
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class RegressionTest1 {

  public static boolean debug = false;

  @Test
  public void test001() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test001"); }


    int i0 = org.jfree.chart.plot.Plot.MINIMUM_WIDTH_TO_DRAW;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 10);

  }

  @Test
  public void test002() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test002"); }


    org.jfree.data.time.Day day1 = org.jfree.data.time.Day.parseDay("RectangleConstraint[LengthConstraintType.FIXED: width=100.0, height=0.0]");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(day1);

  }

  @Test
  public void test003() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test003"); }


    org.jfree.data.xy.XYSeries xYSeries3 = new org.jfree.data.xy.XYSeries((java.lang.Comparable)10.0d, false, false);
    xYSeries3.add((-1.0d), (java.lang.Number)(byte)(-1));
    java.beans.PropertyChangeListener propertyChangeListener7 = null;
    xYSeries3.removePropertyChangeListener(propertyChangeListener7);
    org.jfree.data.xy.XYDataItem xYDataItem9 = null;
    // The following exception was thrown during execution in test generation
    try {
      xYSeries3.add(xYDataItem9);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test004() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test004"); }


    org.jfree.data.time.DateRange dateRange0 = new org.jfree.data.time.DateRange();

  }

  @Test
  public void test005() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test005"); }


    java.lang.String str1 = org.jfree.data.time.SerialDate.weekInMonthToString(0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "Last"+ "'", str1.equals("Last"));

  }

  @Test
  public void test006() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test006"); }


    java.io.ObjectInputStream objectInputStream0 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.text.AttributedString attributedString1 = org.jfree.chart.util.SerialUtilities.readAttributedString(objectInputStream0);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test007() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test007"); }


    java.awt.geom.Line2D line2D0 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.awt.Shape shape2 = org.jfree.chart.util.ShapeUtilities.createLineRegion(line2D0, 1.0f);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test008() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test008"); }


    org.jfree.chart.axis.AxisSpace axisSpace0 = new org.jfree.chart.axis.AxisSpace();
    java.lang.Object obj1 = axisSpace0.clone();
    java.lang.Object obj2 = axisSpace0.clone();
    java.lang.Object obj3 = org.jfree.chart.util.ObjectUtilities.clone(obj2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj3);

  }

  @Test
  public void test009() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test009"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    boolean b5 = xYAreaRenderer1.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition9 = xYAreaRenderer1.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b11 = xYAreaRenderer1.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator12 = null;
    xYAreaRenderer1.setBaseToolTipGenerator(xYToolTipGenerator12, true);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator15 = xYAreaRenderer1.getLegendItemURLGenerator();
    org.jfree.chart.labels.XYItemLabelGenerator xYItemLabelGenerator16 = xYAreaRenderer1.getBaseItemLabelGenerator();
    org.jfree.chart.plot.DrawingSupplier drawingSupplier17 = xYAreaRenderer1.getDrawingSupplier();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYItemLabelGenerator16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier17);

  }

  @Test
  public void test010() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test010"); }


    org.jfree.chart.StandardChartTheme standardChartTheme1 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Paint paint2 = standardChartTheme1.getItemLabelPaint();
    java.awt.Shape shape10 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color12 = java.awt.Color.green;
    java.awt.Color color14 = java.awt.Color.green;
    java.awt.Color color20 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke21 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color22 = java.awt.Color.orange;
    java.awt.Stroke stroke23 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker25 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color20, stroke21, (java.awt.Paint)color22, stroke23, 0.0f);
    java.awt.Shape shape29 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke30 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color31 = java.awt.Color.green;
    java.lang.String str32 = org.jfree.chart.util.PaintUtilities.colorToString(color31);
    org.jfree.chart.LegendItem legendItem33 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape10, true, (java.awt.Paint)color12, false, (java.awt.Paint)color14, stroke21, true, shape29, stroke30, (java.awt.Paint)color31);
    standardChartTheme1.setLabelLinkPaint((java.awt.Paint)color31);
    java.awt.color.ColorSpace colorSpace35 = null;
    float[] f_array38 = new float[] { (-1.0f), 1.0f };
    // The following exception was thrown during execution in test generation
    try {
      float[] f_array39 = color31.getComponents(colorSpace35, f_array38);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str32 + "' != '" + "green"+ "'", str32.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array38);

  }

  @Test
  public void test011() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test011"); }


    java.lang.Class clazz1 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.net.URL uRL2 = org.jfree.chart.util.ObjectUtilities.getResourceRelative("", clazz1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test012() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test012"); }


    // The following exception was thrown during execution in test generation
    try {
      java.lang.String str1 = org.jfree.data.time.SerialDate.monthCodeToString((-1));
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test013() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test013"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis0 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset1 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot2 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset1);
    org.jfree.chart.axis.ValueAxis valueAxis3 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot4 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis3);
    java.util.List list5 = combinedDomainXYPlot4.getAnnotations();
    waferMapPlot2.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot4);
    int i7 = combinedDomainXYPlot4.getSeriesCount();
    categoryAxis0.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot4);
    java.awt.Color color15 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke16 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color17 = java.awt.Color.orange;
    java.awt.Stroke stroke18 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker20 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color15, stroke16, (java.awt.Paint)color17, stroke18, 0.0f);
    java.awt.Paint paint21 = intervalMarker20.getOutlinePaint();
    org.jfree.chart.util.Layer layer22 = null;
    combinedDomainXYPlot4.addRangeMarker(0, (org.jfree.chart.plot.Marker)intervalMarker20, layer22);
    org.jfree.chart.axis.AxisLocation axisLocation24 = combinedDomainXYPlot4.getDomainAxisLocation();
    java.awt.Stroke stroke25 = org.jfree.chart.plot.WaferMapPlot.DEFAULT_CROSSHAIR_STROKE;
    combinedDomainXYPlot4.setRangeGridlineStroke(stroke25);
    combinedDomainXYPlot4.clearDomainMarkers();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke25);

  }

  @Test
  public void test014() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test014"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    java.awt.Shape shape3 = xYAreaRenderer1.getBaseShape();
    java.awt.Stroke stroke4 = org.jfree.chart.plot.WaferMapPlot.DEFAULT_CROSSHAIR_STROKE;
    xYAreaRenderer1.setBaseStroke(stroke4, true);
    java.awt.Color color8 = org.jfree.chart.ChartColor.LIGHT_RED;
    xYAreaRenderer1.setSeriesItemLabelPaint(10, (java.awt.Paint)color8, false);
    java.io.ObjectOutputStream objectOutputStream11 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.util.SerialUtilities.writePaint((java.awt.Paint)color8, objectOutputStream11);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color8);

  }

  @Test
  public void test015() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test015"); }


    org.jfree.chart.ui.Library library4 = new org.jfree.chart.ui.Library("?series=64&amp;item=12", "", "", "item");

  }

  @Test
  public void test016() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test016"); }


    org.jfree.chart.plot.PlotOrientation plotOrientation0 = org.jfree.chart.plot.PlotOrientation.HORIZONTAL;
    boolean b2 = org.jfree.chart.util.ObjectUtilities.equal((java.lang.Object)plotOrientation0, (java.lang.Object)'#');
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer3 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.XYItemLabelGenerator xYItemLabelGenerator5 = null;
    xYStepRenderer3.setSeriesItemLabelGenerator(10, xYItemLabelGenerator5);
    boolean b7 = plotOrientation0.equals((java.lang.Object)10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);

  }

  @Test
  public void test017() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test017"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    org.jfree.data.general.WaferMapDataset waferMapDataset11 = null;
    waferMapPlot1.setDataset(waferMapDataset11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);

  }

  @Test
  public void test018() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test018"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
    numberAxis15.centerRange(100.0d);
    combinedDomainXYPlot9.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis15);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier19 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot9.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.clearRangeMarkers(100);
    boolean b24 = categoryPlot0.isRangePannable();
    float f25 = categoryPlot0.getBackgroundAlpha();
    org.jfree.chart.plot.DatasetRenderingOrder datasetRenderingOrder26 = org.jfree.chart.plot.DatasetRenderingOrder.REVERSE;
    categoryPlot0.setDatasetRenderingOrder(datasetRenderingOrder26);
    double d28 = categoryPlot0.getRangeCrosshairValue();
    org.jfree.chart.axis.NumberAxis numberAxis30 = new org.jfree.chart.axis.NumberAxis();
    numberAxis30.resizeRange2(10.0d, 11.0d);
    org.jfree.chart.util.RectangleInsets rectangleInsets34 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d35 = rectangleInsets34.getLeft();
    numberAxis30.setTickLabelInsets(rectangleInsets34);
    double d37 = numberAxis30.getUpperMargin();
    numberAxis30.setInverted(false);
    numberAxis30.setAutoTickUnitSelection(true, false);
    // The following exception was thrown during execution in test generation
    try {
      categoryPlot0.setRangeAxis((-1), (org.jfree.chart.axis.ValueAxis)numberAxis30);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f25 == 1.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(datasetRenderingOrder26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d28 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d35 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d37 == 0.05d);

  }

  @Test
  public void test019() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test019"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    java.awt.Color color11 = java.awt.Color.RED;
    legendTitle10.setBackgroundPaint((java.awt.Paint)color11);
    org.jfree.chart.block.BlockContainer blockContainer13 = legendTitle10.getItemContainer();
    java.awt.Graphics2D graphics2D14 = null;
    java.awt.geom.Rectangle2D rectangle2D15 = null;
    java.awt.Image image19 = null;
    org.jfree.chart.ui.ProjectInfo projectInfo23 = new org.jfree.chart.ui.ProjectInfo("hi!", "", "green", image19, "hi!", "^2.0", "hi!");
    java.util.List list24 = projectInfo23.getContributors();
    java.awt.Image image28 = null;
    org.jfree.chart.ui.ProjectInfo projectInfo32 = new org.jfree.chart.ui.ProjectInfo("hi!", "", "green", image28, "hi!", "^2.0", "hi!");
    java.util.List list33 = projectInfo32.getContributors();
    org.jfree.chart.plot.ValueMarker valueMarker35 = new org.jfree.chart.plot.ValueMarker(1.0d);
    boolean b36 = projectInfo32.equals((java.lang.Object)1.0d);
    org.jfree.chart.ui.Library[] library_array37 = projectInfo32.getLibraries();
    projectInfo23.addLibrary((org.jfree.chart.ui.Library)projectInfo32);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Object obj39 = legendTitle10.draw(graphics2D14, rectangle2D15, (java.lang.Object)projectInfo32);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockContainer13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(list24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(list33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(library_array37);

  }

  @Test
  public void test020() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test020"); }


    org.jfree.chart.axis.NumberAxis numberAxis0 = new org.jfree.chart.axis.NumberAxis();
    java.awt.Shape shape1 = numberAxis0.getDownArrow();
    // The following exception was thrown during execution in test generation
    try {
      numberAxis0.setAutoRangeMinimumSize((-1.0d), true);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape1);

  }

  @Test
  public void test021() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test021"); }


    org.jfree.chart.labels.ItemLabelAnchor itemLabelAnchor0 = org.jfree.chart.labels.ItemLabelAnchor.INSIDE6;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelAnchor0);

  }

  @Test
  public void test022() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test022"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis5 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets6 = categoryAxis5.getLabelInsets();
    double d8 = rectangleInsets6.calculateLeftInset(4.0d);
    categoryPlot0.setInsets(rectangleInsets6, false);
    int i11 = categoryPlot0.getRendererCount();
    categoryPlot0.setBackgroundAlpha(0.0f);
    boolean b14 = categoryPlot0.isDomainCrosshairVisible();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i11 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);

  }

  @Test
  public void test023() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test023"); }


    java.awt.Color color0 = java.awt.Color.PINK;
    java.lang.String str1 = color0.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "java.awt.Color[r=255,g=175,b=175]"+ "'", str1.equals("java.awt.Color[r=255,g=175,b=175]"));

  }

  @Test
  public void test024() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test024"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    boolean b3 = xYBarRenderer1.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator5 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer1.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator5, true);
    java.lang.Object obj8 = standardXYToolTipGenerator5.clone();
    java.text.NumberFormat numberFormat9 = standardXYToolTipGenerator5.getXFormat();
    numberFormat9.setGroupingUsed(true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat9);

  }

  @Test
  public void test025() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test025"); }


    org.jfree.chart.util.ObjectUtilities.setClassLoaderSource("Combined_Domain_XYPlot");

  }

  @Test
  public void test026() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test026"); }


    org.jfree.chart.block.LabelBlock labelBlock1 = new org.jfree.chart.block.LabelBlock("TextAnchor.CENTER");
    org.jfree.chart.axis.NumberAxis numberAxis2 = new org.jfree.chart.axis.NumberAxis();
    numberAxis2.centerRange(100.0d);
    java.lang.Object obj5 = numberAxis2.clone();
    numberAxis2.setInverted(true);
    org.jfree.chart.util.RectangleInsets rectangleInsets8 = numberAxis2.getTickLabelInsets();
    labelBlock1.setMargin(rectangleInsets8);
    java.awt.Paint paint10 = null;
    // The following exception was thrown during execution in test generation
    try {
      labelBlock1.setPaint(paint10);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets8);

  }

  @Test
  public void test027() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test027"); }


    org.jfree.chart.renderer.xy.GradientXYBarPainter gradientXYBarPainter0 = new org.jfree.chart.renderer.xy.GradientXYBarPainter();
    org.jfree.chart.renderer.xy.XYBarRenderer.setDefaultBarPainter((org.jfree.chart.renderer.xy.XYBarPainter)gradientXYBarPainter0);
    java.awt.Graphics2D graphics2D2 = null;
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer4 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d5 = xYBarRenderer4.getMargin();
    double d6 = xYBarRenderer4.getShadowXOffset();
    org.jfree.chart.urls.XYURLGenerator xYURLGenerator7 = null;
    xYBarRenderer4.setBaseURLGenerator(xYURLGenerator7, true);
    org.jfree.chart.axis.NumberAxis numberAxis10 = new org.jfree.chart.axis.NumberAxis();
    numberAxis10.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer14 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator15 = xYAreaRenderer14.getLegendItemToolTipGenerator();
    java.awt.Shape shape16 = xYAreaRenderer14.getBaseShape();
    numberAxis10.setUpArrow(shape16);
    numberAxis10.pan((-1.0d));
    java.awt.Paint paint20 = numberAxis10.getAxisLinePaint();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer22 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator23 = xYAreaRenderer22.getLegendItemToolTipGenerator();
    java.awt.Shape shape24 = xYAreaRenderer22.getBaseShape();
    java.awt.Shape shape27 = org.jfree.chart.util.ShapeUtilities.createTranslatedShape(shape24, 6.0d, 0.0d);
    numberAxis10.setRightArrow(shape27);
    xYBarRenderer4.setBaseLegendShape(shape27);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition30 = xYBarRenderer4.getPositiveItemLabelPositionFallback();
    java.awt.geom.RectangularShape rectangularShape34 = null;
    org.jfree.chart.plot.CategoryPlot categoryPlot35 = new org.jfree.chart.plot.CategoryPlot();
    boolean b36 = categoryPlot35.isRangeZoomable();
    org.jfree.chart.axis.CategoryAxis categoryAxis37 = categoryPlot35.getDomainAxis();
    org.jfree.chart.axis.CategoryAxis categoryAxis38 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset39 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot40 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset39);
    org.jfree.chart.axis.ValueAxis valueAxis41 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot42 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis41);
    java.util.List list43 = combinedDomainXYPlot42.getAnnotations();
    waferMapPlot40.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot42);
    int i45 = combinedDomainXYPlot42.getSeriesCount();
    categoryAxis38.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot42);
    boolean b48 = categoryAxis38.equals((java.lang.Object)(short)1);
    java.awt.Color color54 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke55 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color56 = java.awt.Color.orange;
    java.awt.Stroke stroke57 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker59 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color54, stroke55, (java.awt.Paint)color56, stroke57, 0.0f);
    java.awt.Color color60 = color56.brighter();
    categoryAxis38.setTickLabelPaint((java.awt.Paint)color56);
    org.jfree.chart.axis.CategoryAxis[] categoryAxis_array62 = new org.jfree.chart.axis.CategoryAxis[] { categoryAxis38 };
    categoryPlot35.setDomainAxes(categoryAxis_array62);
    org.jfree.chart.util.RectangleEdge rectangleEdge65 = categoryPlot35.getRangeAxisEdge(40);
    // The following exception was thrown during execution in test generation
    try {
      gradientXYBarPainter0.paintBar(graphics2D2, xYBarRenderer4, 2, 8, false, rectangularShape34, rectangleEdge65);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(itemLabelPosition30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryAxis37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i45 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b48 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(categoryAxis_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge65);

  }

  @Test
  public void test028() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test028"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.axis.ValueAxis valueAxis2 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot3 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis2);
    java.util.List list4 = combinedDomainXYPlot3.getAnnotations();
    waferMapPlot1.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot3);
    combinedDomainXYPlot3.setDomainCrosshairLockedOnData(true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list4);

  }

  @Test
  public void test029() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test029"); }


    org.jfree.chart.LegendItemCollection legendItemCollection0 = new org.jfree.chart.LegendItemCollection();

  }

  @Test
  public void test030() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test030"); }


    org.jfree.chart.plot.PieLabelLinkStyle pieLabelLinkStyle0 = org.jfree.chart.plot.PieLabelLinkStyle.STANDARD;
    org.jfree.chart.axis.NumberAxis3D numberAxis3D1 = new org.jfree.chart.axis.NumberAxis3D();
    org.jfree.data.Range range3 = null;
    org.jfree.chart.block.RectangleConstraint rectangleConstraint4 = new org.jfree.chart.block.RectangleConstraint(100.0d, range3);
    org.jfree.chart.block.LengthConstraintType lengthConstraintType5 = rectangleConstraint4.getWidthConstraintType();
    org.jfree.data.time.DateRange dateRange8 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange11 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b12 = dateRange8.intersects((org.jfree.data.Range)dateRange11);
    org.jfree.chart.block.RectangleConstraint rectangleConstraint13 = rectangleConstraint4.toRangeHeight((org.jfree.data.Range)dateRange11);
    numberAxis3D1.setDefaultAutoRange((org.jfree.data.Range)dateRange11);
    boolean b15 = pieLabelLinkStyle0.equals((java.lang.Object)numberAxis3D1);
    org.jfree.chart.axis.TickUnitSource tickUnitSource16 = org.jfree.chart.axis.DateAxis.createStandardDateTickUnits();
    numberAxis3D1.setStandardTickUnits(tickUnitSource16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(pieLabelLinkStyle0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleConstraint13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(tickUnitSource16);

  }

  @Test
  public void test031() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test031"); }


    org.jfree.data.xy.XYSeries xYSeries3 = new org.jfree.data.xy.XYSeries((java.lang.Comparable)10.0d, false, false);
    xYSeries3.add((-1.0d), (java.lang.Number)(byte)(-1));
    double d7 = xYSeries3.getMaxX();
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number9 = xYSeries3.getY(7);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == (-1.0d));

  }

  @Test
  public void test032() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test032"); }


    org.jfree.chart.renderer.RendererUtilities rendererUtilities0 = new org.jfree.chart.renderer.RendererUtilities();

  }

  @Test
  public void test033() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test033"); }


    org.jfree.chart.axis.NumberAxis3D numberAxis3D0 = new org.jfree.chart.axis.NumberAxis3D();
    numberAxis3D0.setRange(Double.NaN, 1.0d);
    numberAxis3D0.setFixedAutoRange(2.0d);
    org.jfree.data.general.SeriesChangeInfo seriesChangeInfo6 = null;
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent7 = new org.jfree.data.general.SeriesChangeEvent((java.lang.Object)numberAxis3D0, seriesChangeInfo6);
    org.jfree.data.general.SeriesChangeInfo seriesChangeInfo8 = seriesChangeEvent7.getSummary();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(seriesChangeInfo8);

  }

  @Test
  public void test034() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test034"); }


    org.jfree.chart.block.RectangleConstraint rectangleConstraint2 = new org.jfree.chart.block.RectangleConstraint((-1.0d), 3.0d);
    org.jfree.data.Range range3 = rectangleConstraint2.getWidthRange();
    org.jfree.data.Range range4 = rectangleConstraint2.getHeightRange();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range4);

  }

  @Test
  public void test035() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test035"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis5 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets6 = categoryAxis5.getLabelInsets();
    double d8 = rectangleInsets6.calculateLeftInset(4.0d);
    categoryPlot0.setInsets(rectangleInsets6, false);
    org.jfree.chart.util.Layer layer12 = null;
    java.util.Collection collection13 = categoryPlot0.getDomainMarkers(5, layer12);
    org.jfree.data.general.DatasetGroup datasetGroup14 = categoryPlot0.getDatasetGroup();
    org.jfree.data.time.TimeSeries timeSeries16 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection17 = new org.jfree.data.time.TimeSeriesCollection(timeSeries16);
    timeSeriesCollection17.validateObject();
    java.util.List list19 = timeSeriesCollection17.getSeries();
    // The following exception was thrown during execution in test generation
    try {
      categoryPlot0.mapDatasetToRangeAxes(15, list19);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(datasetGroup14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list19);

  }

  @Test
  public void test036() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test036"); }


    boolean b1 = org.jfree.data.time.SerialDate.isValidWeekInMonthCode(133);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);

  }

  @Test
  public void test037() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test037"); }


    java.awt.Font font1 = null;
    java.awt.Color color2 = java.awt.Color.gray;
    org.jfree.chart.text.TextMeasurer textMeasurer4 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.text.TextBlock textBlock5 = org.jfree.chart.text.TextUtilities.createTextBlock("item", font1, (java.awt.Paint)color2, 1.0f, textMeasurer4);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color2);

  }

  @Test
  public void test038() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test038"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis1 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets2 = categoryAxis1.getLabelInsets();
    double d4 = rectangleInsets2.calculateLeftInset(4.0d);
    java.awt.geom.Rectangle2D rectangle2D5 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.awt.geom.Rectangle2D rectangle2D6 = rectangleInsets2.createInsetRectangle(rectangle2D5);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 3.0d);

  }

  @Test
  public void test039() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test039"); }


    org.jfree.data.function.Function2D function2D0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.xy.XYDataset xYDataset5 = org.jfree.data.general.DatasetUtilities.sampleFunction2D(function2D0, 0.0d, Double.NaN, 255, (java.lang.Comparable)0);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test040() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test040"); }


    java.lang.Class clazz1 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.net.URL uRL2 = org.jfree.chart.util.ObjectUtilities.getResource("1", clazz1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test041() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test041"); }


    org.jfree.chart.StandardChartTheme standardChartTheme1 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Shape shape9 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color13 = java.awt.Color.green;
    java.awt.Color color19 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke20 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color21 = java.awt.Color.orange;
    java.awt.Stroke stroke22 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker24 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color19, stroke20, (java.awt.Paint)color21, stroke22, 0.0f);
    java.awt.Shape shape28 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke29 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color30 = java.awt.Color.green;
    java.lang.String str31 = org.jfree.chart.util.PaintUtilities.colorToString(color30);
    org.jfree.chart.LegendItem legendItem32 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape9, true, (java.awt.Paint)color11, false, (java.awt.Paint)color13, stroke20, true, shape28, stroke29, (java.awt.Paint)color30);
    standardChartTheme1.setCrosshairPaint((java.awt.Paint)color11);
    java.awt.Paint paint34 = standardChartTheme1.getPlotBackgroundPaint();
    java.awt.Paint paint35 = standardChartTheme1.getLegendBackgroundPaint();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str31 + "' != '" + "green"+ "'", str31.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint35);

  }

  @Test
  public void test042() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test042"); }


    org.jfree.chart.axis.SegmentedTimeline segmentedTimeline3 = new org.jfree.chart.axis.SegmentedTimeline(1L, 133, 7);
    boolean b4 = segmentedTimeline3.getAdjustForDaylightSaving();
    // The following exception was thrown during execution in test generation
    try {
      boolean b7 = segmentedTimeline3.containsDomainRange(1456819199999L, 900000L);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);

  }

  @Test
  public void test043() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test043"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer13 = null;
    combinedDomainXYPlot5.setRenderer(xYItemRenderer13);
    boolean b15 = combinedDomainXYPlot5.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries16 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection17 = new org.jfree.data.time.TimeSeriesCollection(timeSeries16);
    combinedDomainXYPlot5.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    java.util.List list19 = timeSeriesCollection17.getSeries();
    org.jfree.data.Range range20 = org.jfree.data.general.DatasetUtilities.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    org.jfree.data.DomainOrder domainOrder21 = timeSeriesCollection17.getDomainOrder();
    org.jfree.data.Range range22 = org.jfree.data.general.DatasetUtilities.findDomainBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    // The following exception was thrown during execution in test generation
    try {
      timeSeriesCollection17.removeSeries(0);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range22);

  }

  @Test
  public void test044() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test044"); }


    org.jfree.data.xy.XYSeries xYSeries0 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection1 = new org.jfree.data.xy.XYSeriesCollection(xYSeries0);
    double d3 = xYSeriesCollection1.getDomainUpperBound(false);
    java.util.List list4 = xYSeriesCollection1.getSeries();
    xYSeriesCollection1.validateObject();
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number8 = xYSeriesCollection1.getEndX((-435), 2016);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d3, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list4);

  }

  @Test
  public void test045() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test045"); }


    java.awt.Color color0 = org.jfree.chart.ChartColor.DARK_GREEN;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color0);

  }

  @Test
  public void test046() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test046"); }


    org.jfree.chart.renderer.xy.XYBarPainter xYBarPainter0 = org.jfree.chart.renderer.xy.XYBarRenderer.getDefaultBarPainter();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(xYBarPainter0);

  }

  @Test
  public void test047() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test047"); }


    org.jfree.chart.axis.LogAxis logAxis1 = new org.jfree.chart.axis.LogAxis("ClassContext");
    logAxis1.zoomRange(0.0d, 4.5d);
    java.awt.Graphics2D graphics2D5 = null;
    org.jfree.chart.axis.AxisState axisState6 = new org.jfree.chart.axis.AxisState();
    java.awt.geom.Rectangle2D rectangle2D7 = null;
    org.jfree.data.general.WaferMapDataset waferMapDataset8 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot9 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset8);
    org.jfree.chart.JFreeChart jFreeChart10 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent11 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot9, jFreeChart10);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment12 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment13 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement16 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment12, verticalAlignment13, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement17 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle18 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot9, (org.jfree.chart.block.Arrangement)flowArrangement16, (org.jfree.chart.block.Arrangement)borderArrangement17);
    org.jfree.chart.plot.CategoryPlot categoryPlot19 = new org.jfree.chart.plot.CategoryPlot();
    boolean b20 = categoryPlot19.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge22 = categoryPlot19.getDomainAxisEdge(8);
    legendTitle18.setPosition(rectangleEdge22);
    org.jfree.chart.block.BlockFrame blockFrame24 = legendTitle18.getFrame();
    org.jfree.chart.util.RectangleEdge rectangleEdge25 = org.jfree.chart.util.RectangleEdge.LEFT;
    legendTitle18.setLegendItemGraphicEdge(rectangleEdge25);
    // The following exception was thrown during execution in test generation
    try {
      java.util.List list27 = logAxis1.refreshTicks(graphics2D5, axisState6, rectangle2D7, rectangleEdge25);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge25);

  }

  @Test
  public void test048() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test048"); }


    org.jfree.chart.renderer.category.BarRenderer barRenderer0 = new org.jfree.chart.renderer.category.BarRenderer();
    double d1 = barRenderer0.getShadowXOffset();
    java.awt.Graphics2D graphics2D2 = null;
    java.awt.geom.Rectangle2D rectangle2D3 = null;
    org.jfree.chart.plot.CategoryPlot categoryPlot4 = new org.jfree.chart.plot.CategoryPlot();
    boolean b5 = categoryPlot4.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge7 = categoryPlot4.getDomainAxisEdge(8);
    java.awt.Font font9 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset10 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot11 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset10);
    org.jfree.chart.axis.ValueAxis valueAxis12 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot13 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis12);
    java.util.List list14 = combinedDomainXYPlot13.getAnnotations();
    waferMapPlot11.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot13);
    org.jfree.chart.JFreeChart jFreeChart17 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font9, (org.jfree.chart.plot.Plot)combinedDomainXYPlot13, true);
    org.jfree.chart.axis.NumberAxis numberAxis19 = new org.jfree.chart.axis.NumberAxis();
    numberAxis19.centerRange(100.0d);
    combinedDomainXYPlot13.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis19);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier23 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot13.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier23);
    categoryPlot4.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier23);
    categoryPlot4.clearRangeMarkers(100);
    boolean b28 = categoryPlot4.isRangePannable();
    float f29 = categoryPlot4.getBackgroundAlpha();
    org.jfree.chart.entity.EntityCollection entityCollection31 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo32 = new org.jfree.chart.ChartRenderingInfo(entityCollection31);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo33 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo32);
    int i34 = plotRenderingInfo33.getSubplotCount();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.renderer.category.CategoryItemRendererState categoryItemRendererState35 = barRenderer0.initialise(graphics2D2, rectangle2D3, categoryPlot4, 10, plotRenderingInfo33);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f29 == 1.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i34 == 0);

  }

  @Test
  public void test049() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test049"); }


    org.jfree.chart.axis.ValueAxis valueAxis1 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot2 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis1);
    java.util.List list3 = combinedDomainXYPlot2.getAnnotations();
    combinedDomainXYPlot2.setRangeGridlinesVisible(true);
    org.jfree.chart.axis.AxisSpace axisSpace6 = null;
    combinedDomainXYPlot2.setFixedRangeAxisSpace(axisSpace6);
    org.jfree.data.xy.XYDataset xYDataset9 = combinedDomainXYPlot2.getDataset(40);
    org.jfree.chart.StandardChartTheme standardChartTheme11 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Paint paint12 = standardChartTheme11.getAxisLabelPaint();
    java.awt.Font font13 = standardChartTheme11.getLargeFont();
    combinedDomainXYPlot2.setNoDataMessageFont(font13);
    org.jfree.data.general.WaferMapDataset waferMapDataset15 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot16 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset15);
    org.jfree.chart.axis.ValueAxis valueAxis17 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot18 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis17);
    java.util.List list19 = combinedDomainXYPlot18.getAnnotations();
    waferMapPlot16.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot18);
    boolean b21 = combinedDomainXYPlot18.isNotify();
    org.jfree.chart.util.Layer layer22 = null;
    java.util.Collection collection23 = combinedDomainXYPlot18.getDomainMarkers(layer22);
    org.jfree.chart.LegendItemCollection legendItemCollection24 = combinedDomainXYPlot18.getLegendItems();
    org.jfree.chart.JFreeChart jFreeChart26 = new org.jfree.chart.JFreeChart("ClassContext", font13, (org.jfree.chart.plot.Plot)combinedDomainXYPlot18, false);
    java.awt.Graphics2D graphics2D27 = null;
    java.awt.geom.Rectangle2D rectangle2D28 = null;
    // The following exception was thrown during execution in test generation
    try {
      jFreeChart26.draw(graphics2D27, rectangle2D28);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYDataset9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b21 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection24);

  }

  @Test
  public void test050() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test050"); }


    org.jfree.chart.axis.NumberAxis numberAxis0 = new org.jfree.chart.axis.NumberAxis();
    numberAxis0.resizeRange2(10.0d, 11.0d);
    org.jfree.chart.util.RectangleInsets rectangleInsets4 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d5 = rectangleInsets4.getLeft();
    numberAxis0.setTickLabelInsets(rectangleInsets4);
    org.jfree.data.Range range7 = numberAxis0.getRange();
    java.awt.Shape shape8 = numberAxis0.getRightArrow();
    numberAxis0.setTickLabelsVisible(true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape8);

  }

  @Test
  public void test051() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test051"); }


    org.jfree.chart.util.ShapeList shapeList0 = new org.jfree.chart.util.ShapeList();
    java.lang.Object obj1 = shapeList0.clone();
    java.awt.Shape shape3 = shapeList0.getShape(12);
    boolean b5 = shapeList0.equals((java.lang.Object)"TextBlockAnchor.BOTTOM_RIGHT");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(shape3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);

  }

  @Test
  public void test052() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test052"); }


    java.awt.Color color5 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke6 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color7 = java.awt.Color.orange;
    java.awt.Stroke stroke8 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker10 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color5, stroke6, (java.awt.Paint)color7, stroke8, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer11 = null;
    intervalMarker10.setGradientPaintTransformer(gradientPaintTransformer11);
    org.jfree.chart.util.RectangleInsets rectangleInsets13 = intervalMarker10.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis15 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets16 = categoryAxis15.getLabelInsets();
    intervalMarker10.setLabelOffset(rectangleInsets16);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer18 = intervalMarker10.getGradientPaintTransformer();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(gradientPaintTransformer18);

  }

  @Test
  public void test053() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test053"); }


    java.lang.String str1 = org.jfree.data.time.SerialDate.relativeToString(8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "ERROR : Relative To String"+ "'", str1.equals("ERROR : Relative To String"));

  }

  @Test
  public void test054() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test054"); }


    org.jfree.data.time.TimeSeries timeSeries0 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection1 = new org.jfree.data.time.TimeSeriesCollection(timeSeries0);
    timeSeriesCollection1.validateObject();
    // The following exception was thrown during execution in test generation
    try {
      int[] i_array5 = timeSeriesCollection1.getSurroundingItems(1, 900000L);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test055() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test055"); }


    org.jfree.chart.util.RectangleAnchor rectangleAnchor0 = org.jfree.chart.util.RectangleAnchor.CENTER;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleAnchor0);

  }

  @Test
  public void test056() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test056"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
    numberAxis15.centerRange(100.0d);
    combinedDomainXYPlot9.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis15);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier19 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot9.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    org.jfree.data.category.CategoryDataset categoryDataset22 = null;
    org.jfree.chart.renderer.category.CategoryItemRenderer categoryItemRenderer23 = categoryPlot0.getRendererForDataset(categoryDataset22);
    java.awt.Color color30 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke31 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color32 = java.awt.Color.orange;
    java.awt.Stroke stroke33 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker35 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color30, stroke31, (java.awt.Paint)color32, stroke33, 0.0f);
    java.awt.Paint paint36 = intervalMarker35.getPaint();
    org.jfree.chart.util.Layer layer37 = null;
    boolean b38 = categoryPlot0.removeDomainMarker(8, (org.jfree.chart.plot.Marker)intervalMarker35, layer37);
    org.jfree.chart.axis.CategoryAnchor categoryAnchor39 = null;
    // The following exception was thrown during execution in test generation
    try {
      categoryPlot0.setDomainGridlinePosition(categoryAnchor39);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryItemRenderer23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == false);

  }

  @Test
  public void test057() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test057"); }


    org.jfree.data.time.SpreadsheetDate spreadsheetDate1 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate3 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b4 = spreadsheetDate1.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate3);
    org.jfree.data.time.SerialDate serialDate6 = spreadsheetDate1.getFollowingDayOfWeek(3);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.SerialDate serialDate8 = spreadsheetDate1.getPreviousDayOfWeek(14);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(serialDate6);

  }

  @Test
  public void test058() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test058"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    java.util.List list2 = combinedDomainXYPlot1.getAnnotations();
    combinedDomainXYPlot1.setRangeGridlinesVisible(true);
    java.awt.Graphics2D graphics2D5 = null;
    java.awt.geom.Rectangle2D rectangle2D6 = null;
    java.awt.geom.Rectangle2D rectangle2D7 = null;
    org.jfree.chart.util.RectangleAnchor rectangleAnchor8 = null;
    java.awt.geom.Point2D point2D9 = org.jfree.chart.util.RectangleAnchor.coordinates(rectangle2D7, rectangleAnchor8);
    org.jfree.chart.plot.PlotState plotState10 = new org.jfree.chart.plot.PlotState();
    java.util.Map map11 = plotState10.getSharedAxisStates();
    org.jfree.chart.entity.EntityCollection entityCollection12 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo13 = new org.jfree.chart.ChartRenderingInfo(entityCollection12);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo14 = chartRenderingInfo13.getPlotInfo();
    org.jfree.chart.entity.EntityCollection entityCollection15 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo16 = new org.jfree.chart.ChartRenderingInfo(entityCollection15);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo17 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo16);
    int i18 = plotRenderingInfo17.getSubplotCount();
    plotRenderingInfo14.addSubplotInfo(plotRenderingInfo17);
    // The following exception was thrown during execution in test generation
    try {
      combinedDomainXYPlot1.draw(graphics2D5, rectangle2D6, point2D9, plotState10, plotRenderingInfo14);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point2D9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(map11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i18 == 0);

  }

  @Test
  public void test059() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test059"); }


    org.jfree.chart.axis.NumberAxis3D numberAxis3D0 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Paint paint1 = org.jfree.chart.axis.Axis.DEFAULT_AXIS_LINE_PAINT;
    numberAxis3D0.setLabelPaint(paint1);
    java.text.NumberFormat numberFormat3 = numberAxis3D0.getNumberFormatOverride();
    org.jfree.data.general.WaferMapDataset waferMapDataset4 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot5 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset4);
    numberAxis3D0.removeChangeListener((org.jfree.chart.event.AxisChangeListener)waferMapPlot5);
    numberAxis3D0.setLowerBound(1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(numberFormat3);

  }

  @Test
  public void test060() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test060"); }


    org.jfree.chart.text.TextLine textLine1 = new org.jfree.chart.text.TextLine("March");
    java.awt.Font font4 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset5 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot6 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset5);
    org.jfree.chart.axis.ValueAxis valueAxis7 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot8 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis7);
    java.util.List list9 = combinedDomainXYPlot8.getAnnotations();
    waferMapPlot6.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot8);
    org.jfree.chart.JFreeChart jFreeChart12 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font4, (org.jfree.chart.plot.Plot)combinedDomainXYPlot8, true);
    java.awt.Color color16 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment17 = new org.jfree.chart.text.TextFragment("hi!", font4, (java.awt.Paint)color16);
    textLine1.addFragment(textFragment17);
    java.awt.Font font19 = textFragment17.getFont();
    java.awt.Graphics2D graphics2D20 = null;
    org.jfree.chart.labels.ItemLabelAnchor itemLabelAnchor21 = org.jfree.chart.labels.ItemLabelAnchor.INSIDE12;
    org.jfree.chart.text.TextAnchor textAnchor22 = org.jfree.chart.text.TextAnchor.CENTER;
    org.jfree.chart.text.TextAnchor textAnchor23 = org.jfree.chart.text.TextAnchor.TOP_CENTER;
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition25 = new org.jfree.chart.labels.ItemLabelPosition(itemLabelAnchor21, textAnchor22, textAnchor23, 0.0d);
    // The following exception was thrown during execution in test generation
    try {
      float f26 = textFragment17.calculateBaselineOffset(graphics2D20, textAnchor23);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelAnchor21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textAnchor22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textAnchor23);

  }

  @Test
  public void test061() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test061"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    java.awt.Font font13 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset14 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot15 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset14);
    org.jfree.chart.axis.ValueAxis valueAxis16 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot17 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis16);
    java.util.List list18 = combinedDomainXYPlot17.getAnnotations();
    waferMapPlot15.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot17);
    boolean b20 = combinedDomainXYPlot17.isNotify();
    org.jfree.chart.JFreeChart jFreeChart22 = new org.jfree.chart.JFreeChart("", font13, (org.jfree.chart.plot.Plot)combinedDomainXYPlot17, true);
    org.jfree.chart.title.TextTitle textTitle23 = new org.jfree.chart.title.TextTitle("", font13);
    org.jfree.chart.axis.NumberTickUnit numberTickUnit24 = org.jfree.chart.axis.NumberAxis.DEFAULT_TICK_UNIT;
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer30 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator31 = xYAreaRenderer30.getLegendItemToolTipGenerator();
    java.awt.Shape shape32 = xYAreaRenderer30.getBaseShape();
    java.awt.Color color38 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke39 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color40 = java.awt.Color.orange;
    java.awt.Stroke stroke41 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker43 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color38, stroke39, (java.awt.Paint)color40, stroke41, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer44 = null;
    intervalMarker43.setGradientPaintTransformer(gradientPaintTransformer44);
    org.jfree.chart.util.RectangleInsets rectangleInsets46 = intervalMarker43.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis48 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets49 = categoryAxis48.getLabelInsets();
    intervalMarker43.setLabelOffset(rectangleInsets49);
    double d51 = intervalMarker43.getEndValue();
    java.awt.Paint paint52 = intervalMarker43.getOutlinePaint();
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer53 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    boolean b54 = xYStepRenderer53.getUseFillPaint();
    xYStepRenderer53.setDrawSeriesLineAsPath(false);
    java.awt.Stroke stroke60 = xYStepRenderer53.getItemOutlineStroke(10, 15, false);
    java.awt.Font font64 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset65 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot66 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset65);
    org.jfree.chart.axis.ValueAxis valueAxis67 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot68 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis67);
    java.util.List list69 = combinedDomainXYPlot68.getAnnotations();
    waferMapPlot66.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot68);
    org.jfree.chart.JFreeChart jFreeChart72 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font64, (org.jfree.chart.plot.Plot)combinedDomainXYPlot68, true);
    java.awt.Color color76 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment77 = new org.jfree.chart.text.TextFragment("hi!", font64, (java.awt.Paint)color76);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer79 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier80 = xYAreaRenderer79.getDrawingSupplier();
    java.awt.Stroke stroke81 = xYAreaRenderer79.getBaseStroke();
    org.jfree.chart.plot.ValueMarker valueMarker82 = new org.jfree.chart.plot.ValueMarker(0.0d, (java.awt.Paint)color76, stroke81);
    org.jfree.chart.LegendItem legendItem83 = new org.jfree.chart.LegendItem("1", "RectangleConstraint[LengthConstraintType.FIXED: width=100.0, height=0.0]", "ERROR : Relative To String", "LengthConstraintType.FIXED", shape32, paint52, stroke60, (java.awt.Paint)color76);
    int i84 = numberTickUnit24.compareTo((java.lang.Object)"1");
    java.lang.Object obj85 = null;
    int i86 = numberTickUnit24.compareTo(obj85);
    // The following exception was thrown during execution in test generation
    try {
      borderArrangement9.add((org.jfree.chart.block.Block)textTitle23, (java.lang.Object)numberTickUnit24);
      org.junit.Assert.fail("Expected exception of type java.lang.ClassCastException");
    } catch (java.lang.ClassCastException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ClassCastException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ClassCastException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberTickUnit24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d51 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b54 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color76);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke81);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i84 == (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i86 == (-1));

  }

  @Test
  public void test062() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test062"); }


    org.jfree.chart.axis.NumberAxis3D numberAxis3D0 = new org.jfree.chart.axis.NumberAxis3D();
    numberAxis3D0.setInverted(true);

  }

  @Test
  public void test063() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test063"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    double d3 = xYBarRenderer1.getShadowXOffset();
    org.jfree.chart.urls.XYURLGenerator xYURLGenerator4 = null;
    xYBarRenderer1.setBaseURLGenerator(xYURLGenerator4, true);
    org.jfree.chart.axis.NumberAxis numberAxis7 = new org.jfree.chart.axis.NumberAxis();
    numberAxis7.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer11 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator12 = xYAreaRenderer11.getLegendItemToolTipGenerator();
    java.awt.Shape shape13 = xYAreaRenderer11.getBaseShape();
    numberAxis7.setUpArrow(shape13);
    numberAxis7.pan((-1.0d));
    java.awt.Paint paint17 = numberAxis7.getAxisLinePaint();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer19 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator20 = xYAreaRenderer19.getLegendItemToolTipGenerator();
    java.awt.Shape shape21 = xYAreaRenderer19.getBaseShape();
    java.awt.Shape shape24 = org.jfree.chart.util.ShapeUtilities.createTranslatedShape(shape21, 6.0d, 0.0d);
    numberAxis7.setRightArrow(shape24);
    xYBarRenderer1.setBaseLegendShape(shape24);
    boolean b27 = xYBarRenderer1.isDrawBarOutline();
    xYBarRenderer1.setMargin(10.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d3 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);

  }

  @Test
  public void test064() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test064"); }


    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D1 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke2 = categoryAxis3D1.getTickMarkStroke();
    float f3 = categoryAxis3D1.getTickMarkOutsideLength();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f3 == 2.0f);

  }

  @Test
  public void test065() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test065"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    boolean b3 = xYBarRenderer1.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator5 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer1.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator5, true);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator9 = null;
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator11 = new org.jfree.chart.urls.StandardXYURLGenerator("");
    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer12 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(100, xYToolTipGenerator9, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator11);
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer13 = new org.jfree.chart.renderer.xy.XYStepRenderer((org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator5, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator11);
    boolean b14 = xYStepRenderer13.getBaseLinesVisible();
    boolean b15 = xYStepRenderer13.getDataBoundsIncludesVisibleSeriesOnly();
    boolean b16 = xYStepRenderer13.getDrawOutlines();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == true);

  }

  @Test
  public void test066() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test066"); }


    org.jfree.chart.labels.ItemLabelAnchor itemLabelAnchor0 = org.jfree.chart.labels.ItemLabelAnchor.INSIDE9;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelAnchor0);

  }

  @Test
  public void test067() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test067"); }


    float f0 = org.jfree.chart.plot.Plot.DEFAULT_BACKGROUND_ALPHA;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f0 == 1.0f);

  }

  @Test
  public void test068() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test068"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis0 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset1 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot2 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset1);
    org.jfree.chart.axis.ValueAxis valueAxis3 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot4 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis3);
    java.util.List list5 = combinedDomainXYPlot4.getAnnotations();
    waferMapPlot2.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot4);
    int i7 = combinedDomainXYPlot4.getSeriesCount();
    categoryAxis0.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot4);
    boolean b10 = categoryAxis0.equals((java.lang.Object)(short)1);
    java.lang.Object obj11 = categoryAxis0.clone();
    org.jfree.chart.event.AxisChangeEvent axisChangeEvent12 = new org.jfree.chart.event.AxisChangeEvent((org.jfree.chart.axis.Axis)categoryAxis0);
    java.lang.Object obj13 = axisChangeEvent12.getSource();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj13);

  }

  @Test
  public void test069() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test069"); }


    org.jfree.chart.resources.JFreeChartResources jFreeChartResources0 = new org.jfree.chart.resources.JFreeChartResources();
    java.util.Enumeration enumeration1 = jFreeChartResources0.getKeys();
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Object obj3 = jFreeChartResources0.getObject("");
      org.junit.Assert.fail("Expected exception of type java.util.MissingResourceException");
    } catch (java.util.MissingResourceException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.util.MissingResourceException")) {
        org.junit.Assert.fail("Expected exception of type java.util.MissingResourceException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(enumeration1);

  }

  @Test
  public void test070() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test070"); }


    java.lang.String[] str_array1 = org.jfree.data.time.SerialDate.getMonths(false);
    java.lang.Comparable[] comparable_array3 = new java.lang.Comparable[] { 1900 };
    double[] d_array4 = null;
    double[][] d_array_array5 = new double[][] { d_array4 };
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.category.CategoryDataset categoryDataset6 = org.jfree.data.general.DatasetUtilities.createCategoryDataset((java.lang.Comparable[])str_array1, comparable_array3, d_array_array5);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(comparable_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);

  }

  @Test
  public void test071() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test071"); }


    org.jfree.chart.resources.JFreeChartResources jFreeChartResources0 = new org.jfree.chart.resources.JFreeChartResources();
    java.util.Enumeration enumeration1 = jFreeChartResources0.getKeys();
    // The following exception was thrown during execution in test generation
    try {
      java.lang.String[] str_array3 = jFreeChartResources0.getStringArray("?hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!=-1&amp;=14");
      org.junit.Assert.fail("Expected exception of type java.util.MissingResourceException");
    } catch (java.util.MissingResourceException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.util.MissingResourceException")) {
        org.junit.Assert.fail("Expected exception of type java.util.MissingResourceException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(enumeration1);

  }

  @Test
  public void test072() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test072"); }


    org.jfree.chart.axis.AxisSpace axisSpace0 = new org.jfree.chart.axis.AxisSpace();
    org.jfree.data.DomainOrder domainOrder1 = org.jfree.data.DomainOrder.DESCENDING;
    boolean b2 = axisSpace0.equals((java.lang.Object)domainOrder1);
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D5 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke6 = categoryAxis3D5.getTickMarkStroke();
    java.awt.Graphics2D graphics2D7 = null;
    java.awt.geom.Rectangle2D rectangle2D9 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge10 = org.jfree.chart.util.RectangleEdge.LEFT;
    org.jfree.chart.axis.AxisState axisState12 = new org.jfree.chart.axis.AxisState(1.0d);
    double d13 = axisState12.getCursor();
    axisState12.cursorLeft(0.2d);
    categoryAxis3D5.drawTickMarks(graphics2D7, 7.0d, rectangle2D9, rectangleEdge10, axisState12);
    axisSpace0.ensureAtLeast(6.0d, rectangleEdge10);
    java.awt.geom.Rectangle2D rectangle2D18 = null;
    java.awt.geom.Rectangle2D rectangle2D19 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.awt.geom.Rectangle2D rectangle2D20 = axisSpace0.shrink(rectangle2D18, rectangle2D19);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d13 == 1.0d);

  }

  @Test
  public void test073() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test073"); }


    org.jfree.data.xy.XYSeries xYSeries0 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection1 = new org.jfree.data.xy.XYSeriesCollection(xYSeries0);
    boolean b2 = xYSeriesCollection1.isAutoWidth();
    org.jfree.data.Range range4 = xYSeriesCollection1.getRangeBounds(true);
    xYSeriesCollection1.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis7 = new org.jfree.chart.axis.NumberAxis();
    numberAxis7.centerRange(100.0d);
    java.lang.Object obj10 = numberAxis7.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer11 = null;
    org.jfree.chart.plot.PolarPlot polarPlot12 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection1, (org.jfree.chart.axis.ValueAxis)numberAxis7, polarItemRenderer11);
    org.jfree.chart.plot.PlotOrientation plotOrientation13 = polarPlot12.getOrientation();
    boolean b14 = polarPlot12.isAngleLabelsVisible();
    org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
    numberAxis15.centerRange(100.0d);
    java.awt.Paint paint18 = numberAxis15.getLabelPaint();
    polarPlot12.setAxis((org.jfree.chart.axis.ValueAxis)numberAxis15);
    double d20 = numberAxis15.getFixedAutoRange();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d20 == 0.0d);

  }

  @Test
  public void test074() {}
// Defects4J: flaky method
//   @Test
//   public void test074() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test074"); }
// 
// 
//     org.jfree.chart.plot.ValueMarker valueMarker1 = new org.jfree.chart.plot.ValueMarker(1.0d);
//     org.jfree.data.time.Month month2 = new org.jfree.data.time.Month();
//     int i3 = month2.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem5 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month2, 11.0d);
//     timeSeriesDataItem5.setSelected(true);
//     boolean b8 = valueMarker1.equals((java.lang.Object)true);
//     valueMarker1.setValue(0.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i3 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b8 == false);
// 
//   }

  @Test
  public void test075() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test075"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis0 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset1 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot2 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset1);
    org.jfree.chart.axis.ValueAxis valueAxis3 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot4 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis3);
    java.util.List list5 = combinedDomainXYPlot4.getAnnotations();
    waferMapPlot2.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot4);
    int i7 = combinedDomainXYPlot4.getSeriesCount();
    categoryAxis0.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot4);
    boolean b10 = categoryAxis0.equals((java.lang.Object)(short)1);
    java.awt.Color color16 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke17 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color18 = java.awt.Color.orange;
    java.awt.Stroke stroke19 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker21 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color16, stroke17, (java.awt.Paint)color18, stroke19, 0.0f);
    java.awt.Color color22 = color18.brighter();
    categoryAxis0.setTickLabelPaint((java.awt.Paint)color18);
    categoryAxis0.setLowerMargin(3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color22);

  }

  @Test
  public void test076() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test076"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    org.jfree.chart.util.Layer layer23 = null;
    boolean b25 = combinedDomainXYPlot5.removeDomainMarker(2, (org.jfree.chart.plot.Marker)intervalMarker22, layer23, false);
    org.jfree.chart.annotations.XYAnnotation xYAnnotation26 = null;
    // The following exception was thrown during execution in test generation
    try {
      boolean b27 = combinedDomainXYPlot5.removeAnnotation(xYAnnotation26);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);

  }

  @Test
  public void test077() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test077"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.axis.CategoryAxis categoryAxis2 = categoryPlot0.getDomainAxis();
    categoryPlot0.setCrosshairDatasetIndex(255);
    java.awt.Font font8 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset9 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot10 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset9);
    org.jfree.chart.axis.ValueAxis valueAxis11 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot12 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis11);
    java.util.List list13 = combinedDomainXYPlot12.getAnnotations();
    waferMapPlot10.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot12);
    org.jfree.chart.JFreeChart jFreeChart16 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font8, (org.jfree.chart.plot.Plot)combinedDomainXYPlot12, true);
    java.awt.Color color20 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment21 = new org.jfree.chart.text.TextFragment("hi!", font8, (java.awt.Paint)color20);
    java.awt.Paint paint22 = org.jfree.chart.plot.PiePlot.DEFAULT_LABEL_OUTLINE_PAINT;
    org.jfree.chart.plot.CategoryPlot categoryPlot23 = new org.jfree.chart.plot.CategoryPlot();
    boolean b24 = categoryPlot23.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge26 = categoryPlot23.getDomainAxisEdge(8);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment27 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment28 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement31 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment27, verticalAlignment28, 11.0d, 0.2d);
    org.jfree.chart.util.VerticalAlignment verticalAlignment32 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement35 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment27, verticalAlignment32, (-1.0d), Double.NaN);
    org.jfree.chart.util.VerticalAlignment verticalAlignment36 = org.jfree.chart.title.Title.DEFAULT_VERTICAL_ALIGNMENT;
    org.jfree.chart.util.RectangleInsets rectangleInsets37 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent38 = new org.jfree.data.general.SeriesChangeEvent((java.lang.Object)rectangleInsets37);
    org.jfree.chart.title.TextTitle textTitle39 = new org.jfree.chart.title.TextTitle("March", font8, paint22, rectangleEdge26, horizontalAlignment27, verticalAlignment36, rectangleInsets37);
    categoryPlot0.setRangeMinorGridlinePaint(paint22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryAxis2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(verticalAlignment36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets37);

  }

  @Test
  public void test078() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test078"); }


    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator0 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator4 = new org.jfree.chart.urls.StandardXYURLGenerator("", "hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!", "");
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer5 = new org.jfree.chart.renderer.xy.XYStepRenderer((org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator0, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator4);
    java.lang.Object obj6 = standardXYToolTipGenerator0.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj6);

  }

  @Test
  public void test079() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test079"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    java.util.List list2 = combinedDomainXYPlot1.getAnnotations();
    combinedDomainXYPlot1.setRangeGridlinesVisible(true);
    java.awt.Color color5 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    combinedDomainXYPlot1.setRangeTickBandPaint((java.awt.Paint)color5);
    boolean b7 = combinedDomainXYPlot1.isSubplot();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);

  }

  @Test
  public void test080() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test080"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    boolean b2 = xYBarRenderer1.getUseYInterval();
    java.awt.Font font4 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset5 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot6 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset5);
    org.jfree.chart.axis.ValueAxis valueAxis7 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot8 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis7);
    java.util.List list9 = combinedDomainXYPlot8.getAnnotations();
    waferMapPlot6.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot8);
    boolean b11 = combinedDomainXYPlot8.isNotify();
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("", font4, (org.jfree.chart.plot.Plot)combinedDomainXYPlot8, true);
    combinedDomainXYPlot8.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer16 = null;
    combinedDomainXYPlot8.setRenderer(xYItemRenderer16);
    boolean b18 = combinedDomainXYPlot8.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries19 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection20 = new org.jfree.data.time.TimeSeriesCollection(timeSeries19);
    combinedDomainXYPlot8.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection20);
    xYBarRenderer1.setPlot((org.jfree.chart.plot.XYPlot)combinedDomainXYPlot8);
    xYBarRenderer1.setBaseSeriesVisibleInLegend(false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == false);

  }

  @Test
  public void test081() {}
// Defects4J: flaky method
//   @Test
//   public void test081() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test081"); }
// 
// 
//     org.jfree.data.time.Month month1 = new org.jfree.data.time.Month();
//     int i2 = month1.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem4 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month1, (java.lang.Number)8);
//     long long5 = month1.getFirstMillisecond();
//     org.jfree.data.time.Month month6 = new org.jfree.data.time.Month();
//     int i7 = month6.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis8 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month1, (org.jfree.data.time.RegularTimePeriod)month6);
//     java.util.Calendar calendar9 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       long long10 = month6.getLastMillisecond(calendar9);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i2 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i7 == 2);
// 
//   }

  @Test
  public void test082() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test082"); }


    org.jfree.data.xy.XYSeries xYSeries1 = new org.jfree.data.xy.XYSeries((java.lang.Comparable)(-1.0f));
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer3 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d4 = xYBarRenderer3.getMargin();
    double d5 = xYBarRenderer3.getShadowXOffset();
    org.jfree.chart.urls.XYURLGenerator xYURLGenerator6 = null;
    xYBarRenderer3.setBaseURLGenerator(xYURLGenerator6, true);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer10 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator11 = xYAreaRenderer10.getLegendItemToolTipGenerator();
    boolean b14 = xYAreaRenderer10.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition18 = xYAreaRenderer10.getPositiveItemLabelPosition(8, 10, false);
    xYBarRenderer3.setNegativeItemLabelPositionFallback(itemLabelPosition18);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier20 = xYBarRenderer3.getDrawingSupplier();
    boolean b21 = xYSeries1.equals((java.lang.Object)drawingSupplier20);
    double d22 = xYSeries1.getMaxX();
    // The following exception was thrown during execution in test generation
    try {
      xYSeries1.update((java.lang.Number)(-25560), (java.lang.Number)11.0d);
      org.junit.Assert.fail("Expected exception of type org.jfree.data.general.SeriesException");
    } catch (org.jfree.data.general.SeriesException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.jfree.data.general.SeriesException")) {
        org.junit.Assert.fail("Expected exception of type org.jfree.data.general.SeriesException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b21 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d22, Double.NaN, 0);

  }

  @Test
  public void test083() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test083"); }


    java.lang.Class clazz0 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Class clazz1 = org.jfree.data.time.RegularTimePeriod.downsize(clazz0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test084() {}
// Defects4J: flaky method
//   @Test
//   public void test084() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test084"); }
// 
// 
//     org.jfree.data.time.DateRange dateRange2 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d3 = dateRange2.getLength();
//     long long4 = dateRange2.getLowerMillis();
//     double d5 = dateRange2.getLength();
//     java.lang.String str6 = dateRange2.toString();
//     java.util.Date date7 = dateRange2.getUpperDate();
//     java.util.TimeZone timeZone8 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year9 = new org.jfree.data.time.Year(date7, timeZone8);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod10 = year9.next();
//     java.util.Calendar calendar11 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       long long12 = year9.getFirstMillisecond(calendar11);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long4 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d5 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str6 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str6.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod10);
// 
//   }

  @Test
  public void test085() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test085"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis5 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets6 = categoryAxis5.getLabelInsets();
    double d8 = rectangleInsets6.calculateLeftInset(4.0d);
    categoryPlot0.setInsets(rectangleInsets6, false);
    double d12 = rectangleInsets6.calculateTopInset(0.0d);
    double d13 = rectangleInsets6.getLeft();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d12 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d13 == 3.0d);

  }

  @Test
  public void test086() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test086"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    boolean b3 = xYBarRenderer1.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator5 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer1.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator5, true);
    java.lang.Object obj8 = standardXYToolTipGenerator5.clone();
    java.text.NumberFormat numberFormat9 = standardXYToolTipGenerator5.getXFormat();
    int i10 = numberFormat9.getMinimumFractionDigits();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i10 == 0);

  }

  @Test
  public void test087() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test087"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    java.awt.Stroke stroke11 = jFreeChart10.getBorderStroke();
    jFreeChart10.setBackgroundImageAlignment(2);
    java.util.List list14 = jFreeChart10.getSubtitles();
    org.jfree.chart.event.TitleChangeEvent titleChangeEvent15 = null;
    // The following exception was thrown during execution in test generation
    try {
      jFreeChart10.titleChanged(titleChangeEvent15);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list14);

  }

  @Test
  public void test088() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test088"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
    numberAxis15.centerRange(100.0d);
    combinedDomainXYPlot9.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis15);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier19 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot9.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.clearRangeMarkers(100);
    boolean b24 = categoryPlot0.isRangePannable();
    float f25 = categoryPlot0.getBackgroundAlpha();
    org.jfree.chart.plot.DatasetRenderingOrder datasetRenderingOrder26 = org.jfree.chart.plot.DatasetRenderingOrder.REVERSE;
    categoryPlot0.setDatasetRenderingOrder(datasetRenderingOrder26);
    java.lang.String str28 = datasetRenderingOrder26.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f25 == 1.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(datasetRenderingOrder26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str28 + "' != '" + "DatasetRenderingOrder.REVERSE"+ "'", str28.equals("DatasetRenderingOrder.REVERSE"));

  }

  @Test
  public void test089() {}
// Defects4J: flaky method
//   @Test
//   public void test089() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test089"); }
// 
// 
//     org.jfree.data.time.Month month1 = new org.jfree.data.time.Month();
//     int i2 = month1.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem4 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month1, (java.lang.Number)8);
//     long long5 = month1.getFirstMillisecond();
//     org.jfree.data.time.Month month6 = new org.jfree.data.time.Month();
//     int i7 = month6.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis8 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month1, (org.jfree.data.time.RegularTimePeriod)month6);
//     periodAxis8.setUpperMargin(10.0d);
//     java.awt.geom.Rectangle2D rectangle2D12 = null;
//     org.jfree.data.general.WaferMapDataset waferMapDataset13 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot14 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset13);
//     org.jfree.chart.JFreeChart jFreeChart15 = null;
//     org.jfree.chart.event.ChartChangeEvent chartChangeEvent16 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot14, jFreeChart15);
//     org.jfree.chart.util.HorizontalAlignment horizontalAlignment17 = org.jfree.chart.util.HorizontalAlignment.LEFT;
//     org.jfree.chart.util.VerticalAlignment verticalAlignment18 = null;
//     org.jfree.chart.block.FlowArrangement flowArrangement21 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment17, verticalAlignment18, 11.0d, 0.2d);
//     org.jfree.chart.block.BorderArrangement borderArrangement22 = new org.jfree.chart.block.BorderArrangement();
//     org.jfree.chart.title.LegendTitle legendTitle23 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot14, (org.jfree.chart.block.Arrangement)flowArrangement21, (org.jfree.chart.block.Arrangement)borderArrangement22);
//     org.jfree.chart.plot.CategoryPlot categoryPlot24 = new org.jfree.chart.plot.CategoryPlot();
//     boolean b25 = categoryPlot24.isRangeZoomable();
//     org.jfree.chart.util.RectangleEdge rectangleEdge27 = categoryPlot24.getDomainAxisEdge(8);
//     legendTitle23.setPosition(rectangleEdge27);
//     org.jfree.chart.util.RectangleEdge rectangleEdge29 = legendTitle23.getPosition();
//     // The following exception was thrown during execution in test generation
//     try {
//       double d30 = periodAxis8.java2DToValue(0.05d, rectangle2D12, rectangleEdge29);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i2 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i7 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(horizontalAlignment17);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b25 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleEdge27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleEdge29);
// 
//   }

  @Test
  public void test090() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test090"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    org.jfree.chart.plot.CategoryPlot categoryPlot11 = new org.jfree.chart.plot.CategoryPlot();
    boolean b12 = categoryPlot11.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge14 = categoryPlot11.getDomainAxisEdge(8);
    legendTitle10.setPosition(rectangleEdge14);
    java.awt.Graphics2D graphics2D16 = null;
    org.jfree.data.time.DateRange dateRange19 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange22 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b23 = dateRange19.intersects((org.jfree.data.Range)dateRange22);
    org.jfree.data.Range range25 = org.jfree.data.Range.expandToInclude((org.jfree.data.Range)dateRange19, 1.0d);
    org.jfree.data.Range range27 = org.jfree.data.Range.scale((org.jfree.data.Range)dateRange19, 0.0d);
    org.jfree.chart.block.RectangleConstraint rectangleConstraint29 = new org.jfree.chart.block.RectangleConstraint((org.jfree.data.Range)dateRange19, 7.0d);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.util.Size2D size2D30 = legendTitle10.arrange(graphics2D16, rectangleConstraint29);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range27);

  }

  @Test
  public void test091() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test091"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot1 = new org.jfree.chart.plot.CategoryPlot();
    boolean b2 = categoryPlot1.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge4 = categoryPlot1.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis6 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets7 = categoryAxis6.getLabelInsets();
    double d9 = rectangleInsets7.calculateLeftInset(4.0d);
    categoryPlot1.setInsets(rectangleInsets7, false);
    int i12 = categoryPlot1.getRendererCount();
    categoryPlot1.setBackgroundAlpha(0.0f);
    java.awt.Paint paint15 = categoryPlot1.getDomainGridlinePaint();
    org.jfree.chart.LegendItem legendItem16 = new org.jfree.chart.LegendItem("TextAnchor.CENTER", paint15);
    legendItem16.setDescription("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d9 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i12 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint15);

  }

  @Test
  public void test092() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test092"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.util.RectangleEdge rectangleEdge13 = combinedDomainXYPlot5.getDomainAxisEdge();
    org.jfree.chart.plot.Marker marker14 = null;
    // The following exception was thrown during execution in test generation
    try {
      combinedDomainXYPlot5.addDomainMarker(marker14);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge13);

  }

  @Test
  public void test093() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test093"); }


    java.awt.Graphics2D graphics2D1 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.text.TextUtilities.drawRotatedString("series", graphics2D1, 12.0d, 0.5f, 2.0f);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test094() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test094"); }


    org.jfree.data.xy.TableXYDataset tableXYDataset0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.Range range2 = org.jfree.data.general.DatasetUtilities.findStackedRangeBounds(tableXYDataset0, 10.0d);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test095() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test095"); }


    org.jfree.chart.ui.BasicProjectInfo basicProjectInfo4 = new org.jfree.chart.ui.BasicProjectInfo("Combined_Domain_XYPlot", "MINOR", "RectangleAnchor.LEFT", "31-December-1969");
    org.jfree.chart.ui.Library[] library_array5 = basicProjectInfo4.getOptionalLibraries();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(library_array5);

  }

  @Test
  public void test096() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test096"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    org.jfree.data.general.WaferMapDataset waferMapDataset31 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot32 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset31);
    org.jfree.chart.JFreeChart jFreeChart33 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent34 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot32, jFreeChart33);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment35 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment36 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement39 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment35, verticalAlignment36, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement40 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle41 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot32, (org.jfree.chart.block.Arrangement)flowArrangement39, (org.jfree.chart.block.Arrangement)borderArrangement40);
    org.jfree.chart.entity.TitleEntity titleEntity43 = new org.jfree.chart.entity.TitleEntity(shape7, (org.jfree.chart.title.Title)legendTitle41, "green");
    org.jfree.chart.util.RectangleInsets rectangleInsets44 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d45 = rectangleInsets44.getTop();
    legendTitle41.setItemLabelPadding(rectangleInsets44);
    java.awt.Graphics2D graphics2D47 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.util.Size2D size2D48 = legendTitle41.arrange(graphics2D47);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d45 == 4.0d);

  }

  @Test
  public void test097() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test097"); }


    java.lang.Number[] number_array2 = null;
    java.lang.Number[][] number_array_array3 = new java.lang.Number[][] { number_array2 };
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.category.CategoryDataset categoryDataset4 = org.jfree.data.general.DatasetUtilities.createCategoryDataset("Last", "LengthConstraintType.FIXED", number_array_array3);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(number_array_array3);

  }

  @Test
  public void test098() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test098"); }


    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator3 = new org.jfree.chart.urls.StandardXYURLGenerator("RectangleAnchor.LEFT", "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]", "{0}: ({1}, {2})");
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    boolean b12 = combinedDomainXYPlot9.isNotify();
    org.jfree.chart.JFreeChart jFreeChart14 = new org.jfree.chart.JFreeChart("", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    combinedDomainXYPlot9.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer17 = null;
    combinedDomainXYPlot9.setRenderer(xYItemRenderer17);
    boolean b19 = combinedDomainXYPlot9.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries20 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection21 = new org.jfree.data.time.TimeSeriesCollection(timeSeries20);
    combinedDomainXYPlot9.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection21);
    timeSeriesCollection21.removeAllSeries();
    java.lang.String str26 = standardXYURLGenerator3.generateURL((org.jfree.data.xy.XYDataset)timeSeriesCollection21, 4, 255);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number29 = timeSeriesCollection21.getX(7, 2016);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str26 + "' != '" + "RectangleAnchor.LEFT?[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]=4&amp;{0}: ({1}, {2})=255"+ "'", str26.equals("RectangleAnchor.LEFT?[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]=4&amp;{0}: ({1}, {2})=255"));

  }

  @Test
  public void test099() {}
// Defects4J: flaky method
//   @Test
//   public void test099() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test099"); }
// 
// 
//     org.jfree.data.time.DateRange dateRange2 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d3 = dateRange2.getLength();
//     long long4 = dateRange2.getLowerMillis();
//     double d5 = dateRange2.getLength();
//     java.lang.String str6 = dateRange2.toString();
//     java.util.Date date7 = dateRange2.getUpperDate();
//     java.util.TimeZone timeZone8 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year9 = new org.jfree.data.time.Year(date7, timeZone8);
//     long long10 = year9.getFirstMillisecond();
//     java.util.Calendar calendar11 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       long long12 = year9.getFirstMillisecond(calendar11);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long4 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d5 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str6 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str6.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long10 == (-31507200000L));
// 
//   }

  @Test
  public void test100() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test100"); }


    org.jfree.chart.util.ShapeList shapeList0 = new org.jfree.chart.util.ShapeList();
    org.jfree.chart.plot.CategoryPlot categoryPlot1 = new org.jfree.chart.plot.CategoryPlot();
    boolean b2 = categoryPlot1.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge4 = categoryPlot1.getDomainAxisEdge(8);
    java.awt.Font font6 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset7 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot8 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset7);
    org.jfree.chart.axis.ValueAxis valueAxis9 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot10 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis9);
    java.util.List list11 = combinedDomainXYPlot10.getAnnotations();
    waferMapPlot8.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot10);
    org.jfree.chart.JFreeChart jFreeChart14 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font6, (org.jfree.chart.plot.Plot)combinedDomainXYPlot10, true);
    org.jfree.chart.axis.NumberAxis numberAxis16 = new org.jfree.chart.axis.NumberAxis();
    numberAxis16.centerRange(100.0d);
    combinedDomainXYPlot10.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis16);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier20 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot10.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier20);
    categoryPlot1.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier20);
    org.jfree.data.category.CategoryDataset categoryDataset23 = null;
    org.jfree.chart.renderer.category.CategoryItemRenderer categoryItemRenderer24 = categoryPlot1.getRendererForDataset(categoryDataset23);
    java.awt.Color color31 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke32 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color33 = java.awt.Color.orange;
    java.awt.Stroke stroke34 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker36 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color31, stroke32, (java.awt.Paint)color33, stroke34, 0.0f);
    java.awt.Paint paint37 = intervalMarker36.getPaint();
    org.jfree.chart.util.Layer layer38 = null;
    boolean b39 = categoryPlot1.removeDomainMarker(8, (org.jfree.chart.plot.Marker)intervalMarker36, layer38);
    boolean b40 = shapeList0.equals((java.lang.Object)categoryPlot1);
    org.jfree.chart.axis.NumberAxis numberAxis41 = new org.jfree.chart.axis.NumberAxis();
    numberAxis41.resizeRange2(10.0d, 11.0d);
    org.jfree.chart.util.RectangleInsets rectangleInsets45 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d46 = rectangleInsets45.getLeft();
    numberAxis41.setTickLabelInsets(rectangleInsets45);
    org.jfree.data.Range range48 = numberAxis41.getRange();
    java.awt.Shape shape49 = numberAxis41.getRightArrow();
    int i50 = categoryPlot1.getRangeAxisIndex((org.jfree.chart.axis.ValueAxis)numberAxis41);
    org.jfree.chart.axis.NumberAxis3D numberAxis3D51 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Color color52 = org.jfree.chart.ChartColor.VERY_LIGHT_GREEN;
    numberAxis3D51.setTickMarkPaint((java.awt.Paint)color52);
    categoryPlot1.setRangeAxis((org.jfree.chart.axis.ValueAxis)numberAxis3D51);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.axis.CategoryAxis categoryAxis56 = categoryPlot1.getDomainAxisForDataset((-1));
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryItemRenderer24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d46 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i50 == (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color52);

  }

  @Test
  public void test101() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test101"); }


    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D1 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D3 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke4 = categoryAxis3D3.getTickMarkStroke();
    java.awt.Stroke stroke5 = org.jfree.chart.plot.CategoryPlot.DEFAULT_CROSSHAIR_STROKE;
    categoryAxis3D3.setAxisLineStroke(stroke5);
    boolean b7 = categoryAxis3D1.equals((java.lang.Object)stroke5);
    java.awt.Paint paint8 = categoryAxis3D1.getLabelPaint();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint8);

  }

  @Test
  public void test102() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test102"); }


    java.lang.ClassLoader classLoader0 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.util.ResourceBundle.clearCache(classLoader0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test103() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test103"); }


    org.jfree.data.category.CategoryDataset categoryDataset0 = null;
    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot1 = new org.jfree.chart.plot.MultiplePiePlot(categoryDataset0);
    double d2 = multiplePiePlot1.getLimit();
    org.jfree.chart.event.AxisChangeEvent axisChangeEvent3 = null;
    multiplePiePlot1.axisChanged(axisChangeEvent3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.0d);

  }

  @Test
  public void test104() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test104"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    boolean b5 = xYAreaRenderer1.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition9 = xYAreaRenderer1.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b11 = xYAreaRenderer1.getSeriesCreateEntities(10);
    java.lang.Boolean b13 = xYAreaRenderer1.getSeriesVisible(8);
    boolean b14 = xYAreaRenderer1.getBaseSeriesVisible();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);

  }

  @Test
  public void test105() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test105"); }


    java.awt.Color color0 = org.jfree.chart.ChartColor.VERY_LIGHT_RED;
    int i1 = color0.getAlpha();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == 255);

  }

  @Test
  public void test106() {}
// Defects4J: flaky method
//   @Test
//   public void test106() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test106"); }
// 
// 
//     org.jfree.data.time.Month month1 = new org.jfree.data.time.Month();
//     int i2 = month1.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem4 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month1, (java.lang.Number)8);
//     long long5 = month1.getFirstMillisecond();
//     org.jfree.data.time.Month month6 = new org.jfree.data.time.Month();
//     int i7 = month6.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis8 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month1, (org.jfree.data.time.RegularTimePeriod)month6);
//     float f9 = periodAxis8.getMinorTickMarkInsideLength();
//     java.lang.Object obj10 = periodAxis8.clone();
//     org.jfree.chart.axis.PeriodAxisLabelInfo[] periodAxisLabelInfo_array11 = periodAxis8.getLabelInfo();
//     java.awt.Shape shape12 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       periodAxis8.setLeftArrow(shape12);
//       org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
//     } catch (java.lang.IllegalArgumentException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i2 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i7 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f9 == 0.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(periodAxisLabelInfo_array11);
// 
//   }

  @Test
  public void test107() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test107"); }


    java.lang.String str1 = org.jfree.data.time.SerialDate.relativeToString(64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "ERROR : Relative To String"+ "'", str1.equals("ERROR : Relative To String"));

  }

  @Test
  public void test108() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test108"); }


    java.lang.Class clazz1 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.io.InputStream inputStream2 = org.jfree.chart.util.ObjectUtilities.getResourceAsStream("", clazz1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test109() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test109"); }


    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D1 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke2 = categoryAxis3D1.getTickMarkStroke();
    java.awt.Stroke stroke3 = org.jfree.chart.plot.CategoryPlot.DEFAULT_CROSSHAIR_STROKE;
    categoryAxis3D1.setAxisLineStroke(stroke3);
    categoryAxis3D1.clearCategoryLabelToolTips();
    org.jfree.chart.axis.CategoryLabelPositions categoryLabelPositions6 = null;
    // The following exception was thrown during execution in test generation
    try {
      categoryAxis3D1.setCategoryLabelPositions(categoryLabelPositions6);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke3);

  }

  @Test
  public void test110() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test110"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    categoryPlot0.clearDomainMarkers();
    org.jfree.chart.axis.NumberAxis numberAxis6 = new org.jfree.chart.axis.NumberAxis();
    numberAxis6.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer10 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator11 = xYAreaRenderer10.getLegendItemToolTipGenerator();
    java.awt.Shape shape12 = xYAreaRenderer10.getBaseShape();
    numberAxis6.setUpArrow(shape12);
    numberAxis6.pan((-1.0d));
    java.awt.Paint paint16 = numberAxis6.getAxisLinePaint();
    categoryPlot0.setRangeAxis(2, (org.jfree.chart.axis.ValueAxis)numberAxis6, false);
    org.jfree.chart.axis.NumberAxis numberAxis19 = new org.jfree.chart.axis.NumberAxis();
    numberAxis19.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer23 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator24 = xYAreaRenderer23.getLegendItemToolTipGenerator();
    java.awt.Shape shape25 = xYAreaRenderer23.getBaseShape();
    numberAxis19.setUpArrow(shape25);
    org.jfree.chart.StandardChartTheme standardChartTheme32 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.renderer.category.BarPainter barPainter33 = standardChartTheme32.getBarPainter();
    java.awt.Font font34 = standardChartTheme32.getLargeFont();
    org.jfree.chart.axis.MarkerAxisBand markerAxisBand35 = new org.jfree.chart.axis.MarkerAxisBand(numberAxis19, 0.2d, 12.0d, 0.0d, 4.5d, font34);
    numberAxis6.setMarkerBand(markerAxisBand35);
    java.awt.geom.Rectangle2D rectangle2D38 = null;
    org.jfree.data.general.WaferMapDataset waferMapDataset39 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot40 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset39);
    org.jfree.chart.JFreeChart jFreeChart41 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent42 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot40, jFreeChart41);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment43 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment44 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement47 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment43, verticalAlignment44, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement48 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle49 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot40, (org.jfree.chart.block.Arrangement)flowArrangement47, (org.jfree.chart.block.Arrangement)borderArrangement48);
    org.jfree.chart.plot.CategoryPlot categoryPlot50 = new org.jfree.chart.plot.CategoryPlot();
    boolean b51 = categoryPlot50.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge53 = categoryPlot50.getDomainAxisEdge(8);
    legendTitle49.setPosition(rectangleEdge53);
    org.jfree.chart.block.BlockFrame blockFrame55 = legendTitle49.getFrame();
    org.jfree.chart.util.RectangleEdge rectangleEdge56 = org.jfree.chart.util.RectangleEdge.LEFT;
    legendTitle49.setLegendItemGraphicEdge(rectangleEdge56);
    // The following exception was thrown during execution in test generation
    try {
      double d58 = numberAxis6.valueToJava2D((-1.0d), rectangle2D38, rectangleEdge56);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(barPainter33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b51 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge56);

  }

  @Test
  public void test111() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test111"); }


    org.jfree.chart.util.Rotation rotation0 = org.jfree.chart.util.Rotation.ANTICLOCKWISE;
    java.awt.Color color6 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke7 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color8 = java.awt.Color.orange;
    java.awt.Stroke stroke9 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker11 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color6, stroke7, (java.awt.Paint)color8, stroke9, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer12 = null;
    intervalMarker11.setGradientPaintTransformer(gradientPaintTransformer12);
    org.jfree.chart.util.RectangleInsets rectangleInsets14 = intervalMarker11.getLabelOffset();
    org.jfree.chart.util.RectangleAnchor rectangleAnchor15 = org.jfree.chart.util.RectangleAnchor.LEFT;
    intervalMarker11.setLabelAnchor(rectangleAnchor15);
    org.jfree.chart.util.RectangleInsets rectangleInsets17 = intervalMarker11.getLabelOffset();
    java.awt.Stroke stroke18 = intervalMarker11.getStroke();
    boolean b19 = rotation0.equals((java.lang.Object)stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rotation0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleAnchor15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);

  }

  @Test
  public void test112() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test112"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    xYAreaRenderer1.setBaseSeriesVisible(false);
    java.awt.Paint paint5 = xYAreaRenderer1.lookupLegendTextPaint(0);
    java.awt.Font font7 = xYAreaRenderer1.getSeriesItemLabelFont(4);
    java.awt.Stroke stroke8 = xYAreaRenderer1.getBaseStroke();
    boolean b9 = xYAreaRenderer1.isOutline();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(font7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);

  }

  @Test
  public void test113() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test113"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    java.lang.Number number3 = null;
    defaultPieDataset0.setValue((java.lang.Comparable)6.0d, number3);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Comparable comparable6 = defaultPieDataset0.getKey(128);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);

  }

  @Test
  public void test114() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test114"); }


    org.jfree.data.category.CategoryDataset categoryDataset0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.Range range1 = org.jfree.data.general.DatasetUtilities.findRangeBounds(categoryDataset0);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test115() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test115"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    org.jfree.chart.JFreeChart jFreeChart9 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    java.awt.Color color15 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke16 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color17 = java.awt.Color.orange;
    java.awt.Stroke stroke18 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker20 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color15, stroke16, (java.awt.Paint)color17, stroke18, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer21 = null;
    intervalMarker20.setGradientPaintTransformer(gradientPaintTransformer21);
    combinedDomainXYPlot5.addDomainMarker((org.jfree.chart.plot.Marker)intervalMarker20);
    intervalMarker20.setStartValue(Double.NaN);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);

  }

  @Test
  public void test116() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test116"); }


    org.jfree.chart.axis.NumberAxis3D numberAxis3D0 = new org.jfree.chart.axis.NumberAxis3D();
    org.jfree.data.Range range2 = null;
    org.jfree.chart.block.RectangleConstraint rectangleConstraint3 = new org.jfree.chart.block.RectangleConstraint(100.0d, range2);
    org.jfree.chart.block.LengthConstraintType lengthConstraintType4 = rectangleConstraint3.getWidthConstraintType();
    org.jfree.data.time.DateRange dateRange7 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange10 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b11 = dateRange7.intersects((org.jfree.data.Range)dateRange10);
    org.jfree.chart.block.RectangleConstraint rectangleConstraint12 = rectangleConstraint3.toRangeHeight((org.jfree.data.Range)dateRange10);
    numberAxis3D0.setDefaultAutoRange((org.jfree.data.Range)dateRange10);
    numberAxis3D0.resizeRange(0.2d);
    float f16 = numberAxis3D0.getMinorTickMarkOutsideLength();
    numberAxis3D0.setLowerMargin(0.025d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleConstraint12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f16 == 2.0f);

  }

  @Test
  public void test117() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test117"); }


    org.jfree.chart.util.LogFormat logFormat3 = new org.jfree.chart.util.LogFormat(10.0d, "", true);
    java.lang.String str5 = logFormat3.format((java.lang.Object)100.0f);
    int i6 = logFormat3.getMinimumFractionDigits();
    logFormat3.setMinimumIntegerDigits(100);
    java.text.NumberFormat numberFormat9 = java.text.NumberFormat.getIntegerInstance();
    java.util.Currency currency10 = numberFormat9.getCurrency();
    // The following exception was thrown during execution in test generation
    try {
      logFormat3.setCurrency(currency10);
      org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException");
    } catch (java.lang.UnsupportedOperationException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.UnsupportedOperationException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str5 + "' != '" + "^2.0"+ "'", str5.equals("^2.0"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(currency10);

  }

  @Test
  public void test118() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test118"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
    numberAxis15.centerRange(100.0d);
    combinedDomainXYPlot9.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis15);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier19 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot9.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.clearRangeMarkers(100);
    org.jfree.chart.util.RectangleInsets rectangleInsets24 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    categoryPlot0.setAxisOffset(rectangleInsets24);
    java.awt.Stroke stroke26 = categoryPlot0.getRangeGridlineStroke();
    org.jfree.chart.util.Layer layer27 = org.jfree.chart.util.Layer.BACKGROUND;
    java.util.Collection collection28 = categoryPlot0.getRangeMarkers(layer27);
    org.jfree.chart.plot.CategoryMarker categoryMarker29 = null;
    org.jfree.chart.util.Layer layer30 = org.jfree.chart.util.Layer.FOREGROUND;
    // The following exception was thrown during execution in test generation
    try {
      categoryPlot0.addDomainMarker(categoryMarker29, layer30);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(layer27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(layer30);

  }

  @Test
  public void test119() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test119"); }


    org.jfree.data.xy.XYSeries xYSeries3 = new org.jfree.data.xy.XYSeries((java.lang.Comparable)10.0d, false, false);
    xYSeries3.add((-1.0d), (java.lang.Number)(byte)(-1));
    java.beans.PropertyChangeListener propertyChangeListener7 = null;
    xYSeries3.removePropertyChangeListener(propertyChangeListener7);
    xYSeries3.fireSeriesChanged();

  }

  @Test
  public void test120() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test120"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
    numberAxis15.centerRange(100.0d);
    combinedDomainXYPlot9.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis15);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier19 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot9.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    double d22 = categoryPlot0.getRangeCrosshairValue();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d22 == 0.0d);

  }

  @Test
  public void test121() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test121"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    java.awt.Graphics2D graphics2D4 = null;
    java.awt.geom.Rectangle2D rectangle2D5 = null;
    org.jfree.data.general.DefaultPieDataset defaultPieDataset6 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj7 = defaultPieDataset6.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D8 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset6);
    piePlot3D8.setIgnoreZeroValues(true);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo12 = null;
    org.jfree.chart.plot.PiePlotState piePlotState13 = piePlot3D2.initialise(graphics2D4, rectangle2D5, (org.jfree.chart.plot.PiePlot)piePlot3D8, (java.lang.Integer)1, plotRenderingInfo12);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo14 = piePlotState13.getInfo();
    org.jfree.chart.entity.EntityCollection entityCollection15 = piePlotState13.getEntityCollection();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(piePlotState13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(plotRenderingInfo14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(entityCollection15);

  }

  @Test
  public void test122() {}
// Defects4J: flaky method
//   @Test
//   public void test122() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test122"); }
// 
// 
//     org.jfree.data.xy.XYSeries xYSeries0 = null;
//     org.jfree.data.xy.XYSeriesCollection xYSeriesCollection1 = new org.jfree.data.xy.XYSeriesCollection(xYSeries0);
//     org.jfree.chart.axis.ValueAxis valueAxis2 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot3 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis2);
//     java.util.List list4 = combinedDomainXYPlot3.getAnnotations();
//     combinedDomainXYPlot3.setRangeGridlinesVisible(true);
//     org.jfree.chart.axis.ValueAxis valueAxis8 = null;
//     combinedDomainXYPlot3.setRangeAxis(100, valueAxis8, false);
//     org.jfree.chart.axis.NumberAxis numberAxis11 = new org.jfree.chart.axis.NumberAxis();
//     numberAxis11.centerRange(100.0d);
//     combinedDomainXYPlot3.setRangeAxis((org.jfree.chart.axis.ValueAxis)numberAxis11);
//     boolean b15 = numberAxis11.isNegativeArrowVisible();
//     org.jfree.data.time.DateRange dateRange18 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     org.jfree.data.time.DateRange dateRange21 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     boolean b22 = dateRange18.intersects((org.jfree.data.Range)dateRange21);
//     java.lang.String str23 = dateRange18.toString();
//     numberAxis11.setDefaultAutoRange((org.jfree.data.Range)dateRange18);
//     numberAxis11.setNegativeArrowVisible(true);
//     org.jfree.chart.labels.ItemLabelAnchor itemLabelAnchor27 = org.jfree.chart.labels.ItemLabelAnchor.INSIDE12;
//     org.jfree.chart.text.TextAnchor textAnchor28 = org.jfree.chart.text.TextAnchor.CENTER;
//     org.jfree.chart.text.TextAnchor textAnchor29 = org.jfree.chart.text.TextAnchor.TOP_CENTER;
//     org.jfree.chart.labels.ItemLabelPosition itemLabelPosition31 = new org.jfree.chart.labels.ItemLabelPosition(itemLabelAnchor27, textAnchor28, textAnchor29, 0.0d);
//     org.jfree.data.Range range33 = null;
//     org.jfree.chart.block.RectangleConstraint rectangleConstraint34 = new org.jfree.chart.block.RectangleConstraint(100.0d, range33);
//     org.jfree.chart.block.LengthConstraintType lengthConstraintType35 = rectangleConstraint34.getWidthConstraintType();
//     org.jfree.data.time.DateRange dateRange38 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     org.jfree.data.time.DateRange dateRange41 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     boolean b42 = dateRange38.intersects((org.jfree.data.Range)dateRange41);
//     org.jfree.chart.block.RectangleConstraint rectangleConstraint43 = rectangleConstraint34.toRangeHeight((org.jfree.data.Range)dateRange41);
//     boolean b44 = textAnchor28.equals((java.lang.Object)dateRange41);
//     numberAxis11.setRangeWithMargins((org.jfree.data.Range)dateRange41);
//     org.jfree.chart.axis.NumberAxis numberAxis46 = new org.jfree.chart.axis.NumberAxis();
//     numberAxis46.centerRange(100.0d);
//     java.lang.Object obj49 = numberAxis46.clone();
//     numberAxis46.setInverted(true);
//     org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer53 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
//     xYAreaRenderer53.setBaseSeriesVisible(false);
//     java.awt.Paint paint57 = xYAreaRenderer53.lookupLegendTextPaint(0);
//     java.awt.Stroke stroke61 = xYAreaRenderer53.getItemOutlineStroke(14, 10, true);
//     org.jfree.chart.plot.XYPlot xYPlot62 = new org.jfree.chart.plot.XYPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection1, (org.jfree.chart.axis.ValueAxis)numberAxis11, (org.jfree.chart.axis.ValueAxis)numberAxis46, (org.jfree.chart.renderer.xy.XYItemRenderer)xYAreaRenderer53);
//     java.awt.Font font64 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
//     org.jfree.data.general.WaferMapDataset waferMapDataset65 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot66 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset65);
//     org.jfree.chart.axis.ValueAxis valueAxis67 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot68 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis67);
//     java.util.List list69 = combinedDomainXYPlot68.getAnnotations();
//     waferMapPlot66.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot68);
//     boolean b71 = combinedDomainXYPlot68.isNotify();
//     org.jfree.chart.JFreeChart jFreeChart73 = new org.jfree.chart.JFreeChart("", font64, (org.jfree.chart.plot.Plot)combinedDomainXYPlot68, true);
//     java.awt.Paint paint74 = combinedDomainXYPlot68.getRangeCrosshairPaint();
//     double d75 = combinedDomainXYPlot68.getGap();
//     java.lang.String str76 = combinedDomainXYPlot68.getPlotType();
//     boolean b77 = xYSeriesCollection1.hasListener((java.util.EventListener)combinedDomainXYPlot68);
//     boolean b78 = xYSeriesCollection1.isAutoWidth();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b15 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b22 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str23 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str23.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(itemLabelAnchor27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(textAnchor28);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(textAnchor29);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(lengthConstraintType35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b42 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleConstraint43);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b44 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj49);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(paint57);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke61);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(font64);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list69);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b71 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(paint74);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d75 == 5.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str76 + "' != '" + "Combined_Domain_XYPlot"+ "'", str76.equals("Combined_Domain_XYPlot"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b77 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b78 == false);
// 
//   }

  @Test
  public void test123() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test123"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer4 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    xYStepRenderer4.setSeriesShapesFilled(15, false);
    boolean b10 = xYStepRenderer4.getItemLineVisible(1, 8);
    java.awt.Shape shape14 = xYStepRenderer4.getItemShape((-435), 133, false);
    java.awt.Stroke stroke15 = null;
    java.awt.Paint paint16 = org.jfree.chart.text.TextFragment.DEFAULT_PAINT;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.LegendItem legendItem17 = new org.jfree.chart.LegendItem("EXPAND", "^2.0", "January", "", shape14, stroke15, paint16);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint16);

  }

  @Test
  public void test124() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test124"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    java.awt.Font font7 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset8 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot9 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset8);
    org.jfree.chart.axis.ValueAxis valueAxis10 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot11 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis10);
    java.util.List list12 = combinedDomainXYPlot11.getAnnotations();
    waferMapPlot9.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot11);
    org.jfree.chart.JFreeChart jFreeChart15 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font7, (org.jfree.chart.plot.Plot)combinedDomainXYPlot11, true);
    java.awt.Color color19 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment20 = new org.jfree.chart.text.TextFragment("hi!", font7, (java.awt.Paint)color19);
    java.awt.Color color21 = java.awt.Color.green;
    java.lang.String str22 = org.jfree.chart.util.PaintUtilities.colorToString(color21);
    org.jfree.chart.text.TextLine textLine23 = new org.jfree.chart.text.TextLine("ERROR : Relative To String", font7, (java.awt.Paint)color21);
    // The following exception was thrown during execution in test generation
    try {
      xYAreaRenderer1.setSeriesOutlinePaint((-435), (java.awt.Paint)color21, false);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str22 + "' != '" + "green"+ "'", str22.equals("green"));

  }

  @Test
  public void test125() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test125"); }


    org.jfree.chart.renderer.xy.XYBarRenderer.setDefaultShadowsVisible(false);

  }

  @Test
  public void test126() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test126"); }


    org.jfree.data.time.TimeSeries timeSeries0 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection1 = new org.jfree.data.time.TimeSeriesCollection(timeSeries0);
    org.jfree.data.time.TimePeriodAnchor timePeriodAnchor2 = timeSeriesCollection1.getXPosition();
    java.lang.Number number3 = org.jfree.data.general.DatasetUtilities.findMinimumDomainValue((org.jfree.data.xy.XYDataset)timeSeriesCollection1);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number6 = timeSeriesCollection1.getStartX(1, (-1));
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(timePeriodAnchor2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)number3, Double.NaN, 0);

  }

  @Test
  public void test127() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test127"); }


    java.util.TimeZone timeZone0 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection1 = new org.jfree.data.time.TimeSeriesCollection(timeZone0);
    org.jfree.data.time.TimePeriodAnchor timePeriodAnchor2 = null;
    // The following exception was thrown during execution in test generation
    try {
      timeSeriesCollection1.setXPosition(timePeriodAnchor2);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test128() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test128"); }


    org.jfree.chart.renderer.category.BarRenderer3D barRenderer3D2 = new org.jfree.chart.renderer.category.BarRenderer3D(0.2d, 6.0d);

  }

  @Test
  public void test129() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test129"); }


    double d0 = org.jfree.chart.axis.ValueAxis.DEFAULT_UPPER_MARGIN;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d0 == 0.05d);

  }

  @Test
  public void test130() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test130"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.axis.ValueAxis valueAxis2 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot3 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis2);
    java.util.List list4 = combinedDomainXYPlot3.getAnnotations();
    waferMapPlot1.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot3);
    int i6 = combinedDomainXYPlot3.getSeriesCount();
    boolean b8 = combinedDomainXYPlot3.equals((java.lang.Object)10.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer10 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    xYAreaRenderer10.setSeriesCreateEntities(15, (java.lang.Boolean)true, true);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition16 = xYAreaRenderer10.getSeriesPositiveItemLabelPosition(3);
    boolean b17 = combinedDomainXYPlot3.equals((java.lang.Object)3);
    boolean b18 = combinedDomainXYPlot3.isDomainZoomable();
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color28 = java.awt.Color.green;
    java.awt.Color color30 = java.awt.Color.green;
    java.awt.Color color36 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke37 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color38 = java.awt.Color.orange;
    java.awt.Stroke stroke39 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker41 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color36, stroke37, (java.awt.Paint)color38, stroke39, 0.0f);
    java.awt.Shape shape45 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke46 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color47 = java.awt.Color.green;
    java.lang.String str48 = org.jfree.chart.util.PaintUtilities.colorToString(color47);
    org.jfree.chart.LegendItem legendItem49 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape26, true, (java.awt.Paint)color28, false, (java.awt.Paint)color30, stroke37, true, shape45, stroke46, (java.awt.Paint)color47);
    boolean b50 = legendItem49.isShapeOutlineVisible();
    org.jfree.data.xy.XYSeries xYSeries51 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection52 = new org.jfree.data.xy.XYSeriesCollection(xYSeries51);
    boolean b53 = xYSeriesCollection52.isAutoWidth();
    legendItem49.setDataset((org.jfree.data.general.Dataset)xYSeriesCollection52);
    combinedDomainXYPlot3.setDataset((org.jfree.data.xy.XYDataset)xYSeriesCollection52);
    // The following exception was thrown during execution in test generation
    try {
      int i59 = org.jfree.chart.renderer.RendererUtilities.findLiveItemsLowerBound((org.jfree.data.xy.XYDataset)xYSeriesCollection52, (-435), 0.05d, 0.05d);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str48 + "' != '" + "green"+ "'", str48.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b50 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b53 == false);

  }

  @Test
  public void test131() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test131"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    java.awt.Shape shape3 = xYAreaRenderer1.getBaseShape();
    java.awt.Shape shape6 = org.jfree.chart.util.ShapeUtilities.createTranslatedShape(shape3, 6.0d, 0.0d);
    java.awt.Paint paint7 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.title.LegendGraphic legendGraphic8 = new org.jfree.chart.title.LegendGraphic(shape6, paint7);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape6);

  }

  @Test
  public void test132() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test132"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer13 = null;
    combinedDomainXYPlot5.setRenderer(xYItemRenderer13);
    boolean b15 = combinedDomainXYPlot5.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries16 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection17 = new org.jfree.data.time.TimeSeriesCollection(timeSeries16);
    combinedDomainXYPlot5.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    java.util.List list19 = timeSeriesCollection17.getSeries();
    org.jfree.data.Range range20 = org.jfree.data.general.DatasetUtilities.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    // The following exception was thrown during execution in test generation
    try {
      int[] i_array23 = timeSeriesCollection17.getSurroundingItems((-25560), 0L);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range20);

  }

  @Test
  public void test133() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test133"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    xYAreaRenderer1.setSeriesItemLabelsVisible(10, (java.lang.Boolean)true);
    java.awt.Font font6 = xYAreaRenderer1.getLegendTextFont(40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(font6);

  }

  @Test
  public void test134() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test134"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.axis.AxisLocation axisLocation14 = null;
    combinedDomainXYPlot5.setDomainAxisLocation(3, axisLocation14, false);
    org.jfree.chart.axis.AxisLocation axisLocation17 = combinedDomainXYPlot5.getRangeAxisLocation();
    combinedDomainXYPlot5.setBackgroundImageAlignment(255);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo22 = null;
    org.jfree.chart.axis.ValueAxis valueAxis23 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot24 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis23);
    java.util.List list25 = combinedDomainXYPlot24.getAnnotations();
    combinedDomainXYPlot24.setRangeGridlinesVisible(true);
    java.awt.geom.Rectangle2D rectangle2D28 = null;
    org.jfree.chart.util.RectangleAnchor rectangleAnchor29 = null;
    java.awt.geom.Point2D point2D30 = org.jfree.chart.util.RectangleAnchor.coordinates(rectangle2D28, rectangleAnchor29);
    combinedDomainXYPlot24.setQuadrantOrigin(point2D30);
    // The following exception was thrown during execution in test generation
    try {
      combinedDomainXYPlot5.zoomRangeAxes(0.0d, 1.0d, plotRenderingInfo22, point2D30);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point2D30);

  }

  @Test
  public void test135() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test135"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    boolean b31 = legendItem30.isShapeOutlineVisible();
    boolean b33 = legendItem30.equals((java.lang.Object)(short)1);
    java.awt.Paint paint34 = legendItem30.getFillPaint();
    legendItem30.setShapeVisible(true);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer38 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator39 = xYAreaRenderer38.getLegendItemToolTipGenerator();
    boolean b42 = xYAreaRenderer38.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition46 = xYAreaRenderer38.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b48 = xYAreaRenderer38.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator49 = null;
    xYAreaRenderer38.setBaseToolTipGenerator(xYToolTipGenerator49, true);
    java.awt.Shape shape53 = xYAreaRenderer38.lookupLegendShape(3);
    legendItem30.setLine(shape53);
    org.jfree.chart.util.ObjectList objectList55 = new org.jfree.chart.util.ObjectList();
    java.lang.Object obj56 = objectList55.clone();
    org.jfree.chart.axis.CategoryAxis categoryAxis57 = new org.jfree.chart.axis.CategoryAxis();
    int i58 = objectList55.indexOf((java.lang.Object)categoryAxis57);
    boolean b59 = legendItem30.equals((java.lang.Object)objectList55);
    objectList55.clear();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b42 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i58 == (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b59 == false);

  }

  @Test
  public void test136() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test136"); }


    org.jfree.chart.resources.JFreeChartResources jFreeChartResources0 = new org.jfree.chart.resources.JFreeChartResources();
    // The following exception was thrown during execution in test generation
    try {
      java.lang.String[] str_array2 = jFreeChartResources0.getStringArray("HorizontalAlignment.LEFT");
      org.junit.Assert.fail("Expected exception of type java.util.MissingResourceException");
    } catch (java.util.MissingResourceException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.util.MissingResourceException")) {
        org.junit.Assert.fail("Expected exception of type java.util.MissingResourceException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test137() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test137"); }


    java.awt.Color color5 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke6 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color7 = java.awt.Color.orange;
    java.awt.Stroke stroke8 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker10 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color5, stroke6, (java.awt.Paint)color7, stroke8, 0.0f);
    java.awt.Paint paint11 = intervalMarker10.getOutlinePaint();
    intervalMarker10.setEndValue(3.0d);
    java.lang.Class clazz14 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.util.EventListener[] eventListener_array15 = intervalMarker10.getListeners(clazz14);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint11);

  }

  @Test
  public void test138() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test138"); }


    java.awt.Font font2 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset3 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot4 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset3);
    org.jfree.chart.axis.ValueAxis valueAxis5 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot6 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis5);
    java.util.List list7 = combinedDomainXYPlot6.getAnnotations();
    waferMapPlot4.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot6);
    boolean b9 = combinedDomainXYPlot6.isNotify();
    org.jfree.chart.JFreeChart jFreeChart11 = new org.jfree.chart.JFreeChart("", font2, (org.jfree.chart.plot.Plot)combinedDomainXYPlot6, true);
    org.jfree.chart.title.TextTitle textTitle12 = new org.jfree.chart.title.TextTitle("", font2);
    boolean b13 = textTitle12.getExpandToFitSpace();
    boolean b14 = textTitle12.visible;
    double d15 = textTitle12.getContentXOffset();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d15 == 1.0d);

  }

  @Test
  public void test139() {}
// Defects4J: flaky method
//   @Test
//   public void test139() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test139"); }
// 
// 
//     org.jfree.data.time.Month month0 = new org.jfree.data.time.Month();
//     int i1 = month0.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem3 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month0, (java.lang.Number)8);
//     java.awt.Shape shape11 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
//     java.awt.Color color13 = java.awt.Color.green;
//     java.awt.Color color15 = java.awt.Color.green;
//     java.awt.Color color21 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
//     java.awt.Stroke stroke22 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
//     java.awt.Color color23 = java.awt.Color.orange;
//     java.awt.Stroke stroke24 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
//     org.jfree.chart.plot.IntervalMarker intervalMarker26 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color21, stroke22, (java.awt.Paint)color23, stroke24, 0.0f);
//     java.awt.Shape shape30 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
//     java.awt.Stroke stroke31 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
//     java.awt.Color color32 = java.awt.Color.green;
//     java.lang.String str33 = org.jfree.chart.util.PaintUtilities.colorToString(color32);
//     org.jfree.chart.LegendItem legendItem34 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape11, true, (java.awt.Paint)color13, false, (java.awt.Paint)color15, stroke22, true, shape30, stroke31, (java.awt.Paint)color32);
//     java.awt.Font font36 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
//     org.jfree.data.general.WaferMapDataset waferMapDataset37 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot38 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset37);
//     org.jfree.chart.axis.ValueAxis valueAxis39 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot40 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis39);
//     java.util.List list41 = combinedDomainXYPlot40.getAnnotations();
//     waferMapPlot38.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot40);
//     boolean b43 = combinedDomainXYPlot40.isNotify();
//     org.jfree.chart.JFreeChart jFreeChart45 = new org.jfree.chart.JFreeChart("", font36, (org.jfree.chart.plot.Plot)combinedDomainXYPlot40, true);
//     java.awt.Stroke stroke46 = jFreeChart45.getBorderStroke();
//     boolean b47 = jFreeChart45.isBorderVisible();
//     java.awt.Image image48 = null;
//     jFreeChart45.setBackgroundImage(image48);
//     org.jfree.chart.entity.JFreeChartEntity jFreeChartEntity51 = new org.jfree.chart.entity.JFreeChartEntity(shape11, jFreeChart45, "hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!");
//     org.jfree.chart.event.ChartChangeEventType chartChangeEventType52 = null;
//     org.jfree.chart.event.ChartChangeEvent chartChangeEvent53 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)8, jFreeChart45, chartChangeEventType52);
//     org.jfree.chart.title.LegendTitle legendTitle55 = jFreeChart45.getLegend(12);
//     // The following exception was thrown during execution in test generation
//     try {
//       org.jfree.chart.plot.CategoryPlot categoryPlot56 = jFreeChart45.getCategoryPlot();
//       org.junit.Assert.fail("Expected exception of type java.lang.ClassCastException");
//     } catch (java.lang.ClassCastException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.ClassCastException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.ClassCastException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i1 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(shape11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color21);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color23);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke24);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(shape30);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke31);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color32);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str33 + "' != '" + "green"+ "'", str33.equals("green"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(font36);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list41);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b43 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke46);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b47 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(legendTitle55);
// 
//   }

  @Test
  public void test140() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test140"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    java.awt.Graphics2D graphics2D4 = null;
    java.awt.geom.Rectangle2D rectangle2D5 = null;
    org.jfree.data.general.DefaultPieDataset defaultPieDataset6 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj7 = defaultPieDataset6.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D8 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset6);
    piePlot3D8.setIgnoreZeroValues(true);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo12 = null;
    org.jfree.chart.plot.PiePlotState piePlotState13 = piePlot3D2.initialise(graphics2D4, rectangle2D5, (org.jfree.chart.plot.PiePlot)piePlot3D8, (java.lang.Integer)1, plotRenderingInfo12);
    org.jfree.chart.labels.PieSectionLabelGenerator pieSectionLabelGenerator14 = piePlot3D8.getLegendLabelToolTipGenerator();
    org.jfree.chart.util.RectangleInsets rectangleInsets15 = piePlot3D8.getSimpleLabelOffset();
    java.awt.Paint paint16 = piePlot3D8.getLabelPaint();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(piePlotState13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(pieSectionLabelGenerator14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint16);

  }

  @Test
  public void test141() {}
// Defects4J: flaky method
//   @Test
//   public void test141() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test141"); }
// 
// 
//     org.jfree.data.time.Month month1 = new org.jfree.data.time.Month();
//     int i2 = month1.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem4 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month1, (java.lang.Number)8);
//     long long5 = month1.getFirstMillisecond();
//     org.jfree.data.time.Month month6 = new org.jfree.data.time.Month();
//     int i7 = month6.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis8 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month1, (org.jfree.data.time.RegularTimePeriod)month6);
//     periodAxis8.setUpperMargin(10.0d);
//     org.jfree.data.Range range11 = periodAxis8.getRange();
//     org.jfree.chart.util.RectangleInsets rectangleInsets12 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
//     double d13 = rectangleInsets12.getLeft();
//     double d15 = rectangleInsets12.calculateLeftOutset(1.0d);
//     double d17 = rectangleInsets12.calculateRightInset(0.05d);
//     periodAxis8.setLabelInsets(rectangleInsets12);
//     java.awt.geom.Rectangle2D rectangle2D19 = null;
//     java.awt.Color color25 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
//     java.awt.Stroke stroke26 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
//     java.awt.Color color27 = java.awt.Color.orange;
//     java.awt.Stroke stroke28 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
//     org.jfree.chart.plot.IntervalMarker intervalMarker30 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color25, stroke26, (java.awt.Paint)color27, stroke28, 0.0f);
//     org.jfree.chart.util.LengthAdjustmentType lengthAdjustmentType31 = intervalMarker30.getLabelOffsetType();
//     org.jfree.data.xy.XYSeries xYSeries32 = null;
//     org.jfree.data.xy.XYSeriesCollection xYSeriesCollection33 = new org.jfree.data.xy.XYSeriesCollection(xYSeries32);
//     double d35 = xYSeriesCollection33.getDomainUpperBound(false);
//     java.util.List list36 = xYSeriesCollection33.getSeries();
//     java.lang.Object obj37 = xYSeriesCollection33.clone();
//     boolean b38 = lengthAdjustmentType31.equals(obj37);
//     java.awt.Color color44 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
//     java.awt.Stroke stroke45 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
//     java.awt.Color color46 = java.awt.Color.orange;
//     java.awt.Stroke stroke47 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
//     org.jfree.chart.plot.IntervalMarker intervalMarker49 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color44, stroke45, (java.awt.Paint)color46, stroke47, 0.0f);
//     org.jfree.chart.util.LengthAdjustmentType lengthAdjustmentType50 = intervalMarker49.getLabelOffsetType();
//     // The following exception was thrown during execution in test generation
//     try {
//       java.awt.geom.Rectangle2D rectangle2D51 = rectangleInsets12.createAdjustedRectangle(rectangle2D19, lengthAdjustmentType31, lengthAdjustmentType50);
//       org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
//     } catch (java.lang.IllegalArgumentException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i2 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i7 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(range11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d13 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d15 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d17 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke26);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke28);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(lengthAdjustmentType31);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertEquals((double)d35, Double.NaN, 0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list36);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj37);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b38 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color44);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke45);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color46);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke47);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(lengthAdjustmentType50);
// 
//   }

  @Test
  public void test142() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test142"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    boolean b1 = xYStepRenderer0.getUseFillPaint();
    xYStepRenderer0.setDrawSeriesLineAsPath(false);
    java.awt.Paint paint7 = xYStepRenderer0.getItemFillPaint(2, 8, false);
    java.awt.Graphics2D graphics2D8 = null;
    java.awt.geom.Rectangle2D rectangle2D9 = null;
    org.jfree.chart.plot.XYPlot xYPlot10 = null;
    org.jfree.data.general.WaferMapDataset waferMapDataset11 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot12 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset11);
    org.jfree.chart.JFreeChart jFreeChart13 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent14 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot12, jFreeChart13);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment15 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment16 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement19 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment15, verticalAlignment16, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement20 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle21 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot12, (org.jfree.chart.block.Arrangement)flowArrangement19, (org.jfree.chart.block.Arrangement)borderArrangement20);
    org.jfree.data.time.TimeSeries timeSeries22 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection23 = new org.jfree.data.time.TimeSeriesCollection(timeSeries22);
    timeSeriesCollection23.validateObject();
    java.lang.Comparable comparable25 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer26 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement19, (org.jfree.data.general.Dataset)timeSeriesCollection23, comparable25);
    timeSeriesCollection23.validateObject();
    org.jfree.chart.axis.ValueAxis valueAxis28 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot29 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis28);
    org.jfree.chart.plot.PlotOrientation plotOrientation30 = combinedDomainXYPlot29.getOrientation();
    boolean b31 = combinedDomainXYPlot29.isDomainCrosshairLockedOnData();
    org.jfree.chart.entity.EntityCollection entityCollection33 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo34 = new org.jfree.chart.ChartRenderingInfo(entityCollection33);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo35 = chartRenderingInfo34.getPlotInfo();
    java.awt.geom.Point2D point2D36 = null;
    combinedDomainXYPlot29.panDomainAxes(4.5d, plotRenderingInfo35, point2D36);
    int i38 = plotRenderingInfo35.getSubplotCount();
    org.jfree.chart.entity.EntityCollection entityCollection39 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo40 = new org.jfree.chart.ChartRenderingInfo(entityCollection39);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo41 = chartRenderingInfo40.getPlotInfo();
    plotRenderingInfo35.addSubplotInfo(plotRenderingInfo41);
    org.jfree.chart.renderer.xy.XYItemRendererState xYItemRendererState43 = xYStepRenderer0.initialise(graphics2D8, rectangle2D9, xYPlot10, (org.jfree.data.xy.XYDataset)timeSeriesCollection23, plotRenderingInfo41);
    // The following exception was thrown during execution in test generation
    try {
      double d46 = timeSeriesCollection23.getXValue(15, 0);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i38 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(xYItemRendererState43);

  }

  @Test
  public void test143() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test143"); }


    org.jfree.data.time.TimePeriodAnchor timePeriodAnchor0 = org.jfree.data.time.TimePeriodAnchor.END;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(timePeriodAnchor0);

  }

  @Test
  public void test144() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test144"); }


    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator0 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator4 = new org.jfree.chart.urls.StandardXYURLGenerator("", "hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!", "");
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer5 = new org.jfree.chart.renderer.xy.XYStepRenderer((org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator0, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator4);
    java.lang.String str6 = standardXYToolTipGenerator0.getNullYString();
    java.lang.String str7 = standardXYToolTipGenerator0.getFormatString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "null"+ "'", str6.equals("null"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str7 + "' != '" + "{0}: ({1}, {2})"+ "'", str7.equals("{0}: ({1}, {2})"));

  }

  @Test
  public void test145() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test145"); }


    java.awt.Color color5 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke6 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color7 = java.awt.Color.orange;
    java.awt.Stroke stroke8 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker10 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color5, stroke6, (java.awt.Paint)color7, stroke8, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer11 = null;
    intervalMarker10.setGradientPaintTransformer(gradientPaintTransformer11);
    org.jfree.chart.util.RectangleInsets rectangleInsets13 = intervalMarker10.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis15 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets16 = categoryAxis15.getLabelInsets();
    intervalMarker10.setLabelOffset(rectangleInsets16);
    double d18 = intervalMarker10.getEndValue();
    java.awt.Font font20 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset21 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot22 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset21);
    org.jfree.chart.axis.ValueAxis valueAxis23 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot24 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis23);
    java.util.List list25 = combinedDomainXYPlot24.getAnnotations();
    waferMapPlot22.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot24);
    boolean b27 = combinedDomainXYPlot24.isNotify();
    org.jfree.chart.JFreeChart jFreeChart29 = new org.jfree.chart.JFreeChart("", font20, (org.jfree.chart.plot.Plot)combinedDomainXYPlot24, true);
    intervalMarker10.setLabelFont(font20);
    java.lang.Class clazz31 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.util.EventListener[] eventListener_array32 = intervalMarker10.getListeners(clazz31);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d18 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == true);

  }

  @Test
  public void test146() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test146"); }


    org.jfree.chart.util.RectangleAnchor rectangleAnchor0 = org.jfree.chart.util.RectangleAnchor.TOP_RIGHT;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleAnchor0);

  }

  @Test
  public void test147() {}
// Defects4J: flaky method
//   @Test
//   public void test147() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test147"); }
// 
// 
//     org.jfree.data.time.DateRange dateRange3 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d4 = dateRange3.getLength();
//     long long5 = dateRange3.getLowerMillis();
//     double d6 = dateRange3.getLength();
//     java.lang.String str7 = dateRange3.toString();
//     java.util.Date date8 = dateRange3.getUpperDate();
//     java.util.TimeZone timeZone9 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year10 = new org.jfree.data.time.Year(date8, timeZone9);
//     org.jfree.chart.axis.DateAxis dateAxis11 = new org.jfree.chart.axis.DateAxis("SerialDate.weekInMonthToString(): invalid code.", timeZone9);
//     org.jfree.data.Range range12 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       dateAxis11.setRange(range12);
//       org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
//     } catch (java.lang.IllegalArgumentException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d4 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d6 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str7 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str7.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone9);
// 
//   }

  @Test
  public void test148() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test148"); }


    org.jfree.data.time.SerialDate serialDate1 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.SerialDate serialDate2 = org.jfree.data.time.SerialDate.addMonths(14, serialDate1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test149() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test149"); }


    org.jfree.chart.text.TextBlock textBlock0 = new org.jfree.chart.text.TextBlock();
    org.jfree.chart.text.TextLine textLine2 = new org.jfree.chart.text.TextLine("March");
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment18 = new org.jfree.chart.text.TextFragment("hi!", font5, (java.awt.Paint)color17);
    textLine2.addFragment(textFragment18);
    textBlock0.addLine(textLine2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment21 = null;
    // The following exception was thrown during execution in test generation
    try {
      textBlock0.setLineAlignment(horizontalAlignment21);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);

  }

  @Test
  public void test150() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test150"); }


    org.jfree.chart.axis.NumberAxis3D numberAxis3D0 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Paint paint1 = org.jfree.chart.axis.Axis.DEFAULT_AXIS_LINE_PAINT;
    numberAxis3D0.setLabelPaint(paint1);
    java.text.NumberFormat numberFormat3 = numberAxis3D0.getNumberFormatOverride();
    numberAxis3D0.setFixedAutoRange(10.0d);
    java.awt.geom.Rectangle2D rectangle2D7 = null;
    org.jfree.chart.axis.AxisSpace axisSpace8 = new org.jfree.chart.axis.AxisSpace();
    org.jfree.data.DomainOrder domainOrder9 = org.jfree.data.DomainOrder.DESCENDING;
    boolean b10 = axisSpace8.equals((java.lang.Object)domainOrder9);
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D13 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke14 = categoryAxis3D13.getTickMarkStroke();
    java.awt.Graphics2D graphics2D15 = null;
    java.awt.geom.Rectangle2D rectangle2D17 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge18 = org.jfree.chart.util.RectangleEdge.LEFT;
    org.jfree.chart.axis.AxisState axisState20 = new org.jfree.chart.axis.AxisState(1.0d);
    double d21 = axisState20.getCursor();
    axisState20.cursorLeft(0.2d);
    categoryAxis3D13.drawTickMarks(graphics2D15, 7.0d, rectangle2D17, rectangleEdge18, axisState20);
    axisSpace8.ensureAtLeast(6.0d, rectangleEdge18);
    org.jfree.chart.util.RectangleEdge rectangleEdge26 = org.jfree.chart.util.RectangleEdge.opposite(rectangleEdge18);
    // The following exception was thrown during execution in test generation
    try {
      double d27 = numberAxis3D0.java2DToValue(100.0d, rectangle2D7, rectangleEdge18);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(numberFormat3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d21 == 1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge26);

  }

  @Test
  public void test151() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test151"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = xYStepRenderer0.getSeriesPositiveItemLabelPosition(3);
    org.jfree.chart.text.TextAnchor textAnchor3 = itemLabelPosition2.getRotationAnchor();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer5 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier6 = xYAreaRenderer5.getDrawingSupplier();
    xYAreaRenderer5.setBaseCreateEntities(false);
    org.jfree.chart.event.RendererChangeEvent rendererChangeEvent9 = null;
    xYAreaRenderer5.notifyListeners(rendererChangeEvent9);
    boolean b11 = itemLabelPosition2.equals((java.lang.Object)rendererChangeEvent9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textAnchor3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);

  }

  @Test
  public void test152() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test152"); }


    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D1 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke2 = categoryAxis3D1.getTickMarkStroke();
    java.awt.Stroke stroke3 = org.jfree.chart.plot.CategoryPlot.DEFAULT_CROSSHAIR_STROKE;
    categoryAxis3D1.setAxisLineStroke(stroke3);
    categoryAxis3D1.clearCategoryLabelToolTips();
    java.awt.Graphics2D graphics2D6 = null;
    java.awt.geom.Rectangle2D rectangle2D8 = null;
    java.awt.geom.Rectangle2D rectangle2D9 = null;
    org.jfree.chart.axis.CategoryAxis categoryAxis10 = new org.jfree.chart.axis.CategoryAxis();
    categoryAxis10.setVisible(false);
    org.jfree.chart.util.RectangleInsets rectangleInsets13 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d14 = rectangleInsets13.getLeft();
    double d16 = rectangleInsets13.calculateLeftOutset(1.0d);
    categoryAxis10.setLabelInsets(rectangleInsets13, true);
    float f19 = categoryAxis10.getTickMarkOutsideLength();
    org.jfree.chart.axis.CategoryAnchor categoryAnchor20 = null;
    java.awt.geom.Rectangle2D rectangle2D23 = null;
    org.jfree.data.general.WaferMapDataset waferMapDataset24 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot25 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset24);
    org.jfree.chart.JFreeChart jFreeChart26 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent27 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot25, jFreeChart26);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment28 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment29 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement32 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment28, verticalAlignment29, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement33 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle34 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot25, (org.jfree.chart.block.Arrangement)flowArrangement32, (org.jfree.chart.block.Arrangement)borderArrangement33);
    org.jfree.chart.plot.CategoryPlot categoryPlot35 = new org.jfree.chart.plot.CategoryPlot();
    boolean b36 = categoryPlot35.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge38 = categoryPlot35.getDomainAxisEdge(8);
    legendTitle34.setPosition(rectangleEdge38);
    double d40 = categoryAxis10.getCategoryJava2DCoordinate(categoryAnchor20, 4, 255, rectangle2D23, rectangleEdge38);
    org.jfree.chart.axis.ValueAxis valueAxis41 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot42 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis41);
    org.jfree.chart.plot.PlotOrientation plotOrientation43 = combinedDomainXYPlot42.getOrientation();
    boolean b44 = combinedDomainXYPlot42.isDomainCrosshairLockedOnData();
    org.jfree.chart.entity.EntityCollection entityCollection46 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo47 = new org.jfree.chart.ChartRenderingInfo(entityCollection46);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo48 = chartRenderingInfo47.getPlotInfo();
    java.awt.geom.Point2D point2D49 = null;
    combinedDomainXYPlot42.panDomainAxes(4.5d, plotRenderingInfo48, point2D49);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.axis.AxisState axisState51 = categoryAxis3D1.draw(graphics2D6, 10.0d, rectangle2D8, rectangle2D9, rectangleEdge38, plotRenderingInfo48);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d16 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f19 == 2.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d40 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo48);

  }

  @Test
  public void test153() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test153"); }


    org.jfree.data.xy.XYDataset xYDataset0 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number1 = org.jfree.data.general.DatasetUtilities.findMaximumDomainValue(xYDataset0);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test154() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test154"); }


    java.lang.Comparable comparable0 = null;
    org.jfree.data.general.DefaultPieDataset defaultPieDataset1 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj2 = defaultPieDataset1.clone();
    java.lang.Number number4 = null;
    defaultPieDataset1.setValue((java.lang.Comparable)6.0d, number4);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.category.CategoryDataset categoryDataset6 = org.jfree.data.general.DatasetUtilities.createCategoryDataset(comparable0, (org.jfree.data.KeyedValues)defaultPieDataset1);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj2);

  }

  @Test
  public void test155() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test155"); }


    org.jfree.chart.plot.SeriesRenderingOrder seriesRenderingOrder0 = org.jfree.chart.plot.SeriesRenderingOrder.REVERSE;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(seriesRenderingOrder0);

  }

  @Test
  public void test156() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test156"); }


    org.jfree.chart.axis.NumberAxis numberAxis0 = new org.jfree.chart.axis.NumberAxis();
    numberAxis0.configure();
    org.jfree.chart.axis.NumberAxis numberAxis2 = new org.jfree.chart.axis.NumberAxis();
    numberAxis2.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer6 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator7 = xYAreaRenderer6.getLegendItemToolTipGenerator();
    java.awt.Shape shape8 = xYAreaRenderer6.getBaseShape();
    numberAxis2.setUpArrow(shape8);
    org.jfree.chart.StandardChartTheme standardChartTheme15 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.renderer.category.BarPainter barPainter16 = standardChartTheme15.getBarPainter();
    java.awt.Font font17 = standardChartTheme15.getLargeFont();
    org.jfree.chart.axis.MarkerAxisBand markerAxisBand18 = new org.jfree.chart.axis.MarkerAxisBand(numberAxis2, 0.2d, 12.0d, 0.0d, 4.5d, font17);
    java.awt.Graphics2D graphics2D19 = null;
    java.awt.geom.Rectangle2D rectangle2D20 = null;
    java.awt.geom.Rectangle2D rectangle2D21 = null;
    markerAxisBand18.draw(graphics2D19, rectangle2D20, rectangle2D21, 0.6d, 0.0d);
    numberAxis0.setMarkerBand(markerAxisBand18);
    java.awt.Graphics2D graphics2D26 = null;
    java.awt.geom.Rectangle2D rectangle2D27 = null;
    java.awt.geom.Rectangle2D rectangle2D28 = null;
    markerAxisBand18.draw(graphics2D26, rectangle2D27, rectangle2D28, 0.5d, 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(barPainter16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font17);

  }

  @Test
  public void test157() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test157"); }


    int i0 = org.jfree.data.time.SerialDate.FRIDAY;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 6);

  }

  @Test
  public void test158() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test158"); }


    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator3 = new org.jfree.chart.urls.StandardXYURLGenerator("Combined_Domain_XYPlot", "RectangleAnchor.BOTTOM_RIGHT", "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]");

  }

  @Test
  public void test159() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test159"); }


    org.jfree.chart.axis.TickType tickType0 = org.jfree.chart.axis.TickType.MINOR;
    java.lang.String str1 = tickType0.toString();
    java.awt.Font font3 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset4 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot5 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset4);
    org.jfree.chart.axis.ValueAxis valueAxis6 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot7 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis6);
    java.util.List list8 = combinedDomainXYPlot7.getAnnotations();
    waferMapPlot5.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot7);
    boolean b10 = combinedDomainXYPlot7.isNotify();
    org.jfree.chart.JFreeChart jFreeChart12 = new org.jfree.chart.JFreeChart("", font3, (org.jfree.chart.plot.Plot)combinedDomainXYPlot7, true);
    java.awt.Stroke stroke13 = jFreeChart12.getBorderStroke();
    java.awt.Paint[] paint_array14 = null;
    org.jfree.chart.axis.ValueAxis valueAxis15 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot16 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis15);
    java.util.List list17 = combinedDomainXYPlot16.getAnnotations();
    combinedDomainXYPlot16.setRangeGridlinesVisible(true);
    java.awt.Color color20 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    combinedDomainXYPlot16.setRangeTickBandPaint((java.awt.Paint)color20);
    java.awt.Paint[] paint_array22 = new java.awt.Paint[] { color20 };
    java.awt.Shape shape30 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color32 = java.awt.Color.green;
    java.awt.Color color34 = java.awt.Color.green;
    java.awt.Color color40 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke41 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color42 = java.awt.Color.orange;
    java.awt.Stroke stroke43 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker45 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color40, stroke41, (java.awt.Paint)color42, stroke43, 0.0f);
    java.awt.Shape shape49 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke50 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color51 = java.awt.Color.green;
    java.lang.String str52 = org.jfree.chart.util.PaintUtilities.colorToString(color51);
    org.jfree.chart.LegendItem legendItem53 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape30, true, (java.awt.Paint)color32, false, (java.awt.Paint)color34, stroke41, true, shape49, stroke50, (java.awt.Paint)color51);
    java.awt.Paint[] paint_array54 = new java.awt.Paint[] { color32 };
    java.awt.Stroke[] stroke_array55 = null;
    java.awt.Stroke stroke56 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Stroke[] stroke_array57 = new java.awt.Stroke[] { stroke56 };
    java.awt.Shape shape60 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Shape[] shape_array61 = new java.awt.Shape[] { shape60 };
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier62 = new org.jfree.chart.plot.DefaultDrawingSupplier(paint_array14, paint_array22, paint_array54, stroke_array55, stroke_array57, shape_array61);
    java.awt.Paint paint63 = defaultDrawingSupplier62.getNextOutlinePaint();
    jFreeChart12.setBackgroundPaint(paint63);
    boolean b65 = tickType0.equals((java.lang.Object)jFreeChart12);
    java.lang.String str66 = tickType0.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(tickType0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "MINOR"+ "'", str1.equals("MINOR"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str52 + "' != '" + "green"+ "'", str52.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint_array54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke_array57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape_array61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b65 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str66 + "' != '" + "MINOR"+ "'", str66.equals("MINOR"));

  }

  @Test
  public void test160() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test160"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = xYStepRenderer0.getSeriesPositiveItemLabelPosition(3);
    org.jfree.chart.axis.CategoryAxis categoryAxis4 = new org.jfree.chart.axis.CategoryAxis("");
    boolean b5 = xYStepRenderer0.equals((java.lang.Object)"");
    org.jfree.chart.plot.XYPlot xYPlot6 = xYStepRenderer0.getPlot();
    boolean b7 = xYStepRenderer0.getDrawSeriesLineAsPath();
    // The following exception was thrown during execution in test generation
    try {
      xYStepRenderer0.setSeriesLinesVisible((-1), true);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYPlot6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);

  }

  @Test
  public void test161() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test161"); }


    org.jfree.chart.axis.LogAxis logAxis1 = new org.jfree.chart.axis.LogAxis("ClassContext");
    logAxis1.zoomRange(0.0d, 4.5d);
    java.awt.Graphics2D graphics2D5 = null;
    org.jfree.chart.axis.AxisState axisState7 = new org.jfree.chart.axis.AxisState(7.0d);
    java.awt.geom.Rectangle2D rectangle2D8 = null;
    org.jfree.chart.plot.CategoryPlot categoryPlot9 = new org.jfree.chart.plot.CategoryPlot();
    boolean b10 = categoryPlot9.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge12 = categoryPlot9.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis14 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets15 = categoryAxis14.getLabelInsets();
    double d17 = rectangleInsets15.calculateLeftInset(4.0d);
    categoryPlot9.setInsets(rectangleInsets15, false);
    java.awt.Font font21 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset22 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot23 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset22);
    org.jfree.chart.axis.ValueAxis valueAxis24 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot25 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis24);
    java.util.List list26 = combinedDomainXYPlot25.getAnnotations();
    waferMapPlot23.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot25);
    boolean b28 = combinedDomainXYPlot25.isNotify();
    org.jfree.chart.JFreeChart jFreeChart30 = new org.jfree.chart.JFreeChart("", font21, (org.jfree.chart.plot.Plot)combinedDomainXYPlot25, true);
    combinedDomainXYPlot25.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.axis.AxisLocation axisLocation34 = null;
    combinedDomainXYPlot25.setDomainAxisLocation(3, axisLocation34, false);
    org.jfree.chart.axis.AxisLocation axisLocation37 = combinedDomainXYPlot25.getRangeAxisLocation();
    categoryPlot9.setDomainAxisLocation(axisLocation37);
    org.jfree.chart.plot.PlotOrientation plotOrientation39 = org.jfree.chart.plot.PlotOrientation.VERTICAL;
    org.jfree.chart.util.RectangleEdge rectangleEdge40 = org.jfree.chart.plot.Plot.resolveRangeAxisLocation(axisLocation37, plotOrientation39);
    // The following exception was thrown during execution in test generation
    try {
      java.util.List list41 = logAxis1.refreshTicks(graphics2D5, axisState7, rectangle2D8, rectangleEdge40);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d17 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge40);

  }

  @Test
  public void test162() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test162"); }


    org.jfree.chart.axis.NumberAxis numberAxis0 = new org.jfree.chart.axis.NumberAxis();
    numberAxis0.centerRange(100.0d);
    org.jfree.data.Range range3 = null;
    // The following exception was thrown during execution in test generation
    try {
      numberAxis0.setDefaultAutoRange(range3);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test163() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test163"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    org.jfree.chart.JFreeChart jFreeChart9 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    org.jfree.chart.axis.NumberAxis numberAxis11 = new org.jfree.chart.axis.NumberAxis();
    numberAxis11.centerRange(100.0d);
    combinedDomainXYPlot5.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis11);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier15 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot5.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier15);
    org.jfree.chart.LegendItemCollection legendItemCollection17 = combinedDomainXYPlot5.getLegendItems();
    java.lang.Object obj18 = legendItemCollection17.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj18);

  }

  @Test
  public void test164() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test164"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis1 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets2 = categoryAxis1.getLabelInsets();
    double d4 = rectangleInsets2.calculateRightInset((-1.0d));
    double d6 = rectangleInsets2.calculateTopOutset(0.0d);
    java.awt.geom.Rectangle2D rectangle2D7 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.awt.geom.Rectangle2D rectangle2D8 = rectangleInsets2.createInsetRectangle(rectangle2D7);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 3.0d);

  }

  @Test
  public void test165() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test165"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    org.jfree.chart.plot.Plot plot2 = combinedDomainXYPlot1.getRootPlot();
    combinedDomainXYPlot1.setWeight(1);
    org.jfree.chart.entity.EntityCollection entityCollection5 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo6 = new org.jfree.chart.ChartRenderingInfo(entityCollection5);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo7 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo6);
    int i8 = plotRenderingInfo7.getSubplotCount();
    java.awt.geom.Point2D point2D9 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.plot.XYPlot xYPlot10 = combinedDomainXYPlot1.findSubplot(plotRenderingInfo7, point2D9);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i8 == 0);

  }

  @Test
  public void test166() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test166"); }


    org.jfree.chart.axis.AxisLocation axisLocation0 = org.jfree.chart.axis.AxisLocation.TOP_OR_RIGHT;
    org.jfree.chart.axis.AxisLocation axisLocation1 = axisLocation0.getOpposite();
    java.lang.String str2 = axisLocation1.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str2 + "' != '" + "AxisLocation.BOTTOM_OR_LEFT"+ "'", str2.equals("AxisLocation.BOTTOM_OR_LEFT"));

  }

  @Test
  public void test167() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test167"); }


    org.jfree.chart.util.LogFormat logFormat5 = new org.jfree.chart.util.LogFormat(12.0d, "{0}: ({1}, {2})", true);
    int i6 = logFormat5.getMaximumIntegerDigits();
    org.jfree.chart.util.LogFormat logFormat10 = new org.jfree.chart.util.LogFormat(12.0d, "{0}: ({1}, {2})", true);
    java.lang.StringBuffer stringBuffer12 = null;
    java.text.FieldPosition fieldPosition13 = null;
    java.lang.StringBuffer stringBuffer14 = logFormat10.format(6.0d, stringBuffer12, fieldPosition13);
    int i15 = logFormat10.getMinimumIntegerDigits();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator16 = new org.jfree.chart.labels.StandardXYToolTipGenerator("?hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!=-1&amp;=14", (java.text.NumberFormat)logFormat5, (java.text.NumberFormat)logFormat10);
    org.jfree.chart.util.LogFormat logFormat20 = new org.jfree.chart.util.LogFormat(10.0d, "", true);
    java.lang.String str22 = logFormat20.format((java.lang.Object)100.0f);
    int i23 = logFormat20.getMinimumFractionDigits();
    logFormat20.setMinimumIntegerDigits(100);
    java.text.NumberFormat numberFormat26 = logFormat20.getExponentFormat();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator27 = new org.jfree.chart.labels.StandardXYToolTipGenerator("ThreadContext", (java.text.NumberFormat)logFormat10, (java.text.NumberFormat)logFormat20);
    org.jfree.chart.util.GradientPaintTransformType gradientPaintTransformType28 = org.jfree.chart.util.GradientPaintTransformType.CENTER_VERTICAL;
    org.jfree.chart.axis.CategoryAxis categoryAxis29 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset30 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot31 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset30);
    org.jfree.chart.axis.ValueAxis valueAxis32 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot33 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis32);
    java.util.List list34 = combinedDomainXYPlot33.getAnnotations();
    waferMapPlot31.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot33);
    int i36 = combinedDomainXYPlot33.getSeriesCount();
    categoryAxis29.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot33);
    java.awt.Color color44 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke45 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color46 = java.awt.Color.orange;
    java.awt.Stroke stroke47 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker49 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color44, stroke45, (java.awt.Paint)color46, stroke47, 0.0f);
    java.awt.Paint paint50 = intervalMarker49.getOutlinePaint();
    org.jfree.chart.util.Layer layer51 = null;
    combinedDomainXYPlot33.addRangeMarker(0, (org.jfree.chart.plot.Marker)intervalMarker49, layer51);
    org.jfree.chart.axis.AxisLocation axisLocation53 = combinedDomainXYPlot33.getDomainAxisLocation();
    boolean b54 = gradientPaintTransformType28.equals((java.lang.Object)axisLocation53);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.String str55 = logFormat20.format((java.lang.Object)b54);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stringBuffer14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i15 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str22 + "' != '" + "^2.0"+ "'", str22.equals("^2.0"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i23 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(gradientPaintTransformType28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i36 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b54 == false);

  }

  @Test
  public void test168() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test168"); }


    org.jfree.chart.text.TextBlockAnchor textBlockAnchor0 = org.jfree.chart.text.TextBlockAnchor.CENTER;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textBlockAnchor0);

  }

  @Test
  public void test169() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test169"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.axis.ValueAxis valueAxis2 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot3 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis2);
    java.util.List list4 = combinedDomainXYPlot3.getAnnotations();
    waferMapPlot1.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot3);
    boolean b6 = combinedDomainXYPlot3.isRangeCrosshairVisible();
    org.jfree.chart.axis.ValueAxis valueAxis7 = combinedDomainXYPlot3.getRangeAxis();
    org.jfree.data.xy.XYDataset xYDataset9 = combinedDomainXYPlot3.getDataset((-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(valueAxis7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYDataset9);

  }

  @Test
  public void test170() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test170"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis1 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    int i8 = combinedDomainXYPlot5.getSeriesCount();
    categoryAxis1.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot5);
    java.awt.Color color16 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke17 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color18 = java.awt.Color.orange;
    java.awt.Stroke stroke19 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker21 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color16, stroke17, (java.awt.Paint)color18, stroke19, 0.0f);
    java.awt.Paint paint22 = intervalMarker21.getOutlinePaint();
    org.jfree.chart.util.Layer layer23 = null;
    combinedDomainXYPlot5.addRangeMarker(0, (org.jfree.chart.plot.Marker)intervalMarker21, layer23);
    org.jfree.chart.axis.AxisLocation axisLocation25 = combinedDomainXYPlot5.getDomainAxisLocation();
    java.awt.Color color26 = java.awt.Color.RED;
    combinedDomainXYPlot5.setDomainTickBandPaint((java.awt.Paint)color26);
    int i28 = color26.getAlpha();
    java.awt.Color color29 = java.awt.Color.getColor("EXPAND", color26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i8 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i28 == 255);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color29);

  }

  @Test
  public void test171() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test171"); }


    org.jfree.chart.renderer.category.BarRenderer barRenderer0 = new org.jfree.chart.renderer.category.BarRenderer();
    double d1 = barRenderer0.getShadowXOffset();
    barRenderer0.setShadowXOffset(10.0d);
    boolean b4 = barRenderer0.getIncludeBaseInRange();
    java.awt.Graphics2D graphics2D5 = null;
    java.awt.geom.Rectangle2D rectangle2D6 = null;
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D8 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    org.jfree.chart.axis.NumberAxis3D numberAxis3D9 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Paint paint10 = org.jfree.chart.axis.Axis.DEFAULT_AXIS_LINE_PAINT;
    numberAxis3D9.setLabelPaint(paint10);
    numberAxis3D9.setTickMarksVisible(true);
    org.jfree.chart.util.Layer layer14 = org.jfree.chart.util.Layer.FOREGROUND;
    org.jfree.chart.plot.CategoryPlot categoryPlot15 = new org.jfree.chart.plot.CategoryPlot();
    boolean b16 = categoryPlot15.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge18 = categoryPlot15.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis20 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets21 = categoryAxis20.getLabelInsets();
    double d23 = rectangleInsets21.calculateLeftInset(4.0d);
    categoryPlot15.setInsets(rectangleInsets21, false);
    int i26 = categoryPlot15.getRendererCount();
    org.jfree.chart.axis.NumberAxis numberAxis27 = new org.jfree.chart.axis.NumberAxis();
    numberAxis27.centerRange(100.0d);
    java.awt.Paint paint30 = numberAxis27.getLabelPaint();
    categoryPlot15.setRangeCrosshairPaint(paint30);
    org.jfree.chart.entity.EntityCollection entityCollection33 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo34 = new org.jfree.chart.ChartRenderingInfo(entityCollection33);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo35 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo34);
    java.awt.geom.Point2D point2D36 = null;
    categoryPlot15.panRangeAxes(0.6d, plotRenderingInfo35, point2D36);
    barRenderer0.drawAnnotations(graphics2D5, rectangle2D6, (org.jfree.chart.axis.CategoryAxis)categoryAxis3D8, (org.jfree.chart.axis.ValueAxis)numberAxis3D9, layer14, plotRenderingInfo35);
    java.awt.Graphics2D graphics2D39 = null;
    org.jfree.chart.plot.CategoryPlot categoryPlot40 = new org.jfree.chart.plot.CategoryPlot();
    boolean b41 = categoryPlot40.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge43 = categoryPlot40.getDomainAxisEdge(8);
    categoryPlot40.clearDomainMarkers();
    categoryPlot40.setDomainGridlinesVisible(false);
    java.awt.geom.Rectangle2D rectangle2D47 = null;
    // The following exception was thrown during execution in test generation
    try {
      barRenderer0.drawOutline(graphics2D39, categoryPlot40, rectangle2D47);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(layer14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d23 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i26 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge43);

  }

  @Test
  public void test172() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test172"); }


    int i1 = org.jfree.data.time.SerialDate.stringToMonthCode("TitleEntity: tooltip = green");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == (-1));

  }

  @Test
  public void test173() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test173"); }


    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator0 = new org.jfree.chart.urls.StandardXYURLGenerator();

  }

  @Test
  public void test174() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test174"); }


    org.jfree.chart.ChartTheme chartTheme0 = org.jfree.chart.StandardChartTheme.createJFreeTheme();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(chartTheme0);

  }

  @Test
  public void test175() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test175"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = xYStepRenderer0.getSeriesPositiveItemLabelPosition(3);
    java.util.Collection collection3 = xYStepRenderer0.getAnnotations();
    org.jfree.chart.labels.StandardXYSeriesLabelGenerator standardXYSeriesLabelGenerator5 = new org.jfree.chart.labels.StandardXYSeriesLabelGenerator("");
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D7 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.geom.Rectangle2D rectangle2D13 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge14 = null;
    double d15 = categoryAxis3D7.getCategorySeriesMiddle((-1), 255, (-1), 0, 0.0d, rectangle2D13, rectangleEdge14);
    boolean b16 = standardXYSeriesLabelGenerator5.equals((java.lang.Object)rectangle2D13);
    org.jfree.chart.util.LogFormat logFormat20 = new org.jfree.chart.util.LogFormat(10.0d, "", true);
    java.text.ParsePosition parsePosition22 = null;
    java.lang.Object obj23 = logFormat20.parseObject("", parsePosition22);
    boolean b24 = standardXYSeriesLabelGenerator5.equals(obj23);
    xYStepRenderer0.setLegendItemURLGenerator((org.jfree.chart.labels.XYSeriesLabelGenerator)standardXYSeriesLabelGenerator5);
    org.jfree.chart.util.RectangleInsets rectangleInsets26 = org.jfree.chart.axis.Axis.DEFAULT_TICK_LABEL_INSETS;
    boolean b27 = standardXYSeriesLabelGenerator5.equals((java.lang.Object)rectangleInsets26);
    java.awt.geom.Rectangle2D rectangle2D28 = null;
    // The following exception was thrown during execution in test generation
    try {
      rectangleInsets26.trim(rectangle2D28);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(collection3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d15, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(obj23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);

  }

  @Test
  public void test176() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test176"); }


    org.jfree.data.time.TimeSeries timeSeries0 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection1 = new org.jfree.data.time.TimeSeriesCollection(timeSeries0);
    org.jfree.data.time.TimePeriodAnchor timePeriodAnchor2 = timeSeriesCollection1.getXPosition();
    org.jfree.data.xy.IntervalXYDelegate intervalXYDelegate3 = new org.jfree.data.xy.IntervalXYDelegate((org.jfree.data.xy.XYDataset)timeSeriesCollection1);
    org.jfree.data.time.TimeSeries timeSeries4 = null;
    // The following exception was thrown during execution in test generation
    try {
      timeSeriesCollection1.addSeries(timeSeries4);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(timePeriodAnchor2);

  }

  @Test
  public void test177() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test177"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(3);
    org.jfree.chart.labels.StandardXYSeriesLabelGenerator standardXYSeriesLabelGenerator3 = new org.jfree.chart.labels.StandardXYSeriesLabelGenerator("");
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D5 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.geom.Rectangle2D rectangle2D11 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge12 = null;
    double d13 = categoryAxis3D5.getCategorySeriesMiddle((-1), 255, (-1), 0, 0.0d, rectangle2D11, rectangleEdge12);
    boolean b14 = standardXYSeriesLabelGenerator3.equals((java.lang.Object)rectangle2D11);
    org.jfree.chart.util.LogFormat logFormat18 = new org.jfree.chart.util.LogFormat(10.0d, "", true);
    java.text.ParsePosition parsePosition20 = null;
    java.lang.Object obj21 = logFormat18.parseObject("", parsePosition20);
    boolean b22 = standardXYSeriesLabelGenerator3.equals(obj21);
    xYAreaRenderer1.setLegendItemLabelGenerator((org.jfree.chart.labels.XYSeriesLabelGenerator)standardXYSeriesLabelGenerator3);
    java.lang.Object obj24 = null;
    boolean b25 = standardXYSeriesLabelGenerator3.equals(obj24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d13, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(obj21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);

  }

  @Test
  public void test178() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test178"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    boolean b5 = xYAreaRenderer1.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition9 = xYAreaRenderer1.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b11 = xYAreaRenderer1.getSeriesCreateEntities(10);
    boolean b12 = xYAreaRenderer1.getDataBoundsIncludesVisibleSeriesOnly();
    java.awt.Paint paint14 = xYAreaRenderer1.lookupLegendTextPaint((-435));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint14);

  }

  @Test
  public void test179() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test179"); }


    int i0 = org.jfree.data.time.SerialDate.INCLUDE_FIRST;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 1);

  }

  @Test
  public void test180() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test180"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    java.awt.Stroke stroke11 = jFreeChart10.getBorderStroke();
    boolean b12 = jFreeChart10.isBorderVisible();
    java.lang.Object obj13 = jFreeChart10.clone();
    org.jfree.chart.entity.EntityCollection entityCollection16 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo17 = new org.jfree.chart.ChartRenderingInfo(entityCollection16);
    jFreeChart10.handleClick(15, 8, chartRenderingInfo17);
    jFreeChart10.setTitle("");
    org.jfree.chart.title.Title title22 = jFreeChart10.getSubtitle(0);
    boolean b23 = title22.isVisible();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(title22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == true);

  }

  @Test
  public void test181() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test181"); }


    org.jfree.data.Range range1 = null;
    org.jfree.chart.block.RectangleConstraint rectangleConstraint2 = new org.jfree.chart.block.RectangleConstraint(100.0d, range1);
    org.jfree.chart.block.LengthConstraintType lengthConstraintType3 = rectangleConstraint2.getWidthConstraintType();
    org.jfree.data.time.DateRange dateRange6 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange9 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b10 = dateRange6.intersects((org.jfree.data.Range)dateRange9);
    org.jfree.chart.block.RectangleConstraint rectangleConstraint11 = rectangleConstraint2.toRangeHeight((org.jfree.data.Range)dateRange9);
    org.jfree.chart.block.LengthConstraintType lengthConstraintType12 = rectangleConstraint11.getHeightConstraintType();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleConstraint11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType12);

  }

  @Test
  public void test182() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test182"); }


    org.jfree.chart.StandardChartTheme standardChartTheme1 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.renderer.category.BarPainter barPainter2 = standardChartTheme1.getBarPainter();
    java.awt.Font font3 = standardChartTheme1.getLargeFont();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer5 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator6 = xYAreaRenderer5.getLegendItemToolTipGenerator();
    boolean b9 = xYAreaRenderer5.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition13 = xYAreaRenderer5.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b15 = xYAreaRenderer5.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator16 = null;
    xYAreaRenderer5.setBaseToolTipGenerator(xYToolTipGenerator16, true);
    java.awt.Shape shape20 = xYAreaRenderer5.lookupLegendShape(3);
    java.awt.Shape shape22 = xYAreaRenderer5.getLegendShape(10);
    org.jfree.data.time.TimeSeries timeSeries23 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection24 = new org.jfree.data.time.TimeSeriesCollection(timeSeries23);
    timeSeriesCollection24.validateObject();
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent26 = null;
    timeSeriesCollection24.seriesChanged(seriesChangeEvent26);
    org.jfree.data.Range range28 = xYAreaRenderer5.findDomainBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection24);
    org.jfree.chart.axis.CategoryAxis categoryAxis29 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset30 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot31 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset30);
    org.jfree.chart.axis.ValueAxis valueAxis32 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot33 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis32);
    java.util.List list34 = combinedDomainXYPlot33.getAnnotations();
    waferMapPlot31.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot33);
    int i36 = combinedDomainXYPlot33.getSeriesCount();
    categoryAxis29.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot33);
    boolean b39 = categoryAxis29.equals((java.lang.Object)(short)1);
    java.awt.Paint paint40 = categoryAxis29.getTickMarkPaint();
    xYAreaRenderer5.setBaseLegendTextPaint(paint40);
    standardChartTheme1.setErrorIndicatorPaint(paint40);
    java.awt.Paint paint43 = standardChartTheme1.getGridBandPaint();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(barPainter2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(shape22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i36 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint43);

  }

  @Test
  public void test183() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test183"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
    numberAxis15.centerRange(100.0d);
    combinedDomainXYPlot9.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis15);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier19 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot9.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    org.jfree.data.category.CategoryDataset categoryDataset22 = null;
    org.jfree.chart.renderer.category.CategoryItemRenderer categoryItemRenderer23 = categoryPlot0.getRendererForDataset(categoryDataset22);
    java.awt.Color color30 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke31 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color32 = java.awt.Color.orange;
    java.awt.Stroke stroke33 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker35 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color30, stroke31, (java.awt.Paint)color32, stroke33, 0.0f);
    java.awt.Paint paint36 = intervalMarker35.getPaint();
    org.jfree.chart.util.Layer layer37 = null;
    boolean b38 = categoryPlot0.removeDomainMarker(8, (org.jfree.chart.plot.Marker)intervalMarker35, layer37);
    categoryPlot0.setDrawSharedDomainAxis(false);
    org.jfree.chart.LegendItemCollection legendItemCollection41 = categoryPlot0.getLegendItems();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.LegendItem legendItem43 = legendItemCollection41.get(128);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryItemRenderer23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection41);

  }

  @Test
  public void test184() {}
// Defects4J: flaky method
//   @Test
//   public void test184() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test184"); }
// 
// 
//     org.jfree.data.time.DateRange dateRange3 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d4 = dateRange3.getLength();
//     long long5 = dateRange3.getLowerMillis();
//     double d6 = dateRange3.getLength();
//     java.lang.String str7 = dateRange3.toString();
//     java.util.Date date8 = dateRange3.getUpperDate();
//     java.util.TimeZone timeZone9 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year10 = new org.jfree.data.time.Year(date8, timeZone9);
//     org.jfree.chart.axis.DateAxis dateAxis11 = new org.jfree.chart.axis.DateAxis("SerialDate.weekInMonthToString(): invalid code.", timeZone9);
//     java.awt.Graphics2D graphics2D12 = null;
//     org.jfree.chart.axis.AxisState axisState14 = new org.jfree.chart.axis.AxisState(1.0d);
//     double d15 = axisState14.getCursor();
//     axisState14.cursorLeft(0.2d);
//     java.awt.geom.Rectangle2D rectangle2D18 = null;
//     org.jfree.chart.axis.AxisSpace axisSpace19 = new org.jfree.chart.axis.AxisSpace();
//     org.jfree.data.DomainOrder domainOrder20 = org.jfree.data.DomainOrder.DESCENDING;
//     boolean b21 = axisSpace19.equals((java.lang.Object)domainOrder20);
//     org.jfree.chart.axis.CategoryAxis3D categoryAxis3D24 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
//     java.awt.Stroke stroke25 = categoryAxis3D24.getTickMarkStroke();
//     java.awt.Graphics2D graphics2D26 = null;
//     java.awt.geom.Rectangle2D rectangle2D28 = null;
//     org.jfree.chart.util.RectangleEdge rectangleEdge29 = org.jfree.chart.util.RectangleEdge.LEFT;
//     org.jfree.chart.axis.AxisState axisState31 = new org.jfree.chart.axis.AxisState(1.0d);
//     double d32 = axisState31.getCursor();
//     axisState31.cursorLeft(0.2d);
//     categoryAxis3D24.drawTickMarks(graphics2D26, 7.0d, rectangle2D28, rectangleEdge29, axisState31);
//     axisSpace19.ensureAtLeast(6.0d, rectangleEdge29);
//     org.jfree.chart.util.RectangleEdge rectangleEdge37 = org.jfree.chart.util.RectangleEdge.opposite(rectangleEdge29);
//     // The following exception was thrown during execution in test generation
//     try {
//       java.util.List list38 = dateAxis11.refreshTicks(graphics2D12, axisState14, rectangle2D18, rectangleEdge29);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d4 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d6 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str7 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str7.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone9);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d15 == 1.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(domainOrder20);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b21 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleEdge29);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d32 == 1.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleEdge37);
// 
//   }

  @Test
  public void test185() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test185"); }


    org.jfree.data.time.TimeSeries timeSeries0 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection1 = new org.jfree.data.time.TimeSeriesCollection(timeSeries0);
    org.jfree.data.time.TimePeriodAnchor timePeriodAnchor2 = timeSeriesCollection1.getXPosition();
    org.jfree.data.xy.IntervalXYDelegate intervalXYDelegate3 = new org.jfree.data.xy.IntervalXYDelegate((org.jfree.data.xy.XYDataset)timeSeriesCollection1);
    double d4 = intervalXYDelegate3.getIntervalWidth();
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number7 = intervalXYDelegate3.getEndX(1900, 100);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(timePeriodAnchor2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 1.0d);

  }

  @Test
  public void test186() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test186"); }


    org.jfree.chart.LegendItem legendItem1 = new org.jfree.chart.LegendItem("ThreadContext");
    java.text.AttributedString attributedString2 = legendItem1.getAttributedLabel();
    legendItem1.setDescription("series");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(attributedString2);

  }

  @Test
  public void test187() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test187"); }


    java.awt.Graphics2D graphics2D1 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.text.TextUtilities.drawRotatedString("^2.0", graphics2D1, 1.0f, 2.0f, 2.0d, (-1.0f), 0.5f);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test188() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test188"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis1 = new org.jfree.chart.axis.CategoryAxis("");
    boolean b2 = categoryAxis1.isAxisLineVisible();
    categoryAxis1.setLowerMargin(3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);

  }

  @Test
  public void test189() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test189"); }


    org.jfree.chart.renderer.category.BarRenderer.setDefaultShadowsVisible(false);

  }

  @Test
  public void test190() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test190"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    java.util.List list2 = combinedDomainXYPlot1.getAnnotations();
    combinedDomainXYPlot1.setRangeGridlinesVisible(true);
    java.awt.Color color5 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    combinedDomainXYPlot1.setRangeTickBandPaint((java.awt.Paint)color5);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer8 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator9 = xYAreaRenderer8.getLegendItemToolTipGenerator();
    boolean b12 = xYAreaRenderer8.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition16 = xYAreaRenderer8.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b18 = xYAreaRenderer8.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator20 = xYAreaRenderer8.getSeriesToolTipGenerator(3);
    java.awt.Font font22 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset23 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot24 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset23);
    org.jfree.chart.axis.ValueAxis valueAxis25 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot26 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis25);
    java.util.List list27 = combinedDomainXYPlot26.getAnnotations();
    waferMapPlot24.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot26);
    boolean b29 = combinedDomainXYPlot26.isNotify();
    org.jfree.chart.JFreeChart jFreeChart31 = new org.jfree.chart.JFreeChart("", font22, (org.jfree.chart.plot.Plot)combinedDomainXYPlot26, true);
    xYAreaRenderer8.setBaseLegendTextFont(font22);
    combinedDomainXYPlot1.setNoDataMessageFont(font22);
    combinedDomainXYPlot1.setRangeCrosshairVisible(true);
    boolean b36 = combinedDomainXYPlot1.isOutlineVisible();
    org.jfree.chart.axis.ValueAxis valueAxis38 = combinedDomainXYPlot1.getRangeAxis(15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYToolTipGenerator20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(valueAxis38);

  }

  @Test
  public void test191() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test191"); }


    org.jfree.data.xy.XYSeries xYSeries0 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection1 = new org.jfree.data.xy.XYSeriesCollection(xYSeries0);
    boolean b2 = xYSeriesCollection1.isAutoWidth();
    org.jfree.data.Range range4 = xYSeriesCollection1.getRangeBounds(true);
    xYSeriesCollection1.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis7 = new org.jfree.chart.axis.NumberAxis();
    numberAxis7.centerRange(100.0d);
    java.lang.Object obj10 = numberAxis7.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer11 = null;
    org.jfree.chart.plot.PolarPlot polarPlot12 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection1, (org.jfree.chart.axis.ValueAxis)numberAxis7, polarItemRenderer11);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number15 = xYSeriesCollection1.getEndY(2, 255);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj10);

  }

  @Test
  public void test192() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test192"); }


    org.jfree.chart.LegendItem legendItem1 = new org.jfree.chart.LegendItem("ThreadContext");
    java.text.AttributedString attributedString2 = legendItem1.getAttributedLabel();
    java.awt.Paint paint3 = legendItem1.getOutlinePaint();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer5 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier6 = xYAreaRenderer5.getDrawingSupplier();
    boolean b7 = xYAreaRenderer5.getBaseItemLabelsVisible();
    java.awt.Paint paint11 = xYAreaRenderer5.getItemOutlinePaint(100, (-1), false);
    boolean b12 = org.jfree.chart.util.PaintUtilities.equal(paint3, paint11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(attributedString2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);

  }

  @Test
  public void test193() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test193"); }


    org.jfree.chart.ui.Contributor contributor2 = new org.jfree.chart.ui.Contributor("RectangleConstraint[LengthConstraintType.FIXED: width=100.0, height=0.0]", "TextBlockAnchor.BOTTOM_RIGHT");
    java.lang.String str3 = contributor2.getName();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str3 + "' != '" + "RectangleConstraint[LengthConstraintType.FIXED: width=100.0, height=0.0]"+ "'", str3.equals("RectangleConstraint[LengthConstraintType.FIXED: width=100.0, height=0.0]"));

  }

  @Test
  public void test194() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test194"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    java.util.List list2 = combinedDomainXYPlot1.getAnnotations();
    combinedDomainXYPlot1.setRangeGridlinesVisible(true);
    org.jfree.chart.plot.PlotOrientation plotOrientation5 = combinedDomainXYPlot1.getOrientation();
    boolean b6 = combinedDomainXYPlot1.isDomainPannable();
    org.jfree.chart.axis.CategoryAxis categoryAxis7 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset8 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot9 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset8);
    org.jfree.chart.axis.ValueAxis valueAxis10 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot11 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis10);
    java.util.List list12 = combinedDomainXYPlot11.getAnnotations();
    waferMapPlot9.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot11);
    int i14 = combinedDomainXYPlot11.getSeriesCount();
    categoryAxis7.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot11);
    java.awt.Color color22 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke23 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color24 = java.awt.Color.orange;
    java.awt.Stroke stroke25 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker27 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color22, stroke23, (java.awt.Paint)color24, stroke25, 0.0f);
    java.awt.Paint paint28 = intervalMarker27.getOutlinePaint();
    org.jfree.chart.util.Layer layer29 = null;
    combinedDomainXYPlot11.addRangeMarker(0, (org.jfree.chart.plot.Marker)intervalMarker27, layer29);
    org.jfree.chart.axis.AxisLocation axisLocation31 = combinedDomainXYPlot11.getDomainAxisLocation();
    java.awt.Color color32 = java.awt.Color.RED;
    combinedDomainXYPlot11.setDomainTickBandPaint((java.awt.Paint)color32);
    org.jfree.chart.LegendItemCollection legendItemCollection34 = combinedDomainXYPlot11.getLegendItems();
    combinedDomainXYPlot1.setFixedLegendItems(legendItemCollection34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i14 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection34);

  }

  @Test
  public void test195() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test195"); }


    java.lang.String str1 = org.jfree.data.time.SerialDate.relativeToString(2016);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "ERROR : Relative To String"+ "'", str1.equals("ERROR : Relative To String"));

  }

  @Test
  public void test196() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test196"); }


    org.jfree.data.RangeType rangeType0 = org.jfree.data.RangeType.NEGATIVE;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rangeType0);

  }

  @Test
  public void test197() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test197"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    boolean b5 = xYAreaRenderer1.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition9 = xYAreaRenderer1.getPositiveItemLabelPosition(8, 10, false);
    org.jfree.chart.annotations.XYAnnotation xYAnnotation10 = null;
    // The following exception was thrown during execution in test generation
    try {
      xYAreaRenderer1.addAnnotation(xYAnnotation10);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition9);

  }

  @Test
  public void test198() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test198"); }


    org.jfree.chart.renderer.category.BarRenderer3D barRenderer3D2 = new org.jfree.chart.renderer.category.BarRenderer3D(1.0E-8d, 1.0d);
    java.awt.Paint paint3 = barRenderer3D2.getWallPaint();
    org.jfree.chart.labels.CategoryItemLabelGenerator categoryItemLabelGenerator4 = null;
    barRenderer3D2.setBaseItemLabelGenerator(categoryItemLabelGenerator4, true);
    java.awt.Shape shape7 = barRenderer3D2.getBaseShape();
    java.awt.Graphics2D graphics2D8 = null;
    java.awt.geom.Rectangle2D rectangle2D9 = null;
    org.jfree.chart.plot.CategoryPlot categoryPlot10 = new org.jfree.chart.plot.CategoryPlot();
    boolean b11 = categoryPlot10.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge13 = categoryPlot10.getDomainAxisEdge(8);
    java.awt.Color color20 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke21 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color22 = java.awt.Color.orange;
    java.awt.Stroke stroke23 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker25 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color20, stroke21, (java.awt.Paint)color22, stroke23, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer26 = null;
    intervalMarker25.setGradientPaintTransformer(gradientPaintTransformer26);
    org.jfree.chart.util.RectangleInsets rectangleInsets28 = intervalMarker25.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis30 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets31 = categoryAxis30.getLabelInsets();
    intervalMarker25.setLabelOffset(rectangleInsets31);
    double d33 = intervalMarker25.getEndValue();
    org.jfree.chart.util.Layer layer34 = null;
    boolean b35 = categoryPlot10.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker25, layer34);
    org.jfree.data.category.CategoryDataset categoryDataset36 = null;
    int i37 = categoryPlot10.indexOf(categoryDataset36);
    org.jfree.data.general.WaferMapDataset waferMapDataset39 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot40 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset39);
    org.jfree.chart.axis.ValueAxis valueAxis41 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot42 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis41);
    java.util.List list43 = combinedDomainXYPlot42.getAnnotations();
    waferMapPlot40.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot42);
    int i45 = combinedDomainXYPlot42.getSeriesCount();
    boolean b47 = combinedDomainXYPlot42.equals((java.lang.Object)10.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer49 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    xYAreaRenderer49.setSeriesCreateEntities(15, (java.lang.Boolean)true, true);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition55 = xYAreaRenderer49.getSeriesPositiveItemLabelPosition(3);
    boolean b56 = combinedDomainXYPlot42.equals((java.lang.Object)3);
    org.jfree.chart.axis.AxisLocation axisLocation58 = combinedDomainXYPlot42.getDomainAxisLocation(10);
    categoryPlot10.setDomainAxisLocation(0, axisLocation58);
    categoryPlot10.setDomainCrosshairColumnKey((java.lang.Comparable)0.0f, false);
    org.jfree.chart.plot.CategoryPlot categoryPlot64 = new org.jfree.chart.plot.CategoryPlot();
    boolean b65 = categoryPlot64.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge67 = categoryPlot64.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis69 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets70 = categoryAxis69.getLabelInsets();
    double d72 = rectangleInsets70.calculateLeftInset(4.0d);
    categoryPlot64.setInsets(rectangleInsets70, false);
    int i75 = categoryPlot64.getRendererCount();
    org.jfree.chart.axis.NumberAxis numberAxis76 = new org.jfree.chart.axis.NumberAxis();
    numberAxis76.centerRange(100.0d);
    java.awt.Paint paint79 = numberAxis76.getLabelPaint();
    categoryPlot64.setRangeCrosshairPaint(paint79);
    org.jfree.chart.entity.EntityCollection entityCollection82 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo83 = new org.jfree.chart.ChartRenderingInfo(entityCollection82);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo84 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo83);
    java.awt.geom.Point2D point2D85 = null;
    categoryPlot64.panRangeAxes(0.6d, plotRenderingInfo84, point2D85);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.renderer.category.CategoryItemRendererState categoryItemRendererState87 = barRenderer3D2.initialise(graphics2D8, rectangle2D9, categoryPlot10, 100, plotRenderingInfo84);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d33 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i37 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i45 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b47 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b56 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b65 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d72 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i75 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint79);

  }

  @Test
  public void test199() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test199"); }


    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.Month month2 = new org.jfree.data.time.Month(64, 10);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test200() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test200"); }


    java.lang.String str1 = org.jfree.data.time.SerialDate.monthCodeToString(4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "April"+ "'", str1.equals("April"));

  }

  @Test
  public void test201() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test201"); }


    java.lang.String str0 = org.jfree.chart.urls.StandardXYURLGenerator.DEFAULT_PREFIX;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str0 + "' != '" + "index.html"+ "'", str0.equals("index.html"));

  }

  @Test
  public void test202() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test202"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    boolean b3 = xYBarRenderer1.getAutoPopulateSeriesShape();
    xYBarRenderer1.setShadowVisible(true);
    xYBarRenderer1.setShadowYOffset(0.2d);
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator11 = new org.jfree.chart.urls.StandardXYURLGenerator("", "hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!", "");
    org.jfree.chart.axis.ValueAxis valueAxis12 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot13 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis12);
    org.jfree.chart.plot.Plot plot14 = combinedDomainXYPlot13.getRootPlot();
    org.jfree.chart.axis.ValueAxis valueAxis15 = null;
    int i16 = combinedDomainXYPlot13.getRangeAxisIndex(valueAxis15);
    org.jfree.data.xy.XYSeries xYSeries18 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection19 = new org.jfree.data.xy.XYSeriesCollection(xYSeries18);
    boolean b20 = xYSeriesCollection19.isAutoWidth();
    org.jfree.data.Range range22 = xYSeriesCollection19.getRangeBounds(true);
    combinedDomainXYPlot13.setDataset(0, (org.jfree.data.xy.XYDataset)xYSeriesCollection19);
    java.lang.String str26 = standardXYURLGenerator11.generateURL((org.jfree.data.xy.XYDataset)xYSeriesCollection19, (-1), 14);
    java.awt.Color color30 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    boolean b31 = xYSeriesCollection19.equals((java.lang.Object)10.0f);
    org.jfree.data.Range range32 = xYBarRenderer1.findRangeBounds((org.jfree.data.xy.XYDataset)xYSeriesCollection19);
    java.awt.Graphics2D graphics2D33 = null;
    org.jfree.chart.axis.ValueAxis valueAxis34 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot35 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis34);
    org.jfree.data.category.CategoryDataset categoryDataset36 = null;
    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot37 = new org.jfree.chart.plot.MultiplePiePlot(categoryDataset36);
    combinedDomainXYPlot35.setParent((org.jfree.chart.plot.Plot)multiplePiePlot37);
    org.jfree.chart.axis.ValueAxis valueAxis39 = null;
    combinedDomainXYPlot35.setDomainAxis(valueAxis39);
    org.jfree.chart.axis.ValueAxis valueAxis41 = null;
    java.awt.geom.Rectangle2D rectangle2D42 = null;
    java.awt.Color color44 = org.jfree.chart.ChartColor.VERY_DARK_CYAN;
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer45 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    boolean b46 = xYStepRenderer45.getUseFillPaint();
    xYStepRenderer45.setDrawSeriesLineAsPath(false);
    java.awt.Stroke stroke52 = xYStepRenderer45.getItemOutlineStroke(10, 15, false);
    // The following exception was thrown during execution in test generation
    try {
      xYBarRenderer1.drawDomainLine(graphics2D33, (org.jfree.chart.plot.XYPlot)combinedDomainXYPlot35, valueAxis41, rectangle2D42, 0.05d, (java.awt.Paint)color44, stroke52);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i16 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str26 + "' != '" + "?hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!=-1&amp;=14"+ "'", str26.equals("?hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!=-1&amp;=14"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b46 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke52);

  }

  @Test
  public void test203() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test203"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    java.awt.Graphics2D graphics2D4 = null;
    java.awt.geom.Rectangle2D rectangle2D5 = null;
    org.jfree.data.general.DefaultPieDataset defaultPieDataset6 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj7 = defaultPieDataset6.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D8 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset6);
    piePlot3D8.setIgnoreZeroValues(true);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo12 = null;
    org.jfree.chart.plot.PiePlotState piePlotState13 = piePlot3D2.initialise(graphics2D4, rectangle2D5, (org.jfree.chart.plot.PiePlot)piePlot3D8, (java.lang.Integer)1, plotRenderingInfo12);
    org.jfree.chart.axis.NumberAxis numberAxis14 = new org.jfree.chart.axis.NumberAxis();
    numberAxis14.resizeRange2(10.0d, 11.0d);
    org.jfree.chart.util.RectangleInsets rectangleInsets18 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d19 = rectangleInsets18.getLeft();
    numberAxis14.setTickLabelInsets(rectangleInsets18);
    org.jfree.data.Range range21 = numberAxis14.getRange();
    java.awt.Shape shape22 = numberAxis14.getRightArrow();
    boolean b23 = piePlot3D8.equals((java.lang.Object)numberAxis14);
    org.jfree.chart.labels.PieToolTipGenerator pieToolTipGenerator24 = piePlot3D8.getToolTipGenerator();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(piePlotState13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d19 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(pieToolTipGenerator24);

  }

  @Test
  public void test204() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test204"); }


    org.jfree.chart.text.TextLine textLine1 = new org.jfree.chart.text.TextLine("March");
    java.awt.Font font4 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset5 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot6 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset5);
    org.jfree.chart.axis.ValueAxis valueAxis7 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot8 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis7);
    java.util.List list9 = combinedDomainXYPlot8.getAnnotations();
    waferMapPlot6.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot8);
    org.jfree.chart.JFreeChart jFreeChart12 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font4, (org.jfree.chart.plot.Plot)combinedDomainXYPlot8, true);
    java.awt.Color color16 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment17 = new org.jfree.chart.text.TextFragment("hi!", font4, (java.awt.Paint)color16);
    textLine1.addFragment(textFragment17);
    java.awt.Graphics2D graphics2D19 = null;
    org.jfree.chart.text.TextAnchor textAnchor22 = org.jfree.chart.text.TextAnchor.CENTER;
    // The following exception was thrown during execution in test generation
    try {
      textLine1.draw(graphics2D19, 1.0f, 1.0f, textAnchor22, 0.0f, 0.5f, 4.0d);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textAnchor22);

  }

  @Test
  public void test205() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test205"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    org.jfree.chart.util.Layer layer23 = null;
    boolean b25 = combinedDomainXYPlot5.removeDomainMarker(2, (org.jfree.chart.plot.Marker)intervalMarker22, layer23, false);
    java.lang.Object obj26 = combinedDomainXYPlot5.clone();
    boolean b27 = combinedDomainXYPlot5.isSubplot();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.axis.ValueAxis valueAxis29 = combinedDomainXYPlot5.getDomainAxisForDataset(15);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);

  }

  @Test
  public void test206() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test206"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    org.jfree.chart.plot.CategoryPlot categoryPlot11 = new org.jfree.chart.plot.CategoryPlot();
    boolean b12 = categoryPlot11.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge14 = categoryPlot11.getDomainAxisEdge(8);
    legendTitle10.setPosition(rectangleEdge14);
    java.awt.Graphics2D graphics2D16 = null;
    java.awt.geom.Rectangle2D rectangle2D17 = null;
    // The following exception was thrown during execution in test generation
    try {
      legendTitle10.draw(graphics2D16, rectangle2D17);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge14);

  }

  @Test
  public void test207() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test207"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.axis.ValueAxis valueAxis2 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot3 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis2);
    java.util.List list4 = combinedDomainXYPlot3.getAnnotations();
    waferMapPlot1.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot3);
    boolean b6 = waferMapPlot1.isOutlineVisible();
    float f7 = waferMapPlot1.getBackgroundAlpha();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.LegendItemCollection legendItemCollection8 = waferMapPlot1.getLegendItems();
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f7 == 1.0f);

  }

  @Test
  public void test208() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test208"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    java.awt.Graphics2D graphics2D4 = null;
    java.awt.geom.Rectangle2D rectangle2D5 = null;
    org.jfree.data.general.DefaultPieDataset defaultPieDataset6 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj7 = defaultPieDataset6.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D8 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset6);
    piePlot3D8.setIgnoreZeroValues(true);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo12 = null;
    org.jfree.chart.plot.PiePlotState piePlotState13 = piePlot3D2.initialise(graphics2D4, rectangle2D5, (org.jfree.chart.plot.PiePlot)piePlot3D8, (java.lang.Integer)1, plotRenderingInfo12);
    org.jfree.chart.axis.NumberAxis numberAxis14 = new org.jfree.chart.axis.NumberAxis();
    numberAxis14.resizeRange2(10.0d, 11.0d);
    org.jfree.chart.util.RectangleInsets rectangleInsets18 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d19 = rectangleInsets18.getLeft();
    numberAxis14.setTickLabelInsets(rectangleInsets18);
    org.jfree.data.Range range21 = numberAxis14.getRange();
    java.awt.Shape shape22 = numberAxis14.getRightArrow();
    boolean b23 = piePlot3D8.equals((java.lang.Object)numberAxis14);
    org.jfree.chart.labels.PieSectionLabelGenerator pieSectionLabelGenerator24 = piePlot3D8.getLegendLabelToolTipGenerator();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(piePlotState13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d19 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(pieSectionLabelGenerator24);

  }

  @Test
  public void test209() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test209"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    java.awt.Stroke stroke11 = jFreeChart10.getBorderStroke();
    org.jfree.chart.plot.XYPlot xYPlot12 = jFreeChart10.getXYPlot();
    org.jfree.chart.plot.CategoryPlot categoryPlot13 = new org.jfree.chart.plot.CategoryPlot();
    boolean b14 = categoryPlot13.isRangeZoomable();
    java.awt.Paint paint15 = org.jfree.chart.block.LabelBlock.DEFAULT_PAINT;
    categoryPlot13.setDomainGridlinePaint(paint15);
    jFreeChart10.setBorderPaint(paint15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(xYPlot12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint15);

  }

  @Test
  public void test210() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test210"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    boolean b5 = xYAreaRenderer1.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition9 = xYAreaRenderer1.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b11 = xYAreaRenderer1.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator12 = null;
    xYAreaRenderer1.setBaseToolTipGenerator(xYToolTipGenerator12, true);
    java.awt.Shape shape16 = xYAreaRenderer1.lookupLegendShape(3);
    java.awt.Paint paint18 = xYAreaRenderer1.getLegendTextPaint(5);
    org.jfree.chart.axis.ValueAxis valueAxis19 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot20 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis19);
    java.util.List list21 = combinedDomainXYPlot20.getAnnotations();
    combinedDomainXYPlot20.setRangeGridlinesVisible(true);
    org.jfree.chart.util.RectangleEdge rectangleEdge25 = combinedDomainXYPlot20.getRangeAxisEdge(4);
    org.jfree.data.xy.XYDataset xYDataset27 = combinedDomainXYPlot20.getDataset(64);
    xYAreaRenderer1.setPlot((org.jfree.chart.plot.XYPlot)combinedDomainXYPlot20);
    org.jfree.chart.entity.EntityCollection entityCollection30 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo31 = new org.jfree.chart.ChartRenderingInfo(entityCollection30);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo32 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo31);
    int i33 = plotRenderingInfo32.getSubplotCount();
    java.awt.geom.Point2D point2D34 = null;
    // The following exception was thrown during execution in test generation
    try {
      combinedDomainXYPlot20.zoomRangeAxes(0.0d, plotRenderingInfo32, point2D34, true);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYDataset27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i33 == 0);

  }

  @Test
  public void test211() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test211"); }


    java.awt.Color color0 = org.jfree.chart.ChartColor.VERY_LIGHT_BLUE;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color0);

  }

  @Test
  public void test212() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test212"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis0 = new org.jfree.chart.axis.CategoryAxis();
    categoryAxis0.setVisible(false);
    org.jfree.chart.util.RectangleInsets rectangleInsets3 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d4 = rectangleInsets3.getLeft();
    double d6 = rectangleInsets3.calculateLeftOutset(1.0d);
    categoryAxis0.setLabelInsets(rectangleInsets3, true);
    java.awt.Font font10 = null;
    categoryAxis0.setTickLabelFont((java.lang.Comparable)900000L, font10);
    java.lang.String str12 = categoryAxis0.getLabelToolTip();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str12);

  }

  @Test
  public void test213() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test213"); }


    int i0 = org.jfree.chart.axis.ValueAxis.MAXIMUM_TICK_COUNT;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 500);

  }

  @Test
  public void test214() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test214"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis0 = new org.jfree.chart.axis.CategoryAxis();
    categoryAxis0.setVisible(false);
    org.jfree.chart.util.RectangleInsets rectangleInsets3 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d4 = rectangleInsets3.getLeft();
    double d6 = rectangleInsets3.calculateLeftOutset(1.0d);
    categoryAxis0.setLabelInsets(rectangleInsets3, true);
    float f9 = categoryAxis0.getTickMarkOutsideLength();
    org.jfree.chart.axis.CategoryAnchor categoryAnchor10 = null;
    java.awt.geom.Rectangle2D rectangle2D13 = null;
    org.jfree.data.general.WaferMapDataset waferMapDataset14 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot15 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset14);
    org.jfree.chart.JFreeChart jFreeChart16 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent17 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot15, jFreeChart16);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment18 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment19 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement22 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment18, verticalAlignment19, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement23 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle24 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot15, (org.jfree.chart.block.Arrangement)flowArrangement22, (org.jfree.chart.block.Arrangement)borderArrangement23);
    org.jfree.chart.plot.CategoryPlot categoryPlot25 = new org.jfree.chart.plot.CategoryPlot();
    boolean b26 = categoryPlot25.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge28 = categoryPlot25.getDomainAxisEdge(8);
    legendTitle24.setPosition(rectangleEdge28);
    double d30 = categoryAxis0.getCategoryJava2DCoordinate(categoryAnchor10, 4, 255, rectangle2D13, rectangleEdge28);
    java.lang.String str31 = categoryAxis0.getLabelToolTip();
    java.lang.Object obj32 = categoryAxis0.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f9 == 2.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d30 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj32);

  }

  @Test
  public void test215() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test215"); }


    java.awt.Paint paint2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.plot.IntervalMarker intervalMarker3 = new org.jfree.chart.plot.IntervalMarker(0.0d, 3.0d, paint2);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test216() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test216"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis1 = new org.jfree.chart.axis.CategoryAxis("");
    boolean b2 = categoryAxis1.isAxisLineVisible();
    java.awt.Paint paint3 = categoryAxis1.getTickMarkPaint();
    categoryAxis1.addCategoryLabelToolTip((java.lang.Comparable)(byte)10, "March");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);

  }

  @Test
  public void test217() {}
// Defects4J: flaky method
//   @Test
//   public void test217() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test217"); }
// 
// 
//     org.jfree.data.time.Month month1 = new org.jfree.data.time.Month();
//     int i2 = month1.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem4 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month1, (java.lang.Number)8);
//     long long5 = month1.getFirstMillisecond();
//     org.jfree.data.time.Month month6 = new org.jfree.data.time.Month();
//     int i7 = month6.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis8 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month1, (org.jfree.data.time.RegularTimePeriod)month6);
//     float f9 = periodAxis8.getMinorTickMarkInsideLength();
//     java.lang.Object obj10 = periodAxis8.clone();
//     java.awt.Color color16 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
//     java.awt.Stroke stroke17 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
//     java.awt.Color color18 = java.awt.Color.orange;
//     java.awt.Stroke stroke19 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
//     org.jfree.chart.plot.IntervalMarker intervalMarker21 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color16, stroke17, (java.awt.Paint)color18, stroke19, 0.0f);
//     org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer22 = null;
//     intervalMarker21.setGradientPaintTransformer(gradientPaintTransformer22);
//     org.jfree.chart.util.RectangleInsets rectangleInsets24 = intervalMarker21.getLabelOffset();
//     org.jfree.chart.axis.CategoryAxis categoryAxis26 = new org.jfree.chart.axis.CategoryAxis("");
//     org.jfree.chart.util.RectangleInsets rectangleInsets27 = categoryAxis26.getLabelInsets();
//     intervalMarker21.setLabelOffset(rectangleInsets27);
//     double d29 = intervalMarker21.getEndValue();
//     org.jfree.chart.util.LengthAdjustmentType lengthAdjustmentType30 = org.jfree.chart.util.LengthAdjustmentType.EXPAND;
//     intervalMarker21.setLabelOffsetType(lengthAdjustmentType30);
//     boolean b32 = periodAxis8.equals((java.lang.Object)lengthAdjustmentType30);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i2 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i7 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f9 == 0.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color16);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke17);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color18);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke19);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets24);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d29 == 0.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(lengthAdjustmentType30);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b32 == false);
// 
//   }

  @Test
  public void test218() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test218"); }


    java.awt.Color color0 = java.awt.Color.orange;
    java.awt.Font font2 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset3 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot4 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset3);
    org.jfree.chart.axis.ValueAxis valueAxis5 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot6 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis5);
    java.util.List list7 = combinedDomainXYPlot6.getAnnotations();
    waferMapPlot4.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot6);
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font2, (org.jfree.chart.plot.Plot)combinedDomainXYPlot6, true);
    jFreeChart10.setNotify(false);
    boolean b13 = color0.equals((java.lang.Object)false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);

  }

  @Test
  public void test219() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test219"); }


    org.jfree.chart.renderer.category.BarRenderer barRenderer0 = new org.jfree.chart.renderer.category.BarRenderer();
    double d1 = barRenderer0.getShadowXOffset();
    barRenderer0.setShadowXOffset(10.0d);
    boolean b4 = barRenderer0.getIncludeBaseInRange();
    org.jfree.chart.labels.CategoryItemLabelGenerator categoryItemLabelGenerator6 = null;
    barRenderer0.setSeriesItemLabelGenerator(15, categoryItemLabelGenerator6, false);
    java.awt.Shape shape17 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color19 = java.awt.Color.green;
    java.awt.Color color21 = java.awt.Color.green;
    java.awt.Color color27 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke28 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color29 = java.awt.Color.orange;
    java.awt.Stroke stroke30 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker32 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color27, stroke28, (java.awt.Paint)color29, stroke30, 0.0f);
    java.awt.Shape shape36 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke37 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color38 = java.awt.Color.green;
    java.lang.String str39 = org.jfree.chart.util.PaintUtilities.colorToString(color38);
    org.jfree.chart.LegendItem legendItem40 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape17, true, (java.awt.Paint)color19, false, (java.awt.Paint)color21, stroke28, true, shape36, stroke37, (java.awt.Paint)color38);
    boolean b41 = legendItem40.isShapeOutlineVisible();
    boolean b43 = legendItem40.equals((java.lang.Object)(short)1);
    org.jfree.data.time.DateRange dateRange46 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    double d47 = dateRange46.getLength();
    long long48 = dateRange46.getLowerMillis();
    java.util.Date date49 = dateRange46.getLowerDate();
    boolean b50 = legendItem40.equals((java.lang.Object)date49);
    org.jfree.data.category.CategoryDataset categoryDataset51 = null;
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D53 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D55 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke56 = categoryAxis3D55.getTickMarkStroke();
    java.awt.Stroke stroke57 = org.jfree.chart.plot.CategoryPlot.DEFAULT_CROSSHAIR_STROKE;
    categoryAxis3D55.setAxisLineStroke(stroke57);
    boolean b59 = categoryAxis3D53.equals((java.lang.Object)stroke57);
    java.awt.geom.Rectangle2D rectangle2D60 = null;
    org.jfree.chart.axis.AxisSpace axisSpace61 = new org.jfree.chart.axis.AxisSpace();
    org.jfree.data.DomainOrder domainOrder62 = org.jfree.data.DomainOrder.DESCENDING;
    boolean b63 = axisSpace61.equals((java.lang.Object)domainOrder62);
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D66 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke67 = categoryAxis3D66.getTickMarkStroke();
    java.awt.Graphics2D graphics2D68 = null;
    java.awt.geom.Rectangle2D rectangle2D70 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge71 = org.jfree.chart.util.RectangleEdge.LEFT;
    org.jfree.chart.axis.AxisState axisState73 = new org.jfree.chart.axis.AxisState(1.0d);
    double d74 = axisState73.getCursor();
    axisState73.cursorLeft(0.2d);
    categoryAxis3D66.drawTickMarks(graphics2D68, 7.0d, rectangle2D70, rectangleEdge71, axisState73);
    axisSpace61.ensureAtLeast(6.0d, rectangleEdge71);
    org.jfree.chart.util.RectangleEdge rectangleEdge79 = org.jfree.chart.util.RectangleEdge.opposite(rectangleEdge71);
    // The following exception was thrown during execution in test generation
    try {
      double d80 = barRenderer0.getItemMiddle((java.lang.Comparable)"null", (java.lang.Comparable)b50, categoryDataset51, (org.jfree.chart.axis.CategoryAxis)categoryAxis3D53, rectangle2D60, rectangleEdge79);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str39 + "' != '" + "green"+ "'", str39.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b43 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d47 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long48 == (-1L));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(date49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b50 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b59 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b63 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d74 == 1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge79);

  }

  @Test
  public void test220() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test220"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    boolean b3 = xYBarRenderer1.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator5 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer1.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator5, true);
    java.lang.Object obj8 = standardXYToolTipGenerator5.clone();
    java.text.NumberFormat numberFormat9 = standardXYToolTipGenerator5.getXFormat();
    java.awt.Font font11 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset12 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot13 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset12);
    org.jfree.chart.axis.ValueAxis valueAxis14 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot15 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis14);
    java.util.List list16 = combinedDomainXYPlot15.getAnnotations();
    waferMapPlot13.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot15);
    boolean b18 = combinedDomainXYPlot15.isNotify();
    org.jfree.chart.JFreeChart jFreeChart20 = new org.jfree.chart.JFreeChart("", font11, (org.jfree.chart.plot.Plot)combinedDomainXYPlot15, true);
    combinedDomainXYPlot15.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer23 = null;
    combinedDomainXYPlot15.setRenderer(xYItemRenderer23);
    boolean b25 = combinedDomainXYPlot15.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries26 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection27 = new org.jfree.data.time.TimeSeriesCollection(timeSeries26);
    combinedDomainXYPlot15.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection27);
    java.util.List list29 = timeSeriesCollection27.getSeries();
    org.jfree.data.Range range30 = org.jfree.data.general.DatasetUtilities.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection27);
    org.jfree.data.DomainOrder domainOrder31 = timeSeriesCollection27.getDomainOrder();
    org.jfree.data.Range range32 = org.jfree.data.general.DatasetUtilities.findDomainBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection27);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.String str35 = standardXYToolTipGenerator5.generateToolTip((org.jfree.data.xy.XYDataset)timeSeriesCollection27, 0, (-25560));
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range32);

  }

  @Test
  public void test221() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test221"); }


    org.jfree.chart.util.ShapeList shapeList0 = new org.jfree.chart.util.ShapeList();
    org.jfree.chart.plot.CategoryPlot categoryPlot1 = new org.jfree.chart.plot.CategoryPlot();
    boolean b2 = categoryPlot1.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge4 = categoryPlot1.getDomainAxisEdge(8);
    java.awt.Font font6 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset7 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot8 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset7);
    org.jfree.chart.axis.ValueAxis valueAxis9 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot10 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis9);
    java.util.List list11 = combinedDomainXYPlot10.getAnnotations();
    waferMapPlot8.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot10);
    org.jfree.chart.JFreeChart jFreeChart14 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font6, (org.jfree.chart.plot.Plot)combinedDomainXYPlot10, true);
    org.jfree.chart.axis.NumberAxis numberAxis16 = new org.jfree.chart.axis.NumberAxis();
    numberAxis16.centerRange(100.0d);
    combinedDomainXYPlot10.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis16);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier20 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot10.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier20);
    categoryPlot1.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier20);
    org.jfree.data.category.CategoryDataset categoryDataset23 = null;
    org.jfree.chart.renderer.category.CategoryItemRenderer categoryItemRenderer24 = categoryPlot1.getRendererForDataset(categoryDataset23);
    java.awt.Color color31 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke32 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color33 = java.awt.Color.orange;
    java.awt.Stroke stroke34 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker36 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color31, stroke32, (java.awt.Paint)color33, stroke34, 0.0f);
    java.awt.Paint paint37 = intervalMarker36.getPaint();
    org.jfree.chart.util.Layer layer38 = null;
    boolean b39 = categoryPlot1.removeDomainMarker(8, (org.jfree.chart.plot.Marker)intervalMarker36, layer38);
    boolean b40 = shapeList0.equals((java.lang.Object)categoryPlot1);
    org.jfree.chart.axis.ValueAxis valueAxis41 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot42 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis41);
    org.jfree.chart.plot.Plot plot43 = combinedDomainXYPlot42.getRootPlot();
    org.jfree.chart.axis.ValueAxis valueAxis44 = null;
    int i45 = combinedDomainXYPlot42.getRangeAxisIndex(valueAxis44);
    java.awt.Stroke stroke46 = combinedDomainXYPlot42.getDomainZeroBaselineStroke();
    categoryPlot1.setRangeCrosshairStroke(stroke46);
    java.awt.Paint paint48 = categoryPlot1.getBackgroundPaint();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryItemRenderer24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i45 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint48);

  }

  @Test
  public void test222() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test222"); }


    java.io.ObjectInputStream objectInputStream0 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.awt.Stroke stroke1 = org.jfree.chart.util.SerialUtilities.readStroke(objectInputStream0);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test223() {}
// Defects4J: flaky method
//   @Test
//   public void test223() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test223"); }
// 
// 
//     org.jfree.chart.axis.NumberAxis numberAxis0 = new org.jfree.chart.axis.NumberAxis();
//     numberAxis0.resizeRange2(10.0d, 11.0d);
//     org.jfree.chart.util.RectangleInsets rectangleInsets4 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
//     double d5 = rectangleInsets4.getLeft();
//     numberAxis0.setTickLabelInsets(rectangleInsets4);
//     org.jfree.data.Range range7 = numberAxis0.getRange();
//     java.awt.Shape shape8 = numberAxis0.getRightArrow();
//     org.jfree.data.category.CategoryDataset categoryDataset11 = null;
//     org.jfree.data.time.Month month12 = new org.jfree.data.time.Month();
//     int i13 = month12.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem15 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month12, 11.0d);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod16 = month12.next();
//     // The following exception was thrown during execution in test generation
//     try {
//       org.jfree.chart.entity.CategoryItemEntity categoryItemEntity18 = new org.jfree.chart.entity.CategoryItemEntity(shape8, "UnitType.ABSOLUTE", "RectangleAnchor.BOTTOM_RIGHT", categoryDataset11, (java.lang.Comparable)regularTimePeriod16, (java.lang.Comparable)"ThreadContext");
//       org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
//     } catch (java.lang.IllegalArgumentException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d5 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(range7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(shape8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i13 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod16);
// 
//   }

  @Test
  public void test224() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test224"); }


    java.awt.Shape shape1 = org.jfree.chart.util.ShapeUtilities.createDownTriangle(1.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape1);

  }

  @Test
  public void test225() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test225"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier2 = xYAreaRenderer1.getDrawingSupplier();
    java.awt.Stroke stroke3 = xYAreaRenderer1.getBaseStroke();
    java.awt.Color color9 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke10 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color11 = java.awt.Color.orange;
    java.awt.Stroke stroke12 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker14 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color9, stroke10, (java.awt.Paint)color11, stroke12, 0.0f);
    java.awt.Paint paint15 = intervalMarker14.getOutlinePaint();
    xYAreaRenderer1.setBaseLegendTextPaint(paint15);
    org.jfree.chart.axis.NumberAxis3D numberAxis3D17 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Color color18 = org.jfree.chart.ChartColor.VERY_LIGHT_GREEN;
    numberAxis3D17.setTickMarkPaint((java.awt.Paint)color18);
    xYAreaRenderer1.setBaseItemLabelPaint((java.awt.Paint)color18);
    float[] f_array22 = new float[] { (-1.0f) };
    // The following exception was thrown during execution in test generation
    try {
      float[] f_array23 = color18.getColorComponents(f_array22);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array22);

  }

  @Test
  public void test226() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test226"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Color color10 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke11 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color12 = java.awt.Color.orange;
    java.awt.Stroke stroke13 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker15 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color10, stroke11, (java.awt.Paint)color12, stroke13, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer16 = null;
    intervalMarker15.setGradientPaintTransformer(gradientPaintTransformer16);
    org.jfree.chart.util.RectangleInsets rectangleInsets18 = intervalMarker15.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis20 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets21 = categoryAxis20.getLabelInsets();
    intervalMarker15.setLabelOffset(rectangleInsets21);
    double d23 = intervalMarker15.getEndValue();
    org.jfree.chart.util.Layer layer24 = null;
    boolean b25 = categoryPlot0.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker15, layer24);
    boolean b26 = categoryPlot0.isRangeCrosshairLockedOnData();
    org.jfree.chart.axis.CategoryAnchor categoryAnchor27 = null;
    // The following exception was thrown during execution in test generation
    try {
      categoryPlot0.setDomainGridlinePosition(categoryAnchor27);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d23 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == true);

  }

  @Test
  public void test227() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test227"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    piePlot3D2.setStartAngle(Double.NaN);
    org.jfree.data.general.DefaultPieDataset defaultPieDataset5 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj6 = defaultPieDataset5.clone();
    double d7 = org.jfree.data.general.DatasetUtilities.calculatePieDatasetTotal((org.jfree.data.general.PieDataset)defaultPieDataset5);
    piePlot3D2.setDataset((org.jfree.data.general.PieDataset)defaultPieDataset5);
    org.jfree.chart.util.Rotation rotation9 = piePlot3D2.getDirection();
    java.lang.String str10 = rotation9.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rotation9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str10 + "' != '" + "Rotation.CLOCKWISE"+ "'", str10.equals("Rotation.CLOCKWISE"));

  }

  @Test
  public void test228() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test228"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis1 = new org.jfree.chart.axis.CategoryAxis("");
    java.awt.Font font3 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset4 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot5 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset4);
    org.jfree.chart.axis.ValueAxis valueAxis6 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot7 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis6);
    java.util.List list8 = combinedDomainXYPlot7.getAnnotations();
    waferMapPlot5.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot7);
    org.jfree.chart.JFreeChart jFreeChart11 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font3, (org.jfree.chart.plot.Plot)combinedDomainXYPlot7, true);
    categoryAxis1.setLabelFont(font3);
    java.awt.Graphics2D graphics2D13 = null;
    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot14 = new org.jfree.chart.plot.MultiplePiePlot();
    java.awt.Paint paint15 = multiplePiePlot14.getOutlinePaint();
    java.awt.Shape shape16 = multiplePiePlot14.getLegendItemShape();
    java.awt.Paint paint17 = multiplePiePlot14.getOutlinePaint();
    java.awt.Paint paint18 = multiplePiePlot14.getAggregatedItemsPaint();
    java.awt.geom.Rectangle2D rectangle2D19 = null;
    java.awt.Font font23 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset24 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot25 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset24);
    org.jfree.chart.axis.ValueAxis valueAxis26 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot27 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis26);
    java.util.List list28 = combinedDomainXYPlot27.getAnnotations();
    waferMapPlot25.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot27);
    org.jfree.chart.JFreeChart jFreeChart31 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font23, (org.jfree.chart.plot.Plot)combinedDomainXYPlot27, true);
    java.awt.Color color35 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment36 = new org.jfree.chart.text.TextFragment("hi!", font23, (java.awt.Paint)color35);
    java.awt.Paint paint37 = org.jfree.chart.plot.PiePlot.DEFAULT_LABEL_OUTLINE_PAINT;
    org.jfree.chart.plot.CategoryPlot categoryPlot38 = new org.jfree.chart.plot.CategoryPlot();
    boolean b39 = categoryPlot38.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge41 = categoryPlot38.getDomainAxisEdge(8);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment42 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment43 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement46 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment42, verticalAlignment43, 11.0d, 0.2d);
    org.jfree.chart.util.VerticalAlignment verticalAlignment47 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement50 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment42, verticalAlignment47, (-1.0d), Double.NaN);
    org.jfree.chart.util.VerticalAlignment verticalAlignment51 = org.jfree.chart.title.Title.DEFAULT_VERTICAL_ALIGNMENT;
    org.jfree.chart.util.RectangleInsets rectangleInsets52 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent53 = new org.jfree.data.general.SeriesChangeEvent((java.lang.Object)rectangleInsets52);
    org.jfree.chart.title.TextTitle textTitle54 = new org.jfree.chart.title.TextTitle("March", font23, paint37, rectangleEdge41, horizontalAlignment42, verticalAlignment51, rectangleInsets52);
    org.jfree.chart.plot.CategoryPlot categoryPlot55 = new org.jfree.chart.plot.CategoryPlot();
    boolean b56 = categoryPlot55.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge58 = categoryPlot55.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis60 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets61 = categoryAxis60.getLabelInsets();
    double d63 = rectangleInsets61.calculateLeftInset(4.0d);
    categoryPlot55.setInsets(rectangleInsets61, false);
    int i66 = categoryPlot55.getRendererCount();
    org.jfree.chart.axis.NumberAxis numberAxis67 = new org.jfree.chart.axis.NumberAxis();
    numberAxis67.centerRange(100.0d);
    java.awt.Paint paint70 = numberAxis67.getLabelPaint();
    categoryPlot55.setRangeCrosshairPaint(paint70);
    org.jfree.chart.entity.EntityCollection entityCollection73 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo74 = new org.jfree.chart.ChartRenderingInfo(entityCollection73);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo75 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo74);
    java.awt.geom.Point2D point2D76 = null;
    categoryPlot55.panRangeAxes(0.6d, plotRenderingInfo75, point2D76);
    org.jfree.chart.axis.AxisSpace axisSpace78 = new org.jfree.chart.axis.AxisSpace();
    java.lang.Object obj79 = axisSpace78.clone();
    java.lang.Object obj80 = axisSpace78.clone();
    categoryPlot55.setFixedRangeAxisSpace(axisSpace78, false);
    double d83 = axisSpace78.getBottom();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.axis.AxisSpace axisSpace84 = categoryAxis1.reserveSpace(graphics2D13, (org.jfree.chart.plot.Plot)multiplePiePlot14, rectangle2D19, rectangleEdge41, axisSpace78);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(verticalAlignment51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b56 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d63 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i66 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d83 == 0.0d);

  }

  @Test
  public void test229() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test229"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Color color10 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke11 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color12 = java.awt.Color.orange;
    java.awt.Stroke stroke13 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker15 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color10, stroke11, (java.awt.Paint)color12, stroke13, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer16 = null;
    intervalMarker15.setGradientPaintTransformer(gradientPaintTransformer16);
    org.jfree.chart.util.RectangleInsets rectangleInsets18 = intervalMarker15.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis20 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets21 = categoryAxis20.getLabelInsets();
    intervalMarker15.setLabelOffset(rectangleInsets21);
    double d23 = intervalMarker15.getEndValue();
    org.jfree.chart.util.Layer layer24 = null;
    boolean b25 = categoryPlot0.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker15, layer24);
    boolean b26 = categoryPlot0.isRangeCrosshairLockedOnData();
    org.jfree.chart.axis.AxisLocation axisLocation27 = categoryPlot0.getDomainAxisLocation();
    org.jfree.chart.axis.LogAxis logAxis29 = new org.jfree.chart.axis.LogAxis("ClassContext");
    logAxis29.zoomRange(0.0d, 4.5d);
    int i33 = categoryPlot0.getRangeAxisIndex((org.jfree.chart.axis.ValueAxis)logAxis29);
    java.awt.Graphics2D graphics2D34 = null;
    java.awt.geom.Rectangle2D rectangle2D36 = null;
    java.awt.geom.Rectangle2D rectangle2D37 = null;
    java.awt.Font font39 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset40 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot41 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset40);
    org.jfree.chart.axis.ValueAxis valueAxis42 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot43 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis42);
    java.util.List list44 = combinedDomainXYPlot43.getAnnotations();
    waferMapPlot41.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot43);
    boolean b46 = combinedDomainXYPlot43.isNotify();
    org.jfree.chart.JFreeChart jFreeChart48 = new org.jfree.chart.JFreeChart("", font39, (org.jfree.chart.plot.Plot)combinedDomainXYPlot43, true);
    combinedDomainXYPlot43.setDomainMinorGridlinesVisible(false);
    java.lang.Object obj51 = null;
    boolean b52 = combinedDomainXYPlot43.equals(obj51);
    java.awt.Stroke stroke53 = combinedDomainXYPlot43.getDomainGridlineStroke();
    org.jfree.chart.util.RectangleEdge rectangleEdge54 = combinedDomainXYPlot43.getDomainAxisEdge();
    org.jfree.data.xy.XYSeries xYSeries55 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection56 = new org.jfree.data.xy.XYSeriesCollection(xYSeries55);
    boolean b57 = xYSeriesCollection56.isAutoWidth();
    org.jfree.data.Range range59 = xYSeriesCollection56.getRangeBounds(true);
    xYSeriesCollection56.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis62 = new org.jfree.chart.axis.NumberAxis();
    numberAxis62.centerRange(100.0d);
    java.lang.Object obj65 = numberAxis62.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer66 = null;
    org.jfree.chart.plot.PolarPlot polarPlot67 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection56, (org.jfree.chart.axis.ValueAxis)numberAxis62, polarItemRenderer66);
    org.jfree.chart.plot.PlotOrientation plotOrientation68 = polarPlot67.getOrientation();
    org.jfree.chart.axis.ValueAxis valueAxis71 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot72 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis71);
    org.jfree.chart.plot.PlotOrientation plotOrientation73 = combinedDomainXYPlot72.getOrientation();
    boolean b74 = combinedDomainXYPlot72.isDomainCrosshairLockedOnData();
    org.jfree.chart.entity.EntityCollection entityCollection76 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo77 = new org.jfree.chart.ChartRenderingInfo(entityCollection76);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo78 = chartRenderingInfo77.getPlotInfo();
    java.awt.geom.Point2D point2D79 = null;
    combinedDomainXYPlot72.panDomainAxes(4.5d, plotRenderingInfo78, point2D79);
    int i81 = plotRenderingInfo78.getSubplotCount();
    org.jfree.chart.entity.EntityCollection entityCollection82 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo83 = new org.jfree.chart.ChartRenderingInfo(entityCollection82);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo84 = chartRenderingInfo83.getPlotInfo();
    plotRenderingInfo78.addSubplotInfo(plotRenderingInfo84);
    java.awt.geom.Rectangle2D rectangle2D86 = null;
    org.jfree.chart.util.RectangleAnchor rectangleAnchor87 = null;
    java.awt.geom.Point2D point2D88 = org.jfree.chart.util.RectangleAnchor.coordinates(rectangle2D86, rectangleAnchor87);
    polarPlot67.zoomDomainAxes(1.0d, 0.6d, plotRenderingInfo84, point2D88);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.axis.AxisState axisState90 = logAxis29.draw(graphics2D34, 0.0d, rectangle2D36, rectangle2D37, rectangleEdge54, plotRenderingInfo84);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d23 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i33 == (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b46 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b52 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b57 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation68);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation73);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b74 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo78);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i81 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point2D88);

  }

  @Test
  public void test230() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test230"); }


    org.jfree.chart.renderer.category.BarRenderer barRenderer0 = new org.jfree.chart.renderer.category.BarRenderer();
    double d1 = barRenderer0.getShadowXOffset();
    org.jfree.chart.labels.CategoryItemLabelGenerator categoryItemLabelGenerator3 = barRenderer0.getSeriesItemLabelGenerator((-25560));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryItemLabelGenerator3);

  }

  @Test
  public void test231() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test231"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis5 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets6 = categoryAxis5.getLabelInsets();
    double d8 = rectangleInsets6.calculateLeftInset(4.0d);
    categoryPlot0.setInsets(rectangleInsets6, false);
    int i11 = categoryPlot0.getRendererCount();
    org.jfree.chart.axis.NumberAxis numberAxis12 = new org.jfree.chart.axis.NumberAxis();
    numberAxis12.centerRange(100.0d);
    java.awt.Paint paint15 = numberAxis12.getLabelPaint();
    categoryPlot0.setRangeCrosshairPaint(paint15);
    org.jfree.chart.entity.EntityCollection entityCollection18 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo19 = new org.jfree.chart.ChartRenderingInfo(entityCollection18);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo20 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo19);
    java.awt.geom.Point2D point2D21 = null;
    categoryPlot0.panRangeAxes(0.6d, plotRenderingInfo20, point2D21);
    org.jfree.chart.plot.DatasetRenderingOrder datasetRenderingOrder23 = org.jfree.chart.plot.DatasetRenderingOrder.FORWARD;
    org.jfree.chart.axis.ValueAxis valueAxis24 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot25 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis24);
    java.util.List list26 = combinedDomainXYPlot25.getAnnotations();
    combinedDomainXYPlot25.setRangeGridlinesVisible(true);
    org.jfree.chart.util.RectangleEdge rectangleEdge30 = combinedDomainXYPlot25.getRangeAxisEdge(4);
    boolean b31 = datasetRenderingOrder23.equals((java.lang.Object)combinedDomainXYPlot25);
    categoryPlot0.setDatasetRenderingOrder(datasetRenderingOrder23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i11 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(datasetRenderingOrder23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);

  }

  @Test
  public void test232() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test232"); }


    int i0 = java.awt.Transparency.BITMASK;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 2);

  }

  @Test
  public void test233() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test233"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    java.awt.Shape shape3 = xYAreaRenderer1.getBaseShape();
    xYAreaRenderer1.setSeriesVisibleInLegend(10, (java.lang.Boolean)false, true);
    java.awt.Paint paint9 = xYAreaRenderer1.getSeriesFillPaint(10);
    org.jfree.chart.labels.StandardXYSeriesLabelGenerator standardXYSeriesLabelGenerator11 = new org.jfree.chart.labels.StandardXYSeriesLabelGenerator("");
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D13 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.geom.Rectangle2D rectangle2D19 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge20 = null;
    double d21 = categoryAxis3D13.getCategorySeriesMiddle((-1), 255, (-1), 0, 0.0d, rectangle2D19, rectangleEdge20);
    boolean b22 = standardXYSeriesLabelGenerator11.equals((java.lang.Object)rectangle2D19);
    xYAreaRenderer1.setLegendItemURLGenerator((org.jfree.chart.labels.XYSeriesLabelGenerator)standardXYSeriesLabelGenerator11);
    java.lang.String[] str_array24 = org.jfree.data.time.SerialDate.getMonths();
    boolean b25 = standardXYSeriesLabelGenerator11.equals((java.lang.Object)str_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d21, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);

  }

  @Test
  public void test234() {}
// Defects4J: flaky method
//   @Test
//   public void test234() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test234"); }
// 
// 
//     org.jfree.data.time.Month month1 = new org.jfree.data.time.Month();
//     int i2 = month1.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem4 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month1, (java.lang.Number)8);
//     long long5 = month1.getFirstMillisecond();
//     org.jfree.data.time.Month month6 = new org.jfree.data.time.Month();
//     int i7 = month6.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis8 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month1, (org.jfree.data.time.RegularTimePeriod)month6);
//     periodAxis8.setUpperMargin(10.0d);
//     org.jfree.data.Range range11 = periodAxis8.getRange();
//     org.jfree.chart.util.RectangleInsets rectangleInsets12 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
//     double d13 = rectangleInsets12.getLeft();
//     double d15 = rectangleInsets12.calculateLeftOutset(1.0d);
//     double d17 = rectangleInsets12.calculateRightInset(0.05d);
//     periodAxis8.setLabelInsets(rectangleInsets12);
//     java.awt.geom.Rectangle2D rectangle2D20 = null;
//     org.jfree.data.general.WaferMapDataset waferMapDataset21 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot22 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset21);
//     org.jfree.chart.JFreeChart jFreeChart23 = null;
//     org.jfree.chart.event.ChartChangeEvent chartChangeEvent24 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot22, jFreeChart23);
//     org.jfree.chart.util.HorizontalAlignment horizontalAlignment25 = org.jfree.chart.util.HorizontalAlignment.LEFT;
//     org.jfree.chart.util.VerticalAlignment verticalAlignment26 = null;
//     org.jfree.chart.block.FlowArrangement flowArrangement29 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment25, verticalAlignment26, 11.0d, 0.2d);
//     org.jfree.chart.block.BorderArrangement borderArrangement30 = new org.jfree.chart.block.BorderArrangement();
//     org.jfree.chart.title.LegendTitle legendTitle31 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot22, (org.jfree.chart.block.Arrangement)flowArrangement29, (org.jfree.chart.block.Arrangement)borderArrangement30);
//     org.jfree.chart.plot.CategoryPlot categoryPlot32 = new org.jfree.chart.plot.CategoryPlot();
//     boolean b33 = categoryPlot32.isRangeZoomable();
//     org.jfree.chart.util.RectangleEdge rectangleEdge35 = categoryPlot32.getDomainAxisEdge(8);
//     legendTitle31.setPosition(rectangleEdge35);
//     // The following exception was thrown during execution in test generation
//     try {
//       double d37 = periodAxis8.java2DToValue(100.0d, rectangle2D20, rectangleEdge35);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i2 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i7 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(range11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d13 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d15 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d17 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(horizontalAlignment25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b33 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleEdge35);
// 
//   }

  @Test
  public void test235() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test235"); }


    org.jfree.data.Range range0 = null;
    org.jfree.data.time.DateRange dateRange3 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange6 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b7 = dateRange3.intersects((org.jfree.data.Range)dateRange6);
    org.jfree.chart.block.RectangleConstraint rectangleConstraint8 = new org.jfree.chart.block.RectangleConstraint(range0, (org.jfree.data.Range)dateRange6);
    double d9 = rectangleConstraint8.getWidth();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d9 == 0.0d);

  }

  @Test
  public void test236() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test236"); }


    org.jfree.chart.util.VerticalAlignment verticalAlignment0 = org.jfree.chart.util.VerticalAlignment.CENTER;
    java.lang.String str1 = verticalAlignment0.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(verticalAlignment0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "VerticalAlignment.CENTER"+ "'", str1.equals("VerticalAlignment.CENTER"));

  }

  @Test
  public void test237() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test237"); }


    org.jfree.chart.text.TextBlock textBlock0 = new org.jfree.chart.text.TextBlock();
    org.jfree.chart.text.TextLine textLine2 = new org.jfree.chart.text.TextLine("March");
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment18 = new org.jfree.chart.text.TextFragment("hi!", font5, (java.awt.Paint)color17);
    textLine2.addFragment(textFragment18);
    textBlock0.addLine(textLine2);
    java.awt.Graphics2D graphics2D21 = null;
    org.jfree.chart.text.TextBlockAnchor textBlockAnchor24 = org.jfree.chart.text.TextBlockAnchor.CENTER_RIGHT;
    // The following exception was thrown during execution in test generation
    try {
      textBlock0.draw(graphics2D21, (-1.0f), 0.0f, textBlockAnchor24);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textBlockAnchor24);

  }

  @Test
  public void test238() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test238"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis5 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets6 = categoryAxis5.getLabelInsets();
    double d8 = rectangleInsets6.calculateLeftInset(4.0d);
    categoryPlot0.setInsets(rectangleInsets6, false);
    org.jfree.chart.util.Layer layer12 = null;
    java.util.Collection collection13 = categoryPlot0.getDomainMarkers(5, layer12);
    org.jfree.data.general.DatasetGroup datasetGroup14 = categoryPlot0.getDatasetGroup();
    org.jfree.chart.entity.EntityCollection entityCollection16 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo17 = new org.jfree.chart.ChartRenderingInfo(entityCollection16);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo18 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo17);
    java.awt.geom.Point2D point2D19 = null;
    categoryPlot0.zoomDomainAxes(12.0d, plotRenderingInfo18, point2D19, true);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo23 = plotRenderingInfo18.getSubplotInfo(0);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(datasetGroup14);

  }

  @Test
  public void test239() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test239"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    java.awt.Graphics2D graphics2D4 = null;
    java.awt.geom.Rectangle2D rectangle2D5 = null;
    org.jfree.data.general.DefaultPieDataset defaultPieDataset6 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj7 = defaultPieDataset6.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D8 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset6);
    piePlot3D8.setIgnoreZeroValues(true);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo12 = null;
    org.jfree.chart.plot.PiePlotState piePlotState13 = piePlot3D2.initialise(graphics2D4, rectangle2D5, (org.jfree.chart.plot.PiePlot)piePlot3D8, (java.lang.Integer)1, plotRenderingInfo12);
    org.jfree.chart.labels.PieSectionLabelGenerator pieSectionLabelGenerator14 = piePlot3D8.getLegendLabelToolTipGenerator();
    org.jfree.chart.util.RectangleInsets rectangleInsets15 = piePlot3D8.getSimpleLabelOffset();
    java.awt.Paint paint16 = piePlot3D8.getLabelShadowPaint();
    org.jfree.chart.util.LogFormat logFormat21 = new org.jfree.chart.util.LogFormat(10.0d, "", true);
    java.lang.String str23 = logFormat21.format((java.lang.Object)100.0f);
    org.jfree.chart.util.LogFormat logFormat27 = new org.jfree.chart.util.LogFormat(10.0d, "", true);
    org.jfree.chart.labels.StandardPieSectionLabelGenerator standardPieSectionLabelGenerator28 = new org.jfree.chart.labels.StandardPieSectionLabelGenerator("", (java.text.NumberFormat)logFormat21, (java.text.NumberFormat)logFormat27);
    piePlot3D8.setLegendLabelToolTipGenerator((org.jfree.chart.labels.PieSectionLabelGenerator)standardPieSectionLabelGenerator28);
    java.lang.Object obj30 = piePlot3D8.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(piePlotState13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(pieSectionLabelGenerator14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str23 + "' != '" + "^2.0"+ "'", str23.equals("^2.0"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj30);

  }

  @Test
  public void test240() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test240"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
    numberAxis15.centerRange(100.0d);
    combinedDomainXYPlot9.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis15);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier19 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot9.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.clearRangeMarkers(100);
    double d24 = categoryPlot0.getRangeCrosshairValue();
    int i25 = categoryPlot0.getRangeAxisCount();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d24 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i25 == 1);

  }

  @Test
  public void test241() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test241"); }


    java.text.NumberFormat numberFormat0 = java.text.NumberFormat.getIntegerInstance();
    java.util.Currency currency1 = numberFormat0.getCurrency();
    numberFormat0.setMinimumIntegerDigits(64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(currency1);

  }

  @Test
  public void test242() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test242"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    org.jfree.data.time.TimeSeries timeSeries11 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection12 = new org.jfree.data.time.TimeSeriesCollection(timeSeries11);
    timeSeriesCollection12.validateObject();
    java.lang.Comparable comparable14 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer15 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.data.general.Dataset)timeSeriesCollection12, comparable14);
    org.jfree.data.DomainOrder domainOrder16 = timeSeriesCollection12.getDomainOrder();
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number19 = timeSeriesCollection12.getY(1, 3);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder16);

  }

  @Test
  public void test243() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test243"); }


    org.jfree.data.xy.XYSeries xYSeries0 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection1 = new org.jfree.data.xy.XYSeriesCollection(xYSeries0);
    boolean b2 = xYSeriesCollection1.isAutoWidth();
    org.jfree.data.Range range4 = xYSeriesCollection1.getRangeBounds(true);
    xYSeriesCollection1.setIntervalWidth(1.0d);
    org.jfree.data.xy.XYSeries xYSeries10 = new org.jfree.data.xy.XYSeries((java.lang.Comparable)10.0d, false, false);
    xYSeriesCollection1.removeSeries(xYSeries10);
    boolean b12 = org.jfree.data.general.DatasetUtilities.isEmptyOrNull((org.jfree.data.xy.XYDataset)xYSeriesCollection1);
    org.jfree.chart.plot.CategoryPlot categoryPlot13 = new org.jfree.chart.plot.CategoryPlot();
    org.jfree.chart.axis.ValueAxis valueAxis15 = categoryPlot13.getRangeAxisForDataset(14);
    org.jfree.chart.axis.CategoryAxis categoryAxis17 = null;
    categoryPlot13.setDomainAxis(0, categoryAxis17);
    org.jfree.chart.renderer.category.CategoryItemRenderer categoryItemRenderer19 = categoryPlot13.getRenderer();
    xYSeriesCollection1.removeChangeListener((org.jfree.data.general.DatasetChangeListener)categoryPlot13);
    // The following exception was thrown during execution in test generation
    try {
      double d23 = xYSeriesCollection1.getYValue(64, 64);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(valueAxis15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryItemRenderer19);

  }

  @Test
  public void test244() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test244"); }


    org.jfree.chart.block.RectangleConstraint rectangleConstraint0 = org.jfree.chart.block.RectangleConstraint.NONE;
    double d1 = rectangleConstraint0.getHeight();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleConstraint0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.0d);

  }

  @Test
  public void test245() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test245"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis0 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset1 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot2 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset1);
    org.jfree.chart.axis.ValueAxis valueAxis3 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot4 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis3);
    java.util.List list5 = combinedDomainXYPlot4.getAnnotations();
    waferMapPlot2.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot4);
    int i7 = combinedDomainXYPlot4.getSeriesCount();
    categoryAxis0.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot4);
    java.awt.Color color15 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke16 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color17 = java.awt.Color.orange;
    java.awt.Stroke stroke18 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker20 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color15, stroke16, (java.awt.Paint)color17, stroke18, 0.0f);
    java.awt.Paint paint21 = intervalMarker20.getOutlinePaint();
    org.jfree.chart.util.Layer layer22 = null;
    combinedDomainXYPlot4.addRangeMarker(0, (org.jfree.chart.plot.Marker)intervalMarker20, layer22);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer26 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition28 = xYAreaRenderer26.getSeriesNegativeItemLabelPosition(1);
    combinedDomainXYPlot4.setRenderer(5, (org.jfree.chart.renderer.xy.XYItemRenderer)xYAreaRenderer26);
    combinedDomainXYPlot4.setRangeZeroBaselineVisible(false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition28);

  }

  @Test
  public void test246() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test246"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.renderer.WaferMapRenderer waferMapRenderer4 = null;
    waferMapPlot1.setRenderer(waferMapRenderer4);
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    waferMapPlot1.setDataset(waferMapDataset6);

  }

  @Test
  public void test247() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test247"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    double d3 = xYBarRenderer1.getShadowXOffset();
    org.jfree.chart.urls.XYURLGenerator xYURLGenerator4 = null;
    xYBarRenderer1.setBaseURLGenerator(xYURLGenerator4, true);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer8 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator9 = xYAreaRenderer8.getLegendItemToolTipGenerator();
    boolean b12 = xYAreaRenderer8.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition16 = xYAreaRenderer8.getPositiveItemLabelPosition(8, 10, false);
    xYBarRenderer1.setNegativeItemLabelPositionFallback(itemLabelPosition16);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier18 = xYBarRenderer1.getDrawingSupplier();
    org.jfree.chart.axis.NumberAxis numberAxis19 = new org.jfree.chart.axis.NumberAxis();
    numberAxis19.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer23 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator24 = xYAreaRenderer23.getLegendItemToolTipGenerator();
    java.awt.Shape shape25 = xYAreaRenderer23.getBaseShape();
    numberAxis19.setUpArrow(shape25);
    xYBarRenderer1.setLegendBar(shape25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d3 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape25);

  }

  @Test
  public void test248() {}
// Defects4J: flaky method
//   @Test
//   public void test248() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test248"); }
// 
// 
//     org.jfree.chart.axis.DateTickUnitType dateTickUnitType0 = org.jfree.chart.axis.DateTickUnitType.MONTH;
//     org.jfree.chart.axis.DateTickUnitType dateTickUnitType2 = org.jfree.chart.axis.DateTickUnitType.MINUTE;
//     org.jfree.chart.axis.DateTickUnitType dateTickUnitType4 = org.jfree.chart.axis.DateTickUnitType.MONTH;
//     org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer7 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
//     double d8 = xYBarRenderer7.getMargin();
//     boolean b9 = xYBarRenderer7.getAutoPopulateSeriesShape();
//     org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator11 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
//     xYBarRenderer7.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator11, true);
//     java.lang.Object obj14 = standardXYToolTipGenerator11.clone();
//     java.text.DateFormat dateFormat15 = standardXYToolTipGenerator11.getXDateFormat();
//     org.jfree.chart.axis.DateTickUnit dateTickUnit16 = new org.jfree.chart.axis.DateTickUnit(dateTickUnitType2, 5, dateTickUnitType4, 4, dateFormat15);
//     org.jfree.chart.axis.DateTickUnitType dateTickUnitType18 = org.jfree.chart.axis.DateTickUnitType.MINUTE;
//     org.jfree.chart.axis.DateTickUnitType dateTickUnitType20 = org.jfree.chart.axis.DateTickUnitType.MONTH;
//     org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer23 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
//     double d24 = xYBarRenderer23.getMargin();
//     boolean b25 = xYBarRenderer23.getAutoPopulateSeriesShape();
//     org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator27 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
//     xYBarRenderer23.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator27, true);
//     java.lang.Object obj30 = standardXYToolTipGenerator27.clone();
//     java.text.DateFormat dateFormat31 = standardXYToolTipGenerator27.getXDateFormat();
//     org.jfree.chart.axis.DateTickUnit dateTickUnit32 = new org.jfree.chart.axis.DateTickUnit(dateTickUnitType18, 5, dateTickUnitType20, 4, dateFormat31);
//     org.jfree.chart.axis.DateTickUnit dateTickUnit33 = new org.jfree.chart.axis.DateTickUnit(dateTickUnitType0, 2016, dateTickUnitType2, 7, dateFormat31);
//     org.jfree.chart.axis.DateTickUnitType dateTickUnitType34 = org.jfree.chart.axis.DateTickUnitType.MINUTE;
//     org.jfree.chart.axis.DateTickUnitType dateTickUnitType36 = org.jfree.chart.axis.DateTickUnitType.MONTH;
//     org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer39 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
//     double d40 = xYBarRenderer39.getMargin();
//     boolean b41 = xYBarRenderer39.getAutoPopulateSeriesShape();
//     org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator43 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
//     xYBarRenderer39.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator43, true);
//     java.lang.Object obj46 = standardXYToolTipGenerator43.clone();
//     java.text.DateFormat dateFormat47 = standardXYToolTipGenerator43.getXDateFormat();
//     org.jfree.chart.axis.DateTickUnit dateTickUnit48 = new org.jfree.chart.axis.DateTickUnit(dateTickUnitType34, 5, dateTickUnitType36, 4, dateFormat47);
//     org.jfree.data.time.DateRange dateRange51 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d52 = dateRange51.getLength();
//     long long53 = dateRange51.getLowerMillis();
//     double d54 = dateRange51.getLength();
//     java.lang.String str55 = dateRange51.toString();
//     java.util.Date date56 = dateRange51.getUpperDate();
//     org.jfree.data.time.DateRange dateRange59 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d60 = dateRange59.getLength();
//     long long61 = dateRange59.getLowerMillis();
//     double d62 = dateRange59.getLength();
//     java.lang.String str63 = dateRange59.toString();
//     java.util.Date date64 = dateRange59.getUpperDate();
//     java.util.TimeZone timeZone65 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year66 = new org.jfree.data.time.Year(date64, timeZone65);
//     java.util.Date date67 = dateTickUnit48.rollDate(date56, timeZone65);
//     java.lang.String str68 = dateTickUnit33.dateToString(date67);
//     org.jfree.data.time.DateRange dateRange71 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d72 = dateRange71.getLength();
//     long long73 = dateRange71.getLowerMillis();
//     double d74 = dateRange71.getLength();
//     java.lang.String str75 = dateRange71.toString();
//     java.util.Date date76 = dateRange71.getUpperDate();
//     org.jfree.data.time.SerialDate serialDate77 = org.jfree.data.time.SerialDate.createInstance(date76);
//     // The following exception was thrown during execution in test generation
//     try {
//       org.jfree.data.time.DateRange dateRange78 = new org.jfree.data.time.DateRange(date67, date76);
//       org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
//     } catch (java.lang.IllegalArgumentException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateTickUnitType0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateTickUnitType2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateTickUnitType4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d8 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b9 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(standardXYToolTipGenerator11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateFormat15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateTickUnitType18);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateTickUnitType20);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d24 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b25 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(standardXYToolTipGenerator27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj30);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateFormat31);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateTickUnitType34);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateTickUnitType36);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d40 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b41 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(standardXYToolTipGenerator43);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj46);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateFormat47);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d52 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long53 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d54 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str55 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str55.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date56);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d60 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long61 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d62 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str63 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str63.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date64);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone65);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date67);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str68 + "' != '" + "30/04/70 16:00"+ "'", str68.equals("30/04/70 16:00"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d72 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long73 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d74 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str75 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str75.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date76);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(serialDate77);
// 
//   }

  @Test
  public void test249() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test249"); }


    org.jfree.chart.axis.NumberAxis numberAxis0 = new org.jfree.chart.axis.NumberAxis();
    numberAxis0.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer4 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator5 = xYAreaRenderer4.getLegendItemToolTipGenerator();
    java.awt.Shape shape6 = xYAreaRenderer4.getBaseShape();
    numberAxis0.setUpArrow(shape6);
    numberAxis0.pan((-1.0d));
    java.awt.Paint paint10 = numberAxis0.getAxisLinePaint();
    double d11 = numberAxis0.getUpperMargin();
    // The following exception was thrown during execution in test generation
    try {
      numberAxis0.setRange(3.0d, 2.0d);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d11 == 0.05d);

  }

  @Test
  public void test250() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test250"); }


    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator1 = null;
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator3 = new org.jfree.chart.urls.StandardXYURLGenerator("");
    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer4 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(100, xYToolTipGenerator1, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator3);
    xYStepAreaRenderer4.setPlotArea(true);
    java.lang.Object obj7 = null;
    boolean b8 = xYStepAreaRenderer4.equals(obj7);
    boolean b9 = xYStepAreaRenderer4.getBaseItemLabelsVisible();
    boolean b10 = xYStepAreaRenderer4.isOutline();
    boolean b11 = xYStepAreaRenderer4.isOutline();
    boolean b12 = xYStepAreaRenderer4.getPlotArea();
    java.lang.String[] str_array14 = org.jfree.data.time.SerialDate.getMonths(false);
    boolean b15 = xYStepAreaRenderer4.equals((java.lang.Object)false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);

  }

  @Test
  public void test251() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test251"); }


    java.awt.Paint paint0 = org.jfree.chart.axis.SymbolAxis.DEFAULT_GRID_BAND_ALTERNATE_PAINT;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint0);

  }

  @Test
  public void test252() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test252"); }


    org.jfree.chart.axis.NumberAxis numberAxis0 = new org.jfree.chart.axis.NumberAxis();
    numberAxis0.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer4 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator5 = xYAreaRenderer4.getLegendItemToolTipGenerator();
    java.awt.Shape shape6 = xYAreaRenderer4.getBaseShape();
    numberAxis0.setUpArrow(shape6);
    org.jfree.chart.axis.MarkerAxisBand markerAxisBand8 = numberAxis0.getMarkerBand();
    numberAxis0.setAutoRangeMinimumSize(0.6d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(markerAxisBand8);

  }

  @Test
  public void test253() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test253"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = xYStepRenderer0.getSeriesPositiveItemLabelPosition(3);
    java.util.Collection collection3 = xYStepRenderer0.getAnnotations();
    boolean b4 = xYStepRenderer0.getDrawOutlines();
    java.awt.Font font5 = xYStepRenderer0.getBaseLegendTextFont();
    java.lang.Boolean b7 = null;
    // The following exception was thrown during execution in test generation
    try {
      xYStepRenderer0.setSeriesLinesVisible((-1), b7);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(collection3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(font5);

  }

  @Test
  public void test254() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test254"); }


    org.jfree.chart.resources.JFreeChartResources jFreeChartResources0 = new org.jfree.chart.resources.JFreeChartResources();
    java.util.Enumeration enumeration1 = jFreeChartResources0.getKeys();
    java.util.Enumeration enumeration2 = jFreeChartResources0.getKeys();
    // The following exception was thrown during execution in test generation
    try {
      java.lang.String[] str_array4 = jFreeChartResources0.getStringArray("Rotation.CLOCKWISE");
      org.junit.Assert.fail("Expected exception of type java.util.MissingResourceException");
    } catch (java.util.MissingResourceException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.util.MissingResourceException")) {
        org.junit.Assert.fail("Expected exception of type java.util.MissingResourceException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(enumeration1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(enumeration2);

  }

  @Test
  public void test255() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test255"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    java.awt.Graphics2D graphics2D4 = null;
    java.awt.geom.Rectangle2D rectangle2D5 = null;
    org.jfree.data.general.DefaultPieDataset defaultPieDataset6 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj7 = defaultPieDataset6.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D8 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset6);
    piePlot3D8.setIgnoreZeroValues(true);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo12 = null;
    org.jfree.chart.plot.PiePlotState piePlotState13 = piePlot3D2.initialise(graphics2D4, rectangle2D5, (org.jfree.chart.plot.PiePlot)piePlot3D8, (java.lang.Integer)1, plotRenderingInfo12);
    org.jfree.chart.axis.NumberAxis numberAxis14 = new org.jfree.chart.axis.NumberAxis();
    numberAxis14.resizeRange2(10.0d, 11.0d);
    org.jfree.chart.util.RectangleInsets rectangleInsets18 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d19 = rectangleInsets18.getLeft();
    numberAxis14.setTickLabelInsets(rectangleInsets18);
    org.jfree.data.Range range21 = numberAxis14.getRange();
    java.awt.Shape shape22 = numberAxis14.getRightArrow();
    boolean b23 = piePlot3D8.equals((java.lang.Object)numberAxis14);
    java.awt.Graphics2D graphics2D24 = null;
    java.awt.geom.Rectangle2D rectangle2D25 = null;
    org.jfree.chart.axis.ValueAxis valueAxis26 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot27 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis26);
    org.jfree.chart.plot.PlotOrientation plotOrientation28 = combinedDomainXYPlot27.getOrientation();
    boolean b29 = combinedDomainXYPlot27.isDomainCrosshairLockedOnData();
    org.jfree.chart.entity.EntityCollection entityCollection31 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo32 = new org.jfree.chart.ChartRenderingInfo(entityCollection31);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo33 = chartRenderingInfo32.getPlotInfo();
    java.awt.geom.Point2D point2D34 = null;
    combinedDomainXYPlot27.panDomainAxes(4.5d, plotRenderingInfo33, point2D34);
    int i36 = plotRenderingInfo33.getSubplotCount();
    org.jfree.chart.entity.EntityCollection entityCollection37 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo38 = new org.jfree.chart.ChartRenderingInfo(entityCollection37);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo39 = chartRenderingInfo38.getPlotInfo();
    plotRenderingInfo33.addSubplotInfo(plotRenderingInfo39);
    java.awt.geom.Rectangle2D rectangle2D41 = null;
    org.jfree.chart.util.RectangleAnchor rectangleAnchor42 = null;
    java.awt.geom.Point2D point2D43 = org.jfree.chart.util.RectangleAnchor.coordinates(rectangle2D41, rectangleAnchor42);
    int i44 = plotRenderingInfo39.getSubplotIndex(point2D43);
    org.jfree.chart.plot.PlotState plotState45 = new org.jfree.chart.plot.PlotState();
    java.util.Map map46 = plotState45.getSharedAxisStates();
    java.util.Map map47 = plotState45.getSharedAxisStates();
    org.jfree.chart.axis.ValueAxis valueAxis48 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot49 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis48);
    org.jfree.chart.plot.PlotOrientation plotOrientation50 = combinedDomainXYPlot49.getOrientation();
    boolean b51 = combinedDomainXYPlot49.isDomainCrosshairLockedOnData();
    org.jfree.chart.entity.EntityCollection entityCollection53 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo54 = new org.jfree.chart.ChartRenderingInfo(entityCollection53);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo55 = chartRenderingInfo54.getPlotInfo();
    java.awt.geom.Point2D point2D56 = null;
    combinedDomainXYPlot49.panDomainAxes(4.5d, plotRenderingInfo55, point2D56);
    int i58 = plotRenderingInfo55.getSubplotCount();
    org.jfree.chart.entity.EntityCollection entityCollection59 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo60 = new org.jfree.chart.ChartRenderingInfo(entityCollection59);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo61 = chartRenderingInfo60.getPlotInfo();
    plotRenderingInfo55.addSubplotInfo(plotRenderingInfo61);
    java.awt.geom.Rectangle2D rectangle2D63 = null;
    org.jfree.chart.util.RectangleAnchor rectangleAnchor64 = null;
    java.awt.geom.Point2D point2D65 = org.jfree.chart.util.RectangleAnchor.coordinates(rectangle2D63, rectangleAnchor64);
    int i66 = plotRenderingInfo61.getSubplotIndex(point2D65);
    // The following exception was thrown during execution in test generation
    try {
      piePlot3D8.draw(graphics2D24, rectangle2D25, point2D43, plotState45, plotRenderingInfo61);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(piePlotState13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d19 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i36 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point2D43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i44 == (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(map46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(map47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b51 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i58 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point2D65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i66 == (-1));

  }

  @Test
  public void test256() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test256"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    piePlot3D2.setLabelLinksVisible(false);
    boolean b6 = piePlot3D2.getLabelLinksVisible();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);

  }

  @Test
  public void test257() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test257"); }


    org.jfree.chart.block.ColumnArrangement columnArrangement0 = new org.jfree.chart.block.ColumnArrangement();
    org.jfree.data.general.WaferMapDataset waferMapDataset1 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot2 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset1);
    org.jfree.chart.JFreeChart jFreeChart3 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent4 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot2, jFreeChart3);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment5 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment6 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement9 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment5, verticalAlignment6, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement10 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle11 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot2, (org.jfree.chart.block.Arrangement)flowArrangement9, (org.jfree.chart.block.Arrangement)borderArrangement10);
    org.jfree.data.time.TimeSeries timeSeries12 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection13 = new org.jfree.data.time.TimeSeriesCollection(timeSeries12);
    timeSeriesCollection13.validateObject();
    java.lang.Comparable comparable15 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer16 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement9, (org.jfree.data.general.Dataset)timeSeriesCollection13, comparable15);
    org.jfree.data.general.Dataset dataset17 = legendItemBlockContainer16.getDataset();
    java.lang.Comparable comparable18 = legendItemBlockContainer16.getSeriesKey();
    java.awt.Graphics2D graphics2D19 = null;
    org.jfree.data.Range range20 = null;
    org.jfree.chart.block.RectangleConstraint rectangleConstraint22 = new org.jfree.chart.block.RectangleConstraint(range20, 100.0d);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.util.Size2D size2D23 = columnArrangement0.arrange((org.jfree.chart.block.BlockContainer)legendItemBlockContainer16, graphics2D19, rectangleConstraint22);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dataset17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(comparable18);

  }

  @Test
  public void test258() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test258"); }


    org.jfree.data.time.SpreadsheetDate spreadsheetDate1 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate3 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b4 = spreadsheetDate1.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate3);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate6 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate8 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b9 = spreadsheetDate6.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate8);
    int i10 = spreadsheetDate6.getYYYY();
    org.jfree.data.time.SpreadsheetDate spreadsheetDate12 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate14 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b15 = spreadsheetDate12.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate14);
    int i16 = spreadsheetDate14.getMonth();
    boolean b17 = spreadsheetDate6.isOnOrBefore((org.jfree.data.time.SerialDate)spreadsheetDate14);
    int i18 = spreadsheetDate14.getDayOfWeek();
    boolean b19 = spreadsheetDate1.isOnOrBefore((org.jfree.data.time.SerialDate)spreadsheetDate14);
    org.jfree.data.general.WaferMapDataset waferMapDataset20 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot21 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset20);
    org.jfree.chart.axis.ValueAxis valueAxis22 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot23 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis22);
    java.util.List list24 = combinedDomainXYPlot23.getAnnotations();
    waferMapPlot21.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot23);
    int i26 = combinedDomainXYPlot23.getSeriesCount();
    boolean b28 = combinedDomainXYPlot23.equals((java.lang.Object)10.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer30 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    xYAreaRenderer30.setSeriesCreateEntities(15, (java.lang.Boolean)true, true);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition36 = xYAreaRenderer30.getSeriesPositiveItemLabelPosition(3);
    boolean b37 = combinedDomainXYPlot23.equals((java.lang.Object)3);
    boolean b38 = combinedDomainXYPlot23.isDomainZoomable();
    java.awt.Shape shape46 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color48 = java.awt.Color.green;
    java.awt.Color color50 = java.awt.Color.green;
    java.awt.Color color56 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke57 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color58 = java.awt.Color.orange;
    java.awt.Stroke stroke59 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker61 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color56, stroke57, (java.awt.Paint)color58, stroke59, 0.0f);
    java.awt.Shape shape65 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke66 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color67 = java.awt.Color.green;
    java.lang.String str68 = org.jfree.chart.util.PaintUtilities.colorToString(color67);
    org.jfree.chart.LegendItem legendItem69 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape46, true, (java.awt.Paint)color48, false, (java.awt.Paint)color50, stroke57, true, shape65, stroke66, (java.awt.Paint)color67);
    boolean b70 = legendItem69.isShapeOutlineVisible();
    org.jfree.data.xy.XYSeries xYSeries71 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection72 = new org.jfree.data.xy.XYSeriesCollection(xYSeries71);
    boolean b73 = xYSeriesCollection72.isAutoWidth();
    legendItem69.setDataset((org.jfree.data.general.Dataset)xYSeriesCollection72);
    combinedDomainXYPlot23.setDataset((org.jfree.data.xy.XYDataset)xYSeriesCollection72);
    boolean b76 = spreadsheetDate14.equals((java.lang.Object)xYSeriesCollection72);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number79 = xYSeriesCollection72.getStartX(10, 15);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i10 == 1900);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i16 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i18 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i26 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str68 + "' != '" + "green"+ "'", str68.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b70 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b73 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b76 == false);

  }

  @Test
  public void test259() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test259"); }


    org.jfree.chart.text.TextUtilities.setUseFontMetricsGetStringBounds(false);

  }

  @Test
  public void test260() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test260"); }


    java.text.DateFormat dateFormat1 = null;
    java.text.DateFormat dateFormat2 = null;
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator3 = new org.jfree.chart.labels.StandardXYToolTipGenerator("31-December-1969", dateFormat1, dateFormat2);
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator7 = new org.jfree.chart.urls.StandardXYURLGenerator("RectangleAnchor.LEFT", "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]", "{0}: ({1}, {2})");
    java.awt.Font font9 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset10 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot11 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset10);
    org.jfree.chart.axis.ValueAxis valueAxis12 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot13 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis12);
    java.util.List list14 = combinedDomainXYPlot13.getAnnotations();
    waferMapPlot11.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot13);
    boolean b16 = combinedDomainXYPlot13.isNotify();
    org.jfree.chart.JFreeChart jFreeChart18 = new org.jfree.chart.JFreeChart("", font9, (org.jfree.chart.plot.Plot)combinedDomainXYPlot13, true);
    combinedDomainXYPlot13.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer21 = null;
    combinedDomainXYPlot13.setRenderer(xYItemRenderer21);
    boolean b23 = combinedDomainXYPlot13.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries24 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection25 = new org.jfree.data.time.TimeSeriesCollection(timeSeries24);
    combinedDomainXYPlot13.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection25);
    timeSeriesCollection25.removeAllSeries();
    java.lang.String str30 = standardXYURLGenerator7.generateURL((org.jfree.data.xy.XYDataset)timeSeriesCollection25, 4, 255);
    org.jfree.data.general.DatasetGroup datasetGroup31 = timeSeriesCollection25.getGroup();
    // The following exception was thrown during execution in test generation
    try {
      java.lang.String str34 = standardXYToolTipGenerator3.generateToolTip((org.jfree.data.xy.XYDataset)timeSeriesCollection25, 5, 3);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str30 + "' != '" + "RectangleAnchor.LEFT?[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]=4&amp;{0}: ({1}, {2})=255"+ "'", str30.equals("RectangleAnchor.LEFT?[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]=4&amp;{0}: ({1}, {2})=255"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(datasetGroup31);

  }

  @Test
  public void test261() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test261"); }


    int i0 = org.jfree.chart.renderer.xy.XYAreaRenderer.SHAPES_AND_LINES;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 3);

  }

  @Test
  public void test262() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test262"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = xYStepRenderer0.getSeriesPositiveItemLabelPosition(3);
    java.awt.Paint paint6 = xYStepRenderer0.getItemFillPaint(5, 3, true);
    double d7 = xYStepRenderer0.getStepPoint();
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator8 = null;
    xYStepRenderer0.setBaseToolTipGenerator(xYToolTipGenerator8, true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 1.0d);

  }

  @Test
  public void test263() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test263"); }


    org.jfree.chart.util.LogFormat logFormat5 = new org.jfree.chart.util.LogFormat(12.0d, "{0}: ({1}, {2})", true);
    int i6 = logFormat5.getMaximumIntegerDigits();
    org.jfree.chart.util.LogFormat logFormat10 = new org.jfree.chart.util.LogFormat(12.0d, "{0}: ({1}, {2})", true);
    java.lang.StringBuffer stringBuffer12 = null;
    java.text.FieldPosition fieldPosition13 = null;
    java.lang.StringBuffer stringBuffer14 = logFormat10.format(6.0d, stringBuffer12, fieldPosition13);
    int i15 = logFormat10.getMinimumIntegerDigits();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator16 = new org.jfree.chart.labels.StandardXYToolTipGenerator("?hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!=-1&amp;=14", (java.text.NumberFormat)logFormat5, (java.text.NumberFormat)logFormat10);
    org.jfree.chart.util.LogFormat logFormat20 = new org.jfree.chart.util.LogFormat(10.0d, "", true);
    java.lang.String str22 = logFormat20.format((java.lang.Object)100.0f);
    int i23 = logFormat20.getMinimumFractionDigits();
    logFormat20.setMinimumIntegerDigits(100);
    java.text.NumberFormat numberFormat26 = logFormat20.getExponentFormat();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator27 = new org.jfree.chart.labels.StandardXYToolTipGenerator("ThreadContext", (java.text.NumberFormat)logFormat10, (java.text.NumberFormat)logFormat20);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Object obj29 = logFormat20.parseObject("green");
      org.junit.Assert.fail("Expected exception of type java.text.ParseException");
    } catch (java.text.ParseException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.text.ParseException")) {
        org.junit.Assert.fail("Expected exception of type java.text.ParseException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stringBuffer14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i15 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str22 + "' != '" + "^2.0"+ "'", str22.equals("^2.0"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i23 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat26);

  }

  @Test
  public void test264() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test264"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Shape shape3 = piePlot3D2.getLegendItemShape();
    java.awt.Paint paint4 = piePlot3D2.getBaseSectionPaint();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint4);

  }

  @Test
  public void test265() {}
// Defects4J: flaky method
//   @Test
//   public void test265() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test265"); }
// 
// 
//     org.jfree.data.time.DateRange dateRange2 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d3 = dateRange2.getLength();
//     long long4 = dateRange2.getLowerMillis();
//     double d5 = dateRange2.getLength();
//     java.lang.String str6 = dateRange2.toString();
//     java.util.Date date7 = dateRange2.getUpperDate();
//     java.util.TimeZone timeZone8 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year9 = new org.jfree.data.time.Year(date7, timeZone8);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod10 = year9.next();
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod11 = year9.previous();
//     java.util.Calendar calendar12 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       long long13 = year9.getFirstMillisecond(calendar12);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long4 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d5 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str6 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str6.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod11);
// 
//   }

  @Test
  public void test266() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test266"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.axis.ValueAxis valueAxis2 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot3 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis2);
    java.util.List list4 = combinedDomainXYPlot3.getAnnotations();
    waferMapPlot1.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot3);
    boolean b6 = combinedDomainXYPlot3.isNotify();
    org.jfree.chart.util.Layer layer7 = null;
    java.util.Collection collection8 = combinedDomainXYPlot3.getDomainMarkers(layer7);
    org.jfree.chart.LegendItemCollection legendItemCollection9 = combinedDomainXYPlot3.getLegendItems();
    org.jfree.chart.util.RectangleEdge rectangleEdge11 = combinedDomainXYPlot3.getRangeAxisEdge(7);
    boolean b12 = combinedDomainXYPlot3.isDomainGridlinesVisible();
    org.jfree.chart.annotations.XYAnnotation xYAnnotation13 = null;
    // The following exception was thrown during execution in test generation
    try {
      boolean b15 = combinedDomainXYPlot3.removeAnnotation(xYAnnotation13, true);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);

  }

  @Test
  public void test267() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test267"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    java.util.List list2 = combinedDomainXYPlot1.getAnnotations();
    combinedDomainXYPlot1.setRangeGridlinesVisible(true);
    org.jfree.chart.axis.ValueAxis valueAxis6 = null;
    combinedDomainXYPlot1.setRangeAxis(100, valueAxis6, false);
    org.jfree.chart.axis.NumberAxis numberAxis9 = new org.jfree.chart.axis.NumberAxis();
    numberAxis9.centerRange(100.0d);
    combinedDomainXYPlot1.setRangeAxis((org.jfree.chart.axis.ValueAxis)numberAxis9);
    java.text.NumberFormat numberFormat13 = numberAxis9.getNumberFormatOverride();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(numberFormat13);

  }

  @Test
  public void test268() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test268"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    org.jfree.chart.axis.ValueAxis valueAxis2 = categoryPlot0.getRangeAxisForDataset(14);
    int i3 = categoryPlot0.getWeight();
    int i4 = categoryPlot0.getDatasetCount();
    int i5 = categoryPlot0.getRendererCount();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(valueAxis2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i3 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 1);

  }

  @Test
  public void test269() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test269"); }


    org.jfree.data.time.TimePeriodAnchor timePeriodAnchor0 = org.jfree.data.time.TimePeriodAnchor.MIDDLE;
    org.jfree.chart.plot.CrosshairState crosshairState1 = new org.jfree.chart.plot.CrosshairState();
    crosshairState1.setAnchorX(2.0d);
    crosshairState1.setDatasetIndex(64);
    crosshairState1.setCrosshairY(7.0d);
    boolean b8 = timePeriodAnchor0.equals((java.lang.Object)crosshairState1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(timePeriodAnchor0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);

  }

  @Test
  public void test270() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test270"); }


    org.jfree.chart.util.Rotation rotation0 = org.jfree.chart.util.Rotation.ANTICLOCKWISE;
    org.jfree.data.xy.XYSeries xYSeries1 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection2 = new org.jfree.data.xy.XYSeriesCollection(xYSeries1);
    boolean b3 = rotation0.equals((java.lang.Object)xYSeriesCollection2);
    double d4 = rotation0.getFactor();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rotation0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 1.0d);

  }

  @Test
  public void test271() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test271"); }


    java.util.Date date0 = null;
    org.jfree.data.time.DateRange dateRange3 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange6 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b7 = dateRange3.intersects((org.jfree.data.Range)dateRange6);
    org.jfree.data.Range range9 = org.jfree.data.Range.expandToInclude((org.jfree.data.Range)dateRange3, 1.0d);
    org.jfree.data.Range range11 = org.jfree.data.Range.scale((org.jfree.data.Range)dateRange3, 0.0d);
    org.jfree.chart.block.RectangleConstraint rectangleConstraint13 = new org.jfree.chart.block.RectangleConstraint((org.jfree.data.Range)dateRange3, 7.0d);
    java.util.Date date14 = dateRange3.getLowerDate();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.DateRange dateRange15 = new org.jfree.data.time.DateRange(date0, date14);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(date14);

  }

  @Test
  public void test272() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test272"); }


    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D1 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke2 = categoryAxis3D1.getTickMarkStroke();
    java.awt.Graphics2D graphics2D3 = null;
    java.awt.geom.Rectangle2D rectangle2D5 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge6 = org.jfree.chart.util.RectangleEdge.LEFT;
    org.jfree.chart.axis.AxisState axisState8 = new org.jfree.chart.axis.AxisState(1.0d);
    double d9 = axisState8.getCursor();
    axisState8.cursorLeft(0.2d);
    categoryAxis3D1.drawTickMarks(graphics2D3, 7.0d, rectangle2D5, rectangleEdge6, axisState8);
    axisState8.cursorUp(0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d9 == 1.0d);

  }

  @Test
  public void test273() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test273"); }


    org.jfree.data.category.CategoryDataset categoryDataset0 = null;
    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot1 = new org.jfree.chart.plot.MultiplePiePlot(categoryDataset0);
    java.awt.Graphics2D graphics2D2 = null;
    java.awt.geom.Rectangle2D rectangle2D3 = null;
    java.awt.geom.Point2D point2D4 = null;
    org.jfree.chart.plot.PlotState plotState5 = new org.jfree.chart.plot.PlotState();
    java.util.Map map6 = plotState5.getSharedAxisStates();
    java.util.Map map7 = plotState5.getSharedAxisStates();
    java.awt.Font font9 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset10 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot11 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset10);
    org.jfree.chart.axis.ValueAxis valueAxis12 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot13 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis12);
    java.util.List list14 = combinedDomainXYPlot13.getAnnotations();
    waferMapPlot11.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot13);
    boolean b16 = combinedDomainXYPlot13.isNotify();
    org.jfree.chart.JFreeChart jFreeChart18 = new org.jfree.chart.JFreeChart("", font9, (org.jfree.chart.plot.Plot)combinedDomainXYPlot13, true);
    java.awt.Stroke stroke19 = jFreeChart18.getBorderStroke();
    boolean b20 = jFreeChart18.isBorderVisible();
    java.lang.Object obj21 = jFreeChart18.clone();
    org.jfree.chart.entity.EntityCollection entityCollection24 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo25 = new org.jfree.chart.ChartRenderingInfo(entityCollection24);
    jFreeChart18.handleClick(15, 8, chartRenderingInfo25);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo27 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo25);
    // The following exception was thrown during execution in test generation
    try {
      multiplePiePlot1.draw(graphics2D2, rectangle2D3, point2D4, plotState5, plotRenderingInfo27);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(map6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(map7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj21);

  }

  @Test
  public void test274() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test274"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Color color10 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke11 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color12 = java.awt.Color.orange;
    java.awt.Stroke stroke13 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker15 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color10, stroke11, (java.awt.Paint)color12, stroke13, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer16 = null;
    intervalMarker15.setGradientPaintTransformer(gradientPaintTransformer16);
    org.jfree.chart.util.RectangleInsets rectangleInsets18 = intervalMarker15.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis20 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets21 = categoryAxis20.getLabelInsets();
    intervalMarker15.setLabelOffset(rectangleInsets21);
    double d23 = intervalMarker15.getEndValue();
    org.jfree.chart.util.Layer layer24 = null;
    boolean b25 = categoryPlot0.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker15, layer24);
    boolean b26 = categoryPlot0.isRangeCrosshairLockedOnData();
    org.jfree.chart.axis.AxisLocation axisLocation27 = categoryPlot0.getDomainAxisLocation();
    int i28 = categoryPlot0.getRendererCount();
    org.jfree.data.category.CategoryDataset categoryDataset30 = null;
    categoryPlot0.setDataset(1900, categoryDataset30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d23 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i28 == 1);

  }

  @Test
  public void test275() {}
// Defects4J: flaky method
//   @Test
//   public void test275() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test275"); }
// 
// 
//     org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
//     java.lang.Object obj1 = defaultPieDataset0.clone();
//     java.lang.Number number3 = null;
//     defaultPieDataset0.setValue((java.lang.Comparable)6.0d, number3);
//     org.jfree.data.time.Month month5 = new org.jfree.data.time.Month();
//     int i6 = month5.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem8 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month5, 11.0d);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod9 = month5.previous();
//     long long10 = month5.getFirstMillisecond();
//     // The following exception was thrown during execution in test generation
//     try {
//       java.lang.Number number11 = defaultPieDataset0.getValue((java.lang.Comparable)long10);
//       org.junit.Assert.fail("Expected exception of type org.jfree.data.UnknownKeyException");
//     } catch (org.jfree.data.UnknownKeyException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.jfree.data.UnknownKeyException")) {
//         org.junit.Assert.fail("Expected exception of type org.jfree.data.UnknownKeyException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i6 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod9);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long10 == 1454313600000L);
// 
//   }

  @Test
  public void test276() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test276"); }


    org.jfree.data.time.TimeSeries timeSeries0 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection1 = new org.jfree.data.time.TimeSeriesCollection(timeSeries0);
    org.jfree.data.time.TimePeriodAnchor timePeriodAnchor2 = timeSeriesCollection1.getXPosition();
    org.jfree.data.xy.IntervalXYDelegate intervalXYDelegate3 = new org.jfree.data.xy.IntervalXYDelegate((org.jfree.data.xy.XYDataset)timeSeriesCollection1);
    int i4 = timeSeriesCollection1.getSeriesCount();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(timePeriodAnchor2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);

  }

  @Test
  public void test277() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test277"); }


    org.jfree.chart.util.RectangleInsets rectangleInsets0 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent1 = new org.jfree.data.general.SeriesChangeEvent((java.lang.Object)rectangleInsets0);
    java.awt.geom.Rectangle2D rectangle2D2 = null;
    org.jfree.chart.util.LengthAdjustmentType lengthAdjustmentType3 = org.jfree.chart.util.LengthAdjustmentType.EXPAND;
    java.lang.String str4 = lengthAdjustmentType3.toString();
    org.jfree.chart.util.LengthAdjustmentType lengthAdjustmentType5 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.awt.geom.Rectangle2D rectangle2D6 = rectangleInsets0.createAdjustedRectangle(rectangle2D2, lengthAdjustmentType3, lengthAdjustmentType5);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthAdjustmentType3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str4 + "' != '" + "EXPAND"+ "'", str4.equals("EXPAND"));

  }

  @Test
  public void test278() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test278"); }


    int i0 = org.jfree.data.time.SerialDate.MAXIMUM_YEAR_SUPPORTED;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 9999);

  }

  @Test
  public void test279() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test279"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis5 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets6 = categoryAxis5.getLabelInsets();
    double d8 = rectangleInsets6.calculateLeftInset(4.0d);
    categoryPlot0.setInsets(rectangleInsets6, false);
    org.jfree.chart.util.Layer layer12 = null;
    java.util.Collection collection13 = categoryPlot0.getDomainMarkers(5, layer12);
    org.jfree.data.general.DatasetGroup datasetGroup14 = categoryPlot0.getDatasetGroup();
    org.jfree.chart.entity.EntityCollection entityCollection16 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo17 = new org.jfree.chart.ChartRenderingInfo(entityCollection16);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo18 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo17);
    java.awt.geom.Point2D point2D19 = null;
    categoryPlot0.zoomDomainAxes(12.0d, plotRenderingInfo18, point2D19, true);
    int i22 = categoryPlot0.getRangeAxisCount();
    org.jfree.data.category.CategoryDataset categoryDataset24 = null;
    // The following exception was thrown during execution in test generation
    try {
      categoryPlot0.setDataset((-1), categoryDataset24);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(datasetGroup14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i22 == 1);

  }

  @Test
  public void test280() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test280"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    piePlot3D2.setStartAngle(Double.NaN);
    org.jfree.data.general.DefaultPieDataset defaultPieDataset5 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj6 = defaultPieDataset5.clone();
    double d7 = org.jfree.data.general.DatasetUtilities.calculatePieDatasetTotal((org.jfree.data.general.PieDataset)defaultPieDataset5);
    piePlot3D2.setDataset((org.jfree.data.general.PieDataset)defaultPieDataset5);
    org.jfree.chart.util.Rotation rotation9 = piePlot3D2.getDirection();
    org.jfree.chart.axis.ValueAxis valueAxis11 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot12 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis11);
    java.util.List list13 = combinedDomainXYPlot12.getAnnotations();
    combinedDomainXYPlot12.setRangeGridlinesVisible(true);
    org.jfree.chart.axis.AxisSpace axisSpace16 = null;
    combinedDomainXYPlot12.setFixedRangeAxisSpace(axisSpace16);
    org.jfree.data.xy.XYDataset xYDataset19 = combinedDomainXYPlot12.getDataset(40);
    org.jfree.chart.StandardChartTheme standardChartTheme21 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Paint paint22 = standardChartTheme21.getAxisLabelPaint();
    java.awt.Font font23 = standardChartTheme21.getLargeFont();
    combinedDomainXYPlot12.setNoDataMessageFont(font23);
    org.jfree.data.general.WaferMapDataset waferMapDataset25 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot26 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset25);
    org.jfree.chart.axis.ValueAxis valueAxis27 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot28 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis27);
    java.util.List list29 = combinedDomainXYPlot28.getAnnotations();
    waferMapPlot26.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot28);
    boolean b31 = combinedDomainXYPlot28.isNotify();
    org.jfree.chart.util.Layer layer32 = null;
    java.util.Collection collection33 = combinedDomainXYPlot28.getDomainMarkers(layer32);
    org.jfree.chart.LegendItemCollection legendItemCollection34 = combinedDomainXYPlot28.getLegendItems();
    org.jfree.chart.JFreeChart jFreeChart36 = new org.jfree.chart.JFreeChart("ClassContext", font23, (org.jfree.chart.plot.Plot)combinedDomainXYPlot28, false);
    boolean b37 = piePlot3D2.equals((java.lang.Object)"ClassContext");
    boolean b38 = piePlot3D2.getSimpleLabels();
    piePlot3D2.setLabelLinkMargin(100.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rotation9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYDataset19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == false);

  }

  @Test
  public void test281() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test281"); }


    double[] d_array2 = null;
    double[][] d_array_array3 = new double[][] { d_array2 };
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.category.CategoryDataset categoryDataset4 = org.jfree.data.general.DatasetUtilities.createCategoryDataset("", "RectangleConstraint[LengthConstraintType.FIXED: width=100.0, height=0.0]", d_array_array3);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array3);

  }

  @Test
  public void test282() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test282"); }


    org.jfree.data.category.CategoryDataset categoryDataset0 = null;
    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot1 = new org.jfree.chart.plot.MultiplePiePlot(categoryDataset0);
    java.awt.Graphics2D graphics2D2 = null;
    java.awt.geom.Rectangle2D rectangle2D3 = null;
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    org.jfree.chart.plot.PlotOrientation plotOrientation6 = combinedDomainXYPlot5.getOrientation();
    boolean b7 = combinedDomainXYPlot5.isDomainCrosshairLockedOnData();
    org.jfree.chart.entity.EntityCollection entityCollection9 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo10 = new org.jfree.chart.ChartRenderingInfo(entityCollection9);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo11 = chartRenderingInfo10.getPlotInfo();
    java.awt.geom.Point2D point2D12 = null;
    combinedDomainXYPlot5.panDomainAxes(4.5d, plotRenderingInfo11, point2D12);
    int i14 = plotRenderingInfo11.getSubplotCount();
    org.jfree.chart.entity.EntityCollection entityCollection15 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo16 = new org.jfree.chart.ChartRenderingInfo(entityCollection15);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo17 = chartRenderingInfo16.getPlotInfo();
    plotRenderingInfo11.addSubplotInfo(plotRenderingInfo17);
    java.awt.geom.Rectangle2D rectangle2D19 = null;
    org.jfree.chart.util.RectangleAnchor rectangleAnchor20 = null;
    java.awt.geom.Point2D point2D21 = org.jfree.chart.util.RectangleAnchor.coordinates(rectangle2D19, rectangleAnchor20);
    int i22 = plotRenderingInfo17.getSubplotIndex(point2D21);
    org.jfree.chart.plot.PlotState plotState23 = new org.jfree.chart.plot.PlotState();
    java.util.Map map24 = plotState23.getSharedAxisStates();
    org.jfree.chart.renderer.category.BarRenderer barRenderer25 = new org.jfree.chart.renderer.category.BarRenderer();
    double d26 = barRenderer25.getShadowXOffset();
    barRenderer25.setShadowXOffset(10.0d);
    boolean b29 = barRenderer25.getIncludeBaseInRange();
    java.awt.Graphics2D graphics2D30 = null;
    java.awt.geom.Rectangle2D rectangle2D31 = null;
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D33 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    org.jfree.chart.axis.NumberAxis3D numberAxis3D34 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Paint paint35 = org.jfree.chart.axis.Axis.DEFAULT_AXIS_LINE_PAINT;
    numberAxis3D34.setLabelPaint(paint35);
    numberAxis3D34.setTickMarksVisible(true);
    org.jfree.chart.util.Layer layer39 = org.jfree.chart.util.Layer.FOREGROUND;
    org.jfree.chart.plot.CategoryPlot categoryPlot40 = new org.jfree.chart.plot.CategoryPlot();
    boolean b41 = categoryPlot40.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge43 = categoryPlot40.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis45 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets46 = categoryAxis45.getLabelInsets();
    double d48 = rectangleInsets46.calculateLeftInset(4.0d);
    categoryPlot40.setInsets(rectangleInsets46, false);
    int i51 = categoryPlot40.getRendererCount();
    org.jfree.chart.axis.NumberAxis numberAxis52 = new org.jfree.chart.axis.NumberAxis();
    numberAxis52.centerRange(100.0d);
    java.awt.Paint paint55 = numberAxis52.getLabelPaint();
    categoryPlot40.setRangeCrosshairPaint(paint55);
    org.jfree.chart.entity.EntityCollection entityCollection58 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo59 = new org.jfree.chart.ChartRenderingInfo(entityCollection58);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo60 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo59);
    java.awt.geom.Point2D point2D61 = null;
    categoryPlot40.panRangeAxes(0.6d, plotRenderingInfo60, point2D61);
    barRenderer25.drawAnnotations(graphics2D30, rectangle2D31, (org.jfree.chart.axis.CategoryAxis)categoryAxis3D33, (org.jfree.chart.axis.ValueAxis)numberAxis3D34, layer39, plotRenderingInfo60);
    java.awt.geom.Rectangle2D rectangle2D64 = null;
    plotRenderingInfo60.setDataArea(rectangle2D64);
    // The following exception was thrown during execution in test generation
    try {
      multiplePiePlot1.draw(graphics2D2, rectangle2D3, point2D21, plotState23, plotRenderingInfo60);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i14 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point2D21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i22 == (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(map24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d26 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(layer39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d48 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i51 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint55);

  }

  @Test
  public void test283() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test283"); }


    java.awt.Font font0 = org.jfree.chart.JFreeChart.DEFAULT_TITLE_FONT;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font0);

  }

  @Test
  public void test284() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test284"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    xYAreaRenderer1.setBaseSeriesVisible(false);
    java.awt.Paint paint5 = xYAreaRenderer1.lookupLegendTextPaint(0);
    java.awt.Font font7 = xYAreaRenderer1.getSeriesItemLabelFont(4);
    java.awt.Shape shape11 = xYAreaRenderer1.getItemShape(1, 8, true);
    org.jfree.chart.axis.CategoryAxis categoryAxis12 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset13 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot14 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset13);
    org.jfree.chart.axis.ValueAxis valueAxis15 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot16 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis15);
    java.util.List list17 = combinedDomainXYPlot16.getAnnotations();
    waferMapPlot14.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot16);
    int i19 = combinedDomainXYPlot16.getSeriesCount();
    categoryAxis12.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot16);
    java.awt.Color color27 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke28 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color29 = java.awt.Color.orange;
    java.awt.Stroke stroke30 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker32 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color27, stroke28, (java.awt.Paint)color29, stroke30, 0.0f);
    java.awt.Paint paint33 = intervalMarker32.getOutlinePaint();
    org.jfree.chart.util.Layer layer34 = null;
    combinedDomainXYPlot16.addRangeMarker(0, (org.jfree.chart.plot.Marker)intervalMarker32, layer34);
    org.jfree.chart.entity.PlotEntity plotEntity36 = new org.jfree.chart.entity.PlotEntity(shape11, (org.jfree.chart.plot.Plot)combinedDomainXYPlot16);
    java.lang.String str37 = plotEntity36.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(font7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i19 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str37 + "' != '" + "PlotEntity: tooltip = null"+ "'", str37.equals("PlotEntity: tooltip = null"));

  }

  @Test
  public void test285() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test285"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis1 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets2 = categoryAxis1.getLabelInsets();
    double d4 = rectangleInsets2.calculateRightInset((-1.0d));
    double d6 = rectangleInsets2.calculateTopOutset(0.0d);
    double d7 = rectangleInsets2.getRight();
    double d9 = rectangleInsets2.calculateRightOutset(2.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d9 == 3.0d);

  }

  @Test
  public void test286() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test286"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis1 = new org.jfree.chart.axis.CategoryAxis("RectangleConstraint[LengthConstraintType.FIXED: width=100.0, height=0.0]");
    org.jfree.chart.axis.NumberAxis3D numberAxis3D2 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Paint paint3 = org.jfree.chart.axis.Axis.DEFAULT_AXIS_LINE_PAINT;
    numberAxis3D2.setLabelPaint(paint3);
    org.jfree.chart.axis.NumberTickUnit numberTickUnit5 = org.jfree.chart.axis.NumberAxis.DEFAULT_TICK_UNIT;
    numberAxis3D2.setTickUnit(numberTickUnit5, false, true);
    java.awt.Font font10 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset11 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot12 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset11);
    org.jfree.chart.axis.ValueAxis valueAxis13 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot14 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis13);
    java.util.List list15 = combinedDomainXYPlot14.getAnnotations();
    waferMapPlot12.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot14);
    boolean b17 = combinedDomainXYPlot14.isNotify();
    org.jfree.chart.JFreeChart jFreeChart19 = new org.jfree.chart.JFreeChart("", font10, (org.jfree.chart.plot.Plot)combinedDomainXYPlot14, true);
    combinedDomainXYPlot14.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer22 = null;
    combinedDomainXYPlot14.setRenderer(xYItemRenderer22);
    boolean b24 = combinedDomainXYPlot14.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries25 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection26 = new org.jfree.data.time.TimeSeriesCollection(timeSeries25);
    combinedDomainXYPlot14.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection26);
    boolean b28 = combinedDomainXYPlot14.isRangeZoomable();
    java.util.List list29 = combinedDomainXYPlot14.getSubplots();
    java.awt.geom.Rectangle2D rectangle2D30 = null;
    java.awt.Font font32 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset33 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot34 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset33);
    org.jfree.chart.axis.ValueAxis valueAxis35 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot36 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis35);
    java.util.List list37 = combinedDomainXYPlot36.getAnnotations();
    waferMapPlot34.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot36);
    boolean b39 = combinedDomainXYPlot36.isNotify();
    org.jfree.chart.JFreeChart jFreeChart41 = new org.jfree.chart.JFreeChart("", font32, (org.jfree.chart.plot.Plot)combinedDomainXYPlot36, true);
    combinedDomainXYPlot36.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer44 = null;
    combinedDomainXYPlot36.setRenderer(xYItemRenderer44);
    boolean b46 = combinedDomainXYPlot36.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries47 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection48 = new org.jfree.data.time.TimeSeriesCollection(timeSeries47);
    combinedDomainXYPlot36.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection48);
    boolean b50 = combinedDomainXYPlot36.isRangeZoomable();
    java.util.List list51 = combinedDomainXYPlot36.getSubplots();
    org.jfree.chart.util.RectangleEdge rectangleEdge52 = combinedDomainXYPlot36.getDomainAxisEdge();
    // The following exception was thrown during execution in test generation
    try {
      double d53 = categoryAxis1.getCategoryMiddle((java.lang.Comparable)true, list29, rectangle2D30, rectangleEdge52);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberTickUnit5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b46 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b50 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge52);

  }

  @Test
  public void test287() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test287"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.axis.AxisLocation axisLocation14 = null;
    combinedDomainXYPlot5.setDomainAxisLocation(3, axisLocation14, false);
    org.jfree.chart.axis.AxisLocation axisLocation17 = combinedDomainXYPlot5.getRangeAxisLocation();
    combinedDomainXYPlot5.setBackgroundImageAlignment(255);
    org.jfree.chart.axis.ValueAxis valueAxis21 = combinedDomainXYPlot5.getDomainAxis(100);
    java.awt.Graphics2D graphics2D22 = null;
    java.awt.geom.Rectangle2D rectangle2D23 = null;
    org.jfree.chart.axis.ValueAxis valueAxis24 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot25 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis24);
    java.util.List list26 = combinedDomainXYPlot25.getAnnotations();
    combinedDomainXYPlot25.setRangeGridlinesVisible(true);
    java.awt.geom.Rectangle2D rectangle2D29 = null;
    org.jfree.chart.util.RectangleAnchor rectangleAnchor30 = null;
    java.awt.geom.Point2D point2D31 = org.jfree.chart.util.RectangleAnchor.coordinates(rectangle2D29, rectangleAnchor30);
    combinedDomainXYPlot25.setQuadrantOrigin(point2D31);
    org.jfree.chart.plot.PlotState plotState33 = new org.jfree.chart.plot.PlotState();
    org.jfree.chart.entity.EntityCollection entityCollection34 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo35 = new org.jfree.chart.ChartRenderingInfo(entityCollection34);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo36 = chartRenderingInfo35.getPlotInfo();
    org.jfree.chart.entity.EntityCollection entityCollection37 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo38 = new org.jfree.chart.ChartRenderingInfo(entityCollection37);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo39 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo38);
    int i40 = plotRenderingInfo39.getSubplotCount();
    plotRenderingInfo36.addSubplotInfo(plotRenderingInfo39);
    // The following exception was thrown during execution in test generation
    try {
      combinedDomainXYPlot5.draw(graphics2D22, rectangle2D23, point2D31, plotState33, plotRenderingInfo36);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(valueAxis21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point2D31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i40 == 0);

  }

  @Test
  public void test288() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test288"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    java.awt.Shape shape33 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    legendItem30.setShape(shape33);
    org.jfree.data.general.Dataset dataset35 = null;
    legendItem30.setDataset(dataset35);
    legendItem30.setURLText("TextAnchor.CENTER");
    java.lang.Comparable comparable39 = legendItem30.getSeriesKey();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(comparable39);

  }

  @Test
  public void test289() {}
// Defects4J: flaky method
//   @Test
//   public void test289() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test289"); }
// 
// 
//     org.jfree.data.time.DateRange dateRange2 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d3 = dateRange2.getLength();
//     long long4 = dateRange2.getLowerMillis();
//     double d5 = dateRange2.getLength();
//     java.lang.String str6 = dateRange2.toString();
//     java.util.Date date7 = dateRange2.getUpperDate();
//     java.util.TimeZone timeZone8 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year9 = new org.jfree.data.time.Year(date7, timeZone8);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod10 = year9.next();
//     long long11 = year9.getLastMillisecond();
//     java.util.Calendar calendar12 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       long long13 = year9.getLastMillisecond(calendar12);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long4 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d5 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str6 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str6.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long11 == 28799999L);
// 
//   }

  @Test
  public void test290() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test290"); }


    java.awt.Font font2 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset3 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot4 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset3);
    org.jfree.chart.axis.ValueAxis valueAxis5 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot6 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis5);
    java.util.List list7 = combinedDomainXYPlot6.getAnnotations();
    waferMapPlot4.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot6);
    boolean b9 = combinedDomainXYPlot6.isNotify();
    org.jfree.chart.JFreeChart jFreeChart11 = new org.jfree.chart.JFreeChart("", font2, (org.jfree.chart.plot.Plot)combinedDomainXYPlot6, true);
    org.jfree.chart.title.TextTitle textTitle12 = new org.jfree.chart.title.TextTitle("", font2);
    boolean b13 = textTitle12.getExpandToFitSpace();
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment14 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    textTitle12.setTextAlignment(horizontalAlignment14);
    textTitle12.setExpandToFitSpace(true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment14);

  }

  @Test
  public void test291() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test291"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis0 = new org.jfree.chart.axis.CategoryAxis();
    categoryAxis0.setVisible(false);
    org.jfree.chart.util.RectangleInsets rectangleInsets3 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d4 = rectangleInsets3.getLeft();
    double d6 = rectangleInsets3.calculateLeftOutset(1.0d);
    categoryAxis0.setLabelInsets(rectangleInsets3, true);
    categoryAxis0.setVisible(false);
    categoryAxis0.clearCategoryLabelToolTips();
    int i12 = categoryAxis0.getCategoryLabelPositionOffset();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i12 == 4);

  }

  @Test
  public void test292() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test292"); }


    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D2 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke3 = categoryAxis3D2.getTickMarkStroke();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer5 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator6 = xYAreaRenderer5.getLegendItemToolTipGenerator();
    boolean b9 = xYAreaRenderer5.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition13 = xYAreaRenderer5.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b15 = xYAreaRenderer5.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator17 = xYAreaRenderer5.getSeriesToolTipGenerator(3);
    java.awt.Font font19 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset20 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot21 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset20);
    org.jfree.chart.axis.ValueAxis valueAxis22 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot23 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis22);
    java.util.List list24 = combinedDomainXYPlot23.getAnnotations();
    waferMapPlot21.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot23);
    boolean b26 = combinedDomainXYPlot23.isNotify();
    org.jfree.chart.JFreeChart jFreeChart28 = new org.jfree.chart.JFreeChart("", font19, (org.jfree.chart.plot.Plot)combinedDomainXYPlot23, true);
    xYAreaRenderer5.setBaseLegendTextFont(font19);
    categoryAxis3D2.setTickLabelFont(font19);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer32 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator33 = xYAreaRenderer32.getLegendItemToolTipGenerator();
    boolean b36 = xYAreaRenderer32.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition40 = xYAreaRenderer32.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b42 = xYAreaRenderer32.getSeriesCreateEntities(10);
    java.awt.Font font44 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset45 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot46 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset45);
    org.jfree.chart.axis.ValueAxis valueAxis47 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot48 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis47);
    java.util.List list49 = combinedDomainXYPlot48.getAnnotations();
    waferMapPlot46.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot48);
    boolean b51 = combinedDomainXYPlot48.isNotify();
    org.jfree.chart.JFreeChart jFreeChart53 = new org.jfree.chart.JFreeChart("", font44, (org.jfree.chart.plot.Plot)combinedDomainXYPlot48, true);
    java.awt.Paint paint54 = combinedDomainXYPlot48.getRangeCrosshairPaint();
    xYAreaRenderer32.setBasePaint(paint54);
    org.jfree.chart.text.TextMeasurer textMeasurer58 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.text.TextBlock textBlock59 = org.jfree.chart.text.TextUtilities.createTextBlock("TitleEntity: tooltip = green", font19, paint54, 100.0f, 14, textMeasurer58);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYToolTipGenerator17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b51 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint54);

  }

  @Test
  public void test293() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test293"); }


    org.jfree.chart.util.RectangleInsets rectangleInsets0 = new org.jfree.chart.util.RectangleInsets();
    double d1 = rectangleInsets0.getLeft();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.0d);

  }

  @Test
  public void test294() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test294"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis0 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset1 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot2 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset1);
    org.jfree.chart.axis.ValueAxis valueAxis3 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot4 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis3);
    java.util.List list5 = combinedDomainXYPlot4.getAnnotations();
    waferMapPlot2.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot4);
    int i7 = combinedDomainXYPlot4.getSeriesCount();
    categoryAxis0.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot4);
    java.awt.Color color15 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke16 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color17 = java.awt.Color.orange;
    java.awt.Stroke stroke18 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker20 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color15, stroke16, (java.awt.Paint)color17, stroke18, 0.0f);
    java.awt.Paint paint21 = intervalMarker20.getOutlinePaint();
    org.jfree.chart.util.Layer layer22 = null;
    combinedDomainXYPlot4.addRangeMarker(0, (org.jfree.chart.plot.Marker)intervalMarker20, layer22);
    combinedDomainXYPlot4.clearRangeMarkers();
    java.awt.Color color25 = java.awt.Color.darkGray;
    int i26 = color25.getRed();
    combinedDomainXYPlot4.setDomainTickBandPaint((java.awt.Paint)color25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i26 == 64);

  }

  @Test
  public void test295() {}
// Defects4J: flaky method
//   @Test
//   public void test295() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test295"); }
// 
// 
//     org.jfree.data.time.Month month0 = new org.jfree.data.time.Month();
//     int i1 = month0.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem3 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month0, 11.0d);
//     timeSeriesDataItem3.setSelected(true);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod6 = timeSeriesDataItem3.getPeriod();
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod7 = timeSeriesDataItem3.getPeriod();
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod8 = timeSeriesDataItem3.getPeriod();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i1 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod6);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod8);
// 
//   }

  @Test
  public void test296() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test296"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    org.jfree.chart.plot.Plot plot2 = combinedDomainXYPlot1.getRootPlot();
    org.jfree.chart.LegendItemCollection legendItemCollection3 = null;
    combinedDomainXYPlot1.setFixedLegendItems(legendItemCollection3);
    combinedDomainXYPlot1.clearRangeAxes();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot2);

  }

  @Test
  public void test297() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test297"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    java.awt.Shape shape3 = xYAreaRenderer1.getBaseShape();
    xYAreaRenderer1.setSeriesVisibleInLegend(10, (java.lang.Boolean)false, true);
    boolean b8 = xYAreaRenderer1.getPlotShapes();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);

  }

  @Test
  public void test298() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test298"); }


    org.jfree.chart.StandardChartTheme standardChartTheme1 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Paint paint2 = null;
    // The following exception was thrown during execution in test generation
    try {
      standardChartTheme1.setSubtitlePaint(paint2);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test299() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test299"); }


    org.jfree.chart.plot.CrosshairState crosshairState0 = new org.jfree.chart.plot.CrosshairState();
    crosshairState0.setAnchorX(2.0d);
    crosshairState0.setDatasetIndex(64);
    crosshairState0.setCrosshairY(7.0d);
    double d7 = crosshairState0.getCrosshairY();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 7.0d);

  }

  @Test
  public void test300() {}
// Defects4J: flaky method
//   @Test
//   public void test300() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test300"); }
// 
// 
//     org.jfree.data.time.Month month1 = new org.jfree.data.time.Month();
//     int i2 = month1.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem4 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month1, (java.lang.Number)8);
//     long long5 = month1.getFirstMillisecond();
//     org.jfree.data.time.Month month6 = new org.jfree.data.time.Month();
//     int i7 = month6.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis8 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month1, (org.jfree.data.time.RegularTimePeriod)month6);
//     org.jfree.data.time.Month month10 = new org.jfree.data.time.Month();
//     int i11 = month10.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem13 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month10, (java.lang.Number)8);
//     long long14 = month10.getFirstMillisecond();
//     org.jfree.data.time.Month month15 = new org.jfree.data.time.Month();
//     int i16 = month15.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis17 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month10, (org.jfree.data.time.RegularTimePeriod)month15);
//     float f18 = periodAxis17.getMinorTickMarkInsideLength();
//     java.lang.Object obj19 = periodAxis17.clone();
//     org.jfree.chart.axis.PeriodAxisLabelInfo[] periodAxisLabelInfo_array20 = periodAxis17.getLabelInfo();
//     periodAxis8.setLabelInfo(periodAxisLabelInfo_array20);
//     java.lang.Class clazz22 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       periodAxis8.setAutoRangeTimePeriodClass(clazz22);
//       org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
//     } catch (java.lang.IllegalArgumentException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i2 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i7 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i11 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long14 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i16 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f18 == 0.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj19);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(periodAxisLabelInfo_array20);
// 
//   }

  @Test
  public void test301() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test301"); }


    org.jfree.data.xy.TableXYDataset tableXYDataset0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.Range range2 = org.jfree.data.general.DatasetUtilities.findStackedRangeBounds(tableXYDataset0, 108.0d);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test302() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test302"); }


    java.awt.Color color0 = java.awt.Color.MAGENTA;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color0);

  }

  @Test
  public void test303() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test303"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    java.awt.Graphics2D graphics2D4 = null;
    java.awt.geom.Rectangle2D rectangle2D5 = null;
    org.jfree.data.general.DefaultPieDataset defaultPieDataset6 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj7 = defaultPieDataset6.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D8 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset6);
    piePlot3D8.setIgnoreZeroValues(true);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo12 = null;
    org.jfree.chart.plot.PiePlotState piePlotState13 = piePlot3D2.initialise(graphics2D4, rectangle2D5, (org.jfree.chart.plot.PiePlot)piePlot3D8, (java.lang.Integer)1, plotRenderingInfo12);
    java.awt.Graphics2D graphics2D14 = null;
    java.awt.geom.Rectangle2D rectangle2D15 = null;
    java.awt.geom.Rectangle2D rectangle2D16 = null;
    org.jfree.chart.util.RectangleAnchor rectangleAnchor17 = null;
    java.awt.geom.Point2D point2D18 = org.jfree.chart.util.RectangleAnchor.coordinates(rectangle2D16, rectangleAnchor17);
    org.jfree.chart.plot.PlotState plotState19 = null;
    org.jfree.chart.axis.ValueAxis valueAxis20 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot21 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis20);
    org.jfree.chart.plot.PlotOrientation plotOrientation22 = combinedDomainXYPlot21.getOrientation();
    boolean b23 = combinedDomainXYPlot21.isDomainCrosshairLockedOnData();
    org.jfree.chart.entity.EntityCollection entityCollection25 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo26 = new org.jfree.chart.ChartRenderingInfo(entityCollection25);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo27 = chartRenderingInfo26.getPlotInfo();
    java.awt.geom.Point2D point2D28 = null;
    combinedDomainXYPlot21.panDomainAxes(4.5d, plotRenderingInfo27, point2D28);
    int i30 = plotRenderingInfo27.getSubplotCount();
    org.jfree.chart.entity.EntityCollection entityCollection31 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo32 = new org.jfree.chart.ChartRenderingInfo(entityCollection31);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo33 = chartRenderingInfo32.getPlotInfo();
    plotRenderingInfo27.addSubplotInfo(plotRenderingInfo33);
    // The following exception was thrown during execution in test generation
    try {
      piePlot3D8.draw(graphics2D14, rectangle2D15, point2D18, plotState19, plotRenderingInfo27);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(piePlotState13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point2D18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i30 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo33);

  }

  @Test
  public void test304() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test304"); }


    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D1 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.geom.Rectangle2D rectangle2D7 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge8 = null;
    double d9 = categoryAxis3D1.getCategorySeriesMiddle((-1), 255, (-1), 0, 0.0d, rectangle2D7, rectangleEdge8);
    java.lang.Object obj10 = categoryAxis3D1.clone();
    java.lang.Object obj11 = categoryAxis3D1.clone();
    org.jfree.chart.axis.CategoryAnchor categoryAnchor12 = null;
    java.awt.geom.Rectangle2D rectangle2D15 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge16 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d17 = categoryAxis3D1.getCategoryJava2DCoordinate(categoryAnchor12, 0, 12, rectangle2D15, rectangleEdge16);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d9, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj11);

  }

  @Test
  public void test305() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test305"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    java.awt.Graphics2D graphics2D4 = null;
    java.awt.geom.Rectangle2D rectangle2D5 = null;
    org.jfree.data.general.DefaultPieDataset defaultPieDataset6 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj7 = defaultPieDataset6.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D8 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset6);
    piePlot3D8.setIgnoreZeroValues(true);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo12 = null;
    org.jfree.chart.plot.PiePlotState piePlotState13 = piePlot3D2.initialise(graphics2D4, rectangle2D5, (org.jfree.chart.plot.PiePlot)piePlot3D8, (java.lang.Integer)1, plotRenderingInfo12);
    piePlot3D2.setCircular(true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(piePlotState13);

  }

  @Test
  public void test306() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test306"); }


    org.jfree.chart.plot.CrosshairState crosshairState0 = new org.jfree.chart.plot.CrosshairState();
    crosshairState0.updateCrosshairY((-1.0d), 14);
    crosshairState0.updateCrosshairY(1.0E-8d, 10);
    crosshairState0.setDatasetIndex(8);

  }

  @Test
  public void test307() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test307"); }


    org.jfree.chart.util.RectangleEdge rectangleEdge0 = org.jfree.chart.title.Title.DEFAULT_POSITION;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge0);

  }

  @Test
  public void test308() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test308"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    xYAreaRenderer1.setBaseSeriesVisible(false);
    java.awt.Paint paint5 = xYAreaRenderer1.lookupLegendTextPaint(0);
    java.awt.Font font7 = xYAreaRenderer1.getSeriesItemLabelFont(4);
    boolean b8 = xYAreaRenderer1.getPlotShapes();
    java.awt.Shape shape10 = xYAreaRenderer1.getLegendShape(0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(font7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(shape10);

  }

  @Test
  public void test309() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test309"); }


    org.jfree.data.time.SpreadsheetDate spreadsheetDate1 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate3 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b4 = spreadsheetDate1.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate3);
    int i5 = spreadsheetDate1.getYYYY();
    org.jfree.data.time.SpreadsheetDate spreadsheetDate7 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate9 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b10 = spreadsheetDate7.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate9);
    int i11 = spreadsheetDate9.getMonth();
    boolean b12 = spreadsheetDate1.isOnOrBefore((org.jfree.data.time.SerialDate)spreadsheetDate9);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate14 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate16 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b17 = spreadsheetDate14.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate16);
    int i18 = spreadsheetDate14.getYYYY();
    org.jfree.data.time.SpreadsheetDate spreadsheetDate20 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate22 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b23 = spreadsheetDate20.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate22);
    int i24 = spreadsheetDate22.getMonth();
    boolean b25 = spreadsheetDate14.isOnOrBefore((org.jfree.data.time.SerialDate)spreadsheetDate22);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate27 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate29 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b30 = spreadsheetDate27.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate29);
    int i31 = spreadsheetDate27.getYYYY();
    org.jfree.data.time.SpreadsheetDate spreadsheetDate33 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate35 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b36 = spreadsheetDate33.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate35);
    int i37 = spreadsheetDate35.getMonth();
    boolean b38 = spreadsheetDate27.isOnOrBefore((org.jfree.data.time.SerialDate)spreadsheetDate35);
    int i39 = spreadsheetDate27.getYYYY();
    boolean b40 = spreadsheetDate9.isInRange((org.jfree.data.time.SerialDate)spreadsheetDate22, (org.jfree.data.time.SerialDate)spreadsheetDate27);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate42 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate44 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b45 = spreadsheetDate42.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate44);
    boolean b46 = spreadsheetDate27.isOnOrBefore((org.jfree.data.time.SerialDate)spreadsheetDate42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 1900);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i11 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i18 == 1900);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i24 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i31 == 1900);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i37 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i39 == 1900);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b45 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b46 == true);

  }

  @Test
  public void test310() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test310"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    boolean b31 = legendItem30.isShapeOutlineVisible();
    boolean b33 = legendItem30.equals((java.lang.Object)(short)1);
    org.jfree.data.time.DateRange dateRange36 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    double d37 = dateRange36.getLength();
    long long38 = dateRange36.getLowerMillis();
    java.util.Date date39 = dateRange36.getLowerDate();
    boolean b40 = legendItem30.equals((java.lang.Object)date39);
    java.lang.String str41 = legendItem30.getURLText();
    java.awt.Shape shape42 = null;
    // The following exception was thrown during execution in test generation
    try {
      legendItem30.setShape(shape42);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d37 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long38 == (-1L));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(date39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str41 + "' != '" + ""+ "'", str41.equals(""));

  }

  @Test
  public void test311() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test311"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    boolean b3 = xYBarRenderer1.getAutoPopulateSeriesShape();
    java.awt.Stroke stroke4 = xYBarRenderer1.getBaseOutlineStroke();
    java.awt.Graphics2D graphics2D5 = null;
    java.awt.geom.Rectangle2D rectangle2D6 = null;
    org.jfree.chart.axis.ValueAxis valueAxis7 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot8 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis7);
    java.util.List list9 = combinedDomainXYPlot8.getAnnotations();
    combinedDomainXYPlot8.setRangeGridlinesVisible(true);
    org.jfree.chart.axis.AxisSpace axisSpace12 = null;
    combinedDomainXYPlot8.setFixedRangeAxisSpace(axisSpace12);
    org.jfree.chart.util.Layer layer15 = null;
    java.util.Collection collection16 = combinedDomainXYPlot8.getRangeMarkers(0, layer15);
    java.awt.Font font18 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset19 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot20 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset19);
    org.jfree.chart.axis.ValueAxis valueAxis21 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot22 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis21);
    java.util.List list23 = combinedDomainXYPlot22.getAnnotations();
    waferMapPlot20.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot22);
    boolean b25 = combinedDomainXYPlot22.isNotify();
    org.jfree.chart.JFreeChart jFreeChart27 = new org.jfree.chart.JFreeChart("", font18, (org.jfree.chart.plot.Plot)combinedDomainXYPlot22, true);
    combinedDomainXYPlot22.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer30 = null;
    combinedDomainXYPlot22.setRenderer(xYItemRenderer30);
    boolean b32 = combinedDomainXYPlot22.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries33 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection34 = new org.jfree.data.time.TimeSeriesCollection(timeSeries33);
    combinedDomainXYPlot22.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection34);
    org.jfree.chart.entity.EntityCollection entityCollection36 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo37 = new org.jfree.chart.ChartRenderingInfo(entityCollection36);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo38 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo37);
    int i39 = plotRenderingInfo38.getSubplotCount();
    org.jfree.chart.renderer.xy.XYItemRendererState xYItemRendererState40 = new org.jfree.chart.renderer.xy.XYItemRendererState(plotRenderingInfo38);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.renderer.xy.XYItemRendererState xYItemRendererState41 = xYBarRenderer1.initialise(graphics2D5, rectangle2D6, (org.jfree.chart.plot.XYPlot)combinedDomainXYPlot8, (org.jfree.data.xy.XYDataset)timeSeriesCollection34, plotRenderingInfo38);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i39 == 0);

  }

  @Test
  public void test312() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test312"); }


    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator3 = new org.jfree.chart.urls.StandardXYURLGenerator("", "hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!", "");
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    boolean b12 = combinedDomainXYPlot9.isNotify();
    org.jfree.chart.JFreeChart jFreeChart14 = new org.jfree.chart.JFreeChart("", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    java.awt.Stroke stroke15 = jFreeChart14.getBorderStroke();
    jFreeChart14.setBackgroundImageAlignment(2);
    java.util.List list18 = jFreeChart14.getSubtitles();
    jFreeChart14.fireChartChanged();
    boolean b20 = standardXYURLGenerator3.equals((java.lang.Object)jFreeChart14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);

  }

  @Test
  public void test313() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test313"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    xYAreaRenderer1.setBaseSeriesVisible(false);
    xYAreaRenderer1.setUseFillPaint(true);

  }

  @Test
  public void test314() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test314"); }


    org.jfree.chart.labels.StandardXYSeriesLabelGenerator standardXYSeriesLabelGenerator1 = new org.jfree.chart.labels.StandardXYSeriesLabelGenerator("");
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D3 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.geom.Rectangle2D rectangle2D9 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge10 = null;
    double d11 = categoryAxis3D3.getCategorySeriesMiddle((-1), 255, (-1), 0, 0.0d, rectangle2D9, rectangleEdge10);
    boolean b12 = standardXYSeriesLabelGenerator1.equals((java.lang.Object)rectangle2D9);
    java.lang.Object obj13 = standardXYSeriesLabelGenerator1.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d11, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj13);

  }

  @Test
  public void test315() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test315"); }


    org.jfree.chart.axis.NumberAxis3D numberAxis3D0 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Paint paint1 = org.jfree.chart.axis.Axis.DEFAULT_AXIS_LINE_PAINT;
    numberAxis3D0.setLabelPaint(paint1);
    java.text.NumberFormat numberFormat3 = numberAxis3D0.getNumberFormatOverride();
    numberAxis3D0.setFixedAutoRange(10.0d);
    boolean b6 = numberAxis3D0.isPositiveArrowVisible();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(numberFormat3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);

  }

  @Test
  public void test316() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test316"); }


    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator1 = null;
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator3 = new org.jfree.chart.urls.StandardXYURLGenerator("");
    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer4 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(100, xYToolTipGenerator1, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator3);
    xYStepAreaRenderer4.setPlotArea(true);
    java.lang.Object obj7 = null;
    boolean b8 = xYStepAreaRenderer4.equals(obj7);
    java.awt.Font font10 = xYStepAreaRenderer4.getLegendTextFont(40);
    boolean b11 = xYStepAreaRenderer4.getPlotArea();
    boolean b12 = xYStepAreaRenderer4.getPlotArea();
    xYStepAreaRenderer4.setShapesVisible(true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(font10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);

  }

  @Test
  public void test317() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test317"); }


    java.lang.Class clazz0 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.lang.ClassLoader classLoader1 = org.jfree.chart.util.ObjectUtilities.getClassLoader(clazz0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test318() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test318"); }


    org.jfree.chart.block.BlockBorder blockBorder0 = org.jfree.chart.block.BlockBorder.NONE;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockBorder0);

  }

  @Test
  public void test319() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test319"); }


    org.jfree.data.category.CategoryDataset categoryDataset0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.general.PieDataset pieDataset2 = org.jfree.data.general.DatasetUtilities.createPieDatasetForRow(categoryDataset0, 2016);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test320() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test320"); }


    org.jfree.data.time.SpreadsheetDate spreadsheetDate1 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate3 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b4 = spreadsheetDate1.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate3);
    int i5 = spreadsheetDate1.getYYYY();
    org.jfree.data.time.SpreadsheetDate spreadsheetDate7 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate9 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b10 = spreadsheetDate7.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate9);
    int i11 = spreadsheetDate9.getMonth();
    boolean b12 = spreadsheetDate1.isOnOrBefore((org.jfree.data.time.SerialDate)spreadsheetDate9);
    int i13 = spreadsheetDate1.getYYYY();
    org.jfree.data.general.DefaultPieDataset defaultPieDataset14 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj15 = defaultPieDataset14.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D16 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset14);
    piePlot3D16.setIgnoreZeroValues(true);
    org.jfree.chart.axis.CategoryAxis categoryAxis20 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets21 = categoryAxis20.getLabelInsets();
    categoryAxis20.setMinorTickMarkOutsideLength(2.0f);
    org.jfree.chart.event.AxisChangeEvent axisChangeEvent24 = new org.jfree.chart.event.AxisChangeEvent((org.jfree.chart.axis.Axis)categoryAxis20);
    piePlot3D16.axisChanged(axisChangeEvent24);
    boolean b26 = spreadsheetDate1.equals((java.lang.Object)axisChangeEvent24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 1900);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i11 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i13 == 1900);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == false);

  }

  @Test
  public void test321() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test321"); }


    org.jfree.chart.block.CenterArrangement centerArrangement0 = new org.jfree.chart.block.CenterArrangement();
    org.jfree.data.general.WaferMapDataset waferMapDataset1 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot2 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset1);
    org.jfree.chart.JFreeChart jFreeChart3 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent4 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot2, jFreeChart3);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment5 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment6 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement9 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment5, verticalAlignment6, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement10 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle11 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot2, (org.jfree.chart.block.Arrangement)flowArrangement9, (org.jfree.chart.block.Arrangement)borderArrangement10);
    org.jfree.data.time.TimeSeries timeSeries12 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection13 = new org.jfree.data.time.TimeSeriesCollection(timeSeries12);
    timeSeriesCollection13.validateObject();
    java.lang.Comparable comparable15 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer16 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement9, (org.jfree.data.general.Dataset)timeSeriesCollection13, comparable15);
    org.jfree.data.general.Dataset dataset17 = legendItemBlockContainer16.getDataset();
    java.awt.Graphics2D graphics2D18 = null;
    org.jfree.data.Range range20 = null;
    org.jfree.chart.block.LengthConstraintType lengthConstraintType21 = org.jfree.chart.block.LengthConstraintType.NONE;
    org.jfree.data.time.DateRange dateRange25 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange28 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b29 = dateRange25.intersects((org.jfree.data.Range)dateRange28);
    org.jfree.data.Range range31 = org.jfree.data.Range.expandToInclude((org.jfree.data.Range)dateRange25, 1.0d);
    org.jfree.chart.block.LengthConstraintType lengthConstraintType32 = org.jfree.chart.block.LengthConstraintType.NONE;
    org.jfree.chart.block.RectangleConstraint rectangleConstraint33 = new org.jfree.chart.block.RectangleConstraint(2.0d, range20, lengthConstraintType21, 0.0d, range31, lengthConstraintType32);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.util.Size2D size2D34 = centerArrangement0.arrange((org.jfree.chart.block.BlockContainer)legendItemBlockContainer16, graphics2D18, rectangleConstraint33);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dataset17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType32);

  }

  @Test
  public void test322() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test322"); }


    org.jfree.data.time.SpreadsheetDate spreadsheetDate1 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate3 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b4 = spreadsheetDate1.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate3);
    int i5 = spreadsheetDate1.getYYYY();
    org.jfree.data.time.SpreadsheetDate spreadsheetDate7 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate9 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b10 = spreadsheetDate7.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate9);
    int i11 = spreadsheetDate9.getMonth();
    boolean b12 = spreadsheetDate1.isOnOrBefore((org.jfree.data.time.SerialDate)spreadsheetDate9);
    int i13 = spreadsheetDate1.getYYYY();
    org.jfree.data.time.SerialDate serialDate14 = null;
    // The following exception was thrown during execution in test generation
    try {
      boolean b15 = spreadsheetDate1.isBefore(serialDate14);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 1900);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i11 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i13 == 1900);

  }

  @Test
  public void test323() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test323"); }


    org.jfree.chart.renderer.category.BarRenderer barRenderer0 = new org.jfree.chart.renderer.category.BarRenderer();
    double d1 = barRenderer0.getShadowXOffset();
    barRenderer0.setShadowXOffset(10.0d);
    boolean b4 = barRenderer0.getIncludeBaseInRange();
    java.awt.Graphics2D graphics2D5 = null;
    org.jfree.chart.plot.CategoryPlot categoryPlot6 = new org.jfree.chart.plot.CategoryPlot();
    boolean b7 = categoryPlot6.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge9 = categoryPlot6.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis11 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets12 = categoryAxis11.getLabelInsets();
    double d14 = rectangleInsets12.calculateLeftInset(4.0d);
    categoryPlot6.setInsets(rectangleInsets12, false);
    org.jfree.chart.util.Layer layer18 = null;
    java.util.Collection collection19 = categoryPlot6.getDomainMarkers(5, layer18);
    org.jfree.chart.axis.NumberAxis numberAxis20 = new org.jfree.chart.axis.NumberAxis();
    numberAxis20.resizeRange2(10.0d, 11.0d);
    org.jfree.chart.util.RectangleInsets rectangleInsets24 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d25 = rectangleInsets24.getLeft();
    numberAxis20.setTickLabelInsets(rectangleInsets24);
    double d27 = numberAxis20.getUpperMargin();
    numberAxis20.setInverted(false);
    java.awt.geom.Rectangle2D rectangle2D30 = null;
    org.jfree.chart.StandardChartTheme standardChartTheme33 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Shape shape41 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color43 = java.awt.Color.green;
    java.awt.Color color45 = java.awt.Color.green;
    java.awt.Color color51 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke52 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color53 = java.awt.Color.orange;
    java.awt.Stroke stroke54 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker56 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color51, stroke52, (java.awt.Paint)color53, stroke54, 0.0f);
    java.awt.Shape shape60 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke61 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color62 = java.awt.Color.green;
    java.lang.String str63 = org.jfree.chart.util.PaintUtilities.colorToString(color62);
    org.jfree.chart.LegendItem legendItem64 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape41, true, (java.awt.Paint)color43, false, (java.awt.Paint)color45, stroke52, true, shape60, stroke61, (java.awt.Paint)color62);
    standardChartTheme33.setCrosshairPaint((java.awt.Paint)color43);
    java.awt.Paint paint66 = standardChartTheme33.getPlotBackgroundPaint();
    java.awt.Paint paint67 = standardChartTheme33.getBaselinePaint();
    org.jfree.chart.plot.CategoryPlot categoryPlot68 = new org.jfree.chart.plot.CategoryPlot();
    boolean b69 = categoryPlot68.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge71 = categoryPlot68.getDomainAxisEdge(8);
    java.awt.Font font73 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset74 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot75 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset74);
    org.jfree.chart.axis.ValueAxis valueAxis76 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot77 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis76);
    java.util.List list78 = combinedDomainXYPlot77.getAnnotations();
    waferMapPlot75.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot77);
    org.jfree.chart.JFreeChart jFreeChart81 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font73, (org.jfree.chart.plot.Plot)combinedDomainXYPlot77, true);
    org.jfree.chart.axis.NumberAxis numberAxis83 = new org.jfree.chart.axis.NumberAxis();
    numberAxis83.centerRange(100.0d);
    combinedDomainXYPlot77.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis83);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier87 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot77.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier87);
    categoryPlot68.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier87);
    categoryPlot68.clearRangeMarkers(100);
    boolean b92 = categoryPlot68.isRangePannable();
    float f93 = categoryPlot68.getBackgroundAlpha();
    java.awt.Stroke stroke94 = categoryPlot68.getDomainCrosshairStroke();
    barRenderer0.drawRangeLine(graphics2D5, categoryPlot6, (org.jfree.chart.axis.ValueAxis)numberAxis20, rectangle2D30, 0.0d, paint67, stroke94);
    org.jfree.chart.labels.CategoryItemLabelGenerator categoryItemLabelGenerator99 = barRenderer0.getItemLabelGenerator(4, 64, true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d25 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 0.05d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str63 + "' != '" + "green"+ "'", str63.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b69 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font73);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list78);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b92 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f93 == 1.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke94);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryItemLabelGenerator99);

  }

  @Test
  public void test324() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test324"); }


    java.awt.Shape shape2 = org.jfree.chart.util.ShapeUtilities.createRegularCross(0.0f, 0.5f);
    java.io.ObjectOutputStream objectOutputStream3 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.util.SerialUtilities.writeShape(shape2, objectOutputStream3);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape2);

  }

  @Test
  public void test325() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test325"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis2 = new org.jfree.chart.axis.CategoryAxis("");
    java.awt.Font font4 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset5 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot6 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset5);
    org.jfree.chart.axis.ValueAxis valueAxis7 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot8 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis7);
    java.util.List list9 = combinedDomainXYPlot8.getAnnotations();
    waferMapPlot6.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot8);
    org.jfree.chart.JFreeChart jFreeChart12 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font4, (org.jfree.chart.plot.Plot)combinedDomainXYPlot8, true);
    categoryAxis2.setLabelFont(font4);
    org.jfree.chart.plot.CategoryPlot categoryPlot14 = new org.jfree.chart.plot.CategoryPlot();
    boolean b15 = categoryPlot14.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge17 = categoryPlot14.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis19 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets20 = categoryAxis19.getLabelInsets();
    double d22 = rectangleInsets20.calculateLeftInset(4.0d);
    categoryPlot14.setInsets(rectangleInsets20, false);
    org.jfree.chart.util.Layer layer26 = null;
    java.util.Collection collection27 = categoryPlot14.getDomainMarkers(5, layer26);
    java.lang.Comparable comparable28 = null;
    categoryPlot14.setDomainCrosshairColumnKey(comparable28, true);
    org.jfree.chart.JFreeChart jFreeChart32 = new org.jfree.chart.JFreeChart("null", font4, (org.jfree.chart.plot.Plot)categoryPlot14, false);
    boolean b33 = categoryPlot14.isRangeZeroBaselineVisible();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d22 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);

  }

  @Test
  public void test326() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test326"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis5 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets6 = categoryAxis5.getLabelInsets();
    double d8 = rectangleInsets6.calculateLeftInset(4.0d);
    categoryPlot0.setInsets(rectangleInsets6, false);
    java.awt.Font font12 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset13 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot14 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset13);
    org.jfree.chart.axis.ValueAxis valueAxis15 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot16 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis15);
    java.util.List list17 = combinedDomainXYPlot16.getAnnotations();
    waferMapPlot14.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot16);
    boolean b19 = combinedDomainXYPlot16.isNotify();
    org.jfree.chart.JFreeChart jFreeChart21 = new org.jfree.chart.JFreeChart("", font12, (org.jfree.chart.plot.Plot)combinedDomainXYPlot16, true);
    combinedDomainXYPlot16.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.axis.AxisLocation axisLocation25 = null;
    combinedDomainXYPlot16.setDomainAxisLocation(3, axisLocation25, false);
    org.jfree.chart.axis.AxisLocation axisLocation28 = combinedDomainXYPlot16.getRangeAxisLocation();
    categoryPlot0.setDomainAxisLocation(axisLocation28);
    org.jfree.chart.axis.AxisLocation axisLocation30 = org.jfree.chart.axis.AxisLocation.getOpposite(axisLocation28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation30);

  }

  @Test
  public void test327() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test327"); }


    org.jfree.chart.util.LogFormat logFormat4 = new org.jfree.chart.util.LogFormat(10.0d, "", true);
    java.lang.String str6 = logFormat4.format((java.lang.Object)100.0f);
    org.jfree.chart.util.LogFormat logFormat10 = new org.jfree.chart.util.LogFormat(10.0d, "", true);
    org.jfree.chart.labels.StandardPieSectionLabelGenerator standardPieSectionLabelGenerator11 = new org.jfree.chart.labels.StandardPieSectionLabelGenerator("", (java.text.NumberFormat)logFormat4, (java.text.NumberFormat)logFormat10);
    boolean b12 = logFormat10.isParseIntegerOnly();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "^2.0"+ "'", str6.equals("^2.0"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);

  }

  @Test
  public void test328() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test328"); }


    int i0 = java.text.NumberFormat.FRACTION_FIELD;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 1);

  }

  @Test
  public void test329() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test329"); }


    org.jfree.chart.plot.PlotOrientation plotOrientation0 = org.jfree.chart.plot.PlotOrientation.HORIZONTAL;
    boolean b2 = org.jfree.chart.util.ObjectUtilities.equal((java.lang.Object)plotOrientation0, (java.lang.Object)'#');
    java.lang.String str3 = plotOrientation0.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str3 + "' != '" + "PlotOrientation.HORIZONTAL"+ "'", str3.equals("PlotOrientation.HORIZONTAL"));

  }

  @Test
  public void test330() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test330"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    xYStepRenderer0.setSeriesShapesFilled(15, false);
    boolean b6 = xYStepRenderer0.getItemLineVisible(1, 8);
    xYStepRenderer0.setBaseShapesFilled(true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);

  }

  @Test
  public void test331() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test331"); }


    org.jfree.chart.block.LabelBlock labelBlock1 = new org.jfree.chart.block.LabelBlock("February 2016");

  }

  @Test
  public void test332() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test332"); }


    java.awt.Color color5 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke6 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color7 = java.awt.Color.orange;
    java.awt.Stroke stroke8 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker10 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color5, stroke6, (java.awt.Paint)color7, stroke8, 0.0f);
    java.awt.Paint paint11 = intervalMarker10.getOutlinePaint();
    intervalMarker10.setEndValue(3.0d);
    org.jfree.chart.plot.CategoryPlot categoryPlot14 = new org.jfree.chart.plot.CategoryPlot();
    categoryPlot14.setDomainCrosshairRowKey((java.lang.Comparable)"TextBlockAnchor.BOTTOM_RIGHT");
    java.awt.Paint paint17 = categoryPlot14.getRangeMinorGridlinePaint();
    intervalMarker10.setLabelPaint(paint17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint17);

  }

  @Test
  public void test333() {}
// Defects4J: flaky method
//   @Test
//   public void test333() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test333"); }
// 
// 
//     java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
//     org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
//     org.jfree.chart.axis.ValueAxis valueAxis4 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
//     java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
//     waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
//     org.jfree.chart.JFreeChart jFreeChart9 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
//     org.jfree.chart.axis.AxisSpace axisSpace10 = null;
//     combinedDomainXYPlot5.setFixedRangeAxisSpace(axisSpace10);
//     org.jfree.chart.axis.ValueAxis valueAxis12 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot13 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis12);
//     java.util.List list14 = combinedDomainXYPlot13.getAnnotations();
//     combinedDomainXYPlot13.setRangeGridlinesVisible(true);
//     org.jfree.chart.axis.ValueAxis valueAxis18 = null;
//     combinedDomainXYPlot13.setRangeAxis(100, valueAxis18, false);
//     org.jfree.chart.axis.NumberAxis numberAxis21 = new org.jfree.chart.axis.NumberAxis();
//     numberAxis21.centerRange(100.0d);
//     combinedDomainXYPlot13.setRangeAxis((org.jfree.chart.axis.ValueAxis)numberAxis21);
//     boolean b25 = numberAxis21.isNegativeArrowVisible();
//     org.jfree.data.time.DateRange dateRange28 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     org.jfree.data.time.DateRange dateRange31 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     boolean b32 = dateRange28.intersects((org.jfree.data.Range)dateRange31);
//     java.lang.String str33 = dateRange28.toString();
//     numberAxis21.setDefaultAutoRange((org.jfree.data.Range)dateRange28);
//     numberAxis21.setTickMarkInsideLength(10.0f);
//     org.jfree.data.Range range37 = combinedDomainXYPlot5.getDataRange((org.jfree.chart.axis.ValueAxis)numberAxis21);
//     boolean b38 = combinedDomainXYPlot5.isDomainZoomable();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(font1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list6);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b25 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b32 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str33 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str33.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(range37);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b38 == true);
// 
//   }

  @Test
  public void test334() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test334"); }


    org.jfree.chart.renderer.category.BarRenderer3D barRenderer3D2 = new org.jfree.chart.renderer.category.BarRenderer3D(1.0E-8d, 1.0d);
    java.awt.Paint paint3 = barRenderer3D2.getWallPaint();
    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot4 = new org.jfree.chart.plot.MultiplePiePlot();
    java.awt.Paint paint5 = multiplePiePlot4.getOutlinePaint();
    java.awt.Shape shape6 = multiplePiePlot4.getLegendItemShape();
    org.jfree.chart.axis.NumberAxis numberAxis7 = new org.jfree.chart.axis.NumberAxis();
    numberAxis7.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer11 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator12 = xYAreaRenderer11.getLegendItemToolTipGenerator();
    java.awt.Shape shape13 = xYAreaRenderer11.getBaseShape();
    numberAxis7.setUpArrow(shape13);
    numberAxis7.pan((-1.0d));
    java.awt.Paint paint17 = numberAxis7.getAxisLinePaint();
    multiplePiePlot4.setAggregatedItemsPaint(paint17);
    barRenderer3D2.setWallPaint(paint17);
    java.awt.Paint paint20 = barRenderer3D2.getShadowPaint();
    org.jfree.chart.labels.CategoryItemLabelGenerator categoryItemLabelGenerator21 = barRenderer3D2.getBaseItemLabelGenerator();
    java.awt.Graphics2D graphics2D22 = null;
    org.jfree.chart.plot.CategoryPlot categoryPlot23 = new org.jfree.chart.plot.CategoryPlot();
    boolean b24 = categoryPlot23.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge26 = categoryPlot23.getDomainAxisEdge(8);
    java.awt.Font font28 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset29 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot30 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset29);
    org.jfree.chart.axis.ValueAxis valueAxis31 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot32 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis31);
    java.util.List list33 = combinedDomainXYPlot32.getAnnotations();
    waferMapPlot30.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot32);
    org.jfree.chart.JFreeChart jFreeChart36 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font28, (org.jfree.chart.plot.Plot)combinedDomainXYPlot32, true);
    org.jfree.chart.axis.NumberAxis numberAxis38 = new org.jfree.chart.axis.NumberAxis();
    numberAxis38.centerRange(100.0d);
    combinedDomainXYPlot32.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis38);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier42 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot32.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier42);
    categoryPlot23.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier42);
    categoryPlot23.clearRangeMarkers(100);
    boolean b47 = categoryPlot23.isRangePannable();
    float f48 = categoryPlot23.getBackgroundAlpha();
    double d49 = categoryPlot23.getRangeCrosshairValue();
    org.jfree.data.xy.XYSeries xYSeries50 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection51 = new org.jfree.data.xy.XYSeriesCollection(xYSeries50);
    boolean b52 = xYSeriesCollection51.isAutoWidth();
    org.jfree.data.Range range54 = xYSeriesCollection51.getRangeBounds(true);
    xYSeriesCollection51.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis57 = new org.jfree.chart.axis.NumberAxis();
    numberAxis57.centerRange(100.0d);
    java.lang.Object obj60 = numberAxis57.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer61 = null;
    org.jfree.chart.plot.PolarPlot polarPlot62 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection51, (org.jfree.chart.axis.ValueAxis)numberAxis57, polarItemRenderer61);
    org.jfree.chart.plot.PlotOrientation plotOrientation63 = polarPlot62.getOrientation();
    boolean b64 = polarPlot62.isAngleLabelsVisible();
    int i65 = polarPlot62.getSeriesCount();
    java.awt.Font font70 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset71 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot72 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset71);
    org.jfree.chart.axis.ValueAxis valueAxis73 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot74 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis73);
    java.util.List list75 = combinedDomainXYPlot74.getAnnotations();
    waferMapPlot72.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot74);
    boolean b77 = combinedDomainXYPlot74.isNotify();
    org.jfree.chart.JFreeChart jFreeChart79 = new org.jfree.chart.JFreeChart("", font70, (org.jfree.chart.plot.Plot)combinedDomainXYPlot74, true);
    org.jfree.chart.title.TextTitle textTitle80 = new org.jfree.chart.title.TextTitle("", font70);
    textTitle80.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame83 = textTitle80.getFrame();
    java.lang.String str84 = textTitle80.getID();
    java.awt.geom.Rectangle2D rectangle2D85 = textTitle80.getBounds();
    java.awt.Point point86 = polarPlot62.translateValueThetaRadiusToJava2D(0.0d, 0.05d, rectangle2D85);
    // The following exception was thrown during execution in test generation
    try {
      barRenderer3D2.drawOutline(graphics2D22, categoryPlot23, rectangle2D85);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryItemLabelGenerator21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b47 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f48 == 1.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d49 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b52 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b64 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i65 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b77 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame83);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point86);

  }

  @Test
  public void test335() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test335"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    org.jfree.chart.plot.Plot plot2 = combinedDomainXYPlot1.getRootPlot();
    org.jfree.chart.axis.ValueAxis valueAxis3 = null;
    int i4 = combinedDomainXYPlot1.getRangeAxisIndex(valueAxis3);
    org.jfree.data.xy.XYSeries xYSeries6 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection7 = new org.jfree.data.xy.XYSeriesCollection(xYSeries6);
    boolean b8 = xYSeriesCollection7.isAutoWidth();
    org.jfree.data.Range range10 = xYSeriesCollection7.getRangeBounds(true);
    combinedDomainXYPlot1.setDataset(0, (org.jfree.data.xy.XYDataset)xYSeriesCollection7);
    org.jfree.data.xy.IntervalXYDelegate intervalXYDelegate13 = new org.jfree.data.xy.IntervalXYDelegate((org.jfree.data.xy.XYDataset)xYSeriesCollection7, false);
    java.lang.Object obj14 = intervalXYDelegate13.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj14);

  }

  @Test
  public void test336() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test336"); }


    int i0 = java.awt.Transparency.TRANSLUCENT;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 3);

  }

  @Test
  public void test337() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test337"); }


    java.awt.Font font2 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset3 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot4 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset3);
    org.jfree.chart.axis.ValueAxis valueAxis5 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot6 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis5);
    java.util.List list7 = combinedDomainXYPlot6.getAnnotations();
    waferMapPlot4.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot6);
    boolean b9 = combinedDomainXYPlot6.isNotify();
    org.jfree.chart.JFreeChart jFreeChart11 = new org.jfree.chart.JFreeChart("", font2, (org.jfree.chart.plot.Plot)combinedDomainXYPlot6, true);
    org.jfree.chart.title.TextTitle textTitle12 = new org.jfree.chart.title.TextTitle("", font2);
    java.lang.String str13 = textTitle12.getID();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str13);

  }

  @Test
  public void test338() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test338"); }


    java.awt.Graphics2D graphics2D1 = null;
    org.jfree.chart.text.TextAnchor textAnchor4 = org.jfree.chart.text.TextAnchor.BOTTOM_LEFT;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.text.TextUtilities.drawRotatedString("java.awt.Color[r=255,g=175,b=175]", graphics2D1, 100.0f, 2.0f, textAnchor4, 0.025d, (-1.0f), 0.0f);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textAnchor4);

  }

  @Test
  public void test339() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test339"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer13 = null;
    combinedDomainXYPlot5.setRenderer(xYItemRenderer13);
    boolean b15 = combinedDomainXYPlot5.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries16 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection17 = new org.jfree.data.time.TimeSeriesCollection(timeSeries16);
    combinedDomainXYPlot5.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    boolean b19 = combinedDomainXYPlot5.isRangeZoomable();
    java.util.List list20 = combinedDomainXYPlot5.getSubplots();
    org.jfree.chart.util.RectangleEdge rectangleEdge21 = combinedDomainXYPlot5.getDomainAxisEdge();
    java.awt.Paint paint22 = combinedDomainXYPlot5.getRangeTickBandPaint();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint22);

  }

  @Test
  public void test340() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test340"); }


    org.jfree.chart.axis.NumberAxis numberAxis0 = new org.jfree.chart.axis.NumberAxis();
    numberAxis0.resizeRange2(10.0d, 11.0d);
    double d4 = numberAxis0.getUpperMargin();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 0.05d);

  }

  @Test
  public void test341() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test341"); }


    java.awt.Image image3 = null;
    org.jfree.chart.ui.ProjectInfo projectInfo7 = new org.jfree.chart.ui.ProjectInfo("hi!", "", "green", image3, "hi!", "^2.0", "hi!");
    java.util.List list8 = projectInfo7.getContributors();
    projectInfo7.setName("^2.0");
    java.lang.Object obj11 = null;
    boolean b12 = projectInfo7.equals(obj11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(list8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);

  }

  @Test
  public void test342() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test342"); }


    java.awt.Shape shape2 = org.jfree.chart.util.ShapeUtilities.createRegularCross(1.0f, 2.0f);
    java.awt.Shape shape6 = org.jfree.chart.util.ShapeUtilities.rotateShape(shape2, 0.0d, 100.0f, 2.0f);
    org.jfree.data.xy.XYSeries xYSeries7 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection8 = new org.jfree.data.xy.XYSeriesCollection(xYSeries7);
    boolean b9 = xYSeriesCollection8.isAutoWidth();
    org.jfree.data.Range range11 = xYSeriesCollection8.getRangeBounds(true);
    xYSeriesCollection8.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis14 = new org.jfree.chart.axis.NumberAxis();
    numberAxis14.centerRange(100.0d);
    java.lang.Object obj17 = numberAxis14.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer18 = null;
    org.jfree.chart.plot.PolarPlot polarPlot19 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection8, (org.jfree.chart.axis.ValueAxis)numberAxis14, polarItemRenderer18);
    org.jfree.chart.plot.PlotOrientation plotOrientation20 = polarPlot19.getOrientation();
    org.jfree.chart.axis.ValueAxis valueAxis23 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot24 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis23);
    org.jfree.chart.plot.PlotOrientation plotOrientation25 = combinedDomainXYPlot24.getOrientation();
    boolean b26 = combinedDomainXYPlot24.isDomainCrosshairLockedOnData();
    org.jfree.chart.entity.EntityCollection entityCollection28 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo29 = new org.jfree.chart.ChartRenderingInfo(entityCollection28);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo30 = chartRenderingInfo29.getPlotInfo();
    java.awt.geom.Point2D point2D31 = null;
    combinedDomainXYPlot24.panDomainAxes(4.5d, plotRenderingInfo30, point2D31);
    int i33 = plotRenderingInfo30.getSubplotCount();
    org.jfree.chart.entity.EntityCollection entityCollection34 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo35 = new org.jfree.chart.ChartRenderingInfo(entityCollection34);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo36 = chartRenderingInfo35.getPlotInfo();
    plotRenderingInfo30.addSubplotInfo(plotRenderingInfo36);
    java.awt.geom.Rectangle2D rectangle2D38 = null;
    org.jfree.chart.util.RectangleAnchor rectangleAnchor39 = null;
    java.awt.geom.Point2D point2D40 = org.jfree.chart.util.RectangleAnchor.coordinates(rectangle2D38, rectangleAnchor39);
    polarPlot19.zoomDomainAxes(1.0d, 0.6d, plotRenderingInfo36, point2D40);
    org.jfree.chart.entity.PlotEntity plotEntity44 = new org.jfree.chart.entity.PlotEntity(shape6, (org.jfree.chart.plot.Plot)polarPlot19, "SeriesRenderingOrder.FORWARD", "");
    java.awt.Color color50 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke51 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color52 = java.awt.Color.orange;
    java.awt.Stroke stroke53 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker55 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color50, stroke51, (java.awt.Paint)color52, stroke53, 0.0f);
    polarPlot19.setRadiusGridlineStroke(stroke53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i33 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point2D40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke53);

  }

  @Test
  public void test343() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test343"); }


    org.jfree.chart.axis.SegmentedTimeline segmentedTimeline3 = new org.jfree.chart.axis.SegmentedTimeline(1L, 100, 14);

  }

  @Test
  public void test344() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test344"); }


    org.jfree.chart.axis.NumberAxis numberAxis0 = new org.jfree.chart.axis.NumberAxis();
    numberAxis0.centerRange(100.0d);
    java.awt.Paint paint3 = numberAxis0.getLabelPaint();
    java.awt.Color color7 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    numberAxis0.setTickLabelPaint((java.awt.Paint)color7);
    float[] f_array10 = new float[] { 1.0f };
    // The following exception was thrown during execution in test generation
    try {
      float[] f_array11 = color7.getColorComponents(f_array10);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array10);

  }

  @Test
  public void test345() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test345"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    piePlot3D2.setLabelLinksVisible(false);
    java.lang.Object obj6 = piePlot3D2.clone();
    org.jfree.chart.util.LogFormat logFormat11 = new org.jfree.chart.util.LogFormat(10.0d, "", true);
    java.lang.String str13 = logFormat11.format((java.lang.Object)100.0f);
    org.jfree.chart.util.LogFormat logFormat17 = new org.jfree.chart.util.LogFormat(10.0d, "", true);
    org.jfree.chart.labels.StandardPieSectionLabelGenerator standardPieSectionLabelGenerator18 = new org.jfree.chart.labels.StandardPieSectionLabelGenerator("", (java.text.NumberFormat)logFormat11, (java.text.NumberFormat)logFormat17);
    org.jfree.chart.axis.CategoryAxis categoryAxis19 = new org.jfree.chart.axis.CategoryAxis();
    categoryAxis19.setVisible(false);
    org.jfree.chart.util.RectangleInsets rectangleInsets22 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d23 = rectangleInsets22.getLeft();
    double d25 = rectangleInsets22.calculateLeftOutset(1.0d);
    categoryAxis19.setLabelInsets(rectangleInsets22, true);
    boolean b28 = standardPieSectionLabelGenerator18.equals((java.lang.Object)rectangleInsets22);
    piePlot3D2.setLabelPadding(rectangleInsets22);
    piePlot3D2.setMaximumLabelWidth(10.0d);
    java.awt.Paint paint32 = piePlot3D2.getLabelOutlinePaint();
    piePlot3D2.clearSectionPaints(false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str13 + "' != '" + "^2.0"+ "'", str13.equals("^2.0"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d23 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d25 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint32);

  }

  @Test
  public void test346() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test346"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis1 = new org.jfree.chart.axis.CategoryAxis("");
    java.awt.Font font3 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset4 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot5 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset4);
    org.jfree.chart.axis.ValueAxis valueAxis6 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot7 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis6);
    java.util.List list8 = combinedDomainXYPlot7.getAnnotations();
    waferMapPlot5.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot7);
    org.jfree.chart.JFreeChart jFreeChart11 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font3, (org.jfree.chart.plot.Plot)combinedDomainXYPlot7, true);
    categoryAxis1.setLabelFont(font3);
    categoryAxis1.clearCategoryLabelToolTips();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list8);

  }

  @Test
  public void test347() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test347"); }


    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D1 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke2 = categoryAxis3D1.getTickMarkStroke();
    java.awt.Stroke stroke3 = org.jfree.chart.plot.CategoryPlot.DEFAULT_CROSSHAIR_STROKE;
    categoryAxis3D1.setAxisLineStroke(stroke3);
    categoryAxis3D1.clearCategoryLabelToolTips();
    java.awt.Font font7 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset8 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot9 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset8);
    org.jfree.chart.axis.ValueAxis valueAxis10 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot11 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis10);
    java.util.List list12 = combinedDomainXYPlot11.getAnnotations();
    waferMapPlot9.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot11);
    boolean b14 = combinedDomainXYPlot11.isNotify();
    org.jfree.chart.JFreeChart jFreeChart16 = new org.jfree.chart.JFreeChart("", font7, (org.jfree.chart.plot.Plot)combinedDomainXYPlot11, true);
    java.awt.Stroke stroke17 = jFreeChart16.getBorderStroke();
    boolean b18 = jFreeChart16.isBorderVisible();
    java.lang.Object obj19 = jFreeChart16.clone();
    java.awt.Paint paint20 = jFreeChart16.getBorderPaint();
    categoryAxis3D1.setTickMarkPaint(paint20);
    categoryAxis3D1.setUpperMargin(300000.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint20);

  }

  @Test
  public void test348() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test348"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    org.jfree.data.time.TimeSeries timeSeries11 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection12 = new org.jfree.data.time.TimeSeriesCollection(timeSeries11);
    timeSeriesCollection12.validateObject();
    java.lang.Comparable comparable14 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer15 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.data.general.Dataset)timeSeriesCollection12, comparable14);
    org.jfree.data.general.Dataset dataset16 = legendItemBlockContainer15.getDataset();
    java.lang.Comparable comparable17 = legendItemBlockContainer15.getSeriesKey();
    legendItemBlockContainer15.setURLText("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]");
    legendItemBlockContainer15.setToolTipText("DatasetRenderingOrder.REVERSE");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dataset16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(comparable17);

  }

  @Test
  public void test349() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test349"); }


    org.jfree.chart.util.Rotation rotation0 = org.jfree.chart.util.Rotation.CLOCKWISE;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rotation0);

  }

  @Test
  public void test350() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test350"); }


    org.jfree.data.xy.DefaultXYDataset defaultXYDataset0 = new org.jfree.data.xy.DefaultXYDataset();
    // The following exception was thrown during execution in test generation
    try {
      double d3 = defaultXYDataset0.getXValue(2147483647, (-435));
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test351() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test351"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition3 = xYAreaRenderer1.getSeriesNegativeItemLabelPosition(1);
    org.jfree.chart.plot.CategoryPlot categoryPlot4 = new org.jfree.chart.plot.CategoryPlot();
    boolean b5 = categoryPlot4.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge7 = categoryPlot4.getDomainAxisEdge(8);
    java.awt.Color color14 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke15 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color16 = java.awt.Color.orange;
    java.awt.Stroke stroke17 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker19 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color14, stroke15, (java.awt.Paint)color16, stroke17, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer20 = null;
    intervalMarker19.setGradientPaintTransformer(gradientPaintTransformer20);
    org.jfree.chart.util.RectangleInsets rectangleInsets22 = intervalMarker19.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis24 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets25 = categoryAxis24.getLabelInsets();
    intervalMarker19.setLabelOffset(rectangleInsets25);
    double d27 = intervalMarker19.getEndValue();
    org.jfree.chart.util.Layer layer28 = null;
    boolean b29 = categoryPlot4.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker19, layer28);
    xYAreaRenderer1.removeChangeListener((org.jfree.chart.event.RendererChangeListener)categoryPlot4);
    categoryPlot4.setOutlineVisible(false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);

  }

  @Test
  public void test352() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test352"); }


    org.jfree.data.category.CategoryDataset categoryDataset0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.general.PieDataset pieDataset2 = org.jfree.data.general.DatasetUtilities.createPieDatasetForRow(categoryDataset0, 6);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test353() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test353"); }


    org.jfree.chart.renderer.category.BarRenderer3D barRenderer3D2 = new org.jfree.chart.renderer.category.BarRenderer3D(1.0E-8d, 1.0d);
    barRenderer3D2.clearSeriesStrokes(true);
    java.awt.Graphics2D graphics2D5 = null;
    org.jfree.chart.renderer.category.CategoryItemRendererState categoryItemRendererState6 = null;
    org.jfree.data.xy.XYSeries xYSeries7 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection8 = new org.jfree.data.xy.XYSeriesCollection(xYSeries7);
    boolean b9 = xYSeriesCollection8.isAutoWidth();
    org.jfree.data.Range range11 = xYSeriesCollection8.getRangeBounds(true);
    xYSeriesCollection8.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis14 = new org.jfree.chart.axis.NumberAxis();
    numberAxis14.centerRange(100.0d);
    java.lang.Object obj17 = numberAxis14.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer18 = null;
    org.jfree.chart.plot.PolarPlot polarPlot19 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection8, (org.jfree.chart.axis.ValueAxis)numberAxis14, polarItemRenderer18);
    org.jfree.chart.plot.PlotOrientation plotOrientation20 = polarPlot19.getOrientation();
    boolean b21 = polarPlot19.isAngleLabelsVisible();
    int i22 = polarPlot19.getSeriesCount();
    java.awt.Font font27 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset28 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot29 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset28);
    org.jfree.chart.axis.ValueAxis valueAxis30 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot31 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis30);
    java.util.List list32 = combinedDomainXYPlot31.getAnnotations();
    waferMapPlot29.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot31);
    boolean b34 = combinedDomainXYPlot31.isNotify();
    org.jfree.chart.JFreeChart jFreeChart36 = new org.jfree.chart.JFreeChart("", font27, (org.jfree.chart.plot.Plot)combinedDomainXYPlot31, true);
    org.jfree.chart.title.TextTitle textTitle37 = new org.jfree.chart.title.TextTitle("", font27);
    textTitle37.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame40 = textTitle37.getFrame();
    java.lang.String str41 = textTitle37.getID();
    java.awt.geom.Rectangle2D rectangle2D42 = textTitle37.getBounds();
    java.awt.Point point43 = polarPlot19.translateValueThetaRadiusToJava2D(0.0d, 0.05d, rectangle2D42);
    org.jfree.chart.plot.CategoryPlot categoryPlot44 = new org.jfree.chart.plot.CategoryPlot();
    org.jfree.chart.axis.ValueAxis valueAxis46 = categoryPlot44.getRangeAxisForDataset(14);
    int i47 = categoryPlot44.getWeight();
    org.jfree.chart.axis.CategoryAxis categoryAxis49 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets50 = categoryAxis49.getLabelInsets();
    categoryAxis49.setMinorTickMarkOutsideLength(2.0f);
    java.lang.String str53 = categoryAxis49.getLabelURL();
    org.jfree.chart.axis.NumberAxis numberAxis54 = new org.jfree.chart.axis.NumberAxis();
    numberAxis54.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer58 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator59 = xYAreaRenderer58.getLegendItemToolTipGenerator();
    java.awt.Shape shape60 = xYAreaRenderer58.getBaseShape();
    numberAxis54.setUpArrow(shape60);
    org.jfree.chart.StandardChartTheme standardChartTheme67 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.renderer.category.BarPainter barPainter68 = standardChartTheme67.getBarPainter();
    java.awt.Font font69 = standardChartTheme67.getLargeFont();
    org.jfree.chart.axis.MarkerAxisBand markerAxisBand70 = new org.jfree.chart.axis.MarkerAxisBand(numberAxis54, 0.2d, 12.0d, 0.0d, 4.5d, font69);
    org.jfree.data.category.CategoryDataset categoryDataset71 = null;
    // The following exception was thrown during execution in test generation
    try {
      barRenderer3D2.drawItem(graphics2D5, categoryItemRendererState6, rectangle2D42, categoryPlot44, categoryAxis49, (org.jfree.chart.axis.ValueAxis)numberAxis54, categoryDataset71, 9999, 1, false, 14);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b21 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i22 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b34 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(valueAxis46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i47 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(barPainter68);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font69);

  }

  @Test
  public void test354() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test354"); }


    int i0 = org.jfree.data.time.SerialDate.SERIAL_UPPER_BOUND;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 2958465);

  }

  @Test
  public void test355() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test355"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    xYStepRenderer0.setSeriesShapesFilled(15, false);
    boolean b6 = xYStepRenderer0.getItemLineVisible(1, 8);
    org.jfree.chart.axis.ValueAxis valueAxis7 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot8 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis7);
    java.util.List list9 = combinedDomainXYPlot8.getAnnotations();
    combinedDomainXYPlot8.setRangeGridlinesVisible(true);
    org.jfree.chart.util.RectangleEdge rectangleEdge13 = combinedDomainXYPlot8.getRangeAxisEdge(4);
    boolean b14 = xYStepRenderer0.equals((java.lang.Object)combinedDomainXYPlot8);
    java.awt.Stroke stroke18 = xYStepRenderer0.getItemStroke(14, 2016, false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);

  }

  @Test
  public void test356() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test356"); }


    org.jfree.chart.axis.NumberTickUnit numberTickUnit1 = new org.jfree.chart.axis.NumberTickUnit(99.5d);

  }

  @Test
  public void test357() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test357"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer13 = null;
    combinedDomainXYPlot5.setRenderer(xYItemRenderer13);
    boolean b15 = combinedDomainXYPlot5.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries16 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection17 = new org.jfree.data.time.TimeSeriesCollection(timeSeries16);
    combinedDomainXYPlot5.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    org.jfree.chart.axis.AxisSpace axisSpace19 = null;
    combinedDomainXYPlot5.setFixedDomainAxisSpace(axisSpace19);
    combinedDomainXYPlot5.mapDatasetToDomainAxis(2, 64);
    org.jfree.chart.util.RectangleEdge rectangleEdge25 = combinedDomainXYPlot5.getDomainAxisEdge(100);
    java.awt.geom.Rectangle2D rectangle2D26 = null;
    org.jfree.chart.util.RectangleAnchor rectangleAnchor27 = null;
    java.awt.geom.Point2D point2D28 = org.jfree.chart.util.RectangleAnchor.coordinates(rectangle2D26, rectangleAnchor27);
    combinedDomainXYPlot5.setQuadrantOrigin(point2D28);
    combinedDomainXYPlot5.setWeight(14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point2D28);

  }

  @Test
  public void test358() {}
// Defects4J: flaky method
//   @Test
//   public void test358() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test358"); }
// 
// 
//     org.jfree.data.time.DateRange dateRange2 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d3 = dateRange2.getLength();
//     long long4 = dateRange2.getLowerMillis();
//     double d5 = dateRange2.getLength();
//     java.lang.String str6 = dateRange2.toString();
//     java.util.Date date7 = dateRange2.getUpperDate();
//     java.util.TimeZone timeZone8 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year9 = new org.jfree.data.time.Year(date7, timeZone8);
//     java.util.Calendar calendar10 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       year9.peg(calendar10);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long4 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d5 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str6 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str6.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone8);
// 
//   }

  @Test
  public void test359() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test359"); }


    org.jfree.chart.plot.PieLabelDistributor pieLabelDistributor1 = new org.jfree.chart.plot.PieLabelDistributor(2016);

  }

  @Test
  public void test360() {}
// Defects4J: flaky method
//   @Test
//   public void test360() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test360"); }
// 
// 
//     org.jfree.data.time.Month month1 = new org.jfree.data.time.Month();
//     int i2 = month1.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem4 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month1, (java.lang.Number)8);
//     long long5 = month1.getFirstMillisecond();
//     org.jfree.data.time.Month month6 = new org.jfree.data.time.Month();
//     int i7 = month6.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis8 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month1, (org.jfree.data.time.RegularTimePeriod)month6);
//     periodAxis8.setUpperMargin(10.0d);
//     org.jfree.data.Range range11 = periodAxis8.getRange();
//     org.jfree.chart.util.RectangleInsets rectangleInsets12 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
//     double d13 = rectangleInsets12.getLeft();
//     double d15 = rectangleInsets12.calculateLeftOutset(1.0d);
//     double d17 = rectangleInsets12.calculateRightInset(0.05d);
//     periodAxis8.setLabelInsets(rectangleInsets12);
//     org.jfree.chart.plot.CategoryPlot categoryPlot19 = new org.jfree.chart.plot.CategoryPlot();
//     boolean b20 = categoryPlot19.isRangeZoomable();
//     org.jfree.chart.util.RectangleEdge rectangleEdge22 = categoryPlot19.getDomainAxisEdge(8);
//     org.jfree.chart.axis.CategoryAxis categoryAxis24 = new org.jfree.chart.axis.CategoryAxis("");
//     org.jfree.chart.util.RectangleInsets rectangleInsets25 = categoryAxis24.getLabelInsets();
//     double d27 = rectangleInsets25.calculateLeftInset(4.0d);
//     categoryPlot19.setInsets(rectangleInsets25, false);
//     int i30 = categoryPlot19.getRendererCount();
//     org.jfree.chart.axis.NumberAxis numberAxis31 = new org.jfree.chart.axis.NumberAxis();
//     numberAxis31.centerRange(100.0d);
//     java.awt.Paint paint34 = numberAxis31.getLabelPaint();
//     categoryPlot19.setRangeCrosshairPaint(paint34);
//     org.jfree.chart.entity.EntityCollection entityCollection37 = null;
//     org.jfree.chart.ChartRenderingInfo chartRenderingInfo38 = new org.jfree.chart.ChartRenderingInfo(entityCollection37);
//     org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo39 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo38);
//     java.awt.geom.Point2D point2D40 = null;
//     categoryPlot19.panRangeAxes(0.6d, plotRenderingInfo39, point2D40);
//     boolean b42 = periodAxis8.equals((java.lang.Object)categoryPlot19);
//     periodAxis8.setMinorTickMarkOutsideLength(0.5f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i2 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i7 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(range11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d13 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d15 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d17 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b20 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleEdge22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d27 == 3.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i30 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(paint34);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b42 == false);
// 
//   }

  @Test
  public void test361() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test361"); }


    java.awt.Color color0 = java.awt.Color.pink;
    java.lang.String str1 = org.jfree.chart.util.PaintUtilities.colorToString(color0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "pink"+ "'", str1.equals("pink"));

  }

  @Test
  public void test362() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test362"); }


    double d0 = org.jfree.chart.plot.PiePlot.DEFAULT_START_ANGLE;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d0 == 90.0d);

  }

  @Test
  public void test363() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test363"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    boolean b5 = xYAreaRenderer1.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition9 = xYAreaRenderer1.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b11 = xYAreaRenderer1.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator12 = null;
    xYAreaRenderer1.setBaseToolTipGenerator(xYToolTipGenerator12, true);
    java.awt.Shape shape16 = xYAreaRenderer1.lookupLegendShape(3);
    java.awt.Shape shape18 = xYAreaRenderer1.getLegendShape(10);
    java.awt.Shape shape19 = xYAreaRenderer1.getLegendArea();
    java.lang.Object obj20 = xYAreaRenderer1.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(shape18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj20);

  }

  @Test
  public void test364() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test364"); }


    org.jfree.data.function.Function2D function2D0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.xy.XYSeries xYSeries5 = org.jfree.data.general.DatasetUtilities.sampleFunction2DToSeries(function2D0, 3.0d, 99.5d, 40, (java.lang.Comparable)true);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test365() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test365"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    boolean b1 = xYStepRenderer0.getUseFillPaint();
    xYStepRenderer0.setDrawSeriesLineAsPath(false);
    java.awt.Paint paint7 = xYStepRenderer0.getItemFillPaint(2, 8, false);
    java.awt.Graphics2D graphics2D8 = null;
    java.awt.geom.Rectangle2D rectangle2D9 = null;
    org.jfree.chart.plot.XYPlot xYPlot10 = null;
    org.jfree.data.general.WaferMapDataset waferMapDataset11 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot12 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset11);
    org.jfree.chart.JFreeChart jFreeChart13 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent14 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot12, jFreeChart13);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment15 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment16 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement19 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment15, verticalAlignment16, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement20 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle21 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot12, (org.jfree.chart.block.Arrangement)flowArrangement19, (org.jfree.chart.block.Arrangement)borderArrangement20);
    org.jfree.data.time.TimeSeries timeSeries22 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection23 = new org.jfree.data.time.TimeSeriesCollection(timeSeries22);
    timeSeriesCollection23.validateObject();
    java.lang.Comparable comparable25 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer26 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement19, (org.jfree.data.general.Dataset)timeSeriesCollection23, comparable25);
    timeSeriesCollection23.validateObject();
    org.jfree.chart.axis.ValueAxis valueAxis28 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot29 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis28);
    org.jfree.chart.plot.PlotOrientation plotOrientation30 = combinedDomainXYPlot29.getOrientation();
    boolean b31 = combinedDomainXYPlot29.isDomainCrosshairLockedOnData();
    org.jfree.chart.entity.EntityCollection entityCollection33 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo34 = new org.jfree.chart.ChartRenderingInfo(entityCollection33);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo35 = chartRenderingInfo34.getPlotInfo();
    java.awt.geom.Point2D point2D36 = null;
    combinedDomainXYPlot29.panDomainAxes(4.5d, plotRenderingInfo35, point2D36);
    int i38 = plotRenderingInfo35.getSubplotCount();
    org.jfree.chart.entity.EntityCollection entityCollection39 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo40 = new org.jfree.chart.ChartRenderingInfo(entityCollection39);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo41 = chartRenderingInfo40.getPlotInfo();
    plotRenderingInfo35.addSubplotInfo(plotRenderingInfo41);
    org.jfree.chart.renderer.xy.XYItemRendererState xYItemRendererState43 = xYStepRenderer0.initialise(graphics2D8, rectangle2D9, xYPlot10, (org.jfree.data.xy.XYDataset)timeSeriesCollection23, plotRenderingInfo41);
    org.jfree.chart.plot.XYCrosshairState xYCrosshairState44 = xYItemRendererState43.getCrosshairState();
    org.jfree.chart.plot.XYCrosshairState xYCrosshairState45 = new org.jfree.chart.plot.XYCrosshairState();
    int i46 = xYCrosshairState45.getDatasetIndex();
    xYItemRendererState43.setCrosshairState(xYCrosshairState45);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo48 = xYItemRendererState43.getInfo();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i38 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(xYItemRendererState43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYCrosshairState44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i46 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo48);

  }

  @Test
  public void test366() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test366"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = xYStepRenderer0.getSeriesPositiveItemLabelPosition(3);
    java.util.Collection collection3 = xYStepRenderer0.getAnnotations();
    org.jfree.chart.labels.StandardXYSeriesLabelGenerator standardXYSeriesLabelGenerator5 = new org.jfree.chart.labels.StandardXYSeriesLabelGenerator("");
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D7 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.geom.Rectangle2D rectangle2D13 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge14 = null;
    double d15 = categoryAxis3D7.getCategorySeriesMiddle((-1), 255, (-1), 0, 0.0d, rectangle2D13, rectangleEdge14);
    boolean b16 = standardXYSeriesLabelGenerator5.equals((java.lang.Object)rectangle2D13);
    org.jfree.chart.util.LogFormat logFormat20 = new org.jfree.chart.util.LogFormat(10.0d, "", true);
    java.text.ParsePosition parsePosition22 = null;
    java.lang.Object obj23 = logFormat20.parseObject("", parsePosition22);
    boolean b24 = standardXYSeriesLabelGenerator5.equals(obj23);
    xYStepRenderer0.setLegendItemURLGenerator((org.jfree.chart.labels.XYSeriesLabelGenerator)standardXYSeriesLabelGenerator5);
    org.jfree.chart.util.RectangleInsets rectangleInsets26 = org.jfree.chart.axis.Axis.DEFAULT_TICK_LABEL_INSETS;
    boolean b27 = standardXYSeriesLabelGenerator5.equals((java.lang.Object)rectangleInsets26);
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer28 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition30 = xYStepRenderer28.getSeriesPositiveItemLabelPosition(3);
    java.util.Collection collection31 = xYStepRenderer28.getAnnotations();
    boolean b32 = xYStepRenderer28.getBaseShapesFilled();
    org.jfree.chart.labels.XYItemLabelGenerator xYItemLabelGenerator34 = null;
    xYStepRenderer28.setSeriesItemLabelGenerator(255, xYItemLabelGenerator34);
    java.awt.Font font37 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset38 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot39 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset38);
    org.jfree.chart.axis.ValueAxis valueAxis40 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot41 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis40);
    java.util.List list42 = combinedDomainXYPlot41.getAnnotations();
    waferMapPlot39.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot41);
    boolean b44 = combinedDomainXYPlot41.isNotify();
    org.jfree.chart.JFreeChart jFreeChart46 = new org.jfree.chart.JFreeChart("", font37, (org.jfree.chart.plot.Plot)combinedDomainXYPlot41, true);
    combinedDomainXYPlot41.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer49 = null;
    combinedDomainXYPlot41.setRenderer(xYItemRenderer49);
    boolean b51 = combinedDomainXYPlot41.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries52 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection53 = new org.jfree.data.time.TimeSeriesCollection(timeSeries52);
    combinedDomainXYPlot41.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection53);
    java.util.List list55 = timeSeriesCollection53.getSeries();
    org.jfree.data.Range range56 = org.jfree.data.general.DatasetUtilities.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection53);
    org.jfree.data.DomainOrder domainOrder57 = timeSeriesCollection53.getDomainOrder();
    org.jfree.data.Range range58 = xYStepRenderer28.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection53);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.String str60 = standardXYSeriesLabelGenerator5.generateLabel((org.jfree.data.xy.XYDataset)timeSeriesCollection53, 0);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(collection3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d15, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(obj23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(collection31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b51 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range58);

  }

  @Test
  public void test367() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test367"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    org.jfree.data.general.WaferMapDataset waferMapDataset31 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot32 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset31);
    org.jfree.chart.JFreeChart jFreeChart33 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent34 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot32, jFreeChart33);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment35 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment36 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement39 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment35, verticalAlignment36, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement40 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle41 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot32, (org.jfree.chart.block.Arrangement)flowArrangement39, (org.jfree.chart.block.Arrangement)borderArrangement40);
    org.jfree.chart.entity.TitleEntity titleEntity43 = new org.jfree.chart.entity.TitleEntity(shape7, (org.jfree.chart.title.Title)legendTitle41, "green");
    org.jfree.chart.util.RectangleInsets rectangleInsets44 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d45 = rectangleInsets44.getTop();
    legendTitle41.setItemLabelPadding(rectangleInsets44);
    org.jfree.chart.util.RectangleInsets rectangleInsets47 = legendTitle41.getLegendItemGraphicPadding();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d45 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets47);

  }

  @Test
  public void test368() {}
// Defects4J: flaky method
//   @Test
//   public void test368() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test368"); }
// 
// 
//     org.jfree.data.function.Function2D function2D0 = null;
//     org.jfree.data.time.Month month4 = new org.jfree.data.time.Month();
//     int i5 = month4.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem7 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month4, 11.0d);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod8 = month4.previous();
//     long long9 = month4.getLastMillisecond();
//     // The following exception was thrown during execution in test generation
//     try {
//       org.jfree.data.xy.XYDataset xYDataset10 = org.jfree.data.general.DatasetUtilities.sampleFunction2D(function2D0, 90.0d, 0.5d, 3, (java.lang.Comparable)month4);
//       org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
//     } catch (java.lang.IllegalArgumentException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i5 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long9 == 1456819199999L);
// 
//   }

  @Test
  public void test369() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test369"); }


    org.jfree.chart.renderer.category.BarRenderer barRenderer0 = new org.jfree.chart.renderer.category.BarRenderer();
    double d1 = barRenderer0.getShadowXOffset();
    barRenderer0.setShadowXOffset(10.0d);
    boolean b4 = barRenderer0.getIncludeBaseInRange();
    org.jfree.chart.labels.CategoryItemLabelGenerator categoryItemLabelGenerator6 = null;
    barRenderer0.setSeriesItemLabelGenerator(15, categoryItemLabelGenerator6, false);
    org.jfree.chart.plot.CategoryPlot categoryPlot9 = new org.jfree.chart.plot.CategoryPlot();
    boolean b10 = categoryPlot9.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge12 = categoryPlot9.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis14 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets15 = categoryAxis14.getLabelInsets();
    double d17 = rectangleInsets15.calculateLeftInset(4.0d);
    categoryPlot9.setInsets(rectangleInsets15, false);
    org.jfree.chart.util.Layer layer21 = null;
    java.util.Collection collection22 = categoryPlot9.getDomainMarkers(5, layer21);
    org.jfree.data.general.DatasetGroup datasetGroup23 = categoryPlot9.getDatasetGroup();
    barRenderer0.setPlot(categoryPlot9);
    org.jfree.chart.urls.CategoryURLGenerator categoryURLGenerator25 = null;
    barRenderer0.setBaseURLGenerator(categoryURLGenerator25, false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d17 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(datasetGroup23);

  }

  @Test
  public void test370() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test370"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    boolean b31 = legendItem30.isShapeOutlineVisible();
    boolean b33 = legendItem30.equals((java.lang.Object)(short)1);
    java.awt.Paint paint34 = legendItem30.getFillPaint();
    legendItem30.setShapeVisible(true);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer38 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator39 = xYAreaRenderer38.getLegendItemToolTipGenerator();
    boolean b42 = xYAreaRenderer38.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition46 = xYAreaRenderer38.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b48 = xYAreaRenderer38.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator49 = null;
    xYAreaRenderer38.setBaseToolTipGenerator(xYToolTipGenerator49, true);
    java.awt.Shape shape53 = xYAreaRenderer38.lookupLegendShape(3);
    legendItem30.setLine(shape53);
    boolean b55 = legendItem30.isShapeVisible();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b42 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b55 == true);

  }

  @Test
  public void test371() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test371"); }


    float[] f_array4 = new float[] { 10.0f };
    // The following exception was thrown during execution in test generation
    try {
      float[] f_array5 = java.awt.Color.RGBtoHSB(8, 9999, 100, f_array4);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array4);

  }

  @Test
  public void test372() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test372"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    java.awt.Graphics2D graphics2D4 = null;
    java.awt.geom.Rectangle2D rectangle2D5 = null;
    org.jfree.data.general.DefaultPieDataset defaultPieDataset6 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj7 = defaultPieDataset6.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D8 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset6);
    piePlot3D8.setIgnoreZeroValues(true);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo12 = null;
    org.jfree.chart.plot.PiePlotState piePlotState13 = piePlot3D2.initialise(graphics2D4, rectangle2D5, (org.jfree.chart.plot.PiePlot)piePlot3D8, (java.lang.Integer)1, plotRenderingInfo12);
    org.jfree.chart.labels.PieSectionLabelGenerator pieSectionLabelGenerator14 = piePlot3D8.getLegendLabelToolTipGenerator();
    org.jfree.chart.util.RectangleInsets rectangleInsets15 = piePlot3D8.getSimpleLabelOffset();
    java.awt.Paint paint16 = piePlot3D8.getLabelShadowPaint();
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D18 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke19 = categoryAxis3D18.getTickMarkStroke();
    java.awt.Stroke stroke20 = org.jfree.chart.plot.CategoryPlot.DEFAULT_CROSSHAIR_STROKE;
    categoryAxis3D18.setAxisLineStroke(stroke20);
    piePlot3D8.setBaseSectionOutlineStroke(stroke20);
    piePlot3D8.setLabelLinkMargin(0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(piePlotState13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(pieSectionLabelGenerator14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);

  }

  @Test
  public void test373() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test373"); }


    java.lang.Class clazz1 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.io.InputStream inputStream2 = org.jfree.chart.util.ObjectUtilities.getResourceRelativeAsStream("Combined Range XYPlot", clazz1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test374() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test374"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    boolean b1 = xYStepRenderer0.getUseFillPaint();
    xYStepRenderer0.setDrawSeriesLineAsPath(false);
    java.awt.Paint paint7 = xYStepRenderer0.getItemFillPaint(2, 8, false);
    boolean b8 = xYStepRenderer0.getDrawOutlines();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);

  }

  @Test
  public void test375() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test375"); }


    org.jfree.chart.ui.ProjectInfo projectInfo0 = org.jfree.chart.JFreeChart.INFO;
    projectInfo0.setLicenceText("AxisLocation.TOP_OR_RIGHT");
    java.awt.Image image3 = null;
    projectInfo0.setLogo(image3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(projectInfo0);

  }

  @Test
  public void test376() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test376"); }


    java.lang.Number number0 = null;
    org.jfree.chart.axis.TickType tickType2 = org.jfree.chart.axis.TickType.MINOR;
    java.awt.Graphics2D graphics2D6 = null;
    org.jfree.chart.text.TextAnchor textAnchor9 = org.jfree.chart.text.TextAnchor.HALF_ASCENT_CENTER;
    org.jfree.chart.text.TextUtilities.drawRotatedString("", graphics2D6, (-1.0f), 1.0f, textAnchor9, 7.0d, 0.0f, 10.0f);
    org.jfree.chart.text.TextAnchor textAnchor14 = org.jfree.chart.text.TextAnchor.HALF_ASCENT_CENTER;
    org.jfree.chart.axis.NumberTick numberTick16 = new org.jfree.chart.axis.NumberTick(tickType2, 100.0d, "", textAnchor9, textAnchor14, 1.0d);
    org.jfree.chart.labels.ItemLabelAnchor itemLabelAnchor17 = org.jfree.chart.labels.ItemLabelAnchor.OUTSIDE1;
    org.jfree.chart.text.TextAnchor textAnchor18 = org.jfree.chart.text.TextAnchor.TOP_CENTER;
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition19 = new org.jfree.chart.labels.ItemLabelPosition(itemLabelAnchor17, textAnchor18);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.axis.NumberTick numberTick21 = new org.jfree.chart.axis.NumberTick(number0, "31-December-1969", textAnchor9, textAnchor18, 0.5d);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(tickType2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textAnchor9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textAnchor14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelAnchor17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textAnchor18);

  }

  @Test
  public void test377() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test377"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    boolean b11 = combinedDomainXYPlot5.isRangeZoomable();
    combinedDomainXYPlot5.configureRangeAxes();
    boolean b13 = combinedDomainXYPlot5.isRangeCrosshairLockedOnData();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == true);

  }

  @Test
  public void test378() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test378"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    boolean b31 = legendItem30.isShapeOutlineVisible();
    boolean b33 = legendItem30.equals((java.lang.Object)(short)1);
    java.awt.Paint paint34 = legendItem30.getFillPaint();
    legendItem30.setShapeVisible(true);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer38 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator39 = xYAreaRenderer38.getLegendItemToolTipGenerator();
    boolean b42 = xYAreaRenderer38.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition46 = xYAreaRenderer38.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b48 = xYAreaRenderer38.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator49 = null;
    xYAreaRenderer38.setBaseToolTipGenerator(xYToolTipGenerator49, true);
    java.awt.Shape shape53 = xYAreaRenderer38.lookupLegendShape(3);
    legendItem30.setLine(shape53);
    org.jfree.chart.util.ObjectList objectList55 = new org.jfree.chart.util.ObjectList();
    java.lang.Object obj56 = objectList55.clone();
    org.jfree.chart.axis.CategoryAxis categoryAxis57 = new org.jfree.chart.axis.CategoryAxis();
    int i58 = objectList55.indexOf((java.lang.Object)categoryAxis57);
    boolean b59 = legendItem30.equals((java.lang.Object)objectList55);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer60 = legendItem30.getFillPaintTransformer();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b42 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i58 == (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b59 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(gradientPaintTransformer60);

  }

  @Test
  public void test379() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test379"); }


    org.jfree.chart.plot.XYCrosshairState xYCrosshairState0 = new org.jfree.chart.plot.XYCrosshairState();
    xYCrosshairState0.updateCrosshairX(6.0d);
    xYCrosshairState0.updateCrosshairY(Double.NaN);

  }

  @Test
  public void test380() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test380"); }


    int i1 = org.jfree.data.time.SerialDate.monthCodeToQuarter(4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == 2);

  }

  @Test
  public void test381() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test381"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    piePlot3D2.setLabelLinksVisible(false);
    java.lang.Object obj6 = piePlot3D2.clone();
    piePlot3D2.setAutoPopulateSectionOutlinePaint(false);
    boolean b9 = piePlot3D2.getSimpleLabels();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);

  }

  @Test
  public void test382() {}
// Defects4J: flaky method
//   @Test
//   public void test382() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test382"); }
// 
// 
//     org.jfree.data.time.Month month0 = new org.jfree.data.time.Month();
//     int i1 = month0.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem3 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month0, 11.0d);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod4 = month0.previous();
//     long long5 = month0.getLastMillisecond();
//     org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer6 = new org.jfree.chart.renderer.xy.XYStepRenderer();
//     xYStepRenderer6.setSeriesShapesFilled(15, false);
//     boolean b12 = xYStepRenderer6.getItemLineVisible(1, 8);
//     org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator13 = xYStepRenderer6.getBaseToolTipGenerator();
//     int i14 = month0.compareTo((java.lang.Object)xYToolTipGenerator13);
//     java.lang.String str15 = month0.toString();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i1 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 1456819199999L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b12 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(xYToolTipGenerator13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i14 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str15 + "' != '" + "February 2016"+ "'", str15.equals("February 2016"));
// 
//   }

  @Test
  public void test383() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test383"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier2 = xYAreaRenderer1.getDrawingSupplier();
    java.awt.Stroke stroke3 = xYAreaRenderer1.getBaseStroke();
    java.io.ObjectOutputStream objectOutputStream4 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.util.SerialUtilities.writeStroke(stroke3, objectOutputStream4);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke3);

  }

  @Test
  public void test384() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test384"); }


    org.jfree.data.time.TimeSeries timeSeries3 = new org.jfree.data.time.TimeSeries((java.lang.Comparable)"hi!", "AxisLocation.TOP_OR_RIGHT", "SeriesRenderingOrder.FORWARD");
    java.util.Collection collection4 = timeSeries3.getTimePeriods();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem6 = timeSeries3.getDataItem(500);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(collection4);

  }

  @Test
  public void test385() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test385"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    org.jfree.chart.plot.CategoryPlot categoryPlot11 = new org.jfree.chart.plot.CategoryPlot();
    boolean b12 = categoryPlot11.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge14 = categoryPlot11.getDomainAxisEdge(8);
    legendTitle10.setPosition(rectangleEdge14);
    org.jfree.chart.util.RectangleAnchor rectangleAnchor16 = legendTitle10.getLegendItemGraphicLocation();
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer18 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    boolean b19 = xYBarRenderer18.getUseYInterval();
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer22 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d23 = xYBarRenderer22.getMargin();
    boolean b24 = xYBarRenderer22.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator26 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer22.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator26, true);
    java.text.NumberFormat numberFormat29 = standardXYToolTipGenerator26.getYFormat();
    java.text.DateFormat dateFormat30 = standardXYToolTipGenerator26.getYDateFormat();
    java.text.NumberFormat numberFormat31 = standardXYToolTipGenerator26.getYFormat();
    xYBarRenderer18.setSeriesToolTipGenerator(5, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator26);
    boolean b33 = rectangleAnchor16.equals((java.lang.Object)5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleAnchor16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d23 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(dateFormat30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);

  }

  @Test
  public void test386() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test386"); }


    boolean b0 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARKS_VISIBLE;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b0 == true);

  }

  @Test
  public void test387() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test387"); }


    java.awt.Font font1 = null;
    java.awt.Shape shape9 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color13 = java.awt.Color.green;
    java.awt.Color color19 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke20 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color21 = java.awt.Color.orange;
    java.awt.Stroke stroke22 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker24 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color19, stroke20, (java.awt.Paint)color21, stroke22, 0.0f);
    java.awt.Shape shape28 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke29 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color30 = java.awt.Color.green;
    java.lang.String str31 = org.jfree.chart.util.PaintUtilities.colorToString(color30);
    org.jfree.chart.LegendItem legendItem32 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape9, true, (java.awt.Paint)color11, false, (java.awt.Paint)color13, stroke20, true, shape28, stroke29, (java.awt.Paint)color30);
    boolean b33 = legendItem32.isShapeOutlineVisible();
    boolean b35 = legendItem32.equals((java.lang.Object)(short)1);
    java.awt.Paint paint36 = legendItem32.getFillPaint();
    legendItem32.setShapeVisible(true);
    java.awt.Color color39 = org.jfree.chart.ChartColor.LIGHT_RED;
    boolean b40 = legendItem32.equals((java.lang.Object)color39);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.text.TextBlock textBlock41 = org.jfree.chart.text.TextUtilities.createTextBlock("pink", font1, (java.awt.Paint)color39);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str31 + "' != '" + "green"+ "'", str31.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == false);

  }

  @Test
  public void test388() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test388"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    boolean b3 = xYBarRenderer1.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator5 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer1.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator5, true);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator9 = null;
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator11 = new org.jfree.chart.urls.StandardXYURLGenerator("");
    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer12 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(100, xYToolTipGenerator9, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator11);
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer13 = new org.jfree.chart.renderer.xy.XYStepRenderer((org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator5, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator11);
    boolean b14 = xYStepRenderer13.getBaseLinesVisible();
    java.awt.Stroke stroke16 = xYStepRenderer13.getSeriesOutlineStroke(5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(stroke16);

  }

  @Test
  public void test389() {}
// Defects4J: flaky method
//   @Test
//   public void test389() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test389"); }
// 
// 
//     org.jfree.chart.axis.NumberAxis3D numberAxis3D0 = new org.jfree.chart.axis.NumberAxis3D();
//     java.awt.Paint paint1 = org.jfree.chart.axis.Axis.DEFAULT_AXIS_LINE_PAINT;
//     numberAxis3D0.setLabelPaint(paint1);
//     java.text.NumberFormat numberFormat3 = numberAxis3D0.getNumberFormatOverride();
//     numberAxis3D0.setFixedAutoRange(10.0d);
//     org.jfree.data.time.DateRange dateRange9 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     org.jfree.data.time.DateRange dateRange12 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     boolean b13 = dateRange9.intersects((org.jfree.data.Range)dateRange12);
//     java.lang.String str14 = dateRange9.toString();
//     org.jfree.chart.block.RectangleConstraint rectangleConstraint15 = new org.jfree.chart.block.RectangleConstraint(0.0d, (org.jfree.data.Range)dateRange9);
//     org.jfree.data.time.DateRange dateRange16 = new org.jfree.data.time.DateRange((org.jfree.data.Range)dateRange9);
//     numberAxis3D0.setRange((org.jfree.data.Range)dateRange9);
//     numberAxis3D0.setLabelToolTip("UnitType.ABSOLUTE");
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(paint1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(numberFormat3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b13 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str14 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str14.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
// 
//   }

  @Test
  public void test390() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test390"); }


    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot0 = new org.jfree.chart.plot.MultiplePiePlot();
    java.awt.Paint paint1 = multiplePiePlot0.getOutlinePaint();
    java.awt.Shape shape2 = multiplePiePlot0.getLegendItemShape();
    org.jfree.chart.util.TableOrder tableOrder3 = null;
    // The following exception was thrown during execution in test generation
    try {
      multiplePiePlot0.setDataExtractOrder(tableOrder3);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape2);

  }

  @Test
  public void test391() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test391"); }


    org.jfree.chart.text.TextAnchor textAnchor0 = org.jfree.chart.text.TextAnchor.BASELINE_RIGHT;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textAnchor0);

  }

  @Test
  public void test392() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test392"); }


    boolean b0 = org.jfree.chart.plot.WaferMapPlot.DEFAULT_CROSSHAIR_VISIBLE;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b0 == false);

  }

  @Test
  public void test393() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test393"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedRangeXYPlot combinedRangeXYPlot1 = new org.jfree.chart.plot.CombinedRangeXYPlot(valueAxis0);
    java.lang.String str2 = combinedRangeXYPlot1.getPlotType();
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo5 = null;
    // The following exception was thrown during execution in test generation
    try {
      combinedRangeXYPlot1.handleClick(128, 15, plotRenderingInfo5);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str2 + "' != '" + "Combined Range XYPlot"+ "'", str2.equals("Combined Range XYPlot"));

  }

  @Test
  public void test394() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test394"); }


    org.jfree.chart.axis.AxisLocation axisLocation0 = org.jfree.chart.axis.AxisLocation.TOP_OR_RIGHT;
    org.jfree.chart.axis.AxisLocation axisLocation1 = axisLocation0.getOpposite();
    org.jfree.chart.axis.CategoryAxis categoryAxis2 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset3 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot4 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset3);
    org.jfree.chart.axis.ValueAxis valueAxis5 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot6 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis5);
    java.util.List list7 = combinedDomainXYPlot6.getAnnotations();
    waferMapPlot4.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot6);
    int i9 = combinedDomainXYPlot6.getSeriesCount();
    categoryAxis2.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot6);
    boolean b12 = categoryAxis2.equals((java.lang.Object)(short)1);
    java.awt.Paint paint13 = categoryAxis2.getTickMarkPaint();
    java.lang.Object obj14 = org.jfree.chart.util.ObjectUtilities.clone((java.lang.Object)categoryAxis2);
    org.jfree.chart.axis.NumberAxis3D numberAxis3D16 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Color color17 = org.jfree.chart.ChartColor.VERY_LIGHT_GREEN;
    numberAxis3D16.setTickMarkPaint((java.awt.Paint)color17);
    categoryAxis2.setTickLabelPaint((java.lang.Comparable)8, (java.awt.Paint)color17);
    categoryAxis2.configure();
    categoryAxis2.setTickMarkOutsideLength(0.5f);
    categoryAxis2.setUpperMargin(0.0d);
    boolean b25 = axisLocation0.equals((java.lang.Object)0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i9 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);

  }

  @Test
  public void test395() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test395"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    java.util.List list2 = combinedDomainXYPlot1.getAnnotations();
    combinedDomainXYPlot1.setRangeGridlinesVisible(true);
    org.jfree.chart.axis.AxisSpace axisSpace5 = null;
    combinedDomainXYPlot1.setFixedRangeAxisSpace(axisSpace5);
    combinedDomainXYPlot1.setRangeCrosshairLockedOnData(true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list2);

  }

  @Test
  public void test396() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test396"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = xYStepRenderer0.getSeriesPositiveItemLabelPosition(3);
    java.lang.Boolean b4 = xYStepRenderer0.getSeriesLinesVisible(0);
    java.text.DateFormat dateFormat7 = null;
    java.text.DateFormat dateFormat8 = null;
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator9 = new org.jfree.chart.labels.StandardXYToolTipGenerator("31-December-1969", dateFormat7, dateFormat8);
    xYStepRenderer0.setSeriesToolTipGenerator(0, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator9, false);
    org.jfree.data.xy.XYSeries xYSeries12 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection13 = new org.jfree.data.xy.XYSeriesCollection(xYSeries12);
    double d15 = xYSeriesCollection13.getDomainUpperBound(false);
    org.jfree.data.general.DatasetChangeEvent datasetChangeEvent16 = new org.jfree.data.general.DatasetChangeEvent((java.lang.Object)0, (org.jfree.data.general.Dataset)xYSeriesCollection13);
    // The following exception was thrown during execution in test generation
    try {
      double d19 = xYSeriesCollection13.getEndYValue(12, 500);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d15, Double.NaN, 0);

  }

  @Test
  public void test397() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test397"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = xYStepRenderer0.getSeriesPositiveItemLabelPosition(3);
    java.util.Collection collection3 = xYStepRenderer0.getAnnotations();
    boolean b4 = xYStepRenderer0.getBaseShapesFilled();
    org.jfree.chart.labels.XYItemLabelGenerator xYItemLabelGenerator6 = null;
    xYStepRenderer0.setSeriesItemLabelGenerator(255, xYItemLabelGenerator6);
    java.awt.Font font9 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset10 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot11 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset10);
    org.jfree.chart.axis.ValueAxis valueAxis12 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot13 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis12);
    java.util.List list14 = combinedDomainXYPlot13.getAnnotations();
    waferMapPlot11.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot13);
    boolean b16 = combinedDomainXYPlot13.isNotify();
    org.jfree.chart.JFreeChart jFreeChart18 = new org.jfree.chart.JFreeChart("", font9, (org.jfree.chart.plot.Plot)combinedDomainXYPlot13, true);
    combinedDomainXYPlot13.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer21 = null;
    combinedDomainXYPlot13.setRenderer(xYItemRenderer21);
    boolean b23 = combinedDomainXYPlot13.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries24 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection25 = new org.jfree.data.time.TimeSeriesCollection(timeSeries24);
    combinedDomainXYPlot13.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection25);
    java.util.List list27 = timeSeriesCollection25.getSeries();
    org.jfree.data.Range range28 = org.jfree.data.general.DatasetUtilities.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection25);
    org.jfree.data.DomainOrder domainOrder29 = timeSeriesCollection25.getDomainOrder();
    org.jfree.data.Range range30 = xYStepRenderer0.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection25);
    java.awt.Color color31 = org.jfree.chart.ChartColor.VERY_DARK_GREEN;
    boolean b32 = xYStepRenderer0.equals((java.lang.Object)color31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(collection3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == false);

  }

  @Test
  public void test398() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test398"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    boolean b3 = xYBarRenderer1.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator5 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer1.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator5, true);
    java.lang.Object obj8 = standardXYToolTipGenerator5.clone();
    java.text.DateFormat dateFormat9 = standardXYToolTipGenerator5.getXDateFormat();
    java.text.DateFormat dateFormat10 = standardXYToolTipGenerator5.getYDateFormat();
    java.lang.String str11 = standardXYToolTipGenerator5.getNullYString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateFormat9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(dateFormat10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str11 + "' != '" + "null"+ "'", str11.equals("null"));

  }

  @Test
  public void test399() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test399"); }


    org.jfree.chart.axis.NumberAxis numberAxis0 = new org.jfree.chart.axis.NumberAxis();
    numberAxis0.resizeRange2(10.0d, 11.0d);
    org.jfree.chart.util.RectangleInsets rectangleInsets4 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d5 = rectangleInsets4.getLeft();
    numberAxis0.setTickLabelInsets(rectangleInsets4);
    org.jfree.data.Range range7 = numberAxis0.getRange();
    numberAxis0.resizeRange(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis10 = new org.jfree.chart.axis.NumberAxis();
    numberAxis10.resizeRange2(10.0d, 11.0d);
    org.jfree.chart.util.RectangleInsets rectangleInsets14 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d15 = rectangleInsets14.getLeft();
    numberAxis10.setTickLabelInsets(rectangleInsets14);
    org.jfree.data.Range range17 = numberAxis10.getRange();
    org.jfree.chart.axis.NumberAxis numberAxis18 = new org.jfree.chart.axis.NumberAxis();
    numberAxis18.resizeRange2(10.0d, 11.0d);
    org.jfree.chart.util.RectangleInsets rectangleInsets22 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d23 = rectangleInsets22.getLeft();
    numberAxis18.setTickLabelInsets(rectangleInsets22);
    org.jfree.data.Range range25 = numberAxis18.getRange();
    org.jfree.chart.block.RectangleConstraint rectangleConstraint26 = new org.jfree.chart.block.RectangleConstraint(range17, range25);
    numberAxis0.setRange(range17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d15 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d23 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range25);

  }

  @Test
  public void test400() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test400"); }


    org.jfree.chart.renderer.category.BarRenderer.setDefaultShadowsVisible(true);

  }

  @Test
  public void test401() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test401"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    org.jfree.chart.plot.CategoryPlot categoryPlot11 = new org.jfree.chart.plot.CategoryPlot();
    boolean b12 = categoryPlot11.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge14 = categoryPlot11.getDomainAxisEdge(8);
    legendTitle10.setPosition(rectangleEdge14);
    org.jfree.chart.util.RectangleAnchor rectangleAnchor16 = legendTitle10.getLegendItemGraphicLocation();
    java.awt.Graphics2D graphics2D17 = null;
    java.awt.Font font20 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset21 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot22 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset21);
    org.jfree.chart.axis.ValueAxis valueAxis23 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot24 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis23);
    java.util.List list25 = combinedDomainXYPlot24.getAnnotations();
    waferMapPlot22.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot24);
    boolean b27 = combinedDomainXYPlot24.isNotify();
    org.jfree.chart.JFreeChart jFreeChart29 = new org.jfree.chart.JFreeChart("", font20, (org.jfree.chart.plot.Plot)combinedDomainXYPlot24, true);
    org.jfree.chart.title.TextTitle textTitle30 = new org.jfree.chart.title.TextTitle("", font20);
    textTitle30.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame33 = textTitle30.getFrame();
    java.lang.String str34 = textTitle30.getID();
    java.awt.geom.Rectangle2D rectangle2D35 = textTitle30.getBounds();
    // The following exception was thrown during execution in test generation
    try {
      legendTitle10.draw(graphics2D17, rectangle2D35);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleAnchor16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D35);

  }

  @Test
  public void test402() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test402"); }


    org.jfree.data.Range range1 = null;
    org.jfree.chart.block.RectangleConstraint rectangleConstraint2 = new org.jfree.chart.block.RectangleConstraint(100.0d, range1);
    org.jfree.chart.block.LengthConstraintType lengthConstraintType3 = rectangleConstraint2.getWidthConstraintType();
    org.jfree.data.time.DateRange dateRange6 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange9 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b10 = dateRange6.intersects((org.jfree.data.Range)dateRange9);
    org.jfree.chart.block.RectangleConstraint rectangleConstraint11 = rectangleConstraint2.toRangeHeight((org.jfree.data.Range)dateRange9);
    org.jfree.chart.axis.ValueAxis valueAxis12 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot13 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis12);
    org.jfree.chart.plot.Plot plot14 = combinedDomainXYPlot13.getRootPlot();
    org.jfree.chart.axis.ValueAxis valueAxis15 = null;
    int i16 = combinedDomainXYPlot13.getRangeAxisIndex(valueAxis15);
    org.jfree.data.xy.XYSeries xYSeries18 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection19 = new org.jfree.data.xy.XYSeriesCollection(xYSeries18);
    boolean b20 = xYSeriesCollection19.isAutoWidth();
    org.jfree.data.Range range22 = xYSeriesCollection19.getRangeBounds(true);
    combinedDomainXYPlot13.setDataset(0, (org.jfree.data.xy.XYDataset)xYSeriesCollection19);
    boolean b24 = dateRange9.equals((java.lang.Object)0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleConstraint11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i16 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);

  }

  @Test
  public void test403() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test403"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    categoryPlot0.clearDomainMarkers();
    int i5 = categoryPlot0.getCrosshairDatasetIndex();
    int i6 = categoryPlot0.getBackgroundImageAlignment();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 15);

  }

  @Test
  public void test404() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test404"); }


    org.jfree.chart.axis.LogAxis logAxis1 = new org.jfree.chart.axis.LogAxis("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]");
    double d3 = logAxis1.calculateValue(5.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d3 == 100000.0d);

  }

  @Test
  public void test405() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test405"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    boolean b1 = xYStepRenderer0.getUseFillPaint();
    xYStepRenderer0.setDrawSeriesLineAsPath(false);
    java.awt.Paint paint7 = xYStepRenderer0.getItemFillPaint(2, 8, false);
    java.awt.Graphics2D graphics2D8 = null;
    java.awt.geom.Rectangle2D rectangle2D9 = null;
    org.jfree.chart.plot.XYPlot xYPlot10 = null;
    org.jfree.data.general.WaferMapDataset waferMapDataset11 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot12 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset11);
    org.jfree.chart.JFreeChart jFreeChart13 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent14 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot12, jFreeChart13);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment15 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment16 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement19 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment15, verticalAlignment16, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement20 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle21 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot12, (org.jfree.chart.block.Arrangement)flowArrangement19, (org.jfree.chart.block.Arrangement)borderArrangement20);
    org.jfree.data.time.TimeSeries timeSeries22 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection23 = new org.jfree.data.time.TimeSeriesCollection(timeSeries22);
    timeSeriesCollection23.validateObject();
    java.lang.Comparable comparable25 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer26 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement19, (org.jfree.data.general.Dataset)timeSeriesCollection23, comparable25);
    timeSeriesCollection23.validateObject();
    org.jfree.chart.axis.ValueAxis valueAxis28 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot29 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis28);
    org.jfree.chart.plot.PlotOrientation plotOrientation30 = combinedDomainXYPlot29.getOrientation();
    boolean b31 = combinedDomainXYPlot29.isDomainCrosshairLockedOnData();
    org.jfree.chart.entity.EntityCollection entityCollection33 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo34 = new org.jfree.chart.ChartRenderingInfo(entityCollection33);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo35 = chartRenderingInfo34.getPlotInfo();
    java.awt.geom.Point2D point2D36 = null;
    combinedDomainXYPlot29.panDomainAxes(4.5d, plotRenderingInfo35, point2D36);
    int i38 = plotRenderingInfo35.getSubplotCount();
    org.jfree.chart.entity.EntityCollection entityCollection39 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo40 = new org.jfree.chart.ChartRenderingInfo(entityCollection39);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo41 = chartRenderingInfo40.getPlotInfo();
    plotRenderingInfo35.addSubplotInfo(plotRenderingInfo41);
    org.jfree.chart.renderer.xy.XYItemRendererState xYItemRendererState43 = xYStepRenderer0.initialise(graphics2D8, rectangle2D9, xYPlot10, (org.jfree.data.xy.XYDataset)timeSeriesCollection23, plotRenderingInfo41);
    java.awt.geom.Line2D line2D44 = null;
    xYItemRendererState43.workingLine = line2D44;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i38 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(xYItemRendererState43);

  }

  @Test
  public void test406() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test406"); }


    org.jfree.chart.axis.SegmentedTimeline segmentedTimeline3 = new org.jfree.chart.axis.SegmentedTimeline(1L, 133, 7);
    boolean b4 = segmentedTimeline3.getAdjustForDaylightSaving();
    long long6 = segmentedTimeline3.toMillisecond(0L);
    org.jfree.chart.util.RectangleAnchor rectangleAnchor7 = org.jfree.chart.util.RectangleAnchor.LEFT;
    java.awt.Font font9 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset10 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot11 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset10);
    org.jfree.chart.axis.ValueAxis valueAxis12 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot13 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis12);
    java.util.List list14 = combinedDomainXYPlot13.getAnnotations();
    waferMapPlot11.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot13);
    boolean b16 = combinedDomainXYPlot13.isNotify();
    org.jfree.chart.JFreeChart jFreeChart18 = new org.jfree.chart.JFreeChart("", font9, (org.jfree.chart.plot.Plot)combinedDomainXYPlot13, true);
    combinedDomainXYPlot13.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer21 = null;
    combinedDomainXYPlot13.setRenderer(xYItemRenderer21);
    org.jfree.chart.axis.AxisSpace axisSpace23 = combinedDomainXYPlot13.getFixedRangeAxisSpace();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer25 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier26 = xYAreaRenderer25.getDrawingSupplier();
    java.awt.Stroke stroke27 = xYAreaRenderer25.getBaseStroke();
    combinedDomainXYPlot13.setDomainCrosshairStroke(stroke27);
    combinedDomainXYPlot13.setNotify(true);
    org.jfree.chart.plot.Marker marker32 = null;
    org.jfree.chart.util.Layer layer33 = null;
    boolean b34 = combinedDomainXYPlot13.removeDomainMarker(100, marker32, layer33);
    boolean b35 = rectangleAnchor7.equals((java.lang.Object)layer33);
    boolean b36 = segmentedTimeline3.equals((java.lang.Object)b35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long6 == 0L);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleAnchor7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(axisSpace23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b34 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);

  }

  @Test
  public void test407() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test407"); }


    org.jfree.chart.renderer.xy.GradientXYBarPainter gradientXYBarPainter3 = new org.jfree.chart.renderer.xy.GradientXYBarPainter(0.0d, 0.0d, 0.2d);
    java.awt.Graphics2D graphics2D4 = null;
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer6 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    java.lang.Object obj7 = xYBarRenderer6.clone();
    xYBarRenderer6.setShadowVisible(false);
    xYBarRenderer6.setBarAlignmentFactor(0.08d);
    org.jfree.data.xy.XYSeries xYSeries15 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection16 = new org.jfree.data.xy.XYSeriesCollection(xYSeries15);
    boolean b17 = xYSeriesCollection16.isAutoWidth();
    org.jfree.data.Range range19 = xYSeriesCollection16.getRangeBounds(true);
    xYSeriesCollection16.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis22 = new org.jfree.chart.axis.NumberAxis();
    numberAxis22.centerRange(100.0d);
    java.lang.Object obj25 = numberAxis22.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer26 = null;
    org.jfree.chart.plot.PolarPlot polarPlot27 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection16, (org.jfree.chart.axis.ValueAxis)numberAxis22, polarItemRenderer26);
    org.jfree.chart.plot.PlotOrientation plotOrientation28 = polarPlot27.getOrientation();
    boolean b29 = polarPlot27.isAngleLabelsVisible();
    int i30 = polarPlot27.getSeriesCount();
    java.awt.Font font35 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset36 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot37 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset36);
    org.jfree.chart.axis.ValueAxis valueAxis38 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot39 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis38);
    java.util.List list40 = combinedDomainXYPlot39.getAnnotations();
    waferMapPlot37.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot39);
    boolean b42 = combinedDomainXYPlot39.isNotify();
    org.jfree.chart.JFreeChart jFreeChart44 = new org.jfree.chart.JFreeChart("", font35, (org.jfree.chart.plot.Plot)combinedDomainXYPlot39, true);
    org.jfree.chart.title.TextTitle textTitle45 = new org.jfree.chart.title.TextTitle("", font35);
    textTitle45.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame48 = textTitle45.getFrame();
    java.lang.String str49 = textTitle45.getID();
    java.awt.geom.Rectangle2D rectangle2D50 = textTitle45.getBounds();
    java.awt.Point point51 = polarPlot27.translateValueThetaRadiusToJava2D(0.0d, 0.05d, rectangle2D50);
    org.jfree.chart.axis.ValueAxis valueAxis52 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot53 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis52);
    java.util.List list54 = combinedDomainXYPlot53.getAnnotations();
    combinedDomainXYPlot53.setRangeGridlinesVisible(true);
    org.jfree.chart.util.RectangleEdge rectangleEdge58 = combinedDomainXYPlot53.getRangeAxisEdge(4);
    // The following exception was thrown during execution in test generation
    try {
      gradientXYBarPainter3.paintBarShadow(graphics2D4, xYBarRenderer6, 14, 0, true, (java.awt.geom.RectangularShape)rectangle2D50, rectangleEdge58, true);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i30 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b42 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge58);

  }

  @Test
  public void test408() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test408"); }


    org.jfree.chart.plot.CrosshairState crosshairState0 = new org.jfree.chart.plot.CrosshairState();
    crosshairState0.updateCrosshairY((-1.0d), 14);
    crosshairState0.updateCrosshairY(1.0E-8d, 10);
    double d7 = crosshairState0.getAnchorY();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 0.0d);

  }

  @Test
  public void test409() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test409"); }


    org.jfree.chart.renderer.category.BarRenderer barRenderer0 = new org.jfree.chart.renderer.category.BarRenderer();
    boolean b1 = barRenderer0.getBaseSeriesVisible();
    barRenderer0.setBase(1.0d);
    java.awt.Graphics2D graphics2D4 = null;
    org.jfree.chart.plot.CategoryPlot categoryPlot5 = new org.jfree.chart.plot.CategoryPlot();
    boolean b6 = categoryPlot5.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge8 = categoryPlot5.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis10 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets11 = categoryAxis10.getLabelInsets();
    double d13 = rectangleInsets11.calculateLeftInset(4.0d);
    categoryPlot5.setInsets(rectangleInsets11, false);
    org.jfree.chart.util.Layer layer17 = null;
    java.util.Collection collection18 = categoryPlot5.getDomainMarkers(5, layer17);
    org.jfree.data.general.DatasetGroup datasetGroup19 = categoryPlot5.getDatasetGroup();
    org.jfree.chart.entity.EntityCollection entityCollection21 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo22 = new org.jfree.chart.ChartRenderingInfo(entityCollection21);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo23 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo22);
    java.awt.geom.Point2D point2D24 = null;
    categoryPlot5.zoomDomainAxes(12.0d, plotRenderingInfo23, point2D24, true);
    int i27 = categoryPlot5.getRangeAxisCount();
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D29 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke30 = categoryAxis3D29.getTickMarkStroke();
    java.awt.Stroke stroke31 = org.jfree.chart.plot.CategoryPlot.DEFAULT_CROSSHAIR_STROKE;
    categoryAxis3D29.setAxisLineStroke(stroke31);
    categoryAxis3D29.clearCategoryLabelToolTips();
    org.jfree.chart.plot.CategoryMarker categoryMarker34 = null;
    org.jfree.chart.axis.LogAxis logAxis36 = new org.jfree.chart.axis.LogAxis("ClassContext");
    org.jfree.data.xy.XYSeries xYSeries38 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection39 = new org.jfree.data.xy.XYSeriesCollection(xYSeries38);
    boolean b40 = xYSeriesCollection39.isAutoWidth();
    org.jfree.data.Range range42 = xYSeriesCollection39.getRangeBounds(true);
    xYSeriesCollection39.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis45 = new org.jfree.chart.axis.NumberAxis();
    numberAxis45.centerRange(100.0d);
    java.lang.Object obj48 = numberAxis45.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer49 = null;
    org.jfree.chart.plot.PolarPlot polarPlot50 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection39, (org.jfree.chart.axis.ValueAxis)numberAxis45, polarItemRenderer49);
    org.jfree.chart.plot.PlotOrientation plotOrientation51 = polarPlot50.getOrientation();
    boolean b52 = polarPlot50.isAngleLabelsVisible();
    int i53 = polarPlot50.getSeriesCount();
    java.awt.Font font58 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset59 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot60 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset59);
    org.jfree.chart.axis.ValueAxis valueAxis61 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot62 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis61);
    java.util.List list63 = combinedDomainXYPlot62.getAnnotations();
    waferMapPlot60.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot62);
    boolean b65 = combinedDomainXYPlot62.isNotify();
    org.jfree.chart.JFreeChart jFreeChart67 = new org.jfree.chart.JFreeChart("", font58, (org.jfree.chart.plot.Plot)combinedDomainXYPlot62, true);
    org.jfree.chart.title.TextTitle textTitle68 = new org.jfree.chart.title.TextTitle("", font58);
    textTitle68.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame71 = textTitle68.getFrame();
    java.lang.String str72 = textTitle68.getID();
    java.awt.geom.Rectangle2D rectangle2D73 = textTitle68.getBounds();
    java.awt.Point point74 = polarPlot50.translateValueThetaRadiusToJava2D(0.0d, 0.05d, rectangle2D73);
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D76 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke77 = categoryAxis3D76.getTickMarkStroke();
    java.awt.Graphics2D graphics2D78 = null;
    java.awt.geom.Rectangle2D rectangle2D80 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge81 = org.jfree.chart.util.RectangleEdge.LEFT;
    org.jfree.chart.axis.AxisState axisState83 = new org.jfree.chart.axis.AxisState(1.0d);
    double d84 = axisState83.getCursor();
    axisState83.cursorLeft(0.2d);
    categoryAxis3D76.drawTickMarks(graphics2D78, 7.0d, rectangle2D80, rectangleEdge81, axisState83);
    boolean b88 = org.jfree.chart.util.RectangleEdge.isTopOrBottom(rectangleEdge81);
    double d89 = logAxis36.java2DToValue(2.0d, rectangle2D73, rectangleEdge81);
    // The following exception was thrown during execution in test generation
    try {
      barRenderer0.drawDomainMarker(graphics2D4, categoryPlot5, (org.jfree.chart.axis.CategoryAxis)categoryAxis3D29, categoryMarker34, rectangle2D73);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d13 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(datasetGroup19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i27 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b52 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i53 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b65 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D73);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point74);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge81);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d84 == 1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d89, Double.NaN, 0);

  }

  @Test
  public void test410() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test410"); }


    java.awt.Color color5 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke6 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color7 = java.awt.Color.orange;
    java.awt.Stroke stroke8 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker10 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color5, stroke6, (java.awt.Paint)color7, stroke8, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer11 = null;
    intervalMarker10.setGradientPaintTransformer(gradientPaintTransformer11);
    org.jfree.chart.util.RectangleInsets rectangleInsets13 = intervalMarker10.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis15 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets16 = categoryAxis15.getLabelInsets();
    intervalMarker10.setLabelOffset(rectangleInsets16);
    intervalMarker10.setLabel("March");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets16);

  }

  @Test
  public void test411() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test411"); }


    java.awt.Paint[] paint_array0 = null;
    org.jfree.chart.axis.ValueAxis valueAxis1 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot2 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis1);
    java.util.List list3 = combinedDomainXYPlot2.getAnnotations();
    combinedDomainXYPlot2.setRangeGridlinesVisible(true);
    java.awt.Color color6 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    combinedDomainXYPlot2.setRangeTickBandPaint((java.awt.Paint)color6);
    java.awt.Paint[] paint_array8 = new java.awt.Paint[] { color6 };
    java.awt.Shape shape16 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color18 = java.awt.Color.green;
    java.awt.Color color20 = java.awt.Color.green;
    java.awt.Color color26 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color28 = java.awt.Color.orange;
    java.awt.Stroke stroke29 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker31 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color26, stroke27, (java.awt.Paint)color28, stroke29, 0.0f);
    java.awt.Shape shape35 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke36 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color37 = java.awt.Color.green;
    java.lang.String str38 = org.jfree.chart.util.PaintUtilities.colorToString(color37);
    org.jfree.chart.LegendItem legendItem39 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape16, true, (java.awt.Paint)color18, false, (java.awt.Paint)color20, stroke27, true, shape35, stroke36, (java.awt.Paint)color37);
    java.awt.Paint[] paint_array40 = new java.awt.Paint[] { color18 };
    java.awt.Stroke[] stroke_array41 = null;
    java.awt.Stroke stroke42 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Stroke[] stroke_array43 = new java.awt.Stroke[] { stroke42 };
    java.awt.Shape shape46 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Shape[] shape_array47 = new java.awt.Shape[] { shape46 };
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier48 = new org.jfree.chart.plot.DefaultDrawingSupplier(paint_array0, paint_array8, paint_array40, stroke_array41, stroke_array43, shape_array47);
    java.awt.Paint paint49 = defaultDrawingSupplier48.getNextOutlinePaint();
    java.lang.Object obj50 = defaultDrawingSupplier48.clone();
    // The following exception was thrown during execution in test generation
    try {
      java.awt.Paint paint51 = defaultDrawingSupplier48.getNextPaint();
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str38 + "' != '" + "green"+ "'", str38.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint_array40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape_array47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj50);

  }

  @Test
  public void test412() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test412"); }


    java.awt.Color color0 = java.awt.Color.yellow;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color0);

  }

  @Test
  public void test413() {}
// Defects4J: flaky method
//   @Test
//   public void test413() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test413"); }
// 
// 
//     org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
//     org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = xYStepRenderer0.getSeriesPositiveItemLabelPosition(3);
//     java.util.Collection collection3 = xYStepRenderer0.getAnnotations();
//     java.awt.Font font5 = xYStepRenderer0.lookupLegendTextFont(255);
//     xYStepRenderer0.setSeriesItemLabelsVisible(0, (java.lang.Boolean)true, false);
//     java.awt.Graphics2D graphics2D10 = null;
//     org.jfree.chart.renderer.xy.GradientXYBarPainter gradientXYBarPainter14 = new org.jfree.chart.renderer.xy.GradientXYBarPainter(0.0d, 0.0d, 0.2d);
//     org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer15 = new org.jfree.chart.renderer.xy.XYStepRenderer();
//     boolean b16 = xYStepRenderer15.getUseFillPaint();
//     xYStepRenderer15.setDrawSeriesLineAsPath(false);
//     java.awt.Paint paint22 = xYStepRenderer15.getItemFillPaint(2, 8, false);
//     java.awt.Graphics2D graphics2D23 = null;
//     java.awt.geom.Rectangle2D rectangle2D24 = null;
//     org.jfree.chart.plot.XYPlot xYPlot25 = null;
//     org.jfree.data.general.WaferMapDataset waferMapDataset26 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot27 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset26);
//     org.jfree.chart.JFreeChart jFreeChart28 = null;
//     org.jfree.chart.event.ChartChangeEvent chartChangeEvent29 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot27, jFreeChart28);
//     org.jfree.chart.util.HorizontalAlignment horizontalAlignment30 = org.jfree.chart.util.HorizontalAlignment.LEFT;
//     org.jfree.chart.util.VerticalAlignment verticalAlignment31 = null;
//     org.jfree.chart.block.FlowArrangement flowArrangement34 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment30, verticalAlignment31, 11.0d, 0.2d);
//     org.jfree.chart.block.BorderArrangement borderArrangement35 = new org.jfree.chart.block.BorderArrangement();
//     org.jfree.chart.title.LegendTitle legendTitle36 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot27, (org.jfree.chart.block.Arrangement)flowArrangement34, (org.jfree.chart.block.Arrangement)borderArrangement35);
//     org.jfree.data.time.TimeSeries timeSeries37 = null;
//     org.jfree.data.time.TimeSeriesCollection timeSeriesCollection38 = new org.jfree.data.time.TimeSeriesCollection(timeSeries37);
//     timeSeriesCollection38.validateObject();
//     java.lang.Comparable comparable40 = null;
//     org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer41 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement34, (org.jfree.data.general.Dataset)timeSeriesCollection38, comparable40);
//     timeSeriesCollection38.validateObject();
//     org.jfree.chart.axis.ValueAxis valueAxis43 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot44 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis43);
//     org.jfree.chart.plot.PlotOrientation plotOrientation45 = combinedDomainXYPlot44.getOrientation();
//     boolean b46 = combinedDomainXYPlot44.isDomainCrosshairLockedOnData();
//     org.jfree.chart.entity.EntityCollection entityCollection48 = null;
//     org.jfree.chart.ChartRenderingInfo chartRenderingInfo49 = new org.jfree.chart.ChartRenderingInfo(entityCollection48);
//     org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo50 = chartRenderingInfo49.getPlotInfo();
//     java.awt.geom.Point2D point2D51 = null;
//     combinedDomainXYPlot44.panDomainAxes(4.5d, plotRenderingInfo50, point2D51);
//     int i53 = plotRenderingInfo50.getSubplotCount();
//     org.jfree.chart.entity.EntityCollection entityCollection54 = null;
//     org.jfree.chart.ChartRenderingInfo chartRenderingInfo55 = new org.jfree.chart.ChartRenderingInfo(entityCollection54);
//     org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo56 = chartRenderingInfo55.getPlotInfo();
//     plotRenderingInfo50.addSubplotInfo(plotRenderingInfo56);
//     org.jfree.chart.renderer.xy.XYItemRendererState xYItemRendererState58 = xYStepRenderer15.initialise(graphics2D23, rectangle2D24, xYPlot25, (org.jfree.data.xy.XYDataset)timeSeriesCollection38, plotRenderingInfo56);
//     boolean b59 = gradientXYBarPainter14.equals((java.lang.Object)xYItemRendererState58);
//     java.awt.geom.Rectangle2D rectangle2D60 = null;
//     org.jfree.chart.axis.ValueAxis valueAxis61 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot62 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis61);
//     java.util.List list63 = combinedDomainXYPlot62.getAnnotations();
//     combinedDomainXYPlot62.setRangeGridlinesVisible(true);
//     org.jfree.chart.plot.PlotOrientation plotOrientation66 = combinedDomainXYPlot62.getOrientation();
//     boolean b67 = combinedDomainXYPlot62.isDomainPannable();
//     org.jfree.chart.axis.NumberAxis numberAxis68 = new org.jfree.chart.axis.NumberAxis();
//     numberAxis68.resizeRange2(10.0d, 11.0d);
//     org.jfree.chart.util.RectangleInsets rectangleInsets72 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
//     double d73 = rectangleInsets72.getLeft();
//     numberAxis68.setTickLabelInsets(rectangleInsets72);
//     double d75 = numberAxis68.getUpperMargin();
//     org.jfree.data.time.Month month77 = new org.jfree.data.time.Month();
//     int i78 = month77.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem80 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month77, (java.lang.Number)8);
//     long long81 = month77.getFirstMillisecond();
//     org.jfree.data.time.Month month82 = new org.jfree.data.time.Month();
//     int i83 = month82.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis84 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month77, (org.jfree.data.time.RegularTimePeriod)month82);
//     float f85 = periodAxis84.getMinorTickMarkInsideLength();
//     org.jfree.data.xy.XYDataset xYDataset86 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       xYStepRenderer0.drawItem(graphics2D10, xYItemRendererState58, rectangle2D60, (org.jfree.chart.plot.XYPlot)combinedDomainXYPlot62, (org.jfree.chart.axis.ValueAxis)numberAxis68, (org.jfree.chart.axis.ValueAxis)periodAxis84, xYDataset86, 0, 255, true, 8);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(itemLabelPosition2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(collection3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(font5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b16 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(paint22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(horizontalAlignment30);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(plotOrientation45);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b46 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(plotRenderingInfo50);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i53 == 0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(plotRenderingInfo56);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(xYItemRendererState58);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b59 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list63);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(plotOrientation66);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b67 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets72);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d73 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d75 == 0.05d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i78 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long81 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i83 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f85 == 0.0f);
// 
//   }

  @Test
  public void test414() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test414"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    java.awt.Stroke stroke11 = jFreeChart10.getBorderStroke();
    boolean b12 = jFreeChart10.isBorderVisible();
    java.lang.Object obj13 = jFreeChart10.clone();
    org.jfree.chart.entity.EntityCollection entityCollection16 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo17 = new org.jfree.chart.ChartRenderingInfo(entityCollection16);
    jFreeChart10.handleClick(15, 8, chartRenderingInfo17);
    java.awt.RenderingHints renderingHints19 = null;
    // The following exception was thrown during execution in test generation
    try {
      jFreeChart10.setRenderingHints(renderingHints19);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj13);

  }

  @Test
  public void test415() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test415"); }


    org.jfree.data.time.TimeSeries timeSeries3 = new org.jfree.data.time.TimeSeries((java.lang.Comparable)"hi!", "AxisLocation.TOP_OR_RIGHT", "SeriesRenderingOrder.FORWARD");
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem5 = timeSeries3.getDataItem(8);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test416() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test416"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.axis.ValueAxis valueAxis2 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot3 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis2);
    java.util.List list4 = combinedDomainXYPlot3.getAnnotations();
    waferMapPlot1.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot3);
    int i6 = combinedDomainXYPlot3.getSeriesCount();
    boolean b8 = combinedDomainXYPlot3.equals((java.lang.Object)10.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer10 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    xYAreaRenderer10.setSeriesCreateEntities(15, (java.lang.Boolean)true, true);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition16 = xYAreaRenderer10.getSeriesPositiveItemLabelPosition(3);
    boolean b17 = combinedDomainXYPlot3.equals((java.lang.Object)3);
    combinedDomainXYPlot3.configureRangeAxes();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);

  }

  @Test
  public void test417() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test417"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    piePlot3D2.setStartAngle(Double.NaN);
    org.jfree.data.general.DefaultPieDataset defaultPieDataset5 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj6 = defaultPieDataset5.clone();
    double d7 = org.jfree.data.general.DatasetUtilities.calculatePieDatasetTotal((org.jfree.data.general.PieDataset)defaultPieDataset5);
    piePlot3D2.setDataset((org.jfree.data.general.PieDataset)defaultPieDataset5);
    double d9 = piePlot3D2.getInteriorGap();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d9 == 0.08d);

  }

  @Test
  public void test418() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test418"); }


    org.jfree.data.xy.XYSeries xYSeries3 = new org.jfree.data.xy.XYSeries((java.lang.Comparable)10.0d, false, false);
    xYSeries3.add((-1.0d), (java.lang.Number)(byte)(-1));
    double d7 = xYSeries3.getMaxX();
    java.lang.String str8 = xYSeries3.getDescription();
    org.jfree.data.xy.XYDataItem xYDataItem11 = new org.jfree.data.xy.XYDataItem(4.5d, 0.05d);
    xYSeries3.add(xYDataItem11);
    // The following exception was thrown during execution in test generation
    try {
      xYSeries3.add((java.lang.Number)(-1.0d), (java.lang.Number)(-435), false);
      org.junit.Assert.fail("Expected exception of type org.jfree.data.general.SeriesException");
    } catch (org.jfree.data.general.SeriesException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.jfree.data.general.SeriesException")) {
        org.junit.Assert.fail("Expected exception of type org.jfree.data.general.SeriesException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == (-1.0d));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str8);

  }

  @Test
  public void test419() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test419"); }


    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.ChartColor chartColor3 = new org.jfree.chart.ChartColor((-25560), 3, 12);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test420() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test420"); }


    org.jfree.data.time.DateRange dateRange2 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    double d3 = dateRange2.getLength();
    long long4 = dateRange2.getLowerMillis();
    java.util.Date date5 = dateRange2.getLowerDate();
    java.util.Date date6 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.DateRange dateRange7 = new org.jfree.data.time.DateRange(date5, date6);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d3 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long4 == (-1L));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(date5);

  }

  @Test
  public void test421() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test421"); }


    java.awt.Font font2 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset3 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot4 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset3);
    org.jfree.chart.axis.ValueAxis valueAxis5 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot6 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis5);
    java.util.List list7 = combinedDomainXYPlot6.getAnnotations();
    waferMapPlot4.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot6);
    boolean b9 = combinedDomainXYPlot6.isNotify();
    org.jfree.chart.JFreeChart jFreeChart11 = new org.jfree.chart.JFreeChart("", font2, (org.jfree.chart.plot.Plot)combinedDomainXYPlot6, true);
    org.jfree.chart.title.TextTitle textTitle12 = new org.jfree.chart.title.TextTitle("", font2);
    boolean b13 = textTitle12.getExpandToFitSpace();
    boolean b14 = textTitle12.visible;
    java.awt.Graphics2D graphics2D15 = null;
    org.jfree.chart.block.RectangleConstraint rectangleConstraint18 = new org.jfree.chart.block.RectangleConstraint((-1.0d), 3.0d);
    org.jfree.data.Range range19 = rectangleConstraint18.getWidthRange();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.util.Size2D size2D20 = textTitle12.arrange(graphics2D15, rectangleConstraint18);
      org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException");
    } catch (java.lang.RuntimeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.RuntimeException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range19);

  }

  @Test
  public void test422() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test422"); }


    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator1 = null;
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator3 = new org.jfree.chart.urls.StandardXYURLGenerator("");
    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer4 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(100, xYToolTipGenerator1, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator3);
    xYStepAreaRenderer4.setPlotArea(true);
    java.lang.Object obj7 = null;
    boolean b8 = xYStepAreaRenderer4.equals(obj7);
    boolean b9 = xYStepAreaRenderer4.getBaseItemLabelsVisible();
    boolean b10 = xYStepAreaRenderer4.isOutline();
    xYStepAreaRenderer4.setPlotArea(false);
    org.jfree.chart.plot.CategoryPlot categoryPlot13 = new org.jfree.chart.plot.CategoryPlot();
    boolean b14 = categoryPlot13.isRangeZoomable();
    org.jfree.chart.axis.CategoryAxis categoryAxis15 = categoryPlot13.getDomainAxis();
    org.jfree.chart.axis.CategoryAxis categoryAxis16 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset17 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot18 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset17);
    org.jfree.chart.axis.ValueAxis valueAxis19 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot20 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis19);
    java.util.List list21 = combinedDomainXYPlot20.getAnnotations();
    waferMapPlot18.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot20);
    int i23 = combinedDomainXYPlot20.getSeriesCount();
    categoryAxis16.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot20);
    boolean b26 = categoryAxis16.equals((java.lang.Object)(short)1);
    java.awt.Color color32 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke33 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color34 = java.awt.Color.orange;
    java.awt.Stroke stroke35 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker37 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color32, stroke33, (java.awt.Paint)color34, stroke35, 0.0f);
    java.awt.Color color38 = color34.brighter();
    categoryAxis16.setTickLabelPaint((java.awt.Paint)color34);
    org.jfree.chart.axis.CategoryAxis[] categoryAxis_array40 = new org.jfree.chart.axis.CategoryAxis[] { categoryAxis16 };
    categoryPlot13.setDomainAxes(categoryAxis_array40);
    categoryPlot13.clearRangeMarkers(255);
    java.util.TimeZone timeZone44 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection45 = new org.jfree.data.time.TimeSeriesCollection(timeZone44);
    org.jfree.chart.event.RendererChangeEvent rendererChangeEvent47 = new org.jfree.chart.event.RendererChangeEvent((java.lang.Object)timeSeriesCollection45, false);
    categoryPlot13.rendererChanged(rendererChangeEvent47);
    xYStepAreaRenderer4.notifyListeners(rendererChangeEvent47);
    boolean b50 = rendererChangeEvent47.getSeriesVisibilityChanged();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryAxis15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i23 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(categoryAxis_array40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b50 == false);

  }

  @Test
  public void test423() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test423"); }


    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator1 = null;
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator3 = new org.jfree.chart.urls.StandardXYURLGenerator("");
    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer4 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(100, xYToolTipGenerator1, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator3);
    xYStepAreaRenderer4.setPlotArea(true);
    java.lang.Object obj7 = null;
    boolean b8 = xYStepAreaRenderer4.equals(obj7);
    java.awt.Font font10 = xYStepAreaRenderer4.getLegendTextFont(40);
    boolean b11 = xYStepAreaRenderer4.getPlotArea();
    org.jfree.chart.StandardChartTheme standardChartTheme14 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.plot.DrawingSupplier drawingSupplier15 = standardChartTheme14.getDrawingSupplier();
    java.awt.Paint paint16 = standardChartTheme14.getItemLabelPaint();
    xYStepAreaRenderer4.setSeriesFillPaint(14, paint16, false);
    org.jfree.chart.annotations.XYAnnotation xYAnnotation19 = null;
    // The following exception was thrown during execution in test generation
    try {
      xYStepAreaRenderer4.addAnnotation(xYAnnotation19);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(font10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(drawingSupplier15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint16);

  }

  @Test
  public void test424() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test424"); }


    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot0 = new org.jfree.chart.plot.MultiplePiePlot();
    java.awt.Paint paint1 = multiplePiePlot0.getOutlinePaint();
    java.awt.Shape shape2 = multiplePiePlot0.getLegendItemShape();
    java.awt.Paint paint3 = multiplePiePlot0.getOutlinePaint();
    float f4 = multiplePiePlot0.getBackgroundImageAlpha();
    java.lang.String str5 = multiplePiePlot0.getPlotType();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f4 == 0.5f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str5 + "' != '" + "Multiple Pie Plot"+ "'", str5.equals("Multiple Pie Plot"));

  }

  @Test
  public void test425() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test425"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = null;
    // The following exception was thrown during execution in test generation
    try {
      piePlot3D2.setBaseSectionOutlinePaint(paint3);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);

  }

  @Test
  public void test426() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test426"); }


    org.jfree.chart.renderer.category.GradientBarPainter gradientBarPainter0 = new org.jfree.chart.renderer.category.GradientBarPainter();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator1 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator5 = new org.jfree.chart.urls.StandardXYURLGenerator("", "hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!", "");
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer6 = new org.jfree.chart.renderer.xy.XYStepRenderer((org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator1, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator5);
    xYStepRenderer6.setSeriesLinesVisible(12, (java.lang.Boolean)true);
    boolean b12 = xYStepRenderer6.getItemShapeFilled(40, 100);
    boolean b13 = xYStepRenderer6.getUseFillPaint();
    boolean b14 = gradientBarPainter0.equals((java.lang.Object)b13);
    java.awt.Graphics2D graphics2D15 = null;
    org.jfree.chart.renderer.category.BarRenderer barRenderer16 = new org.jfree.chart.renderer.category.BarRenderer();
    java.awt.Font font22 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset23 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot24 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset23);
    org.jfree.chart.axis.ValueAxis valueAxis25 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot26 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis25);
    java.util.List list27 = combinedDomainXYPlot26.getAnnotations();
    waferMapPlot24.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot26);
    boolean b29 = combinedDomainXYPlot26.isNotify();
    org.jfree.chart.JFreeChart jFreeChart31 = new org.jfree.chart.JFreeChart("", font22, (org.jfree.chart.plot.Plot)combinedDomainXYPlot26, true);
    org.jfree.chart.title.TextTitle textTitle32 = new org.jfree.chart.title.TextTitle("", font22);
    textTitle32.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame35 = textTitle32.getFrame();
    java.lang.String str36 = textTitle32.getID();
    java.awt.geom.Rectangle2D rectangle2D37 = textTitle32.getBounds();
    org.jfree.chart.axis.ValueAxis valueAxis38 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot39 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis38);
    java.util.List list40 = combinedDomainXYPlot39.getAnnotations();
    combinedDomainXYPlot39.setRangeGridlinesVisible(true);
    org.jfree.chart.util.RectangleEdge rectangleEdge44 = combinedDomainXYPlot39.getRangeAxisEdge(4);
    // The following exception was thrown during execution in test generation
    try {
      gradientBarPainter0.paintBar(graphics2D15, barRenderer16, 4, 255, false, (java.awt.geom.RectangularShape)rectangle2D37, rectangleEdge44);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge44);

  }

  @Test
  public void test427() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test427"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(99.5d);

  }

  @Test
  public void test428() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test428"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier2 = xYAreaRenderer1.getDrawingSupplier();
    xYAreaRenderer1.setBaseCreateEntities(false);
    xYAreaRenderer1.setAutoPopulateSeriesOutlineStroke(true);
    java.awt.Paint paint7 = xYAreaRenderer1.getBaseLegendTextPaint();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint7);

  }

  @Test
  public void test429() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test429"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    boolean b1 = xYStepRenderer0.getUseFillPaint();
    xYStepRenderer0.setDrawSeriesLineAsPath(false);
    java.awt.Stroke stroke7 = xYStepRenderer0.getItemOutlineStroke(10, 15, false);
    boolean b8 = xYStepRenderer0.getUseOutlinePaint();
    org.jfree.chart.event.RendererChangeEvent rendererChangeEvent10 = new org.jfree.chart.event.RendererChangeEvent((java.lang.Object)b8, true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);

  }

  @Test
  public void test430() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test430"); }


    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.ChartColor chartColor3 = new org.jfree.chart.ChartColor(0, 2958465, 100);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test431() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test431"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Color color10 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke11 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color12 = java.awt.Color.orange;
    java.awt.Stroke stroke13 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker15 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color10, stroke11, (java.awt.Paint)color12, stroke13, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer16 = null;
    intervalMarker15.setGradientPaintTransformer(gradientPaintTransformer16);
    org.jfree.chart.util.RectangleInsets rectangleInsets18 = intervalMarker15.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis20 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets21 = categoryAxis20.getLabelInsets();
    intervalMarker15.setLabelOffset(rectangleInsets21);
    double d23 = intervalMarker15.getEndValue();
    org.jfree.chart.util.Layer layer24 = null;
    boolean b25 = categoryPlot0.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker15, layer24);
    org.jfree.data.category.CategoryDataset categoryDataset26 = null;
    int i27 = categoryPlot0.indexOf(categoryDataset26);
    org.jfree.data.general.WaferMapDataset waferMapDataset29 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot30 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset29);
    org.jfree.chart.axis.ValueAxis valueAxis31 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot32 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis31);
    java.util.List list33 = combinedDomainXYPlot32.getAnnotations();
    waferMapPlot30.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot32);
    int i35 = combinedDomainXYPlot32.getSeriesCount();
    boolean b37 = combinedDomainXYPlot32.equals((java.lang.Object)10.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer39 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    xYAreaRenderer39.setSeriesCreateEntities(15, (java.lang.Boolean)true, true);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition45 = xYAreaRenderer39.getSeriesPositiveItemLabelPosition(3);
    boolean b46 = combinedDomainXYPlot32.equals((java.lang.Object)3);
    org.jfree.chart.axis.AxisLocation axisLocation48 = combinedDomainXYPlot32.getDomainAxisLocation(10);
    categoryPlot0.setDomainAxisLocation(0, axisLocation48);
    org.jfree.chart.renderer.category.BarRenderer barRenderer52 = new org.jfree.chart.renderer.category.BarRenderer();
    double d53 = barRenderer52.getShadowXOffset();
    barRenderer52.setShadowXOffset(10.0d);
    boolean b56 = barRenderer52.getIncludeBaseInRange();
    java.awt.Graphics2D graphics2D57 = null;
    java.awt.geom.Rectangle2D rectangle2D58 = null;
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D60 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    org.jfree.chart.axis.NumberAxis3D numberAxis3D61 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Paint paint62 = org.jfree.chart.axis.Axis.DEFAULT_AXIS_LINE_PAINT;
    numberAxis3D61.setLabelPaint(paint62);
    numberAxis3D61.setTickMarksVisible(true);
    org.jfree.chart.util.Layer layer66 = org.jfree.chart.util.Layer.FOREGROUND;
    org.jfree.chart.plot.CategoryPlot categoryPlot67 = new org.jfree.chart.plot.CategoryPlot();
    boolean b68 = categoryPlot67.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge70 = categoryPlot67.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis72 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets73 = categoryAxis72.getLabelInsets();
    double d75 = rectangleInsets73.calculateLeftInset(4.0d);
    categoryPlot67.setInsets(rectangleInsets73, false);
    int i78 = categoryPlot67.getRendererCount();
    org.jfree.chart.axis.NumberAxis numberAxis79 = new org.jfree.chart.axis.NumberAxis();
    numberAxis79.centerRange(100.0d);
    java.awt.Paint paint82 = numberAxis79.getLabelPaint();
    categoryPlot67.setRangeCrosshairPaint(paint82);
    org.jfree.chart.entity.EntityCollection entityCollection85 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo86 = new org.jfree.chart.ChartRenderingInfo(entityCollection85);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo87 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo86);
    java.awt.geom.Point2D point2D88 = null;
    categoryPlot67.panRangeAxes(0.6d, plotRenderingInfo87, point2D88);
    barRenderer52.drawAnnotations(graphics2D57, rectangle2D58, (org.jfree.chart.axis.CategoryAxis)categoryAxis3D60, (org.jfree.chart.axis.ValueAxis)numberAxis3D61, layer66, plotRenderingInfo87);
    java.awt.geom.Rectangle2D rectangle2D91 = null;
    org.jfree.chart.util.RectangleAnchor rectangleAnchor92 = null;
    java.awt.geom.Point2D point2D93 = org.jfree.chart.util.RectangleAnchor.coordinates(rectangle2D91, rectangleAnchor92);
    categoryPlot0.zoomRangeAxes(108.0d, 4.5d, plotRenderingInfo87, point2D93);
    org.jfree.chart.axis.CategoryAxis categoryAxis95 = categoryPlot0.getDomainAxis();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d23 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i27 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i35 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b46 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d53 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b56 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(layer66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b68 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets73);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d75 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i78 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point2D93);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryAxis95);

  }

  @Test
  public void test432() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test432"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer0 = new org.jfree.chart.renderer.xy.XYBarRenderer();
    xYBarRenderer0.setBase(90.0d);

  }

  @Test
  public void test433() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test433"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    piePlot3D2.setStartAngle(Double.NaN);
    org.jfree.data.general.DefaultPieDataset defaultPieDataset5 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj6 = defaultPieDataset5.clone();
    double d7 = org.jfree.data.general.DatasetUtilities.calculatePieDatasetTotal((org.jfree.data.general.PieDataset)defaultPieDataset5);
    piePlot3D2.setDataset((org.jfree.data.general.PieDataset)defaultPieDataset5);
    org.jfree.chart.util.Rotation rotation9 = piePlot3D2.getDirection();
    org.jfree.chart.axis.ValueAxis valueAxis11 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot12 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis11);
    java.util.List list13 = combinedDomainXYPlot12.getAnnotations();
    combinedDomainXYPlot12.setRangeGridlinesVisible(true);
    org.jfree.chart.axis.AxisSpace axisSpace16 = null;
    combinedDomainXYPlot12.setFixedRangeAxisSpace(axisSpace16);
    org.jfree.data.xy.XYDataset xYDataset19 = combinedDomainXYPlot12.getDataset(40);
    org.jfree.chart.StandardChartTheme standardChartTheme21 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Paint paint22 = standardChartTheme21.getAxisLabelPaint();
    java.awt.Font font23 = standardChartTheme21.getLargeFont();
    combinedDomainXYPlot12.setNoDataMessageFont(font23);
    org.jfree.data.general.WaferMapDataset waferMapDataset25 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot26 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset25);
    org.jfree.chart.axis.ValueAxis valueAxis27 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot28 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis27);
    java.util.List list29 = combinedDomainXYPlot28.getAnnotations();
    waferMapPlot26.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot28);
    boolean b31 = combinedDomainXYPlot28.isNotify();
    org.jfree.chart.util.Layer layer32 = null;
    java.util.Collection collection33 = combinedDomainXYPlot28.getDomainMarkers(layer32);
    org.jfree.chart.LegendItemCollection legendItemCollection34 = combinedDomainXYPlot28.getLegendItems();
    org.jfree.chart.JFreeChart jFreeChart36 = new org.jfree.chart.JFreeChart("ClassContext", font23, (org.jfree.chart.plot.Plot)combinedDomainXYPlot28, false);
    boolean b37 = piePlot3D2.equals((java.lang.Object)"ClassContext");
    boolean b38 = piePlot3D2.getSimpleLabels();
    piePlot3D2.setMaximumLabelWidth(0.0d);
    boolean b41 = piePlot3D2.getIgnoreZeroValues();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rotation9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYDataset19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == false);

  }

  @Test
  public void test434() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test434"); }


    org.jfree.chart.axis.NumberAxis3D numberAxis3D0 = new org.jfree.chart.axis.NumberAxis3D();
    numberAxis3D0.resizeRange2(0.0d, 0.08d);
    boolean b4 = numberAxis3D0.getAutoRangeIncludesZero();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);

  }

  @Test
  public void test435() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test435"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    boolean b31 = legendItem30.isShapeOutlineVisible();
    boolean b33 = legendItem30.equals((java.lang.Object)(short)1);
    java.awt.Paint paint34 = legendItem30.getFillPaint();
    legendItem30.setShapeVisible(true);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer38 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator39 = xYAreaRenderer38.getLegendItemToolTipGenerator();
    boolean b42 = xYAreaRenderer38.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition46 = xYAreaRenderer38.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b48 = xYAreaRenderer38.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator49 = null;
    xYAreaRenderer38.setBaseToolTipGenerator(xYToolTipGenerator49, true);
    java.awt.Shape shape53 = xYAreaRenderer38.lookupLegendShape(3);
    legendItem30.setLine(shape53);
    java.io.ObjectOutputStream objectOutputStream55 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.util.SerialUtilities.writeShape(shape53, objectOutputStream55);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b42 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape53);

  }

  @Test
  public void test436() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test436"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    java.awt.Stroke stroke11 = jFreeChart10.getBorderStroke();
    jFreeChart10.setBackgroundImageAlpha(1.0f);
    java.awt.RenderingHints renderingHints14 = null;
    // The following exception was thrown during execution in test generation
    try {
      jFreeChart10.setRenderingHints(renderingHints14);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke11);

  }

  @Test
  public void test437() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test437"); }


    org.jfree.chart.StandardChartTheme standardChartTheme1 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.plot.DrawingSupplier drawingSupplier2 = standardChartTheme1.getDrawingSupplier();
    org.jfree.chart.ChartColor chartColor6 = new org.jfree.chart.ChartColor(40, 255, 255);
    standardChartTheme1.setItemLabelPaint((java.awt.Paint)chartColor6);
    java.awt.Color color8 = chartColor6.darker();
    java.awt.Color color9 = java.awt.Color.white;
    java.awt.color.ColorSpace colorSpace10 = color9.getColorSpace();
    float[] f_array11 = new float[] {  };
    // The following exception was thrown during execution in test generation
    try {
      float[] f_array12 = chartColor6.getComponents(colorSpace10, f_array11);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(drawingSupplier2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(colorSpace10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array11);

  }

  @Test
  public void test438() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test438"); }


    long long0 = org.jfree.chart.axis.SegmentedTimeline.DAY_SEGMENT_SIZE;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long0 == 86400000L);

  }

  @Test
  public void test439() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test439"); }


    org.jfree.chart.renderer.xy.GradientXYBarPainter gradientXYBarPainter3 = new org.jfree.chart.renderer.xy.GradientXYBarPainter(0.0d, 0.0d, 0.2d);
    java.awt.Graphics2D graphics2D4 = null;
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer6 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d7 = xYBarRenderer6.getMargin();
    boolean b8 = xYBarRenderer6.getAutoPopulateSeriesShape();
    java.awt.Stroke stroke9 = xYBarRenderer6.getBaseOutlineStroke();
    org.jfree.chart.renderer.xy.XYBarPainter xYBarPainter10 = xYBarRenderer6.getBarPainter();
    org.jfree.data.xy.XYSeries xYSeries14 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection15 = new org.jfree.data.xy.XYSeriesCollection(xYSeries14);
    boolean b16 = xYSeriesCollection15.isAutoWidth();
    org.jfree.data.Range range18 = xYSeriesCollection15.getRangeBounds(true);
    xYSeriesCollection15.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis21 = new org.jfree.chart.axis.NumberAxis();
    numberAxis21.centerRange(100.0d);
    java.lang.Object obj24 = numberAxis21.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer25 = null;
    org.jfree.chart.plot.PolarPlot polarPlot26 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection15, (org.jfree.chart.axis.ValueAxis)numberAxis21, polarItemRenderer25);
    org.jfree.chart.plot.PlotOrientation plotOrientation27 = polarPlot26.getOrientation();
    boolean b28 = polarPlot26.isAngleLabelsVisible();
    int i29 = polarPlot26.getSeriesCount();
    java.awt.Font font34 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset35 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot36 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset35);
    org.jfree.chart.axis.ValueAxis valueAxis37 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot38 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis37);
    java.util.List list39 = combinedDomainXYPlot38.getAnnotations();
    waferMapPlot36.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot38);
    boolean b41 = combinedDomainXYPlot38.isNotify();
    org.jfree.chart.JFreeChart jFreeChart43 = new org.jfree.chart.JFreeChart("", font34, (org.jfree.chart.plot.Plot)combinedDomainXYPlot38, true);
    org.jfree.chart.title.TextTitle textTitle44 = new org.jfree.chart.title.TextTitle("", font34);
    textTitle44.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame47 = textTitle44.getFrame();
    java.lang.String str48 = textTitle44.getID();
    java.awt.geom.Rectangle2D rectangle2D49 = textTitle44.getBounds();
    java.awt.Point point50 = polarPlot26.translateValueThetaRadiusToJava2D(0.0d, 0.05d, rectangle2D49);
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D52 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke53 = categoryAxis3D52.getTickMarkStroke();
    java.awt.Graphics2D graphics2D54 = null;
    java.awt.geom.Rectangle2D rectangle2D56 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge57 = org.jfree.chart.util.RectangleEdge.LEFT;
    org.jfree.chart.axis.AxisState axisState59 = new org.jfree.chart.axis.AxisState(1.0d);
    double d60 = axisState59.getCursor();
    axisState59.cursorLeft(0.2d);
    categoryAxis3D52.drawTickMarks(graphics2D54, 7.0d, rectangle2D56, rectangleEdge57, axisState59);
    // The following exception was thrown during execution in test generation
    try {
      gradientXYBarPainter3.paintBarShadow(graphics2D4, xYBarRenderer6, 15, 255, true, (java.awt.geom.RectangularShape)rectangle2D49, rectangleEdge57, true);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(xYBarPainter10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i29 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d60 == 1.0d);

  }

  @Test
  public void test440() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test440"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    xYAreaRenderer1.setSeriesCreateEntities(15, (java.lang.Boolean)true, true);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer7 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator8 = xYAreaRenderer7.getLegendItemToolTipGenerator();
    boolean b11 = xYAreaRenderer7.getItemVisible(10, 1);
    boolean b12 = xYAreaRenderer1.equals((java.lang.Object)xYAreaRenderer7);
    java.lang.Boolean b14 = xYAreaRenderer7.getSeriesVisible(1);
    java.awt.Font font16 = xYAreaRenderer7.getSeriesItemLabelFont(133);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(font16);

  }

  @Test
  public void test441() {}
// Defects4J: flaky method
//   @Test
//   public void test441() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test441"); }
// 
// 
//     org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
//     boolean b1 = categoryPlot0.isRangeZoomable();
//     org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
//     java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
//     org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
//     org.jfree.chart.axis.ValueAxis valueAxis8 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
//     java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
//     waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
//     org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
//     org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
//     numberAxis15.centerRange(100.0d);
//     combinedDomainXYPlot9.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis15);
//     org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier19 = new org.jfree.chart.plot.DefaultDrawingSupplier();
//     combinedDomainXYPlot9.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
//     categoryPlot0.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
//     categoryPlot0.clearRangeMarkers(100);
//     boolean b24 = categoryPlot0.isRangePannable();
//     float f25 = categoryPlot0.getBackgroundAlpha();
//     org.jfree.chart.plot.DatasetRenderingOrder datasetRenderingOrder26 = org.jfree.chart.plot.DatasetRenderingOrder.REVERSE;
//     categoryPlot0.setDatasetRenderingOrder(datasetRenderingOrder26);
//     categoryPlot0.configureRangeAxes();
//     int i29 = categoryPlot0.getBackgroundImageAlignment();
//     categoryPlot0.clearRangeMarkers(7);
//     org.jfree.chart.plot.DatasetRenderingOrder datasetRenderingOrder32 = org.jfree.chart.plot.DatasetRenderingOrder.FORWARD;
//     org.jfree.chart.axis.ValueAxis valueAxis33 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot34 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis33);
//     java.util.List list35 = combinedDomainXYPlot34.getAnnotations();
//     combinedDomainXYPlot34.setRangeGridlinesVisible(true);
//     org.jfree.chart.util.RectangleEdge rectangleEdge39 = combinedDomainXYPlot34.getRangeAxisEdge(4);
//     boolean b40 = datasetRenderingOrder32.equals((java.lang.Object)combinedDomainXYPlot34);
//     org.jfree.data.time.Month month41 = new org.jfree.data.time.Month();
//     int i42 = month41.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem44 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month41, 11.0d);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod45 = month41.next();
//     boolean b46 = datasetRenderingOrder32.equals((java.lang.Object)regularTimePeriod45);
//     categoryPlot0.setDatasetRenderingOrder(datasetRenderingOrder32);
//     org.jfree.chart.axis.CategoryAnchor categoryAnchor48 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       categoryPlot0.setDomainGridlinePosition(categoryAnchor48);
//       org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
//     } catch (java.lang.IllegalArgumentException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b1 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleEdge3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(font5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b24 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f25 == 1.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(datasetRenderingOrder26);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i29 == 15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(datasetRenderingOrder32);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleEdge39);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b40 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i42 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod45);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b46 == false);
// 
//   }

  @Test
  public void test442() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test442"); }


    java.lang.Number[] number_array2 = null;
    java.lang.Number[][] number_array_array3 = new java.lang.Number[][] { number_array2 };
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.category.CategoryDataset categoryDataset4 = org.jfree.data.general.DatasetUtilities.createCategoryDataset("RectangleAnchor.BOTTOM_RIGHT", "Combined Range XYPlot", number_array_array3);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(number_array_array3);

  }

  @Test
  public void test443() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test443"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    piePlot3D2.setStartAngle(Double.NaN);
    double d5 = piePlot3D2.getMaximumExplodePercent();
    java.awt.Paint paint6 = piePlot3D2.getBaseSectionPaint();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint6);

  }

  @Test
  public void test444() throws Throwable {

    if (debug) { System.out.for