
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class RegressionTest3 {

  public static boolean debug = false;

  @Test
  public void test001() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test001"); }


    org.jfree.chart.renderer.category.BarRenderer barRenderer0 = new org.jfree.chart.renderer.category.BarRenderer();
    double d1 = barRenderer0.getShadowXOffset();
    org.jfree.chart.labels.CategoryToolTipGenerator categoryToolTipGenerator5 = barRenderer0.getToolTipGenerator((-25560), 2, false);
    barRenderer0.setItemMargin(0.2d);
    java.lang.Boolean b9 = barRenderer0.getSeriesCreateEntities(2016);
    org.jfree.chart.urls.CategoryURLGenerator categoryURLGenerator10 = null;
    barRenderer0.setBaseURLGenerator(categoryURLGenerator10, true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryToolTipGenerator5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b9);

  }

  @Test
  public void test002() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test002"); }


    java.awt.Color color0 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    java.awt.Stroke stroke1 = org.jfree.chart.plot.CategoryPlot.DEFAULT_CROSSHAIR_STROKE;
    org.jfree.chart.util.RectangleInsets rectangleInsets2 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.chart.util.UnitType unitType3 = rectangleInsets2.getUnitType();
    double d5 = rectangleInsets2.calculateLeftOutset(0.0d);
    org.jfree.chart.block.LineBorder lineBorder6 = new org.jfree.chart.block.LineBorder((java.awt.Paint)color0, stroke1, rectangleInsets2);
    java.lang.Object obj7 = null;
    boolean b8 = lineBorder6.equals(obj7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(unitType3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);

  }

  @Test
  public void test003() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test003"); }


    java.util.TimeZone timeZone1 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
    org.jfree.chart.axis.DateAxis dateAxis2 = new org.jfree.chart.axis.DateAxis("", timeZone1);
    java.lang.Object obj3 = dateAxis2.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(timeZone1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj3);

  }

  @Test
  public void test004() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test004"); }


    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D0 = new org.jfree.chart.axis.CategoryAxis3D();
    org.jfree.chart.plot.Plot plot1 = categoryAxis3D0.getPlot();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(plot1);

  }

  @Test
  public void test005() {}
// Defects4J: flaky method
//   @Test
//   public void test005() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test005"); }
// 
// 
//     org.jfree.data.time.Month month1 = new org.jfree.data.time.Month();
//     int i2 = month1.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem4 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month1, (java.lang.Number)8);
//     long long5 = month1.getFirstMillisecond();
//     org.jfree.data.time.Month month6 = new org.jfree.data.time.Month();
//     int i7 = month6.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis8 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month1, (org.jfree.data.time.RegularTimePeriod)month6);
//     periodAxis8.setUpperMargin(10.0d);
//     org.jfree.data.Range range11 = periodAxis8.getRange();
//     org.jfree.chart.util.RectangleInsets rectangleInsets12 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
//     double d13 = rectangleInsets12.getLeft();
//     double d15 = rectangleInsets12.calculateLeftOutset(1.0d);
//     double d17 = rectangleInsets12.calculateRightInset(0.05d);
//     periodAxis8.setLabelInsets(rectangleInsets12);
//     periodAxis8.resizeRange2(90.0d, 5.0d);
//     java.lang.Object obj22 = periodAxis8.clone();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i2 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i7 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(range11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d13 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d15 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d17 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj22);
// 
//   }

  @Test
  public void test006() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test006"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    org.jfree.chart.plot.Plot plot2 = combinedDomainXYPlot1.getRootPlot();
    java.awt.Color color8 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke9 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color10 = java.awt.Color.orange;
    java.awt.Stroke stroke11 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker13 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color8, stroke9, (java.awt.Paint)color10, stroke11, 0.0f);
    org.jfree.chart.util.Layer layer14 = null;
    boolean b15 = combinedDomainXYPlot1.removeRangeMarker((org.jfree.chart.plot.Marker)intervalMarker13, layer14);
    org.jfree.chart.event.MarkerChangeEvent markerChangeEvent16 = null;
    intervalMarker13.notifyListeners(markerChangeEvent16);
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer19 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition20 = null;
    xYBarRenderer19.setNegativeItemLabelPositionFallback(itemLabelPosition20);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer22 = xYBarRenderer19.getGradientPaintTransformer();
    intervalMarker13.setGradientPaintTransformer(gradientPaintTransformer22);
    // The following exception was thrown during execution in test generation
    try {
      intervalMarker13.setAlpha(100.0f);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(gradientPaintTransformer22);

  }

  @Test
  public void test007() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test007"); }


    org.jfree.chart.axis.TickType tickType0 = org.jfree.chart.axis.TickType.MINOR;
    java.awt.Font font2 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset3 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot4 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset3);
    org.jfree.chart.axis.ValueAxis valueAxis5 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot6 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis5);
    java.util.List list7 = combinedDomainXYPlot6.getAnnotations();
    waferMapPlot4.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot6);
    boolean b9 = combinedDomainXYPlot6.isNotify();
    org.jfree.chart.JFreeChart jFreeChart11 = new org.jfree.chart.JFreeChart("", font2, (org.jfree.chart.plot.Plot)combinedDomainXYPlot6, true);
    combinedDomainXYPlot6.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer14 = null;
    combinedDomainXYPlot6.setRenderer(xYItemRenderer14);
    boolean b16 = combinedDomainXYPlot6.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries17 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection18 = new org.jfree.data.time.TimeSeriesCollection(timeSeries17);
    combinedDomainXYPlot6.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection18);
    org.jfree.data.time.TimeSeries timeSeries20 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection21 = new org.jfree.data.time.TimeSeriesCollection(timeSeries20);
    timeSeriesCollection21.validateObject();
    java.util.List list23 = timeSeriesCollection21.getSeries();
    org.jfree.data.time.TimePeriodAnchor timePeriodAnchor24 = timeSeriesCollection21.getXPosition();
    timeSeriesCollection18.setXPosition(timePeriodAnchor24);
    boolean b26 = tickType0.equals((java.lang.Object)timeSeriesCollection18);
    // The following exception was thrown during execution in test generation
    try {
      int i28 = timeSeriesCollection18.getItemCount((-25560));
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(tickType0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(timePeriodAnchor24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == false);

  }

  @Test
  public void test008() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test008"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis5 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets6 = categoryAxis5.getLabelInsets();
    double d8 = rectangleInsets6.calculateLeftInset(4.0d);
    categoryPlot0.setInsets(rectangleInsets6, false);
    org.jfree.chart.util.Layer layer12 = null;
    java.util.Collection collection13 = categoryPlot0.getDomainMarkers(5, layer12);
    org.jfree.data.general.DatasetGroup datasetGroup14 = categoryPlot0.getDatasetGroup();
    org.jfree.chart.entity.EntityCollection entityCollection16 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo17 = new org.jfree.chart.ChartRenderingInfo(entityCollection16);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo18 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo17);
    java.awt.geom.Point2D point2D19 = null;
    categoryPlot0.zoomDomainAxes(12.0d, plotRenderingInfo18, point2D19, true);
    org.jfree.chart.renderer.category.BarRenderer barRenderer23 = new org.jfree.chart.renderer.category.BarRenderer();
    double d24 = barRenderer23.getShadowXOffset();
    barRenderer23.setShadowXOffset(10.0d);
    boolean b27 = barRenderer23.getIncludeBaseInRange();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition28 = barRenderer23.getNegativeItemLabelPositionFallback();
    categoryPlot0.setRenderer(0, (org.jfree.chart.renderer.category.CategoryItemRenderer)barRenderer23);
    categoryPlot0.setRangeZeroBaselineVisible(true);
    int i32 = categoryPlot0.getDomainAxisCount();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(datasetGroup14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d24 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(itemLabelPosition28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i32 == 1);

  }

  @Test
  public void test009() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test009"); }


    org.jfree.chart.block.FlowArrangement flowArrangement0 = new org.jfree.chart.block.FlowArrangement();
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer1 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    boolean b2 = xYStepRenderer1.getUseFillPaint();
    xYStepRenderer1.setDrawSeriesLineAsPath(false);
    java.awt.Paint paint8 = xYStepRenderer1.getItemFillPaint(2, 8, false);
    java.awt.Graphics2D graphics2D9 = null;
    java.awt.geom.Rectangle2D rectangle2D10 = null;
    org.jfree.chart.plot.XYPlot xYPlot11 = null;
    org.jfree.data.general.WaferMapDataset waferMapDataset12 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot13 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset12);
    org.jfree.chart.JFreeChart jFreeChart14 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent15 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot13, jFreeChart14);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment16 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment17 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement20 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment16, verticalAlignment17, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement21 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle22 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot13, (org.jfree.chart.block.Arrangement)flowArrangement20, (org.jfree.chart.block.Arrangement)borderArrangement21);
    org.jfree.data.time.TimeSeries timeSeries23 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection24 = new org.jfree.data.time.TimeSeriesCollection(timeSeries23);
    timeSeriesCollection24.validateObject();
    java.lang.Comparable comparable26 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer27 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement20, (org.jfree.data.general.Dataset)timeSeriesCollection24, comparable26);
    timeSeriesCollection24.validateObject();
    org.jfree.chart.axis.ValueAxis valueAxis29 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot30 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis29);
    org.jfree.chart.plot.PlotOrientation plotOrientation31 = combinedDomainXYPlot30.getOrientation();
    boolean b32 = combinedDomainXYPlot30.isDomainCrosshairLockedOnData();
    org.jfree.chart.entity.EntityCollection entityCollection34 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo35 = new org.jfree.chart.ChartRenderingInfo(entityCollection34);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo36 = chartRenderingInfo35.getPlotInfo();
    java.awt.geom.Point2D point2D37 = null;
    combinedDomainXYPlot30.panDomainAxes(4.5d, plotRenderingInfo36, point2D37);
    int i39 = plotRenderingInfo36.getSubplotCount();
    org.jfree.chart.entity.EntityCollection entityCollection40 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo41 = new org.jfree.chart.ChartRenderingInfo(entityCollection40);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo42 = chartRenderingInfo41.getPlotInfo();
    plotRenderingInfo36.addSubplotInfo(plotRenderingInfo42);
    org.jfree.chart.renderer.xy.XYItemRendererState xYItemRendererState44 = xYStepRenderer1.initialise(graphics2D9, rectangle2D10, xYPlot11, (org.jfree.data.xy.XYDataset)timeSeriesCollection24, plotRenderingInfo42);
    org.jfree.data.time.TimeSeries timeSeries46 = timeSeriesCollection24.getSeries((java.lang.Comparable)"January");
    java.lang.Comparable comparable47 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer48 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement0, (org.jfree.data.general.Dataset)timeSeriesCollection24, comparable47);
    org.jfree.chart.block.BlockContainer blockContainer49 = new org.jfree.chart.block.BlockContainer((org.jfree.chart.block.Arrangement)flowArrangement0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i39 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(xYItemRendererState44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(timeSeries46);

  }

  @Test
  public void test010() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test010"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
    numberAxis15.centerRange(100.0d);
    combinedDomainXYPlot9.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis15);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier19 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot9.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.setBackgroundImageAlpha(0.0f);
    int i24 = categoryPlot0.getRendererCount();
    org.jfree.chart.plot.CategoryPlot categoryPlot26 = new org.jfree.chart.plot.CategoryPlot();
    boolean b27 = categoryPlot26.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge29 = categoryPlot26.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis31 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets32 = categoryAxis31.getLabelInsets();
    double d34 = rectangleInsets32.calculateLeftInset(4.0d);
    categoryPlot26.setInsets(rectangleInsets32, false);
    int i37 = categoryPlot26.getRendererCount();
    org.jfree.chart.axis.NumberAxis numberAxis38 = new org.jfree.chart.axis.NumberAxis();
    numberAxis38.centerRange(100.0d);
    java.awt.Paint paint41 = numberAxis38.getLabelPaint();
    categoryPlot26.setRangeCrosshairPaint(paint41);
    org.jfree.chart.entity.EntityCollection entityCollection44 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo45 = new org.jfree.chart.ChartRenderingInfo(entityCollection44);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo46 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo45);
    java.awt.geom.Point2D point2D47 = null;
    categoryPlot26.panRangeAxes(0.6d, plotRenderingInfo46, point2D47);
    java.awt.geom.Rectangle2D rectangle2D49 = plotRenderingInfo46.getPlotArea();
    org.jfree.chart.axis.ValueAxis valueAxis50 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot51 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis50);
    java.util.List list52 = combinedDomainXYPlot51.getAnnotations();
    combinedDomainXYPlot51.setRangeGridlinesVisible(true);
    java.awt.geom.Rectangle2D rectangle2D55 = null;
    org.jfree.chart.util.RectangleAnchor rectangleAnchor56 = null;
    java.awt.geom.Point2D point2D57 = org.jfree.chart.util.RectangleAnchor.coordinates(rectangle2D55, rectangleAnchor56);
    combinedDomainXYPlot51.setQuadrantOrigin(point2D57);
    categoryPlot0.zoomDomainAxes(5.0d, plotRenderingInfo46, point2D57, false);
    org.jfree.chart.axis.CategoryAxis categoryAxis62 = new org.jfree.chart.axis.CategoryAxis("RectangleConstraint[LengthConstraintType.FIXED: width=100.0, height=0.0]");
    categoryAxis62.setCategoryLabelPositionOffset(5);
    categoryPlot0.setDomainAxis(categoryAxis62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i24 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d34 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i37 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(rectangle2D49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point2D57);

  }

  @Test
  public void test011() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test011"); }


    java.awt.Color color5 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke6 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color7 = java.awt.Color.orange;
    java.awt.Stroke stroke8 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker10 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color5, stroke6, (java.awt.Paint)color7, stroke8, 0.0f);
    intervalMarker10.setStartValue(0.0d);
    intervalMarker10.setEndValue(0.4d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke8);

  }

  @Test
  public void test012() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test012"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.axis.ValueAxis valueAxis2 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot3 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis2);
    java.util.List list4 = combinedDomainXYPlot3.getAnnotations();
    waferMapPlot1.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot3);
    int i6 = combinedDomainXYPlot3.getSeriesCount();
    boolean b8 = combinedDomainXYPlot3.equals((java.lang.Object)10.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer10 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    xYAreaRenderer10.setSeriesCreateEntities(15, (java.lang.Boolean)true, true);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition16 = xYAreaRenderer10.getSeriesPositiveItemLabelPosition(3);
    boolean b17 = combinedDomainXYPlot3.equals((java.lang.Object)3);
    org.jfree.chart.annotations.XYAnnotation xYAnnotation18 = null;
    // The following exception was thrown during execution in test generation
    try {
      combinedDomainXYPlot3.addAnnotation(xYAnnotation18);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);

  }

  @Test
  public void test013() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test013"); }


    org.jfree.data.time.DateRange dateRange2 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange5 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b6 = dateRange2.intersects((org.jfree.data.Range)dateRange5);
    org.jfree.data.xy.XYSeries xYSeries10 = new org.jfree.data.xy.XYSeries((java.lang.Comparable)10.0d, false, false);
    org.jfree.data.general.WaferMapDataset waferMapDataset11 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot12 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset11);
    org.jfree.chart.JFreeChart jFreeChart13 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent14 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot12, jFreeChart13);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment15 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment16 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement19 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment15, verticalAlignment16, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement20 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle21 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot12, (org.jfree.chart.block.Arrangement)flowArrangement19, (org.jfree.chart.block.Arrangement)borderArrangement20);
    org.jfree.data.time.TimeSeries timeSeries22 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection23 = new org.jfree.data.time.TimeSeriesCollection(timeSeries22);
    timeSeriesCollection23.validateObject();
    java.lang.Comparable comparable25 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer26 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement19, (org.jfree.data.general.Dataset)timeSeriesCollection23, comparable25);
    org.jfree.data.DomainOrder domainOrder27 = timeSeriesCollection23.getDomainOrder();
    xYSeries10.removeChangeListener((org.jfree.data.general.SeriesChangeListener)timeSeriesCollection23);
    boolean b29 = dateRange5.equals((java.lang.Object)xYSeries10);
    java.util.Date date30 = dateRange5.getLowerDate();
    org.jfree.chart.block.RectangleConstraint rectangleConstraint32 = new org.jfree.chart.block.RectangleConstraint((org.jfree.data.Range)dateRange5, 3.421523046092185d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(date30);

  }

  @Test
  public void test014() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test014"); }


    org.jfree.chart.util.LogFormat logFormat3 = new org.jfree.chart.util.LogFormat(12.0d, "{0}: ({1}, {2})", true);
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer5 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d6 = xYBarRenderer5.getMargin();
    boolean b7 = xYBarRenderer5.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator9 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer5.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator9, true);
    java.text.NumberFormat numberFormat12 = standardXYToolTipGenerator9.getXFormat();
    java.text.NumberFormat numberFormat13 = java.text.NumberFormat.getIntegerInstance();
    java.util.Currency currency14 = numberFormat13.getCurrency();
    numberFormat12.setCurrency(currency14);
    // The following exception was thrown during execution in test generation
    try {
      logFormat3.setCurrency(currency14);
      org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException");
    } catch (java.lang.UnsupportedOperationException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.UnsupportedOperationException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(currency14);

  }

  @Test
  public void test015() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test015"); }


    java.util.TimeZone timeZone0 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection1 = new org.jfree.data.time.TimeSeriesCollection(timeZone0);
    org.jfree.chart.event.RendererChangeEvent rendererChangeEvent3 = new org.jfree.chart.event.RendererChangeEvent((java.lang.Object)timeSeriesCollection1, false);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number6 = timeSeriesCollection1.getStartY(10, 128);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test016() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test016"); }


    org.jfree.data.xy.XYSeries xYSeries1 = new org.jfree.data.xy.XYSeries((java.lang.Comparable)(-1.0f));
    xYSeries1.add(12.0d, (-1.0d), true);
    boolean b6 = xYSeries1.getAutoSort();
    xYSeries1.setKey((java.lang.Comparable)2);
    double d9 = xYSeries1.getMaxY();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d9 == (-1.0d));

  }

  @Test
  public void test017() {}
// Defects4J: flaky method
//   @Test
//   public void test017() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test017"); }
// 
// 
//     org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
//     org.jfree.chart.labels.ItemLabelPosition itemLabelPosition3 = xYAreaRenderer1.getSeriesNegativeItemLabelPosition(1);
//     org.jfree.chart.plot.CategoryPlot categoryPlot4 = new org.jfree.chart.plot.CategoryPlot();
//     boolean b5 = categoryPlot4.isRangeZoomable();
//     org.jfree.chart.util.RectangleEdge rectangleEdge7 = categoryPlot4.getDomainAxisEdge(8);
//     java.awt.Color color14 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
//     java.awt.Stroke stroke15 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
//     java.awt.Color color16 = java.awt.Color.orange;
//     java.awt.Stroke stroke17 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
//     org.jfree.chart.plot.IntervalMarker intervalMarker19 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color14, stroke15, (java.awt.Paint)color16, stroke17, 0.0f);
//     org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer20 = null;
//     intervalMarker19.setGradientPaintTransformer(gradientPaintTransformer20);
//     org.jfree.chart.util.RectangleInsets rectangleInsets22 = intervalMarker19.getLabelOffset();
//     org.jfree.chart.axis.CategoryAxis categoryAxis24 = new org.jfree.chart.axis.CategoryAxis("");
//     org.jfree.chart.util.RectangleInsets rectangleInsets25 = categoryAxis24.getLabelInsets();
//     intervalMarker19.setLabelOffset(rectangleInsets25);
//     double d27 = intervalMarker19.getEndValue();
//     org.jfree.chart.util.Layer layer28 = null;
//     boolean b29 = categoryPlot4.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker19, layer28);
//     xYAreaRenderer1.removeChangeListener((org.jfree.chart.event.RendererChangeListener)categoryPlot4);
//     org.jfree.chart.axis.ValueAxis valueAxis32 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot33 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis32);
//     java.util.List list34 = combinedDomainXYPlot33.getAnnotations();
//     combinedDomainXYPlot33.setRangeGridlinesVisible(true);
//     java.awt.Color color37 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
//     combinedDomainXYPlot33.setRangeTickBandPaint((java.awt.Paint)color37);
//     org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer40 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
//     org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator41 = xYAreaRenderer40.getLegendItemToolTipGenerator();
//     boolean b44 = xYAreaRenderer40.getItemVisible(10, 1);
//     org.jfree.chart.labels.ItemLabelPosition itemLabelPosition48 = xYAreaRenderer40.getPositiveItemLabelPosition(8, 10, false);
//     java.lang.Boolean b50 = xYAreaRenderer40.getSeriesCreateEntities(10);
//     org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator52 = xYAreaRenderer40.getSeriesToolTipGenerator(3);
//     java.awt.Font font54 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
//     org.jfree.data.general.WaferMapDataset waferMapDataset55 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot56 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset55);
//     org.jfree.chart.axis.ValueAxis valueAxis57 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot58 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis57);
//     java.util.List list59 = combinedDomainXYPlot58.getAnnotations();
//     waferMapPlot56.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot58);
//     boolean b61 = combinedDomainXYPlot58.isNotify();
//     org.jfree.chart.JFreeChart jFreeChart63 = new org.jfree.chart.JFreeChart("", font54, (org.jfree.chart.plot.Plot)combinedDomainXYPlot58, true);
//     xYAreaRenderer40.setBaseLegendTextFont(font54);
//     combinedDomainXYPlot33.setNoDataMessageFont(font54);
//     xYAreaRenderer1.setSeriesItemLabelFont(10, font54, false);
//     org.jfree.chart.labels.ItemLabelPosition itemLabelPosition71 = xYAreaRenderer1.getNegativeItemLabelPosition(2016, 40, false);
//     org.jfree.data.time.DateRange dateRange76 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d77 = dateRange76.getLength();
//     long long78 = dateRange76.getLowerMillis();
//     double d79 = dateRange76.getLength();
//     java.lang.String str80 = dateRange76.toString();
//     java.util.Date date81 = dateRange76.getUpperDate();
//     org.jfree.data.time.SerialDate serialDate82 = org.jfree.data.time.SerialDate.createInstance(date81);
//     java.lang.String str83 = serialDate82.toString();
//     org.jfree.data.time.SerialDate serialDate84 = org.jfree.data.time.SerialDate.addYears(1900, serialDate82);
//     org.jfree.data.time.SerialDate serialDate85 = org.jfree.data.time.SerialDate.addYears(0, serialDate82);
//     boolean b86 = itemLabelPosition71.equals((java.lang.Object)serialDate85);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(itemLabelPosition3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b5 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleEdge7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color16);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke17);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d27 == 0.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b29 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list34);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color37);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(xYSeriesLabelGenerator41);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b44 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(itemLabelPosition48);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(b50);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(xYToolTipGenerator52);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(font54);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list59);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b61 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(itemLabelPosition71);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d77 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long78 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d79 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str80 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str80.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date81);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(serialDate82);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str83 + "' != '" + "31-December-1969"+ "'", str83.equals("31-December-1969"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(serialDate84);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(serialDate85);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b86 == false);
// 
//   }

  @Test
  public void test018() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test018"); }


    org.jfree.chart.event.ChartChangeEventType chartChangeEventType0 = org.jfree.chart.event.ChartChangeEventType.GENERAL;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(chartChangeEventType0);

  }

  @Test
  public void test019() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test019"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Color color10 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke11 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color12 = java.awt.Color.orange;
    java.awt.Stroke stroke13 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker15 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color10, stroke11, (java.awt.Paint)color12, stroke13, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer16 = null;
    intervalMarker15.setGradientPaintTransformer(gradientPaintTransformer16);
    org.jfree.chart.util.RectangleInsets rectangleInsets18 = intervalMarker15.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis20 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets21 = categoryAxis20.getLabelInsets();
    intervalMarker15.setLabelOffset(rectangleInsets21);
    double d23 = intervalMarker15.getEndValue();
    org.jfree.chart.util.Layer layer24 = null;
    boolean b25 = categoryPlot0.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker15, layer24);
    boolean b26 = categoryPlot0.isRangeCrosshairLockedOnData();
    org.jfree.chart.plot.IntervalMarker intervalMarker30 = new org.jfree.chart.plot.IntervalMarker(5.0d, 1.0d);
    org.jfree.chart.util.LengthAdjustmentType lengthAdjustmentType31 = intervalMarker30.getLabelOffsetType();
    org.jfree.chart.util.Layer layer32 = null;
    boolean b34 = categoryPlot0.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker30, layer32, true);
    int i35 = categoryPlot0.getRangeAxisCount();
    org.jfree.chart.entity.EntityCollection entityCollection37 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo38 = new org.jfree.chart.ChartRenderingInfo(entityCollection37);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo39 = chartRenderingInfo38.getPlotInfo();
    java.awt.Color color45 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke46 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color47 = java.awt.Color.orange;
    java.awt.Stroke stroke48 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker50 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color45, stroke46, (java.awt.Paint)color47, stroke48, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer51 = null;
    intervalMarker50.setGradientPaintTransformer(gradientPaintTransformer51);
    org.jfree.chart.util.RectangleInsets rectangleInsets53 = intervalMarker50.getLabelOffset();
    org.jfree.chart.util.RectangleAnchor rectangleAnchor54 = org.jfree.chart.util.RectangleAnchor.LEFT;
    intervalMarker50.setLabelAnchor(rectangleAnchor54);
    boolean b56 = chartRenderingInfo38.equals((java.lang.Object)intervalMarker50);
    org.jfree.chart.util.Layer layer57 = org.jfree.chart.util.Layer.BACKGROUND;
    categoryPlot0.addRangeMarker((-435), (org.jfree.chart.plot.Marker)intervalMarker50, layer57, false);
    org.jfree.chart.util.Layer layer60 = org.jfree.chart.util.Layer.FOREGROUND;
    java.util.Collection collection61 = categoryPlot0.getRangeMarkers(layer60);
    org.jfree.chart.axis.ValueAxis valueAxis62 = null;
    categoryPlot0.setRangeAxis(valueAxis62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d23 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthAdjustmentType31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b34 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i35 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleAnchor54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b56 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(layer57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(layer60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection61);

  }

  @Test
  public void test020() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test020"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    org.jfree.chart.labels.StandardPieSectionLabelGenerator standardPieSectionLabelGenerator5 = new org.jfree.chart.labels.StandardPieSectionLabelGenerator("ERROR : Relative To String");
    piePlot3D2.setLegendLabelGenerator((org.jfree.chart.labels.PieSectionLabelGenerator)standardPieSectionLabelGenerator5);
    java.text.AttributedString attributedString8 = standardPieSectionLabelGenerator5.getAttributedLabel(0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(attributedString8);

  }

  @Test
  public void test021() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test021"); }


    org.jfree.data.time.SerialDate serialDate1 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.SerialDate serialDate2 = org.jfree.data.time.SerialDate.getNearestDayOfWeek(2, serialDate1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test022() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test022"); }


    java.awt.Font font3 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset4 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot5 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset4);
    org.jfree.chart.axis.ValueAxis valueAxis6 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot7 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis6);
    java.util.List list8 = combinedDomainXYPlot7.getAnnotations();
    waferMapPlot5.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot7);
    boolean b10 = combinedDomainXYPlot7.isNotify();
    org.jfree.chart.JFreeChart jFreeChart12 = new org.jfree.chart.JFreeChart("", font3, (org.jfree.chart.plot.Plot)combinedDomainXYPlot7, true);
    org.jfree.chart.title.TextTitle textTitle13 = new org.jfree.chart.title.TextTitle("", font3);
    textTitle13.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame16 = textTitle13.getFrame();
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment17 = textTitle13.getHorizontalAlignment();
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment18 = textTitle13.getTextAlignment();
    java.lang.Object obj19 = textTitle13.clone();
    org.jfree.chart.axis.NumberAxis3D numberAxis3D20 = new org.jfree.chart.axis.NumberAxis3D();
    org.jfree.data.Range range22 = null;
    org.jfree.chart.block.RectangleConstraint rectangleConstraint23 = new org.jfree.chart.block.RectangleConstraint(100.0d, range22);
    org.jfree.chart.block.LengthConstraintType lengthConstraintType24 = rectangleConstraint23.getWidthConstraintType();
    org.jfree.data.time.DateRange dateRange27 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange30 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b31 = dateRange27.intersects((org.jfree.data.Range)dateRange30);
    org.jfree.chart.block.RectangleConstraint rectangleConstraint32 = rectangleConstraint23.toRangeHeight((org.jfree.data.Range)dateRange30);
    numberAxis3D20.setDefaultAutoRange((org.jfree.data.Range)dateRange30);
    numberAxis3D20.resizeRange(0.2d);
    float f36 = numberAxis3D20.getMinorTickMarkOutsideLength();
    java.awt.Font font37 = numberAxis3D20.getTickLabelFont();
    textTitle13.setFont(font37);
    org.jfree.data.general.DefaultPieDataset defaultPieDataset39 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj40 = defaultPieDataset39.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D41 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset39);
    java.awt.Paint paint42 = piePlot3D41.getLabelShadowPaint();
    org.jfree.chart.labels.StandardPieSectionLabelGenerator standardPieSectionLabelGenerator44 = new org.jfree.chart.labels.StandardPieSectionLabelGenerator("ERROR : Relative To String");
    piePlot3D41.setLegendLabelGenerator((org.jfree.chart.labels.PieSectionLabelGenerator)standardPieSectionLabelGenerator44);
    java.awt.Font font49 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset50 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot51 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset50);
    org.jfree.chart.axis.ValueAxis valueAxis52 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot53 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis52);
    java.util.List list54 = combinedDomainXYPlot53.getAnnotations();
    waferMapPlot51.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot53);
    org.jfree.chart.JFreeChart jFreeChart57 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font49, (org.jfree.chart.plot.Plot)combinedDomainXYPlot53, true);
    java.awt.Color color61 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment62 = new org.jfree.chart.text.TextFragment("hi!", font49, (java.awt.Paint)color61);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer64 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier65 = xYAreaRenderer64.getDrawingSupplier();
    java.awt.Stroke stroke66 = xYAreaRenderer64.getBaseStroke();
    org.jfree.chart.plot.ValueMarker valueMarker67 = new org.jfree.chart.plot.ValueMarker(0.0d, (java.awt.Paint)color61, stroke66);
    org.jfree.chart.StandardChartTheme standardChartTheme69 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Paint paint70 = standardChartTheme69.getAxisLabelPaint();
    valueMarker67.setOutlinePaint(paint70);
    piePlot3D41.setLabelOutlinePaint(paint70);
    java.awt.Graphics2D graphics2D74 = null;
    org.jfree.chart.text.G2TextMeasurer g2TextMeasurer75 = new org.jfree.chart.text.G2TextMeasurer(graphics2D74);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.text.TextBlock textBlock76 = org.jfree.chart.text.TextUtilities.createTextBlock("java.awt.Color[r=128,g=128,b=128]", font37, paint70, (-1.0f), (org.jfree.chart.text.TextMeasurer)g2TextMeasurer75);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleConstraint32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f36 == 2.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint70);

  }

  @Test
  public void test023() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test023"); }


    java.lang.String str0 = org.jfree.chart.ui.Licences.GPL;

  }

  @Test
  public void test024() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test024"); }


    org.jfree.chart.plot.IntervalMarker intervalMarker2 = new org.jfree.chart.plot.IntervalMarker(5.0d, 1.0d);
    org.jfree.chart.util.LengthAdjustmentType lengthAdjustmentType3 = intervalMarker2.getLabelOffsetType();
    java.awt.Paint paint4 = intervalMarker2.getLabelPaint();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthAdjustmentType3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint4);

  }

  @Test
  public void test025() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test025"); }


    org.jfree.data.general.DatasetGroup datasetGroup1 = new org.jfree.data.general.DatasetGroup("RectangleAnchor.LEFT");
    java.lang.String str2 = datasetGroup1.getID();
    java.lang.String str3 = datasetGroup1.getID();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str2 + "' != '" + "RectangleAnchor.LEFT"+ "'", str2.equals("RectangleAnchor.LEFT"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str3 + "' != '" + "RectangleAnchor.LEFT"+ "'", str3.equals("RectangleAnchor.LEFT"));

  }

  @Test
  public void test026() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test026"); }


    org.jfree.chart.axis.SegmentedTimeline.FIRST_MONDAY_AFTER_1900 = (-2517120002L);

  }

  @Test
  public void test027() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test027"); }


    org.jfree.chart.labels.ItemLabelAnchor itemLabelAnchor0 = org.jfree.chart.labels.ItemLabelAnchor.OUTSIDE11;
    java.awt.Shape shape8 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color10 = java.awt.Color.green;
    java.awt.Color color12 = java.awt.Color.green;
    java.awt.Color color18 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke19 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color20 = java.awt.Color.orange;
    java.awt.Stroke stroke21 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker23 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color18, stroke19, (java.awt.Paint)color20, stroke21, 0.0f);
    java.awt.Shape shape27 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke28 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color29 = java.awt.Color.green;
    java.lang.String str30 = org.jfree.chart.util.PaintUtilities.colorToString(color29);
    org.jfree.chart.LegendItem legendItem31 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape8, true, (java.awt.Paint)color10, false, (java.awt.Paint)color12, stroke19, true, shape27, stroke28, (java.awt.Paint)color29);
    java.awt.Font font33 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset34 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot35 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset34);
    org.jfree.chart.axis.ValueAxis valueAxis36 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot37 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis36);
    java.util.List list38 = combinedDomainXYPlot37.getAnnotations();
    waferMapPlot35.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot37);
    boolean b40 = combinedDomainXYPlot37.isNotify();
    org.jfree.chart.JFreeChart jFreeChart42 = new org.jfree.chart.JFreeChart("", font33, (org.jfree.chart.plot.Plot)combinedDomainXYPlot37, true);
    java.awt.Stroke stroke43 = jFreeChart42.getBorderStroke();
    boolean b44 = jFreeChart42.isBorderVisible();
    java.awt.Image image45 = null;
    jFreeChart42.setBackgroundImage(image45);
    org.jfree.chart.entity.JFreeChartEntity jFreeChartEntity48 = new org.jfree.chart.entity.JFreeChartEntity(shape8, jFreeChart42, "hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!");
    org.jfree.data.xy.XYSeries xYSeries49 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection50 = new org.jfree.data.xy.XYSeriesCollection(xYSeries49);
    double d52 = xYSeriesCollection50.getDomainUpperBound(false);
    java.util.List list53 = xYSeriesCollection50.getSeries();
    jFreeChart42.setSubtitles(list53);
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent55 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)itemLabelAnchor0, jFreeChart42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelAnchor0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str30 + "' != '" + "green"+ "'", str30.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d52, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list53);

  }

  @Test
  public void test028() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test028"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = xYStepRenderer0.getSeriesPositiveItemLabelPosition(3);
    org.jfree.chart.axis.NumberAxis3D numberAxis3D3 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Color color4 = org.jfree.chart.ChartColor.VERY_LIGHT_GREEN;
    numberAxis3D3.setTickMarkPaint((java.awt.Paint)color4);
    boolean b6 = itemLabelPosition2.equals((java.lang.Object)numberAxis3D3);
    numberAxis3D3.setFixedAutoRange(11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);

  }

  @Test
  public void test029() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test029"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis0 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset1 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot2 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset1);
    org.jfree.chart.axis.ValueAxis valueAxis3 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot4 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis3);
    java.util.List list5 = combinedDomainXYPlot4.getAnnotations();
    waferMapPlot2.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot4);
    int i7 = combinedDomainXYPlot4.getSeriesCount();
    categoryAxis0.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot4);
    combinedDomainXYPlot4.zoom(1.0d);
    combinedDomainXYPlot4.setDomainZeroBaselineVisible(false);
    org.jfree.chart.util.RectangleEdge rectangleEdge13 = combinedDomainXYPlot4.getDomainAxisEdge();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge13);

  }

  @Test
  public void test030() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test030"); }


    org.jfree.chart.plot.DatasetRenderingOrder datasetRenderingOrder0 = org.jfree.chart.plot.DatasetRenderingOrder.FORWARD;
    java.lang.String str1 = datasetRenderingOrder0.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(datasetRenderingOrder0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "DatasetRenderingOrder.FORWARD"+ "'", str1.equals("DatasetRenderingOrder.FORWARD"));

  }

  @Test
  public void test031() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test031"); }


    org.jfree.data.xy.DefaultXYDataset defaultXYDataset0 = new org.jfree.data.xy.DefaultXYDataset();
    java.lang.Number number1 = org.jfree.data.general.DatasetUtilities.findMinimumDomainValue((org.jfree.data.xy.XYDataset)defaultXYDataset0);
    org.jfree.data.DomainOrder domainOrder2 = defaultXYDataset0.getDomainOrder();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(number1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder2);

  }

  @Test
  public void test032() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test032"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    categoryPlot0.clearDomainMarkers();
    org.jfree.chart.axis.NumberAxis numberAxis6 = new org.jfree.chart.axis.NumberAxis();
    numberAxis6.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer10 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator11 = xYAreaRenderer10.getLegendItemToolTipGenerator();
    java.awt.Shape shape12 = xYAreaRenderer10.getBaseShape();
    numberAxis6.setUpArrow(shape12);
    numberAxis6.pan((-1.0d));
    java.awt.Paint paint16 = numberAxis6.getAxisLinePaint();
    categoryPlot0.setRangeAxis(2, (org.jfree.chart.axis.ValueAxis)numberAxis6, false);
    org.jfree.chart.axis.NumberAxis numberAxis19 = new org.jfree.chart.axis.NumberAxis();
    numberAxis19.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer23 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator24 = xYAreaRenderer23.getLegendItemToolTipGenerator();
    java.awt.Shape shape25 = xYAreaRenderer23.getBaseShape();
    numberAxis19.setUpArrow(shape25);
    org.jfree.chart.StandardChartTheme standardChartTheme32 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.renderer.category.BarPainter barPainter33 = standardChartTheme32.getBarPainter();
    java.awt.Font font34 = standardChartTheme32.getLargeFont();
    org.jfree.chart.axis.MarkerAxisBand markerAxisBand35 = new org.jfree.chart.axis.MarkerAxisBand(numberAxis19, 0.2d, 12.0d, 0.0d, 4.5d, font34);
    numberAxis6.setMarkerBand(markerAxisBand35);
    java.awt.Graphics2D graphics2D37 = null;
    double d38 = markerAxisBand35.getHeight(graphics2D37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(barPainter33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d38 == 0.0d);

  }

  @Test
  public void test033() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test033"); }


    org.jfree.chart.axis.NumberAxis numberAxis0 = new org.jfree.chart.axis.NumberAxis();
    numberAxis0.centerRange(100.0d);
    float f3 = numberAxis0.getTickMarkInsideLength();
    numberAxis0.setUpperBound(0.0d);
    boolean b6 = numberAxis0.isTickMarksVisible();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f3 == 0.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);

  }

  @Test
  public void test034() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test034"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    java.awt.Shape shape33 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    legendItem30.setShape(shape33);
    java.lang.String str35 = legendItem30.getLabel();
    boolean b36 = legendItem30.isShapeOutlineVisible();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str35 + "' != '" + ""+ "'", str35.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);

  }

  @Test
  public void test035() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test035"); }


    java.awt.Paint paint1 = null;
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer3 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier4 = xYAreaRenderer3.getDrawingSupplier();
    java.awt.Stroke stroke5 = xYAreaRenderer3.getBaseStroke();
    java.awt.Color color11 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke12 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color13 = java.awt.Color.orange;
    java.awt.Stroke stroke14 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker16 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color11, stroke12, (java.awt.Paint)color13, stroke14, 0.0f);
    java.awt.Paint paint17 = intervalMarker16.getOutlinePaint();
    xYAreaRenderer3.setBaseLegendTextPaint(paint17);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer21 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator22 = xYAreaRenderer21.getLegendItemToolTipGenerator();
    boolean b25 = xYAreaRenderer21.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition29 = xYAreaRenderer21.getPositiveItemLabelPosition(8, 10, false);
    org.jfree.chart.plot.PlotOrientation plotOrientation30 = org.jfree.chart.plot.PlotOrientation.HORIZONTAL;
    boolean b31 = itemLabelPosition29.equals((java.lang.Object)plotOrientation30);
    xYAreaRenderer3.setSeriesNegativeItemLabelPosition(0, itemLabelPosition29);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer34 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier35 = xYAreaRenderer34.getDrawingSupplier();
    java.awt.Stroke stroke36 = xYAreaRenderer34.getBaseStroke();
    xYAreaRenderer3.setBaseOutlineStroke(stroke36, false);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.plot.ValueMarker valueMarker39 = new org.jfree.chart.plot.ValueMarker(0.6d, paint1, stroke36);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke36);

  }

  @Test
  public void test036() {}
// Defects4J: flaky method
//   @Test
//   public void test036() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test036"); }
// 
// 
//     org.jfree.data.time.Month month2 = new org.jfree.data.time.Month();
//     int i3 = month2.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem5 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month2, (java.lang.Number)8);
//     long long6 = month2.getFirstMillisecond();
//     org.jfree.data.time.Month month7 = new org.jfree.data.time.Month();
//     int i8 = month7.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis9 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month2, (org.jfree.data.time.RegularTimePeriod)month7);
//     float f10 = periodAxis9.getMinorTickMarkInsideLength();
//     java.util.Locale locale11 = periodAxis9.getLocale();
//     java.text.NumberFormat numberFormat12 = java.text.NumberFormat.getPercentInstance(locale11);
//     java.lang.ClassLoader classLoader13 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       java.util.ResourceBundle resourceBundle14 = java.util.ResourceBundle.getBundle("TextAnchor.TOP_CENTER", locale11, classLoader13);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i3 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long6 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i8 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f10 == 0.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(locale11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(numberFormat12);
// 
//   }

  @Test
  public void test037() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test037"); }


    org.jfree.chart.labels.StandardXYSeriesLabelGenerator standardXYSeriesLabelGenerator1 = new org.jfree.chart.labels.StandardXYSeriesLabelGenerator("Feb");

  }

  @Test
  public void test038() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test038"); }


    java.awt.Color color0 = org.jfree.chart.ChartColor.VERY_DARK_GREEN;
    float[] f_array1 = new float[] {  };
    // The following exception was thrown during execution in test generation
    try {
      float[] f_array2 = color0.getComponents(f_array1);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array1);

  }

  @Test
  public void test039() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test039"); }


    org.jfree.chart.block.LabelBlock labelBlock1 = new org.jfree.chart.block.LabelBlock("TextAnchor.CENTER");
    java.lang.Object obj2 = labelBlock1.clone();
    labelBlock1.setWidth(4.0d);
    java.lang.Object obj5 = labelBlock1.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj5);

  }

  @Test
  public void test040() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test040"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = xYStepRenderer0.getSeriesPositiveItemLabelPosition(3);
    boolean b3 = xYStepRenderer0.getDrawSeriesLineAsPath();
    xYStepRenderer0.setStepPoint(0.5d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test041() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test041"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    org.jfree.data.category.CategoryDataset categoryDataset2 = null;
    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot3 = new org.jfree.chart.plot.MultiplePiePlot(categoryDataset2);
    combinedDomainXYPlot1.setParent((org.jfree.chart.plot.Plot)multiplePiePlot3);
    java.awt.Shape shape5 = multiplePiePlot3.getLegendItemShape();
    org.jfree.data.category.CategoryDataset categoryDataset6 = multiplePiePlot3.getDataset();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryDataset6);

  }

  @Test
  public void test042() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test042"); }


    java.awt.Color color0 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.lang.String str1 = org.jfree.chart.util.PaintUtilities.colorToString(color0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test043() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test043"); }


    org.jfree.chart.util.LogFormat logFormat3 = new org.jfree.chart.util.LogFormat(12.0d, "{0}: ({1}, {2})", true);
    logFormat3.setMaximumFractionDigits(2);

  }

  @Test
  public void test044() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test044"); }


    org.jfree.chart.ui.BasicProjectInfo basicProjectInfo5 = new org.jfree.chart.ui.BasicProjectInfo("index.html", "PlotOrientation.HORIZONTAL", "series", "", "GradientPaintTransformType.CENTER_VERTICAL");

  }

  @Test
  public void test045() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test045"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    piePlot3D2.setStartAngle(Double.NaN);
    org.jfree.data.general.DefaultPieDataset defaultPieDataset5 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj6 = defaultPieDataset5.clone();
    double d7 = org.jfree.data.general.DatasetUtilities.calculatePieDatasetTotal((org.jfree.data.general.PieDataset)defaultPieDataset5);
    piePlot3D2.setDataset((org.jfree.data.general.PieDataset)defaultPieDataset5);
    org.jfree.chart.util.Rotation rotation9 = piePlot3D2.getDirection();
    org.jfree.chart.axis.ValueAxis valueAxis11 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot12 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis11);
    java.util.List list13 = combinedDomainXYPlot12.getAnnotations();
    combinedDomainXYPlot12.setRangeGridlinesVisible(true);
    org.jfree.chart.axis.AxisSpace axisSpace16 = null;
    combinedDomainXYPlot12.setFixedRangeAxisSpace(axisSpace16);
    org.jfree.data.xy.XYDataset xYDataset19 = combinedDomainXYPlot12.getDataset(40);
    org.jfree.chart.StandardChartTheme standardChartTheme21 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Paint paint22 = standardChartTheme21.getAxisLabelPaint();
    java.awt.Font font23 = standardChartTheme21.getLargeFont();
    combinedDomainXYPlot12.setNoDataMessageFont(font23);
    org.jfree.data.general.WaferMapDataset waferMapDataset25 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot26 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset25);
    org.jfree.chart.axis.ValueAxis valueAxis27 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot28 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis27);
    java.util.List list29 = combinedDomainXYPlot28.getAnnotations();
    waferMapPlot26.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot28);
    boolean b31 = combinedDomainXYPlot28.isNotify();
    org.jfree.chart.util.Layer layer32 = null;
    java.util.Collection collection33 = combinedDomainXYPlot28.getDomainMarkers(layer32);
    org.jfree.chart.LegendItemCollection legendItemCollection34 = combinedDomainXYPlot28.getLegendItems();
    org.jfree.chart.JFreeChart jFreeChart36 = new org.jfree.chart.JFreeChart("ClassContext", font23, (org.jfree.chart.plot.Plot)combinedDomainXYPlot28, false);
    boolean b37 = piePlot3D2.equals((java.lang.Object)"ClassContext");
    java.awt.Color color38 = java.awt.Color.LIGHT_GRAY;
    boolean b39 = piePlot3D2.equals((java.lang.Object)color38);
    java.awt.Stroke stroke40 = piePlot3D2.getLabelOutlineStroke();
    java.awt.Stroke stroke41 = piePlot3D2.getLabelOutlineStroke();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rotation9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYDataset19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke41);

  }

  @Test
  public void test046() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test046"); }


    org.jfree.chart.plot.CrosshairState crosshairState0 = new org.jfree.chart.plot.CrosshairState();
    crosshairState0.updateCrosshairY((-1.0d), 14);
    crosshairState0.updateCrosshairY(1.0E-8d, 10);
    int i7 = crosshairState0.getRangeAxisIndex();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 0);

  }

  @Test
  public void test047() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test047"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer13 = null;
    combinedDomainXYPlot5.setRenderer(xYItemRenderer13);
    boolean b15 = combinedDomainXYPlot5.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries16 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection17 = new org.jfree.data.time.TimeSeriesCollection(timeSeries16);
    combinedDomainXYPlot5.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    java.util.List list19 = timeSeriesCollection17.getSeries();
    org.jfree.data.Range range20 = org.jfree.data.general.DatasetUtilities.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    org.jfree.data.DomainOrder domainOrder21 = timeSeriesCollection17.getDomainOrder();
    double d23 = timeSeriesCollection17.getDomainUpperBound(false);
    org.jfree.data.Range range24 = org.jfree.data.general.DatasetUtilities.iterateDomainBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d23, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range24);

  }

  @Test
  public void test048() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test048"); }


    org.jfree.data.xy.XYSeries xYSeries0 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection1 = new org.jfree.data.xy.XYSeriesCollection(xYSeries0);
    boolean b2 = xYSeriesCollection1.isAutoWidth();
    org.jfree.data.Range range4 = xYSeriesCollection1.getRangeBounds(true);
    xYSeriesCollection1.setIntervalWidth(1.0d);
    org.jfree.data.xy.XYSeries xYSeries10 = new org.jfree.data.xy.XYSeries((java.lang.Comparable)10.0d, false, false);
    xYSeriesCollection1.removeSeries(xYSeries10);
    xYSeriesCollection1.setAutoWidth(true);
    xYSeriesCollection1.validateObject();
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number17 = xYSeriesCollection1.getY(4, 9999);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range4);

  }

  @Test
  public void test049() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test049"); }


    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer1 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(2016);

  }

  @Test
  public void test050() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test050"); }


    org.jfree.data.xy.XYSeries xYSeries1 = new org.jfree.data.xy.XYSeries((java.lang.Comparable)(-1.0f));
    java.lang.String str2 = xYSeries1.getDescription();
    java.awt.Font font4 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset5 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot6 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset5);
    org.jfree.chart.axis.ValueAxis valueAxis7 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot8 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis7);
    java.util.List list9 = combinedDomainXYPlot8.getAnnotations();
    waferMapPlot6.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot8);
    boolean b11 = combinedDomainXYPlot8.isNotify();
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("", font4, (org.jfree.chart.plot.Plot)combinedDomainXYPlot8, true);
    boolean b14 = combinedDomainXYPlot8.isRangeZoomable();
    java.awt.Image image15 = combinedDomainXYPlot8.getBackgroundImage();
    java.awt.Paint paint16 = combinedDomainXYPlot8.getRangeMinorGridlinePaint();
    boolean b17 = xYSeries1.equals((java.lang.Object)paint16);
    boolean b18 = xYSeries1.getNotify();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(image15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == true);

  }

  @Test
  public void test051() {}
// Defects4J: flaky method
//   @Test
//   public void test051() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test051"); }
// 
// 
//     org.jfree.data.time.Month month2 = new org.jfree.data.time.Month();
//     int i3 = month2.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem5 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month2, (java.lang.Number)8);
//     long long6 = month2.getFirstMillisecond();
//     org.jfree.data.time.Month month7 = new org.jfree.data.time.Month();
//     int i8 = month7.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis9 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month2, (org.jfree.data.time.RegularTimePeriod)month7);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod10 = month2.next();
//     java.util.TimeZone timeZone12 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.chart.axis.DateAxis dateAxis13 = new org.jfree.chart.axis.DateAxis("", timeZone12);
//     org.jfree.data.time.DateRange dateRange16 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d17 = dateRange16.getLength();
//     long long18 = dateRange16.getLowerMillis();
//     java.util.Date date19 = dateRange16.getLowerDate();
//     java.util.Date date20 = dateRange16.getLowerDate();
//     dateAxis13.setMaximumDate(date20);
//     org.jfree.data.time.Year year22 = new org.jfree.data.time.Year(date20);
//     org.jfree.data.time.DateRange dateRange26 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d27 = dateRange26.getLength();
//     long long28 = dateRange26.getLowerMillis();
//     double d29 = dateRange26.getLength();
//     java.lang.String str30 = dateRange26.toString();
//     java.util.Date date31 = dateRange26.getUpperDate();
//     java.util.TimeZone timeZone32 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year33 = new org.jfree.data.time.Year(date31, timeZone32);
//     org.jfree.chart.axis.DateAxis dateAxis34 = new org.jfree.chart.axis.DateAxis("SerialDate.weekInMonthToString(): invalid code.", timeZone32);
//     java.util.Locale locale35 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       org.jfree.chart.axis.PeriodAxis periodAxis36 = new org.jfree.chart.axis.PeriodAxis("ThreadContext", (org.jfree.data.time.RegularTimePeriod)month2, (org.jfree.data.time.RegularTimePeriod)year22, timeZone32, locale35);
//       org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
//     } catch (java.lang.IllegalArgumentException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i3 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long6 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i8 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d17 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long18 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date19);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date20);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d27 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long28 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d29 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str30 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str30.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date31);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone32);
// 
//   }

  @Test
  public void test052() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test052"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    java.util.List list2 = combinedDomainXYPlot1.getAnnotations();
    combinedDomainXYPlot1.setRangeGridlinesVisible(true);
    java.awt.Color color5 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    combinedDomainXYPlot1.setRangeTickBandPaint((java.awt.Paint)color5);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer8 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator9 = xYAreaRenderer8.getLegendItemToolTipGenerator();
    boolean b12 = xYAreaRenderer8.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition16 = xYAreaRenderer8.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b18 = xYAreaRenderer8.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator20 = xYAreaRenderer8.getSeriesToolTipGenerator(3);
    java.awt.Font font22 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset23 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot24 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset23);
    org.jfree.chart.axis.ValueAxis valueAxis25 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot26 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis25);
    java.util.List list27 = combinedDomainXYPlot26.getAnnotations();
    waferMapPlot24.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot26);
    boolean b29 = combinedDomainXYPlot26.isNotify();
    org.jfree.chart.JFreeChart jFreeChart31 = new org.jfree.chart.JFreeChart("", font22, (org.jfree.chart.plot.Plot)combinedDomainXYPlot26, true);
    xYAreaRenderer8.setBaseLegendTextFont(font22);
    combinedDomainXYPlot1.setNoDataMessageFont(font22);
    combinedDomainXYPlot1.setRangeCrosshairVisible(true);
    boolean b36 = combinedDomainXYPlot1.isOutlineVisible();
    java.awt.Paint paint37 = combinedDomainXYPlot1.getRangeMinorGridlinePaint();
    boolean b38 = combinedDomainXYPlot1.isRangeZeroBaselineVisible();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYToolTipGenerator20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == false);

  }

  @Test
  public void test053() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test053"); }


    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator1 = null;
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator3 = new org.jfree.chart.urls.StandardXYURLGenerator("");
    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer4 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(100, xYToolTipGenerator1, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator3);
    xYStepAreaRenderer4.setPlotArea(true);
    org.jfree.chart.annotations.XYAnnotation xYAnnotation7 = null;
    boolean b8 = xYStepAreaRenderer4.removeAnnotation(xYAnnotation7);
    boolean b9 = xYStepAreaRenderer4.isShapesFilled();
    xYStepAreaRenderer4.setSeriesVisible(1, (java.lang.Boolean)true, true);
    org.jfree.chart.labels.XYItemLabelGenerator xYItemLabelGenerator15 = xYStepAreaRenderer4.getSeriesItemLabelGenerator(7);
    org.jfree.chart.LegendItemCollection legendItemCollection16 = xYStepAreaRenderer4.getLegendItems();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYItemLabelGenerator15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection16);

  }

  @Test
  public void test054() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test054"); }


    org.jfree.chart.axis.DateTickUnitType dateTickUnitType0 = org.jfree.chart.axis.DateTickUnitType.MONTH;
    org.jfree.chart.axis.DateTickUnitType dateTickUnitType2 = org.jfree.chart.axis.DateTickUnitType.MINUTE;
    org.jfree.chart.axis.DateTickUnitType dateTickUnitType4 = org.jfree.chart.axis.DateTickUnitType.MONTH;
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer7 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d8 = xYBarRenderer7.getMargin();
    boolean b9 = xYBarRenderer7.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator11 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer7.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator11, true);
    java.lang.Object obj14 = standardXYToolTipGenerator11.clone();
    java.text.DateFormat dateFormat15 = standardXYToolTipGenerator11.getXDateFormat();
    org.jfree.chart.axis.DateTickUnit dateTickUnit16 = new org.jfree.chart.axis.DateTickUnit(dateTickUnitType2, 5, dateTickUnitType4, 4, dateFormat15);
    org.jfree.chart.axis.DateTickUnitType dateTickUnitType18 = org.jfree.chart.axis.DateTickUnitType.MINUTE;
    org.jfree.chart.axis.DateTickUnitType dateTickUnitType20 = org.jfree.chart.axis.DateTickUnitType.MONTH;
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer23 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d24 = xYBarRenderer23.getMargin();
    boolean b25 = xYBarRenderer23.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator27 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer23.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator27, true);
    java.lang.Object obj30 = standardXYToolTipGenerator27.clone();
    java.text.DateFormat dateFormat31 = standardXYToolTipGenerator27.getXDateFormat();
    org.jfree.chart.axis.DateTickUnit dateTickUnit32 = new org.jfree.chart.axis.DateTickUnit(dateTickUnitType18, 5, dateTickUnitType20, 4, dateFormat31);
    org.jfree.chart.axis.DateTickUnit dateTickUnit33 = new org.jfree.chart.axis.DateTickUnit(dateTickUnitType0, 2016, dateTickUnitType2, 7, dateFormat31);
    org.jfree.chart.util.ObjectList objectList34 = new org.jfree.chart.util.ObjectList();
    java.lang.Object obj35 = objectList34.clone();
    boolean b36 = dateTickUnit33.equals(obj35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateTickUnitType0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateTickUnitType2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateTickUnitType4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateFormat15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateTickUnitType18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateTickUnitType20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d24 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateFormat31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);

  }

  @Test
  public void test055() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test055"); }


    org.jfree.chart.block.LabelBlock labelBlock1 = new org.jfree.chart.block.LabelBlock("TextAnchor.CENTER");
    java.awt.Paint paint2 = labelBlock1.getPaint();
    labelBlock1.setURLText("");
    java.awt.Graphics2D graphics2D5 = null;
    org.jfree.data.time.DateRange dateRange8 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange11 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b12 = dateRange8.intersects((org.jfree.data.Range)dateRange11);
    org.jfree.data.Range range14 = org.jfree.data.Range.expandToInclude((org.jfree.data.Range)dateRange8, 1.0d);
    org.jfree.data.Range range16 = org.jfree.data.Range.scale((org.jfree.data.Range)dateRange8, 0.0d);
    org.jfree.chart.block.RectangleConstraint rectangleConstraint18 = new org.jfree.chart.block.RectangleConstraint((org.jfree.data.Range)dateRange8, 7.0d);
    org.jfree.chart.block.LengthConstraintType lengthConstraintType19 = rectangleConstraint18.getWidthConstraintType();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.util.Size2D size2D20 = labelBlock1.arrange(graphics2D5, rectangleConstraint18);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType19);

  }

  @Test
  public void test056() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test056"); }


    java.awt.Color color5 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke6 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color7 = java.awt.Color.orange;
    java.awt.Stroke stroke8 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker10 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color5, stroke6, (java.awt.Paint)color7, stroke8, 0.0f);
    org.jfree.chart.util.LengthAdjustmentType lengthAdjustmentType11 = intervalMarker10.getLabelOffsetType();
    java.awt.Paint paint12 = intervalMarker10.getPaint();
    double d13 = intervalMarker10.getEndValue();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthAdjustmentType11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d13 == 0.0d);

  }

  @Test
  public void test057() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test057"); }


    org.jfree.data.time.TimeSeries timeSeries3 = new org.jfree.data.time.TimeSeries((java.lang.Comparable)"hi!", "AxisLocation.TOP_OR_RIGHT", "SeriesRenderingOrder.FORWARD");
    java.util.Collection collection4 = timeSeries3.getTimePeriods();
    double d5 = timeSeries3.getMinY();
    java.lang.Object obj6 = timeSeries3.clone();
    java.lang.Object obj7 = timeSeries3.clone();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem9 = timeSeries3.getDataItem(15);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(collection4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d5, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj7);

  }

  @Test
  public void test058() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test058"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    java.awt.Shape shape33 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    legendItem30.setShape(shape33);
    org.jfree.data.general.Dataset dataset35 = null;
    legendItem30.setDataset(dataset35);
    legendItem30.setURLText("TextAnchor.CENTER");
    org.jfree.data.general.DefaultPieDataset defaultPieDataset39 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj40 = defaultPieDataset39.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D41 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset39);
    java.awt.Paint paint42 = piePlot3D41.getLabelShadowPaint();
    legendItem30.setLinePaint(paint42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint42);

  }

  @Test
  public void test059() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test059"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    categoryPlot0.clearDomainMarkers();
    org.jfree.chart.axis.NumberAxis numberAxis6 = new org.jfree.chart.axis.NumberAxis();
    numberAxis6.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer10 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator11 = xYAreaRenderer10.getLegendItemToolTipGenerator();
    java.awt.Shape shape12 = xYAreaRenderer10.getBaseShape();
    numberAxis6.setUpArrow(shape12);
    numberAxis6.pan((-1.0d));
    java.awt.Paint paint16 = numberAxis6.getAxisLinePaint();
    categoryPlot0.setRangeAxis(2, (org.jfree.chart.axis.ValueAxis)numberAxis6, false);
    boolean b19 = categoryPlot0.isDomainPannable();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);

  }

  @Test
  public void test060() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test060"); }


    org.jfree.chart.axis.NumberAxis numberAxis0 = new org.jfree.chart.axis.NumberAxis();
    numberAxis0.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer4 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator5 = xYAreaRenderer4.getLegendItemToolTipGenerator();
    java.awt.Shape shape6 = xYAreaRenderer4.getBaseShape();
    numberAxis0.setUpArrow(shape6);
    numberAxis0.pan((-1.0d));
    numberAxis0.setVisible(false);
    numberAxis0.setRangeAboutValue(3.0d, 0.0d);
    numberAxis0.setAutoRangeStickyZero(true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape6);

  }

  @Test
  public void test061() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test061"); }


    org.jfree.chart.labels.StandardPieToolTipGenerator standardPieToolTipGenerator1 = new org.jfree.chart.labels.StandardPieToolTipGenerator("WMAP_Plot");

  }

  @Test
  public void test062() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test062"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    org.jfree.chart.JFreeChart jFreeChart9 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    org.jfree.chart.axis.NumberAxis numberAxis11 = new org.jfree.chart.axis.NumberAxis();
    numberAxis11.centerRange(100.0d);
    combinedDomainXYPlot5.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis11);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier15 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot5.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier15);
    java.lang.String str17 = combinedDomainXYPlot5.getPlotType();
    java.awt.Paint paint18 = combinedDomainXYPlot5.getRangeMinorGridlinePaint();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer20 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator21 = xYAreaRenderer20.getLegendItemToolTipGenerator();
    java.awt.Shape shape22 = xYAreaRenderer20.getBaseShape();
    xYAreaRenderer20.setSeriesVisibleInLegend(10, (java.lang.Boolean)false, true);
    java.awt.Paint paint28 = xYAreaRenderer20.getSeriesFillPaint(10);
    org.jfree.chart.labels.StandardXYSeriesLabelGenerator standardXYSeriesLabelGenerator30 = new org.jfree.chart.labels.StandardXYSeriesLabelGenerator("");
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D32 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.geom.Rectangle2D rectangle2D38 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge39 = null;
    double d40 = categoryAxis3D32.getCategorySeriesMiddle((-1), 255, (-1), 0, 0.0d, rectangle2D38, rectangleEdge39);
    boolean b41 = standardXYSeriesLabelGenerator30.equals((java.lang.Object)rectangle2D38);
    xYAreaRenderer20.setLegendItemURLGenerator((org.jfree.chart.labels.XYSeriesLabelGenerator)standardXYSeriesLabelGenerator30);
    combinedDomainXYPlot5.setRenderer((org.jfree.chart.renderer.xy.XYItemRenderer)xYAreaRenderer20);
    org.jfree.chart.block.LabelBlock labelBlock45 = new org.jfree.chart.block.LabelBlock("TextAnchor.CENTER");
    java.awt.Font font46 = labelBlock45.getFont();
    xYAreaRenderer20.setBaseItemLabelFont(font46, true);
    org.jfree.chart.LegendItem legendItem51 = xYAreaRenderer20.getLegendItem(2147483647, 2147483647);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str17 + "' != '" + "Combined_Domain_XYPlot"+ "'", str17.equals("Combined_Domain_XYPlot"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d40, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(legendItem51);

  }

  @Test
  public void test063() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test063"); }


    org.jfree.data.time.TimeSeries timeSeries3 = new org.jfree.data.time.TimeSeries((java.lang.Comparable)"hi!", "AxisLocation.TOP_OR_RIGHT", "SeriesRenderingOrder.FORWARD");
    int i4 = timeSeries3.getMaximumItemCount();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer6 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator7 = xYAreaRenderer6.getLegendItemToolTipGenerator();
    boolean b10 = xYAreaRenderer6.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition14 = xYAreaRenderer6.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b16 = xYAreaRenderer6.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator17 = null;
    xYAreaRenderer6.setBaseToolTipGenerator(xYToolTipGenerator17, true);
    java.awt.Shape shape21 = xYAreaRenderer6.lookupLegendShape(3);
    java.awt.Shape shape23 = xYAreaRenderer6.getLegendShape(10);
    org.jfree.data.time.TimeSeries timeSeries24 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection25 = new org.jfree.data.time.TimeSeriesCollection(timeSeries24);
    timeSeriesCollection25.validateObject();
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent27 = null;
    timeSeriesCollection25.seriesChanged(seriesChangeEvent27);
    org.jfree.data.Range range29 = xYAreaRenderer6.findDomainBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection25);
    org.jfree.data.Range range31 = timeSeriesCollection25.getDomainBounds(false);
    org.jfree.data.time.TimeSeries timeSeries35 = new org.jfree.data.time.TimeSeries((java.lang.Comparable)"hi!", "AxisLocation.TOP_OR_RIGHT", "SeriesRenderingOrder.FORWARD");
    int i36 = timeSeries35.getMaximumItemCount();
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection37 = new org.jfree.data.time.TimeSeriesCollection(timeSeries35);
    timeSeriesCollection25.removeSeries(timeSeries35);
    org.jfree.data.time.TimeSeries timeSeries39 = timeSeries3.addAndOrUpdate(timeSeries35);
    // The following exception was thrown during execution in test generation
    try {
      timeSeries39.update(8, (java.lang.Number)100);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 2147483647);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(shape23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i36 == 2147483647);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(timeSeries39);

  }

  @Test
  public void test064() {}
// Defects4J: flaky method
//   @Test
//   public void test064() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test064"); }
// 
// 
//     org.jfree.data.category.CategoryDataset categoryDataset0 = null;
//     org.jfree.data.time.Month month1 = new org.jfree.data.time.Month();
//     int i2 = month1.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem4 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month1, 11.0d);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod5 = month1.previous();
//     long long6 = month1.getLastMillisecond();
//     // The following exception was thrown during execution in test generation
//     try {
//       org.jfree.data.general.PieDataset pieDataset7 = org.jfree.data.general.DatasetUtilities.createPieDatasetForColumn(categoryDataset0, (java.lang.Comparable)month1);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i2 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long6 == 1456819199999L);
// 
//   }

  @Test
  public void test065() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test065"); }


    org.jfree.chart.util.RectangleAnchor rectangleAnchor0 = org.jfree.chart.util.RectangleAnchor.TOP;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleAnchor0);

  }

  @Test
  public void test066() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test066"); }


    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator1 = null;
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator3 = new org.jfree.chart.urls.StandardXYURLGenerator("");
    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer4 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(100, xYToolTipGenerator1, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator3);
    xYStepAreaRenderer4.setPlotArea(true);
    org.jfree.chart.annotations.XYAnnotation xYAnnotation7 = null;
    boolean b8 = xYStepAreaRenderer4.removeAnnotation(xYAnnotation7);
    boolean b9 = xYStepAreaRenderer4.isShapesFilled();
    java.awt.Paint paint13 = xYStepAreaRenderer4.getItemFillPaint(5, 40, false);
    boolean b14 = xYStepAreaRenderer4.getPlotArea();
    xYStepAreaRenderer4.setPlotArea(true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);

  }

  @Test
  public void test067() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test067"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(0.05d);
    double d2 = xYBarRenderer1.getBase();
    java.awt.Paint paint6 = xYBarRenderer1.getItemFillPaint(12, 1900, false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint6);

  }

  @Test
  public void test068() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test068"); }


    java.lang.Number[] number_array2 = null;
    java.lang.Number[][] number_array_array3 = new java.lang.Number[][] { number_array2 };
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.category.CategoryDataset categoryDataset4 = org.jfree.data.general.DatasetUtilities.createCategoryDataset("", "TitleEntity: tooltip = green", number_array_array3);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(number_array_array3);

  }

  @Test
  public void test069() {}
// Defects4J: flaky method
//   @Test
//   public void test069() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test069"); }
// 
// 
//     org.jfree.data.time.Month month1 = new org.jfree.data.time.Month();
//     int i2 = month1.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem4 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month1, (java.lang.Number)8);
//     long long5 = month1.getFirstMillisecond();
//     org.jfree.data.time.Month month6 = new org.jfree.data.time.Month();
//     int i7 = month6.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis8 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month1, (org.jfree.data.time.RegularTimePeriod)month6);
//     org.jfree.chart.axis.PeriodAxisLabelInfo[] periodAxisLabelInfo_array9 = periodAxis8.getLabelInfo();
//     periodAxis8.setMinorTickMarksVisible(true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i2 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i7 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(periodAxisLabelInfo_array9);
// 
//   }

  @Test
  public void test070() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test070"); }


    org.jfree.chart.renderer.xy.XYLineAndShapeRenderer xYLineAndShapeRenderer0 = new org.jfree.chart.renderer.xy.XYLineAndShapeRenderer();

  }

  @Test
  public void test071() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test071"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    java.awt.Color color11 = java.awt.Color.RED;
    legendTitle10.setBackgroundPaint((java.awt.Paint)color11);
    org.jfree.chart.block.BlockContainer blockContainer13 = legendTitle10.getItemContainer();
    org.jfree.chart.block.BlockContainer blockContainer14 = legendTitle10.getWrapper();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockContainer13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(blockContainer14);

  }

  @Test
  public void test072() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test072"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    boolean b31 = legendItem30.isShapeOutlineVisible();
    boolean b33 = legendItem30.equals((java.lang.Object)(short)1);
    java.awt.Paint paint34 = legendItem30.getFillPaint();
    legendItem30.setShapeVisible(true);
    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot37 = new org.jfree.chart.plot.MultiplePiePlot();
    java.awt.Paint paint38 = multiplePiePlot37.getOutlinePaint();
    java.awt.Shape shape39 = multiplePiePlot37.getLegendItemShape();
    legendItem30.setLine(shape39);
    java.awt.Font font44 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset45 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot46 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset45);
    org.jfree.chart.axis.ValueAxis valueAxis47 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot48 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis47);
    java.util.List list49 = combinedDomainXYPlot48.getAnnotations();
    waferMapPlot46.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot48);
    org.jfree.chart.JFreeChart jFreeChart52 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font44, (org.jfree.chart.plot.Plot)combinedDomainXYPlot48, true);
    java.awt.Color color56 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment57 = new org.jfree.chart.text.TextFragment("hi!", font44, (java.awt.Paint)color56);
    java.awt.Paint paint58 = org.jfree.chart.plot.PiePlot.DEFAULT_LABEL_OUTLINE_PAINT;
    org.jfree.chart.plot.CategoryPlot categoryPlot59 = new org.jfree.chart.plot.CategoryPlot();
    boolean b60 = categoryPlot59.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge62 = categoryPlot59.getDomainAxisEdge(8);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment63 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment64 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement67 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment63, verticalAlignment64, 11.0d, 0.2d);
    org.jfree.chart.util.VerticalAlignment verticalAlignment68 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement71 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment63, verticalAlignment68, (-1.0d), Double.NaN);
    org.jfree.chart.util.VerticalAlignment verticalAlignment72 = org.jfree.chart.title.Title.DEFAULT_VERTICAL_ALIGNMENT;
    org.jfree.chart.util.RectangleInsets rectangleInsets73 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent74 = new org.jfree.data.general.SeriesChangeEvent((java.lang.Object)rectangleInsets73);
    org.jfree.chart.title.TextTitle textTitle75 = new org.jfree.chart.title.TextTitle("March", font44, paint58, rectangleEdge62, horizontalAlignment63, verticalAlignment72, rectangleInsets73);
    legendItem30.setFillPaint(paint58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b60 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(verticalAlignment72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets73);

  }

  @Test
  public void test073() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test073"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    org.jfree.chart.util.Layer layer23 = null;
    boolean b25 = combinedDomainXYPlot5.removeDomainMarker(2, (org.jfree.chart.plot.Marker)intervalMarker22, layer23, false);
    org.jfree.chart.plot.SeriesRenderingOrder seriesRenderingOrder26 = combinedDomainXYPlot5.getSeriesRenderingOrder();
    org.jfree.chart.axis.CategoryAxis categoryAxis27 = new org.jfree.chart.axis.CategoryAxis();
    categoryAxis27.setVisible(false);
    org.jfree.chart.util.RectangleInsets rectangleInsets30 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d31 = rectangleInsets30.getLeft();
    double d33 = rectangleInsets30.calculateLeftOutset(1.0d);
    categoryAxis27.setLabelInsets(rectangleInsets30, true);
    combinedDomainXYPlot5.setAxisOffset(rectangleInsets30);
    double d38 = rectangleInsets30.extendHeight(299994.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(seriesRenderingOrder26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d31 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d33 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d38 == 300002.0d);

  }

  @Test
  public void test074() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test074"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    boolean b5 = xYAreaRenderer1.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition9 = xYAreaRenderer1.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b11 = xYAreaRenderer1.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator12 = null;
    xYAreaRenderer1.setBaseToolTipGenerator(xYToolTipGenerator12, true);
    java.awt.Shape shape16 = xYAreaRenderer1.lookupLegendShape(3);
    java.awt.Shape shape18 = xYAreaRenderer1.getLegendShape(10);
    org.jfree.data.time.TimeSeries timeSeries19 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection20 = new org.jfree.data.time.TimeSeriesCollection(timeSeries19);
    timeSeriesCollection20.validateObject();
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent22 = null;
    timeSeriesCollection20.seriesChanged(seriesChangeEvent22);
    org.jfree.data.Range range24 = xYAreaRenderer1.findDomainBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection20);
    org.jfree.data.Range range26 = timeSeriesCollection20.getDomainBounds(false);
    org.jfree.data.time.TimeSeries timeSeries30 = new org.jfree.data.time.TimeSeries((java.lang.Comparable)"hi!", "AxisLocation.TOP_OR_RIGHT", "SeriesRenderingOrder.FORWARD");
    int i31 = timeSeries30.getMaximumItemCount();
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection32 = new org.jfree.data.time.TimeSeriesCollection(timeSeries30);
    timeSeriesCollection20.removeSeries(timeSeries30);
    int i34 = timeSeriesCollection20.getSeriesCount();
    // The following exception was thrown during execution in test generation
    try {
      double d37 = timeSeriesCollection20.getEndXValue(1, 0);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(shape18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i31 == 2147483647);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i34 == 0);

  }

  @Test
  public void test075() {}
// Defects4J: flaky method
//   @Test
//   public void test075() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test075"); }
// 
// 
//     org.jfree.data.DefaultKeyedValues defaultKeyedValues0 = new org.jfree.data.DefaultKeyedValues();
//     org.jfree.data.time.DateRange dateRange3 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d4 = dateRange3.getLength();
//     long long5 = dateRange3.getLowerMillis();
//     double d6 = dateRange3.getLength();
//     java.lang.String str7 = dateRange3.toString();
//     java.util.Date date8 = dateRange3.getUpperDate();
//     org.jfree.data.time.SerialDate serialDate9 = org.jfree.data.time.SerialDate.createInstance(date8);
//     org.jfree.data.time.Month month10 = new org.jfree.data.time.Month(date8);
//     defaultKeyedValues0.setValue((java.lang.Comparable)month10, 90.0d);
//     int i14 = defaultKeyedValues0.getIndex((java.lang.Comparable)0);
//     int i15 = defaultKeyedValues0.getItemCount();
//     org.jfree.data.time.Month month16 = new org.jfree.data.time.Month();
//     int i17 = month16.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem19 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month16, 11.0d);
//     timeSeriesDataItem19.setSelected(true);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod22 = timeSeriesDataItem19.getPeriod();
//     boolean b23 = timeSeriesDataItem19.isSelected();
//     int i24 = defaultKeyedValues0.getIndex((java.lang.Comparable)b23);
//     org.jfree.data.general.DefaultPieDataset defaultPieDataset25 = new org.jfree.data.general.DefaultPieDataset();
//     org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer27 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
//     org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator28 = xYAreaRenderer27.getLegendItemToolTipGenerator();
//     java.awt.Shape shape29 = xYAreaRenderer27.getBaseShape();
//     java.awt.Paint paint30 = xYAreaRenderer27.getBaseLegendTextPaint();
//     boolean b31 = defaultPieDataset25.equals((java.lang.Object)xYAreaRenderer27);
//     org.jfree.data.general.PieDataset pieDataset34 = org.jfree.data.general.DatasetUtilities.createConsolidatedPieDataset((org.jfree.data.general.PieDataset)defaultPieDataset25, (java.lang.Comparable)6.0d, 3.0d);
//     org.jfree.data.general.DefaultPieDataset defaultPieDataset35 = new org.jfree.data.general.DefaultPieDataset();
//     java.lang.Object obj36 = defaultPieDataset35.clone();
//     double d37 = org.jfree.data.general.DatasetUtilities.calculatePieDatasetTotal((org.jfree.data.general.PieDataset)defaultPieDataset35);
//     org.jfree.chart.plot.CategoryPlot categoryPlot38 = new org.jfree.chart.plot.CategoryPlot();
//     boolean b39 = categoryPlot38.isRangeZoomable();
//     org.jfree.chart.util.RectangleEdge rectangleEdge41 = categoryPlot38.getDomainAxisEdge(8);
//     java.awt.Font font43 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
//     org.jfree.data.general.WaferMapDataset waferMapDataset44 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot45 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset44);
//     org.jfree.chart.axis.ValueAxis valueAxis46 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot47 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis46);
//     java.util.List list48 = combinedDomainXYPlot47.getAnnotations();
//     waferMapPlot45.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot47);
//     org.jfree.chart.JFreeChart jFreeChart51 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font43, (org.jfree.chart.plot.Plot)combinedDomainXYPlot47, true);
//     org.jfree.chart.axis.NumberAxis numberAxis53 = new org.jfree.chart.axis.NumberAxis();
//     numberAxis53.centerRange(100.0d);
//     combinedDomainXYPlot47.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis53);
//     org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier57 = new org.jfree.chart.plot.DefaultDrawingSupplier();
//     combinedDomainXYPlot47.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier57);
//     categoryPlot38.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier57);
//     categoryPlot38.clearRangeMarkers(100);
//     org.jfree.chart.util.SortOrder sortOrder62 = categoryPlot38.getRowRenderingOrder();
//     defaultPieDataset35.sortByKeys(sortOrder62);
//     defaultPieDataset25.sortByValues(sortOrder62);
//     defaultKeyedValues0.sortByValues(sortOrder62);
//     defaultKeyedValues0.insertValue(0, (java.lang.Comparable)"series", (java.lang.Number)255);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d4 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d6 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str7 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str7.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(serialDate9);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i14 == (-1));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i15 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i17 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b23 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i24 == (-1));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(xYSeriesLabelGenerator28);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(shape29);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(paint30);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b31 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(pieDataset34);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj36);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d37 == 0.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b39 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleEdge41);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(font43);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list48);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(sortOrder62);
// 
//   }

  @Test
  public void test076() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test076"); }


    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator1 = null;
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator3 = new org.jfree.chart.urls.StandardXYURLGenerator("");
    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer4 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(100, xYToolTipGenerator1, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator3);
    xYStepAreaRenderer4.setPlotArea(true);
    java.lang.Object obj7 = null;
    boolean b8 = xYStepAreaRenderer4.equals(obj7);
    boolean b9 = xYStepAreaRenderer4.getBaseItemLabelsVisible();
    boolean b13 = xYStepAreaRenderer4.isItemLabelVisible(500, 31, false);
    boolean b14 = xYStepAreaRenderer4.getAutoPopulateSeriesStroke();
    org.jfree.data.xy.XYSeries xYSeries15 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection16 = new org.jfree.data.xy.XYSeriesCollection(xYSeries15);
    boolean b17 = xYSeriesCollection16.isAutoWidth();
    org.jfree.data.Range range19 = xYSeriesCollection16.getRangeBounds(true);
    xYSeriesCollection16.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis22 = new org.jfree.chart.axis.NumberAxis();
    numberAxis22.centerRange(100.0d);
    java.lang.Object obj25 = numberAxis22.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer26 = null;
    org.jfree.chart.plot.PolarPlot polarPlot27 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection16, (org.jfree.chart.axis.ValueAxis)numberAxis22, polarItemRenderer26);
    org.jfree.chart.plot.PlotOrientation plotOrientation28 = polarPlot27.getOrientation();
    org.jfree.chart.axis.ValueAxis valueAxis31 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot32 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis31);
    org.jfree.chart.plot.PlotOrientation plotOrientation33 = combinedDomainXYPlot32.getOrientation();
    boolean b34 = combinedDomainXYPlot32.isDomainCrosshairLockedOnData();
    org.jfree.chart.entity.EntityCollection entityCollection36 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo37 = new org.jfree.chart.ChartRenderingInfo(entityCollection36);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo38 = chartRenderingInfo37.getPlotInfo();
    java.awt.geom.Point2D point2D39 = null;
    combinedDomainXYPlot32.panDomainAxes(4.5d, plotRenderingInfo38, point2D39);
    int i41 = plotRenderingInfo38.getSubplotCount();
    org.jfree.chart.entity.EntityCollection entityCollection42 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo43 = new org.jfree.chart.ChartRenderingInfo(entityCollection42);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo44 = chartRenderingInfo43.getPlotInfo();
    plotRenderingInfo38.addSubplotInfo(plotRenderingInfo44);
    java.awt.geom.Rectangle2D rectangle2D46 = null;
    org.jfree.chart.util.RectangleAnchor rectangleAnchor47 = null;
    java.awt.geom.Point2D point2D48 = org.jfree.chart.util.RectangleAnchor.coordinates(rectangle2D46, rectangleAnchor47);
    polarPlot27.zoomDomainAxes(1.0d, 0.6d, plotRenderingInfo44, point2D48);
    org.jfree.chart.LegendItemCollection legendItemCollection50 = polarPlot27.getLegendItems();
    polarPlot27.setAngleLabelsVisible(false);
    org.jfree.chart.plot.PlotOrientation plotOrientation53 = polarPlot27.getOrientation();
    boolean b54 = xYStepAreaRenderer4.equals((java.lang.Object)polarPlot27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b34 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i41 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point2D48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b54 == false);

  }

  @Test
  public void test077() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test077"); }


    org.jfree.chart.renderer.category.BarRenderer barRenderer0 = new org.jfree.chart.renderer.category.BarRenderer();
    double d1 = barRenderer0.getShadowXOffset();
    barRenderer0.setShadowXOffset(10.0d);
    boolean b4 = barRenderer0.getIncludeBaseInRange();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition5 = barRenderer0.getNegativeItemLabelPositionFallback();
    org.jfree.chart.urls.CategoryURLGenerator categoryURLGenerator6 = null;
    barRenderer0.setBaseURLGenerator(categoryURLGenerator6);
    org.jfree.chart.labels.CategorySeriesLabelGenerator categorySeriesLabelGenerator8 = null;
    barRenderer0.setLegendItemURLGenerator(categorySeriesLabelGenerator8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(itemLabelPosition5);

  }

  @Test
  public void test078() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test078"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    boolean b1 = xYStepRenderer0.getUseFillPaint();
    xYStepRenderer0.setDrawSeriesLineAsPath(false);
    java.awt.Paint paint7 = xYStepRenderer0.getItemFillPaint(2, 8, false);
    java.awt.Graphics2D graphics2D8 = null;
    java.awt.geom.Rectangle2D rectangle2D9 = null;
    org.jfree.chart.plot.XYPlot xYPlot10 = null;
    org.jfree.data.general.WaferMapDataset waferMapDataset11 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot12 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset11);
    org.jfree.chart.JFreeChart jFreeChart13 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent14 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot12, jFreeChart13);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment15 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment16 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement19 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment15, verticalAlignment16, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement20 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle21 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot12, (org.jfree.chart.block.Arrangement)flowArrangement19, (org.jfree.chart.block.Arrangement)borderArrangement20);
    org.jfree.data.time.TimeSeries timeSeries22 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection23 = new org.jfree.data.time.TimeSeriesCollection(timeSeries22);
    timeSeriesCollection23.validateObject();
    java.lang.Comparable comparable25 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer26 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement19, (org.jfree.data.general.Dataset)timeSeriesCollection23, comparable25);
    timeSeriesCollection23.validateObject();
    org.jfree.chart.axis.ValueAxis valueAxis28 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot29 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis28);
    org.jfree.chart.plot.PlotOrientation plotOrientation30 = combinedDomainXYPlot29.getOrientation();
    boolean b31 = combinedDomainXYPlot29.isDomainCrosshairLockedOnData();
    org.jfree.chart.entity.EntityCollection entityCollection33 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo34 = new org.jfree.chart.ChartRenderingInfo(entityCollection33);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo35 = chartRenderingInfo34.getPlotInfo();
    java.awt.geom.Point2D point2D36 = null;
    combinedDomainXYPlot29.panDomainAxes(4.5d, plotRenderingInfo35, point2D36);
    int i38 = plotRenderingInfo35.getSubplotCount();
    org.jfree.chart.entity.EntityCollection entityCollection39 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo40 = new org.jfree.chart.ChartRenderingInfo(entityCollection39);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo41 = chartRenderingInfo40.getPlotInfo();
    plotRenderingInfo35.addSubplotInfo(plotRenderingInfo41);
    org.jfree.chart.renderer.xy.XYItemRendererState xYItemRendererState43 = xYStepRenderer0.initialise(graphics2D8, rectangle2D9, xYPlot10, (org.jfree.data.xy.XYDataset)timeSeriesCollection23, plotRenderingInfo41);
    java.awt.Stroke stroke47 = xYStepRenderer0.getItemOutlineStroke(1900, 2016, false);
    java.awt.Paint paint49 = xYStepRenderer0.lookupSeriesOutlinePaint((-9999));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i38 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(xYItemRendererState43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint49);

  }

  @Test
  public void test079() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test079"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    piePlot3D2.setStartAngle(Double.NaN);
    org.jfree.data.general.DefaultPieDataset defaultPieDataset5 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj6 = defaultPieDataset5.clone();
    double d7 = org.jfree.data.general.DatasetUtilities.calculatePieDatasetTotal((org.jfree.data.general.PieDataset)defaultPieDataset5);
    piePlot3D2.setDataset((org.jfree.data.general.PieDataset)defaultPieDataset5);
    double d9 = piePlot3D2.getMinimumArcAngleToDraw();
    org.jfree.chart.util.RectangleInsets rectangleInsets10 = null;
    // The following exception was thrown during execution in test generation
    try {
      piePlot3D2.setSimpleLabelOffset(rectangleInsets10);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d9 == 1.0E-5d);

  }

  @Test
  public void test080() {}
// Defects4J: flaky method
//   @Test
//   public void test080() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test080"); }
// 
// 
//     org.jfree.data.time.TimeSeries timeSeries0 = null;
//     org.jfree.data.time.Month month2 = new org.jfree.data.time.Month();
//     int i3 = month2.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem5 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month2, (java.lang.Number)8);
//     long long6 = month2.getFirstMillisecond();
//     org.jfree.data.time.Month month7 = new org.jfree.data.time.Month();
//     int i8 = month7.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis9 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month2, (org.jfree.data.time.RegularTimePeriod)month7);
//     float f10 = periodAxis9.getMinorTickMarkInsideLength();
//     java.util.TimeZone timeZone11 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.TimeSeriesCollection timeSeriesCollection12 = new org.jfree.data.time.TimeSeriesCollection(timeZone11);
//     periodAxis9.setTimeZone(timeZone11);
//     org.jfree.data.time.TimeSeriesCollection timeSeriesCollection14 = new org.jfree.data.time.TimeSeriesCollection(timeSeries0, timeZone11);
//     // The following exception was thrown during execution in test generation
//     try {
//       double d17 = timeSeriesCollection14.getStartXValue(0, 31);
//       org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
//     } catch (java.lang.IndexOutOfBoundsException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i3 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long6 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i8 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f10 == 0.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone11);
// 
//   }

  @Test
  public void test081() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test081"); }


    org.jfree.chart.renderer.category.BarRenderer barRenderer0 = new org.jfree.chart.renderer.category.BarRenderer();
    double d1 = barRenderer0.getShadowXOffset();
    barRenderer0.setShadowXOffset(10.0d);
    boolean b4 = barRenderer0.getIncludeBaseInRange();
    org.jfree.chart.labels.CategoryItemLabelGenerator categoryItemLabelGenerator6 = null;
    barRenderer0.setSeriesItemLabelGenerator(15, categoryItemLabelGenerator6, false);
    org.jfree.chart.plot.CategoryPlot categoryPlot9 = new org.jfree.chart.plot.CategoryPlot();
    boolean b10 = categoryPlot9.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge12 = categoryPlot9.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis14 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets15 = categoryAxis14.getLabelInsets();
    double d17 = rectangleInsets15.calculateLeftInset(4.0d);
    categoryPlot9.setInsets(rectangleInsets15, false);
    org.jfree.chart.util.Layer layer21 = null;
    java.util.Collection collection22 = categoryPlot9.getDomainMarkers(5, layer21);
    org.jfree.data.general.DatasetGroup datasetGroup23 = categoryPlot9.getDatasetGroup();
    barRenderer0.setPlot(categoryPlot9);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer26 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition28 = xYAreaRenderer26.getSeriesNegativeItemLabelPosition(1);
    org.jfree.chart.plot.CategoryPlot categoryPlot29 = new org.jfree.chart.plot.CategoryPlot();
    boolean b30 = categoryPlot29.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge32 = categoryPlot29.getDomainAxisEdge(8);
    java.awt.Color color39 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke40 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color41 = java.awt.Color.orange;
    java.awt.Stroke stroke42 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker44 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color39, stroke40, (java.awt.Paint)color41, stroke42, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer45 = null;
    intervalMarker44.setGradientPaintTransformer(gradientPaintTransformer45);
    org.jfree.chart.util.RectangleInsets rectangleInsets47 = intervalMarker44.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis49 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets50 = categoryAxis49.getLabelInsets();
    intervalMarker44.setLabelOffset(rectangleInsets50);
    double d52 = intervalMarker44.getEndValue();
    org.jfree.chart.util.Layer layer53 = null;
    boolean b54 = categoryPlot29.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker44, layer53);
    xYAreaRenderer26.removeChangeListener((org.jfree.chart.event.RendererChangeListener)categoryPlot29);
    org.jfree.chart.axis.ValueAxis valueAxis57 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot58 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis57);
    java.util.List list59 = combinedDomainXYPlot58.getAnnotations();
    combinedDomainXYPlot58.setRangeGridlinesVisible(true);
    java.awt.Color color62 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    combinedDomainXYPlot58.setRangeTickBandPaint((java.awt.Paint)color62);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer65 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator66 = xYAreaRenderer65.getLegendItemToolTipGenerator();
    boolean b69 = xYAreaRenderer65.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition73 = xYAreaRenderer65.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b75 = xYAreaRenderer65.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator77 = xYAreaRenderer65.getSeriesToolTipGenerator(3);
    java.awt.Font font79 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset80 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot81 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset80);
    org.jfree.chart.axis.ValueAxis valueAxis82 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot83 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis82);
    java.util.List list84 = combinedDomainXYPlot83.getAnnotations();
    waferMapPlot81.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot83);
    boolean b86 = combinedDomainXYPlot83.isNotify();
    org.jfree.chart.JFreeChart jFreeChart88 = new org.jfree.chart.JFreeChart("", font79, (org.jfree.chart.plot.Plot)combinedDomainXYPlot83, true);
    xYAreaRenderer65.setBaseLegendTextFont(font79);
    combinedDomainXYPlot58.setNoDataMessageFont(font79);
    xYAreaRenderer26.setSeriesItemLabelFont(10, font79, false);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition96 = xYAreaRenderer26.getNegativeItemLabelPosition(2016, 40, false);
    org.jfree.chart.event.RendererChangeEvent rendererChangeEvent98 = new org.jfree.chart.event.RendererChangeEvent((java.lang.Object)false, false);
    categoryPlot9.rendererChanged(rendererChangeEvent98);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d17 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(datasetGroup23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d52 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b54 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b69 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition73);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYToolTipGenerator77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b86 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition96);

  }

  @Test
  public void test082() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test082"); }


    java.awt.Shape shape11 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color13 = java.awt.Color.green;
    java.awt.Color color15 = java.awt.Color.green;
    java.awt.Color color21 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke22 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color23 = java.awt.Color.orange;
    java.awt.Stroke stroke24 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker26 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color21, stroke22, (java.awt.Paint)color23, stroke24, 0.0f);
    java.awt.Shape shape30 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke31 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color32 = java.awt.Color.green;
    java.lang.String str33 = org.jfree.chart.util.PaintUtilities.colorToString(color32);
    org.jfree.chart.LegendItem legendItem34 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape11, true, (java.awt.Paint)color13, false, (java.awt.Paint)color15, stroke22, true, shape30, stroke31, (java.awt.Paint)color32);
    org.jfree.chart.axis.CategoryAxis categoryAxis35 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset36 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot37 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset36);
    org.jfree.chart.axis.ValueAxis valueAxis38 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot39 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis38);
    java.util.List list40 = combinedDomainXYPlot39.getAnnotations();
    waferMapPlot37.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot39);
    int i42 = combinedDomainXYPlot39.getSeriesCount();
    categoryAxis35.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot39);
    boolean b44 = combinedDomainXYPlot39.isRangeMinorGridlinesVisible();
    org.jfree.data.general.DatasetChangeEvent datasetChangeEvent45 = null;
    combinedDomainXYPlot39.datasetChanged(datasetChangeEvent45);
    org.jfree.chart.axis.NumberAxis numberAxis48 = new org.jfree.chart.axis.NumberAxis();
    numberAxis48.centerRange(100.0d);
    java.lang.Object obj51 = numberAxis48.clone();
    combinedDomainXYPlot39.setDomainAxis(4, (org.jfree.chart.axis.ValueAxis)numberAxis48, true);
    java.awt.Paint paint54 = combinedDomainXYPlot39.getRangeZeroBaselinePaint();
    org.jfree.chart.LegendItem legendItem55 = new org.jfree.chart.LegendItem("?hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!=-1&amp;=14", "{0}: ({1}, {2})", "^2.0", "LengthConstraintType.FIXED", shape30, paint54);
    legendItem55.setDatasetIndex(140);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str33 + "' != '" + "green"+ "'", str33.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i42 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint54);

  }

  @Test
  public void test083() {}
// Defects4J: flaky method
//   @Test
//   public void test083() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test083"); }
// 
// 
//     org.jfree.data.time.Month month3 = new org.jfree.data.time.Month();
//     int i4 = month3.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem6 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month3, (java.lang.Number)8);
//     long long7 = month3.getFirstMillisecond();
//     org.jfree.data.time.Month month8 = new org.jfree.data.time.Month();
//     int i9 = month8.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis10 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month3, (org.jfree.data.time.RegularTimePeriod)month8);
//     float f11 = periodAxis10.getMinorTickMarkInsideLength();
//     java.util.TimeZone timeZone12 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.TimeSeriesCollection timeSeriesCollection13 = new org.jfree.data.time.TimeSeriesCollection(timeZone12);
//     periodAxis10.setTimeZone(timeZone12);
//     org.jfree.data.time.Month month16 = new org.jfree.data.time.Month();
//     int i17 = month16.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem19 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month16, (java.lang.Number)8);
//     long long20 = month16.getFirstMillisecond();
//     org.jfree.data.time.Month month21 = new org.jfree.data.time.Month();
//     int i22 = month21.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis23 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month16, (org.jfree.data.time.RegularTimePeriod)month21);
//     float f24 = periodAxis23.getMinorTickMarkInsideLength();
//     java.util.Locale locale25 = periodAxis23.getLocale();
//     org.jfree.chart.axis.DateAxis dateAxis26 = new org.jfree.chart.axis.DateAxis("", timeZone12, locale25);
//     org.jfree.chart.labels.StandardPieSectionLabelGenerator standardPieSectionLabelGenerator27 = new org.jfree.chart.labels.StandardPieSectionLabelGenerator("VerticalAlignment.CENTER", locale25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i4 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long7 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i9 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f11 == 0.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i17 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long20 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i22 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f24 == 0.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(locale25);
// 
//   }

  @Test
  public void test084() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test084"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer13 = null;
    combinedDomainXYPlot5.setRenderer(xYItemRenderer13);
    boolean b15 = combinedDomainXYPlot5.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries16 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection17 = new org.jfree.data.time.TimeSeriesCollection(timeSeries16);
    combinedDomainXYPlot5.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    boolean b19 = combinedDomainXYPlot5.isRangeZoomable();
    org.jfree.chart.event.PlotChangeEvent plotChangeEvent20 = null;
    // The following exception was thrown during execution in test generation
    try {
      combinedDomainXYPlot5.notifyListeners(plotChangeEvent20);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == true);

  }

  @Test
  public void test085() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test085"); }


    org.jfree.chart.axis.AxisState axisState1 = new org.jfree.chart.axis.AxisState(6.0d);
    axisState1.cursorDown(0.2d);

  }

  @Test
  public void test086() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test086"); }


    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.SpreadsheetDate spreadsheetDate3 = new org.jfree.data.time.SpreadsheetDate(255, 128, 2147483647);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test087() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test087"); }


    org.jfree.data.xy.XYSeries xYSeries0 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection1 = new org.jfree.data.xy.XYSeriesCollection(xYSeries0);
    boolean b2 = xYSeriesCollection1.isAutoWidth();
    org.jfree.data.Range range4 = xYSeriesCollection1.getRangeBounds(true);
    xYSeriesCollection1.setIntervalWidth(1.0d);
    org.jfree.chart.util.RectangleInsets rectangleInsets7 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent8 = new org.jfree.data.general.SeriesChangeEvent((java.lang.Object)rectangleInsets7);
    xYSeriesCollection1.seriesChanged(seriesChangeEvent8);
    org.jfree.data.xy.XYSeries xYSeries11 = new org.jfree.data.xy.XYSeries((java.lang.Comparable)(-1.0f));
    org.jfree.data.xy.XYDataItem xYDataItem14 = xYSeries11.addOrUpdate((java.lang.Number)5, (java.lang.Number)(short)10);
    xYSeriesCollection1.addSeries(xYSeries11);
    boolean b16 = xYSeries11.getAutoSort();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYDataItem14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == true);

  }

  @Test
  public void test088() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test088"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    boolean b1 = xYStepRenderer0.getUseFillPaint();
    boolean b2 = xYStepRenderer0.getDrawSeriesLineAsPath();
    boolean b3 = xYStepRenderer0.getUseFillPaint();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test089() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test089"); }


    org.jfree.chart.labels.ItemLabelAnchor itemLabelAnchor0 = org.jfree.chart.labels.ItemLabelAnchor.OUTSIDE8;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelAnchor0);

  }

  @Test
  public void test090() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test090"); }


    org.jfree.chart.renderer.category.BarRenderer barRenderer0 = new org.jfree.chart.renderer.category.BarRenderer();
    org.jfree.chart.labels.CategoryItemLabelGenerator categoryItemLabelGenerator2 = null;
    barRenderer0.setSeriesItemLabelGenerator(100, categoryItemLabelGenerator2);
    org.jfree.chart.urls.CategoryURLGenerator categoryURLGenerator7 = barRenderer0.getURLGenerator(12, (-435), false);
    barRenderer0.setSeriesItemLabelsVisible(21, (java.lang.Boolean)true, false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryURLGenerator7);

  }

  @Test
  public void test091() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test091"); }


    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.Month month2 = new org.jfree.data.time.Month(140, 0);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test092() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test092"); }


    org.jfree.chart.renderer.category.BarRenderer barRenderer0 = new org.jfree.chart.renderer.category.BarRenderer();
    double d1 = barRenderer0.getShadowXOffset();
    org.jfree.chart.labels.CategoryToolTipGenerator categoryToolTipGenerator5 = barRenderer0.getToolTipGenerator((-25560), 2, false);
    org.jfree.chart.labels.CategoryToolTipGenerator categoryToolTipGenerator6 = null;
    barRenderer0.setBaseToolTipGenerator(categoryToolTipGenerator6, false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryToolTipGenerator5);

  }

  @Test
  public void test093() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test093"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis1 = new org.jfree.chart.axis.CategoryAxis("");
    java.lang.Object obj2 = categoryAxis1.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj2);

  }

  @Test
  public void test094() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test094"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer13 = null;
    combinedDomainXYPlot5.setRenderer(xYItemRenderer13);
    boolean b15 = combinedDomainXYPlot5.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries16 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection17 = new org.jfree.data.time.TimeSeriesCollection(timeSeries16);
    combinedDomainXYPlot5.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    java.util.List list19 = timeSeriesCollection17.getSeries();
    org.jfree.data.Range range20 = org.jfree.data.general.DatasetUtilities.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    org.jfree.data.DomainOrder domainOrder21 = timeSeriesCollection17.getDomainOrder();
    double d23 = timeSeriesCollection17.getDomainUpperBound(false);
    // The following exception was thrown during execution in test generation
    try {
      timeSeriesCollection17.setSelected((-435), 0, false, true);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d23, Double.NaN, 0);

  }

  @Test
  public void test095() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test095"); }


    int i1 = org.jfree.data.time.SerialDate.stringToMonthCode("LengthConstraintType.FIXED");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == (-1));

  }

  @Test
  public void test096() {}
// Defects4J: flaky method
//   @Test
//   public void test096() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test096"); }
// 
// 
//     org.jfree.data.time.Month month0 = new org.jfree.data.time.Month();
//     int i1 = month0.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem3 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month0, 11.0d);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod4 = month0.previous();
//     long long5 = month0.getFirstMillisecond();
//     org.jfree.data.time.Year year6 = month0.getYear();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i1 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(year6);
// 
//   }

  @Test
  public void test097() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test097"); }


    org.jfree.data.xy.XYSeries xYSeries0 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection1 = new org.jfree.data.xy.XYSeriesCollection(xYSeries0);
    boolean b2 = xYSeriesCollection1.isAutoWidth();
    org.jfree.data.Range range4 = xYSeriesCollection1.getRangeBounds(true);
    xYSeriesCollection1.setIntervalWidth(1.0d);
    org.jfree.data.xy.XYSeries xYSeries10 = new org.jfree.data.xy.XYSeries((java.lang.Comparable)10.0d, false, false);
    xYSeriesCollection1.removeSeries(xYSeries10);
    boolean b12 = org.jfree.data.general.DatasetUtilities.isEmptyOrNull((org.jfree.data.xy.XYDataset)xYSeriesCollection1);
    java.util.List list13 = xYSeriesCollection1.getSeries();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list13);

  }

  @Test
  public void test098() {}
// Defects4J: flaky method
//   @Test
//   public void test098() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test098"); }
// 
// 
//     org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
//     boolean b1 = categoryPlot0.isRangeZoomable();
//     org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
//     java.awt.Color color10 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
//     java.awt.Stroke stroke11 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
//     java.awt.Color color12 = java.awt.Color.orange;
//     java.awt.Stroke stroke13 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
//     org.jfree.chart.plot.IntervalMarker intervalMarker15 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color10, stroke11, (java.awt.Paint)color12, stroke13, 0.0f);
//     org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer16 = null;
//     intervalMarker15.setGradientPaintTransformer(gradientPaintTransformer16);
//     org.jfree.chart.util.RectangleInsets rectangleInsets18 = intervalMarker15.getLabelOffset();
//     org.jfree.chart.axis.CategoryAxis categoryAxis20 = new org.jfree.chart.axis.CategoryAxis("");
//     org.jfree.chart.util.RectangleInsets rectangleInsets21 = categoryAxis20.getLabelInsets();
//     intervalMarker15.setLabelOffset(rectangleInsets21);
//     double d23 = intervalMarker15.getEndValue();
//     org.jfree.chart.util.Layer layer24 = null;
//     boolean b25 = categoryPlot0.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker15, layer24);
//     org.jfree.data.category.CategoryDataset categoryDataset26 = null;
//     int i27 = categoryPlot0.indexOf(categoryDataset26);
//     org.jfree.data.general.WaferMapDataset waferMapDataset29 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot30 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset29);
//     org.jfree.chart.axis.ValueAxis valueAxis31 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot32 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis31);
//     java.util.List list33 = combinedDomainXYPlot32.getAnnotations();
//     waferMapPlot30.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot32);
//     int i35 = combinedDomainXYPlot32.getSeriesCount();
//     boolean b37 = combinedDomainXYPlot32.equals((java.lang.Object)10.0d);
//     org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer39 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
//     xYAreaRenderer39.setSeriesCreateEntities(15, (java.lang.Boolean)true, true);
//     org.jfree.chart.labels.ItemLabelPosition itemLabelPosition45 = xYAreaRenderer39.getSeriesPositiveItemLabelPosition(3);
//     boolean b46 = combinedDomainXYPlot32.equals((java.lang.Object)3);
//     org.jfree.chart.axis.AxisLocation axisLocation48 = combinedDomainXYPlot32.getDomainAxisLocation(10);
//     categoryPlot0.setDomainAxisLocation(0, axisLocation48);
//     org.jfree.data.time.Month month51 = new org.jfree.data.time.Month();
//     int i52 = month51.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem54 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month51, (java.lang.Number)8);
//     long long55 = month51.getFirstMillisecond();
//     org.jfree.data.time.Month month56 = new org.jfree.data.time.Month();
//     int i57 = month56.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis58 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month51, (org.jfree.data.time.RegularTimePeriod)month56);
//     periodAxis58.setUpperMargin(10.0d);
//     org.jfree.data.Range range61 = periodAxis58.getRange();
//     org.jfree.chart.util.RectangleInsets rectangleInsets62 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
//     double d63 = rectangleInsets62.getLeft();
//     double d65 = rectangleInsets62.calculateLeftOutset(1.0d);
//     double d67 = rectangleInsets62.calculateRightInset(0.05d);
//     periodAxis58.setLabelInsets(rectangleInsets62);
//     org.jfree.chart.plot.CategoryPlot categoryPlot69 = new org.jfree.chart.plot.CategoryPlot();
//     boolean b70 = categoryPlot69.isRangeZoomable();
//     org.jfree.chart.util.RectangleEdge rectangleEdge72 = categoryPlot69.getDomainAxisEdge(8);
//     org.jfree.chart.axis.CategoryAxis categoryAxis74 = new org.jfree.chart.axis.CategoryAxis("");
//     org.jfree.chart.util.RectangleInsets rectangleInsets75 = categoryAxis74.getLabelInsets();
//     double d77 = rectangleInsets75.calculateLeftInset(4.0d);
//     categoryPlot69.setInsets(rectangleInsets75, false);
//     int i80 = categoryPlot69.getRendererCount();
//     org.jfree.chart.axis.NumberAxis numberAxis81 = new org.jfree.chart.axis.NumberAxis();
//     numberAxis81.centerRange(100.0d);
//     java.awt.Paint paint84 = numberAxis81.getLabelPaint();
//     categoryPlot69.setRangeCrosshairPaint(paint84);
//     org.jfree.chart.entity.EntityCollection entityCollection87 = null;
//     org.jfree.chart.ChartRenderingInfo chartRenderingInfo88 = new org.jfree.chart.ChartRenderingInfo(entityCollection87);
//     org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo89 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo88);
//     java.awt.geom.Point2D point2D90 = null;
//     categoryPlot69.panRangeAxes(0.6d, plotRenderingInfo89, point2D90);
//     boolean b92 = periodAxis58.equals((java.lang.Object)categoryPlot69);
//     org.jfree.chart.plot.PlotOrientation plotOrientation93 = categoryPlot69.getOrientation();
//     org.jfree.chart.util.RectangleEdge rectangleEdge94 = org.jfree.chart.plot.Plot.resolveRangeAxisLocation(axisLocation48, plotOrientation93);
//     boolean b96 = rectangleEdge94.equals((java.lang.Object)"TextBlockAnchor.BOTTOM_RIGHT?series=9999&amp;item=133");
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b1 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleEdge3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets18);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets21);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d23 == 0.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b25 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i27 == 0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list33);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i35 == 0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b37 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(itemLabelPosition45);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b46 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(axisLocation48);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i52 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long55 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i57 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(range61);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets62);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d63 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d65 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d67 == 8.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b70 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleEdge72);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets75);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d77 == 3.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i80 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(paint84);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b92 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(plotOrientation93);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleEdge94);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b96 == false);
// 
//   }

  @Test
  public void test099() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test099"); }


    org.jfree.chart.renderer.category.BarRenderer barRenderer0 = new org.jfree.chart.renderer.category.BarRenderer();
    org.jfree.chart.labels.CategoryItemLabelGenerator categoryItemLabelGenerator2 = null;
    barRenderer0.setSeriesItemLabelGenerator(100, categoryItemLabelGenerator2);
    org.jfree.chart.LegendItem legendItem6 = barRenderer0.getLegendItem(10, 7);
    barRenderer0.setItemLabelAnchorOffset(11.0d);
    java.awt.Shape shape12 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross((-1.0f), 100.0f);
    barRenderer0.setSeriesShape(3, shape12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(legendItem6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape12);

  }

  @Test
  public void test100() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test100"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    java.awt.Shape shape3 = xYAreaRenderer1.getBaseShape();
    java.awt.Stroke stroke4 = org.jfree.chart.plot.WaferMapPlot.DEFAULT_CROSSHAIR_STROKE;
    xYAreaRenderer1.setBaseStroke(stroke4, true);
    java.awt.Shape shape15 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color17 = java.awt.Color.green;
    java.awt.Color color19 = java.awt.Color.green;
    java.awt.Color color25 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke26 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color27 = java.awt.Color.orange;
    java.awt.Stroke stroke28 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker30 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color25, stroke26, (java.awt.Paint)color27, stroke28, 0.0f);
    java.awt.Shape shape34 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke35 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color36 = java.awt.Color.green;
    java.lang.String str37 = org.jfree.chart.util.PaintUtilities.colorToString(color36);
    org.jfree.chart.LegendItem legendItem38 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape15, true, (java.awt.Paint)color17, false, (java.awt.Paint)color19, stroke26, true, shape34, stroke35, (java.awt.Paint)color36);
    org.jfree.data.general.WaferMapDataset waferMapDataset39 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot40 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset39);
    org.jfree.chart.JFreeChart jFreeChart41 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent42 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot40, jFreeChart41);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment43 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment44 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement47 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment43, verticalAlignment44, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement48 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle49 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot40, (org.jfree.chart.block.Arrangement)flowArrangement47, (org.jfree.chart.block.Arrangement)borderArrangement48);
    org.jfree.chart.entity.TitleEntity titleEntity51 = new org.jfree.chart.entity.TitleEntity(shape15, (org.jfree.chart.title.Title)legendTitle49, "green");
    org.jfree.chart.util.RectangleInsets rectangleInsets52 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d53 = rectangleInsets52.getTop();
    legendTitle49.setItemLabelPadding(rectangleInsets52);
    java.awt.Paint paint55 = legendTitle49.getItemPaint();
    java.awt.Paint paint56 = legendTitle49.getBackgroundPaint();
    java.awt.Font font57 = legendTitle49.getItemFont();
    xYAreaRenderer1.setSeriesItemLabelFont(8, font57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str37 + "' != '" + "green"+ "'", str37.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d53 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font57);

  }

  @Test
  public void test101() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test101"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    double d3 = xYBarRenderer1.getShadowXOffset();
    xYBarRenderer1.setShadowXOffset(7.0d);
    xYBarRenderer1.setBarAlignmentFactor(11.0d);
    java.awt.Shape shape9 = xYBarRenderer1.lookupLegendShape(0);
    boolean b10 = xYBarRenderer1.getDataBoundsIncludesVisibleSeriesOnly();
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator12 = null;
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator14 = new org.jfree.chart.urls.StandardXYURLGenerator("");
    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer15 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(100, xYToolTipGenerator12, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator14);
    xYStepAreaRenderer15.setPlotArea(true);
    java.lang.Object obj18 = null;
    boolean b19 = xYStepAreaRenderer15.equals(obj18);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition20 = xYStepAreaRenderer15.getBasePositiveItemLabelPosition();
    xYBarRenderer1.setBaseNegativeItemLabelPosition(itemLabelPosition20, false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d3 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition20);

  }

  @Test
  public void test102() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test102"); }


    org.jfree.chart.resources.JFreeChartResources jFreeChartResources0 = new org.jfree.chart.resources.JFreeChartResources();
    java.util.Enumeration enumeration1 = jFreeChartResources0.getKeys();
    java.util.Enumeration enumeration2 = jFreeChartResources0.getKeys();
    java.lang.Object obj4 = jFreeChartResources0.handleGetObject("AxisLocation.BOTTOM_OR_LEFT");
    java.util.Locale locale5 = jFreeChartResources0.getLocale();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(enumeration1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(enumeration2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(obj4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(locale5);

  }

  @Test
  public void test103() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test103"); }


    java.awt.Font font2 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset3 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot4 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset3);
    org.jfree.chart.axis.ValueAxis valueAxis5 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot6 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis5);
    java.util.List list7 = combinedDomainXYPlot6.getAnnotations();
    waferMapPlot4.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot6);
    boolean b9 = combinedDomainXYPlot6.isNotify();
    org.jfree.chart.JFreeChart jFreeChart11 = new org.jfree.chart.JFreeChart("", font2, (org.jfree.chart.plot.Plot)combinedDomainXYPlot6, true);
    org.jfree.chart.title.TextTitle textTitle12 = new org.jfree.chart.title.TextTitle("", font2);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer14 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier15 = xYAreaRenderer14.getDrawingSupplier();
    java.awt.Stroke stroke16 = xYAreaRenderer14.getBaseStroke();
    java.awt.Color color22 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke23 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color24 = java.awt.Color.orange;
    java.awt.Stroke stroke25 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker27 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color22, stroke23, (java.awt.Paint)color24, stroke25, 0.0f);
    java.awt.Paint paint28 = intervalMarker27.getOutlinePaint();
    xYAreaRenderer14.setBaseLegendTextPaint(paint28);
    org.jfree.chart.axis.NumberAxis3D numberAxis3D30 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Color color31 = org.jfree.chart.ChartColor.VERY_LIGHT_GREEN;
    numberAxis3D30.setTickMarkPaint((java.awt.Paint)color31);
    xYAreaRenderer14.setBaseItemLabelPaint((java.awt.Paint)color31);
    java.awt.Font font34 = xYAreaRenderer14.getBaseItemLabelFont();
    textTitle12.setFont(font34);
    textTitle12.setText("{0}: ({1}, {2})");
    textTitle12.setExpandToFitSpace(false);
    textTitle12.setMargin(0.6d, (-1.0d), 100.0d, 0.12d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font34);

  }

  @Test
  public void test104() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test104"); }


    org.jfree.chart.StandardChartTheme standardChartTheme1 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.renderer.category.BarPainter barPainter2 = standardChartTheme1.getBarPainter();
    java.awt.Paint paint3 = standardChartTheme1.getShadowPaint();
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    boolean b12 = combinedDomainXYPlot9.isNotify();
    org.jfree.chart.JFreeChart jFreeChart14 = new org.jfree.chart.JFreeChart("", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    combinedDomainXYPlot9.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.util.RectangleEdge rectangleEdge17 = combinedDomainXYPlot9.getDomainAxisEdge();
    org.jfree.chart.util.RectangleInsets rectangleInsets18 = org.jfree.chart.axis.Axis.DEFAULT_TICK_LABEL_INSETS;
    combinedDomainXYPlot9.setAxisOffset(rectangleInsets18);
    standardChartTheme1.setAxisOffset(rectangleInsets18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(barPainter2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets18);

  }

  @Test
  public void test105() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test105"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = xYStepRenderer0.getSeriesPositiveItemLabelPosition(3);
    java.util.Collection collection3 = xYStepRenderer0.getAnnotations();
    boolean b4 = xYStepRenderer0.getBaseShapesFilled();
    org.jfree.chart.labels.XYItemLabelGenerator xYItemLabelGenerator6 = null;
    xYStepRenderer0.setSeriesItemLabelGenerator(255, xYItemLabelGenerator6);
    java.awt.Font font9 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset10 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot11 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset10);
    org.jfree.chart.axis.ValueAxis valueAxis12 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot13 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis12);
    java.util.List list14 = combinedDomainXYPlot13.getAnnotations();
    waferMapPlot11.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot13);
    boolean b16 = combinedDomainXYPlot13.isNotify();
    org.jfree.chart.JFreeChart jFreeChart18 = new org.jfree.chart.JFreeChart("", font9, (org.jfree.chart.plot.Plot)combinedDomainXYPlot13, true);
    combinedDomainXYPlot13.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer21 = null;
    combinedDomainXYPlot13.setRenderer(xYItemRenderer21);
    boolean b23 = combinedDomainXYPlot13.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries24 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection25 = new org.jfree.data.time.TimeSeriesCollection(timeSeries24);
    combinedDomainXYPlot13.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection25);
    java.util.List list27 = timeSeriesCollection25.getSeries();
    org.jfree.data.Range range28 = org.jfree.data.general.DatasetUtilities.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection25);
    org.jfree.data.DomainOrder domainOrder29 = timeSeriesCollection25.getDomainOrder();
    org.jfree.data.Range range30 = xYStepRenderer0.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection25);
    // The following exception was thrown during execution in test generation
    try {
      int[] i_array33 = timeSeriesCollection25.getSurroundingItems(4, 1969L);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(collection3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range30);

  }

  @Test
  public void test106() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test106"); }


    java.awt.Paint[] paint_array0 = null;
    org.jfree.chart.axis.ValueAxis valueAxis1 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot2 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis1);
    java.util.List list3 = combinedDomainXYPlot2.getAnnotations();
    combinedDomainXYPlot2.setRangeGridlinesVisible(true);
    java.awt.Color color6 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    combinedDomainXYPlot2.setRangeTickBandPaint((java.awt.Paint)color6);
    java.awt.Paint[] paint_array8 = new java.awt.Paint[] { color6 };
    java.awt.Shape shape16 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color18 = java.awt.Color.green;
    java.awt.Color color20 = java.awt.Color.green;
    java.awt.Color color26 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color28 = java.awt.Color.orange;
    java.awt.Stroke stroke29 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker31 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color26, stroke27, (java.awt.Paint)color28, stroke29, 0.0f);
    java.awt.Shape shape35 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke36 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color37 = java.awt.Color.green;
    java.lang.String str38 = org.jfree.chart.util.PaintUtilities.colorToString(color37);
    org.jfree.chart.LegendItem legendItem39 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape16, true, (java.awt.Paint)color18, false, (java.awt.Paint)color20, stroke27, true, shape35, stroke36, (java.awt.Paint)color37);
    java.awt.Paint[] paint_array40 = new java.awt.Paint[] { color18 };
    java.awt.Stroke[] stroke_array41 = null;
    java.awt.Stroke stroke42 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Stroke[] stroke_array43 = new java.awt.Stroke[] { stroke42 };
    java.awt.Shape shape46 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Shape[] shape_array47 = new java.awt.Shape[] { shape46 };
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier48 = new org.jfree.chart.plot.DefaultDrawingSupplier(paint_array0, paint_array8, paint_array40, stroke_array41, stroke_array43, shape_array47);
    java.awt.Shape shape49 = defaultDrawingSupplier48.getNextShape();
    java.awt.Shape shape50 = defaultDrawingSupplier48.getNextShape();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str38 + "' != '" + "green"+ "'", str38.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint_array40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape_array47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape50);

  }

  @Test
  public void test107() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test107"); }


    java.awt.Color color1 = null;
    java.awt.Color color2 = java.awt.Color.getColor("ClassContext", color1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(color2);

  }

  @Test
  public void test108() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test108"); }


    org.jfree.chart.util.StrokeMap strokeMap0 = new org.jfree.chart.util.StrokeMap();
    java.lang.Object obj1 = strokeMap0.clone();
    java.awt.Stroke stroke3 = strokeMap0.getStroke((java.lang.Comparable)1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(stroke3);

  }

  @Test
  public void test109() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test109"); }


    org.jfree.chart.util.LogFormat logFormat3 = new org.jfree.chart.util.LogFormat(12.0d, "{0}: ({1}, {2})", true);
    java.lang.StringBuffer stringBuffer5 = null;
    java.text.FieldPosition fieldPosition6 = null;
    java.lang.StringBuffer stringBuffer7 = logFormat3.format(6.0d, stringBuffer5, fieldPosition6);
    int i8 = logFormat3.getMinimumIntegerDigits();
    java.awt.Color color9 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    java.awt.Stroke stroke10 = org.jfree.chart.plot.CategoryPlot.DEFAULT_CROSSHAIR_STROKE;
    org.jfree.chart.util.RectangleInsets rectangleInsets11 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.chart.util.UnitType unitType12 = rectangleInsets11.getUnitType();
    double d14 = rectangleInsets11.calculateLeftOutset(0.0d);
    org.jfree.chart.block.LineBorder lineBorder15 = new org.jfree.chart.block.LineBorder((java.awt.Paint)color9, stroke10, rectangleInsets11);
    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot16 = new org.jfree.chart.plot.MultiplePiePlot();
    boolean b17 = lineBorder15.equals((java.lang.Object)multiplePiePlot16);
    boolean b18 = logFormat3.equals((java.lang.Object)b17);
    java.text.NumberFormat numberFormat19 = logFormat3.getExponentFormat();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stringBuffer7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i8 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(unitType12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat19);

  }

  @Test
  public void test110() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test110"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition3 = xYAreaRenderer1.getSeriesNegativeItemLabelPosition(1);
    org.jfree.chart.plot.CategoryPlot categoryPlot4 = new org.jfree.chart.plot.CategoryPlot();
    boolean b5 = categoryPlot4.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge7 = categoryPlot4.getDomainAxisEdge(8);
    java.awt.Color color14 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke15 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color16 = java.awt.Color.orange;
    java.awt.Stroke stroke17 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker19 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color14, stroke15, (java.awt.Paint)color16, stroke17, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer20 = null;
    intervalMarker19.setGradientPaintTransformer(gradientPaintTransformer20);
    org.jfree.chart.util.RectangleInsets rectangleInsets22 = intervalMarker19.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis24 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets25 = categoryAxis24.getLabelInsets();
    intervalMarker19.setLabelOffset(rectangleInsets25);
    double d27 = intervalMarker19.getEndValue();
    org.jfree.chart.util.Layer layer28 = null;
    boolean b29 = categoryPlot4.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker19, layer28);
    xYAreaRenderer1.removeChangeListener((org.jfree.chart.event.RendererChangeListener)categoryPlot4);
    boolean b31 = categoryPlot4.isRangeZoomable();
    org.jfree.chart.renderer.category.BarRenderer3D barRenderer3D35 = new org.jfree.chart.renderer.category.BarRenderer3D(1.0E-8d, 1.0d);
    java.awt.Paint paint36 = barRenderer3D35.getWallPaint();
    categoryPlot4.setRenderer(0, (org.jfree.chart.renderer.category.CategoryItemRenderer)barRenderer3D35, false);
    boolean b40 = barRenderer3D35.isSeriesVisible(8);
    java.awt.Paint paint44 = barRenderer3D35.getItemFillPaint((-1), 0, true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint44);

  }

  @Test
  public void test111() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test111"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    org.jfree.chart.axis.ValueAxis valueAxis2 = categoryPlot0.getRangeAxisForDataset(14);
    int i3 = categoryPlot0.getWeight();
    int i4 = categoryPlot0.getDatasetCount();
    categoryPlot0.mapDatasetToRangeAxis(0, 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(valueAxis2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i3 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 1);

  }

  @Test
  public void test112() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test112"); }


    org.jfree.chart.StandardChartTheme standardChartTheme1 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Shape shape9 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color13 = java.awt.Color.green;
    java.awt.Color color19 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke20 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color21 = java.awt.Color.orange;
    java.awt.Stroke stroke22 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker24 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color19, stroke20, (java.awt.Paint)color21, stroke22, 0.0f);
    java.awt.Shape shape28 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke29 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color30 = java.awt.Color.green;
    java.lang.String str31 = org.jfree.chart.util.PaintUtilities.colorToString(color30);
    org.jfree.chart.LegendItem legendItem32 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape9, true, (java.awt.Paint)color11, false, (java.awt.Paint)color13, stroke20, true, shape28, stroke29, (java.awt.Paint)color30);
    standardChartTheme1.setCrosshairPaint((java.awt.Paint)color11);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier34 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    standardChartTheme1.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier34);
    java.lang.Object obj36 = defaultDrawingSupplier34.clone();
    java.awt.Shape shape37 = defaultDrawingSupplier34.getNextShape();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str31 + "' != '" + "green"+ "'", str31.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape37);

  }

  @Test
  public void test113() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test113"); }


    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator3 = new org.jfree.chart.urls.StandardXYURLGenerator("RectangleAnchor.LEFT", "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]", "{0}: ({1}, {2})");
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    boolean b12 = combinedDomainXYPlot9.isNotify();
    org.jfree.chart.JFreeChart jFreeChart14 = new org.jfree.chart.JFreeChart("", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    combinedDomainXYPlot9.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer17 = null;
    combinedDomainXYPlot9.setRenderer(xYItemRenderer17);
    boolean b19 = combinedDomainXYPlot9.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries20 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection21 = new org.jfree.data.time.TimeSeriesCollection(timeSeries20);
    combinedDomainXYPlot9.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection21);
    timeSeriesCollection21.removeAllSeries();
    java.lang.String str26 = standardXYURLGenerator3.generateURL((org.jfree.data.xy.XYDataset)timeSeriesCollection21, 4, 255);
    org.jfree.data.time.TimePeriodAnchor timePeriodAnchor27 = timeSeriesCollection21.getXPosition();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str26 + "' != '" + "RectangleAnchor.LEFT?[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]=4&amp;{0}: ({1}, {2})=255"+ "'", str26.equals("RectangleAnchor.LEFT?[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]=4&amp;{0}: ({1}, {2})=255"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(timePeriodAnchor27);

  }

  @Test
  public void test114() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test114"); }


    org.jfree.chart.axis.NumberAxis3D numberAxis3D0 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Paint paint1 = org.jfree.chart.axis.Axis.DEFAULT_AXIS_LINE_PAINT;
    numberAxis3D0.setLabelPaint(paint1);
    org.jfree.chart.axis.NumberTickUnit numberTickUnit3 = org.jfree.chart.axis.NumberAxis.DEFAULT_TICK_UNIT;
    numberAxis3D0.setTickUnit(numberTickUnit3, false, true);
    numberAxis3D0.resizeRange(6.0d, 1.0d);
    numberAxis3D0.setAutoRange(false);
    java.awt.Stroke stroke12 = numberAxis3D0.getTickMarkStroke();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberTickUnit3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke12);

  }

  @Test
  public void test115() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test115"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    org.jfree.data.general.WaferMapDataset waferMapDataset31 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot32 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset31);
    org.jfree.chart.JFreeChart jFreeChart33 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent34 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot32, jFreeChart33);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment35 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment36 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement39 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment35, verticalAlignment36, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement40 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle41 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot32, (org.jfree.chart.block.Arrangement)flowArrangement39, (org.jfree.chart.block.Arrangement)borderArrangement40);
    org.jfree.chart.entity.TitleEntity titleEntity43 = new org.jfree.chart.entity.TitleEntity(shape7, (org.jfree.chart.title.Title)legendTitle41, "green");
    java.lang.Object obj44 = titleEntity43.clone();
    java.lang.Object obj45 = null;
    boolean b46 = titleEntity43.equals(obj45);
    java.lang.String str47 = titleEntity43.toString();
    org.jfree.chart.title.Title title48 = titleEntity43.getTitle();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b46 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str47 + "' != '" + "TitleEntity: tooltip = green"+ "'", str47.equals("TitleEntity: tooltip = green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(title48);

  }

  @Test
  public void test116() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test116"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    boolean b3 = xYBarRenderer1.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator5 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer1.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator5, true);
    java.lang.Object obj8 = standardXYToolTipGenerator5.clone();
    java.text.NumberFormat numberFormat9 = standardXYToolTipGenerator5.getXFormat();
    java.text.DateFormat dateFormat10 = standardXYToolTipGenerator5.getXDateFormat();
    java.lang.String str11 = standardXYToolTipGenerator5.getNullYString();
    org.jfree.data.xy.XYSeries xYSeries12 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection13 = new org.jfree.data.xy.XYSeriesCollection(xYSeries12);
    boolean b14 = xYSeriesCollection13.isAutoWidth();
    org.jfree.data.Range range16 = xYSeriesCollection13.getRangeBounds(true);
    xYSeriesCollection13.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis19 = new org.jfree.chart.axis.NumberAxis();
    numberAxis19.centerRange(100.0d);
    java.lang.Object obj22 = numberAxis19.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer23 = null;
    org.jfree.chart.plot.PolarPlot polarPlot24 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection13, (org.jfree.chart.axis.ValueAxis)numberAxis19, polarItemRenderer23);
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer25 = null;
    polarPlot24.setRenderer(polarItemRenderer25);
    java.awt.Font font28 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset29 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot30 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset29);
    org.jfree.chart.axis.ValueAxis valueAxis31 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot32 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis31);
    java.util.List list33 = combinedDomainXYPlot32.getAnnotations();
    waferMapPlot30.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot32);
    boolean b35 = combinedDomainXYPlot32.isNotify();
    org.jfree.chart.JFreeChart jFreeChart37 = new org.jfree.chart.JFreeChart("", font28, (org.jfree.chart.plot.Plot)combinedDomainXYPlot32, true);
    combinedDomainXYPlot32.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer40 = null;
    combinedDomainXYPlot32.setRenderer(xYItemRenderer40);
    boolean b42 = combinedDomainXYPlot32.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries43 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection44 = new org.jfree.data.time.TimeSeriesCollection(timeSeries43);
    combinedDomainXYPlot32.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection44);
    java.util.List list46 = timeSeriesCollection44.getSeries();
    org.jfree.data.Range range47 = org.jfree.data.general.DatasetUtilities.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection44);
    org.jfree.data.DomainOrder domainOrder48 = timeSeriesCollection44.getDomainOrder();
    org.jfree.data.Range range49 = org.jfree.data.general.DatasetUtilities.findDomainBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection44);
    polarPlot24.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection44);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.String str53 = standardXYToolTipGenerator5.generateLabelString((org.jfree.data.xy.XYDataset)timeSeriesCollection44, 2016, 255);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateFormat10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str11 + "' != '" + "null"+ "'", str11.equals("null"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b42 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range49);

  }

  @Test
  public void test117() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test117"); }


    org.jfree.data.category.CategoryDataset categoryDataset0 = null;
    boolean b1 = org.jfree.data.general.DatasetUtilities.isEmptyOrNull(categoryDataset0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);

  }

  @Test
  public void test118() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test118"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    java.awt.Graphics2D graphics2D4 = null;
    java.awt.geom.Rectangle2D rectangle2D5 = null;
    org.jfree.data.general.DefaultPieDataset defaultPieDataset6 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj7 = defaultPieDataset6.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D8 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset6);
    piePlot3D8.setIgnoreZeroValues(true);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo12 = null;
    org.jfree.chart.plot.PiePlotState piePlotState13 = piePlot3D2.initialise(graphics2D4, rectangle2D5, (org.jfree.chart.plot.PiePlot)piePlot3D8, (java.lang.Integer)1, plotRenderingInfo12);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer15 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier16 = xYAreaRenderer15.getDrawingSupplier();
    xYAreaRenderer15.setBaseCreateEntities(false);
    org.jfree.chart.event.RendererChangeEvent rendererChangeEvent19 = null;
    xYAreaRenderer15.notifyListeners(rendererChangeEvent19);
    boolean b21 = xYAreaRenderer15.getAutoPopulateSeriesFillPaint();
    java.awt.Paint paint23 = xYAreaRenderer15.getSeriesFillPaint(15);
    org.jfree.chart.plot.CategoryPlot categoryPlot24 = new org.jfree.chart.plot.CategoryPlot();
    boolean b25 = categoryPlot24.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge27 = categoryPlot24.getDomainAxisEdge(8);
    java.awt.Font font29 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset30 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot31 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset30);
    org.jfree.chart.axis.ValueAxis valueAxis32 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot33 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis32);
    java.util.List list34 = combinedDomainXYPlot33.getAnnotations();
    waferMapPlot31.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot33);
    org.jfree.chart.JFreeChart jFreeChart37 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font29, (org.jfree.chart.plot.Plot)combinedDomainXYPlot33, true);
    org.jfree.chart.axis.NumberAxis numberAxis39 = new org.jfree.chart.axis.NumberAxis();
    numberAxis39.centerRange(100.0d);
    combinedDomainXYPlot33.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis39);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier43 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot33.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier43);
    categoryPlot24.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier43);
    categoryPlot24.clearRangeMarkers(100);
    org.jfree.chart.util.RectangleInsets rectangleInsets48 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    categoryPlot24.setAxisOffset(rectangleInsets48);
    java.awt.Stroke stroke50 = categoryPlot24.getRangeGridlineStroke();
    org.jfree.chart.axis.NumberAxis3D numberAxis3D51 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Color color52 = org.jfree.chart.ChartColor.VERY_LIGHT_GREEN;
    numberAxis3D51.setTickMarkPaint((java.awt.Paint)color52);
    categoryPlot24.setRangeZeroBaselinePaint((java.awt.Paint)color52);
    xYAreaRenderer15.setBaseOutlinePaint((java.awt.Paint)color52, false);
    piePlot3D2.setBackgroundPaint((java.awt.Paint)color52);
    piePlot3D2.setPieIndex(0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(piePlotState13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b21 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color52);

  }

  @Test
  public void test119() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test119"); }


    java.awt.Paint paint1 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.LegendItem legendItem2 = new org.jfree.chart.LegendItem("1", paint1);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test120() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test120"); }


    org.jfree.data.category.CategoryDataset categoryDataset0 = null;
    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot1 = new org.jfree.chart.plot.MultiplePiePlot(categoryDataset0);
    double d2 = multiplePiePlot1.getLimit();
    org.jfree.chart.LegendItemCollection legendItemCollection3 = multiplePiePlot1.getLegendItems();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.LegendItem legendItem5 = legendItemCollection3.get((-9999));
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection3);

  }

  @Test
  public void test121() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test121"); }


    org.jfree.chart.axis.NumberAxis numberAxis0 = new org.jfree.chart.axis.NumberAxis();
    java.awt.Shape shape1 = numberAxis0.getDownArrow();
    org.jfree.chart.entity.ChartEntity chartEntity3 = new org.jfree.chart.entity.ChartEntity(shape1, "ThreadContext");
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    combinedDomainXYPlot5.setRangeGridlinesVisible(true);
    org.jfree.chart.util.RectangleEdge rectangleEdge10 = combinedDomainXYPlot5.getRangeAxisEdge(4);
    org.jfree.data.xy.XYDataset xYDataset12 = combinedDomainXYPlot5.getDataset(64);
    org.jfree.chart.axis.AxisLocation axisLocation13 = org.jfree.chart.axis.AxisLocation.TOP_OR_RIGHT;
    combinedDomainXYPlot5.setDomainAxisLocation(axisLocation13);
    org.jfree.chart.entity.PlotEntity plotEntity17 = new org.jfree.chart.entity.PlotEntity(shape1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, "8", "31-December-1969");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYDataset12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation13);

  }

  @Test
  public void test122() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test122"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.renderer.category.BarRenderer barRenderer2 = new org.jfree.chart.renderer.category.BarRenderer();
    double d3 = barRenderer2.getShadowXOffset();
    barRenderer2.setShadowXOffset(10.0d);
    org.jfree.chart.renderer.category.CategoryItemRenderer[] categoryItemRenderer_array6 = new org.jfree.chart.renderer.category.CategoryItemRenderer[] { barRenderer2 };
    categoryPlot0.setRenderers(categoryItemRenderer_array6);
    org.jfree.chart.plot.CategoryPlot categoryPlot8 = new org.jfree.chart.plot.CategoryPlot();
    boolean b9 = categoryPlot8.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge11 = categoryPlot8.getDomainAxisEdge(8);
    java.awt.Color color18 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke19 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color20 = java.awt.Color.orange;
    java.awt.Stroke stroke21 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker23 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color18, stroke19, (java.awt.Paint)color20, stroke21, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer24 = null;
    intervalMarker23.setGradientPaintTransformer(gradientPaintTransformer24);
    org.jfree.chart.util.RectangleInsets rectangleInsets26 = intervalMarker23.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis28 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets29 = categoryAxis28.getLabelInsets();
    intervalMarker23.setLabelOffset(rectangleInsets29);
    double d31 = intervalMarker23.getEndValue();
    org.jfree.chart.util.Layer layer32 = null;
    boolean b33 = categoryPlot8.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker23, layer32);
    org.jfree.chart.util.Layer layer34 = org.jfree.chart.util.Layer.BACKGROUND;
    categoryPlot0.addRangeMarker((org.jfree.chart.plot.Marker)intervalMarker23, layer34);
    org.jfree.data.general.DatasetGroup datasetGroup37 = new org.jfree.data.general.DatasetGroup("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]");
    boolean b38 = layer34.equals((java.lang.Object)datasetGroup37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d3 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(categoryItemRenderer_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d31 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(layer34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == false);

  }

  @Test
  public void test123() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test123"); }


    org.jfree.chart.block.LabelBlock labelBlock1 = new org.jfree.chart.block.LabelBlock("TextAnchor.CENTER");
    java.awt.Paint paint2 = labelBlock1.getPaint();
    org.jfree.chart.plot.PieLabelLinkStyle pieLabelLinkStyle3 = org.jfree.chart.plot.PieLabelLinkStyle.CUBIC_CURVE;
    org.jfree.chart.util.RectangleAnchor rectangleAnchor4 = org.jfree.chart.util.RectangleAnchor.LEFT;
    boolean b5 = pieLabelLinkStyle3.equals((java.lang.Object)rectangleAnchor4);
    labelBlock1.setTextAnchor(rectangleAnchor4);
    java.lang.String str7 = labelBlock1.getURLText();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(pieLabelLinkStyle3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleAnchor4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str7);

  }

  @Test
  public void test124() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test124"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    org.jfree.chart.axis.NumberAxis numberAxis31 = new org.jfree.chart.axis.NumberAxis();
    numberAxis31.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer35 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator36 = xYAreaRenderer35.getLegendItemToolTipGenerator();
    java.awt.Shape shape37 = xYAreaRenderer35.getBaseShape();
    numberAxis31.setUpArrow(shape37);
    numberAxis31.pan((-1.0d));
    java.awt.Paint paint41 = numberAxis31.getAxisLinePaint();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer43 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator44 = xYAreaRenderer43.getLegendItemToolTipGenerator();
    java.awt.Shape shape45 = xYAreaRenderer43.getBaseShape();
    java.awt.Shape shape48 = org.jfree.chart.util.ShapeUtilities.createTranslatedShape(shape45, 6.0d, 0.0d);
    numberAxis31.setRightArrow(shape48);
    org.jfree.chart.entity.AxisEntity axisEntity52 = new org.jfree.chart.entity.AxisEntity(shape7, (org.jfree.chart.axis.Axis)numberAxis31, "SeriesRenderingOrder.FORWARD", "hi!");
    org.jfree.chart.axis.Axis axis53 = axisEntity52.getAxis();
    boolean b54 = axis53.isAxisLineVisible();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axis53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b54 == true);

  }

  @Test
  public void test125() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test125"); }


    org.jfree.chart.axis.DateAxis dateAxis1 = new org.jfree.chart.axis.DateAxis("TextAnchor.TOP_CENTER");

  }

  @Test
  public void test126() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test126"); }


    org.jfree.chart.block.LabelBlock labelBlock1 = new org.jfree.chart.block.LabelBlock("TextAnchor.CENTER");
    java.awt.Paint paint2 = labelBlock1.getPaint();
    labelBlock1.setURLText("");
    org.jfree.chart.text.TextBlockAnchor textBlockAnchor5 = org.jfree.chart.text.TextBlockAnchor.BOTTOM_RIGHT;
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer7 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d8 = xYBarRenderer7.getMargin();
    boolean b9 = xYBarRenderer7.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator11 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer7.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator11, true);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator15 = null;
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator17 = new org.jfree.chart.urls.StandardXYURLGenerator("");
    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer18 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(100, xYToolTipGenerator15, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator17);
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer19 = new org.jfree.chart.renderer.xy.XYStepRenderer((org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator11, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator17);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer26 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator27 = xYAreaRenderer26.getLegendItemToolTipGenerator();
    java.awt.Shape shape28 = xYAreaRenderer26.getBaseShape();
    java.awt.Color color34 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke35 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color36 = java.awt.Color.orange;
    java.awt.Stroke stroke37 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker39 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color34, stroke35, (java.awt.Paint)color36, stroke37, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer40 = null;
    intervalMarker39.setGradientPaintTransformer(gradientPaintTransformer40);
    org.jfree.chart.util.RectangleInsets rectangleInsets42 = intervalMarker39.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis44 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets45 = categoryAxis44.getLabelInsets();
    intervalMarker39.setLabelOffset(rectangleInsets45);
    double d47 = intervalMarker39.getEndValue();
    java.awt.Paint paint48 = intervalMarker39.getOutlinePaint();
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer49 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    boolean b50 = xYStepRenderer49.getUseFillPaint();
    xYStepRenderer49.setDrawSeriesLineAsPath(false);
    java.awt.Stroke stroke56 = xYStepRenderer49.getItemOutlineStroke(10, 15, false);
    java.awt.Font font60 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset61 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot62 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset61);
    org.jfree.chart.axis.ValueAxis valueAxis63 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot64 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis63);
    java.util.List list65 = combinedDomainXYPlot64.getAnnotations();
    waferMapPlot62.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot64);
    org.jfree.chart.JFreeChart jFreeChart68 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font60, (org.jfree.chart.plot.Plot)combinedDomainXYPlot64, true);
    java.awt.Color color72 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment73 = new org.jfree.chart.text.TextFragment("hi!", font60, (java.awt.Paint)color72);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer75 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier76 = xYAreaRenderer75.getDrawingSupplier();
    java.awt.Stroke stroke77 = xYAreaRenderer75.getBaseStroke();
    org.jfree.chart.plot.ValueMarker valueMarker78 = new org.jfree.chart.plot.ValueMarker(0.0d, (java.awt.Paint)color72, stroke77);
    org.jfree.chart.LegendItem legendItem79 = new org.jfree.chart.LegendItem("1", "RectangleConstraint[LengthConstraintType.FIXED: width=100.0, height=0.0]", "ERROR : Relative To String", "LengthConstraintType.FIXED", shape28, paint48, stroke56, (java.awt.Paint)color72);
    xYStepRenderer19.setSeriesItemLabelPaint(64, (java.awt.Paint)color72);
    boolean b81 = textBlockAnchor5.equals((java.lang.Object)64);
    labelBlock1.setContentAlignmentPoint(textBlockAnchor5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textBlockAnchor5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d47 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b50 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier76);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b81 == false);

  }

  @Test
  public void test127() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test127"); }


    org.jfree.chart.axis.NumberAxis3D numberAxis3D0 = new org.jfree.chart.axis.NumberAxis3D();
    org.jfree.data.Range range2 = null;
    org.jfree.chart.block.RectangleConstraint rectangleConstraint3 = new org.jfree.chart.block.RectangleConstraint(100.0d, range2);
    org.jfree.chart.block.LengthConstraintType lengthConstraintType4 = rectangleConstraint3.getWidthConstraintType();
    org.jfree.data.time.DateRange dateRange7 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange10 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b11 = dateRange7.intersects((org.jfree.data.Range)dateRange10);
    org.jfree.chart.block.RectangleConstraint rectangleConstraint12 = rectangleConstraint3.toRangeHeight((org.jfree.data.Range)dateRange10);
    numberAxis3D0.setDefaultAutoRange((org.jfree.data.Range)dateRange10);
    numberAxis3D0.resizeRange(0.2d);
    float f16 = numberAxis3D0.getMinorTickMarkOutsideLength();
    org.jfree.data.RangeType rangeType17 = org.jfree.data.RangeType.FULL;
    numberAxis3D0.setRangeType(rangeType17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleConstraint12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f16 == 2.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rangeType17);

  }

  @Test
  public void test128() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test128"); }


    int i0 = org.jfree.data.time.MonthConstants.SEPTEMBER;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 9);

  }

  @Test
  public void test129() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test129"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    org.jfree.data.time.TimeSeries timeSeries11 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection12 = new org.jfree.data.time.TimeSeriesCollection(timeSeries11);
    timeSeriesCollection12.validateObject();
    java.lang.Comparable comparable14 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer15 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.data.general.Dataset)timeSeriesCollection12, comparable14);
    org.jfree.data.general.Dataset dataset16 = legendItemBlockContainer15.getDataset();
    legendItemBlockContainer15.setURLText("DateTickMarkPosition.END");
    org.jfree.chart.util.RectangleInsets rectangleInsets19 = legendItemBlockContainer15.getPadding();
    double d20 = rectangleInsets19.getLeft();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dataset16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d20 == 0.0d);

  }

  @Test
  public void test130() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test130"); }


    int i0 = org.jfree.data.time.MonthConstants.NOVEMBER;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 11);

  }

  @Test
  public void test131() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test131"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = xYStepRenderer0.getSeriesPositiveItemLabelPosition(3);
    java.lang.Boolean b4 = xYStepRenderer0.getSeriesLinesVisible(0);
    java.lang.Boolean b6 = xYStepRenderer0.getSeriesShapesFilled(1);
    org.jfree.chart.labels.XYItemLabelGenerator xYItemLabelGenerator7 = xYStepRenderer0.getBaseItemLabelGenerator();
    java.awt.Paint paint9 = xYStepRenderer0.lookupSeriesFillPaint((-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYItemLabelGenerator7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint9);

  }

  @Test
  public void test132() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test132"); }


    org.jfree.chart.util.GradientPaintTransformType gradientPaintTransformType0 = org.jfree.chart.util.GradientPaintTransformType.CENTER_HORIZONTAL;
    java.lang.String str1 = gradientPaintTransformType0.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(gradientPaintTransformType0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "GradientPaintTransformType.CENTER_HORIZONTAL"+ "'", str1.equals("GradientPaintTransformType.CENTER_HORIZONTAL"));

  }

  @Test
  public void test133() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test133"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer13 = null;
    combinedDomainXYPlot5.setRenderer(xYItemRenderer13);
    boolean b15 = combinedDomainXYPlot5.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries16 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection17 = new org.jfree.data.time.TimeSeriesCollection(timeSeries16);
    combinedDomainXYPlot5.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    java.util.List list19 = timeSeriesCollection17.getSeries();
    org.jfree.data.Range range20 = org.jfree.data.general.DatasetUtilities.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    org.jfree.data.DomainOrder domainOrder21 = timeSeriesCollection17.getDomainOrder();
    double d23 = timeSeriesCollection17.getDomainUpperBound(true);
    java.lang.Number number24 = org.jfree.data.general.DatasetUtilities.findMaximumRangeValue((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d23, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(number24);

  }

  @Test
  public void test134() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test134"); }


    org.jfree.chart.renderer.category.BarRenderer3D barRenderer3D2 = new org.jfree.chart.renderer.category.BarRenderer3D(1.0E-8d, 1.0d);
    java.awt.Paint paint3 = barRenderer3D2.getWallPaint();
    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot4 = new org.jfree.chart.plot.MultiplePiePlot();
    java.awt.Paint paint5 = multiplePiePlot4.getOutlinePaint();
    java.awt.Shape shape6 = multiplePiePlot4.getLegendItemShape();
    org.jfree.chart.axis.NumberAxis numberAxis7 = new org.jfree.chart.axis.NumberAxis();
    numberAxis7.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer11 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator12 = xYAreaRenderer11.getLegendItemToolTipGenerator();
    java.awt.Shape shape13 = xYAreaRenderer11.getBaseShape();
    numberAxis7.setUpArrow(shape13);
    numberAxis7.pan((-1.0d));
    java.awt.Paint paint17 = numberAxis7.getAxisLinePaint();
    multiplePiePlot4.setAggregatedItemsPaint(paint17);
    barRenderer3D2.setWallPaint(paint17);
    org.jfree.chart.axis.CategoryAxis categoryAxis21 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset22 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot23 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset22);
    org.jfree.chart.axis.ValueAxis valueAxis24 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot25 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis24);
    java.util.List list26 = combinedDomainXYPlot25.getAnnotations();
    waferMapPlot23.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot25);
    int i28 = combinedDomainXYPlot25.getSeriesCount();
    categoryAxis21.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot25);
    java.awt.Color color36 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke37 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color38 = java.awt.Color.orange;
    java.awt.Stroke stroke39 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker41 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color36, stroke37, (java.awt.Paint)color38, stroke39, 0.0f);
    java.awt.Paint paint42 = intervalMarker41.getOutlinePaint();
    org.jfree.chart.util.Layer layer43 = null;
    combinedDomainXYPlot25.addRangeMarker(0, (org.jfree.chart.plot.Marker)intervalMarker41, layer43);
    combinedDomainXYPlot25.clearRangeMarkers();
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D47 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke48 = categoryAxis3D47.getTickMarkStroke();
    combinedDomainXYPlot25.setDomainGridlineStroke(stroke48);
    barRenderer3D2.setSeriesOutlineStroke(5, stroke48, false);
    org.jfree.chart.annotations.CategoryAnnotation categoryAnnotation52 = null;
    // The following exception was thrown during execution in test generation
    try {
      barRenderer3D2.addAnnotation(categoryAnnotation52);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i28 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke48);

  }

  @Test
  public void test135() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test135"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer13 = null;
    combinedDomainXYPlot5.setRenderer(xYItemRenderer13);
    boolean b15 = combinedDomainXYPlot5.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries16 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection17 = new org.jfree.data.time.TimeSeriesCollection(timeSeries16);
    combinedDomainXYPlot5.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    org.jfree.chart.axis.AxisSpace axisSpace19 = null;
    combinedDomainXYPlot5.setFixedDomainAxisSpace(axisSpace19);
    combinedDomainXYPlot5.mapDatasetToDomainAxis(2, 64);
    org.jfree.chart.util.RectangleEdge rectangleEdge25 = combinedDomainXYPlot5.getDomainAxisEdge(100);
    org.jfree.chart.plot.CategoryPlot categoryPlot27 = new org.jfree.chart.plot.CategoryPlot();
    boolean b28 = categoryPlot27.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge30 = categoryPlot27.getDomainAxisEdge(8);
    java.awt.Color color37 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke38 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color39 = java.awt.Color.orange;
    java.awt.Stroke stroke40 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker42 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color37, stroke38, (java.awt.Paint)color39, stroke40, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer43 = null;
    intervalMarker42.setGradientPaintTransformer(gradientPaintTransformer43);
    org.jfree.chart.util.RectangleInsets rectangleInsets45 = intervalMarker42.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis47 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets48 = categoryAxis47.getLabelInsets();
    intervalMarker42.setLabelOffset(rectangleInsets48);
    double d50 = intervalMarker42.getEndValue();
    org.jfree.chart.util.Layer layer51 = null;
    boolean b52 = categoryPlot27.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker42, layer51);
    boolean b53 = categoryPlot27.isRangeCrosshairLockedOnData();
    org.jfree.chart.axis.AxisLocation axisLocation54 = categoryPlot27.getDomainAxisLocation();
    // The following exception was thrown during execution in test generation
    try {
      combinedDomainXYPlot5.setDomainAxisLocation((-25560), axisLocation54, false);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d50 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b52 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b53 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation54);

  }

  @Test
  public void test136() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test136"); }


    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection0 = new org.jfree.data.xy.XYSeriesCollection();

  }

  @Test
  public void test137() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test137"); }


    org.jfree.data.category.CategoryDataset categoryDataset0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.general.PieDataset pieDataset2 = org.jfree.data.general.DatasetUtilities.createPieDatasetForRow(categoryDataset0, 0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test138() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test138"); }


    org.jfree.chart.title.TextTitle textTitle1 = new org.jfree.chart.title.TextTitle("");
    java.awt.Graphics2D graphics2D2 = null;
    org.jfree.data.Range range4 = null;
    org.jfree.chart.block.LengthConstraintType lengthConstraintType5 = org.jfree.chart.block.LengthConstraintType.NONE;
    org.jfree.data.time.DateRange dateRange9 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange12 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b13 = dateRange9.intersects((org.jfree.data.Range)dateRange12);
    org.jfree.data.Range range15 = org.jfree.data.Range.expandToInclude((org.jfree.data.Range)dateRange9, 1.0d);
    org.jfree.chart.block.LengthConstraintType lengthConstraintType16 = org.jfree.chart.block.LengthConstraintType.NONE;
    org.jfree.chart.block.RectangleConstraint rectangleConstraint17 = new org.jfree.chart.block.RectangleConstraint(2.0d, range4, lengthConstraintType5, 0.0d, range15, lengthConstraintType16);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.util.Size2D size2D18 = textTitle1.arrange(graphics2D2, rectangleConstraint17);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType16);

  }

  @Test
  public void test139() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test139"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
    numberAxis15.centerRange(100.0d);
    combinedDomainXYPlot9.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis15);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier19 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot9.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    org.jfree.data.category.CategoryDataset categoryDataset22 = null;
    org.jfree.chart.renderer.category.CategoryItemRenderer categoryItemRenderer23 = categoryPlot0.getRendererForDataset(categoryDataset22);
    java.awt.Color color30 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke31 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color32 = java.awt.Color.orange;
    java.awt.Stroke stroke33 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker35 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color30, stroke31, (java.awt.Paint)color32, stroke33, 0.0f);
    java.awt.Paint paint36 = intervalMarker35.getPaint();
    org.jfree.chart.util.Layer layer37 = null;
    boolean b38 = categoryPlot0.removeDomainMarker(8, (org.jfree.chart.plot.Marker)intervalMarker35, layer37);
    categoryPlot0.setDrawSharedDomainAxis(false);
    org.jfree.chart.axis.AxisLocation axisLocation41 = categoryPlot0.getDomainAxisLocation();
    org.jfree.chart.axis.AxisLocation axisLocation42 = categoryPlot0.getDomainAxisLocation();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryItemRenderer23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation42);

  }

  @Test
  public void test140() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test140"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    boolean b11 = combinedDomainXYPlot5.isRangeZoomable();
    combinedDomainXYPlot5.configureRangeAxes();
    org.jfree.chart.plot.Marker marker13 = null;
    java.awt.Font font15 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset16 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot17 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset16);
    org.jfree.chart.axis.ValueAxis valueAxis18 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot19 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis18);
    java.util.List list20 = combinedDomainXYPlot19.getAnnotations();
    waferMapPlot17.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot19);
    boolean b22 = combinedDomainXYPlot19.isNotify();
    org.jfree.chart.JFreeChart jFreeChart24 = new org.jfree.chart.JFreeChart("", font15, (org.jfree.chart.plot.Plot)combinedDomainXYPlot19, true);
    combinedDomainXYPlot19.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.axis.AxisLocation axisLocation28 = null;
    combinedDomainXYPlot19.setDomainAxisLocation(3, axisLocation28, false);
    org.jfree.chart.axis.NumberAxis numberAxis32 = new org.jfree.chart.axis.NumberAxis();
    numberAxis32.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer36 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator37 = xYAreaRenderer36.getLegendItemToolTipGenerator();
    java.awt.Shape shape38 = xYAreaRenderer36.getBaseShape();
    numberAxis32.setUpArrow(shape38);
    numberAxis32.pan((-1.0d));
    boolean b42 = numberAxis32.getAutoRangeIncludesZero();
    combinedDomainXYPlot19.setDomainAxis(2, (org.jfree.chart.axis.ValueAxis)numberAxis32, false);
    org.jfree.chart.util.Layer layer46 = org.jfree.chart.util.Layer.FOREGROUND;
    java.util.Collection collection47 = combinedDomainXYPlot19.getDomainMarkers(8, layer46);
    // The following exception was thrown during execution in test generation
    try {
      boolean b48 = combinedDomainXYPlot5.removeRangeMarker(marker13, layer46);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b42 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(layer46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection47);

  }

  @Test
  public void test141() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test141"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis0 = new org.jfree.chart.axis.CategoryAxis();
    categoryAxis0.setVisible(false);
    org.jfree.chart.util.RectangleInsets rectangleInsets3 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d4 = rectangleInsets3.getLeft();
    double d6 = rectangleInsets3.calculateLeftOutset(1.0d);
    categoryAxis0.setLabelInsets(rectangleInsets3, true);
    java.awt.Font font10 = null;
    categoryAxis0.setTickLabelFont((java.lang.Comparable)900000L, font10);
    org.jfree.chart.plot.CategoryPlot categoryPlot12 = new org.jfree.chart.plot.CategoryPlot();
    boolean b13 = categoryPlot12.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge15 = categoryPlot12.getDomainAxisEdge(8);
    java.awt.Color color22 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke23 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color24 = java.awt.Color.orange;
    java.awt.Stroke stroke25 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker27 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color22, stroke23, (java.awt.Paint)color24, stroke25, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer28 = null;
    intervalMarker27.setGradientPaintTransformer(gradientPaintTransformer28);
    org.jfree.chart.util.RectangleInsets rectangleInsets30 = intervalMarker27.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis32 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets33 = categoryAxis32.getLabelInsets();
    intervalMarker27.setLabelOffset(rectangleInsets33);
    double d35 = intervalMarker27.getEndValue();
    org.jfree.chart.util.Layer layer36 = null;
    boolean b37 = categoryPlot12.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker27, layer36);
    boolean b38 = categoryAxis0.equals((java.lang.Object)intervalMarker27);
    java.awt.Graphics2D graphics2D39 = null;
    org.jfree.chart.axis.AxisState axisState41 = new org.jfree.chart.axis.AxisState(10.0d);
    axisState41.cursorUp(0.2d);
    axisState41.setMax(4.5d);
    java.awt.Font font48 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset49 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot50 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset49);
    org.jfree.chart.axis.ValueAxis valueAxis51 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot52 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis51);
    java.util.List list53 = combinedDomainXYPlot52.getAnnotations();
    waferMapPlot50.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot52);
    boolean b55 = combinedDomainXYPlot52.isNotify();
    org.jfree.chart.JFreeChart jFreeChart57 = new org.jfree.chart.JFreeChart("", font48, (org.jfree.chart.plot.Plot)combinedDomainXYPlot52, true);
    org.jfree.chart.title.TextTitle textTitle58 = new org.jfree.chart.title.TextTitle("", font48);
    textTitle58.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame61 = textTitle58.getFrame();
    java.lang.String str62 = textTitle58.getID();
    java.awt.geom.Rectangle2D rectangle2D63 = textTitle58.getBounds();
    org.jfree.chart.axis.AxisSpace axisSpace64 = new org.jfree.chart.axis.AxisSpace();
    org.jfree.data.DomainOrder domainOrder65 = org.jfree.data.DomainOrder.DESCENDING;
    boolean b66 = axisSpace64.equals((java.lang.Object)domainOrder65);
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D69 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke70 = categoryAxis3D69.getTickMarkStroke();
    java.awt.Graphics2D graphics2D71 = null;
    java.awt.geom.Rectangle2D rectangle2D73 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge74 = org.jfree.chart.util.RectangleEdge.LEFT;
    org.jfree.chart.axis.AxisState axisState76 = new org.jfree.chart.axis.AxisState(1.0d);
    double d77 = axisState76.getCursor();
    axisState76.cursorLeft(0.2d);
    categoryAxis3D69.drawTickMarks(graphics2D71, 7.0d, rectangle2D73, rectangleEdge74, axisState76);
    axisSpace64.ensureAtLeast(6.0d, rectangleEdge74);
    java.util.List list82 = categoryAxis0.refreshTicks(graphics2D39, axisState41, rectangle2D63, rectangleEdge74);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d35 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b55 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b66 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge74);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d77 == 1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list82);

  }

  @Test
  public void test142() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test142"); }


    org.jfree.chart.block.LengthConstraintType lengthConstraintType0 = org.jfree.chart.block.LengthConstraintType.RANGE;
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer2 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d3 = xYBarRenderer2.getMargin();
    boolean b4 = xYBarRenderer2.getAutoPopulateSeriesShape();
    org.jfree.chart.plot.CategoryPlot categoryPlot5 = new org.jfree.chart.plot.CategoryPlot();
    boolean b6 = categoryPlot5.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge8 = categoryPlot5.getDomainAxisEdge(8);
    categoryPlot5.clearDomainMarkers();
    xYBarRenderer2.removeChangeListener((org.jfree.chart.event.RendererChangeListener)categoryPlot5);
    org.jfree.chart.axis.ValueAxis valueAxis11 = categoryPlot5.getRangeAxis();
    java.lang.Object obj12 = categoryPlot5.clone();
    boolean b13 = lengthConstraintType0.equals((java.lang.Object)categoryPlot5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d3 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(valueAxis11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);

  }

  @Test
  public void test143() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test143"); }


    org.jfree.chart.util.LogFormat logFormat0 = new org.jfree.chart.util.LogFormat();
    logFormat0.setMinimumIntegerDigits(6);

  }

  @Test
  public void test144() {}
// Defects4J: flaky method
//   @Test
//   public void test144() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test144"); }
// 
// 
//     org.jfree.data.xy.DefaultXYDataset defaultXYDataset0 = new org.jfree.data.xy.DefaultXYDataset();
//     org.jfree.chart.util.PaintMap paintMap1 = new org.jfree.chart.util.PaintMap();
//     org.jfree.data.time.DateRange dateRange4 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d5 = dateRange4.getLength();
//     long long6 = dateRange4.getLowerMillis();
//     double d7 = dateRange4.getLength();
//     java.lang.String str8 = dateRange4.toString();
//     java.util.Date date9 = dateRange4.getUpperDate();
//     java.util.TimeZone timeZone10 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year11 = new org.jfree.data.time.Year(date9, timeZone10);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod12 = year11.next();
//     java.awt.Paint paint13 = paintMap1.getPaint((java.lang.Comparable)year11);
//     int i14 = defaultXYDataset0.indexOf((java.lang.Comparable)year11);
//     // The following exception was thrown during execution in test generation
//     try {
//       java.lang.Comparable comparable16 = defaultXYDataset0.getSeriesKey((-25560));
//       org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
//     } catch (java.lang.IllegalArgumentException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d5 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long6 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d7 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str8 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str8.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date9);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(paint13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i14 == (-1));
// 
//   }

  @Test
  public void test145() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test145"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis0 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset1 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot2 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset1);
    org.jfree.chart.axis.ValueAxis valueAxis3 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot4 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis3);
    java.util.List list5 = combinedDomainXYPlot4.getAnnotations();
    waferMapPlot2.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot4);
    int i7 = combinedDomainXYPlot4.getSeriesCount();
    categoryAxis0.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot4);
    java.awt.Color color15 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke16 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color17 = java.awt.Color.orange;
    java.awt.Stroke stroke18 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker20 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color15, stroke16, (java.awt.Paint)color17, stroke18, 0.0f);
    java.awt.Paint paint21 = intervalMarker20.getOutlinePaint();
    org.jfree.chart.util.Layer layer22 = null;
    combinedDomainXYPlot4.addRangeMarker(0, (org.jfree.chart.plot.Marker)intervalMarker20, layer22);
    combinedDomainXYPlot4.clearRangeMarkers();
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D26 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke27 = categoryAxis3D26.getTickMarkStroke();
    combinedDomainXYPlot4.setDomainGridlineStroke(stroke27);
    combinedDomainXYPlot4.setDomainZeroBaselineVisible(true);
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer31 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    xYStepRenderer31.setSeriesShapesFilled(15, false);
    boolean b37 = xYStepRenderer31.getItemLineVisible(1, 8);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator38 = xYStepRenderer31.getBaseToolTipGenerator();
    int i39 = xYStepRenderer31.getPassCount();
    int i40 = combinedDomainXYPlot4.getIndexOf((org.jfree.chart.renderer.xy.XYItemRenderer)xYStepRenderer31);
    combinedDomainXYPlot4.setRangePannable(false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYToolTipGenerator38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i39 == 2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i40 == (-1));

  }

  @Test
  public void test146() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test146"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    org.jfree.chart.plot.Plot plot2 = combinedDomainXYPlot1.getRootPlot();
    org.jfree.chart.axis.ValueAxis valueAxis3 = null;
    int i4 = combinedDomainXYPlot1.getRangeAxisIndex(valueAxis3);
    org.jfree.data.xy.XYSeries xYSeries6 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection7 = new org.jfree.data.xy.XYSeriesCollection(xYSeries6);
    boolean b8 = xYSeriesCollection7.isAutoWidth();
    org.jfree.data.Range range10 = xYSeriesCollection7.getRangeBounds(true);
    combinedDomainXYPlot1.setDataset(0, (org.jfree.data.xy.XYDataset)xYSeriesCollection7);
    org.jfree.data.xy.IntervalXYDelegate intervalXYDelegate13 = new org.jfree.data.xy.IntervalXYDelegate((org.jfree.data.xy.XYDataset)xYSeriesCollection7, false);
    double d15 = xYSeriesCollection7.getDomainUpperBound(true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d15, Double.NaN, 0);

  }

  @Test
  public void test147() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test147"); }


    java.awt.Color color5 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke6 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color7 = java.awt.Color.orange;
    java.awt.Stroke stroke8 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker10 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color5, stroke6, (java.awt.Paint)color7, stroke8, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer11 = null;
    intervalMarker10.setGradientPaintTransformer(gradientPaintTransformer11);
    org.jfree.chart.axis.ValueAxis valueAxis13 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot14 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis13);
    java.awt.Color color15 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    java.awt.Stroke stroke16 = org.jfree.chart.plot.CategoryPlot.DEFAULT_CROSSHAIR_STROKE;
    org.jfree.chart.util.RectangleInsets rectangleInsets17 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.chart.util.UnitType unitType18 = rectangleInsets17.getUnitType();
    double d20 = rectangleInsets17.calculateLeftOutset(0.0d);
    org.jfree.chart.block.LineBorder lineBorder21 = new org.jfree.chart.block.LineBorder((java.awt.Paint)color15, stroke16, rectangleInsets17);
    combinedDomainXYPlot14.setAxisOffset(rectangleInsets17);
    double d24 = rectangleInsets17.calculateBottomOutset(1.0E-8d);
    intervalMarker10.setLabelOffset(rectangleInsets17);
    double d27 = rectangleInsets17.calculateBottomInset(0.0d);
    java.awt.Font font29 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset30 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot31 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset30);
    org.jfree.chart.axis.ValueAxis valueAxis32 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot33 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis32);
    java.util.List list34 = combinedDomainXYPlot33.getAnnotations();
    waferMapPlot31.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot33);
    boolean b36 = combinedDomainXYPlot33.isNotify();
    org.jfree.chart.JFreeChart jFreeChart38 = new org.jfree.chart.JFreeChart("", font29, (org.jfree.chart.plot.Plot)combinedDomainXYPlot33, true);
    java.awt.Stroke stroke39 = jFreeChart38.getBorderStroke();
    java.awt.Paint[] paint_array40 = null;
    org.jfree.chart.axis.ValueAxis valueAxis41 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot42 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis41);
    java.util.List list43 = combinedDomainXYPlot42.getAnnotations();
    combinedDomainXYPlot42.setRangeGridlinesVisible(true);
    java.awt.Color color46 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    combinedDomainXYPlot42.setRangeTickBandPaint((java.awt.Paint)color46);
    java.awt.Paint[] paint_array48 = new java.awt.Paint[] { color46 };
    java.awt.Shape shape56 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color58 = java.awt.Color.green;
    java.awt.Color color60 = java.awt.Color.green;
    java.awt.Color color66 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke67 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color68 = java.awt.Color.orange;
    java.awt.Stroke stroke69 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker71 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color66, stroke67, (java.awt.Paint)color68, stroke69, 0.0f);
    java.awt.Shape shape75 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke76 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color77 = java.awt.Color.green;
    java.lang.String str78 = org.jfree.chart.util.PaintUtilities.colorToString(color77);
    org.jfree.chart.LegendItem legendItem79 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape56, true, (java.awt.Paint)color58, false, (java.awt.Paint)color60, stroke67, true, shape75, stroke76, (java.awt.Paint)color77);
    java.awt.Paint[] paint_array80 = new java.awt.Paint[] { color58 };
    java.awt.Stroke[] stroke_array81 = null;
    java.awt.Stroke stroke82 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Stroke[] stroke_array83 = new java.awt.Stroke[] { stroke82 };
    java.awt.Shape shape86 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Shape[] shape_array87 = new java.awt.Shape[] { shape86 };
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier88 = new org.jfree.chart.plot.DefaultDrawingSupplier(paint_array40, paint_array48, paint_array80, stroke_array81, stroke_array83, shape_array87);
    java.awt.Paint paint89 = defaultDrawingSupplier88.getNextOutlinePaint();
    jFreeChart38.setBackgroundPaint(paint89);
    boolean b91 = rectangleInsets17.equals((java.lang.Object)jFreeChart38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(unitType18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d20 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d24 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color68);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke76);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str78 + "' != '" + "green"+ "'", str78.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint_array80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke_array83);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape_array87);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint89);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b91 == false);

  }

  @Test
  public void test148() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test148"); }


    java.awt.Color color0 = org.jfree.chart.ChartColor.VERY_LIGHT_CYAN;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color0);

  }

  @Test
  public void test149() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test149"); }


    org.jfree.data.time.TimeSeries timeSeries3 = new org.jfree.data.time.TimeSeries((java.lang.Comparable)"hi!", "AxisLocation.TOP_OR_RIGHT", "SeriesRenderingOrder.FORWARD");
    int i4 = timeSeries3.getMaximumItemCount();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem6 = timeSeries3.getDataItem(12);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 2147483647);

  }

  @Test
  public void test150() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test150"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis1 = new org.jfree.chart.axis.CategoryAxis("");
    boolean b2 = categoryAxis1.isAxisLineVisible();
    java.awt.Paint paint3 = categoryAxis1.getTickMarkPaint();
    categoryAxis1.configure();
    categoryAxis1.setLabelToolTip("?hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!=-1&amp;=14");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);

  }

  @Test
  public void test151() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test151"); }


    org.jfree.chart.resources.JFreeChartResources jFreeChartResources0 = new org.jfree.chart.resources.JFreeChartResources();
    boolean b2 = jFreeChartResources0.containsKey("TextBlockAnchor.BOTTOM_RIGHT");
    java.util.Enumeration enumeration3 = jFreeChartResources0.getKeys();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(enumeration3);

  }

  @Test
  public void test152() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test152"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    boolean b1 = xYStepRenderer0.getUseFillPaint();
    xYStepRenderer0.setDrawSeriesLineAsPath(false);
    java.awt.Paint paint7 = xYStepRenderer0.getItemFillPaint(2, 8, false);
    java.awt.Graphics2D graphics2D8 = null;
    java.awt.geom.Rectangle2D rectangle2D9 = null;
    org.jfree.chart.plot.XYPlot xYPlot10 = null;
    org.jfree.data.general.WaferMapDataset waferMapDataset11 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot12 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset11);
    org.jfree.chart.JFreeChart jFreeChart13 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent14 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot12, jFreeChart13);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment15 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment16 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement19 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment15, verticalAlignment16, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement20 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle21 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot12, (org.jfree.chart.block.Arrangement)flowArrangement19, (org.jfree.chart.block.Arrangement)borderArrangement20);
    org.jfree.data.time.TimeSeries timeSeries22 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection23 = new org.jfree.data.time.TimeSeriesCollection(timeSeries22);
    timeSeriesCollection23.validateObject();
    java.lang.Comparable comparable25 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer26 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement19, (org.jfree.data.general.Dataset)timeSeriesCollection23, comparable25);
    timeSeriesCollection23.validateObject();
    org.jfree.chart.axis.ValueAxis valueAxis28 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot29 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis28);
    org.jfree.chart.plot.PlotOrientation plotOrientation30 = combinedDomainXYPlot29.getOrientation();
    boolean b31 = combinedDomainXYPlot29.isDomainCrosshairLockedOnData();
    org.jfree.chart.entity.EntityCollection entityCollection33 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo34 = new org.jfree.chart.ChartRenderingInfo(entityCollection33);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo35 = chartRenderingInfo34.getPlotInfo();
    java.awt.geom.Point2D point2D36 = null;
    combinedDomainXYPlot29.panDomainAxes(4.5d, plotRenderingInfo35, point2D36);
    int i38 = plotRenderingInfo35.getSubplotCount();
    org.jfree.chart.entity.EntityCollection entityCollection39 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo40 = new org.jfree.chart.ChartRenderingInfo(entityCollection39);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo41 = chartRenderingInfo40.getPlotInfo();
    plotRenderingInfo35.addSubplotInfo(plotRenderingInfo41);
    org.jfree.chart.renderer.xy.XYItemRendererState xYItemRendererState43 = xYStepRenderer0.initialise(graphics2D8, rectangle2D9, xYPlot10, (org.jfree.data.xy.XYDataset)timeSeriesCollection23, plotRenderingInfo41);
    org.jfree.chart.plot.XYCrosshairState xYCrosshairState44 = xYItemRendererState43.getCrosshairState();
    boolean b45 = xYItemRendererState43.getProcessVisibleItemsOnly();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i38 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotRenderingInfo41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(xYItemRendererState43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYCrosshairState44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b45 == true);

  }

  @Test
  public void test153() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test153"); }


    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator1 = null;
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator3 = new org.jfree.chart.urls.StandardXYURLGenerator("");
    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer4 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(100, xYToolTipGenerator1, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator3);
    xYStepAreaRenderer4.setPlotArea(true);
    java.lang.Object obj7 = null;
    boolean b8 = xYStepAreaRenderer4.equals(obj7);
    boolean b9 = xYStepAreaRenderer4.getBaseItemLabelsVisible();
    boolean b10 = xYStepAreaRenderer4.isOutline();
    boolean b11 = xYStepAreaRenderer4.isOutline();
    boolean b12 = xYStepAreaRenderer4.getPlotArea();
    boolean b13 = xYStepAreaRenderer4.getAutoPopulateSeriesFillPaint();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);

  }

  @Test
  public void test154() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test154"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = xYStepRenderer0.getSeriesPositiveItemLabelPosition(3);
    org.jfree.chart.axis.NumberAxis3D numberAxis3D3 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Color color4 = org.jfree.chart.ChartColor.VERY_LIGHT_GREEN;
    numberAxis3D3.setTickMarkPaint((java.awt.Paint)color4);
    boolean b6 = itemLabelPosition2.equals((java.lang.Object)numberAxis3D3);
    numberAxis3D3.setVerticalTickLabels(false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);

  }

  @Test
  public void test155() {}
// Defects4J: flaky method
//   @Test
//   public void test155() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test155"); }
// 
// 
//     org.jfree.data.time.Month month1 = new org.jfree.data.time.Month();
//     int i2 = month1.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem4 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month1, (java.lang.Number)8);
//     long long5 = month1.getFirstMillisecond();
//     org.jfree.data.time.Month month6 = new org.jfree.data.time.Month();
//     int i7 = month6.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis8 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month1, (org.jfree.data.time.RegularTimePeriod)month6);
//     float f9 = periodAxis8.getMinorTickMarkInsideLength();
//     java.lang.Object obj10 = periodAxis8.clone();
//     periodAxis8.zoomRange(1.0E-8d, 1.0E-8d);
//     org.jfree.data.Range range14 = periodAxis8.getDefaultAutoRange();
//     boolean b17 = range14.intersects(1.0E-8d, 300002.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i2 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i7 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f9 == 0.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(range14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b17 == true);
// 
//   }

  @Test
  public void test156() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test156"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    java.awt.Graphics2D graphics2D4 = null;
    java.awt.geom.Rectangle2D rectangle2D5 = null;
    org.jfree.data.general.DefaultPieDataset defaultPieDataset6 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj7 = defaultPieDataset6.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D8 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset6);
    piePlot3D8.setIgnoreZeroValues(true);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo12 = null;
    org.jfree.chart.plot.PiePlotState piePlotState13 = piePlot3D2.initialise(graphics2D4, rectangle2D5, (org.jfree.chart.plot.PiePlot)piePlot3D8, (java.lang.Integer)1, plotRenderingInfo12);
    org.jfree.chart.labels.PieSectionLabelGenerator pieSectionLabelGenerator14 = piePlot3D8.getLegendLabelToolTipGenerator();
    org.jfree.chart.util.RectangleInsets rectangleInsets15 = piePlot3D8.getSimpleLabelOffset();
    org.jfree.chart.axis.ValueAxis valueAxis17 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot18 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis17);
    org.jfree.chart.plot.Plot plot19 = combinedDomainXYPlot18.getRootPlot();
    org.jfree.chart.LegendItemCollection legendItemCollection20 = null;
    combinedDomainXYPlot18.setFixedLegendItems(legendItemCollection20);
    org.jfree.chart.event.PlotChangeEvent plotChangeEvent22 = null;
    combinedDomainXYPlot18.notifyListeners(plotChangeEvent22);
    java.awt.Color color24 = java.awt.Color.cyan;
    combinedDomainXYPlot18.setDomainCrosshairPaint((java.awt.Paint)color24);
    piePlot3D8.setSectionPaint((java.lang.Comparable)"VerticalAlignment.CENTER", (java.awt.Paint)color24);
    java.awt.image.ColorModel colorModel27 = null;
    java.awt.Rectangle rectangle28 = null;
    org.jfree.chart.util.RectangleInsets rectangleInsets29 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.chart.util.UnitType unitType30 = rectangleInsets29.getUnitType();
    org.jfree.chart.axis.LogAxis logAxis32 = new org.jfree.chart.axis.LogAxis("ClassContext");
    org.jfree.data.xy.XYSeries xYSeries34 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection35 = new org.jfree.data.xy.XYSeriesCollection(xYSeries34);
    boolean b36 = xYSeriesCollection35.isAutoWidth();
    org.jfree.data.Range range38 = xYSeriesCollection35.getRangeBounds(true);
    xYSeriesCollection35.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis41 = new org.jfree.chart.axis.NumberAxis();
    numberAxis41.centerRange(100.0d);
    java.lang.Object obj44 = numberAxis41.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer45 = null;
    org.jfree.chart.plot.PolarPlot polarPlot46 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection35, (org.jfree.chart.axis.ValueAxis)numberAxis41, polarItemRenderer45);
    org.jfree.chart.plot.PlotOrientation plotOrientation47 = polarPlot46.getOrientation();
    boolean b48 = polarPlot46.isAngleLabelsVisible();
    int i49 = polarPlot46.getSeriesCount();
    java.awt.Font font54 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset55 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot56 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset55);
    org.jfree.chart.axis.ValueAxis valueAxis57 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot58 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis57);
    java.util.List list59 = combinedDomainXYPlot58.getAnnotations();
    waferMapPlot56.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot58);
    boolean b61 = combinedDomainXYPlot58.isNotify();
    org.jfree.chart.JFreeChart jFreeChart63 = new org.jfree.chart.JFreeChart("", font54, (org.jfree.chart.plot.Plot)combinedDomainXYPlot58, true);
    org.jfree.chart.title.TextTitle textTitle64 = new org.jfree.chart.title.TextTitle("", font54);
    textTitle64.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame67 = textTitle64.getFrame();
    java.lang.String str68 = textTitle64.getID();
    java.awt.geom.Rectangle2D rectangle2D69 = textTitle64.getBounds();
    java.awt.Point point70 = polarPlot46.translateValueThetaRadiusToJava2D(0.0d, 0.05d, rectangle2D69);
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D72 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke73 = categoryAxis3D72.getTickMarkStroke();
    java.awt.Graphics2D graphics2D74 = null;
    java.awt.geom.Rectangle2D rectangle2D76 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge77 = org.jfree.chart.util.RectangleEdge.LEFT;
    org.jfree.chart.axis.AxisState axisState79 = new org.jfree.chart.axis.AxisState(1.0d);
    double d80 = axisState79.getCursor();
    axisState79.cursorLeft(0.2d);
    categoryAxis3D72.drawTickMarks(graphics2D74, 7.0d, rectangle2D76, rectangleEdge77, axisState79);
    boolean b84 = org.jfree.chart.util.RectangleEdge.isTopOrBottom(rectangleEdge77);
    double d85 = logAxis32.java2DToValue(2.0d, rectangle2D69, rectangleEdge77);
    java.awt.geom.Rectangle2D rectangle2D86 = rectangleInsets29.createInsetRectangle(rectangle2D69);
    java.awt.geom.AffineTransform affineTransform87 = null;
    java.awt.RenderingHints renderingHints88 = null;
    java.awt.PaintContext paintContext89 = color24.createContext(colorModel27, rectangle28, rectangle2D86, affineTransform87, renderingHints88);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(piePlotState13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(pieSectionLabelGenerator14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(unitType30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b48 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i49 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b61 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str68);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke73);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d80 == 1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b84 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d85, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paintContext89);

  }

  @Test
  public void test157() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test157"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    boolean b2 = xYBarRenderer1.getUseYInterval();
    java.awt.Font font4 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset5 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot6 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset5);
    org.jfree.chart.axis.ValueAxis valueAxis7 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot8 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis7);
    java.util.List list9 = combinedDomainXYPlot8.getAnnotations();
    waferMapPlot6.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot8);
    boolean b11 = combinedDomainXYPlot8.isNotify();
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("", font4, (org.jfree.chart.plot.Plot)combinedDomainXYPlot8, true);
    combinedDomainXYPlot8.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer16 = null;
    combinedDomainXYPlot8.setRenderer(xYItemRenderer16);
    boolean b18 = combinedDomainXYPlot8.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries19 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection20 = new org.jfree.data.time.TimeSeriesCollection(timeSeries19);
    combinedDomainXYPlot8.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection20);
    xYBarRenderer1.setPlot((org.jfree.chart.plot.XYPlot)combinedDomainXYPlot8);
    java.awt.Paint paint24 = xYBarRenderer1.getSeriesOutlinePaint((-25560));
    java.awt.Paint paint25 = xYBarRenderer1.getBaseItemLabelPaint();
    java.awt.Paint paint27 = org.jfree.chart.plot.XYPlot.DEFAULT_GRIDLINE_PAINT;
    xYBarRenderer1.setLegendTextPaint(12, paint27);
    org.jfree.chart.urls.XYURLGenerator xYURLGenerator29 = xYBarRenderer1.getBaseURLGenerator();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYURLGenerator29);

  }

  @Test
  public void test158() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test158"); }


    org.jfree.chart.StandardChartTheme standardChartTheme1 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.renderer.category.BarPainter barPainter2 = standardChartTheme1.getBarPainter();
    java.awt.Paint paint3 = standardChartTheme1.getTickLabelPaint();
    java.awt.Color color6 = java.awt.Color.cyan;
    java.awt.color.ColorSpace colorSpace7 = color6.getColorSpace();
    org.jfree.chart.plot.IntervalMarker intervalMarker8 = new org.jfree.chart.plot.IntervalMarker(0.0d, 0.0d, (java.awt.Paint)color6);
    standardChartTheme1.setBaselinePaint((java.awt.Paint)color6);
    java.awt.Paint paint10 = standardChartTheme1.getChartBackgroundPaint();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(barPainter2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(colorSpace7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint10);

  }

  @Test
  public void test159() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test159"); }


    org.jfree.chart.StandardChartTheme standardChartTheme1 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Shape shape9 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color13 = java.awt.Color.green;
    java.awt.Color color19 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke20 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color21 = java.awt.Color.orange;
    java.awt.Stroke stroke22 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker24 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color19, stroke20, (java.awt.Paint)color21, stroke22, 0.0f);
    java.awt.Shape shape28 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke29 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color30 = java.awt.Color.green;
    java.lang.String str31 = org.jfree.chart.util.PaintUtilities.colorToString(color30);
    org.jfree.chart.LegendItem legendItem32 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape9, true, (java.awt.Paint)color11, false, (java.awt.Paint)color13, stroke20, true, shape28, stroke29, (java.awt.Paint)color30);
    standardChartTheme1.setCrosshairPaint((java.awt.Paint)color11);
    java.awt.Paint paint34 = standardChartTheme1.getPlotBackgroundPaint();
    java.awt.Paint paint35 = standardChartTheme1.getBaselinePaint();
    java.awt.Font font39 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset40 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot41 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset40);
    org.jfree.chart.axis.ValueAxis valueAxis42 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot43 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis42);
    java.util.List list44 = combinedDomainXYPlot43.getAnnotations();
    waferMapPlot41.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot43);
    org.jfree.chart.JFreeChart jFreeChart47 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font39, (org.jfree.chart.plot.Plot)combinedDomainXYPlot43, true);
    java.awt.Color color51 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment52 = new org.jfree.chart.text.TextFragment("hi!", font39, (java.awt.Paint)color51);
    java.awt.Paint paint53 = org.jfree.chart.plot.PiePlot.DEFAULT_LABEL_OUTLINE_PAINT;
    org.jfree.chart.plot.CategoryPlot categoryPlot54 = new org.jfree.chart.plot.CategoryPlot();
    boolean b55 = categoryPlot54.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge57 = categoryPlot54.getDomainAxisEdge(8);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment58 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment59 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement62 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment58, verticalAlignment59, 11.0d, 0.2d);
    org.jfree.chart.util.VerticalAlignment verticalAlignment63 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement66 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment58, verticalAlignment63, (-1.0d), Double.NaN);
    org.jfree.chart.util.VerticalAlignment verticalAlignment67 = org.jfree.chart.title.Title.DEFAULT_VERTICAL_ALIGNMENT;
    org.jfree.chart.util.RectangleInsets rectangleInsets68 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent69 = new org.jfree.data.general.SeriesChangeEvent((java.lang.Object)rectangleInsets68);
    org.jfree.chart.title.TextTitle textTitle70 = new org.jfree.chart.title.TextTitle("March", font39, paint53, rectangleEdge57, horizontalAlignment58, verticalAlignment67, rectangleInsets68);
    java.awt.Font font71 = textTitle70.getFont();
    standardChartTheme1.setRegularFont(font71);
    java.awt.Paint paint73 = standardChartTheme1.getWallPaint();
    java.awt.Paint paint74 = standardChartTheme1.getThermometerPaint();
    org.jfree.chart.renderer.category.BarPainter barPainter75 = standardChartTheme1.getBarPainter();
    org.jfree.chart.renderer.category.BarRenderer.setDefaultBarPainter(barPainter75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str31 + "' != '" + "green"+ "'", str31.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b55 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(verticalAlignment67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets68);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint73);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint74);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(barPainter75);

  }

  @Test
  public void test160() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test160"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(12.0d);
    xYBarRenderer1.setUseYInterval(true);
    xYBarRenderer1.setItemLabelAnchorOffset(6.0d);

  }

  @Test
  public void test161() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test161"); }


    int i0 = org.jfree.data.time.MonthConstants.OCTOBER;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 10);

  }

  @Test
  public void test162() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test162"); }


    org.jfree.chart.plot.Plot plot0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.JFreeChart jFreeChart1 = new org.jfree.chart.JFreeChart(plot0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test163() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test163"); }


    org.jfree.chart.axis.AxisSpace axisSpace0 = new org.jfree.chart.axis.AxisSpace();
    org.jfree.data.DomainOrder domainOrder1 = org.jfree.data.DomainOrder.DESCENDING;
    boolean b2 = axisSpace0.equals((java.lang.Object)domainOrder1);
    axisSpace0.setTop(10.0d);
    axisSpace0.setLeft(4.0d);
    double d7 = axisSpace0.getBottom();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 0.0d);

  }

  @Test
  public void test164() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test164"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    boolean b3 = xYBarRenderer1.getAutoPopulateSeriesShape();
    xYBarRenderer1.setShadowVisible(true);
    xYBarRenderer1.setShadowYOffset(0.2d);
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator11 = new org.jfree.chart.urls.StandardXYURLGenerator("", "hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!", "");
    org.jfree.chart.axis.ValueAxis valueAxis12 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot13 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis12);
    org.jfree.chart.plot.Plot plot14 = combinedDomainXYPlot13.getRootPlot();
    org.jfree.chart.axis.ValueAxis valueAxis15 = null;
    int i16 = combinedDomainXYPlot13.getRangeAxisIndex(valueAxis15);
    org.jfree.data.xy.XYSeries xYSeries18 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection19 = new org.jfree.data.xy.XYSeriesCollection(xYSeries18);
    boolean b20 = xYSeriesCollection19.isAutoWidth();
    org.jfree.data.Range range22 = xYSeriesCollection19.getRangeBounds(true);
    combinedDomainXYPlot13.setDataset(0, (org.jfree.data.xy.XYDataset)xYSeriesCollection19);
    java.lang.String str26 = standardXYURLGenerator11.generateURL((org.jfree.data.xy.XYDataset)xYSeriesCollection19, (-1), 14);
    java.awt.Color color30 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    boolean b31 = xYSeriesCollection19.equals((java.lang.Object)10.0f);
    org.jfree.data.Range range32 = xYBarRenderer1.findRangeBounds((org.jfree.data.xy.XYDataset)xYSeriesCollection19);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number35 = xYSeriesCollection19.getEndX(2147483647, 255);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i16 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str26 + "' != '" + "?hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!=-1&amp;=14"+ "'", str26.equals("?hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!=-1&amp;=14"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range32);

  }

  @Test
  public void test165() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test165"); }


    org.jfree.chart.util.StrokeList strokeList0 = new org.jfree.chart.util.StrokeList();
    java.lang.Object obj1 = strokeList0.clone();
    java.lang.Object obj2 = strokeList0.clone();
    java.lang.Object obj3 = strokeList0.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj3);

  }

  @Test
  public void test166() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test166"); }


    java.awt.Font font2 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset3 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot4 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset3);
    org.jfree.chart.axis.ValueAxis valueAxis5 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot6 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis5);
    java.util.List list7 = combinedDomainXYPlot6.getAnnotations();
    waferMapPlot4.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot6);
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font2, (org.jfree.chart.plot.Plot)combinedDomainXYPlot6, true);
    org.jfree.chart.text.TextLine textLine11 = new org.jfree.chart.text.TextLine("March", font2);
    org.jfree.chart.text.TextFragment textFragment12 = textLine11.getLastTextFragment();
    org.jfree.chart.text.TextFragment textFragment13 = textLine11.getFirstTextFragment();
    java.awt.Font font14 = textFragment13.getFont();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textFragment12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textFragment13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font14);

  }

  @Test
  public void test167() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test167"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    org.jfree.data.time.TimeSeries timeSeries11 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection12 = new org.jfree.data.time.TimeSeriesCollection(timeSeries11);
    timeSeriesCollection12.validateObject();
    java.lang.Comparable comparable14 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer15 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.data.general.Dataset)timeSeriesCollection12, comparable14);
    org.jfree.data.general.Dataset dataset16 = legendItemBlockContainer15.getDataset();
    java.lang.Comparable comparable17 = legendItemBlockContainer15.getSeriesKey();
    legendItemBlockContainer15.setURLText("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]");
    legendItemBlockContainer15.clear();
    java.util.List list21 = legendItemBlockContainer15.getBlocks();
    java.lang.Comparable comparable22 = legendItemBlockContainer15.getSeriesKey();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dataset16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(comparable17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(comparable22);

  }

  @Test
  public void test168() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test168"); }


    java.awt.Font font4 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset5 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot6 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset5);
    org.jfree.chart.axis.ValueAxis valueAxis7 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot8 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis7);
    java.util.List list9 = combinedDomainXYPlot8.getAnnotations();
    waferMapPlot6.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot8);
    org.jfree.chart.JFreeChart jFreeChart12 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font4, (org.jfree.chart.plot.Plot)combinedDomainXYPlot8, true);
    java.awt.Color color16 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment17 = new org.jfree.chart.text.TextFragment("hi!", font4, (java.awt.Paint)color16);
    java.awt.Color color18 = java.awt.Color.green;
    java.lang.String str19 = org.jfree.chart.util.PaintUtilities.colorToString(color18);
    org.jfree.chart.text.TextLine textLine20 = new org.jfree.chart.text.TextLine("ERROR : Relative To String", font4, (java.awt.Paint)color18);
    org.jfree.chart.text.TextFragment textFragment21 = new org.jfree.chart.text.TextFragment("LengthConstraintType.FIXED", font4);
    float f22 = textFragment21.getBaselineOffset();
    java.awt.Graphics2D graphics2D23 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.util.Size2D size2D24 = textFragment21.calculateDimensions(graphics2D23);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str19 + "' != '" + "green"+ "'", str19.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f22 == 0.0f);

  }

  @Test
  public void test169() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test169"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    boolean b3 = xYBarRenderer1.getAutoPopulateSeriesShape();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer5 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator6 = xYAreaRenderer5.getLegendItemToolTipGenerator();
    boolean b9 = xYAreaRenderer5.getItemVisible(10, 1);
    java.lang.Boolean b11 = xYAreaRenderer5.getSeriesVisibleInLegend(0);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition12 = xYAreaRenderer5.getBasePositiveItemLabelPosition();
    org.jfree.chart.text.TextAnchor textAnchor13 = itemLabelPosition12.getTextAnchor();
    xYBarRenderer1.setPositiveItemLabelPositionFallback(itemLabelPosition12);
    org.jfree.data.xy.DefaultXYDataset defaultXYDataset15 = new org.jfree.data.xy.DefaultXYDataset();
    org.jfree.data.Range range16 = xYBarRenderer1.findDomainBounds((org.jfree.data.xy.XYDataset)defaultXYDataset15);
    org.jfree.data.general.DatasetGroup datasetGroup17 = new org.jfree.data.general.DatasetGroup();
    defaultXYDataset15.setGroup(datasetGroup17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textAnchor13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range16);

  }

  @Test
  public void test170() {}
// Defects4J: flaky method
//   @Test
//   public void test170() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test170"); }
// 
// 
//     org.jfree.data.time.Month month2 = new org.jfree.data.time.Month();
//     int i3 = month2.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem5 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month2, (java.lang.Number)8);
//     long long6 = month2.getFirstMillisecond();
//     org.jfree.data.time.Month month7 = new org.jfree.data.time.Month();
//     int i8 = month7.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis9 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month2, (org.jfree.data.time.RegularTimePeriod)month7);
//     float f10 = periodAxis9.getMinorTickMarkInsideLength();
//     java.util.Locale locale11 = periodAxis9.getLocale();
//     java.text.NumberFormat numberFormat12 = java.text.NumberFormat.getInstance(locale11);
//     java.lang.ClassLoader classLoader13 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       java.util.ResourceBundle resourceBundle14 = java.util.ResourceBundle.getBundle("null version null.\nnull.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:null\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY null:None\nnull LICENCE TERMS:\nnull", locale11, classLoader13);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i3 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long6 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i8 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f10 == 0.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(locale11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(numberFormat12);
// 
//   }

  @Test
  public void test171() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test171"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier2 = xYAreaRenderer1.getDrawingSupplier();
    xYAreaRenderer1.setBaseCreateEntities(false);
    org.jfree.chart.event.RendererChangeEvent rendererChangeEvent5 = null;
    xYAreaRenderer1.notifyListeners(rendererChangeEvent5);
    boolean b7 = xYAreaRenderer1.getAutoPopulateSeriesFillPaint();
    java.awt.Paint paint9 = xYAreaRenderer1.getSeriesFillPaint(15);
    org.jfree.chart.plot.CategoryPlot categoryPlot10 = new org.jfree.chart.plot.CategoryPlot();
    boolean b11 = categoryPlot10.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge13 = categoryPlot10.getDomainAxisEdge(8);
    java.awt.Font font15 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset16 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot17 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset16);
    org.jfree.chart.axis.ValueAxis valueAxis18 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot19 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis18);
    java.util.List list20 = combinedDomainXYPlot19.getAnnotations();
    waferMapPlot17.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot19);
    org.jfree.chart.JFreeChart jFreeChart23 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font15, (org.jfree.chart.plot.Plot)combinedDomainXYPlot19, true);
    org.jfree.chart.axis.NumberAxis numberAxis25 = new org.jfree.chart.axis.NumberAxis();
    numberAxis25.centerRange(100.0d);
    combinedDomainXYPlot19.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis25);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier29 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot19.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier29);
    categoryPlot10.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier29);
    categoryPlot10.clearRangeMarkers(100);
    org.jfree.chart.util.RectangleInsets rectangleInsets34 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    categoryPlot10.setAxisOffset(rectangleInsets34);
    java.awt.Stroke stroke36 = categoryPlot10.getRangeGridlineStroke();
    org.jfree.chart.axis.NumberAxis3D numberAxis3D37 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Color color38 = org.jfree.chart.ChartColor.VERY_LIGHT_GREEN;
    numberAxis3D37.setTickMarkPaint((java.awt.Paint)color38);
    categoryPlot10.setRangeZeroBaselinePaint((java.awt.Paint)color38);
    xYAreaRenderer1.setBaseOutlinePaint((java.awt.Paint)color38, false);
    xYAreaRenderer1.clearSeriesPaints(false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color38);

  }

  @Test
  public void test172() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test172"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(12.0d);
    java.awt.Paint paint3 = xYBarRenderer1.getSeriesItemLabelPaint(100);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition4 = xYBarRenderer1.getPositiveItemLabelPositionFallback();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(itemLabelPosition4);

  }

  @Test
  public void test173() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test173"); }


    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator0 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator4 = new org.jfree.chart.urls.StandardXYURLGenerator("", "hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!", "");
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer5 = new org.jfree.chart.renderer.xy.XYStepRenderer((org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator0, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator4);
    xYStepRenderer5.setSeriesLinesVisible(12, (java.lang.Boolean)true);
    boolean b11 = xYStepRenderer5.getItemShapeFilled(40, 100);
    boolean b12 = xYStepRenderer5.getUseFillPaint();
    xYStepRenderer5.setBaseSeriesVisibleInLegend(false);
    xYStepRenderer5.setSeriesLinesVisible(1, true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);

  }

  @Test
  public void test174() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test174"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    org.jfree.chart.axis.ValueAxis valueAxis2 = categoryPlot0.getRangeAxisForDataset(14);
    int i3 = categoryPlot0.getWeight();
    org.jfree.chart.axis.AxisLocation axisLocation4 = categoryPlot0.getRangeAxisLocation();
    java.awt.Stroke stroke5 = categoryPlot0.getRangeMinorGridlineStroke();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(valueAxis2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i3 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke5);

  }

  @Test
  public void test175() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test175"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    boolean b5 = xYAreaRenderer1.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition9 = xYAreaRenderer1.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b11 = xYAreaRenderer1.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator12 = null;
    xYAreaRenderer1.setBaseToolTipGenerator(xYToolTipGenerator12, true);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator15 = xYAreaRenderer1.getLegendItemURLGenerator();
    org.jfree.chart.labels.XYItemLabelGenerator xYItemLabelGenerator16 = xYAreaRenderer1.getBaseItemLabelGenerator();
    org.jfree.chart.StandardChartTheme standardChartTheme19 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.renderer.category.BarPainter barPainter20 = standardChartTheme19.getBarPainter();
    java.awt.Font font21 = standardChartTheme19.getLargeFont();
    xYAreaRenderer1.setLegendTextFont(0, font21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYItemLabelGenerator16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(barPainter20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font21);

  }

  @Test
  public void test176() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test176"); }


    org.jfree.data.category.CategoryDataset categoryDataset0 = null;
    org.jfree.chart.axis.CategoryAxis categoryAxis1 = new org.jfree.chart.axis.CategoryAxis();
    categoryAxis1.setVisible(false);
    org.jfree.chart.util.RectangleInsets rectangleInsets4 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d5 = rectangleInsets4.getLeft();
    double d7 = rectangleInsets4.calculateLeftOutset(1.0d);
    categoryAxis1.setLabelInsets(rectangleInsets4, true);
    float f10 = categoryAxis1.getTickMarkOutsideLength();
    org.jfree.chart.axis.CategoryAnchor categoryAnchor11 = null;
    java.awt.geom.Rectangle2D rectangle2D14 = null;
    org.jfree.data.general.WaferMapDataset waferMapDataset15 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot16 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset15);
    org.jfree.chart.JFreeChart jFreeChart17 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent18 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot16, jFreeChart17);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment19 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment20 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement23 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment19, verticalAlignment20, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement24 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle25 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot16, (org.jfree.chart.block.Arrangement)flowArrangement23, (org.jfree.chart.block.Arrangement)borderArrangement24);
    org.jfree.chart.plot.CategoryPlot categoryPlot26 = new org.jfree.chart.plot.CategoryPlot();
    boolean b27 = categoryPlot26.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge29 = categoryPlot26.getDomainAxisEdge(8);
    legendTitle25.setPosition(rectangleEdge29);
    double d31 = categoryAxis1.getCategoryJava2DCoordinate(categoryAnchor11, 4, 255, rectangle2D14, rectangleEdge29);
    org.jfree.chart.axis.NumberAxis3D numberAxis3D32 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Paint paint33 = org.jfree.chart.axis.Axis.DEFAULT_AXIS_LINE_PAINT;
    numberAxis3D32.setLabelPaint(paint33);
    org.jfree.chart.axis.NumberTickUnit numberTickUnit35 = org.jfree.chart.axis.NumberAxis.DEFAULT_TICK_UNIT;
    numberAxis3D32.setTickUnit(numberTickUnit35, false, true);
    numberAxis3D32.resizeRange(6.0d, 1.0d);
    org.jfree.chart.renderer.category.BarRenderer barRenderer42 = new org.jfree.chart.renderer.category.BarRenderer();
    double d43 = barRenderer42.getShadowXOffset();
    org.jfree.chart.plot.CategoryPlot categoryPlot44 = new org.jfree.chart.plot.CategoryPlot(categoryDataset0, categoryAxis1, (org.jfree.chart.axis.ValueAxis)numberAxis3D32, (org.jfree.chart.renderer.category.CategoryItemRenderer)barRenderer42);
    java.awt.Paint paint45 = barRenderer42.getBaseItemLabelPaint();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer47 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator48 = xYAreaRenderer47.getLegendItemToolTipGenerator();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition49 = xYAreaRenderer47.getBasePositiveItemLabelPosition();
    barRenderer42.setPositiveItemLabelPositionFallback(itemLabelPosition49);
    org.jfree.chart.labels.CategoryToolTipGenerator categoryToolTipGenerator51 = null;
    barRenderer42.setBaseToolTipGenerator(categoryToolTipGenerator51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f10 == 2.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d31 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberTickUnit35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d43 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition49);

  }

  @Test
  public void test177() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test177"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    boolean b31 = legendItem30.isShapeOutlineVisible();
    boolean b33 = legendItem30.equals((java.lang.Object)(short)1);
    java.lang.Object obj34 = legendItem30.clone();
    java.awt.Shape shape35 = legendItem30.getShape();
    org.jfree.chart.JFreeChart jFreeChart36 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.entity.JFreeChartEntity jFreeChartEntity37 = new org.jfree.chart.entity.JFreeChartEntity(shape35, jFreeChart36);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape35);

  }

  @Test
  public void test178() {}
// Defects4J: flaky method
//   @Test
//   public void test178() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test178"); }
// 
// 
//     org.jfree.data.DefaultKeyedValues defaultKeyedValues0 = new org.jfree.data.DefaultKeyedValues();
//     org.jfree.data.time.DateRange dateRange3 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d4 = dateRange3.getLength();
//     long long5 = dateRange3.getLowerMillis();
//     double d6 = dateRange3.getLength();
//     java.lang.String str7 = dateRange3.toString();
//     java.util.Date date8 = dateRange3.getUpperDate();
//     org.jfree.data.time.SerialDate serialDate9 = org.jfree.data.time.SerialDate.createInstance(date8);
//     org.jfree.data.time.Month month10 = new org.jfree.data.time.Month(date8);
//     defaultKeyedValues0.setValue((java.lang.Comparable)month10, 90.0d);
//     int i14 = defaultKeyedValues0.getIndex((java.lang.Comparable)0);
//     int i15 = defaultKeyedValues0.getItemCount();
//     org.jfree.data.time.Month month16 = new org.jfree.data.time.Month();
//     int i17 = month16.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem19 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month16, 11.0d);
//     timeSeriesDataItem19.setSelected(true);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod22 = timeSeriesDataItem19.getPeriod();
//     boolean b23 = timeSeriesDataItem19.isSelected();
//     int i24 = defaultKeyedValues0.getIndex((java.lang.Comparable)b23);
//     org.jfree.chart.axis.NumberTickUnit numberTickUnit25 = org.jfree.chart.axis.NumberAxis.DEFAULT_TICK_UNIT;
//     org.jfree.data.time.Day day26 = new org.jfree.data.time.Day();
//     long long27 = day26.getFirstMillisecond();
//     boolean b28 = numberTickUnit25.equals((java.lang.Object)day26);
//     // The following exception was thrown during execution in test generation
//     try {
//       defaultKeyedValues0.removeValue((java.lang.Comparable)day26);
//       org.junit.Assert.fail("Expected exception of type org.jfree.data.UnknownKeyException");
//     } catch (org.jfree.data.UnknownKeyException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.jfree.data.UnknownKeyException")) {
//         org.junit.Assert.fail("Expected exception of type org.jfree.data.UnknownKeyException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d4 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d6 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str7 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str7.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(serialDate9);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i14 == (-1));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i15 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i17 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b23 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i24 == (-1));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(numberTickUnit25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long27 == 1456041600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b28 == false);
// 
//   }

  @Test
  public void test179() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test179"); }


    org.jfree.chart.util.LogFormat logFormat0 = new org.jfree.chart.util.LogFormat();
    boolean b1 = logFormat0.isParseIntegerOnly();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);

  }

  @Test
  public void test180() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test180"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    java.util.List list2 = combinedDomainXYPlot1.getAnnotations();
    combinedDomainXYPlot1.setRangeGridlinesVisible(true);
    org.jfree.chart.axis.AxisSpace axisSpace5 = null;
    combinedDomainXYPlot1.setFixedRangeAxisSpace(axisSpace5);
    org.jfree.chart.axis.ValueAxis valueAxis7 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot8 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis7);
    org.jfree.chart.plot.Plot plot9 = combinedDomainXYPlot8.getRootPlot();
    java.awt.Color color15 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke16 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color17 = java.awt.Color.orange;
    java.awt.Stroke stroke18 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker20 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color15, stroke16, (java.awt.Paint)color17, stroke18, 0.0f);
    org.jfree.chart.util.Layer layer21 = null;
    boolean b22 = combinedDomainXYPlot8.removeRangeMarker((org.jfree.chart.plot.Marker)intervalMarker20, layer21);
    combinedDomainXYPlot1.addRangeMarker((org.jfree.chart.plot.Marker)intervalMarker20);
    combinedDomainXYPlot1.setDomainMinorGridlinesVisible(true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);

  }

  @Test
  public void test181() {}
// Defects4J: flaky method
//   @Test
//   public void test181() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test181"); }
// 
// 
//     org.jfree.data.time.Day day0 = new org.jfree.data.time.Day();
//     int i1 = day0.getDayOfMonth();
//     org.jfree.data.time.SerialDate serialDate2 = day0.getSerialDate();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i1 == 21);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(serialDate2);
// 
//   }

  @Test
  public void test182() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test182"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis0 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset1 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot2 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset1);
    org.jfree.chart.axis.ValueAxis valueAxis3 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot4 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis3);
    java.util.List list5 = combinedDomainXYPlot4.getAnnotations();
    waferMapPlot2.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot4);
    int i7 = combinedDomainXYPlot4.getSeriesCount();
    categoryAxis0.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot4);
    java.awt.Color color15 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke16 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color17 = java.awt.Color.orange;
    java.awt.Stroke stroke18 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker20 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color15, stroke16, (java.awt.Paint)color17, stroke18, 0.0f);
    java.awt.Paint paint21 = intervalMarker20.getOutlinePaint();
    org.jfree.chart.util.Layer layer22 = null;
    combinedDomainXYPlot4.addRangeMarker(0, (org.jfree.chart.plot.Marker)intervalMarker20, layer22);
    combinedDomainXYPlot4.clearRangeMarkers();
    java.awt.Stroke stroke25 = org.jfree.chart.plot.Plot.DEFAULT_OUTLINE_STROKE;
    combinedDomainXYPlot4.setRangeZeroBaselineStroke(stroke25);
    java.awt.Color color27 = java.awt.Color.WHITE;
    combinedDomainXYPlot4.setRangeZeroBaselinePaint((java.awt.Paint)color27);
    int i29 = combinedDomainXYPlot4.getWeight();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i29 == 1);

  }

  @Test
  public void test183() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test183"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer13 = null;
    combinedDomainXYPlot5.setRenderer(xYItemRenderer13);
    org.jfree.chart.axis.AxisSpace axisSpace15 = combinedDomainXYPlot5.getFixedRangeAxisSpace();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer17 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier18 = xYAreaRenderer17.getDrawingSupplier();
    java.awt.Stroke stroke19 = xYAreaRenderer17.getBaseStroke();
    combinedDomainXYPlot5.setDomainCrosshairStroke(stroke19);
    combinedDomainXYPlot5.setNotify(true);
    java.awt.Stroke stroke23 = combinedDomainXYPlot5.getDomainGridlineStroke();
    java.awt.Graphics2D graphics2D24 = null;
    org.jfree.chart.util.RectangleInsets rectangleInsets25 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.chart.util.UnitType unitType26 = rectangleInsets25.getUnitType();
    org.jfree.chart.axis.LogAxis logAxis28 = new org.jfree.chart.axis.LogAxis("ClassContext");
    org.jfree.data.xy.XYSeries xYSeries30 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection31 = new org.jfree.data.xy.XYSeriesCollection(xYSeries30);
    boolean b32 = xYSeriesCollection31.isAutoWidth();
    org.jfree.data.Range range34 = xYSeriesCollection31.getRangeBounds(true);
    xYSeriesCollection31.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis37 = new org.jfree.chart.axis.NumberAxis();
    numberAxis37.centerRange(100.0d);
    java.lang.Object obj40 = numberAxis37.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer41 = null;
    org.jfree.chart.plot.PolarPlot polarPlot42 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection31, (org.jfree.chart.axis.ValueAxis)numberAxis37, polarItemRenderer41);
    org.jfree.chart.plot.PlotOrientation plotOrientation43 = polarPlot42.getOrientation();
    boolean b44 = polarPlot42.isAngleLabelsVisible();
    int i45 = polarPlot42.getSeriesCount();
    java.awt.Font font50 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset51 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot52 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset51);
    org.jfree.chart.axis.ValueAxis valueAxis53 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot54 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis53);
    java.util.List list55 = combinedDomainXYPlot54.getAnnotations();
    waferMapPlot52.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot54);
    boolean b57 = combinedDomainXYPlot54.isNotify();
    org.jfree.chart.JFreeChart jFreeChart59 = new org.jfree.chart.JFreeChart("", font50, (org.jfree.chart.plot.Plot)combinedDomainXYPlot54, true);
    org.jfree.chart.title.TextTitle textTitle60 = new org.jfree.chart.title.TextTitle("", font50);
    textTitle60.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame63 = textTitle60.getFrame();
    java.lang.String str64 = textTitle60.getID();
    java.awt.geom.Rectangle2D rectangle2D65 = textTitle60.getBounds();
    java.awt.Point point66 = polarPlot42.translateValueThetaRadiusToJava2D(0.0d, 0.05d, rectangle2D65);
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D68 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke69 = categoryAxis3D68.getTickMarkStroke();
    java.awt.Graphics2D graphics2D70 = null;
    java.awt.geom.Rectangle2D rectangle2D72 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge73 = org.jfree.chart.util.RectangleEdge.LEFT;
    org.jfree.chart.axis.AxisState axisState75 = new org.jfree.chart.axis.AxisState(1.0d);
    double d76 = axisState75.getCursor();
    axisState75.cursorLeft(0.2d);
    categoryAxis3D68.drawTickMarks(graphics2D70, 7.0d, rectangle2D72, rectangleEdge73, axisState75);
    boolean b80 = org.jfree.chart.util.RectangleEdge.isTopOrBottom(rectangleEdge73);
    double d81 = logAxis28.java2DToValue(2.0d, rectangle2D65, rectangleEdge73);
    java.awt.geom.Rectangle2D rectangle2D82 = rectangleInsets25.createInsetRectangle(rectangle2D65);
    // The following exception was thrown during execution in test generation
    try {
      combinedDomainXYPlot5.drawOutline(graphics2D24, rectangle2D65);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(axisSpace15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(unitType26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i45 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b57 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge73);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d76 == 1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b80 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d81, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D82);

  }

  @Test
  public void test184() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test184"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    java.util.List list2 = combinedDomainXYPlot1.getAnnotations();
    combinedDomainXYPlot1.setRangeGridlinesVisible(true);
    java.awt.Color color5 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    combinedDomainXYPlot1.setRangeTickBandPaint((java.awt.Paint)color5);
    java.awt.Graphics2D graphics2D7 = null;
    org.jfree.data.xy.XYSeries xYSeries8 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection9 = new org.jfree.data.xy.XYSeriesCollection(xYSeries8);
    boolean b10 = xYSeriesCollection9.isAutoWidth();
    org.jfree.data.Range range12 = xYSeriesCollection9.getRangeBounds(true);
    xYSeriesCollection9.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
    numberAxis15.centerRange(100.0d);
    java.lang.Object obj18 = numberAxis15.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer19 = null;
    org.jfree.chart.plot.PolarPlot polarPlot20 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection9, (org.jfree.chart.axis.ValueAxis)numberAxis15, polarItemRenderer19);
    org.jfree.chart.plot.PlotOrientation plotOrientation21 = polarPlot20.getOrientation();
    boolean b22 = polarPlot20.isAngleLabelsVisible();
    int i23 = polarPlot20.getSeriesCount();
    java.awt.Font font28 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset29 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot30 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset29);
    org.jfree.chart.axis.ValueAxis valueAxis31 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot32 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis31);
    java.util.List list33 = combinedDomainXYPlot32.getAnnotations();
    waferMapPlot30.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot32);
    boolean b35 = combinedDomainXYPlot32.isNotify();
    org.jfree.chart.JFreeChart jFreeChart37 = new org.jfree.chart.JFreeChart("", font28, (org.jfree.chart.plot.Plot)combinedDomainXYPlot32, true);
    org.jfree.chart.title.TextTitle textTitle38 = new org.jfree.chart.title.TextTitle("", font28);
    textTitle38.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame41 = textTitle38.getFrame();
    java.lang.String str42 = textTitle38.getID();
    java.awt.geom.Rectangle2D rectangle2D43 = textTitle38.getBounds();
    java.awt.Point point44 = polarPlot20.translateValueThetaRadiusToJava2D(0.0d, 0.05d, rectangle2D43);
    java.awt.Shape shape52 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color54 = java.awt.Color.green;
    java.awt.Color color56 = java.awt.Color.green;
    java.awt.Color color62 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke63 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color64 = java.awt.Color.orange;
    java.awt.Stroke stroke65 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker67 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color62, stroke63, (java.awt.Paint)color64, stroke65, 0.0f);
    java.awt.Shape shape71 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke72 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color73 = java.awt.Color.green;
    java.lang.String str74 = org.jfree.chart.util.PaintUtilities.colorToString(color73);
    org.jfree.chart.LegendItem legendItem75 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape52, true, (java.awt.Paint)color54, false, (java.awt.Paint)color56, stroke63, true, shape71, stroke72, (java.awt.Paint)color73);
    java.awt.Font font77 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset78 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot79 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset78);
    org.jfree.chart.axis.ValueAxis valueAxis80 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot81 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis80);
    java.util.List list82 = combinedDomainXYPlot81.getAnnotations();
    waferMapPlot79.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot81);
    boolean b84 = combinedDomainXYPlot81.isNotify();
    org.jfree.chart.JFreeChart jFreeChart86 = new org.jfree.chart.JFreeChart("", font77, (org.jfree.chart.plot.Plot)combinedDomainXYPlot81, true);
    java.awt.Stroke stroke87 = jFreeChart86.getBorderStroke();
    boolean b88 = jFreeChart86.isBorderVisible();
    java.awt.Image image89 = null;
    jFreeChart86.setBackgroundImage(image89);
    org.jfree.chart.entity.JFreeChartEntity jFreeChartEntity92 = new org.jfree.chart.entity.JFreeChartEntity(shape52, jFreeChart86, "hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!");
    org.jfree.data.xy.XYSeries xYSeries93 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection94 = new org.jfree.data.xy.XYSeriesCollection(xYSeries93);
    double d96 = xYSeriesCollection94.getDomainUpperBound(false);
    java.util.List list97 = xYSeriesCollection94.getSeries();
    jFreeChart86.setSubtitles(list97);
    // The following exception was thrown during execution in test generation
    try {
      combinedDomainXYPlot1.drawRangeTickBands(graphics2D7, rectangle2D43, list97);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i23 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color73);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str74 + "' != '" + "green"+ "'", str74.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b84 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke87);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d96, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list97);

  }

  @Test
  public void test185() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test185"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    java.util.List list2 = combinedDomainXYPlot1.getAnnotations();
    combinedDomainXYPlot1.setRangeGridlinesVisible(true);
    org.jfree.chart.axis.ValueAxis valueAxis6 = null;
    combinedDomainXYPlot1.setRangeAxis(100, valueAxis6, false);
    org.jfree.chart.axis.NumberAxis numberAxis9 = new org.jfree.chart.axis.NumberAxis();
    numberAxis9.centerRange(100.0d);
    combinedDomainXYPlot1.setRangeAxis((org.jfree.chart.axis.ValueAxis)numberAxis9);
    org.jfree.chart.event.PlotChangeEvent plotChangeEvent13 = null;
    combinedDomainXYPlot1.plotChanged(plotChangeEvent13);
    java.awt.Stroke stroke15 = combinedDomainXYPlot1.getRangeCrosshairStroke();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke15);

  }

  @Test
  public void test186() {}
// Defects4J: flaky method
//   @Test
//   public void test186() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test186"); }
// 
// 
//     org.jfree.data.time.Month month1 = new org.jfree.data.time.Month();
//     int i2 = month1.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem4 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month1, (java.lang.Number)8);
//     long long5 = month1.getFirstMillisecond();
//     org.jfree.data.time.Month month6 = new org.jfree.data.time.Month();
//     int i7 = month6.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis8 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month1, (org.jfree.data.time.RegularTimePeriod)month6);
//     periodAxis8.setUpperMargin(10.0d);
//     periodAxis8.setAutoRange(false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i2 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i7 == 2);
// 
//   }

  @Test
  public void test187() {}
// Defects4J: flaky method
//   @Test
//   public void test187() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test187"); }
// 
// 
//     org.jfree.data.time.TimeSeries timeSeries3 = new org.jfree.data.time.TimeSeries((java.lang.Comparable)"hi!", "AxisLocation.TOP_OR_RIGHT", "SeriesRenderingOrder.FORWARD");
//     int i4 = timeSeries3.getMaximumItemCount();
//     org.jfree.data.time.DateRange dateRange7 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d8 = dateRange7.getLength();
//     long long9 = dateRange7.getLowerMillis();
//     double d10 = dateRange7.getLength();
//     java.lang.String str11 = dateRange7.toString();
//     java.util.Date date12 = dateRange7.getUpperDate();
//     java.util.TimeZone timeZone13 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year14 = new org.jfree.data.time.Year(date12, timeZone13);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod15 = year14.next();
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod16 = year14.previous();
//     timeSeries3.add(regularTimePeriod16, 12.0d, false);
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem20 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       timeSeries3.add(timeSeriesDataItem20);
//       org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
//     } catch (java.lang.IllegalArgumentException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i4 == 2147483647);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d8 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long9 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d10 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str11 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str11.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod16);
// 
//   }

  @Test
  public void test188() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test188"); }


    org.jfree.chart.util.LogFormat logFormat3 = new org.jfree.chart.util.LogFormat(12.0d, "{0}: ({1}, {2})", true);
    java.lang.StringBuffer stringBuffer5 = null;
    java.text.FieldPosition fieldPosition6 = null;
    java.lang.StringBuffer stringBuffer7 = logFormat3.format(6.0d, stringBuffer5, fieldPosition6);
    int i8 = logFormat3.getMinimumIntegerDigits();
    java.awt.Color color9 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    java.awt.Stroke stroke10 = org.jfree.chart.plot.CategoryPlot.DEFAULT_CROSSHAIR_STROKE;
    org.jfree.chart.util.RectangleInsets rectangleInsets11 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.chart.util.UnitType unitType12 = rectangleInsets11.getUnitType();
    double d14 = rectangleInsets11.calculateLeftOutset(0.0d);
    org.jfree.chart.block.LineBorder lineBorder15 = new org.jfree.chart.block.LineBorder((java.awt.Paint)color9, stroke10, rectangleInsets11);
    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot16 = new org.jfree.chart.plot.MultiplePiePlot();
    boolean b17 = lineBorder15.equals((java.lang.Object)multiplePiePlot16);
    boolean b18 = logFormat3.equals((java.lang.Object)b17);
    logFormat3.setParseIntegerOnly(true);
    java.lang.Object obj21 = logFormat3.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stringBuffer7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i8 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(unitType12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj21);

  }

  @Test
  public void test189() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test189"); }


    java.awt.Color color2 = org.jfree.chart.ChartColor.VERY_DARK_YELLOW;
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator5 = null;
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator7 = new org.jfree.chart.urls.StandardXYURLGenerator("");
    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer8 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(100, xYToolTipGenerator5, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator7);
    xYStepAreaRenderer8.setPlotArea(true);
    java.lang.Object obj11 = null;
    boolean b12 = xYStepAreaRenderer8.equals(obj11);
    java.awt.Font font14 = xYStepAreaRenderer8.getLegendTextFont(40);
    boolean b15 = xYStepAreaRenderer8.getPlotArea();
    org.jfree.chart.StandardChartTheme standardChartTheme18 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.plot.DrawingSupplier drawingSupplier19 = standardChartTheme18.getDrawingSupplier();
    java.awt.Paint paint20 = standardChartTheme18.getItemLabelPaint();
    xYStepAreaRenderer8.setSeriesFillPaint(14, paint20, false);
    java.awt.Stroke stroke23 = org.jfree.chart.plot.PolarPlot.DEFAULT_GRIDLINE_STROKE;
    org.jfree.chart.plot.ValueMarker valueMarker24 = new org.jfree.chart.plot.ValueMarker(10.0d, paint20, stroke23);
    java.awt.Font font29 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset30 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot31 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset30);
    org.jfree.chart.axis.ValueAxis valueAxis32 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot33 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis32);
    java.util.List list34 = combinedDomainXYPlot33.getAnnotations();
    waferMapPlot31.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot33);
    org.jfree.chart.JFreeChart jFreeChart37 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font29, (org.jfree.chart.plot.Plot)combinedDomainXYPlot33, true);
    java.awt.Color color41 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment42 = new org.jfree.chart.text.TextFragment("hi!", font29, (java.awt.Paint)color41);
    java.awt.Color color43 = java.awt.Color.green;
    java.lang.String str44 = org.jfree.chart.util.PaintUtilities.colorToString(color43);
    org.jfree.chart.text.TextLine textLine45 = new org.jfree.chart.text.TextLine("ERROR : Relative To String", font29, (java.awt.Paint)color43);
    org.jfree.chart.text.TextFragment textFragment46 = new org.jfree.chart.text.TextFragment("LengthConstraintType.FIXED", font29);
    java.awt.Paint paint47 = textFragment46.getPaint();
    java.awt.Font font49 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset50 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot51 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset50);
    org.jfree.chart.axis.ValueAxis valueAxis52 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot53 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis52);
    java.util.List list54 = combinedDomainXYPlot53.getAnnotations();
    waferMapPlot51.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot53);
    boolean b56 = combinedDomainXYPlot53.isNotify();
    org.jfree.chart.JFreeChart jFreeChart58 = new org.jfree.chart.JFreeChart("", font49, (org.jfree.chart.plot.Plot)combinedDomainXYPlot53, true);
    combinedDomainXYPlot53.setDomainMinorGridlinesVisible(false);
    java.lang.Object obj61 = null;
    boolean b62 = combinedDomainXYPlot53.equals(obj61);
    java.awt.Stroke stroke63 = combinedDomainXYPlot53.getDomainGridlineStroke();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.plot.IntervalMarker intervalMarker65 = new org.jfree.chart.plot.IntervalMarker(0.2d, 6.0d, (java.awt.Paint)color2, stroke23, paint47, stroke63, 2.0f);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(font14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(drawingSupplier19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str44 + "' != '" + "green"+ "'", str44.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b56 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b62 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke63);

  }

  @Test
  public void test190() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test190"); }


    java.awt.Graphics2D graphics2D0 = null;
    org.jfree.chart.text.G2TextMeasurer g2TextMeasurer1 = new org.jfree.chart.text.G2TextMeasurer(graphics2D0);
    // The following exception was thrown during execution in test generation
    try {
      float f5 = g2TextMeasurer1.getStringWidth("Pie 3D Plot", 14, 128);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test191() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test191"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    java.awt.Shape shape3 = xYAreaRenderer1.getBaseShape();
    java.awt.Shape shape6 = org.jfree.chart.util.ShapeUtilities.createTranslatedShape(shape3, 6.0d, 0.0d);
    java.awt.Font font9 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset10 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot11 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset10);
    org.jfree.chart.axis.ValueAxis valueAxis12 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot13 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis12);
    java.util.List list14 = combinedDomainXYPlot13.getAnnotations();
    waferMapPlot11.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot13);
    boolean b16 = combinedDomainXYPlot13.isNotify();
    org.jfree.chart.JFreeChart jFreeChart18 = new org.jfree.chart.JFreeChart("", font9, (org.jfree.chart.plot.Plot)combinedDomainXYPlot13, true);
    org.jfree.chart.title.TextTitle textTitle19 = new org.jfree.chart.title.TextTitle("", font9);
    boolean b20 = textTitle19.getExpandToFitSpace();
    textTitle19.setText("TextBlockAnchor.BOTTOM_RIGHT");
    org.jfree.chart.entity.TitleEntity titleEntity25 = new org.jfree.chart.entity.TitleEntity(shape3, (org.jfree.chart.title.Title)textTitle19, "TitleEntity: tooltip = green", "PieLabelLinkStyle.STANDARD");
    org.jfree.chart.util.RectangleInsets rectangleInsets26 = textTitle19.getMargin();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets26);

  }

  @Test
  public void test192() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test192"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    xYAreaRenderer1.setBaseSeriesVisible(false);
    java.awt.Paint paint5 = xYAreaRenderer1.lookupLegendTextPaint(0);
    java.awt.Font font7 = xYAreaRenderer1.getSeriesItemLabelFont(4);
    java.awt.Shape shape11 = xYAreaRenderer1.getItemShape(1, 8, true);
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer14 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d15 = xYBarRenderer14.getMargin();
    boolean b16 = xYBarRenderer14.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator18 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer14.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator18, true);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator22 = null;
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator24 = new org.jfree.chart.urls.StandardXYURLGenerator("");
    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer25 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(100, xYToolTipGenerator22, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator24);
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer26 = new org.jfree.chart.renderer.xy.XYStepRenderer((org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator18, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator24);
    xYAreaRenderer1.setSeriesURLGenerator(12, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator24);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate29 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate31 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b32 = spreadsheetDate29.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate31);
    int i33 = spreadsheetDate29.getYYYY();
    org.jfree.data.time.SpreadsheetDate spreadsheetDate35 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate37 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b38 = spreadsheetDate35.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate37);
    int i39 = spreadsheetDate37.getMonth();
    boolean b40 = spreadsheetDate29.isOnOrBefore((org.jfree.data.time.SerialDate)spreadsheetDate37);
    boolean b41 = xYAreaRenderer1.equals((java.lang.Object)spreadsheetDate37);
    boolean b42 = xYAreaRenderer1.getAutoPopulateSeriesStroke();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(font7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d15 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i33 == 1900);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i39 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b42 == true);

  }

  @Test
  public void test193() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test193"); }


    org.jfree.data.Range range1 = null;
    org.jfree.chart.block.LengthConstraintType lengthConstraintType2 = org.jfree.chart.block.LengthConstraintType.NONE;
    org.jfree.data.time.DateRange dateRange6 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange9 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b10 = dateRange6.intersects((org.jfree.data.Range)dateRange9);
    org.jfree.data.Range range12 = org.jfree.data.Range.expandToInclude((org.jfree.data.Range)dateRange6, 1.0d);
    org.jfree.chart.block.LengthConstraintType lengthConstraintType13 = org.jfree.chart.block.LengthConstraintType.NONE;
    org.jfree.chart.block.RectangleConstraint rectangleConstraint14 = new org.jfree.chart.block.RectangleConstraint(2.0d, range1, lengthConstraintType2, 0.0d, range12, lengthConstraintType13);
    org.jfree.data.general.DefaultPieDataset defaultPieDataset15 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj16 = defaultPieDataset15.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D17 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset15);
    piePlot3D17.setIgnoreZeroValues(true);
    boolean b20 = lengthConstraintType2.equals((java.lang.Object)piePlot3D17);
    double d21 = piePlot3D17.getLabelGap();
    java.lang.Object obj22 = piePlot3D17.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d21 == 0.025d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj22);

  }

  @Test
  public void test194() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test194"); }


    int i0 = org.jfree.data.time.SerialDate.SERIAL_LOWER_BOUND;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 2);

  }

  @Test
  public void test195() {}
// Defects4J: flaky method
//   @Test
//   public void test195() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test195"); }
// 
// 
//     org.jfree.data.time.Month month2 = new org.jfree.data.time.Month();
//     int i3 = month2.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem5 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month2, (java.lang.Number)8);
//     long long6 = month2.getFirstMillisecond();
//     org.jfree.data.time.Month month7 = new org.jfree.data.time.Month();
//     int i8 = month7.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis9 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month2, (org.jfree.data.time.RegularTimePeriod)month7);
//     float f10 = periodAxis9.getMinorTickMarkInsideLength();
//     java.util.Locale locale11 = periodAxis9.getLocale();
//     java.text.NumberFormat numberFormat12 = java.text.NumberFormat.getInstance(locale11);
//     // The following exception was thrown during execution in test generation
//     try {
//       java.util.ResourceBundle resourceBundle13 = java.util.ResourceBundle.getBundle("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]", locale11);
//       org.junit.Assert.fail("Expected exception of type java.util.MissingResourceException");
//     } catch (java.util.MissingResourceException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.util.MissingResourceException")) {
//         org.junit.Assert.fail("Expected exception of type java.util.MissingResourceException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i3 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long6 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i8 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f10 == 0.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(locale11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(numberFormat12);
// 
//   }

  @Test
  public void test196() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test196"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    boolean b5 = xYAreaRenderer1.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition9 = xYAreaRenderer1.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b11 = xYAreaRenderer1.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator12 = null;
    xYAreaRenderer1.setBaseToolTipGenerator(xYToolTipGenerator12, true);
    xYAreaRenderer1.setBaseCreateEntities(false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b11);

  }

  @Test
  public void test197() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test197"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    boolean b11 = combinedDomainXYPlot5.isRangeZoomable();
    java.awt.Image image12 = combinedDomainXYPlot5.getBackgroundImage();
    org.jfree.chart.axis.AxisSpace axisSpace13 = new org.jfree.chart.axis.AxisSpace();
    org.jfree.data.DomainOrder domainOrder14 = org.jfree.data.DomainOrder.DESCENDING;
    boolean b15 = axisSpace13.equals((java.lang.Object)domainOrder14);
    combinedDomainXYPlot5.setFixedRangeAxisSpace(axisSpace13);
    org.jfree.chart.axis.AxisLocation axisLocation17 = org.jfree.chart.axis.AxisLocation.TOP_OR_RIGHT;
    combinedDomainXYPlot5.setRangeAxisLocation(axisLocation17);
    int i19 = combinedDomainXYPlot5.getSeriesCount();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(image12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i19 == 0);

  }

  @Test
  public void test198() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test198"); }


    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator3 = new org.jfree.chart.urls.StandardXYURLGenerator("RectangleAnchor.LEFT", "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]", "{0}: ({1}, {2})");
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    boolean b12 = combinedDomainXYPlot9.isNotify();
    org.jfree.chart.JFreeChart jFreeChart14 = new org.jfree.chart.JFreeChart("", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    combinedDomainXYPlot9.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer17 = null;
    combinedDomainXYPlot9.setRenderer(xYItemRenderer17);
    boolean b19 = combinedDomainXYPlot9.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries20 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection21 = new org.jfree.data.time.TimeSeriesCollection(timeSeries20);
    combinedDomainXYPlot9.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection21);
    timeSeriesCollection21.removeAllSeries();
    java.lang.String str26 = standardXYURLGenerator3.generateURL((org.jfree.data.xy.XYDataset)timeSeriesCollection21, 4, 255);
    org.jfree.data.general.DatasetGroup datasetGroup27 = timeSeriesCollection21.getGroup();
    java.lang.Object obj28 = timeSeriesCollection21.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str26 + "' != '" + "RectangleAnchor.LEFT?[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]=4&amp;{0}: ({1}, {2})=255"+ "'", str26.equals("RectangleAnchor.LEFT?[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]=4&amp;{0}: ({1}, {2})=255"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(datasetGroup27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj28);

  }

  @Test
  public void test199() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test199"); }


    java.awt.Paint paint1 = org.jfree.chart.plot.XYPlot.DEFAULT_CROSSHAIR_PAINT;
    java.awt.Stroke stroke2 = null;
    org.jfree.chart.StandardChartTheme standardChartTheme4 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Paint paint5 = standardChartTheme4.getItemLabelPaint();
    java.awt.Shape shape13 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color15 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.green;
    java.awt.Color color23 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke24 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color25 = java.awt.Color.orange;
    java.awt.Stroke stroke26 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker28 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color23, stroke24, (java.awt.Paint)color25, stroke26, 0.0f);
    java.awt.Shape shape32 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke33 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color34 = java.awt.Color.green;
    java.lang.String str35 = org.jfree.chart.util.PaintUtilities.colorToString(color34);
    org.jfree.chart.LegendItem legendItem36 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape13, true, (java.awt.Paint)color15, false, (java.awt.Paint)color17, stroke24, true, shape32, stroke33, (java.awt.Paint)color34);
    standardChartTheme4.setLabelLinkPaint((java.awt.Paint)color34);
    java.awt.Paint paint38 = standardChartTheme4.getTitlePaint();
    java.awt.Font font40 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset41 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot42 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset41);
    org.jfree.chart.axis.ValueAxis valueAxis43 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot44 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis43);
    java.util.List list45 = combinedDomainXYPlot44.getAnnotations();
    waferMapPlot42.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot44);
    org.jfree.chart.JFreeChart jFreeChart48 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font40, (org.jfree.chart.plot.Plot)combinedDomainXYPlot44, true);
    org.jfree.chart.axis.NumberAxis numberAxis50 = new org.jfree.chart.axis.NumberAxis();
    numberAxis50.centerRange(100.0d);
    combinedDomainXYPlot44.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis50);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier54 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot44.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier54);
    org.jfree.chart.LegendItemCollection legendItemCollection56 = combinedDomainXYPlot44.getLegendItems();
    double d57 = combinedDomainXYPlot44.getRangeCrosshairValue();
    org.jfree.chart.axis.ValueAxis valueAxis58 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot59 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis58);
    org.jfree.chart.plot.Plot plot60 = combinedDomainXYPlot59.getRootPlot();
    org.jfree.chart.axis.ValueAxis valueAxis61 = null;
    int i62 = combinedDomainXYPlot59.getRangeAxisIndex(valueAxis61);
    java.awt.Stroke stroke63 = combinedDomainXYPlot59.getDomainZeroBaselineStroke();
    combinedDomainXYPlot44.setRangeZeroBaselineStroke(stroke63);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.plot.ValueMarker valueMarker66 = new org.jfree.chart.plot.ValueMarker(100.5d, paint1, stroke2, paint38, stroke63, 2.0f);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str35 + "' != '" + "green"+ "'", str35.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d57 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i62 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke63);

  }

  @Test
  public void test200() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test200"); }


    int i1 = org.jfree.data.time.SerialDate.stringToMonthCode("February 2016");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == (-1));

  }

  @Test
  public void test201() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test201"); }


    org.jfree.chart.axis.LogAxis logAxis1 = new org.jfree.chart.axis.LogAxis("ClassContext");
    logAxis1.zoomRange(0.0d, 4.5d);
    double d5 = logAxis1.getBase();
    org.jfree.chart.axis.NumberTickUnit numberTickUnit7 = new org.jfree.chart.axis.NumberTickUnit(100.0d);
    logAxis1.setTickUnit(numberTickUnit7, true, false);
    java.awt.Graphics2D graphics2D11 = null;
    org.jfree.chart.axis.AxisState axisState13 = new org.jfree.chart.axis.AxisState(1.0d);
    double d14 = axisState13.getCursor();
    axisState13.cursorLeft(0.2d);
    axisState13.cursorUp(1.0d);
    org.jfree.chart.axis.ValueAxis valueAxis19 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot20 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis19);
    org.jfree.chart.plot.Plot plot21 = combinedDomainXYPlot20.getRootPlot();
    org.jfree.chart.LegendItemCollection legendItemCollection22 = null;
    combinedDomainXYPlot20.setFixedLegendItems(legendItemCollection22);
    org.jfree.chart.event.PlotChangeEvent plotChangeEvent24 = null;
    combinedDomainXYPlot20.notifyListeners(plotChangeEvent24);
    java.awt.Color color26 = java.awt.Color.cyan;
    combinedDomainXYPlot20.setDomainCrosshairPaint((java.awt.Paint)color26);
    java.awt.geom.GeneralPath generalPath28 = null;
    org.jfree.data.xy.XYSeries xYSeries29 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection30 = new org.jfree.data.xy.XYSeriesCollection(xYSeries29);
    boolean b31 = xYSeriesCollection30.isAutoWidth();
    org.jfree.data.Range range33 = xYSeriesCollection30.getRangeBounds(true);
    xYSeriesCollection30.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis36 = new org.jfree.chart.axis.NumberAxis();
    numberAxis36.centerRange(100.0d);
    java.lang.Object obj39 = numberAxis36.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer40 = null;
    org.jfree.chart.plot.PolarPlot polarPlot41 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection30, (org.jfree.chart.axis.ValueAxis)numberAxis36, polarItemRenderer40);
    org.jfree.chart.plot.PlotOrientation plotOrientation42 = polarPlot41.getOrientation();
    boolean b43 = polarPlot41.isAngleLabelsVisible();
    int i44 = polarPlot41.getSeriesCount();
    java.awt.Font font49 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset50 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot51 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset50);
    org.jfree.chart.axis.ValueAxis valueAxis52 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot53 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis52);
    java.util.List list54 = combinedDomainXYPlot53.getAnnotations();
    waferMapPlot51.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot53);
    boolean b56 = combinedDomainXYPlot53.isNotify();
    org.jfree.chart.JFreeChart jFreeChart58 = new org.jfree.chart.JFreeChart("", font49, (org.jfree.chart.plot.Plot)combinedDomainXYPlot53, true);
    org.jfree.chart.title.TextTitle textTitle59 = new org.jfree.chart.title.TextTitle("", font49);
    textTitle59.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame62 = textTitle59.getFrame();
    java.lang.String str63 = textTitle59.getID();
    java.awt.geom.Rectangle2D rectangle2D64 = textTitle59.getBounds();
    java.awt.Point point65 = polarPlot41.translateValueThetaRadiusToJava2D(0.0d, 0.05d, rectangle2D64);
    org.jfree.chart.RenderingSource renderingSource66 = null;
    combinedDomainXYPlot20.select(generalPath28, rectangle2D64, renderingSource66);
    java.awt.Font font69 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset70 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot71 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset70);
    org.jfree.chart.axis.ValueAxis valueAxis72 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot73 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis72);
    java.util.List list74 = combinedDomainXYPlot73.getAnnotations();
    waferMapPlot71.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot73);
    boolean b76 = combinedDomainXYPlot73.isNotify();
    org.jfree.chart.JFreeChart jFreeChart78 = new org.jfree.chart.JFreeChart("", font69, (org.jfree.chart.plot.Plot)combinedDomainXYPlot73, true);
    combinedDomainXYPlot73.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.util.RectangleEdge rectangleEdge81 = combinedDomainXYPlot73.getDomainAxisEdge();
    // The following exception was thrown during execution in test generation
    try {
      java.util.List list82 = logAxis1.refreshTicks(graphics2D11, axisState13, rectangle2D64, rectangleEdge81);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 10.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b43 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i44 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b56 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list74);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b76 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge81);

  }

  @Test
  public void test202() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test202"); }


    org.jfree.data.xy.DefaultXYDataset defaultXYDataset0 = new org.jfree.data.xy.DefaultXYDataset();
    int i2 = defaultXYDataset0.indexOf((java.lang.Comparable)255);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number5 = defaultXYDataset0.getY(15, 2958465);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == (-1));

  }

  @Test
  public void test203() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test203"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer13 = null;
    combinedDomainXYPlot5.setRenderer(xYItemRenderer13);
    boolean b15 = combinedDomainXYPlot5.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries16 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection17 = new org.jfree.data.time.TimeSeriesCollection(timeSeries16);
    combinedDomainXYPlot5.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
    timeSeriesCollection17.removeAllSeries();
    // The following exception was thrown during execution in test generation
    try {
      double d22 = timeSeriesCollection17.getEndXValue((-25560), 11);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);

  }

  @Test
  public void test204() {}
// Defects4J: flaky method
//   @Test
//   public void test204() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test204"); }
// 
// 
//     java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
//     org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
//     org.jfree.chart.axis.ValueAxis valueAxis4 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
//     java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
//     waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
//     org.jfree.chart.JFreeChart jFreeChart9 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
//     org.jfree.chart.axis.AxisSpace axisSpace10 = null;
//     combinedDomainXYPlot5.setFixedRangeAxisSpace(axisSpace10);
//     org.jfree.chart.axis.ValueAxis valueAxis12 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot13 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis12);
//     java.util.List list14 = combinedDomainXYPlot13.getAnnotations();
//     combinedDomainXYPlot13.setRangeGridlinesVisible(true);
//     org.jfree.chart.axis.ValueAxis valueAxis18 = null;
//     combinedDomainXYPlot13.setRangeAxis(100, valueAxis18, false);
//     org.jfree.chart.axis.NumberAxis numberAxis21 = new org.jfree.chart.axis.NumberAxis();
//     numberAxis21.centerRange(100.0d);
//     combinedDomainXYPlot13.setRangeAxis((org.jfree.chart.axis.ValueAxis)numberAxis21);
//     boolean b25 = numberAxis21.isNegativeArrowVisible();
//     org.jfree.data.time.DateRange dateRange28 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     org.jfree.data.time.DateRange dateRange31 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     boolean b32 = dateRange28.intersects((org.jfree.data.Range)dateRange31);
//     java.lang.String str33 = dateRange28.toString();
//     numberAxis21.setDefaultAutoRange((org.jfree.data.Range)dateRange28);
//     numberAxis21.setTickMarkInsideLength(10.0f);
//     org.jfree.data.Range range37 = combinedDomainXYPlot5.getDataRange((org.jfree.chart.axis.ValueAxis)numberAxis21);
//     org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer39 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
//     org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator40 = xYAreaRenderer39.getLegendItemToolTipGenerator();
//     java.awt.Shape shape41 = xYAreaRenderer39.getBaseShape();
//     java.awt.Stroke stroke42 = org.jfree.chart.plot.WaferMapPlot.DEFAULT_CROSSHAIR_STROKE;
//     xYAreaRenderer39.setBaseStroke(stroke42, true);
//     combinedDomainXYPlot5.setDomainZeroBaselineStroke(stroke42);
//     org.jfree.chart.util.RectangleInsets rectangleInsets46 = combinedDomainXYPlot5.getInsets();
//     java.awt.Stroke stroke47 = combinedDomainXYPlot5.getDomainCrosshairStroke();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(font1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list6);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b25 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b32 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str33 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str33.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(range37);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(xYSeriesLabelGenerator40);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(shape41);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke42);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleInsets46);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke47);
// 
//   }

  @Test
  public void test205() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test205"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    org.jfree.data.category.CategoryDataset categoryDataset2 = null;
    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot3 = new org.jfree.chart.plot.MultiplePiePlot(categoryDataset2);
    combinedDomainXYPlot1.setParent((org.jfree.chart.plot.Plot)multiplePiePlot3);
    org.jfree.chart.axis.ValueAxis valueAxis5 = null;
    combinedDomainXYPlot1.setDomainAxis(valueAxis5);
    org.jfree.data.xy.XYSeries xYSeries7 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection8 = new org.jfree.data.xy.XYSeriesCollection(xYSeries7);
    boolean b9 = xYSeriesCollection8.isAutoWidth();
    org.jfree.data.Range range11 = xYSeriesCollection8.getRangeBounds(true);
    xYSeriesCollection8.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis14 = new org.jfree.chart.axis.NumberAxis();
    numberAxis14.centerRange(100.0d);
    java.lang.Object obj17 = numberAxis14.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer18 = null;
    org.jfree.chart.plot.PolarPlot polarPlot19 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection8, (org.jfree.chart.axis.ValueAxis)numberAxis14, polarItemRenderer18);
    org.jfree.chart.plot.PlotOrientation plotOrientation20 = polarPlot19.getOrientation();
    boolean b21 = polarPlot19.isAngleLabelsVisible();
    org.jfree.chart.axis.NumberAxis numberAxis22 = new org.jfree.chart.axis.NumberAxis();
    numberAxis22.centerRange(100.0d);
    java.awt.Paint paint25 = numberAxis22.getLabelPaint();
    polarPlot19.setAxis((org.jfree.chart.axis.ValueAxis)numberAxis22);
    boolean b27 = polarPlot19.isRangeZoomable();
    java.awt.Stroke stroke28 = polarPlot19.getRadiusGridlineStroke();
    combinedDomainXYPlot1.setRangeCrosshairStroke(stroke28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b21 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke28);

  }

  @Test
  public void test206() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test206"); }


    java.util.TimeZone timeZone0 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection1 = new org.jfree.data.time.TimeSeriesCollection(timeZone0);
    org.jfree.chart.event.RendererChangeEvent rendererChangeEvent3 = new org.jfree.chart.event.RendererChangeEvent((java.lang.Object)timeSeriesCollection1, false);
    double d5 = timeSeriesCollection1.getDomainUpperBound(false);
    java.lang.Number number6 = org.jfree.data.general.DatasetUtilities.findMaximumRangeValue((org.jfree.data.xy.XYDataset)timeSeriesCollection1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d5, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(number6);

  }

  @Test
  public void test207() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test207"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    xYStepRenderer0.setSeriesShapesFilled(15, false);
    boolean b6 = xYStepRenderer0.getItemLineVisible(1, 8);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator7 = xYStepRenderer0.getBaseToolTipGenerator();
    int i8 = xYStepRenderer0.getPassCount();
    java.awt.Graphics2D graphics2D9 = null;
    org.jfree.chart.plot.XYPlot xYPlot10 = null;
    org.jfree.chart.axis.ValueAxis valueAxis11 = null;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer23 = null;
    intervalMarker22.setGradientPaintTransformer(gradientPaintTransformer23);
    org.jfree.chart.util.RectangleInsets rectangleInsets25 = intervalMarker22.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis27 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets28 = categoryAxis27.getLabelInsets();
    intervalMarker22.setLabelOffset(rectangleInsets28);
    org.jfree.data.xy.XYSeries xYSeries30 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection31 = new org.jfree.data.xy.XYSeriesCollection(xYSeries30);
    boolean b32 = xYSeriesCollection31.isAutoWidth();
    org.jfree.data.Range range34 = xYSeriesCollection31.getRangeBounds(true);
    xYSeriesCollection31.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis37 = new org.jfree.chart.axis.NumberAxis();
    numberAxis37.centerRange(100.0d);
    java.lang.Object obj40 = numberAxis37.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer41 = null;
    org.jfree.chart.plot.PolarPlot polarPlot42 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection31, (org.jfree.chart.axis.ValueAxis)numberAxis37, polarItemRenderer41);
    org.jfree.chart.plot.PlotOrientation plotOrientation43 = polarPlot42.getOrientation();
    boolean b44 = polarPlot42.isAngleLabelsVisible();
    int i45 = polarPlot42.getSeriesCount();
    java.awt.Font font50 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset51 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot52 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset51);
    org.jfree.chart.axis.ValueAxis valueAxis53 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot54 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis53);
    java.util.List list55 = combinedDomainXYPlot54.getAnnotations();
    waferMapPlot52.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot54);
    boolean b57 = combinedDomainXYPlot54.isNotify();
    org.jfree.chart.JFreeChart jFreeChart59 = new org.jfree.chart.JFreeChart("", font50, (org.jfree.chart.plot.Plot)combinedDomainXYPlot54, true);
    org.jfree.chart.title.TextTitle textTitle60 = new org.jfree.chart.title.TextTitle("", font50);
    textTitle60.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame63 = textTitle60.getFrame();
    java.lang.String str64 = textTitle60.getID();
    java.awt.geom.Rectangle2D rectangle2D65 = textTitle60.getBounds();
    java.awt.Point point66 = polarPlot42.translateValueThetaRadiusToJava2D(0.0d, 0.05d, rectangle2D65);
    // The following exception was thrown during execution in test generation
    try {
      xYStepRenderer0.drawDomainMarker(graphics2D9, xYPlot10, valueAxis11, (org.jfree.chart.plot.Marker)intervalMarker22, rectangle2D65);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYToolTipGenerator7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i8 == 2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i45 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b57 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point66);

  }

  @Test
  public void test208() {}
// Defects4J: flaky method
//   @Test
//   public void test208() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test208"); }
// 
// 
//     java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
//     org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
//     org.jfree.chart.axis.ValueAxis valueAxis4 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
//     java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
//     waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
//     boolean b8 = combinedDomainXYPlot5.isNotify();
//     org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
//     combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
//     org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer13 = null;
//     combinedDomainXYPlot5.setRenderer(xYItemRenderer13);
//     boolean b15 = combinedDomainXYPlot5.isDomainCrosshairVisible();
//     org.jfree.data.time.TimeSeries timeSeries16 = null;
//     org.jfree.data.time.TimeSeriesCollection timeSeriesCollection17 = new org.jfree.data.time.TimeSeriesCollection(timeSeries16);
//     combinedDomainXYPlot5.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
//     timeSeriesCollection17.removeAllSeries();
//     org.jfree.data.time.DateRange dateRange22 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d23 = dateRange22.getLength();
//     long long24 = dateRange22.getLowerMillis();
//     double d25 = dateRange22.getLength();
//     java.lang.String str26 = dateRange22.toString();
//     java.util.Date date27 = dateRange22.getUpperDate();
//     org.jfree.data.time.SerialDate serialDate28 = org.jfree.data.time.SerialDate.createInstance(date27);
//     org.jfree.data.time.Month month29 = new org.jfree.data.time.Month(date27);
//     org.jfree.data.time.TimeSeries timeSeries30 = timeSeriesCollection17.getSeries((java.lang.Comparable)month29);
//     // The following exception was thrown during execution in test generation
//     try {
//       double d33 = timeSeriesCollection17.getXValue((-25560), 14);
//       org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
//     } catch (java.lang.ArrayIndexOutOfBoundsException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(font1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list6);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b8 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b15 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d23 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long24 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d25 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str26 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str26.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(serialDate28);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(timeSeries30);
// 
//   }

  @Test
  public void test209() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test209"); }


    org.jfree.chart.block.LabelBlock labelBlock1 = new org.jfree.chart.block.LabelBlock("TextAnchor.CENTER");
    java.lang.Object obj2 = labelBlock1.clone();
    labelBlock1.setWidth(4.0d);
    java.awt.Graphics2D graphics2D5 = null;
    org.jfree.chart.util.RectangleInsets rectangleInsets6 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.chart.util.UnitType unitType7 = rectangleInsets6.getUnitType();
    org.jfree.chart.axis.LogAxis logAxis9 = new org.jfree.chart.axis.LogAxis("ClassContext");
    org.jfree.data.xy.XYSeries xYSeries11 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection12 = new org.jfree.data.xy.XYSeriesCollection(xYSeries11);
    boolean b13 = xYSeriesCollection12.isAutoWidth();
    org.jfree.data.Range range15 = xYSeriesCollection12.getRangeBounds(true);
    xYSeriesCollection12.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis18 = new org.jfree.chart.axis.NumberAxis();
    numberAxis18.centerRange(100.0d);
    java.lang.Object obj21 = numberAxis18.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer22 = null;
    org.jfree.chart.plot.PolarPlot polarPlot23 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection12, (org.jfree.chart.axis.ValueAxis)numberAxis18, polarItemRenderer22);
    org.jfree.chart.plot.PlotOrientation plotOrientation24 = polarPlot23.getOrientation();
    boolean b25 = polarPlot23.isAngleLabelsVisible();
    int i26 = polarPlot23.getSeriesCount();
    java.awt.Font font31 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset32 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot33 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset32);
    org.jfree.chart.axis.ValueAxis valueAxis34 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot35 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis34);
    java.util.List list36 = combinedDomainXYPlot35.getAnnotations();
    waferMapPlot33.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot35);
    boolean b38 = combinedDomainXYPlot35.isNotify();
    org.jfree.chart.JFreeChart jFreeChart40 = new org.jfree.chart.JFreeChart("", font31, (org.jfree.chart.plot.Plot)combinedDomainXYPlot35, true);
    org.jfree.chart.title.TextTitle textTitle41 = new org.jfree.chart.title.TextTitle("", font31);
    textTitle41.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame44 = textTitle41.getFrame();
    java.lang.String str45 = textTitle41.getID();
    java.awt.geom.Rectangle2D rectangle2D46 = textTitle41.getBounds();
    java.awt.Point point47 = polarPlot23.translateValueThetaRadiusToJava2D(0.0d, 0.05d, rectangle2D46);
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D49 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke50 = categoryAxis3D49.getTickMarkStroke();
    java.awt.Graphics2D graphics2D51 = null;
    java.awt.geom.Rectangle2D rectangle2D53 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge54 = org.jfree.chart.util.RectangleEdge.LEFT;
    org.jfree.chart.axis.AxisState axisState56 = new org.jfree.chart.axis.AxisState(1.0d);
    double d57 = axisState56.getCursor();
    axisState56.cursorLeft(0.2d);
    categoryAxis3D49.drawTickMarks(graphics2D51, 7.0d, rectangle2D53, rectangleEdge54, axisState56);
    boolean b61 = org.jfree.chart.util.RectangleEdge.isTopOrBottom(rectangleEdge54);
    double d62 = logAxis9.java2DToValue(2.0d, rectangle2D46, rectangleEdge54);
    java.awt.geom.Rectangle2D rectangle2D63 = rectangleInsets6.createInsetRectangle(rectangle2D46);
    // The following exception was thrown during execution in test generation
    try {
      labelBlock1.draw(graphics2D5, rectangle2D46);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(unitType7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i26 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d57 == 1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b61 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d62, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D63);

  }

  @Test
  public void test210() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test210"); }


    org.jfree.chart.axis.NumberAxis3D numberAxis3D0 = new org.jfree.chart.axis.NumberAxis3D();
    org.jfree.data.Range range2 = null;
    org.jfree.chart.block.RectangleConstraint rectangleConstraint3 = new org.jfree.chart.block.RectangleConstraint(100.0d, range2);
    org.jfree.chart.block.LengthConstraintType lengthConstraintType4 = rectangleConstraint3.getWidthConstraintType();
    org.jfree.data.time.DateRange dateRange7 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange10 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b11 = dateRange7.intersects((org.jfree.data.Range)dateRange10);
    org.jfree.chart.block.RectangleConstraint rectangleConstraint12 = rectangleConstraint3.toRangeHeight((org.jfree.data.Range)dateRange10);
    numberAxis3D0.setDefaultAutoRange((org.jfree.data.Range)dateRange10);
    numberAxis3D0.resizeRange(0.2d);
    float f16 = numberAxis3D0.getMinorTickMarkOutsideLength();
    org.jfree.chart.axis.NumberTickUnit numberTickUnit17 = numberAxis3D0.getTickUnit();
    boolean b18 = numberAxis3D0.getAutoRangeStickyZero();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleConstraint12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f16 == 2.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberTickUnit17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == true);

  }

  @Test
  public void test211() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test211"); }


    org.jfree.chart.StandardChartTheme standardChartTheme1 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.renderer.category.BarPainter barPainter2 = standardChartTheme1.getBarPainter();
    java.awt.Font font3 = standardChartTheme1.getLargeFont();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer5 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator6 = xYAreaRenderer5.getLegendItemToolTipGenerator();
    boolean b9 = xYAreaRenderer5.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition13 = xYAreaRenderer5.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b15 = xYAreaRenderer5.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator16 = null;
    xYAreaRenderer5.setBaseToolTipGenerator(xYToolTipGenerator16, true);
    java.awt.Shape shape20 = xYAreaRenderer5.lookupLegendShape(3);
    java.awt.Shape shape22 = xYAreaRenderer5.getLegendShape(10);
    org.jfree.data.time.TimeSeries timeSeries23 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection24 = new org.jfree.data.time.TimeSeriesCollection(timeSeries23);
    timeSeriesCollection24.validateObject();
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent26 = null;
    timeSeriesCollection24.seriesChanged(seriesChangeEvent26);
    org.jfree.data.Range range28 = xYAreaRenderer5.findDomainBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection24);
    org.jfree.chart.axis.CategoryAxis categoryAxis29 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset30 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot31 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset30);
    org.jfree.chart.axis.ValueAxis valueAxis32 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot33 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis32);
    java.util.List list34 = combinedDomainXYPlot33.getAnnotations();
    waferMapPlot31.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot33);
    int i36 = combinedDomainXYPlot33.getSeriesCount();
    categoryAxis29.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot33);
    boolean b39 = categoryAxis29.equals((java.lang.Object)(short)1);
    java.awt.Paint paint40 = categoryAxis29.getTickMarkPaint();
    xYAreaRenderer5.setBaseLegendTextPaint(paint40);
    standardChartTheme1.setErrorIndicatorPaint(paint40);
    org.jfree.chart.plot.PieLabelLinkStyle pieLabelLinkStyle43 = org.jfree.chart.plot.PieLabelLinkStyle.QUAD_CURVE;
    standardChartTheme1.setLabelLinkStyle(pieLabelLinkStyle43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(barPainter2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(shape22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i36 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(pieLabelLinkStyle43);

  }

  @Test
  public void test212() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test212"); }


    org.jfree.data.xy.XYSeries xYSeries0 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection1 = new org.jfree.data.xy.XYSeriesCollection(xYSeries0);
    boolean b2 = xYSeriesCollection1.isAutoWidth();
    org.jfree.data.Range range4 = xYSeriesCollection1.getRangeBounds(true);
    xYSeriesCollection1.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis7 = new org.jfree.chart.axis.NumberAxis();
    numberAxis7.centerRange(100.0d);
    java.lang.Object obj10 = numberAxis7.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer11 = null;
    org.jfree.chart.plot.PolarPlot polarPlot12 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection1, (org.jfree.chart.axis.ValueAxis)numberAxis7, polarItemRenderer11);
    org.jfree.data.xy.XYDataset xYDataset13 = polarPlot12.getDataset();
    org.jfree.chart.plot.CategoryPlot categoryPlot14 = new org.jfree.chart.plot.CategoryPlot();
    boolean b15 = categoryPlot14.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge17 = categoryPlot14.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis19 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets20 = categoryAxis19.getLabelInsets();
    double d22 = rectangleInsets20.calculateLeftInset(4.0d);
    categoryPlot14.setInsets(rectangleInsets20, false);
    org.jfree.chart.util.Layer layer26 = null;
    java.util.Collection collection27 = categoryPlot14.getDomainMarkers(5, layer26);
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer28 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition30 = xYStepRenderer28.getSeriesPositiveItemLabelPosition(3);
    java.lang.Boolean b32 = xYStepRenderer28.getSeriesLinesVisible(0);
    java.text.DateFormat dateFormat35 = null;
    java.text.DateFormat dateFormat36 = null;
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator37 = new org.jfree.chart.labels.StandardXYToolTipGenerator("31-December-1969", dateFormat35, dateFormat36);
    xYStepRenderer28.setSeriesToolTipGenerator(0, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator37, false);
    org.jfree.data.xy.XYSeries xYSeries40 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection41 = new org.jfree.data.xy.XYSeriesCollection(xYSeries40);
    double d43 = xYSeriesCollection41.getDomainUpperBound(false);
    org.jfree.data.general.DatasetChangeEvent datasetChangeEvent44 = new org.jfree.data.general.DatasetChangeEvent((java.lang.Object)0, (org.jfree.data.general.Dataset)xYSeriesCollection41);
    categoryPlot14.datasetChanged(datasetChangeEvent44);
    polarPlot12.datasetChanged(datasetChangeEvent44);
    polarPlot12.setAngleLabelsVisible(true);
    org.jfree.chart.axis.ValueAxis valueAxis49 = polarPlot12.getAxis();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(xYDataset13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d22 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d43, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(valueAxis49);

  }

  @Test
  public void test213() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test213"); }


    org.jfree.chart.axis.AxisSpace axisSpace0 = new org.jfree.chart.axis.AxisSpace();
    org.jfree.data.DomainOrder domainOrder1 = org.jfree.data.DomainOrder.DESCENDING;
    boolean b2 = axisSpace0.equals((java.lang.Object)domainOrder1);
    org.jfree.chart.axis.AxisSpace axisSpace3 = new org.jfree.chart.axis.AxisSpace();
    axisSpace0.ensureAtLeast(axisSpace3);
    java.awt.geom.Rectangle2D rectangle2D5 = null;
    org.jfree.chart.util.RectangleInsets rectangleInsets6 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.chart.util.UnitType unitType7 = rectangleInsets6.getUnitType();
    org.jfree.chart.axis.LogAxis logAxis9 = new org.jfree.chart.axis.LogAxis("ClassContext");
    org.jfree.data.xy.XYSeries xYSeries11 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection12 = new org.jfree.data.xy.XYSeriesCollection(xYSeries11);
    boolean b13 = xYSeriesCollection12.isAutoWidth();
    org.jfree.data.Range range15 = xYSeriesCollection12.getRangeBounds(true);
    xYSeriesCollection12.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis18 = new org.jfree.chart.axis.NumberAxis();
    numberAxis18.centerRange(100.0d);
    java.lang.Object obj21 = numberAxis18.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer22 = null;
    org.jfree.chart.plot.PolarPlot polarPlot23 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection12, (org.jfree.chart.axis.ValueAxis)numberAxis18, polarItemRenderer22);
    org.jfree.chart.plot.PlotOrientation plotOrientation24 = polarPlot23.getOrientation();
    boolean b25 = polarPlot23.isAngleLabelsVisible();
    int i26 = polarPlot23.getSeriesCount();
    java.awt.Font font31 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset32 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot33 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset32);
    org.jfree.chart.axis.ValueAxis valueAxis34 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot35 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis34);
    java.util.List list36 = combinedDomainXYPlot35.getAnnotations();
    waferMapPlot33.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot35);
    boolean b38 = combinedDomainXYPlot35.isNotify();
    org.jfree.chart.JFreeChart jFreeChart40 = new org.jfree.chart.JFreeChart("", font31, (org.jfree.chart.plot.Plot)combinedDomainXYPlot35, true);
    org.jfree.chart.title.TextTitle textTitle41 = new org.jfree.chart.title.TextTitle("", font31);
    textTitle41.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame44 = textTitle41.getFrame();
    java.lang.String str45 = textTitle41.getID();
    java.awt.geom.Rectangle2D rectangle2D46 = textTitle41.getBounds();
    java.awt.Point point47 = polarPlot23.translateValueThetaRadiusToJava2D(0.0d, 0.05d, rectangle2D46);
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D49 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke50 = categoryAxis3D49.getTickMarkStroke();
    java.awt.Graphics2D graphics2D51 = null;
    java.awt.geom.Rectangle2D rectangle2D53 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge54 = org.jfree.chart.util.RectangleEdge.LEFT;
    org.jfree.chart.axis.AxisState axisState56 = new org.jfree.chart.axis.AxisState(1.0d);
    double d57 = axisState56.getCursor();
    axisState56.cursorLeft(0.2d);
    categoryAxis3D49.drawTickMarks(graphics2D51, 7.0d, rectangle2D53, rectangleEdge54, axisState56);
    boolean b61 = org.jfree.chart.util.RectangleEdge.isTopOrBottom(rectangleEdge54);
    double d62 = logAxis9.java2DToValue(2.0d, rectangle2D46, rectangleEdge54);
    java.awt.geom.Rectangle2D rectangle2D63 = rectangleInsets6.createInsetRectangle(rectangle2D46);
    // The following exception was thrown during execution in test generation
    try {
      java.awt.geom.Rectangle2D rectangle2D64 = axisSpace0.expand(rectangle2D5, rectangle2D63);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(unitType7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i26 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d57 == 1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b61 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d62, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D63);

  }

  @Test
  public void test214() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test214"); }


    org.jfree.chart.StandardChartTheme standardChartTheme1 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Paint paint2 = standardChartTheme1.getItemLabelPaint();
    java.awt.Shape shape10 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color12 = java.awt.Color.green;
    java.awt.Color color14 = java.awt.Color.green;
    java.awt.Color color20 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke21 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color22 = java.awt.Color.orange;
    java.awt.Stroke stroke23 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker25 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color20, stroke21, (java.awt.Paint)color22, stroke23, 0.0f);
    java.awt.Shape shape29 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke30 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color31 = java.awt.Color.green;
    java.lang.String str32 = org.jfree.chart.util.PaintUtilities.colorToString(color31);
    org.jfree.chart.LegendItem legendItem33 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape10, true, (java.awt.Paint)color12, false, (java.awt.Paint)color14, stroke21, true, shape29, stroke30, (java.awt.Paint)color31);
    standardChartTheme1.setLabelLinkPaint((java.awt.Paint)color31);
    java.awt.Paint paint35 = standardChartTheme1.getLabelLinkPaint();
    java.awt.Paint paint36 = standardChartTheme1.getGridBandPaint();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str32 + "' != '" + "green"+ "'", str32.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint36);

  }

  @Test
  public void test215() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test215"); }


    int i0 = org.jfree.chart.util.AbstractObjectList.DEFAULT_INITIAL_CAPACITY;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 8);

  }

  @Test
  public void test216() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test216"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    org.jfree.data.time.TimeSeries timeSeries11 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection12 = new org.jfree.data.time.TimeSeriesCollection(timeSeries11);
    timeSeriesCollection12.validateObject();
    java.lang.Comparable comparable14 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer15 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.data.general.Dataset)timeSeriesCollection12, comparable14);
    org.jfree.chart.block.Arrangement arrangement16 = legendItemBlockContainer15.getArrangement();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrangement16);

  }

  @Test
  public void test217() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test217"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer13 = null;
    combinedDomainXYPlot5.setRenderer(xYItemRenderer13);
    org.jfree.chart.axis.AxisSpace axisSpace15 = combinedDomainXYPlot5.getFixedRangeAxisSpace();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer17 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier18 = xYAreaRenderer17.getDrawingSupplier();
    java.awt.Stroke stroke19 = xYAreaRenderer17.getBaseStroke();
    combinedDomainXYPlot5.setDomainCrosshairStroke(stroke19);
    combinedDomainXYPlot5.setNotify(true);
    java.awt.Stroke stroke23 = combinedDomainXYPlot5.getDomainGridlineStroke();
    org.jfree.chart.axis.AxisLocation axisLocation25 = combinedDomainXYPlot5.getRangeAxisLocation(9999);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.axis.ValueAxis valueAxis27 = combinedDomainXYPlot5.getDomainAxisForDataset(31);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(axisSpace15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation25);

  }

  @Test
  public void test218() {}
// Defects4J: flaky method
//   @Test
//   public void test218() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test218"); }
// 
// 
//     org.jfree.chart.axis.SegmentedTimeline segmentedTimeline3 = new org.jfree.chart.axis.SegmentedTimeline(1L, 133, 7);
//     org.jfree.chart.axis.DateTickUnitType dateTickUnitType4 = org.jfree.chart.axis.DateTickUnitType.MINUTE;
//     org.jfree.chart.axis.DateTickUnitType dateTickUnitType6 = org.jfree.chart.axis.DateTickUnitType.MONTH;
//     org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer9 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
//     double d10 = xYBarRenderer9.getMargin();
//     boolean b11 = xYBarRenderer9.getAutoPopulateSeriesShape();
//     org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator13 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
//     xYBarRenderer9.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator13, true);
//     java.lang.Object obj16 = standardXYToolTipGenerator13.clone();
//     java.text.DateFormat dateFormat17 = standardXYToolTipGenerator13.getXDateFormat();
//     org.jfree.chart.axis.DateTickUnit dateTickUnit18 = new org.jfree.chart.axis.DateTickUnit(dateTickUnitType4, 5, dateTickUnitType6, 4, dateFormat17);
//     org.jfree.data.time.DateRange dateRange21 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d22 = dateRange21.getLength();
//     long long23 = dateRange21.getLowerMillis();
//     double d24 = dateRange21.getLength();
//     java.lang.String str25 = dateRange21.toString();
//     java.util.Date date26 = dateRange21.getUpperDate();
//     org.jfree.data.time.DateRange dateRange29 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d30 = dateRange29.getLength();
//     long long31 = dateRange29.getLowerMillis();
//     double d32 = dateRange29.getLength();
//     java.lang.String str33 = dateRange29.toString();
//     java.util.Date date34 = dateRange29.getUpperDate();
//     java.util.TimeZone timeZone35 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year36 = new org.jfree.data.time.Year(date34, timeZone35);
//     java.util.Date date37 = dateTickUnit18.rollDate(date26, timeZone35);
//     org.jfree.chart.axis.SegmentedTimeline.Segment segment38 = segmentedTimeline3.getSegment(date26);
//     long long39 = segmentedTimeline3.getStartTime();
//     long long40 = segmentedTimeline3.getSegmentsGroupSize();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateTickUnitType4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateTickUnitType6);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d10 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b11 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(standardXYToolTipGenerator13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj16);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateFormat17);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d22 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long23 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d24 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str25 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str25.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date26);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d30 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long31 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d32 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str33 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str33.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date34);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date37);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(segment38);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long39 == 0L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long40 == 140L);
// 
//   }

  @Test
  public void test219() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test219"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator2 = xYAreaRenderer1.getLegendItemToolTipGenerator();
    java.awt.Shape shape3 = xYAreaRenderer1.getBaseShape();
    java.awt.Stroke stroke4 = org.jfree.chart.plot.WaferMapPlot.DEFAULT_CROSSHAIR_STROKE;
    xYAreaRenderer1.setBaseStroke(stroke4, true);
    java.awt.Color color8 = org.jfree.chart.ChartColor.LIGHT_RED;
    xYAreaRenderer1.setSeriesItemLabelPaint(10, (java.awt.Paint)color8, false);
    org.jfree.chart.urls.XYURLGenerator xYURLGenerator11 = null;
    xYAreaRenderer1.setBaseURLGenerator(xYURLGenerator11);
    java.lang.Boolean b14 = xYAreaRenderer1.getSeriesItemLabelsVisible(1);
    xYAreaRenderer1.clearSeriesPaints(false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b14);

  }

  @Test
  public void test220() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test220"); }


    int i1 = org.jfree.data.time.SerialDate.stringToMonthCode("ERROR : Relative To String");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == (-1));

  }

  @Test
  public void test221() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test221"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
    numberAxis15.centerRange(100.0d);
    combinedDomainXYPlot9.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis15);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier19 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot9.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.setBackgroundImageAlpha(0.0f);
    org.jfree.chart.axis.ValueAxis valueAxis24 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot25 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis24);
    org.jfree.chart.plot.Plot plot26 = combinedDomainXYPlot25.getRootPlot();
    org.jfree.chart.LegendItemCollection legendItemCollection27 = null;
    combinedDomainXYPlot25.setFixedLegendItems(legendItemCollection27);
    org.jfree.chart.event.PlotChangeEvent plotChangeEvent29 = null;
    combinedDomainXYPlot25.notifyListeners(plotChangeEvent29);
    java.awt.Color color31 = java.awt.Color.cyan;
    combinedDomainXYPlot25.setDomainCrosshairPaint((java.awt.Paint)color31);
    categoryPlot0.setNoDataMessagePaint((java.awt.Paint)color31);
    org.jfree.chart.util.SortOrder sortOrder34 = null;
    // The following exception was thrown during execution in test generation
    try {
      categoryPlot0.setColumnRenderingOrder(sortOrder34);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color31);

  }

  @Test
  public void test222() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test222"); }


    java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
    org.jfree.chart.axis.ValueAxis valueAxis4 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
    java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
    waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
    boolean b8 = combinedDomainXYPlot5.isNotify();
    org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
    // The following exception was thrown during execution in test generation
    try {
      java.awt.image.BufferedImage bufferedImage13 = jFreeChart10.createBufferedImage(0, 255);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);

  }

  @Test
  public void test223() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test223"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    org.jfree.chart.plot.CategoryPlot categoryPlot11 = new org.jfree.chart.plot.CategoryPlot();
    boolean b12 = categoryPlot11.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge14 = categoryPlot11.getDomainAxisEdge(8);
    legendTitle10.setPosition(rectangleEdge14);
    org.jfree.chart.util.RectangleAnchor rectangleAnchor16 = legendTitle10.getLegendItemGraphicLocation();
    org.jfree.chart.block.BlockFrame blockFrame17 = legendTitle10.getFrame();
    java.awt.Graphics2D graphics2D18 = null;
    org.jfree.chart.util.RectangleInsets rectangleInsets19 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.chart.util.UnitType unitType20 = rectangleInsets19.getUnitType();
    org.jfree.chart.axis.LogAxis logAxis22 = new org.jfree.chart.axis.LogAxis("ClassContext");
    org.jfree.data.xy.XYSeries xYSeries24 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection25 = new org.jfree.data.xy.XYSeriesCollection(xYSeries24);
    boolean b26 = xYSeriesCollection25.isAutoWidth();
    org.jfree.data.Range range28 = xYSeriesCollection25.getRangeBounds(true);
    xYSeriesCollection25.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis31 = new org.jfree.chart.axis.NumberAxis();
    numberAxis31.centerRange(100.0d);
    java.lang.Object obj34 = numberAxis31.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer35 = null;
    org.jfree.chart.plot.PolarPlot polarPlot36 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection25, (org.jfree.chart.axis.ValueAxis)numberAxis31, polarItemRenderer35);
    org.jfree.chart.plot.PlotOrientation plotOrientation37 = polarPlot36.getOrientation();
    boolean b38 = polarPlot36.isAngleLabelsVisible();
    int i39 = polarPlot36.getSeriesCount();
    java.awt.Font font44 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset45 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot46 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset45);
    org.jfree.chart.axis.ValueAxis valueAxis47 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot48 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis47);
    java.util.List list49 = combinedDomainXYPlot48.getAnnotations();
    waferMapPlot46.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot48);
    boolean b51 = combinedDomainXYPlot48.isNotify();
    org.jfree.chart.JFreeChart jFreeChart53 = new org.jfree.chart.JFreeChart("", font44, (org.jfree.chart.plot.Plot)combinedDomainXYPlot48, true);
    org.jfree.chart.title.TextTitle textTitle54 = new org.jfree.chart.title.TextTitle("", font44);
    textTitle54.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame57 = textTitle54.getFrame();
    java.lang.String str58 = textTitle54.getID();
    java.awt.geom.Rectangle2D rectangle2D59 = textTitle54.getBounds();
    java.awt.Point point60 = polarPlot36.translateValueThetaRadiusToJava2D(0.0d, 0.05d, rectangle2D59);
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D62 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke63 = categoryAxis3D62.getTickMarkStroke();
    java.awt.Graphics2D graphics2D64 = null;
    java.awt.geom.Rectangle2D rectangle2D66 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge67 = org.jfree.chart.util.RectangleEdge.LEFT;
    org.jfree.chart.axis.AxisState axisState69 = new org.jfree.chart.axis.AxisState(1.0d);
    double d70 = axisState69.getCursor();
    axisState69.cursorLeft(0.2d);
    categoryAxis3D62.drawTickMarks(graphics2D64, 7.0d, rectangle2D66, rectangleEdge67, axisState69);
    boolean b74 = org.jfree.chart.util.RectangleEdge.isTopOrBottom(rectangleEdge67);
    double d75 = logAxis22.java2DToValue(2.0d, rectangle2D59, rectangleEdge67);
    java.awt.geom.Rectangle2D rectangle2D76 = rectangleInsets19.createInsetRectangle(rectangle2D59);
    org.jfree.chart.util.RectangleInsets rectangleInsets81 = new org.jfree.chart.util.RectangleInsets(8.0d, 100.0d, 11.0d, 0.05d);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Object obj82 = legendTitle10.draw(graphics2D18, rectangle2D76, (java.lang.Object)0.05d);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleAnchor16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(unitType20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i39 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b51 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d70 == 1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b74 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d75, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D76);

  }

  @Test
  public void test224() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test224"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
    numberAxis15.centerRange(100.0d);
    combinedDomainXYPlot9.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis15);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier19 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot9.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.clearRangeMarkers(100);
    boolean b24 = categoryPlot0.isRangePannable();
    float f25 = categoryPlot0.getBackgroundAlpha();
    double d26 = categoryPlot0.getRangeCrosshairValue();
    org.jfree.chart.axis.AxisLocation axisLocation27 = categoryPlot0.getDomainAxisLocation();
    boolean b28 = categoryPlot0.isRangePannable();
    categoryPlot0.setRangeCrosshairValue(0.0d, false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f25 == 1.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d26 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);

  }

  @Test
  public void test225() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test225"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedRangeXYPlot combinedRangeXYPlot1 = new org.jfree.chart.plot.CombinedRangeXYPlot(valueAxis0);
    java.lang.String str2 = combinedRangeXYPlot1.getPlotType();
    org.jfree.chart.axis.ValueAxis valueAxis3 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot4 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis3);
    org.jfree.chart.plot.Plot plot5 = combinedDomainXYPlot4.getRootPlot();
    org.jfree.chart.LegendItemCollection legendItemCollection6 = null;
    combinedDomainXYPlot4.setFixedLegendItems(legendItemCollection6);
    org.jfree.chart.event.PlotChangeEvent plotChangeEvent8 = null;
    combinedDomainXYPlot4.notifyListeners(plotChangeEvent8);
    combinedDomainXYPlot4.setDomainMinorGridlinesVisible(true);
    combinedRangeXYPlot1.remove((org.jfree.chart.plot.XYPlot)combinedDomainXYPlot4);
    org.jfree.chart.LegendItemCollection legendItemCollection13 = combinedRangeXYPlot1.getLegendItems();
    org.jfree.chart.event.PlotChangeEvent plotChangeEvent14 = null;
    combinedRangeXYPlot1.plotChanged(plotChangeEvent14);
    java.lang.String str16 = combinedRangeXYPlot1.getPlotType();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str2 + "' != '" + "Combined Range XYPlot"+ "'", str2.equals("Combined Range XYPlot"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str16 + "' != '" + "Combined Range XYPlot"+ "'", str16.equals("Combined Range XYPlot"));

  }

  @Test
  public void test226() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test226"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    org.jfree.data.general.WaferMapDataset waferMapDataset31 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot32 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset31);
    org.jfree.chart.JFreeChart jFreeChart33 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent34 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot32, jFreeChart33);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment35 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment36 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement39 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment35, verticalAlignment36, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement40 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle41 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot32, (org.jfree.chart.block.Arrangement)flowArrangement39, (org.jfree.chart.block.Arrangement)borderArrangement40);
    org.jfree.chart.entity.TitleEntity titleEntity43 = new org.jfree.chart.entity.TitleEntity(shape7, (org.jfree.chart.title.Title)legendTitle41, "green");
    org.jfree.chart.util.RectangleInsets rectangleInsets44 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d45 = rectangleInsets44.getTop();
    legendTitle41.setItemLabelPadding(rectangleInsets44);
    org.jfree.chart.block.BlockContainer blockContainer47 = legendTitle41.getWrapper();
    org.jfree.chart.util.RectangleInsets rectangleInsets48 = null;
    // The following exception was thrown during execution in test generation
    try {
      blockContainer47.setMargin(rectangleInsets48);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d45 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(blockContainer47);

  }

  @Test
  public void test227() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test227"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis5 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets6 = categoryAxis5.getLabelInsets();
    double d8 = rectangleInsets6.calculateLeftInset(4.0d);
    categoryPlot0.setInsets(rectangleInsets6, false);
    int i11 = categoryPlot0.getRendererCount();
    categoryPlot0.setBackgroundAlpha(0.0f);
    java.awt.Paint paint14 = categoryPlot0.getDomainGridlinePaint();
    java.awt.Font font20 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset21 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot22 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset21);
    org.jfree.chart.axis.ValueAxis valueAxis23 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot24 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis23);
    java.util.List list25 = combinedDomainXYPlot24.getAnnotations();
    waferMapPlot22.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot24);
    org.jfree.chart.JFreeChart jFreeChart28 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font20, (org.jfree.chart.plot.Plot)combinedDomainXYPlot24, true);
    java.awt.Color color32 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment33 = new org.jfree.chart.text.TextFragment("hi!", font20, (java.awt.Paint)color32);
    java.awt.Paint paint34 = org.jfree.chart.plot.PiePlot.DEFAULT_LABEL_OUTLINE_PAINT;
    org.jfree.chart.plot.CategoryPlot categoryPlot35 = new org.jfree.chart.plot.CategoryPlot();
    boolean b36 = categoryPlot35.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge38 = categoryPlot35.getDomainAxisEdge(8);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment39 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment40 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement43 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment39, verticalAlignment40, 11.0d, 0.2d);
    org.jfree.chart.util.VerticalAlignment verticalAlignment44 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement47 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment39, verticalAlignment44, (-1.0d), Double.NaN);
    org.jfree.chart.util.VerticalAlignment verticalAlignment48 = org.jfree.chart.title.Title.DEFAULT_VERTICAL_ALIGNMENT;
    org.jfree.chart.util.RectangleInsets rectangleInsets49 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent50 = new org.jfree.data.general.SeriesChangeEvent((java.lang.Object)rectangleInsets49);
    org.jfree.chart.title.TextTitle textTitle51 = new org.jfree.chart.title.TextTitle("March", font20, paint34, rectangleEdge38, horizontalAlignment39, verticalAlignment48, rectangleInsets49);
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D53 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke54 = categoryAxis3D53.getTickMarkStroke();
    org.jfree.chart.plot.ValueMarker valueMarker55 = new org.jfree.chart.plot.ValueMarker(7.0d, paint34, stroke54);
    org.jfree.chart.util.Layer layer56 = null;
    boolean b57 = categoryPlot0.removeDomainMarker(15, (org.jfree.chart.plot.Marker)valueMarker55, layer56);
    org.jfree.data.general.DefaultPieDataset defaultPieDataset58 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj59 = defaultPieDataset58.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D60 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset58);
    java.awt.Paint paint61 = piePlot3D60.getLabelShadowPaint();
    org.jfree.chart.labels.StandardPieSectionLabelGenerator standardPieSectionLabelGenerator63 = new org.jfree.chart.labels.StandardPieSectionLabelGenerator("ERROR : Relative To String");
    piePlot3D60.setLegendLabelGenerator((org.jfree.chart.labels.PieSectionLabelGenerator)standardPieSectionLabelGenerator63);
    boolean b65 = categoryPlot0.equals((java.lang.Object)piePlot3D60);
    java.awt.Shape shape66 = piePlot3D60.getLegendItemShape();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i11 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(verticalAlignment48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b57 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b65 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape66);

  }

  @Test
  public void test228() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test228"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = xYStepRenderer0.getSeriesPositiveItemLabelPosition(3);
    java.awt.Paint paint6 = xYStepRenderer0.getItemFillPaint(5, 3, true);
    boolean b7 = xYStepRenderer0.getBaseShapesFilled();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);

  }

  @Test
  public void test229() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test229"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeGridlinesVisible();
    org.jfree.chart.entity.EntityCollection entityCollection3 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo4 = new org.jfree.chart.ChartRenderingInfo(entityCollection3);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo5 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo4);
    int i6 = plotRenderingInfo5.getSubplotCount();
    org.jfree.chart.renderer.xy.XYItemRendererState xYItemRendererState7 = new org.jfree.chart.renderer.xy.XYItemRendererState(plotRenderingInfo5);
    org.jfree.chart.axis.LogAxis logAxis11 = new org.jfree.chart.axis.LogAxis("ClassContext");
    org.jfree.data.xy.XYSeries xYSeries13 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection14 = new org.jfree.data.xy.XYSeriesCollection(xYSeries13);
    boolean b15 = xYSeriesCollection14.isAutoWidth();
    org.jfree.data.Range range17 = xYSeriesCollection14.getRangeBounds(true);
    xYSeriesCollection14.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis20 = new org.jfree.chart.axis.NumberAxis();
    numberAxis20.centerRange(100.0d);
    java.lang.Object obj23 = numberAxis20.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer24 = null;
    org.jfree.chart.plot.PolarPlot polarPlot25 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection14, (org.jfree.chart.axis.ValueAxis)numberAxis20, polarItemRenderer24);
    org.jfree.chart.plot.PlotOrientation plotOrientation26 = polarPlot25.getOrientation();
    boolean b27 = polarPlot25.isAngleLabelsVisible();
    int i28 = polarPlot25.getSeriesCount();
    java.awt.Font font33 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset34 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot35 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset34);
    org.jfree.chart.axis.ValueAxis valueAxis36 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot37 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis36);
    java.util.List list38 = combinedDomainXYPlot37.getAnnotations();
    waferMapPlot35.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot37);
    boolean b40 = combinedDomainXYPlot37.isNotify();
    org.jfree.chart.JFreeChart jFreeChart42 = new org.jfree.chart.JFreeChart("", font33, (org.jfree.chart.plot.Plot)combinedDomainXYPlot37, true);
    org.jfree.chart.title.TextTitle textTitle43 = new org.jfree.chart.title.TextTitle("", font33);
    textTitle43.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame46 = textTitle43.getFrame();
    java.lang.String str47 = textTitle43.getID();
    java.awt.geom.Rectangle2D rectangle2D48 = textTitle43.getBounds();
    java.awt.Point point49 = polarPlot25.translateValueThetaRadiusToJava2D(0.0d, 0.05d, rectangle2D48);
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D51 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke52 = categoryAxis3D51.getTickMarkStroke();
    java.awt.Graphics2D graphics2D53 = null;
    java.awt.geom.Rectangle2D rectangle2D55 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge56 = org.jfree.chart.util.RectangleEdge.LEFT;
    org.jfree.chart.axis.AxisState axisState58 = new org.jfree.chart.axis.AxisState(1.0d);
    double d59 = axisState58.getCursor();
    axisState58.cursorLeft(0.2d);
    categoryAxis3D51.drawTickMarks(graphics2D53, 7.0d, rectangle2D55, rectangleEdge56, axisState58);
    boolean b63 = org.jfree.chart.util.RectangleEdge.isTopOrBottom(rectangleEdge56);
    double d64 = logAxis11.java2DToValue(2.0d, rectangle2D48, rectangleEdge56);
    java.awt.geom.Point2D point2D65 = org.jfree.chart.util.ShapeUtilities.getPointInRectangle(1.0d, 0.0d, rectangle2D48);
    categoryPlot0.panRangeAxes(12.0d, plotRenderingInfo5, point2D65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i28 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d59 == 1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b63 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d64, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point2D65);

  }

  @Test
  public void test230() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test230"); }


    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator1 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator5 = new org.jfree.chart.urls.StandardXYURLGenerator("", "hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!", "");
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer6 = new org.jfree.chart.renderer.xy.XYStepRenderer((org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator1, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator5);
    org.jfree.chart.urls.XYURLGenerator xYURLGenerator7 = null;
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer8 = new org.jfree.chart.renderer.xy.XYAreaRenderer((-1), (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator1, xYURLGenerator7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator1);

  }

  @Test
  public void test231() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test231"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    piePlot3D2.setLabelLinksVisible(false);
    java.lang.Object obj6 = piePlot3D2.clone();
    org.jfree.chart.util.LogFormat logFormat11 = new org.jfree.chart.util.LogFormat(10.0d, "", true);
    java.lang.String str13 = logFormat11.format((java.lang.Object)100.0f);
    org.jfree.chart.util.LogFormat logFormat17 = new org.jfree.chart.util.LogFormat(10.0d, "", true);
    org.jfree.chart.labels.StandardPieSectionLabelGenerator standardPieSectionLabelGenerator18 = new org.jfree.chart.labels.StandardPieSectionLabelGenerator("", (java.text.NumberFormat)logFormat11, (java.text.NumberFormat)logFormat17);
    org.jfree.chart.axis.CategoryAxis categoryAxis19 = new org.jfree.chart.axis.CategoryAxis();
    categoryAxis19.setVisible(false);
    org.jfree.chart.util.RectangleInsets rectangleInsets22 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d23 = rectangleInsets22.getLeft();
    double d25 = rectangleInsets22.calculateLeftOutset(1.0d);
    categoryAxis19.setLabelInsets(rectangleInsets22, true);
    boolean b28 = standardPieSectionLabelGenerator18.equals((java.lang.Object)rectangleInsets22);
    piePlot3D2.setLabelPadding(rectangleInsets22);
    java.lang.String str30 = piePlot3D2.getPlotType();
    piePlot3D2.setSectionOutlinesVisible(true);
    org.jfree.chart.plot.PieLabelLinkStyle pieLabelLinkStyle33 = piePlot3D2.getLabelLinkStyle();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str13 + "' != '" + "^2.0"+ "'", str13.equals("^2.0"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d23 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d25 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str30 + "' != '" + "Pie 3D Plot"+ "'", str30.equals("Pie 3D Plot"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(pieLabelLinkStyle33);

  }

  @Test
  public void test232() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test232"); }


    java.awt.Color color5 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke6 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color7 = java.awt.Color.orange;
    java.awt.Stroke stroke8 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker10 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color5, stroke6, (java.awt.Paint)color7, stroke8, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer11 = null;
    intervalMarker10.setGradientPaintTransformer(gradientPaintTransformer11);
    org.jfree.chart.util.RectangleInsets rectangleInsets13 = intervalMarker10.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis15 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets16 = categoryAxis15.getLabelInsets();
    intervalMarker10.setLabelOffset(rectangleInsets16);
    double d18 = intervalMarker10.getEndValue();
    org.jfree.chart.util.LengthAdjustmentType lengthAdjustmentType19 = org.jfree.chart.util.LengthAdjustmentType.EXPAND;
    intervalMarker10.setLabelOffsetType(lengthAdjustmentType19);
    org.jfree.data.general.WaferMapDataset waferMapDataset21 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot22 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset21);
    org.jfree.chart.JFreeChart jFreeChart23 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent24 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot22, jFreeChart23);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment25 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment26 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement29 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment25, verticalAlignment26, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement30 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle31 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot22, (org.jfree.chart.block.Arrangement)flowArrangement29, (org.jfree.chart.block.Arrangement)borderArrangement30);
    org.jfree.chart.plot.CategoryPlot categoryPlot32 = new org.jfree.chart.plot.CategoryPlot();
    boolean b33 = categoryPlot32.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge35 = categoryPlot32.getDomainAxisEdge(8);
    legendTitle31.setPosition(rectangleEdge35);
    org.jfree.chart.util.RectangleAnchor rectangleAnchor37 = legendTitle31.getLegendItemGraphicLocation();
    intervalMarker10.setLabelAnchor(rectangleAnchor37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d18 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthAdjustmentType19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleAnchor37);

  }

  @Test
  public void test233() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test233"); }


    java.awt.Font font3 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset4 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot5 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset4);
    org.jfree.chart.axis.ValueAxis valueAxis6 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot7 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis6);
    java.util.List list8 = combinedDomainXYPlot7.getAnnotations();
    waferMapPlot5.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot7);
    org.jfree.chart.JFreeChart jFreeChart11 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font3, (org.jfree.chart.plot.Plot)combinedDomainXYPlot7, true);
    java.awt.Color color15 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment16 = new org.jfree.chart.text.TextFragment("hi!", font3, (java.awt.Paint)color15);
    java.awt.Paint paint17 = org.jfree.chart.plot.PiePlot.DEFAULT_LABEL_OUTLINE_PAINT;
    org.jfree.chart.plot.CategoryPlot categoryPlot18 = new org.jfree.chart.plot.CategoryPlot();
    boolean b19 = categoryPlot18.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge21 = categoryPlot18.getDomainAxisEdge(8);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment22 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment23 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement26 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment22, verticalAlignment23, 11.0d, 0.2d);
    org.jfree.chart.util.VerticalAlignment verticalAlignment27 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement30 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment22, verticalAlignment27, (-1.0d), Double.NaN);
    org.jfree.chart.util.VerticalAlignment verticalAlignment31 = org.jfree.chart.title.Title.DEFAULT_VERTICAL_ALIGNMENT;
    org.jfree.chart.util.RectangleInsets rectangleInsets32 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent33 = new org.jfree.data.general.SeriesChangeEvent((java.lang.Object)rectangleInsets32);
    org.jfree.chart.title.TextTitle textTitle34 = new org.jfree.chart.title.TextTitle("March", font3, paint17, rectangleEdge21, horizontalAlignment22, verticalAlignment31, rectangleInsets32);
    org.jfree.chart.util.UnitType unitType35 = rectangleInsets32.getUnitType();
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer37 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    java.lang.Object obj38 = xYBarRenderer37.clone();
    xYBarRenderer37.setShadowVisible(false);
    boolean b41 = unitType35.equals((java.lang.Object)false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(verticalAlignment31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(unitType35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == false);

  }

  @Test
  public void test234() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test234"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
    numberAxis15.centerRange(100.0d);
    combinedDomainXYPlot9.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis15);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier19 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot9.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    org.jfree.data.category.CategoryDataset categoryDataset22 = null;
    org.jfree.chart.renderer.category.CategoryItemRenderer categoryItemRenderer23 = categoryPlot0.getRendererForDataset(categoryDataset22);
    java.awt.Color color30 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke31 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color32 = java.awt.Color.orange;
    java.awt.Stroke stroke33 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker35 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color30, stroke31, (java.awt.Paint)color32, stroke33, 0.0f);
    java.awt.Paint paint36 = intervalMarker35.getPaint();
    org.jfree.chart.util.Layer layer37 = null;
    boolean b38 = categoryPlot0.removeDomainMarker(8, (org.jfree.chart.plot.Marker)intervalMarker35, layer37);
    categoryPlot0.setDrawSharedDomainAxis(false);
    org.jfree.chart.LegendItemCollection legendItemCollection41 = categoryPlot0.getLegendItems();
    categoryPlot0.setRangePannable(false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryItemRenderer23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection41);

  }

  @Test
  public void test235() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test235"); }


    org.jfree.chart.axis.NumberAxis3D numberAxis3D4 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Paint paint5 = org.jfree.chart.axis.Axis.DEFAULT_AXIS_LINE_PAINT;
    numberAxis3D4.setLabelPaint(paint5);
    org.jfree.chart.axis.NumberTickUnit numberTickUnit7 = org.jfree.chart.axis.NumberAxis.DEFAULT_TICK_UNIT;
    numberAxis3D4.setTickUnit(numberTickUnit7, false, true);
    numberAxis3D4.resizeRange(6.0d, 1.0d);
    java.awt.Color color14 = java.awt.Color.GRAY;
    numberAxis3D4.setLabelPaint((java.awt.Paint)color14);
    org.jfree.chart.block.BlockBorder blockBorder16 = new org.jfree.chart.block.BlockBorder(0.12d, 0.6d, 0.6d, 10.0d, (java.awt.Paint)color14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberTickUnit7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color14);

  }

  @Test
  public void test236() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test236"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    piePlot3D2.setStartAngle(Double.NaN);
    org.jfree.data.general.DefaultPieDataset defaultPieDataset5 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj6 = defaultPieDataset5.clone();
    double d7 = org.jfree.data.general.DatasetUtilities.calculatePieDatasetTotal((org.jfree.data.general.PieDataset)defaultPieDataset5);
    piePlot3D2.setDataset((org.jfree.data.general.PieDataset)defaultPieDataset5);
    boolean b9 = piePlot3D2.getIgnoreNullValues();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);

  }

  @Test
  public void test237() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test237"); }


    java.awt.Shape shape0 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.awt.Shape shape3 = org.jfree.chart.util.ShapeUtilities.createTranslatedShape(shape0, 10.0d, 4.5d);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test238() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test238"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    org.jfree.chart.axis.NumberAxis numberAxis31 = new org.jfree.chart.axis.NumberAxis();
    numberAxis31.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer35 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator36 = xYAreaRenderer35.getLegendItemToolTipGenerator();
    java.awt.Shape shape37 = xYAreaRenderer35.getBaseShape();
    numberAxis31.setUpArrow(shape37);
    numberAxis31.pan((-1.0d));
    java.awt.Paint paint41 = numberAxis31.getAxisLinePaint();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer43 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator44 = xYAreaRenderer43.getLegendItemToolTipGenerator();
    java.awt.Shape shape45 = xYAreaRenderer43.getBaseShape();
    java.awt.Shape shape48 = org.jfree.chart.util.ShapeUtilities.createTranslatedShape(shape45, 6.0d, 0.0d);
    numberAxis31.setRightArrow(shape48);
    org.jfree.chart.entity.AxisEntity axisEntity52 = new org.jfree.chart.entity.AxisEntity(shape7, (org.jfree.chart.axis.Axis)numberAxis31, "SeriesRenderingOrder.FORWARD", "hi!");
    org.jfree.chart.axis.Axis axis53 = axisEntity52.getAxis();
    org.jfree.chart.axis.Axis axis54 = axisEntity52.getAxis();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axis53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axis54);

  }

  @Test
  public void test239() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test239"); }


    org.jfree.data.category.CategoryDataset categoryDataset0 = null;
    org.jfree.chart.axis.CategoryAxis categoryAxis1 = new org.jfree.chart.axis.CategoryAxis();
    categoryAxis1.setVisible(false);
    org.jfree.chart.util.RectangleInsets rectangleInsets4 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d5 = rectangleInsets4.getLeft();
    double d7 = rectangleInsets4.calculateLeftOutset(1.0d);
    categoryAxis1.setLabelInsets(rectangleInsets4, true);
    float f10 = categoryAxis1.getTickMarkOutsideLength();
    org.jfree.chart.axis.CategoryAnchor categoryAnchor11 = null;
    java.awt.geom.Rectangle2D rectangle2D14 = null;
    org.jfree.data.general.WaferMapDataset waferMapDataset15 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot16 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset15);
    org.jfree.chart.JFreeChart jFreeChart17 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent18 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot16, jFreeChart17);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment19 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment20 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement23 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment19, verticalAlignment20, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement24 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle25 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot16, (org.jfree.chart.block.Arrangement)flowArrangement23, (org.jfree.chart.block.Arrangement)borderArrangement24);
    org.jfree.chart.plot.CategoryPlot categoryPlot26 = new org.jfree.chart.plot.CategoryPlot();
    boolean b27 = categoryPlot26.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge29 = categoryPlot26.getDomainAxisEdge(8);
    legendTitle25.setPosition(rectangleEdge29);
    double d31 = categoryAxis1.getCategoryJava2DCoordinate(categoryAnchor11, 4, 255, rectangle2D14, rectangleEdge29);
    org.jfree.chart.axis.NumberAxis3D numberAxis3D32 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Paint paint33 = org.jfree.chart.axis.Axis.DEFAULT_AXIS_LINE_PAINT;
    numberAxis3D32.setLabelPaint(paint33);
    org.jfree.chart.axis.NumberTickUnit numberTickUnit35 = org.jfree.chart.axis.NumberAxis.DEFAULT_TICK_UNIT;
    numberAxis3D32.setTickUnit(numberTickUnit35, false, true);
    numberAxis3D32.resizeRange(6.0d, 1.0d);
    org.jfree.chart.renderer.category.BarRenderer barRenderer42 = new org.jfree.chart.renderer.category.BarRenderer();
    double d43 = barRenderer42.getShadowXOffset();
    org.jfree.chart.plot.CategoryPlot categoryPlot44 = new org.jfree.chart.plot.CategoryPlot(categoryDataset0, categoryAxis1, (org.jfree.chart.axis.ValueAxis)numberAxis3D32, (org.jfree.chart.renderer.category.CategoryItemRenderer)barRenderer42);
    java.awt.Paint paint45 = barRenderer42.getBaseItemLabelPaint();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer47 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator48 = xYAreaRenderer47.getLegendItemToolTipGenerator();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition49 = xYAreaRenderer47.getBasePositiveItemLabelPosition();
    barRenderer42.setPositiveItemLabelPositionFallback(itemLabelPosition49);
    org.jfree.chart.labels.ItemLabelAnchor itemLabelAnchor51 = itemLabelPosition49.getItemLabelAnchor();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f10 == 2.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d31 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberTickUnit35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d43 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelAnchor51);

  }

  @Test
  public void test240() {}
// Defects4J: flaky method
//   @Test
//   public void test240() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test240"); }
// 
// 
//     org.jfree.chart.axis.ValueAxis valueAxis0 = null;
//     org.jfree.chart.plot.CombinedRangeXYPlot combinedRangeXYPlot1 = new org.jfree.chart.plot.CombinedRangeXYPlot(valueAxis0);
//     org.jfree.chart.axis.ValueAxis valueAxis2 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot3 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis2);
//     org.jfree.chart.plot.Plot plot4 = combinedDomainXYPlot3.getRootPlot();
//     java.awt.Color color10 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
//     java.awt.Stroke stroke11 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
//     java.awt.Color color12 = java.awt.Color.orange;
//     java.awt.Stroke stroke13 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
//     org.jfree.chart.plot.IntervalMarker intervalMarker15 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color10, stroke11, (java.awt.Paint)color12, stroke13, 0.0f);
//     org.jfree.chart.util.Layer layer16 = null;
//     boolean b17 = combinedDomainXYPlot3.removeRangeMarker((org.jfree.chart.plot.Marker)intervalMarker15, layer16);
//     org.jfree.chart.entity.EntityCollection entityCollection19 = null;
//     org.jfree.chart.ChartRenderingInfo chartRenderingInfo20 = new org.jfree.chart.ChartRenderingInfo(entityCollection19);
//     org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo21 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo20);
//     java.awt.geom.Rectangle2D rectangle2D22 = null;
//     plotRenderingInfo21.setPlotArea(rectangle2D22);
//     java.awt.geom.Point2D point2D24 = null;
//     combinedDomainXYPlot3.zoomDomainAxes(11.0d, plotRenderingInfo21, point2D24, true);
//     combinedRangeXYPlot1.add((org.jfree.chart.plot.XYPlot)combinedDomainXYPlot3);
//     org.jfree.data.time.DateRange dateRange31 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d32 = dateRange31.getLength();
//     long long33 = dateRange31.getLowerMillis();
//     double d34 = dateRange31.getLength();
//     java.lang.String str35 = dateRange31.toString();
//     java.util.Date date36 = dateRange31.getUpperDate();
//     java.util.TimeZone timeZone37 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year38 = new org.jfree.data.time.Year(date36, timeZone37);
//     org.jfree.chart.axis.DateAxis dateAxis39 = new org.jfree.chart.axis.DateAxis("SerialDate.weekInMonthToString(): invalid code.", timeZone37);
//     org.jfree.data.Range range40 = combinedRangeXYPlot1.getDataRange((org.jfree.chart.axis.ValueAxis)dateAxis39);
//     org.jfree.chart.labels.StandardPieToolTipGenerator standardPieToolTipGenerator41 = new org.jfree.chart.labels.StandardPieToolTipGenerator();
//     org.jfree.data.general.PieDataset pieDataset42 = null;
//     java.lang.String str44 = standardPieToolTipGenerator41.generateToolTip(pieDataset42, (java.lang.Comparable)"DateTickMarkPosition.END");
//     boolean b45 = dateAxis39.equals((java.lang.Object)"DateTickMarkPosition.END");
//     java.text.DateFormat dateFormat46 = dateAxis39.getDateFormatOverride();
//     dateAxis39.setVisible(true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(plot4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b17 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d32 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long33 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d34 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str35 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str35.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date36);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone37);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(range40);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(str44);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b45 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(dateFormat46);
// 
//   }

  @Test
  public void test241() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test241"); }


    org.jfree.chart.renderer.category.BarRenderer barRenderer0 = new org.jfree.chart.renderer.category.BarRenderer();
    double d1 = barRenderer0.getShadowXOffset();
    org.jfree.chart.labels.CategoryToolTipGenerator categoryToolTipGenerator5 = barRenderer0.getToolTipGenerator((-25560), 2, false);
    org.jfree.chart.labels.CategoryItemLabelGenerator categoryItemLabelGenerator7 = null;
    barRenderer0.setSeriesItemLabelGenerator(40, categoryItemLabelGenerator7);
    double d9 = barRenderer0.getUpperClip();
    java.awt.Shape shape16 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(2.0f, 0.0f);
    org.jfree.chart.block.LabelBlock labelBlock19 = new org.jfree.chart.block.LabelBlock("TextAnchor.CENTER");
    java.awt.Paint paint20 = labelBlock19.getPaint();
    labelBlock19.setURLText("");
    org.jfree.chart.StandardChartTheme standardChartTheme24 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.renderer.category.BarPainter barPainter25 = standardChartTheme24.getBarPainter();
    java.awt.Font font26 = standardChartTheme24.getLargeFont();
    java.awt.Paint paint27 = standardChartTheme24.getDomainGridlinePaint();
    labelBlock19.setPaint(paint27);
    org.jfree.chart.LegendItem legendItem29 = new org.jfree.chart.LegendItem("index.html", paint27);
    org.jfree.chart.plot.CategoryPlot categoryPlot30 = new org.jfree.chart.plot.CategoryPlot();
    boolean b31 = categoryPlot30.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge33 = categoryPlot30.getDomainAxisEdge(8);
    java.awt.Stroke stroke34 = categoryPlot30.getDomainGridlineStroke();
    java.awt.Shape shape42 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color44 = java.awt.Color.green;
    java.awt.Color color46 = java.awt.Color.green;
    java.awt.Color color52 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke53 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color54 = java.awt.Color.orange;
    java.awt.Stroke stroke55 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker57 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color52, stroke53, (java.awt.Paint)color54, stroke55, 0.0f);
    java.awt.Shape shape61 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke62 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color63 = java.awt.Color.green;
    java.lang.String str64 = org.jfree.chart.util.PaintUtilities.colorToString(color63);
    org.jfree.chart.LegendItem legendItem65 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape42, true, (java.awt.Paint)color44, false, (java.awt.Paint)color46, stroke53, true, shape61, stroke62, (java.awt.Paint)color63);
    java.awt.Color color66 = color44.brighter();
    org.jfree.chart.LegendItem legendItem67 = new org.jfree.chart.LegendItem("DateTickMarkPosition.END", "DateTickUnit[DateTickUnitType.MONTH, 2016]", "SeriesRenderingOrder.FORWARD", "{0}", shape16, paint27, stroke34, (java.awt.Paint)color66);
    barRenderer0.setBaseOutlinePaint((java.awt.Paint)color66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryToolTipGenerator5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d9 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(barPainter25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str64 + "' != '" + "green"+ "'", str64.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color66);

  }

  @Test
  public void test242() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test242"); }


    double d0 = org.jfree.chart.renderer.category.BarRenderer3D.DEFAULT_Y_OFFSET;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d0 == 8.0d);

  }

  @Test
  public void test243() {}
// Defects4J: flaky method
//   @Test
//   public void test243() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test243"); }
// 
// 
//     org.jfree.chart.plot.PlotOrientation plotOrientation0 = org.jfree.chart.plot.PlotOrientation.HORIZONTAL;
//     boolean b2 = org.jfree.chart.util.ObjectUtilities.equal((java.lang.Object)plotOrientation0, (java.lang.Object)'#');
//     org.jfree.chart.axis.ValueAxis valueAxis3 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot4 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis3);
//     java.util.List list5 = combinedDomainXYPlot4.getAnnotations();
//     combinedDomainXYPlot4.setRangeGridlinesVisible(true);
//     org.jfree.chart.axis.ValueAxis valueAxis9 = null;
//     combinedDomainXYPlot4.setRangeAxis(100, valueAxis9, false);
//     org.jfree.chart.axis.NumberAxis numberAxis12 = new org.jfree.chart.axis.NumberAxis();
//     numberAxis12.centerRange(100.0d);
//     combinedDomainXYPlot4.setRangeAxis((org.jfree.chart.axis.ValueAxis)numberAxis12);
//     boolean b16 = numberAxis12.isNegativeArrowVisible();
//     org.jfree.data.time.DateRange dateRange19 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     org.jfree.data.time.DateRange dateRange22 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     boolean b23 = dateRange19.intersects((org.jfree.data.Range)dateRange22);
//     java.lang.String str24 = dateRange19.toString();
//     numberAxis12.setDefaultAutoRange((org.jfree.data.Range)dateRange19);
//     numberAxis12.setNegativeArrowVisible(true);
//     org.jfree.chart.plot.CategoryPlot categoryPlot28 = new org.jfree.chart.plot.CategoryPlot();
//     boolean b29 = categoryPlot28.isRangeZoomable();
//     org.jfree.chart.util.RectangleEdge rectangleEdge31 = categoryPlot28.getDomainAxisEdge(8);
//     java.awt.Font font33 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
//     org.jfree.data.general.WaferMapDataset waferMapDataset34 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot35 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset34);
//     org.jfree.chart.axis.ValueAxis valueAxis36 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot37 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis36);
//     java.util.List list38 = combinedDomainXYPlot37.getAnnotations();
//     waferMapPlot35.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot37);
//     org.jfree.chart.JFreeChart jFreeChart41 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font33, (org.jfree.chart.plot.Plot)combinedDomainXYPlot37, true);
//     org.jfree.chart.axis.NumberAxis numberAxis43 = new org.jfree.chart.axis.NumberAxis();
//     numberAxis43.centerRange(100.0d);
//     combinedDomainXYPlot37.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis43);
//     org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier47 = new org.jfree.chart.plot.DefaultDrawingSupplier();
//     combinedDomainXYPlot37.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier47);
//     categoryPlot28.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier47);
//     categoryPlot28.clearRangeMarkers(100);
//     numberAxis12.removeChangeListener((org.jfree.chart.event.AxisChangeListener)categoryPlot28);
//     categoryPlot28.clearRangeMarkers(0);
//     boolean b55 = plotOrientation0.equals((java.lang.Object)0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(plotOrientation0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b2 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b16 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b23 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str24 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str24.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b29 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleEdge31);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(font33);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list38);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b55 == false);
// 
//   }

  @Test
  public void test244() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test244"); }


    java.awt.Color color5 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke6 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color7 = java.awt.Color.orange;
    java.awt.Stroke stroke8 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker10 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color5, stroke6, (java.awt.Paint)color7, stroke8, 0.0f);
    java.awt.Paint paint11 = intervalMarker10.getOutlinePaint();
    intervalMarker10.setStartValue(0.6d);
    intervalMarker10.setEndValue((-1.0d));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint11);

  }

  @Test
  public void test245() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test245"); }


    org.jfree.chart.text.TextBlock textBlock0 = new org.jfree.chart.text.TextBlock();
    org.jfree.chart.text.TextLine textLine2 = new org.jfree.chart.text.TextLine("March");
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment18 = new org.jfree.chart.text.TextFragment("hi!", font5, (java.awt.Paint)color17);
    textLine2.addFragment(textFragment18);
    textBlock0.addLine(textLine2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment21 = textBlock0.getLineAlignment();
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment22 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment23 = org.jfree.chart.util.VerticalAlignment.CENTER;
    org.jfree.chart.block.FlowArrangement flowArrangement26 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment22, verticalAlignment23, 1.0d, 8.0d);
    boolean b27 = textBlock0.equals((java.lang.Object)verticalAlignment23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(verticalAlignment23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);

  }

  @Test
  public void test246() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test246"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.axis.CategoryAxis categoryAxis2 = categoryPlot0.getDomainAxis();
    org.jfree.chart.axis.CategoryAxis categoryAxis3 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset4 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot5 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset4);
    org.jfree.chart.axis.ValueAxis valueAxis6 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot7 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis6);
    java.util.List list8 = combinedDomainXYPlot7.getAnnotations();
    waferMapPlot5.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot7);
    int i10 = combinedDomainXYPlot7.getSeriesCount();
    categoryAxis3.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot7);
    boolean b13 = categoryAxis3.equals((java.lang.Object)(short)1);
    java.awt.Color color19 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke20 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color21 = java.awt.Color.orange;
    java.awt.Stroke stroke22 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker24 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color19, stroke20, (java.awt.Paint)color21, stroke22, 0.0f);
    java.awt.Color color25 = color21.brighter();
    categoryAxis3.setTickLabelPaint((java.awt.Paint)color21);
    org.jfree.chart.axis.CategoryAxis[] categoryAxis_array27 = new org.jfree.chart.axis.CategoryAxis[] { categoryAxis3 };
    categoryPlot0.setDomainAxes(categoryAxis_array27);
    categoryPlot0.clearRangeMarkers(255);
    categoryPlot0.clearDomainMarkers(2958465);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryAxis2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i10 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(categoryAxis_array27);

  }

  @Test
  public void test247() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test247"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    boolean b3 = xYBarRenderer1.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator5 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer1.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator5, true);
    boolean b8 = xYBarRenderer1.getUseYInterval();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition9 = xYBarRenderer1.getPositiveItemLabelPositionFallback();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(itemLabelPosition9);

  }

  @Test
  public void test248() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test248"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    java.util.List list2 = combinedDomainXYPlot1.getAnnotations();
    combinedDomainXYPlot1.setRangeGridlinesVisible(true);
    org.jfree.chart.util.RectangleEdge rectangleEdge6 = combinedDomainXYPlot1.getRangeAxisEdge(4);
    org.jfree.data.xy.XYDataset xYDataset8 = combinedDomainXYPlot1.getDataset(64);
    java.awt.Font font14 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset15 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot16 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset15);
    org.jfree.chart.axis.ValueAxis valueAxis17 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot18 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis17);
    java.util.List list19 = combinedDomainXYPlot18.getAnnotations();
    waferMapPlot16.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot18);
    org.jfree.chart.JFreeChart jFreeChart22 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font14, (org.jfree.chart.plot.Plot)combinedDomainXYPlot18, true);
    java.awt.Color color26 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment27 = new org.jfree.chart.text.TextFragment("hi!", font14, (java.awt.Paint)color26);
    java.awt.Paint paint28 = org.jfree.chart.plot.PiePlot.DEFAULT_LABEL_OUTLINE_PAINT;
    org.jfree.chart.plot.CategoryPlot categoryPlot29 = new org.jfree.chart.plot.CategoryPlot();
    boolean b30 = categoryPlot29.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge32 = categoryPlot29.getDomainAxisEdge(8);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment33 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment34 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement37 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment33, verticalAlignment34, 11.0d, 0.2d);
    org.jfree.chart.util.VerticalAlignment verticalAlignment38 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement41 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment33, verticalAlignment38, (-1.0d), Double.NaN);
    org.jfree.chart.util.VerticalAlignment verticalAlignment42 = org.jfree.chart.title.Title.DEFAULT_VERTICAL_ALIGNMENT;
    org.jfree.chart.util.RectangleInsets rectangleInsets43 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent44 = new org.jfree.data.general.SeriesChangeEvent((java.lang.Object)rectangleInsets43);
    org.jfree.chart.title.TextTitle textTitle45 = new org.jfree.chart.title.TextTitle("March", font14, paint28, rectangleEdge32, horizontalAlignment33, verticalAlignment42, rectangleInsets43);
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D47 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke48 = categoryAxis3D47.getTickMarkStroke();
    org.jfree.chart.plot.ValueMarker valueMarker49 = new org.jfree.chart.plot.ValueMarker(7.0d, paint28, stroke48);
    // The following exception was thrown during execution in test generation
    try {
      combinedDomainXYPlot1.setQuadrantPaint((-1), paint28);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYDataset8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(verticalAlignment42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke48);

  }

  @Test
  public void test249() {}
// Defects4J: flaky method
//   @Test
//   public void test249() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test249"); }
// 
// 
//     org.jfree.data.time.Month month0 = new org.jfree.data.time.Month();
//     int i1 = month0.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem3 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month0, (java.lang.Number)8);
//     java.util.Calendar calendar4 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       month0.peg(calendar4);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i1 == 2);
// 
//   }

  @Test
  public void test250() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test250"); }


    org.jfree.chart.axis.SegmentedTimeline segmentedTimeline3 = new org.jfree.chart.axis.SegmentedTimeline(1L, 133, 7);
    long long5 = segmentedTimeline3.toMillisecond(1969L);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long5 == 2067L);

  }

  @Test
  public void test251() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test251"); }


    org.jfree.data.xy.XYSeries xYSeries3 = new org.jfree.data.xy.XYSeries((java.lang.Comparable)10.0d, false, false);
    xYSeries3.add((-1.0d), (java.lang.Number)(byte)(-1));
    double d7 = xYSeries3.getMaxX();
    java.lang.String str8 = xYSeries3.getDescription();
    org.jfree.data.xy.XYDataItem xYDataItem11 = new org.jfree.data.xy.XYDataItem(4.5d, 0.05d);
    xYSeries3.add(xYDataItem11);
    boolean b13 = xYDataItem11.isSelected();
    java.lang.Number number14 = null;
    xYDataItem11.setY(number14);
    java.lang.Number number16 = xYDataItem11.getY();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == (-1.0d));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(number16);

  }

  @Test
  public void test252() {}
// Defects4J: flaky method
//   @Test
//   public void test252() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test252"); }
// 
// 
//     org.jfree.data.time.Month month1 = new org.jfree.data.time.Month();
//     int i2 = month1.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem4 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month1, (java.lang.Number)8);
//     long long5 = month1.getFirstMillisecond();
//     org.jfree.data.time.Month month6 = new org.jfree.data.time.Month();
//     int i7 = month6.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis8 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month1, (org.jfree.data.time.RegularTimePeriod)month6);
//     periodAxis8.setUpperMargin(10.0d);
//     org.jfree.data.time.Month month11 = new org.jfree.data.time.Month();
//     int i12 = month11.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem14 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month11, (java.lang.Number)8);
//     periodAxis8.setLast((org.jfree.data.time.RegularTimePeriod)month11);
//     org.jfree.chart.axis.ValueAxis valueAxis16 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot17 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis16);
//     java.util.List list18 = combinedDomainXYPlot17.getAnnotations();
//     combinedDomainXYPlot17.setRangeGridlinesVisible(true);
//     org.jfree.chart.axis.ValueAxis valueAxis22 = null;
//     combinedDomainXYPlot17.setRangeAxis(100, valueAxis22, false);
//     org.jfree.chart.axis.NumberAxis numberAxis25 = new org.jfree.chart.axis.NumberAxis();
//     numberAxis25.centerRange(100.0d);
//     combinedDomainXYPlot17.setRangeAxis((org.jfree.chart.axis.ValueAxis)numberAxis25);
//     boolean b29 = numberAxis25.isNegativeArrowVisible();
//     org.jfree.data.time.DateRange dateRange32 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     org.jfree.data.time.DateRange dateRange35 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     boolean b36 = dateRange32.intersects((org.jfree.data.Range)dateRange35);
//     java.lang.String str37 = dateRange32.toString();
//     numberAxis25.setDefaultAutoRange((org.jfree.data.Range)dateRange32);
//     numberAxis25.setNegativeArrowVisible(true);
//     org.jfree.chart.plot.CategoryPlot categoryPlot41 = new org.jfree.chart.plot.CategoryPlot();
//     boolean b42 = categoryPlot41.isRangeZoomable();
//     org.jfree.chart.util.RectangleEdge rectangleEdge44 = categoryPlot41.getDomainAxisEdge(8);
//     java.awt.Font font46 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
//     org.jfree.data.general.WaferMapDataset waferMapDataset47 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot48 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset47);
//     org.jfree.chart.axis.ValueAxis valueAxis49 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot50 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis49);
//     java.util.List list51 = combinedDomainXYPlot50.getAnnotations();
//     waferMapPlot48.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot50);
//     org.jfree.chart.JFreeChart jFreeChart54 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font46, (org.jfree.chart.plot.Plot)combinedDomainXYPlot50, true);
//     org.jfree.chart.axis.NumberAxis numberAxis56 = new org.jfree.chart.axis.NumberAxis();
//     numberAxis56.centerRange(100.0d);
//     combinedDomainXYPlot50.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis56);
//     org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier60 = new org.jfree.chart.plot.DefaultDrawingSupplier();
//     combinedDomainXYPlot50.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier60);
//     categoryPlot41.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier60);
//     categoryPlot41.clearRangeMarkers(100);
//     numberAxis25.removeChangeListener((org.jfree.chart.event.AxisChangeListener)categoryPlot41);
//     org.jfree.data.time.SpreadsheetDate spreadsheetDate68 = new org.jfree.data.time.SpreadsheetDate(8);
//     org.jfree.data.time.SpreadsheetDate spreadsheetDate70 = new org.jfree.data.time.SpreadsheetDate(8);
//     boolean b71 = spreadsheetDate68.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate70);
//     org.jfree.data.time.SerialDate serialDate72 = org.jfree.data.time.SerialDate.getPreviousDayOfWeek(5, (org.jfree.data.time.SerialDate)spreadsheetDate68);
//     int i73 = spreadsheetDate68.getYYYY();
//     org.jfree.data.time.SerialDate serialDate75 = spreadsheetDate68.getFollowingDayOfWeek(6);
//     categoryPlot41.setDomainCrosshairRowKey((java.lang.Comparable)spreadsheetDate68, false);
//     org.jfree.chart.entity.EntityCollection entityCollection79 = null;
//     org.jfree.chart.ChartRenderingInfo chartRenderingInfo80 = new org.jfree.chart.ChartRenderingInfo(entityCollection79);
//     org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo81 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo80);
//     int i82 = plotRenderingInfo81.getSubplotCount();
//     org.jfree.chart.renderer.xy.XYItemRendererState xYItemRendererState83 = new org.jfree.chart.renderer.xy.XYItemRendererState(plotRenderingInfo81);
//     java.awt.geom.Rectangle2D rectangle2D84 = null;
//     org.jfree.chart.util.RectangleAnchor rectangleAnchor85 = null;
//     java.awt.geom.Point2D point2D86 = org.jfree.chart.util.RectangleAnchor.coordinates(rectangle2D84, rectangleAnchor85);
//     categoryPlot41.zoomDomainAxes(300000.0d, plotRenderingInfo81, point2D86);
//     java.awt.Paint paint88 = categoryPlot41.getRangeZeroBaselinePaint();
//     periodAxis8.setMinorTickMarkPaint(paint88);
//     periodAxis8.setMinorTickMarkOutsideLength(100.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i2 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i7 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i12 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list18);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b29 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b36 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str37 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str37.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b42 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleEdge44);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(font46);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list51);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b71 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(serialDate72);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i73 == 1900);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(serialDate75);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i82 == 0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(point2D86);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(paint88);
// 
//   }

  @Test
  public void test253() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test253"); }


    org.jfree.chart.util.GradientPaintTransformType gradientPaintTransformType0 = org.jfree.chart.util.GradientPaintTransformType.HORIZONTAL;
    java.lang.String str1 = gradientPaintTransformType0.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(gradientPaintTransformType0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "GradientPaintTransformType.HORIZONTAL"+ "'", str1.equals("GradientPaintTransformType.HORIZONTAL"));

  }

  @Test
  public void test254() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test254"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedRangeXYPlot combinedRangeXYPlot1 = new org.jfree.chart.plot.CombinedRangeXYPlot(valueAxis0);
    org.jfree.chart.axis.DateTickUnitType dateTickUnitType2 = org.jfree.chart.axis.DateTickUnitType.MINUTE;
    org.jfree.chart.axis.DateTickUnitType dateTickUnitType4 = org.jfree.chart.axis.DateTickUnitType.MONTH;
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer7 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d8 = xYBarRenderer7.getMargin();
    boolean b9 = xYBarRenderer7.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator11 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer7.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator11, true);
    java.lang.Object obj14 = standardXYToolTipGenerator11.clone();
    java.text.DateFormat dateFormat15 = standardXYToolTipGenerator11.getXDateFormat();
    org.jfree.chart.axis.DateTickUnit dateTickUnit16 = new org.jfree.chart.axis.DateTickUnit(dateTickUnitType2, 5, dateTickUnitType4, 4, dateFormat15);
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer17 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition19 = xYStepRenderer17.getSeriesPositiveItemLabelPosition(3);
    org.jfree.chart.axis.CategoryAxis categoryAxis21 = new org.jfree.chart.axis.CategoryAxis("");
    boolean b22 = xYStepRenderer17.equals((java.lang.Object)"");
    org.jfree.chart.plot.XYPlot xYPlot23 = xYStepRenderer17.getPlot();
    boolean b24 = xYStepRenderer17.getDrawSeriesLineAsPath();
    boolean b25 = dateTickUnit16.equals((java.lang.Object)xYStepRenderer17);
    combinedRangeXYPlot1.setRenderer((org.jfree.chart.renderer.xy.XYItemRenderer)xYStepRenderer17);
    org.jfree.chart.event.PlotChangeEvent plotChangeEvent27 = null;
    combinedRangeXYPlot1.plotChanged(plotChangeEvent27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateTickUnitType2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateTickUnitType4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateFormat15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYPlot23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);

  }

  @Test
  public void test255() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test255"); }


    boolean b1 = org.jfree.data.time.SerialDate.isValidWeekdayCode(15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);

  }

  @Test
  public void test256() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test256"); }


    org.jfree.data.Range range1 = null;
    org.jfree.chart.block.LengthConstraintType lengthConstraintType2 = org.jfree.chart.block.LengthConstraintType.NONE;
    org.jfree.data.time.DateRange dateRange6 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange9 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b10 = dateRange6.intersects((org.jfree.data.Range)dateRange9);
    org.jfree.data.Range range12 = org.jfree.data.Range.expandToInclude((org.jfree.data.Range)dateRange6, 1.0d);
    org.jfree.chart.block.LengthConstraintType lengthConstraintType13 = org.jfree.chart.block.LengthConstraintType.NONE;
    org.jfree.chart.block.RectangleConstraint rectangleConstraint14 = new org.jfree.chart.block.RectangleConstraint(2.0d, range1, lengthConstraintType2, 0.0d, range12, lengthConstraintType13);
    org.jfree.data.general.DefaultPieDataset defaultPieDataset15 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj16 = defaultPieDataset15.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D17 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset15);
    piePlot3D17.setIgnoreZeroValues(true);
    boolean b20 = lengthConstraintType2.equals((java.lang.Object)piePlot3D17);
    double d21 = piePlot3D17.getLabelGap();
    java.lang.Object obj22 = piePlot3D17.clone();
    org.jfree.chart.util.RectangleInsets rectangleInsets23 = piePlot3D17.getLabelPadding();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d21 == 0.025d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets23);

  }

  @Test
  public void test257() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test257"); }


    org.jfree.chart.renderer.category.BarRenderer3D barRenderer3D2 = new org.jfree.chart.renderer.category.BarRenderer3D(1.0E-8d, 1.0d);
    barRenderer3D2.clearSeriesStrokes(true);
    boolean b5 = barRenderer3D2.getShadowsVisible();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);

  }

  @Test
  public void test258() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test258"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    piePlot3D2.setLabelLinksVisible(false);
    java.lang.Object obj6 = piePlot3D2.clone();
    org.jfree.chart.axis.CategoryAxis categoryAxis7 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset8 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot9 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset8);
    org.jfree.chart.axis.ValueAxis valueAxis10 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot11 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis10);
    java.util.List list12 = combinedDomainXYPlot11.getAnnotations();
    waferMapPlot9.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot11);
    int i14 = combinedDomainXYPlot11.getSeriesCount();
    categoryAxis7.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot11);
    boolean b17 = categoryAxis7.equals((java.lang.Object)(short)1);
    java.awt.Paint paint18 = categoryAxis7.getTickMarkPaint();
    java.lang.Object obj19 = org.jfree.chart.util.ObjectUtilities.clone((java.lang.Object)categoryAxis7);
    categoryAxis7.setMaximumCategoryLabelLines(1);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate23 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate25 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b26 = spreadsheetDate23.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate25);
    java.util.Date date27 = spreadsheetDate25.toDate();
    java.awt.Paint paint28 = categoryAxis7.getTickLabelPaint((java.lang.Comparable)spreadsheetDate25);
    piePlot3D2.setLabelOutlinePaint(paint28);
    org.jfree.chart.labels.StandardPieSectionLabelGenerator standardPieSectionLabelGenerator31 = new org.jfree.chart.labels.StandardPieSectionLabelGenerator("ERROR : Relative To String");
    piePlot3D2.setLegendLabelGenerator((org.jfree.chart.labels.PieSectionLabelGenerator)standardPieSectionLabelGenerator31);
    java.lang.Object obj33 = null;
    boolean b34 = standardPieSectionLabelGenerator31.equals(obj33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i14 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(date27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b34 == false);

  }

  @Test
  public void test259() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test259"); }


    java.awt.Shape shape1 = org.jfree.chart.util.ShapeUtilities.createDiamond(0.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape1);

  }

  @Test
  public void test260() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test260"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.axis.ValueAxis valueAxis2 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot3 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis2);
    java.util.List list4 = combinedDomainXYPlot3.getAnnotations();
    waferMapPlot1.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot3);
    boolean b6 = combinedDomainXYPlot3.isNotify();
    org.jfree.chart.util.Layer layer7 = null;
    java.util.Collection collection8 = combinedDomainXYPlot3.getDomainMarkers(layer7);
    org.jfree.chart.LegendItemCollection legendItemCollection9 = combinedDomainXYPlot3.getLegendItems();
    org.jfree.chart.util.RectangleEdge rectangleEdge11 = combinedDomainXYPlot3.getRangeAxisEdge(7);
    boolean b12 = combinedDomainXYPlot3.isDomainGridlinesVisible();
    combinedDomainXYPlot3.setRangeGridlinesVisible(true);
    boolean b15 = combinedDomainXYPlot3.isDomainGridlinesVisible();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == true);

  }

  @Test
  public void test261() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test261"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge3 = categoryPlot0.getDomainAxisEdge(8);
    java.awt.Font font5 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset6 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot7 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset6);
    org.jfree.chart.axis.ValueAxis valueAxis8 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot9 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis8);
    java.util.List list10 = combinedDomainXYPlot9.getAnnotations();
    waferMapPlot7.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot9);
    org.jfree.chart.JFreeChart jFreeChart13 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font5, (org.jfree.chart.plot.Plot)combinedDomainXYPlot9, true);
    org.jfree.chart.axis.NumberAxis numberAxis15 = new org.jfree.chart.axis.NumberAxis();
    numberAxis15.centerRange(100.0d);
    combinedDomainXYPlot9.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis15);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier19 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot9.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    categoryPlot0.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier19);
    org.jfree.data.category.CategoryDataset categoryDataset22 = null;
    org.jfree.chart.renderer.category.CategoryItemRenderer categoryItemRenderer23 = categoryPlot0.getRendererForDataset(categoryDataset22);
    java.awt.Color color30 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke31 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color32 = java.awt.Color.orange;
    java.awt.Stroke stroke33 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker35 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color30, stroke31, (java.awt.Paint)color32, stroke33, 0.0f);
    java.awt.Paint paint36 = intervalMarker35.getPaint();
    org.jfree.chart.util.Layer layer37 = null;
    boolean b38 = categoryPlot0.removeDomainMarker(8, (org.jfree.chart.plot.Marker)intervalMarker35, layer37);
    categoryPlot0.setDrawSharedDomainAxis(false);
    org.jfree.chart.axis.AxisLocation axisLocation41 = categoryPlot0.getDomainAxisLocation();
    java.awt.Stroke stroke42 = categoryPlot0.getRangeMinorGridlineStroke();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryItemRenderer23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke42);

  }

  @Test
  public void test262() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test262"); }


    org.jfree.chart.axis.DateTickUnitType dateTickUnitType0 = org.jfree.chart.axis.DateTickUnitType.MINUTE;
    org.jfree.chart.axis.DateTickUnitType dateTickUnitType2 = org.jfree.chart.axis.DateTickUnitType.MONTH;
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer5 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d6 = xYBarRenderer5.getMargin();
    boolean b7 = xYBarRenderer5.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator9 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer5.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator9, true);
    java.lang.Object obj12 = standardXYToolTipGenerator9.clone();
    java.text.DateFormat dateFormat13 = standardXYToolTipGenerator9.getXDateFormat();
    org.jfree.chart.axis.DateTickUnit dateTickUnit14 = new org.jfree.chart.axis.DateTickUnit(dateTickUnitType0, 5, dateTickUnitType2, 4, dateFormat13);
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer15 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition17 = xYStepRenderer15.getSeriesPositiveItemLabelPosition(3);
    org.jfree.chart.axis.CategoryAxis categoryAxis19 = new org.jfree.chart.axis.CategoryAxis("");
    boolean b20 = xYStepRenderer15.equals((java.lang.Object)"");
    org.jfree.chart.plot.XYPlot xYPlot21 = xYStepRenderer15.getPlot();
    boolean b22 = xYStepRenderer15.getDrawSeriesLineAsPath();
    boolean b23 = dateTickUnit14.equals((java.lang.Object)xYStepRenderer15);
    xYStepRenderer15.removeAnnotations();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateTickUnitType0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateTickUnitType2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateFormat13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYPlot21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == false);

  }

  @Test
  public void test263() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test263"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis0 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset1 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot2 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset1);
    org.jfree.chart.axis.ValueAxis valueAxis3 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot4 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis3);
    java.util.List list5 = combinedDomainXYPlot4.getAnnotations();
    waferMapPlot2.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot4);
    int i7 = combinedDomainXYPlot4.getSeriesCount();
    categoryAxis0.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot4);
    java.awt.Color color15 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke16 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color17 = java.awt.Color.orange;
    java.awt.Stroke stroke18 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker20 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color15, stroke16, (java.awt.Paint)color17, stroke18, 0.0f);
    java.awt.Paint paint21 = intervalMarker20.getOutlinePaint();
    org.jfree.chart.util.Layer layer22 = null;
    combinedDomainXYPlot4.addRangeMarker(0, (org.jfree.chart.plot.Marker)intervalMarker20, layer22);
    org.jfree.chart.axis.AxisLocation axisLocation24 = combinedDomainXYPlot4.getDomainAxisLocation();
    java.awt.Color color31 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke32 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color33 = java.awt.Color.orange;
    java.awt.Stroke stroke34 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker36 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color31, stroke32, (java.awt.Paint)color33, stroke34, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer37 = null;
    intervalMarker36.setGradientPaintTransformer(gradientPaintTransformer37);
    org.jfree.chart.util.RectangleInsets rectangleInsets39 = intervalMarker36.getLabelOffset();
    org.jfree.chart.util.RectangleAnchor rectangleAnchor40 = org.jfree.chart.util.RectangleAnchor.LEFT;
    intervalMarker36.setLabelAnchor(rectangleAnchor40);
    org.jfree.chart.util.RectangleInsets rectangleInsets42 = intervalMarker36.getLabelOffset();
    org.jfree.chart.util.Layer layer43 = null;
    boolean b45 = combinedDomainXYPlot4.removeRangeMarker(14, (org.jfree.chart.plot.Marker)intervalMarker36, layer43, false);
    combinedDomainXYPlot4.setRangeCrosshairValue(2.0d, true);
    org.jfree.chart.axis.ValueAxis valueAxis50 = combinedDomainXYPlot4.getDomainAxis(1900);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(axisLocation24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleAnchor40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b45 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(valueAxis50);

  }

  @Test
  public void test264() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test264"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    org.jfree.chart.plot.Plot plot2 = combinedDomainXYPlot1.getRootPlot();
    org.jfree.chart.LegendItemCollection legendItemCollection3 = null;
    combinedDomainXYPlot1.setFixedLegendItems(legendItemCollection3);
    java.awt.Color color11 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke12 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color13 = java.awt.Color.orange;
    java.awt.Stroke stroke14 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker16 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color11, stroke12, (java.awt.Paint)color13, stroke14, 0.0f);
    java.awt.Paint paint17 = intervalMarker16.getOutlinePaint();
    intervalMarker16.setEndValue(3.0d);
    org.jfree.chart.util.Layer layer20 = null;
    combinedDomainXYPlot1.addRangeMarker(0, (org.jfree.chart.plot.Marker)intervalMarker16, layer20);
    combinedDomainXYPlot1.configureDomainAxes();
    java.awt.Font font24 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset25 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot26 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset25);
    org.jfree.chart.axis.ValueAxis valueAxis27 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot28 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis27);
    java.util.List list29 = combinedDomainXYPlot28.getAnnotations();
    waferMapPlot26.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot28);
    org.jfree.chart.JFreeChart jFreeChart32 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font24, (org.jfree.chart.plot.Plot)combinedDomainXYPlot28, true);
    org.jfree.chart.axis.NumberAxis numberAxis34 = new org.jfree.chart.axis.NumberAxis();
    numberAxis34.centerRange(100.0d);
    combinedDomainXYPlot28.setDomainAxis(0, (org.jfree.chart.axis.ValueAxis)numberAxis34);
    org.jfree.chart.plot.DefaultDrawingSupplier defaultDrawingSupplier38 = new org.jfree.chart.plot.DefaultDrawingSupplier();
    combinedDomainXYPlot28.setDrawingSupplier((org.jfree.chart.plot.DrawingSupplier)defaultDrawingSupplier38);
    java.lang.String str40 = combinedDomainXYPlot28.getPlotType();
    java.awt.Paint paint41 = combinedDomainXYPlot28.getRangeMinorGridlinePaint();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer43 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator44 = xYAreaRenderer43.getLegendItemToolTipGenerator();
    java.awt.Shape shape45 = xYAreaRenderer43.getBaseShape();
    xYAreaRenderer43.setSeriesVisibleInLegend(10, (java.lang.Boolean)false, true);
    java.awt.Paint paint51 = xYAreaRenderer43.getSeriesFillPaint(10);
    org.jfree.chart.labels.StandardXYSeriesLabelGenerator standardXYSeriesLabelGenerator53 = new org.jfree.chart.labels.StandardXYSeriesLabelGenerator("");
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D55 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.geom.Rectangle2D rectangle2D61 = null;
    org.jfree.chart.util.RectangleEdge rectangleEdge62 = null;
    double d63 = categoryAxis3D55.getCategorySeriesMiddle((-1), 255, (-1), 0, 0.0d, rectangle2D61, rectangleEdge62);
    boolean b64 = standardXYSeriesLabelGenerator53.equals((java.lang.Object)rectangle2D61);
    xYAreaRenderer43.setLegendItemURLGenerator((org.jfree.chart.labels.XYSeriesLabelGenerator)standardXYSeriesLabelGenerator53);
    combinedDomainXYPlot28.setRenderer((org.jfree.chart.renderer.xy.XYItemRenderer)xYAreaRenderer43);
    org.jfree.data.xy.XYSeries xYSeries67 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection68 = new org.jfree.data.xy.XYSeriesCollection(xYSeries67);
    boolean b69 = xYSeriesCollection68.isAutoWidth();
    org.jfree.data.Range range71 = xYSeriesCollection68.getRangeBounds(true);
    xYSeriesCollection68.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis74 = new org.jfree.chart.axis.NumberAxis();
    numberAxis74.centerRange(100.0d);
    java.lang.Object obj77 = numberAxis74.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer78 = null;
    org.jfree.chart.plot.PolarPlot polarPlot79 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection68, (org.jfree.chart.axis.ValueAxis)numberAxis74, polarItemRenderer78);
    org.jfree.chart.plot.PlotOrientation plotOrientation80 = polarPlot79.getOrientation();
    java.awt.Paint paint81 = polarPlot79.getAngleLabelPaint();
    combinedDomainXYPlot28.setNoDataMessagePaint(paint81);
    combinedDomainXYPlot1.setBackgroundPaint(paint81);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str40 + "' != '" + "Combined_Domain_XYPlot"+ "'", str40.equals("Combined_Domain_XYPlot"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d63, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b64 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b69 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint81);

  }

  @Test
  public void test265() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test265"); }


    java.awt.Color color2 = java.awt.Color.cyan;
    java.awt.color.ColorSpace colorSpace3 = color2.getColorSpace();
    org.jfree.chart.plot.IntervalMarker intervalMarker4 = new org.jfree.chart.plot.IntervalMarker(0.0d, 0.0d, (java.awt.Paint)color2);
    java.awt.Color color5 = java.awt.Color.cyan;
    java.awt.color.ColorSpace colorSpace6 = color5.getColorSpace();
    float[] f_array10 = new float[] { (-1.0f), 100.0f, 0.0f };
    // The following exception was thrown during execution in test generation
    try {
      float[] f_array11 = color2.getComponents(colorSpace6, f_array10);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(colorSpace3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(colorSpace6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array10);

  }

  @Test
  public void test266() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test266"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    org.jfree.chart.labels.StandardPieSectionLabelGenerator standardPieSectionLabelGenerator5 = new org.jfree.chart.labels.StandardPieSectionLabelGenerator("ERROR : Relative To String");
    piePlot3D2.setLegendLabelGenerator((org.jfree.chart.labels.PieSectionLabelGenerator)standardPieSectionLabelGenerator5);
    java.text.NumberFormat numberFormat7 = standardPieSectionLabelGenerator5.getNumberFormat();
    java.text.NumberFormat numberFormat8 = standardPieSectionLabelGenerator5.getPercentFormat();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat8);

  }

  @Test
  public void test267() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test267"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier2 = xYAreaRenderer1.getDrawingSupplier();
    java.awt.Stroke stroke3 = xYAreaRenderer1.getBaseStroke();
    boolean b4 = xYAreaRenderer1.getBaseSeriesVisible();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);

  }

  @Test
  public void test268() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test268"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    org.jfree.chart.urls.PieURLGenerator pieURLGenerator4 = piePlot3D2.getURLGenerator();
    double d5 = piePlot3D2.getMaximumExplodePercent();
    java.awt.Shape shape6 = piePlot3D2.getLegendItemShape();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(pieURLGenerator4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape6);

  }

  @Test
  public void test269() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test269"); }


    java.awt.Graphics2D graphics2D1 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.text.TextUtilities.drawRotatedString("TextBlockAnchor.BOTTOM_RIGHT", graphics2D1, 1.0f, 0.5f, 12.0d, 0.0f, 0.0f);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test270() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test270"); }


    org.jfree.data.time.DateRange dateRange2 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange5 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b6 = dateRange2.intersects((org.jfree.data.Range)dateRange5);
    org.jfree.data.xy.XYSeries xYSeries10 = new org.jfree.data.xy.XYSeries((java.lang.Comparable)10.0d, false, false);
    org.jfree.data.general.WaferMapDataset waferMapDataset11 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot12 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset11);
    org.jfree.chart.JFreeChart jFreeChart13 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent14 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot12, jFreeChart13);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment15 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment16 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement19 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment15, verticalAlignment16, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement20 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle21 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot12, (org.jfree.chart.block.Arrangement)flowArrangement19, (org.jfree.chart.block.Arrangement)borderArrangement20);
    org.jfree.data.time.TimeSeries timeSeries22 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection23 = new org.jfree.data.time.TimeSeriesCollection(timeSeries22);
    timeSeriesCollection23.validateObject();
    java.lang.Comparable comparable25 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer26 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement19, (org.jfree.data.general.Dataset)timeSeriesCollection23, comparable25);
    org.jfree.data.DomainOrder domainOrder27 = timeSeriesCollection23.getDomainOrder();
    xYSeries10.removeChangeListener((org.jfree.data.general.SeriesChangeListener)timeSeriesCollection23);
    boolean b29 = dateRange5.equals((java.lang.Object)xYSeries10);
    java.util.Date date30 = dateRange5.getLowerDate();
    org.jfree.data.time.SerialDate serialDate31 = org.jfree.data.time.SerialDate.createInstance(date30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(domainOrder27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(date30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(serialDate31);

  }

  @Test
  public void test271() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test271"); }


    org.jfree.chart.StandardChartTheme standardChartTheme1 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Paint paint2 = standardChartTheme1.getItemLabelPaint();
    java.awt.Shape shape10 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color12 = java.awt.Color.green;
    java.awt.Color color14 = java.awt.Color.green;
    java.awt.Color color20 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke21 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color22 = java.awt.Color.orange;
    java.awt.Stroke stroke23 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker25 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color20, stroke21, (java.awt.Paint)color22, stroke23, 0.0f);
    java.awt.Shape shape29 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke30 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color31 = java.awt.Color.green;
    java.lang.String str32 = org.jfree.chart.util.PaintUtilities.colorToString(color31);
    org.jfree.chart.LegendItem legendItem33 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape10, true, (java.awt.Paint)color12, false, (java.awt.Paint)color14, stroke21, true, shape29, stroke30, (java.awt.Paint)color31);
    standardChartTheme1.setLabelLinkPaint((java.awt.Paint)color31);
    java.awt.Paint paint35 = standardChartTheme1.getLabelLinkPaint();
    boolean b36 = standardChartTheme1.isShadowVisible();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str32 + "' != '" + "green"+ "'", str32.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == true);

  }

  @Test
  public void test272() {}
// Defects4J: flaky method
//   @Test
//   public void test272() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test272"); }
// 
// 
//     java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
//     org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
//     org.jfree.chart.axis.ValueAxis valueAxis4 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
//     java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
//     waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
//     org.jfree.chart.JFreeChart jFreeChart9 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
//     org.jfree.chart.axis.AxisSpace axisSpace10 = null;
//     combinedDomainXYPlot5.setFixedRangeAxisSpace(axisSpace10);
//     org.jfree.chart.axis.ValueAxis valueAxis12 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot13 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis12);
//     java.util.List list14 = combinedDomainXYPlot13.getAnnotations();
//     combinedDomainXYPlot13.setRangeGridlinesVisible(true);
//     org.jfree.chart.axis.ValueAxis valueAxis18 = null;
//     combinedDomainXYPlot13.setRangeAxis(100, valueAxis18, false);
//     org.jfree.chart.axis.NumberAxis numberAxis21 = new org.jfree.chart.axis.NumberAxis();
//     numberAxis21.centerRange(100.0d);
//     combinedDomainXYPlot13.setRangeAxis((org.jfree.chart.axis.ValueAxis)numberAxis21);
//     boolean b25 = numberAxis21.isNegativeArrowVisible();
//     org.jfree.data.time.DateRange dateRange28 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     org.jfree.data.time.DateRange dateRange31 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     boolean b32 = dateRange28.intersects((org.jfree.data.Range)dateRange31);
//     java.lang.String str33 = dateRange28.toString();
//     numberAxis21.setDefaultAutoRange((org.jfree.data.Range)dateRange28);
//     numberAxis21.setTickMarkInsideLength(10.0f);
//     org.jfree.data.Range range37 = combinedDomainXYPlot5.getDataRange((org.jfree.chart.axis.ValueAxis)numberAxis21);
//     org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer39 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
//     org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator40 = xYAreaRenderer39.getLegendItemToolTipGenerator();
//     java.awt.Shape shape41 = xYAreaRenderer39.getBaseShape();
//     java.awt.Stroke stroke42 = org.jfree.chart.plot.WaferMapPlot.DEFAULT_CROSSHAIR_STROKE;
//     xYAreaRenderer39.setBaseStroke(stroke42, true);
//     combinedDomainXYPlot5.setDomainZeroBaselineStroke(stroke42);
//     java.lang.String str46 = combinedDomainXYPlot5.getPlotType();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(font1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list6);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b25 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b32 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str33 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str33.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(range37);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(xYSeriesLabelGenerator40);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(shape41);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(stroke42);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str46 + "' != '" + "Combined_Domain_XYPlot"+ "'", str46.equals("Combined_Domain_XYPlot"));
// 
//   }

  @Test
  public void test273() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test273"); }


    java.util.TimeZone timeZone1 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
    org.jfree.chart.axis.DateAxis dateAxis2 = new org.jfree.chart.axis.DateAxis("", timeZone1);
    org.jfree.data.time.DateRange dateRange5 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    double d6 = dateRange5.getLength();
    long long7 = dateRange5.getLowerMillis();
    java.util.Date date8 = dateRange5.getLowerDate();
    java.util.Date date9 = dateRange5.getLowerDate();
    dateAxis2.setMaximumDate(date9);
    org.jfree.data.time.Year year11 = new org.jfree.data.time.Year(date9);
    java.util.Calendar calendar12 = null;
    // The following exception was thrown during execution in test generation
    try {
      long long13 = year11.getFirstMillisecond(calendar12);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(timeZone1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long7 == (-1L));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(date8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(date9);

  }

  @Test
  public void test274() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test274"); }


    java.awt.Image image0 = null;
    java.io.ObjectOutputStream objectOutputStream1 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.util.SerialUtilities.writeImage(image0, objectOutputStream1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test275() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test275"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    boolean b1 = categoryPlot0.isRangeZoomable();
    java.awt.Paint paint2 = org.jfree.chart.block.LabelBlock.DEFAULT_PAINT;
    categoryPlot0.setDomainGridlinePaint(paint2);
    org.jfree.chart.axis.CategoryAxis categoryAxis5 = categoryPlot0.getDomainAxisForDataset(9999);
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer7 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    boolean b8 = xYBarRenderer7.getUseYInterval();
    java.awt.Font font10 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset11 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot12 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset11);
    org.jfree.chart.axis.ValueAxis valueAxis13 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot14 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis13);
    java.util.List list15 = combinedDomainXYPlot14.getAnnotations();
    waferMapPlot12.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot14);
    boolean b17 = combinedDomainXYPlot14.isNotify();
    org.jfree.chart.JFreeChart jFreeChart19 = new org.jfree.chart.JFreeChart("", font10, (org.jfree.chart.plot.Plot)combinedDomainXYPlot14, true);
    combinedDomainXYPlot14.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer22 = null;
    combinedDomainXYPlot14.setRenderer(xYItemRenderer22);
    boolean b24 = combinedDomainXYPlot14.isDomainCrosshairVisible();
    org.jfree.data.time.TimeSeries timeSeries25 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection26 = new org.jfree.data.time.TimeSeriesCollection(timeSeries25);
    combinedDomainXYPlot14.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection26);
    xYBarRenderer7.setPlot((org.jfree.chart.plot.XYPlot)combinedDomainXYPlot14);
    java.awt.Paint paint30 = xYBarRenderer7.getSeriesOutlinePaint((-25560));
    java.awt.Paint paint31 = xYBarRenderer7.getBaseItemLabelPaint();
    java.awt.Paint paint33 = org.jfree.chart.plot.XYPlot.DEFAULT_GRIDLINE_PAINT;
    xYBarRenderer7.setLegendTextPaint(12, paint33);
    categoryPlot0.setOutlinePaint(paint33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryAxis5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint33);

  }

  @Test
  public void test276() {}
// Defects4J: flaky method
//   @Test
//   public void test276() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test276"); }
// 
// 
//     org.jfree.data.time.DateRange dateRange2 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d3 = dateRange2.getLength();
//     long long4 = dateRange2.getLowerMillis();
//     double d5 = dateRange2.getLength();
//     java.lang.String str6 = dateRange2.toString();
//     java.util.Date date7 = dateRange2.getUpperDate();
//     java.util.TimeZone timeZone8 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year9 = new org.jfree.data.time.Year(date7, timeZone8);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod10 = year9.next();
//     long long11 = year9.getLastMillisecond();
//     long long12 = year9.getSerialIndex();
//     java.util.Calendar calendar13 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       long long14 = year9.getFirstMillisecond(calendar13);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long4 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d5 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str6 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str6.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long11 == 28799999L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long12 == 1969L);
// 
//   }

  @Test
  public void test277() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test277"); }


    org.jfree.chart.StandardChartTheme standardChartTheme1 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.renderer.category.BarPainter barPainter2 = standardChartTheme1.getBarPainter();
    java.awt.Font font3 = standardChartTheme1.getLargeFont();
    java.lang.Object obj4 = standardChartTheme1.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(barPainter2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj4);

  }

  @Test
  public void test278() {}
// Defects4J: flaky method
//   @Test
//   public void test278() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test278"); }
// 
// 
//     org.jfree.chart.util.PaintMap paintMap0 = new org.jfree.chart.util.PaintMap();
//     java.lang.Object obj1 = null;
//     boolean b2 = paintMap0.equals(obj1);
//     org.jfree.data.time.Month month3 = new org.jfree.data.time.Month();
//     int i4 = month3.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem6 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month3, 11.0d);
//     org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer7 = new org.jfree.chart.renderer.xy.XYStepRenderer();
//     org.jfree.chart.labels.ItemLabelPosition itemLabelPosition9 = xYStepRenderer7.getSeriesPositiveItemLabelPosition(3);
//     java.util.Collection collection10 = xYStepRenderer7.getAnnotations();
//     boolean b11 = xYStepRenderer7.getBaseShapesFilled();
//     org.jfree.chart.labels.XYItemLabelGenerator xYItemLabelGenerator13 = null;
//     xYStepRenderer7.setSeriesItemLabelGenerator(255, xYItemLabelGenerator13);
//     java.awt.Font font16 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
//     org.jfree.data.general.WaferMapDataset waferMapDataset17 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot18 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset17);
//     org.jfree.chart.axis.ValueAxis valueAxis19 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot20 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis19);
//     java.util.List list21 = combinedDomainXYPlot20.getAnnotations();
//     waferMapPlot18.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot20);
//     boolean b23 = combinedDomainXYPlot20.isNotify();
//     org.jfree.chart.JFreeChart jFreeChart25 = new org.jfree.chart.JFreeChart("", font16, (org.jfree.chart.plot.Plot)combinedDomainXYPlot20, true);
//     combinedDomainXYPlot20.setDomainCrosshairLockedOnData(true);
//     org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer28 = null;
//     combinedDomainXYPlot20.setRenderer(xYItemRenderer28);
//     boolean b30 = combinedDomainXYPlot20.isDomainCrosshairVisible();
//     org.jfree.data.time.TimeSeries timeSeries31 = null;
//     org.jfree.data.time.TimeSeriesCollection timeSeriesCollection32 = new org.jfree.data.time.TimeSeriesCollection(timeSeries31);
//     combinedDomainXYPlot20.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection32);
//     java.util.List list34 = timeSeriesCollection32.getSeries();
//     org.jfree.data.Range range35 = org.jfree.data.general.DatasetUtilities.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection32);
//     org.jfree.data.DomainOrder domainOrder36 = timeSeriesCollection32.getDomainOrder();
//     org.jfree.data.Range range37 = xYStepRenderer7.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection32);
//     boolean b40 = xYStepRenderer7.getItemLineVisible((-25560), 100);
//     boolean b41 = xYStepRenderer7.getUseFillPaint();
//     org.jfree.data.Range range43 = null;
//     org.jfree.chart.block.RectangleConstraint rectangleConstraint44 = new org.jfree.chart.block.RectangleConstraint(100.0d, range43);
//     org.jfree.chart.block.LengthConstraintType lengthConstraintType45 = rectangleConstraint44.getWidthConstraintType();
//     org.jfree.data.time.DateRange dateRange48 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     org.jfree.data.time.DateRange dateRange51 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     boolean b52 = dateRange48.intersects((org.jfree.data.Range)dateRange51);
//     org.jfree.chart.block.RectangleConstraint rectangleConstraint53 = rectangleConstraint44.toRangeHeight((org.jfree.data.Range)dateRange51);
//     java.lang.String str54 = rectangleConstraint44.toString();
//     org.jfree.chart.block.RectangleConstraint rectangleConstraint55 = rectangleConstraint44.toUnconstrainedWidth();
//     org.jfree.chart.block.LengthConstraintType lengthConstraintType56 = rectangleConstraint55.getHeightConstraintType();
//     java.awt.Color color57 = java.awt.Color.darkGray;
//     boolean b58 = lengthConstraintType56.equals((java.lang.Object)color57);
//     xYStepRenderer7.setBaseFillPaint((java.awt.Paint)color57);
//     paintMap0.put((java.lang.Comparable)timeSeriesDataItem6, (java.awt.Paint)color57);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b2 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i4 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(itemLabelPosition9);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(collection10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b11 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(font16);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list21);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b23 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b30 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list34);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(range35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(domainOrder36);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(range37);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b40 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b41 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(lengthConstraintType45);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b52 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleConstraint53);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str54 + "' != '" + "RectangleConstraint[LengthConstraintType.FIXED: width=100.0, height=0.0]"+ "'", str54.equals("RectangleConstraint[LengthConstraintType.FIXED: width=100.0, height=0.0]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(rectangleConstraint55);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(lengthConstraintType56);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(color57);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b58 == false);
// 
//   }

  @Test
  public void test279() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test279"); }


    org.jfree.data.category.CategoryDataset categoryDataset0 = null;
    org.jfree.chart.axis.CategoryAxis categoryAxis1 = new org.jfree.chart.axis.CategoryAxis();
    categoryAxis1.setVisible(false);
    org.jfree.chart.util.RectangleInsets rectangleInsets4 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d5 = rectangleInsets4.getLeft();
    double d7 = rectangleInsets4.calculateLeftOutset(1.0d);
    categoryAxis1.setLabelInsets(rectangleInsets4, true);
    float f10 = categoryAxis1.getTickMarkOutsideLength();
    org.jfree.chart.axis.CategoryAnchor categoryAnchor11 = null;
    java.awt.geom.Rectangle2D rectangle2D14 = null;
    org.jfree.data.general.WaferMapDataset waferMapDataset15 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot16 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset15);
    org.jfree.chart.JFreeChart jFreeChart17 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent18 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot16, jFreeChart17);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment19 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment20 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement23 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment19, verticalAlignment20, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement24 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle25 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot16, (org.jfree.chart.block.Arrangement)flowArrangement23, (org.jfree.chart.block.Arrangement)borderArrangement24);
    org.jfree.chart.plot.CategoryPlot categoryPlot26 = new org.jfree.chart.plot.CategoryPlot();
    boolean b27 = categoryPlot26.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge29 = categoryPlot26.getDomainAxisEdge(8);
    legendTitle25.setPosition(rectangleEdge29);
    double d31 = categoryAxis1.getCategoryJava2DCoordinate(categoryAnchor11, 4, 255, rectangle2D14, rectangleEdge29);
    org.jfree.chart.axis.NumberAxis3D numberAxis3D32 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Paint paint33 = org.jfree.chart.axis.Axis.DEFAULT_AXIS_LINE_PAINT;
    numberAxis3D32.setLabelPaint(paint33);
    org.jfree.chart.axis.NumberTickUnit numberTickUnit35 = org.jfree.chart.axis.NumberAxis.DEFAULT_TICK_UNIT;
    numberAxis3D32.setTickUnit(numberTickUnit35, false, true);
    numberAxis3D32.resizeRange(6.0d, 1.0d);
    org.jfree.chart.renderer.category.BarRenderer barRenderer42 = new org.jfree.chart.renderer.category.BarRenderer();
    double d43 = barRenderer42.getShadowXOffset();
    org.jfree.chart.plot.CategoryPlot categoryPlot44 = new org.jfree.chart.plot.CategoryPlot(categoryDataset0, categoryAxis1, (org.jfree.chart.axis.ValueAxis)numberAxis3D32, (org.jfree.chart.renderer.category.CategoryItemRenderer)barRenderer42);
    java.awt.Paint paint45 = barRenderer42.getBaseItemLabelPaint();
    barRenderer42.setMinimumBarLength(100.0d);
    org.jfree.chart.plot.CategoryPlot categoryPlot48 = new org.jfree.chart.plot.CategoryPlot();
    boolean b49 = categoryPlot48.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge51 = categoryPlot48.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis53 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets54 = categoryAxis53.getLabelInsets();
    double d56 = rectangleInsets54.calculateLeftInset(4.0d);
    categoryPlot48.setInsets(rectangleInsets54, false);
    org.jfree.chart.util.Layer layer60 = null;
    java.util.Collection collection61 = categoryPlot48.getDomainMarkers(5, layer60);
    org.jfree.data.general.DatasetGroup datasetGroup62 = categoryPlot48.getDatasetGroup();
    org.jfree.chart.entity.EntityCollection entityCollection64 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo65 = new org.jfree.chart.ChartRenderingInfo(entityCollection64);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo66 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo65);
    java.awt.geom.Point2D point2D67 = null;
    categoryPlot48.zoomDomainAxes(12.0d, plotRenderingInfo66, point2D67, true);
    org.jfree.data.category.CategoryDataset categoryDataset70 = null;
    int i71 = categoryPlot48.indexOf(categoryDataset70);
    barRenderer42.setPlot(categoryPlot48);
    float f73 = categoryPlot48.getBackgroundImageAlpha();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f10 == 2.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d31 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberTickUnit35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d43 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b49 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d56 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(datasetGroup62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i71 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f73 == 0.5f);

  }

  @Test
  public void test280() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test280"); }


    org.jfree.data.Range range1 = null;
    org.jfree.chart.block.LengthConstraintType lengthConstraintType2 = org.jfree.chart.block.LengthConstraintType.NONE;
    org.jfree.data.time.DateRange dateRange6 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    org.jfree.data.time.DateRange dateRange9 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    boolean b10 = dateRange6.intersects((org.jfree.data.Range)dateRange9);
    org.jfree.data.Range range12 = org.jfree.data.Range.expandToInclude((org.jfree.data.Range)dateRange6, 1.0d);
    org.jfree.chart.block.LengthConstraintType lengthConstraintType13 = org.jfree.chart.block.LengthConstraintType.NONE;
    org.jfree.chart.block.RectangleConstraint rectangleConstraint14 = new org.jfree.chart.block.RectangleConstraint(2.0d, range1, lengthConstraintType2, 0.0d, range12, lengthConstraintType13);
    org.jfree.data.Range range16 = org.jfree.data.Range.shift(range12, 0.4d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(range16);

  }

  @Test
  public void test281() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test281"); }


    org.jfree.chart.block.RectangleConstraint rectangleConstraint0 = org.jfree.chart.block.RectangleConstraint.NONE;
    org.jfree.chart.block.LengthConstraintType lengthConstraintType1 = rectangleConstraint0.getHeightConstraintType();
    org.jfree.chart.block.LengthConstraintType lengthConstraintType2 = rectangleConstraint0.getWidthConstraintType();
    double d3 = rectangleConstraint0.getWidth();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleConstraint0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(lengthConstraintType2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d3 == 0.0d);

  }

  @Test
  public void test282() {}
// Defects4J: flaky method
//   @Test
//   public void test282() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test282"); }
// 
// 
//     java.awt.Font font1 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
//     org.jfree.data.general.WaferMapDataset waferMapDataset2 = null;
//     org.jfree.chart.plot.WaferMapPlot waferMapPlot3 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset2);
//     org.jfree.chart.axis.ValueAxis valueAxis4 = null;
//     org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot5 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis4);
//     java.util.List list6 = combinedDomainXYPlot5.getAnnotations();
//     waferMapPlot3.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot5);
//     boolean b8 = combinedDomainXYPlot5.isNotify();
//     org.jfree.chart.JFreeChart jFreeChart10 = new org.jfree.chart.JFreeChart("", font1, (org.jfree.chart.plot.Plot)combinedDomainXYPlot5, true);
//     combinedDomainXYPlot5.setDomainCrosshairLockedOnData(true);
//     org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer13 = null;
//     combinedDomainXYPlot5.setRenderer(xYItemRenderer13);
//     boolean b15 = combinedDomainXYPlot5.isDomainCrosshairVisible();
//     org.jfree.data.time.TimeSeries timeSeries16 = null;
//     org.jfree.data.time.TimeSeriesCollection timeSeriesCollection17 = new org.jfree.data.time.TimeSeriesCollection(timeSeries16);
//     combinedDomainXYPlot5.setDataset((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
//     java.util.List list19 = timeSeriesCollection17.getSeries();
//     org.jfree.data.Range range20 = org.jfree.data.general.DatasetUtilities.findRangeBounds((org.jfree.data.xy.XYDataset)timeSeriesCollection17);
//     org.jfree.data.DomainOrder domainOrder21 = timeSeriesCollection17.getDomainOrder();
//     double d23 = timeSeriesCollection17.getDomainUpperBound(false);
//     org.jfree.data.time.TimeSeries timeSeries27 = new org.jfree.data.time.TimeSeries((java.lang.Comparable)"hi!", "AxisLocation.TOP_OR_RIGHT", "SeriesRenderingOrder.FORWARD");
//     java.util.Collection collection28 = timeSeries27.getTimePeriods();
//     double d29 = timeSeries27.getMinY();
//     org.jfree.data.time.DateRange dateRange32 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d33 = dateRange32.getLength();
//     long long34 = dateRange32.getLowerMillis();
//     double d35 = dateRange32.getLength();
//     java.lang.String str36 = dateRange32.toString();
//     java.util.Date date37 = dateRange32.getUpperDate();
//     java.util.TimeZone timeZone38 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year39 = new org.jfree.data.time.Year(date37, timeZone38);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod40 = year39.next();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem42 = timeSeries27.addOrUpdate(regularTimePeriod40, 100000.0d);
//     timeSeriesCollection17.addSeries(timeSeries27);
//     // The following exception was thrown during execution in test generation
//     try {
//       org.jfree.data.time.TimeSeries timeSeries46 = timeSeries27.createCopy(21, 128);
//       org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
//     } catch (java.lang.IndexOutOfBoundsException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(font1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list6);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b8 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b15 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list19);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(range20);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(domainOrder21);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertEquals((double)d23, Double.NaN, 0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(collection28);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertEquals((double)d29, Double.NaN, 0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d33 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long34 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d35 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str36 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str36.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date37);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone38);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod40);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(timeSeriesDataItem42);
// 
//   }

  @Test
  public void test283() {}
// Defects4J: flaky method
//   @Test
//   public void test283() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test283"); }
// 
// 
//     org.jfree.chart.util.PaintMap paintMap0 = new org.jfree.chart.util.PaintMap();
//     org.jfree.data.time.DateRange dateRange3 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d4 = dateRange3.getLength();
//     long long5 = dateRange3.getLowerMillis();
//     double d6 = dateRange3.getLength();
//     java.lang.String str7 = dateRange3.toString();
//     java.util.Date date8 = dateRange3.getUpperDate();
//     java.util.TimeZone timeZone9 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year10 = new org.jfree.data.time.Year(date8, timeZone9);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod11 = year10.next();
//     java.awt.Paint paint12 = paintMap0.getPaint((java.lang.Comparable)year10);
//     org.jfree.data.time.SpreadsheetDate spreadsheetDate14 = new org.jfree.data.time.SpreadsheetDate(8);
//     org.jfree.data.time.SpreadsheetDate spreadsheetDate16 = new org.jfree.data.time.SpreadsheetDate(8);
//     boolean b17 = spreadsheetDate14.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate16);
//     int i18 = spreadsheetDate14.getYYYY();
//     boolean b19 = paintMap0.containsKey((java.lang.Comparable)spreadsheetDate14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d4 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d6 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str7 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str7.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone9);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(paint12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b17 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i18 == 1900);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b19 == false);
// 
//   }

  @Test
  public void test284() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test284"); }


    org.jfree.chart.plot.PiePlot piePlot0 = new org.jfree.chart.plot.PiePlot();

  }

  @Test
  public void test285() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test285"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.axis.ValueAxis valueAxis2 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot3 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis2);
    java.util.List list4 = combinedDomainXYPlot3.getAnnotations();
    waferMapPlot1.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot3);
    boolean b6 = combinedDomainXYPlot3.isNotify();
    org.jfree.chart.util.Layer layer7 = null;
    java.util.Collection collection8 = combinedDomainXYPlot3.getDomainMarkers(layer7);
    org.jfree.chart.LegendItemCollection legendItemCollection9 = combinedDomainXYPlot3.getLegendItems();
    org.jfree.chart.util.RectangleEdge rectangleEdge11 = combinedDomainXYPlot3.getRangeAxisEdge(7);
    boolean b12 = combinedDomainXYPlot3.isDomainGridlinesVisible();
    org.jfree.chart.axis.NumberAxis numberAxis14 = new org.jfree.chart.axis.NumberAxis();
    numberAxis14.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer18 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator19 = xYAreaRenderer18.getLegendItemToolTipGenerator();
    java.awt.Shape shape20 = xYAreaRenderer18.getBaseShape();
    numberAxis14.setUpArrow(shape20);
    numberAxis14.pan((-1.0d));
    boolean b24 = numberAxis14.getAutoRangeIncludesZero();
    combinedDomainXYPlot3.setDomainAxis(14, (org.jfree.chart.axis.ValueAxis)numberAxis14, false);
    org.jfree.chart.axis.ValueAxis valueAxis28 = combinedDomainXYPlot3.getDomainAxis((-1));
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer30 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator31 = xYAreaRenderer30.getLegendItemToolTipGenerator();
    boolean b34 = xYAreaRenderer30.getItemVisible(10, 1);
    java.lang.Boolean b36 = xYAreaRenderer30.getSeriesVisibleInLegend(0);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition37 = xYAreaRenderer30.getBasePositiveItemLabelPosition();
    java.awt.Shape shape39 = xYAreaRenderer30.lookupSeriesShape(0);
    combinedDomainXYPlot3.setRenderer((org.jfree.chart.renderer.xy.XYItemRenderer)xYAreaRenderer30);
    java.awt.Paint paint42 = xYAreaRenderer30.getSeriesPaint(9999);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(valueAxis28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b34 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint42);

  }

  @Test
  public void test286() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test286"); }


    java.awt.Paint paint0 = org.jfree.chart.plot.Plot.DEFAULT_BACKGROUND_PAINT;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint0);

  }

  @Test
  public void test287() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test287"); }


    org.jfree.chart.renderer.category.BarRenderer barRenderer0 = new org.jfree.chart.renderer.category.BarRenderer();
    double d1 = barRenderer0.getShadowXOffset();
    barRenderer0.setShadowXOffset(10.0d);
    boolean b4 = barRenderer0.getIncludeBaseInRange();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition5 = barRenderer0.getNegativeItemLabelPositionFallback();
    org.jfree.chart.urls.CategoryURLGenerator categoryURLGenerator6 = null;
    barRenderer0.setBaseURLGenerator(categoryURLGenerator6);
    org.jfree.chart.plot.CategoryPlot categoryPlot8 = barRenderer0.getPlot();
    double d9 = barRenderer0.getUpperClip();
    barRenderer0.setItemMargin(299994.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(itemLabelPosition5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(categoryPlot8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d9 == 0.0d);

  }

  @Test
  public void test288() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test288"); }


    java.awt.Paint paint0 = org.jfree.chart.axis.Axis.DEFAULT_AXIS_LINE_PAINT;
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent1 = new org.jfree.data.general.SeriesChangeEvent((java.lang.Object)paint0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint0);

  }

  @Test
  public void test289() {}
// Defects4J: flaky method
//   @Test
//   public void test289() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test289"); }
// 
// 
//     org.jfree.chart.block.ColumnArrangement columnArrangement0 = new org.jfree.chart.block.ColumnArrangement();
//     org.jfree.chart.plot.CategoryPlot categoryPlot1 = new org.jfree.chart.plot.CategoryPlot();
//     boolean b2 = categoryPlot1.isRangeZoomable();
//     org.jfree.chart.axis.CategoryAxis categoryAxis3 = categoryPlot1.getDomainAxis();
//     boolean b4 = columnArrangement0.equals((java.lang.Object)categoryAxis3);
//     org.jfree.data.time.DateRange dateRange7 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d8 = dateRange7.getLength();
//     long long9 = dateRange7.getLowerMillis();
//     double d10 = dateRange7.getLength();
//     java.lang.String str11 = dateRange7.toString();
//     java.util.Date date12 = dateRange7.getUpperDate();
//     java.util.TimeZone timeZone13 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year14 = new org.jfree.data.time.Year(date12, timeZone13);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod15 = year14.next();
//     long long16 = year14.getFirstMillisecond();
//     boolean b17 = columnArrangement0.equals((java.lang.Object)year14);
//     columnArrangement0.clear();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b2 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(categoryAxis3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b4 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d8 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long9 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d10 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str11 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str11.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long16 == (-31507200000L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b17 == false);
// 
//   }

  @Test
  public void test290() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test290"); }


    org.jfree.data.time.TimeSeries timeSeries3 = new org.jfree.data.time.TimeSeries((java.lang.Comparable)"hi!", "AxisLocation.TOP_OR_RIGHT", "SeriesRenderingOrder.FORWARD");
    java.lang.String str4 = timeSeries3.getRangeDescription();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str4 + "' != '" + "SeriesRenderingOrder.FORWARD"+ "'", str4.equals("SeriesRenderingOrder.FORWARD"));

  }

  @Test
  public void test291() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test291"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    piePlot3D2.setStartAngle(Double.NaN);
    org.jfree.data.general.DefaultPieDataset defaultPieDataset5 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj6 = defaultPieDataset5.clone();
    double d7 = org.jfree.data.general.DatasetUtilities.calculatePieDatasetTotal((org.jfree.data.general.PieDataset)defaultPieDataset5);
    piePlot3D2.setDataset((org.jfree.data.general.PieDataset)defaultPieDataset5);
    org.jfree.chart.util.Rotation rotation9 = piePlot3D2.getDirection();
    org.jfree.chart.axis.ValueAxis valueAxis11 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot12 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis11);
    java.util.List list13 = combinedDomainXYPlot12.getAnnotations();
    combinedDomainXYPlot12.setRangeGridlinesVisible(true);
    org.jfree.chart.axis.AxisSpace axisSpace16 = null;
    combinedDomainXYPlot12.setFixedRangeAxisSpace(axisSpace16);
    org.jfree.data.xy.XYDataset xYDataset19 = combinedDomainXYPlot12.getDataset(40);
    org.jfree.chart.StandardChartTheme standardChartTheme21 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Paint paint22 = standardChartTheme21.getAxisLabelPaint();
    java.awt.Font font23 = standardChartTheme21.getLargeFont();
    combinedDomainXYPlot12.setNoDataMessageFont(font23);
    org.jfree.data.general.WaferMapDataset waferMapDataset25 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot26 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset25);
    org.jfree.chart.axis.ValueAxis valueAxis27 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot28 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis27);
    java.util.List list29 = combinedDomainXYPlot28.getAnnotations();
    waferMapPlot26.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot28);
    boolean b31 = combinedDomainXYPlot28.isNotify();
    org.jfree.chart.util.Layer layer32 = null;
    java.util.Collection collection33 = combinedDomainXYPlot28.getDomainMarkers(layer32);
    org.jfree.chart.LegendItemCollection legendItemCollection34 = combinedDomainXYPlot28.getLegendItems();
    org.jfree.chart.JFreeChart jFreeChart36 = new org.jfree.chart.JFreeChart("ClassContext", font23, (org.jfree.chart.plot.Plot)combinedDomainXYPlot28, false);
    boolean b37 = piePlot3D2.equals((java.lang.Object)"ClassContext");
    double d38 = piePlot3D2.getDepthFactor();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rotation9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYDataset19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d38 == 0.12d);

  }

  @Test
  public void test292() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test292"); }


    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer0 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    xYStepRenderer0.setAutoPopulateSeriesOutlineStroke(false);
    boolean b3 = xYStepRenderer0.getDrawSeriesLineAsPath();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test293() {}
// Defects4J: flaky method
//   @Test
//   public void test293() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test293"); }
// 
// 
//     org.jfree.chart.axis.DateTickUnitType dateTickUnitType0 = org.jfree.chart.axis.DateTickUnitType.MINUTE;
//     org.jfree.chart.axis.DateTickUnitType dateTickUnitType2 = org.jfree.chart.axis.DateTickUnitType.MONTH;
//     org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer5 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
//     double d6 = xYBarRenderer5.getMargin();
//     boolean b7 = xYBarRenderer5.getAutoPopulateSeriesShape();
//     org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator9 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
//     xYBarRenderer5.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator9, true);
//     java.lang.Object obj12 = standardXYToolTipGenerator9.clone();
//     java.text.DateFormat dateFormat13 = standardXYToolTipGenerator9.getXDateFormat();
//     org.jfree.chart.axis.DateTickUnit dateTickUnit14 = new org.jfree.chart.axis.DateTickUnit(dateTickUnitType0, 5, dateTickUnitType2, 4, dateFormat13);
//     org.jfree.data.time.DateRange dateRange17 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d18 = dateRange17.getLength();
//     long long19 = dateRange17.getLowerMillis();
//     double d20 = dateRange17.getLength();
//     java.lang.String str21 = dateRange17.toString();
//     java.util.Date date22 = dateRange17.getUpperDate();
//     org.jfree.data.time.DateRange dateRange25 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d26 = dateRange25.getLength();
//     long long27 = dateRange25.getLowerMillis();
//     double d28 = dateRange25.getLength();
//     java.lang.String str29 = dateRange25.toString();
//     java.util.Date date30 = dateRange25.getUpperDate();
//     java.util.TimeZone timeZone31 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year32 = new org.jfree.data.time.Year(date30, timeZone31);
//     java.util.Date date33 = dateTickUnit14.rollDate(date22, timeZone31);
//     java.util.TimeZone timeZone34 = null;
//     org.jfree.data.time.Year year37 = new org.jfree.data.time.Year(3);
//     org.jfree.data.xy.DefaultXYDataset defaultXYDataset38 = new org.jfree.data.xy.DefaultXYDataset();
//     org.jfree.chart.util.PaintMap paintMap39 = new org.jfree.chart.util.PaintMap();
//     org.jfree.data.time.DateRange dateRange42 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d43 = dateRange42.getLength();
//     long long44 = dateRange42.getLowerMillis();
//     double d45 = dateRange42.getLength();
//     java.lang.String str46 = dateRange42.toString();
//     java.util.Date date47 = dateRange42.getUpperDate();
//     java.util.TimeZone timeZone48 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year49 = new org.jfree.data.time.Year(date47, timeZone48);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod50 = year49.next();
//     java.awt.Paint paint51 = paintMap39.getPaint((java.lang.Comparable)year49);
//     int i52 = defaultXYDataset38.indexOf((java.lang.Comparable)year49);
//     java.util.TimeZone timeZone53 = org.jfree.chart.axis.SegmentedTimeline.NO_DST_TIME_ZONE;
//     org.jfree.data.time.Month month55 = new org.jfree.data.time.Month();
//     int i56 = month55.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem58 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month55, (java.lang.Number)8);
//     long long59 = month55.getFirstMillisecond();
//     org.jfree.data.time.Month month60 = new org.jfree.data.time.Month();
//     int i61 = month60.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis62 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month55, (org.jfree.data.time.RegularTimePeriod)month60);
//     float f63 = periodAxis62.getMinorTickMarkInsideLength();
//     java.util.Locale locale64 = periodAxis62.getLocale();
//     java.text.NumberFormat numberFormat65 = java.text.NumberFormat.getInstance(locale64);
//     org.jfree.chart.axis.PeriodAxis periodAxis66 = new org.jfree.chart.axis.PeriodAxis("Feb", (org.jfree.data.time.RegularTimePeriod)year37, (org.jfree.data.time.RegularTimePeriod)year49, timeZone53, locale64);
//     org.jfree.chart.labels.StandardPieToolTipGenerator standardPieToolTipGenerator67 = new org.jfree.chart.labels.StandardPieToolTipGenerator(locale64);
//     // The following exception was thrown during execution in test generation
//     try {
//       org.jfree.data.time.Year year68 = new org.jfree.data.time.Year(date33, timeZone34, locale64);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateTickUnitType0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateTickUnitType2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d6 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b7 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(standardXYToolTipGenerator9);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateFormat13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d18 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long19 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d20 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str21 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str21.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d26 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long27 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d28 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str29 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str29.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date30);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone31);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date33);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d43 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long44 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d45 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str46 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str46.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date47);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone48);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod50);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(paint51);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i52 == (-1));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone53);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i56 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long59 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i61 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f63 == 0.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(locale64);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(numberFormat65);
// 
//   }

  @Test
  public void test294() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test294"); }


    org.jfree.data.category.CategoryDataset categoryDataset0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.general.PieDataset pieDataset2 = org.jfree.data.general.DatasetUtilities.createPieDatasetForRow(categoryDataset0, (-16711936));
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test295() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test295"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.axis.ValueAxis valueAxis2 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot3 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis2);
    java.util.List list4 = combinedDomainXYPlot3.getAnnotations();
    waferMapPlot1.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot3);
    boolean b6 = combinedDomainXYPlot3.isNotify();
    org.jfree.chart.util.Layer layer7 = null;
    java.util.Collection collection8 = combinedDomainXYPlot3.getDomainMarkers(layer7);
    org.jfree.chart.LegendItemCollection legendItemCollection9 = combinedDomainXYPlot3.getLegendItems();
    org.jfree.chart.util.RectangleEdge rectangleEdge11 = combinedDomainXYPlot3.getRangeAxisEdge(7);
    boolean b12 = combinedDomainXYPlot3.isDomainGridlinesVisible();
    java.awt.Paint paint13 = combinedDomainXYPlot3.getRangeMinorGridlinePaint();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(collection8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint13);

  }

  @Test
  public void test296() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test296"); }


    org.jfree.data.time.TimeSeries timeSeries0 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection1 = new org.jfree.data.time.TimeSeriesCollection(timeSeries0);
    org.jfree.data.time.TimePeriodAnchor timePeriodAnchor2 = timeSeriesCollection1.getXPosition();
    org.jfree.data.xy.IntervalXYDelegate intervalXYDelegate3 = new org.jfree.data.xy.IntervalXYDelegate((org.jfree.data.xy.XYDataset)timeSeriesCollection1);
    double d4 = intervalXYDelegate3.getIntervalWidth();
    double d5 = intervalXYDelegate3.getIntervalPositionFactor();
    double d6 = intervalXYDelegate3.getIntervalWidth();
    double d7 = intervalXYDelegate3.getFixedIntervalWidth();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(timePeriodAnchor2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 0.5d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 1.0d);

  }

  @Test
  public void test297() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test297"); }


    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.Day day3 = new org.jfree.data.time.Day(9999, 128, 140);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test298() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test298"); }


    org.jfree.chart.plot.CrosshairState crosshairState1 = new org.jfree.chart.plot.CrosshairState(true);
    crosshairState1.updateCrosshairY(6.0d, (-1));
    double d5 = crosshairState1.getCrosshairDistance();
    double d6 = crosshairState1.getCrosshairX();
    crosshairState1.setCrosshairY(6.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 0.0d);

  }

  @Test
  public void test299() {}
// Defects4J: flaky method
//   @Test
//   public void test299() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test299"); }
// 
// 
//     org.jfree.chart.block.Arrangement arrangement0 = null;
//     org.jfree.data.time.TimeSeries timeSeries1 = null;
//     org.jfree.data.time.Month month3 = new org.jfree.data.time.Month();
//     int i4 = month3.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem6 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month3, (java.lang.Number)8);
//     long long7 = month3.getFirstMillisecond();
//     org.jfree.data.time.Month month8 = new org.jfree.data.time.Month();
//     int i9 = month8.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis10 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month3, (org.jfree.data.time.RegularTimePeriod)month8);
//     float f11 = periodAxis10.getMinorTickMarkInsideLength();
//     java.util.TimeZone timeZone12 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.TimeSeriesCollection timeSeriesCollection13 = new org.jfree.data.time.TimeSeriesCollection(timeZone12);
//     periodAxis10.setTimeZone(timeZone12);
//     org.jfree.data.time.TimeSeriesCollection timeSeriesCollection15 = new org.jfree.data.time.TimeSeriesCollection(timeSeries1, timeZone12);
//     org.jfree.data.time.DateRange dateRange18 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d19 = dateRange18.getLength();
//     long long20 = dateRange18.getLowerMillis();
//     double d21 = dateRange18.getLength();
//     java.lang.String str22 = dateRange18.toString();
//     java.util.Date date23 = dateRange18.getUpperDate();
//     java.util.TimeZone timeZone24 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year25 = new org.jfree.data.time.Year(date23, timeZone24);
//     long long26 = year25.getSerialIndex();
//     // The following exception was thrown during execution in test generation
//     try {
//       org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer27 = new org.jfree.chart.title.LegendItemBlockContainer(arrangement0, (org.jfree.data.general.Dataset)timeSeriesCollection15, (java.lang.Comparable)long26);
//       org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
//     } catch (java.lang.IllegalArgumentException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i4 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long7 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i9 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f11 == 0.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d19 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long20 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d21 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str22 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str22.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date23);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone24);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long26 == 1969L);
// 
//   }

  @Test
  public void test300() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test300"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    org.jfree.data.time.TimeSeries timeSeries11 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection12 = new org.jfree.data.time.TimeSeriesCollection(timeSeries11);
    timeSeriesCollection12.validateObject();
    java.lang.Comparable comparable14 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer15 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.data.general.Dataset)timeSeriesCollection12, comparable14);
    timeSeriesCollection12.validateObject();
    java.util.List list17 = timeSeriesCollection12.getSeries();
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number20 = timeSeriesCollection12.getStartY(31, (-1));
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list17);

  }

  @Test
  public void test301() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test301"); }


    org.jfree.chart.axis.NumberAxis numberAxis0 = new org.jfree.chart.axis.NumberAxis();
    numberAxis0.configure();
    org.jfree.chart.axis.NumberAxis numberAxis2 = new org.jfree.chart.axis.NumberAxis();
    numberAxis2.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer6 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator7 = xYAreaRenderer6.getLegendItemToolTipGenerator();
    java.awt.Shape shape8 = xYAreaRenderer6.getBaseShape();
    numberAxis2.setUpArrow(shape8);
    org.jfree.chart.StandardChartTheme standardChartTheme15 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.renderer.category.BarPainter barPainter16 = standardChartTheme15.getBarPainter();
    java.awt.Font font17 = standardChartTheme15.getLargeFont();
    org.jfree.chart.axis.MarkerAxisBand markerAxisBand18 = new org.jfree.chart.axis.MarkerAxisBand(numberAxis2, 0.2d, 12.0d, 0.0d, 4.5d, font17);
    java.awt.Graphics2D graphics2D19 = null;
    java.awt.geom.Rectangle2D rectangle2D20 = null;
    java.awt.geom.Rectangle2D rectangle2D21 = null;
    markerAxisBand18.draw(graphics2D19, rectangle2D20, rectangle2D21, 0.6d, 0.0d);
    numberAxis0.setMarkerBand(markerAxisBand18);
    java.awt.Graphics2D graphics2D26 = null;
    double d27 = markerAxisBand18.getHeight(graphics2D26);
    java.text.NumberFormat numberFormat28 = java.text.NumberFormat.getIntegerInstance();
    java.util.Currency currency29 = numberFormat28.getCurrency();
    boolean b30 = markerAxisBand18.equals((java.lang.Object)numberFormat28);
    int i31 = numberFormat28.getMinimumIntegerDigits();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(barPainter16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(currency29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i31 == 1);

  }

  @Test
  public void test302() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test302"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    double d3 = xYBarRenderer1.getShadowXOffset();
    org.jfree.chart.urls.XYURLGenerator xYURLGenerator4 = null;
    xYBarRenderer1.setBaseURLGenerator(xYURLGenerator4, true);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer8 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator9 = xYAreaRenderer8.getLegendItemToolTipGenerator();
    boolean b12 = xYAreaRenderer8.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition16 = xYAreaRenderer8.getPositiveItemLabelPosition(8, 10, false);
    xYBarRenderer1.setNegativeItemLabelPositionFallback(itemLabelPosition16);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition18 = xYBarRenderer1.getPositiveItemLabelPositionFallback();
    java.awt.Font font23 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset24 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot25 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset24);
    org.jfree.chart.axis.ValueAxis valueAxis26 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot27 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis26);
    java.util.List list28 = combinedDomainXYPlot27.getAnnotations();
    waferMapPlot25.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot27);
    org.jfree.chart.JFreeChart jFreeChart31 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font23, (org.jfree.chart.plot.Plot)combinedDomainXYPlot27, true);
    java.awt.Color color35 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment36 = new org.jfree.chart.text.TextFragment("hi!", font23, (java.awt.Paint)color35);
    java.awt.Paint paint37 = org.jfree.chart.plot.PiePlot.DEFAULT_LABEL_OUTLINE_PAINT;
    org.jfree.chart.plot.CategoryPlot categoryPlot38 = new org.jfree.chart.plot.CategoryPlot();
    boolean b39 = categoryPlot38.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge41 = categoryPlot38.getDomainAxisEdge(8);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment42 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment43 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement46 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment42, verticalAlignment43, 11.0d, 0.2d);
    org.jfree.chart.util.VerticalAlignment verticalAlignment47 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement50 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment42, verticalAlignment47, (-1.0d), Double.NaN);
    org.jfree.chart.util.VerticalAlignment verticalAlignment51 = org.jfree.chart.title.Title.DEFAULT_VERTICAL_ALIGNMENT;
    org.jfree.chart.util.RectangleInsets rectangleInsets52 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent53 = new org.jfree.data.general.SeriesChangeEvent((java.lang.Object)rectangleInsets52);
    org.jfree.chart.title.TextTitle textTitle54 = new org.jfree.chart.title.TextTitle("March", font23, paint37, rectangleEdge41, horizontalAlignment42, verticalAlignment51, rectangleInsets52);
    java.awt.Font font55 = textTitle54.getFont();
    xYBarRenderer1.setLegendTextFont(3, font55);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier57 = xYBarRenderer1.getDrawingSupplier();
    org.jfree.chart.labels.XYItemLabelGenerator xYItemLabelGenerator61 = xYBarRenderer1.getItemLabelGenerator(4, (-9999), true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d3 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(itemLabelPosition18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(verticalAlignment51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYItemLabelGenerator61);

  }

  @Test
  public void test303() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test303"); }


    org.jfree.chart.plot.PieLabelDistributor pieLabelDistributor1 = new org.jfree.chart.plot.PieLabelDistributor(8);
    int i2 = pieLabelDistributor1.getItemCount();
    pieLabelDistributor1.clear();
    pieLabelDistributor1.sort();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.plot.PieLabelRecord pieLabelRecord6 = pieLabelDistributor1.getPieLabelRecord(8);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);

  }

  @Test
  public void test304() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test304"); }


    org.jfree.data.time.SpreadsheetDate spreadsheetDate2 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate4 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b5 = spreadsheetDate2.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate4);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate7 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate9 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b10 = spreadsheetDate7.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate9);
    int i11 = spreadsheetDate7.getYYYY();
    org.jfree.data.time.SpreadsheetDate spreadsheetDate13 = new org.jfree.data.time.SpreadsheetDate(8);
    org.jfree.data.time.SpreadsheetDate spreadsheetDate15 = new org.jfree.data.time.SpreadsheetDate(8);
    boolean b16 = spreadsheetDate13.isAfter((org.jfree.data.time.SerialDate)spreadsheetDate15);
    int i17 = spreadsheetDate15.getMonth();
    boolean b18 = spreadsheetDate7.isOnOrBefore((org.jfree.data.time.SerialDate)spreadsheetDate15);
    int i19 = spreadsheetDate15.getDayOfWeek();
    boolean b20 = spreadsheetDate2.isOnOrBefore((org.jfree.data.time.SerialDate)spreadsheetDate15);
    org.jfree.data.time.SerialDate serialDate21 = org.jfree.data.time.SerialDate.getNearestDayOfWeek(4, (org.jfree.data.time.SerialDate)spreadsheetDate2);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.SerialDate serialDate23 = serialDate21.getNearestDayOfWeek(40);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i11 == 1900);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i17 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i19 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(serialDate21);

  }

  @Test
  public void test305() {}
// Defects4J: flaky method
//   @Test
//   public void test305() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test305"); }
// 
// 
//     org.jfree.data.time.DateRange dateRange3 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     org.jfree.data.time.DateRange dateRange6 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     boolean b7 = dateRange3.intersects((org.jfree.data.Range)dateRange6);
//     java.lang.String str8 = dateRange3.toString();
//     org.jfree.chart.block.RectangleConstraint rectangleConstraint9 = new org.jfree.chart.block.RectangleConstraint(0.0d, (org.jfree.data.Range)dateRange3);
//     org.jfree.data.time.DateRange dateRange10 = new org.jfree.data.time.DateRange((org.jfree.data.Range)dateRange3);
//     org.jfree.data.Range range12 = org.jfree.data.Range.expandToInclude((org.jfree.data.Range)dateRange10, 108.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b7 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str8 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str8.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(range12);
// 
//   }

  @Test
  public void test306() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test306"); }


    org.jfree.chart.plot.CategoryPlot categoryPlot0 = new org.jfree.chart.plot.CategoryPlot();
    org.jfree.chart.axis.ValueAxis valueAxis2 = categoryPlot0.getRangeAxisForDataset(14);
    categoryPlot0.setRangeCrosshairValue(0.08d, false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(valueAxis2);

  }

  @Test
  public void test307() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test307"); }


    org.jfree.chart.util.StrokeMap strokeMap0 = new org.jfree.chart.util.StrokeMap();
    strokeMap0.clear();
    java.lang.Comparable comparable2 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.awt.Stroke stroke3 = strokeMap0.getStroke(comparable2);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test308() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test308"); }


    org.jfree.chart.axis.NumberAxis numberAxis0 = new org.jfree.chart.axis.NumberAxis();
    numberAxis0.configure();
    org.jfree.chart.axis.NumberAxis numberAxis2 = new org.jfree.chart.axis.NumberAxis();
    numberAxis2.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer6 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator7 = xYAreaRenderer6.getLegendItemToolTipGenerator();
    java.awt.Shape shape8 = xYAreaRenderer6.getBaseShape();
    numberAxis2.setUpArrow(shape8);
    org.jfree.chart.StandardChartTheme standardChartTheme15 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.renderer.category.BarPainter barPainter16 = standardChartTheme15.getBarPainter();
    java.awt.Font font17 = standardChartTheme15.getLargeFont();
    org.jfree.chart.axis.MarkerAxisBand markerAxisBand18 = new org.jfree.chart.axis.MarkerAxisBand(numberAxis2, 0.2d, 12.0d, 0.0d, 4.5d, font17);
    java.awt.Graphics2D graphics2D19 = null;
    java.awt.geom.Rectangle2D rectangle2D20 = null;
    java.awt.geom.Rectangle2D rectangle2D21 = null;
    markerAxisBand18.draw(graphics2D19, rectangle2D20, rectangle2D21, 0.6d, 0.0d);
    numberAxis0.setMarkerBand(markerAxisBand18);
    java.awt.Graphics2D graphics2D26 = null;
    double d27 = markerAxisBand18.getHeight(graphics2D26);
    java.text.NumberFormat numberFormat28 = java.text.NumberFormat.getIntegerInstance();
    java.util.Currency currency29 = numberFormat28.getCurrency();
    boolean b30 = markerAxisBand18.equals((java.lang.Object)numberFormat28);
    java.awt.Graphics2D graphics2D31 = null;
    org.jfree.chart.util.RectangleInsets rectangleInsets32 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    double d33 = rectangleInsets32.getLeft();
    org.jfree.chart.axis.ValueAxis valueAxis34 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot35 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis34);
    org.jfree.chart.plot.Plot plot36 = combinedDomainXYPlot35.getRootPlot();
    org.jfree.chart.LegendItemCollection legendItemCollection37 = null;
    combinedDomainXYPlot35.setFixedLegendItems(legendItemCollection37);
    org.jfree.chart.event.PlotChangeEvent plotChangeEvent39 = null;
    combinedDomainXYPlot35.notifyListeners(plotChangeEvent39);
    java.awt.Color color41 = java.awt.Color.cyan;
    combinedDomainXYPlot35.setDomainCrosshairPaint((java.awt.Paint)color41);
    java.awt.geom.GeneralPath generalPath43 = null;
    org.jfree.data.xy.XYSeries xYSeries44 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection45 = new org.jfree.data.xy.XYSeriesCollection(xYSeries44);
    boolean b46 = xYSeriesCollection45.isAutoWidth();
    org.jfree.data.Range range48 = xYSeriesCollection45.getRangeBounds(true);
    xYSeriesCollection45.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis51 = new org.jfree.chart.axis.NumberAxis();
    numberAxis51.centerRange(100.0d);
    java.lang.Object obj54 = numberAxis51.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer55 = null;
    org.jfree.chart.plot.PolarPlot polarPlot56 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection45, (org.jfree.chart.axis.ValueAxis)numberAxis51, polarItemRenderer55);
    org.jfree.chart.plot.PlotOrientation plotOrientation57 = polarPlot56.getOrientation();
    boolean b58 = polarPlot56.isAngleLabelsVisible();
    int i59 = polarPlot56.getSeriesCount();
    java.awt.Font font64 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset65 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot66 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset65);
    org.jfree.chart.axis.ValueAxis valueAxis67 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot68 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis67);
    java.util.List list69 = combinedDomainXYPlot68.getAnnotations();
    waferMapPlot66.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot68);
    boolean b71 = combinedDomainXYPlot68.isNotify();
    org.jfree.chart.JFreeChart jFreeChart73 = new org.jfree.chart.JFreeChart("", font64, (org.jfree.chart.plot.Plot)combinedDomainXYPlot68, true);
    org.jfree.chart.title.TextTitle textTitle74 = new org.jfree.chart.title.TextTitle("", font64);
    textTitle74.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame77 = textTitle74.getFrame();
    java.lang.String str78 = textTitle74.getID();
    java.awt.geom.Rectangle2D rectangle2D79 = textTitle74.getBounds();
    java.awt.Point point80 = polarPlot56.translateValueThetaRadiusToJava2D(0.0d, 0.05d, rectangle2D79);
    org.jfree.chart.RenderingSource renderingSource81 = null;
    combinedDomainXYPlot35.select(generalPath43, rectangle2D79, renderingSource81);
    java.awt.geom.Rectangle2D rectangle2D83 = rectangleInsets32.createOutsetRectangle(rectangle2D79);
    java.awt.geom.Rectangle2D rectangle2D84 = null;
    markerAxisBand18.draw(graphics2D31, rectangle2D79, rectangle2D84, 3.421523046092185d, 2.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(barPainter16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(currency29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d33 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b46 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b58 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i59 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b71 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str78);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(point80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangle2D83);

  }

  @Test
  public void test309() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test309"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer1 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d2 = xYBarRenderer1.getMargin();
    boolean b3 = xYBarRenderer1.getAutoPopulateSeriesShape();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer5 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator6 = xYAreaRenderer5.getLegendItemToolTipGenerator();
    boolean b9 = xYAreaRenderer5.getItemVisible(10, 1);
    java.lang.Boolean b11 = xYAreaRenderer5.getSeriesVisibleInLegend(0);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition12 = xYAreaRenderer5.getBasePositiveItemLabelPosition();
    org.jfree.chart.text.TextAnchor textAnchor13 = itemLabelPosition12.getTextAnchor();
    xYBarRenderer1.setPositiveItemLabelPositionFallback(itemLabelPosition12);
    org.jfree.data.xy.DefaultXYDataset defaultXYDataset15 = new org.jfree.data.xy.DefaultXYDataset();
    org.jfree.data.Range range16 = xYBarRenderer1.findDomainBounds((org.jfree.data.xy.XYDataset)defaultXYDataset15);
    boolean b18 = xYBarRenderer1.equals((java.lang.Object)"^2.0");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textAnchor13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == false);

  }

  @Test
  public void test310() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test310"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    java.awt.Font font32 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset33 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot34 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset33);
    org.jfree.chart.axis.ValueAxis valueAxis35 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot36 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis35);
    java.util.List list37 = combinedDomainXYPlot36.getAnnotations();
    waferMapPlot34.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot36);
    boolean b39 = combinedDomainXYPlot36.isNotify();
    org.jfree.chart.JFreeChart jFreeChart41 = new org.jfree.chart.JFreeChart("", font32, (org.jfree.chart.plot.Plot)combinedDomainXYPlot36, true);
    java.awt.Stroke stroke42 = jFreeChart41.getBorderStroke();
    boolean b43 = jFreeChart41.isBorderVisible();
    java.awt.Image image44 = null;
    jFreeChart41.setBackgroundImage(image44);
    org.jfree.chart.entity.JFreeChartEntity jFreeChartEntity47 = new org.jfree.chart.entity.JFreeChartEntity(shape7, jFreeChart41, "hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!");
    java.lang.Object obj48 = jFreeChartEntity47.clone();
    java.lang.Object obj49 = jFreeChartEntity47.clone();
    java.lang.String str50 = jFreeChartEntity47.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b43 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str50 + "' != '" + "JFreeChartEntity: tooltip = hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!"+ "'", str50.equals("JFreeChartEntity: tooltip = hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!"));

  }

  @Test
  public void test311() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test311"); }


    org.jfree.chart.plot.XYPlot xYPlot0 = new org.jfree.chart.plot.XYPlot();
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer2 = null;
    xYPlot0.setRenderer(31, xYItemRenderer2, false);
    org.jfree.chart.plot.Marker marker5 = null;
    org.jfree.chart.util.Layer layer6 = org.jfree.chart.util.Layer.BACKGROUND;
    // The following exception was thrown during execution in test generation
    try {
      xYPlot0.addDomainMarker(marker5, layer6);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(layer6);

  }

  @Test
  public void test312() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test312"); }


    java.awt.Shape shape7 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color9 = java.awt.Color.green;
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color17 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke18 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color19 = java.awt.Color.orange;
    java.awt.Stroke stroke20 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker22 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color17, stroke18, (java.awt.Paint)color19, stroke20, 0.0f);
    java.awt.Shape shape26 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke27 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color28 = java.awt.Color.green;
    java.lang.String str29 = org.jfree.chart.util.PaintUtilities.colorToString(color28);
    org.jfree.chart.LegendItem legendItem30 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape7, true, (java.awt.Paint)color9, false, (java.awt.Paint)color11, stroke18, true, shape26, stroke27, (java.awt.Paint)color28);
    boolean b31 = legendItem30.isShapeOutlineVisible();
    boolean b33 = legendItem30.equals((java.lang.Object)(short)1);
    java.lang.Object obj34 = legendItem30.clone();
    java.awt.Shape shape35 = legendItem30.getShape();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer37 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator38 = xYAreaRenderer37.getLegendItemToolTipGenerator();
    java.awt.Shape shape39 = xYAreaRenderer37.getBaseShape();
    java.awt.Shape shape42 = org.jfree.chart.util.ShapeUtilities.createTranslatedShape(shape39, 6.0d, 0.0d);
    legendItem30.setShape(shape39);
    int i44 = legendItem30.getDatasetIndex();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + "green"+ "'", str29.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i44 == 0);

  }

  @Test
  public void test313() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test313"); }


    org.jfree.data.xy.XYSeries xYSeries0 = null;
    org.jfree.data.xy.XYSeriesCollection xYSeriesCollection1 = new org.jfree.data.xy.XYSeriesCollection(xYSeries0);
    boolean b2 = xYSeriesCollection1.isAutoWidth();
    org.jfree.data.Range range4 = xYSeriesCollection1.getRangeBounds(true);
    xYSeriesCollection1.setIntervalWidth(1.0d);
    org.jfree.chart.axis.NumberAxis numberAxis7 = new org.jfree.chart.axis.NumberAxis();
    numberAxis7.centerRange(100.0d);
    java.lang.Object obj10 = numberAxis7.clone();
    org.jfree.chart.renderer.PolarItemRenderer polarItemRenderer11 = null;
    org.jfree.chart.plot.PolarPlot polarPlot12 = new org.jfree.chart.plot.PolarPlot((org.jfree.data.xy.XYDataset)xYSeriesCollection1, (org.jfree.chart.axis.ValueAxis)numberAxis7, polarItemRenderer11);
    org.jfree.chart.plot.PlotOrientation plotOrientation13 = polarPlot12.getOrientation();
    java.lang.Object obj14 = polarPlot12.clone();
    java.util.TimeZone timeZone16 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
    org.jfree.chart.axis.DateAxis dateAxis17 = new org.jfree.chart.axis.DateAxis("", timeZone16);
    org.jfree.data.time.DateRange dateRange20 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
    double d21 = dateRange20.getLength();
    long long22 = dateRange20.getLowerMillis();
    java.util.Date date23 = dateRange20.getLowerDate();
    java.util.Date date24 = dateRange20.getLowerDate();
    dateAxis17.setMaximumDate(date24);
    org.jfree.data.time.Year year26 = new org.jfree.data.time.Year(date24);
    boolean b27 = polarPlot12.equals((java.lang.Object)year26);
    org.jfree.data.general.DefaultPieDataset defaultPieDataset29 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj30 = defaultPieDataset29.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D31 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset29);
    piePlot3D31.setStartAngle(Double.NaN);
    org.jfree.data.general.DefaultPieDataset defaultPieDataset34 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj35 = defaultPieDataset34.clone();
    double d36 = org.jfree.data.general.DatasetUtilities.calculatePieDatasetTotal((org.jfree.data.general.PieDataset)defaultPieDataset34);
    piePlot3D31.setDataset((org.jfree.data.general.PieDataset)defaultPieDataset34);
    org.jfree.chart.util.Rotation rotation38 = piePlot3D31.getDirection();
    org.jfree.chart.plot.ValueMarker valueMarker40 = new org.jfree.chart.plot.ValueMarker(1.0d);
    double d41 = valueMarker40.getValue();
    java.awt.Color color47 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke48 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color49 = java.awt.Color.orange;
    java.awt.Stroke stroke50 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker52 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color47, stroke48, (java.awt.Paint)color49, stroke50, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer53 = null;
    intervalMarker52.setGradientPaintTransformer(gradientPaintTransformer53);
    org.jfree.chart.util.RectangleInsets rectangleInsets55 = intervalMarker52.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis57 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets58 = categoryAxis57.getLabelInsets();
    intervalMarker52.setLabelOffset(rectangleInsets58);
    double d60 = intervalMarker52.getEndValue();
    java.awt.Font font62 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset63 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot64 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset63);
    org.jfree.chart.axis.ValueAxis valueAxis65 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot66 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis65);
    java.util.List list67 = combinedDomainXYPlot66.getAnnotations();
    waferMapPlot64.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot66);
    boolean b69 = combinedDomainXYPlot66.isNotify();
    org.jfree.chart.JFreeChart jFreeChart71 = new org.jfree.chart.JFreeChart("", font62, (org.jfree.chart.plot.Plot)combinedDomainXYPlot66, true);
    intervalMarker52.setLabelFont(font62);
    valueMarker40.setLabelFont(font62);
    piePlot3D31.setLabelFont(font62);
    java.awt.Color color80 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke81 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color82 = java.awt.Color.orange;
    java.awt.Stroke stroke83 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker85 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color80, stroke81, (java.awt.Paint)color82, stroke83, 0.0f);
    org.jfree.chart.text.TextFragment textFragment87 = new org.jfree.chart.text.TextFragment("SerialDate.weekInMonthToString(): invalid code.", font62, (java.awt.Paint)color82, 0.0f);
    java.awt.Font font88 = textFragment87.getFont();
    polarPlot12.setAngleLabelFont(font88);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plotOrientation13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(timeZone16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d21 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long22 == (-1L));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(date23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(date24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d36 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rotation38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d41 == 1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d60 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b69 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke81);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke83);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font88);

  }

  @Test
  public void test314() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test314"); }


    // The following exception was thrown during execution in test generation
    try {
      java.util.ResourceBundle resourceBundle1 = java.util.ResourceBundle.getBundle("12");
      org.junit.Assert.fail("Expected exception of type java.util.MissingResourceException");
    } catch (java.util.MissingResourceException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.util.MissingResourceException")) {
        org.junit.Assert.fail("Expected exception of type java.util.MissingResourceException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test315() {}
// Defects4J: flaky method
//   @Test
//   public void test315() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test315"); }
// 
// 
//     org.jfree.chart.axis.SegmentedTimeline segmentedTimeline3 = new org.jfree.chart.axis.SegmentedTimeline(1L, 133, 7);
//     org.jfree.chart.axis.DateTickUnitType dateTickUnitType4 = org.jfree.chart.axis.DateTickUnitType.MINUTE;
//     org.jfree.chart.axis.DateTickUnitType dateTickUnitType6 = org.jfree.chart.axis.DateTickUnitType.MONTH;
//     org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer9 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
//     double d10 = xYBarRenderer9.getMargin();
//     boolean b11 = xYBarRenderer9.getAutoPopulateSeriesShape();
//     org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator13 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
//     xYBarRenderer9.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator13, true);
//     java.lang.Object obj16 = standardXYToolTipGenerator13.clone();
//     java.text.DateFormat dateFormat17 = standardXYToolTipGenerator13.getXDateFormat();
//     org.jfree.chart.axis.DateTickUnit dateTickUnit18 = new org.jfree.chart.axis.DateTickUnit(dateTickUnitType4, 5, dateTickUnitType6, 4, dateFormat17);
//     org.jfree.data.time.DateRange dateRange21 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d22 = dateRange21.getLength();
//     long long23 = dateRange21.getLowerMillis();
//     double d24 = dateRange21.getLength();
//     java.lang.String str25 = dateRange21.toString();
//     java.util.Date date26 = dateRange21.getUpperDate();
//     org.jfree.data.time.DateRange dateRange29 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d30 = dateRange29.getLength();
//     long long31 = dateRange29.getLowerMillis();
//     double d32 = dateRange29.getLength();
//     java.lang.String str33 = dateRange29.toString();
//     java.util.Date date34 = dateRange29.getUpperDate();
//     java.util.TimeZone timeZone35 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year36 = new org.jfree.data.time.Year(date34, timeZone35);
//     java.util.Date date37 = dateTickUnit18.rollDate(date26, timeZone35);
//     org.jfree.chart.axis.SegmentedTimeline.Segment segment38 = segmentedTimeline3.getSegment(date26);
//     java.lang.Object obj39 = segmentedTimeline3.clone();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateTickUnitType4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateTickUnitType6);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d10 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b11 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(standardXYToolTipGenerator13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj16);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(dateFormat17);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d22 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long23 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d24 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str25 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str25.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date26);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d30 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long31 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d32 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str33 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str33.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date34);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date37);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(segment38);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj39);
// 
//   }

  @Test
  public void test316() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test316"); }


    java.awt.Stroke stroke0 = null;
    java.io.ObjectOutputStream objectOutputStream1 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.util.SerialUtilities.writeStroke(stroke0, objectOutputStream1);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test317() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test317"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    xYAreaRenderer1.setSeriesCreateEntities(15, (java.lang.Boolean)true, true);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer7 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator8 = xYAreaRenderer7.getLegendItemToolTipGenerator();
    boolean b11 = xYAreaRenderer7.getItemVisible(10, 1);
    boolean b12 = xYAreaRenderer1.equals((java.lang.Object)xYAreaRenderer7);
    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer15 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    double d16 = xYBarRenderer15.getMargin();
    boolean b17 = xYBarRenderer15.getAutoPopulateSeriesShape();
    org.jfree.chart.labels.StandardXYToolTipGenerator standardXYToolTipGenerator19 = org.jfree.chart.labels.StandardXYToolTipGenerator.getTimeSeriesInstance();
    xYBarRenderer15.setSeriesToolTipGenerator(8, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator19, true);
    java.lang.Object obj22 = standardXYToolTipGenerator19.clone();
    java.text.DateFormat dateFormat23 = standardXYToolTipGenerator19.getXDateFormat();
    xYAreaRenderer7.setSeriesToolTipGenerator(10, (org.jfree.chart.labels.XYToolTipGenerator)standardXYToolTipGenerator19);
    java.text.DateFormat dateFormat25 = standardXYToolTipGenerator19.getXDateFormat();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d16 == 11.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(standardXYToolTipGenerator19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateFormat23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(dateFormat25);

  }

  @Test
  public void test318() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test318"); }


    java.awt.Font font2 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset3 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot4 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset3);
    org.jfree.chart.axis.ValueAxis valueAxis5 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot6 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis5);
    java.util.List list7 = combinedDomainXYPlot6.getAnnotations();
    waferMapPlot4.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot6);
    boolean b9 = combinedDomainXYPlot6.isNotify();
    org.jfree.chart.JFreeChart jFreeChart11 = new org.jfree.chart.JFreeChart("", font2, (org.jfree.chart.plot.Plot)combinedDomainXYPlot6, true);
    org.jfree.chart.title.TextTitle textTitle12 = new org.jfree.chart.title.TextTitle("", font2);
    textTitle12.setText("ClassContext");
    org.jfree.chart.block.BlockFrame blockFrame15 = textTitle12.getFrame();
    org.jfree.chart.util.VerticalAlignment verticalAlignment16 = org.jfree.chart.title.Title.DEFAULT_VERTICAL_ALIGNMENT;
    textTitle12.setVerticalAlignment(verticalAlignment16);
    org.jfree.chart.util.RectangleInsets rectangleInsets18 = textTitle12.getMargin();
    double d20 = rectangleInsets18.trimWidth(1.0E-100d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockFrame15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(verticalAlignment16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d20 == 1.0E-100d);

  }

  @Test
  public void test319() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test319"); }


    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot0 = new org.jfree.chart.plot.CombinedDomainXYPlot();
    org.jfree.chart.axis.NumberAxis numberAxis1 = new org.jfree.chart.axis.NumberAxis();
    numberAxis1.centerRange(100.0d);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer5 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator6 = xYAreaRenderer5.getLegendItemToolTipGenerator();
    java.awt.Shape shape7 = xYAreaRenderer5.getBaseShape();
    numberAxis1.setUpArrow(shape7);
    numberAxis1.pan((-1.0d));
    java.awt.Paint paint11 = numberAxis1.getAxisLinePaint();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer13 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator14 = xYAreaRenderer13.getLegendItemToolTipGenerator();
    java.awt.Shape shape15 = xYAreaRenderer13.getBaseShape();
    java.awt.Shape shape18 = org.jfree.chart.util.ShapeUtilities.createTranslatedShape(shape15, 6.0d, 0.0d);
    numberAxis1.setRightArrow(shape18);
    numberAxis1.configure();
    int i21 = combinedDomainXYPlot0.getRangeAxisIndex((org.jfree.chart.axis.ValueAxis)numberAxis1);
    numberAxis1.setRangeAboutValue(0.0d, 90.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i21 == (-1));

  }

  @Test
  public void test320() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test320"); }


    java.text.AttributedString attributedString0 = null;
    java.awt.Shape shape4 = null;
    java.awt.Font font6 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset7 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot8 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset7);
    org.jfree.chart.axis.ValueAxis valueAxis9 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot10 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis9);
    java.util.List list11 = combinedDomainXYPlot10.getAnnotations();
    waferMapPlot8.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot10);
    boolean b13 = combinedDomainXYPlot10.isNotify();
    org.jfree.chart.JFreeChart jFreeChart15 = new org.jfree.chart.JFreeChart("", font6, (org.jfree.chart.plot.Plot)combinedDomainXYPlot10, true);
    combinedDomainXYPlot10.setDomainCrosshairLockedOnData(true);
    org.jfree.chart.renderer.xy.XYItemRenderer xYItemRenderer18 = null;
    combinedDomainXYPlot10.setRenderer(xYItemRenderer18);
    org.jfree.chart.axis.AxisSpace axisSpace20 = combinedDomainXYPlot10.getFixedRangeAxisSpace();
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer22 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.plot.DrawingSupplier drawingSupplier23 = xYAreaRenderer22.getDrawingSupplier();
    java.awt.Stroke stroke24 = xYAreaRenderer22.getBaseStroke();
    combinedDomainXYPlot10.setDomainCrosshairStroke(stroke24);
    combinedDomainXYPlot10.setNotify(true);
    java.awt.Stroke stroke28 = combinedDomainXYPlot10.getDomainGridlineStroke();
    java.awt.Color color29 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    java.awt.Stroke stroke30 = org.jfree.chart.plot.CategoryPlot.DEFAULT_CROSSHAIR_STROKE;
    org.jfree.chart.util.RectangleInsets rectangleInsets31 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.chart.util.UnitType unitType32 = rectangleInsets31.getUnitType();
    double d34 = rectangleInsets31.calculateLeftOutset(0.0d);
    org.jfree.chart.block.LineBorder lineBorder35 = new org.jfree.chart.block.LineBorder((java.awt.Paint)color29, stroke30, rectangleInsets31);
    org.jfree.chart.plot.MultiplePiePlot multiplePiePlot36 = new org.jfree.chart.plot.MultiplePiePlot();
    boolean b37 = lineBorder35.equals((java.lang.Object)multiplePiePlot36);
    java.awt.Paint paint38 = lineBorder35.getPaint();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.LegendItem legendItem39 = new org.jfree.chart.LegendItem(attributedString0, "HorizontalAlignment.LEFT", "RectangleAnchor.LEFT?[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]=4&amp;{0}: ({1}, {2})=255", "?hi! version .\nhi!.\n\nFor terms of use, see the licence below.\n\nFURTHER INFORMATION:green\nCONTRIBUTORS:None\nOTHER LIBRARIES USED BY hi!:None\nhi! LICENCE TERMS:\nhi!=0&amp;=2958465", shape4, stroke28, paint38);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(axisSpace20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(drawingSupplier23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(unitType32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d34 == 8.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint38);

  }

  @Test
  public void test321() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test321"); }


    org.jfree.chart.axis.AxisState axisState1 = new org.jfree.chart.axis.AxisState(300000.0d);

  }

  @Test
  public void test322() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test322"); }


    org.jfree.chart.renderer.xy.XYBarRenderer xYBarRenderer5 = new org.jfree.chart.renderer.xy.XYBarRenderer(11.0d);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition6 = null;
    xYBarRenderer5.setNegativeItemLabelPositionFallback(itemLabelPosition6);
    java.awt.Shape shape9 = xYBarRenderer5.getSeriesShape(12);
    java.awt.Shape shape10 = xYBarRenderer5.getLegendBar();
    java.awt.Font font12 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset13 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot14 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset13);
    org.jfree.chart.axis.ValueAxis valueAxis15 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot16 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis15);
    java.util.List list17 = combinedDomainXYPlot16.getAnnotations();
    waferMapPlot14.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot16);
    boolean b19 = combinedDomainXYPlot16.isNotify();
    org.jfree.chart.JFreeChart jFreeChart21 = new org.jfree.chart.JFreeChart("", font12, (org.jfree.chart.plot.Plot)combinedDomainXYPlot16, true);
    java.awt.Color color28 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke29 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color30 = java.awt.Color.orange;
    java.awt.Stroke stroke31 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker33 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color28, stroke29, (java.awt.Paint)color30, stroke31, 0.0f);
    org.jfree.chart.util.Layer layer34 = null;
    boolean b36 = combinedDomainXYPlot16.removeDomainMarker(2, (org.jfree.chart.plot.Marker)intervalMarker33, layer34, false);
    org.jfree.chart.entity.PlotEntity plotEntity38 = new org.jfree.chart.entity.PlotEntity(shape10, (org.jfree.chart.plot.Plot)combinedDomainXYPlot16, "PlotEntity: tooltip = null");
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer39 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    boolean b40 = xYStepRenderer39.getUseFillPaint();
    xYStepRenderer39.setDrawSeriesLineAsPath(false);
    java.awt.Paint paint46 = xYStepRenderer39.getItemFillPaint(2, 8, false);
    java.awt.Stroke stroke47 = null;
    org.jfree.chart.block.LabelBlock labelBlock49 = new org.jfree.chart.block.LabelBlock("TextAnchor.CENTER");
    java.lang.String str50 = labelBlock49.getToolTipText();
    java.awt.Shape shape58 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color60 = java.awt.Color.green;
    java.awt.Color color62 = java.awt.Color.green;
    java.awt.Color color68 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke69 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color70 = java.awt.Color.orange;
    java.awt.Stroke stroke71 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker73 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color68, stroke69, (java.awt.Paint)color70, stroke71, 0.0f);
    java.awt.Shape shape77 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke78 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color79 = java.awt.Color.green;
    java.lang.String str80 = org.jfree.chart.util.PaintUtilities.colorToString(color79);
    org.jfree.chart.LegendItem legendItem81 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape58, true, (java.awt.Paint)color60, false, (java.awt.Paint)color62, stroke69, true, shape77, stroke78, (java.awt.Paint)color79);
    java.awt.Color color82 = color60.brighter();
    labelBlock49.setPaint((java.awt.Paint)color60);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.chart.LegendItem legendItem84 = new org.jfree.chart.LegendItem("", "^2.0", "Rotation.ANTICLOCKWISE", "", shape10, paint46, stroke47, (java.awt.Paint)color60);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(shape9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color68);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke78);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str80 + "' != '" + "green"+ "'", str80.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color82);

  }

  @Test
  public void test323() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test323"); }


    org.jfree.chart.plot.CrosshairState crosshairState0 = new org.jfree.chart.plot.CrosshairState();
    crosshairState0.updateCrosshairY((-1.0d), 14);
    crosshairState0.setAnchorY(0.2d);
    crosshairState0.setCrosshairX(0.025d);
    crosshairState0.setCrosshairX(0.0d);

  }

  @Test
  public void test324() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test324"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.axis.ValueAxis valueAxis2 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot3 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis2);
    java.util.List list4 = combinedDomainXYPlot3.getAnnotations();
    waferMapPlot1.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot3);
    int i6 = combinedDomainXYPlot3.getSeriesCount();
    boolean b8 = combinedDomainXYPlot3.equals((java.lang.Object)10.0d);
    java.awt.Color color15 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke16 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color17 = java.awt.Color.orange;
    java.awt.Stroke stroke18 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker20 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color15, stroke16, (java.awt.Paint)color17, stroke18, 0.0f);
    java.awt.Paint paint21 = intervalMarker20.getOutlinePaint();
    org.jfree.chart.util.Layer layer22 = null;
    boolean b24 = combinedDomainXYPlot3.removeRangeMarker(1, (org.jfree.chart.plot.Marker)intervalMarker20, layer22, false);
    org.jfree.chart.axis.NumberAxis numberAxis26 = new org.jfree.chart.axis.NumberAxis();
    numberAxis26.centerRange(100.0d);
    float f29 = numberAxis26.getTickMarkInsideLength();
    numberAxis26.setUpperBound(0.0d);
    double d32 = numberAxis26.getLabelAngle();
    combinedDomainXYPlot3.setDomainAxis(6, (org.jfree.chart.axis.ValueAxis)numberAxis26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f29 == 0.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d32 == 0.0d);

  }

  @Test
  public void test325() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test325"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedRangeXYPlot combinedRangeXYPlot1 = new org.jfree.chart.plot.CombinedRangeXYPlot(valueAxis0);
    java.lang.String str2 = combinedRangeXYPlot1.getPlotType();
    org.jfree.chart.axis.ValueAxis valueAxis3 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot4 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis3);
    org.jfree.chart.plot.Plot plot5 = combinedDomainXYPlot4.getRootPlot();
    org.jfree.chart.LegendItemCollection legendItemCollection6 = null;
    combinedDomainXYPlot4.setFixedLegendItems(legendItemCollection6);
    org.jfree.chart.event.PlotChangeEvent plotChangeEvent8 = null;
    combinedDomainXYPlot4.notifyListeners(plotChangeEvent8);
    combinedDomainXYPlot4.setDomainMinorGridlinesVisible(true);
    combinedRangeXYPlot1.remove((org.jfree.chart.plot.XYPlot)combinedDomainXYPlot4);
    org.jfree.chart.LegendItemCollection legendItemCollection13 = combinedRangeXYPlot1.getLegendItems();
    org.jfree.chart.event.PlotChangeEvent plotChangeEvent14 = null;
    combinedRangeXYPlot1.plotChanged(plotChangeEvent14);
    java.awt.Paint paint16 = combinedRangeXYPlot1.getBackgroundPaint();
    org.jfree.data.general.WaferMapDataset waferMapDataset17 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot18 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset17);
    org.jfree.chart.axis.ValueAxis valueAxis19 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot20 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis19);
    java.util.List list21 = combinedDomainXYPlot20.getAnnotations();
    waferMapPlot18.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot20);
    boolean b23 = combinedDomainXYPlot20.isRangeCrosshairVisible();
    org.jfree.chart.renderer.category.BarRenderer barRenderer24 = new org.jfree.chart.renderer.category.BarRenderer();
    double d25 = barRenderer24.getShadowXOffset();
    barRenderer24.setShadowXOffset(10.0d);
    boolean b28 = barRenderer24.getIncludeBaseInRange();
    java.awt.Graphics2D graphics2D29 = null;
    java.awt.geom.Rectangle2D rectangle2D30 = null;
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D32 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    org.jfree.chart.axis.NumberAxis3D numberAxis3D33 = new org.jfree.chart.axis.NumberAxis3D();
    java.awt.Paint paint34 = org.jfree.chart.axis.Axis.DEFAULT_AXIS_LINE_PAINT;
    numberAxis3D33.setLabelPaint(paint34);
    numberAxis3D33.setTickMarksVisible(true);
    org.jfree.chart.util.Layer layer38 = org.jfree.chart.util.Layer.FOREGROUND;
    org.jfree.chart.plot.CategoryPlot categoryPlot39 = new org.jfree.chart.plot.CategoryPlot();
    boolean b40 = categoryPlot39.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge42 = categoryPlot39.getDomainAxisEdge(8);
    org.jfree.chart.axis.CategoryAxis categoryAxis44 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets45 = categoryAxis44.getLabelInsets();
    double d47 = rectangleInsets45.calculateLeftInset(4.0d);
    categoryPlot39.setInsets(rectangleInsets45, false);
    int i50 = categoryPlot39.getRendererCount();
    org.jfree.chart.axis.NumberAxis numberAxis51 = new org.jfree.chart.axis.NumberAxis();
    numberAxis51.centerRange(100.0d);
    java.awt.Paint paint54 = numberAxis51.getLabelPaint();
    categoryPlot39.setRangeCrosshairPaint(paint54);
    org.jfree.chart.entity.EntityCollection entityCollection57 = null;
    org.jfree.chart.ChartRenderingInfo chartRenderingInfo58 = new org.jfree.chart.ChartRenderingInfo(entityCollection57);
    org.jfree.chart.plot.PlotRenderingInfo plotRenderingInfo59 = new org.jfree.chart.plot.PlotRenderingInfo(chartRenderingInfo58);
    java.awt.geom.Point2D point2D60 = null;
    categoryPlot39.panRangeAxes(0.6d, plotRenderingInfo59, point2D60);
    barRenderer24.drawAnnotations(graphics2D29, rectangle2D30, (org.jfree.chart.axis.CategoryAxis)categoryAxis3D32, (org.jfree.chart.axis.ValueAxis)numberAxis3D33, layer38, plotRenderingInfo59);
    int i63 = combinedDomainXYPlot20.getRangeAxisIndex((org.jfree.chart.axis.ValueAxis)numberAxis3D33);
    org.jfree.data.Range range64 = combinedRangeXYPlot1.getDataRange((org.jfree.chart.axis.ValueAxis)numberAxis3D33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str2 + "' != '" + "Combined Range XYPlot"+ "'", str2.equals("Combined Range XYPlot"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(plot5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(legendItemCollection13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d25 == 4.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(layer38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d47 == 3.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i50 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i63 == (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(range64);

  }

  @Test
  public void test326() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test326"); }


    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer1 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition3 = xYAreaRenderer1.getSeriesNegativeItemLabelPosition(1);
    org.jfree.chart.plot.CategoryPlot categoryPlot4 = new org.jfree.chart.plot.CategoryPlot();
    boolean b5 = categoryPlot4.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge7 = categoryPlot4.getDomainAxisEdge(8);
    java.awt.Color color14 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke15 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color16 = java.awt.Color.orange;
    java.awt.Stroke stroke17 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker19 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color14, stroke15, (java.awt.Paint)color16, stroke17, 0.0f);
    org.jfree.chart.util.GradientPaintTransformer gradientPaintTransformer20 = null;
    intervalMarker19.setGradientPaintTransformer(gradientPaintTransformer20);
    org.jfree.chart.util.RectangleInsets rectangleInsets22 = intervalMarker19.getLabelOffset();
    org.jfree.chart.axis.CategoryAxis categoryAxis24 = new org.jfree.chart.axis.CategoryAxis("");
    org.jfree.chart.util.RectangleInsets rectangleInsets25 = categoryAxis24.getLabelInsets();
    intervalMarker19.setLabelOffset(rectangleInsets25);
    double d27 = intervalMarker19.getEndValue();
    org.jfree.chart.util.Layer layer28 = null;
    boolean b29 = categoryPlot4.removeRangeMarker(4, (org.jfree.chart.plot.Marker)intervalMarker19, layer28);
    xYAreaRenderer1.removeChangeListener((org.jfree.chart.event.RendererChangeListener)categoryPlot4);
    org.jfree.chart.axis.ValueAxis valueAxis32 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot33 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis32);
    java.util.List list34 = combinedDomainXYPlot33.getAnnotations();
    combinedDomainXYPlot33.setRangeGridlinesVisible(true);
    java.awt.Color color37 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    combinedDomainXYPlot33.setRangeTickBandPaint((java.awt.Paint)color37);
    org.jfree.chart.renderer.xy.XYAreaRenderer xYAreaRenderer40 = new org.jfree.chart.renderer.xy.XYAreaRenderer(8);
    org.jfree.chart.labels.XYSeriesLabelGenerator xYSeriesLabelGenerator41 = xYAreaRenderer40.getLegendItemToolTipGenerator();
    boolean b44 = xYAreaRenderer40.getItemVisible(10, 1);
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition48 = xYAreaRenderer40.getPositiveItemLabelPosition(8, 10, false);
    java.lang.Boolean b50 = xYAreaRenderer40.getSeriesCreateEntities(10);
    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator52 = xYAreaRenderer40.getSeriesToolTipGenerator(3);
    java.awt.Font font54 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset55 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot56 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset55);
    org.jfree.chart.axis.ValueAxis valueAxis57 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot58 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis57);
    java.util.List list59 = combinedDomainXYPlot58.getAnnotations();
    waferMapPlot56.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot58);
    boolean b61 = combinedDomainXYPlot58.isNotify();
    org.jfree.chart.JFreeChart jFreeChart63 = new org.jfree.chart.JFreeChart("", font54, (org.jfree.chart.plot.Plot)combinedDomainXYPlot58, true);
    xYAreaRenderer40.setBaseLegendTextFont(font54);
    combinedDomainXYPlot33.setNoDataMessageFont(font54);
    xYAreaRenderer1.setSeriesItemLabelFont(10, font54, false);
    org.jfree.chart.annotations.XYAnnotation xYAnnotation68 = null;
    org.jfree.chart.util.Layer layer69 = org.jfree.chart.util.Layer.BACKGROUND;
    // The following exception was thrown during execution in test generation
    try {
      xYAreaRenderer1.addAnnotation(xYAnnotation68, layer69);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYSeriesLabelGenerator41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYToolTipGenerator52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b61 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(layer69);

  }

  @Test
  public void test327() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test327"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    org.jfree.data.time.TimeSeries timeSeries11 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection12 = new org.jfree.data.time.TimeSeriesCollection(timeSeries11);
    timeSeriesCollection12.validateObject();
    java.lang.Comparable comparable14 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer15 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.data.general.Dataset)timeSeriesCollection12, comparable14);
    java.util.List list16 = timeSeriesCollection12.getSeries();
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.TimeSeries timeSeries18 = timeSeriesCollection12.getSeries(100);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list16);

  }

  @Test
  public void test328() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test328"); }


    org.jfree.data.general.WaferMapDataset waferMapDataset0 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot1 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset0);
    org.jfree.chart.JFreeChart jFreeChart2 = null;
    org.jfree.chart.event.ChartChangeEvent chartChangeEvent3 = new org.jfree.chart.event.ChartChangeEvent((java.lang.Object)waferMapPlot1, jFreeChart2);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment4 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment5 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement8 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment4, verticalAlignment5, 11.0d, 0.2d);
    org.jfree.chart.block.BorderArrangement borderArrangement9 = new org.jfree.chart.block.BorderArrangement();
    org.jfree.chart.title.LegendTitle legendTitle10 = new org.jfree.chart.title.LegendTitle((org.jfree.chart.LegendItemSource)waferMapPlot1, (org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.chart.block.Arrangement)borderArrangement9);
    org.jfree.data.time.TimeSeries timeSeries11 = null;
    org.jfree.data.time.TimeSeriesCollection timeSeriesCollection12 = new org.jfree.data.time.TimeSeriesCollection(timeSeries11);
    timeSeriesCollection12.validateObject();
    java.lang.Comparable comparable14 = null;
    org.jfree.chart.title.LegendItemBlockContainer legendItemBlockContainer15 = new org.jfree.chart.title.LegendItemBlockContainer((org.jfree.chart.block.Arrangement)flowArrangement8, (org.jfree.data.general.Dataset)timeSeriesCollection12, comparable14);
    java.util.List list16 = timeSeriesCollection12.getSeries();
    org.jfree.data.xy.IntervalXYDelegate intervalXYDelegate17 = new org.jfree.data.xy.IntervalXYDelegate((org.jfree.data.xy.XYDataset)timeSeriesCollection12);
    // The following exception was thrown during execution in test generation
    try {
      org.jfree.data.time.TimeSeries timeSeries19 = timeSeriesCollection12.getSeries(15);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list16);

  }

  @Test
  public void test329() {}
// Defects4J: flaky method
//   @Test
//   public void test329() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test329"); }
// 
// 
//     org.jfree.data.DefaultKeyedValues defaultKeyedValues0 = new org.jfree.data.DefaultKeyedValues();
//     org.jfree.data.time.DateRange dateRange3 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d4 = dateRange3.getLength();
//     long long5 = dateRange3.getLowerMillis();
//     double d6 = dateRange3.getLength();
//     java.lang.String str7 = dateRange3.toString();
//     java.util.Date date8 = dateRange3.getUpperDate();
//     org.jfree.data.time.SerialDate serialDate9 = org.jfree.data.time.SerialDate.createInstance(date8);
//     org.jfree.data.time.Month month10 = new org.jfree.data.time.Month(date8);
//     defaultKeyedValues0.setValue((java.lang.Comparable)month10, 90.0d);
//     int i14 = defaultKeyedValues0.getIndex((java.lang.Comparable)0);
//     int i15 = defaultKeyedValues0.getItemCount();
//     org.jfree.data.time.Month month16 = new org.jfree.data.time.Month();
//     int i17 = month16.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem19 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month16, 11.0d);
//     timeSeriesDataItem19.setSelected(true);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod22 = timeSeriesDataItem19.getPeriod();
//     boolean b23 = timeSeriesDataItem19.isSelected();
//     int i24 = defaultKeyedValues0.getIndex((java.lang.Comparable)b23);
//     // The following exception was thrown during execution in test generation
//     try {
//       defaultKeyedValues0.removeValue((java.lang.Comparable)2016);
//       org.junit.Assert.fail("Expected exception of type org.jfree.data.UnknownKeyException");
//     } catch (org.jfree.data.UnknownKeyException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.jfree.data.UnknownKeyException")) {
//         org.junit.Assert.fail("Expected exception of type org.jfree.data.UnknownKeyException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d4 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d6 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str7 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str7.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(serialDate9);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i14 == (-1));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i15 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i17 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b23 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i24 == (-1));
// 
//   }

  @Test
  public void test330() {}
// Defects4J: flaky method
//   @Test
//   public void test330() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test330"); }
// 
// 
//     java.awt.Shape shape0 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_SHAPE;
//     org.jfree.chart.entity.LegendItemEntity legendItemEntity1 = new org.jfree.chart.entity.LegendItemEntity(shape0);
//     java.lang.Object obj2 = legendItemEntity1.clone();
//     org.jfree.data.general.DefaultPieDataset defaultPieDataset3 = new org.jfree.data.general.DefaultPieDataset();
//     java.lang.Object obj4 = defaultPieDataset3.clone();
//     defaultPieDataset3.clear();
//     legendItemEntity1.setDataset((org.jfree.data.general.Dataset)defaultPieDataset3);
//     java.lang.Comparable comparable7 = legendItemEntity1.getSeriesKey();
//     org.jfree.chart.block.ColumnArrangement columnArrangement8 = new org.jfree.chart.block.ColumnArrangement();
//     org.jfree.chart.plot.CategoryPlot categoryPlot9 = new org.jfree.chart.plot.CategoryPlot();
//     boolean b10 = categoryPlot9.isRangeZoomable();
//     org.jfree.chart.axis.CategoryAxis categoryAxis11 = categoryPlot9.getDomainAxis();
//     boolean b12 = columnArrangement8.equals((java.lang.Object)categoryAxis11);
//     org.jfree.data.time.DateRange dateRange15 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d16 = dateRange15.getLength();
//     long long17 = dateRange15.getLowerMillis();
//     double d18 = dateRange15.getLength();
//     java.lang.String str19 = dateRange15.toString();
//     java.util.Date date20 = dateRange15.getUpperDate();
//     java.util.TimeZone timeZone21 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year22 = new org.jfree.data.time.Year(date20, timeZone21);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod23 = year22.next();
//     long long24 = year22.getFirstMillisecond();
//     boolean b25 = columnArrangement8.equals((java.lang.Object)year22);
//     legendItemEntity1.setSeriesKey((java.lang.Comparable)year22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(shape0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(obj4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(comparable7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b10 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(categoryAxis11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b12 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d16 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long17 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d18 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str19 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str19.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date20);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone21);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod23);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long24 == (-31507200000L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b25 == false);
// 
//   }

  @Test
  public void test331() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test331"); }


    org.jfree.chart.labels.XYToolTipGenerator xYToolTipGenerator1 = null;
    org.jfree.chart.urls.StandardXYURLGenerator standardXYURLGenerator3 = new org.jfree.chart.urls.StandardXYURLGenerator("");
    org.jfree.chart.renderer.xy.XYStepAreaRenderer xYStepAreaRenderer4 = new org.jfree.chart.renderer.xy.XYStepAreaRenderer(100, xYToolTipGenerator1, (org.jfree.chart.urls.XYURLGenerator)standardXYURLGenerator3);
    xYStepAreaRenderer4.setPlotArea(true);
    org.jfree.chart.annotations.XYAnnotation xYAnnotation7 = null;
    boolean b8 = xYStepAreaRenderer4.removeAnnotation(xYAnnotation7);
    boolean b9 = xYStepAreaRenderer4.isShapesFilled();
    xYStepAreaRenderer4.setSeriesVisible(1, (java.lang.Boolean)true, true);
    org.jfree.chart.labels.XYItemLabelGenerator xYItemLabelGenerator15 = xYStepAreaRenderer4.getSeriesItemLabelGenerator(7);
    java.awt.Paint paint17 = xYStepAreaRenderer4.getLegendTextPaint(3);
    java.awt.Paint paint19 = xYStepAreaRenderer4.lookupSeriesFillPaint(40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(xYItemLabelGenerator15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(paint17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint19);

  }

  @Test
  public void test332() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test332"); }


    org.jfree.chart.LegendItem legendItem1 = new org.jfree.chart.LegendItem("item");

  }

  @Test
  public void test333() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test333"); }


    org.jfree.chart.axis.NumberAxis3D numberAxis3D0 = new org.jfree.chart.axis.NumberAxis3D();
    numberAxis3D0.setRange(Double.NaN, 1.0d);
    numberAxis3D0.setFixedAutoRange(2.0d);
    org.jfree.data.general.SeriesChangeInfo seriesChangeInfo6 = null;
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent7 = new org.jfree.data.general.SeriesChangeEvent((java.lang.Object)numberAxis3D0, seriesChangeInfo6);
    boolean b8 = numberAxis3D0.isTickLabelsVisible();
    java.awt.Font font13 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset14 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot15 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset14);
    org.jfree.chart.axis.ValueAxis valueAxis16 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot17 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis16);
    java.util.List list18 = combinedDomainXYPlot17.getAnnotations();
    waferMapPlot15.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot17);
    org.jfree.chart.JFreeChart jFreeChart21 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font13, (org.jfree.chart.plot.Plot)combinedDomainXYPlot17, true);
    java.awt.Color color25 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment26 = new org.jfree.chart.text.TextFragment("hi!", font13, (java.awt.Paint)color25);
    java.awt.Paint paint27 = org.jfree.chart.plot.PiePlot.DEFAULT_LABEL_OUTLINE_PAINT;
    org.jfree.chart.plot.CategoryPlot categoryPlot28 = new org.jfree.chart.plot.CategoryPlot();
    boolean b29 = categoryPlot28.isRangeZoomable();
    org.jfree.chart.util.RectangleEdge rectangleEdge31 = categoryPlot28.getDomainAxisEdge(8);
    org.jfree.chart.util.HorizontalAlignment horizontalAlignment32 = org.jfree.chart.util.HorizontalAlignment.LEFT;
    org.jfree.chart.util.VerticalAlignment verticalAlignment33 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement36 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment32, verticalAlignment33, 11.0d, 0.2d);
    org.jfree.chart.util.VerticalAlignment verticalAlignment37 = null;
    org.jfree.chart.block.FlowArrangement flowArrangement40 = new org.jfree.chart.block.FlowArrangement(horizontalAlignment32, verticalAlignment37, (-1.0d), Double.NaN);
    org.jfree.chart.util.VerticalAlignment verticalAlignment41 = org.jfree.chart.title.Title.DEFAULT_VERTICAL_ALIGNMENT;
    org.jfree.chart.util.RectangleInsets rectangleInsets42 = org.jfree.chart.plot.Plot.DEFAULT_INSETS;
    org.jfree.data.general.SeriesChangeEvent seriesChangeEvent43 = new org.jfree.data.general.SeriesChangeEvent((java.lang.Object)rectangleInsets42);
    org.jfree.chart.title.TextTitle textTitle44 = new org.jfree.chart.title.TextTitle("March", font13, paint27, rectangleEdge31, horizontalAlignment32, verticalAlignment41, rectangleInsets42);
    org.jfree.chart.axis.CategoryAxis3D categoryAxis3D46 = new org.jfree.chart.axis.CategoryAxis3D("PieLabelLinkStyle.STANDARD");
    java.awt.Stroke stroke47 = categoryAxis3D46.getTickMarkStroke();
    org.jfree.chart.plot.ValueMarker valueMarker48 = new org.jfree.chart.plot.ValueMarker(7.0d, paint27, stroke47);
    numberAxis3D0.setTickLabelPaint(paint27);
    org.jfree.chart.axis.NumberTickUnit numberTickUnit51 = new org.jfree.chart.axis.NumberTickUnit(100.0d);
    numberAxis3D0.setTickUnit(numberTickUnit51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleEdge31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(horizontalAlignment32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(verticalAlignment41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rectangleInsets42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke47);

  }

  @Test
  public void test334() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test334"); }


    org.jfree.chart.axis.NumberTickUnit numberTickUnit1 = new org.jfree.chart.axis.NumberTickUnit(6.0d);
    org.jfree.chart.renderer.xy.XYStepRenderer xYStepRenderer2 = new org.jfree.chart.renderer.xy.XYStepRenderer();
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition4 = xYStepRenderer2.getSeriesPositiveItemLabelPosition(3);
    java.lang.Boolean b6 = xYStepRenderer2.getSeriesLinesVisible(0);
    boolean b7 = numberTickUnit1.equals((java.lang.Object)b6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelPosition4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(b6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);

  }

  @Test
  public void test335() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test335"); }


    org.jfree.data.general.DefaultPieDataset defaultPieDataset0 = new org.jfree.data.general.DefaultPieDataset();
    java.lang.Object obj1 = defaultPieDataset0.clone();
    org.jfree.chart.plot.PiePlot3D piePlot3D2 = new org.jfree.chart.plot.PiePlot3D((org.jfree.data.general.PieDataset)defaultPieDataset0);
    java.awt.Paint paint3 = piePlot3D2.getLabelShadowPaint();
    piePlot3D2.setLabelLinksVisible(false);
    piePlot3D2.setLabelLinkMargin(0.05d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint3);

  }

  @Test
  public void test336() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test336"); }


    org.jfree.chart.util.ObjectList objectList0 = new org.jfree.chart.util.ObjectList();
    java.awt.Color color2 = org.jfree.chart.ChartColor.LIGHT_YELLOW;
    objectList0.set(2016, (java.lang.Object)color2);
    int i4 = color2.getTransparency();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 1);

  }

  @Test
  public void test337() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test337"); }


    org.jfree.chart.StandardChartTheme standardChartTheme1 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    java.awt.Shape shape9 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Color color11 = java.awt.Color.green;
    java.awt.Color color13 = java.awt.Color.green;
    java.awt.Color color19 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke20 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color21 = java.awt.Color.orange;
    java.awt.Stroke stroke22 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker24 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color19, stroke20, (java.awt.Paint)color21, stroke22, 0.0f);
    java.awt.Shape shape28 = org.jfree.chart.util.ShapeUtilities.createDiagonalCross(0.0f, 1.0f);
    java.awt.Stroke stroke29 = org.jfree.chart.renderer.AbstractRenderer.DEFAULT_STROKE;
    java.awt.Color color30 = java.awt.Color.green;
    java.lang.String str31 = org.jfree.chart.util.PaintUtilities.colorToString(color30);
    org.jfree.chart.LegendItem legendItem32 = new org.jfree.chart.LegendItem("", "^2.0", "^2.0", "", false, shape9, true, (java.awt.Paint)color11, false, (java.awt.Paint)color13, stroke20, true, shape28, stroke29, (java.awt.Paint)color30);
    standardChartTheme1.setCrosshairPaint((java.awt.Paint)color11);
    java.awt.Paint paint34 = standardChartTheme1.getPlotBackgroundPaint();
    java.awt.Paint paint35 = standardChartTheme1.getBaselinePaint();
    org.jfree.chart.StandardChartTheme standardChartTheme37 = new org.jfree.chart.StandardChartTheme("DateTickMarkPosition.END");
    org.jfree.chart.renderer.category.BarPainter barPainter38 = standardChartTheme37.getBarPainter();
    java.awt.Font font39 = standardChartTheme37.getLargeFont();
    java.awt.Font font42 = org.jfree.chart.title.LegendTitle.DEFAULT_ITEM_FONT;
    org.jfree.data.general.WaferMapDataset waferMapDataset43 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot44 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset43);
    org.jfree.chart.axis.ValueAxis valueAxis45 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot46 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis45);
    java.util.List list47 = combinedDomainXYPlot46.getAnnotations();
    waferMapPlot44.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot46);
    org.jfree.chart.JFreeChart jFreeChart50 = new org.jfree.chart.JFreeChart("TextBlockAnchor.BOTTOM_RIGHT", font42, (org.jfree.chart.plot.Plot)combinedDomainXYPlot46, true);
    java.awt.Color color54 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    org.jfree.chart.text.TextFragment textFragment55 = new org.jfree.chart.text.TextFragment("hi!", font42, (java.awt.Paint)color54);
    standardChartTheme37.setDomainGridlinePaint((java.awt.Paint)color54);
    java.awt.Font font57 = standardChartTheme37.getRegularFont();
    standardChartTheme1.setLargeFont(font57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(shape28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str31 + "' != '" + "green"+ "'", str31.equals("green"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(paint35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(barPainter38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(font57);

  }

  @Test
  public void test338() {}
// Defects4J: flaky method
//   @Test
//   public void test338() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test338"); }
// 
// 
//     org.jfree.data.time.Month month3 = new org.jfree.data.time.Month();
//     int i4 = month3.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem6 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month3, (java.lang.Number)8);
//     long long7 = month3.getFirstMillisecond();
//     org.jfree.data.time.Month month8 = new org.jfree.data.time.Month();
//     int i9 = month8.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis10 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month3, (org.jfree.data.time.RegularTimePeriod)month8);
//     float f11 = periodAxis10.getMinorTickMarkInsideLength();
//     java.util.TimeZone timeZone12 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.TimeSeriesCollection timeSeriesCollection13 = new org.jfree.data.time.TimeSeriesCollection(timeZone12);
//     periodAxis10.setTimeZone(timeZone12);
//     org.jfree.data.time.Month month16 = new org.jfree.data.time.Month();
//     int i17 = month16.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem19 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month16, (java.lang.Number)8);
//     long long20 = month16.getFirstMillisecond();
//     org.jfree.data.time.Month month21 = new org.jfree.data.time.Month();
//     int i22 = month21.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis23 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month16, (org.jfree.data.time.RegularTimePeriod)month21);
//     float f24 = periodAxis23.getMinorTickMarkInsideLength();
//     java.util.Locale locale25 = periodAxis23.getLocale();
//     org.jfree.chart.axis.DateAxis dateAxis26 = new org.jfree.chart.axis.DateAxis("", timeZone12, locale25);
//     // The following exception was thrown during execution in test generation
//     try {
//       java.util.ResourceBundle resourceBundle27 = org.jfree.chart.util.ResourceBundleWrapper.getBundle("pink", locale25);
//       org.junit.Assert.fail("Expected exception of type java.util.MissingResourceException");
//     } catch (java.util.MissingResourceException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.util.MissingResourceException")) {
//         org.junit.Assert.fail("Expected exception of type java.util.MissingResourceException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i4 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long7 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i9 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f11 == 0.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i17 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long20 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i22 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f24 == 0.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(locale25);
// 
//   }

  @Test
  public void test339() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test339"); }


    org.jfree.data.RangeType rangeType0 = org.jfree.data.RangeType.FULL;
    java.lang.String str1 = rangeType0.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(rangeType0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "RangeType.FULL"+ "'", str1.equals("RangeType.FULL"));

  }

  @Test
  public void test340() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test340"); }


    java.awt.Color color5 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke6 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color7 = java.awt.Color.orange;
    java.awt.Stroke stroke8 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker10 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color5, stroke6, (java.awt.Paint)color7, stroke8, 0.0f);
    java.awt.Color color11 = color7.brighter();
    int i12 = color7.getAlpha();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(stroke8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(color11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i12 == 255);

  }

  @Test
  public void test341() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test341"); }


    // The following exception was thrown during execution in test generation
    try {
      java.lang.String str1 = org.jfree.data.time.SerialDate.weekdayCodeToString((-25560));
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test342() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test342"); }


    java.lang.String str0 = org.jfree.chart.labels.StandardXYSeriesLabelGenerator.DEFAULT_LABEL_FORMAT;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str0 + "' != '" + "{0}"+ "'", str0.equals("{0}"));

  }

  @Test
  public void test343() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test343"); }


    org.jfree.data.xy.XYSeries xYSeries1 = new org.jfree.data.xy.XYSeries((java.lang.Comparable)(-1.0f));
    xYSeries1.add(12.0d, (-1.0d), true);
    boolean b6 = xYSeries1.getAutoSort();
    xYSeries1.setDescription("?series=64&amp;item=12");
    java.util.List list9 = xYSeries1.getItems();
    java.lang.Object obj10 = xYSeries1.clone();
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number12 = xYSeries1.getY(2016);
      org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException");
    } catch (java.lang.IndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj10);

  }

  @Test
  public void test344() {}
// Defects4J: flaky method
//   @Test
//   public void test344() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest3.test344"); }
// 
// 
//     org.jfree.data.time.Year year3 = new org.jfree.data.time.Year(3);
//     org.jfree.data.xy.DefaultXYDataset defaultXYDataset4 = new org.jfree.data.xy.DefaultXYDataset();
//     org.jfree.chart.util.PaintMap paintMap5 = new org.jfree.chart.util.PaintMap();
//     org.jfree.data.time.DateRange dateRange8 = new org.jfree.data.time.DateRange((-1.0d), 10.0d);
//     double d9 = dateRange8.getLength();
//     long long10 = dateRange8.getLowerMillis();
//     double d11 = dateRange8.getLength();
//     java.lang.String str12 = dateRange8.toString();
//     java.util.Date date13 = dateRange8.getUpperDate();
//     java.util.TimeZone timeZone14 = org.jfree.chart.axis.SegmentedTimeline.DEFAULT_TIME_ZONE;
//     org.jfree.data.time.Year year15 = new org.jfree.data.time.Year(date13, timeZone14);
//     org.jfree.data.time.RegularTimePeriod regularTimePeriod16 = year15.next();
//     java.awt.Paint paint17 = paintMap5.getPaint((java.lang.Comparable)year15);
//     int i18 = defaultXYDataset4.indexOf((java.lang.Comparable)year15);
//     java.util.TimeZone timeZone19 = org.jfree.chart.axis.SegmentedTimeline.NO_DST_TIME_ZONE;
//     org.jfree.data.time.Month month21 = new org.jfree.data.time.Month();
//     int i22 = month21.getMonth();
//     org.jfree.data.time.TimeSeriesDataItem timeSeriesDataItem24 = new org.jfree.data.time.TimeSeriesDataItem((org.jfree.data.time.RegularTimePeriod)month21, (java.lang.Number)8);
//     long long25 = month21.getFirstMillisecond();
//     org.jfree.data.time.Month month26 = new org.jfree.data.time.Month();
//     int i27 = month26.getMonth();
//     org.jfree.chart.axis.PeriodAxis periodAxis28 = new org.jfree.chart.axis.PeriodAxis("TitleEntity: tooltip = green", (org.jfree.data.time.RegularTimePeriod)month21, (org.jfree.data.time.RegularTimePeriod)month26);
//     float f29 = periodAxis28.getMinorTickMarkInsideLength();
//     java.util.Locale locale30 = periodAxis28.getLocale();
//     java.text.NumberFormat numberFormat31 = java.text.NumberFormat.getInstance(locale30);
//     org.jfree.chart.axis.PeriodAxis periodAxis32 = new org.jfree.chart.axis.PeriodAxis("Feb", (org.jfree.data.time.RegularTimePeriod)year3, (org.jfree.data.time.RegularTimePeriod)year15, timeZone19, locale30);
//     java.text.NumberFormat numberFormat33 = java.text.NumberFormat.getIntegerInstance(locale30);
//     org.jfree.chart.labels.StandardPieSectionLabelGenerator standardPieSectionLabelGenerator34 = new org.jfree.chart.labels.StandardPieSectionLabelGenerator(locale30);
//     org.jfree.chart.labels.StandardPieSectionLabelGenerator standardPieSectionLabelGenerator35 = new org.jfree.chart.labels.StandardPieSectionLabelGenerator("VerticalAlignment.CENTER", locale30);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d9 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long10 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d11 == 11.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str12 + "' != '" + "[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"+ "'", str12.equals("[31-Dec-1969 15:59:59 --> 31-Dec-1969 16:00:00]"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(date13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(regularTimePeriod16);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(paint17);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i18 == (-1));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(timeZone19);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i22 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long25 == 1454313600000L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i27 == 2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f29 == 0.0f);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(locale30);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(numberFormat31);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(numberFormat33);
// 
//   }

  @Test
  public void test345() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test345"); }


    org.jfree.chart.labels.ItemLabelAnchor itemLabelAnchor0 = org.jfree.chart.labels.ItemLabelAnchor.OUTSIDE7;
    org.jfree.chart.text.TextAnchor textAnchor1 = org.jfree.chart.text.TextAnchor.HALF_ASCENT_RIGHT;
    org.jfree.chart.labels.ItemLabelPosition itemLabelPosition2 = new org.jfree.chart.labels.ItemLabelPosition(itemLabelAnchor0, textAnchor1);
    org.jfree.chart.labels.ItemLabelAnchor itemLabelAnchor3 = itemLabelPosition2.getItemLabelAnchor();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelAnchor0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(textAnchor1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(itemLabelAnchor3);

  }

  @Test
  public void test346() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test346"); }


    org.jfree.chart.axis.ValueAxis valueAxis0 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot1 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis0);
    java.util.List list2 = combinedDomainXYPlot1.getAnnotations();
    combinedDomainXYPlot1.setRangeGridlinesVisible(true);
    org.jfree.chart.axis.ValueAxis valueAxis6 = null;
    combinedDomainXYPlot1.setRangeAxis(100, valueAxis6, false);
    org.jfree.chart.axis.NumberAxis numberAxis9 = new org.jfree.chart.axis.NumberAxis();
    numberAxis9.centerRange(100.0d);
    combinedDomainXYPlot1.setRangeAxis((org.jfree.chart.axis.ValueAxis)numberAxis9);
    boolean b13 = numberAxis9.isNegativeArrowVisible();
    // The following exception was thrown during execution in test generation
    try {
      numberAxis9.setRangeWithMargins(6.0d, 1.0E-5d);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);

  }

  @Test
  public void test347() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest3.test347"); }


    org.jfree.chart.axis.CategoryAxis categoryAxis0 = new org.jfree.chart.axis.CategoryAxis();
    org.jfree.data.general.WaferMapDataset waferMapDataset1 = null;
    org.jfree.chart.plot.WaferMapPlot waferMapPlot2 = new org.jfree.chart.plot.WaferMapPlot(waferMapDataset1);
    org.jfree.chart.axis.ValueAxis valueAxis3 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot4 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis3);
    java.util.List list5 = combinedDomainXYPlot4.getAnnotations();
    waferMapPlot2.setParent((org.jfree.chart.plot.Plot)combinedDomainXYPlot4);
    int i7 = combinedDomainXYPlot4.getSeriesCount();
    categoryAxis0.addChangeListener((org.jfree.chart.event.AxisChangeListener)combinedDomainXYPlot4);
    java.awt.Color color15 = java.awt.Color.getHSBColor((-1.0f), 10.0f, 100.0f);
    java.awt.Stroke stroke16 = org.jfree.chart.plot.CategoryPlot.DEFAULT_GRIDLINE_STROKE;
    java.awt.Color color17 = java.awt.Color.orange;
    java.awt.Stroke stroke18 = org.jfree.chart.axis.Axis.DEFAULT_TICK_MARK_STROKE;
    org.jfree.chart.plot.IntervalMarker intervalMarker20 = new org.jfree.chart.plot.IntervalMarker((-1.0d), 0.0d, (java.awt.Paint)color15, stroke16, (java.awt.Paint)color17, stroke18, 0.0f);
    java.awt.Paint paint21 = intervalMarker20.getOutlinePaint();
    org.jfree.chart.util.Layer layer22 = null;
    combinedDomainXYPlot4.addRangeMarker(0, (org.jfree.chart.plot.Marker)intervalMarker20, layer22);
    org.jfree.chart.axis.AxisLocation axisLocation24 = combinedDomainXYPlot4.getDomainAxisLocation();
    java.awt.Color color25 = java.awt.Color.RED;
    combinedDomainXYPlot4.setDomainTickBandPaint((java.awt.Paint)color25);
    org.jfree.chart.LegendItemCollection legendItemCollection27 = combinedDomainXYPlot4.getLegendItems();
    org.jfree.chart.axis.AxisLocation axisLocation28 = org.jfree.chart.axis.AxisLocation.TOP_OR_RIGHT;
    org.jfree.chart.axis.AxisLocation axisLocation29 = axisLocation28.getOpposite();
    combinedDomainXYPlot4.setRangeAxisLocation(axisLocation29, true);
    org.jfree.chart.axis.ValueAxis valueAxis32 = null;
    org.jfree.chart.plot.CombinedDomainXYPlot combinedDomainXYPlot33 = new org.jfree.chart.plot.CombinedDomainXYPlot(valueAxis32);
    org.jfree.chart.plot.PlotOrientation plotOrientation34 = combinedDomainXYPlot33.getOrientation();
    boolean b35 = combinedDomainXYPlot33.isDomainCrosshairLockedO