
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class RegressionTest5 {

  public static boolean debug = false;

  @Test
  public void test001() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test001"); }


    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.rhino.EcmaError ecmaError2 = com.google.javascript.rhino.ScriptRuntime.typeError1("empty", "function ({proxy:{1404434850}}): {proxy:{1823794890}}");
      org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException");
    } catch (java.lang.RuntimeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.RuntimeException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test002() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test002"); }


    com.google.javascript.rhino.EcmaError ecmaError6 = com.google.javascript.rhino.ScriptRuntime.constructError("OFF", "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "", 131, "JSC_NODE_TRAVERSAL_ERROR. {0} at Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n line (unknown line) : (unknown column)", 16);
    int i7 = ecmaError6.columnNumber();
    int i8 = ecmaError6.getLineNumber();
    int i9 = ecmaError6.lineNumber();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ecmaError6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i8 == 131);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i9 == 131);

  }

  @Test
  public void test003() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test003"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.gatherCssNames;
    com.google.javascript.jscomp.VariableRenamingPolicy variableRenamingPolicy2 = compilerOptions0.variableRenaming;
    compilerOptions0.exportTestFunctions = true;
    boolean b5 = compilerOptions0.instrumentForCoverage;
    java.lang.String str6 = compilerOptions0.aliasStringsBlacklist;
    compilerOptions0.checkDuplicateMessages = false;
    compilerOptions0.checkSymbols = false;
    compilerOptions0.jsOutputFile = "{0}";
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(variableRenamingPolicy2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + ""+ "'", str6.equals(""));

  }

  @Test
  public void test004() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test004"); }


    com.google.javascript.rhino.JSDocInfo jSDocInfo0 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str1 = jSDocInfo0.getTemplateTypeName();
    boolean b2 = jSDocInfo0.isExterns();
    boolean b3 = jSDocInfo0.shouldPreserveTry();
    com.google.javascript.rhino.JSDocInfo.Visibility visibility4 = com.google.javascript.rhino.JSDocInfo.Visibility.INHERITED;
    jSDocInfo0.setVisibility(visibility4);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression6 = jSDocInfo0.getType();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression8 = jSDocInfo0.getParameterType("JSC_NODE_TRAVERSAL_ERROR. {0} at Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n line (unknown line) : (unknown column)");
    boolean b9 = jSDocInfo0.isExport();
    java.lang.String str10 = jSDocInfo0.getLicense();
    java.lang.String str11 = jSDocInfo0.getTemplateTypeName();
    boolean b12 = jSDocInfo0.isConstructor();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(visibility4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSTypeExpression6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSTypeExpression8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);

  }

  @Test
  public void test005() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test005"); }


    com.google.javascript.rhino.Node node1 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    com.google.javascript.rhino.Node node2 = node1.getLastChild();
    com.google.javascript.rhino.Node node5 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable6 = node5.getAncestors();
    com.google.javascript.rhino.Node node8 = new com.google.javascript.rhino.Node(0);
    boolean b9 = node5.hasChild(node8);
    com.google.javascript.rhino.Node node11 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str12 = node8.checkTreeEquals(node11);
    com.google.javascript.rhino.Node node13 = node11.cloneNode();
    com.google.javascript.rhino.Node node15 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node node17 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable18 = node17.getAncestors();
    com.google.javascript.rhino.Node node20 = new com.google.javascript.rhino.Node(0);
    boolean b21 = node17.hasChild(node20);
    com.google.javascript.rhino.Node node23 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str24 = node20.checkTreeEquals(node23);
    com.google.javascript.rhino.Node node25 = node15.copyInformationFromForTree(node20);
    com.google.javascript.rhino.Node node28 = new com.google.javascript.rhino.Node(9, node11, node15, 29, 10);
    node15.setOptionalArg(false);
    com.google.javascript.rhino.Node node31 = node2.copyInformationFromForTree(node15);
    boolean b32 = node31.wasEmptyNode();
    com.google.javascript.rhino.ScriptOrFnNode scriptOrFnNode36 = new com.google.javascript.rhino.ScriptOrFnNode(0, 91, 18);
    com.google.javascript.rhino.Node node39 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable40 = node39.getAncestors();
    com.google.javascript.rhino.Node node42 = new com.google.javascript.rhino.Node(0);
    boolean b43 = node39.hasChild(node42);
    com.google.javascript.rhino.Node node45 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str46 = node42.checkTreeEquals(node45);
    com.google.javascript.rhino.FunctionNode functionNode50 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.Node node52 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable53 = node52.getAncestors();
    com.google.javascript.rhino.Node node55 = new com.google.javascript.rhino.Node(0);
    boolean b56 = node52.hasChild(node55);
    node52.putBooleanProp(83, false);
    functionNode50.addChildrenToBack(node52);
    boolean b61 = node42.checkTreeTypeAwareEqualsSilent(node52);
    com.google.javascript.jscomp.CheckLevel checkLevel62 = com.google.javascript.jscomp.CheckLevel.OFF;
    com.google.javascript.jscomp.DiagnosticType diagnosticType63 = com.google.javascript.jscomp.NodeTraversal.NODE_TRAVERSAL_ERROR;
    com.google.javascript.rhino.FunctionNode functionNode65 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String[] str_array66 = functionNode65.getParamAndVarNames();
    com.google.javascript.jscomp.JSError jSError67 = com.google.javascript.jscomp.JSError.make("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", node42, checkLevel62, diagnosticType63, str_array66);
    boolean b68 = scriptOrFnNode36.checkTreeEqualsSilent(node42);
    boolean b69 = node31.isEquivalentTo(node42);
    // The following exception was thrown during execution in test generation
    try {
      double d70 = node31.getDouble();
      org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException");
    } catch (java.lang.UnsupportedOperationException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.UnsupportedOperationException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str12.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b21 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str24 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str24.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b43 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str46 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str46.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b56 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b61 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b68 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b69 == false);

  }

  @Test
  public void test006() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test006"); }


    com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler1 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState2 = compiler1.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter4 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler1, true);
    com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list7 = jSModule6.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback8 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler1, list7, callback8);
    com.google.javascript.jscomp.ErrorManager errorManager10 = compiler1.getErrorManager();
    com.google.javascript.jscomp.SourceFile.Generator generator12 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile13 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator12);
    com.google.javascript.jscomp.JSSourceFile[] jSSourceFile_array14 = new com.google.javascript.jscomp.JSSourceFile[] { jSSourceFile13 };
    com.google.javascript.jscomp.SourceFile.Generator generator16 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile17 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator16);
    com.google.javascript.jscomp.JsAst jsAst18 = new com.google.javascript.jscomp.JsAst((com.google.javascript.jscomp.SourceFile)jSSourceFile17);
    com.google.javascript.jscomp.JSSourceFile[] jSSourceFile_array19 = new com.google.javascript.jscomp.JSSourceFile[] { jSSourceFile17 };
    com.google.javascript.jscomp.CompilerOptions compilerOptions20 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions20.collapseVariableDeclarations = true;
    com.google.javascript.jscomp.Result result23 = compiler1.compile(jSSourceFile_array14, jSSourceFile_array19, compilerOptions20);
    compilerOptions20.renamePrefix = "OFF: Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n";
    compilerOptions20.inlineLocalVariables = true;
    com.google.javascript.jscomp.CheckLevel checkLevel28 = compilerOptions20.checkMissingGetCssNameLevel;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorManager10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(result23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel28);

  }

  @Test
  public void test007() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test007"); }


    com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler1 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState2 = compiler1.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter4 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler1, true);
    com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list7 = jSModule6.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback8 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler1, list7, callback8);
    com.google.javascript.jscomp.ErrorManager errorManager10 = compiler1.getErrorManager();
    com.google.javascript.jscomp.NodeTraversal.Callback callback11 = null;
    com.google.javascript.jscomp.NodeTraversal nodeTraversal12 = new com.google.javascript.jscomp.NodeTraversal((com.google.javascript.jscomp.AbstractCompiler)compiler1, callback11);
    com.google.javascript.jscomp.ErrorFormat errorFormat13 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler14 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState15 = compiler14.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter17 = errorFormat13.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler14, true);
    com.google.javascript.jscomp.JSModule jSModule19 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list20 = jSModule19.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback21 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler14, list20, callback21);
    com.google.javascript.jscomp.ErrorFormat errorFormat23 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler24 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState25 = compiler24.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter27 = errorFormat23.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler24, true);
    com.google.javascript.jscomp.JSModule jSModule29 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list30 = jSModule29.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback31 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler24, list30, callback31);
    com.google.javascript.jscomp.JSModuleGraph jSModuleGraph33 = new com.google.javascript.jscomp.JSModuleGraph(list30);
    com.google.javascript.jscomp.CompilerOptions compilerOptions34 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b35 = compilerOptions34.smartNameRemoval;
    compilerOptions34.groupVariableDeclarations = false;
    compiler1.initModules(list20, list30, compilerOptions34);
    com.google.javascript.jscomp.CheckLevel checkLevel39 = compilerOptions34.checkMissingGetCssNameLevel;
    compilerOptions34.skipAllCompilerPasses();
    boolean b41 = compilerOptions34.smartNameRemoval;
    com.google.javascript.jscomp.VariableRenamingPolicy variableRenamingPolicy42 = compilerOptions34.variableRenaming;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorManager10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(variableRenamingPolicy42);

  }

  @Test
  public void test008() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test008"); }


    com.google.javascript.jscomp.SourceFile sourceFile1 = com.google.javascript.jscomp.SourceFile.fromFile("language version");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(sourceFile1);

  }

  @Test
  public void test009() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test009"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.jstype.JSType jSType24 = functionType23.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter26 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry27 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter26);
    jSTypeRegistry27.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter30 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry31 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter30);
    com.google.javascript.rhino.jstype.StaticScope staticScope32 = null;
    com.google.javascript.rhino.jstype.JSType jSType37 = jSTypeRegistry31.getForgivingType(staticScope32, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array46 = new com.google.javascript.rhino.jstype.JSType[] { jSType45 };
    com.google.javascript.rhino.jstype.FunctionType functionType47 = jSTypeRegistry27.createFunctionType(jSType37, jSType_array46);
    com.google.javascript.rhino.jstype.FunctionType functionType48 = jSTypeRegistry1.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType23, false, jSType_array46);
    java.util.List list49 = functionType23.getSubTypes();
    com.google.javascript.rhino.JSDocInfo jSDocInfo50 = functionType23.getJSDocInfo();
    com.google.javascript.rhino.ErrorReporter errorReporter51 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry52 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter51);
    com.google.javascript.rhino.ErrorReporter errorReporter53 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry54 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter53);
    jSTypeRegistry54.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter57 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry58 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter57);
    com.google.javascript.rhino.jstype.StaticScope staticScope59 = null;
    com.google.javascript.rhino.jstype.JSType jSType64 = jSTypeRegistry58.getForgivingType(staticScope59, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter65 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry66 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter65);
    com.google.javascript.rhino.jstype.StaticScope staticScope67 = null;
    com.google.javascript.rhino.jstype.JSType jSType72 = jSTypeRegistry66.getForgivingType(staticScope67, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array73 = new com.google.javascript.rhino.jstype.JSType[] { jSType72 };
    com.google.javascript.rhino.jstype.FunctionType functionType74 = jSTypeRegistry54.createFunctionType(jSType64, jSType_array73);
    com.google.javascript.rhino.Node node76 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable77 = node76.getAncestors();
    java.lang.String str78 = node76.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType79 = jSTypeRegistry52.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType74, node76);
    com.google.javascript.rhino.jstype.JSType jSType80 = functionType79.getParameterType();
    com.google.javascript.rhino.jstype.JSType.TypePair typePair81 = functionType23.getTypesUnderShallowInequality((com.google.javascript.rhino.jstype.JSType)functionType79);
    boolean b82 = functionType23.isRegexpType();
    boolean b83 = functionType23.isReturnTypeInferred();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType84 = functionType23.getPrototype();
    boolean b85 = functionType23.isBooleanValueType();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(list49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSDocInfo50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array73);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType74);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str78 + "' != '" + "EOF"+ "'", str78.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(typePair81);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b82 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b83 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b85 == false);

  }

  @Test
  public void test010() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test010"); }


    com.google.javascript.rhino.JSDocInfo jSDocInfo0 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str1 = jSDocInfo0.getTemplateTypeName();
    boolean b2 = jSDocInfo0.isExterns();
    java.util.List list3 = jSDocInfo0.getThrownTypes();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression4 = jSDocInfo0.getTypedefType();
    boolean b5 = jSDocInfo0.containsDeclaration();
    java.lang.String str6 = jSDocInfo0.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSTypeExpression4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "JSDocInfo"+ "'", str6.equals("JSDocInfo"));

  }

  @Test
  public void test011() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test011"); }


    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.rhino.EcmaError ecmaError1 = com.google.javascript.rhino.ScriptRuntime.typeError0("LEGACY");
      org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException");
    } catch (java.lang.RuntimeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.RuntimeException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test012() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test012"); }


    com.google.javascript.jscomp.DefaultCodingConvention defaultCodingConvention0 = new com.google.javascript.jscomp.DefaultCodingConvention();
    java.lang.String str1 = defaultCodingConvention0.getDelegateSuperclassName();
    com.google.javascript.rhino.Node node3 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable4 = node3.getAncestors();
    com.google.javascript.rhino.Node node6 = new com.google.javascript.rhino.Node(0);
    boolean b7 = node3.hasChild(node6);
    com.google.javascript.rhino.Node node9 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str10 = node6.checkTreeEquals(node9);
    com.google.javascript.rhino.Node node11 = node9.cloneNode();
    boolean b12 = node11.hasSideEffects();
    java.lang.String str13 = defaultCodingConvention0.getSingletonGetterClassName(node11);
    com.google.javascript.rhino.FunctionNode functionNode18 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.Node node20 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable21 = node20.getAncestors();
    com.google.javascript.rhino.Node node23 = new com.google.javascript.rhino.Node(0);
    boolean b24 = node20.hasChild(node23);
    node20.putBooleanProp(83, false);
    functionNode18.addChildrenToBack(node20);
    int i29 = functionNode18.getFunctionType();
    com.google.javascript.jscomp.CompilerOptions compilerOptions30 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b31 = compilerOptions30.gatherCssNames;
    java.lang.String str32 = compilerOptions30.aliasableGlobals;
    boolean b33 = compilerOptions30.removeDeadCode;
    compilerOptions30.setLooseTypes(false);
    boolean b36 = compilerOptions30.markNoSideEffectCalls;
    com.google.javascript.jscomp.CheckLevel checkLevel37 = com.google.javascript.jscomp.CheckLevel.ERROR;
    compilerOptions30.brokenClosureRequiresLevel = checkLevel37;
    com.google.javascript.jscomp.DiagnosticType diagnosticType41 = com.google.javascript.jscomp.DiagnosticType.disabled("", "hi!");
    com.google.javascript.rhino.FunctionNode functionNode43 = new com.google.javascript.rhino.FunctionNode("");
    int i44 = functionNode43.getFunctionType();
    com.google.javascript.rhino.ErrorReporter errorReporter45 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry46 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter45);
    jSTypeRegistry46.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter49 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry50 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter49);
    com.google.javascript.rhino.jstype.StaticScope staticScope51 = null;
    com.google.javascript.rhino.jstype.JSType jSType56 = jSTypeRegistry50.getForgivingType(staticScope51, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter57 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry58 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter57);
    com.google.javascript.rhino.jstype.StaticScope staticScope59 = null;
    com.google.javascript.rhino.jstype.JSType jSType64 = jSTypeRegistry58.getForgivingType(staticScope59, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array65 = new com.google.javascript.rhino.jstype.JSType[] { jSType64 };
    com.google.javascript.rhino.jstype.FunctionType functionType66 = jSTypeRegistry46.createFunctionType(jSType56, jSType_array65);
    boolean b67 = functionType66.isConstructor();
    functionNode43.setJSType((com.google.javascript.rhino.jstype.JSType)functionType66);
    java.lang.String[] str_array69 = functionNode43.getParamAndVarNames();
    com.google.javascript.jscomp.JSError jSError70 = com.google.javascript.jscomp.JSError.make("EOF", (com.google.javascript.rhino.Node)functionNode18, checkLevel37, diagnosticType41, str_array69);
    com.google.javascript.jscomp.CodingConvention.DelegateRelationship delegateRelationship71 = defaultCodingConvention0.getDelegateRelationship((com.google.javascript.rhino.Node)functionNode18);
    java.lang.String str72 = defaultCodingConvention0.getExportPropertyFunction();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str10 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str10.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i29 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i44 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b67 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(delegateRelationship71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str72);

  }

  @Test
  public void test013() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test013"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter4 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry5 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter4);
    com.google.javascript.rhino.jstype.StaticScope staticScope6 = null;
    com.google.javascript.rhino.jstype.JSType jSType11 = jSTypeRegistry5.getForgivingType(staticScope6, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter12 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry13 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter12);
    com.google.javascript.rhino.jstype.StaticScope staticScope14 = null;
    com.google.javascript.rhino.jstype.JSType jSType19 = jSTypeRegistry13.getForgivingType(staticScope14, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array20 = new com.google.javascript.rhino.jstype.JSType[] { jSType19 };
    com.google.javascript.rhino.jstype.FunctionType functionType21 = jSTypeRegistry1.createFunctionType(jSType11, jSType_array20);
    java.lang.String str22 = functionType21.getReferenceName();
    com.google.javascript.rhino.jstype.JSType jSType23 = functionType21.unboxesTo();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType23);

  }

  @Test
  public void test014() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test014"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    compilerOptions0.setDefineToBooleanLiteral("hi!", false);
    boolean b8 = compilerOptions0.instrumentForCoverage;
    compilerOptions0.collapseAnonymousFunctions = false;
    boolean b11 = compilerOptions0.checkSymbols;
    java.lang.String str12 = compilerOptions0.renamePrefix;
    com.google.javascript.jscomp.CompilerOptions compilerOptions13 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b14 = compilerOptions13.gatherCssNames;
    java.lang.String str15 = compilerOptions13.aliasableGlobals;
    com.google.javascript.jscomp.CheckLevel checkLevel16 = compilerOptions13.checkShadowVars;
    compilerOptions0.checkGlobalThisLevel = checkLevel16;
    com.google.common.collect.Multimap multimap18 = null;
    compilerOptions0.customPasses = multimap18;
    compilerOptions0.checkMissingGetCssNameBlacklist = "";
    java.util.Map map22 = compilerOptions0.getDefineReplacements();
    compilerOptions0.extractPrototypeMemberDeclarations = false;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(map22);

  }

  @Test
  public void test015() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test015"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b3 = jSDocInfoBuilder1.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression4 = null;
    boolean b5 = jSDocInfoBuilder1.recordReturnType(jSTypeExpression4);
    boolean b6 = jSDocInfoBuilder1.recordHiddenness();
    boolean b7 = jSDocInfoBuilder1.recordConstructor();
    boolean b9 = jSDocInfoBuilder1.recordReturnDescription("Not declared as a type name");
    com.google.javascript.rhino.JSDocInfo jSDocInfo11 = jSDocInfoBuilder1.build("// Input %num%");
    boolean b12 = jSDocInfo11.containsDeclaration();
    java.lang.String str13 = jSDocInfo11.getReturnDescription();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSDocInfo11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str13 + "' != '" + "Not declared as a type name"+ "'", str13.equals("Not declared as a type name"));

  }

  @Test
  public void test016() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test016"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    jSTypeRegistry1.setTemplateTypeName("EOF");
    com.google.javascript.rhino.jstype.JSType jSType10 = jSTypeRegistry1.createNamedType("", "EOF", 105, 126);
    com.google.javascript.rhino.ErrorReporter errorReporter11 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry12 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter11);
    com.google.javascript.rhino.jstype.StaticScope staticScope13 = null;
    com.google.javascript.rhino.jstype.JSType jSType18 = jSTypeRegistry12.getForgivingType(staticScope13, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter19 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry20 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter19);
    com.google.javascript.rhino.jstype.StaticScope staticScope21 = null;
    com.google.javascript.rhino.jstype.JSType jSType26 = jSTypeRegistry20.getForgivingType(staticScope21, "hi!", "", 0, 1);
    boolean b27 = jSType26.isEnumType();
    boolean b28 = jSType26.isResolved();
    boolean b29 = jSType18.differsFrom(jSType26);
    boolean b30 = jSType26.isTemplateType();
    com.google.javascript.jscomp.JSModule jSModule32 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list33 = jSModule32.getDependencies();
    com.google.javascript.rhino.jstype.FunctionType functionType34 = jSTypeRegistry1.createFunctionType(jSType26, list33);
    boolean b36 = functionType34.isPropertyInExterns("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n");
    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.rhino.jstype.ObjectType objectType37 = functionType34.getInstanceType();
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalStateException");
    } catch (java.lang.IllegalStateException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalStateException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalStateException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);

  }

  @Test
  public void test017() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test017"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.jstype.StaticScope staticScope2 = null;
    com.google.javascript.rhino.jstype.JSType jSType7 = jSTypeRegistry1.getForgivingType(staticScope2, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter8 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry9 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter8);
    com.google.javascript.rhino.ErrorReporter errorReporter10 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry11 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter10);
    jSTypeRegistry11.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter22 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry23 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter22);
    com.google.javascript.rhino.jstype.StaticScope staticScope24 = null;
    com.google.javascript.rhino.jstype.JSType jSType29 = jSTypeRegistry23.getForgivingType(staticScope24, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array30 = new com.google.javascript.rhino.jstype.JSType[] { jSType29 };
    com.google.javascript.rhino.jstype.FunctionType functionType31 = jSTypeRegistry11.createFunctionType(jSType21, jSType_array30);
    com.google.javascript.rhino.jstype.JSType jSType32 = functionType31.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter34 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry35 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter34);
    jSTypeRegistry35.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter46 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry47 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter46);
    com.google.javascript.rhino.jstype.StaticScope staticScope48 = null;
    com.google.javascript.rhino.jstype.JSType jSType53 = jSTypeRegistry47.getForgivingType(staticScope48, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array54 = new com.google.javascript.rhino.jstype.JSType[] { jSType53 };
    com.google.javascript.rhino.jstype.FunctionType functionType55 = jSTypeRegistry35.createFunctionType(jSType45, jSType_array54);
    com.google.javascript.rhino.jstype.FunctionType functionType56 = jSTypeRegistry9.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType31, false, jSType_array54);
    com.google.javascript.rhino.ErrorReporter errorReporter57 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry58 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter57);
    com.google.javascript.rhino.ErrorReporter errorReporter59 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry60 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter59);
    jSTypeRegistry60.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter71 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry72 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter71);
    com.google.javascript.rhino.jstype.StaticScope staticScope73 = null;
    com.google.javascript.rhino.jstype.JSType jSType78 = jSTypeRegistry72.getForgivingType(staticScope73, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array79 = new com.google.javascript.rhino.jstype.JSType[] { jSType78 };
    com.google.javascript.rhino.jstype.FunctionType functionType80 = jSTypeRegistry60.createFunctionType(jSType70, jSType_array79);
    com.google.javascript.rhino.Node node82 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable83 = node82.getAncestors();
    java.lang.String str84 = node82.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType85 = jSTypeRegistry58.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType80, node82);
    com.google.javascript.rhino.jstype.JSType jSType87 = jSTypeRegistry9.getGreatestSubtypeWithProperty((com.google.javascript.rhino.jstype.JSType)functionType80, "EOF");
    com.google.javascript.rhino.jstype.JSType jSType88 = jSTypeRegistry1.createDefaultObjectUnion((com.google.javascript.rhino.jstype.JSType)functionType80);
    boolean b89 = functionType80.isReturnTypeInferred();
    com.google.javascript.rhino.JSDocInfo jSDocInfo90 = functionType80.getJSDocInfo();
    boolean b91 = functionType80.isUnionType();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType78);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable83);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str84 + "' != '" + "EOF"+ "'", str84.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType87);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType88);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b89 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSDocInfo90);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b91 == false);

  }

  @Test
  public void test018() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test018"); }


    com.google.javascript.rhino.Node node1 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable2 = node1.getAncestors();
    boolean b3 = node1.isUnscopedQualifiedName();
    com.google.javascript.rhino.jstype.JSType jSType4 = node1.getJSType();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType4);

  }

  @Test
  public void test019() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test019"); }


    com.google.javascript.rhino.JSDocInfo jSDocInfo0 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str1 = jSDocInfo0.getTemplateTypeName();
    boolean b2 = jSDocInfo0.isExterns();
    java.lang.String str3 = jSDocInfo0.getLicense();
    boolean b5 = jSDocInfo0.hasParameterType("EOF");
    boolean b6 = jSDocInfo0.isDefine();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);

  }

  @Test
  public void test020() {}
// Defects4J: flaky method
//   @Test
//   public void test020() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test020"); }
// 
// 
//     com.google.javascript.rhino.Context context0 = null;
//     com.google.javascript.rhino.Context context1 = com.google.javascript.rhino.Context.enter(context0);
//     context1.removeActivationName("OFF");
//     int i4 = context1.getLanguageVersion();
//     boolean b5 = context1.hasCompileFunctionsWithDynamicScope();
//     com.google.javascript.rhino.Node node8 = new com.google.javascript.rhino.Node(0);
//     com.google.javascript.rhino.Node.AncestorIterable ancestorIterable9 = node8.getAncestors();
//     com.google.javascript.rhino.Node node11 = new com.google.javascript.rhino.Node(0);
//     boolean b12 = node8.hasChild(node11);
//     com.google.javascript.rhino.Node node14 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
//     java.lang.String str15 = node11.checkTreeEquals(node14);
//     com.google.javascript.rhino.FunctionNode functionNode19 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
//     com.google.javascript.rhino.Node node21 = new com.google.javascript.rhino.Node(0);
//     com.google.javascript.rhino.Node.AncestorIterable ancestorIterable22 = node21.getAncestors();
//     com.google.javascript.rhino.Node node24 = new com.google.javascript.rhino.Node(0);
//     boolean b25 = node21.hasChild(node24);
//     node21.putBooleanProp(83, false);
//     functionNode19.addChildrenToBack(node21);
//     boolean b30 = node11.checkTreeTypeAwareEqualsSilent(node21);
//     com.google.javascript.jscomp.CheckLevel checkLevel31 = com.google.javascript.jscomp.CheckLevel.OFF;
//     com.google.javascript.jscomp.DiagnosticType diagnosticType32 = com.google.javascript.jscomp.NodeTraversal.NODE_TRAVERSAL_ERROR;
//     com.google.javascript.rhino.FunctionNode functionNode34 = new com.google.javascript.rhino.FunctionNode("");
//     java.lang.String[] str_array35 = functionNode34.getParamAndVarNames();
//     com.google.javascript.jscomp.JSError jSError36 = com.google.javascript.jscomp.JSError.make("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", node11, checkLevel31, diagnosticType32, str_array35);
//     context1.seal((java.lang.Object)checkLevel31);
//     com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
//     com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
//     com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
//     java.lang.Object obj46 = context1.getThreadLocal((java.lang.Object)0);
//     boolean b48 = context1.isActivationNeeded("window");
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(context1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i4 == 0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b5 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(ancestorIterable9);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b12 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(node14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str15 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str15.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(ancestorIterable22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b25 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b30 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(checkLevel31);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(diagnosticType32);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(str_array35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSError36);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType45);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(obj46);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b48 == false);
// 
//   }

  @Test
  public void test021() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test021"); }


    com.google.javascript.rhino.FunctionNode functionNode3 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.Node node5 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable6 = node5.getAncestors();
    com.google.javascript.rhino.Node node8 = new com.google.javascript.rhino.Node(0);
    boolean b9 = node5.hasChild(node8);
    node5.putBooleanProp(83, false);
    functionNode3.addChildrenToBack(node5);
    boolean b14 = functionNode3.hasOneChild();
    com.google.javascript.rhino.ErrorReporter errorReporter15 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry16 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter15);
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry16.createNamedType("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "", 301, 71);
    java.lang.RuntimeException runtimeException22 = com.google.javascript.rhino.ScriptRuntime.undefReadError((java.lang.Object)functionNode3, (java.lang.Object)jSType21);
    com.google.javascript.rhino.EcmaError ecmaError29 = com.google.javascript.rhino.ScriptRuntime.constructError("<No stack trace available>", "<No stack trace available>", "EOF", 52, "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 27);
    java.lang.String str30 = ecmaError29.details();
    runtimeException22.addSuppressed((java.lang.Throwable)ecmaError29);
    int i32 = ecmaError29.getColumnNumber();
    int i33 = ecmaError29.lineNumber();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(runtimeException22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ecmaError29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str30 + "' != '" + "<No stack trace available>: <No stack trace available>"+ "'", str30.equals("<No stack trace available>: <No stack trace available>"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i32 == 27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i33 == 52);

  }

  @Test
  public void test022() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test022"); }


    com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler1 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState2 = compiler1.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter4 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler1, true);
    com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list7 = jSModule6.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback8 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler1, list7, callback8);
    com.google.javascript.jscomp.ErrorManager errorManager10 = compiler1.getErrorManager();
    com.google.javascript.jscomp.SourceFile.Generator generator12 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile13 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator12);
    com.google.javascript.jscomp.JSSourceFile[] jSSourceFile_array14 = new com.google.javascript.jscomp.JSSourceFile[] { jSSourceFile13 };
    com.google.javascript.jscomp.SourceFile.Generator generator16 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile17 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator16);
    com.google.javascript.jscomp.JsAst jsAst18 = new com.google.javascript.jscomp.JsAst((com.google.javascript.jscomp.SourceFile)jSSourceFile17);
    com.google.javascript.jscomp.JSSourceFile[] jSSourceFile_array19 = new com.google.javascript.jscomp.JSSourceFile[] { jSSourceFile17 };
    com.google.javascript.jscomp.CompilerOptions compilerOptions20 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions20.collapseVariableDeclarations = true;
    com.google.javascript.jscomp.Result result23 = compiler1.compile(jSSourceFile_array14, jSSourceFile_array19, compilerOptions20);
    compilerOptions20.coalesceVariableNames = true;
    boolean b26 = compilerOptions20.deadAssignmentElimination;
    com.google.javascript.jscomp.MessageBundle messageBundle27 = compilerOptions20.messageBundle;
    com.google.javascript.jscomp.CompilerOptions compilerOptions28 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b29 = compilerOptions28.gatherCssNames;
    java.lang.String str30 = compilerOptions28.aliasableGlobals;
    boolean b31 = compilerOptions28.removeDeadCode;
    compilerOptions28.setLooseTypes(false);
    boolean b34 = compilerOptions28.markNoSideEffectCalls;
    com.google.javascript.jscomp.SourceMap.Format format35 = null;
    compilerOptions28.sourceMapFormat = format35;
    com.google.javascript.jscomp.CompilerOptions compilerOptions37 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions37.collapseVariableDeclarations = true;
    compilerOptions37.setSummaryDetailLevel(86);
    compilerOptions37.setDefineToBooleanLiteral("hi!", false);
    boolean b45 = compilerOptions37.instrumentForCoverage;
    com.google.common.collect.Multimap multimap46 = null;
    compilerOptions37.customPasses = multimap46;
    boolean b48 = compilerOptions37.inferTypesInGlobalScope;
    com.google.javascript.jscomp.ErrorFormat errorFormat49 = compilerOptions37.errorFormat;
    compilerOptions28.errorFormat = errorFormat49;
    compilerOptions20.errorFormat = errorFormat49;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorManager10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(result23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(messageBundle27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b34 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b45 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b48 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat49);

  }

  @Test
  public void test023() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test023"); }


    com.google.javascript.jscomp.DiagnosticGroup diagnosticGroup0 = com.google.javascript.jscomp.DiagnosticGroups.EXTERNS_VALIDATION;
    com.google.javascript.jscomp.DiagnosticGroups.EXTERNS_VALIDATION = diagnosticGroup0;
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    jSTypeRegistry3.setTemplateTypeName("EOF");
    com.google.javascript.rhino.jstype.JSType jSType12 = jSTypeRegistry3.createNamedType("", "EOF", 105, 126);
    com.google.javascript.rhino.ErrorReporter errorReporter13 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry14 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter13);
    com.google.javascript.rhino.jstype.StaticScope staticScope15 = null;
    com.google.javascript.rhino.jstype.JSType jSType20 = jSTypeRegistry14.getForgivingType(staticScope15, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter21 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry22 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter21);
    com.google.javascript.rhino.jstype.StaticScope staticScope23 = null;
    com.google.javascript.rhino.jstype.JSType jSType28 = jSTypeRegistry22.getForgivingType(staticScope23, "hi!", "", 0, 1);
    boolean b29 = jSType28.isEnumType();
    boolean b30 = jSType28.isResolved();
    boolean b31 = jSType20.differsFrom(jSType28);
    boolean b32 = jSType28.isTemplateType();
    com.google.javascript.jscomp.JSModule jSModule34 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list35 = jSModule34.getDependencies();
    com.google.javascript.rhino.jstype.FunctionType functionType36 = jSTypeRegistry3.createFunctionType(jSType28, list35);
    com.google.javascript.jscomp.ComposeWarningsGuard composeWarningsGuard37 = new com.google.javascript.jscomp.ComposeWarningsGuard(list35);
    com.google.javascript.rhino.FunctionNode functionNode42 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.Node node44 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable45 = node44.getAncestors();
    com.google.javascript.rhino.Node node47 = new com.google.javascript.rhino.Node(0);
    boolean b48 = node44.hasChild(node47);
    node44.putBooleanProp(83, false);
    functionNode42.addChildrenToBack(node44);
    int i53 = functionNode42.getFunctionType();
    com.google.javascript.jscomp.CompilerOptions compilerOptions54 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b55 = compilerOptions54.gatherCssNames;
    java.lang.String str56 = compilerOptions54.aliasableGlobals;
    boolean b57 = compilerOptions54.removeDeadCode;
    compilerOptions54.setLooseTypes(false);
    boolean b60 = compilerOptions54.markNoSideEffectCalls;
    com.google.javascript.jscomp.CheckLevel checkLevel61 = com.google.javascript.jscomp.CheckLevel.ERROR;
    compilerOptions54.brokenClosureRequiresLevel = checkLevel61;
    com.google.javascript.jscomp.DiagnosticType diagnosticType65 = com.google.javascript.jscomp.DiagnosticType.disabled("", "hi!");
    com.google.javascript.rhino.FunctionNode functionNode67 = new com.google.javascript.rhino.FunctionNode("");
    int i68 = functionNode67.getFunctionType();
    com.google.javascript.rhino.ErrorReporter errorReporter69 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry70 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter69);
    jSTypeRegistry70.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter73 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry74 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter73);
    com.google.javascript.rhino.jstype.StaticScope staticScope75 = null;
    com.google.javascript.rhino.jstype.JSType jSType80 = jSTypeRegistry74.getForgivingType(staticScope75, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter81 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry82 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter81);
    com.google.javascript.rhino.jstype.StaticScope staticScope83 = null;
    com.google.javascript.rhino.jstype.JSType jSType88 = jSTypeRegistry82.getForgivingType(staticScope83, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array89 = new com.google.javascript.rhino.jstype.JSType[] { jSType88 };
    com.google.javascript.rhino.jstype.FunctionType functionType90 = jSTypeRegistry70.createFunctionType(jSType80, jSType_array89);
    boolean b91 = functionType90.isConstructor();
    functionNode67.setJSType((com.google.javascript.rhino.jstype.JSType)functionType90);
    java.lang.String[] str_array93 = functionNode67.getParamAndVarNames();
    com.google.javascript.jscomp.JSError jSError94 = com.google.javascript.jscomp.JSError.make("EOF", (com.google.javascript.rhino.Node)functionNode42, checkLevel61, diagnosticType65, str_array93);
    com.google.javascript.jscomp.CheckLevel checkLevel95 = composeWarningsGuard37.level(jSError94);
    boolean b96 = diagnosticGroup0.matches(jSError94);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticGroup0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b48 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i53 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b55 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b57 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b60 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i68 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType88);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array89);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType90);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b91 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array93);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError94);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(checkLevel95);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b96 == false);

  }

  @Test
  public void test024() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test024"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    com.google.javascript.jscomp.CompilerOptions compilerOptions1 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b2 = compilerOptions1.gatherCssNames;
    java.lang.String str3 = compilerOptions1.aliasableGlobals;
    boolean b4 = compilerOptions1.removeDeadCode;
    compilerOptions1.setLooseTypes(false);
    boolean b7 = compilerOptions1.markNoSideEffectCalls;
    com.google.javascript.jscomp.CheckLevel checkLevel8 = com.google.javascript.jscomp.CheckLevel.ERROR;
    compilerOptions1.brokenClosureRequiresLevel = checkLevel8;
    compilerOptions0.reportUnknownTypes = checkLevel8;
    boolean b11 = compilerOptions0.computeFunctionSideEffects;
    boolean b12 = compilerOptions0.convertToDottedProperties;
    com.google.javascript.jscomp.CheckLevel checkLevel13 = compilerOptions0.brokenClosureRequiresLevel;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel13);

  }

  @Test
  public void test025() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test025"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b3 = jSDocInfoBuilder1.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression4 = null;
    boolean b5 = jSDocInfoBuilder1.recordReturnType(jSTypeExpression4);
    com.google.javascript.rhino.Node node7 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable8 = node7.getAncestors();
    com.google.javascript.rhino.Node node10 = new com.google.javascript.rhino.Node(0);
    boolean b11 = node7.hasChild(node10);
    com.google.javascript.rhino.Node node13 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str14 = node10.checkTreeEquals(node13);
    com.google.javascript.rhino.Node node15 = node13.cloneNode();
    boolean b16 = node15.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression18 = new com.google.javascript.rhino.JSTypeExpression(node15, "<No stack trace available>");
    boolean b19 = jSDocInfoBuilder1.recordDefineType(jSTypeExpression18);
    com.google.javascript.rhino.Node node21 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable22 = node21.getAncestors();
    com.google.javascript.rhino.Node node24 = new com.google.javascript.rhino.Node(0);
    boolean b25 = node21.hasChild(node24);
    com.google.javascript.rhino.Node node27 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str28 = node24.checkTreeEquals(node27);
    com.google.javascript.rhino.Node node29 = node27.cloneNode();
    boolean b30 = node29.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression32 = new com.google.javascript.rhino.JSTypeExpression(node29, "<No stack trace available>");
    boolean b33 = jSDocInfoBuilder1.recordType(jSTypeExpression32);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression34 = com.google.javascript.rhino.JSTypeExpression.makeOptionalArg(jSTypeExpression32);
    com.google.javascript.rhino.jstype.StaticScope staticScope35 = null;
    com.google.javascript.rhino.ErrorReporter errorReporter36 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry37 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter36);
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    jSTypeRegistry39.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter42 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry43 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter42);
    com.google.javascript.rhino.jstype.StaticScope staticScope44 = null;
    com.google.javascript.rhino.jstype.JSType jSType49 = jSTypeRegistry43.getForgivingType(staticScope44, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter50 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry51 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter50);
    com.google.javascript.rhino.jstype.StaticScope staticScope52 = null;
    com.google.javascript.rhino.jstype.JSType jSType57 = jSTypeRegistry51.getForgivingType(staticScope52, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array58 = new com.google.javascript.rhino.jstype.JSType[] { jSType57 };
    com.google.javascript.rhino.jstype.FunctionType functionType59 = jSTypeRegistry39.createFunctionType(jSType49, jSType_array58);
    com.google.javascript.rhino.jstype.JSType jSType60 = functionType59.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter62 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry63 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter62);
    jSTypeRegistry63.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter66 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry67 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter66);
    com.google.javascript.rhino.jstype.StaticScope staticScope68 = null;
    com.google.javascript.rhino.jstype.JSType jSType73 = jSTypeRegistry67.getForgivingType(staticScope68, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter74 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry75 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter74);
    com.google.javascript.rhino.jstype.StaticScope staticScope76 = null;
    com.google.javascript.rhino.jstype.JSType jSType81 = jSTypeRegistry75.getForgivingType(staticScope76, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array82 = new com.google.javascript.rhino.jstype.JSType[] { jSType81 };
    com.google.javascript.rhino.jstype.FunctionType functionType83 = jSTypeRegistry63.createFunctionType(jSType73, jSType_array82);
    com.google.javascript.rhino.jstype.FunctionType functionType84 = jSTypeRegistry37.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType59, false, jSType_array82);
    boolean b86 = jSTypeRegistry37.hasNamespace("OFF");
    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.rhino.jstype.JSType jSType87 = jSTypeExpression34.evaluate(staticScope35, jSTypeRegistry37);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str14 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str14.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str28 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str28.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSTypeExpression34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType73);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType81);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType83);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b86 == false);

  }

  @Test
  public void test026() {}
// Defects4J: flaky method
//   @Test
//   public void test026() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test026"); }
// 
// 
//     com.google.javascript.rhino.Context context0 = null;
//     com.google.javascript.rhino.Context context1 = com.google.javascript.rhino.Context.enter(context0);
//     context1.removeActivationName("OFF");
//     boolean b4 = context1.isGeneratingSource();
//     long long5 = com.google.javascript.rhino.ScriptRuntime.lastUint32Result(context1);
//     com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
//     com.google.javascript.rhino.ErrorReporter errorReporter8 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry9 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter8);
//     jSTypeRegistry9.forwardDeclareType("hi!");
//     com.google.javascript.rhino.ErrorReporter errorReporter12 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry13 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter12);
//     com.google.javascript.rhino.jstype.StaticScope staticScope14 = null;
//     com.google.javascript.rhino.jstype.JSType jSType19 = jSTypeRegistry13.getForgivingType(staticScope14, "hi!", "", 0, 1);
//     com.google.javascript.rhino.ErrorReporter errorReporter20 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry21 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter20);
//     com.google.javascript.rhino.jstype.StaticScope staticScope22 = null;
//     com.google.javascript.rhino.jstype.JSType jSType27 = jSTypeRegistry21.getForgivingType(staticScope22, "hi!", "", 0, 1);
//     com.google.javascript.rhino.jstype.JSType[] jSType_array28 = new com.google.javascript.rhino.jstype.JSType[] { jSType27 };
//     com.google.javascript.rhino.jstype.FunctionType functionType29 = jSTypeRegistry9.createFunctionType(jSType19, jSType_array28);
//     com.google.javascript.rhino.Node node31 = new com.google.javascript.rhino.Node(0);
//     com.google.javascript.rhino.Node.AncestorIterable ancestorIterable32 = node31.getAncestors();
//     java.lang.String str33 = node31.toString();
//     com.google.javascript.rhino.jstype.FunctionType functionType34 = jSTypeRegistry7.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType29, node31);
//     context1.seal((java.lang.Object)functionType29);
//     // The following exception was thrown during execution in test generation
//     try {
//       context1.seal((java.lang.Object)91);
//       org.junit.Assert.fail("Expected exception of type java.lang.IllegalStateException");
//     } catch (java.lang.IllegalStateException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.IllegalStateException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.IllegalStateException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(context1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b4 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long5 == 0L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType19);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType_array28);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType29);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(ancestorIterable32);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str33 + "' != '" + "EOF"+ "'", str33.equals("EOF"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType34);
// 
//   }

  @Test
  public void test027() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test027"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.jstype.JSType jSType24 = functionType23.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter26 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry27 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter26);
    jSTypeRegistry27.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter30 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry31 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter30);
    com.google.javascript.rhino.jstype.StaticScope staticScope32 = null;
    com.google.javascript.rhino.jstype.JSType jSType37 = jSTypeRegistry31.getForgivingType(staticScope32, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array46 = new com.google.javascript.rhino.jstype.JSType[] { jSType45 };
    com.google.javascript.rhino.jstype.FunctionType functionType47 = jSTypeRegistry27.createFunctionType(jSType37, jSType_array46);
    com.google.javascript.rhino.jstype.FunctionType functionType48 = jSTypeRegistry1.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType23, false, jSType_array46);
    com.google.javascript.rhino.ErrorReporter errorReporter49 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry50 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter49);
    com.google.javascript.rhino.ErrorReporter errorReporter51 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry52 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter51);
    jSTypeRegistry52.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter55 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry56 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter55);
    com.google.javascript.rhino.jstype.StaticScope staticScope57 = null;
    com.google.javascript.rhino.jstype.JSType jSType62 = jSTypeRegistry56.getForgivingType(staticScope57, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array71 = new com.google.javascript.rhino.jstype.JSType[] { jSType70 };
    com.google.javascript.rhino.jstype.FunctionType functionType72 = jSTypeRegistry52.createFunctionType(jSType62, jSType_array71);
    com.google.javascript.rhino.Node node74 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable75 = node74.getAncestors();
    java.lang.String str76 = node74.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry50.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType72, node74);
    functionType23.setPrototypeBasedOn((com.google.javascript.rhino.jstype.ObjectType)functionType77);
    com.google.javascript.rhino.ErrorReporter errorReporter79 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry80 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter79);
    com.google.javascript.rhino.jstype.StaticScope staticScope81 = null;
    com.google.javascript.rhino.jstype.JSType jSType86 = jSTypeRegistry80.getForgivingType(staticScope81, "hi!", "", 0, 1);
    boolean b87 = jSType86.isRecordType();
    boolean b88 = jSType86.isBooleanObjectType();
    com.google.javascript.rhino.jstype.JSType jSType89 = functionType23.getLeastSupertype(jSType86);
    boolean b91 = functionType23.hasProperty("OFF");
    boolean b92 = functionType23.isInstanceType();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str76 + "' != '" + "EOF"+ "'", str76.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b87 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType89);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b91 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b92 == false);

  }

  @Test
  public void test028() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test028"); }


    com.google.javascript.rhino.FunctionNode functionNode2 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String[] str_array3 = functionNode2.getParamAndVarNames();
    boolean b5 = functionNode2.addConst("hi!");
    int i6 = functionNode2.getFunctionCount();
    com.google.javascript.rhino.FunctionNode functionNode10 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.Node node12 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable13 = node12.getAncestors();
    com.google.javascript.rhino.Node node15 = new com.google.javascript.rhino.Node(0);
    boolean b16 = node12.hasChild(node15);
    node12.putBooleanProp(83, false);
    functionNode10.addChildrenToBack(node12);
    boolean b21 = functionNode10.hasOneChild();
    com.google.javascript.rhino.ErrorReporter errorReporter22 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry23 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter22);
    com.google.javascript.rhino.jstype.JSType jSType28 = jSTypeRegistry23.createNamedType("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "", 301, 71);
    java.lang.RuntimeException runtimeException29 = com.google.javascript.rhino.ScriptRuntime.undefReadError((java.lang.Object)functionNode10, (java.lang.Object)jSType28);
    boolean b30 = functionNode10.isUnscopedQualifiedName();
    com.google.javascript.rhino.Node node31 = new com.google.javascript.rhino.Node(85, (com.google.javascript.rhino.Node)functionNode2, (com.google.javascript.rhino.Node)functionNode10);
    int i32 = functionNode10.getEncodedSourceStart();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b21 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(runtimeException29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i32 == 0);

  }

  @Test
  public void test029() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test029"); }


    com.google.javascript.jscomp.DefaultCodingConvention defaultCodingConvention0 = new com.google.javascript.jscomp.DefaultCodingConvention();
    boolean b2 = defaultCodingConvention0.isExported("");
    com.google.javascript.rhino.FunctionNode functionNode6 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.Node node8 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable9 = node8.getAncestors();
    com.google.javascript.rhino.Node node11 = new com.google.javascript.rhino.Node(0);
    boolean b12 = node8.hasChild(node11);
    node8.putBooleanProp(83, false);
    functionNode6.addChildrenToBack(node8);
    boolean b17 = functionNode6.hasOneChild();
    com.google.javascript.rhino.ErrorReporter errorReporter18 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry19 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter18);
    com.google.javascript.rhino.jstype.JSType jSType24 = jSTypeRegistry19.createNamedType("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "", 301, 71);
    java.lang.RuntimeException runtimeException25 = com.google.javascript.rhino.ScriptRuntime.undefReadError((java.lang.Object)functionNode6, (java.lang.Object)jSType24);
    boolean b26 = functionNode6.isUnscopedQualifiedName();
    boolean b27 = functionNode6.isQualifiedName();
    java.lang.String str28 = functionNode6.getFunctionName();
    int i29 = functionNode6.getFunctionType();
    com.google.javascript.rhino.ErrorReporter errorReporter30 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry31 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter30);
    jSTypeRegistry31.forwardDeclareType("hi!");
    jSTypeRegistry31.setTemplateTypeName("EOF");
    com.google.javascript.rhino.jstype.FunctionBuilder functionBuilder36 = new com.google.javascript.rhino.jstype.FunctionBuilder(jSTypeRegistry31);
    com.google.javascript.rhino.jstype.FunctionBuilder functionBuilder38 = functionBuilder36.withTemplateName("@IMPLEMENTATION.VERSION@");
    com.google.javascript.rhino.jstype.FunctionBuilder functionBuilder40 = functionBuilder36.withName("");
    com.google.javascript.rhino.jstype.FunctionBuilder functionBuilder42 = functionBuilder40.withName("JSC_NODE_TRAVERSAL_ERROR. {0} at Node tree inequality:\\nTree1:\\nEOF\\n\\n\\nTree2:\\nBANG 0\\n    STRING hi 0\\n\\n\\nSubtree1: EOF\\n\\n\\nSubtree2: BANG 0\\n    STRING hi 0\\n line (unknown line) : (unknown column)");
    com.google.javascript.rhino.FunctionNode functionNode44 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String[] str_array45 = functionNode44.getParamAndVarNames();
    com.google.javascript.rhino.Node node46 = functionNode44.getFirstChild();
    boolean b48 = functionNode44.hasParamOrVar("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n");
    com.google.javascript.rhino.ErrorReporter errorReporter49 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry50 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter49);
    com.google.javascript.rhino.ErrorReporter errorReporter51 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry52 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter51);
    jSTypeRegistry52.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter55 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry56 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter55);
    com.google.javascript.rhino.jstype.StaticScope staticScope57 = null;
    com.google.javascript.rhino.jstype.JSType jSType62 = jSTypeRegistry56.getForgivingType(staticScope57, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array71 = new com.google.javascript.rhino.jstype.JSType[] { jSType70 };
    com.google.javascript.rhino.jstype.FunctionType functionType72 = jSTypeRegistry52.createFunctionType(jSType62, jSType_array71);
    com.google.javascript.rhino.Node node74 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable75 = node74.getAncestors();
    java.lang.String str76 = node74.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry50.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType72, node74);
    com.google.javascript.rhino.JSDocInfo jSDocInfo78 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str79 = jSDocInfo78.getTemplateTypeName();
    boolean b80 = jSDocInfo78.hasEnumParameterType();
    functionType72.setJSDocInfo(jSDocInfo78);
    functionNode44.setJSDocInfo(jSDocInfo78);
    int i85 = functionNode44.addRegexp("{...}", "Not declared as a type name");
    com.google.javascript.jscomp.CompilerOptions compilerOptions87 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions87.collapseVariableDeclarations = true;
    compilerOptions87.debugFunctionSideEffectsPath = "hi!";
    functionNode44.putProp(97, (java.lang.Object)compilerOptions87);
    int i93 = functionNode44.getParamCount();
    boolean b94 = functionNode44.getIgnoreDynamicScope();
    com.google.javascript.rhino.jstype.FunctionBuilder functionBuilder95 = functionBuilder42.withSourceNode((com.google.javascript.rhino.Node)functionNode44);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.String str96 = defaultCodingConvention0.extractClassNameIfProvide((com.google.javascript.rhino.Node)functionNode6, (com.google.javascript.rhino.Node)functionNode44);
      org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException");
    } catch (java.lang.UnsupportedOperationException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.UnsupportedOperationException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(runtimeException25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str28 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str28.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i29 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionBuilder38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionBuilder40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionBuilder42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(node46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b48 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str76 + "' != '" + "EOF"+ "'", str76.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b80 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i85 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i93 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b94 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionBuilder95);

  }

  @Test
  public void test030() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test030"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.jstype.JSType jSType24 = functionType23.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter26 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry27 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter26);
    jSTypeRegistry27.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter30 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry31 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter30);
    com.google.javascript.rhino.jstype.StaticScope staticScope32 = null;
    com.google.javascript.rhino.jstype.JSType jSType37 = jSTypeRegistry31.getForgivingType(staticScope32, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array46 = new com.google.javascript.rhino.jstype.JSType[] { jSType45 };
    com.google.javascript.rhino.jstype.FunctionType functionType47 = jSTypeRegistry27.createFunctionType(jSType37, jSType_array46);
    com.google.javascript.rhino.jstype.FunctionType functionType48 = jSTypeRegistry1.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType23, false, jSType_array46);
    com.google.javascript.rhino.ErrorReporter errorReporter49 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry50 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter49);
    com.google.javascript.rhino.ErrorReporter errorReporter51 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry52 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter51);
    jSTypeRegistry52.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter55 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry56 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter55);
    com.google.javascript.rhino.jstype.StaticScope staticScope57 = null;
    com.google.javascript.rhino.jstype.JSType jSType62 = jSTypeRegistry56.getForgivingType(staticScope57, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array71 = new com.google.javascript.rhino.jstype.JSType[] { jSType70 };
    com.google.javascript.rhino.jstype.FunctionType functionType72 = jSTypeRegistry52.createFunctionType(jSType62, jSType_array71);
    com.google.javascript.rhino.Node node74 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable75 = node74.getAncestors();
    java.lang.String str76 = node74.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry50.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType72, node74);
    boolean b78 = functionType23.isSubtype((com.google.javascript.rhino.jstype.JSType)functionType72);
    com.google.javascript.rhino.JSDocInfo jSDocInfo80 = functionType72.getOwnPropertyJSDocInfo("");
    java.lang.Iterable iterable81 = functionType72.getImplementedInterfaces();
    boolean b82 = functionType72.isEnumType();
    java.lang.String str83 = functionType72.getTemplateTypeName();
    boolean b84 = functionType72.matchesNumberContext();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str76 + "' != '" + "EOF"+ "'", str76.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b78 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSDocInfo80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(iterable81);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b82 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str83);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b84 == false);

  }

  @Test
  public void test031() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test031"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.debugFunctionSideEffectsPath = "hi!";
    compilerOptions0.removeUnusedVars = true;
    compilerOptions0.aliasableGlobals = "OFF";
    boolean b9 = compilerOptions0.smartNameRemoval;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);

  }

  @Test
  public void test032() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test032"); }


    com.google.javascript.rhino.Node node4 = com.google.javascript.rhino.Node.newString(141, "function ({1147325357}): {1147325357}", 62, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node4);

  }

  @Test
  public void test033() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test033"); }


    com.google.javascript.rhino.Node node1 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    com.google.javascript.rhino.Node node2 = node1.getLastChild();
    com.google.javascript.rhino.Node node5 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable6 = node5.getAncestors();
    com.google.javascript.rhino.Node node8 = new com.google.javascript.rhino.Node(0);
    boolean b9 = node5.hasChild(node8);
    com.google.javascript.rhino.Node node11 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str12 = node8.checkTreeEquals(node11);
    com.google.javascript.rhino.Node node13 = node11.cloneNode();
    com.google.javascript.rhino.Node node15 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node node17 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable18 = node17.getAncestors();
    com.google.javascript.rhino.Node node20 = new com.google.javascript.rhino.Node(0);
    boolean b21 = node17.hasChild(node20);
    com.google.javascript.rhino.Node node23 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str24 = node20.checkTreeEquals(node23);
    com.google.javascript.rhino.Node node25 = node15.copyInformationFromForTree(node20);
    com.google.javascript.rhino.Node node28 = new com.google.javascript.rhino.Node(9, node11, node15, 29, 10);
    node15.setOptionalArg(false);
    com.google.javascript.rhino.Node node31 = node2.copyInformationFromForTree(node15);
    com.google.javascript.rhino.ErrorReporter errorReporter32 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry33 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter32);
    jSTypeRegistry33.forwardDeclareType("hi!");
    com.google.javascript.rhino.jstype.FunctionParamBuilder functionParamBuilder36 = new com.google.javascript.rhino.jstype.FunctionParamBuilder(jSTypeRegistry33);
    com.google.javascript.rhino.Node node37 = functionParamBuilder36.build();
    boolean b38 = node37.hasMoreThanOneChild();
    boolean b39 = node37.isOptionalArg();
    node15.addChildToFront(node37);
    java.lang.String str41 = node37.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str12.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b21 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str24 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str24.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str41 + "' != '" + "LP"+ "'", str41.equals("LP"));

  }

  @Test
  public void test034() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test034"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b2 = jSDocInfoBuilder1.isJavaDispatch();
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder4 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b6 = jSDocInfoBuilder4.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression8 = null;
    boolean b9 = jSDocInfoBuilder4.recordParameter("JSDocInfo", jSTypeExpression8);
    boolean b12 = jSDocInfoBuilder4.recordParameterDescription("", "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n");
    boolean b13 = jSDocInfoBuilder4.recordNoSideEffects();
    boolean b14 = jSDocInfoBuilder4.recordNoShadow();
    boolean b15 = jSDocInfoBuilder4.shouldParseDocumentation();
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder17 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b19 = jSDocInfoBuilder17.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression20 = null;
    boolean b21 = jSDocInfoBuilder17.recordReturnType(jSTypeExpression20);
    com.google.javascript.rhino.Node node23 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable24 = node23.getAncestors();
    com.google.javascript.rhino.Node node26 = new com.google.javascript.rhino.Node(0);
    boolean b27 = node23.hasChild(node26);
    com.google.javascript.rhino.Node node29 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str30 = node26.checkTreeEquals(node29);
    com.google.javascript.rhino.Node node31 = node29.cloneNode();
    boolean b32 = node31.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression34 = new com.google.javascript.rhino.JSTypeExpression(node31, "<No stack trace available>");
    boolean b35 = jSDocInfoBuilder17.recordDefineType(jSTypeExpression34);
    com.google.javascript.rhino.Node node37 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable38 = node37.getAncestors();
    com.google.javascript.rhino.Node node40 = new com.google.javascript.rhino.Node(0);
    boolean b41 = node37.hasChild(node40);
    com.google.javascript.rhino.Node node43 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str44 = node40.checkTreeEquals(node43);
    com.google.javascript.rhino.Node node45 = node43.cloneNode();
    boolean b46 = node45.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression48 = new com.google.javascript.rhino.JSTypeExpression(node45, "<No stack trace available>");
    boolean b49 = jSDocInfoBuilder17.recordType(jSTypeExpression48);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression50 = com.google.javascript.rhino.JSTypeExpression.makeOptionalArg(jSTypeExpression48);
    boolean b51 = jSDocInfoBuilder4.recordType(jSTypeExpression50);
    boolean b52 = jSDocInfoBuilder1.recordThrowType(jSTypeExpression50);
    boolean b54 = jSDocInfoBuilder1.recordLends("function (hi!): hi!");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b21 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str30 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str30.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str44 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str44.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b46 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b49 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSTypeExpression50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b51 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b52 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b54 == true);

  }

  @Test
  public void test035() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test035"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.jstype.JSType jSType6 = jSTypeRegistry1.createNamedType("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "", 301, 71);
    jSTypeRegistry1.identifyEnumName("EOF");
    jSTypeRegistry1.forwardDeclareType("@IMPLEMENTATION.VERSION@");
    com.google.javascript.rhino.ErrorReporter errorReporter11 = jSTypeRegistry1.getErrorReporter();
    com.google.javascript.rhino.jstype.JSType jSType13 = null;
    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.rhino.jstype.EnumType enumType14 = jSTypeRegistry1.createEnumType("JSC_NODE_TRAVERSAL_ERROR: {0}", jSType13);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(errorReporter11);

  }

  @Test
  public void test036() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test036"); }


    com.google.javascript.jscomp.Compiler compiler0 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState1 = compiler0.getState();
    com.google.javascript.jscomp.SourceExcerptProvider.SourceExcerpt sourceExcerpt2 = null;
    com.google.javascript.jscomp.LightweightMessageFormatter lightweightMessageFormatter3 = new com.google.javascript.jscomp.LightweightMessageFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler0, sourceExcerpt2);
    java.util.logging.Logger logger4 = null;
    com.google.javascript.jscomp.LoggerErrorManager loggerErrorManager5 = new com.google.javascript.jscomp.LoggerErrorManager((com.google.javascript.jscomp.MessageFormatter)lightweightMessageFormatter3, logger4);
    com.google.javascript.jscomp.JSError[] jSError_array6 = loggerErrorManager5.getErrors();
    com.google.javascript.jscomp.Compiler compiler7 = new com.google.javascript.jscomp.Compiler((com.google.javascript.jscomp.ErrorManager)loggerErrorManager5);
    com.google.javascript.jscomp.JSError[] jSError_array8 = compiler7.getErrors();
    com.google.javascript.jscomp.SourceFile.Generator generator10 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile11 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("function ({proxy:{78039409}}): {proxy:{384921772}}", generator10);
    com.google.javascript.jscomp.JSSourceFile[] jSSourceFile_array12 = new com.google.javascript.jscomp.JSSourceFile[] { jSSourceFile11 };
    com.google.javascript.jscomp.ErrorFormat errorFormat13 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler14 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState15 = compiler14.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter17 = errorFormat13.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler14, true);
    com.google.javascript.jscomp.JSModule jSModule19 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list20 = jSModule19.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback21 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler14, list20, callback21);
    com.google.javascript.jscomp.ErrorManager errorManager23 = compiler14.getErrorManager();
    com.google.javascript.jscomp.JSModule jSModule25 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list26 = jSModule25.getDependencies();
    java.util.List list27 = jSModule25.getProvides();
    java.lang.String[] str_array28 = compiler14.toSourceArray(jSModule25);
    java.util.List list29 = jSModule25.getInputs();
    com.google.javascript.jscomp.JSModule jSModule31 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list32 = jSModule31.getDependencies();
    java.util.List list33 = jSModule31.getProvides();
    com.google.javascript.jscomp.SourceFile.Generator generator35 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile36 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator35);
    com.google.javascript.jscomp.CompilerInput compilerInput37 = new com.google.javascript.jscomp.CompilerInput(jSSourceFile36);
    jSModule31.add(jSSourceFile36);
    com.google.javascript.jscomp.JSSourceFile jSSourceFile41 = com.google.javascript.jscomp.JSSourceFile.fromCode("", "<No stack trace available>: <No stack trace available>");
    jSModule31.addFirst(jSSourceFile41);
    jSModule25.add(jSSourceFile41);
    com.google.javascript.jscomp.JSModule[] jSModule_array44 = new com.google.javascript.jscomp.JSModule[] { jSModule25 };
    com.google.javascript.jscomp.JSModuleGraph jSModuleGraph45 = new com.google.javascript.jscomp.JSModuleGraph(jSModule_array44);
    com.google.javascript.jscomp.CompilerOptions compilerOptions46 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions46.collapseVariableDeclarations = true;
    compilerOptions46.debugFunctionSideEffectsPath = "hi!";
    compilerOptions46.removeUnusedVars = true;
    compilerOptions46.aliasableGlobals = "OFF";
    boolean b55 = compilerOptions46.gatherCssNames;
    boolean b56 = compilerOptions46.allowLegacyJsMessages;
    compilerOptions46.syntheticBlockEndMarker = "hi!";
    boolean b59 = compilerOptions46.moveFunctionDeclarations;
    compilerOptions46.setRemoveClosureAsserts(true);
    com.google.javascript.jscomp.SourceMap.Format format62 = compilerOptions46.sourceMapFormat;
    compilerOptions46.computeFunctionSideEffects = true;
    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.jscomp.Result result65 = compiler7.compile(jSSourceFile_array12, jSModule_array44, compilerOptions46);
      org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException");
    } catch (java.lang.RuntimeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.RuntimeException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorManager23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSModule_array44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b55 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b56 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b59 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(format62);

  }

  @Test
  public void test037() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test037"); }


    com.google.javascript.rhino.JSDocInfo jSDocInfo0 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str1 = jSDocInfo0.getTemplateTypeName();
    boolean b2 = jSDocInfo0.hasEnumParameterType();
    boolean b3 = jSDocInfo0.isConstant();
    java.lang.String str4 = jSDocInfo0.getFileOverview();
    boolean b5 = jSDocInfo0.isNoAlias();
    int i6 = jSDocInfo0.getImplementedInterfaceCount();
    boolean b8 = jSDocInfo0.hasParameter("function ({proxy:{1404434850}}): {proxy:{1823794890}}");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);

  }

  @Test
  public void test038() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test038"); }


    com.google.javascript.rhino.FunctionNode functionNode3 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.Node node5 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable6 = node5.getAncestors();
    com.google.javascript.rhino.Node node8 = new com.google.javascript.rhino.Node(0);
    boolean b9 = node5.hasChild(node8);
    node5.putBooleanProp(83, false);
    functionNode3.addChildrenToBack(node5);
    boolean b14 = functionNode3.hasOneChild();
    com.google.javascript.rhino.ErrorReporter errorReporter15 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry16 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter15);
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry16.createNamedType("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "", 301, 71);
    java.lang.RuntimeException runtimeException22 = com.google.javascript.rhino.ScriptRuntime.undefReadError((java.lang.Object)functionNode3, (java.lang.Object)jSType21);
    com.google.javascript.rhino.ScriptOrFnNode scriptOrFnNode26 = new com.google.javascript.rhino.ScriptOrFnNode(6, 112, 68);
    com.google.javascript.rhino.Node node27 = scriptOrFnNode26.cloneNode();
    scriptOrFnNode26.setEncodedSourceBounds(47, 49);
    java.lang.String str31 = functionNode3.checkTreeEquals((com.google.javascript.rhino.Node)scriptOrFnNode26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(runtimeException22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str31 + "' != '" + "Node tree inequality:\nTree1:\nFUNCTION  12\n    EOF\n\n\nTree2:\nIFEQ [source name: null] [encoded source length: 2] [base line: -1] [end line: -1] 112\n\n\nSubtree1: FUNCTION  12\n    EOF\n\n\nSubtree2: IFEQ [source name: null] [encoded source length: 2] [base line: -1] [end line: -1] 112\n"+ "'", str31.equals("Node tree inequality:\nTree1:\nFUNCTION  12\n    EOF\n\n\nTree2:\nIFEQ [source name: null] [encoded source length: 2] [base line: -1] [end line: -1] 112\n\n\nSubtree1: FUNCTION  12\n    EOF\n\n\nSubtree2: IFEQ [source name: null] [encoded source length: 2] [base line: -1] [end line: -1] 112\n"));

  }

  @Test
  public void test039() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test039"); }


    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.rhino.EcmaError ecmaError2 = com.google.javascript.rhino.ScriptRuntime.typeError1("and", "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n");
      org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException");
    } catch (java.lang.RuntimeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.RuntimeException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test040() {}
// Defects4J: flaky method
//   @Test
//   public void test040() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test040"); }
// 
// 
//     com.google.javascript.jscomp.DiagnosticGroup diagnosticGroup0 = com.google.javascript.jscomp.DiagnosticGroups.NON_STANDARD_JSDOC;
//     com.google.javascript.jscomp.DiagnosticGroups.NON_STANDARD_JSDOC = diagnosticGroup0;
//     com.google.javascript.jscomp.DiagnosticGroup diagnosticGroup2 = com.google.javascript.jscomp.DiagnosticGroups.CHECK_TYPES;
//     com.google.javascript.rhino.Node node5 = new com.google.javascript.rhino.Node(0);
//     com.google.javascript.rhino.Node.AncestorIterable ancestorIterable6 = node5.getAncestors();
//     com.google.javascript.rhino.Node node8 = new com.google.javascript.rhino.Node(0);
//     boolean b9 = node5.hasChild(node8);
//     com.google.javascript.rhino.Node node11 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
//     java.lang.String str12 = node8.checkTreeEquals(node11);
//     com.google.javascript.rhino.FunctionNode functionNode16 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
//     com.google.javascript.rhino.Node node18 = new com.google.javascript.rhino.Node(0);
//     com.google.javascript.rhino.Node.AncestorIterable ancestorIterable19 = node18.getAncestors();
//     com.google.javascript.rhino.Node node21 = new com.google.javascript.rhino.Node(0);
//     boolean b22 = node18.hasChild(node21);
//     node18.putBooleanProp(83, false);
//     functionNode16.addChildrenToBack(node18);
//     boolean b27 = node8.checkTreeTypeAwareEqualsSilent(node18);
//     com.google.javascript.jscomp.CheckLevel checkLevel28 = com.google.javascript.jscomp.CheckLevel.OFF;
//     com.google.javascript.jscomp.DiagnosticType diagnosticType29 = com.google.javascript.jscomp.NodeTraversal.NODE_TRAVERSAL_ERROR;
//     com.google.javascript.rhino.FunctionNode functionNode31 = new com.google.javascript.rhino.FunctionNode("");
//     java.lang.String[] str_array32 = functionNode31.getParamAndVarNames();
//     com.google.javascript.jscomp.JSError jSError33 = com.google.javascript.jscomp.JSError.make("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", node8, checkLevel28, diagnosticType29, str_array32);
//     com.google.javascript.jscomp.DiagnosticGroupWarningsGuard diagnosticGroupWarningsGuard34 = new com.google.javascript.jscomp.DiagnosticGroupWarningsGuard(diagnosticGroup2, checkLevel28);
//     com.google.javascript.jscomp.DiagnosticGroup diagnosticGroup35 = com.google.javascript.jscomp.DiagnosticGroups.EXTERNS_VALIDATION;
//     com.google.javascript.jscomp.DiagnosticGroup diagnosticGroup36 = com.google.javascript.jscomp.DiagnosticGroups.CHECK_TYPES;
//     com.google.javascript.jscomp.AbstractCompiler abstractCompiler37 = null;
//     com.google.javascript.jscomp.NodeTraversal.Callback callback38 = null;
//     com.google.javascript.jscomp.NodeTraversal nodeTraversal39 = new com.google.javascript.jscomp.NodeTraversal(abstractCompiler37, callback38);
//     com.google.javascript.jscomp.JSModule jSModule41 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list42 = jSModule41.getDependencies();
//     nodeTraversal39.traverseRoots(list42);
//     com.google.javascript.rhino.ErrorReporter errorReporter44 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry45 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter44);
//     jSTypeRegistry45.forwardDeclareType("hi!");
//     com.google.javascript.rhino.jstype.FunctionParamBuilder functionParamBuilder48 = new com.google.javascript.rhino.jstype.FunctionParamBuilder(jSTypeRegistry45);
//     com.google.javascript.rhino.Node node49 = functionParamBuilder48.build();
//     com.google.javascript.jscomp.DiagnosticType diagnosticType50 = com.google.javascript.jscomp.NodeTraversal.NODE_TRAVERSAL_ERROR;
//     java.text.MessageFormat messageFormat51 = diagnosticType50.format;
//     java.lang.String[] str_array52 = null;
//     com.google.javascript.jscomp.JSError jSError53 = nodeTraversal39.makeError(node49, diagnosticType50, str_array52);
//     boolean b54 = diagnosticGroup36.matches(diagnosticType50);
//     boolean b55 = diagnosticGroup35.matches(diagnosticType50);
//     com.google.javascript.jscomp.DiagnosticGroups.DEPRECATED = diagnosticGroup35;
//     boolean b57 = diagnosticGroupWarningsGuard34.disables(diagnosticGroup35);
//     com.google.javascript.rhino.Node node60 = new com.google.javascript.rhino.Node(0);
//     com.google.javascript.rhino.Node.AncestorIterable ancestorIterable61 = node60.getAncestors();
//     com.google.javascript.rhino.Node node63 = new com.google.javascript.rhino.Node(0);
//     boolean b64 = node60.hasChild(node63);
//     com.google.javascript.rhino.Node node66 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
//     java.lang.String str67 = node63.checkTreeEquals(node66);
//     com.google.javascript.rhino.FunctionNode functionNode71 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
//     com.google.javascript.rhino.Node node73 = new com.google.javascript.rhino.Node(0);
//     com.google.javascript.rhino.Node.AncestorIterable ancestorIterable74 = node73.getAncestors();
//     com.google.javascript.rhino.Node node76 = new com.google.javascript.rhino.Node(0);
//     boolean b77 = node73.hasChild(node76);
//     node73.putBooleanProp(83, false);
//     functionNode71.addChildrenToBack(node73);
//     boolean b82 = node63.checkTreeTypeAwareEqualsSilent(node73);
//     com.google.javascript.jscomp.CheckLevel checkLevel83 = com.google.javascript.jscomp.CheckLevel.OFF;
//     com.google.javascript.jscomp.DiagnosticType diagnosticType84 = com.google.javascript.jscomp.NodeTraversal.NODE_TRAVERSAL_ERROR;
//     com.google.javascript.rhino.FunctionNode functionNode86 = new com.google.javascript.rhino.FunctionNode("");
//     java.lang.String[] str_array87 = functionNode86.getParamAndVarNames();
//     com.google.javascript.jscomp.JSError jSError88 = com.google.javascript.jscomp.JSError.make("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", node63, checkLevel83, diagnosticType84, str_array87);
//     int i89 = jSError88.lineNumber;
//     com.google.javascript.jscomp.CheckLevel checkLevel90 = diagnosticGroupWarningsGuard34.level(jSError88);
//     java.lang.String str91 = jSError88.sourceName;
//     boolean b92 = diagnosticGroup0.matches(jSError88);
//     com.google.javascript.jscomp.DiagnosticGroups.EXTERNS_VALIDATION = diagnosticGroup0;
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(diagnosticGroup0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(diagnosticGroup2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(ancestorIterable6);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b9 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(node11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str12.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(ancestorIterable19);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b22 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b27 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(checkLevel28);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(diagnosticType29);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(str_array32);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSError33);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(diagnosticGroup35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(diagnosticGroup36);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list42);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(node49);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(diagnosticType50);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormat51);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSError53);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b54 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b55 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b57 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(ancestorIterable61);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b64 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(node66);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str67 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str67.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(ancestorIterable74);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b77 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b82 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(checkLevel83);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(diagnosticType84);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(str_array87);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSError88);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i89 == (-1));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(checkLevel90);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str91 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str91.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b92 == false);
// 
//   }

  @Test
  public void test041() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test041"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.debugFunctionSideEffectsPath = "hi!";
    compilerOptions0.removeUnusedVars = true;
    compilerOptions0.aliasableGlobals = "OFF";
    boolean b9 = compilerOptions0.gatherCssNames;
    com.google.javascript.jscomp.CheckLevel checkLevel10 = compilerOptions0.reportUnknownTypes;
    boolean b11 = compilerOptions0.lineBreak;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);

  }

  @Test
  public void test042() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test042"); }


    com.google.javascript.jscomp.DefaultCodingConvention defaultCodingConvention0 = new com.google.javascript.jscomp.DefaultCodingConvention();
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = null;
    com.google.javascript.jscomp.Scope scope2 = null;
    com.google.javascript.jscomp.JSModule jSModule4 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list5 = jSModule4.getDependencies();
    defaultCodingConvention0.defineDelegateProxyPrototypeProperties(jSTypeRegistry1, scope2, list5);
    boolean b8 = defaultCodingConvention0.isExported("Not declared as a type name");
    boolean b10 = defaultCodingConvention0.isConstant("JSC_NODE_TRAVERSAL_ERROR. {0} at Node tree inequality:\\nTree1:\\nEOF\\n\\n\\nTree2:\\nBANG 0\\n    STRING hi 0\\n\\n\\nSubtree1: EOF\\n\\n\\nSubtree2: BANG 0\\n    STRING hi 0\\n line (unknown line) : (unknown column)");
    java.lang.String str11 = defaultCodingConvention0.getExportSymbolFunction();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str11);

  }

  @Test
  public void test043() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test043"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    compilerOptions0.setDefineToBooleanLiteral("hi!", false);
    boolean b8 = compilerOptions0.instrumentForCoverage;
    com.google.common.collect.Multimap multimap9 = null;
    compilerOptions0.customPasses = multimap9;
    boolean b11 = compilerOptions0.inferTypesInGlobalScope;
    com.google.javascript.jscomp.ErrorFormat errorFormat12 = compilerOptions0.errorFormat;
    com.google.javascript.jscomp.ErrorFormat errorFormat13 = compilerOptions0.errorFormat;
    boolean b14 = compilerOptions0.crossModuleCodeMotion;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);

  }

  @Test
  public void test044() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test044"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression2 = null;
    boolean b3 = jSDocInfoBuilder1.recordTypedef(jSTypeExpression2);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression4 = null;
    boolean b6 = jSDocInfoBuilder1.recordThrowDescription(jSTypeExpression4, "hi!");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression7 = null;
    boolean b8 = jSDocInfoBuilder1.recordThisType(jSTypeExpression7);
    boolean b10 = jSDocInfoBuilder1.recordMeaning("");
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder12 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b14 = jSDocInfoBuilder12.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression15 = null;
    boolean b16 = jSDocInfoBuilder12.recordReturnType(jSTypeExpression15);
    com.google.javascript.rhino.Node node18 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable19 = node18.getAncestors();
    com.google.javascript.rhino.Node node21 = new com.google.javascript.rhino.Node(0);
    boolean b22 = node18.hasChild(node21);
    com.google.javascript.rhino.Node node24 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str25 = node21.checkTreeEquals(node24);
    com.google.javascript.rhino.Node node26 = node24.cloneNode();
    boolean b27 = node26.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression29 = new com.google.javascript.rhino.JSTypeExpression(node26, "<No stack trace available>");
    boolean b30 = jSDocInfoBuilder12.recordDefineType(jSTypeExpression29);
    com.google.javascript.rhino.Node node32 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable33 = node32.getAncestors();
    com.google.javascript.rhino.Node node35 = new com.google.javascript.rhino.Node(0);
    boolean b36 = node32.hasChild(node35);
    com.google.javascript.rhino.Node node38 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str39 = node35.checkTreeEquals(node38);
    com.google.javascript.rhino.Node node40 = node38.cloneNode();
    boolean b41 = node40.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression43 = new com.google.javascript.rhino.JSTypeExpression(node40, "<No stack trace available>");
    boolean b44 = jSDocInfoBuilder12.recordType(jSTypeExpression43);
    boolean b45 = jSDocInfoBuilder1.recordType(jSTypeExpression43);
    boolean b46 = jSDocInfoBuilder1.recordNoAlias();
    boolean b47 = jSDocInfoBuilder1.recordNoAlias();
    boolean b48 = jSDocInfoBuilder1.recordPreserveTry();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str25 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str25.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str39 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str39.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b45 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b46 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b47 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b48 == true);

  }

  @Test
  public void test045() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test045"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    boolean b3 = compilerOptions0.computeFunctionSideEffects;
    com.google.javascript.jscomp.CheckLevel checkLevel4 = compilerOptions0.checkMissingGetCssNameLevel;
    boolean b5 = compilerOptions0.flowSensitiveInlineVariables;
    compilerOptions0.groupVariableDeclarations = true;
    boolean b8 = compilerOptions0.tightenTypes;
    compilerOptions0.inlineVariables = true;
    java.util.Set set11 = compilerOptions0.stripNameSuffixes;
    compilerOptions0.convertToDottedProperties = false;
    compilerOptions0.markNoSideEffectCalls = false;
    boolean b16 = compilerOptions0.inlineLocalVariables;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);

  }

  @Test
  public void test046() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test046"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    boolean b3 = compilerOptions0.computeFunctionSideEffects;
    com.google.javascript.jscomp.CheckLevel checkLevel4 = compilerOptions0.checkMissingGetCssNameLevel;
    boolean b5 = compilerOptions0.flowSensitiveInlineVariables;
    boolean b6 = compilerOptions0.removeUnusedPrototypePropertiesInExterns;
    boolean b7 = compilerOptions0.removeDeadCode;
    boolean b8 = compilerOptions0.checkSuspiciousCode;
    compilerOptions0.checkSymbols = false;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);

  }

  @Test
  public void test047() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test047"); }


    com.google.javascript.jscomp.SourceFile sourceFile1 = com.google.javascript.jscomp.SourceFile.fromFile("function ({proxy:{1307993529}}): {proxy:{968451595}}");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(sourceFile1);

  }

  @Test
  public void test048() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test048"); }


    com.google.javascript.jscomp.DiagnosticGroup diagnosticGroup0 = com.google.javascript.jscomp.DiagnosticGroups.DEPRECATED;
    com.google.javascript.jscomp.DiagnosticGroups.INVALID_CASTS = diagnosticGroup0;
    com.google.javascript.jscomp.DiagnosticGroups.ACCESS_CONTROLS = diagnosticGroup0;
    com.google.javascript.jscomp.DiagnosticGroups.AMBIGUOUS_FUNCTION_DECL = diagnosticGroup0;
    com.google.javascript.jscomp.DiagnosticGroups.CHECK_VARIABLES = diagnosticGroup0;
    com.google.javascript.jscomp.CompilerOptions compilerOptions5 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b6 = compilerOptions5.gatherCssNames;
    java.lang.String str7 = compilerOptions5.aliasableGlobals;
    boolean b8 = compilerOptions5.removeDeadCode;
    compilerOptions5.setLooseTypes(false);
    boolean b11 = compilerOptions5.markNoSideEffectCalls;
    com.google.javascript.jscomp.CheckLevel checkLevel12 = compilerOptions5.checkGlobalNamesLevel;
    com.google.javascript.jscomp.DiagnosticGroupWarningsGuard diagnosticGroupWarningsGuard13 = new com.google.javascript.jscomp.DiagnosticGroupWarningsGuard(diagnosticGroup0, checkLevel12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticGroup0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel12);

  }

  @Test
  public void test049() {}
// Defects4J: flaky method
//   @Test
//   public void test049() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test049"); }
// 
// 
//     // The following exception was thrown during execution in test generation
//     try {
//       com.google.javascript.rhino.Context.reportError("null.prototype", "function ({proxy:{1017305348}}): {proxy:{99123531}}", 124, "Not declared as a constructor", 62);
//       org.junit.Assert.fail("Expected exception of type com.google.javascript.rhino.EvaluatorException");
//     } catch (com.google.javascript.rhino.EvaluatorException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("com.google.javascript.rhino.EvaluatorException")) {
//         org.junit.Assert.fail("Expected exception of type com.google.javascript.rhino.EvaluatorException, got " + e.getClass().getCanonicalName());
//       }
//     }
// 
//   }

  @Test
  public void test050() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test050"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    java.lang.String str3 = compilerOptions0.inputDelimiter;
    compilerOptions0.checkSymbols = false;
    compilerOptions0.computeFunctionSideEffects = false;
    compilerOptions0.convertToDottedProperties = true;
    com.google.javascript.jscomp.CompilerOptions compilerOptions10 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions10.collapseVariableDeclarations = true;
    compilerOptions10.setSummaryDetailLevel(86);
    compilerOptions10.setDefineToBooleanLiteral("hi!", false);
    boolean b18 = compilerOptions10.instrumentForCoverage;
    com.google.common.collect.Multimap multimap19 = null;
    compilerOptions10.customPasses = multimap19;
    boolean b21 = compilerOptions10.inferTypesInGlobalScope;
    com.google.javascript.jscomp.ErrorFormat errorFormat22 = compilerOptions10.errorFormat;
    boolean b23 = compilerOptions10.lineBreak;
    compilerOptions10.collapseVariableDeclarations = true;
    com.google.javascript.jscomp.CheckLevel checkLevel26 = compilerOptions10.checkMethods;
    compilerOptions0.checkMissingReturn = checkLevel26;
    compilerOptions0.aliasKeywords = true;
    boolean b30 = compilerOptions0.aliasExternals;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str3 + "' != '" + "// Input %num%"+ "'", str3.equals("// Input %num%"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b21 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);

  }

  @Test
  public void test051() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test051"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter4 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry5 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter4);
    com.google.javascript.rhino.jstype.StaticScope staticScope6 = null;
    com.google.javascript.rhino.jstype.JSType jSType11 = jSTypeRegistry5.getForgivingType(staticScope6, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter12 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry13 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter12);
    com.google.javascript.rhino.jstype.StaticScope staticScope14 = null;
    com.google.javascript.rhino.jstype.JSType jSType19 = jSTypeRegistry13.getForgivingType(staticScope14, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array20 = new com.google.javascript.rhino.jstype.JSType[] { jSType19 };
    com.google.javascript.rhino.jstype.FunctionType functionType21 = jSTypeRegistry1.createFunctionType(jSType11, jSType_array20);
    com.google.javascript.rhino.jstype.JSType jSType22 = functionType21.unboxesTo();
    java.lang.String str23 = functionType21.getReferenceName();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType24 = functionType21.getPrototype();
    com.google.javascript.rhino.jstype.JSType jSType25 = functionPrototypeType24.unboxesTo();
    com.google.javascript.rhino.jstype.FunctionType functionType26 = functionPrototypeType24.getOwnerFunction();
    int i27 = functionPrototypeType24.getPropertiesCount();
    boolean b28 = functionPrototypeType24.isString();
    com.google.javascript.rhino.ErrorReporter errorReporter29 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry30 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter29);
    jSTypeRegistry30.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter33 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry34 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter33);
    com.google.javascript.rhino.jstype.StaticScope staticScope35 = null;
    com.google.javascript.rhino.jstype.JSType jSType40 = jSTypeRegistry34.getForgivingType(staticScope35, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter41 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry42 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter41);
    com.google.javascript.rhino.jstype.StaticScope staticScope43 = null;
    com.google.javascript.rhino.jstype.JSType jSType48 = jSTypeRegistry42.getForgivingType(staticScope43, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array49 = new com.google.javascript.rhino.jstype.JSType[] { jSType48 };
    com.google.javascript.rhino.jstype.FunctionType functionType50 = jSTypeRegistry30.createFunctionType(jSType40, jSType_array49);
    com.google.javascript.rhino.jstype.JSType jSType51 = functionType50.unboxesTo();
    java.lang.String str52 = functionType50.getReferenceName();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType53 = functionType50.getPrototype();
    com.google.javascript.rhino.jstype.JSType jSType54 = functionPrototypeType53.unboxesTo();
    com.google.javascript.rhino.jstype.JSType jSType55 = functionPrototypeType53.unboxesTo();
    com.google.javascript.rhino.jstype.FunctionType functionType56 = functionPrototypeType53.getOwnerFunction();
    boolean b57 = functionPrototypeType24.isSubtype((com.google.javascript.rhino.jstype.JSType)functionPrototypeType53);
    com.google.javascript.rhino.jstype.JSType jSType58 = functionPrototypeType24.unboxesTo();
    java.lang.Iterable iterable59 = functionPrototypeType24.getCtorImplementedInterfaces();
    com.google.javascript.rhino.jstype.ObjectType objectType60 = functionPrototypeType24.getImplicitPrototype();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i27 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b57 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(iterable59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(objectType60);

  }

  @Test
  public void test052() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test052"); }


    com.google.javascript.jscomp.SourceFile.Generator generator1 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile2 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator1);
    com.google.javascript.jscomp.CompilerInput compilerInput3 = new com.google.javascript.jscomp.CompilerInput(jSSourceFile2);
    boolean b4 = compilerInput3.isExtern();
    com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list7 = jSModule6.getDependencies();
    java.util.List list8 = jSModule6.getProvides();
    compilerInput3.setModule(jSModule6);
    java.lang.String str10 = compilerInput3.getName();
    compilerInput3.clearAst();
    boolean b12 = compilerInput3.isExtern();
    // The following exception was thrown during execution in test generation
    try {
      java.util.Collection collection13 = compilerInput3.getRequires();
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str10 + "' != '" + ""+ "'", str10.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);

  }

  @Test
  public void test053() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test053"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.smartNameRemoval;
    boolean b2 = compilerOptions0.reserveRawExports;
    compilerOptions0.tightenTypes = false;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);

  }

  @Test
  public void test054() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test054"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    compilerOptions0.setDefineToBooleanLiteral("hi!", false);
    boolean b8 = compilerOptions0.instrumentForCoverage;
    com.google.common.collect.Multimap multimap9 = null;
    compilerOptions0.customPasses = multimap9;
    boolean b11 = compilerOptions0.inferTypesInGlobalScope;
    com.google.javascript.jscomp.ErrorFormat errorFormat12 = compilerOptions0.errorFormat;
    com.google.javascript.jscomp.CheckLevel checkLevel13 = compilerOptions0.checkGlobalThisLevel;
    boolean b14 = compilerOptions0.inlineGetters;
    java.lang.String str15 = com.google.javascript.rhino.ScriptRuntime.toString((java.lang.Object)compilerOptions0);
    java.util.Set set16 = compilerOptions0.stripNameSuffixes;
    compilerOptions0.convertToDottedProperties = false;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set16);

  }

  @Test
  public void test055() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test055"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.jstype.StaticScope staticScope2 = null;
    com.google.javascript.rhino.jstype.JSType jSType7 = jSTypeRegistry1.getForgivingType(staticScope2, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter8 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry9 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter8);
    com.google.javascript.rhino.ErrorReporter errorReporter10 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry11 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter10);
    jSTypeRegistry11.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter22 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry23 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter22);
    com.google.javascript.rhino.jstype.StaticScope staticScope24 = null;
    com.google.javascript.rhino.jstype.JSType jSType29 = jSTypeRegistry23.getForgivingType(staticScope24, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array30 = new com.google.javascript.rhino.jstype.JSType[] { jSType29 };
    com.google.javascript.rhino.jstype.FunctionType functionType31 = jSTypeRegistry11.createFunctionType(jSType21, jSType_array30);
    com.google.javascript.rhino.jstype.JSType jSType32 = functionType31.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter34 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry35 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter34);
    jSTypeRegistry35.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter46 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry47 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter46);
    com.google.javascript.rhino.jstype.StaticScope staticScope48 = null;
    com.google.javascript.rhino.jstype.JSType jSType53 = jSTypeRegistry47.getForgivingType(staticScope48, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array54 = new com.google.javascript.rhino.jstype.JSType[] { jSType53 };
    com.google.javascript.rhino.jstype.FunctionType functionType55 = jSTypeRegistry35.createFunctionType(jSType45, jSType_array54);
    com.google.javascript.rhino.jstype.FunctionType functionType56 = jSTypeRegistry9.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType31, false, jSType_array54);
    com.google.javascript.rhino.ErrorReporter errorReporter57 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry58 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter57);
    com.google.javascript.rhino.ErrorReporter errorReporter59 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry60 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter59);
    jSTypeRegistry60.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter71 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry72 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter71);
    com.google.javascript.rhino.jstype.StaticScope staticScope73 = null;
    com.google.javascript.rhino.jstype.JSType jSType78 = jSTypeRegistry72.getForgivingType(staticScope73, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array79 = new com.google.javascript.rhino.jstype.JSType[] { jSType78 };
    com.google.javascript.rhino.jstype.FunctionType functionType80 = jSTypeRegistry60.createFunctionType(jSType70, jSType_array79);
    com.google.javascript.rhino.Node node82 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable83 = node82.getAncestors();
    java.lang.String str84 = node82.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType85 = jSTypeRegistry58.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType80, node82);
    com.google.javascript.rhino.jstype.JSType jSType87 = jSTypeRegistry9.getGreatestSubtypeWithProperty((com.google.javascript.rhino.jstype.JSType)functionType80, "EOF");
    com.google.javascript.rhino.jstype.JSType jSType88 = jSTypeRegistry1.createDefaultObjectUnion((com.google.javascript.rhino.jstype.JSType)functionType80);
    boolean b89 = functionType80.isReturnTypeInferred();
    com.google.javascript.rhino.JSDocInfo jSDocInfo90 = functionType80.getJSDocInfo();
    com.google.javascript.rhino.Node node91 = functionType80.getSource();
    boolean b92 = functionType80.isInstanceType();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType78);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable83);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str84 + "' != '" + "EOF"+ "'", str84.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType87);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType88);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b89 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSDocInfo90);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(node91);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b92 == false);

  }

  @Test
  public void test056() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test056"); }


    java.util.logging.Logger logger0 = null;
    com.google.javascript.jscomp.LoggerErrorManager loggerErrorManager1 = new com.google.javascript.jscomp.LoggerErrorManager(logger0);
    double d2 = loggerErrorManager1.getTypedPercent();
    com.google.javascript.jscomp.Compiler compiler3 = new com.google.javascript.jscomp.Compiler((com.google.javascript.jscomp.ErrorManager)loggerErrorManager1);
    com.google.javascript.rhino.JSDocInfo jSDocInfo4 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str5 = jSDocInfo4.getTemplateTypeName();
    boolean b6 = jSDocInfo4.isExterns();
    java.util.List list7 = jSDocInfo4.getThrownTypes();
    com.google.javascript.jscomp.NodeTraversal.Callback callback8 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler3, list7, callback8);
    com.google.javascript.jscomp.JSError[] jSError_array10 = compiler3.getMessages();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError_array10);

  }

  @Test
  public void test057() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test057"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    compilerOptions0.setDefineToBooleanLiteral("hi!", false);
    boolean b8 = compilerOptions0.instrumentForCoverage;
    com.google.common.collect.Multimap multimap9 = null;
    compilerOptions0.customPasses = multimap9;
    boolean b11 = compilerOptions0.inferTypesInGlobalScope;
    com.google.javascript.jscomp.ErrorFormat errorFormat12 = compilerOptions0.errorFormat;
    com.google.javascript.jscomp.CheckLevel checkLevel13 = compilerOptions0.checkGlobalThisLevel;
    boolean b14 = compilerOptions0.inlineGetters;
    java.lang.String str15 = compilerOptions0.sourceMapOutputPath;
    boolean b16 = compilerOptions0.inlineConstantVars;
    compilerOptions0.inlineAnonymousFunctionExpressions = true;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);

  }

  @Test
  public void test058() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test058"); }


    com.google.javascript.jscomp.AbstractCompiler abstractCompiler0 = null;
    com.google.javascript.jscomp.NodeTraversal.Callback callback1 = null;
    com.google.javascript.jscomp.NodeTraversal nodeTraversal2 = new com.google.javascript.jscomp.NodeTraversal(abstractCompiler0, callback1);
    com.google.javascript.jscomp.JSModule jSModule4 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list5 = jSModule4.getDependencies();
    nodeTraversal2.traverseRoots(list5);
    com.google.javascript.rhino.FunctionNode functionNode8 = new com.google.javascript.rhino.FunctionNode("");
    int i9 = functionNode8.getFunctionType();
    com.google.javascript.rhino.ErrorReporter errorReporter10 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry11 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter10);
    jSTypeRegistry11.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter22 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry23 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter22);
    com.google.javascript.rhino.jstype.StaticScope staticScope24 = null;
    com.google.javascript.rhino.jstype.JSType jSType29 = jSTypeRegistry23.getForgivingType(staticScope24, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array30 = new com.google.javascript.rhino.jstype.JSType[] { jSType29 };
    com.google.javascript.rhino.jstype.FunctionType functionType31 = jSTypeRegistry11.createFunctionType(jSType21, jSType_array30);
    boolean b32 = functionType31.isConstructor();
    functionNode8.setJSType((com.google.javascript.rhino.jstype.JSType)functionType31);
    com.google.javascript.jscomp.DiagnosticType diagnosticType34 = com.google.javascript.jscomp.NodeTraversal.NODE_TRAVERSAL_ERROR;
    java.text.MessageFormat messageFormat35 = diagnosticType34.format;
    java.lang.String[] str_array36 = com.google.javascript.rhino.ScriptRuntime.emptyStrings;
    com.google.javascript.jscomp.JSError jSError37 = nodeTraversal2.makeError((com.google.javascript.rhino.Node)functionNode8, diagnosticType34, str_array36);
    java.lang.String str38 = diagnosticType34.key;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i9 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormat35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str38 + "' != '" + "JSC_NODE_TRAVERSAL_ERROR"+ "'", str38.equals("JSC_NODE_TRAVERSAL_ERROR"));

  }

  @Test
  public void test059() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test059"); }


    com.google.javascript.rhino.Context context0 = new com.google.javascript.rhino.Context();
    com.google.javascript.rhino.ErrorReporter errorReporter1 = context0.getErrorReporter();
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    jSTypeRegistry3.setTemplateTypeName("EOF");
    com.google.javascript.rhino.jstype.JSType jSType12 = jSTypeRegistry3.createNamedType("", "EOF", 105, 126);
    com.google.javascript.rhino.ErrorReporter errorReporter13 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry14 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter13);
    com.google.javascript.rhino.jstype.StaticScope staticScope15 = null;
    com.google.javascript.rhino.jstype.JSType jSType20 = jSTypeRegistry14.getForgivingType(staticScope15, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter21 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry22 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter21);
    com.google.javascript.rhino.jstype.StaticScope staticScope23 = null;
    com.google.javascript.rhino.jstype.JSType jSType28 = jSTypeRegistry22.getForgivingType(staticScope23, "hi!", "", 0, 1);
    boolean b29 = jSType28.isEnumType();
    boolean b30 = jSType28.isResolved();
    boolean b31 = jSType20.differsFrom(jSType28);
    boolean b32 = jSType28.isTemplateType();
    com.google.javascript.jscomp.JSModule jSModule34 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list35 = jSModule34.getDependencies();
    com.google.javascript.rhino.jstype.FunctionType functionType36 = jSTypeRegistry3.createFunctionType(jSType28, list35);
    context0.seal((java.lang.Object)jSTypeRegistry3);
    com.google.javascript.rhino.jstype.StaticScope staticScope38 = null;
    jSTypeRegistry3.resolveTypesInScope(staticScope38);
    java.lang.Object obj40 = null;
    java.lang.RuntimeException runtimeException41 = com.google.javascript.rhino.ScriptRuntime.undefReadError((java.lang.Object)staticScope38, obj40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(errorReporter1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(runtimeException41);

  }

  @Test
  public void test060() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test060"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.Node node25 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable26 = node25.getAncestors();
    java.lang.String str27 = node25.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType28 = jSTypeRegistry1.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType23, node25);
    com.google.javascript.rhino.JSDocInfo jSDocInfo29 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str30 = jSDocInfo29.getTemplateTypeName();
    boolean b31 = jSDocInfo29.hasEnumParameterType();
    functionType23.setJSDocInfo(jSDocInfo29);
    boolean b33 = jSDocInfo29.isNoShadow();
    boolean b34 = jSDocInfo29.isOverride();
    boolean b35 = jSDocInfo29.isNoSideEffects();
    java.lang.String str36 = jSDocInfo29.getMeaning();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str27 + "' != '" + "EOF"+ "'", str27.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b34 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str36);

  }

  @Test
  public void test061() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test061"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.gatherCssNames;
    java.lang.String str2 = compilerOptions0.aliasableGlobals;
    boolean b3 = compilerOptions0.removeDeadCode;
    com.google.javascript.jscomp.MessageBundle messageBundle4 = compilerOptions0.messageBundle;
    compilerOptions0.disambiguateProperties = false;
    com.google.javascript.jscomp.CheckLevel checkLevel7 = compilerOptions0.checkMethods;
    compilerOptions0.extractPrototypeMemberDeclarations = true;
    boolean b10 = compilerOptions0.checkSymbols;
    boolean b11 = compilerOptions0.checkControlStructures;
    java.util.Set set12 = compilerOptions0.stripTypes;
    boolean b13 = compilerOptions0.checkDuplicateMessages;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(messageBundle4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);

  }

  @Test
  public void test062() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test062"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    boolean b3 = compilerOptions0.inlineConstantVars;
    java.lang.String str4 = compilerOptions0.aliasableGlobals;
    compilerOptions0.specializeInitialModule = false;
    java.util.Set set7 = compilerOptions0.stripTypes;
    compilerOptions0.removeEmptyFunctions = true;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set7);

  }

  @Test
  public void test063() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test063"); }


    com.google.javascript.rhino.FunctionNode functionNode1 = new com.google.javascript.rhino.FunctionNode("");
    int i2 = functionNode1.getFunctionType();
    java.lang.String str3 = functionNode1.getFunctionName();
    boolean b4 = functionNode1.hasMoreThanOneChild();
    functionNode1.setBaseLineno(4095);
    com.google.javascript.rhino.FunctionNode functionNode8 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String str9 = functionNode8.getFunctionName();
    com.google.javascript.jscomp.AbstractCompiler abstractCompiler10 = null;
    com.google.javascript.jscomp.NodeTraversal.Callback callback11 = null;
    com.google.javascript.jscomp.NodeTraversal nodeTraversal12 = new com.google.javascript.jscomp.NodeTraversal(abstractCompiler10, callback11);
    com.google.javascript.jscomp.JSModule jSModule14 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list15 = jSModule14.getDependencies();
    nodeTraversal12.traverseRoots(list15);
    com.google.javascript.rhino.ErrorReporter errorReporter17 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry18 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter17);
    jSTypeRegistry18.forwardDeclareType("hi!");
    com.google.javascript.rhino.jstype.FunctionParamBuilder functionParamBuilder21 = new com.google.javascript.rhino.jstype.FunctionParamBuilder(jSTypeRegistry18);
    com.google.javascript.rhino.Node node22 = functionParamBuilder21.build();
    com.google.javascript.jscomp.DiagnosticType diagnosticType23 = com.google.javascript.jscomp.NodeTraversal.NODE_TRAVERSAL_ERROR;
    java.text.MessageFormat messageFormat24 = diagnosticType23.format;
    java.lang.String[] str_array25 = null;
    com.google.javascript.jscomp.JSError jSError26 = nodeTraversal12.makeError(node22, diagnosticType23, str_array25);
    boolean b27 = functionNode8.checkTreeTypeAwareEqualsSilent(node22);
    java.lang.String str28 = functionNode8.getFunctionName();
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable29 = functionNode8.getAncestors();
    functionNode1.setCompilerData((java.lang.Object)functionNode8);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression32 = new com.google.javascript.rhino.JSTypeExpression((com.google.javascript.rhino.Node)functionNode8, "function ({proxy:{78039409}}): {proxy:{384921772}}");
    com.google.javascript.rhino.Node node37 = new com.google.javascript.rhino.Node(54, 151, 76);
    com.google.javascript.rhino.Node node40 = new com.google.javascript.rhino.Node(0, node37, 90, 110);
    com.google.javascript.rhino.Node node41 = node37.detachFromParent();
    com.google.javascript.rhino.jstype.JSType jSType42 = node41.getJSType();
    com.google.javascript.rhino.FunctionNode functionNode45 = new com.google.javascript.rhino.FunctionNode("");
    int i46 = functionNode45.getFunctionType();
    java.lang.String str47 = functionNode45.getFunctionName();
    com.google.javascript.rhino.Node node50 = new com.google.javascript.rhino.Node(91, (com.google.javascript.rhino.Node)functionNode45, 12, 13);
    com.google.javascript.rhino.Node node52 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("error reporter");
    com.google.javascript.rhino.Node node53 = functionNode45.copyInformationFrom(node52);
    com.google.javascript.rhino.Node node54 = node41.copyInformationFromForTree((com.google.javascript.rhino.Node)functionNode45);
    com.google.javascript.rhino.Node node56 = node54.getAncestor(76);
    boolean b57 = functionNode8.hasChild(node56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str3 + "' != '" + ""+ "'", str3.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str9 + "' != '" + ""+ "'", str9.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormat24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str28 + "' != '" + ""+ "'", str28.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i46 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str47 + "' != '" + ""+ "'", str47.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(node56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b57 == false);

  }

  @Test
  public void test064() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test064"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    compilerOptions0.setDefineToBooleanLiteral("hi!", false);
    boolean b8 = compilerOptions0.instrumentForCoverage;
    boolean b9 = compilerOptions0.foldConstants;
    compilerOptions0.nameReferenceReportPath = "error reporter";
    java.util.Map map12 = compilerOptions0.getDefineReplacements();
    compilerOptions0.setRewriteNewDateGoogNow(false);
    java.lang.String str15 = compilerOptions0.sourceMapOutputPath;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(map12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str15);

  }

  @Test
  public void test065() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test065"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.jstype.StaticScope staticScope2 = null;
    com.google.javascript.rhino.jstype.JSType jSType7 = jSTypeRegistry1.getForgivingType(staticScope2, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter8 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry9 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter8);
    com.google.javascript.rhino.ErrorReporter errorReporter10 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry11 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter10);
    jSTypeRegistry11.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter22 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry23 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter22);
    com.google.javascript.rhino.jstype.StaticScope staticScope24 = null;
    com.google.javascript.rhino.jstype.JSType jSType29 = jSTypeRegistry23.getForgivingType(staticScope24, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array30 = new com.google.javascript.rhino.jstype.JSType[] { jSType29 };
    com.google.javascript.rhino.jstype.FunctionType functionType31 = jSTypeRegistry11.createFunctionType(jSType21, jSType_array30);
    com.google.javascript.rhino.jstype.JSType jSType32 = functionType31.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter34 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry35 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter34);
    jSTypeRegistry35.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter46 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry47 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter46);
    com.google.javascript.rhino.jstype.StaticScope staticScope48 = null;
    com.google.javascript.rhino.jstype.JSType jSType53 = jSTypeRegistry47.getForgivingType(staticScope48, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array54 = new com.google.javascript.rhino.jstype.JSType[] { jSType53 };
    com.google.javascript.rhino.jstype.FunctionType functionType55 = jSTypeRegistry35.createFunctionType(jSType45, jSType_array54);
    com.google.javascript.rhino.jstype.FunctionType functionType56 = jSTypeRegistry9.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType31, false, jSType_array54);
    com.google.javascript.rhino.ErrorReporter errorReporter57 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry58 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter57);
    com.google.javascript.rhino.ErrorReporter errorReporter59 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry60 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter59);
    jSTypeRegistry60.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter71 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry72 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter71);
    com.google.javascript.rhino.jstype.StaticScope staticScope73 = null;
    com.google.javascript.rhino.jstype.JSType jSType78 = jSTypeRegistry72.getForgivingType(staticScope73, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array79 = new com.google.javascript.rhino.jstype.JSType[] { jSType78 };
    com.google.javascript.rhino.jstype.FunctionType functionType80 = jSTypeRegistry60.createFunctionType(jSType70, jSType_array79);
    com.google.javascript.rhino.Node node82 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable83 = node82.getAncestors();
    java.lang.String str84 = node82.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType85 = jSTypeRegistry58.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType80, node82);
    com.google.javascript.rhino.jstype.JSType jSType87 = jSTypeRegistry9.getGreatestSubtypeWithProperty((com.google.javascript.rhino.jstype.JSType)functionType80, "EOF");
    com.google.javascript.rhino.jstype.JSType jSType88 = jSTypeRegistry1.createDefaultObjectUnion((com.google.javascript.rhino.jstype.JSType)functionType80);
    boolean b89 = functionType80.isRegexpType();
    boolean b90 = functionType80.isStringObjectType();
    com.google.javascript.rhino.FunctionNode functionNode92 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String str93 = functionNode92.getFunctionName();
    functionType80.setSource((com.google.javascript.rhino.Node)functionNode92);
    functionNode92.setSourceName("Named type with empty name component");
    boolean b97 = functionNode92.isQuotedString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType78);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable83);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str84 + "' != '" + "EOF"+ "'", str84.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType87);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType88);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b89 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b90 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str93 + "' != '" + ""+ "'", str93.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b97 == false);

  }

  @Test
  public void test066() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test066"); }


    com.google.javascript.jscomp.Compiler compiler0 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState1 = compiler0.getState();
    com.google.javascript.rhino.Node node2 = compiler0.getRoot();
    com.google.javascript.jscomp.CompilerOptions compilerOptions3 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b4 = compilerOptions3.gatherCssNames;
    java.lang.String str5 = compilerOptions3.aliasableGlobals;
    java.lang.String str6 = compilerOptions3.instrumentationTemplate;
    boolean b7 = compilerOptions3.inlineGetters;
    compiler0.initOptions(compilerOptions3);
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry9 = compiler0.getTypeRegistry();
    com.google.javascript.rhino.ErrorReporter errorReporter10 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry11 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter10);
    jSTypeRegistry11.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter22 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry23 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter22);
    com.google.javascript.rhino.jstype.StaticScope staticScope24 = null;
    com.google.javascript.rhino.jstype.JSType jSType29 = jSTypeRegistry23.getForgivingType(staticScope24, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array30 = new com.google.javascript.rhino.jstype.JSType[] { jSType29 };
    com.google.javascript.rhino.jstype.FunctionType functionType31 = jSTypeRegistry11.createFunctionType(jSType21, jSType_array30);
    com.google.javascript.rhino.jstype.JSType jSType32 = functionType31.unboxesTo();
    java.lang.String str33 = functionType31.getReferenceName();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType34 = functionType31.getPrototype();
    com.google.javascript.rhino.jstype.JSType jSType35 = functionPrototypeType34.unboxesTo();
    com.google.javascript.rhino.jstype.JSType jSType36 = functionPrototypeType34.unboxesTo();
    com.google.javascript.rhino.jstype.FunctionType functionType37 = functionPrototypeType34.getOwnerFunction();
    boolean b39 = functionPrototypeType34.hasOwnProperty("function (this:{797389023}, {proxy:{1933578632}}): function ({proxy:{1149450402}}): {proxy:{941639620}}");
    java.util.Set set40 = functionPrototypeType34.getOwnPropertyNames();
    com.google.javascript.rhino.jstype.ObjectType objectType41 = functionPrototypeType34.getImplicitPrototype();
    com.google.javascript.rhino.jstype.JSType jSType42 = jSTypeRegistry9.createOptionalType((com.google.javascript.rhino.jstype.JSType)functionPrototypeType34);
    com.google.javascript.rhino.jstype.JSType jSType44 = functionPrototypeType34.getPropertyType("function (this:{797389023}, {proxy:{1933578632}}): function ({proxy:{1149450402}}): {proxy:{941639620}}");
    com.google.javascript.rhino.ErrorReporter errorReporter45 = null;
    com.google.javascript.rhino.jstype.StaticScope staticScope46 = null;
    com.google.javascript.rhino.jstype.JSType jSType47 = functionPrototypeType34.resolve(errorReporter45, staticScope46);
    java.lang.String str48 = functionPrototypeType34.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(node2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSTypeRegistry9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(objectType41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str48 + "' != '" + "{...}"+ "'", str48.equals("{...}"));

  }

  @Test
  public void test067() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test067"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    com.google.javascript.rhino.jstype.FunctionParamBuilder functionParamBuilder4 = new com.google.javascript.rhino.jstype.FunctionParamBuilder(jSTypeRegistry1);
    com.google.javascript.rhino.ErrorReporter errorReporter5 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry6 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter5);
    jSTypeRegistry6.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter9 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry10 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter9);
    com.google.javascript.rhino.jstype.StaticScope staticScope11 = null;
    com.google.javascript.rhino.jstype.JSType jSType16 = jSTypeRegistry10.getForgivingType(staticScope11, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter17 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry18 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter17);
    com.google.javascript.rhino.jstype.StaticScope staticScope19 = null;
    com.google.javascript.rhino.jstype.JSType jSType24 = jSTypeRegistry18.getForgivingType(staticScope19, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array25 = new com.google.javascript.rhino.jstype.JSType[] { jSType24 };
    com.google.javascript.rhino.jstype.FunctionType functionType26 = jSTypeRegistry6.createFunctionType(jSType16, jSType_array25);
    com.google.javascript.rhino.jstype.JSType jSType27 = jSTypeRegistry1.createUnionType(jSType_array25);
    jSTypeRegistry1.setLastGeneration(true);
    jSTypeRegistry1.resetForTypeCheck();
    jSTypeRegistry1.identifyEnumName("// Input %num%");
    com.google.javascript.jscomp.CompilerOptions compilerOptions33 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions33.collapseVariableDeclarations = true;
    boolean b36 = compilerOptions33.inlineConstantVars;
    java.util.Map map37 = compilerOptions33.getDefineReplacements();
    com.google.javascript.rhino.jstype.RecordType recordType38 = jSTypeRegistry1.createRecordType(map37);
    com.google.javascript.rhino.ErrorReporter errorReporter39 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry40 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter39);
    com.google.javascript.rhino.jstype.StaticScope staticScope41 = null;
    com.google.javascript.rhino.jstype.JSType jSType46 = jSTypeRegistry40.getForgivingType(staticScope41, "", "Named type with empty name component", 53, 108);
    boolean b47 = jSType46.isBooleanObjectType();
    boolean b48 = recordType38.isEquivalentTo(jSType46);
    boolean b50 = recordType38.isPropertyInExterns("JSC_NODE_TRAVERSAL_ERROR: {0}");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(map37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(recordType38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b47 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b48 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b50 == false);

  }

  @Test
  public void test068() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test068"); }


    com.google.javascript.rhino.JSDocInfo jSDocInfo0 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str1 = jSDocInfo0.getTemplateTypeName();
    boolean b2 = jSDocInfo0.isExterns();
    boolean b3 = jSDocInfo0.shouldPreserveTry();
    boolean b4 = jSDocInfo0.isConstant();
    boolean b5 = jSDocInfo0.hasModifies();
    boolean b6 = jSDocInfo0.shouldPreserveTry();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);

  }

  @Test
  public void test069() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test069"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b3 = jSDocInfoBuilder1.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression4 = null;
    boolean b5 = jSDocInfoBuilder1.recordReturnType(jSTypeExpression4);
    boolean b6 = jSDocInfoBuilder1.recordHiddenness();
    boolean b7 = jSDocInfoBuilder1.recordConstructor();
    boolean b9 = jSDocInfoBuilder1.recordReturnDescription("Not declared as a type name");
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder11 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression12 = null;
    boolean b13 = jSDocInfoBuilder11.recordTypedef(jSTypeExpression12);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression14 = null;
    boolean b16 = jSDocInfoBuilder11.recordThrowDescription(jSTypeExpression14, "hi!");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression17 = null;
    boolean b18 = jSDocInfoBuilder11.recordThisType(jSTypeExpression17);
    boolean b20 = jSDocInfoBuilder11.recordMeaning("");
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder22 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression23 = null;
    boolean b24 = jSDocInfoBuilder22.recordTypedef(jSTypeExpression23);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression25 = null;
    boolean b27 = jSDocInfoBuilder22.recordThrowDescription(jSTypeExpression25, "hi!");
    boolean b28 = jSDocInfoBuilder22.isConstructorRecorded();
    com.google.javascript.rhino.JSDocInfo.Visibility visibility29 = com.google.javascript.rhino.JSDocInfo.Visibility.PROTECTED;
    boolean b30 = jSDocInfoBuilder22.recordVisibility(visibility29);
    boolean b31 = jSDocInfoBuilder11.recordVisibility(visibility29);
    boolean b32 = jSDocInfoBuilder1.recordVisibility(visibility29);
    boolean b33 = jSDocInfoBuilder1.recordExterns();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(visibility29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == true);

  }

  @Test
  public void test070() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test070"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    jSTypeRegistry1.setTemplateTypeName("EOF");
    com.google.javascript.rhino.jstype.JSType jSType10 = jSTypeRegistry1.createNamedType("", "EOF", 105, 126);
    com.google.javascript.rhino.jstype.StaticScope staticScope11 = null;
    com.google.javascript.rhino.jstype.JSType jSType16 = jSTypeRegistry1.getType(staticScope11, "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 148, 148);
    com.google.javascript.rhino.jstype.StaticScope staticScope17 = null;
    com.google.javascript.rhino.jstype.JSType jSType22 = jSTypeRegistry1.getForgivingType(staticScope17, "hi!", "", 23, 4095);
    com.google.javascript.rhino.jstype.ObjectType objectType23 = jSTypeRegistry1.createAnonymousObjectType();
    com.google.javascript.rhino.ErrorReporter errorReporter24 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry25 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter24);
    jSTypeRegistry25.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter28 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry29 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter28);
    com.google.javascript.rhino.jstype.StaticScope staticScope30 = null;
    com.google.javascript.rhino.jstype.JSType jSType35 = jSTypeRegistry29.getForgivingType(staticScope30, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter36 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry37 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter36);
    com.google.javascript.rhino.jstype.StaticScope staticScope38 = null;
    com.google.javascript.rhino.jstype.JSType jSType43 = jSTypeRegistry37.getForgivingType(staticScope38, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array44 = new com.google.javascript.rhino.jstype.JSType[] { jSType43 };
    com.google.javascript.rhino.jstype.FunctionType functionType45 = jSTypeRegistry25.createFunctionType(jSType35, jSType_array44);
    com.google.javascript.rhino.jstype.JSType jSType46 = functionType45.unboxesTo();
    java.lang.String str47 = functionType45.getReferenceName();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType48 = functionType45.getPrototype();
    com.google.javascript.rhino.jstype.JSType jSType49 = functionPrototypeType48.unboxesTo();
    com.google.javascript.rhino.jstype.JSType jSType50 = functionPrototypeType48.unboxesTo();
    com.google.javascript.rhino.jstype.FunctionType functionType51 = functionPrototypeType48.getOwnerFunction();
    com.google.javascript.rhino.jstype.JSType jSType52 = jSTypeRegistry1.createDefaultObjectUnion((com.google.javascript.rhino.jstype.JSType)functionPrototypeType48);
    com.google.javascript.rhino.FunctionNode functionNode54 = new com.google.javascript.rhino.FunctionNode("");
    int i55 = functionNode54.getFunctionType();
    com.google.javascript.rhino.ErrorReporter errorReporter56 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry57 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter56);
    jSTypeRegistry57.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter60 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry61 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter60);
    com.google.javascript.rhino.jstype.StaticScope staticScope62 = null;
    com.google.javascript.rhino.jstype.JSType jSType67 = jSTypeRegistry61.getForgivingType(staticScope62, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter68 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry69 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter68);
    com.google.javascript.rhino.jstype.StaticScope staticScope70 = null;
    com.google.javascript.rhino.jstype.JSType jSType75 = jSTypeRegistry69.getForgivingType(staticScope70, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array76 = new com.google.javascript.rhino.jstype.JSType[] { jSType75 };
    com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry57.createFunctionType(jSType67, jSType_array76);
    boolean b78 = functionType77.isConstructor();
    functionNode54.setJSType((com.google.javascript.rhino.jstype.JSType)functionType77);
    boolean b80 = functionType77.isNumberValueType();
    com.google.javascript.rhino.jstype.JSType jSType82 = functionType77.getPropertyType("JSDocInfo");
    boolean b83 = functionPrototypeType48.canTestForEqualityWith((com.google.javascript.rhino.jstype.JSType)functionType77);
    boolean b84 = functionType77.hasCachedValues();
    com.google.javascript.rhino.jstype.ObjectType objectType85 = functionType77.toObjectType();
    com.google.javascript.rhino.jstype.JSType jSType86 = functionType77.getReturnType();
    com.google.javascript.rhino.jstype.ObjectType objectType87 = com.google.javascript.rhino.jstype.ObjectType.cast(jSType86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(objectType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i55 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array76);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b78 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b80 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b83 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b84 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(objectType85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(objectType87);

  }

  @Test
  public void test071() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test071"); }


    com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler1 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState2 = compiler1.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter4 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler1, true);
    com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list7 = jSModule6.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback8 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler1, list7, callback8);
    com.google.javascript.jscomp.ErrorManager errorManager10 = compiler1.getErrorManager();
    com.google.javascript.jscomp.JSModule jSModule12 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list13 = jSModule12.getDependencies();
    java.util.List list14 = jSModule12.getProvides();
    java.lang.String[] str_array15 = compiler1.toSourceArray(jSModule12);
    com.google.javascript.jscomp.JSModule[] jSModule_array16 = new com.google.javascript.jscomp.JSModule[] { jSModule12 };
    com.google.javascript.jscomp.JSModuleGraph jSModuleGraph17 = new com.google.javascript.jscomp.JSModuleGraph(jSModule_array16);
    com.google.javascript.jscomp.SourceFile.Generator generator19 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile20 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator19);
    com.google.javascript.jscomp.CompilerInput compilerInput21 = new com.google.javascript.jscomp.CompilerInput(jSSourceFile20);
    boolean b22 = compilerInput21.isExtern();
    com.google.javascript.jscomp.JSModule jSModule24 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list25 = jSModule24.getDependencies();
    java.util.List list26 = jSModule24.getProvides();
    compilerInput21.setModule(jSModule24);
    com.google.javascript.jscomp.JSModule jSModule29 = new com.google.javascript.jscomp.JSModule("");
    java.lang.String str30 = jSModule29.getName();
    boolean b31 = jSModuleGraph17.dependsOn(jSModule24, jSModule29);
    com.google.javascript.jscomp.CompilerOptions compilerOptions32 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions32.collapseVariableDeclarations = true;
    compilerOptions32.setSummaryDetailLevel(86);
    compilerOptions32.setDefineToBooleanLiteral("hi!", false);
    boolean b40 = compilerOptions32.instrumentForCoverage;
    compilerOptions32.collapseAnonymousFunctions = false;
    compilerOptions32.appNameStr = "Not declared as a constructor";
    compilerOptions32.unaliasableGlobals = "<No stack trace available>";
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder48 = new com.google.javascript.rhino.JSDocInfoBuilder(false);
    boolean b49 = jSDocInfoBuilder48.recordExport();
    com.google.javascript.jscomp.CompilerOptions compilerOptions50 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b51 = compilerOptions50.gatherCssNames;
    com.google.javascript.jscomp.VariableRenamingPolicy variableRenamingPolicy52 = compilerOptions50.variableRenaming;
    compilerOptions50.exportTestFunctions = true;
    java.util.Set set55 = compilerOptions50.aliasableStrings;
    boolean b56 = jSDocInfoBuilder48.recordSuppressions(set55);
    compilerOptions32.stripTypes = set55;
    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.jscomp.JSModule jSModule58 = jSModuleGraph17.getDeepestCommonDependencyInclusive((java.util.Collection)set55);
      org.junit.Assert.fail("Expected exception of type java.util.NoSuchElementException");
    } catch (java.util.NoSuchElementException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.util.NoSuchElementException")) {
        org.junit.Assert.fail("Expected exception of type java.util.NoSuchElementException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorManager10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSModule_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str30 + "' != '" + ""+ "'", str30.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b49 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b51 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(variableRenamingPolicy52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b56 == true);

  }

  @Test
  public void test072() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test072"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter4 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry5 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter4);
    com.google.javascript.rhino.jstype.StaticScope staticScope6 = null;
    com.google.javascript.rhino.jstype.JSType jSType11 = jSTypeRegistry5.getForgivingType(staticScope6, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter12 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry13 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter12);
    com.google.javascript.rhino.jstype.StaticScope staticScope14 = null;
    com.google.javascript.rhino.jstype.JSType jSType19 = jSTypeRegistry13.getForgivingType(staticScope14, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array20 = new com.google.javascript.rhino.jstype.JSType[] { jSType19 };
    com.google.javascript.rhino.jstype.FunctionType functionType21 = jSTypeRegistry1.createFunctionType(jSType11, jSType_array20);
    boolean b22 = jSType11.isArrayType();
    com.google.javascript.rhino.ErrorReporter errorReporter23 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry24 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter23);
    jSTypeRegistry24.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter27 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry28 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter27);
    com.google.javascript.rhino.jstype.StaticScope staticScope29 = null;
    com.google.javascript.rhino.jstype.JSType jSType34 = jSTypeRegistry28.getForgivingType(staticScope29, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter35 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry36 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter35);
    com.google.javascript.rhino.jstype.StaticScope staticScope37 = null;
    com.google.javascript.rhino.jstype.JSType jSType42 = jSTypeRegistry36.getForgivingType(staticScope37, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array43 = new com.google.javascript.rhino.jstype.JSType[] { jSType42 };
    com.google.javascript.rhino.jstype.FunctionType functionType44 = jSTypeRegistry24.createFunctionType(jSType34, jSType_array43);
    java.lang.String str45 = functionType44.getReferenceName();
    com.google.javascript.rhino.jstype.JSType jSType46 = functionType44.getReturnType();
    boolean b47 = jSType11.isEquivalentTo((com.google.javascript.rhino.jstype.JSType)functionType44);
    boolean b48 = functionType44.isAllType();
    com.google.javascript.rhino.jstype.JSType jSType49 = functionType44.unboxesTo();
    boolean b51 = functionType44.isPropertyInExterns("JSC_NODE_TRAVERSAL_ERROR. {0} at (unknown source) line (unknown line) : (unknown column)");
    boolean b53 = functionType44.hasOwnProperty("function ({proxy:{837129231}}): {proxy:{935070810}}");
    com.google.javascript.rhino.jstype.JSType jSType55 = functionType44.findPropertyType("JSC_NODE_TRAVERSAL_ERROR");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b47 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b48 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b51 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b53 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType55);

  }

  @Test
  public void test073() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test073"); }


    com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler1 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState2 = compiler1.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter4 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler1, true);
    com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list7 = jSModule6.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback8 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler1, list7, callback8);
    com.google.javascript.jscomp.ErrorManager errorManager10 = compiler1.getErrorManager();
    com.google.javascript.jscomp.JSModule jSModule12 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list13 = jSModule12.getDependencies();
    java.util.List list14 = jSModule12.getProvides();
    java.lang.String[] str_array15 = compiler1.toSourceArray(jSModule12);
    com.google.javascript.jscomp.CompilerOptions compilerOptions16 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions16.collapseVariableDeclarations = true;
    compilerOptions16.setSummaryDetailLevel(86);
    compilerOptions16.setDefineToBooleanLiteral("hi!", false);
    boolean b24 = compilerOptions16.instrumentForCoverage;
    com.google.common.collect.Multimap multimap25 = null;
    compilerOptions16.customPasses = multimap25;
    boolean b27 = compilerOptions16.inferTypesInGlobalScope;
    compiler1.initOptions(compilerOptions16);
    boolean b29 = compiler1.isTypeCheckingEnabled();
    // The following exception was thrown during execution in test generation
    try {
      compiler1.processDefines();
      org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException");
    } catch (java.lang.RuntimeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.RuntimeException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorManager10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);

  }

  @Test
  public void test074() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test074"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.gatherCssNames;
    java.lang.String str2 = compilerOptions0.aliasableGlobals;
    boolean b3 = compilerOptions0.removeDeadCode;
    com.google.javascript.jscomp.MessageBundle messageBundle4 = compilerOptions0.messageBundle;
    compilerOptions0.disambiguateProperties = false;
    com.google.javascript.jscomp.CheckLevel checkLevel7 = compilerOptions0.checkUndefinedProperties;
    com.google.javascript.jscomp.CheckLevel checkLevel8 = compilerOptions0.brokenClosureRequiresLevel;
    compilerOptions0.instrumentationTemplate = "goog.exportProperty";
    com.google.javascript.jscomp.WarningsGuard warningsGuard11 = null;
    com.google.javascript.jscomp.WarningsGuard[] warningsGuard_array12 = new com.google.javascript.jscomp.WarningsGuard[] { warningsGuard11 };
    com.google.javascript.jscomp.ComposeWarningsGuard composeWarningsGuard13 = new com.google.javascript.jscomp.ComposeWarningsGuard(warningsGuard_array12);
    compilerOptions0.addWarningsGuard((com.google.javascript.jscomp.WarningsGuard)composeWarningsGuard13);
    com.google.javascript.jscomp.CompilerOptions compilerOptions15 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions15.collapseVariableDeclarations = true;
    compilerOptions15.setSummaryDetailLevel(86);
    compilerOptions15.setDefineToBooleanLiteral("hi!", false);
    boolean b23 = compilerOptions15.instrumentForCoverage;
    com.google.common.collect.Multimap multimap24 = null;
    compilerOptions15.customPasses = multimap24;
    boolean b26 = compilerOptions15.inferTypesInGlobalScope;
    com.google.javascript.jscomp.ErrorFormat errorFormat27 = compilerOptions15.errorFormat;
    com.google.javascript.jscomp.CheckLevel checkLevel28 = compilerOptions15.checkGlobalThisLevel;
    boolean b29 = compilerOptions15.inlineGetters;
    boolean b30 = compilerOptions15.smartNameRemoval;
    com.google.javascript.jscomp.CheckLevel checkLevel31 = compilerOptions15.reportUnknownTypes;
    compilerOptions0.checkFunctions = checkLevel31;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(messageBundle4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(warningsGuard_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel31);

  }

  @Test
  public void test075() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test075"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.jstype.JSType jSType24 = functionType23.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter26 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry27 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter26);
    jSTypeRegistry27.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter30 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry31 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter30);
    com.google.javascript.rhino.jstype.StaticScope staticScope32 = null;
    com.google.javascript.rhino.jstype.JSType jSType37 = jSTypeRegistry31.getForgivingType(staticScope32, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array46 = new com.google.javascript.rhino.jstype.JSType[] { jSType45 };
    com.google.javascript.rhino.jstype.FunctionType functionType47 = jSTypeRegistry27.createFunctionType(jSType37, jSType_array46);
    com.google.javascript.rhino.jstype.FunctionType functionType48 = jSTypeRegistry1.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType23, false, jSType_array46);
    com.google.javascript.rhino.ErrorReporter errorReporter49 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry50 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter49);
    com.google.javascript.rhino.ErrorReporter errorReporter51 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry52 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter51);
    jSTypeRegistry52.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter55 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry56 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter55);
    com.google.javascript.rhino.jstype.StaticScope staticScope57 = null;
    com.google.javascript.rhino.jstype.JSType jSType62 = jSTypeRegistry56.getForgivingType(staticScope57, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array71 = new com.google.javascript.rhino.jstype.JSType[] { jSType70 };
    com.google.javascript.rhino.jstype.FunctionType functionType72 = jSTypeRegistry52.createFunctionType(jSType62, jSType_array71);
    com.google.javascript.rhino.Node node74 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable75 = node74.getAncestors();
    java.lang.String str76 = node74.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry50.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType72, node74);
    functionType23.setPrototypeBasedOn((com.google.javascript.rhino.jstype.ObjectType)functionType77);
    boolean b80 = functionType77.hasOwnProperty("JSDocInfo");
    int i81 = functionType77.getMinArguments();
    java.util.List list82 = functionType77.getSubTypes();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str76 + "' != '" + "EOF"+ "'", str76.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b80 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i81 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(list82);

  }

  @Test
  public void test076() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test076"); }


    com.google.javascript.rhino.JSDocInfo jSDocInfo0 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str1 = jSDocInfo0.getTemplateTypeName();
    boolean b2 = jSDocInfo0.isNoTypeCheck();
    boolean b3 = jSDocInfo0.hasTypedefType();
    boolean b4 = jSDocInfo0.isNoTypeCheck();
    boolean b5 = jSDocInfo0.isExterns();
    java.lang.String str6 = jSDocInfo0.getFileOverview();
    java.util.List list7 = jSDocInfo0.getThrownTypes();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);

  }

  @Test
  public void test077() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test077"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.gatherCssNames;
    java.lang.String str2 = compilerOptions0.aliasableGlobals;
    compilerOptions0.instrumentForCoverageOnly = true;
    compilerOptions0.setDefineToStringLiteral("OFF: Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "goog.exportProperty");
    compilerOptions0.recordFunctionInformation = true;
    boolean b10 = compilerOptions0.ignoreCajaProperties;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);

  }

  @Test
  public void test078() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test078"); }


    com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler1 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState2 = compiler1.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter4 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler1, true);
    com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list7 = jSModule6.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback8 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler1, list7, callback8);
    com.google.javascript.jscomp.JSModuleGraph jSModuleGraph10 = new com.google.javascript.jscomp.JSModuleGraph(list7);
    com.google.javascript.jscomp.JSModule jSModule12 = new com.google.javascript.jscomp.JSModule("");
    jSModule12.clearAsts();
    com.google.javascript.jscomp.SourceFile.Generator generator15 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile16 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator15);
    com.google.javascript.jscomp.CompilerInput compilerInput17 = new com.google.javascript.jscomp.CompilerInput(jSSourceFile16);
    boolean b18 = compilerInput17.isExtern();
    com.google.javascript.jscomp.JSModule jSModule20 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list21 = jSModule20.getDependencies();
    java.util.List list22 = jSModule20.getProvides();
    compilerInput17.setModule(jSModule20);
    com.google.javascript.jscomp.JSModule jSModule24 = jSModuleGraph10.getDeepestCommonDependencyInclusive(jSModule12, jSModule20);
    jSModuleGraph10.coalesceDuplicateFiles();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSModule24);

  }

  @Test
  public void test079() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test079"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSDocInfo jSDocInfo3 = jSDocInfoBuilder1.build("");
    boolean b5 = jSDocInfoBuilder1.recordLends("EOF");
    boolean b7 = jSDocInfoBuilder1.recordBlockDescription("OFF");
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder9 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b11 = jSDocInfoBuilder9.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression12 = null;
    boolean b13 = jSDocInfoBuilder9.recordReturnType(jSTypeExpression12);
    boolean b14 = jSDocInfoBuilder9.recordHiddenness();
    boolean b15 = jSDocInfoBuilder9.recordConstructor();
    boolean b17 = jSDocInfoBuilder9.recordReturnDescription("Not declared as a type name");
    boolean b18 = jSDocInfoBuilder9.recordOverride();
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder20 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b22 = jSDocInfoBuilder20.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression23 = null;
    boolean b24 = jSDocInfoBuilder20.recordReturnType(jSTypeExpression23);
    com.google.javascript.rhino.Node node26 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable27 = node26.getAncestors();
    com.google.javascript.rhino.Node node29 = new com.google.javascript.rhino.Node(0);
    boolean b30 = node26.hasChild(node29);
    com.google.javascript.rhino.Node node32 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str33 = node29.checkTreeEquals(node32);
    com.google.javascript.rhino.Node node34 = node32.cloneNode();
    boolean b35 = node34.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression37 = new com.google.javascript.rhino.JSTypeExpression(node34, "<No stack trace available>");
    boolean b38 = jSDocInfoBuilder20.recordDefineType(jSTypeExpression37);
    boolean b39 = jSDocInfoBuilder9.recordType(jSTypeExpression37);
    boolean b40 = jSDocInfoBuilder1.recordTypedef(jSTypeExpression37);
    jSDocInfoBuilder1.markName("goog.exportSymbol", 0, 116);
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder46 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression47 = null;
    boolean b48 = jSDocInfoBuilder46.recordTypedef(jSTypeExpression47);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression49 = null;
    boolean b51 = jSDocInfoBuilder46.recordThrowDescription(jSTypeExpression49, "hi!");
    boolean b52 = jSDocInfoBuilder46.recordNoSideEffects();
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder54 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSDocInfo jSDocInfo56 = jSDocInfoBuilder54.build("");
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder58 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b59 = jSDocInfoBuilder58.recordExport();
    boolean b61 = jSDocInfoBuilder58.recordBlockDescription("OFF");
    boolean b62 = jSDocInfoBuilder58.recordNoSideEffects();
    boolean b64 = jSDocInfoBuilder58.recordVersion("hi!");
    com.google.javascript.rhino.JSDocInfo jSDocInfo65 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str66 = jSDocInfo65.getTemplateTypeName();
    boolean b67 = jSDocInfo65.hasEnumParameterType();
    boolean b68 = jSDocInfo65.isConstant();
    java.lang.String str69 = jSDocInfo65.getFileOverview();
    boolean b70 = jSDocInfo65.isExport();
    boolean b71 = jSDocInfo65.isOverride();
    java.util.Set set72 = jSDocInfo65.getModifies();
    boolean b73 = jSDocInfoBuilder58.recordModifies(set72);
    boolean b74 = jSDocInfoBuilder58.recordExport();
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder76 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b78 = jSDocInfoBuilder76.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression79 = null;
    boolean b80 = jSDocInfoBuilder76.recordReturnType(jSTypeExpression79);
    com.google.javascript.rhino.Node node82 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable83 = node82.getAncestors();
    com.google.javascript.rhino.Node node85 = new com.google.javascript.rhino.Node(0);
    boolean b86 = node82.hasChild(node85);
    com.google.javascript.rhino.Node node88 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str89 = node85.checkTreeEquals(node88);
    com.google.javascript.rhino.Node node90 = node88.cloneNode();
    boolean b91 = node90.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression93 = new com.google.javascript.rhino.JSTypeExpression(node90, "<No stack trace available>");
    boolean b94 = jSDocInfoBuilder76.recordDefineType(jSTypeExpression93);
    boolean b95 = jSDocInfoBuilder58.recordReturnType(jSTypeExpression93);
    boolean b97 = jSDocInfoBuilder54.recordThrowDescription(jSTypeExpression93, "");
    boolean b98 = jSDocInfoBuilder46.recordTypedef(jSTypeExpression93);
    boolean b99 = jSDocInfoBuilder1.recordReturnType(jSTypeExpression93);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSDocInfo3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str33 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str33.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b48 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b51 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b52 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSDocInfo56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b59 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b61 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b62 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b64 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b67 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b68 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b70 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b71 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b73 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b74 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b78 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b80 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable83);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b86 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node88);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str89 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str89.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node90);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b91 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b94 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b95 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b97 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b98 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b99 == true);

  }

  @Test
  public void test080() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test080"); }


    com.google.javascript.rhino.EcmaError ecmaError6 = com.google.javascript.rhino.ScriptRuntime.constructError("OFF", "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "", 131, "JSC_NODE_TRAVERSAL_ERROR. {0} at Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n line (unknown line) : (unknown column)", 16);
    java.lang.Throwable[] throwable_array7 = ecmaError6.getSuppressed();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ecmaError6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(throwable_array7);

  }

  @Test
  public void test081() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test081"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    java.lang.String str3 = compilerOptions0.inputDelimiter;
    compilerOptions0.checkSymbols = false;
    compilerOptions0.checkTypedPropertyCalls = true;
    compilerOptions0.syntheticBlockEndMarker = "";
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str3 + "' != '" + "// Input %num%"+ "'", str3.equals("// Input %num%"));

  }

  @Test
  public void test082() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test082"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.gatherCssNames;
    java.lang.String str2 = compilerOptions0.aliasableGlobals;
    boolean b3 = compilerOptions0.removeDeadCode;
    compilerOptions0.setLooseTypes(false);
    boolean b6 = compilerOptions0.markNoSideEffectCalls;
    com.google.javascript.jscomp.SourceMap.Format format7 = null;
    compilerOptions0.sourceMapFormat = format7;
    com.google.javascript.jscomp.CodingConvention codingConvention9 = null;
    compilerOptions0.setCodingConvention(codingConvention9);
    boolean b11 = compilerOptions0.markAsCompiled;
    boolean b12 = compilerOptions0.markNoSideEffectCalls;
    compilerOptions0.jsOutputFile = "Named type with empty name component";
    boolean b15 = compilerOptions0.crossModuleMethodMotion;
    compilerOptions0.printInputDelimiter = true;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);

  }

  @Test
  public void test083() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test083"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.jstype.JSType jSType24 = functionType23.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter26 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry27 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter26);
    jSTypeRegistry27.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter30 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry31 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter30);
    com.google.javascript.rhino.jstype.StaticScope staticScope32 = null;
    com.google.javascript.rhino.jstype.JSType jSType37 = jSTypeRegistry31.getForgivingType(staticScope32, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array46 = new com.google.javascript.rhino.jstype.JSType[] { jSType45 };
    com.google.javascript.rhino.jstype.FunctionType functionType47 = jSTypeRegistry27.createFunctionType(jSType37, jSType_array46);
    com.google.javascript.rhino.jstype.FunctionType functionType48 = jSTypeRegistry1.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType23, false, jSType_array46);
    com.google.javascript.rhino.ErrorReporter errorReporter49 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry50 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter49);
    com.google.javascript.rhino.ErrorReporter errorReporter51 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry52 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter51);
    jSTypeRegistry52.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter55 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry56 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter55);
    com.google.javascript.rhino.jstype.StaticScope staticScope57 = null;
    com.google.javascript.rhino.jstype.JSType jSType62 = jSTypeRegistry56.getForgivingType(staticScope57, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array71 = new com.google.javascript.rhino.jstype.JSType[] { jSType70 };
    com.google.javascript.rhino.jstype.FunctionType functionType72 = jSTypeRegistry52.createFunctionType(jSType62, jSType_array71);
    com.google.javascript.rhino.Node node74 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable75 = node74.getAncestors();
    java.lang.String str76 = node74.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry50.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType72, node74);
    functionType23.setPrototypeBasedOn((com.google.javascript.rhino.jstype.ObjectType)functionType77);
    com.google.javascript.rhino.jstype.JSType jSType79 = functionType23.restrictByNotNullOrUndefined();
    boolean b80 = functionType23.isReturnTypeInferred();
    com.google.javascript.rhino.jstype.FunctionType functionType81 = functionType23.getConstructor();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str76 + "' != '" + "EOF"+ "'", str76.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b80 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(functionType81);

  }

  @Test
  public void test084() {}
// Defects4J: flaky method
//   @Test
//   public void test084() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test084"); }
// 
// 
//     com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.LEGACY;
//     com.google.javascript.jscomp.ErrorFormat errorFormat1 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler2 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState3 = compiler2.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter5 = errorFormat1.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler2, true);
//     com.google.javascript.jscomp.JSModule jSModule7 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list8 = jSModule7.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback9 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler2, list8, callback9);
//     com.google.javascript.jscomp.ErrorManager errorManager11 = compiler2.getErrorManager();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter13 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler2, false);
//     com.google.javascript.rhino.Node node14 = compiler2.getRoot();
//     boolean b15 = compiler2.hasErrors();
//     com.google.javascript.jscomp.ErrorFormat errorFormat16 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler17 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState18 = compiler17.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter20 = errorFormat16.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler17, true);
//     com.google.javascript.jscomp.JSModule jSModule22 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list23 = jSModule22.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback24 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler17, list23, callback24);
//     com.google.javascript.jscomp.ErrorManager errorManager26 = compiler17.getErrorManager();
//     com.google.javascript.jscomp.SourceFile.Generator generator28 = null;
//     com.google.javascript.jscomp.JSSourceFile jSSourceFile29 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator28);
//     com.google.javascript.jscomp.JSSourceFile[] jSSourceFile_array30 = new com.google.javascript.jscomp.JSSourceFile[] { jSSourceFile29 };
//     com.google.javascript.jscomp.SourceFile.Generator generator32 = null;
//     com.google.javascript.jscomp.JSSourceFile jSSourceFile33 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator32);
//     com.google.javascript.jscomp.JsAst jsAst34 = new com.google.javascript.jscomp.JsAst((com.google.javascript.jscomp.SourceFile)jSSourceFile33);
//     com.google.javascript.jscomp.JSSourceFile[] jSSourceFile_array35 = new com.google.javascript.jscomp.JSSourceFile[] { jSSourceFile33 };
//     com.google.javascript.jscomp.CompilerOptions compilerOptions36 = new com.google.javascript.jscomp.CompilerOptions();
//     compilerOptions36.collapseVariableDeclarations = true;
//     com.google.javascript.jscomp.Result result39 = compiler17.compile(jSSourceFile_array30, jSSourceFile_array35, compilerOptions36);
//     com.google.javascript.jscomp.ErrorFormat errorFormat40 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler41 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState42 = compiler41.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter44 = errorFormat40.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler41, true);
//     com.google.javascript.jscomp.JSModule jSModule46 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list47 = jSModule46.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback48 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler41, list47, callback48);
//     com.google.javascript.jscomp.ErrorManager errorManager50 = compiler41.getErrorManager();
//     com.google.javascript.jscomp.JSModule jSModule52 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list53 = jSModule52.getDependencies();
//     java.util.List list54 = jSModule52.getProvides();
//     java.lang.String[] str_array55 = compiler41.toSourceArray(jSModule52);
//     com.google.javascript.jscomp.JSModule[] jSModule_array56 = new com.google.javascript.jscomp.JSModule[] { jSModule52 };
//     com.google.javascript.jscomp.JSModuleGraph jSModuleGraph57 = new com.google.javascript.jscomp.JSModuleGraph(jSModule_array56);
//     com.google.javascript.jscomp.JSModuleGraph jSModuleGraph58 = new com.google.javascript.jscomp.JSModuleGraph(jSModule_array56);
//     com.google.javascript.jscomp.CompilerOptions compilerOptions59 = new com.google.javascript.jscomp.CompilerOptions();
//     compilerOptions59.collapseVariableDeclarations = true;
//     java.lang.String str62 = compilerOptions59.inputDelimiter;
//     compilerOptions59.collapseVariableDeclarations = true;
//     // The following exception was thrown during execution in test generation
//     try {
//       com.google.javascript.jscomp.Result result65 = compiler2.compile(jSSourceFile_array30, jSModule_array56, compilerOptions59);
//       org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException");
//     } catch (java.lang.RuntimeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.RuntimeException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorManager11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(node14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b15 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat16);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState18);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter20);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list23);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorManager26);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile29);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile_array30);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile33);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile_array35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(result39);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat40);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState42);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter44);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list47);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorManager50);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list53);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list54);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(str_array55);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSModule_array56);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str62 + "' != '" + "// Input %num%"+ "'", str62.equals("// Input %num%"));
// 
//   }

  @Test
  public void test085() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test085"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b3 = jSDocInfoBuilder1.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression5 = null;
    boolean b6 = jSDocInfoBuilder1.recordParameter("JSDocInfo", jSTypeExpression5);
    java.lang.Object obj7 = null;
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder9 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression10 = null;
    boolean b11 = jSDocInfoBuilder9.recordTypedef(jSTypeExpression10);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression12 = null;
    boolean b14 = jSDocInfoBuilder9.recordThrowDescription(jSTypeExpression12, "hi!");
    boolean b15 = jSDocInfoBuilder9.isConstructorRecorded();
    boolean b16 = jSDocInfoBuilder9.recordNoTypeCheck();
    boolean b17 = jSDocInfoBuilder9.isDescriptionRecorded();
    com.google.javascript.rhino.Node node19 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable20 = node19.getAncestors();
    com.google.javascript.rhino.Node node22 = new com.google.javascript.rhino.Node(0);
    boolean b23 = node19.hasChild(node22);
    com.google.javascript.rhino.Node node25 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str26 = node22.checkTreeEquals(node25);
    com.google.javascript.rhino.Node node27 = node25.cloneNode();
    boolean b28 = node27.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression30 = new com.google.javascript.rhino.JSTypeExpression(node27, "<No stack trace available>");
    boolean b31 = jSDocInfoBuilder9.recordBaseType(jSTypeExpression30);
    java.lang.RuntimeException runtimeException32 = com.google.javascript.rhino.ScriptRuntime.undefCallError(obj7, (java.lang.Object)jSDocInfoBuilder9);
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder34 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression35 = null;
    boolean b36 = jSDocInfoBuilder34.recordTypedef(jSTypeExpression35);
    boolean b38 = jSDocInfoBuilder34.recordBlockDescription("");
    com.google.javascript.rhino.Node node40 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable41 = node40.getAncestors();
    com.google.javascript.rhino.Node node43 = new com.google.javascript.rhino.Node(0);
    boolean b44 = node40.hasChild(node43);
    com.google.javascript.rhino.Node node46 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str47 = node43.checkTreeEquals(node46);
    com.google.javascript.rhino.Node node48 = node46.cloneNode();
    boolean b49 = node48.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression51 = new com.google.javascript.rhino.JSTypeExpression(node48, "<No stack trace available>");
    boolean b52 = jSDocInfoBuilder34.recordReturnType(jSTypeExpression51);
    boolean b53 = jSTypeExpression51.isOptionalArg();
    boolean b54 = jSDocInfoBuilder9.recordImplementedInterface(jSTypeExpression51);
    boolean b55 = jSDocInfoBuilder1.recordImplementedInterface(jSTypeExpression51);
    boolean b57 = jSDocInfoBuilder1.recordMeaning("function (hi!): hi!");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str26 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str26.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(runtimeException32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str47 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str47.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b49 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b52 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b53 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b54 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b55 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b57 == true);

  }

  @Test
  public void test086() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test086"); }


    com.google.javascript.rhino.ScriptOrFnNode scriptOrFnNode3 = new com.google.javascript.rhino.ScriptOrFnNode(0, 91, 18);
    java.lang.String str4 = scriptOrFnNode3.getSourceName();
    com.google.javascript.rhino.FunctionNode functionNode6 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String[] str_array7 = functionNode6.getParamAndVarNames();
    com.google.javascript.rhino.Node node8 = functionNode6.getFirstChild();
    boolean b10 = functionNode6.hasParamOrVar("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n");
    com.google.javascript.rhino.ErrorReporter errorReporter11 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry12 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter11);
    com.google.javascript.rhino.ErrorReporter errorReporter13 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry14 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter13);
    jSTypeRegistry14.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter17 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry18 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter17);
    com.google.javascript.rhino.jstype.StaticScope staticScope19 = null;
    com.google.javascript.rhino.jstype.JSType jSType24 = jSTypeRegistry18.getForgivingType(staticScope19, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter25 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry26 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter25);
    com.google.javascript.rhino.jstype.StaticScope staticScope27 = null;
    com.google.javascript.rhino.jstype.JSType jSType32 = jSTypeRegistry26.getForgivingType(staticScope27, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array33 = new com.google.javascript.rhino.jstype.JSType[] { jSType32 };
    com.google.javascript.rhino.jstype.FunctionType functionType34 = jSTypeRegistry14.createFunctionType(jSType24, jSType_array33);
    com.google.javascript.rhino.Node node36 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable37 = node36.getAncestors();
    java.lang.String str38 = node36.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType39 = jSTypeRegistry12.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType34, node36);
    com.google.javascript.rhino.JSDocInfo jSDocInfo40 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str41 = jSDocInfo40.getTemplateTypeName();
    boolean b42 = jSDocInfo40.hasEnumParameterType();
    functionType34.setJSDocInfo(jSDocInfo40);
    functionNode6.setJSDocInfo(jSDocInfo40);
    scriptOrFnNode3.addChildrenToFront((com.google.javascript.rhino.Node)functionNode6);
    com.google.javascript.rhino.Node node46 = functionNode6.getNext();
    com.google.javascript.rhino.ScriptOrFnNode scriptOrFnNode51 = new com.google.javascript.rhino.ScriptOrFnNode(33, 24, 73);
    com.google.javascript.rhino.Node node53 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n");
    com.google.javascript.jscomp.ClosureCodingConvention closureCodingConvention54 = new com.google.javascript.jscomp.ClosureCodingConvention();
    com.google.javascript.rhino.Node node57 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable58 = node57.getAncestors();
    com.google.javascript.rhino.Node node60 = new com.google.javascript.rhino.Node(0);
    boolean b61 = node57.hasChild(node60);
    com.google.javascript.rhino.Node node63 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str64 = node60.checkTreeEquals(node63);
    com.google.javascript.rhino.Node node65 = node63.cloneNode();
    com.google.javascript.rhino.Node node67 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node node69 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable70 = node69.getAncestors();
    com.google.javascript.rhino.Node node72 = new com.google.javascript.rhino.Node(0);
    boolean b73 = node69.hasChild(node72);
    com.google.javascript.rhino.Node node75 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str76 = node72.checkTreeEquals(node75);
    com.google.javascript.rhino.Node node77 = node67.copyInformationFromForTree(node72);
    com.google.javascript.rhino.Node node80 = new com.google.javascript.rhino.Node(9, node63, node67, 29, 10);
    boolean b81 = closureCodingConvention54.isOptionalParameter(node67);
    com.google.javascript.rhino.Node node86 = new com.google.javascript.rhino.Node(54, 151, 76);
    com.google.javascript.rhino.Node node89 = new com.google.javascript.rhino.Node(0, node86, 90, 110);
    com.google.javascript.rhino.Node node90 = node86.detachFromParent();
    boolean b91 = closureCodingConvention54.isVarArgsParameter(node86);
    node86.setIsSyntheticBlock(false);
    com.google.javascript.rhino.Node node96 = new com.google.javascript.rhino.Node(87, (com.google.javascript.rhino.Node)scriptOrFnNode51, node53, node86, 9, 303);
    // The following exception was thrown during execution in test generation
    try {
      node46.removeChild((com.google.javascript.rhino.Node)scriptOrFnNode51);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(node8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str38 + "' != '" + "EOF"+ "'", str38.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b42 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(node46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b61 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str64 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str64.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b73 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str76 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str76.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b81 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node90);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b91 == false);

  }

  @Test
  public void test087() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test087"); }


    com.google.javascript.rhino.EvaluatorException evaluatorException3 = new com.google.javascript.rhino.EvaluatorException("function (hi!): hi!", "", 0);
    int i4 = evaluatorException3.columnNumber();
    // The following exception was thrown during execution in test generation
    try {
      evaluatorException3.initSourceName("<No stack trace available>");
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalStateException");
    } catch (java.lang.IllegalStateException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalStateException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalStateException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);

  }

  @Test
  public void test088() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test088"); }


    com.google.javascript.jscomp.AbstractCompiler abstractCompiler0 = null;
    com.google.javascript.jscomp.NodeTraversal.Callback callback1 = null;
    com.google.javascript.jscomp.NodeTraversal nodeTraversal2 = new com.google.javascript.jscomp.NodeTraversal(abstractCompiler0, callback1);
    com.google.javascript.jscomp.JSModule jSModule4 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list5 = jSModule4.getDependencies();
    nodeTraversal2.traverseRoots(list5);
    com.google.javascript.rhino.FunctionNode functionNode8 = new com.google.javascript.rhino.FunctionNode("");
    int i9 = functionNode8.getFunctionType();
    com.google.javascript.rhino.ErrorReporter errorReporter10 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry11 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter10);
    jSTypeRegistry11.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter22 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry23 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter22);
    com.google.javascript.rhino.jstype.StaticScope staticScope24 = null;
    com.google.javascript.rhino.jstype.JSType jSType29 = jSTypeRegistry23.getForgivingType(staticScope24, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array30 = new com.google.javascript.rhino.jstype.JSType[] { jSType29 };
    com.google.javascript.rhino.jstype.FunctionType functionType31 = jSTypeRegistry11.createFunctionType(jSType21, jSType_array30);
    boolean b32 = functionType31.isConstructor();
    functionNode8.setJSType((com.google.javascript.rhino.jstype.JSType)functionType31);
    com.google.javascript.jscomp.DiagnosticType diagnosticType34 = com.google.javascript.jscomp.NodeTraversal.NODE_TRAVERSAL_ERROR;
    java.text.MessageFormat messageFormat35 = diagnosticType34.format;
    java.lang.String[] str_array36 = com.google.javascript.rhino.ScriptRuntime.emptyStrings;
    com.google.javascript.jscomp.JSError jSError37 = nodeTraversal2.makeError((com.google.javascript.rhino.Node)functionNode8, diagnosticType34, str_array36);
    java.lang.String str38 = jSError37.toString();
    com.google.javascript.jscomp.DiagnosticType diagnosticType39 = jSError37.getType();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i9 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormat35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str38 + "' != '" + "JSC_NODE_TRAVERSAL_ERROR. {0} at (unknown source) line (unknown line) : (unknown column)"+ "'", str38.equals("JSC_NODE_TRAVERSAL_ERROR. {0} at (unknown source) line (unknown line) : (unknown column)"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType39);

  }

  @Test
  public void test089() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test089"); }


    com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler1 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState2 = compiler1.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter4 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler1, true);
    com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list7 = jSModule6.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback8 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler1, list7, callback8);
    com.google.javascript.jscomp.ErrorManager errorManager10 = compiler1.getErrorManager();
    com.google.javascript.jscomp.NodeTraversal.Callback callback11 = null;
    com.google.javascript.jscomp.NodeTraversal nodeTraversal12 = new com.google.javascript.jscomp.NodeTraversal((com.google.javascript.jscomp.AbstractCompiler)compiler1, callback11);
    java.lang.String str13 = nodeTraversal12.getSourceName();
    com.google.javascript.jscomp.Compiler compiler14 = nodeTraversal12.getCompiler();
    com.google.javascript.rhino.FunctionNode functionNode18 = new com.google.javascript.rhino.FunctionNode("");
    int i19 = functionNode18.getFunctionType();
    java.lang.String str20 = functionNode18.getFunctionName();
    com.google.javascript.rhino.Node node23 = new com.google.javascript.rhino.Node(91, (com.google.javascript.rhino.Node)functionNode18, 12, 13);
    com.google.javascript.rhino.Node[] node_array24 = new com.google.javascript.rhino.Node[] { node23 };
    com.google.javascript.rhino.Node node25 = new com.google.javascript.rhino.Node(0, node_array24);
    // The following exception was thrown during execution in test generation
    try {
      nodeTraversal12.traverseRoots(node_array24);
      org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException");
    } catch (java.lang.RuntimeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.RuntimeException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorManager10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str13 + "' != '" + ""+ "'", str13.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(compiler14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i19 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str20 + "' != '" + ""+ "'", str20.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node_array24);

  }

  @Test
  public void test090() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test090"); }


    com.google.javascript.rhino.Node node2 = com.google.javascript.rhino.Node.newString(85, "function ({proxy:{1589448235}}): {proxy:{2065817421}}");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node2);

  }

  @Test
  public void test091() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test091"); }


    com.google.javascript.rhino.FunctionNode functionNode3 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.Node node5 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable6 = node5.getAncestors();
    com.google.javascript.rhino.Node node8 = new com.google.javascript.rhino.Node(0);
    boolean b9 = node5.hasChild(node8);
    node5.putBooleanProp(83, false);
    functionNode3.addChildrenToBack(node5);
    boolean b14 = functionNode3.hasOneChild();
    com.google.javascript.rhino.ErrorReporter errorReporter15 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry16 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter15);
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry16.createNamedType("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "", 301, 71);
    java.lang.RuntimeException runtimeException22 = com.google.javascript.rhino.ScriptRuntime.undefReadError((java.lang.Object)functionNode3, (java.lang.Object)jSType21);
    boolean[] b_array23 = functionNode3.getParamAndVarConst();
    functionNode3.setSourceName("com.google.javascript.rhino.EcmaError: OFF: Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n: <No stack trace available> (OFF: Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n#8)");
    // The following exception was thrown during execution in test generation
    try {
      functionNode3.setDouble((-1.0d));
      org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException");
    } catch (java.lang.UnsupportedOperationException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.UnsupportedOperationException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(runtimeException22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(b_array23);

  }

  @Test
  public void test092() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test092"); }


    com.google.javascript.jscomp.ErrorFormat errorFormat1 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler2 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState3 = compiler2.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter5 = errorFormat1.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler2, true);
    com.google.javascript.jscomp.JSModule jSModule7 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list8 = jSModule7.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback9 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler2, list8, callback9);
    com.google.javascript.jscomp.ErrorManager errorManager11 = compiler2.getErrorManager();
    com.google.javascript.jscomp.JSModule jSModule13 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list14 = jSModule13.getDependencies();
    java.util.List list15 = jSModule13.getProvides();
    java.lang.String[] str_array16 = compiler2.toSourceArray(jSModule13);
    java.util.List list17 = jSModule13.getInputs();
    com.google.javascript.rhino.ErrorReporter errorReporter18 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry19 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter18);
    com.google.javascript.rhino.jstype.StaticScope staticScope20 = null;
    com.google.javascript.rhino.jstype.JSType jSType25 = jSTypeRegistry19.getForgivingType(staticScope20, "hi!", "", 0, 1);
    boolean b26 = jSType25.isEnumType();
    boolean b27 = jSType25.isResolved();
    com.google.javascript.rhino.jstype.ObjectType objectType28 = jSType25.dereference();
    java.util.Set set29 = objectType28.getOwnPropertyNames();
    // The following exception was thrown during execution in test generation
    try {
      java.lang.String str30 = com.google.javascript.rhino.ScriptRuntime.getMessage2("function ({proxy:{1307993529}}): {proxy:{968451595}}", (java.lang.Object)list17, (java.lang.Object)objectType28);
      org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException");
    } catch (java.lang.RuntimeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.RuntimeException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorManager11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(objectType28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set29);

  }

  @Test
  public void test093() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test093"); }


    com.google.javascript.rhino.FunctionNode functionNode1 = new com.google.javascript.rhino.FunctionNode("");
    functionNode1.setLineno(101);
    com.google.javascript.rhino.FunctionNode functionNode5 = new com.google.javascript.rhino.FunctionNode("");
    int i6 = functionNode5.getFunctionType();
    com.google.javascript.rhino.ErrorReporter errorReporter7 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry8 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter7);
    jSTypeRegistry8.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter11 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry12 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter11);
    com.google.javascript.rhino.jstype.StaticScope staticScope13 = null;
    com.google.javascript.rhino.jstype.JSType jSType18 = jSTypeRegistry12.getForgivingType(staticScope13, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter19 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry20 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter19);
    com.google.javascript.rhino.jstype.StaticScope staticScope21 = null;
    com.google.javascript.rhino.jstype.JSType jSType26 = jSTypeRegistry20.getForgivingType(staticScope21, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array27 = new com.google.javascript.rhino.jstype.JSType[] { jSType26 };
    com.google.javascript.rhino.jstype.FunctionType functionType28 = jSTypeRegistry8.createFunctionType(jSType18, jSType_array27);
    boolean b29 = functionType28.isConstructor();
    functionNode5.setJSType((com.google.javascript.rhino.jstype.JSType)functionType28);
    java.lang.String[] str_array31 = functionNode5.getParamAndVarNames();
    java.lang.Object obj32 = functionNode5.getCompilerData();
    int i33 = functionNode1.addFunction(functionNode5);
    functionNode1.setEncodedSourceBounds(7, 20);
    com.google.javascript.rhino.Node.SideEffectFlags sideEffectFlags37 = null;
    // The following exception was thrown during execution in test generation
    try {
      functionNode1.setSideEffectFlags(sideEffectFlags37);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(obj32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i33 == 0);

  }

  @Test
  public void test094() {}
// Defects4J: flaky method
//   @Test
//   public void test094() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test094"); }
// 
// 
//     com.google.javascript.rhino.Context context0 = null;
//     com.google.javascript.rhino.Context context1 = com.google.javascript.rhino.Context.enter(context0);
//     context1.removeActivationName("OFF");
//     com.google.javascript.rhino.ScriptRuntime.storeUint32Result(context1, 10L);
//     com.google.javascript.rhino.EvaluatorException evaluatorException9 = new com.google.javascript.rhino.EvaluatorException("hi!", "EOF", 12);
//     evaluatorException9.initLineSource("");
//     com.google.javascript.jscomp.Compiler compiler12 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState13 = compiler12.getState();
//     com.google.javascript.jscomp.SourceExcerptProvider.SourceExcerpt sourceExcerpt14 = null;
//     com.google.javascript.jscomp.LightweightMessageFormatter lightweightMessageFormatter15 = new com.google.javascript.jscomp.LightweightMessageFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler12, sourceExcerpt14);
//     java.util.logging.Logger logger16 = null;
//     com.google.javascript.jscomp.LoggerErrorManager loggerErrorManager17 = new com.google.javascript.jscomp.LoggerErrorManager(logger16);
//     com.google.javascript.jscomp.CheckLevel checkLevel18 = com.google.javascript.jscomp.CheckLevel.OFF;
//     com.google.javascript.rhino.Node node21 = new com.google.javascript.rhino.Node(0);
//     com.google.javascript.rhino.Node.AncestorIterable ancestorIterable22 = node21.getAncestors();
//     com.google.javascript.rhino.Node node24 = new com.google.javascript.rhino.Node(0);
//     boolean b25 = node21.hasChild(node24);
//     com.google.javascript.rhino.Node node27 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
//     java.lang.String str28 = node24.checkTreeEquals(node27);
//     com.google.javascript.rhino.FunctionNode functionNode32 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
//     com.google.javascript.rhino.Node node34 = new com.google.javascript.rhino.Node(0);
//     com.google.javascript.rhino.Node.AncestorIterable ancestorIterable35 = node34.getAncestors();
//     com.google.javascript.rhino.Node node37 = new com.google.javascript.rhino.Node(0);
//     boolean b38 = node34.hasChild(node37);
//     node34.putBooleanProp(83, false);
//     functionNode32.addChildrenToBack(node34);
//     boolean b43 = node24.checkTreeTypeAwareEqualsSilent(node34);
//     com.google.javascript.jscomp.CheckLevel checkLevel44 = com.google.javascript.jscomp.CheckLevel.OFF;
//     com.google.javascript.jscomp.DiagnosticType diagnosticType45 = com.google.javascript.jscomp.NodeTraversal.NODE_TRAVERSAL_ERROR;
//     com.google.javascript.rhino.FunctionNode functionNode47 = new com.google.javascript.rhino.FunctionNode("");
//     java.lang.String[] str_array48 = functionNode47.getParamAndVarNames();
//     com.google.javascript.jscomp.JSError jSError49 = com.google.javascript.jscomp.JSError.make("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", node24, checkLevel44, diagnosticType45, str_array48);
//     loggerErrorManager17.println(checkLevel18, jSError49);
//     compiler12.report(jSError49);
//     context1.putThreadLocal((java.lang.Object)"", (java.lang.Object)compiler12);
//     boolean b53 = context1.isGeneratingDebug();
//     com.google.javascript.rhino.Context context54 = null;
//     com.google.javascript.rhino.Context context55 = com.google.javascript.rhino.Context.enter(context54);
//     context55.removeActivationName("OFF");
//     int i58 = context55.getLanguageVersion();
//     boolean b59 = context55.hasCompileFunctionsWithDynamicScope();
//     boolean b60 = context55.isGeneratingDebug();
//     boolean b61 = context55.isGeneratingSource();
//     java.util.Locale locale62 = context55.getLocale();
//     java.util.Locale locale63 = context1.setLocale(locale62);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(context1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(checkLevel18);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(ancestorIterable22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b25 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(node27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str28 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str28.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(ancestorIterable35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b38 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b43 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(checkLevel44);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(diagnosticType45);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(str_array48);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSError49);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b53 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(context55);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i58 == 0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b59 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b60 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b61 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(locale62);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(locale63);
// 
//   }

  @Test
  public void test095() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test095"); }


    com.google.javascript.jscomp.DiagnosticGroup diagnosticGroup0 = com.google.javascript.jscomp.DiagnosticGroups.DEPRECATED;
    com.google.javascript.jscomp.DiagnosticGroups.INVALID_CASTS = diagnosticGroup0;
    com.google.javascript.jscomp.DiagnosticGroups.ACCESS_CONTROLS = diagnosticGroup0;
    com.google.javascript.jscomp.DiagnosticGroups.AMBIGUOUS_FUNCTION_DECL = diagnosticGroup0;
    com.google.javascript.jscomp.DiagnosticGroups.CHECK_VARIABLES = diagnosticGroup0;
    com.google.javascript.jscomp.DiagnosticGroups.INVALID_CASTS = diagnosticGroup0;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticGroup0);

  }

  @Test
  public void test096() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test096"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter4 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry5 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter4);
    com.google.javascript.rhino.jstype.StaticScope staticScope6 = null;
    com.google.javascript.rhino.jstype.JSType jSType11 = jSTypeRegistry5.getForgivingType(staticScope6, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter12 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry13 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter12);
    com.google.javascript.rhino.jstype.StaticScope staticScope14 = null;
    com.google.javascript.rhino.jstype.JSType jSType19 = jSTypeRegistry13.getForgivingType(staticScope14, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array20 = new com.google.javascript.rhino.jstype.JSType[] { jSType19 };
    com.google.javascript.rhino.jstype.FunctionType functionType21 = jSTypeRegistry1.createFunctionType(jSType11, jSType_array20);
    com.google.javascript.rhino.jstype.JSType jSType22 = functionType21.unboxesTo();
    java.lang.String str23 = functionType21.getReferenceName();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType24 = functionType21.getPrototype();
    com.google.javascript.rhino.jstype.JSType jSType25 = functionPrototypeType24.unboxesTo();
    com.google.javascript.rhino.jstype.FunctionType functionType26 = functionPrototypeType24.getOwnerFunction();
    com.google.javascript.rhino.jstype.ObjectType objectType27 = com.google.javascript.rhino.jstype.ObjectType.cast((com.google.javascript.rhino.jstype.JSType)functionPrototypeType24);
    boolean b28 = functionPrototypeType24.isNullable();
    com.google.javascript.rhino.jstype.JSType jSType30 = functionPrototypeType24.getPropertyType("null");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(objectType27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType30);

  }

  @Test
  public void test097() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test097"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    compilerOptions0.setDefineToBooleanLiteral("hi!", false);
    boolean b8 = compilerOptions0.instrumentForCoverage;
    java.util.Set set9 = compilerOptions0.stripNameSuffixes;
    boolean b10 = compilerOptions0.markAsCompiled;
    compilerOptions0.checkEs5Strict = false;
    boolean b13 = compilerOptions0.reserveRawExports;
    com.google.javascript.jscomp.CompilerOptions compilerOptions14 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b15 = compilerOptions14.gatherCssNames;
    java.lang.String str16 = compilerOptions14.aliasableGlobals;
    boolean b17 = compilerOptions14.removeDeadCode;
    com.google.javascript.jscomp.MessageBundle messageBundle18 = compilerOptions14.messageBundle;
    compilerOptions14.disambiguateProperties = false;
    com.google.javascript.jscomp.CheckLevel checkLevel21 = compilerOptions14.checkUndefinedProperties;
    boolean b22 = compilerOptions14.markAsCompiled;
    boolean b23 = compilerOptions14.inferTypesInGlobalScope;
    com.google.javascript.jscomp.CompilerOptions compilerOptions24 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b25 = compilerOptions24.gatherCssNames;
    java.lang.String str26 = compilerOptions24.aliasableGlobals;
    boolean b27 = compilerOptions24.removeDeadCode;
    compilerOptions24.setLooseTypes(false);
    boolean b30 = compilerOptions24.markNoSideEffectCalls;
    com.google.javascript.jscomp.CheckLevel checkLevel31 = compilerOptions24.checkGlobalNamesLevel;
    compilerOptions14.reportMissingOverride = checkLevel31;
    compilerOptions0.brokenClosureRequiresLevel = checkLevel31;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(messageBundle18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel31);

  }

  @Test
  public void test098() {}
// Defects4J: flaky method
//   @Test
//   public void test098() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test098"); }
// 
// 
//     com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
//     com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
//     jSTypeRegistry3.forwardDeclareType("hi!");
//     com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
//     com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
//     com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
//     com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
//     com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
//     com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
//     com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
//     com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
//     com.google.javascript.rhino.jstype.JSType jSType24 = functionType23.unboxesTo();
//     com.google.javascript.rhino.ErrorReporter errorReporter26 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry27 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter26);
//     jSTypeRegistry27.forwardDeclareType("hi!");
//     com.google.javascript.rhino.ErrorReporter errorReporter30 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry31 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter30);
//     com.google.javascript.rhino.jstype.StaticScope staticScope32 = null;
//     com.google.javascript.rhino.jstype.JSType jSType37 = jSTypeRegistry31.getForgivingType(staticScope32, "hi!", "", 0, 1);
//     com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
//     com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
//     com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
//     com.google.javascript.rhino.jstype.JSType[] jSType_array46 = new com.google.javascript.rhino.jstype.JSType[] { jSType45 };
//     com.google.javascript.rhino.jstype.FunctionType functionType47 = jSTypeRegistry27.createFunctionType(jSType37, jSType_array46);
//     com.google.javascript.rhino.jstype.FunctionType functionType48 = jSTypeRegistry1.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType23, false, jSType_array46);
//     com.google.javascript.rhino.ErrorReporter errorReporter49 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry50 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter49);
//     com.google.javascript.rhino.ErrorReporter errorReporter51 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry52 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter51);
//     jSTypeRegistry52.forwardDeclareType("hi!");
//     com.google.javascript.rhino.ErrorReporter errorReporter55 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry56 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter55);
//     com.google.javascript.rhino.jstype.StaticScope staticScope57 = null;
//     com.google.javascript.rhino.jstype.JSType jSType62 = jSTypeRegistry56.getForgivingType(staticScope57, "hi!", "", 0, 1);
//     com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
//     com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
//     com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
//     com.google.javascript.rhino.jstype.JSType[] jSType_array71 = new com.google.javascript.rhino.jstype.JSType[] { jSType70 };
//     com.google.javascript.rhino.jstype.FunctionType functionType72 = jSTypeRegistry52.createFunctionType(jSType62, jSType_array71);
//     com.google.javascript.rhino.Node node74 = new com.google.javascript.rhino.Node(0);
//     com.google.javascript.rhino.Node.AncestorIterable ancestorIterable75 = node74.getAncestors();
//     java.lang.String str76 = node74.toString();
//     com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry50.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType72, node74);
//     functionType23.setPrototypeBasedOn((com.google.javascript.rhino.jstype.ObjectType)functionType77);
//     com.google.javascript.rhino.ErrorReporter errorReporter79 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry80 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter79);
//     com.google.javascript.rhino.jstype.StaticScope staticScope81 = null;
//     com.google.javascript.rhino.jstype.JSType jSType86 = jSTypeRegistry80.getForgivingType(staticScope81, "hi!", "", 0, 1);
//     boolean b87 = jSType86.isRecordType();
//     boolean b88 = jSType86.isBooleanObjectType();
//     com.google.javascript.rhino.jstype.JSType jSType89 = functionType23.getLeastSupertype(jSType86);
//     java.lang.String str90 = functionType23.toDebugHashCodeString();
//     boolean b91 = functionType23.isCheckedUnknownType();
//     boolean b92 = functionType23.isInterface();
//     boolean b93 = functionType23.isEnumElementType();
//     boolean b94 = functionType23.isReturnTypeInferred();
//     java.lang.Iterable iterable95 = functionType23.getAllImplementedInterfaces();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType21);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType_array22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType23);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(jSType24);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType37);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType45);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType_array46);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType47);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType48);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType62);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType70);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType_array71);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType72);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(ancestorIterable75);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str76 + "' != '" + "EOF"+ "'", str76.equals("EOF"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType77);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType86);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b87 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b88 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType89);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str90 + "' != '" + "function ({proxy:{860732907}}): {proxy:{850020228}}"+ "'", str90.equals("function ({proxy:{860732907}}): {proxy:{850020228}}"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b91 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b92 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b93 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b94 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(iterable95);
// 
//   }

  @Test
  public void test099() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test099"); }


    java.util.logging.Logger logger0 = null;
    com.google.javascript.jscomp.LoggerErrorManager loggerErrorManager1 = new com.google.javascript.jscomp.LoggerErrorManager(logger0);
    double d2 = loggerErrorManager1.getTypedPercent();
    com.google.javascript.jscomp.Compiler compiler3 = new com.google.javascript.jscomp.Compiler((com.google.javascript.jscomp.ErrorManager)loggerErrorManager1);
    compiler3.reportCodeChange();
    java.util.logging.Logger logger5 = null;
    com.google.javascript.jscomp.LoggerErrorManager loggerErrorManager6 = new com.google.javascript.jscomp.LoggerErrorManager(logger5);
    double d7 = loggerErrorManager6.getTypedPercent();
    com.google.javascript.jscomp.Compiler compiler8 = new com.google.javascript.jscomp.Compiler((com.google.javascript.jscomp.ErrorManager)loggerErrorManager6);
    com.google.javascript.jscomp.CompilerOptions compilerOptions9 = null;
    com.google.javascript.jscomp.DefaultPassConfig defaultPassConfig10 = new com.google.javascript.jscomp.DefaultPassConfig(compilerOptions9);
    compiler8.setPassConfig((com.google.javascript.jscomp.PassConfig)defaultPassConfig10);
    compiler3.setPassConfig((com.google.javascript.jscomp.PassConfig)defaultPassConfig10);
    com.google.javascript.jscomp.JSSourceFile jSSourceFile13 = null;
    java.util.logging.Logger logger14 = null;
    com.google.javascript.jscomp.LoggerErrorManager loggerErrorManager15 = new com.google.javascript.jscomp.LoggerErrorManager(logger14);
    double d16 = loggerErrorManager15.getTypedPercent();
    com.google.javascript.jscomp.Compiler compiler17 = new com.google.javascript.jscomp.Compiler((com.google.javascript.jscomp.ErrorManager)loggerErrorManager15);
    com.google.javascript.rhino.JSDocInfo jSDocInfo18 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str19 = jSDocInfo18.getTemplateTypeName();
    boolean b20 = jSDocInfo18.isExterns();
    java.util.List list21 = jSDocInfo18.getThrownTypes();
    com.google.javascript.jscomp.NodeTraversal.Callback callback22 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler17, list21, callback22);
    com.google.javascript.jscomp.ErrorFormat errorFormat24 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler25 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState26 = compiler25.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter28 = errorFormat24.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler25, true);
    com.google.javascript.jscomp.JSModule jSModule30 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list31 = jSModule30.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback32 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler25, list31, callback32);
    com.google.javascript.jscomp.ErrorManager errorManager34 = compiler25.getErrorManager();
    com.google.javascript.jscomp.SourceFile.Generator generator36 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile37 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator36);
    com.google.javascript.jscomp.JSSourceFile[] jSSourceFile_array38 = new com.google.javascript.jscomp.JSSourceFile[] { jSSourceFile37 };
    com.google.javascript.jscomp.SourceFile.Generator generator40 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile41 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator40);
    com.google.javascript.jscomp.JsAst jsAst42 = new com.google.javascript.jscomp.JsAst((com.google.javascript.jscomp.SourceFile)jSSourceFile41);
    com.google.javascript.jscomp.JSSourceFile[] jSSourceFile_array43 = new com.google.javascript.jscomp.JSSourceFile[] { jSSourceFile41 };
    com.google.javascript.jscomp.CompilerOptions compilerOptions44 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions44.collapseVariableDeclarations = true;
    com.google.javascript.jscomp.Result result47 = compiler25.compile(jSSourceFile_array38, jSSourceFile_array43, compilerOptions44);
    com.google.javascript.jscomp.ErrorFormat errorFormat48 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler49 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState50 = compiler49.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter52 = errorFormat48.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler49, true);
    com.google.javascript.jscomp.JSModule jSModule54 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list55 = jSModule54.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback56 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler49, list55, callback56);
    com.google.javascript.jscomp.ErrorManager errorManager58 = compiler49.getErrorManager();
    com.google.javascript.jscomp.SourceFile.Generator generator60 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile61 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator60);
    com.google.javascript.jscomp.JSSourceFile[] jSSourceFile_array62 = new com.google.javascript.jscomp.JSSourceFile[] { jSSourceFile61 };
    com.google.javascript.jscomp.SourceFile.Generator generator64 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile65 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator64);
    com.google.javascript.jscomp.JsAst jsAst66 = new com.google.javascript.jscomp.JsAst((com.google.javascript.jscomp.SourceFile)jSSourceFile65);
    com.google.javascript.jscomp.JSSourceFile[] jSSourceFile_array67 = new com.google.javascript.jscomp.JSSourceFile[] { jSSourceFile65 };
    com.google.javascript.jscomp.CompilerOptions compilerOptions68 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions68.collapseVariableDeclarations = true;
    com.google.javascript.jscomp.Result result71 = compiler49.compile(jSSourceFile_array62, jSSourceFile_array67, compilerOptions68);
    com.google.javascript.jscomp.CompilerOptions compilerOptions72 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions72.collapseVariableDeclarations = true;
    boolean b75 = compilerOptions72.computeFunctionSideEffects;
    com.google.javascript.jscomp.CheckLevel checkLevel76 = compilerOptions72.checkMissingGetCssNameLevel;
    compiler17.init(jSSourceFile_array43, jSSourceFile_array67, compilerOptions72);
    com.google.javascript.jscomp.CompilerOptions compilerOptions78 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions78.collapseVariableDeclarations = true;
    boolean b81 = compilerOptions78.computeFunctionSideEffects;
    com.google.javascript.jscomp.CheckLevel checkLevel82 = compilerOptions78.checkMissingGetCssNameLevel;
    boolean b83 = compilerOptions78.flowSensitiveInlineVariables;
    compilerOptions78.groupVariableDeclarations = true;
    boolean b86 = compilerOptions78.removeEmptyFunctions;
    compilerOptions78.inlineGetters = false;
    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.jscomp.Result result89 = compiler3.compile(jSSourceFile13, jSSourceFile_array67, compilerOptions78);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d16 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorManager34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(result47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorManager58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile_array67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(result71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b75 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel76);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b81 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b83 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b86 == false);

  }

  @Test
  public void test100() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test100"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.debugFunctionSideEffectsPath = "hi!";
    compilerOptions0.inlineConstantVars = false;
    boolean b7 = compilerOptions0.crossModuleCodeMotion;
    compilerOptions0.computeFunctionSideEffects = false;
    com.google.javascript.jscomp.CompilerOptions compilerOptions10 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b11 = compilerOptions10.gatherCssNames;
    com.google.javascript.jscomp.VariableRenamingPolicy variableRenamingPolicy12 = compilerOptions10.variableRenaming;
    compilerOptions10.exportTestFunctions = true;
    boolean b15 = compilerOptions10.instrumentForCoverage;
    java.lang.String str16 = compilerOptions10.aliasStringsBlacklist;
    com.google.javascript.jscomp.CheckLevel checkLevel17 = compilerOptions10.checkFunctions;
    com.google.javascript.jscomp.CheckLevel checkLevel18 = compilerOptions10.brokenClosureRequiresLevel;
    compilerOptions0.checkMethods = checkLevel18;
    compilerOptions0.setSummaryDetailLevel(4);
    boolean b22 = compilerOptions0.inlineLocalVariables;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(variableRenamingPolicy12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str16 + "' != '" + ""+ "'", str16.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);

  }

  @Test
  public void test101() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test101"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    compilerOptions0.setDefineToBooleanLiteral("hi!", false);
    boolean b8 = compilerOptions0.instrumentForCoverage;
    boolean b9 = compilerOptions0.foldConstants;
    java.lang.Object obj10 = compilerOptions0.clone();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj10);

  }

  @Test
  public void test102() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test102"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    boolean b3 = compilerOptions0.computeFunctionSideEffects;
    com.google.javascript.jscomp.CheckLevel checkLevel4 = compilerOptions0.checkMissingGetCssNameLevel;
    boolean b5 = compilerOptions0.flowSensitiveInlineVariables;
    boolean b6 = compilerOptions0.removeUnusedPrototypePropertiesInExterns;
    boolean b7 = compilerOptions0.inlineVariables;
    compilerOptions0.inlineFunctions = false;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);

  }

  @Test
  public void test103() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test103"); }


    com.google.javascript.jscomp.SourceFile sourceFile1 = com.google.javascript.jscomp.SourceFile.fromFile("JSC_NODE_TRAVERSAL_ERROR. {0} at Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n line (unknown line) : (unknown column)");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(sourceFile1);

  }

  @Test
  public void test104() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test104"); }


    java.lang.String str1 = com.google.javascript.rhino.Node.tokenToName(51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "in"+ "'", str1.equals("in"));

  }

  @Test
  public void test105() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test105"); }


    com.google.javascript.rhino.Node node2 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable3 = node2.getAncestors();
    java.lang.String str4 = node2.toString();
    java.util.logging.Logger logger5 = null;
    com.google.javascript.jscomp.LoggerErrorManager loggerErrorManager6 = new com.google.javascript.jscomp.LoggerErrorManager(logger5);
    com.google.javascript.jscomp.CheckLevel checkLevel7 = com.google.javascript.jscomp.CheckLevel.OFF;
    com.google.javascript.rhino.Node node10 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable11 = node10.getAncestors();
    com.google.javascript.rhino.Node node13 = new com.google.javascript.rhino.Node(0);
    boolean b14 = node10.hasChild(node13);
    com.google.javascript.rhino.Node node16 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str17 = node13.checkTreeEquals(node16);
    com.google.javascript.rhino.FunctionNode functionNode21 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.Node node23 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable24 = node23.getAncestors();
    com.google.javascript.rhino.Node node26 = new com.google.javascript.rhino.Node(0);
    boolean b27 = node23.hasChild(node26);
    node23.putBooleanProp(83, false);
    functionNode21.addChildrenToBack(node23);
    boolean b32 = node13.checkTreeTypeAwareEqualsSilent(node23);
    com.google.javascript.jscomp.CheckLevel checkLevel33 = com.google.javascript.jscomp.CheckLevel.OFF;
    com.google.javascript.jscomp.DiagnosticType diagnosticType34 = com.google.javascript.jscomp.NodeTraversal.NODE_TRAVERSAL_ERROR;
    com.google.javascript.rhino.FunctionNode functionNode36 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String[] str_array37 = functionNode36.getParamAndVarNames();
    com.google.javascript.jscomp.JSError jSError38 = com.google.javascript.jscomp.JSError.make("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", node13, checkLevel33, diagnosticType34, str_array37);
    loggerErrorManager6.println(checkLevel7, jSError38);
    com.google.javascript.jscomp.DiagnosticType diagnosticType40 = com.google.javascript.jscomp.Compiler.OPTIMIZE_LOOP_ERROR;
    java.lang.String[] str_array41 = null;
    com.google.javascript.jscomp.JSError jSError42 = com.google.javascript.jscomp.JSError.make("hi!", node2, checkLevel7, diagnosticType40, str_array41);
    com.google.javascript.rhino.Node node46 = com.google.javascript.jscomp.NodeUtil.newQualifiedNameNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 10, 81);
    com.google.javascript.rhino.ErrorReporter errorReporter47 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry48 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter47);
    jSTypeRegistry48.forwardDeclareType("hi!");
    com.google.javascript.rhino.jstype.FunctionParamBuilder functionParamBuilder51 = new com.google.javascript.rhino.jstype.FunctionParamBuilder(jSTypeRegistry48);
    com.google.javascript.rhino.ErrorReporter errorReporter52 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry53 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter52);
    jSTypeRegistry53.forwardDeclareType("hi!");
    com.google.javascript.rhino.jstype.FunctionParamBuilder functionParamBuilder56 = new com.google.javascript.rhino.jstype.FunctionParamBuilder(jSTypeRegistry53);
    com.google.javascript.rhino.Node node57 = functionParamBuilder56.build();
    boolean b58 = node57.hasMoreThanOneChild();
    com.google.javascript.rhino.Node node59 = functionParamBuilder51.newParameterFromNode(node57);
    node2.addChildAfter(node46, node57);
    node46.setType(0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str4 + "' != '" + "EOF"+ "'", str4.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str17 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str17.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b58 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node59);

  }

  @Test
  public void test106() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test106"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.gatherCssNames;
    java.lang.String str2 = compilerOptions0.aliasableGlobals;
    boolean b3 = compilerOptions0.removeDeadCode;
    com.google.javascript.jscomp.MessageBundle messageBundle4 = compilerOptions0.messageBundle;
    compilerOptions0.disambiguateProperties = false;
    compilerOptions0.coalesceVariableNames = false;
    java.util.Set set9 = compilerOptions0.stripTypePrefixes;
    compilerOptions0.setNameAnonymousFunctionsOnly(true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(messageBundle4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set9);

  }

  @Test
  public void test107() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test107"); }


    com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler1 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState2 = compiler1.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter4 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler1, true);
    com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list7 = jSModule6.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback8 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler1, list7, callback8);
    com.google.javascript.jscomp.ErrorManager errorManager10 = compiler1.getErrorManager();
    com.google.javascript.jscomp.JSModule jSModule12 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list13 = jSModule12.getDependencies();
    java.util.List list14 = jSModule12.getProvides();
    java.lang.String[] str_array15 = compiler1.toSourceArray(jSModule12);
    com.google.javascript.jscomp.CompilerOptions compilerOptions16 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions16.collapseVariableDeclarations = true;
    compilerOptions16.setSummaryDetailLevel(86);
    compilerOptions16.setDefineToBooleanLiteral("hi!", false);
    boolean b24 = compilerOptions16.instrumentForCoverage;
    com.google.common.collect.Multimap multimap25 = null;
    compilerOptions16.customPasses = multimap25;
    boolean b27 = compilerOptions16.inferTypesInGlobalScope;
    compiler1.initOptions(compilerOptions16);
    // The following exception was thrown during execution in test generation
    try {
      compiler1.parse();
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorManager10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);

  }

  @Test
  public void test108() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test108"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression2 = null;
    boolean b3 = jSDocInfoBuilder1.recordTypedef(jSTypeExpression2);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression4 = null;
    boolean b6 = jSDocInfoBuilder1.recordThrowDescription(jSTypeExpression4, "hi!");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression7 = null;
    boolean b8 = jSDocInfoBuilder1.recordThisType(jSTypeExpression7);
    boolean b10 = jSDocInfoBuilder1.recordMeaning("");
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder12 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b14 = jSDocInfoBuilder12.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression15 = null;
    boolean b16 = jSDocInfoBuilder12.recordReturnType(jSTypeExpression15);
    com.google.javascript.rhino.Node node18 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable19 = node18.getAncestors();
    com.google.javascript.rhino.Node node21 = new com.google.javascript.rhino.Node(0);
    boolean b22 = node18.hasChild(node21);
    com.google.javascript.rhino.Node node24 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str25 = node21.checkTreeEquals(node24);
    com.google.javascript.rhino.Node node26 = node24.cloneNode();
    boolean b27 = node26.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression29 = new com.google.javascript.rhino.JSTypeExpression(node26, "<No stack trace available>");
    boolean b30 = jSDocInfoBuilder12.recordDefineType(jSTypeExpression29);
    com.google.javascript.rhino.Node node32 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable33 = node32.getAncestors();
    com.google.javascript.rhino.Node node35 = new com.google.javascript.rhino.Node(0);
    boolean b36 = node32.hasChild(node35);
    com.google.javascript.rhino.Node node38 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str39 = node35.checkTreeEquals(node38);
    com.google.javascript.rhino.Node node40 = node38.cloneNode();
    boolean b41 = node40.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression43 = new com.google.javascript.rhino.JSTypeExpression(node40, "<No stack trace available>");
    boolean b44 = jSDocInfoBuilder12.recordType(jSTypeExpression43);
    boolean b45 = jSDocInfoBuilder1.recordType(jSTypeExpression43);
    boolean b46 = jSDocInfoBuilder1.recordNoSideEffects();
    boolean b47 = jSDocInfoBuilder1.recordPreserveTry();
    boolean b48 = jSDocInfoBuilder1.shouldParseDocumentation();
    boolean b50 = jSDocInfoBuilder1.recordDeprecationReason("JSC_NODE_TRAVERSAL_ERROR. {0} at (unknown source) line (unknown line) : (unknown column)");
    boolean b53 = jSDocInfoBuilder1.recordParameterDescription("XMLATTR", "Named type with empty name component");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str25 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str25.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str39 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str39.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b45 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b46 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b47 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b48 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b50 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b53 == true);

  }

  @Test
  public void test109() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test109"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.jstype.JSType jSType6 = jSTypeRegistry1.createNamedType("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "", 301, 71);
    com.google.javascript.rhino.ErrorReporter errorReporter7 = jSTypeRegistry1.getErrorReporter();
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry1.getType(staticScope8, "QMARK", "function (hi!): hi!", 135, 88);
    boolean b14 = jSType13.isEmptyType();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(errorReporter7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);

  }

  @Test
  public void test110() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test110"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.gatherCssNames;
    java.lang.String str2 = compilerOptions0.aliasableGlobals;
    boolean b3 = compilerOptions0.removeDeadCode;
    com.google.javascript.jscomp.MessageBundle messageBundle4 = compilerOptions0.messageBundle;
    boolean b5 = compilerOptions0.checkEs5Strict;
    boolean b6 = compilerOptions0.inlineLocalFunctions;
    com.google.javascript.jscomp.MessageBundle messageBundle7 = compilerOptions0.messageBundle;
    boolean b8 = compilerOptions0.ignoreCajaProperties;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(messageBundle4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(messageBundle7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);

  }

  @Test
  public void test111() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test111"); }


    com.google.javascript.jscomp.ClosureCodingConvention closureCodingConvention0 = new com.google.javascript.jscomp.ClosureCodingConvention();
    com.google.javascript.rhino.Node node3 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable4 = node3.getAncestors();
    com.google.javascript.rhino.Node node6 = new com.google.javascript.rhino.Node(0);
    boolean b7 = node3.hasChild(node6);
    com.google.javascript.rhino.Node node9 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str10 = node6.checkTreeEquals(node9);
    com.google.javascript.rhino.Node node11 = node9.cloneNode();
    com.google.javascript.rhino.Node node13 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node node15 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable16 = node15.getAncestors();
    com.google.javascript.rhino.Node node18 = new com.google.javascript.rhino.Node(0);
    boolean b19 = node15.hasChild(node18);
    com.google.javascript.rhino.Node node21 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str22 = node18.checkTreeEquals(node21);
    com.google.javascript.rhino.Node node23 = node13.copyInformationFromForTree(node18);
    com.google.javascript.rhino.Node node26 = new com.google.javascript.rhino.Node(9, node9, node13, 29, 10);
    boolean b27 = closureCodingConvention0.isOptionalParameter(node13);
    com.google.javascript.rhino.Node node32 = new com.google.javascript.rhino.Node(54, 151, 76);
    com.google.javascript.rhino.Node node35 = new com.google.javascript.rhino.Node(0, node32, 90, 110);
    com.google.javascript.rhino.Node node36 = node32.detachFromParent();
    boolean b37 = closureCodingConvention0.isVarArgsParameter(node32);
    com.google.javascript.rhino.Node node40 = new com.google.javascript.rhino.Node(52);
    node40.removeProp(110);
    com.google.javascript.rhino.Node node46 = com.google.javascript.rhino.Node.newString("OFF", 37, 63);
    com.google.javascript.rhino.Node node47 = new com.google.javascript.rhino.Node(45, node40, node46);
    java.util.List list48 = closureCodingConvention0.identifyTypeDeclarationCall(node47);
    java.lang.String str49 = closureCodingConvention0.getExportSymbolFunction();
    boolean b52 = closureCodingConvention0.isExported("QMARK", true);
    com.google.javascript.rhino.Node node54 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable55 = node54.getAncestors();
    com.google.javascript.rhino.Node node57 = new com.google.javascript.rhino.Node(0);
    boolean b58 = node54.hasChild(node57);
    com.google.javascript.rhino.Node node60 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str61 = node57.checkTreeEquals(node60);
    com.google.javascript.rhino.FunctionNode functionNode65 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.Node node67 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable68 = node67.getAncestors();
    com.google.javascript.rhino.Node node70 = new com.google.javascript.rhino.Node(0);
    boolean b71 = node67.hasChild(node70);
    node67.putBooleanProp(83, false);
    functionNode65.addChildrenToBack(node67);
    boolean b76 = node57.checkTreeTypeAwareEqualsSilent(node67);
    int i77 = node57.getType();
    int i79 = node57.getIntProp((-2));
    com.google.javascript.rhino.Node node82 = com.google.javascript.rhino.Node.newString(57, "");
    java.lang.String str83 = closureCodingConvention0.extractClassNameIfRequire(node57, node82);
    com.google.javascript.rhino.ScriptOrFnNode scriptOrFnNode87 = new com.google.javascript.rhino.ScriptOrFnNode(48, 0, 120);
    boolean b88 = scriptOrFnNode87.hasOneChild();
    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.rhino.Node node89 = node82.removeChildAfter((com.google.javascript.rhino.Node)scriptOrFnNode87);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str10 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str10.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str22 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str22.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(list48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str49 + "' != '" + "goog.exportSymbol"+ "'", str49.equals("goog.exportSymbol"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b52 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b58 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str61 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str61.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable68);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b71 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b76 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i77 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i79 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str83);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);

  }

  @Test
  public void test112() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test112"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    compilerOptions0.setDefineToBooleanLiteral("hi!", false);
    java.lang.String str8 = compilerOptions0.syntheticBlockStartMarker;
    compilerOptions0.setCollapsePropertiesOnExternTypes(true);
    compilerOptions0.collapseProperties = false;
    compilerOptions0.setDefineToNumberLiteral("language version", 0);
    boolean b16 = compilerOptions0.inlineVariables;
    boolean b17 = compilerOptions0.checkEs5Strict;
    boolean b18 = compilerOptions0.allowLegacyJsMessages;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == false);

  }

  @Test
  public void test113() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test113"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.gatherCssNames;
    java.lang.String str2 = compilerOptions0.aliasableGlobals;
    boolean b3 = compilerOptions0.ignoreCajaProperties;
    boolean b4 = compilerOptions0.moveFunctionDeclarations;
    com.google.javascript.jscomp.CompilerOptions compilerOptions5 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions5.collapseVariableDeclarations = true;
    boolean b8 = compilerOptions5.inlineConstantVars;
    java.lang.String str9 = compilerOptions5.aliasableGlobals;
    compilerOptions5.specializeInitialModule = false;
    java.util.Set set12 = compilerOptions5.stripTypes;
    compilerOptions0.setIdGenerators(set12);
    compilerOptions0.disambiguateProperties = false;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set12);

  }

  @Test
  public void test114() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test114"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression2 = null;
    boolean b3 = jSDocInfoBuilder1.recordTypedef(jSTypeExpression2);
    boolean b6 = jSDocInfoBuilder1.recordParameterDescription("hi!", "function (this:{797389023}, {proxy:{1933578632}}): function ({proxy:{1149450402}}): {proxy:{941639620}}");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);

  }

  @Test
  public void test115() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test115"); }


    com.google.javascript.rhino.FunctionNode functionNode3 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.Node node5 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable6 = node5.getAncestors();
    com.google.javascript.rhino.Node node8 = new com.google.javascript.rhino.Node(0);
    boolean b9 = node5.hasChild(node8);
    node5.putBooleanProp(83, false);
    functionNode3.addChildrenToBack(node5);
    boolean b14 = functionNode3.hasOneChild();
    com.google.javascript.rhino.ErrorReporter errorReporter15 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry16 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter15);
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry16.createNamedType("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "", 301, 71);
    java.lang.RuntimeException runtimeException22 = com.google.javascript.rhino.ScriptRuntime.undefReadError((java.lang.Object)functionNode3, (java.lang.Object)jSType21);
    java.lang.String[] str_array23 = functionNode3.getParamAndVarNames();
    com.google.javascript.jscomp.ErrorFormat errorFormat24 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler25 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState26 = compiler25.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter28 = errorFormat24.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler25, true);
    com.google.javascript.jscomp.JSModule jSModule30 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list31 = jSModule30.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback32 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler25, list31, callback32);
    com.google.javascript.jscomp.ErrorManager errorManager34 = compiler25.getErrorManager();
    java.lang.RuntimeException runtimeException35 = com.google.javascript.rhino.ScriptRuntime.notFunctionError((java.lang.Object)functionNode3, (java.lang.Object)compiler25);
    com.google.javascript.jscomp.SourceFile.Generator generator37 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile38 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator37);
    com.google.javascript.jscomp.JsAst jsAst39 = new com.google.javascript.jscomp.JsAst((com.google.javascript.jscomp.SourceFile)jSSourceFile38);
    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.rhino.Node node40 = compiler25.parse(jSSourceFile38);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(runtimeException22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorManager34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(runtimeException35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile38);

  }

  @Test
  public void test116() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test116"); }


    java.util.logging.Logger logger0 = null;
    com.google.javascript.jscomp.LoggerErrorManager loggerErrorManager1 = new com.google.javascript.jscomp.LoggerErrorManager(logger0);
    double d2 = loggerErrorManager1.getTypedPercent();
    com.google.javascript.jscomp.Compiler compiler3 = new com.google.javascript.jscomp.Compiler((com.google.javascript.jscomp.ErrorManager)loggerErrorManager1);
    com.google.javascript.jscomp.CompilerOptions compilerOptions4 = null;
    com.google.javascript.jscomp.DefaultPassConfig defaultPassConfig5 = new com.google.javascript.jscomp.DefaultPassConfig(compilerOptions4);
    compiler3.setPassConfig((com.google.javascript.jscomp.PassConfig)defaultPassConfig5);
    com.google.javascript.jscomp.NodeTraversal.Callback callback7 = null;
    com.google.javascript.jscomp.NodeTraversal nodeTraversal8 = new com.google.javascript.jscomp.NodeTraversal((com.google.javascript.jscomp.AbstractCompiler)compiler3, callback7);
    boolean b9 = nodeTraversal8.hasScope();
    com.google.javascript.jscomp.AbstractCompiler abstractCompiler10 = null;
    com.google.javascript.jscomp.NodeTraversal.Callback callback11 = null;
    com.google.javascript.jscomp.NodeTraversal nodeTraversal12 = new com.google.javascript.jscomp.NodeTraversal(abstractCompiler10, callback11);
    int i13 = nodeTraversal12.getLineNumber();
    com.google.javascript.rhino.Node node14 = nodeTraversal12.getCurrentNode();
    com.google.javascript.rhino.Node node15 = nodeTraversal12.getEnclosingFunction();
    com.google.javascript.rhino.ErrorReporter errorReporter16 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry17 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter16);
    com.google.javascript.rhino.jstype.JSType jSType22 = jSTypeRegistry17.createNamedType("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "", 301, 71);
    com.google.javascript.rhino.ErrorReporter errorReporter23 = jSTypeRegistry17.getErrorReporter();
    com.google.javascript.rhino.jstype.StaticScope staticScope24 = null;
    com.google.javascript.rhino.jstype.JSType jSType29 = jSTypeRegistry17.getType(staticScope24, "QMARK", "function (hi!): hi!", 135, 88);
    com.google.javascript.jscomp.ErrorFormat errorFormat30 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler31 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState32 = compiler31.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter34 = errorFormat30.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler31, true);
    com.google.javascript.jscomp.JSModule jSModule36 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list37 = jSModule36.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback38 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler31, list37, callback38);
    com.google.javascript.jscomp.ErrorManager errorManager40 = compiler31.getErrorManager();
    com.google.javascript.jscomp.NodeTraversal.Callback callback41 = null;
    com.google.javascript.jscomp.NodeTraversal nodeTraversal42 = new com.google.javascript.jscomp.NodeTraversal((com.google.javascript.jscomp.AbstractCompiler)compiler31, callback41);
    com.google.javascript.jscomp.Result result43 = compiler31.getResult();
    com.google.javascript.jscomp.PerformanceTracker performanceTracker44 = null;
    compiler31.tracker = performanceTracker44;
    java.util.logging.Logger logger46 = null;
    com.google.javascript.jscomp.LoggerErrorManager loggerErrorManager47 = new com.google.javascript.jscomp.LoggerErrorManager(logger46);
    double d48 = loggerErrorManager47.getTypedPercent();
    com.google.javascript.jscomp.Compiler compiler49 = new com.google.javascript.jscomp.Compiler((com.google.javascript.jscomp.ErrorManager)loggerErrorManager47);
    com.google.javascript.rhino.JSDocInfo jSDocInfo50 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str51 = jSDocInfo50.getTemplateTypeName();
    boolean b52 = jSDocInfo50.isExterns();
    java.util.List list53 = jSDocInfo50.getThrownTypes();
    com.google.javascript.jscomp.NodeTraversal.Callback callback54 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler49, list53, callback54);
    com.google.javascript.jscomp.NodeTraversal.Callback callback56 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler31, list53, callback56);
    com.google.javascript.rhino.Node node58 = jSTypeRegistry17.createParameters(list53);
    nodeTraversal12.traverseRoots(list53);
    nodeTraversal8.traverseRoots(list53);
    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.jscomp.CompilerInput compilerInput61 = nodeTraversal8.getInput();
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i13 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(node14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(node15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(errorReporter23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorManager40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(result43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d48 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b52 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node58);

  }

  @Test
  public void test117() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test117"); }


    com.google.javascript.jscomp.DefaultCodingConvention defaultCodingConvention1 = new com.google.javascript.jscomp.DefaultCodingConvention();
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry2 = null;
    com.google.javascript.jscomp.Scope scope3 = null;
    com.google.javascript.jscomp.JSModule jSModule5 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list6 = jSModule5.getDependencies();
    defaultCodingConvention1.defineDelegateProxyPrototypeProperties(jSTypeRegistry2, scope3, list6);
    boolean b9 = defaultCodingConvention1.isExported("Not declared as a type name");
    com.google.javascript.rhino.FunctionNode functionNode12 = new com.google.javascript.rhino.FunctionNode("");
    int i13 = functionNode12.getFunctionType();
    java.lang.String str14 = functionNode12.getFunctionName();
    com.google.javascript.rhino.Node node17 = new com.google.javascript.rhino.Node(91, (com.google.javascript.rhino.Node)functionNode12, 12, 13);
    com.google.javascript.jscomp.CodingConvention.SubclassRelationship subclassRelationship18 = defaultCodingConvention1.getClassesDefinedByCall((com.google.javascript.rhino.Node)functionNode12);
    boolean b19 = functionNode12.isNoSideEffectsCall();
    com.google.javascript.jscomp.AbstractCompiler abstractCompiler20 = null;
    com.google.javascript.jscomp.NodeTraversal.Callback callback21 = null;
    com.google.javascript.jscomp.NodeTraversal nodeTraversal22 = new com.google.javascript.jscomp.NodeTraversal(abstractCompiler20, callback21);
    com.google.javascript.jscomp.JSModule jSModule24 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list25 = jSModule24.getDependencies();
    nodeTraversal22.traverseRoots(list25);
    com.google.javascript.rhino.FunctionNode functionNode28 = new com.google.javascript.rhino.FunctionNode("");
    int i29 = functionNode28.getFunctionType();
    com.google.javascript.rhino.ErrorReporter errorReporter30 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry31 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter30);
    jSTypeRegistry31.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter34 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry35 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter34);
    com.google.javascript.rhino.jstype.StaticScope staticScope36 = null;
    com.google.javascript.rhino.jstype.JSType jSType41 = jSTypeRegistry35.getForgivingType(staticScope36, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter42 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry43 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter42);
    com.google.javascript.rhino.jstype.StaticScope staticScope44 = null;
    com.google.javascript.rhino.jstype.JSType jSType49 = jSTypeRegistry43.getForgivingType(staticScope44, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array50 = new com.google.javascript.rhino.jstype.JSType[] { jSType49 };
    com.google.javascript.rhino.jstype.FunctionType functionType51 = jSTypeRegistry31.createFunctionType(jSType41, jSType_array50);
    boolean b52 = functionType51.isConstructor();
    functionNode28.setJSType((com.google.javascript.rhino.jstype.JSType)functionType51);
    com.google.javascript.jscomp.DiagnosticType diagnosticType54 = com.google.javascript.jscomp.NodeTraversal.NODE_TRAVERSAL_ERROR;
    java.text.MessageFormat messageFormat55 = diagnosticType54.format;
    java.lang.String[] str_array56 = com.google.javascript.rhino.ScriptRuntime.emptyStrings;
    com.google.javascript.jscomp.JSError jSError57 = nodeTraversal22.makeError((com.google.javascript.rhino.Node)functionNode28, diagnosticType54, str_array56);
    com.google.javascript.rhino.FunctionNode functionNode59 = new com.google.javascript.rhino.FunctionNode("");
    int i60 = functionNode59.getFunctionType();
    com.google.javascript.rhino.ErrorReporter errorReporter61 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry62 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter61);
    jSTypeRegistry62.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter65 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry66 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter65);
    com.google.javascript.rhino.jstype.StaticScope staticScope67 = null;
    com.google.javascript.rhino.jstype.JSType jSType72 = jSTypeRegistry66.getForgivingType(staticScope67, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter73 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry74 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter73);
    com.google.javascript.rhino.jstype.StaticScope staticScope75 = null;
    com.google.javascript.rhino.jstype.JSType jSType80 = jSTypeRegistry74.getForgivingType(staticScope75, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array81 = new com.google.javascript.rhino.jstype.JSType[] { jSType80 };
    com.google.javascript.rhino.jstype.FunctionType functionType82 = jSTypeRegistry62.createFunctionType(jSType72, jSType_array81);
    boolean b83 = functionType82.isConstructor();
    functionNode59.setJSType((com.google.javascript.rhino.jstype.JSType)functionType82);
    java.lang.String[] str_array85 = functionNode59.getParamAndVarNames();
    com.google.javascript.jscomp.JSError jSError86 = com.google.javascript.jscomp.JSError.make(diagnosticType54, str_array85);
    java.lang.String[] str_array87 = null;
    com.google.javascript.jscomp.JSError jSError88 = com.google.javascript.jscomp.JSError.make("goog.exportSymbol", (com.google.javascript.rhino.Node)functionNode12, diagnosticType54, str_array87);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i13 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str14 + "' != '" + ""+ "'", str14.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(subclassRelationship18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i29 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b52 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormat55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i60 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array81);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b83 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError88);

  }

  @Test
  public void test118() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test118"); }


    com.google.javascript.jscomp.Compiler compiler0 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.SourceExcerptProvider.SourceExcerpt sourceExcerpt1 = null;
    com.google.javascript.jscomp.LightweightMessageFormatter lightweightMessageFormatter2 = new com.google.javascript.jscomp.LightweightMessageFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler0, sourceExcerpt1);
    com.google.javascript.rhino.FunctionNode functionNode5 = new com.google.javascript.rhino.FunctionNode("");
    int i6 = functionNode5.getFunctionType();
    java.lang.String str7 = functionNode5.getFunctionName();
    boolean b8 = functionNode5.hasMoreThanOneChild();
    boolean[] b_array9 = functionNode5.getParamAndVarConst();
    int i10 = functionNode5.getCharno();
    com.google.javascript.jscomp.CheckLevel checkLevel12 = com.google.javascript.jscomp.CheckLevel.OFF;
    com.google.javascript.jscomp.DiagnosticType diagnosticType14 = com.google.javascript.jscomp.DiagnosticType.make("EOF", checkLevel12, "// Input %num%");
    com.google.javascript.rhino.ErrorReporter errorReporter16 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry17 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter16);
    jSTypeRegistry17.forwardDeclareType("hi!");
    com.google.javascript.rhino.jstype.FunctionParamBuilder functionParamBuilder20 = new com.google.javascript.rhino.jstype.FunctionParamBuilder(jSTypeRegistry17);
    com.google.javascript.rhino.ErrorReporter errorReporter21 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry22 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter21);
    jSTypeRegistry22.forwardDeclareType("hi!");
    com.google.javascript.rhino.jstype.FunctionParamBuilder functionParamBuilder25 = new com.google.javascript.rhino.jstype.FunctionParamBuilder(jSTypeRegistry22);
    com.google.javascript.rhino.Node node26 = functionParamBuilder25.build();
    boolean b27 = node26.hasMoreThanOneChild();
    com.google.javascript.rhino.Node node28 = functionParamBuilder20.newParameterFromNode(node26);
    com.google.javascript.rhino.Node node31 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable32 = node31.getAncestors();
    java.lang.String str33 = node31.toString();
    java.util.logging.Logger logger34 = null;
    com.google.javascript.jscomp.LoggerErrorManager loggerErrorManager35 = new com.google.javascript.jscomp.LoggerErrorManager(logger34);
    com.google.javascript.jscomp.CheckLevel checkLevel36 = com.google.javascript.jscomp.CheckLevel.OFF;
    com.google.javascript.rhino.Node node39 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable40 = node39.getAncestors();
    com.google.javascript.rhino.Node node42 = new com.google.javascript.rhino.Node(0);
    boolean b43 = node39.hasChild(node42);
    com.google.javascript.rhino.Node node45 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str46 = node42.checkTreeEquals(node45);
    com.google.javascript.rhino.FunctionNode functionNode50 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.Node node52 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable53 = node52.getAncestors();
    com.google.javascript.rhino.Node node55 = new com.google.javascript.rhino.Node(0);
    boolean b56 = node52.hasChild(node55);
    node52.putBooleanProp(83, false);
    functionNode50.addChildrenToBack(node52);
    boolean b61 = node42.checkTreeTypeAwareEqualsSilent(node52);
    com.google.javascript.jscomp.CheckLevel checkLevel62 = com.google.javascript.jscomp.CheckLevel.OFF;
    com.google.javascript.jscomp.DiagnosticType diagnosticType63 = com.google.javascript.jscomp.NodeTraversal.NODE_TRAVERSAL_ERROR;
    com.google.javascript.rhino.FunctionNode functionNode65 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String[] str_array66 = functionNode65.getParamAndVarNames();
    com.google.javascript.jscomp.JSError jSError67 = com.google.javascript.jscomp.JSError.make("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", node42, checkLevel62, diagnosticType63, str_array66);
    loggerErrorManager35.println(checkLevel36, jSError67);
    com.google.javascript.jscomp.DiagnosticType diagnosticType69 = com.google.javascript.jscomp.Compiler.OPTIMIZE_LOOP_ERROR;
    java.lang.String[] str_array70 = null;
    com.google.javascript.jscomp.JSError jSError71 = com.google.javascript.jscomp.JSError.make("hi!", node31, checkLevel36, diagnosticType69, str_array70);
    com.google.javascript.rhino.FunctionNode functionNode73 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String[] str_array74 = functionNode73.getParamAndVarNames();
    functionNode73.addParam("hi!");
    java.lang.String[] str_array77 = functionNode73.getParamAndVarNames();
    com.google.javascript.jscomp.JSError jSError78 = com.google.javascript.jscomp.JSError.make("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", node26, diagnosticType69, str_array77);
    com.google.javascript.rhino.FunctionNode functionNode82 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    int i83 = functionNode82.getFunctionType();
    java.lang.String[] str_array84 = functionNode82.getParamAndVarNames();
    com.google.javascript.jscomp.JSError jSError85 = com.google.javascript.jscomp.JSError.make("@IMPLEMENTATION.VERSION@", (com.google.javascript.rhino.Node)functionNode5, checkLevel12, diagnosticType69, str_array84);
    boolean b87 = jSError85.equals((java.lang.Object)115);
    // The following exception was thrown during execution in test generation
    try {
      java.lang.String str88 = lightweightMessageFormatter2.formatError(jSError85);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str7 + "' != '" + ""+ "'", str7.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(b_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i10 == (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str33 + "' != '" + "EOF"+ "'", str33.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b43 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str46 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str46.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b56 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b61 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array74);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError78);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i83 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b87 == false);

  }

  @Test
  public void test119() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test119"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.Node node25 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable26 = node25.getAncestors();
    java.lang.String str27 = node25.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType28 = jSTypeRegistry1.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType23, node25);
    jSTypeRegistry1.setLastGeneration(true);
    boolean b31 = jSTypeRegistry1.shouldTolerateUndefinedValues();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str27 + "' != '" + "EOF"+ "'", str27.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);

  }

  @Test
  public void test120() {}
// Defects4J: flaky method
//   @Test
//   public void test120() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test120"); }
// 
// 
//     com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler1 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState2 = compiler1.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter4 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler1, true);
//     com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list7 = jSModule6.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback8 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler1, list7, callback8);
//     com.google.javascript.jscomp.ErrorManager errorManager10 = compiler1.getErrorManager();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback11 = null;
//     com.google.javascript.jscomp.NodeTraversal nodeTraversal12 = new com.google.javascript.jscomp.NodeTraversal((com.google.javascript.jscomp.AbstractCompiler)compiler1, callback11);
//     com.google.javascript.rhino.Node node13 = nodeTraversal12.getCurrentNode();
//     com.google.javascript.jscomp.Compiler compiler14 = nodeTraversal12.getCompiler();
//     com.google.javascript.jscomp.JSSourceFile jSSourceFile17 = com.google.javascript.jscomp.JSSourceFile.fromCode("84", "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n");
//     com.google.javascript.jscomp.Region region19 = jSSourceFile17.getRegion(0);
//     com.google.javascript.rhino.Node node20 = compiler14.parse(jSSourceFile17);
//     com.google.javascript.jscomp.Compiler compiler21 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState22 = compiler21.getState();
//     com.google.javascript.rhino.Node node23 = compiler21.getRoot();
//     com.google.javascript.jscomp.LightweightMessageFormatter lightweightMessageFormatter24 = new com.google.javascript.jscomp.LightweightMessageFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler21);
//     java.util.logging.Logger logger25 = null;
//     com.google.javascript.jscomp.LoggerErrorManager loggerErrorManager26 = new com.google.javascript.jscomp.LoggerErrorManager((com.google.javascript.jscomp.MessageFormatter)lightweightMessageFormatter24, logger25);
//     compiler14.setErrorManager((com.google.javascript.jscomp.ErrorManager)loggerErrorManager26);
//     int i28 = loggerErrorManager26.getErrorCount();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorManager10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(node13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(compiler14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile17);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(region19);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(node20);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(node23);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i28 == 0);
// 
//   }

  @Test
  public void test121() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test121"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    compilerOptions0.setDefineToBooleanLiteral("hi!", false);
    boolean b8 = compilerOptions0.instrumentForCoverage;
    compilerOptions0.collapseAnonymousFunctions = false;
    compilerOptions0.removeUnusedPrototypeProperties = true;
    compilerOptions0.setCollapsePropertiesOnExternTypes(false);
    boolean b15 = compilerOptions0.inlineVariables;
    java.lang.String str16 = compilerOptions0.unaliasableGlobals;
    boolean b17 = compilerOptions0.gatherCssNames;
    compilerOptions0.strictMessageReplacement = false;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);

  }

  @Test
  public void test122() {}
// Defects4J: flaky method
//   @Test
//   public void test122() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test122"); }
// 
// 
//     com.google.javascript.rhino.Context context0 = null;
//     com.google.javascript.rhino.Context context1 = com.google.javascript.rhino.Context.enter(context0);
//     context1.removeActivationName("OFF");
//     int i4 = context1.getLanguageVersion();
//     com.google.javascript.rhino.ErrorReporter errorReporter5 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry6 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter5);
//     com.google.javascript.rhino.ErrorReporter errorReporter7 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry8 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter7);
//     jSTypeRegistry8.forwardDeclareType("hi!");
//     com.google.javascript.rhino.ErrorReporter errorReporter11 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry12 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter11);
//     com.google.javascript.rhino.jstype.StaticScope staticScope13 = null;
//     com.google.javascript.rhino.jstype.JSType jSType18 = jSTypeRegistry12.getForgivingType(staticScope13, "hi!", "", 0, 1);
//     com.google.javascript.rhino.ErrorReporter errorReporter19 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry20 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter19);
//     com.google.javascript.rhino.jstype.StaticScope staticScope21 = null;
//     com.google.javascript.rhino.jstype.JSType jSType26 = jSTypeRegistry20.getForgivingType(staticScope21, "hi!", "", 0, 1);
//     com.google.javascript.rhino.jstype.JSType[] jSType_array27 = new com.google.javascript.rhino.jstype.JSType[] { jSType26 };
//     com.google.javascript.rhino.jstype.FunctionType functionType28 = jSTypeRegistry8.createFunctionType(jSType18, jSType_array27);
//     com.google.javascript.rhino.jstype.JSType jSType29 = functionType28.unboxesTo();
//     com.google.javascript.rhino.ErrorReporter errorReporter31 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry32 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter31);
//     jSTypeRegistry32.forwardDeclareType("hi!");
//     com.google.javascript.rhino.ErrorReporter errorReporter35 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry36 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter35);
//     com.google.javascript.rhino.jstype.StaticScope staticScope37 = null;
//     com.google.javascript.rhino.jstype.JSType jSType42 = jSTypeRegistry36.getForgivingType(staticScope37, "hi!", "", 0, 1);
//     com.google.javascript.rhino.ErrorReporter errorReporter43 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry44 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter43);
//     com.google.javascript.rhino.jstype.StaticScope staticScope45 = null;
//     com.google.javascript.rhino.jstype.JSType jSType50 = jSTypeRegistry44.getForgivingType(staticScope45, "hi!", "", 0, 1);
//     com.google.javascript.rhino.jstype.JSType[] jSType_array51 = new com.google.javascript.rhino.jstype.JSType[] { jSType50 };
//     com.google.javascript.rhino.jstype.FunctionType functionType52 = jSTypeRegistry32.createFunctionType(jSType42, jSType_array51);
//     com.google.javascript.rhino.jstype.FunctionType functionType53 = jSTypeRegistry6.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType28, false, jSType_array51);
//     com.google.javascript.rhino.ErrorReporter errorReporter54 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry55 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter54);
//     com.google.javascript.rhino.ErrorReporter errorReporter56 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry57 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter56);
//     jSTypeRegistry57.forwardDeclareType("hi!");
//     com.google.javascript.rhino.ErrorReporter errorReporter60 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry61 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter60);
//     com.google.javascript.rhino.jstype.StaticScope staticScope62 = null;
//     com.google.javascript.rhino.jstype.JSType jSType67 = jSTypeRegistry61.getForgivingType(staticScope62, "hi!", "", 0, 1);
//     com.google.javascript.rhino.ErrorReporter errorReporter68 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry69 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter68);
//     com.google.javascript.rhino.jstype.StaticScope staticScope70 = null;
//     com.google.javascript.rhino.jstype.JSType jSType75 = jSTypeRegistry69.getForgivingType(staticScope70, "hi!", "", 0, 1);
//     com.google.javascript.rhino.jstype.JSType[] jSType_array76 = new com.google.javascript.rhino.jstype.JSType[] { jSType75 };
//     com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry57.createFunctionType(jSType67, jSType_array76);
//     com.google.javascript.rhino.Node node79 = new com.google.javascript.rhino.Node(0);
//     com.google.javascript.rhino.Node.AncestorIterable ancestorIterable80 = node79.getAncestors();
//     java.lang.String str81 = node79.toString();
//     com.google.javascript.rhino.jstype.FunctionType functionType82 = jSTypeRegistry55.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType77, node79);
//     functionType28.setPrototypeBasedOn((com.google.javascript.rhino.jstype.ObjectType)functionType82);
//     com.google.javascript.rhino.jstype.JSType jSType84 = functionType82.getReturnType();
//     java.lang.Object obj85 = context1.getThreadLocal((java.lang.Object)jSType84);
//     context1.setInstructionObserverThreshold(301);
//     int i88 = context1.getOptimizationLevel();
//     long long89 = com.google.javascript.rhino.ScriptRuntime.lastUint32Result(context1);
//     java.lang.Object obj90 = context1.getDebuggerContextData();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(context1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i4 == 0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType18);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType26);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType_array27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType28);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(jSType29);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType42);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType50);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType_array51);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType52);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType53);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType67);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType75);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType_array76);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType77);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(ancestorIterable80);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str81 + "' != '" + "EOF"+ "'", str81.equals("EOF"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType82);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType84);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(obj85);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i88 == 0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long89 == 0L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(obj90);
// 
//   }

  @Test
  public void test123() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test123"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.debugFunctionSideEffectsPath = "hi!";
    compilerOptions0.removeUnusedVars = true;
    compilerOptions0.inputDelimiter = "function ({proxy:{1347039697}}): {proxy:{1390996524}}";
    compilerOptions0.ignoreCajaProperties = true;
    compilerOptions0.checkControlStructures = false;

  }

  @Test
  public void test124() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test124"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    com.google.javascript.rhino.jstype.FunctionParamBuilder functionParamBuilder4 = new com.google.javascript.rhino.jstype.FunctionParamBuilder(jSTypeRegistry1);
    com.google.javascript.rhino.ErrorReporter errorReporter5 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry6 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter5);
    jSTypeRegistry6.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter9 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry10 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter9);
    com.google.javascript.rhino.jstype.StaticScope staticScope11 = null;
    com.google.javascript.rhino.jstype.JSType jSType16 = jSTypeRegistry10.getForgivingType(staticScope11, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter17 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry18 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter17);
    com.google.javascript.rhino.jstype.StaticScope staticScope19 = null;
    com.google.javascript.rhino.jstype.JSType jSType24 = jSTypeRegistry18.getForgivingType(staticScope19, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array25 = new com.google.javascript.rhino.jstype.JSType[] { jSType24 };
    com.google.javascript.rhino.jstype.FunctionType functionType26 = jSTypeRegistry6.createFunctionType(jSType16, jSType_array25);
    com.google.javascript.rhino.jstype.JSType jSType27 = jSTypeRegistry1.createUnionType(jSType_array25);
    jSTypeRegistry1.setLastGeneration(true);
    jSTypeRegistry1.resetForTypeCheck();
    jSTypeRegistry1.incrementGeneration();
    boolean b32 = jSTypeRegistry1.shouldTolerateUndefinedValues();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == false);

  }

  @Test
  public void test125() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test125"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions1 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions1.collapseVariableDeclarations = true;
    compilerOptions1.setSummaryDetailLevel(86);
    compilerOptions1.setDefineToBooleanLiteral("hi!", false);
    boolean b9 = compilerOptions1.instrumentForCoverage;
    com.google.common.collect.Multimap multimap10 = null;
    compilerOptions1.customPasses = multimap10;
    boolean b12 = compilerOptions1.inferTypesInGlobalScope;
    com.google.javascript.jscomp.ErrorFormat errorFormat13 = compilerOptions1.errorFormat;
    com.google.javascript.jscomp.CheckLevel checkLevel14 = compilerOptions1.checkGlobalThisLevel;
    boolean b15 = compilerOptions1.inlineGetters;
    boolean b16 = compilerOptions1.smartNameRemoval;
    com.google.javascript.jscomp.CheckLevel checkLevel17 = compilerOptions1.reportUnknownTypes;
    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.jscomp.DiagnosticType diagnosticType19 = com.google.javascript.jscomp.DiagnosticType.make("in", checkLevel17, "function ({proxy:{1017305348}}): {proxy:{99123531}}");
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel17);

  }

  @Test
  public void test126() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test126"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.jstype.JSType jSType24 = functionType23.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter26 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry27 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter26);
    jSTypeRegistry27.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter30 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry31 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter30);
    com.google.javascript.rhino.jstype.StaticScope staticScope32 = null;
    com.google.javascript.rhino.jstype.JSType jSType37 = jSTypeRegistry31.getForgivingType(staticScope32, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array46 = new com.google.javascript.rhino.jstype.JSType[] { jSType45 };
    com.google.javascript.rhino.jstype.FunctionType functionType47 = jSTypeRegistry27.createFunctionType(jSType37, jSType_array46);
    com.google.javascript.rhino.jstype.FunctionType functionType48 = jSTypeRegistry1.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType23, false, jSType_array46);
    com.google.javascript.rhino.ErrorReporter errorReporter49 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry50 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter49);
    com.google.javascript.rhino.ErrorReporter errorReporter51 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry52 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter51);
    jSTypeRegistry52.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter55 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry56 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter55);
    com.google.javascript.rhino.jstype.StaticScope staticScope57 = null;
    com.google.javascript.rhino.jstype.JSType jSType62 = jSTypeRegistry56.getForgivingType(staticScope57, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array71 = new com.google.javascript.rhino.jstype.JSType[] { jSType70 };
    com.google.javascript.rhino.jstype.FunctionType functionType72 = jSTypeRegistry52.createFunctionType(jSType62, jSType_array71);
    com.google.javascript.rhino.Node node74 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable75 = node74.getAncestors();
    java.lang.String str76 = node74.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry50.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType72, node74);
    functionType23.setPrototypeBasedOn((com.google.javascript.rhino.jstype.ObjectType)functionType77);
    int i79 = functionType77.getMaxArguments();
    com.google.javascript.rhino.JSDocInfo jSDocInfo80 = functionType77.getJSDocInfo();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str76 + "' != '" + "EOF"+ "'", str76.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i79 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSDocInfo80);

  }

  @Test
  public void test127() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test127"); }


    com.google.javascript.jscomp.DiagnosticType diagnosticType2 = com.google.javascript.jscomp.DiagnosticType.warning("function ({proxy:{1347039697}}): {proxy:{1390996524}}", "Named type with empty name component");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType2);

  }

  @Test
  public void test128() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test128"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSDocInfo jSDocInfo3 = jSDocInfoBuilder1.build("");
    boolean b5 = jSDocInfoBuilder1.recordLends("EOF");
    boolean b7 = jSDocInfoBuilder1.recordBlockDescription("OFF");
    java.util.Set set8 = null;
    boolean b9 = jSDocInfoBuilder1.recordModifies(set8);
    boolean b10 = jSDocInfoBuilder1.isPopulated();
    boolean b11 = jSDocInfoBuilder1.recordNoCompile();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSDocInfo3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);

  }

  @Test
  public void test129() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test129"); }


    com.google.javascript.rhino.FunctionNode functionNode1 = new com.google.javascript.rhino.FunctionNode("");
    functionNode1.setEndLineno(148);
    java.lang.Iterable iterable4 = functionNode1.siblings();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(iterable4);

  }

  @Test
  public void test130() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test130"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter4 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry5 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter4);
    com.google.javascript.rhino.jstype.StaticScope staticScope6 = null;
    com.google.javascript.rhino.jstype.JSType jSType11 = jSTypeRegistry5.getForgivingType(staticScope6, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter12 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry13 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter12);
    com.google.javascript.rhino.jstype.StaticScope staticScope14 = null;
    com.google.javascript.rhino.jstype.JSType jSType19 = jSTypeRegistry13.getForgivingType(staticScope14, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array20 = new com.google.javascript.rhino.jstype.JSType[] { jSType19 };
    com.google.javascript.rhino.jstype.FunctionType functionType21 = jSTypeRegistry1.createFunctionType(jSType11, jSType_array20);
    com.google.javascript.rhino.jstype.JSType jSType22 = functionType21.unboxesTo();
    java.util.Set set23 = functionType21.getOwnPropertyNames();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType24 = functionType21.getPrototype();
    boolean b25 = functionType21.isBooleanObjectType();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);

  }

  @Test
  public void test131() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test131"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.jstype.JSType jSType24 = functionType23.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter26 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry27 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter26);
    jSTypeRegistry27.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter30 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry31 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter30);
    com.google.javascript.rhino.jstype.StaticScope staticScope32 = null;
    com.google.javascript.rhino.jstype.JSType jSType37 = jSTypeRegistry31.getForgivingType(staticScope32, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array46 = new com.google.javascript.rhino.jstype.JSType[] { jSType45 };
    com.google.javascript.rhino.jstype.FunctionType functionType47 = jSTypeRegistry27.createFunctionType(jSType37, jSType_array46);
    com.google.javascript.rhino.jstype.FunctionType functionType48 = jSTypeRegistry1.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType23, false, jSType_array46);
    com.google.javascript.rhino.ErrorReporter errorReporter49 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry50 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter49);
    com.google.javascript.rhino.ErrorReporter errorReporter51 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry52 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter51);
    jSTypeRegistry52.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter55 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry56 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter55);
    com.google.javascript.rhino.jstype.StaticScope staticScope57 = null;
    com.google.javascript.rhino.jstype.JSType jSType62 = jSTypeRegistry56.getForgivingType(staticScope57, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array71 = new com.google.javascript.rhino.jstype.JSType[] { jSType70 };
    com.google.javascript.rhino.jstype.FunctionType functionType72 = jSTypeRegistry52.createFunctionType(jSType62, jSType_array71);
    com.google.javascript.rhino.Node node74 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable75 = node74.getAncestors();
    java.lang.String str76 = node74.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry50.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType72, node74);
    functionType23.setPrototypeBasedOn((com.google.javascript.rhino.jstype.ObjectType)functionType77);
    com.google.javascript.rhino.jstype.JSType jSType79 = functionType23.restrictByNotNullOrUndefined();
    java.lang.String str80 = functionType23.toString();
    com.google.javascript.rhino.jstype.JSType jSType81 = functionType23.autoboxesTo();
    com.google.javascript.rhino.jstype.JSType jSType82 = null;
    boolean b83 = functionType23.isEquivalentTo(jSType82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str76 + "' != '" + "EOF"+ "'", str76.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str80 + "' != '" + "function (hi!): hi!"+ "'", str80.equals("function (hi!): hi!"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType81);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b83 == false);

  }

  @Test
  public void test132() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test132"); }


    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.rhino.EcmaError ecmaError1 = com.google.javascript.rhino.ScriptRuntime.typeError0("");
      org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException");
    } catch (java.lang.RuntimeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.RuntimeException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test133() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test133"); }


    com.google.javascript.rhino.EcmaError ecmaError1 = com.google.javascript.rhino.ScriptRuntime.typeError("Not declared as a constructor");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ecmaError1);

  }

  @Test
  public void test134() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test134"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b2 = jSDocInfoBuilder1.recordExport();
    boolean b4 = jSDocInfoBuilder1.recordBlockDescription("OFF");
    com.google.javascript.rhino.JSDocInfo jSDocInfo6 = jSDocInfoBuilder1.build("JSC_NODE_TRAVERSAL_ERROR. {0} at Node tree inequality:\\nTree1:\\nEOF\\n\\n\\nTree2:\\nBANG 0\\n    STRING hi 0\\n\\n\\nSubtree1: EOF\\n\\n\\nSubtree2: BANG 0\\n    STRING hi 0\\n line (unknown line) : (unknown column)");
    java.lang.String str7 = jSDocInfo6.getDeprecationReason();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSDocInfo6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str7);

  }

  @Test
  public void test135() {}
// Defects4J: flaky method
//   @Test
//   public void test135() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test135"); }
// 
// 
//     com.google.javascript.rhino.Context context0 = null;
//     com.google.javascript.rhino.Context context1 = com.google.javascript.rhino.Context.enter(context0);
//     context1.removeActivationName("OFF");
//     int i4 = context1.getLanguageVersion();
//     com.google.javascript.rhino.ErrorReporter errorReporter5 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry6 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter5);
//     com.google.javascript.rhino.ErrorReporter errorReporter7 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry8 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter7);
//     jSTypeRegistry8.forwardDeclareType("hi!");
//     com.google.javascript.rhino.ErrorReporter errorReporter11 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry12 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter11);
//     com.google.javascript.rhino.jstype.StaticScope staticScope13 = null;
//     com.google.javascript.rhino.jstype.JSType jSType18 = jSTypeRegistry12.getForgivingType(staticScope13, "hi!", "", 0, 1);
//     com.google.javascript.rhino.ErrorReporter errorReporter19 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry20 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter19);
//     com.google.javascript.rhino.jstype.StaticScope staticScope21 = null;
//     com.google.javascript.rhino.jstype.JSType jSType26 = jSTypeRegistry20.getForgivingType(staticScope21, "hi!", "", 0, 1);
//     com.google.javascript.rhino.jstype.JSType[] jSType_array27 = new com.google.javascript.rhino.jstype.JSType[] { jSType26 };
//     com.google.javascript.rhino.jstype.FunctionType functionType28 = jSTypeRegistry8.createFunctionType(jSType18, jSType_array27);
//     com.google.javascript.rhino.jstype.JSType jSType29 = functionType28.unboxesTo();
//     com.google.javascript.rhino.ErrorReporter errorReporter31 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry32 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter31);
//     jSTypeRegistry32.forwardDeclareType("hi!");
//     com.google.javascript.rhino.ErrorReporter errorReporter35 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry36 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter35);
//     com.google.javascript.rhino.jstype.StaticScope staticScope37 = null;
//     com.google.javascript.rhino.jstype.JSType jSType42 = jSTypeRegistry36.getForgivingType(staticScope37, "hi!", "", 0, 1);
//     com.google.javascript.rhino.ErrorReporter errorReporter43 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry44 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter43);
//     com.google.javascript.rhino.jstype.StaticScope staticScope45 = null;
//     com.google.javascript.rhino.jstype.JSType jSType50 = jSTypeRegistry44.getForgivingType(staticScope45, "hi!", "", 0, 1);
//     com.google.javascript.rhino.jstype.JSType[] jSType_array51 = new com.google.javascript.rhino.jstype.JSType[] { jSType50 };
//     com.google.javascript.rhino.jstype.FunctionType functionType52 = jSTypeRegistry32.createFunctionType(jSType42, jSType_array51);
//     com.google.javascript.rhino.jstype.FunctionType functionType53 = jSTypeRegistry6.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType28, false, jSType_array51);
//     com.google.javascript.rhino.ErrorReporter errorReporter54 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry55 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter54);
//     com.google.javascript.rhino.ErrorReporter errorReporter56 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry57 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter56);
//     jSTypeRegistry57.forwardDeclareType("hi!");
//     com.google.javascript.rhino.ErrorReporter errorReporter60 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry61 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter60);
//     com.google.javascript.rhino.jstype.StaticScope staticScope62 = null;
//     com.google.javascript.rhino.jstype.JSType jSType67 = jSTypeRegistry61.getForgivingType(staticScope62, "hi!", "", 0, 1);
//     com.google.javascript.rhino.ErrorReporter errorReporter68 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry69 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter68);
//     com.google.javascript.rhino.jstype.StaticScope staticScope70 = null;
//     com.google.javascript.rhino.jstype.JSType jSType75 = jSTypeRegistry69.getForgivingType(staticScope70, "hi!", "", 0, 1);
//     com.google.javascript.rhino.jstype.JSType[] jSType_array76 = new com.google.javascript.rhino.jstype.JSType[] { jSType75 };
//     com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry57.createFunctionType(jSType67, jSType_array76);
//     com.google.javascript.rhino.Node node79 = new com.google.javascript.rhino.Node(0);
//     com.google.javascript.rhino.Node.AncestorIterable ancestorIterable80 = node79.getAncestors();
//     java.lang.String str81 = node79.toString();
//     com.google.javascript.rhino.jstype.FunctionType functionType82 = jSTypeRegistry55.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType77, node79);
//     functionType28.setPrototypeBasedOn((com.google.javascript.rhino.jstype.ObjectType)functionType82);
//     com.google.javascript.rhino.jstype.JSType jSType84 = functionType82.getReturnType();
//     java.lang.Object obj85 = context1.getThreadLocal((java.lang.Object)jSType84);
//     context1.setInstructionObserverThreshold(301);
//     java.util.Locale locale88 = null;
//     java.util.Locale locale89 = context1.setLocale(locale88);
//     boolean b90 = context1.hasCompileFunctionsWithDynamicScope();
//     com.google.javascript.rhino.ErrorReporter errorReporter91 = context1.getErrorReporter();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(context1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i4 == 0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType18);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType26);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType_array27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType28);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(jSType29);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType42);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType50);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType_array51);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType52);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType53);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType67);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType75);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType_array76);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType77);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(ancestorIterable80);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str81 + "' != '" + "EOF"+ "'", str81.equals("EOF"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType82);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType84);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(obj85);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(locale89);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b90 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(errorReporter91);
// 
//   }

  @Test
  public void test136() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test136"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    java.lang.String str3 = compilerOptions0.inputDelimiter;
    compilerOptions0.checkSymbols = false;
    compilerOptions0.checkTypedPropertyCalls = true;
    compilerOptions0.renamePrefix = "84";
    compilerOptions0.setSummaryDetailLevel(89);
    compilerOptions0.removeUnusedVarsInGlobalScope = true;
    boolean b14 = compilerOptions0.ambiguateProperties;
    compilerOptions0.checkEs5Strict = true;
    com.google.javascript.jscomp.CheckLevel checkLevel17 = compilerOptions0.checkUndefinedProperties;
    boolean b18 = compilerOptions0.rewriteFunctionExpressions;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str3 + "' != '" + "// Input %num%"+ "'", str3.equals("// Input %num%"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == false);

  }

  @Test
  public void test137() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test137"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    com.google.javascript.rhino.jstype.FunctionParamBuilder functionParamBuilder4 = new com.google.javascript.rhino.jstype.FunctionParamBuilder(jSTypeRegistry1);
    boolean b6 = jSTypeRegistry1.hasNamespace("error reporter");
    boolean b8 = jSTypeRegistry1.hasNamespace("{...}");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);

  }

  @Test
  public void test138() {}
// Defects4J: flaky method
//   @Test
//   public void test138() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test138"); }
// 
// 
//     com.google.javascript.rhino.Context context0 = null;
//     com.google.javascript.rhino.Context context1 = com.google.javascript.rhino.Context.enter(context0);
//     context1.removeActivationName("OFF");
//     boolean b4 = context1.isGeneratingSource();
//     com.google.javascript.rhino.JSDocInfo jSDocInfo5 = new com.google.javascript.rhino.JSDocInfo();
//     java.lang.String str6 = jSDocInfo5.getTemplateTypeName();
//     boolean b7 = jSDocInfo5.hasEnumParameterType();
//     boolean b8 = jSDocInfo5.isConstant();
//     java.lang.String str9 = jSDocInfo5.toString();
//     java.util.Set set10 = jSDocInfo5.getModifies();
//     java.lang.String str11 = jSDocInfo5.getFileOverview();
//     boolean b12 = jSDocInfo5.isNoCompile();
//     boolean b13 = jSDocInfo5.isNoAlias();
//     context1.removeThreadLocal((java.lang.Object)b13);
//     boolean b15 = context1.isGeneratingDebug();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(context1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b4 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(str6);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b7 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b8 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str9 + "' != '" + "JSDocInfo"+ "'", str9.equals("JSDocInfo"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(set10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(str11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b12 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b13 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b15 == false);
// 
//   }

  @Test
  public void test139() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test139"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.Node node25 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable26 = node25.getAncestors();
    java.lang.String str27 = node25.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType28 = jSTypeRegistry1.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType23, node25);
    com.google.javascript.rhino.JSDocInfo jSDocInfo29 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str30 = jSDocInfo29.getTemplateTypeName();
    boolean b31 = jSDocInfo29.hasEnumParameterType();
    functionType23.setJSDocInfo(jSDocInfo29);
    boolean b33 = jSDocInfo29.isNoTypeCheck();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str27 + "' != '" + "EOF"+ "'", str27.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);

  }

  @Test
  public void test140() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test140"); }


    com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler1 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState2 = compiler1.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter4 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler1, true);
    com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list7 = jSModule6.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback8 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler1, list7, callback8);
    com.google.javascript.jscomp.JSModuleGraph jSModuleGraph10 = new com.google.javascript.jscomp.JSModuleGraph(list7);
    com.google.javascript.jscomp.JSModule jSModule12 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list13 = jSModule12.getDependencies();
    java.util.List list14 = jSModule12.getProvides();
    com.google.javascript.jscomp.ErrorFormat errorFormat15 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler16 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState17 = compiler16.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter19 = errorFormat15.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler16, true);
    com.google.javascript.jscomp.JSModule jSModule21 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list22 = jSModule21.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback23 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler16, list22, callback23);
    com.google.javascript.jscomp.ErrorManager errorManager25 = compiler16.getErrorManager();
    com.google.javascript.jscomp.JSModule jSModule27 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list28 = jSModule27.getDependencies();
    java.util.List list29 = jSModule27.getProvides();
    java.lang.String[] str_array30 = compiler16.toSourceArray(jSModule27);
    com.google.javascript.jscomp.JSModule[] jSModule_array31 = new com.google.javascript.jscomp.JSModule[] { jSModule27 };
    com.google.javascript.jscomp.JSModuleGraph jSModuleGraph32 = new com.google.javascript.jscomp.JSModuleGraph(jSModule_array31);
    com.google.javascript.jscomp.SourceFile.Generator generator34 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile35 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator34);
    com.google.javascript.jscomp.CompilerInput compilerInput36 = new com.google.javascript.jscomp.CompilerInput(jSSourceFile35);
    boolean b37 = compilerInput36.isExtern();
    com.google.javascript.jscomp.JSModule jSModule39 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list40 = jSModule39.getDependencies();
    java.util.List list41 = jSModule39.getProvides();
    compilerInput36.setModule(jSModule39);
    com.google.javascript.jscomp.JSModule jSModule44 = new com.google.javascript.jscomp.JSModule("");
    java.lang.String str45 = jSModule44.getName();
    boolean b46 = jSModuleGraph32.dependsOn(jSModule39, jSModule44);
    com.google.javascript.jscomp.JSModule jSModule47 = jSModuleGraph10.getDeepestCommonDependencyInclusive(jSModule12, jSModule39);
    com.google.javascript.jscomp.SourceFile.Generator generator49 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile50 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator49);
    com.google.javascript.jscomp.CompilerInput compilerInput51 = new com.google.javascript.jscomp.CompilerInput(jSSourceFile50);
    boolean b52 = compilerInput51.isExtern();
    com.google.javascript.jscomp.JSModule jSModule54 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list55 = jSModule54.getDependencies();
    java.util.List list56 = jSModule54.getProvides();
    compilerInput51.setModule(jSModule54);
    java.lang.String str58 = jSModule54.getName();
    jSModule54.setDepth(90);
    java.util.List list61 = jSModule54.getInputs();
    com.google.javascript.jscomp.ErrorFormat errorFormat62 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler63 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState64 = compiler63.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter66 = errorFormat62.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler63, true);
    com.google.javascript.jscomp.JSModule jSModule68 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list69 = jSModule68.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback70 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler63, list69, callback70);
    com.google.javascript.jscomp.JSModuleGraph jSModuleGraph72 = new com.google.javascript.jscomp.JSModuleGraph(list69);
    com.google.javascript.jscomp.JSModule jSModule74 = new com.google.javascript.jscomp.JSModule("");
    jSModule74.clearAsts();
    com.google.javascript.jscomp.SourceFile.Generator generator77 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile78 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator77);
    com.google.javascript.jscomp.CompilerInput compilerInput79 = new com.google.javascript.jscomp.CompilerInput(jSSourceFile78);
    boolean b80 = compilerInput79.isExtern();
    com.google.javascript.jscomp.JSModule jSModule82 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list83 = jSModule82.getDependencies();
    java.util.List list84 = jSModule82.getProvides();
    compilerInput79.setModule(jSModule82);
    com.google.javascript.jscomp.JSModule jSModule86 = jSModuleGraph72.getDeepestCommonDependencyInclusive(jSModule74, jSModule82);
    int i87 = jSModule74.getDepth();
    java.lang.String str88 = jSModule74.getName();
    boolean b89 = jSModuleGraph10.dependsOn(jSModule54, jSModule74);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorManager25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSModule_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str45 + "' != '" + ""+ "'", str45.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b46 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSModule47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b52 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str58 + "' != '" + ""+ "'", str58.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile78);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b80 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list83);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSModule86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i87 == (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str88 + "' != '" + ""+ "'", str88.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b89 == false);

  }

  @Test
  public void test141() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test141"); }


    java.nio.charset.Charset charset1 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile2 = com.google.javascript.jscomp.JSSourceFile.fromFile("JSDocInfo", charset1);
    java.lang.String str3 = jSSourceFile2.getName();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str3 + "' != '" + "JSDocInfo"+ "'", str3.equals("JSDocInfo"));

  }

  @Test
  public void test142() {}
// Defects4J: flaky method
//   @Test
//   public void test142() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test142"); }
// 
// 
//     com.google.javascript.jscomp.DefaultCodingConvention defaultCodingConvention0 = new com.google.javascript.jscomp.DefaultCodingConvention();
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = null;
//     com.google.javascript.jscomp.Scope scope2 = null;
//     com.google.javascript.jscomp.JSModule jSModule4 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list5 = jSModule4.getDependencies();
//     defaultCodingConvention0.defineDelegateProxyPrototypeProperties(jSTypeRegistry1, scope2, list5);
//     com.google.javascript.rhino.Node node8 = new com.google.javascript.rhino.Node(0);
//     com.google.javascript.rhino.Node node10 = new com.google.javascript.rhino.Node(0);
//     com.google.javascript.rhino.Node.AncestorIterable ancestorIterable11 = node10.getAncestors();
//     com.google.javascript.rhino.Node node13 = new com.google.javascript.rhino.Node(0);
//     boolean b14 = node10.hasChild(node13);
//     com.google.javascript.rhino.Node node16 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
//     java.lang.String str17 = node13.checkTreeEquals(node16);
//     com.google.javascript.rhino.Node node18 = node8.copyInformationFromForTree(node13);
//     boolean b19 = node8.hasOneChild();
//     com.google.javascript.rhino.Node node20 = node8.cloneTree();
//     java.lang.String str21 = defaultCodingConvention0.getSingletonGetterClassName(node20);
//     com.google.javascript.rhino.ErrorReporter errorReporter22 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry23 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter22);
//     jSTypeRegistry23.forwardDeclareType("hi!");
//     com.google.javascript.rhino.jstype.FunctionParamBuilder functionParamBuilder26 = new com.google.javascript.rhino.jstype.FunctionParamBuilder(jSTypeRegistry23);
//     com.google.javascript.rhino.ErrorReporter errorReporter27 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry28 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter27);
//     jSTypeRegistry28.forwardDeclareType("hi!");
//     com.google.javascript.rhino.ErrorReporter errorReporter31 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry32 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter31);
//     com.google.javascript.rhino.jstype.StaticScope staticScope33 = null;
//     com.google.javascript.rhino.jstype.JSType jSType38 = jSTypeRegistry32.getForgivingType(staticScope33, "hi!", "", 0, 1);
//     com.google.javascript.rhino.ErrorReporter errorReporter39 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry40 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter39);
//     com.google.javascript.rhino.jstype.StaticScope staticScope41 = null;
//     com.google.javascript.rhino.jstype.JSType jSType46 = jSTypeRegistry40.getForgivingType(staticScope41, "hi!", "", 0, 1);
//     com.google.javascript.rhino.jstype.JSType[] jSType_array47 = new com.google.javascript.rhino.jstype.JSType[] { jSType46 };
//     com.google.javascript.rhino.jstype.FunctionType functionType48 = jSTypeRegistry28.createFunctionType(jSType38, jSType_array47);
//     com.google.javascript.rhino.jstype.JSType jSType49 = jSTypeRegistry23.createUnionType(jSType_array47);
//     com.google.javascript.jscomp.Scope scope50 = null;
//     com.google.javascript.jscomp.ErrorFormat errorFormat51 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler52 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState53 = compiler52.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter55 = errorFormat51.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler52, true);
//     com.google.javascript.jscomp.JSModule jSModule57 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list58 = jSModule57.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback59 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler52, list58, callback59);
//     com.google.javascript.jscomp.ErrorManager errorManager61 = compiler52.getErrorManager();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback62 = null;
//     com.google.javascript.jscomp.NodeTraversal nodeTraversal63 = new com.google.javascript.jscomp.NodeTraversal((com.google.javascript.jscomp.AbstractCompiler)compiler52, callback62);
//     com.google.javascript.jscomp.ErrorFormat errorFormat64 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler65 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState66 = compiler65.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter68 = errorFormat64.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler65, true);
//     com.google.javascript.jscomp.JSModule jSModule70 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list71 = jSModule70.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback72 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler65, list71, callback72);
//     com.google.javascript.jscomp.ErrorFormat errorFormat74 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler75 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState76 = compiler75.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter78 = errorFormat74.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler75, true);
//     com.google.javascript.jscomp.JSModule jSModule80 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list81 = jSModule80.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback82 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler75, list81, callback82);
//     com.google.javascript.jscomp.JSModuleGraph jSModuleGraph84 = new com.google.javascript.jscomp.JSModuleGraph(list81);
//     com.google.javascript.jscomp.CompilerOptions compilerOptions85 = new com.google.javascript.jscomp.CompilerOptions();
//     boolean b86 = compilerOptions85.smartNameRemoval;
//     compilerOptions85.groupVariableDeclarations = false;
//     compiler52.initModules(list71, list81, compilerOptions85);
//     defaultCodingConvention0.defineDelegateProxyPrototypeProperties(jSTypeRegistry23, scope50, list71);
//     com.google.javascript.rhino.jstype.StaticScope staticScope91 = null;
//     jSTypeRegistry23.resolveTypesInScope(staticScope91);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(ancestorIterable11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b14 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(node16);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str17 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str17.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(node18);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b19 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(node20);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(str21);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType38);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType46);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType_array47);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType48);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType49);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat51);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState53);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter55);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list58);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorManager61);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat64);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState66);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter68);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list71);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat74);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState76);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter78);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list81);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b86 == false);
// 
//   }

  @Test
  public void test143() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test143"); }


    java.lang.String str2 = com.google.javascript.rhino.ScriptRuntime.numberToString((-0.0d), 101);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str2 + "' != '" + "0"+ "'", str2.equals("0"));

  }

  @Test
  public void test144() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test144"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.debugFunctionSideEffectsPath = "hi!";
    compilerOptions0.inlineConstantVars = false;
    boolean b7 = compilerOptions0.crossModuleCodeMotion;
    boolean b8 = compilerOptions0.lineBreak;
    compilerOptions0.debugFunctionSideEffectsPath = "goog.exportProperty";
    compilerOptions0.setSummaryDetailLevel(142);
    com.google.javascript.jscomp.CheckLevel checkLevel13 = compilerOptions0.checkUnreachableCode;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel13);

  }

  @Test
  public void test145() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test145"); }


    com.google.javascript.jscomp.SourceFile sourceFile3 = com.google.javascript.jscomp.SourceFile.fromCode("QMARK", "ifeq", "goog.global");
    java.lang.String str4 = sourceFile3.getName();
    java.lang.String str6 = sourceFile3.getLine(0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(sourceFile3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str4 + "' != '" + "QMARK"+ "'", str4.equals("QMARK"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str6);

  }

  @Test
  public void test146() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test146"); }


    java.util.logging.Logger logger0 = null;
    com.google.javascript.jscomp.LoggerErrorManager loggerErrorManager1 = new com.google.javascript.jscomp.LoggerErrorManager(logger0);
    double d2 = loggerErrorManager1.getTypedPercent();
    com.google.javascript.jscomp.Compiler compiler3 = new com.google.javascript.jscomp.Compiler((com.google.javascript.jscomp.ErrorManager)loggerErrorManager1);
    compiler3.reportCodeChange();
    compiler3.disableThreads();
    // The following exception was thrown during execution in test generation
    try {
      compiler3.check();
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.0d);

  }

  @Test
  public void test147() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test147"); }


    com.google.javascript.rhino.FunctionNode functionNode3 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.ErrorReporter errorReporter5 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry6 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter5);
    com.google.javascript.rhino.ErrorReporter errorReporter7 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry8 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter7);
    jSTypeRegistry8.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter11 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry12 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter11);
    com.google.javascript.rhino.jstype.StaticScope staticScope13 = null;
    com.google.javascript.rhino.jstype.JSType jSType18 = jSTypeRegistry12.getForgivingType(staticScope13, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter19 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry20 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter19);
    com.google.javascript.rhino.jstype.StaticScope staticScope21 = null;
    com.google.javascript.rhino.jstype.JSType jSType26 = jSTypeRegistry20.getForgivingType(staticScope21, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array27 = new com.google.javascript.rhino.jstype.JSType[] { jSType26 };
    com.google.javascript.rhino.jstype.FunctionType functionType28 = jSTypeRegistry8.createFunctionType(jSType18, jSType_array27);
    com.google.javascript.rhino.jstype.JSType jSType29 = functionType28.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter31 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry32 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter31);
    jSTypeRegistry32.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter35 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry36 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter35);
    com.google.javascript.rhino.jstype.StaticScope staticScope37 = null;
    com.google.javascript.rhino.jstype.JSType jSType42 = jSTypeRegistry36.getForgivingType(staticScope37, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter43 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry44 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter43);
    com.google.javascript.rhino.jstype.StaticScope staticScope45 = null;
    com.google.javascript.rhino.jstype.JSType jSType50 = jSTypeRegistry44.getForgivingType(staticScope45, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array51 = new com.google.javascript.rhino.jstype.JSType[] { jSType50 };
    com.google.javascript.rhino.jstype.FunctionType functionType52 = jSTypeRegistry32.createFunctionType(jSType42, jSType_array51);
    com.google.javascript.rhino.jstype.FunctionType functionType53 = jSTypeRegistry6.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType28, false, jSType_array51);
    boolean b55 = jSTypeRegistry6.hasNamespace("OFF");
    functionNode3.putProp(2, (java.lang.Object)"OFF");
    // The following exception was thrown during execution in test generation
    try {
      int i58 = functionNode3.getExistingIntProp(27);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalStateException");
    } catch (java.lang.IllegalStateException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalStateException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalStateException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b55 == false);

  }

  @Test
  public void test148() {}
// Defects4J: flaky method
//   @Test
//   public void test148() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test148"); }
// 
// 
//     com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler1 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState2 = compiler1.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter4 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler1, true);
//     com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list7 = jSModule6.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback8 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler1, list7, callback8);
//     com.google.javascript.jscomp.ErrorManager errorManager10 = compiler1.getErrorManager();
//     com.google.javascript.jscomp.SourceFile.Generator generator12 = null;
//     com.google.javascript.jscomp.JSSourceFile jSSourceFile13 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator12);
//     com.google.javascript.jscomp.JSSourceFile[] jSSourceFile_array14 = new com.google.javascript.jscomp.JSSourceFile[] { jSSourceFile13 };
//     com.google.javascript.jscomp.SourceFile.Generator generator16 = null;
//     com.google.javascript.jscomp.JSSourceFile jSSourceFile17 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator16);
//     com.google.javascript.jscomp.JsAst jsAst18 = new com.google.javascript.jscomp.JsAst((com.google.javascript.jscomp.SourceFile)jSSourceFile17);
//     com.google.javascript.jscomp.JSSourceFile[] jSSourceFile_array19 = new com.google.javascript.jscomp.JSSourceFile[] { jSSourceFile17 };
//     com.google.javascript.jscomp.CompilerOptions compilerOptions20 = new com.google.javascript.jscomp.CompilerOptions();
//     compilerOptions20.collapseVariableDeclarations = true;
//     com.google.javascript.jscomp.Result result23 = compiler1.compile(jSSourceFile_array14, jSSourceFile_array19, compilerOptions20);
//     compilerOptions20.renamePrefix = "OFF: Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n";
//     compilerOptions20.syntheticBlockEndMarker = "";
//     boolean b28 = compilerOptions20.exportTestFunctions;
//     com.google.javascript.jscomp.CheckLevel checkLevel29 = compilerOptions20.checkUnreachableCode;
//     compilerOptions20.setRemoveClosureAsserts(true);
//     compilerOptions20.locale = "LP";
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorManager10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile_array14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile17);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile_array19);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(result23);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b28 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(checkLevel29);
// 
//   }

  @Test
  public void test149() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test149"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.smartNameRemoval;
    compilerOptions0.groupVariableDeclarations = false;
    compilerOptions0.reportPath = "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n";
    compilerOptions0.aliasKeywords = false;
    compilerOptions0.enableRuntimeTypeCheck("");
    boolean b10 = compilerOptions0.checkTypedPropertyCalls;
    compilerOptions0.inlineVariables = true;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);

  }

  @Test
  public void test150() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test150"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    compilerOptions0.setDefineToBooleanLiteral("hi!", false);
    boolean b8 = compilerOptions0.instrumentForCoverage;
    com.google.common.collect.Multimap multimap9 = null;
    compilerOptions0.customPasses = multimap9;
    boolean b11 = compilerOptions0.inferTypesInGlobalScope;
    com.google.javascript.jscomp.ErrorFormat errorFormat12 = compilerOptions0.errorFormat;
    boolean b13 = compilerOptions0.lineBreak;
    compilerOptions0.collapseVariableDeclarations = true;
    boolean b16 = compilerOptions0.disambiguateProperties;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);

  }

  @Test
  public void test151() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test151"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    com.google.javascript.jscomp.CompilerOptions compilerOptions1 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b2 = compilerOptions1.gatherCssNames;
    java.lang.String str3 = compilerOptions1.aliasableGlobals;
    boolean b4 = compilerOptions1.removeDeadCode;
    compilerOptions1.setLooseTypes(false);
    boolean b7 = compilerOptions1.markNoSideEffectCalls;
    com.google.javascript.jscomp.CheckLevel checkLevel8 = com.google.javascript.jscomp.CheckLevel.ERROR;
    compilerOptions1.brokenClosureRequiresLevel = checkLevel8;
    compilerOptions0.reportUnknownTypes = checkLevel8;
    com.google.javascript.jscomp.CheckLevel checkLevel11 = compilerOptions0.checkMissingGetCssNameLevel;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel11);

  }

  @Test
  public void test152() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test152"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b3 = jSDocInfoBuilder1.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression4 = null;
    boolean b5 = jSDocInfoBuilder1.recordReturnType(jSTypeExpression4);
    boolean b6 = jSDocInfoBuilder1.recordHiddenness();
    boolean b7 = jSDocInfoBuilder1.recordConstructor();
    boolean b9 = jSDocInfoBuilder1.recordReturnDescription("Not declared as a type name");
    com.google.javascript.rhino.JSDocInfo jSDocInfo11 = jSDocInfoBuilder1.build("// Input %num%");
    boolean b12 = jSDocInfo11.containsDeclaration();
    boolean b13 = jSDocInfo11.isConstructor();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSDocInfo11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == true);

  }

  @Test
  public void test153() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test153"); }


    com.google.javascript.rhino.FunctionNode functionNode2 = new com.google.javascript.rhino.FunctionNode("");
    int i3 = functionNode2.getFunctionType();
    java.lang.String str4 = functionNode2.getFunctionName();
    com.google.javascript.rhino.Node node7 = new com.google.javascript.rhino.Node(91, (com.google.javascript.rhino.Node)functionNode2, 12, 13);
    com.google.javascript.rhino.Node node9 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("error reporter");
    com.google.javascript.rhino.Node node10 = functionNode2.copyInformationFrom(node9);
    boolean b11 = node9.isOptionalArg();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i3 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str4 + "' != '" + ""+ "'", str4.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);

  }

  @Test
  public void test154() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test154"); }


    com.google.javascript.rhino.EcmaError ecmaError2 = com.google.javascript.rhino.ScriptRuntime.constructError("// Input %num%", "ifeq");
    int i3 = ecmaError2.getLineNumber();
    java.lang.String str4 = ecmaError2.getLineSource();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ecmaError2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i3 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str4);

  }

  @Test
  public void test155() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test155"); }


    com.google.javascript.rhino.Node node4 = com.google.javascript.rhino.Node.newString(65, "", 33, 133);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node4);

  }

  @Test
  public void test156() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test156"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b2 = jSDocInfoBuilder1.recordExport();
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder4 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b6 = jSDocInfoBuilder4.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression7 = null;
    boolean b8 = jSDocInfoBuilder4.recordReturnType(jSTypeExpression7);
    com.google.javascript.rhino.Node node10 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable11 = node10.getAncestors();
    com.google.javascript.rhino.Node node13 = new com.google.javascript.rhino.Node(0);
    boolean b14 = node10.hasChild(node13);
    com.google.javascript.rhino.Node node16 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str17 = node13.checkTreeEquals(node16);
    com.google.javascript.rhino.Node node18 = node16.cloneNode();
    boolean b19 = node18.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression21 = new com.google.javascript.rhino.JSTypeExpression(node18, "<No stack trace available>");
    boolean b22 = jSDocInfoBuilder4.recordDefineType(jSTypeExpression21);
    com.google.javascript.rhino.Node node24 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable25 = node24.getAncestors();
    com.google.javascript.rhino.Node node27 = new com.google.javascript.rhino.Node(0);
    boolean b28 = node24.hasChild(node27);
    com.google.javascript.rhino.Node node30 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str31 = node27.checkTreeEquals(node30);
    com.google.javascript.rhino.Node node32 = node30.cloneNode();
    boolean b33 = node32.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression35 = new com.google.javascript.rhino.JSTypeExpression(node32, "<No stack trace available>");
    boolean b36 = jSDocInfoBuilder4.recordType(jSTypeExpression35);
    boolean b37 = jSDocInfoBuilder4.recordExterns();
    com.google.javascript.rhino.Node node40 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable41 = node40.getAncestors();
    com.google.javascript.rhino.Node node43 = new com.google.javascript.rhino.Node(0);
    boolean b44 = node40.hasChild(node43);
    com.google.javascript.rhino.Node node46 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str47 = node43.checkTreeEquals(node46);
    com.google.javascript.rhino.Node node48 = node46.cloneNode();
    boolean b49 = node48.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression51 = new com.google.javascript.rhino.JSTypeExpression(node48, "<No stack trace available>");
    boolean b52 = jSDocInfoBuilder4.recordParameter("JSC_NODE_TRAVERSAL_ERROR. {0} at Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n line (unknown line) : (unknown column)", jSTypeExpression51);
    boolean b54 = jSDocInfoBuilder1.recordThrowDescription(jSTypeExpression51, "@IMPLEMENTATION.VERSION@");
    boolean b55 = jSDocInfoBuilder1.isPopulatedWithFileOverview();
    boolean b57 = jSDocInfoBuilder1.recordBlockDescription("<unknown=75>");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str17 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str17.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str31 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str31.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str47 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str47.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b49 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b52 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b54 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b55 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b57 == true);

  }

  @Test
  public void test157() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test157"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    compilerOptions0.setDefineToBooleanLiteral("hi!", false);
    boolean b8 = compilerOptions0.instrumentForCoverage;
    boolean b9 = compilerOptions0.devirtualizePrototypeMethods;
    boolean b10 = compilerOptions0.removeEmptyFunctions;
    compilerOptions0.flowSensitiveInlineVariables = true;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);

  }

  @Test
  public void test158() {}
// Defects4J: flaky method
//   @Test
//   public void test158() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test158"); }
// 
// 
//     com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler1 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState2 = compiler1.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter4 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler1, true);
//     com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list7 = jSModule6.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback8 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler1, list7, callback8);
//     com.google.javascript.jscomp.ErrorManager errorManager10 = compiler1.getErrorManager();
//     com.google.javascript.jscomp.ErrorFormat errorFormat11 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler12 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState13 = compiler12.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter15 = errorFormat11.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler12, true);
//     com.google.javascript.jscomp.JSModule jSModule17 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list18 = jSModule17.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback19 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler12, list18, callback19);
//     com.google.javascript.jscomp.ErrorManager errorManager21 = compiler12.getErrorManager();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback22 = null;
//     com.google.javascript.jscomp.NodeTraversal nodeTraversal23 = new com.google.javascript.jscomp.NodeTraversal((com.google.javascript.jscomp.AbstractCompiler)compiler12, callback22);
//     com.google.javascript.jscomp.ErrorFormat errorFormat24 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler25 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState26 = compiler25.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter28 = errorFormat24.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler25, true);
//     com.google.javascript.jscomp.JSModule jSModule30 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list31 = jSModule30.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback32 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler25, list31, callback32);
//     com.google.javascript.jscomp.ErrorFormat errorFormat34 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler35 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState36 = compiler35.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter38 = errorFormat34.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler35, true);
//     com.google.javascript.jscomp.JSModule jSModule40 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list41 = jSModule40.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback42 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler35, list41, callback42);
//     com.google.javascript.jscomp.JSModuleGraph jSModuleGraph44 = new com.google.javascript.jscomp.JSModuleGraph(list41);
//     com.google.javascript.jscomp.CompilerOptions compilerOptions45 = new com.google.javascript.jscomp.CompilerOptions();
//     boolean b46 = compilerOptions45.smartNameRemoval;
//     compilerOptions45.groupVariableDeclarations = false;
//     compiler12.initModules(list31, list41, compilerOptions45);
//     com.google.javascript.jscomp.ErrorFormat errorFormat50 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler51 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState52 = compiler51.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter54 = errorFormat50.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler51, true);
//     com.google.javascript.jscomp.JSModule jSModule56 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list57 = jSModule56.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback58 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler51, list57, callback58);
//     com.google.javascript.jscomp.JSModuleGraph jSModuleGraph60 = new com.google.javascript.jscomp.JSModuleGraph(list57);
//     com.google.javascript.jscomp.CompilerOptions compilerOptions61 = new com.google.javascript.jscomp.CompilerOptions();
//     compilerOptions61.collapseVariableDeclarations = true;
//     boolean b64 = compilerOptions61.computeFunctionSideEffects;
//     compiler1.init(list41, list57, compilerOptions61);
//     compilerOptions61.ignoreCajaProperties = true;
//     java.lang.String str68 = compilerOptions61.syntheticBlockStartMarker;
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorManager10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list18);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorManager21);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat24);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState26);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter28);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list31);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat34);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState36);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter38);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list41);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b46 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat50);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState52);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter54);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list57);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b64 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(str68);
// 
//   }

  @Test
  public void test159() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test159"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.gatherCssNames;
    com.google.javascript.jscomp.VariableRenamingPolicy variableRenamingPolicy2 = compilerOptions0.variableRenaming;
    compilerOptions0.exportTestFunctions = true;
    boolean b5 = compilerOptions0.instrumentForCoverage;
    java.lang.String str6 = compilerOptions0.aliasStringsBlacklist;
    boolean b7 = compilerOptions0.deadAssignmentElimination;
    boolean b8 = compilerOptions0.extractPrototypeMemberDeclarations;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(variableRenamingPolicy2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + ""+ "'", str6.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);

  }

  @Test
  public void test160() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test160"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    compilerOptions0.setDefineToBooleanLiteral("hi!", false);
    java.lang.String str8 = compilerOptions0.syntheticBlockStartMarker;
    compilerOptions0.setCollapsePropertiesOnExternTypes(true);
    compilerOptions0.collapseProperties = false;
    compilerOptions0.setDefineToNumberLiteral("language version", 0);
    boolean b16 = compilerOptions0.removeUnusedPrototypeProperties;
    compilerOptions0.inlineConstantVars = false;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);

  }

  @Test
  public void test161() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test161"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.Node node25 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable26 = node25.getAncestors();
    java.lang.String str27 = node25.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType28 = jSTypeRegistry1.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType23, node25);
    com.google.javascript.rhino.JSDocInfo jSDocInfo29 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str30 = jSDocInfo29.getTemplateTypeName();
    boolean b31 = jSDocInfo29.hasEnumParameterType();
    functionType23.setJSDocInfo(jSDocInfo29);
    java.lang.String str33 = jSDocInfo29.toString();
    java.lang.String str34 = jSDocInfo29.getReturnDescription();
    java.lang.String str35 = jSDocInfo29.getSourceName();
    boolean b37 = jSDocInfo29.hasDescriptionForParameter("function ({proxy:{1589448235}}): {proxy:{2065817421}}");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str27 + "' != '" + "EOF"+ "'", str27.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str33 + "' != '" + "JSDocInfo"+ "'", str33.equals("JSDocInfo"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == false);

  }

  @Test
  public void test162() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test162"); }


    com.google.javascript.rhino.FunctionNode functionNode1 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String[] str_array2 = functionNode1.getParamAndVarNames();
    functionNode1.addParam("hi!");
    java.lang.String[] str_array5 = functionNode1.getParamAndVarNames();
    int i6 = functionNode1.getBaseLineno();
    int i8 = functionNode1.getParamOrVarIndex("// Input %num%");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i8 == (-1));

  }

  @Test
  public void test163() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test163"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.gatherCssNames;
    java.lang.String str2 = compilerOptions0.aliasableGlobals;
    boolean b3 = compilerOptions0.removeDeadCode;
    com.google.javascript.jscomp.MessageBundle messageBundle4 = compilerOptions0.messageBundle;
    compilerOptions0.disambiguateProperties = false;
    compilerOptions0.coalesceVariableNames = false;
    com.google.javascript.jscomp.AnonymousFunctionNamingPolicy anonymousFunctionNamingPolicy9 = com.google.javascript.jscomp.AnonymousFunctionNamingPolicy.UNMAPPED;
    compilerOptions0.anonymousFunctionNaming = anonymousFunctionNamingPolicy9;
    compilerOptions0.removeUnusedPrototypeProperties = false;
    boolean b13 = compilerOptions0.gatherCssNames;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(messageBundle4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(anonymousFunctionNamingPolicy9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);

  }

  @Test
  public void test164() {}
// Defects4J: flaky method
//   @Test
//   public void test164() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test164"); }
// 
// 
//     com.google.javascript.rhino.Context context0 = null;
//     com.google.javascript.rhino.Context context1 = com.google.javascript.rhino.Context.enter(context0);
//     context1.removeActivationName("OFF");
//     int i4 = context1.getLanguageVersion();
//     com.google.javascript.rhino.ErrorReporter errorReporter5 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry6 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter5);
//     com.google.javascript.rhino.ErrorReporter errorReporter7 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry8 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter7);
//     jSTypeRegistry8.forwardDeclareType("hi!");
//     com.google.javascript.rhino.ErrorReporter errorReporter11 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry12 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter11);
//     com.google.javascript.rhino.jstype.StaticScope staticScope13 = null;
//     com.google.javascript.rhino.jstype.JSType jSType18 = jSTypeRegistry12.getForgivingType(staticScope13, "hi!", "", 0, 1);
//     com.google.javascript.rhino.ErrorReporter errorReporter19 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry20 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter19);
//     com.google.javascript.rhino.jstype.StaticScope staticScope21 = null;
//     com.google.javascript.rhino.jstype.JSType jSType26 = jSTypeRegistry20.getForgivingType(staticScope21, "hi!", "", 0, 1);
//     com.google.javascript.rhino.jstype.JSType[] jSType_array27 = new com.google.javascript.rhino.jstype.JSType[] { jSType26 };
//     com.google.javascript.rhino.jstype.FunctionType functionType28 = jSTypeRegistry8.createFunctionType(jSType18, jSType_array27);
//     com.google.javascript.rhino.jstype.JSType jSType29 = functionType28.unboxesTo();
//     com.google.javascript.rhino.ErrorReporter errorReporter31 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry32 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter31);
//     jSTypeRegistry32.forwardDeclareType("hi!");
//     com.google.javascript.rhino.ErrorReporter errorReporter35 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry36 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter35);
//     com.google.javascript.rhino.jstype.StaticScope staticScope37 = null;
//     com.google.javascript.rhino.jstype.JSType jSType42 = jSTypeRegistry36.getForgivingType(staticScope37, "hi!", "", 0, 1);
//     com.google.javascript.rhino.ErrorReporter errorReporter43 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry44 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter43);
//     com.google.javascript.rhino.jstype.StaticScope staticScope45 = null;
//     com.google.javascript.rhino.jstype.JSType jSType50 = jSTypeRegistry44.getForgivingType(staticScope45, "hi!", "", 0, 1);
//     com.google.javascript.rhino.jstype.JSType[] jSType_array51 = new com.google.javascript.rhino.jstype.JSType[] { jSType50 };
//     com.google.javascript.rhino.jstype.FunctionType functionType52 = jSTypeRegistry32.createFunctionType(jSType42, jSType_array51);
//     com.google.javascript.rhino.jstype.FunctionType functionType53 = jSTypeRegistry6.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType28, false, jSType_array51);
//     com.google.javascript.rhino.ErrorReporter errorReporter54 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry55 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter54);
//     com.google.javascript.rhino.ErrorReporter errorReporter56 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry57 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter56);
//     jSTypeRegistry57.forwardDeclareType("hi!");
//     com.google.javascript.rhino.ErrorReporter errorReporter60 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry61 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter60);
//     com.google.javascript.rhino.jstype.StaticScope staticScope62 = null;
//     com.google.javascript.rhino.jstype.JSType jSType67 = jSTypeRegistry61.getForgivingType(staticScope62, "hi!", "", 0, 1);
//     com.google.javascript.rhino.ErrorReporter errorReporter68 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry69 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter68);
//     com.google.javascript.rhino.jstype.StaticScope staticScope70 = null;
//     com.google.javascript.rhino.jstype.JSType jSType75 = jSTypeRegistry69.getForgivingType(staticScope70, "hi!", "", 0, 1);
//     com.google.javascript.rhino.jstype.JSType[] jSType_array76 = new com.google.javascript.rhino.jstype.JSType[] { jSType75 };
//     com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry57.createFunctionType(jSType67, jSType_array76);
//     com.google.javascript.rhino.Node node79 = new com.google.javascript.rhino.Node(0);
//     com.google.javascript.rhino.Node.AncestorIterable ancestorIterable80 = node79.getAncestors();
//     java.lang.String str81 = node79.toString();
//     com.google.javascript.rhino.jstype.FunctionType functionType82 = jSTypeRegistry55.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType77, node79);
//     functionType28.setPrototypeBasedOn((com.google.javascript.rhino.jstype.ObjectType)functionType82);
//     com.google.javascript.rhino.jstype.JSType jSType84 = functionType82.getReturnType();
//     java.lang.Object obj85 = context1.getThreadLocal((java.lang.Object)jSType84);
//     context1.setInstructionObserverThreshold(301);
//     java.util.Locale locale88 = null;
//     java.util.Locale locale89 = context1.setLocale(locale88);
//     boolean b90 = context1.hasCompileFunctionsWithDynamicScope();
//     boolean b91 = context1.isGeneratingDebugChanged();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(context1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i4 == 0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType18);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType26);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType_array27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType28);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(jSType29);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType42);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType50);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType_array51);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType52);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType53);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType67);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType75);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType_array76);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType77);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(ancestorIterable80);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str81 + "' != '" + "EOF"+ "'", str81.equals("EOF"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(functionType82);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSType84);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(obj85);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(locale89);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b90 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b91 == false);
// 
//   }

  @Test
  public void test165() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test165"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.jstype.StaticScope staticScope2 = null;
    com.google.javascript.rhino.jstype.JSType jSType7 = jSTypeRegistry1.getForgivingType(staticScope2, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter8 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry9 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter8);
    com.google.javascript.rhino.ErrorReporter errorReporter10 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry11 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter10);
    jSTypeRegistry11.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter22 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry23 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter22);
    com.google.javascript.rhino.jstype.StaticScope staticScope24 = null;
    com.google.javascript.rhino.jstype.JSType jSType29 = jSTypeRegistry23.getForgivingType(staticScope24, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array30 = new com.google.javascript.rhino.jstype.JSType[] { jSType29 };
    com.google.javascript.rhino.jstype.FunctionType functionType31 = jSTypeRegistry11.createFunctionType(jSType21, jSType_array30);
    com.google.javascript.rhino.jstype.JSType jSType32 = functionType31.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter34 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry35 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter34);
    jSTypeRegistry35.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter46 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry47 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter46);
    com.google.javascript.rhino.jstype.StaticScope staticScope48 = null;
    com.google.javascript.rhino.jstype.JSType jSType53 = jSTypeRegistry47.getForgivingType(staticScope48, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array54 = new com.google.javascript.rhino.jstype.JSType[] { jSType53 };
    com.google.javascript.rhino.jstype.FunctionType functionType55 = jSTypeRegistry35.createFunctionType(jSType45, jSType_array54);
    com.google.javascript.rhino.jstype.FunctionType functionType56 = jSTypeRegistry9.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType31, false, jSType_array54);
    com.google.javascript.rhino.ErrorReporter errorReporter57 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry58 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter57);
    com.google.javascript.rhino.ErrorReporter errorReporter59 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry60 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter59);
    jSTypeRegistry60.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter71 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry72 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter71);
    com.google.javascript.rhino.jstype.StaticScope staticScope73 = null;
    com.google.javascript.rhino.jstype.JSType jSType78 = jSTypeRegistry72.getForgivingType(staticScope73, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array79 = new com.google.javascript.rhino.jstype.JSType[] { jSType78 };
    com.google.javascript.rhino.jstype.FunctionType functionType80 = jSTypeRegistry60.createFunctionType(jSType70, jSType_array79);
    com.google.javascript.rhino.Node node82 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable83 = node82.getAncestors();
    java.lang.String str84 = node82.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType85 = jSTypeRegistry58.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType80, node82);
    com.google.javascript.rhino.jstype.JSType jSType87 = jSTypeRegistry9.getGreatestSubtypeWithProperty((com.google.javascript.rhino.jstype.JSType)functionType80, "EOF");
    com.google.javascript.rhino.jstype.JSType jSType88 = jSTypeRegistry1.createDefaultObjectUnion((com.google.javascript.rhino.jstype.JSType)functionType80);
    com.google.javascript.rhino.jstype.JSTypeNative jSTypeNative89 = com.google.javascript.rhino.jstype.JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE;
    com.google.javascript.rhino.jstype.FunctionType functionType90 = jSTypeRegistry1.getNativeFunctionType(jSTypeNative89);
    com.google.javascript.jscomp.CompilerOptions compilerOptions91 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions91.collapseVariableDeclarations = true;
    boolean b94 = compilerOptions91.inlineConstantVars;
    java.util.Map map95 = compilerOptions91.getDefineReplacements();
    com.google.javascript.rhino.jstype.RecordType recordType96 = jSTypeRegistry1.createRecordType(map95);
    boolean b98 = recordType96.hasProperty("language version: error reporter");
    java.util.Set set99 = recordType96.getOwnPropertyNames();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType78);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable83);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str84 + "' != '" + "EOF"+ "'", str84.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType87);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType88);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSTypeNative89);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType90);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b94 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(map95);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(recordType96);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b98 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set99);

  }

  @Test
  public void test166() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test166"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b3 = jSDocInfoBuilder1.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression4 = null;
    boolean b5 = jSDocInfoBuilder1.recordReturnType(jSTypeExpression4);
    com.google.javascript.rhino.Node node7 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable8 = node7.getAncestors();
    com.google.javascript.rhino.Node node10 = new com.google.javascript.rhino.Node(0);
    boolean b11 = node7.hasChild(node10);
    com.google.javascript.rhino.Node node13 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str14 = node10.checkTreeEquals(node13);
    com.google.javascript.rhino.Node node15 = node13.cloneNode();
    boolean b16 = node15.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression18 = new com.google.javascript.rhino.JSTypeExpression(node15, "<No stack trace available>");
    boolean b19 = jSDocInfoBuilder1.recordDefineType(jSTypeExpression18);
    com.google.javascript.rhino.Node node21 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable22 = node21.getAncestors();
    com.google.javascript.rhino.Node node24 = new com.google.javascript.rhino.Node(0);
    boolean b25 = node21.hasChild(node24);
    com.google.javascript.rhino.Node node27 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str28 = node24.checkTreeEquals(node27);
    com.google.javascript.rhino.Node node29 = node27.cloneNode();
    boolean b30 = node29.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression32 = new com.google.javascript.rhino.JSTypeExpression(node29, "<No stack trace available>");
    boolean b33 = jSDocInfoBuilder1.recordType(jSTypeExpression32);
    boolean b34 = jSDocInfoBuilder1.recordExterns();
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder36 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b38 = jSDocInfoBuilder36.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression39 = null;
    boolean b40 = jSDocInfoBuilder36.recordReturnType(jSTypeExpression39);
    com.google.javascript.rhino.Node node42 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable43 = node42.getAncestors();
    com.google.javascript.rhino.Node node45 = new com.google.javascript.rhino.Node(0);
    boolean b46 = node42.hasChild(node45);
    com.google.javascript.rhino.Node node48 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str49 = node45.checkTreeEquals(node48);
    com.google.javascript.rhino.Node node50 = node48.cloneNode();
    boolean b51 = node50.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression53 = new com.google.javascript.rhino.JSTypeExpression(node50, "<No stack trace available>");
    boolean b54 = jSDocInfoBuilder36.recordDefineType(jSTypeExpression53);
    com.google.javascript.rhino.Node node56 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable57 = node56.getAncestors();
    com.google.javascript.rhino.Node node59 = new com.google.javascript.rhino.Node(0);
    boolean b60 = node56.hasChild(node59);
    com.google.javascript.rhino.Node node62 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str63 = node59.checkTreeEquals(node62);
    com.google.javascript.rhino.Node node64 = node62.cloneNode();
    boolean b65 = node64.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression67 = new com.google.javascript.rhino.JSTypeExpression(node64, "<No stack trace available>");
    boolean b68 = jSDocInfoBuilder36.recordType(jSTypeExpression67);
    boolean b69 = jSDocInfoBuilder36.recordExterns();
    com.google.javascript.rhino.Node node72 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable73 = node72.getAncestors();
    com.google.javascript.rhino.Node node75 = new com.google.javascript.rhino.Node(0);
    boolean b76 = node72.hasChild(node75);
    com.google.javascript.rhino.Node node78 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str79 = node75.checkTreeEquals(node78);
    com.google.javascript.rhino.Node node80 = node78.cloneNode();
    boolean b81 = node80.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression83 = new com.google.javascript.rhino.JSTypeExpression(node80, "<No stack trace available>");
    boolean b84 = jSDocInfoBuilder36.recordParameter("JSC_NODE_TRAVERSAL_ERROR. {0} at Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n line (unknown line) : (unknown column)", jSTypeExpression83);
    boolean b85 = jSTypeExpression83.isOptionalArg();
    boolean b86 = jSDocInfoBuilder1.recordThisType(jSTypeExpression83);
    boolean b87 = jSDocInfoBuilder1.recordImplicitCast();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str14 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str14.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str28 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str28.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b34 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b46 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str49 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str49.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b51 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b54 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b60 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str63 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str63.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b65 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b68 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b69 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable73);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b76 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node78);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str79 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str79.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b81 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b84 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b85 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b86 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b87 == true);

  }

  @Test
  public void test167() {}
// Defects4J: flaky method
//   @Test
//   public void test167() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test167"); }
// 
// 
//     com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler1 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState2 = compiler1.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter4 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler1, true);
//     com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list7 = jSModule6.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback8 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler1, list7, callback8);
//     com.google.javascript.jscomp.ErrorManager errorManager10 = compiler1.getErrorManager();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback11 = null;
//     com.google.javascript.jscomp.NodeTraversal nodeTraversal12 = new com.google.javascript.jscomp.NodeTraversal((com.google.javascript.jscomp.AbstractCompiler)compiler1, callback11);
//     com.google.javascript.jscomp.ErrorFormat errorFormat13 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler14 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState15 = compiler14.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter17 = errorFormat13.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler14, true);
//     com.google.javascript.jscomp.JSModule jSModule19 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list20 = jSModule19.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback21 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler14, list20, callback21);
//     com.google.javascript.jscomp.ErrorFormat errorFormat23 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler24 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState25 = compiler24.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter27 = errorFormat23.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler24, true);
//     com.google.javascript.jscomp.JSModule jSModule29 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list30 = jSModule29.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback31 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler24, list30, callback31);
//     com.google.javascript.jscomp.JSModuleGraph jSModuleGraph33 = new com.google.javascript.jscomp.JSModuleGraph(list30);
//     com.google.javascript.jscomp.CompilerOptions compilerOptions34 = new com.google.javascript.jscomp.CompilerOptions();
//     boolean b35 = compilerOptions34.smartNameRemoval;
//     compilerOptions34.groupVariableDeclarations = false;
//     compiler1.initModules(list20, list30, compilerOptions34);
//     com.google.javascript.jscomp.SourceFile.Generator generator40 = null;
//     com.google.javascript.jscomp.JSSourceFile jSSourceFile41 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator40);
//     com.google.javascript.jscomp.JsAst jsAst42 = new com.google.javascript.jscomp.JsAst((com.google.javascript.jscomp.SourceFile)jSSourceFile41);
//     com.google.javascript.jscomp.SourceFile.Generator generator44 = null;
//     com.google.javascript.jscomp.JSSourceFile jSSourceFile45 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator44);
//     jSSourceFile45.clearCachedSource();
//     com.google.javascript.jscomp.CompilerOptions compilerOptions47 = new com.google.javascript.jscomp.CompilerOptions();
//     compilerOptions47.collapseVariableDeclarations = true;
//     compilerOptions47.debugFunctionSideEffectsPath = "hi!";
//     compilerOptions47.inlineConstantVars = false;
//     boolean b54 = compilerOptions47.crossModuleCodeMotion;
//     com.google.javascript.jscomp.Result result55 = compiler1.compile(jSSourceFile41, jSSourceFile45, compilerOptions47);
//     com.google.javascript.jscomp.CompilerInput compilerInput56 = new com.google.javascript.jscomp.CompilerInput(jSSourceFile41);
//     com.google.javascript.jscomp.CompilerInput compilerInput57 = new com.google.javascript.jscomp.CompilerInput(jSSourceFile41);
//     // The following exception was thrown during execution in test generation
//     try {
//       com.google.javascript.jscomp.Region region59 = compilerInput57.getRegion(0);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorManager10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter17);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list20);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat23);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list30);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b35 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile41);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile45);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b54 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(result55);
// 
//   }

  @Test
  public void test168() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test168"); }


    com.google.javascript.jscomp.DiagnosticGroup diagnosticGroup0 = null;
    com.google.javascript.jscomp.DiagnosticGroups.MISSING_PROPERTIES = diagnosticGroup0;

  }

  @Test
  public void test169() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test169"); }


    com.google.javascript.rhino.FunctionNode functionNode2 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String[] str_array3 = functionNode2.getParamAndVarNames();
    com.google.javascript.rhino.Node node4 = functionNode2.getFirstChild();
    boolean b6 = functionNode2.hasParamOrVar("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n");
    java.lang.Object obj8 = functionNode2.getProp(25);
    com.google.javascript.rhino.Node node10 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node node12 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable13 = node12.getAncestors();
    com.google.javascript.rhino.Node node15 = new com.google.javascript.rhino.Node(0);
    boolean b16 = node12.hasChild(node15);
    com.google.javascript.rhino.Node node18 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str19 = node15.checkTreeEquals(node18);
    com.google.javascript.rhino.Node node20 = node10.copyInformationFromForTree(node15);
    node20.setCharno(149);
    java.lang.Object obj24 = node20.getProp(86);
    com.google.javascript.rhino.Node node26 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    com.google.javascript.rhino.Node node28 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable29 = node28.getAncestors();
    com.google.javascript.rhino.Node node31 = new com.google.javascript.rhino.Node(0);
    boolean b32 = node28.hasChild(node31);
    com.google.javascript.rhino.Node node34 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str35 = node31.checkTreeEquals(node34);
    com.google.javascript.rhino.Node node38 = new com.google.javascript.rhino.Node(126, (com.google.javascript.rhino.Node)functionNode2, node20, node26, node31, 106, 142);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable39 = node31.getAncestors();
    node31.setIsSyntheticBlock(false);
    // The following exception was thrown during execution in test generation
    try {
      double d42 = node31.getDouble();
      org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException");
    } catch (java.lang.UnsupportedOperationException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.UnsupportedOperationException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(node4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(obj8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str19 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str19.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(obj24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str35 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str35.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable39);

  }

  @Test
  public void test170() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test170"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.gatherCssNames;
    java.lang.String str2 = compilerOptions0.aliasableGlobals;
    boolean b3 = compilerOptions0.removeDeadCode;
    com.google.javascript.jscomp.MessageBundle messageBundle4 = compilerOptions0.messageBundle;
    compilerOptions0.disambiguateProperties = false;
    com.google.javascript.jscomp.CheckLevel checkLevel7 = compilerOptions0.checkUndefinedProperties;
    boolean b8 = compilerOptions0.markAsCompiled;
    compilerOptions0.enableRuntimeTypeCheck("<No stack trace available>");
    compilerOptions0.computeFunctionSideEffects = true;
    compilerOptions0.instrumentationTemplate = "Named type with empty name component";
    boolean b15 = compilerOptions0.removeUnusedVars;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(messageBundle4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);

  }

  @Test
  public void test171() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test171"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.Node node25 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable26 = node25.getAncestors();
    java.lang.String str27 = node25.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType28 = jSTypeRegistry1.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType23, node25);
    com.google.javascript.rhino.JSDocInfo jSDocInfo30 = functionType23.getOwnPropertyJSDocInfo("function (hi!): hi!");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str27 + "' != '" + "EOF"+ "'", str27.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSDocInfo30);

  }

  @Test
  public void test172() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test172"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(false);
    boolean b3 = jSDocInfoBuilder1.recordMeaning("Not declared as a type name");
    com.google.javascript.rhino.JSDocInfo jSDocInfo5 = jSDocInfoBuilder1.build("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n");
    boolean b7 = jSDocInfoBuilder1.recordDeprecationReason("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n: WARNING - {0}\n");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSDocInfo5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);

  }

  @Test
  public void test173() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test173"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    com.google.javascript.rhino.jstype.FunctionParamBuilder functionParamBuilder4 = new com.google.javascript.rhino.jstype.FunctionParamBuilder(jSTypeRegistry1);
    com.google.javascript.rhino.ErrorReporter errorReporter5 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry6 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter5);
    jSTypeRegistry6.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter9 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry10 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter9);
    com.google.javascript.rhino.jstype.StaticScope staticScope11 = null;
    com.google.javascript.rhino.jstype.JSType jSType16 = jSTypeRegistry10.getForgivingType(staticScope11, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter17 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry18 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter17);
    com.google.javascript.rhino.jstype.StaticScope staticScope19 = null;
    com.google.javascript.rhino.jstype.JSType jSType24 = jSTypeRegistry18.getForgivingType(staticScope19, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array25 = new com.google.javascript.rhino.jstype.JSType[] { jSType24 };
    com.google.javascript.rhino.jstype.FunctionType functionType26 = jSTypeRegistry6.createFunctionType(jSType16, jSType_array25);
    com.google.javascript.rhino.jstype.JSType jSType27 = jSTypeRegistry1.createUnionType(jSType_array25);
    jSTypeRegistry1.setLastGeneration(false);
    com.google.javascript.jscomp.CompilerOptions compilerOptions30 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions30.collapseVariableDeclarations = true;
    compilerOptions30.setSummaryDetailLevel(86);
    compilerOptions30.setDefineToBooleanLiteral("hi!", false);
    boolean b38 = compilerOptions30.instrumentForCoverage;
    compilerOptions30.collapseAnonymousFunctions = false;
    boolean b41 = compilerOptions30.checkSymbols;
    java.lang.String str42 = compilerOptions30.renamePrefix;
    com.google.javascript.jscomp.CompilerOptions compilerOptions43 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b44 = compilerOptions43.gatherCssNames;
    java.lang.String str45 = compilerOptions43.aliasableGlobals;
    com.google.javascript.jscomp.CheckLevel checkLevel46 = compilerOptions43.checkShadowVars;
    compilerOptions30.checkGlobalThisLevel = checkLevel46;
    com.google.common.collect.Multimap multimap48 = null;
    compilerOptions30.customPasses = multimap48;
    compilerOptions30.checkMissingGetCssNameBlacklist = "";
    java.util.Map map52 = compilerOptions30.getDefineReplacements();
    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.rhino.jstype.RecordType recordType53 = jSTypeRegistry1.createRecordType(map52);
      org.junit.Assert.fail("Expected exception of type java.lang.ClassCastException");
    } catch (java.lang.ClassCastException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ClassCastException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ClassCastException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(map52);

  }

  @Test
  public void test174() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test174"); }


    com.google.javascript.rhino.FunctionNode functionNode3 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    functionNode3.setEncodedSourceBounds(98, 75);
    com.google.javascript.jscomp.ErrorFormat errorFormat7 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler8 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState9 = compiler8.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter11 = errorFormat7.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler8, true);
    com.google.javascript.jscomp.JSModule jSModule13 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list14 = jSModule13.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback15 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler8, list14, callback15);
    com.google.javascript.jscomp.ErrorManager errorManager17 = compiler8.getErrorManager();
    com.google.javascript.jscomp.JSModule jSModule19 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list20 = jSModule19.getDependencies();
    java.util.List list21 = jSModule19.getProvides();
    java.lang.String[] str_array22 = compiler8.toSourceArray(jSModule19);
    java.util.List list23 = jSModule19.getInputs();
    java.util.Set set24 = jSModule19.getAllDependencies();
    functionNode3.setDirectives(set24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorManager17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set24);

  }

  @Test
  public void test175() {}
// Defects4J: flaky method
//   @Test
//   public void test175() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test175"); }
// 
// 
//     // The following exception was thrown during execution in test generation
//     try {
//       com.google.javascript.rhino.Context.reportWarning("");
//       org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException");
//     } catch (java.lang.RuntimeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.RuntimeException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException, got " + e.getClass().getCanonicalName());
//       }
//     }
// 
//   }

  @Test
  public void test176() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test176"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    compilerOptions0.setDefineToBooleanLiteral("hi!", false);
    boolean b8 = compilerOptions0.instrumentForCoverage;
    compilerOptions0.collapseAnonymousFunctions = false;
    boolean b11 = compilerOptions0.checkSymbols;
    java.lang.String str12 = compilerOptions0.renamePrefix;
    com.google.javascript.jscomp.CompilerOptions compilerOptions13 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b14 = compilerOptions13.gatherCssNames;
    java.lang.String str15 = compilerOptions13.aliasableGlobals;
    com.google.javascript.jscomp.CheckLevel checkLevel16 = compilerOptions13.checkShadowVars;
    compilerOptions0.checkGlobalThisLevel = checkLevel16;
    com.google.common.collect.Multimap multimap18 = null;
    compilerOptions0.customPasses = multimap18;
    compilerOptions0.checkMissingGetCssNameBlacklist = "";
    java.util.Map map22 = compilerOptions0.getDefineReplacements();
    compilerOptions0.checkTypedPropertyCalls = false;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(map22);

  }

  @Test
  public void test177() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test177"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    java.lang.String str3 = compilerOptions0.inputDelimiter;
    compilerOptions0.checkSymbols = false;
    compilerOptions0.inlineLocalVariables = true;
    compilerOptions0.strictMessageReplacement = false;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str3 + "' != '" + "// Input %num%"+ "'", str3.equals("// Input %num%"));

  }

  @Test
  public void test178() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test178"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression2 = null;
    boolean b3 = jSDocInfoBuilder1.recordTypedef(jSTypeExpression2);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression4 = null;
    boolean b6 = jSDocInfoBuilder1.recordThrowDescription(jSTypeExpression4, "hi!");
    boolean b7 = jSDocInfoBuilder1.isConstructorRecorded();
    boolean b8 = jSDocInfoBuilder1.recordNoTypeCheck();
    boolean b9 = jSDocInfoBuilder1.isDescriptionRecorded();
    boolean b11 = jSDocInfoBuilder1.recordDescription(": GETVAR");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);

  }

  @Test
  public void test179() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test179"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    jSTypeRegistry1.setTemplateTypeName("EOF");
    com.google.javascript.rhino.jstype.JSType jSType10 = jSTypeRegistry1.createNamedType("", "EOF", 105, 126);
    com.google.javascript.rhino.jstype.StaticScope staticScope11 = null;
    com.google.javascript.rhino.jstype.JSType jSType16 = jSTypeRegistry1.getType(staticScope11, "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 148, 148);
    jSTypeRegistry1.resetForTypeCheck();
    jSTypeRegistry1.incrementGeneration();
    jSTypeRegistry1.resetForTypeCheck();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType16);

  }

  @Test
  public void test180() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test180"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b3 = jSDocInfoBuilder1.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression4 = null;
    boolean b5 = jSDocInfoBuilder1.recordReturnType(jSTypeExpression4);
    boolean b6 = jSDocInfoBuilder1.recordHiddenness();
    boolean b7 = jSDocInfoBuilder1.recordNoCompile();
    boolean b8 = jSDocInfoBuilder1.recordOverride();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression9 = null;
    boolean b11 = jSDocInfoBuilder1.recordThrowDescription(jSTypeExpression9, "EOF");
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder13 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSDocInfo jSDocInfo15 = jSDocInfoBuilder13.build("");
    boolean b17 = jSDocInfoBuilder13.recordLends("EOF");
    boolean b19 = jSDocInfoBuilder13.recordBlockDescription("OFF");
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder21 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b23 = jSDocInfoBuilder21.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression24 = null;
    boolean b25 = jSDocInfoBuilder21.recordReturnType(jSTypeExpression24);
    boolean b26 = jSDocInfoBuilder21.recordHiddenness();
    boolean b27 = jSDocInfoBuilder21.recordConstructor();
    boolean b29 = jSDocInfoBuilder21.recordReturnDescription("Not declared as a type name");
    boolean b30 = jSDocInfoBuilder21.recordOverride();
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder32 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b34 = jSDocInfoBuilder32.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression35 = null;
    boolean b36 = jSDocInfoBuilder32.recordReturnType(jSTypeExpression35);
    com.google.javascript.rhino.Node node38 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable39 = node38.getAncestors();
    com.google.javascript.rhino.Node node41 = new com.google.javascript.rhino.Node(0);
    boolean b42 = node38.hasChild(node41);
    com.google.javascript.rhino.Node node44 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str45 = node41.checkTreeEquals(node44);
    com.google.javascript.rhino.Node node46 = node44.cloneNode();
    boolean b47 = node46.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression49 = new com.google.javascript.rhino.JSTypeExpression(node46, "<No stack trace available>");
    boolean b50 = jSDocInfoBuilder32.recordDefineType(jSTypeExpression49);
    boolean b51 = jSDocInfoBuilder21.recordType(jSTypeExpression49);
    boolean b52 = jSDocInfoBuilder13.recordTypedef(jSTypeExpression49);
    boolean b53 = jSDocInfoBuilder1.recordThrowType(jSTypeExpression49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSDocInfo15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b34 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b42 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str45 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str45.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b47 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b50 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b51 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b52 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b53 == true);

  }

  @Test
  public void test181() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test181"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    boolean b3 = compilerOptions0.inlineConstantVars;
    java.lang.String str4 = compilerOptions0.aliasableGlobals;
    com.google.javascript.jscomp.VariableRenamingPolicy variableRenamingPolicy5 = compilerOptions0.variableRenaming;
    compilerOptions0.foldConstants = false;
    boolean b8 = compilerOptions0.removeEmptyFunctions;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(variableRenamingPolicy5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);

  }

  @Test
  public void test182() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test182"); }


    com.google.javascript.rhino.Node node1 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    com.google.javascript.rhino.Node node2 = node1.getLastChild();
    com.google.javascript.rhino.Node node5 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable6 = node5.getAncestors();
    com.google.javascript.rhino.Node node8 = new com.google.javascript.rhino.Node(0);
    boolean b9 = node5.hasChild(node8);
    com.google.javascript.rhino.Node node11 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str12 = node8.checkTreeEquals(node11);
    com.google.javascript.rhino.Node node13 = node11.cloneNode();
    com.google.javascript.rhino.Node node15 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node node17 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable18 = node17.getAncestors();
    com.google.javascript.rhino.Node node20 = new com.google.javascript.rhino.Node(0);
    boolean b21 = node17.hasChild(node20);
    com.google.javascript.rhino.Node node23 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str24 = node20.checkTreeEquals(node23);
    com.google.javascript.rhino.Node node25 = node15.copyInformationFromForTree(node20);
    com.google.javascript.rhino.Node node28 = new com.google.javascript.rhino.Node(9, node11, node15, 29, 10);
    node15.setOptionalArg(false);
    com.google.javascript.rhino.Node node31 = node2.copyInformationFromForTree(node15);
    com.google.javascript.rhino.ErrorReporter errorReporter32 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry33 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter32);
    jSTypeRegistry33.forwardDeclareType("hi!");
    com.google.javascript.rhino.jstype.FunctionParamBuilder functionParamBuilder36 = new com.google.javascript.rhino.jstype.FunctionParamBuilder(jSTypeRegistry33);
    com.google.javascript.rhino.Node node37 = functionParamBuilder36.build();
    boolean b38 = node37.hasMoreThanOneChild();
    boolean b39 = node37.isOptionalArg();
    node15.addChildToFront(node37);
    node37.setCharno(57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str12.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b21 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str24 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str24.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == false);

  }

  @Test
  public void test183() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test183"); }


    com.google.javascript.rhino.FunctionNode functionNode2 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String[] str_array3 = functionNode2.getParamAndVarNames();
    com.google.javascript.rhino.Node node4 = functionNode2.getFirstChild();
    boolean b6 = functionNode2.hasParamOrVar("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n");
    java.lang.Object obj8 = functionNode2.getProp(25);
    com.google.javascript.rhino.Node node10 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node node12 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable13 = node12.getAncestors();
    com.google.javascript.rhino.Node node15 = new com.google.javascript.rhino.Node(0);
    boolean b16 = node12.hasChild(node15);
    com.google.javascript.rhino.Node node18 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str19 = node15.checkTreeEquals(node18);
    com.google.javascript.rhino.Node node20 = node10.copyInformationFromForTree(node15);
    node20.setCharno(149);
    java.lang.Object obj24 = node20.getProp(86);
    com.google.javascript.rhino.Node node26 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    com.google.javascript.rhino.Node node28 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable29 = node28.getAncestors();
    com.google.javascript.rhino.Node node31 = new com.google.javascript.rhino.Node(0);
    boolean b32 = node28.hasChild(node31);
    com.google.javascript.rhino.Node node34 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str35 = node31.checkTreeEquals(node34);
    com.google.javascript.rhino.Node node38 = new com.google.javascript.rhino.Node(126, (com.google.javascript.rhino.Node)functionNode2, node20, node26, node31, 106, 142);
    boolean b39 = node20.isNoSideEffectsCall();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(node4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(obj8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str19 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str19.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(obj24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b32 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str35 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str35.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == false);

  }

  @Test
  public void test184() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test184"); }


    com.google.javascript.jscomp.DefaultCodingConvention defaultCodingConvention0 = new com.google.javascript.jscomp.DefaultCodingConvention();
    java.lang.String str1 = defaultCodingConvention0.getDelegateSuperclassName();
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    com.google.javascript.rhino.ErrorReporter errorReporter4 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry5 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter4);
    jSTypeRegistry5.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter8 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry9 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter8);
    com.google.javascript.rhino.jstype.StaticScope staticScope10 = null;
    com.google.javascript.rhino.jstype.JSType jSType15 = jSTypeRegistry9.getForgivingType(staticScope10, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter16 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry17 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter16);
    com.google.javascript.rhino.jstype.StaticScope staticScope18 = null;
    com.google.javascript.rhino.jstype.JSType jSType23 = jSTypeRegistry17.getForgivingType(staticScope18, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array24 = new com.google.javascript.rhino.jstype.JSType[] { jSType23 };
    com.google.javascript.rhino.jstype.FunctionType functionType25 = jSTypeRegistry5.createFunctionType(jSType15, jSType_array24);
    com.google.javascript.rhino.jstype.JSType jSType26 = functionType25.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter28 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry29 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter28);
    jSTypeRegistry29.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter32 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry33 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter32);
    com.google.javascript.rhino.jstype.StaticScope staticScope34 = null;
    com.google.javascript.rhino.jstype.JSType jSType39 = jSTypeRegistry33.getForgivingType(staticScope34, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter40 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry41 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter40);
    com.google.javascript.rhino.jstype.StaticScope staticScope42 = null;
    com.google.javascript.rhino.jstype.JSType jSType47 = jSTypeRegistry41.getForgivingType(staticScope42, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array48 = new com.google.javascript.rhino.jstype.JSType[] { jSType47 };
    com.google.javascript.rhino.jstype.FunctionType functionType49 = jSTypeRegistry29.createFunctionType(jSType39, jSType_array48);
    com.google.javascript.rhino.jstype.FunctionType functionType50 = jSTypeRegistry3.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType25, false, jSType_array48);
    com.google.javascript.jscomp.Scope scope51 = null;
    com.google.javascript.jscomp.ErrorFormat errorFormat52 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler53 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState54 = compiler53.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter56 = errorFormat52.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler53, true);
    com.google.javascript.jscomp.JSModule jSModule58 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list59 = jSModule58.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback60 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler53, list59, callback60);
    defaultCodingConvention0.defineDelegateProxyPrototypeProperties(jSTypeRegistry3, scope51, list59);
    com.google.javascript.rhino.ErrorReporter errorReporter63 = jSTypeRegistry3.getErrorReporter();
    com.google.javascript.rhino.jstype.JSType jSType68 = jSTypeRegistry3.createNamedType("FUNCTION ", "function ({proxy:{131657635}}): {proxy:{874677665}}", 0, 142);
    com.google.javascript.rhino.ErrorReporter errorReporter69 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry70 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter69);
    jSTypeRegistry70.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter73 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry74 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter73);
    com.google.javascript.rhino.jstype.StaticScope staticScope75 = null;
    com.google.javascript.rhino.jstype.JSType jSType80 = jSTypeRegistry74.getForgivingType(staticScope75, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter81 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry82 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter81);
    com.google.javascript.rhino.jstype.StaticScope staticScope83 = null;
    com.google.javascript.rhino.jstype.JSType jSType88 = jSTypeRegistry82.getForgivingType(staticScope83, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array89 = new com.google.javascript.rhino.jstype.JSType[] { jSType88 };
    com.google.javascript.rhino.jstype.FunctionType functionType90 = jSTypeRegistry70.createFunctionType(jSType80, jSType_array89);
    com.google.javascript.rhino.jstype.JSType jSType91 = functionType90.unboxesTo();
    java.lang.String str92 = functionType90.getReferenceName();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType93 = functionType90.getPrototype();
    com.google.javascript.rhino.jstype.JSType jSType94 = functionPrototypeType93.unboxesTo();
    com.google.javascript.rhino.jstype.FunctionType functionType95 = functionPrototypeType93.getOwnerFunction();
    boolean b96 = functionPrototypeType93.hasReferenceName();
    com.google.javascript.rhino.jstype.JSType jSType97 = jSTypeRegistry3.createDefaultObjectUnion((com.google.javascript.rhino.jstype.JSType)functionPrototypeType93);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(errorReporter63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType68);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType88);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array89);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType90);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType91);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str92);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType93);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType94);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType95);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b96 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType97);

  }

  @Test
  public void test185() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test185"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.jstype.JSType jSType24 = functionType23.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter26 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry27 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter26);
    jSTypeRegistry27.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter30 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry31 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter30);
    com.google.javascript.rhino.jstype.StaticScope staticScope32 = null;
    com.google.javascript.rhino.jstype.JSType jSType37 = jSTypeRegistry31.getForgivingType(staticScope32, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array46 = new com.google.javascript.rhino.jstype.JSType[] { jSType45 };
    com.google.javascript.rhino.jstype.FunctionType functionType47 = jSTypeRegistry27.createFunctionType(jSType37, jSType_array46);
    com.google.javascript.rhino.jstype.FunctionType functionType48 = jSTypeRegistry1.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType23, false, jSType_array46);
    int i49 = functionType48.getPropertiesCount();
    boolean b50 = functionType48.isUnionType();
    boolean b51 = functionType48.isNumberValueType();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i49 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b50 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b51 == false);

  }

  @Test
  public void test186() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test186"); }


    com.google.javascript.jscomp.CheckLevel checkLevel4 = com.google.javascript.jscomp.CheckLevel.ERROR;
    com.google.javascript.jscomp.DiagnosticType diagnosticType6 = com.google.javascript.jscomp.DiagnosticType.make("OFF: Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", checkLevel4, "");
    com.google.javascript.rhino.FunctionNode functionNode11 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.Node node13 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable14 = node13.getAncestors();
    com.google.javascript.rhino.Node node16 = new com.google.javascript.rhino.Node(0);
    boolean b17 = node13.hasChild(node16);
    node13.putBooleanProp(83, false);
    functionNode11.addChildrenToBack(node13);
    int i22 = functionNode11.getFunctionType();
    com.google.javascript.jscomp.CompilerOptions compilerOptions23 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b24 = compilerOptions23.gatherCssNames;
    java.lang.String str25 = compilerOptions23.aliasableGlobals;
    boolean b26 = compilerOptions23.removeDeadCode;
    compilerOptions23.setLooseTypes(false);
    boolean b29 = compilerOptions23.markNoSideEffectCalls;
    com.google.javascript.jscomp.CheckLevel checkLevel30 = com.google.javascript.jscomp.CheckLevel.ERROR;
    compilerOptions23.brokenClosureRequiresLevel = checkLevel30;
    com.google.javascript.jscomp.DiagnosticType diagnosticType34 = com.google.javascript.jscomp.DiagnosticType.disabled("", "hi!");
    com.google.javascript.rhino.FunctionNode functionNode36 = new com.google.javascript.rhino.FunctionNode("");
    int i37 = functionNode36.getFunctionType();
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    jSTypeRegistry39.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter42 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry43 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter42);
    com.google.javascript.rhino.jstype.StaticScope staticScope44 = null;
    com.google.javascript.rhino.jstype.JSType jSType49 = jSTypeRegistry43.getForgivingType(staticScope44, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter50 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry51 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter50);
    com.google.javascript.rhino.jstype.StaticScope staticScope52 = null;
    com.google.javascript.rhino.jstype.JSType jSType57 = jSTypeRegistry51.getForgivingType(staticScope52, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array58 = new com.google.javascript.rhino.jstype.JSType[] { jSType57 };
    com.google.javascript.rhino.jstype.FunctionType functionType59 = jSTypeRegistry39.createFunctionType(jSType49, jSType_array58);
    boolean b60 = functionType59.isConstructor();
    functionNode36.setJSType((com.google.javascript.rhino.jstype.JSType)functionType59);
    java.lang.String[] str_array62 = functionNode36.getParamAndVarNames();
    com.google.javascript.jscomp.JSError jSError63 = com.google.javascript.jscomp.JSError.make("EOF", (com.google.javascript.rhino.Node)functionNode11, checkLevel30, diagnosticType34, str_array62);
    com.google.javascript.jscomp.JSError jSError64 = com.google.javascript.jscomp.JSError.make("function (this:{1173631672}, {proxy:{1109466092}}): function ({proxy:{1995439683}}): {proxy:{130237813}}", (-1), 11, diagnosticType6, str_array62);
    com.google.javascript.jscomp.CompilerOptions compilerOptions65 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b66 = compilerOptions65.gatherCssNames;
    java.lang.String str67 = compilerOptions65.aliasableGlobals;
    boolean b68 = compilerOptions65.removeDeadCode;
    com.google.javascript.jscomp.MessageBundle messageBundle69 = compilerOptions65.messageBundle;
    compilerOptions65.disambiguateProperties = false;
    com.google.javascript.jscomp.CheckLevel checkLevel72 = compilerOptions65.checkUndefinedProperties;
    boolean b73 = compilerOptions65.markAsCompiled;
    boolean b74 = compilerOptions65.inferTypesInGlobalScope;
    compilerOptions65.removeDeadCode = true;
    compilerOptions65.inlineLocalFunctions = false;
    com.google.javascript.jscomp.CheckLevel checkLevel79 = compilerOptions65.checkUndefinedProperties;
    diagnosticType6.level = checkLevel79;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i22 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticType34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i37 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b60 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b66 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b68 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(messageBundle69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b73 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b74 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel79);

  }

  @Test
  public void test187() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test187"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter4 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry5 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter4);
    com.google.javascript.rhino.jstype.StaticScope staticScope6 = null;
    com.google.javascript.rhino.jstype.JSType jSType11 = jSTypeRegistry5.getForgivingType(staticScope6, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter12 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry13 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter12);
    com.google.javascript.rhino.jstype.StaticScope staticScope14 = null;
    com.google.javascript.rhino.jstype.JSType jSType19 = jSTypeRegistry13.getForgivingType(staticScope14, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array20 = new com.google.javascript.rhino.jstype.JSType[] { jSType19 };
    com.google.javascript.rhino.jstype.FunctionType functionType21 = jSTypeRegistry1.createFunctionType(jSType11, jSType_array20);
    com.google.javascript.rhino.jstype.JSType jSType22 = functionType21.unboxesTo();
    java.lang.String str23 = functionType21.getReferenceName();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType24 = functionType21.getPrototype();
    com.google.javascript.rhino.jstype.JSType jSType25 = functionPrototypeType24.unboxesTo();
    com.google.javascript.rhino.jstype.FunctionType functionType26 = functionPrototypeType24.getOwnerFunction();
    com.google.javascript.rhino.jstype.ObjectType objectType27 = com.google.javascript.rhino.jstype.ObjectType.cast((com.google.javascript.rhino.jstype.JSType)functionPrototypeType24);
    boolean b28 = functionPrototypeType24.matchesObjectContext();
    com.google.javascript.rhino.jstype.FunctionType functionType29 = functionPrototypeType24.getOwnerFunction();
    boolean b31 = functionPrototypeType24.isPropertyTypeDeclared("function ({proxy:{78039409}}): {proxy:{384921772}}");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(objectType27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);

  }

  @Test
  public void test188() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test188"); }


    java.lang.String str1 = com.google.javascript.rhino.ScriptRuntime.escapeString("<unknown=75>");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "<unknown=75>"+ "'", str1.equals("<unknown=75>"));

  }

  @Test
  public void test189() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test189"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    boolean b5 = compilerOptions0.checkSymbols;
    compilerOptions0.setRewriteNewDateGoogNow(false);
    compilerOptions0.removeUnusedPrototypePropertiesInExterns = true;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);

  }

  @Test
  public void test190() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test190"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.jstype.StaticScope staticScope2 = null;
    com.google.javascript.rhino.jstype.JSType jSType7 = jSTypeRegistry1.getForgivingType(staticScope2, "", "Named type with empty name component", 53, 108);
    boolean b8 = jSType7.isNumberObjectType();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);

  }

  @Test
  public void test191() {}
// Defects4J: flaky method
//   @Test
//   public void test191() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test191"); }
// 
// 
//     com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler1 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState2 = compiler1.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter4 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler1, true);
//     com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list7 = jSModule6.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback8 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler1, list7, callback8);
//     com.google.javascript.jscomp.ErrorManager errorManager10 = compiler1.getErrorManager();
//     com.google.javascript.jscomp.SourceFile.Generator generator12 = null;
//     com.google.javascript.jscomp.JSSourceFile jSSourceFile13 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator12);
//     com.google.javascript.jscomp.JSSourceFile[] jSSourceFile_array14 = new com.google.javascript.jscomp.JSSourceFile[] { jSSourceFile13 };
//     com.google.javascript.jscomp.SourceFile.Generator generator16 = null;
//     com.google.javascript.jscomp.JSSourceFile jSSourceFile17 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator16);
//     com.google.javascript.jscomp.JsAst jsAst18 = new com.google.javascript.jscomp.JsAst((com.google.javascript.jscomp.SourceFile)jSSourceFile17);
//     com.google.javascript.jscomp.JSSourceFile[] jSSourceFile_array19 = new com.google.javascript.jscomp.JSSourceFile[] { jSSourceFile17 };
//     com.google.javascript.jscomp.CompilerOptions compilerOptions20 = new com.google.javascript.jscomp.CompilerOptions();
//     compilerOptions20.collapseVariableDeclarations = true;
//     com.google.javascript.jscomp.Result result23 = compiler1.compile(jSSourceFile_array14, jSSourceFile_array19, compilerOptions20);
//     compilerOptions20.renamePrefix = "OFF: Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n";
//     compilerOptions20.setDefineToDoubleLiteral("", (-0.0d));
//     boolean b29 = compilerOptions20.labelRenaming;
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorManager10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile_array14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile17);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile_array19);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(result23);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b29 == false);
// 
//   }

  @Test
  public void test192() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test192"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.Node node25 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable26 = node25.getAncestors();
    java.lang.String str27 = node25.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType28 = jSTypeRegistry1.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType23, node25);
    java.util.Set set30 = jSTypeRegistry1.getTypesWithProperty("JSDocInfo");
    com.google.javascript.rhino.jstype.StaticScope staticScope31 = null;
    jSTypeRegistry1.resolveTypesInScope(staticScope31);
    com.google.javascript.rhino.ErrorReporter errorReporter33 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry34 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter33);
    jSTypeRegistry34.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter37 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry38 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter37);
    com.google.javascript.rhino.jstype.StaticScope staticScope39 = null;
    com.google.javascript.rhino.jstype.JSType jSType44 = jSTypeRegistry38.getForgivingType(staticScope39, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter45 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry46 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter45);
    com.google.javascript.rhino.jstype.StaticScope staticScope47 = null;
    com.google.javascript.rhino.jstype.JSType jSType52 = jSTypeRegistry46.getForgivingType(staticScope47, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array53 = new com.google.javascript.rhino.jstype.JSType[] { jSType52 };
    com.google.javascript.rhino.jstype.FunctionType functionType54 = jSTypeRegistry34.createFunctionType(jSType44, jSType_array53);
    com.google.javascript.rhino.jstype.JSType jSType55 = functionType54.unboxesTo();
    java.lang.String str56 = functionType54.getReferenceName();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType57 = functionType54.getPrototype();
    com.google.javascript.rhino.jstype.JSType jSType58 = functionPrototypeType57.unboxesTo();
    com.google.javascript.rhino.jstype.FunctionType functionType59 = functionPrototypeType57.getOwnerFunction();
    java.lang.String str60 = functionPrototypeType57.toString();
    boolean b61 = functionPrototypeType57.hasCachedValues();
    boolean b62 = functionPrototypeType57.canBeCalled();
    com.google.javascript.rhino.jstype.JSType jSType64 = functionPrototypeType57.getPropertyType("FUNCTION ");
    boolean b65 = functionPrototypeType57.isNativeObjectType();
    boolean b67 = functionPrototypeType57.isPropertyInExterns("LEGACY");
    com.google.javascript.rhino.jstype.FunctionType functionType68 = functionPrototypeType57.getConstructor();
    boolean b70 = functionPrototypeType57.isPropertyTypeInferred("GETVAR");
    com.google.javascript.rhino.jstype.JSType jSType71 = jSTypeRegistry1.createOptionalNullableType((com.google.javascript.rhino.jstype.JSType)functionPrototypeType57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str27 + "' != '" + "EOF"+ "'", str27.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str60 + "' != '" + "{...}"+ "'", str60.equals("{...}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b61 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b62 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b65 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b67 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(functionType68);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b70 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType71);

  }

  @Test
  public void test193() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test193"); }


    com.google.javascript.rhino.FunctionNode functionNode1 = new com.google.javascript.rhino.FunctionNode("");
    int i2 = functionNode1.getFunctionType();
    functionNode1.setEndLineno(43);
    int i5 = functionNode1.getBaseLineno();
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable6 = functionNode1.getAncestors();
    functionNode1.setVarArgs(false);
    com.google.javascript.jscomp.ClosureCodingConvention closureCodingConvention9 = new com.google.javascript.jscomp.ClosureCodingConvention();
    com.google.javascript.rhino.Node node12 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable13 = node12.getAncestors();
    com.google.javascript.rhino.Node node15 = new com.google.javascript.rhino.Node(0);
    boolean b16 = node12.hasChild(node15);
    com.google.javascript.rhino.Node node18 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str19 = node15.checkTreeEquals(node18);
    com.google.javascript.rhino.Node node20 = node18.cloneNode();
    com.google.javascript.rhino.Node node22 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node node24 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable25 = node24.getAncestors();
    com.google.javascript.rhino.Node node27 = new com.google.javascript.rhino.Node(0);
    boolean b28 = node24.hasChild(node27);
    com.google.javascript.rhino.Node node30 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str31 = node27.checkTreeEquals(node30);
    com.google.javascript.rhino.Node node32 = node22.copyInformationFromForTree(node27);
    com.google.javascript.rhino.Node node35 = new com.google.javascript.rhino.Node(9, node18, node22, 29, 10);
    boolean b36 = closureCodingConvention9.isOptionalParameter(node22);
    com.google.javascript.rhino.Node node41 = new com.google.javascript.rhino.Node(54, 151, 76);
    com.google.javascript.rhino.Node node44 = new com.google.javascript.rhino.Node(0, node41, 90, 110);
    com.google.javascript.rhino.Node node45 = node41.detachFromParent();
    boolean b46 = closureCodingConvention9.isVarArgsParameter(node41);
    com.google.javascript.rhino.FunctionNode functionNode48 = new com.google.javascript.rhino.FunctionNode("");
    int i49 = functionNode48.getFunctionType();
    functionNode48.setEndLineno(43);
    int i52 = functionNode48.getBaseLineno();
    java.lang.Object obj53 = functionNode48.getCompilerData();
    java.lang.String str54 = closureCodingConvention9.identifyTypeDefAssign((com.google.javascript.rhino.Node)functionNode48);
    com.google.javascript.rhino.FunctionNode functionNode56 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String str57 = functionNode56.getFunctionName();
    java.lang.Iterable iterable58 = functionNode56.siblings();
    boolean b59 = closureCodingConvention9.isOptionalParameter((com.google.javascript.rhino.Node)functionNode56);
    java.lang.String str60 = closureCodingConvention9.getExportPropertyFunction();
    com.google.javascript.rhino.FunctionNode functionNode63 = new com.google.javascript.rhino.FunctionNode("");
    int i64 = functionNode63.getFunctionType();
    java.lang.String str65 = functionNode63.getFunctionName();
    com.google.javascript.rhino.Node node68 = new com.google.javascript.rhino.Node(91, (com.google.javascript.rhino.Node)functionNode63, 12, 13);
    java.lang.String str69 = closureCodingConvention9.getSingletonGetterClassName(node68);
    com.google.javascript.rhino.Node node74 = new com.google.javascript.rhino.Node(54, 151, 76);
    com.google.javascript.rhino.Node node77 = new com.google.javascript.rhino.Node(0, node74, 90, 110);
    boolean b78 = closureCodingConvention9.isOptionalParameter(node77);
    int i79 = node77.getType();
    boolean b80 = functionNode1.checkTreeTypeAwareEqualsSilent(node77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str19 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str19.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str31 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str31.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b46 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i49 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i52 == (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(obj53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str57 + "' != '" + ""+ "'", str57.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(iterable58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b59 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str60 + "' != '" + "goog.exportProperty"+ "'", str60.equals("goog.exportProperty"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i64 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str65 + "' != '" + ""+ "'", str65.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b78 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i79 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b80 == false);

  }

  @Test
  public void test194() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test194"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter4 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry5 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter4);
    com.google.javascript.rhino.jstype.StaticScope staticScope6 = null;
    com.google.javascript.rhino.jstype.JSType jSType11 = jSTypeRegistry5.getForgivingType(staticScope6, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter12 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry13 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter12);
    com.google.javascript.rhino.jstype.StaticScope staticScope14 = null;
    com.google.javascript.rhino.jstype.JSType jSType19 = jSTypeRegistry13.getForgivingType(staticScope14, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array20 = new com.google.javascript.rhino.jstype.JSType[] { jSType19 };
    com.google.javascript.rhino.jstype.FunctionType functionType21 = jSTypeRegistry1.createFunctionType(jSType11, jSType_array20);
    com.google.javascript.rhino.jstype.JSType jSType22 = functionType21.unboxesTo();
    java.lang.String str23 = functionType21.getReferenceName();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType24 = functionType21.getPrototype();
    com.google.javascript.rhino.jstype.JSType jSType25 = functionPrototypeType24.unboxesTo();
    com.google.javascript.rhino.jstype.FunctionType functionType26 = functionPrototypeType24.getOwnerFunction();
    java.lang.String str27 = functionPrototypeType24.toString();
    boolean b28 = functionPrototypeType24.hasCachedValues();
    boolean b29 = functionPrototypeType24.canBeCalled();
    java.lang.String str30 = functionPrototypeType24.toString();
    com.google.javascript.rhino.ErrorReporter errorReporter31 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry32 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter31);
    jSTypeRegistry32.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter35 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry36 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter35);
    com.google.javascript.rhino.jstype.StaticScope staticScope37 = null;
    com.google.javascript.rhino.jstype.JSType jSType42 = jSTypeRegistry36.getForgivingType(staticScope37, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter43 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry44 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter43);
    com.google.javascript.rhino.jstype.StaticScope staticScope45 = null;
    com.google.javascript.rhino.jstype.JSType jSType50 = jSTypeRegistry44.getForgivingType(staticScope45, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array51 = new com.google.javascript.rhino.jstype.JSType[] { jSType50 };
    com.google.javascript.rhino.jstype.FunctionType functionType52 = jSTypeRegistry32.createFunctionType(jSType42, jSType_array51);
    com.google.javascript.rhino.jstype.JSType jSType53 = functionType52.unboxesTo();
    java.lang.String str54 = functionType52.getReferenceName();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType55 = functionType52.getPrototype();
    com.google.javascript.rhino.jstype.JSType jSType56 = functionPrototypeType55.unboxesTo();
    com.google.javascript.rhino.jstype.FunctionType functionType57 = functionPrototypeType55.getOwnerFunction();
    com.google.javascript.rhino.jstype.JSType jSType59 = functionPrototypeType55.getPropertyType("function (this:{1173631672}, {proxy:{1109466092}}): function ({proxy:{1995439683}}): {proxy:{130237813}}");
    com.google.javascript.rhino.JSDocInfo jSDocInfo61 = null;
    functionPrototypeType55.setPropertyJSDocInfo("", jSDocInfo61, false);
    com.google.javascript.rhino.jstype.FunctionType functionType64 = functionPrototypeType55.getConstructor();
    boolean b65 = functionPrototypeType55.isTemplateType();
    boolean b66 = com.google.javascript.rhino.jstype.JSType.isEquivalent((com.google.javascript.rhino.jstype.JSType)functionPrototypeType24, (com.google.javascript.rhino.jstype.JSType)functionPrototypeType55);
    java.util.Set set67 = functionPrototypeType24.getOwnPropertyNames();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str27 + "' != '" + "{...}"+ "'", str27.equals("{...}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str30 + "' != '" + "{...}"+ "'", str30.equals("{...}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(functionType64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b65 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b66 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set67);

  }

  @Test
  public void test195() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test195"); }


    com.google.javascript.rhino.JSDocInfo jSDocInfo0 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str1 = jSDocInfo0.getTemplateTypeName();
    boolean b2 = jSDocInfo0.hasEnumParameterType();
    boolean b3 = jSDocInfo0.isConstant();
    java.lang.String str4 = jSDocInfo0.toString();
    java.util.Set set5 = jSDocInfo0.getModifies();
    java.lang.String str6 = jSDocInfo0.getFileOverview();
    boolean b7 = jSDocInfo0.isNoCompile();
    boolean b8 = jSDocInfo0.isNoAlias();
    int i9 = jSDocInfo0.getImplementedInterfaceCount();
    boolean b10 = jSDocInfo0.containsDeclaration();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str4 + "' != '" + "JSDocInfo"+ "'", str4.equals("JSDocInfo"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i9 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);

  }

  @Test
  public void test196() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test196"); }


    com.google.javascript.jscomp.DefaultCodingConvention defaultCodingConvention0 = new com.google.javascript.jscomp.DefaultCodingConvention();
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = null;
    com.google.javascript.jscomp.Scope scope2 = null;
    com.google.javascript.jscomp.JSModule jSModule4 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list5 = jSModule4.getDependencies();
    defaultCodingConvention0.defineDelegateProxyPrototypeProperties(jSTypeRegistry1, scope2, list5);
    com.google.javascript.rhino.Node node7 = null;
    java.lang.String str8 = defaultCodingConvention0.identifyTypeDefAssign(node7);
    java.lang.String str9 = defaultCodingConvention0.getExportPropertyFunction();
    com.google.javascript.rhino.ScriptOrFnNode scriptOrFnNode13 = new com.google.javascript.rhino.ScriptOrFnNode(6, 112, 68);
    com.google.javascript.rhino.Node node14 = scriptOrFnNode13.getLastSibling();
    com.google.javascript.jscomp.CodingConvention.DelegateRelationship delegateRelationship15 = defaultCodingConvention0.getDelegateRelationship((com.google.javascript.rhino.Node)scriptOrFnNode13);
    com.google.javascript.jscomp.DefaultCodingConvention defaultCodingConvention16 = new com.google.javascript.jscomp.DefaultCodingConvention();
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry17 = null;
    com.google.javascript.jscomp.Scope scope18 = null;
    com.google.javascript.jscomp.JSModule jSModule20 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list21 = jSModule20.getDependencies();
    defaultCodingConvention16.defineDelegateProxyPrototypeProperties(jSTypeRegistry17, scope18, list21);
    boolean b24 = defaultCodingConvention16.isExported("Not declared as a type name");
    com.google.javascript.rhino.FunctionNode functionNode27 = new com.google.javascript.rhino.FunctionNode("");
    int i28 = functionNode27.getFunctionType();
    java.lang.String str29 = functionNode27.getFunctionName();
    com.google.javascript.rhino.Node node32 = new com.google.javascript.rhino.Node(91, (com.google.javascript.rhino.Node)functionNode27, 12, 13);
    com.google.javascript.jscomp.CodingConvention.SubclassRelationship subclassRelationship33 = defaultCodingConvention16.getClassesDefinedByCall((com.google.javascript.rhino.Node)functionNode27);
    functionNode27.setBaseLineno(31);
    int i36 = functionNode27.getCharno();
    boolean b37 = defaultCodingConvention0.isOptionalParameter((com.google.javascript.rhino.Node)functionNode27);
    boolean b39 = defaultCodingConvention0.isConstantKey("function ({proxy:{78039409}}): {proxy:{384921772}}");
    com.google.javascript.rhino.Node node44 = new com.google.javascript.rhino.Node(54, 151, 76);
    com.google.javascript.rhino.Node node47 = new com.google.javascript.rhino.Node(0, node44, 90, 110);
    int i48 = node44.getType();
    com.google.javascript.rhino.Node node49 = node44.getFirstChild();
    java.lang.String str50 = defaultCodingConvention0.identifyTypeDefAssign(node44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(delegateRelationship15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i28 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str29 + "' != '" + ""+ "'", str29.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(subclassRelationship33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i36 == (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i48 == 54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(node49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str50);

  }

  @Test
  public void test197() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test197"); }


    com.google.javascript.rhino.EvaluatorException evaluatorException3 = new com.google.javascript.rhino.EvaluatorException("Not declared as a constructor", "JSDocInfo", 42);
    java.lang.String str4 = evaluatorException3.sourceName();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str4 + "' != '" + "JSDocInfo"+ "'", str4.equals("JSDocInfo"));

  }

  @Test
  public void test198() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test198"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.jstype.JSType jSType24 = functionType23.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter26 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry27 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter26);
    jSTypeRegistry27.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter30 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry31 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter30);
    com.google.javascript.rhino.jstype.StaticScope staticScope32 = null;
    com.google.javascript.rhino.jstype.JSType jSType37 = jSTypeRegistry31.getForgivingType(staticScope32, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array46 = new com.google.javascript.rhino.jstype.JSType[] { jSType45 };
    com.google.javascript.rhino.jstype.FunctionType functionType47 = jSTypeRegistry27.createFunctionType(jSType37, jSType_array46);
    com.google.javascript.rhino.jstype.FunctionType functionType48 = jSTypeRegistry1.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType23, false, jSType_array46);
    com.google.javascript.rhino.ErrorReporter errorReporter49 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry50 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter49);
    com.google.javascript.rhino.ErrorReporter errorReporter51 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry52 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter51);
    jSTypeRegistry52.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter55 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry56 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter55);
    com.google.javascript.rhino.jstype.StaticScope staticScope57 = null;
    com.google.javascript.rhino.jstype.JSType jSType62 = jSTypeRegistry56.getForgivingType(staticScope57, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array71 = new com.google.javascript.rhino.jstype.JSType[] { jSType70 };
    com.google.javascript.rhino.jstype.FunctionType functionType72 = jSTypeRegistry52.createFunctionType(jSType62, jSType_array71);
    com.google.javascript.rhino.Node node74 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable75 = node74.getAncestors();
    java.lang.String str76 = node74.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry50.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType72, node74);
    functionType23.setPrototypeBasedOn((com.google.javascript.rhino.jstype.ObjectType)functionType77);
    boolean b79 = functionType23.isOrdinaryFunction();
    com.google.javascript.jscomp.ErrorFormat errorFormat80 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
    com.google.javascript.jscomp.Compiler compiler81 = new com.google.javascript.jscomp.Compiler();
    com.google.javascript.jscomp.Compiler.IntermediateState intermediateState82 = compiler81.getState();
    com.google.javascript.jscomp.MessageFormatter messageFormatter84 = errorFormat80.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler81, true);
    com.google.javascript.jscomp.JSModule jSModule86 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list87 = jSModule86.getDependencies();
    com.google.javascript.jscomp.NodeTraversal.Callback callback88 = null;
    com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler81, list87, callback88);
    functionType23.setImplementedInterfaces(list87);
    boolean b91 = functionType23.hasCachedValues();
    boolean b92 = functionType23.isNumberObjectType();
    java.lang.Iterable iterable93 = functionType23.getAllImplementedInterfaces();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str76 + "' != '" + "EOF"+ "'", str76.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b79 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(intermediateState82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(messageFormatter84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list87);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b91 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b92 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(iterable93);

  }

  @Test
  public void test199() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test199"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter4 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry5 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter4);
    com.google.javascript.rhino.jstype.StaticScope staticScope6 = null;
    com.google.javascript.rhino.jstype.JSType jSType11 = jSTypeRegistry5.getForgivingType(staticScope6, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter12 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry13 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter12);
    com.google.javascript.rhino.jstype.StaticScope staticScope14 = null;
    com.google.javascript.rhino.jstype.JSType jSType19 = jSTypeRegistry13.getForgivingType(staticScope14, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array20 = new com.google.javascript.rhino.jstype.JSType[] { jSType19 };
    com.google.javascript.rhino.jstype.FunctionType functionType21 = jSTypeRegistry1.createFunctionType(jSType11, jSType_array20);
    com.google.javascript.rhino.jstype.JSType jSType22 = functionType21.unboxesTo();
    java.lang.String str23 = functionType21.getReferenceName();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType24 = functionType21.getPrototype();
    com.google.javascript.rhino.jstype.JSType jSType25 = functionPrototypeType24.unboxesTo();
    com.google.javascript.rhino.jstype.FunctionType functionType26 = functionPrototypeType24.getOwnerFunction();
    com.google.javascript.rhino.jstype.JSType jSType28 = functionPrototypeType24.getPropertyType("function (this:{1173631672}, {proxy:{1109466092}}): function ({proxy:{1995439683}}): {proxy:{130237813}}");
    com.google.javascript.rhino.jstype.FunctionType functionType29 = functionPrototypeType24.getOwnerFunction();
    boolean b31 = functionType29.isPropertyInExterns("goog.exportSymbol");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);

  }

  @Test
  public void test200() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test200"); }


    com.google.javascript.rhino.Node node3 = com.google.javascript.jscomp.NodeUtil.newQualifiedNameNode("EOF", 26, 0);
    com.google.javascript.rhino.FunctionNode functionNode6 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String[] str_array7 = functionNode6.getParamAndVarNames();
    com.google.javascript.rhino.Node node8 = functionNode6.getFirstChild();
    boolean b10 = functionNode6.hasParamOrVar("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n");
    java.lang.Object obj12 = functionNode6.getProp(25);
    com.google.javascript.rhino.Node node14 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node node16 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable17 = node16.getAncestors();
    com.google.javascript.rhino.Node node19 = new com.google.javascript.rhino.Node(0);
    boolean b20 = node16.hasChild(node19);
    com.google.javascript.rhino.Node node22 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str23 = node19.checkTreeEquals(node22);
    com.google.javascript.rhino.Node node24 = node14.copyInformationFromForTree(node19);
    node24.setCharno(149);
    java.lang.Object obj28 = node24.getProp(86);
    com.google.javascript.rhino.Node node30 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    com.google.javascript.rhino.Node node32 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable33 = node32.getAncestors();
    com.google.javascript.rhino.Node node35 = new com.google.javascript.rhino.Node(0);
    boolean b36 = node32.hasChild(node35);
    com.google.javascript.rhino.Node node38 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str39 = node35.checkTreeEquals(node38);
    com.google.javascript.rhino.Node node42 = new com.google.javascript.rhino.Node(126, (com.google.javascript.rhino.Node)functionNode6, node24, node30, node35, 106, 142);
    com.google.javascript.rhino.Node node43 = node3.clonePropsFrom(node24);
    java.lang.Iterable iterable44 = node3.siblings();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(node8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(obj12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str23 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str23.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(obj28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str39 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str39.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(iterable44);

  }

  @Test
  public void test201() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test201"); }


    com.google.javascript.jscomp.ClosureCodingConvention closureCodingConvention0 = new com.google.javascript.jscomp.ClosureCodingConvention();
    com.google.javascript.rhino.Node node3 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable4 = node3.getAncestors();
    com.google.javascript.rhino.Node node6 = new com.google.javascript.rhino.Node(0);
    boolean b7 = node3.hasChild(node6);
    com.google.javascript.rhino.Node node9 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str10 = node6.checkTreeEquals(node9);
    com.google.javascript.rhino.Node node11 = node9.cloneNode();
    com.google.javascript.rhino.Node node13 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node node15 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable16 = node15.getAncestors();
    com.google.javascript.rhino.Node node18 = new com.google.javascript.rhino.Node(0);
    boolean b19 = node15.hasChild(node18);
    com.google.javascript.rhino.Node node21 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str22 = node18.checkTreeEquals(node21);
    com.google.javascript.rhino.Node node23 = node13.copyInformationFromForTree(node18);
    com.google.javascript.rhino.Node node26 = new com.google.javascript.rhino.Node(9, node9, node13, 29, 10);
    boolean b27 = closureCodingConvention0.isOptionalParameter(node13);
    com.google.javascript.rhino.Node node29 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node node31 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable32 = node31.getAncestors();
    com.google.javascript.rhino.Node node34 = new com.google.javascript.rhino.Node(0);
    boolean b35 = node31.hasChild(node34);
    com.google.javascript.rhino.Node node37 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str38 = node34.checkTreeEquals(node37);
    com.google.javascript.rhino.Node node39 = node29.copyInformationFromForTree(node34);
    boolean b40 = node29.hasOneChild();
    boolean b41 = closureCodingConvention0.isOptionalParameter(node29);
    boolean b43 = closureCodingConvention0.isSuperClassReference("Unknown class name");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str10 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str10.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str22 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str22.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str38 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str38.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b43 == false);

  }

  @Test
  public void test202() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test202"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.jstype.StaticScope staticScope2 = null;
    com.google.javascript.rhino.jstype.JSType jSType7 = jSTypeRegistry1.getForgivingType(staticScope2, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter8 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry9 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter8);
    com.google.javascript.rhino.ErrorReporter errorReporter10 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry11 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter10);
    jSTypeRegistry11.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter22 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry23 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter22);
    com.google.javascript.rhino.jstype.StaticScope staticScope24 = null;
    com.google.javascript.rhino.jstype.JSType jSType29 = jSTypeRegistry23.getForgivingType(staticScope24, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array30 = new com.google.javascript.rhino.jstype.JSType[] { jSType29 };
    com.google.javascript.rhino.jstype.FunctionType functionType31 = jSTypeRegistry11.createFunctionType(jSType21, jSType_array30);
    com.google.javascript.rhino.jstype.JSType jSType32 = functionType31.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter34 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry35 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter34);
    jSTypeRegistry35.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter46 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry47 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter46);
    com.google.javascript.rhino.jstype.StaticScope staticScope48 = null;
    com.google.javascript.rhino.jstype.JSType jSType53 = jSTypeRegistry47.getForgivingType(staticScope48, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array54 = new com.google.javascript.rhino.jstype.JSType[] { jSType53 };
    com.google.javascript.rhino.jstype.FunctionType functionType55 = jSTypeRegistry35.createFunctionType(jSType45, jSType_array54);
    com.google.javascript.rhino.jstype.FunctionType functionType56 = jSTypeRegistry9.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType31, false, jSType_array54);
    com.google.javascript.rhino.ErrorReporter errorReporter57 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry58 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter57);
    com.google.javascript.rhino.ErrorReporter errorReporter59 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry60 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter59);
    jSTypeRegistry60.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter71 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry72 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter71);
    com.google.javascript.rhino.jstype.StaticScope staticScope73 = null;
    com.google.javascript.rhino.jstype.JSType jSType78 = jSTypeRegistry72.getForgivingType(staticScope73, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array79 = new com.google.javascript.rhino.jstype.JSType[] { jSType78 };
    com.google.javascript.rhino.jstype.FunctionType functionType80 = jSTypeRegistry60.createFunctionType(jSType70, jSType_array79);
    com.google.javascript.rhino.Node node82 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable83 = node82.getAncestors();
    java.lang.String str84 = node82.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType85 = jSTypeRegistry58.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType80, node82);
    com.google.javascript.rhino.jstype.JSType jSType87 = jSTypeRegistry9.getGreatestSubtypeWithProperty((com.google.javascript.rhino.jstype.JSType)functionType80, "EOF");
    com.google.javascript.rhino.jstype.JSType jSType88 = jSTypeRegistry1.createDefaultObjectUnion((com.google.javascript.rhino.jstype.JSType)functionType80);
    boolean b89 = functionType80.isString();
    boolean b90 = functionType80.isNumberValueType();
    boolean b92 = functionType80.isPropertyTypeDeclared("");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType78);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable83);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str84 + "' != '" + "EOF"+ "'", str84.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType87);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType88);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b89 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b90 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b92 == false);

  }

  @Test
  public void test203() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test203"); }


    com.google.javascript.rhino.FunctionNode functionNode1 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String[] str_array2 = functionNode1.getParamAndVarNames();
    com.google.javascript.rhino.Node node3 = functionNode1.getFirstChild();
    boolean b5 = functionNode1.hasParamOrVar("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.ErrorReporter errorReporter8 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry9 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter8);
    jSTypeRegistry9.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter12 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry13 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter12);
    com.google.javascript.rhino.jstype.StaticScope staticScope14 = null;
    com.google.javascript.rhino.jstype.JSType jSType19 = jSTypeRegistry13.getForgivingType(staticScope14, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter20 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry21 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter20);
    com.google.javascript.rhino.jstype.StaticScope staticScope22 = null;
    com.google.javascript.rhino.jstype.JSType jSType27 = jSTypeRegistry21.getForgivingType(staticScope22, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array28 = new com.google.javascript.rhino.jstype.JSType[] { jSType27 };
    com.google.javascript.rhino.jstype.FunctionType functionType29 = jSTypeRegistry9.createFunctionType(jSType19, jSType_array28);
    com.google.javascript.rhino.Node node31 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable32 = node31.getAncestors();
    java.lang.String str33 = node31.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType34 = jSTypeRegistry7.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType29, node31);
    com.google.javascript.rhino.JSDocInfo jSDocInfo35 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str36 = jSDocInfo35.getTemplateTypeName();
    boolean b37 = jSDocInfo35.hasEnumParameterType();
    functionType29.setJSDocInfo(jSDocInfo35);
    functionNode1.setJSDocInfo(jSDocInfo35);
    int i42 = functionNode1.addRegexp("{...}", "Not declared as a type name");
    com.google.javascript.jscomp.CompilerOptions compilerOptions44 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions44.collapseVariableDeclarations = true;
    compilerOptions44.debugFunctionSideEffectsPath = "hi!";
    functionNode1.putProp(97, (java.lang.Object)compilerOptions44);
    boolean b50 = compilerOptions44.instrumentForCoverageOnly;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(node3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str33 + "' != '" + "EOF"+ "'", str33.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i42 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b50 == false);

  }

  @Test
  public void test204() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test204"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSDocInfo jSDocInfo3 = jSDocInfoBuilder1.build("");
    boolean b5 = jSDocInfoBuilder1.recordLends("EOF");
    boolean b7 = jSDocInfoBuilder1.recordBlockDescription("OFF");
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder9 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b11 = jSDocInfoBuilder9.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression12 = null;
    boolean b13 = jSDocInfoBuilder9.recordReturnType(jSTypeExpression12);
    boolean b14 = jSDocInfoBuilder9.recordHiddenness();
    boolean b15 = jSDocInfoBuilder9.recordConstructor();
    boolean b17 = jSDocInfoBuilder9.recordReturnDescription("Not declared as a type name");
    boolean b18 = jSDocInfoBuilder9.recordOverride();
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder20 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b22 = jSDocInfoBuilder20.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression23 = null;
    boolean b24 = jSDocInfoBuilder20.recordReturnType(jSTypeExpression23);
    com.google.javascript.rhino.Node node26 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable27 = node26.getAncestors();
    com.google.javascript.rhino.Node node29 = new com.google.javascript.rhino.Node(0);
    boolean b30 = node26.hasChild(node29);
    com.google.javascript.rhino.Node node32 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str33 = node29.checkTreeEquals(node32);
    com.google.javascript.rhino.Node node34 = node32.cloneNode();
    boolean b35 = node34.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression37 = new com.google.javascript.rhino.JSTypeExpression(node34, "<No stack trace available>");
    boolean b38 = jSDocInfoBuilder20.recordDefineType(jSTypeExpression37);
    boolean b39 = jSDocInfoBuilder9.recordType(jSTypeExpression37);
    boolean b40 = jSDocInfoBuilder1.recordTypedef(jSTypeExpression37);
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder42 = new com.google.javascript.rhino.JSDocInfoBuilder(false);
    boolean b43 = jSDocInfoBuilder42.recordExport();
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder45 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b47 = jSDocInfoBuilder45.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression48 = null;
    boolean b49 = jSDocInfoBuilder45.recordReturnType(jSTypeExpression48);
    com.google.javascript.rhino.Node node51 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable52 = node51.getAncestors();
    com.google.javascript.rhino.Node node54 = new com.google.javascript.rhino.Node(0);
    boolean b55 = node51.hasChild(node54);
    com.google.javascript.rhino.Node node57 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str58 = node54.checkTreeEquals(node57);
    com.google.javascript.rhino.Node node59 = node57.cloneNode();
    boolean b60 = node59.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression62 = new com.google.javascript.rhino.JSTypeExpression(node59, "<No stack trace available>");
    boolean b63 = jSDocInfoBuilder45.recordDefineType(jSTypeExpression62);
    com.google.javascript.rhino.Node node65 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable66 = node65.getAncestors();
    com.google.javascript.rhino.Node node68 = new com.google.javascript.rhino.Node(0);
    boolean b69 = node65.hasChild(node68);
    com.google.javascript.rhino.Node node71 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str72 = node68.checkTreeEquals(node71);
    com.google.javascript.rhino.Node node73 = node71.cloneNode();
    boolean b74 = node73.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression76 = new com.google.javascript.rhino.JSTypeExpression(node73, "<No stack trace available>");
    boolean b77 = jSDocInfoBuilder45.recordType(jSTypeExpression76);
    boolean b78 = jSDocInfoBuilder45.recordExterns();
    com.google.javascript.rhino.Node node81 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable82 = node81.getAncestors();
    com.google.javascript.rhino.Node node84 = new com.google.javascript.rhino.Node(0);
    boolean b85 = node81.hasChild(node84);
    com.google.javascript.rhino.Node node87 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str88 = node84.checkTreeEquals(node87);
    com.google.javascript.rhino.Node node89 = node87.cloneNode();
    boolean b90 = node89.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression92 = new com.google.javascript.rhino.JSTypeExpression(node89, "<No stack trace available>");
    boolean b93 = jSDocInfoBuilder45.recordParameter("JSC_NODE_TRAVERSAL_ERROR. {0} at Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n line (unknown line) : (unknown column)", jSTypeExpression92);
    boolean b94 = jSTypeExpression92.isOptionalArg();
    boolean b95 = jSTypeExpression92.isVarArgs();
    boolean b96 = jSDocInfoBuilder42.recordImplementedInterface(jSTypeExpression92);
    java.lang.RuntimeException runtimeException97 = com.google.javascript.rhino.ScriptRuntime.notFunctionError((java.lang.Object)b40, (java.lang.Object)jSTypeExpression92);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSDocInfo3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str33 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str33.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b43 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b47 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b49 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b55 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str58 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str58.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b60 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b63 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b69 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str72 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str72.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node73);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b74 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b77 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b78 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b85 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node87);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str88 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str88.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node89);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b90 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b93 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b94 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b95 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b96 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(runtimeException97);

  }

  @Test
  public void test205() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test205"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    compilerOptions0.setDefineToBooleanLiteral("hi!", false);
    com.google.javascript.jscomp.ClosureCodingConvention closureCodingConvention8 = new com.google.javascript.jscomp.ClosureCodingConvention();
    com.google.javascript.rhino.Node node11 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable12 = node11.getAncestors();
    com.google.javascript.rhino.Node node14 = new com.google.javascript.rhino.Node(0);
    boolean b15 = node11.hasChild(node14);
    com.google.javascript.rhino.Node node17 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str18 = node14.checkTreeEquals(node17);
    com.google.javascript.rhino.Node node19 = node17.cloneNode();
    com.google.javascript.rhino.Node node21 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node node23 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable24 = node23.getAncestors();
    com.google.javascript.rhino.Node node26 = new com.google.javascript.rhino.Node(0);
    boolean b27 = node23.hasChild(node26);
    com.google.javascript.rhino.Node node29 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str30 = node26.checkTreeEquals(node29);
    com.google.javascript.rhino.Node node31 = node21.copyInformationFromForTree(node26);
    com.google.javascript.rhino.Node node34 = new com.google.javascript.rhino.Node(9, node17, node21, 29, 10);
    boolean b35 = closureCodingConvention8.isOptionalParameter(node21);
    compilerOptions0.setCodingConvention((com.google.javascript.jscomp.CodingConvention)closureCodingConvention8);
    java.util.Collection collection37 = closureCodingConvention8.getAssertionFunctions();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str18 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str18.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str30 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str30.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(collection37);

  }

  @Test
  public void test206() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test206"); }


    com.google.javascript.jscomp.JSSourceFile jSSourceFile1 = com.google.javascript.jscomp.JSSourceFile.fromFile("function ({proxy:{1163350302}}): {proxy:{1983624356}}");
    com.google.javascript.jscomp.CompilerInput compilerInput3 = new com.google.javascript.jscomp.CompilerInput(jSSourceFile1, false);
    com.google.javascript.jscomp.CompilerInput compilerInput5 = new com.google.javascript.jscomp.CompilerInput(jSSourceFile1, false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile1);

  }

  @Test
  public void test207() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test207"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter4 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry5 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter4);
    com.google.javascript.rhino.jstype.StaticScope staticScope6 = null;
    com.google.javascript.rhino.jstype.JSType jSType11 = jSTypeRegistry5.getForgivingType(staticScope6, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter12 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry13 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter12);
    com.google.javascript.rhino.jstype.StaticScope staticScope14 = null;
    com.google.javascript.rhino.jstype.JSType jSType19 = jSTypeRegistry13.getForgivingType(staticScope14, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array20 = new com.google.javascript.rhino.jstype.JSType[] { jSType19 };
    com.google.javascript.rhino.jstype.FunctionType functionType21 = jSTypeRegistry1.createFunctionType(jSType11, jSType_array20);
    com.google.javascript.rhino.jstype.JSType jSType22 = functionType21.unboxesTo();
    java.lang.String str23 = functionType21.getReferenceName();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType24 = functionType21.getPrototype();
    com.google.javascript.rhino.jstype.JSType jSType25 = functionPrototypeType24.unboxesTo();
    com.google.javascript.rhino.jstype.FunctionType functionType26 = functionPrototypeType24.getOwnerFunction();
    int i27 = functionPrototypeType24.getPropertiesCount();
    boolean b28 = functionPrototypeType24.hasReferenceName();
    com.google.javascript.rhino.JSDocInfo jSDocInfo29 = functionPrototypeType24.getJSDocInfo();
    com.google.javascript.rhino.JSDocInfo jSDocInfo31 = functionPrototypeType24.getOwnPropertyJSDocInfo("CALL");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i27 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSDocInfo29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSDocInfo31);

  }

  @Test
  public void test208() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test208"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter4 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry5 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter4);
    com.google.javascript.rhino.jstype.StaticScope staticScope6 = null;
    com.google.javascript.rhino.jstype.JSType jSType11 = jSTypeRegistry5.getForgivingType(staticScope6, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter12 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry13 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter12);
    com.google.javascript.rhino.jstype.StaticScope staticScope14 = null;
    com.google.javascript.rhino.jstype.JSType jSType19 = jSTypeRegistry13.getForgivingType(staticScope14, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array20 = new com.google.javascript.rhino.jstype.JSType[] { jSType19 };
    com.google.javascript.rhino.jstype.FunctionType functionType21 = jSTypeRegistry1.createFunctionType(jSType11, jSType_array20);
    com.google.javascript.rhino.jstype.JSType jSType22 = functionType21.unboxesTo();
    java.lang.String str23 = functionType21.getReferenceName();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType24 = functionType21.getPrototype();
    com.google.javascript.rhino.jstype.JSType jSType25 = functionPrototypeType24.unboxesTo();
    com.google.javascript.rhino.jstype.FunctionType functionType26 = functionPrototypeType24.getOwnerFunction();
    java.lang.String str27 = functionPrototypeType24.toString();
    boolean b28 = functionPrototypeType24.hasCachedValues();
    boolean b29 = functionPrototypeType24.canBeCalled();
    boolean b30 = functionPrototypeType24.matchesStringContext();
    com.google.javascript.rhino.jstype.JSType jSType31 = null;
    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.rhino.jstype.JSType jSType32 = functionPrototypeType24.getLeastSupertype(jSType31);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str27 + "' != '" + "{...}"+ "'", str27.equals("{...}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);

  }

  @Test
  public void test209() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test209"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    boolean b3 = compilerOptions0.computeFunctionSideEffects;
    com.google.javascript.jscomp.CheckLevel checkLevel4 = compilerOptions0.checkMissingGetCssNameLevel;
    boolean b5 = compilerOptions0.flowSensitiveInlineVariables;
    boolean b6 = compilerOptions0.removeUnusedPrototypePropertiesInExterns;
    compilerOptions0.crossModuleCodeMotion = true;
    compilerOptions0.tightenTypes = true;
    java.lang.String str11 = compilerOptions0.sourceMapOutputPath;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str11);

  }

  @Test
  public void test210() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test210"); }


    com.google.javascript.rhino.JSDocInfo jSDocInfo0 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str1 = jSDocInfo0.getTemplateTypeName();
    boolean b2 = jSDocInfo0.hasEnumParameterType();
    boolean b3 = jSDocInfo0.isConstant();
    java.lang.String str4 = jSDocInfo0.toString();
    java.util.Set set5 = jSDocInfo0.getModifies();
    java.lang.String str6 = jSDocInfo0.getFileOverview();
    boolean b7 = jSDocInfo0.isNoCompile();
    boolean b8 = jSDocInfo0.isNoAlias();
    boolean b9 = jSDocInfo0.isNoAlias();
    boolean b10 = jSDocInfo0.isDefine();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str4 + "' != '" + "JSDocInfo"+ "'", str4.equals("JSDocInfo"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);

  }

  @Test
  public void test211() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test211"); }


    java.util.logging.Logger logger0 = null;
    com.google.javascript.jscomp.LoggerErrorManager loggerErrorManager1 = new com.google.javascript.jscomp.LoggerErrorManager(logger0);
    double d2 = loggerErrorManager1.getTypedPercent();
    com.google.javascript.jscomp.Compiler compiler3 = new com.google.javascript.jscomp.Compiler((com.google.javascript.jscomp.ErrorManager)loggerErrorManager1);
    com.google.javascript.jscomp.JSError[] jSError_array4 = loggerErrorManager1.getErrors();
    com.google.javascript.jscomp.JSError[] jSError_array5 = loggerErrorManager1.getWarnings();
    com.google.javascript.jscomp.Compiler compiler6 = new com.google.javascript.jscomp.Compiler((com.google.javascript.jscomp.ErrorManager)loggerErrorManager1);
    com.google.javascript.jscomp.PerformanceTracker performanceTracker7 = compiler6.tracker;
    // The following exception was thrown during execution in test generation
    try {
      compiler6.optimize();
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSError_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(performanceTracker7);

  }

  @Test
  public void test212() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test212"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    jSTypeRegistry1.forwardDeclareType("hi!");
    jSTypeRegistry1.setTemplateTypeName("EOF");
    com.google.javascript.rhino.jstype.JSType jSType10 = jSTypeRegistry1.createNamedType("", "EOF", 105, 126);
    com.google.javascript.rhino.jstype.StaticScope staticScope11 = null;
    com.google.javascript.rhino.jstype.JSType jSType16 = jSTypeRegistry1.getType(staticScope11, "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 148, 148);
    com.google.javascript.rhino.jstype.StaticScope staticScope17 = null;
    com.google.javascript.rhino.jstype.JSType jSType22 = jSTypeRegistry1.getForgivingType(staticScope17, "hi!", "", 23, 4095);
    com.google.javascript.rhino.jstype.ObjectType objectType23 = jSTypeRegistry1.createAnonymousObjectType();
    com.google.javascript.rhino.ErrorReporter errorReporter24 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry25 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter24);
    jSTypeRegistry25.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter28 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry29 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter28);
    com.google.javascript.rhino.jstype.StaticScope staticScope30 = null;
    com.google.javascript.rhino.jstype.JSType jSType35 = jSTypeRegistry29.getForgivingType(staticScope30, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter36 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry37 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter36);
    com.google.javascript.rhino.jstype.StaticScope staticScope38 = null;
    com.google.javascript.rhino.jstype.JSType jSType43 = jSTypeRegistry37.getForgivingType(staticScope38, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array44 = new com.google.javascript.rhino.jstype.JSType[] { jSType43 };
    com.google.javascript.rhino.jstype.FunctionType functionType45 = jSTypeRegistry25.createFunctionType(jSType35, jSType_array44);
    com.google.javascript.rhino.jstype.JSType jSType46 = functionType45.unboxesTo();
    java.lang.String str47 = functionType45.getReferenceName();
    com.google.javascript.rhino.jstype.FunctionPrototypeType functionPrototypeType48 = functionType45.getPrototype();
    com.google.javascript.rhino.jstype.JSType jSType49 = functionPrototypeType48.unboxesTo();
    com.google.javascript.rhino.jstype.JSType jSType50 = functionPrototypeType48.unboxesTo();
    com.google.javascript.rhino.jstype.FunctionType functionType51 = functionPrototypeType48.getOwnerFunction();
    com.google.javascript.rhino.jstype.JSType jSType52 = jSTypeRegistry1.createDefaultObjectUnion((com.google.javascript.rhino.jstype.JSType)functionPrototypeType48);
    boolean b53 = jSType52.matchesUint32Context();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(objectType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionPrototypeType48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b53 == true);

  }

  @Test
  public void test213() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test213"); }


    com.google.javascript.rhino.Node node2 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable3 = node2.getAncestors();
    com.google.javascript.rhino.Node node5 = new com.google.javascript.rhino.Node(0);
    boolean b6 = node2.hasChild(node5);
    com.google.javascript.rhino.Node node8 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str9 = node5.checkTreeEquals(node8);
    com.google.javascript.rhino.FunctionNode functionNode12 = new com.google.javascript.rhino.FunctionNode("");
    int i13 = functionNode12.getFunctionType();
    java.lang.String str14 = functionNode12.getFunctionName();
    boolean b15 = functionNode12.hasMoreThanOneChild();
    int i16 = functionNode12.getParamAndVarCount();
    int i17 = functionNode12.getFunctionType();
    com.google.javascript.rhino.Node node22 = new com.google.javascript.rhino.Node(54, 151, 76);
    com.google.javascript.rhino.Node node25 = new com.google.javascript.rhino.Node(0, node22, 90, 110);
    com.google.javascript.rhino.Node node26 = node22.detachFromParent();
    com.google.javascript.rhino.Node node30 = new com.google.javascript.rhino.Node(307, 0, 116);
    com.google.javascript.rhino.FunctionNode functionNode34 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.Node node36 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable37 = node36.getAncestors();
    com.google.javascript.rhino.Node node39 = new com.google.javascript.rhino.Node(0);
    boolean b40 = node36.hasChild(node39);
    node36.putBooleanProp(83, false);
    functionNode34.addChildrenToBack(node36);
    boolean b45 = functionNode34.hasOneChild();
    com.google.javascript.rhino.Node node48 = new com.google.javascript.rhino.Node(128, (com.google.javascript.rhino.Node)functionNode12, node22, node30, (com.google.javascript.rhino.Node)functionNode34, 82, 4);
    com.google.javascript.rhino.FunctionNode functionNode50 = new com.google.javascript.rhino.FunctionNode("");
    java.lang.String[] str_array51 = functionNode50.getParamAndVarNames();
    com.google.javascript.rhino.Node node52 = functionNode50.getFirstChild();
    functionNode50.addParam("JSDocInfo");
    boolean b56 = functionNode50.hasParamOrVar("function (hi!): hi!");
    com.google.javascript.rhino.Node node59 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable60 = node59.getAncestors();
    com.google.javascript.rhino.Node node62 = new com.google.javascript.rhino.Node(0);
    boolean b63 = node59.hasChild(node62);
    com.google.javascript.rhino.Node node65 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str66 = node62.checkTreeEquals(node65);
    com.google.javascript.rhino.Node node67 = node65.cloneNode();
    com.google.javascript.rhino.Node node69 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node node71 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable72 = node71.getAncestors();
    com.google.javascript.rhino.Node node74 = new com.google.javascript.rhino.Node(0);
    boolean b75 = node71.hasChild(node74);
    com.google.javascript.rhino.Node node77 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str78 = node74.checkTreeEquals(node77);
    com.google.javascript.rhino.Node node79 = node69.copyInformationFromForTree(node74);
    com.google.javascript.rhino.Node node82 = new com.google.javascript.rhino.Node(9, node65, node69, 29, 10);
    java.util.Set set83 = node69.getDirectives();
    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.rhino.Node node86 = new com.google.javascript.rhino.Node(19, node8, node22, (com.google.javascript.rhino.Node)functionNode50, node69, 120, 85);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str9 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str9.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i13 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str14 + "' != '" + ""+ "'", str14.equals(""));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i16 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i17 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b45 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(str_array51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(node52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b56 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b63 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str66 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str66.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b75 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str78 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str78.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(set83);

  }

  @Test
  public void test214() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test214"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.jstype.JSType jSType24 = functionType23.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter26 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry27 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter26);
    jSTypeRegistry27.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter30 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry31 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter30);
    com.google.javascript.rhino.jstype.StaticScope staticScope32 = null;
    com.google.javascript.rhino.jstype.JSType jSType37 = jSTypeRegistry31.getForgivingType(staticScope32, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array46 = new com.google.javascript.rhino.jstype.JSType[] { jSType45 };
    com.google.javascript.rhino.jstype.FunctionType functionType47 = jSTypeRegistry27.createFunctionType(jSType37, jSType_array46);
    com.google.javascript.rhino.jstype.FunctionType functionType48 = jSTypeRegistry1.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType23, false, jSType_array46);
    com.google.javascript.rhino.ErrorReporter errorReporter49 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry50 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter49);
    com.google.javascript.rhino.ErrorReporter errorReporter51 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry52 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter51);
    jSTypeRegistry52.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter55 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry56 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter55);
    com.google.javascript.rhino.jstype.StaticScope staticScope57 = null;
    com.google.javascript.rhino.jstype.JSType jSType62 = jSTypeRegistry56.getForgivingType(staticScope57, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array71 = new com.google.javascript.rhino.jstype.JSType[] { jSType70 };
    com.google.javascript.rhino.jstype.FunctionType functionType72 = jSTypeRegistry52.createFunctionType(jSType62, jSType_array71);
    com.google.javascript.rhino.Node node74 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable75 = node74.getAncestors();
    java.lang.String str76 = node74.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry50.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType72, node74);
    boolean b78 = functionType23.isSubtype((com.google.javascript.rhino.jstype.JSType)functionType72);
    com.google.javascript.rhino.ErrorReporter errorReporter79 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry80 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter79);
    com.google.javascript.rhino.jstype.StaticScope staticScope81 = null;
    com.google.javascript.rhino.jstype.JSType jSType86 = jSTypeRegistry80.getForgivingType(staticScope81, "hi!", "", 0, 1);
    boolean b87 = jSType86.isEnumType();
    boolean b88 = jSType86.isResolved();
    com.google.javascript.rhino.jstype.ObjectType objectType89 = jSType86.dereference();
    java.util.Set set90 = objectType89.getOwnPropertyNames();
    boolean b91 = functionType72.canAssignTo((com.google.javascript.rhino.jstype.JSType)objectType89);
    java.lang.String str92 = functionType72.getReferenceName();
    boolean b93 = functionType72.isNullType();
    com.google.javascript.rhino.Node node94 = functionType72.getParametersNode();
    com.google.javascript.rhino.Node node95 = node94.removeFirstChild();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str76 + "' != '" + "EOF"+ "'", str76.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b78 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b87 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(objectType89);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set90);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b91 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str92);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b93 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node94);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node95);

  }

  @Test
  public void test215() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test215"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression2 = null;
    boolean b3 = jSDocInfoBuilder1.recordTypedef(jSTypeExpression2);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression4 = null;
    boolean b6 = jSDocInfoBuilder1.recordThrowDescription(jSTypeExpression4, "hi!");
    boolean b7 = jSDocInfoBuilder1.isConstructorRecorded();
    boolean b8 = jSDocInfoBuilder1.recordNoTypeCheck();
    boolean b10 = jSDocInfoBuilder1.recordBlockDescription("and");
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);

  }

  @Test
  public void test216() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test216"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    compilerOptions0.setSummaryDetailLevel(86);
    compilerOptions0.setDefineToBooleanLiteral("hi!", false);
    boolean b8 = compilerOptions0.instrumentForCoverage;
    com.google.common.collect.Multimap multimap9 = null;
    compilerOptions0.customPasses = multimap9;
    boolean b11 = compilerOptions0.inferTypesInGlobalScope;
    com.google.javascript.jscomp.ErrorFormat errorFormat12 = compilerOptions0.errorFormat;
    boolean b13 = compilerOptions0.lineBreak;
    compilerOptions0.inferTypesInGlobalScope = false;
    compilerOptions0.smartNameRemoval = false;
    com.google.javascript.jscomp.CompilerOptions compilerOptions18 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions18.collapseVariableDeclarations = true;
    boolean b21 = compilerOptions18.inlineConstantVars;
    compilerOptions18.allowLegacyJsMessages = false;
    compilerOptions18.decomposeExpressions = true;
    compilerOptions18.gatherCssNames = false;
    com.google.javascript.jscomp.WarningsGuard warningsGuard28 = null;
    com.google.javascript.jscomp.WarningsGuard[] warningsGuard_array29 = new com.google.javascript.jscomp.WarningsGuard[] { warningsGuard28 };
    com.google.javascript.jscomp.ComposeWarningsGuard composeWarningsGuard30 = new com.google.javascript.jscomp.ComposeWarningsGuard(warningsGuard_array29);
    com.google.javascript.jscomp.ComposeWarningsGuard composeWarningsGuard31 = new com.google.javascript.jscomp.ComposeWarningsGuard(warningsGuard_array29);
    compilerOptions18.addWarningsGuard((com.google.javascript.jscomp.WarningsGuard)composeWarningsGuard31);
    compilerOptions0.addWarningsGuard((com.google.javascript.jscomp.WarningsGuard)composeWarningsGuard31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(errorFormat12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b21 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(warningsGuard_array29);

  }

  @Test
  public void test217() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test217"); }


    com.google.javascript.rhino.FunctionNode functionNode3 = new com.google.javascript.rhino.FunctionNode("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", 12, 124);
    com.google.javascript.rhino.Node node5 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable6 = node5.getAncestors();
    com.google.javascript.rhino.Node node8 = new com.google.javascript.rhino.Node(0);
    boolean b9 = node5.hasChild(node8);
    node5.putBooleanProp(83, false);
    functionNode3.addChildrenToBack(node5);
    functionNode3.setEndLineno(13);
    com.google.javascript.rhino.Node.FileLevelJsDocBuilder fileLevelJsDocBuilder16 = functionNode3.getJsDocBuilderForNode();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fileLevelJsDocBuilder16);

  }

  @Test
  public void test218() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test218"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.gatherCssNames;
    java.lang.String str2 = compilerOptions0.aliasableGlobals;
    boolean b3 = compilerOptions0.removeDeadCode;
    com.google.javascript.jscomp.MessageBundle messageBundle4 = compilerOptions0.messageBundle;
    compilerOptions0.disambiguateProperties = false;
    com.google.javascript.jscomp.CheckLevel checkLevel7 = compilerOptions0.checkUndefinedProperties;
    boolean b8 = compilerOptions0.markAsCompiled;
    compilerOptions0.flowSensitiveInlineVariables = true;
    com.google.javascript.jscomp.CheckLevel checkLevel11 = compilerOptions0.reportUnknownTypes;
    compilerOptions0.checkTypes = true;
    boolean b14 = compilerOptions0.coalesceVariableNames;
    java.lang.String str15 = compilerOptions0.sourceMapOutputPath;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(messageBundle4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str15);

  }

  @Test
  public void test219() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test219"); }


    com.google.javascript.rhino.Context context0 = new com.google.javascript.rhino.Context();
    com.google.javascript.rhino.ErrorReporter errorReporter1 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry2 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter1);
    com.google.javascript.rhino.jstype.JSType jSType7 = jSTypeRegistry2.createNamedType("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n", "", 301, 71);
    context0.seal((java.lang.Object)jSTypeRegistry2);
    java.util.Set set10 = jSTypeRegistry2.getTypesWithProperty("goog.exportProperty");
    com.google.javascript.rhino.ErrorReporter errorReporter11 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry12 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter11);
    jSTypeRegistry12.forwardDeclareType("hi!");
    java.util.Set set16 = jSTypeRegistry12.getTypesWithProperty("function (this:{1173631672}, {proxy:{1109466092}}): function ({proxy:{1995439683}}): {proxy:{130237813}}");
    jSTypeRegistry12.resetForTypeCheck();
    jSTypeRegistry12.setTemplateTypeName("goog.exportSymbol");
    com.google.javascript.rhino.ErrorReporter errorReporter20 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry21 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter20);
    jSTypeRegistry21.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter24 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry25 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter24);
    com.google.javascript.rhino.jstype.StaticScope staticScope26 = null;
    com.google.javascript.rhino.jstype.JSType jSType31 = jSTypeRegistry25.getForgivingType(staticScope26, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter32 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry33 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter32);
    com.google.javascript.rhino.jstype.StaticScope staticScope34 = null;
    com.google.javascript.rhino.jstype.JSType jSType39 = jSTypeRegistry33.getForgivingType(staticScope34, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array40 = new com.google.javascript.rhino.jstype.JSType[] { jSType39 };
    com.google.javascript.rhino.jstype.FunctionType functionType41 = jSTypeRegistry21.createFunctionType(jSType31, jSType_array40);
    java.lang.String str42 = functionType41.getReferenceName();
    java.util.Set set43 = functionType41.getOwnPropertyNames();
    com.google.javascript.rhino.jstype.ObjectType objectType44 = functionType41.getTypeOfThis();
    com.google.javascript.rhino.ErrorReporter errorReporter46 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry47 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter46);
    com.google.javascript.rhino.ErrorReporter errorReporter48 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry49 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter48);
    jSTypeRegistry49.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter52 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry53 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter52);
    com.google.javascript.rhino.jstype.StaticScope staticScope54 = null;
    com.google.javascript.rhino.jstype.JSType jSType59 = jSTypeRegistry53.getForgivingType(staticScope54, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter60 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry61 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter60);
    com.google.javascript.rhino.jstype.StaticScope staticScope62 = null;
    com.google.javascript.rhino.jstype.JSType jSType67 = jSTypeRegistry61.getForgivingType(staticScope62, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array68 = new com.google.javascript.rhino.jstype.JSType[] { jSType67 };
    com.google.javascript.rhino.jstype.FunctionType functionType69 = jSTypeRegistry49.createFunctionType(jSType59, jSType_array68);
    com.google.javascript.rhino.Node node71 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable72 = node71.getAncestors();
    java.lang.String str73 = node71.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType74 = jSTypeRegistry47.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType69, node71);
    jSTypeRegistry47.setLastGeneration(true);
    com.google.javascript.rhino.ErrorReporter errorReporter78 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry79 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter78);
    jSTypeRegistry79.forwardDeclareType("hi!");
    jSTypeRegistry79.setTemplateTypeName("EOF");
    com.google.javascript.rhino.jstype.JSType jSType88 = jSTypeRegistry79.createNamedType("", "EOF", 105, 126);
    com.google.javascript.rhino.jstype.JSType jSType90 = jSType88.findPropertyType("");
    boolean b91 = jSTypeRegistry47.declareType("", jSType88);
    com.google.javascript.rhino.jstype.JSType[] jSType_array92 = new com.google.javascript.rhino.jstype.JSType[] { jSType88 };
    com.google.javascript.rhino.jstype.FunctionType functionType93 = jSTypeRegistry12.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType41, true, jSType_array92);
    boolean b94 = functionType93.isResolved();
    boolean b95 = functionType93.isFunctionType();
    com.google.javascript.rhino.jstype.JSType jSType96 = jSTypeRegistry2.createDefaultObjectUnion((com.google.javascript.rhino.jstype.JSType)functionType93);
    boolean b97 = functionType93.isArrayType();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(objectType44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array68);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str73 + "' != '" + "EOF"+ "'", str73.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType74);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType88);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType90);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b91 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array92);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType93);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b94 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b95 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType96);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b97 == false);

  }

  @Test
  public void test220() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test220"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.jstype.JSType jSType24 = functionType23.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter26 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry27 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter26);
    jSTypeRegistry27.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter30 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry31 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter30);
    com.google.javascript.rhino.jstype.StaticScope staticScope32 = null;
    com.google.javascript.rhino.jstype.JSType jSType37 = jSTypeRegistry31.getForgivingType(staticScope32, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array46 = new com.google.javascript.rhino.jstype.JSType[] { jSType45 };
    com.google.javascript.rhino.jstype.FunctionType functionType47 = jSTypeRegistry27.createFunctionType(jSType37, jSType_array46);
    com.google.javascript.rhino.jstype.FunctionType functionType48 = jSTypeRegistry1.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType23, false, jSType_array46);
    com.google.javascript.rhino.ErrorReporter errorReporter49 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry50 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter49);
    com.google.javascript.rhino.ErrorReporter errorReporter51 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry52 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter51);
    jSTypeRegistry52.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter55 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry56 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter55);
    com.google.javascript.rhino.jstype.StaticScope staticScope57 = null;
    com.google.javascript.rhino.jstype.JSType jSType62 = jSTypeRegistry56.getForgivingType(staticScope57, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array71 = new com.google.javascript.rhino.jstype.JSType[] { jSType70 };
    com.google.javascript.rhino.jstype.FunctionType functionType72 = jSTypeRegistry52.createFunctionType(jSType62, jSType_array71);
    com.google.javascript.rhino.Node node74 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable75 = node74.getAncestors();
    java.lang.String str76 = node74.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry50.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType72, node74);
    functionType23.setPrototypeBasedOn((com.google.javascript.rhino.jstype.ObjectType)functionType77);
    com.google.javascript.rhino.JSDocInfo jSDocInfo79 = null;
    functionType23.setJSDocInfo(jSDocInfo79);
    boolean b81 = functionType23.isUnknownType();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str76 + "' != '" + "EOF"+ "'", str76.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b81 == false);

  }

  @Test
  public void test221() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test221"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.jstype.StaticScope staticScope2 = null;
    com.google.javascript.rhino.jstype.JSType jSType7 = jSTypeRegistry1.getForgivingType(staticScope2, "hi!", "", 0, 1);
    boolean b8 = jSType7.isEnumType();
    boolean b9 = jSType7.isResolved();
    com.google.javascript.rhino.jstype.ObjectType objectType10 = jSType7.dereference();
    com.google.javascript.rhino.jstype.JSType jSType11 = objectType10.getParameterType();
    boolean b13 = objectType10.hasOwnProperty("JSDocInfo");
    com.google.javascript.rhino.ErrorReporter errorReporter15 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry16 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter15);
    com.google.javascript.rhino.ErrorReporter errorReporter17 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry18 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter17);
    jSTypeRegistry18.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter21 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry22 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter21);
    com.google.javascript.rhino.jstype.StaticScope staticScope23 = null;
    com.google.javascript.rhino.jstype.JSType jSType28 = jSTypeRegistry22.getForgivingType(staticScope23, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter29 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry30 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter29);
    com.google.javascript.rhino.jstype.StaticScope staticScope31 = null;
    com.google.javascript.rhino.jstype.JSType jSType36 = jSTypeRegistry30.getForgivingType(staticScope31, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array37 = new com.google.javascript.rhino.jstype.JSType[] { jSType36 };
    com.google.javascript.rhino.jstype.FunctionType functionType38 = jSTypeRegistry18.createFunctionType(jSType28, jSType_array37);
    com.google.javascript.rhino.jstype.JSType jSType39 = functionType38.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter41 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry42 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter41);
    jSTypeRegistry42.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter45 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry46 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter45);
    com.google.javascript.rhino.jstype.StaticScope staticScope47 = null;
    com.google.javascript.rhino.jstype.JSType jSType52 = jSTypeRegistry46.getForgivingType(staticScope47, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter53 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry54 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter53);
    com.google.javascript.rhino.jstype.StaticScope staticScope55 = null;
    com.google.javascript.rhino.jstype.JSType jSType60 = jSTypeRegistry54.getForgivingType(staticScope55, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array61 = new com.google.javascript.rhino.jstype.JSType[] { jSType60 };
    com.google.javascript.rhino.jstype.FunctionType functionType62 = jSTypeRegistry42.createFunctionType(jSType52, jSType_array61);
    com.google.javascript.rhino.jstype.FunctionType functionType63 = jSTypeRegistry16.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType38, false, jSType_array61);
    com.google.javascript.rhino.ErrorReporter errorReporter64 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry65 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter64);
    com.google.javascript.rhino.ErrorReporter errorReporter66 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry67 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter66);
    jSTypeRegistry67.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter70 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry71 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter70);
    com.google.javascript.rhino.jstype.StaticScope staticScope72 = null;
    com.google.javascript.rhino.jstype.JSType jSType77 = jSTypeRegistry71.getForgivingType(staticScope72, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter78 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry79 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter78);
    com.google.javascript.rhino.jstype.StaticScope staticScope80 = null;
    com.google.javascript.rhino.jstype.JSType jSType85 = jSTypeRegistry79.getForgivingType(staticScope80, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array86 = new com.google.javascript.rhino.jstype.JSType[] { jSType85 };
    com.google.javascript.rhino.jstype.FunctionType functionType87 = jSTypeRegistry67.createFunctionType(jSType77, jSType_array86);
    com.google.javascript.rhino.Node node89 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable90 = node89.getAncestors();
    java.lang.String str91 = node89.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType92 = jSTypeRegistry65.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType87, node89);
    boolean b93 = functionType38.isSubtype((com.google.javascript.rhino.jstype.JSType)functionType87);
    boolean b95 = objectType10.defineInferredProperty("", (com.google.javascript.rhino.jstype.JSType)functionType38, true);
    boolean b96 = functionType38.hasReferenceName();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(objectType10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType87);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable90);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str91 + "' != '" + "EOF"+ "'", str91.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType92);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b93 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b95 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b96 == false);

  }

  @Test
  public void test222() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test222"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSDocInfo jSDocInfo3 = jSDocInfoBuilder1.build("");
    boolean b5 = jSDocInfoBuilder1.recordLends("EOF");
    boolean b7 = jSDocInfoBuilder1.recordBlockDescription("OFF");
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder9 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b11 = jSDocInfoBuilder9.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression12 = null;
    boolean b13 = jSDocInfoBuilder9.recordReturnType(jSTypeExpression12);
    boolean b14 = jSDocInfoBuilder9.recordHiddenness();
    boolean b15 = jSDocInfoBuilder9.recordConstructor();
    boolean b17 = jSDocInfoBuilder9.recordReturnDescription("Not declared as a type name");
    boolean b18 = jSDocInfoBuilder9.recordOverride();
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder20 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b22 = jSDocInfoBuilder20.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression23 = null;
    boolean b24 = jSDocInfoBuilder20.recordReturnType(jSTypeExpression23);
    com.google.javascript.rhino.Node node26 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable27 = node26.getAncestors();
    com.google.javascript.rhino.Node node29 = new com.google.javascript.rhino.Node(0);
    boolean b30 = node26.hasChild(node29);
    com.google.javascript.rhino.Node node32 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str33 = node29.checkTreeEquals(node32);
    com.google.javascript.rhino.Node node34 = node32.cloneNode();
    boolean b35 = node34.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression37 = new com.google.javascript.rhino.JSTypeExpression(node34, "<No stack trace available>");
    boolean b38 = jSDocInfoBuilder20.recordDefineType(jSTypeExpression37);
    boolean b39 = jSDocInfoBuilder9.recordType(jSTypeExpression37);
    boolean b40 = jSDocInfoBuilder1.recordTypedef(jSTypeExpression37);
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder42 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b44 = jSDocInfoBuilder42.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression46 = null;
    boolean b47 = jSDocInfoBuilder42.recordParameter("JSDocInfo", jSTypeExpression46);
    java.lang.Object obj48 = null;
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder50 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression51 = null;
    boolean b52 = jSDocInfoBuilder50.recordTypedef(jSTypeExpression51);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression53 = null;
    boolean b55 = jSDocInfoBuilder50.recordThrowDescription(jSTypeExpression53, "hi!");
    boolean b56 = jSDocInfoBuilder50.isConstructorRecorded();
    boolean b57 = jSDocInfoBuilder50.recordNoTypeCheck();
    boolean b58 = jSDocInfoBuilder50.isDescriptionRecorded();
    com.google.javascript.rhino.Node node60 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable61 = node60.getAncestors();
    com.google.javascript.rhino.Node node63 = new com.google.javascript.rhino.Node(0);
    boolean b64 = node60.hasChild(node63);
    com.google.javascript.rhino.Node node66 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str67 = node63.checkTreeEquals(node66);
    com.google.javascript.rhino.Node node68 = node66.cloneNode();
    boolean b69 = node68.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression71 = new com.google.javascript.rhino.JSTypeExpression(node68, "<No stack trace available>");
    boolean b72 = jSDocInfoBuilder50.recordBaseType(jSTypeExpression71);
    java.lang.RuntimeException runtimeException73 = com.google.javascript.rhino.ScriptRuntime.undefCallError(obj48, (java.lang.Object)jSDocInfoBuilder50);
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder75 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression76 = null;
    boolean b77 = jSDocInfoBuilder75.recordTypedef(jSTypeExpression76);
    boolean b79 = jSDocInfoBuilder75.recordBlockDescription("");
    com.google.javascript.rhino.Node node81 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable82 = node81.getAncestors();
    com.google.javascript.rhino.Node node84 = new com.google.javascript.rhino.Node(0);
    boolean b85 = node81.hasChild(node84);
    com.google.javascript.rhino.Node node87 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str88 = node84.checkTreeEquals(node87);
    com.google.javascript.rhino.Node node89 = node87.cloneNode();
    boolean b90 = node89.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression92 = new com.google.javascript.rhino.JSTypeExpression(node89, "<No stack trace available>");
    boolean b93 = jSDocInfoBuilder75.recordReturnType(jSTypeExpression92);
    boolean b94 = jSTypeExpression92.isOptionalArg();
    boolean b95 = jSDocInfoBuilder50.recordImplementedInterface(jSTypeExpression92);
    boolean b96 = jSDocInfoBuilder42.recordImplementedInterface(jSTypeExpression92);
    boolean b97 = jSDocInfoBuilder1.recordTypedef(jSTypeExpression92);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSDocInfo3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str33 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str33.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b39 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b47 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b52 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b55 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b56 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b57 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b58 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b64 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str67 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str67.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node68);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b69 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b72 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(runtimeException73);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b77 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b79 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b85 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node87);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str88 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str88.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node89);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b90 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b93 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b94 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b95 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b96 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b97 == false);

  }

  @Test
  public void test223() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test223"); }


    com.google.javascript.rhino.JSDocInfo jSDocInfo0 = new com.google.javascript.rhino.JSDocInfo();
    java.lang.String str1 = jSDocInfo0.getTemplateTypeName();
    boolean b2 = jSDocInfo0.hasEnumParameterType();
    boolean b3 = jSDocInfo0.isConstant();
    java.lang.String str4 = jSDocInfo0.toString();
    java.util.Set set5 = jSDocInfo0.getModifies();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression6 = jSDocInfo0.getReturnType();
    boolean b7 = jSDocInfo0.isNoTypeCheck();
    jSDocInfo0.setDeprecated(false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str4 + "' != '" + "JSDocInfo"+ "'", str4.equals("JSDocInfo"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSTypeExpression6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);

  }

  @Test
  public void test224() {}
// Defects4J: flaky method
//   @Test
//   public void test224() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test224"); }
// 
// 
//     com.google.javascript.jscomp.SourceFile.Generator generator1 = null;
//     com.google.javascript.jscomp.JSSourceFile jSSourceFile2 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator1);
//     com.google.javascript.jscomp.CompilerInput compilerInput3 = new com.google.javascript.jscomp.CompilerInput(jSSourceFile2);
//     boolean b4 = compilerInput3.isExtern();
//     com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list7 = jSModule6.getDependencies();
//     java.util.List list8 = jSModule6.getProvides();
//     compilerInput3.setModule(jSModule6);
//     java.lang.String str10 = jSModule6.getName();
//     java.util.Set set11 = jSModule6.getThisAndAllDependencies();
//     com.google.javascript.jscomp.SourceFile.Generator generator13 = null;
//     com.google.javascript.jscomp.JSSourceFile jSSourceFile14 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator13);
//     com.google.javascript.jscomp.CompilerInput compilerInput15 = new com.google.javascript.jscomp.CompilerInput(jSSourceFile14);
//     com.google.javascript.jscomp.ErrorFormat errorFormat16 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler17 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState18 = compiler17.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter20 = errorFormat16.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler17, true);
//     com.google.javascript.jscomp.JSModule jSModule22 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list23 = jSModule22.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback24 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler17, list23, callback24);
//     com.google.javascript.jscomp.ErrorManager errorManager26 = compiler17.getErrorManager();
//     com.google.javascript.jscomp.ErrorFormat errorFormat27 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler28 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState29 = compiler28.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter31 = errorFormat27.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler28, true);
//     com.google.javascript.jscomp.JSModule jSModule33 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list34 = jSModule33.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback35 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler28, list34, callback35);
//     com.google.javascript.jscomp.ErrorManager errorManager37 = compiler28.getErrorManager();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback38 = null;
//     com.google.javascript.jscomp.NodeTraversal nodeTraversal39 = new com.google.javascript.jscomp.NodeTraversal((com.google.javascript.jscomp.AbstractCompiler)compiler28, callback38);
//     com.google.javascript.jscomp.ErrorFormat errorFormat40 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler41 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState42 = compiler41.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter44 = errorFormat40.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler41, true);
//     com.google.javascript.jscomp.JSModule jSModule46 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list47 = jSModule46.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback48 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler41, list47, callback48);
//     com.google.javascript.jscomp.ErrorFormat errorFormat50 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler51 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState52 = compiler51.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter54 = errorFormat50.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler51, true);
//     com.google.javascript.jscomp.JSModule jSModule56 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list57 = jSModule56.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback58 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler51, list57, callback58);
//     com.google.javascript.jscomp.JSModuleGraph jSModuleGraph60 = new com.google.javascript.jscomp.JSModuleGraph(list57);
//     com.google.javascript.jscomp.CompilerOptions compilerOptions61 = new com.google.javascript.jscomp.CompilerOptions();
//     boolean b62 = compilerOptions61.smartNameRemoval;
//     compilerOptions61.groupVariableDeclarations = false;
//     compiler28.initModules(list47, list57, compilerOptions61);
//     com.google.javascript.jscomp.ErrorFormat errorFormat66 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler67 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState68 = compiler67.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter70 = errorFormat66.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler67, true);
//     com.google.javascript.jscomp.JSModule jSModule72 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list73 = jSModule72.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback74 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler67, list73, callback74);
//     com.google.javascript.jscomp.JSModuleGraph jSModuleGraph76 = new com.google.javascript.jscomp.JSModuleGraph(list73);
//     com.google.javascript.jscomp.CompilerOptions compilerOptions77 = new com.google.javascript.jscomp.CompilerOptions();
//     compilerOptions77.collapseVariableDeclarations = true;
//     boolean b80 = compilerOptions77.computeFunctionSideEffects;
//     compiler17.init(list57, list73, compilerOptions77);
//     compilerInput15.setCompiler((com.google.javascript.jscomp.AbstractCompiler)compiler17);
//     jSModule6.add(compilerInput15);
//     com.google.javascript.jscomp.CompilerInput compilerInput85 = new com.google.javascript.jscomp.CompilerInput((com.google.javascript.jscomp.SourceAst)compilerInput15, true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b4 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list7);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str10 + "' != '" + ""+ "'", str10.equals(""));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(set11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(jSSourceFile14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat16);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState18);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter20);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list23);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorManager26);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState29);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter31);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list34);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorManager37);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat40);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState42);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter44);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list47);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat50);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState52);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter54);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list57);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b62 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat66);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState68);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter70);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list73);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b80 == false);
// 
//   }

  @Test
  public void test225() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test225"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.gatherCssNames;
    com.google.javascript.jscomp.VariableRenamingPolicy variableRenamingPolicy2 = compilerOptions0.variableRenaming;
    boolean b3 = compilerOptions0.smartNameRemoval;
    com.google.javascript.jscomp.CheckLevel checkLevel4 = compilerOptions0.checkUndefinedProperties;
    compilerOptions0.aliasStringsBlacklist = "goog.exportProperty";
    compilerOptions0.disambiguateProperties = true;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(variableRenamingPolicy2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel4);

  }

  @Test
  public void test226() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test226"); }


    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder1 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression2 = null;
    boolean b3 = jSDocInfoBuilder1.recordTypedef(jSTypeExpression2);
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression4 = null;
    boolean b6 = jSDocInfoBuilder1.recordThrowDescription(jSTypeExpression4, "hi!");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression7 = null;
    boolean b8 = jSDocInfoBuilder1.recordThisType(jSTypeExpression7);
    boolean b10 = jSDocInfoBuilder1.recordMeaning("");
    com.google.javascript.rhino.JSDocInfoBuilder jSDocInfoBuilder12 = new com.google.javascript.rhino.JSDocInfoBuilder(true);
    boolean b14 = jSDocInfoBuilder12.recordVersion("JSDocInfo");
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression15 = null;
    boolean b16 = jSDocInfoBuilder12.recordReturnType(jSTypeExpression15);
    com.google.javascript.rhino.Node node18 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable19 = node18.getAncestors();
    com.google.javascript.rhino.Node node21 = new com.google.javascript.rhino.Node(0);
    boolean b22 = node18.hasChild(node21);
    com.google.javascript.rhino.Node node24 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str25 = node21.checkTreeEquals(node24);
    com.google.javascript.rhino.Node node26 = node24.cloneNode();
    boolean b27 = node26.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression29 = new com.google.javascript.rhino.JSTypeExpression(node26, "<No stack trace available>");
    boolean b30 = jSDocInfoBuilder12.recordDefineType(jSTypeExpression29);
    com.google.javascript.rhino.Node node32 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable33 = node32.getAncestors();
    com.google.javascript.rhino.Node node35 = new com.google.javascript.rhino.Node(0);
    boolean b36 = node32.hasChild(node35);
    com.google.javascript.rhino.Node node38 = com.google.javascript.jscomp.parsing.JsDocInfoParser.parseTypeString("hi!");
    java.lang.String str39 = node35.checkTreeEquals(node38);
    com.google.javascript.rhino.Node node40 = node38.cloneNode();
    boolean b41 = node40.hasSideEffects();
    com.google.javascript.rhino.JSTypeExpression jSTypeExpression43 = new com.google.javascript.rhino.JSTypeExpression(node40, "<No stack trace available>");
    boolean b44 = jSDocInfoBuilder12.recordType(jSTypeExpression43);
    boolean b45 = jSDocInfoBuilder1.recordType(jSTypeExpression43);
    com.google.javascript.rhino.JSDocInfo jSDocInfo47 = jSDocInfoBuilder1.build("Not declared as a constructor");
    boolean b50 = jSDocInfoBuilder1.recordParameterDescription("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n: WARNING - {0}\n", "error reporter");
    jSDocInfoBuilder1.markAnnotation("", 160, 53);
    boolean b55 = jSDocInfoBuilder1.recordNoCompile();
    boolean b56 = jSDocInfoBuilder1.recordExport();
    boolean b57 = jSDocInfoBuilder1.recordNoCompile();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str25 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str25.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str39 + "' != '" + "Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"+ "'", str39.equals("Node tree inequality:\nTree1:\nEOF\n\n\nTree2:\nBANG 0\n    STRING hi 0\n\n\nSubtree1: EOF\n\n\nSubtree2: BANG 0\n    STRING hi 0\n"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b45 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSDocInfo47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b50 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b55 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b56 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b57 == false);

  }

  @Test
  public void test227() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test227"); }


    com.google.javascript.jscomp.SourceFile.Generator generator1 = null;
    com.google.javascript.jscomp.JSSourceFile jSSourceFile2 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator1);
    com.google.javascript.jscomp.CompilerInput compilerInput3 = new com.google.javascript.jscomp.CompilerInput(jSSourceFile2);
    boolean b4 = compilerInput3.isExtern();
    com.google.javascript.jscomp.JSModule jSModule6 = new com.google.javascript.jscomp.JSModule("");
    java.util.List list7 = jSModule6.getDependencies();
    java.util.List list8 = jSModule6.getProvides();
    compilerInput3.setModule(jSModule6);
    java.lang.String str10 = jSModule6.getName();
    com.google.javascript.jscomp.CompilerInput compilerInput11 = null;
    // The following exception was thrown during execution in test generation
    try {
      jSModule6.add(compilerInput11);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSSourceFile2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(list8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str10 + "' != '" + ""+ "'", str10.equals(""));

  }

  @Test
  public void test228() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test228"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.gatherCssNames;
    java.lang.String str2 = compilerOptions0.aliasableGlobals;
    boolean b3 = compilerOptions0.removeDeadCode;
    com.google.javascript.jscomp.MessageBundle messageBundle4 = compilerOptions0.messageBundle;
    compilerOptions0.disambiguateProperties = false;
    com.google.javascript.jscomp.CheckLevel checkLevel7 = compilerOptions0.checkUndefinedProperties;
    boolean b8 = compilerOptions0.markAsCompiled;
    boolean b9 = compilerOptions0.inferTypesInGlobalScope;
    compilerOptions0.optimizeArgumentsArray = false;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(messageBundle4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);

  }

  @Test
  public void test229() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test229"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions0.collapseVariableDeclarations = true;
    boolean b3 = compilerOptions0.inlineConstantVars;
    com.google.javascript.jscomp.CheckLevel checkLevel4 = compilerOptions0.checkMethods;
    compilerOptions0.gatherCssNames = true;
    com.google.javascript.jscomp.CompilerOptions compilerOptions7 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions7.collapseVariableDeclarations = true;
    java.lang.String str10 = compilerOptions7.inputDelimiter;
    compilerOptions7.checkSymbols = false;
    com.google.javascript.jscomp.DiagnosticGroup diagnosticGroup13 = com.google.javascript.jscomp.DiagnosticGroups.ACCESS_CONTROLS;
    com.google.javascript.jscomp.CompilerOptions compilerOptions14 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b15 = compilerOptions14.smartNameRemoval;
    boolean b16 = compilerOptions14.reserveRawExports;
    com.google.javascript.jscomp.CheckLevel checkLevel17 = com.google.javascript.jscomp.CheckLevel.ERROR;
    compilerOptions14.checkMissingReturn = checkLevel17;
    compilerOptions7.setWarningLevel(diagnosticGroup13, checkLevel17);
    compilerOptions7.rewriteFunctionExpressions = true;
    com.google.javascript.jscomp.CompilerOptions compilerOptions22 = new com.google.javascript.jscomp.CompilerOptions();
    compilerOptions22.collapseVariableDeclarations = true;
    boolean b25 = compilerOptions22.inlineConstantVars;
    java.lang.String str26 = compilerOptions22.aliasableGlobals;
    com.google.javascript.jscomp.VariableRenamingPolicy variableRenamingPolicy27 = compilerOptions22.variableRenaming;
    compilerOptions22.foldConstants = false;
    com.google.javascript.jscomp.CompilerOptions compilerOptions30 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b31 = compilerOptions30.gatherCssNames;
    com.google.javascript.jscomp.VariableRenamingPolicy variableRenamingPolicy32 = compilerOptions30.variableRenaming;
    boolean b33 = compilerOptions30.smartNameRemoval;
    compilerOptions30.setSummaryDetailLevel(137);
    byte[] byte_array38 = new byte[] { (byte)100, (byte)0 };
    compilerOptions30.inputPropertyMapSerialized = byte_array38;
    compilerOptions22.inputPropertyMapSerialized = byte_array38;
    compilerOptions7.inputVariableMapSerialized = byte_array38;
    compilerOptions0.inputVariableMapSerialized = byte_array38;
    compilerOptions0.checkControlStructures = true;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str10 + "' != '" + "// Input %num%"+ "'", str10.equals("// Input %num%"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(diagnosticGroup13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(variableRenamingPolicy27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(variableRenamingPolicy32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(byte_array38);

  }

  @Test
  public void test230() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test230"); }


    com.google.javascript.jscomp.AbstractCompiler abstractCompiler0 = null;
    java.util.List list1 = null;
    com.google.javascript.jscomp.NodeTraversal.Callback callback2 = null;
    // The following exception was thrown during execution in test generation
    try {
      com.google.javascript.jscomp.NodeTraversal.traverseRoots(abstractCompiler0, list1, callback2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test231() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test231"); }


    com.google.javascript.jscomp.CompilerOptions compilerOptions0 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b1 = compilerOptions0.smartNameRemoval;
    boolean b2 = compilerOptions0.reserveRawExports;
    com.google.javascript.jscomp.CompilerOptions compilerOptions3 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b4 = compilerOptions3.gatherCssNames;
    java.lang.String str5 = compilerOptions3.aliasableGlobals;
    boolean b6 = compilerOptions3.removeDeadCode;
    com.google.javascript.jscomp.MessageBundle messageBundle7 = compilerOptions3.messageBundle;
    compilerOptions3.disambiguateProperties = false;
    com.google.javascript.jscomp.CheckLevel checkLevel10 = compilerOptions3.checkMethods;
    compilerOptions0.checkMethods = checkLevel10;
    java.lang.String str12 = compilerOptions0.reportPath;
    com.google.javascript.jscomp.CompilerOptions compilerOptions13 = new com.google.javascript.jscomp.CompilerOptions();
    boolean b14 = compilerOptions13.gatherCssNames;
    java.lang.String str15 = compilerOptions13.aliasableGlobals;
    com.google.javascript.jscomp.CheckLevel checkLevel16 = compilerOptions13.checkShadowVars;
    compilerOptions0.checkUndefinedProperties = checkLevel16;
    compilerOptions0.closurePass = false;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b1 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(messageBundle7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(checkLevel16);

  }

  @Test
  public void test232() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test232"); }


    // The following exception was thrown during execution in test generation
    try {
      java.lang.String str1 = com.google.javascript.rhino.ScriptRuntime.getMessage0("function (this:{1173631672}, {proxy:{1109466092}}): function ({proxy:{1995439683}}): {proxy:{130237813}}");
      org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException");
    } catch (java.lang.RuntimeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.RuntimeException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.RuntimeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test233() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test233"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.ErrorReporter errorReporter2 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry3 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter2);
    jSTypeRegistry3.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter6 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry7 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter6);
    com.google.javascript.rhino.jstype.StaticScope staticScope8 = null;
    com.google.javascript.rhino.jstype.JSType jSType13 = jSTypeRegistry7.getForgivingType(staticScope8, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array22 = new com.google.javascript.rhino.jstype.JSType[] { jSType21 };
    com.google.javascript.rhino.jstype.FunctionType functionType23 = jSTypeRegistry3.createFunctionType(jSType13, jSType_array22);
    com.google.javascript.rhino.jstype.JSType jSType24 = functionType23.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter26 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry27 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter26);
    jSTypeRegistry27.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter30 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry31 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter30);
    com.google.javascript.rhino.jstype.StaticScope staticScope32 = null;
    com.google.javascript.rhino.jstype.JSType jSType37 = jSTypeRegistry31.getForgivingType(staticScope32, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array46 = new com.google.javascript.rhino.jstype.JSType[] { jSType45 };
    com.google.javascript.rhino.jstype.FunctionType functionType47 = jSTypeRegistry27.createFunctionType(jSType37, jSType_array46);
    com.google.javascript.rhino.jstype.FunctionType functionType48 = jSTypeRegistry1.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType23, false, jSType_array46);
    com.google.javascript.rhino.ErrorReporter errorReporter49 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry50 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter49);
    com.google.javascript.rhino.ErrorReporter errorReporter51 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry52 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter51);
    jSTypeRegistry52.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter55 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry56 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter55);
    com.google.javascript.rhino.jstype.StaticScope staticScope57 = null;
    com.google.javascript.rhino.jstype.JSType jSType62 = jSTypeRegistry56.getForgivingType(staticScope57, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter63 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry64 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter63);
    com.google.javascript.rhino.jstype.StaticScope staticScope65 = null;
    com.google.javascript.rhino.jstype.JSType jSType70 = jSTypeRegistry64.getForgivingType(staticScope65, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array71 = new com.google.javascript.rhino.jstype.JSType[] { jSType70 };
    com.google.javascript.rhino.jstype.FunctionType functionType72 = jSTypeRegistry52.createFunctionType(jSType62, jSType_array71);
    com.google.javascript.rhino.Node node74 = new com.google.javascript.rhino.Node(0);
    com.google.javascript.rhino.Node.AncestorIterable ancestorIterable75 = node74.getAncestors();
    java.lang.String str76 = node74.toString();
    com.google.javascript.rhino.jstype.FunctionType functionType77 = jSTypeRegistry50.createFunctionType((com.google.javascript.rhino.jstype.JSType)functionType72, node74);
    functionType23.setPrototypeBasedOn((com.google.javascript.rhino.jstype.ObjectType)functionType77);
    com.google.javascript.rhino.jstype.JSType jSType79 = functionType23.restrictByNotNullOrUndefined();
    boolean b80 = functionType23.isArrayType();
    java.lang.String str81 = functionType23.getTemplateTypeName();
    com.google.javascript.rhino.Node node82 = functionType23.getParametersNode();
    java.util.Set set83 = functionType23.getPropertyNames();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(ancestorIterable75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str76 + "' != '" + "EOF"+ "'", str76.equals("EOF"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b80 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(str81);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(node82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(set83);

  }

  @Test
  public void test234() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest5.test234"); }


    com.google.javascript.rhino.ErrorReporter errorReporter0 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry1 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter0);
    com.google.javascript.rhino.jstype.StaticScope staticScope2 = null;
    com.google.javascript.rhino.jstype.JSType jSType7 = jSTypeRegistry1.getForgivingType(staticScope2, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter8 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry9 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter8);
    com.google.javascript.rhino.ErrorReporter errorReporter10 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry11 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter10);
    jSTypeRegistry11.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter14 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry15 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter14);
    com.google.javascript.rhino.jstype.StaticScope staticScope16 = null;
    com.google.javascript.rhino.jstype.JSType jSType21 = jSTypeRegistry15.getForgivingType(staticScope16, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter22 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry23 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter22);
    com.google.javascript.rhino.jstype.StaticScope staticScope24 = null;
    com.google.javascript.rhino.jstype.JSType jSType29 = jSTypeRegistry23.getForgivingType(staticScope24, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array30 = new com.google.javascript.rhino.jstype.JSType[] { jSType29 };
    com.google.javascript.rhino.jstype.FunctionType functionType31 = jSTypeRegistry11.createFunctionType(jSType21, jSType_array30);
    com.google.javascript.rhino.jstype.JSType jSType32 = functionType31.unboxesTo();
    com.google.javascript.rhino.ErrorReporter errorReporter34 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry35 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter34);
    jSTypeRegistry35.forwardDeclareType("hi!");
    com.google.javascript.rhino.ErrorReporter errorReporter38 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry39 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter38);
    com.google.javascript.rhino.jstype.StaticScope staticScope40 = null;
    com.google.javascript.rhino.jstype.JSType jSType45 = jSTypeRegistry39.getForgivingType(staticScope40, "hi!", "", 0, 1);
    com.google.javascript.rhino.ErrorReporter errorReporter46 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry47 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter46);
    com.google.javascript.rhino.jstype.StaticScope staticScope48 = null;
    com.google.javascript.rhino.jstype.JSType jSType53 = jSTypeRegistry47.getForgivingType(staticScope48, "hi!", "", 0, 1);
    com.google.javascript.rhino.jstype.JSType[] jSType_array54 = new com.google.javascript.rhino.jstype.JSType[] { jSType53 };
    com.google.javascript.rhino.jstype.FunctionType functionType55 = jSTypeRegistry35.createFunctionType(jSType45, jSType_array54);
    com.google.javascript.rhino.jstype.FunctionType functionType56 = jSTypeRegistry9.createConstructorType((com.google.javascript.rhino.jstype.JSType)functionType31, false, jSType_array54);
    com.google.javascript.rhino.ErrorReporter errorReporter57 = null;
    com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry58 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter57);
    com.google.javascript.rhino.jstype.StaticScope staticScope59 = null;
    com.google.javascript.rhino.jstype.JSType jSType64 = jSTypeRegistry58.getForgivingType(staticScope59, "hi!", "", 0, 1);
    boolean b65 = jSType64.isEnumType();
    boolean b66 = jSType64.isResolved();
    boolean b67 = jSType64.isEnumElementType();
    com.google.javascript.rhino.jstype.FunctionType functionType68 = jSTypeRegistry1.createFunctionTypeWithNewReturnType(functionType56, jSType64);
    com.google.javascript.rhino.Node node69 = functionType68.getSource();
    boolean b70 = functionType68.isInterface();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(jSType32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType_array54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(jSType64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b65 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b66 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b67 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(functionType68);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(node69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b70 == false);

  }

  @Test
  public void test235() {}
// Defects4J: flaky method
//   @Test
//   public void test235() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest5.test235"); }
// 
// 
//     com.google.javascript.jscomp.ErrorFormat errorFormat0 = com.google.javascript.jscomp.ErrorFormat.LEGACY;
//     com.google.javascript.jscomp.ErrorFormat errorFormat1 = com.google.javascript.jscomp.ErrorFormat.SOURCELESS;
//     com.google.javascript.jscomp.Compiler compiler2 = new com.google.javascript.jscomp.Compiler();
//     com.google.javascript.jscomp.Compiler.IntermediateState intermediateState3 = compiler2.getState();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter5 = errorFormat1.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler2, true);
//     com.google.javascript.jscomp.JSModule jSModule7 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list8 = jSModule7.getDependencies();
//     com.google.javascript.jscomp.NodeTraversal.Callback callback9 = null;
//     com.google.javascript.jscomp.NodeTraversal.traverseRoots((com.google.javascript.jscomp.AbstractCompiler)compiler2, list8, callback9);
//     com.google.javascript.jscomp.ErrorManager errorManager11 = compiler2.getErrorManager();
//     com.google.javascript.jscomp.MessageFormatter messageFormatter13 = errorFormat0.toFormatter((com.google.javascript.jscomp.SourceExcerptProvider)compiler2, false);
//     com.google.javascript.rhino.Node node14 = compiler2.getRoot();
//     com.google.javascript.jscomp.JSModule jSModule16 = new com.google.javascript.jscomp.JSModule("");
//     java.util.List list17 = jSModule16.getDependencies();
//     java.util.List list18 = jSModule16.getProvides();
//     com.google.javascript.jscomp.SourceFile.Generator generator20 = null;
//     com.google.javascript.jscomp.JSSourceFile jSSourceFile21 = com.google.javascript.jscomp.JSSourceFile.fromGenerator("", generator20);
//     com.google.javascript.jscomp.CompilerInput compilerInput22 = new com.google.javascript.jscomp.CompilerInput(jSSourceFile21);
//     jSModule16.add(jSSourceFile21);
//     com.google.javascript.jscomp.JSSourceFile jSSourceFile26 = com.google.javascript.jscomp.JSSourceFile.fromCode("", "<No stack trace available>: <No stack trace available>");
//     jSModule16.addFirst(jSSourceFile26);
//     com.google.javascript.rhino.Node node28 = compiler2.parse(jSSourceFile26);
//     com.google.javascript.jscomp.Result result29 = compiler2.getResult();
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry30 = compiler2.getTypeRegistry();
//     com.google.javascript.rhino.jstype.JSType jSType31 = null;
//     com.google.javascript.rhino.ErrorReporter errorReporter32 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry33 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter32);
//     jSTypeRegistry33.forwardDeclareType("hi!");
//     com.google.javascript.rhino.ErrorReporter errorReporter36 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry37 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter36);
//     com.google.javascript.rhino.jstype.StaticScope staticScope38 = null;
//     com.google.javascript.rhino.jstype.JSType jSType43 = jSTypeRegistry37.getForgivingType(staticScope38, "hi!", "", 0, 1);
//     com.google.javascript.rhino.ErrorReporter errorReporter44 = null;
//     com.google.javascript.rhino.jstype.JSTypeRegistry jSTypeRegistry45 = new com.google.javascript.rhino.jstype.JSTypeRegistry(errorReporter44);
//     com.google.javascript.rhino.jstype.StaticScope staticScope46 = null;
//     com.google.javascript.rhino.jstype.JSType jSType51 = jSTypeRegistry45.getForgivingType(staticScope46, "hi!", "", 0, 1);
//     com.google.javascript.rhino.jstype.JSType[] jSType_array52 = new com.google.javascript.rhino.jstype.JSType[] { jSType51 };
//     com.google.javascript.rhino.jstype.FunctionType functionType53 = jSTypeRegistry33.createFunctionType(jSType43, jSType_array52);
//     java.lang.String str54 = functionType53.getReferenceName();
//     boolean b56 = functionType53.isPropertyTypeInferred("JSDocInfo");
//     com.google.javascript.rhino.Node node57 = functionType53.getParametersNode();
//     node57.putIntProp(69, 106);
//     com.google.javascript.rhino.jstype.FunctionType functionType61 = jSTypeRegistry30.createFunctionType(jSType31, node57);
//     boolean b62 = functionType61.isOrdinaryFunction();
//     boolean b63 = functionType61.isConstructor();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(errorFormat1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(intermediateState3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(messageFormatter5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(list8);
//     
//     // Regr