
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class RegressionTest0 {

  public static boolean debug = false;

  @Test
  public void test001() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test001"); }


    byte byte2 = org.apache.commons.math3.util.MathUtils.copySign((byte)1, (byte)0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(byte2 == (byte)1);

  }

  @Test
  public void test002() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test002"); }


    java.lang.Throwable throwable0 = null;
    org.apache.commons.math3.exception.MathInternalError mathInternalError1 = new org.apache.commons.math3.exception.MathInternalError(throwable0);

  }

  @Test
  public void test003() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test003"); }


    org.apache.commons.math3.linear.AnyMatrix anyMatrix0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.checkSubMatrixIndex(anyMatrix0, 1, 10, 0, 0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test004() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test004"); }


    org.apache.commons.math3.FieldElement[] fieldElement_array2 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array3 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array2 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.BlockFieldMatrix blockFieldMatrix5 = new org.apache.commons.math3.linear.BlockFieldMatrix(0, 10, fieldElement_array_array3, false);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array3);

  }

  @Test
  public void test005() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test005"); }


    double d1 = org.apache.commons.math3.util.FastMath.sinh(100.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.3440585709080678E43d);

  }

  @Test
  public void test006() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test006"); }


    org.apache.commons.math3.FieldElement[] fieldElement_array0 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array1 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array0 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix3 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(fieldElement_array_array1, true);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array1);

  }

  @Test
  public void test007() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test007"); }


    java.util.Locale locale0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat1 = org.apache.commons.math3.linear.RealMatrixFormat.getInstance(locale0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test008() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test008"); }


    double d1 = org.apache.commons.math3.util.FastMath.signum(1.3440585709080678E43d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.0d);

  }

  @Test
  public void test009() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test009"); }


    org.apache.commons.math3.Field field0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement[][] fieldElement_array_array3 = org.apache.commons.math3.linear.BlockFieldMatrix.<org.apache.commons.math3.FieldElement>createBlocksLayout(field0, 0, 0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test010() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test010"); }


    org.apache.commons.math3.linear.FieldMatrix fieldMatrix0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix1 = org.apache.commons.math3.linear.MatrixUtils.bigFractionMatrixToRealMatrix(fieldMatrix0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test011() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test011"); }


    org.apache.commons.math3.linear.AnyMatrix anyMatrix0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.checkRowIndex(anyMatrix0, 0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test012() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test012"); }


    long long1 = org.apache.commons.math3.util.FastMath.abs((-1L));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long1 == 1L);

  }

  @Test
  public void test013() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test013"); }


    org.apache.commons.math3.linear.AnyMatrix anyMatrix0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.checkMatrixIndex(anyMatrix0, 1, 10);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test014() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test014"); }


    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.OpenMapRealMatrix openMapRealMatrix2 = new org.apache.commons.math3.linear.OpenMapRealMatrix((-1), 1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test015() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test015"); }


    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector1 = new org.apache.commons.math3.linear.ArrayRealVector((-1));
      org.junit.Assert.fail("Expected exception of type java.lang.NegativeArraySizeException");
    } catch (java.lang.NegativeArraySizeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NegativeArraySizeException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NegativeArraySizeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test016() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test016"); }


    org.apache.commons.math3.linear.RealMatrix realMatrix0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition1 = new org.apache.commons.math3.linear.EigenDecomposition(realMatrix0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test017() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test017"); }


    org.apache.commons.math3.linear.FieldMatrix fieldMatrix0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix1 = org.apache.commons.math3.linear.MatrixUtils.fractionMatrixToRealMatrix(fieldMatrix0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test018() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test018"); }


    double d1 = org.apache.commons.math3.util.FastMath.sqrt(10.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 3.1622776601683795d);

  }

  @Test
  public void test019() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test019"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array8 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array5, 1.3440585709080678E43d);
    double[] d_array10 = new double[] { 0.0d };
    double[] d_array12 = org.apache.commons.math3.util.MathArrays.copyOf(d_array10, 1);
    // The following exception was thrown during execution in test generation
    try {
      double d13 = org.apache.commons.math3.util.MathArrays.distanceInf(d_array8, d_array12);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);

  }

  @Test
  public void test020() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test020"); }


    java.text.NumberFormat numberFormat1 = null;
    java.text.ParsePosition parsePosition2 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number3 = org.apache.commons.math3.util.CompositeFormat.parseNumber("", numberFormat1, parsePosition2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test021() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test021"); }


    org.apache.commons.math3.Field field0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.BlockFieldMatrix blockFieldMatrix3 = new org.apache.commons.math3.linear.BlockFieldMatrix(field0, (-1), 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test022() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test022"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    int[] i_array2 = new int[] {  };
    int[] i_array5 = new int[] { 0, 10 };
    int[] i_array7 = org.apache.commons.math3.util.MathArrays.copyOf(i_array5, 10);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.checkSubMatrixIndex((org.apache.commons.math3.linear.AnyMatrix)array2DRowFieldMatrix1, i_array2, i_array7);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoDataException");
    } catch (org.apache.commons.math3.exception.NoDataException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NoDataException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoDataException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array7);

  }

  @Test
  public void test023() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test023"); }


    double d1 = org.apache.commons.math3.util.FastMath.sqrt(0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.0d);

  }

  @Test
  public void test024() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test024"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equals(1.3440585709080678E43d, 10.0d, 3.1622776601683795d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test025() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test025"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    int[] i_array2 = null;
    int[] i_array5 = new int[] { 0, 10 };
    int[] i_array7 = org.apache.commons.math3.util.MathArrays.copyOf(i_array5, 10);
    org.apache.commons.math3.FieldElement[] fieldElement_array8 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array9 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array8 };
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.copySubMatrix(i_array2, i_array7, fieldElement_array_array9);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException");
    } catch (org.apache.commons.math3.exception.NullArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NullArgumentException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array9);

  }

  @Test
  public void test026() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test026"); }


    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.distribution.NormalDistribution normalDistribution2 = new org.apache.commons.math3.distribution.NormalDistribution(1.0d, 0.0d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test027() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test027"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array10 = new double[] { 100.0d, 10.0d, 1.0d };
    // The following exception was thrown during execution in test generation
    try {
      double[] d_array11 = org.apache.commons.math3.util.MathArrays.ebeSubtract(d_array1, d_array10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array10);

  }

  @Test
  public void test028() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test028"); }


    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector0 = null;
    org.apache.commons.math3.linear.RealVector realVector1 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector0, realVector1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test029() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test029"); }


    double d2 = org.apache.commons.math3.util.FastMath.hypot(1.3440585709080678E43d, 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 1.3440585709080678E43d);

  }

  @Test
  public void test030() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test030"); }


    short s2 = org.apache.commons.math3.util.MathUtils.copySign((short)10, (short)10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(s2 == (short)10);

  }

  @Test
  public void test031() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test031"); }


    org.apache.commons.math3.FieldElement fieldElement0 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array1 = new org.apache.commons.math3.FieldElement[] { fieldElement0 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix2 = org.apache.commons.math3.linear.MatrixUtils.<org.apache.commons.math3.FieldElement>createFieldDiagonalMatrix(fieldElement_array1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array1);

  }

  @Test
  public void test032() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test032"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement4 = array2DRowFieldMatrix1.getTrace();
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test033() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test033"); }


    org.apache.commons.math3.Field field0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement[][] fieldElement_array_array3 = org.apache.commons.math3.linear.BlockFieldMatrix.<org.apache.commons.math3.FieldElement>createBlocksLayout(field0, 100, 1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test034() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test034"); }


    int[] i_array0 = null;
    // The following exception was thrown during execution in test generation
    try {
      int[] i_array1 = org.apache.commons.math3.util.MathArrays.copyOf(i_array0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test035() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test035"); }


    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector1 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test036() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test036"); }


    int i1 = org.apache.commons.math3.util.FastMath.abs((-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == 1);

  }

  @Test
  public void test037() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test037"); }


    double d2 = org.apache.commons.math3.util.FastMath.IEEEremainder(0.0d, 3.1622776601683795d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.0d);

  }

  @Test
  public void test038() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test038"); }


    float f1 = org.apache.commons.math3.util.FastMath.nextUp(0.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f1 == 1.4E-45f);

  }

  @Test
  public void test039() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test039"); }


    org.apache.commons.math3.Field field0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix3 = org.apache.commons.math3.linear.MatrixUtils.<org.apache.commons.math3.FieldElement>createFieldMatrix(field0, 0, 10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test040() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test040"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[] d_array5 = new double[] { 100.0d };
    double[] d_array9 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b10 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array5, d_array9);
    double[] d_array12 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array9, 1.3440585709080678E43d);
    // The following exception was thrown during execution in test generation
    try {
      double d13 = org.apache.commons.math3.util.MathArrays.linearCombination(d_array1, d_array12);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);

  }

  @Test
  public void test041() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test041"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.NoDataException noDataException1 = new org.apache.commons.math3.exception.NoDataException(localizable0);

  }

  @Test
  public void test042() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test042"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    int[] i_array2 = null;
    int[] i_array4 = new int[] { 100 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix5 = array2DRowFieldMatrix1.getSubMatrix(i_array2, i_array4);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException");
    } catch (org.apache.commons.math3.exception.NullArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NullArgumentException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array4);

  }

  @Test
  public void test043() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test043"); }


    double d1 = org.apache.commons.math3.util.FastMath.cos(100.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.8623188722876839d);

  }

  @Test
  public void test044() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test044"); }


    double d2 = org.apache.commons.math3.util.FastMath.hypot(10.0d, (-1.0d));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 10.04987562112089d);

  }

  @Test
  public void test045() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test045"); }


    int i1 = org.apache.commons.math3.util.FastMath.round(1.4E-45f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == 0);

  }

  @Test
  public void test046() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test046"); }


    java.lang.Number number1 = null;
    org.apache.commons.math3.exception.NumberIsTooLargeException numberIsTooLargeException3 = new org.apache.commons.math3.exception.NumberIsTooLargeException((java.lang.Number)(short)100, number1, false);
    boolean b4 = numberIsTooLargeException3.getBoundIsAllowed();
    java.lang.Number number5 = numberIsTooLargeException3.getMax();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(number5);

  }

  @Test
  public void test047() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test047"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    int[] i_array7 = new int[] { 0, 10 };
    int[] i_array9 = org.apache.commons.math3.util.MathArrays.copyOf(i_array7, 10);
    int[] i_array10 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix11 = array2DRowFieldMatrix1.getSubMatrix(i_array9, i_array10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException");
    } catch (org.apache.commons.math3.exception.NullArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NullArgumentException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array9);

  }

  @Test
  public void test048() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test048"); }


    double d3 = org.apache.commons.math3.util.MathUtils.reduce(0.0d, (-1.0d), 1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d3 == 0.0d);

  }

  @Test
  public void test049() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test049"); }


    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix2 = new org.apache.commons.math3.linear.BlockRealMatrix(0, (-1));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test050() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test050"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor5 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement6 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixPreservingVisitor5);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);

  }

  @Test
  public void test051() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test051"); }


    double d6 = org.apache.commons.math3.util.MathArrays.linearCombination(10.0d, 0.8623188722876839d, 0.0d, 10.04987562112089d, 3.1622776601683795d, 1.3440585709080678E43d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 4.2502863927404205E43d);

  }

  @Test
  public void test052() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test052"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.FieldElement[] fieldElement_array5 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array6 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array5 };
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setSubMatrix(fieldElement_array_array6, (-1), 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathIllegalStateException");
    } catch (org.apache.commons.math3.exception.MathIllegalStateException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathIllegalStateException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathIllegalStateException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array6);

  }

  @Test
  public void test053() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test053"); }


    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector0 = null;
    double[] d_array2 = new double[] { 100.0d };
    double[] d_array6 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b7 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array2, d_array6);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector8 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector0, d_array6);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);

  }

  @Test
  public void test054() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test054"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    int[] i_array5 = new int[] {  };
    int[] i_array6 = new int[] {  };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix7 = array2DRowFieldMatrix1.getSubMatrix(i_array5, i_array6);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoDataException");
    } catch (org.apache.commons.math3.exception.NoDataException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NoDataException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoDataException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array6);

  }

  @Test
  public void test055() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test055"); }


    org.apache.commons.math3.util.MathUtils.checkNotNull((java.lang.Object)10L);

  }

  @Test
  public void test056() {}
// Defects4J: flaky method
//   @Test
//   public void test056() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test056"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d3 = randomDataImpl0.nextUniform((-1.0d), 100.0d);
//     // The following exception was thrown during execution in test generation
//     try {
//       int i6 = randomDataImpl0.nextSecureInt(0, (-1));
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException");
//     } catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NumberIsTooLargeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == 79.44866013505964d);
// 
//   }

  @Test
  public void test057() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test057"); }


    double d1 = org.apache.commons.math3.util.FastMath.tanh(0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.0d);

  }

  @Test
  public void test058() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test058"); }


    java.util.Locale locale0 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.text.NumberFormat numberFormat1 = org.apache.commons.math3.util.CompositeFormat.getDefaultNumberFormat(locale0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test059() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test059"); }


    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix1 = org.apache.commons.math3.linear.MatrixUtils.createRealIdentityMatrix(0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test060() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test060"); }


    float f2 = org.apache.commons.math3.util.FastMath.min(0.0f, 100.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f2 == 0.0f);

  }

  @Test
  public void test061() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test061"); }


    boolean b2 = org.apache.commons.math3.util.Precision.equalsIncludingNaN(10.0f, 10.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);

  }

  @Test
  public void test062() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test062"); }


    long long1 = org.apache.commons.math3.util.FastMath.abs(0L);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long1 == 0L);

  }

  @Test
  public void test063() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test063"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVector realVector2 = array2DRowRealMatrix0.getRowVector((-1));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test064() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test064"); }


    int i2 = org.apache.commons.math3.util.FastMath.min(0, 100);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);

  }

  @Test
  public void test065() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test065"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.FieldElement fieldElement6 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array7 = new org.apache.commons.math3.FieldElement[] { fieldElement6 };
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setColumn(0, fieldElement_array7);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array7);

  }

  @Test
  public void test066() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test066"); }


    org.apache.commons.math3.FieldElement fieldElement0 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array1 = new org.apache.commons.math3.FieldElement[] { fieldElement0 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix2 = org.apache.commons.math3.linear.MatrixUtils.<org.apache.commons.math3.FieldElement>createRowFieldMatrix(fieldElement_array1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array1);

  }

  @Test
  public void test067() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test067"); }


    int i1 = org.apache.commons.math3.util.FastMath.getExponent(1.3622825063580968d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == 0);

  }

  @Test
  public void test068() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test068"); }


    double d1 = org.apache.commons.math3.util.FastMath.toRadians(10.04987562112089d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.1754034190044697d);

  }

  @Test
  public void test069() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test069"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix5 = array2DRowRealMatrix0.getSubMatrix((-1), 10, 1, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test070() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test070"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat1 = org.apache.commons.math3.linear.MatrixUtils.DEFAULT_FORMAT;
    java.text.NumberFormat numberFormat2 = realMatrixFormat1.getFormat();
    java.text.ParsePosition parsePosition3 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number4 = org.apache.commons.math3.util.CompositeFormat.parseNumber("hi!", numberFormat2, parsePosition3);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrixFormat1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat2);

  }

  @Test
  public void test071() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test071"); }


    java.lang.Integer[] i_array1 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array3 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException4 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array1, i_array3);
    java.lang.Integer[] i_array5 = multiDimensionMismatchException4.getExpectedDimensions();
    // The following exception was thrown during execution in test generation
    try {
      int i7 = multiDimensionMismatchException4.getWrongDimension(1);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array5);

  }

  @Test
  public void test072() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test072"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.checkRowIndex((org.apache.commons.math3.linear.AnyMatrix)array2DRowFieldMatrix1, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test073() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test073"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    java.lang.Object[] obj_array1 = null;
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException2 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, obj_array1);

  }

  @Test
  public void test074() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test074"); }


    long long2 = org.apache.commons.math3.util.MathUtils.copySign(1L, 100L);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long2 == 1L);

  }

  @Test
  public void test075() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test075"); }


    double d0 = org.apache.commons.math3.distribution.AbstractRealDistribution.SOLVER_DEFAULT_ABSOLUTE_ACCURACY;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d0 == 1.0E-6d);

  }

  @Test
  public void test076() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test076"); }


    double d1 = org.apache.commons.math3.util.FastMath.exp(54.444384793244126d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.414646020926698E23d);

  }

  @Test
  public void test077() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test077"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    java.lang.Double[] d_array18 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(d_array18, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector29 = arrayRealVector21.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    double d30 = arrayRealVector4.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector21);
    java.lang.Double[] d_array32 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(d_array32, 0, 0);
    java.lang.Double[] d_array39 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector42 = new org.apache.commons.math3.linear.ArrayRealVector(d_array39, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector43 = arrayRealVector35.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector42);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix44 = arrayRealVector4.outerProduct((org.apache.commons.math3.linear.RealVector)arrayRealVector42);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d30 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector43);

  }

  @Test
  public void test078() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test078"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.Field field4 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix5 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field4);
    boolean b7 = array2DRowFieldMatrix5.equals((java.lang.Object)(short)10);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix8 = array2DRowFieldMatrix1.add(array2DRowFieldMatrix5);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);

  }

  @Test
  public void test079() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test079"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix8 = array2DRowFieldMatrix1.getSubMatrix((-1), 100, 0, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test080() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test080"); }


    double d1 = org.apache.commons.math3.util.FastMath.tan(54.444384793244126d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.6931640502651133d);

  }

  @Test
  public void test081() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test081"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVector realVector3 = array2DRowRealMatrix0.getColumnVector((-1));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);

  }

  @Test
  public void test082() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test082"); }


    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix1 = org.apache.commons.math3.linear.MatrixUtils.createRealIdentityMatrix((-1));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test083() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test083"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equalsIncludingNaN(4.2502863927404205E43d, 1.6931640502651133d, (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test084() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test084"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.Field field5 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix6 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field5);
    boolean b8 = array2DRowFieldMatrix6.equals((java.lang.Object)(short)10);
    boolean b10 = array2DRowFieldMatrix6.equals((java.lang.Object)4.2502863927404205E43d);
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setColumnMatrix(0, (org.apache.commons.math3.linear.FieldMatrix)array2DRowFieldMatrix6);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);

  }

  @Test
  public void test085() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test085"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    boolean b2 = array2DRowRealMatrix0.isSquare();
    org.apache.commons.math3.linear.RealMatrixPreservingVisitor realMatrixPreservingVisitor3 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d8 = array2DRowRealMatrix0.walkInColumnOrder(realMatrixPreservingVisitor3, 100, 10, 0, (-1));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);

  }

  @Test
  public void test086() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test086"); }


    org.apache.commons.math3.exception.ZeroException zeroException0 = new org.apache.commons.math3.exception.ZeroException();

  }

  @Test
  public void test087() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test087"); }


    float f2 = org.apache.commons.math3.util.Precision.round(10.0f, 100);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((float)f2, Float.NaN, 0);

  }

  @Test
  public void test088() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test088"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor2 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d7 = array2DRowRealMatrix0.walkInOptimizedOrder(realMatrixChangingVisitor2, 0, 10, 10, 10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);

  }

  @Test
  public void test089() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test089"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.FieldElement fieldElement5 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array6 = new org.apache.commons.math3.FieldElement[] { fieldElement5 };
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setRow(100, fieldElement_array6);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array6);

  }

  @Test
  public void test090() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test090"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix1 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array2 = array2DRowRealMatrix1.getDataRef();
    boolean b3 = array2DRowRealMatrix1.isSquare();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix4 = array2DRowRealMatrix0.add((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);

  }

  @Test
  public void test091() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test091"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat0 = org.apache.commons.math3.linear.MatrixUtils.DEFAULT_FORMAT;
    java.text.NumberFormat numberFormat1 = realMatrixFormat0.getFormat();
    double[] d_array3 = new double[] { 0.0d };
    double[] d_array5 = org.apache.commons.math3.util.MathArrays.copyOf(d_array3, 1);
    double[][] d_array_array6 = new double[][] { d_array3 };
    org.apache.commons.math3.linear.RealMatrix realMatrix7 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array6);
    java.lang.StringBuffer stringBuffer8 = null;
    java.text.FieldPosition fieldPosition9 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.lang.StringBuffer stringBuffer10 = realMatrixFormat0.format(realMatrix7, stringBuffer8, fieldPosition9);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrixFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix7);

  }

  @Test
  public void test092() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test092"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    boolean b5 = array2DRowFieldMatrix1.isSquare();
    org.apache.commons.math3.FieldElement[] fieldElement_array10 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array11 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array10 };
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.copySubMatrix(1, 0, 10, 10, fieldElement_array_array11);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array11);

  }

  @Test
  public void test093() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test093"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    boolean b2 = array2DRowRealMatrix0.isSquare();
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor3 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d8 = array2DRowRealMatrix0.walkInOptimizedOrder(realMatrixChangingVisitor3, 1, (-1), 1, 1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);

  }

  @Test
  public void test094() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test094"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    java.lang.Double[] d_array5 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector8 = new org.apache.commons.math3.linear.ArrayRealVector(d_array5, 0, 0);
    java.lang.Double[] d_array12 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector15 = new org.apache.commons.math3.linear.ArrayRealVector(d_array12, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = arrayRealVector8.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector15);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector17 = arrayRealVector16.copy();
    java.lang.Double[] d_array19 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector22 = new org.apache.commons.math3.linear.ArrayRealVector(d_array19, 0, 0);
    java.lang.Double[] d_array26 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector29 = new org.apache.commons.math3.linear.ArrayRealVector(d_array26, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = arrayRealVector22.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector29);
    double d31 = arrayRealVector16.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector30);
    // The following exception was thrown during execution in test generation
    try {
      arrayRealVector2.setSubVector(10, (org.apache.commons.math3.linear.RealVector)arrayRealVector30);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d31 == 0.0d);

  }

  @Test
  public void test095() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test095"); }


    java.text.ParsePosition parsePosition1 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.util.CompositeFormat.parseAndIgnoreWhitespace("hi!", parsePosition1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test096() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test096"); }


    org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
    randomDataImpl0.reSeedSecure();
    // The following exception was thrown during execution in test generation
    try {
      randomDataImpl0.setSecureAlgorithm("hi!", "Array2DRowFieldMatrix{}");
      org.junit.Assert.fail("Expected exception of type java.security.NoSuchProviderException");
    } catch (java.security.NoSuchProviderException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.security.NoSuchProviderException")) {
        org.junit.Assert.fail("Expected exception of type java.security.NoSuchProviderException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test097() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test097"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    double[] d_array2 = null;
    // The following exception was thrown during execution in test generation
    try {
      double[] d_array3 = array2DRowRealMatrix0.preMultiply(d_array2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);

  }

  @Test
  public void test098() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test098"); }


    double[] d_array0 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d1 = org.apache.commons.math3.util.MathArrays.safeNorm(d_array0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test099() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test099"); }


    double[] d_array0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector1 = new org.apache.commons.math3.linear.ArrayRealVector(d_array0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test100() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test100"); }


    java.lang.Integer[] i_array1 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array3 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException4 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array1, i_array3);
    java.lang.Integer[] i_array5 = multiDimensionMismatchException4.getExpectedDimensions();
    // The following exception was thrown during execution in test generation
    try {
      int i7 = multiDimensionMismatchException4.getWrongDimension((-1));
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array5);

  }

  @Test
  public void test101() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test101"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix4 = array2DRowFieldMatrix1.createMatrix(100, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test102() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test102"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equalsIncludingNaN((-1.0f), (-1.0f), 100);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);

  }

  @Test
  public void test103() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test103"); }


    long long2 = org.apache.commons.math3.util.FastMath.max(10L, 0L);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long2 == 10L);

  }

  @Test
  public void test104() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test104"); }


    double d1 = org.apache.commons.math3.util.FastMath.sin(4.414646020926698E23d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.9956942709230656d);

  }

  @Test
  public void test105() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test105"); }


    double d1 = org.apache.commons.math3.util.FastMath.abs((-7.241149127564359d));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 7.241149127564359d);

  }

  @Test
  public void test106() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test106"); }


    double d1 = org.apache.commons.math3.util.FastMath.abs(54.444384793244126d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 54.444384793244126d);

  }

  @Test
  public void test107() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test107"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement7 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixPreservingVisitor2, (-1), 0, 0, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test108() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test108"); }


    double d1 = org.apache.commons.math3.util.FastMath.ulp(0.1754034190044697d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 2.7755575615628914E-17d);

  }

  @Test
  public void test109() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test109"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor1 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d6 = array2DRowRealMatrix0.walkInOptimizedOrder(realMatrixChangingVisitor1, 0, 1, 100, 1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test110() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test110"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector2, false);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVector realVector7 = arrayRealVector4.getSubVector(100, 1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);

  }

  @Test
  public void test111() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test111"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector2, false);
    int i5 = arrayRealVector4.getMaxIndex();
    org.apache.commons.math3.linear.RealVectorChangingVisitor realVectorChangingVisitor6 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d9 = arrayRealVector4.walkInOptimizedOrder(realVectorChangingVisitor6, (-1), 10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 0);

  }

  @Test
  public void test112() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test112"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    double[] d_array3 = new double[] { 0.0d };
    double[] d_array5 = org.apache.commons.math3.util.MathArrays.copyOf(d_array3, 1);
    double[][] d_array_array6 = new double[][] { d_array3 };
    org.apache.commons.math3.linear.RealMatrix realMatrix7 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array6);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix8 = array2DRowRealMatrix0.preMultiply(realMatrix7);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix7);

  }

  @Test
  public void test113() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test113"); }


    float f1 = org.apache.commons.math3.util.FastMath.nextUp((-1.0f));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f1 == (-0.99999994f));

  }

  @Test
  public void test114() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test114"); }


    double[] d_array0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix1 = org.apache.commons.math3.linear.MatrixUtils.createColumnRealMatrix(d_array0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException");
    } catch (org.apache.commons.math3.exception.NullArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NullArgumentException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test115() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test115"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix6 = array2DRowRealMatrix0.getSubMatrix((-1), (-1), 1, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);

  }

  @Test
  public void test116() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test116"); }


    org.apache.commons.math3.random.RandomGenerator randomGenerator0 = null;
    double[] d_array2 = new double[] { 100.0d };
    double[] d_array6 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b7 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array2, d_array6);
    double[] d_array9 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array6, 1.3440585709080678E43d);
    double[] d_array11 = new double[] { 0.0d };
    double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
    double[] d_array15 = new double[] { 100.0d };
    double[] d_array19 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b20 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array15, d_array19);
    boolean b21 = org.apache.commons.math3.util.MathArrays.equals(d_array11, d_array15);
    double[][] d_array_array22 = new double[][] { d_array15 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.distribution.MultivariateNormalDistribution multivariateNormalDistribution23 = new org.apache.commons.math3.distribution.MultivariateNormalDistribution(randomGenerator0, d_array6, d_array_array22);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b21 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array22);

  }

  @Test
  public void test117() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test117"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor6 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement7 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixChangingVisitor6);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);

  }

  @Test
  public void test118() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test118"); }


    double d2 = org.apache.commons.math3.util.FastMath.atan2(0.07277703352123166d, 0.1754034190044697d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.3932953321069236d);

  }

  @Test
  public void test119() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test119"); }


    org.apache.commons.math3.exception.MathInternalError mathInternalError0 = new org.apache.commons.math3.exception.MathInternalError();
    org.apache.commons.math3.exception.util.ExceptionContext exceptionContext1 = mathInternalError0.getContext();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(exceptionContext1);

  }

  @Test
  public void test120() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test120"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array22 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector25 = new org.apache.commons.math3.linear.ArrayRealVector(d_array22, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = arrayRealVector18.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector25);
    double d27 = arrayRealVector12.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector26);
    org.apache.commons.math3.linear.RealVectorPreservingVisitor realVectorPreservingVisitor28 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d31 = arrayRealVector26.walkInOptimizedOrder(realVectorPreservingVisitor28, 10, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 0.0d);

  }

  @Test
  public void test121() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test121"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor7 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement12 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixPreservingVisitor7, 0, 100, 10, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test122() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test122"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    int i2 = array2DRowRealMatrix0.getRowDimension();
    org.apache.commons.math3.linear.RealMatrixPreservingVisitor realMatrixPreservingVisitor3 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d4 = array2DRowRealMatrix0.walkInRowOrder(realMatrixPreservingVisitor3);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);

  }

  @Test
  public void test123() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test123"); }


    double d0 = org.apache.commons.math3.distribution.NormalDistribution.DEFAULT_INVERSE_ABSOLUTE_ACCURACY;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d0 == 1.0E-9d);

  }

  @Test
  public void test124() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test124"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat6 = org.apache.commons.math3.linear.MatrixUtils.DEFAULT_FORMAT;
    java.text.NumberFormat numberFormat7 = realMatrixFormat6.getFormat();
    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat8 = new org.apache.commons.math3.linear.RealMatrixFormat("", "", "Array2DRowFieldMatrix{}", "", "", "Array2DRowFieldMatrix{}", numberFormat7);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix10 = realMatrixFormat8.parse("hi!");
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathParseException");
    } catch (org.apache.commons.math3.exception.MathParseException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathParseException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathParseException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrixFormat6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat7);

  }

  @Test
  public void test125() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test125"); }


    double d2 = org.apache.commons.math3.util.FastMath.copySign(100.0d, 7.241149127564359d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 100.0d);

  }

  @Test
  public void test126() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test126"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor1 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d6 = array2DRowRealMatrix0.walkInColumnOrder(realMatrixChangingVisitor1, 10, 0, 0, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test127() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test127"); }


    double d1 = org.apache.commons.math3.util.FastMath.rint(0.8623188722876839d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.0d);

  }

  @Test
  public void test128() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test128"); }


    float f2 = org.apache.commons.math3.util.FastMath.scalb(1.4E-45f, 100);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f2 == 1.7763568E-15f);

  }

  @Test
  public void test129() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test129"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    org.apache.commons.math3.linear.RealMatrix realMatrix1 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix2 = array2DRowRealMatrix0.subtract(realMatrix1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test130() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test130"); }


    int i2 = org.apache.commons.math3.util.MathUtils.copySign((-1), 10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 1);

  }

  @Test
  public void test131() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test131"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.linear.FieldVector fieldVector5 = null;
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setColumnVector(100, fieldVector5);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test132() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test132"); }


    java.text.ParsePosition parsePosition2 = null;
    // The following exception was thrown during execution in test generation
    try {
      boolean b3 = org.apache.commons.math3.util.CompositeFormat.parseFixedstring("", "", parsePosition2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test133() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test133"); }


    org.apache.commons.math3.exception.NumberIsTooSmallException numberIsTooSmallException3 = new org.apache.commons.math3.exception.NumberIsTooSmallException((java.lang.Number)(-1.0d), (java.lang.Number)(-1.0f), false);
    boolean b4 = numberIsTooSmallException3.getBoundIsAllowed();
    org.apache.commons.math3.exception.MathInternalError mathInternalError5 = new org.apache.commons.math3.exception.MathInternalError((java.lang.Throwable)numberIsTooSmallException3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);

  }

  @Test
  public void test134() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test134"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor7 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement12 = array2DRowFieldMatrix1.walkInOptimizedOrder(fieldMatrixPreservingVisitor7, 100, 1, 10, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test135() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test135"); }


    float f1 = org.apache.commons.math3.util.FastMath.ulp(1.4E-45f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f1 == 1.4E-45f);

  }

  @Test
  public void test136() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test136"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array8 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array5, 1.3440585709080678E43d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.util.MathArrays.checkOrder(d_array5);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NonMonotonicSequenceException");
    } catch (org.apache.commons.math3.exception.NonMonotonicSequenceException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NonMonotonicSequenceException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NonMonotonicSequenceException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);

  }

  @Test
  public void test137() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test137"); }


    org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
    randomDataImpl0.reSeedSecure();
    randomDataImpl0.reSeed(100L);
    // The following exception was thrown during execution in test generation
    try {
      long long6 = randomDataImpl0.nextLong(0L, 0L);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException");
    } catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NumberIsTooLargeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test138() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test138"); }


    long long1 = org.apache.commons.math3.util.FastMath.round(49.41408584662507d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long1 == 49L);

  }

  @Test
  public void test139() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test139"); }


    org.apache.commons.math3.random.RandomGenerator randomGenerator0 = null;
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution4 = new org.apache.commons.math3.distribution.NormalDistribution(randomGenerator0, 54.444384793244126d, 54.444384793244126d, 0.1754034190044697d);
    double d5 = normalDistribution4.getNumericalMean();
    double d6 = normalDistribution4.getStandardDeviation();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 54.444384793244126d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 54.444384793244126d);

  }

  @Test
  public void test140() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test140"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    boolean b2 = array2DRowRealMatrix0.isSquare();
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix3 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array4 = array2DRowRealMatrix3.getDataRef();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix5 = array2DRowRealMatrix0.multiply((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix3);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array4);

  }

  @Test
  public void test141() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test141"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    double[] d_array18 = new double[] { 0.0d };
    double[] d_array20 = org.apache.commons.math3.util.MathArrays.copyOf(d_array18, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector16, d_array20);
    java.lang.Double[] d_array23 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = new org.apache.commons.math3.linear.ArrayRealVector(d_array23, 0, 0);
    java.lang.Double[] d_array28 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector31 = new org.apache.commons.math3.linear.ArrayRealVector(d_array28, 0, 0);
    java.lang.Double[] d_array33 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector(d_array33, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector37 = arrayRealVector31.append((org.apache.commons.math3.linear.RealVector)arrayRealVector36);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector38 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector26, arrayRealVector36);
    java.lang.Double[] d_array40 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector43 = new org.apache.commons.math3.linear.ArrayRealVector(d_array40, 0, 0);
    java.lang.Double[] d_array47 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector50 = new org.apache.commons.math3.linear.ArrayRealVector(d_array47, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = arrayRealVector43.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector50);
    double d52 = arrayRealVector26.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector43);
    org.apache.commons.math3.linear.RealVector realVector54 = arrayRealVector26.mapAdd(1.6931640502651133d);
    // The following exception was thrown during execution in test generation
    try {
      double d55 = arrayRealVector21.getL1Distance(realVector54);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d52 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector54);

  }

  @Test
  public void test142() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test142"); }


    double d2 = org.apache.commons.math3.util.MathUtils.normalizeAngle(0.0d, 4.414646020926698E23d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 4.414646020926698E23d);

  }

  @Test
  public void test143() {}
// Defects4J: flaky method
//   @Test
//   public void test143() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test143"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d3 = randomDataImpl0.nextUniform((-1.0d), 100.0d);
//     int[] i_array6 = randomDataImpl0.nextPermutation(10, 1);
//     org.apache.commons.math3.distribution.IntegerDistribution integerDistribution7 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       int i8 = randomDataImpl0.nextInversionDeviate(integerDistribution7);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == 93.11227448388838d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array6);
// 
//   }

  @Test
  public void test144() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test144"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array22 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector25 = new org.apache.commons.math3.linear.ArrayRealVector(d_array22, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = arrayRealVector18.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector25);
    double d27 = arrayRealVector12.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector26);
    java.lang.Double[] d_array29 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector32 = new org.apache.commons.math3.linear.ArrayRealVector(d_array29, 0, 0);
    java.lang.Double[] d_array34 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector37 = new org.apache.commons.math3.linear.ArrayRealVector(d_array34, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector38 = arrayRealVector32.append((org.apache.commons.math3.linear.RealVector)arrayRealVector37);
    // The following exception was thrown during execution in test generation
    try {
      double d39 = arrayRealVector12.cosine(realVector38);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException");
    } catch (org.apache.commons.math3.exception.MathArithmeticException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathArithmeticException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector38);

  }

  @Test
  public void test145() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test145"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    java.lang.Integer[] i_array2 = new java.lang.Integer[] { 10 };
    java.lang.Integer[] i_array4 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array6 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException7 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array4, i_array6);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException8 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(localizable0, i_array2, i_array4);
    // The following exception was thrown during execution in test generation
    try {
      int i10 = multiDimensionMismatchException8.getWrongDimension(10);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array6);

  }

  @Test
  public void test146() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test146"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix2 = array2DRowRealMatrix0.getRowMatrix(0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test147() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test147"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat7 = org.apache.commons.math3.linear.MatrixUtils.DEFAULT_FORMAT;
    java.text.NumberFormat numberFormat8 = realMatrixFormat7.getFormat();
    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat9 = new org.apache.commons.math3.linear.RealMatrixFormat("", "", "Array2DRowFieldMatrix{}", "", "", "Array2DRowFieldMatrix{}", numberFormat8);
    java.text.ParsePosition parsePosition10 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number11 = org.apache.commons.math3.util.CompositeFormat.parseNumber("Array2DRowFieldMatrix{}", numberFormat8, parsePosition10);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrixFormat7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat8);

  }

  @Test
  public void test148() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test148"); }


    double d1 = org.apache.commons.math3.util.FastMath.tan(0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.0d);

  }

  @Test
  public void test149() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test149"); }


    double d1 = org.apache.commons.math3.util.FastMath.signum(0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.0d);

  }

  @Test
  public void test150() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test150"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.util.Localizable localizable2 = null;
    double[] d_array5 = new double[] { 0.0d };
    double[] d_array7 = org.apache.commons.math3.util.MathArrays.copyOf(d_array5, 1);
    java.lang.Object[] obj_array8 = new java.lang.Object[] { d_array5 };
    org.apache.commons.math3.exception.MaxCountExceededException maxCountExceededException9 = new org.apache.commons.math3.exception.MaxCountExceededException(localizable2, (java.lang.Number)(byte)0, obj_array8);
    org.apache.commons.math3.exception.MaxCountExceededException maxCountExceededException10 = new org.apache.commons.math3.exception.MaxCountExceededException(localizable0, (java.lang.Number)(short)0, obj_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj_array8);

  }

  @Test
  public void test151() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test151"); }


    org.apache.commons.math3.FieldElement[] fieldElement_array0 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array1 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array0 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement[][] fieldElement_array_array2 = org.apache.commons.math3.linear.BlockFieldMatrix.<org.apache.commons.math3.FieldElement>toBlocksLayout(fieldElement_array_array1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array1);

  }

  @Test
  public void test152() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test152"); }


    int i0 = org.apache.commons.math3.linear.BlockRealMatrix.BLOCK_SIZE;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i0 == 52);

  }

  @Test
  public void test153() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test153"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.FieldElement fieldElement5 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array6 = new org.apache.commons.math3.FieldElement[] { fieldElement5 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement[] fieldElement_array7 = array2DRowFieldMatrix1.preMultiply(fieldElement_array6);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array6);

  }

  @Test
  public void test154() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test154"); }


    double[] d_array0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.util.MathArrays.checkOrder(d_array0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test155() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test155"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    java.lang.Double[] d_array14 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector15 = new org.apache.commons.math3.linear.ArrayRealVector(d_array14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector17 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector15, false);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = arrayRealVector11.ebeMultiply((org.apache.commons.math3.linear.RealVector)arrayRealVector15);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array14);

  }

  @Test
  public void test156() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test156"); }


    int[] i_array2 = new int[] { 0, 10 };
    int[] i_array4 = org.apache.commons.math3.util.MathArrays.copyOf(i_array2, 10);
    // The following exception was thrown during execution in test generation
    try {
      int[] i_array6 = org.apache.commons.math3.util.MathArrays.copyOf(i_array2, (-1));
      org.junit.Assert.fail("Expected exception of type java.lang.NegativeArraySizeException");
    } catch (java.lang.NegativeArraySizeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NegativeArraySizeException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NegativeArraySizeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array4);

  }

  @Test
  public void test157() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test157"); }


    java.util.Locale locale0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVectorFormat realVectorFormat1 = org.apache.commons.math3.linear.RealVectorFormat.getInstance(locale0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test158() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test158"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.FieldElement fieldElement7 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array8 = new org.apache.commons.math3.FieldElement[] { fieldElement7 };
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setRow(0, fieldElement_array8);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array8);

  }

  @Test
  public void test159() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test159"); }


    org.apache.commons.math3.linear.NonSquareMatrixException nonSquareMatrixException2 = new org.apache.commons.math3.linear.NonSquareMatrixException(100, 1);

  }

  @Test
  public void test160() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test160"); }


    double[] d_array0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[] d_array6 = new double[] { 100.0d };
    double[] d_array10 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b11 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array6, d_array10);
    boolean b12 = org.apache.commons.math3.util.MathArrays.equals(d_array2, d_array6);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array2, false);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector15 = new org.apache.commons.math3.linear.ArrayRealVector(d_array0, arrayRealVector14);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);

  }

  @Test
  public void test161() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test161"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    java.lang.Double[] d_array2 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector5 = new org.apache.commons.math3.linear.ArrayRealVector(d_array2, 0, 0);
    org.apache.commons.math3.exception.MathArithmeticException mathArithmeticException6 = new org.apache.commons.math3.exception.MathArithmeticException(localizable0, (java.lang.Object[])d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);

  }

  @Test
  public void test162() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test162"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[] d_array5 = new double[] { 100.0d };
    double[] d_array9 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b10 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array5, d_array9);
    boolean b11 = org.apache.commons.math3.util.MathArrays.equals(d_array1, d_array5);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array5, 52, 52);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException");
    } catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NumberIsTooLargeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);

  }

  @Test
  public void test163() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test163"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    double[] d_array18 = new double[] { 0.0d };
    double[] d_array20 = org.apache.commons.math3.util.MathArrays.copyOf(d_array18, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector16, d_array20);
    org.apache.commons.math3.analysis.UnivariateFunction univariateFunction22 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = arrayRealVector21.map(univariateFunction22);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);

  }

  @Test
  public void test164() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test164"); }


    float f1 = org.apache.commons.math3.util.FastMath.abs(Float.NaN);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((float)f1, Float.NaN, 0);

  }

  @Test
  public void test165() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test165"); }


    java.lang.Class clazz2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.exception.MathParseException mathParseException3 = new org.apache.commons.math3.exception.MathParseException("Array2DRowFieldMatrix{}", 0, clazz2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test166() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test166"); }


    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(10, 0.0d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVector realVector3 = arrayRealVector2.unitVector();
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException");
    } catch (org.apache.commons.math3.exception.MathArithmeticException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathArithmeticException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test167() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test167"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.linear.AnyMatrix anyMatrix7 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.checkSubtractionCompatible((org.apache.commons.math3.linear.AnyMatrix)array2DRowFieldMatrix1, anyMatrix7);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test168() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test168"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    boolean b5 = array2DRowFieldMatrix1.isSquare();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor6 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement7 = array2DRowFieldMatrix1.walkInRowOrder(fieldMatrixPreservingVisitor6);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);

  }

  @Test
  public void test169() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test169"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    java.lang.Double[] d_array18 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(d_array18, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector29 = arrayRealVector21.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    double d30 = arrayRealVector4.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector21);
    org.apache.commons.math3.linear.RealVectorPreservingVisitor realVectorPreservingVisitor31 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d34 = arrayRealVector21.walkInDefaultOrder(realVectorPreservingVisitor31, 1, 1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d30 == 0.0d);

  }

  @Test
  public void test170() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test170"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor5 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement10 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixPreservingVisitor5, 0, 0, 0, (-1));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);

  }

  @Test
  public void test171() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test171"); }


    double d1 = org.apache.commons.math3.util.FastMath.expm1(100.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 2.6881171418161356E43d);

  }

  @Test
  public void test172() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test172"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    boolean b2 = array2DRowRealMatrix0.isSquare();
    double[] d_array4 = new double[] { 100.0d };
    double[] d_array8 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b9 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array4, d_array8);
    // The following exception was thrown during execution in test generation
    try {
      double[] d_array10 = array2DRowRealMatrix0.operate(d_array4);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);

  }

  @Test
  public void test173() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test173"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix3 = array2DRowRealMatrix0.createMatrix(52, (-1));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test174() {}
// Defects4J: flaky method
//   @Test
//   public void test174() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test174"); }
// 
// 
//     org.apache.commons.math3.Field field0 = null;
//     org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl2 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d5 = randomDataImpl2.nextUniform((-1.0d), 100.0d);
//     int[] i_array8 = randomDataImpl2.nextPermutation(10, 1);
//     int[] i_array11 = new int[] { 0, 10 };
//     int[] i_array13 = org.apache.commons.math3.util.MathArrays.copyOf(i_array11, 10);
//     // The following exception was thrown during execution in test generation
//     try {
//       org.apache.commons.math3.linear.FieldMatrix fieldMatrix14 = array2DRowFieldMatrix1.getSubMatrix(i_array8, i_array13);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
//     } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d5 == 12.239641568454685d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array13);
// 
//   }

  @Test
  public void test175() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test175"); }


    org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
    randomDataImpl0.reSeedSecure();
    randomDataImpl0.reSeed(100L);
    // The following exception was thrown during execution in test generation
    try {
      double d7 = randomDataImpl0.nextUniform(10.0d, 1.3622825063580968d, false);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException");
    } catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NumberIsTooLargeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test176() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test176"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix1 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix2 = array2DRowRealMatrix0.add((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test177() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test177"); }


    java.text.ParsePosition parsePosition1 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.util.CompositeFormat.parseAndIgnoreWhitespace("Array2DRowFieldMatrix{}", parsePosition1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test178() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test178"); }


    org.apache.commons.math3.util.MathUtils.checkFinite(49.41408584662507d);

  }

  @Test
  public void test179() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test179"); }


    java.text.ParsePosition parsePosition1 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.util.CompositeFormat.parseAndIgnoreWhitespace("", parsePosition1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test180() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test180"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat0 = org.apache.commons.math3.linear.MatrixUtils.DEFAULT_FORMAT;
    java.text.NumberFormat numberFormat1 = realMatrixFormat0.getFormat();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix3 = realMatrixFormat0.parse("Array2DRowFieldMatrix{}");
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathParseException");
    } catch (org.apache.commons.math3.exception.MathParseException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathParseException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathParseException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrixFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat1);

  }

  @Test
  public void test181() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test181"); }


    double d1 = org.apache.commons.math3.util.FastMath.toRadians(2.6881171418161356E43d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.691649480399091E41d);

  }

  @Test
  public void test182() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test182"); }


    double d2 = org.apache.commons.math3.util.FastMath.nextAfter((-7.241149127564359d), 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == (-7.241149127564358d));

  }

  @Test
  public void test183() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test183"); }


    org.apache.commons.math3.exception.NumberIsTooSmallException numberIsTooSmallException3 = new org.apache.commons.math3.exception.NumberIsTooSmallException((java.lang.Number)(-1.0d), (java.lang.Number)(-1.0f), false);
    boolean b4 = numberIsTooSmallException3.getBoundIsAllowed();
    java.lang.Number number5 = numberIsTooSmallException3.getMin();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + number5 + "' != '" + (-1.0f)+ "'", number5.equals((-1.0f)));

  }

  @Test
  public void test184() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test184"); }


    org.apache.commons.math3.random.RandomGenerator randomGenerator0 = null;
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution4 = new org.apache.commons.math3.distribution.NormalDistribution(randomGenerator0, 54.444384793244126d, 54.444384793244126d, 0.1754034190044697d);
    double d5 = normalDistribution4.getSupportLowerBound();
    // The following exception was thrown during execution in test generation
    try {
      double d7 = normalDistribution4.inverseCumulativeProbability(49.41408584662507d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == Double.NEGATIVE_INFINITY);

  }

  @Test
  public void test185() {}
// Defects4J: flaky method
//   @Test
//   public void test185() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test185"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d3 = randomDataImpl0.nextUniform((-1.0d), 100.0d);
//     org.apache.commons.math3.distribution.IntegerDistribution integerDistribution4 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       int i5 = randomDataImpl0.nextInversionDeviate(integerDistribution4);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == 53.75471604402941d);
// 
//   }

  @Test
  public void test186() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test186"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.RealMatrixPreservingVisitor realMatrixPreservingVisitor10 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d11 = array2DRowRealMatrix9.walkInRowOrder(realMatrixPreservingVisitor10);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);

  }

  @Test
  public void test187() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test187"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix8 = array2DRowFieldMatrix1.getSubMatrix(0, 52, 100, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test188() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test188"); }


    double d2 = org.apache.commons.math3.util.FastMath.log(100.0d, Double.NEGATIVE_INFINITY);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d2, Double.NaN, 0);

  }

  @Test
  public void test189() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test189"); }


    org.apache.commons.math3.Field field0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix2 = org.apache.commons.math3.linear.MatrixUtils.<org.apache.commons.math3.FieldElement>createFieldIdentityMatrix(field0, 100);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test190() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test190"); }


    double d0 = org.apache.commons.math3.util.FastMath.PI;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d0 == 3.141592653589793d);

  }

  @Test
  public void test191() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test191"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    boolean b5 = array2DRowFieldMatrix1.isSquare();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix7 = array2DRowFieldMatrix1.getColumnMatrix(100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);

  }

  @Test
  public void test192() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test192"); }


    byte byte2 = org.apache.commons.math3.util.MathUtils.copySign((byte)0, (byte)1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(byte2 == (byte)0);

  }

  @Test
  public void test193() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test193"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    double d2 = well19937c1.nextDouble();
    long long3 = well19937c1.nextLong();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.07277703352123166d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long3 == 6179557979701623951L);

  }

  @Test
  public void test194() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test194"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.FieldElement[] fieldElement_array10 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array11 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array10 };
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.copySubMatrix(0, 10, 1, 52, fieldElement_array_array11);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array11);

  }

  @Test
  public void test195() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test195"); }


    double d1 = org.apache.commons.math3.util.FastMath.atanh((-1.0d));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == Double.NEGATIVE_INFINITY);

  }

  @Test
  public void test196() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test196"); }


    boolean b2 = org.apache.commons.math3.util.Precision.equalsIncludingNaN(10.0d, 0.8623188722876839d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);

  }

  @Test
  public void test197() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test197"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    boolean b5 = array2DRowFieldMatrix1.isSquare();
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor6 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement11 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixChangingVisitor6, (-1), 1, 52, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);

  }

  @Test
  public void test198() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test198"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array22 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector25 = new org.apache.commons.math3.linear.ArrayRealVector(d_array22, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = arrayRealVector18.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector25);
    double d27 = arrayRealVector12.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector26);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVector realVector30 = arrayRealVector12.getSubVector(52, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 0.0d);

  }

  @Test
  public void test199() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test199"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector2, false);
    org.apache.commons.math3.linear.RealVector realVector6 = arrayRealVector4.mapSubtract(10.04987562112089d);
    double[] d_array7 = arrayRealVector4.getDataRef();
    org.apache.commons.math3.linear.RealVectorPreservingVisitor realVectorPreservingVisitor8 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d11 = arrayRealVector4.walkInOptimizedOrder(realVectorPreservingVisitor8, 52, 1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);

  }

  @Test
  public void test200() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test200"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix12 = eigenDecomposition11.getSquareRoot();
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathUnsupportedOperationException");
    } catch (org.apache.commons.math3.exception.MathUnsupportedOperationException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathUnsupportedOperationException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathUnsupportedOperationException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);

  }

  @Test
  public void test201() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test201"); }


    org.apache.commons.math3.Field field0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix3 = org.apache.commons.math3.linear.MatrixUtils.<org.apache.commons.math3.FieldElement>createFieldMatrix(field0, 1, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test202() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test202"); }


    org.apache.commons.math3.util.MathUtils.checkFinite(4.2502863927404205E43d);

  }

  @Test
  public void test203() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test203"); }


    double d1 = org.apache.commons.math3.util.FastMath.asin((-7.241149127564359d));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d1, Double.NaN, 0);

  }

  @Test
  public void test204() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test204"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = array2DRowRealMatrix6.add(array2DRowRealMatrix7);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.linear.MatrixDimensionMismatchException");
    } catch (org.apache.commons.math3.linear.MatrixDimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.linear.MatrixDimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.linear.MatrixDimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);

  }

  @Test
  public void test205() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test205"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equalsIncludingNaN(0.0f, 0.0f, 10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);

  }

  @Test
  public void test206() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test206"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    boolean b2 = array2DRowRealMatrix0.isSquare();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix4 = org.apache.commons.math3.linear.MatrixUtils.blockInverse((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix0, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);

  }

  @Test
  public void test207() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test207"); }


    double d1 = org.apache.commons.math3.util.FastMath.cosh(0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.0d);

  }

  @Test
  public void test208() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test208"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector2, false);
    org.apache.commons.math3.linear.RealVector realVector6 = arrayRealVector4.mapSubtract(10.04987562112089d);
    double[] d_array7 = arrayRealVector4.getDataRef();
    // The following exception was thrown during execution in test generation
    try {
      arrayRealVector4.addToEntry(2147483647, (-1.0d));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);

  }

  @Test
  public void test209() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test209"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.FieldElement fieldElement4 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix5 = array2DRowFieldMatrix1.scalarMultiply(fieldElement4);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test210() {}
// Defects4J: flaky method
//   @Test
//   public void test210() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test210"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d3 = randomDataImpl0.nextUniform((-1.0d), 100.0d);
//     double d6 = randomDataImpl0.nextWeibull(10.0d, Double.NaN);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == 99.37864167209166d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertEquals((double)d6, Double.NaN, 0);
// 
//   }

  @Test
  public void test211() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test211"); }


    org.apache.commons.math3.FieldElement[] fieldElement_array0 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array1 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array0 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix2 = org.apache.commons.math3.linear.MatrixUtils.<org.apache.commons.math3.FieldElement>createFieldMatrix(fieldElement_array_array1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException");
    } catch (org.apache.commons.math3.exception.NullArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NullArgumentException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array1);

  }

  @Test
  public void test212() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test212"); }


    java.io.ObjectInputStream objectInputStream2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.deserializeRealMatrix((java.lang.Object)(byte)10, "Array2DRowFieldMatrix{}", objectInputStream2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test213() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test213"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    boolean b2 = array2DRowRealMatrix0.isSquare();
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor3 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d4 = array2DRowRealMatrix0.walkInOptimizedOrder(realMatrixChangingVisitor3);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);

  }

  @Test
  public void test214() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test214"); }


    double d1 = org.apache.commons.math3.util.FastMath.asinh(0.1754034190044697d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.17451622721454543d);

  }

  @Test
  public void test215() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test215"); }


    double d1 = org.apache.commons.math3.util.FastMath.expm1(0.1754034190044697d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.19172688492398912d);

  }

  @Test
  public void test216() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test216"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    org.apache.commons.math3.util.MathArrays.checkOrder(d_array1);
    double[] d_array9 = new double[] { 0.0d };
    double[] d_array11 = org.apache.commons.math3.util.MathArrays.copyOf(d_array9, 1);
    // The following exception was thrown during execution in test generation
    try {
      double d12 = org.apache.commons.math3.util.MathArrays.linearCombination(d_array1, d_array11);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);

  }

  @Test
  public void test217() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test217"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.FieldElement[] fieldElement_array9 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array10 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array9 };
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.copySubMatrix((-1), 10, 0, 52, fieldElement_array_array10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array10);

  }

  @Test
  public void test218() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test218"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor6 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement11 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixChangingVisitor6, 1, (-1), 0, 2147483647);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);

  }

  @Test
  public void test219() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test219"); }


    double d6 = org.apache.commons.math3.util.MathArrays.linearCombination(4.691649480399091E41d, 0.3932953321069236d, 1.0E-9d, 0.0d, (-1.0d), 90.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 1.845203840522836E41d);

  }

  @Test
  public void test220() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test220"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    java.lang.Double[] d_array4 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector5 = new org.apache.commons.math3.linear.ArrayRealVector(d_array4);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector7 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector5, false);
    int i8 = arrayRealVector7.getMaxIndex();
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix0.setRowVector(1, (org.apache.commons.math3.linear.RealVector)arrayRealVector7);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i8 == 0);

  }

  @Test
  public void test221() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test221"); }


    double d2 = org.apache.commons.math3.util.FastMath.hypot(0.0d, 1.3440585709080678E43d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 1.3440585709080678E43d);

  }

  @Test
  public void test222() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test222"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat0 = new org.apache.commons.math3.linear.RealMatrixFormat();
    java.text.ParsePosition parsePosition2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix3 = realMatrixFormat0.parse("", parsePosition2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test223() {}
// Defects4J: flaky method
//   @Test
//   public void test223() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test223"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d2 = randomDataImpl0.nextT(0.8623188722876839d);
//     java.io.ObjectInputStream objectInputStream4 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       org.apache.commons.math3.linear.MatrixUtils.deserializeRealMatrix((java.lang.Object)d2, "hi!", objectInputStream4);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d2 == (-1.064498166079961d));
// 
//   }

  @Test
  public void test224() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test224"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equals(1.845203840522836E41d, 10.04987562112089d, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test225() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test225"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor6 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement11 = array2DRowFieldMatrix1.walkInRowOrder(fieldMatrixChangingVisitor6, (-1), 10, 52, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);

  }

  @Test
  public void test226() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test226"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement7 = array2DRowFieldMatrix1.getEntry(100, 2147483647);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);

  }

  @Test
  public void test227() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test227"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    java.lang.Double[] d_array3 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector6 = new org.apache.commons.math3.linear.ArrayRealVector(d_array3, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    java.lang.Double[] d_array13 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector(d_array13, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector17 = arrayRealVector11.append((org.apache.commons.math3.linear.RealVector)arrayRealVector16);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector6, arrayRealVector16);
    double[] d_array20 = new double[] { 0.0d };
    double[] d_array22 = org.apache.commons.math3.util.MathArrays.copyOf(d_array20, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector18, d_array22);
    // The following exception was thrown during execution in test generation
    try {
      double[] d_array24 = array2DRowRealMatrix0.operate(d_array22);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);

  }

  @Test
  public void test228() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test228"); }


    double d1 = org.apache.commons.math3.util.FastMath.signum(3.1622776601683795d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.0d);

  }

  @Test
  public void test229() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test229"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.FieldElement fieldElement6 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix7 = array2DRowFieldMatrix1.scalarAdd(fieldElement6);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);

  }

  @Test
  public void test230() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test230"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    int[] i_array4 = new int[] { 0, 100 };
    int[] i_array7 = new int[] { 0, 10 };
    int[] i_array9 = org.apache.commons.math3.util.MathArrays.copyOf(i_array7, 10);
    int[] i_array10 = org.apache.commons.math3.util.MathArrays.copyOf(i_array9);
    double d11 = org.apache.commons.math3.util.MathArrays.distance(i_array4, i_array10);
    int[] i_array14 = new int[] { 0, 10 };
    int[] i_array16 = org.apache.commons.math3.util.MathArrays.copyOf(i_array14, 10);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix17 = array2DRowRealMatrix0.getSubMatrix(i_array10, i_array14);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d11 == 90.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array16);

  }

  @Test
  public void test231() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test231"); }


    org.apache.commons.math3.Field field0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix2 = org.apache.commons.math3.linear.MatrixUtils.<org.apache.commons.math3.FieldElement>createFieldIdentityMatrix(field0, 0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test232() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test232"); }


    org.apache.commons.math3.linear.RealMatrix realMatrix1 = org.apache.commons.math3.linear.MatrixUtils.createRealIdentityMatrix(100);
    java.lang.Double[] d_array3 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector6 = new org.apache.commons.math3.linear.ArrayRealVector(d_array3, 0, 0);
    java.lang.Double[] d_array10 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = new org.apache.commons.math3.linear.ArrayRealVector(d_array10, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = arrayRealVector6.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector13);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector15 = arrayRealVector14.copy();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.solveLowerTriangularSystem(realMatrix1, (org.apache.commons.math3.linear.RealVector)arrayRealVector14);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector15);

  }

  @Test
  public void test233() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test233"); }


    double d3 = org.apache.commons.math3.util.MathUtils.reduce(0.07277703352123166d, 7.241149127564359d, 10.04987562112089d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d3 == 4.505199667529061d);

  }

  @Test
  public void test234() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test234"); }


    double d1 = org.apache.commons.math3.util.FastMath.nextUp(0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.9E-324d);

  }

  @Test
  public void test235() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test235"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.analysis.UnivariateFunction univariateFunction13 = null;
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = arrayRealVector12.map(univariateFunction13);
    org.apache.commons.math3.linear.RealVector realVector15 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d16 = arrayRealVector12.dotProduct(realVector15);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector14);

  }

  @Test
  public void test236() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test236"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement[] fieldElement_array3 = array2DRowFieldMatrix1.getRow(10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test237() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test237"); }


    double d2 = org.apache.commons.math3.util.FastMath.atan2(2.6881171418161356E43d, 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 1.5707963267948966d);

  }

  @Test
  public void test238() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test238"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.RealMatrixPreservingVisitor realMatrixPreservingVisitor10 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d15 = array2DRowRealMatrix9.walkInOptimizedOrder(realMatrixPreservingVisitor10, 0, 0, 0, 2147483647);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);

  }

  @Test
  public void test239() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test239"); }


    double d1 = org.apache.commons.math3.util.FastMath.abs(2.6881171418161356E43d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 2.6881171418161356E43d);

  }

  @Test
  public void test240() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test240"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.FieldElement fieldElement5 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array6 = new org.apache.commons.math3.FieldElement[] { fieldElement5 };
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setColumn(10, fieldElement_array6);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array6);

  }

  @Test
  public void test241() {}
// Defects4J: flaky method
//   @Test
//   public void test241() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test241"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d3 = randomDataImpl0.nextUniform((-1.0d), 100.0d);
//     int[] i_array6 = randomDataImpl0.nextPermutation(10, 1);
//     // The following exception was thrown during execution in test generation
//     try {
//       int i9 = randomDataImpl0.nextBinomial(10, (-1.0d));
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
//     } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == 89.86279313410017d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array6);
// 
//   }

  @Test
  public void test242() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test242"); }


    double d1 = org.apache.commons.math3.util.FastMath.cbrt(100.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.641588833612779d);

  }

  @Test
  public void test243() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test243"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    java.lang.Number number3 = null;
    org.apache.commons.math3.exception.OutOfRangeException outOfRangeException4 = new org.apache.commons.math3.exception.OutOfRangeException(localizable0, (java.lang.Number)0.0d, (java.lang.Number)1.0f, number3);
    org.apache.commons.math3.exception.util.ExceptionContext exceptionContext5 = outOfRangeException4.getContext();
    java.lang.Number number6 = outOfRangeException4.getLo();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(exceptionContext5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + number6 + "' != '" + 1.0f+ "'", number6.equals(1.0f));

  }

  @Test
  public void test244() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test244"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    org.apache.commons.math3.linear.RealMatrixPreservingVisitor realMatrixPreservingVisitor13 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d18 = array2DRowRealMatrix9.walkInOptimizedOrder(realMatrixPreservingVisitor13, (-1), 100, 1, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));

  }

  @Test
  public void test245() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test245"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equalsIncludingNaN(4.9E-324d, Double.NaN, 4.414646020926698E23d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test246() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test246"); }


    double[] d_array0 = new double[] {  };
    double[] d_array2 = new double[] { 100.0d };
    double[] d_array6 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b7 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array2, d_array6);
    double d8 = org.apache.commons.math3.util.MathArrays.distance(d_array0, d_array6);
    double[] d_array9 = org.apache.commons.math3.util.MathArrays.copyOf(d_array0);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection10 = org.apache.commons.math3.util.MathArrays.OrderDirection.DECREASING;
    // The following exception was thrown during execution in test generation
    try {
      boolean b13 = org.apache.commons.math3.util.MathArrays.checkOrder(d_array0, orderDirection10, true, false);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection10);

  }

  @Test
  public void test247() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test247"); }


    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix2 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(0, (-1));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test248() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test248"); }


    org.apache.commons.math3.FieldElement[][] fieldElement_array_array0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix2 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(fieldElement_array_array0, false);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException");
    } catch (org.apache.commons.math3.exception.NullArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NullArgumentException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test249() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test249"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    org.apache.commons.math3.exception.util.Localizable localizable1 = null;
    double[] d_array3 = new double[] { 0.0d };
    double[] d_array5 = org.apache.commons.math3.util.MathArrays.copyOf(d_array3, 1);
    double[][] d_array_array6 = new double[][] { d_array3 };
    org.apache.commons.math3.linear.RealMatrix realMatrix7 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array6);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array6);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException9 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable1, (java.lang.Object[])d_array_array6);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix10 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array6);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix11 = array2DRowRealMatrix0.subtract(array2DRowRealMatrix10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.linear.MatrixDimensionMismatchException");
    } catch (org.apache.commons.math3.linear.MatrixDimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.linear.MatrixDimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.linear.MatrixDimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix7);

  }

  @Test
  public void test250() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test250"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equals(3.141592653589793d, (-1.0d), 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test251() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test251"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement7 = array2DRowFieldMatrix1.getEntry(10, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);

  }

  @Test
  public void test252() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test252"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    boolean b2 = array2DRowRealMatrix0.isSquare();
    org.apache.commons.math3.linear.RealMatrixPreservingVisitor realMatrixPreservingVisitor3 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d4 = array2DRowRealMatrix0.walkInRowOrder(realMatrixPreservingVisitor3);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);

  }

  @Test
  public void test253() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test253"); }


    double d2 = org.apache.commons.math3.util.FastMath.pow(Double.NaN, 2147483647);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d2, Double.NaN, 0);

  }

  @Test
  public void test254() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test254"); }


    int i2 = org.apache.commons.math3.util.FastMath.min(0, 52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);

  }

  @Test
  public void test255() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test255"); }


    org.apache.commons.math3.linear.RealVectorFormat realVectorFormat0 = org.apache.commons.math3.linear.RealVectorFormat.getInstance();
    java.lang.Double[] d_array2 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector5 = new org.apache.commons.math3.linear.ArrayRealVector(d_array2, 0, 0);
    java.lang.Double[] d_array9 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = new org.apache.commons.math3.linear.ArrayRealVector(d_array9, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector5.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector12);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = arrayRealVector13.copy();
    org.apache.commons.math3.linear.RealVector realVector16 = arrayRealVector13.mapDivide(49.41408584662507d);
    java.lang.StringBuffer stringBuffer17 = null;
    java.text.FieldPosition fieldPosition18 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.lang.StringBuffer stringBuffer19 = realVectorFormat0.format(realVector16, stringBuffer17, fieldPosition18);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVectorFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector16);

  }

  @Test
  public void test256() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test256"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    java.lang.Double[] d_array2 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector5 = new org.apache.commons.math3.linear.ArrayRealVector(d_array2, 0, 0);
    java.lang.Double[] d_array7 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector10 = new org.apache.commons.math3.linear.ArrayRealVector(d_array7, 0, 0);
    java.lang.Double[] d_array12 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector15 = new org.apache.commons.math3.linear.ArrayRealVector(d_array12, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector16 = arrayRealVector10.append((org.apache.commons.math3.linear.RealVector)arrayRealVector15);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector17 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector5, arrayRealVector15);
    double[] d_array19 = new double[] { 0.0d };
    double[] d_array21 = org.apache.commons.math3.util.MathArrays.copyOf(d_array19, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector22 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector17, d_array21);
    // The following exception was thrown during execution in test generation
    try {
      double[] d_array23 = array2DRowRealMatrix0.preMultiply(d_array21);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array21);

  }

  @Test
  public void test257() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test257"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    org.apache.commons.math3.FieldElement fieldElement7 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array8 = new org.apache.commons.math3.FieldElement[] { fieldElement7 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement[] fieldElement_array9 = array2DRowFieldMatrix1.preMultiply(fieldElement_array8);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array8);

  }

  @Test
  public void test258() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test258"); }


    float f1 = org.apache.commons.math3.util.FastMath.nextUp(1.7763568E-15f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f1 == 1.776357E-15f);

  }

  @Test
  public void test259() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test259"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    org.apache.commons.math3.Field field8 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix9 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field8);
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setColumnMatrix(52, (org.apache.commons.math3.linear.FieldMatrix)array2DRowFieldMatrix9);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);

  }

  @Test
  public void test260() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test260"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix8 = array2DRowFieldMatrix1.power(0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test261() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test261"); }


    double[][] d_array_array2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix4 = new org.apache.commons.math3.linear.BlockRealMatrix(0, 2147483647, d_array_array2, false);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test262() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test262"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.DimensionMismatchException dimensionMismatchException3 = new org.apache.commons.math3.exception.DimensionMismatchException(localizable0, 0, 0);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.util.MathUtils.checkNotNull((java.lang.Object)localizable0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException");
    } catch (org.apache.commons.math3.exception.NullArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NullArgumentException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test263() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test263"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    int i2 = array2DRowRealMatrix0.getRowDimension();
    org.apache.commons.math3.linear.RealMatrixPreservingVisitor realMatrixPreservingVisitor3 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d4 = array2DRowRealMatrix0.walkInRowOrder(realMatrixPreservingVisitor3);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);

  }

  @Test
  public void test264() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test264"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array8 = new double[] { 100.0d };
    double[] d_array12 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b13 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array8, d_array12);
    boolean b14 = org.apache.commons.math3.util.MathArrays.equals(d_array1, d_array12);
    double[] d_array15 = null;
    // The following exception was thrown during execution in test generation
    try {
      double[] d_array16 = org.apache.commons.math3.util.MathArrays.ebeSubtract(d_array12, d_array15);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);

  }

  @Test
  public void test265() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test265"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    boolean b2 = array2DRowRealMatrix0.isSquare();
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix3 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array4 = array2DRowRealMatrix3.getDataRef();
    int i5 = array2DRowRealMatrix3.getRowDimension();
    double[][] d_array_array6 = array2DRowRealMatrix3.getData();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix7 = array2DRowRealMatrix0.preMultiply((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix3);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array6);

  }

  @Test
  public void test266() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test266"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVector realVector14 = array2DRowRealMatrix9.getColumnVector(2147483647);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));

  }

  @Test
  public void test267() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test267"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.FieldElement fieldElement2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix3 = array2DRowFieldMatrix1.scalarAdd(fieldElement2);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test268() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test268"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array8 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array5, 1.3440585709080678E43d);
    double[] d_array10 = org.apache.commons.math3.util.MathArrays.copyOf(d_array5, 1);
    double[] d_array11 = new double[] {  };
    double[] d_array13 = new double[] { 100.0d };
    double[] d_array17 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b18 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array13, d_array17);
    double d19 = org.apache.commons.math3.util.MathArrays.distance(d_array11, d_array17);
    // The following exception was thrown during execution in test generation
    try {
      double[] d_array20 = org.apache.commons.math3.util.MathArrays.ebeAdd(d_array5, d_array11);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d19 == 0.0d);

  }

  @Test
  public void test269() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test269"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix9 = array2DRowRealMatrix6.createMatrix(0, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);

  }

  @Test
  public void test270() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test270"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    int i5 = arrayRealVector4.getDimension();
    double[] d_array6 = arrayRealVector4.toArray();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 52, 1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException");
    } catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NumberIsTooLargeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);

  }

  @Test
  public void test271() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test271"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[] d_array5 = new double[] { 100.0d };
    double[] d_array9 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b10 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array5, d_array9);
    boolean b11 = org.apache.commons.math3.util.MathArrays.equals(d_array1, d_array5);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, false);
    boolean b14 = arrayRealVector13.isNaN();
    java.lang.Double[] d_array16 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector19 = new org.apache.commons.math3.linear.ArrayRealVector(d_array16, 0, 0);
    java.lang.Double[] d_array23 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = new org.apache.commons.math3.linear.ArrayRealVector(d_array23, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = arrayRealVector19.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector26);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = arrayRealVector27.copy();
    java.lang.Double[] d_array30 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector33 = new org.apache.commons.math3.linear.ArrayRealVector(d_array30, 0, 0);
    java.lang.Double[] d_array35 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector38 = new org.apache.commons.math3.linear.ArrayRealVector(d_array35, 0, 0);
    java.lang.Double[] d_array40 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector43 = new org.apache.commons.math3.linear.ArrayRealVector(d_array40, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector44 = arrayRealVector38.append((org.apache.commons.math3.linear.RealVector)arrayRealVector43);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector45 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector33, arrayRealVector43);
    double[] d_array47 = new double[] { 0.0d };
    double[] d_array49 = org.apache.commons.math3.util.MathArrays.copyOf(d_array47, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector50 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector45, d_array49);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector28, arrayRealVector45);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector52 = arrayRealVector13.subtract((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array49);

  }

  @Test
  public void test272() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test272"); }


    java.text.ParsePosition parsePosition1 = null;
    // The following exception was thrown during execution in test generation
    try {
      char char2 = org.apache.commons.math3.util.CompositeFormat.parseNextCharacter("Array2DRowRealMatrix{{0.0}}", parsePosition1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test273() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test273"); }


    org.apache.commons.math3.exception.NoDataException noDataException0 = new org.apache.commons.math3.exception.NoDataException();

  }

  @Test
  public void test274() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test274"); }


    float f2 = org.apache.commons.math3.util.FastMath.scalb(1.776357E-15f, 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f2 == 3.552714E-15f);

  }

  @Test
  public void test275() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test275"); }


    byte byte2 = org.apache.commons.math3.util.MathUtils.copySign((byte)0, (byte)0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(byte2 == (byte)0);

  }

  @Test
  public void test276() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test276"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement3 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixPreservingVisitor2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test277() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test277"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.FieldElement fieldElement6 = null;
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.addToEntry((-1), 1, fieldElement6);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test278() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test278"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    int i2 = array2DRowRealMatrix0.getRowDimension();
    double[][] d_array_array3 = array2DRowRealMatrix0.getData();
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix4 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix5 = array2DRowRealMatrix0.multiply(array2DRowRealMatrix4);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoDataException");
    } catch (org.apache.commons.math3.exception.NoDataException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NoDataException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoDataException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array3);

  }

  @Test
  public void test279() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test279"); }


    double d1 = org.apache.commons.math3.util.FastMath.acosh(99.37864167209166d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 5.29205908405969d);

  }

  @Test
  public void test280() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test280"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equals(1.0E-9d, 0.9956942709230656d, 2964.191035514832d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);

  }

  @Test
  public void test281() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test281"); }


    int i2 = org.apache.commons.math3.util.MathUtils.copySign((-1), 52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 1);

  }

  @Test
  public void test282() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test282"); }


    float f1 = org.apache.commons.math3.util.FastMath.signum(0.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f1 == 0.0f);

  }

  @Test
  public void test283() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test283"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    double d14 = array2DRowRealMatrix9.getFrobeniusNorm();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector17 = new org.apache.commons.math3.linear.ArrayRealVector(10, 0.0d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.solveUpperTriangularSystem((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, (org.apache.commons.math3.linear.RealVector)arrayRealVector17);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 0.0d);

  }

  @Test
  public void test284() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test284"); }


    org.apache.commons.math3.linear.RealVectorFormat realVectorFormat0 = org.apache.commons.math3.linear.RealVectorFormat.getInstance();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = realVectorFormat0.parse("hi!");
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathParseException");
    } catch (org.apache.commons.math3.exception.MathParseException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathParseException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathParseException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVectorFormat0);

  }

  @Test
  public void test285() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test285"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    int i5 = arrayRealVector4.getDimension();
    double[] d_array6 = arrayRealVector4.toArray();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector7 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector4);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVector realVector10 = arrayRealVector7.getSubVector(10, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);

  }

  @Test
  public void test286() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test286"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix9.addToEntry(10, 10, 4.9E-324d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);

  }

  @Test
  public void test287() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test287"); }


    double d1 = org.apache.commons.math3.util.FastMath.atanh(0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.0d);

  }

  @Test
  public void test288() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test288"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array22 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector25 = new org.apache.commons.math3.linear.ArrayRealVector(d_array22, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = arrayRealVector18.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector25);
    double d27 = arrayRealVector12.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector26);
    java.lang.Double[] d_array29 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector32 = new org.apache.commons.math3.linear.ArrayRealVector(d_array29, 0, 0);
    java.lang.Double[] d_array34 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector37 = new org.apache.commons.math3.linear.ArrayRealVector(d_array34, 0, 0);
    java.lang.Double[] d_array39 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector42 = new org.apache.commons.math3.linear.ArrayRealVector(d_array39, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector43 = arrayRealVector37.append((org.apache.commons.math3.linear.RealVector)arrayRealVector42);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector44 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector32, arrayRealVector42);
    java.lang.Double[] d_array46 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector49 = new org.apache.commons.math3.linear.ArrayRealVector(d_array46, 0, 0);
    java.lang.Double[] d_array53 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector56 = new org.apache.commons.math3.linear.ArrayRealVector(d_array53, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector57 = arrayRealVector49.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector56);
    double d58 = arrayRealVector32.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector49);
    org.apache.commons.math3.linear.RealVector realVector60 = arrayRealVector32.mapAdd(1.6931640502651133d);
    double d61 = arrayRealVector32.getNorm();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector62 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, arrayRealVector32);
    org.apache.commons.math3.linear.RealVectorChangingVisitor realVectorChangingVisitor63 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d64 = arrayRealVector26.walkInOptimizedOrder(realVectorChangingVisitor63);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d58 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d61 == 0.0d);

  }

  @Test
  public void test289() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test289"); }


    org.apache.commons.math3.linear.RealMatrix realMatrix2 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(10, 100);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix2);

  }

  @Test
  public void test290() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test290"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor4 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement5 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixPreservingVisitor4);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test291() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test291"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    int i2 = array2DRowRealMatrix0.getRowDimension();
    // The following exception was thrown during execution in test generation
    try {
      double d5 = array2DRowRealMatrix0.getEntry(52, 2147483647);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);

  }

  @Test
  public void test292() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test292"); }


    boolean b2 = org.apache.commons.math3.util.Precision.equals(4.505199667529061d, 1.5707963267948966d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);

  }

  @Test
  public void test293() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test293"); }


    float f2 = org.apache.commons.math3.util.FastMath.scalb(100.0f, (-1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f2 == 50.0f);

  }

  @Test
  public void test294() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test294"); }


    boolean b2 = org.apache.commons.math3.util.Precision.equals(10.04987562112089d, 0.07277703352123166d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);

  }

  @Test
  public void test295() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test295"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix2 = array2DRowRealMatrix0.scalarMultiply(0.0d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test296() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test296"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor2 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d3 = array2DRowRealMatrix0.walkInColumnOrder(realMatrixChangingVisitor2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);

  }

  @Test
  public void test297() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test297"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array8 = new double[] { 100.0d };
    double[] d_array12 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b13 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array8, d_array12);
    boolean b14 = org.apache.commons.math3.util.MathArrays.equals(d_array1, d_array12);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.util.MathArrays.checkPositive(d_array12);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);

  }

  @Test
  public void test298() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test298"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.Field field3 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix4 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field3);
    boolean b6 = array2DRowFieldMatrix4.equals((java.lang.Object)(short)10);
    int i7 = array2DRowFieldMatrix4.getRowDimension();
    boolean b8 = array2DRowFieldMatrix4.isSquare();
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setColumnMatrix(100, (org.apache.commons.math3.linear.FieldMatrix)array2DRowFieldMatrix4);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);

  }

  @Test
  public void test299() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test299"); }


    double d2 = org.apache.commons.math3.util.FastMath.nextAfter(3.1622776601683795d, 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 3.162277660168379d);

  }

  @Test
  public void test300() {}
// Defects4J: flaky method
//   @Test
//   public void test300() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test300"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d3 = randomDataImpl0.nextUniform((-1.0d), 100.0d);
//     // The following exception was thrown during execution in test generation
//     try {
//       double d5 = randomDataImpl0.nextT((-7.241149127564359d));
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
//     } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == (-0.04632002356741771d));
// 
//   }

  @Test
  public void test301() {}
// Defects4J: flaky method
//   @Test
//   public void test301() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test301"); }
// 
// 
//     double d0 = org.apache.commons.math3.util.FastMath.random();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d0 == 0.6892682844514348d);
// 
//   }

  @Test
  public void test302() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test302"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    int i3 = well19937c1.nextInt(2147483647);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i3 == 156287497);

  }

  @Test
  public void test303() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test303"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.linear.FieldVector fieldVector3 = null;
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setColumnVector(52, fieldVector3);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test304() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test304"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    double d14 = array2DRowRealMatrix9.getFrobeniusNorm();
    java.lang.String str15 = array2DRowRealMatrix9.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str15 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str15.equals("Array2DRowRealMatrix{{0.0}}"));

  }

  @Test
  public void test305() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test305"); }


    double d2 = org.apache.commons.math3.util.FastMath.nextAfter(4.505199667529061d, 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 4.50519966752906d);

  }

  @Test
  public void test306() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test306"); }


    int i1 = org.apache.commons.math3.util.FastMath.getExponent((-1.0d));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == 0);

  }

  @Test
  public void test307() {}
// Defects4J: flaky method
//   @Test
//   public void test307() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test307"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d2 = randomDataImpl0.nextT(0.8623188722876839d);
//     randomDataImpl0.reSeedSecure();
//     // The following exception was thrown during execution in test generation
//     try {
//       long long6 = randomDataImpl0.nextLong((-1L), (-1L));
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException");
//     } catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NumberIsTooLargeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d2 == 2.421403944202397d);
// 
//   }

  @Test
  public void test308() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test308"); }


    org.apache.commons.math3.FieldElement fieldElement0 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array1 = new org.apache.commons.math3.FieldElement[] { fieldElement0 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix2 = org.apache.commons.math3.linear.MatrixUtils.<org.apache.commons.math3.FieldElement>createColumnFieldMatrix(fieldElement_array1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array1);

  }

  @Test
  public void test309() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test309"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equals(0.07277703352123166d, 4.691649480399091E41d, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test310() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test310"); }


    double d0 = org.apache.commons.math3.util.Precision.EPSILON;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d0 == 1.1102230246251565E-16d);

  }

  @Test
  public void test311() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test311"); }


    double d1 = org.apache.commons.math3.util.FastMath.log10(2964.191035514832d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 3.4719061895220023d);

  }

  @Test
  public void test312() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test312"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector5 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d6 = arrayRealVector4.dotProduct(realVector5);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);

  }

  @Test
  public void test313() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test313"); }


    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector0 = new org.apache.commons.math3.linear.ArrayRealVector();

  }

  @Test
  public void test314() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test314"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    java.lang.Double[] d_array18 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(d_array18, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector29 = arrayRealVector21.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    double d30 = arrayRealVector4.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector21);
    org.apache.commons.math3.linear.RealVector realVector32 = arrayRealVector4.mapAdd(1.6931640502651133d);
    org.apache.commons.math3.linear.RealVector realVector34 = realVector32.mapDivide(0.0d);
    double d35 = realVector32.getMaxValue();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d30 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d35, Double.NaN, 0);

  }

  @Test
  public void test315() {}
// Defects4J: flaky method
//   @Test
//   public void test315() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test315"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d3 = randomDataImpl0.nextUniform((-1.0d), 100.0d);
//     int[] i_array6 = randomDataImpl0.nextPermutation(10, 1);
//     int i9 = randomDataImpl0.nextZipf(52, 4.641588833612779d);
//     randomDataImpl0.reSeed(49L);
//     long long13 = randomDataImpl0.nextPoisson(54.444384793244126d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == 49.66762847873805d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array6);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i9 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long13 == 64L);
// 
//   }

  @Test
  public void test316() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test316"); }


    double d1 = org.apache.commons.math3.util.FastMath.cosh(7.241149127564359d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 697.8487999813906d);

  }

  @Test
  public void test317() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test317"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    org.apache.commons.math3.linear.RealMatrixPreservingVisitor realMatrixPreservingVisitor2 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d7 = array2DRowRealMatrix0.walkInOptimizedOrder(realMatrixPreservingVisitor2, 10, 10, 0, 52);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);

  }

  @Test
  public void test318() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test318"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.NumberIsTooSmallException numberIsTooSmallException4 = new org.apache.commons.math3.exception.NumberIsTooSmallException(localizable0, (java.lang.Number)(-7.241149127564359d), (java.lang.Number)1.3622825063580968d, false);
    java.lang.Number number5 = numberIsTooSmallException4.getArgument();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + number5 + "' != '" + (-7.241149127564359d)+ "'", number5.equals((-7.241149127564359d)));

  }

  @Test
  public void test319() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test319"); }


    boolean b2 = org.apache.commons.math3.util.Precision.equals(10.0d, 3.4719061895220023d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);

  }

  @Test
  public void test320() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test320"); }


    org.apache.commons.math3.exception.NotPositiveException notPositiveException1 = new org.apache.commons.math3.exception.NotPositiveException((java.lang.Number)4.414646020926698E23d);

  }

  @Test
  public void test321() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test321"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    org.apache.commons.math3.linear.RealVector realVector4 = org.apache.commons.math3.linear.MatrixUtils.createRealVector(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector4);

  }

  @Test
  public void test322() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test322"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.util.Localizable localizable2 = null;
    java.lang.Double[] d_array4 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector7 = new org.apache.commons.math3.linear.ArrayRealVector(d_array4, 0, 0);
    org.apache.commons.math3.exception.MathIllegalStateException mathIllegalStateException8 = new org.apache.commons.math3.exception.MathIllegalStateException(localizable2, (java.lang.Object[])d_array4);
    org.apache.commons.math3.exception.MaxCountExceededException maxCountExceededException9 = new org.apache.commons.math3.exception.MaxCountExceededException(localizable0, (java.lang.Number)Double.NaN, (java.lang.Object[])d_array4);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector10 = new org.apache.commons.math3.linear.ArrayRealVector(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);

  }

  @Test
  public void test323() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test323"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equals(1.776357E-15f, (-0.99999994f), 52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test324() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test324"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor5 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement6 = array2DRowFieldMatrix1.walkInRowOrder(fieldMatrixPreservingVisitor5);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);

  }

  @Test
  public void test325() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test325"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    boolean b5 = array2DRowFieldMatrix1.isSquare();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor6 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement7 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixPreservingVisitor6);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);

  }

  @Test
  public void test326() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test326"); }


    org.apache.commons.math3.random.RandomGenerator randomGenerator0 = null;
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution4 = new org.apache.commons.math3.distribution.NormalDistribution(randomGenerator0, 54.444384793244126d, 54.444384793244126d, 0.1754034190044697d);
    double d5 = normalDistribution4.getSupportLowerBound();
    double d6 = normalDistribution4.getNumericalVariance();
    double d8 = normalDistribution4.cumulativeProbability(1.0E-9d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == Double.NEGATIVE_INFINITY);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 2964.191035514832d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 0.1586552539359014d);

  }

  @Test
  public void test327() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test327"); }


    long long1 = org.apache.commons.math3.util.FastMath.abs(10L);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long1 == 10L);

  }

  @Test
  public void test328() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test328"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    org.apache.commons.math3.linear.RealVectorPreservingVisitor realVectorPreservingVisitor17 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d20 = arrayRealVector16.walkInOptimizedOrder(realVectorPreservingVisitor17, 52, 156287497);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);

  }

  @Test
  public void test329() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test329"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array22 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector25 = new org.apache.commons.math3.linear.ArrayRealVector(d_array22, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = arrayRealVector18.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector25);
    double d27 = arrayRealVector12.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector26);
    java.lang.Double[] d_array29 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector32 = new org.apache.commons.math3.linear.ArrayRealVector(d_array29, 0, 0);
    java.lang.Double[] d_array34 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector37 = new org.apache.commons.math3.linear.ArrayRealVector(d_array34, 0, 0);
    java.lang.Double[] d_array39 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector42 = new org.apache.commons.math3.linear.ArrayRealVector(d_array39, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector43 = arrayRealVector37.append((org.apache.commons.math3.linear.RealVector)arrayRealVector42);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector44 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector32, arrayRealVector42);
    java.lang.Double[] d_array46 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector49 = new org.apache.commons.math3.linear.ArrayRealVector(d_array46, 0, 0);
    java.lang.Double[] d_array53 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector56 = new org.apache.commons.math3.linear.ArrayRealVector(d_array53, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector57 = arrayRealVector49.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector56);
    double d58 = arrayRealVector32.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector49);
    org.apache.commons.math3.linear.RealVector realVector60 = arrayRealVector32.mapAdd(1.6931640502651133d);
    double d61 = arrayRealVector32.getNorm();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector62 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, arrayRealVector32);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector64 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, false);
    double d65 = arrayRealVector26.getMinValue();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d58 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d61 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d65, Double.NaN, 0);

  }

  @Test
  public void test330() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test330"); }


    double d1 = org.apache.commons.math3.util.FastMath.atan(90.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.5596856728972892d);

  }

  @Test
  public void test331() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test331"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    double d2 = well19937c1.nextDouble();
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution6 = new org.apache.commons.math3.distribution.NormalDistribution((org.apache.commons.math3.random.RandomGenerator)well19937c1, 1.0E-6d, 2.7755575615628914E-17d, (-1.0d));
    // The following exception was thrown during execution in test generation
    try {
      int i8 = well19937c1.nextInt(0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.07277703352123166d);

  }

  @Test
  public void test332() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test332"); }


    org.apache.commons.math3.random.RandomGenerator randomGenerator0 = null;
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution4 = new org.apache.commons.math3.distribution.NormalDistribution(randomGenerator0, 54.444384793244126d, 54.444384793244126d, 0.1754034190044697d);
    double d5 = normalDistribution4.getNumericalMean();
    boolean b6 = normalDistribution4.isSupportConnected();
    double d9 = normalDistribution4.cumulativeProbability((-7.241149127564359d), 1.2548583213158613d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 54.444384793244126d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d9 == 0.03568961846248486d);

  }

  @Test
  public void test333() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test333"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor7 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement12 = array2DRowFieldMatrix1.walkInOptimizedOrder(fieldMatrixChangingVisitor7, 10, 52, 100, (-1));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test334() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test334"); }


    org.apache.commons.math3.linear.RealVector realVector0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector1 = new org.apache.commons.math3.linear.ArrayRealVector(realVector0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException");
    } catch (org.apache.commons.math3.exception.NullArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NullArgumentException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test335() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test335"); }


    double d2 = org.apache.commons.math3.util.FastMath.log(1.0E-9d, 2.7755575615628914E-17d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 1.8396277512798853d);

  }

  @Test
  public void test336() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test336"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition15 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 4.9E-324d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix17 = array2DRowRealMatrix9.getRowMatrix(156287497);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);

  }

  @Test
  public void test337() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test337"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix5 = array2DRowFieldMatrix1.copy();
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);

  }

  @Test
  public void test338() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test338"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector2, false);
    org.apache.commons.math3.linear.RealVector realVector6 = arrayRealVector4.mapSubtract(10.04987562112089d);
    boolean b7 = arrayRealVector4.isNaN();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);

  }

  @Test
  public void test339() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test339"); }


    org.apache.commons.math3.linear.NonSquareMatrixException nonSquareMatrixException2 = new org.apache.commons.math3.linear.NonSquareMatrixException(0, 10);

  }

  @Test
  public void test340() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test340"); }


    org.apache.commons.math3.exception.MathIllegalStateException mathIllegalStateException0 = new org.apache.commons.math3.exception.MathIllegalStateException();

  }

  @Test
  public void test341() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test341"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    double[] d_array18 = new double[] { 0.0d };
    double[] d_array20 = org.apache.commons.math3.util.MathArrays.copyOf(d_array18, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector16, d_array20);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, false);
    int i29 = arrayRealVector28.getMaxIndex();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = arrayRealVector21.combineToSelf(0.0d, (-7.241149127564359d), (org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    java.lang.Double[] d_array32 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(d_array32, 0, 0);
    java.lang.Double[] d_array39 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector42 = new org.apache.commons.math3.linear.ArrayRealVector(d_array39, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector43 = arrayRealVector35.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector42);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector44 = arrayRealVector43.copy();
    java.lang.Double[] d_array46 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector49 = new org.apache.commons.math3.linear.ArrayRealVector(d_array46, 0, 0);
    java.lang.Double[] d_array53 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector56 = new org.apache.commons.math3.linear.ArrayRealVector(d_array53, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector57 = arrayRealVector49.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector56);
    double d58 = arrayRealVector43.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector57);
    java.lang.Double[] d_array60 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector63 = new org.apache.commons.math3.linear.ArrayRealVector(d_array60, 0, 0);
    java.lang.Double[] d_array65 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector68 = new org.apache.commons.math3.linear.ArrayRealVector(d_array65, 0, 0);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector74 = arrayRealVector68.append((org.apache.commons.math3.linear.RealVector)arrayRealVector73);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector75 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector63, arrayRealVector73);
    java.lang.Double[] d_array77 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector80 = new org.apache.commons.math3.linear.ArrayRealVector(d_array77, 0, 0);
    java.lang.Double[] d_array84 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector87 = new org.apache.commons.math3.linear.ArrayRealVector(d_array84, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector88 = arrayRealVector80.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector87);
    double d89 = arrayRealVector63.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector80);
    org.apache.commons.math3.linear.RealVector realVector91 = arrayRealVector63.mapAdd(1.6931640502651133d);
    double d92 = arrayRealVector63.getNorm();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector93 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector57, arrayRealVector63);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector95 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector57, false);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector96 = arrayRealVector30.subtract((org.apache.commons.math3.linear.RealVector)arrayRealVector57);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i29 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d58 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector74);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array77);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector88);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d89 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector91);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d92 == 0.0d);

  }

  @Test
  public void test342() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test342"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[] d_array5 = new double[] { 100.0d };
    double[] d_array9 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b10 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array5, d_array9);
    boolean b11 = org.apache.commons.math3.util.MathArrays.equals(d_array1, d_array5);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    double[] d_array13 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d14 = org.apache.commons.math3.util.MathArrays.linearCombination(d_array1, d_array13);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);

  }

  @Test
  public void test343() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test343"); }


    double d2 = org.apache.commons.math3.util.FastMath.log(14.013348232392797d, 1.2104058782952831d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.07233143692049858d);

  }

  @Test
  public void test344() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test344"); }


    org.apache.commons.math3.exception.NullArgumentException nullArgumentException0 = new org.apache.commons.math3.exception.NullArgumentException();

  }

  @Test
  public void test345() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test345"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.linear.FieldVector fieldVector5 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldVector fieldVector6 = array2DRowFieldMatrix1.operate(fieldVector5);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);

  }

  @Test
  public void test346() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test346"); }


    org.apache.commons.math3.linear.RealVectorFormat realVectorFormat0 = org.apache.commons.math3.linear.RealVectorFormat.getInstance();
    java.text.ParsePosition parsePosition2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector3 = realVectorFormat0.parse("{", parsePosition2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVectorFormat0);

  }

  @Test
  public void test347() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test347"); }


    org.apache.commons.math3.Field field0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix3 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0, 100, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test348() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test348"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    java.lang.Double[] d_array3 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector6 = new org.apache.commons.math3.linear.ArrayRealVector(d_array3, 0, 0);
    java.lang.Double[] d_array10 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = new org.apache.commons.math3.linear.ArrayRealVector(d_array10, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = arrayRealVector6.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector13);
    org.apache.commons.math3.analysis.UnivariateFunction univariateFunction15 = null;
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = arrayRealVector14.map(univariateFunction15);
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix0.setRowVector((-1), (org.apache.commons.math3.linear.RealVector)arrayRealVector14);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector16);

  }

  @Test
  public void test349() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test349"); }


    int[] i_array0 = null;
    int[] i_array3 = new int[] { 0, 10 };
    int[] i_array5 = org.apache.commons.math3.util.MathArrays.copyOf(i_array3, 10);
    int[] i_array6 = org.apache.commons.math3.util.MathArrays.copyOf(i_array5);
    // The following exception was thrown during execution in test generation
    try {
      int i7 = org.apache.commons.math3.util.MathArrays.distanceInf(i_array0, i_array6);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array6);

  }

  @Test
  public void test350() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test350"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector2, false);
    org.apache.commons.math3.linear.RealVector realVector6 = arrayRealVector4.mapSubtract(10.04987562112089d);
    double[] d_array7 = arrayRealVector4.getDataRef();
    java.lang.Double[] d_array10 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = new org.apache.commons.math3.linear.ArrayRealVector(d_array10, 0, 0);
    java.lang.Double[] d_array17 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector20 = new org.apache.commons.math3.linear.ArrayRealVector(d_array17, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = arrayRealVector13.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector20);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector22 = arrayRealVector21.copy();
    java.lang.Double[] d_array24 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = new org.apache.commons.math3.linear.ArrayRealVector(d_array24, 0, 0);
    java.lang.Double[] d_array31 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector34 = new org.apache.commons.math3.linear.ArrayRealVector(d_array31, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = arrayRealVector27.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector34);
    double d36 = arrayRealVector21.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector35);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    org.apache.commons.math3.linear.RealVector realVector69 = arrayRealVector41.mapAdd(1.6931640502651133d);
    double d70 = arrayRealVector41.getNorm();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector71 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector35, arrayRealVector41);
    // The following exception was thrown during execution in test generation
    try {
      arrayRealVector4.setSubVector(156287497, (org.apache.commons.math3.linear.RealVector)arrayRealVector71);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d36 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d70 == 0.0d);

  }

  @Test
  public void test351() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test351"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat0 = org.apache.commons.math3.linear.MatrixUtils.DEFAULT_FORMAT;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix2 = realMatrixFormat0.parse("");
      org.junit.Assert.fail("Expected exception of type java.lang.StringIndexOutOfBoundsException");
    } catch (java.lang.StringIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.StringIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.StringIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrixFormat0);

  }

  @Test
  public void test352() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test352"); }


    double d2 = org.apache.commons.math3.util.FastMath.min(5.29205908405969d, 4.50519966752906d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 4.50519966752906d);

  }

  @Test
  public void test353() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test353"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    int i2 = array2DRowRealMatrix0.getRowDimension();
    double[][] d_array_array3 = array2DRowRealMatrix0.getData();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.blockInverse((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix0, (-1));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array3);

  }

  @Test
  public void test354() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test354"); }


    double d2 = org.apache.commons.math3.util.FastMath.log(4.50519966752906d, 7.241149127564359d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 1.315265444157678d);

  }

  @Test
  public void test355() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test355"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    double d14 = array2DRowRealMatrix9.getFrobeniusNorm();
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor15 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d20 = array2DRowRealMatrix9.walkInRowOrder(realMatrixChangingVisitor15, 10, 0, 1, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 0.0d);

  }

  @Test
  public void test356() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test356"); }


    double d1 = org.apache.commons.math3.util.FastMath.tan((-7.241149127564359d));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == (-1.4221850306345674d));

  }

  @Test
  public void test357() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test357"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    double d13 = array2DRowRealMatrix9.getNorm();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array22 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector25 = new org.apache.commons.math3.linear.ArrayRealVector(d_array22, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = arrayRealVector18.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector25);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = arrayRealVector26.copy();
    java.lang.Double[] d_array29 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector32 = new org.apache.commons.math3.linear.ArrayRealVector(d_array29, 0, 0);
    java.lang.Double[] d_array34 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector37 = new org.apache.commons.math3.linear.ArrayRealVector(d_array34, 0, 0);
    java.lang.Double[] d_array39 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector42 = new org.apache.commons.math3.linear.ArrayRealVector(d_array39, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector43 = arrayRealVector37.append((org.apache.commons.math3.linear.RealVector)arrayRealVector42);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector44 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector32, arrayRealVector42);
    double[] d_array46 = new double[] { 0.0d };
    double[] d_array48 = org.apache.commons.math3.util.MathArrays.copyOf(d_array46, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector49 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector44, d_array48);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector50 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector27, arrayRealVector44);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.solveUpperTriangularSystem((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, (org.apache.commons.math3.linear.RealVector)arrayRealVector27);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d13 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);

  }

  @Test
  public void test358() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test358"); }


    double[] d_array0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix1 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test359() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test359"); }


    double d2 = org.apache.commons.math3.util.FastMath.nextAfter(2.7755575615628914E-17d, 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 2.775557561562891E-17d);

  }

  @Test
  public void test360() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test360"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.FieldElement[] fieldElement_array7 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array8 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array7 };
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setSubMatrix(fieldElement_array_array8, 100, (-1));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathIllegalStateException");
    } catch (org.apache.commons.math3.exception.MathIllegalStateException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathIllegalStateException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathIllegalStateException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array8);

  }

  @Test
  public void test361() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test361"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.linear.FieldVector fieldVector2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldVector fieldVector3 = array2DRowFieldMatrix1.operate(fieldVector2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test362() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test362"); }


    org.apache.commons.math3.random.Well19937c well19937c0 = new org.apache.commons.math3.random.Well19937c();
    double[] d_array2 = new double[] { 100.0d };
    double[] d_array6 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b7 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array2, d_array6);
    org.apache.commons.math3.util.MathArrays.checkOrder(d_array2);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array10 = array2DRowRealMatrix9.getDataRef();
    int i11 = array2DRowRealMatrix9.getRowDimension();
    double[][] d_array_array12 = array2DRowRealMatrix9.getData();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.distribution.MultivariateNormalDistribution multivariateNormalDistribution13 = new org.apache.commons.math3.distribution.MultivariateNormalDistribution((org.apache.commons.math3.random.RandomGenerator)well19937c0, d_array2, d_array_array12);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i11 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array12);

  }

  @Test
  public void test363() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test363"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.Field field2 = array2DRowFieldMatrix1.getField();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement[] fieldElement_array4 = array2DRowFieldMatrix1.getRow(52);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field2);

  }

  @Test
  public void test364() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test364"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    double[] d_array3 = new double[] { 0.0d };
    double[] d_array5 = org.apache.commons.math3.util.MathArrays.copyOf(d_array3, 1);
    double[] d_array7 = new double[] { 100.0d };
    double[] d_array11 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b12 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array7, d_array11);
    boolean b13 = org.apache.commons.math3.util.MathArrays.equals(d_array3, d_array7);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array3);
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealDiagonalMatrix(d_array3);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix16 = array2DRowRealMatrix0.add(realMatrix15);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.linear.MatrixDimensionMismatchException");
    } catch (org.apache.commons.math3.linear.MatrixDimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.linear.MatrixDimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.linear.MatrixDimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);

  }

  @Test
  public void test365() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test365"); }


    org.apache.commons.math3.exception.NotANumberException notANumberException0 = new org.apache.commons.math3.exception.NotANumberException();

  }

  @Test
  public void test366() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test366"); }


    double d1 = org.apache.commons.math3.util.FastMath.exp(3.1622776601683795d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 23.624342922017807d);

  }

  @Test
  public void test367() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test367"); }


    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException3 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.0f, (java.lang.Number)(short)100, 10);
    boolean b4 = nonMonotonicSequenceException3.getStrict();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);

  }

  @Test
  public void test368() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test368"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.FieldElement[] fieldElement_array9 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array10 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array9 };
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.copySubMatrix((-1), 52, 0, 52, fieldElement_array_array10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array10);

  }

  @Test
  public void test369() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test369"); }


    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.OpenMapRealMatrix openMapRealMatrix2 = new org.apache.commons.math3.linear.OpenMapRealMatrix(1, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test370() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test370"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector12.mapDivide(49.41408584662507d);
    java.lang.Double[] d_array17 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector20 = new org.apache.commons.math3.linear.ArrayRealVector(d_array17, 0, 0);
    java.lang.Double[] d_array24 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = new org.apache.commons.math3.linear.ArrayRealVector(d_array24, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = arrayRealVector20.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector27);
    boolean b29 = arrayRealVector28.isInfinite();
    double d30 = arrayRealVector12.dotProduct((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(10, 0.0d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = arrayRealVector12.combine(0.1586552539359014d, 2.6881171418161356E43d, (org.apache.commons.math3.linear.RealVector)arrayRealVector35);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d30 == 0.0d);

  }

  @Test
  public void test371() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test371"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector12.mapDivide(49.41408584662507d);
    java.lang.Double[] d_array17 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector20 = new org.apache.commons.math3.linear.ArrayRealVector(d_array17, 0, 0);
    java.lang.Double[] d_array24 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = new org.apache.commons.math3.linear.ArrayRealVector(d_array24, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = arrayRealVector20.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector27);
    boolean b29 = arrayRealVector28.isInfinite();
    double d30 = arrayRealVector12.dotProduct((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    double[] d_array36 = new double[] { 100.0d };
    double[] d_array40 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b41 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array36, d_array40);
    boolean b42 = org.apache.commons.math3.util.MathArrays.equals(d_array32, d_array36);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector43 = new org.apache.commons.math3.linear.ArrayRealVector(d_array32);
    // The following exception was thrown during execution in test generation
    try {
      double d44 = arrayRealVector12.cosine((org.apache.commons.math3.linear.RealVector)arrayRealVector43);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException");
    } catch (org.apache.commons.math3.exception.MathArithmeticException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathArithmeticException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d30 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b42 == false);

  }

  @Test
  public void test372() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test372"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    int i2 = array2DRowRealMatrix0.getRowDimension();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.checkMatrixIndex((org.apache.commons.math3.linear.AnyMatrix)array2DRowRealMatrix0, 52, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);

  }

  @Test
  public void test373() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test373"); }


    double d2 = org.apache.commons.math3.util.Precision.round(4.691649480399091E41d, 10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 4.691649480399091E41d);

  }

  @Test
  public void test374() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test374"); }


    double d1 = org.apache.commons.math3.util.FastMath.cosh(4.2502863927404205E43d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == Double.POSITIVE_INFINITY);

  }

  @Test
  public void test375() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test375"); }


    java.lang.Number number1 = null;
    org.apache.commons.math3.exception.OutOfRangeException outOfRangeException3 = new org.apache.commons.math3.exception.OutOfRangeException((java.lang.Number)1.0f, number1, (java.lang.Number)(-1));

  }

  @Test
  public void test376() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test376"); }


    org.apache.commons.math3.random.RandomGenerator randomGenerator0 = null;
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution4 = new org.apache.commons.math3.distribution.NormalDistribution(randomGenerator0, 54.444384793244126d, 54.444384793244126d, 0.1754034190044697d);
    double d5 = normalDistribution4.getSupportLowerBound();
    // The following exception was thrown during execution in test generation
    try {
      normalDistribution4.reseedRandomGenerator(0L);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == Double.NEGATIVE_INFINITY);

  }

  @Test
  public void test377() {}
// Defects4J: flaky method
//   @Test
//   public void test377() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test377"); }
// 
// 
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
//     double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
//     boolean b2 = array2DRowRealMatrix0.isSquare();
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl3 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d6 = randomDataImpl3.nextUniform((-1.0d), 100.0d);
//     int[] i_array9 = randomDataImpl3.nextPermutation(10, 1);
//     int i12 = randomDataImpl3.nextZipf(52, 4.641588833612779d);
//     boolean b13 = array2DRowRealMatrix0.equals((java.lang.Object)randomDataImpl3);
//     org.apache.commons.math3.exception.util.Localizable localizable18 = null;
//     double[] d_array20 = new double[] { 0.0d };
//     double[] d_array22 = org.apache.commons.math3.util.MathArrays.copyOf(d_array20, 1);
//     double[][] d_array_array23 = new double[][] { d_array20 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix24 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array23);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array23);
//     org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException26 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable18, (java.lang.Object[])d_array_array23);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix27 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array23);
//     // The following exception was thrown during execution in test generation
//     try {
//       array2DRowRealMatrix0.copySubMatrix(0, 52, 10, 0, d_array_array23);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
//     } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(d_array_array1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b2 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d6 == 96.81341829477891d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array9);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i12 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b13 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array20);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array23);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix24);
// 
//   }

  @Test
  public void test378() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test378"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldVector fieldVector8 = array2DRowFieldMatrix1.getColumnVector(52);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test379() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test379"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    boolean b2 = array2DRowRealMatrix0.isSquare();
    org.apache.commons.math3.linear.RealMatrixPreservingVisitor realMatrixPreservingVisitor3 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d4 = array2DRowRealMatrix0.walkInColumnOrder(realMatrixPreservingVisitor3);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);

  }

  @Test
  public void test380() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test380"); }


    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException3 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)(-7.241149127564359d), (java.lang.Number)6.095135277953756d, 1);

  }

  @Test
  public void test381() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test381"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    double d2 = well19937c1.nextDouble();
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution6 = new org.apache.commons.math3.distribution.NormalDistribution((org.apache.commons.math3.random.RandomGenerator)well19937c1, 1.0E-6d, 2.7755575615628914E-17d, (-1.0d));
    double d8 = normalDistribution6.probability(2.6881171418161356E43d);
    double d11 = normalDistribution6.cumulativeProbability(10.04987562112089d, 1.3440585709080678E43d);
    // The following exception was thrown during execution in test generation
    try {
      double d13 = normalDistribution6.inverseCumulativeProbability(1.3440585709080678E43d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.07277703352123166d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d11 == 0.0d);

  }

  @Test
  public void test382() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test382"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector19 = arrayRealVector11.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector18);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.solveLowerTriangularSystem((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix6, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector19);

  }

  @Test
  public void test383() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test383"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    java.lang.Double[] d_array3 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array3);
    org.apache.commons.math3.exception.MaxCountExceededException maxCountExceededException5 = new org.apache.commons.math3.exception.MaxCountExceededException(localizable0, (java.lang.Number)0.9956942709230656d, (java.lang.Object[])d_array3);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector6 = new org.apache.commons.math3.linear.ArrayRealVector(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);

  }

  @Test
  public void test384() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test384"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.DimensionMismatchException dimensionMismatchException3 = new org.apache.commons.math3.exception.DimensionMismatchException(localizable0, 0, 2147483647);

  }

  @Test
  public void test385() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test385"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    double[] d_array11 = new double[] { 0.0d };
    double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
    double[][] d_array_array14 = new double[][] { d_array11 };
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14, false);
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix9.setSubMatrix(d_array_array14, 100, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);

  }

  @Test
  public void test386() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test386"); }


    double d1 = org.apache.commons.math3.util.FastMath.toDegrees(4.691649480399091E41d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 2.6881171418161356E43d);

  }

  @Test
  public void test387() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test387"); }


    java.lang.Number number1 = null;
    org.apache.commons.math3.exception.NumberIsTooLargeException numberIsTooLargeException3 = new org.apache.commons.math3.exception.NumberIsTooLargeException((java.lang.Number)(byte)(-1), number1, true);

  }

  @Test
  public void test388() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test388"); }


    long long2 = org.apache.commons.math3.util.MathUtils.copySign(100L, 0L);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long2 == 100L);

  }

  @Test
  public void test389() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test389"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    boolean b2 = array2DRowRealMatrix0.isSquare();
    org.apache.commons.math3.exception.util.Localizable localizable3 = null;
    double[] d_array5 = new double[] { 0.0d };
    double[] d_array7 = org.apache.commons.math3.util.MathArrays.copyOf(d_array5, 1);
    double[][] d_array_array8 = new double[][] { d_array5 };
    org.apache.commons.math3.linear.RealMatrix realMatrix9 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array8);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix10 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array8);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException11 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable3, (java.lang.Object[])d_array_array8);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix12 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array8);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition14 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix12, 1.3440585709080678E43d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix15 = array2DRowRealMatrix0.subtract(array2DRowRealMatrix12);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.linear.MatrixDimensionMismatchException");
    } catch (org.apache.commons.math3.linear.MatrixDimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.linear.MatrixDimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.linear.MatrixDimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix9);

  }

  @Test
  public void test390() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test390"); }


    boolean b2 = org.apache.commons.math3.util.Precision.equals(2964.191035514832d, 14.013348232392797d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);

  }

  @Test
  public void test391() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test391"); }


    double d1 = org.apache.commons.math3.util.FastMath.ceil((-1.4221850306345674d));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == (-1.0d));

  }

  @Test
  public void test392() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test392"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array8 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array5, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix9 = org.apache.commons.math3.linear.MatrixUtils.createRealDiagonalMatrix(d_array8);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector12, false);
    org.apache.commons.math3.linear.RealVector realVector16 = arrayRealVector14.mapSubtract(10.04987562112089d);
    double[] d_array17 = arrayRealVector14.getDataRef();
    org.apache.commons.math3.linear.RealMatrix realMatrix18 = org.apache.commons.math3.linear.MatrixUtils.createRowRealMatrix(d_array17);
    // The following exception was thrown during execution in test generation
    try {
      double[] d_array19 = org.apache.commons.math3.util.MathArrays.ebeSubtract(d_array8, d_array17);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix18);

  }

  @Test
  public void test393() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test393"); }


    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException3 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.1102230246251565E-16d, (java.lang.Number)Float.NaN, 52);

  }

  @Test
  public void test394() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test394"); }


    double d1 = org.apache.commons.math3.util.FastMath.atanh(1.0E-6d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.0000000000003333E-6d);

  }

  @Test
  public void test395() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test395"); }


    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(10, 0.0d);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector3 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector2);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    // The following exception was thrown during execution in test generation
    try {
      arrayRealVector2.setSubVector(100, (org.apache.commons.math3.linear.RealVector)arrayRealVector9);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);

  }

  @Test
  public void test396() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test396"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    int i2 = array2DRowRealMatrix0.getRowDimension();
    org.apache.commons.math3.linear.MatrixUtils.checkSymmetric((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix0, 0.07233143692049858d);
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor5 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d6 = array2DRowRealMatrix0.walkInRowOrder(realMatrixChangingVisitor5);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);

  }

  @Test
  public void test397() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test397"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[] d_array5 = new double[] { 100.0d };
    double[] d_array9 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b10 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array5, d_array9);
    boolean b11 = org.apache.commons.math3.util.MathArrays.equals(d_array1, d_array5);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, false);
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array22 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector25 = new org.apache.commons.math3.linear.ArrayRealVector(d_array22, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = arrayRealVector18.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector25);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = arrayRealVector26.copy();
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector26.mapDivide(49.41408584662507d);
    org.apache.commons.math3.analysis.UnivariateFunction univariateFunction30 = null;
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector31 = arrayRealVector26.mapToSelf(univariateFunction30);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix32 = arrayRealVector13.outerProduct((org.apache.commons.math3.linear.RealVector)arrayRealVector26);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector31);

  }

  @Test
  public void test398() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test398"); }


    org.apache.commons.math3.Field field0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix3 = org.apache.commons.math3.linear.MatrixUtils.<org.apache.commons.math3.FieldElement>createFieldMatrix(field0, 2147483647, 10);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test399() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test399"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equals(1.4E-45f, (-0.99999994f), 100);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test400() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test400"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor4 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement9 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixChangingVisitor4, (-1), 0, 1, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test401() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test401"); }


    double d0 = org.apache.commons.math3.util.MathUtils.TWO_PI;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d0 == 6.283185307179586d);

  }

  @Test
  public void test402() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test402"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    double[] d_array18 = new double[] { 0.0d };
    double[] d_array20 = org.apache.commons.math3.util.MathArrays.copyOf(d_array18, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector16, d_array20);
    double[] d_array23 = new double[] { 100.0d };
    double[] d_array27 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b28 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array23, d_array27);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException32 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.0f, (java.lang.Number)(short)100, 10);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection33 = nonMonotonicSequenceException32.getDirection();
    boolean b35 = org.apache.commons.math3.util.MathArrays.isMonotonic(d_array23, orderDirection33, false);
    // The following exception was thrown during execution in test generation
    try {
      double d36 = org.apache.commons.math3.util.MathArrays.linearCombination(d_array20, d_array23);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == true);

  }

  @Test
  public void test403() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test403"); }


    int i1 = org.apache.commons.math3.util.FastMath.round(0.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == 0);

  }

  @Test
  public void test404() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test404"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
    org.apache.commons.math3.exception.util.Localizable localizable9 = null;
    double[] d_array11 = new double[] { 0.0d };
    double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
    double[][] d_array_array14 = new double[][] { d_array11 };
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVector realVector27 = array2DRowRealMatrix8.getColumnVector(10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix25);

  }

  @Test
  public void test405() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test405"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    // The following exception was thrown during execution in test generation
    try {
      double d12 = array2DRowRealMatrix9.getEntry(2147483647, 156287497);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);

  }

  @Test
  public void test406() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test406"); }


    double[] d_array0 = null;
    double[] d_array1 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition3 = new org.apache.commons.math3.linear.EigenDecomposition(d_array0, d_array1, 1.3622825063580968d);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test407() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test407"); }


    double d2 = org.apache.commons.math3.util.FastMath.scalb(0.9956942709230656d, 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 1.9913885418461312d);

  }

  @Test
  public void test408() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test408"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector2, false);
    int i5 = arrayRealVector4.getMaxIndex();
    // The following exception was thrown during execution in test generation
    try {
      arrayRealVector4.addToEntry((-1), 0.19172688492398912d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 0);

  }

  @Test
  public void test409() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test409"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    boolean b7 = array2DRowFieldMatrix1.isSquare();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix8 = array2DRowFieldMatrix1.transpose();
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);

  }

  @Test
  public void test410() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test410"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.NotStrictlyPositiveException notStrictlyPositiveException2 = new org.apache.commons.math3.exception.NotStrictlyPositiveException(localizable0, (java.lang.Number)1.0E-6d);

  }

  @Test
  public void test411() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test411"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    double d2 = well19937c1.nextDouble();
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution6 = new org.apache.commons.math3.distribution.NormalDistribution((org.apache.commons.math3.random.RandomGenerator)well19937c1, 1.0E-6d, 2.7755575615628914E-17d, (-1.0d));
    boolean b7 = normalDistribution6.isSupportConnected();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.07277703352123166d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);

  }

  @Test
  public void test412() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test412"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(52);
    well19937c1.clear();
    double d3 = well19937c1.nextDouble();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d3 == 0.3921994840967409d);

  }

  @Test
  public void test413() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test413"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    int i2 = array2DRowRealMatrix0.getRowDimension();
    double[][] d_array_array3 = array2DRowRealMatrix0.getData();
    org.apache.commons.math3.linear.RealMatrixPreservingVisitor realMatrixPreservingVisitor4 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d5 = array2DRowRealMatrix0.walkInOptimizedOrder(realMatrixPreservingVisitor4);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array3);

  }

  @Test
  public void test414() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test414"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    boolean b7 = org.apache.commons.math3.linear.MatrixUtils.isSymmetric(realMatrix5, (-1.0d));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);

  }

  @Test
  public void test415() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test415"); }


    int i1 = org.apache.commons.math3.util.FastMath.getExponent(697.8487999813906d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == 9);

  }

  @Test
  public void test416() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test416"); }


    java.lang.Number number0 = null;
    java.lang.Number number2 = null;
    org.apache.commons.math3.exception.OutOfRangeException outOfRangeException3 = new org.apache.commons.math3.exception.OutOfRangeException(number0, (java.lang.Number)4.641588833612779d, number2);
    org.apache.commons.math3.exception.util.ExceptionContext exceptionContext4 = outOfRangeException3.getContext();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(exceptionContext4);

  }

  @Test
  public void test417() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test417"); }


    long long2 = org.apache.commons.math3.util.FastMath.min(6179557979701623951L, 6179557979701623951L);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long2 == 6179557979701623951L);

  }

  @Test
  public void test418() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test418"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    boolean b2 = array2DRowRealMatrix0.isSquare();
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor3 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d4 = array2DRowRealMatrix0.walkInColumnOrder(realMatrixChangingVisitor3);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);

  }

  @Test
  public void test419() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test419"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement7 = array2DRowFieldMatrix1.walkInRowOrder(fieldMatrixPreservingVisitor2, 1, 52, (-1), 156287497);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test420() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test420"); }


    float f1 = org.apache.commons.math3.util.FastMath.nextUp((-0.99999994f));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f1 == (-0.9999999f));

  }

  @Test
  public void test421() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test421"); }


    float[] f_array1 = new float[] { (-1.0f) };
    float[] f_array4 = new float[] { 10.0f, 100.0f };
    boolean b5 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(f_array1, f_array4);
    float[] f_array7 = new float[] { (-1.0f) };
    float[] f_array10 = new float[] { 10.0f, 100.0f };
    boolean b11 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(f_array7, f_array10);
    float[] f_array13 = new float[] { (-1.0f) };
    float[] f_array16 = new float[] { 10.0f, 100.0f };
    boolean b17 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(f_array13, f_array16);
    boolean b18 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(f_array7, f_array13);
    boolean b19 = org.apache.commons.math3.util.MathArrays.equals(f_array4, f_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);

  }

  @Test
  public void test422() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test422"); }


    int i1 = org.apache.commons.math3.util.FastMath.round(1.7763568E-15f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == 0);

  }

  @Test
  public void test423() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test423"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    double[] d_array18 = new double[] { 0.0d };
    double[] d_array20 = org.apache.commons.math3.util.MathArrays.copyOf(d_array18, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector16, d_array20);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, false);
    int i29 = arrayRealVector28.getMaxIndex();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = arrayRealVector21.combineToSelf(0.0d, (-7.241149127564359d), (org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.RealVectorChangingVisitor realVectorChangingVisitor31 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d32 = arrayRealVector30.walkInOptimizedOrder(realVectorChangingVisitor31);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i29 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector30);

  }

  @Test
  public void test424() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test424"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
    org.apache.commons.math3.exception.util.Localizable localizable9 = null;
    double[] d_array11 = new double[] { 0.0d };
    double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
    double[][] d_array_array14 = new double[][] { d_array11 };
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
    org.apache.commons.math3.linear.RealMatrixPreservingVisitor realMatrixPreservingVisitor26 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d31 = array2DRowRealMatrix25.walkInColumnOrder(realMatrixPreservingVisitor26, 1, 10, (-1), 2147483647);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix25);

  }

  @Test
  public void test425() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test425"); }


    org.apache.commons.math3.linear.RealVectorFormat realVectorFormat0 = org.apache.commons.math3.linear.RealVectorFormat.getInstance();
    java.lang.String str1 = realVectorFormat0.getSeparator();
    java.lang.String str2 = realVectorFormat0.getSuffix();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVectorFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "; "+ "'", str1.equals("; "));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str2 + "' != '" + "}"+ "'", str2.equals("}"));

  }

  @Test
  public void test426() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test426"); }


    double d2 = org.apache.commons.math3.util.FastMath.pow(1.5596856728972892d, 3.1622776601683795d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 4.0779026560837695d);

  }

  @Test
  public void test427() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test427"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array3 };
    double[][] d_array_array5 = org.apache.commons.math3.linear.BlockRealMatrix.toBlocksLayout(d_array_array4);
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.checkColumnIndex((org.apache.commons.math3.linear.AnyMatrix)realMatrix6, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);

  }

  @Test
  public void test428() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test428"); }


    org.apache.commons.math3.exception.util.Localizable localizable1 = null;
    java.lang.Integer[] i_array3 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array5 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException6 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array3, i_array5);
    org.apache.commons.math3.util.MathUtils.checkNotNull((java.lang.Object)0.0d, localizable1, (java.lang.Object[])i_array5);
    org.apache.commons.math3.exception.util.Localizable localizable8 = null;
    java.lang.Integer[] i_array10 = new java.lang.Integer[] { 10 };
    java.lang.Integer[] i_array12 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array14 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException15 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array12, i_array14);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException16 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(localizable8, i_array10, i_array12);
    org.apache.commons.math3.exception.util.Localizable localizable17 = null;
    java.lang.Integer[] i_array19 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array21 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException22 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array19, i_array21);
    org.apache.commons.math3.exception.NullArgumentException nullArgumentException23 = new org.apache.commons.math3.exception.NullArgumentException(localizable17, (java.lang.Object[])i_array19);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException24 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array10, i_array19);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException25 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array5, i_array19);
    java.lang.Integer[] i_array26 = multiDimensionMismatchException25.getExpectedDimensions();
    int i28 = multiDimensionMismatchException25.getExpectedDimension(0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i28 == 100);

  }

  @Test
  public void test429() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test429"); }


    double d2 = org.apache.commons.math3.util.FastMath.atan2(3.162277660168379d, (-3.4893569077129025d));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 2.4053276775961323d);

  }

  @Test
  public void test430() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test430"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.Field field2 = array2DRowFieldMatrix1.getField();
    org.apache.commons.math3.linear.FieldVector fieldVector3 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldVector fieldVector4 = array2DRowFieldMatrix1.operate(fieldVector3);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field2);

  }

  @Test
  public void test431() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test431"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector12.mapDivide(49.41408584662507d);
    org.apache.commons.math3.analysis.UnivariateFunction univariateFunction16 = null;
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector17 = arrayRealVector12.mapToSelf(univariateFunction16);
    boolean b18 = arrayRealVector17.isNaN();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == false);

  }

  @Test
  public void test432() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test432"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector5 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    java.lang.Double[] d_array7 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector10 = new org.apache.commons.math3.linear.ArrayRealVector(d_array7, 0, 0);
    java.lang.Double[] d_array14 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector17 = new org.apache.commons.math3.linear.ArrayRealVector(d_array14, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = arrayRealVector10.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector17);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector19 = arrayRealVector18.copy();
    java.lang.Double[] d_array21 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector24 = new org.apache.commons.math3.linear.ArrayRealVector(d_array21, 0, 0);
    java.lang.Double[] d_array26 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector29 = new org.apache.commons.math3.linear.ArrayRealVector(d_array26, 0, 0);
    java.lang.Double[] d_array31 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector34 = new org.apache.commons.math3.linear.ArrayRealVector(d_array31, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector35 = arrayRealVector29.append((org.apache.commons.math3.linear.RealVector)arrayRealVector34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector24, arrayRealVector34);
    double[] d_array38 = new double[] { 0.0d };
    double[] d_array40 = org.apache.commons.math3.util.MathArrays.copyOf(d_array38, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector36, d_array40);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector42 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector19, arrayRealVector36);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector43 = arrayRealVector5.ebeMultiply((org.apache.commons.math3.linear.RealVector)arrayRealVector36);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array40);

  }

  @Test
  public void test433() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test433"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor7 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement8 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixChangingVisitor7);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);

  }

  @Test
  public void test434() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test434"); }


    double d2 = org.apache.commons.math3.util.FastMath.copySign(0.9956942709230656d, 0.9956942709230656d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.9956942709230656d);

  }

  @Test
  public void test435() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test435"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor7 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement8 = array2DRowFieldMatrix1.walkInOptimizedOrder(fieldMatrixPreservingVisitor7);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);

  }

  @Test
  public void test436() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test436"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement8 = array2DRowFieldMatrix1.getEntry(0, 52);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);

  }

  @Test
  public void test437() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test437"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = org.apache.commons.math3.linear.MatrixUtils.bigFractionMatrixToRealMatrix((org.apache.commons.math3.linear.FieldMatrix)array2DRowFieldMatrix1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoDataException");
    } catch (org.apache.commons.math3.exception.NoDataException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NoDataException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoDataException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);

  }

  @Test
  public void test438() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test438"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    org.apache.commons.math3.linear.RealVectorChangingVisitor realVectorChangingVisitor17 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d18 = arrayRealVector14.walkInDefaultOrder(realVectorChangingVisitor17);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);

  }

  @Test
  public void test439() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test439"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    int i2 = array2DRowRealMatrix0.getRowDimension();
    double[][] d_array_array3 = array2DRowRealMatrix0.getData();
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix0.addToEntry(156287497, 52, 6.482892211805716d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array3);

  }

  @Test
  public void test440() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test440"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    double d14 = array2DRowRealMatrix9.getFrobeniusNorm();
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition15 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9);
    // The following exception was thrown during execution in test generation
    try {
      double d17 = eigenDecomposition15.getImagEigenvalue(100);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 0.0d);

  }

  @Test
  public void test441() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test441"); }


    double d1 = org.apache.commons.math3.util.FastMath.sinh(0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.0d);

  }

  @Test
  public void test442() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test442"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = org.apache.commons.math3.linear.MatrixUtils.bigFractionMatrixToRealMatrix((org.apache.commons.math3.linear.FieldMatrix)array2DRowFieldMatrix1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoDataException");
    } catch (org.apache.commons.math3.exception.NoDataException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NoDataException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoDataException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);

  }

  @Test
  public void test443() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test443"); }


    double d2 = org.apache.commons.math3.util.FastMath.IEEEremainder(1.0502117406906721d, 1.0E-9d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == (-3.0932793010781605E-10d));

  }

  @Test
  public void test444() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test444"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix7 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field6);
    boolean b9 = array2DRowFieldMatrix7.equals((java.lang.Object)(short)10);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix10 = array2DRowFieldMatrix1.subtract((org.apache.commons.math3.linear.FieldMatrix)array2DRowFieldMatrix7);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);

  }

  @Test
  public void test445() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test445"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array8 = new double[] { 100.0d };
    double[] d_array12 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b13 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array8, d_array12);
    boolean b14 = org.apache.commons.math3.util.MathArrays.equals(d_array1, d_array12);
    double[] d_array15 = new double[] {  };
    double[] d_array17 = new double[] { 100.0d };
    double[] d_array21 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b22 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array17, d_array21);
    double d23 = org.apache.commons.math3.util.MathArrays.distance(d_array15, d_array21);
    // The following exception was thrown during execution in test generation
    try {
      double[] d_array24 = org.apache.commons.math3.util.MathArrays.ebeMultiply(d_array1, d_array21);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d23 == 0.0d);

  }

  @Test
  public void test446() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test446"); }


    double d1 = org.apache.commons.math3.util.FastMath.nextUp(1.3440585709080678E43d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.344058570908068E43d);

  }

  @Test
  public void test447() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test447"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector2, false);
    org.apache.commons.math3.linear.RealVector realVector6 = arrayRealVector4.mapSubtract(10.04987562112089d);
    double[] d_array7 = arrayRealVector4.getDataRef();
    org.apache.commons.math3.analysis.UnivariateFunction univariateFunction8 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = arrayRealVector4.map(univariateFunction8);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);

  }

  @Test
  public void test448() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test448"); }


    org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
    randomDataImpl0.reSeedSecure();
    randomDataImpl0.reSeed(100L);
    // The following exception was thrown during execution in test generation
    try {
      int i7 = randomDataImpl0.nextHypergeometric(100, 2147483647, 156287497);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException");
    } catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NumberIsTooLargeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test449() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test449"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array1 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array2 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array1 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix3 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0, fieldElement_array_array2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array2);

  }

  @Test
  public void test450() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test450"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    double d13 = array2DRowRealMatrix9.getNorm();
    org.apache.commons.math3.linear.RealMatrixPreservingVisitor realMatrixPreservingVisitor14 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d19 = array2DRowRealMatrix9.walkInOptimizedOrder(realMatrixPreservingVisitor14, 0, 0, 0, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d13 == 0.0d);

  }

  @Test
  public void test451() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test451"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equalsIncludingNaN(0.0d, (-7.241149127564358d), 100);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test452() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test452"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix18 = array2DRowRealMatrix9.getSubMatrix(52, 9, 1, 2147483647);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);

  }

  @Test
  public void test453() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test453"); }


    org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
    // The following exception was thrown during execution in test generation
    try {
      int i3 = randomDataGenerator0.nextPascal(10, 54.444384793244126d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test454() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test454"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor7 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement8 = array2DRowFieldMatrix1.walkInRowOrder(fieldMatrixPreservingVisitor7);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);

  }

  @Test
  public void test455() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test455"); }


    int i3 = org.apache.commons.math3.util.Precision.compareTo(100.00499987500625d, 1.344058570908068E43d, 0.3921994840967409d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i3 == (-1));

  }

  @Test
  public void test456() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test456"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    org.apache.commons.math3.linear.RealMatrixPreservingVisitor realMatrixPreservingVisitor1 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d6 = array2DRowRealMatrix0.walkInRowOrder(realMatrixPreservingVisitor1, 1, 52, 0, 1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test457() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test457"); }


    org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException nonPositiveDefiniteMatrixException3 = new org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException(3.4719061895220023d, 0, 7.703719777548943E-34d);
    org.apache.commons.math3.exception.NumberIsTooSmallException numberIsTooSmallException7 = new org.apache.commons.math3.exception.NumberIsTooSmallException((java.lang.Number)(byte)0, (java.lang.Number)100.0d, false);
    nonPositiveDefiniteMatrixException3.addSuppressed((java.lang.Throwable)numberIsTooSmallException7);
    boolean b9 = numberIsTooSmallException7.getBoundIsAllowed();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);

  }

  @Test
  public void test458() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test458"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    java.lang.Object[] obj_array1 = null;
    org.apache.commons.math3.exception.MathInternalError mathInternalError2 = new org.apache.commons.math3.exception.MathInternalError(localizable0, obj_array1);

  }

  @Test
  public void test459() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test459"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor6 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement11 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixChangingVisitor6, 100, (-1), 0, (-1));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);

  }

  @Test
  public void test460() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test460"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.exception.util.Localizable localizable14 = null;
    double[] d_array16 = new double[] { 0.0d };
    double[] d_array18 = org.apache.commons.math3.util.MathArrays.copyOf(d_array16, 1);
    double[][] d_array_array19 = new double[][] { d_array16 };
    org.apache.commons.math3.linear.RealMatrix realMatrix20 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array19);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix21 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array19);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException22 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable14, (java.lang.Object[])d_array_array19);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix23 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array19);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition25 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix23, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix27 = array2DRowRealMatrix23.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition29 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix23, 4.9E-324d);
    org.apache.commons.math3.linear.RealMatrix realMatrix30 = eigenDecomposition29.getV();
    double[] d_array31 = eigenDecomposition29.getRealEigenvalues();
    double[] d_array32 = org.apache.commons.math3.util.MathArrays.copyOf(d_array31);
    double[] d_array33 = array2DRowRealMatrix9.operate(d_array32);
    double[] d_array35 = new double[] { 100.0d };
    double[] d_array39 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b40 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array35, d_array39);
    double[] d_array42 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array39, 1.3440585709080678E43d);
    double[] d_array44 = org.apache.commons.math3.util.MathArrays.copyOf(d_array39, 1);
    // The following exception was thrown during execution in test generation
    try {
      double[] d_array45 = array2DRowRealMatrix9.preMultiply(d_array39);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array44);

  }

  @Test
  public void test461() {}
// Defects4J: flaky method
//   @Test
//   public void test461() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test461"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
//     double d2 = randomDataGenerator0.nextT(0.07277703352123166d);
//     // The following exception was thrown during execution in test generation
//     try {
//       double d5 = randomDataGenerator0.nextBeta((-1.4221850306345674d), 1.3622825063580968d);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoBracketingException");
//     } catch (org.apache.commons.math3.exception.NoBracketingException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NoBracketingException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoBracketingException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d2 == (-7.379986073298354E11d));
// 
//   }

  @Test
  public void test462() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test462"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[] d_array5 = new double[] { 100.0d };
    double[] d_array9 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b10 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array5, d_array9);
    boolean b11 = org.apache.commons.math3.util.MathArrays.equals(d_array1, d_array5);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    java.lang.Double[] d_array14 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector17 = new org.apache.commons.math3.linear.ArrayRealVector(d_array14, 0, 0);
    java.lang.Double[] d_array19 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector22 = new org.apache.commons.math3.linear.ArrayRealVector(d_array19, 0, 0);
    java.lang.Double[] d_array24 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = new org.apache.commons.math3.linear.ArrayRealVector(d_array24, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector28 = arrayRealVector22.append((org.apache.commons.math3.linear.RealVector)arrayRealVector27);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector29 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector17, arrayRealVector27);
    java.lang.Double[] d_array31 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector34 = new org.apache.commons.math3.linear.ArrayRealVector(d_array31, 0, 0);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector42 = arrayRealVector34.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector41);
    double d43 = arrayRealVector17.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector34);
    org.apache.commons.math3.linear.RealVector realVector45 = arrayRealVector17.mapAdd(1.6931640502651133d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix46 = arrayRealVector12.outerProduct(realVector45);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d43 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector45);

  }

  @Test
  public void test463() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test463"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    org.apache.commons.math3.linear.RealMatrixPreservingVisitor realMatrixPreservingVisitor2 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d3 = array2DRowRealMatrix0.walkInColumnOrder(realMatrixPreservingVisitor2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);

  }

  @Test
  public void test464() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test464"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    java.lang.Double[] d_array2 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector5 = new org.apache.commons.math3.linear.ArrayRealVector(d_array2, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector6 = new org.apache.commons.math3.linear.ArrayRealVector(d_array2);
    org.apache.commons.math3.exception.MathArithmeticException mathArithmeticException7 = new org.apache.commons.math3.exception.MathArithmeticException(localizable0, (java.lang.Object[])d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);

  }

  @Test
  public void test465() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test465"); }


    org.apache.commons.math3.linear.RealMatrix realMatrix1 = org.apache.commons.math3.linear.MatrixUtils.createRealIdentityMatrix(100);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.checkSubMatrixIndex((org.apache.commons.math3.linear.AnyMatrix)realMatrix1, 1, 52, 156287497, 156287497);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix1);

  }

  @Test
  public void test466() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test466"); }


    java.io.ObjectInputStream objectInputStream2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.deserializeRealVector((java.lang.Object)14.556736826696994d, "Array2DRowRealMatrix{{0.0}}", objectInputStream2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test467() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test467"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    double[] d_array15 = new double[] { 0.0d };
    double[] d_array17 = org.apache.commons.math3.util.MathArrays.copyOf(d_array15, 1);
    double[][] d_array_array18 = new double[][] { d_array15 };
    org.apache.commons.math3.linear.RealMatrix realMatrix19 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array18);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix20 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array18);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix22 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array18, false);
    org.apache.commons.math3.linear.MatrixUtils.checkSubtractionCompatible((org.apache.commons.math3.linear.AnyMatrix)realMatrix13, (org.apache.commons.math3.linear.AnyMatrix)array2DRowRealMatrix22);
    double[] d_array29 = new double[] { 0.0d };
    double[] d_array31 = org.apache.commons.math3.util.MathArrays.copyOf(d_array29, 1);
    double[][] d_array_array32 = new double[][] { d_array29 };
    org.apache.commons.math3.linear.RealMatrix realMatrix33 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array32);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix34 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array32);
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix22.copySubMatrix(2147483647, 10, 10, 1, d_array_array32);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix33);

  }

  @Test
  public void test468() {}
// Defects4J: flaky method
//   @Test
//   public void test468() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test468"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d2 = randomDataImpl0.nextT(0.8623188722876839d);
//     randomDataImpl0.reSeedSecure(0L);
//     // The following exception was thrown during execution in test generation
//     try {
//       int i7 = randomDataImpl0.nextZipf(0, 6.482892211805716d);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
//     } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d2 == 0.35875492642853085d);
// 
//   }

  @Test
  public void test469() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test469"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    double d13 = array2DRowRealMatrix9.getNorm();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix16 = array2DRowRealMatrix9.createMatrix(0, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d13 == 0.0d);

  }

  @Test
  public void test470() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test470"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor5 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement10 = array2DRowFieldMatrix1.walkInOptimizedOrder(fieldMatrixChangingVisitor5, 10, (-1), 0, 52);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);

  }

  @Test
  public void test471() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test471"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    java.lang.Double[] d_array14 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector17 = new org.apache.commons.math3.linear.ArrayRealVector(d_array14, 0, 0);
    java.lang.Double[] d_array21 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector24 = new org.apache.commons.math3.linear.ArrayRealVector(d_array21, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector25 = arrayRealVector17.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector24);
    double d26 = arrayRealVector24.getMaxValue();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = arrayRealVector11.subtract((org.apache.commons.math3.linear.RealVector)arrayRealVector24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d26, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector27);

  }

  @Test
  public void test472() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test472"); }


    double d1 = org.apache.commons.math3.util.FastMath.log10(4.505199667529061d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.6537140433915507d);

  }

  @Test
  public void test473() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test473"); }


    long long1 = org.apache.commons.math3.util.FastMath.round(0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long1 == 0L);

  }

  @Test
  public void test474() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test474"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array3 };
    double[][] d_array_array5 = org.apache.commons.math3.linear.BlockRealMatrix.toBlocksLayout(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);

  }

  @Test
  public void test475() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test475"); }


    org.apache.commons.math3.random.RandomGenerator randomGenerator0 = null;
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution4 = new org.apache.commons.math3.distribution.NormalDistribution(randomGenerator0, 54.444384793244126d, 54.444384793244126d, 0.1754034190044697d);
    double d5 = normalDistribution4.getNumericalMean();
    boolean b6 = normalDistribution4.isSupportConnected();
    boolean b7 = normalDistribution4.isSupportLowerBoundInclusive();
    double d9 = normalDistribution4.density(4.641588833612779d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 54.444384793244126d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d9 == 0.00482232748012793d);

  }

  @Test
  public void test476() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test476"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.linear.FieldVector fieldVector4 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldVector fieldVector5 = array2DRowFieldMatrix1.preMultiply(fieldVector4);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test477() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test477"); }


    java.lang.Class clazz2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.exception.MathParseException mathParseException3 = new org.apache.commons.math3.exception.MathParseException("}", 0, clazz2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test478() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test478"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    long[] long_array1 = null;
    long[][] long_array_array2 = new long[][] { long_array1 };
    org.apache.commons.math3.util.MathArrays.checkRectangular(long_array_array2);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException4 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])long_array_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(long_array_array2);

  }

  @Test
  public void test479() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test479"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.FieldElement fieldElement6 = null;
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.addToEntry(2147483647, 156287497, fieldElement6);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test480() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test480"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    double[] d_array18 = new double[] { 0.0d };
    double[] d_array20 = org.apache.commons.math3.util.MathArrays.copyOf(d_array18, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector16, d_array20);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, false);
    int i29 = arrayRealVector28.getMaxIndex();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = arrayRealVector21.combineToSelf(0.0d, (-7.241149127564359d), (org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    double[] d_array31 = arrayRealVector21.toArray();
    double[] d_array33 = org.apache.commons.math3.util.MathArrays.copyOf(d_array31, 100);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i29 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array33);

  }

  @Test
  public void test481() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test481"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    int i13 = array2DRowRealMatrix9.getRowDimension();
    double[] d_array16 = new double[] { 0.0d };
    double[] d_array18 = org.apache.commons.math3.util.MathArrays.copyOf(d_array16, 1);
    double[][] d_array_array19 = new double[][] { d_array16 };
    org.apache.commons.math3.linear.RealMatrix realMatrix20 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array19);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix21 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array19);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix23 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array19, false);
    org.apache.commons.math3.exception.util.Localizable localizable24 = null;
    double[] d_array26 = new double[] { 0.0d };
    double[] d_array28 = org.apache.commons.math3.util.MathArrays.copyOf(d_array26, 1);
    double[][] d_array_array29 = new double[][] { d_array26 };
    org.apache.commons.math3.linear.RealMatrix realMatrix30 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array29);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix31 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array29);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException32 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable24, (java.lang.Object[])d_array_array29);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix33 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array29);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition35 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix33, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix37 = array2DRowRealMatrix33.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition39 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix33, 4.9E-324d);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix40 = array2DRowRealMatrix23.subtract(array2DRowRealMatrix33);
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix9.setColumnMatrix(52, (org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix40);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i13 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix40);

  }

  @Test
  public void test482() {}
// Defects4J: flaky method
//   @Test
//   public void test482() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test482"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d2 = randomDataImpl0.nextT(0.8623188722876839d);
//     randomDataImpl0.reSeedSecure();
//     double d6 = randomDataImpl0.nextCauchy(2.466889252024757d, 3.4719061895220023d);
//     java.lang.String str8 = randomDataImpl0.nextSecureHexString(1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d2 == 1.6794711176442731d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d6 == 3.4091431702387944d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str8 + "' != '" + "6"+ "'", str8.equals("6"));
// 
//   }

  @Test
  public void test483() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test483"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    java.lang.Integer[] i_array2 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array4 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException5 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array2, i_array4);
    java.lang.Integer[] i_array6 = multiDimensionMismatchException5.getExpectedDimensions();
    org.apache.commons.math3.exception.NullArgumentException nullArgumentException7 = new org.apache.commons.math3.exception.NullArgumentException(localizable0, (java.lang.Object[])i_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array6);

  }

  @Test
  public void test484() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test484"); }


    org.apache.commons.math3.FieldElement[] fieldElement_array0 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array1 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array0 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix2 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(fieldElement_array_array1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array1);

  }

  @Test
  public void test485() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test485"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    java.lang.Integer[] i_array1 = null;
    org.apache.commons.math3.exception.util.Localizable localizable3 = null;
    java.lang.Integer[] i_array5 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array7 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException8 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array5, i_array7);
    org.apache.commons.math3.util.MathUtils.checkNotNull((java.lang.Object)0.0d, localizable3, (java.lang.Object[])i_array7);
    org.apache.commons.math3.exception.util.Localizable localizable10 = null;
    java.lang.Integer[] i_array12 = new java.lang.Integer[] { 10 };
    java.lang.Integer[] i_array14 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array16 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException17 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array14, i_array16);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException18 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(localizable10, i_array12, i_array14);
    org.apache.commons.math3.exception.util.Localizable localizable19 = null;
    java.lang.Integer[] i_array21 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array23 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException24 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array21, i_array23);
    org.apache.commons.math3.exception.NullArgumentException nullArgumentException25 = new org.apache.commons.math3.exception.NullArgumentException(localizable19, (java.lang.Object[])i_array21);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException26 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array12, i_array21);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException27 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array7, i_array21);
    double[] d_array32 = new double[] { 100.0d };
    double[] d_array36 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b37 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array32, d_array36);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException41 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.0f, (java.lang.Number)(short)100, 10);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection42 = nonMonotonicSequenceException41.getDirection();
    boolean b44 = org.apache.commons.math3.util.MathArrays.isMonotonic(d_array32, orderDirection42, false);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException46 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.845203840522836E41d, (java.lang.Number)1.5707963267948966d, 156287497, orderDirection42, true);
    boolean b48 = org.apache.commons.math3.util.MathArrays.<java.lang.Comparable>isMonotonic((java.lang.Comparable[])i_array7, orderDirection42, true);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException49 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(localizable0, i_array1, i_array7);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b37 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b48 == true);

  }

  @Test
  public void test486() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test486"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    double[] d_array18 = new double[] { 0.0d };
    double[] d_array20 = org.apache.commons.math3.util.MathArrays.copyOf(d_array18, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector16, d_array20);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, false);
    int i29 = arrayRealVector28.getMaxIndex();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = arrayRealVector21.combineToSelf(0.0d, (-7.241149127564359d), (org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.RealVectorChangingVisitor realVectorChangingVisitor31 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d32 = arrayRealVector28.walkInOptimizedOrder(realVectorChangingVisitor31);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i29 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector30);

  }

  @Test
  public void test487() {}
// Defects4J: flaky method
//   @Test
//   public void test487() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest0.test487"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     randomDataImpl0.reSeedSecure();
//     randomDataImpl0.reSeed();
//     randomDataImpl0.reSeedSecure(49L);
//     double d7 = randomDataImpl0.nextF(3.141592653589793d, 1.5707963267948966d);
//     double d10 = randomDataImpl0.nextF(0.6892682844514348d, 100.0d);
//     java.lang.String str12 = randomDataImpl0.nextHexString(1);
//     // The following exception was thrown during execution in test generation
//     try {
//       double d15 = randomDataImpl0.nextBeta(1.5707963267948966d, 0.0d);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoBracketingException");
//     } catch (org.apache.commons.math3.exception.NoBracketingException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NoBracketingException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoBracketingException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d7 == 0.2598988698476005d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d10 == 0.7472016058578357d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str12 + "' != '" + "e"+ "'", str12.equals("e"));
// 
//   }

  @Test
  public void test488() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test488"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.io.ObjectInputStream objectInputStream70 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.deserializeRealVector((java.lang.Object)arrayRealVector36, "Array2DRowRealMatrix{{0.0}}", objectInputStream70);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);

  }

  @Test
  public void test489() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test489"); }


    double d1 = org.apache.commons.math3.util.FastMath.toRadians(0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.0d);

  }

  @Test
  public void test490() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test490"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor4 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement5 = array2DRowFieldMatrix1.walkInOptimizedOrder(fieldMatrixChangingVisitor4);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test491() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test491"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    double d81 = arrayRealVector36.getNorm();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d81 == 0.0d);

  }

  @Test
  public void test492() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test492"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    int i13 = array2DRowRealMatrix9.getRowDimension();
    double[] d_array15 = null;
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix9.setColumn(0, d_array15);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i13 == 1);

  }

  @Test
  public void test493() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test493"); }


    org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
    randomDataImpl0.reSeedSecure();
    randomDataImpl0.reSeed(100L);
    // The following exception was thrown during execution in test generation
    try {
      int i7 = randomDataImpl0.nextHypergeometric(0, 100, 10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test494() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test494"); }


    org.apache.commons.math3.random.RandomGenerator randomGenerator0 = null;
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution4 = new org.apache.commons.math3.distribution.NormalDistribution(randomGenerator0, 54.444384793244126d, 54.444384793244126d, 0.1754034190044697d);
    double d5 = normalDistribution4.getNumericalMean();
    boolean b6 = normalDistribution4.isSupportUpperBoundInclusive();
    double d7 = normalDistribution4.getStandardDeviation();
    double d9 = normalDistribution4.inverseCumulativeProbability(1.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 54.444384793244126d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 54.444384793244126d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d9 == Double.POSITIVE_INFINITY);

  }

  @Test
  public void test495() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test495"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    boolean b5 = array2DRowFieldMatrix1.isSquare();
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor6 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement7 = array2DRowFieldMatrix1.walkInRowOrder(fieldMatrixChangingVisitor6);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);

  }

  @Test
  public void test496() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test496"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array22 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector25 = new org.apache.commons.math3.linear.ArrayRealVector(d_array22, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = arrayRealVector18.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector25);
    double d27 = arrayRealVector12.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector26);
    java.lang.Double[] d_array29 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector32 = new org.apache.commons.math3.linear.ArrayRealVector(d_array29, 0, 0);
    java.lang.Double[] d_array34 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector37 = new org.apache.commons.math3.linear.ArrayRealVector(d_array34, 0, 0);
    java.lang.Double[] d_array39 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector42 = new org.apache.commons.math3.linear.ArrayRealVector(d_array39, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector43 = arrayRealVector37.append((org.apache.commons.math3.linear.RealVector)arrayRealVector42);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector44 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector32, arrayRealVector42);
    java.lang.Double[] d_array46 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector49 = new org.apache.commons.math3.linear.ArrayRealVector(d_array46, 0, 0);
    java.lang.Double[] d_array53 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector56 = new org.apache.commons.math3.linear.ArrayRealVector(d_array53, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector57 = arrayRealVector49.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector56);
    double d58 = arrayRealVector32.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector49);
    org.apache.commons.math3.linear.RealVector realVector60 = arrayRealVector32.mapAdd(1.6931640502651133d);
    double d61 = arrayRealVector32.getNorm();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector62 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, arrayRealVector32);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector64 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, false);
    org.apache.commons.math3.linear.RealVectorPreservingVisitor realVectorPreservingVisitor65 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d66 = arrayRealVector64.walkInDefaultOrder(realVectorPreservingVisitor65);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d58 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d61 == 0.0d);

  }

  @Test
  public void test497() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test497"); }


    java.lang.Class clazz2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.exception.MathParseException mathParseException3 = new org.apache.commons.math3.exception.MathParseException("9", 2147483647, clazz2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test498() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test498"); }


    double d1 = org.apache.commons.math3.util.FastMath.toDegrees(99.37864167209166d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 5693.976741553778d);

  }

  @Test
  public void test499() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test499"); }


    org.apache.commons.math3.exception.DimensionMismatchException dimensionMismatchException2 = new org.apache.commons.math3.exception.DimensionMismatchException(1, 0);

  }

  @Test
  public void test500() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest0.test500"); }


    org.apache.commons.math3.random.RandomGenerator randomGenerator0 = null;
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution4 = new org.apache.commons.math3.distribution.NormalDistribution(randomGenerator0, 54.444384793244126d, 54.444384793244126d, 0.1754034190044697d);
    double d6 = normalDistribution4.cumulativeProbability(54.444384793244126d);
    double d7 = normalDistribution4.getStandardDeviation();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 0.5d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 54.444384793244126d);

  }

}
