
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class RegressionTest1 {

  public static boolean debug = false;

  @Test
  public void test001() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test001"); }


    org.apache.commons.math3.Field field0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix3 = org.apache.commons.math3.linear.MatrixUtils.<org.apache.commons.math3.FieldElement>createFieldMatrix(field0, 100, 156287497);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test002() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test002"); }


    long long1 = org.apache.commons.math3.util.FastMath.abs(49L);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long1 == 49L);

  }

  @Test
  public void test003() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test003"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
    org.apache.commons.math3.exception.util.Localizable localizable9 = null;
    double[] d_array11 = new double[] { 0.0d };
    double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
    double[][] d_array_array14 = new double[][] { d_array11 };
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
    double[] d_array27 = new double[] { 0.0d };
    double[] d_array29 = org.apache.commons.math3.util.MathArrays.copyOf(d_array27, 1);
    double[][] d_array_array30 = new double[][] { d_array29 };
    double[][] d_array_array31 = org.apache.commons.math3.linear.BlockRealMatrix.toBlocksLayout(d_array_array30);
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix8.setSubMatrix(d_array_array31, 52, 43);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array31);

  }

  @Test
  public void test004() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test004"); }


    double d2 = org.apache.commons.math3.util.Precision.representableDelta(0.07233143692049858d, 0.03568961846248486d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.03568961846248486d);

  }

  @Test
  public void test005() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test005"); }


    double d1 = org.apache.commons.math3.util.FastMath.ulp(0.1586552539359014d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 2.7755575615628914E-17d);

  }

  @Test
  public void test006() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test006"); }


    long long2 = org.apache.commons.math3.util.FastMath.min(100L, (-1L));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long2 == (-1L));

  }

  @Test
  public void test007() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test007"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector10 = arrayRealVector4.append((org.apache.commons.math3.linear.RealVector)arrayRealVector9);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = arrayRealVector9.copy();
    double d12 = arrayRealVector11.getL1Norm();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d12 == 0.0d);

  }

  @Test
  public void test008() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test008"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    int[] i_array4 = new int[] { 0, 10 };
    int[] i_array6 = org.apache.commons.math3.util.MathArrays.copyOf(i_array4, 10);
    int[] i_array9 = new int[] { 0, 100 };
    int[] i_array12 = new int[] { 0, 10 };
    int[] i_array14 = org.apache.commons.math3.util.MathArrays.copyOf(i_array12, 10);
    int[] i_array15 = org.apache.commons.math3.util.MathArrays.copyOf(i_array14);
    double d16 = org.apache.commons.math3.util.MathArrays.distance(i_array9, i_array15);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix17 = array2DRowFieldMatrix1.getSubMatrix(i_array4, i_array9);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d16 == 90.0d);

  }

  @Test
  public void test009() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test009"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array22 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector25 = new org.apache.commons.math3.linear.ArrayRealVector(d_array22, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = arrayRealVector18.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector25);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = arrayRealVector26.copy();
    java.lang.Double[] d_array29 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector32 = new org.apache.commons.math3.linear.ArrayRealVector(d_array29, 0, 0);
    java.lang.Double[] d_array34 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector37 = new org.apache.commons.math3.linear.ArrayRealVector(d_array34, 0, 0);
    java.lang.Double[] d_array39 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector42 = new org.apache.commons.math3.linear.ArrayRealVector(d_array39, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector43 = arrayRealVector37.append((org.apache.commons.math3.linear.RealVector)arrayRealVector42);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector44 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector32, arrayRealVector42);
    double[] d_array46 = new double[] { 0.0d };
    double[] d_array48 = org.apache.commons.math3.util.MathArrays.copyOf(d_array46, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector49 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector44, d_array48);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector50 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector27, arrayRealVector44);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector12, arrayRealVector50);
    double[] d_array54 = new double[] { 0.0d };
    double[] d_array56 = org.apache.commons.math3.util.MathArrays.copyOf(d_array54, 1);
    // The following exception was thrown during execution in test generation
    try {
      arrayRealVector51.setSubVector(43, d_array54);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array56);

  }

  @Test
  public void test010() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test010"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix13 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix14 = array2DRowRealMatrix9.preMultiply((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix13);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));

  }

  @Test
  public void test011() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test011"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector10 = arrayRealVector4.append((org.apache.commons.math3.linear.RealVector)arrayRealVector9);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = arrayRealVector9.copy();
    arrayRealVector9.set(10.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector11);

  }

  @Test
  public void test012() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test012"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.Field field5 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix6 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field5);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix7 = array2DRowFieldMatrix1.subtract(array2DRowFieldMatrix6);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);

  }

  @Test
  public void test013() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test013"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldVector fieldVector8 = array2DRowFieldMatrix1.getColumnVector(9);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);

  }

  @Test
  public void test014() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test014"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    java.lang.String str7 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.Field field8 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix9 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field8);
    boolean b11 = array2DRowFieldMatrix9.equals((java.lang.Object)(short)10);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix12 = array2DRowFieldMatrix1.add((org.apache.commons.math3.linear.FieldMatrix)array2DRowFieldMatrix9);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str7 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str7.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);

  }

  @Test
  public void test015() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test015"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    boolean b7 = array2DRowFieldMatrix1.isSquare();
    org.apache.commons.math3.FieldElement fieldElement8 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix9 = array2DRowFieldMatrix1.scalarMultiply(fieldElement8);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);

  }

  @Test
  public void test016() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test016"); }


    java.lang.Number number1 = null;
    org.apache.commons.math3.exception.NumberIsTooLargeException numberIsTooLargeException3 = new org.apache.commons.math3.exception.NumberIsTooLargeException((java.lang.Number)(-1), number1, false);

  }

  @Test
  public void test017() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test017"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.RealMatrix realMatrix8 = array2DRowRealMatrix6.scalarMultiply(0.0d);
    double[] d_array10 = new double[] { 0.0d };
    double[] d_array12 = org.apache.commons.math3.util.MathArrays.copyOf(d_array10, 1);
    double[] d_array14 = new double[] { 100.0d };
    double[] d_array18 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b19 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array14, d_array18);
    boolean b20 = org.apache.commons.math3.util.MathArrays.equals(d_array10, d_array14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(d_array10);
    org.apache.commons.math3.linear.RealMatrix realMatrix22 = org.apache.commons.math3.linear.MatrixUtils.createRealDiagonalMatrix(d_array10);
    org.apache.commons.math3.linear.RealMatrix realMatrix23 = array2DRowRealMatrix6.add(realMatrix22);
    org.apache.commons.math3.exception.util.Localizable localizable24 = null;
    double[] d_array26 = new double[] { 0.0d };
    double[] d_array28 = org.apache.commons.math3.util.MathArrays.copyOf(d_array26, 1);
    double[][] d_array_array29 = new double[][] { d_array26 };
    org.apache.commons.math3.linear.RealMatrix realMatrix30 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array29);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix31 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array29);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException32 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable24, (java.lang.Object[])d_array_array29);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix33 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array29);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition35 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix33, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix37 = array2DRowRealMatrix33.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition39 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix33, 4.9E-324d);
    org.apache.commons.math3.linear.RealMatrix realMatrix40 = array2DRowRealMatrix6.subtract((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix33);
    double[] d_array42 = new double[] { 100.0d };
    double[] d_array46 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b47 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array42, d_array46);
    double[] d_array49 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array46, 1.3440585709080678E43d);
    double d50 = org.apache.commons.math3.util.MathArrays.safeNorm(d_array46);
    double[][] d_array_array51 = new double[][] { d_array46 };
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix6.setSubMatrix(d_array_array51, 1, 2147483647);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b47 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d50 == 100.00499987500625d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array51);

  }

  @Test
  public void test018() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test018"); }


    float f2 = org.apache.commons.math3.util.FastMath.nextAfter(1.0f, 0.9956942709230656d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f2 == 0.99999994f);

  }

  @Test
  public void test019() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test019"); }


    org.apache.commons.math3.Field field0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix2 = org.apache.commons.math3.linear.MatrixUtils.<org.apache.commons.math3.FieldElement>createFieldIdentityMatrix(field0, 156287497);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test020() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test020"); }


    double d4 = org.apache.commons.math3.util.MathArrays.linearCombination(1.0502117406906721d, 2.4053276775961323d, Double.NEGATIVE_INFINITY, 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d4, Double.NaN, 0);

  }

  @Test
  public void test021() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test021"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector2, false);
    org.apache.commons.math3.linear.RealVector realVector6 = arrayRealVector4.mapSubtract(10.04987562112089d);
    double[] d_array7 = arrayRealVector4.getDataRef();
    org.apache.commons.math3.linear.RealMatrix realMatrix8 = org.apache.commons.math3.linear.MatrixUtils.createRowRealMatrix(d_array7);
    double[] d_array10 = new double[] { 0.0d };
    double[] d_array12 = org.apache.commons.math3.util.MathArrays.copyOf(d_array10, 1);
    double[] d_array14 = new double[] { 100.0d };
    double[] d_array18 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b19 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array14, d_array18);
    boolean b20 = org.apache.commons.math3.util.MathArrays.equals(d_array10, d_array14);
    org.apache.commons.math3.linear.RealVector realVector21 = org.apache.commons.math3.linear.MatrixUtils.createRealVector(d_array14);
    org.apache.commons.math3.linear.MatrixUtils.solveUpperTriangularSystem(realMatrix8, realVector21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector21);

  }

  @Test
  public void test022() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test022"); }


    org.apache.commons.math3.linear.OpenMapRealMatrix openMapRealMatrix0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.OpenMapRealMatrix openMapRealMatrix1 = new org.apache.commons.math3.linear.OpenMapRealMatrix(openMapRealMatrix0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test023() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test023"); }


    org.apache.commons.math3.exception.NotPositiveException notPositiveException1 = new org.apache.commons.math3.exception.NotPositiveException((java.lang.Number)5693.976741553778d);

  }

  @Test
  public void test024() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test024"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    double d2 = well19937c1.nextDouble();
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution6 = new org.apache.commons.math3.distribution.NormalDistribution((org.apache.commons.math3.random.RandomGenerator)well19937c1, 1.0E-6d, 2.7755575615628914E-17d, (-1.0d));
    org.apache.commons.math3.random.RandomDataImpl randomDataImpl7 = new org.apache.commons.math3.random.RandomDataImpl((org.apache.commons.math3.random.RandomGenerator)well19937c1);
    well19937c1.setSeed(49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.07277703352123166d);

  }

  @Test
  public void test025() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test025"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.util.Localizable localizable2 = null;
    java.lang.Double[] d_array4 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector7 = new org.apache.commons.math3.linear.ArrayRealVector(d_array4, 0, 0);
    org.apache.commons.math3.exception.MathIllegalStateException mathIllegalStateException8 = new org.apache.commons.math3.exception.MathIllegalStateException(localizable2, (java.lang.Object[])d_array4);
    org.apache.commons.math3.exception.MaxCountExceededException maxCountExceededException9 = new org.apache.commons.math3.exception.MaxCountExceededException(localizable0, (java.lang.Number)Double.NaN, (java.lang.Object[])d_array4);
    org.apache.commons.math3.exception.util.ExceptionContext exceptionContext10 = maxCountExceededException9.getContext();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(exceptionContext10);

  }

  @Test
  public void test026() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test026"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.NumberIsTooLargeException numberIsTooLargeException4 = new org.apache.commons.math3.exception.NumberIsTooLargeException(localizable0, (java.lang.Number)0.9956942709230656d, (java.lang.Number)Double.NaN, false);
    boolean b5 = numberIsTooLargeException4.getBoundIsAllowed();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);

  }

  @Test
  public void test027() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test027"); }


    float f2 = org.apache.commons.math3.util.FastMath.nextAfter(0.0f, 1.2104058782952831d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f2 == 1.4E-45f);

  }

  @Test
  public void test028() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test028"); }


    float f2 = org.apache.commons.math3.util.FastMath.copySign(10.0f, 1.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f2 == 10.0f);

  }

  @Test
  public void test029() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test029"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.linear.FieldVector fieldVector5 = null;
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setColumnVector(9, fieldVector5);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test030() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test030"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor2 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d3 = array2DRowRealMatrix0.walkInOptimizedOrder(realMatrixChangingVisitor2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);

  }

  @Test
  public void test031() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test031"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
    org.apache.commons.math3.exception.util.Localizable localizable9 = null;
    double[] d_array11 = new double[] { 0.0d };
    double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
    double[][] d_array_array14 = new double[][] { d_array11 };
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix18.multiplyEntry(1, 2147483647, 0.17451622721454543d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix25);

  }

  @Test
  public void test032() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test032"); }


    org.apache.commons.math3.FieldElement[] fieldElement_array0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix1 = org.apache.commons.math3.linear.MatrixUtils.<org.apache.commons.math3.FieldElement>createRowFieldMatrix(fieldElement_array0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException");
    } catch (org.apache.commons.math3.exception.NullArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NullArgumentException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test033() {}
// Defects4J: flaky method
//   @Test
//   public void test033() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test033"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d2 = randomDataImpl0.nextT(0.8623188722876839d);
//     randomDataImpl0.reSeedSecure();
//     // The following exception was thrown during execution in test generation
//     try {
//       int i6 = randomDataImpl0.nextPascal(9, 2964.191035514832d);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
//     } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d2 == (-2.6697911699061065d));
// 
//   }

  @Test
  public void test034() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test034"); }


    boolean b2 = org.apache.commons.math3.util.Precision.equals((-0.99999994f), (-1.0f));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);

  }

  @Test
  public void test035() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test035"); }


    org.apache.commons.math3.exception.DimensionMismatchException dimensionMismatchException2 = new org.apache.commons.math3.exception.DimensionMismatchException(10, 10);
    int i3 = dimensionMismatchException2.getDimension();
    java.lang.Throwable[] throwable_array4 = dimensionMismatchException2.getSuppressed();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i3 == 10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(throwable_array4);

  }

  @Test
  public void test036() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test036"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    java.io.ObjectOutputStream objectOutputStream17 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.serializeRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, objectOutputStream17);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);

  }

  @Test
  public void test037() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test037"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor7 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement8 = array2DRowFieldMatrix1.walkInRowOrder(fieldMatrixChangingVisitor7);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);

  }

  @Test
  public void test038() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test038"); }


    boolean b2 = org.apache.commons.math3.util.Precision.equals(0.99999994f, 100.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);

  }

  @Test
  public void test039() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test039"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equalsIncludingNaN(Double.POSITIVE_INFINITY, (-1.4221850306345674d), 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test040() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test040"); }


    double d1 = org.apache.commons.math3.util.FastMath.sqrt(1.1102230246251565E-16d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.0536712127723509E-8d);

  }

  @Test
  public void test041() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test041"); }


    double d0 = org.apache.commons.math3.util.FastMath.E;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d0 == 2.718281828459045d);

  }

  @Test
  public void test042() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test042"); }


    double d1 = org.apache.commons.math3.util.FastMath.ceil(100.00499987500625d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 101.0d);

  }

  @Test
  public void test043() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test043"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat0 = org.apache.commons.math3.linear.MatrixUtils.DEFAULT_FORMAT;
    java.text.NumberFormat numberFormat1 = realMatrixFormat0.getFormat();
    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat2 = new org.apache.commons.math3.linear.RealMatrixFormat(numberFormat1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrixFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat1);

  }

  @Test
  public void test044() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test044"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    java.lang.Double[] d_array14 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector17 = new org.apache.commons.math3.linear.ArrayRealVector(d_array14, 0, 0);
    int i18 = arrayRealVector17.getDimension();
    double[] d_array19 = arrayRealVector17.toArray();
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix20 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array21 = array2DRowRealMatrix20.getDataRef();
    int i22 = array2DRowRealMatrix20.getRowDimension();
    double[][] d_array_array23 = array2DRowRealMatrix20.getData();
    org.apache.commons.math3.util.MathArrays.sortInPlace(d_array19, d_array_array23);
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix9.setSubMatrix(d_array_array23, 49, 9);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoDataException");
    } catch (org.apache.commons.math3.exception.NoDataException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NoDataException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoDataException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i18 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i22 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array23);

  }

  @Test
  public void test045() {}
// Defects4J: flaky method
//   @Test
//   public void test045() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test045"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d3 = randomDataImpl0.nextUniform((-1.0d), 100.0d);
//     int[] i_array6 = randomDataImpl0.nextPermutation(10, 1);
//     int i9 = randomDataImpl0.nextZipf(52, 4.641588833612779d);
//     randomDataImpl0.reSeed(49L);
//     java.util.Collection collection12 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       java.lang.Object[] obj_array14 = randomDataImpl0.nextSample(collection12, 0);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == 7.008167898748803d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array6);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i9 == 1);
// 
//   }

  @Test
  public void test046() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test046"); }


    int i3 = org.apache.commons.math3.util.Precision.compareTo(98.3368500438211d, 70.95715494148374d, 1.3622825063580968d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i3 == 1);

  }

  @Test
  public void test047() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test047"); }


    double d2 = org.apache.commons.math3.util.FastMath.log(0.0d, 2.6881171418161356E43d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == (-0.0d));

  }

  @Test
  public void test048() {}
// Defects4J: flaky method
//   @Test
//   public void test048() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test048"); }
// 
// 
//     double[] d_array1 = new double[] { 0.0d };
//     double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
//     double[][] d_array_array4 = new double[][] { d_array1 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
//     org.apache.commons.math3.exception.util.Localizable localizable9 = null;
//     double[] d_array11 = new double[] { 0.0d };
//     double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
//     double[][] d_array_array14 = new double[][] { d_array11 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
//     org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix26 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
//     double[][] d_array_array27 = array2DRowRealMatrix26.getDataRef();
//     boolean b28 = array2DRowRealMatrix26.isSquare();
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl29 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d32 = randomDataImpl29.nextUniform((-1.0d), 100.0d);
//     int[] i_array35 = randomDataImpl29.nextPermutation(10, 1);
//     int i38 = randomDataImpl29.nextZipf(52, 4.641588833612779d);
//     boolean b39 = array2DRowRealMatrix26.equals((java.lang.Object)randomDataImpl29);
//     boolean b40 = array2DRowRealMatrix8.equals((java.lang.Object)array2DRowRealMatrix26);
//     org.apache.commons.math3.linear.RealMatrix realMatrix42 = array2DRowRealMatrix8.scalarAdd(1.6931640502651133d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(d_array_array27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b28 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d32 == 63.081707367870514d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i38 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b39 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b40 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix42);
// 
//   }

  @Test
  public void test049() {}
// Defects4J: flaky method
//   @Test
//   public void test049() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test049"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d2 = randomDataImpl0.nextT(0.8623188722876839d);
//     randomDataImpl0.reSeedSecure(0L);
//     // The following exception was thrown during execution in test generation
//     try {
//       long long7 = randomDataImpl0.nextSecureLong((-2252072468373639168L), (-2252072468373639168L));
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException");
//     } catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NumberIsTooLargeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d2 == 4.047270268372805d);
// 
//   }

  @Test
  public void test050() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test050"); }


    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(10, 0.0d);
    org.apache.commons.math3.linear.RealVector realVector4 = arrayRealVector2.mapMultiplyToSelf(99.37864167209166d);
    // The following exception was thrown during execution in test generation
    try {
      arrayRealVector2.unitize();
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException");
    } catch (org.apache.commons.math3.exception.MathArithmeticException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathArithmeticException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector4);

  }

  @Test
  public void test051() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test051"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.FieldElement fieldElement3 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array4 = new org.apache.commons.math3.FieldElement[] { fieldElement3 };
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setColumn(1, fieldElement_array4);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array4);

  }

  @Test
  public void test052() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test052"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.util.Localizable localizable2 = null;
    java.lang.Integer[] i_array4 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array6 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException7 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array4, i_array6);
    org.apache.commons.math3.util.MathUtils.checkNotNull((java.lang.Object)0.0d, localizable2, (java.lang.Object[])i_array6);
    org.apache.commons.math3.exception.util.Localizable localizable9 = null;
    java.lang.Integer[] i_array11 = new java.lang.Integer[] { 10 };
    java.lang.Integer[] i_array13 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array15 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException16 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array13, i_array15);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException17 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(localizable9, i_array11, i_array13);
    org.apache.commons.math3.exception.util.Localizable localizable18 = null;
    java.lang.Integer[] i_array20 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array22 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException23 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array20, i_array22);
    org.apache.commons.math3.exception.NullArgumentException nullArgumentException24 = new org.apache.commons.math3.exception.NullArgumentException(localizable18, (java.lang.Object[])i_array20);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException25 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array11, i_array20);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException26 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array6, i_array20);
    java.lang.Integer[] i_array27 = multiDimensionMismatchException26.getExpectedDimensions();
    org.apache.commons.math3.exception.MathArithmeticException mathArithmeticException28 = new org.apache.commons.math3.exception.MathArithmeticException(localizable0, (java.lang.Object[])i_array27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array27);

  }

  @Test
  public void test053() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test053"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    double d13 = array2DRowRealMatrix9.getNorm();
    org.apache.commons.math3.linear.RealMatrix realMatrix14 = array2DRowRealMatrix9.transpose();
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor15 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d16 = array2DRowRealMatrix9.walkInRowOrder(realMatrixChangingVisitor15);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d13 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix14);

  }

  @Test
  public void test054() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test054"); }


    org.apache.commons.math3.exception.OutOfRangeException outOfRangeException3 = new org.apache.commons.math3.exception.OutOfRangeException((java.lang.Number)3.1622776601683795d, (java.lang.Number)0, (java.lang.Number)1);
    java.lang.Number number4 = outOfRangeException3.getHi();
    java.lang.Number number5 = outOfRangeException3.getLo();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + number4 + "' != '" + 1+ "'", number4.equals(1));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + number5 + "' != '" + 0+ "'", number5.equals(0));

  }

  @Test
  public void test055() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test055"); }


    int i3 = org.apache.commons.math3.util.Precision.compareTo(2.775557561562891E-17d, 3.4091431702387944d, 10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i3 == (-1));

  }

  @Test
  public void test056() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test056"); }


    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection0 = org.apache.commons.math3.util.MathArrays.OrderDirection.INCREASING;
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection0);

  }

  @Test
  public void test057() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test057"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    org.apache.commons.math3.linear.RealVector realVector14 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector15 = arrayRealVector12.subtract(realVector14);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);

  }

  @Test
  public void test058() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test058"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equals(50.0f, 1.0f, Float.NaN);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test059() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test059"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector12.mapDivide(49.41408584662507d);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(10, 0.0d);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector19 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18);
    // The following exception was thrown during execution in test generation
    try {
      double d20 = arrayRealVector12.cosine((org.apache.commons.math3.linear.RealVector)arrayRealVector18);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException");
    } catch (org.apache.commons.math3.exception.MathArithmeticException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathArithmeticException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);

  }

  @Test
  public void test060() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test060"); }


    int i1 = org.apache.commons.math3.util.FastMath.abs(0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == 0);

  }

  @Test
  public void test061() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test061"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix12 = eigenDecomposition11.getV();
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = eigenDecomposition11.getV();
    boolean b14 = eigenDecomposition11.hasComplexEigenvalues();
    double[] d_array15 = eigenDecomposition11.getRealEigenvalues();
    double[] d_array16 = eigenDecomposition11.getRealEigenvalues();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);

  }

  @Test
  public void test062() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test062"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.OutOfRangeException outOfRangeException4 = new org.apache.commons.math3.exception.OutOfRangeException(localizable0, (java.lang.Number)5693.976741553778d, (java.lang.Number)52.422382841558026d, (java.lang.Number)100);

  }

  @Test
  public void test063() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test063"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.util.Localizable localizable1 = null;
    double[] d_array2 = new double[] {  };
    double[] d_array4 = new double[] { 100.0d };
    double[] d_array8 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b9 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array4, d_array8);
    double d10 = org.apache.commons.math3.util.MathArrays.distance(d_array2, d_array8);
    double[] d_array11 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2);
    org.apache.commons.math3.exception.util.Localizable localizable12 = null;
    double[] d_array14 = new double[] { 0.0d };
    double[] d_array16 = org.apache.commons.math3.util.MathArrays.copyOf(d_array14, 1);
    double[][] d_array_array17 = new double[][] { d_array14 };
    org.apache.commons.math3.linear.RealMatrix realMatrix18 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array17);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix19 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array17);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException20 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable12, (java.lang.Object[])d_array_array17);
    org.apache.commons.math3.util.MathArrays.sortInPlace(d_array2, d_array_array17);
    org.apache.commons.math3.exception.NullArgumentException nullArgumentException22 = new org.apache.commons.math3.exception.NullArgumentException(localizable1, (java.lang.Object[])d_array_array17);
    org.apache.commons.math3.exception.ZeroException zeroException23 = new org.apache.commons.math3.exception.ZeroException(localizable0, (java.lang.Object[])d_array_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d10 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix18);

  }

  @Test
  public void test064() {}
// Defects4J: flaky method
//   @Test
//   public void test064() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test064"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d2 = randomDataImpl0.nextT(0.8623188722876839d);
//     randomDataImpl0.reSeedSecure();
//     int i6 = randomDataImpl0.nextInt(0, 10);
//     // The following exception was thrown during execution in test generation
//     try {
//       int i9 = randomDataImpl0.nextZipf(0, 0.0d);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
//     } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d2 == 0.05897033008168409d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i6 == 4);
// 
//   }

  @Test
  public void test065() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test065"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat0 = org.apache.commons.math3.linear.MatrixUtils.DEFAULT_FORMAT;
    java.text.NumberFormat numberFormat1 = realMatrixFormat0.getFormat();
    java.lang.String str2 = realMatrixFormat0.getSuffix();
    java.lang.String str3 = realMatrixFormat0.getRowSuffix();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix5 = realMatrixFormat0.parse("5515c956b2eab6260306e287b6e79f9b24f15f0c4374f130a0c3f153c6cd0cd56d53992ff18a0c43e497680ba0f4a0f1340d");
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathParseException");
    } catch (org.apache.commons.math3.exception.MathParseException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathParseException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathParseException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrixFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str2 + "' != '" + "}"+ "'", str2.equals("}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str3 + "' != '" + "}"+ "'", str3.equals("}"));

  }

  @Test
  public void test066() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test066"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition15 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 4.9E-324d);
    org.apache.commons.math3.linear.RealMatrix realMatrix16 = eigenDecomposition15.getV();
    double[] d_array17 = eigenDecomposition15.getRealEigenvalues();
    double[] d_array18 = org.apache.commons.math3.util.MathArrays.copyOf(d_array17);
    // The following exception was thrown during execution in test generation
    try {
      double[] d_array20 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array17, 4.9E-324d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException");
    } catch (org.apache.commons.math3.exception.MathArithmeticException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathArithmeticException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);

  }

  @Test
  public void test067() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test067"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    java.io.ObjectOutputStream objectOutputStream81 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.serializeRealVector(realVector80, objectOutputStream81);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);

  }

  @Test
  public void test068() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test068"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    java.lang.Double[] d_array14 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector17 = new org.apache.commons.math3.linear.ArrayRealVector(d_array14, 0, 0);
    java.lang.Double[] d_array19 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector22 = new org.apache.commons.math3.linear.ArrayRealVector(d_array19, 0, 0);
    java.lang.Double[] d_array24 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = new org.apache.commons.math3.linear.ArrayRealVector(d_array24, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector28 = arrayRealVector22.append((org.apache.commons.math3.linear.RealVector)arrayRealVector27);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector29 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector17, arrayRealVector27);
    double[] d_array31 = new double[] { 0.0d };
    double[] d_array33 = org.apache.commons.math3.util.MathArrays.copyOf(d_array31, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector34 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector29, d_array33);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector39 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector39, false);
    int i42 = arrayRealVector41.getMaxIndex();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector43 = arrayRealVector34.combineToSelf(0.0d, (-7.241149127564359d), (org.apache.commons.math3.linear.RealVector)arrayRealVector41);
    double[] d_array44 = arrayRealVector34.toArray();
    org.apache.commons.math3.linear.RealVector realVector46 = arrayRealVector34.mapMultiplyToSelf(1.0E-6d);
    org.apache.commons.math3.linear.RealVector realVector47 = array2DRowRealMatrix9.operate((org.apache.commons.math3.linear.RealVector)arrayRealVector34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i42 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector47);

  }

  @Test
  public void test069() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test069"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(100L);

  }

  @Test
  public void test070() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test070"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    double d2 = well19937c1.nextDouble();
    well19937c1.setSeed(0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.07277703352123166d);

  }

  @Test
  public void test071() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test071"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.util.Localizable localizable2 = null;
    double[] d_array5 = new double[] { 0.0d };
    double[] d_array7 = org.apache.commons.math3.util.MathArrays.copyOf(d_array5, 1);
    java.lang.Object[] obj_array8 = new java.lang.Object[] { d_array5 };
    org.apache.commons.math3.exception.MaxCountExceededException maxCountExceededException9 = new org.apache.commons.math3.exception.MaxCountExceededException(localizable2, (java.lang.Number)(byte)0, obj_array8);
    org.apache.commons.math3.exception.MaxCountExceededException maxCountExceededException10 = new org.apache.commons.math3.exception.MaxCountExceededException(localizable0, (java.lang.Number)10.0f, obj_array8);
    java.lang.Number number11 = maxCountExceededException10.getMax();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + number11 + "' != '" + 10.0f+ "'", number11.equals(10.0f));

  }

  @Test
  public void test072() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test072"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    well19937c1.setSeed(0);
    byte[] byte_array4 = new byte[] {  };
    well19937c1.nextBytes(byte_array4);
    int i7 = well19937c1.nextInt(100);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(byte_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 69);

  }

  @Test
  public void test073() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test073"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    // The following exception was thrown during execution in test generation
    try {
      double d15 = arrayRealVector12.getEntry(1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);

  }

  @Test
  public void test074() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test074"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector10 = arrayRealVector4.append((org.apache.commons.math3.linear.RealVector)arrayRealVector9);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = arrayRealVector9.copy();
    org.apache.commons.math3.linear.RealVector realVector13 = arrayRealVector9.mapSubtractToSelf(1.327000036267693d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector13);

  }

  @Test
  public void test075() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test075"); }


    float f1 = org.apache.commons.math3.util.FastMath.abs(3.552714E-15f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f1 == 3.552714E-15f);

  }

  @Test
  public void test076() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test076"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.NotPositiveException notPositiveException2 = new org.apache.commons.math3.exception.NotPositiveException(localizable0, (java.lang.Number)2.7755575615628914E-17d);
    org.apache.commons.math3.exception.util.ExceptionContext exceptionContext3 = notPositiveException2.getContext();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(exceptionContext3);

  }

  @Test
  public void test077() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test077"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix6 = array2DRowFieldMatrix1.transpose();
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);

  }

  @Test
  public void test078() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test078"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.FieldElement[] fieldElement_array6 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array7 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array6 };
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setSubMatrix(fieldElement_array_array7, 0, 52);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathIllegalStateException");
    } catch (org.apache.commons.math3.exception.MathIllegalStateException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathIllegalStateException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathIllegalStateException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array7);

  }

  @Test
  public void test079() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test079"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.util.Localizable localizable1 = null;
    java.lang.Integer[] i_array3 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array5 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException6 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array3, i_array5);
    java.lang.Integer[] i_array7 = multiDimensionMismatchException6.getExpectedDimensions();
    org.apache.commons.math3.exception.ZeroException zeroException8 = new org.apache.commons.math3.exception.ZeroException(localizable1, (java.lang.Object[])i_array7);
    org.apache.commons.math3.exception.NullArgumentException nullArgumentException9 = new org.apache.commons.math3.exception.NullArgumentException(localizable0, (java.lang.Object[])i_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array7);

  }

  @Test
  public void test080() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test080"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement7 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixPreservingVisitor2, 0, (-1), 1, (-1));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test081() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test081"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.Field field2 = array2DRowFieldMatrix1.getField();
    org.apache.commons.math3.Field field4 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix5 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field4);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix5.getField();
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setColumnMatrix(0, (org.apache.commons.math3.linear.FieldMatrix)array2DRowFieldMatrix5);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);

  }

  @Test
  public void test082() {}
// Defects4J: flaky method
//   @Test
//   public void test082() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test082"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     randomDataImpl0.reSeedSecure();
//     randomDataImpl0.reSeed();
//     randomDataImpl0.reSeedSecure(49L);
//     double d7 = randomDataImpl0.nextF(3.141592653589793d, 1.5707963267948966d);
//     int i10 = randomDataImpl0.nextSecureInt(0, 1);
//     // The following exception was thrown during execution in test generation
//     try {
//       int i14 = randomDataImpl0.nextHypergeometric(69, 2147483647, 2147483647);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException");
//     } catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NumberIsTooLargeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d7 == 0.11260404171742633d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i10 == 0);
// 
//   }

  @Test
  public void test083() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test083"); }


    double d1 = org.apache.commons.math3.util.FastMath.cbrt(0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.0d);

  }

  @Test
  public void test084() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test084"); }


    int[] i_array0 = null;
    int[] i_array3 = new int[] { 0, 100 };
    int[] i_array6 = new int[] { 0, 10 };
    int[] i_array8 = org.apache.commons.math3.util.MathArrays.copyOf(i_array6, 10);
    int[] i_array9 = org.apache.commons.math3.util.MathArrays.copyOf(i_array8);
    double d10 = org.apache.commons.math3.util.MathArrays.distance(i_array3, i_array9);
    // The following exception was thrown during execution in test generation
    try {
      int i11 = org.apache.commons.math3.util.MathArrays.distance1(i_array0, i_array9);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d10 == 90.0d);

  }

  @Test
  public void test085() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test085"); }


    double d2 = org.apache.commons.math3.util.Precision.round((-1.4221850306345674d), 49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == (-1.4221850306345674d));

  }

  @Test
  public void test086() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test086"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    org.apache.commons.math3.FieldElement fieldElement9 = null;
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setEntry(0, 9, fieldElement9);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);

  }

  @Test
  public void test087() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test087"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor7 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement8 = array2DRowFieldMatrix1.walkInOptimizedOrder(fieldMatrixChangingVisitor7);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);

  }

  @Test
  public void test088() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test088"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array1 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array2 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array1 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix4 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0, fieldElement_array_array2, false);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array2);

  }

  @Test
  public void test089() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test089"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement[][] fieldElement_array_array6 = array2DRowFieldMatrix1.getData();
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);

  }

  @Test
  public void test090() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test090"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector2, false);
    org.apache.commons.math3.linear.RealVectorPreservingVisitor realVectorPreservingVisitor5 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d6 = arrayRealVector2.walkInOptimizedOrder(realVectorPreservingVisitor5);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);

  }

  @Test
  public void test091() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test091"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    double[] d_array18 = new double[] { 0.0d };
    double[] d_array20 = org.apache.commons.math3.util.MathArrays.copyOf(d_array18, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector16, d_array20);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, false);
    int i29 = arrayRealVector28.getMaxIndex();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = arrayRealVector21.combineToSelf(0.0d, (-7.241149127564359d), (org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    double[] d_array31 = arrayRealVector21.toArray();
    double[] d_array32 = arrayRealVector21.toArray();
    org.apache.commons.math3.linear.RealVector realVector34 = arrayRealVector21.append(1.1102230246251565E-16d);
    java.lang.Double[] d_array36 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector39 = new org.apache.commons.math3.linear.ArrayRealVector(d_array36, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector47 = arrayRealVector39.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector46);
    org.apache.commons.math3.analysis.UnivariateFunction univariateFunction48 = null;
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector49 = arrayRealVector47.map(univariateFunction48);
    java.lang.Double[] d_array51 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector54 = new org.apache.commons.math3.linear.ArrayRealVector(d_array51, 0, 0);
    java.lang.Double[] d_array58 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector61 = new org.apache.commons.math3.linear.ArrayRealVector(d_array58, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector62 = arrayRealVector54.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector61);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector63 = arrayRealVector62.copy();
    org.apache.commons.math3.linear.RealVector realVector65 = arrayRealVector62.mapDivide(49.41408584662507d);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector49, arrayRealVector62);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector67 = arrayRealVector21.ebeMultiply((org.apache.commons.math3.linear.RealVector)arrayRealVector66);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i29 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector63);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector65);

  }

  @Test
  public void test092() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test092"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix3 = array2DRowFieldMatrix1.subtract(array2DRowFieldMatrix2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test093() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test093"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    java.lang.String str7 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.linear.AnyMatrix anyMatrix8 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.checkAdditionCompatible((org.apache.commons.math3.linear.AnyMatrix)array2DRowFieldMatrix1, anyMatrix8);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str7 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str7.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test094() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test094"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    int i13 = array2DRowRealMatrix9.getRowDimension();
    double[] d_array15 = new double[] { 100.0d };
    double[] d_array19 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b20 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array15, d_array19);
    double[] d_array22 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array19, 1.3440585709080678E43d);
    double[] d_array24 = org.apache.commons.math3.util.MathArrays.copyOf(d_array19, 1);
    double[] d_array25 = array2DRowRealMatrix9.operate(d_array24);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(10, 0.0d);
    org.apache.commons.math3.linear.RealVector realVector30 = arrayRealVector28.mapMultiplyToSelf(99.37864167209166d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVector realVector31 = array2DRowRealMatrix9.operate(realVector30);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i13 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector30);

  }

  @Test
  public void test095() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test095"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement6 = array2DRowFieldMatrix1.getEntry(69, 49);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test096() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test096"); }


    double d1 = org.apache.commons.math3.util.FastMath.ceil(23.624342922017807d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 24.0d);

  }

  @Test
  public void test097() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test097"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    boolean b2 = array2DRowRealMatrix0.isSquare();
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor3 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d8 = array2DRowRealMatrix0.walkInColumnOrder(realMatrixChangingVisitor3, 2147483647, 100, 10, 9);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);

  }

  @Test
  public void test098() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test098"); }


    double d2 = org.apache.commons.math3.util.FastMath.copySign(0.6892682844514348d, 1.315265444157678d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.6892682844514348d);

  }

  @Test
  public void test099() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test099"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    double[] d_array82 = new double[] { 0.0d };
    double[] d_array84 = org.apache.commons.math3.util.MathArrays.copyOf(d_array82, 1);
    double[][] d_array_array85 = new double[][] { d_array82 };
    org.apache.commons.math3.linear.RealMatrix realMatrix86 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix87 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    boolean b88 = arrayRealVector36.equals((java.lang.Object)d_array_array85);
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix89 = new org.apache.commons.math3.linear.BlockRealMatrix(d_array_array85);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix94 = blockRealMatrix89.getSubMatrix(10, 10, 49, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);

  }

  @Test
  public void test100() {}
// Defects4J: flaky method
//   @Test
//   public void test100() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test100"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
//     long long3 = randomDataGenerator0.nextLong((-1L), 0L);
//     double d5 = randomDataGenerator0.nextExponential(0.6892682844514348d);
//     randomDataGenerator0.reSeed(100L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long3 == 0L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d5 == 2.9993428361796024d);
// 
//   }

  @Test
  public void test101() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test101"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    java.lang.Integer[] i_array3 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array5 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException6 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array3, i_array5);
    java.lang.Integer[] i_array7 = multiDimensionMismatchException6.getExpectedDimensions();
    org.apache.commons.math3.exception.NotFiniteNumberException notFiniteNumberException8 = new org.apache.commons.math3.exception.NotFiniteNumberException(localizable0, (java.lang.Number)(-1), (java.lang.Object[])i_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array7);

  }

  @Test
  public void test102() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test102"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    boolean b7 = array2DRowFieldMatrix1.isSquare();
    org.apache.commons.math3.Field field9 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix10 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field9);
    boolean b12 = array2DRowFieldMatrix10.equals((java.lang.Object)(short)10);
    boolean b14 = array2DRowFieldMatrix10.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field15 = array2DRowFieldMatrix10.getField();
    java.lang.String str16 = array2DRowFieldMatrix10.toString();
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setRowMatrix(69, (org.apache.commons.math3.linear.FieldMatrix)array2DRowFieldMatrix10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str16 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str16.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test103() {}
// Defects4J: flaky method
//   @Test
//   public void test103() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test103"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
//     double d2 = randomDataGenerator0.nextT(0.07277703352123166d);
//     // The following exception was thrown during execution in test generation
//     try {
//       int i5 = randomDataGenerator0.nextZipf((-1), 101.0d);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
//     } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d2 == 1.1652445538367003E20d);
// 
//   }

  @Test
  public void test104() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test104"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    double d2 = well19937c1.nextDouble();
    well19937c1.setSeed(10L);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.07277703352123166d);

  }

  @Test
  public void test105() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test105"); }


    org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
    randomDataImpl0.reSeedSecure();
    randomDataImpl0.reSeed();
    randomDataImpl0.reSeed((-1L));

  }

  @Test
  public void test106() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test106"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    double[] d_array82 = new double[] { 0.0d };
    double[] d_array84 = org.apache.commons.math3.util.MathArrays.copyOf(d_array82, 1);
    double[][] d_array_array85 = new double[][] { d_array82 };
    org.apache.commons.math3.linear.RealMatrix realMatrix86 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix87 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    boolean b88 = arrayRealVector36.equals((java.lang.Object)d_array_array85);
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix89 = new org.apache.commons.math3.linear.BlockRealMatrix(d_array_array85);
    // The following exception was thrown during execution in test generation
    try {
      blockRealMatrix89.setEntry(52, 9, 3.4719061895220023d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);

  }

  @Test
  public void test107() {}
// Defects4J: flaky method
//   @Test
//   public void test107() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test107"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d2 = randomDataImpl0.nextT(0.8623188722876839d);
//     randomDataImpl0.reSeedSecure();
//     long long6 = randomDataImpl0.nextLong(0L, 100L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d2 == 0.916057346631253d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long6 == 44L);
// 
//   }

  @Test
  public void test108() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test108"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.DecompositionSolver decompositionSolver12 = eigenDecomposition11.getSolver();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVector realVector14 = eigenDecomposition11.getEigenvector(100);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(decompositionSolver12);

  }

  @Test
  public void test109() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test109"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.Field field2 = array2DRowFieldMatrix1.getField();
    org.apache.commons.math3.Field field3 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix4 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field3);
    boolean b6 = array2DRowFieldMatrix4.equals((java.lang.Object)(short)10);
    int i7 = array2DRowFieldMatrix4.getRowDimension();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix8 = array2DRowFieldMatrix1.preMultiply((org.apache.commons.math3.linear.FieldMatrix)array2DRowFieldMatrix4);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 0);

  }

  @Test
  public void test110() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test110"); }


    org.apache.commons.math3.linear.RealVectorFormat realVectorFormat3 = new org.apache.commons.math3.linear.RealVectorFormat(",", "", ",");

  }

  @Test
  public void test111() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test111"); }


    org.apache.commons.math3.exception.MathArithmeticException mathArithmeticException0 = new org.apache.commons.math3.exception.MathArithmeticException();
    org.apache.commons.math3.exception.util.ExceptionContext exceptionContext1 = mathArithmeticException0.getContext();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(exceptionContext1);

  }

  @Test
  public void test112() {}
// Defects4J: flaky method
//   @Test
//   public void test112() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test112"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     randomDataImpl0.reSeedSecure();
//     randomDataImpl0.reSeed();
//     randomDataImpl0.reSeedSecure(49L);
//     double d7 = randomDataImpl0.nextF(3.141592653589793d, 1.5707963267948966d);
//     double d10 = randomDataImpl0.nextF(0.6892682844514348d, 100.0d);
//     org.apache.commons.math3.random.RandomGenerator randomGenerator11 = null;
//     org.apache.commons.math3.distribution.NormalDistribution normalDistribution15 = new org.apache.commons.math3.distribution.NormalDistribution(randomGenerator11, 54.444384793244126d, 54.444384793244126d, 0.1754034190044697d);
//     double d16 = normalDistribution15.getNumericalMean();
//     boolean b17 = normalDistribution15.isSupportUpperBoundInclusive();
//     double d18 = randomDataImpl0.nextInversionDeviate((org.apache.commons.math3.distribution.RealDistribution)normalDistribution15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d7 == 21.840524586984657d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d10 == 7.2166419995096245d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d16 == 54.444384793244126d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b17 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d18 == 74.07163262740275d);
// 
//   }

  @Test
  public void test113() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test113"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat0 = org.apache.commons.math3.linear.MatrixUtils.DEFAULT_FORMAT;
    java.text.NumberFormat numberFormat1 = realMatrixFormat0.getFormat();
    java.lang.String str2 = realMatrixFormat0.getColumnSeparator();
    java.text.ParsePosition parsePosition4 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix5 = realMatrixFormat0.parse("", parsePosition4);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrixFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str2 + "' != '" + ","+ "'", str2.equals(","));

  }

  @Test
  public void test114() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test114"); }


    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection3 = null;
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException5 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)2.775557561562891E-17d, (java.lang.Number)2.466889252024757d, (-1), orderDirection3, false);

  }

  @Test
  public void test115() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test115"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    double[] d_array18 = new double[] { 0.0d };
    double[] d_array20 = org.apache.commons.math3.util.MathArrays.copyOf(d_array18, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector16, d_array20);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, false);
    int i29 = arrayRealVector28.getMaxIndex();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = arrayRealVector21.combineToSelf(0.0d, (-7.241149127564359d), (org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    double[] d_array31 = arrayRealVector21.toArray();
    double d32 = org.apache.commons.math3.util.MathArrays.safeNorm(d_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i29 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d32 == 72.41149127564358d);

  }

  @Test
  public void test116() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test116"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    int i2 = array2DRowRealMatrix0.getRowDimension();
    org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor3 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
    double d4 = array2DRowRealMatrix0.walkInColumnOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor3);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix6 = array2DRowRealMatrix0.scalarAdd(2.9993428361796024d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 0.0d);

  }

  @Test
  public void test117() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test117"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix12 = eigenDecomposition11.getVT();
    double[] d_array13 = eigenDecomposition11.getRealEigenvalues();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);

  }

  @Test
  public void test118() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test118"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    int i5 = arrayRealVector4.getDimension();
    double[] d_array6 = arrayRealVector4.toArray();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector7 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector4);
    org.apache.commons.math3.linear.RealVector realVector9 = arrayRealVector4.mapSubtract(2.775557561562891E-17d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector9);

  }

  @Test
  public void test119() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test119"); }


    double d1 = org.apache.commons.math3.util.FastMath.ulp(1.3440585709080678E43d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 2.4758800785707605E27d);

  }

  @Test
  public void test120() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test120"); }


    float f2 = org.apache.commons.math3.util.FastMath.min(Float.NaN, (-1.0f));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((float)f2, Float.NaN, 0);

  }

  @Test
  public void test121() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test121"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor5 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement6 = array2DRowFieldMatrix1.walkInOptimizedOrder(fieldMatrixPreservingVisitor5);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);

  }

  @Test
  public void test122() {}
// Defects4J: flaky method
//   @Test
//   public void test122() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test122"); }
// 
// 
//     double[] d_array1 = new double[] { 0.0d };
//     double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
//     double[][] d_array_array4 = new double[][] { d_array1 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
//     org.apache.commons.math3.exception.util.Localizable localizable9 = null;
//     double[] d_array11 = new double[] { 0.0d };
//     double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
//     double[][] d_array_array14 = new double[][] { d_array11 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
//     org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix26 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
//     double[][] d_array_array27 = array2DRowRealMatrix26.getDataRef();
//     boolean b28 = array2DRowRealMatrix26.isSquare();
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl29 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d32 = randomDataImpl29.nextUniform((-1.0d), 100.0d);
//     int[] i_array35 = randomDataImpl29.nextPermutation(10, 1);
//     int i38 = randomDataImpl29.nextZipf(52, 4.641588833612779d);
//     boolean b39 = array2DRowRealMatrix26.equals((java.lang.Object)randomDataImpl29);
//     boolean b40 = array2DRowRealMatrix8.equals((java.lang.Object)array2DRowRealMatrix26);
//     java.io.ObjectOutputStream objectOutputStream41 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       org.apache.commons.math3.linear.MatrixUtils.serializeRealMatrix((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix8, objectOutputStream41);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(d_array_array27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b28 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d32 == 58.646369068695776d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i38 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b39 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b40 == false);
// 
//   }

  @Test
  public void test123() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test123"); }


    double d2 = org.apache.commons.math3.util.FastMath.atan2(0.17451622721454543d, 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 1.5707963267948966d);

  }

  @Test
  public void test124() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test124"); }


    double[] d_array0 = new double[] {  };
    double[] d_array2 = new double[] { 100.0d };
    double[] d_array6 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b7 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array2, d_array6);
    double d8 = org.apache.commons.math3.util.MathArrays.distance(d_array0, d_array6);
    double[] d_array9 = org.apache.commons.math3.util.MathArrays.copyOf(d_array0);
    double[] d_array11 = new double[] { 100.0d };
    double[] d_array15 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b16 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array11, d_array15);
    double[] d_array18 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array15, 1.3440585709080678E43d);
    boolean b19 = org.apache.commons.math3.util.MathArrays.equals(d_array0, d_array15);
    double[] d_array21 = new double[] { 0.0d };
    double[] d_array23 = org.apache.commons.math3.util.MathArrays.copyOf(d_array21, 1);
    double[] d_array25 = new double[] { 100.0d };
    double[] d_array29 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b30 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array25, d_array29);
    boolean b31 = org.apache.commons.math3.util.MathArrays.equals(d_array21, d_array25);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector32 = new org.apache.commons.math3.linear.ArrayRealVector(d_array21);
    org.apache.commons.math3.linear.RealMatrix realMatrix33 = org.apache.commons.math3.linear.MatrixUtils.createRealDiagonalMatrix(d_array21);
    // The following exception was thrown during execution in test generation
    try {
      double[] d_array34 = org.apache.commons.math3.util.MathArrays.ebeMultiply(d_array15, d_array21);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b30 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b31 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix33);

  }

  @Test
  public void test125() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test125"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    org.apache.commons.math3.analysis.UnivariateFunction univariateFunction17 = null;
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = arrayRealVector16.mapToSelf(univariateFunction17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector18);

  }

  @Test
  public void test126() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test126"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix12 = eigenDecomposition11.getVT();
    // The following exception was thrown during execution in test generation
    try {
      double d14 = eigenDecomposition11.getImagEigenvalue(69);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix12);

  }

  @Test
  public void test127() {}
// Defects4J: flaky method
//   @Test
//   public void test127() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test127"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d3 = randomDataImpl0.nextUniform((-1.0d), 100.0d);
//     // The following exception was thrown during execution in test generation
//     try {
//       double d6 = randomDataImpl0.nextBeta(1.2104058782952831d, 0.0d);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoBracketingException");
//     } catch (org.apache.commons.math3.exception.NoBracketingException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NoBracketingException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoBracketingException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == 0.3042133750593863d);
// 
//   }

  @Test
  public void test128() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test128"); }


    float f2 = org.apache.commons.math3.util.FastMath.max((-0.9999999f), 50.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f2 == 50.0f);

  }

  @Test
  public void test129() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test129"); }


    float[] f_array1 = new float[] { (-1.0f) };
    float[] f_array4 = new float[] { 10.0f, 100.0f };
    boolean b5 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(f_array1, f_array4);
    float[] f_array7 = new float[] { (-1.0f) };
    float[] f_array10 = new float[] { 10.0f, 100.0f };
    boolean b11 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(f_array7, f_array10);
    boolean b12 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(f_array1, f_array7);
    float[] f_array15 = new float[] { 100.0f, 10.0f };
    boolean b16 = org.apache.commons.math3.util.MathArrays.equals(f_array1, f_array15);
    float[] f_array18 = new float[] { (-1.0f) };
    float[] f_array21 = new float[] { 10.0f, 100.0f };
    boolean b22 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(f_array18, f_array21);
    float[] f_array24 = new float[] { (-1.0f) };
    float[] f_array27 = new float[] { 10.0f, 100.0f };
    boolean b28 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(f_array24, f_array27);
    boolean b29 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(f_array18, f_array24);
    float[] f_array32 = new float[] { 100.0f, 10.0f };
    boolean b33 = org.apache.commons.math3.util.MathArrays.equals(f_array18, f_array32);
    boolean b34 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(f_array1, f_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b29 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(f_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b33 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b34 == false);

  }

  @Test
  public void test130() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test130"); }


    int i1 = org.apache.commons.math3.util.FastMath.getExponent(4.50519966752906d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == 2);

  }

  @Test
  public void test131() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test131"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.NumberIsTooSmallException numberIsTooSmallException4 = new org.apache.commons.math3.exception.NumberIsTooSmallException(localizable0, (java.lang.Number)0.19172688492398912d, (java.lang.Number)0.76195765f, false);

  }

  @Test
  public void test132() {}
// Defects4J: flaky method
//   @Test
//   public void test132() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test132"); }
// 
// 
//     org.apache.commons.math3.exception.util.Localizable localizable0 = null;
//     double[] d_array2 = new double[] { 0.0d };
//     double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
//     double[][] d_array_array5 = new double[][] { d_array2 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
//     org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
//     java.lang.String str12 = array2DRowRealMatrix9.toString();
//     double d13 = array2DRowRealMatrix9.getNorm();
//     double[] d_array15 = new double[] { 0.0d };
//     double[] d_array17 = org.apache.commons.math3.util.MathArrays.copyOf(d_array15, 1);
//     double[][] d_array_array18 = new double[][] { d_array15 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix19 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array18);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix20 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array18);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix22 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array18, false);
//     org.apache.commons.math3.exception.util.Localizable localizable23 = null;
//     double[] d_array25 = new double[] { 0.0d };
//     double[] d_array27 = org.apache.commons.math3.util.MathArrays.copyOf(d_array25, 1);
//     double[][] d_array_array28 = new double[][] { d_array25 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix29 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array28);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix30 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array28);
//     org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException31 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable23, (java.lang.Object[])d_array_array28);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix32 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array28);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition34 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix32, 1.3440585709080678E43d);
//     org.apache.commons.math3.linear.RealMatrix realMatrix36 = array2DRowRealMatrix32.scalarAdd(0.3932953321069236d);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition38 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix32, 4.9E-324d);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix39 = array2DRowRealMatrix22.subtract(array2DRowRealMatrix32);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix40 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
//     double[][] d_array_array41 = array2DRowRealMatrix40.getDataRef();
//     boolean b42 = array2DRowRealMatrix40.isSquare();
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl43 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d46 = randomDataImpl43.nextUniform((-1.0d), 100.0d);
//     int[] i_array49 = randomDataImpl43.nextPermutation(10, 1);
//     int i52 = randomDataImpl43.nextZipf(52, 4.641588833612779d);
//     boolean b53 = array2DRowRealMatrix40.equals((java.lang.Object)randomDataImpl43);
//     boolean b54 = array2DRowRealMatrix22.equals((java.lang.Object)array2DRowRealMatrix40);
//     org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor55 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
//     double d56 = array2DRowRealMatrix22.walkInColumnOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor55);
//     double d57 = array2DRowRealMatrix9.walkInOptimizedOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor55);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array2);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix6);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d13 == 0.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array17);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array18);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix19);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array28);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix29);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix36);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(array2DRowRealMatrix39);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(d_array_array41);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b42 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d46 == 91.72846348246509d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array49);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i52 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b53 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b54 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d56 == 0.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d57 == 0.0d);
// 
//   }

  @Test
  public void test133() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test133"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    java.lang.String str7 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.FieldElement fieldElement8 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array9 = new org.apache.commons.math3.FieldElement[] { fieldElement8 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement[] fieldElement_array10 = array2DRowFieldMatrix1.operate(fieldElement_array9);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str7 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str7.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array9);

  }

  @Test
  public void test134() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test134"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    double[] d_array82 = new double[] { 0.0d };
    double[] d_array84 = org.apache.commons.math3.util.MathArrays.copyOf(d_array82, 1);
    double[][] d_array_array85 = new double[][] { d_array82 };
    org.apache.commons.math3.linear.RealMatrix realMatrix86 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix87 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    boolean b88 = arrayRealVector36.equals((java.lang.Object)d_array_array85);
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix89 = new org.apache.commons.math3.linear.BlockRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix90 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix91 = blockRealMatrix89.multiply(blockRealMatrix90);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);

  }

  @Test
  public void test135() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test135"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
    double[][] d_array_array9 = array2DRowRealMatrix8.getData();
    double[] d_array11 = new double[] { 100.0d };
    double[] d_array15 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b16 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array11, d_array15);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException20 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.0f, (java.lang.Number)(short)100, 10);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection21 = nonMonotonicSequenceException20.getDirection();
    boolean b23 = org.apache.commons.math3.util.MathArrays.isMonotonic(d_array11, orderDirection21, false);
    double[] d_array24 = array2DRowRealMatrix8.operate(d_array11);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 49, 156287497);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException");
    } catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NumberIsTooLargeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array24);

  }

  @Test
  public void test136() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test136"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    double[] d_array82 = new double[] { 0.0d };
    double[] d_array84 = org.apache.commons.math3.util.MathArrays.copyOf(d_array82, 1);
    double[][] d_array_array85 = new double[][] { d_array82 };
    org.apache.commons.math3.linear.RealMatrix realMatrix86 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix87 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    boolean b88 = arrayRealVector36.equals((java.lang.Object)d_array_array85);
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix89 = new org.apache.commons.math3.linear.BlockRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor90 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
    // The following exception was thrown during execution in test generation
    try {
      double d95 = blockRealMatrix89.walkInRowOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor90, 9, 69, 156287497, 156287497);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);

  }

  @Test
  public void test137() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test137"); }


    org.apache.commons.math3.exception.NotStrictlyPositiveException notStrictlyPositiveException1 = new org.apache.commons.math3.exception.NotStrictlyPositiveException((java.lang.Number)1.5596856728972892d);
    org.apache.commons.math3.exception.util.Localizable localizable2 = null;
    org.apache.commons.math3.exception.util.Localizable localizable3 = null;
    java.lang.Double[] d_array6 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector7 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6);
    org.apache.commons.math3.exception.MaxCountExceededException maxCountExceededException8 = new org.apache.commons.math3.exception.MaxCountExceededException(localizable3, (java.lang.Number)0.9956942709230656d, (java.lang.Object[])d_array6);
    org.apache.commons.math3.exception.MathIllegalStateException mathIllegalStateException9 = new org.apache.commons.math3.exception.MathIllegalStateException((java.lang.Throwable)notStrictlyPositiveException1, localizable2, (java.lang.Object[])d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);

  }

  @Test
  public void test138() {}
// Defects4J: flaky method
//   @Test
//   public void test138() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test138"); }
// 
// 
//     org.apache.commons.math3.random.Well19937c well19937c0 = new org.apache.commons.math3.random.Well19937c();
//     long long1 = well19937c0.nextLong();
//     float f2 = well19937c0.nextFloat();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long1 == (-8706929317658494603L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(f2 == 0.091349006f);
// 
//   }

  @Test
  public void test139() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test139"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
    org.apache.commons.math3.exception.util.Localizable localizable9 = null;
    double[] d_array11 = new double[] { 0.0d };
    double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
    double[][] d_array_array14 = new double[][] { d_array11 };
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
    org.apache.commons.math3.linear.RealMatrix realMatrix27 = array2DRowRealMatrix25.power(1);
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor28 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d33 = array2DRowRealMatrix25.walkInColumnOrder(realMatrixChangingVisitor28, 1, 43, 0, 69);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix27);

  }

  @Test
  public void test140() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test140"); }


    float f2 = org.apache.commons.math3.util.FastMath.min(50.0f, 0.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f2 == 0.0f);

  }

  @Test
  public void test141() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test141"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array22 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector25 = new org.apache.commons.math3.linear.ArrayRealVector(d_array22, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = arrayRealVector18.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector25);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = arrayRealVector26.copy();
    java.lang.Double[] d_array29 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector32 = new org.apache.commons.math3.linear.ArrayRealVector(d_array29, 0, 0);
    java.lang.Double[] d_array34 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector37 = new org.apache.commons.math3.linear.ArrayRealVector(d_array34, 0, 0);
    java.lang.Double[] d_array39 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector42 = new org.apache.commons.math3.linear.ArrayRealVector(d_array39, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector43 = arrayRealVector37.append((org.apache.commons.math3.linear.RealVector)arrayRealVector42);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector44 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector32, arrayRealVector42);
    double[] d_array46 = new double[] { 0.0d };
    double[] d_array48 = org.apache.commons.math3.util.MathArrays.copyOf(d_array46, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector49 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector44, d_array48);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector50 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector27, arrayRealVector44);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector12, arrayRealVector50);
    boolean b52 = arrayRealVector12.isNaN();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b52 == false);

  }

  @Test
  public void test142() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test142"); }


    double d2 = org.apache.commons.math3.util.FastMath.hypot(0.1754034190044697d, 49.66762847873805d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 49.667938200224796d);

  }

  @Test
  public void test143() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test143"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8);
    org.apache.commons.math3.linear.RealVector realVector13 = array2DRowRealMatrix6.operate((org.apache.commons.math3.linear.RealVector)arrayRealVector12);
    int i14 = array2DRowRealMatrix6.getRowDimension();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i14 == 1);

  }

  @Test
  public void test144() {}
// Defects4J: flaky method
//   @Test
//   public void test144() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test144"); }
// 
// 
//     double[] d_array1 = new double[] { 0.0d };
//     double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
//     double[][] d_array_array4 = new double[][] { d_array1 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
//     org.apache.commons.math3.exception.util.Localizable localizable9 = null;
//     double[] d_array11 = new double[] { 0.0d };
//     double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
//     double[][] d_array_array14 = new double[][] { d_array11 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
//     org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix26 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
//     double[][] d_array_array27 = array2DRowRealMatrix26.getDataRef();
//     boolean b28 = array2DRowRealMatrix26.isSquare();
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl29 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d32 = randomDataImpl29.nextUniform((-1.0d), 100.0d);
//     int[] i_array35 = randomDataImpl29.nextPermutation(10, 1);
//     int i38 = randomDataImpl29.nextZipf(52, 4.641588833612779d);
//     boolean b39 = array2DRowRealMatrix26.equals((java.lang.Object)randomDataImpl29);
//     boolean b40 = array2DRowRealMatrix8.equals((java.lang.Object)array2DRowRealMatrix26);
//     // The following exception was thrown during execution in test generation
//     try {
//       org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition41 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix26);
//       org.junit.Assert.fail("Expected exception of type java.lang.NegativeArraySizeException");
//     } catch (java.lang.NegativeArraySizeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NegativeArraySizeException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NegativeArraySizeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(d_array_array27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b28 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d32 == 98.43844795068216d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i38 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b39 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b40 == false);
// 
//   }

  @Test
  public void test145() {}
// Defects4J: flaky method
//   @Test
//   public void test145() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test145"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
//     randomDataGenerator0.reSeedSecure(6179557979701623951L);
//     int i5 = randomDataGenerator0.nextSecureInt(0, 52);
//     // The following exception was thrown during execution in test generation
//     try {
//       int i8 = randomDataGenerator0.nextPascal(10, 2.4758800785707605E27d);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
//     } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i5 == 19);
// 
//   }

  @Test
  public void test146() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test146"); }


    // The following exception was thrown during execution in test generation
    try {
      double d3 = org.apache.commons.math3.util.Precision.round(0.0d, 100, 100);
      org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException");
    } catch (java.lang.IllegalArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.IllegalArgumentException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.IllegalArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test147() {}
// Defects4J: flaky method
//   @Test
//   public void test147() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test147"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
//     randomDataGenerator0.reSeedSecure(6179557979701623951L);
//     int i5 = randomDataGenerator0.nextSecureInt(0, 1);
//     double d8 = randomDataGenerator0.nextF(0.19172688492398912d, 1.3622825063580968d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i5 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d8 == 0.0032444438954024163d);
// 
//   }

  @Test
  public void test148() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test148"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    java.lang.String str7 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor8 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement13 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixChangingVisitor8, (-1), 52, 0, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str7 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str7.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test149() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test149"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    double d2 = well19937c1.nextDouble();
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution6 = new org.apache.commons.math3.distribution.NormalDistribution((org.apache.commons.math3.random.RandomGenerator)well19937c1, 1.0E-6d, 2.7755575615628914E-17d, (-1.0d));
    well19937c1.clear();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.07277703352123166d);

  }

  @Test
  public void test150() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test150"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    double d2 = well19937c1.nextDouble();
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution6 = new org.apache.commons.math3.distribution.NormalDistribution((org.apache.commons.math3.random.RandomGenerator)well19937c1, 1.0E-6d, 2.7755575615628914E-17d, (-1.0d));
    double d8 = normalDistribution6.probability(2.6881171418161356E43d);
    double d11 = normalDistribution6.cumulativeProbability(10.04987562112089d, 1.3440585709080678E43d);
    double d12 = normalDistribution6.getStandardDeviation();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.07277703352123166d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d11 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d12 == 2.7755575615628914E-17d);

  }

  @Test
  public void test151() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test151"); }


    double d2 = org.apache.commons.math3.util.FastMath.log(0.0d, 0.3921994840967409d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.0d);

  }

  @Test
  public void test152() {}
// Defects4J: flaky method
//   @Test
//   public void test152() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test152"); }
// 
// 
//     double[] d_array1 = new double[] { 0.0d };
//     double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
//     double[][] d_array_array4 = new double[][] { d_array1 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
//     org.apache.commons.math3.exception.util.Localizable localizable9 = null;
//     double[] d_array11 = new double[] { 0.0d };
//     double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
//     double[][] d_array_array14 = new double[][] { d_array11 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
//     org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix26 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
//     double[][] d_array_array27 = array2DRowRealMatrix26.getDataRef();
//     boolean b28 = array2DRowRealMatrix26.isSquare();
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl29 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d32 = randomDataImpl29.nextUniform((-1.0d), 100.0d);
//     int[] i_array35 = randomDataImpl29.nextPermutation(10, 1);
//     int i38 = randomDataImpl29.nextZipf(52, 4.641588833612779d);
//     boolean b39 = array2DRowRealMatrix26.equals((java.lang.Object)randomDataImpl29);
//     boolean b40 = array2DRowRealMatrix8.equals((java.lang.Object)array2DRowRealMatrix26);
//     org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor41 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
//     double d42 = array2DRowRealMatrix8.walkInColumnOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor41);
//     org.apache.commons.math3.linear.MatrixUtils.checkColumnIndex((org.apache.commons.math3.linear.AnyMatrix)array2DRowRealMatrix8, 0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(d_array_array27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b28 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d32 == 99.72385498121952d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i38 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b39 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b40 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d42 == 0.0d);
// 
//   }

  @Test
  public void test153() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test153"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.FieldElement fieldElement4 = null;
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.multiplyEntry(1, 10, fieldElement4);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test154() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test154"); }


    double d1 = org.apache.commons.math3.util.FastMath.sqrt(0.1586552539359014d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.3983155205812365d);

  }

  @Test
  public void test155() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test155"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    org.apache.commons.math3.linear.RealVector realVector82 = realVector80.mapMultiply(Double.NaN);
    org.apache.commons.math3.util.MathUtils.checkNotNull((java.lang.Object)realVector82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector82);

  }

  @Test
  public void test156() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test156"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector12.mapDivide(49.41408584662507d);
    org.apache.commons.math3.linear.RealVectorPreservingVisitor realVectorPreservingVisitor16 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d17 = arrayRealVector12.walkInDefaultOrder(realVectorPreservingVisitor16);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);

  }

  @Test
  public void test157() {}
// Defects4J: flaky method
//   @Test
//   public void test157() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test157"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d3 = randomDataImpl0.nextUniform((-1.0d), 100.0d);
//     int[] i_array6 = randomDataImpl0.nextPermutation(10, 1);
//     // The following exception was thrown during execution in test generation
//     try {
//       int i10 = randomDataImpl0.nextHypergeometric(0, 49, 1);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
//     } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d3 == 11.548370188579186d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array6);
// 
//   }

  @Test
  public void test158() {}
// Defects4J: flaky method
//   @Test
//   public void test158() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test158"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
//     double d2 = randomDataGenerator0.nextT(0.07277703352123166d);
//     double d4 = randomDataGenerator0.nextExponential(1.9913885418461312d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d2 == 3.2180494402710503E20d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d4 == 0.990730617910627d);
// 
//   }

  @Test
  public void test159() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test159"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.transpose();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);

  }

  @Test
  public void test160() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test160"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix6 = array2DRowFieldMatrix1.copy();
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);

  }

  @Test
  public void test161() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test161"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.util.Localizable localizable3 = null;
    java.lang.Integer[] i_array5 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array7 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException8 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array5, i_array7);
    org.apache.commons.math3.util.MathUtils.checkNotNull((java.lang.Object)0.0d, localizable3, (java.lang.Object[])i_array7);
    org.apache.commons.math3.exception.util.Localizable localizable10 = null;
    java.lang.Integer[] i_array12 = new java.lang.Integer[] { 10 };
    java.lang.Integer[] i_array14 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array16 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException17 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array14, i_array16);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException18 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(localizable10, i_array12, i_array14);
    org.apache.commons.math3.exception.util.Localizable localizable19 = null;
    java.lang.Integer[] i_array21 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array23 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException24 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array21, i_array23);
    org.apache.commons.math3.exception.NullArgumentException nullArgumentException25 = new org.apache.commons.math3.exception.NullArgumentException(localizable19, (java.lang.Object[])i_array21);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException26 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array12, i_array21);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException27 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array7, i_array21);
    double[] d_array29 = new double[] { 100.0d };
    double[] d_array33 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b34 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array29, d_array33);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException38 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.0f, (java.lang.Number)(short)100, 10);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection39 = nonMonotonicSequenceException38.getDirection();
    boolean b41 = org.apache.commons.math3.util.MathArrays.isMonotonic(d_array29, orderDirection39, false);
    boolean b43 = org.apache.commons.math3.util.MathArrays.<java.lang.Comparable>isMonotonic((java.lang.Comparable[])i_array21, orderDirection39, true);
    org.apache.commons.math3.exception.NotFiniteNumberException notFiniteNumberException44 = new org.apache.commons.math3.exception.NotFiniteNumberException(localizable0, (java.lang.Number)(-1.4221850306345674d), (java.lang.Object[])i_array21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b34 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b41 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b43 == true);

  }

  @Test
  public void test162() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test162"); }


    int i1 = org.apache.commons.math3.util.FastMath.round((-1.0f));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == (-1));

  }

  @Test
  public void test163() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test163"); }


    org.apache.commons.math3.random.RandomGenerator randomGenerator0 = null;
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution4 = new org.apache.commons.math3.distribution.NormalDistribution(randomGenerator0, 54.444384793244126d, 54.444384793244126d, 0.1754034190044697d);
    double d5 = normalDistribution4.getNumericalVariance();
    double d6 = normalDistribution4.getSupportLowerBound();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 2964.191035514832d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == Double.NEGATIVE_INFINITY);

  }

  @Test
  public void test164() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test164"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);

  }

  @Test
  public void test165() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test165"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[] d_array5 = new double[] { 100.0d };
    double[] d_array9 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b10 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array5, d_array9);
    boolean b11 = org.apache.commons.math3.util.MathArrays.equals(d_array1, d_array5);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.RealVector realVector14 = arrayRealVector12.mapAdd(3.1622776601683795d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector14);

  }

  @Test
  public void test166() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test166"); }


    org.apache.commons.math3.FieldElement[] fieldElement_array2 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array3 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array2 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.BlockFieldMatrix blockFieldMatrix5 = new org.apache.commons.math3.linear.BlockFieldMatrix(9, 0, fieldElement_array_array3, false);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array3);

  }

  @Test
  public void test167() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test167"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    java.lang.Double[] d_array2 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector5 = new org.apache.commons.math3.linear.ArrayRealVector(d_array2, 0, 0);
    java.lang.Double[] d_array7 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector10 = new org.apache.commons.math3.linear.ArrayRealVector(d_array7, 0, 0);
    java.lang.Double[] d_array12 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector15 = new org.apache.commons.math3.linear.ArrayRealVector(d_array12, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector16 = arrayRealVector10.append((org.apache.commons.math3.linear.RealVector)arrayRealVector15);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector17 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector5, arrayRealVector15);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVector realVector18 = array2DRowRealMatrix0.operateTranspose((org.apache.commons.math3.linear.RealVector)arrayRealVector5);
      org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException");
    } catch (java.lang.UnsupportedOperationException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.UnsupportedOperationException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector16);

  }

  @Test
  public void test168() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test168"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    org.apache.commons.math3.Field field7 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix8 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field7);
    boolean b10 = array2DRowFieldMatrix8.equals((java.lang.Object)(short)10);
    int i11 = array2DRowFieldMatrix8.getRowDimension();
    boolean b12 = array2DRowFieldMatrix8.isSquare();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix13 = array2DRowFieldMatrix1.subtract((org.apache.commons.math3.linear.FieldMatrix)array2DRowFieldMatrix8);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i11 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);

  }

  @Test
  public void test169() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test169"); }


    java.lang.Number number0 = null;
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException6 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.3440585709080678E43d, (java.lang.Number)1.3440585709080678E43d, 2147483647);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection7 = nonMonotonicSequenceException6.getDirection();
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException9 = new org.apache.commons.math3.exception.NonMonotonicSequenceException(number0, (java.lang.Number)49.41408584662507d, 156287497, orderDirection7, true);
    java.lang.Number number10 = nonMonotonicSequenceException9.getPrevious();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + number10 + "' != '" + 49.41408584662507d+ "'", number10.equals(49.41408584662507d));

  }

  @Test
  public void test170() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test170"); }


    int i3 = org.apache.commons.math3.util.Precision.compareTo(7.703719777548943E-34d, 0.0d, 1.2548583213158613d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i3 == 0);

  }

  @Test
  public void test171() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test171"); }


    java.text.ParsePosition parsePosition1 = null;
    // The following exception was thrown during execution in test generation
    try {
      char char2 = org.apache.commons.math3.util.CompositeFormat.parseNextCharacter("1", parsePosition1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test172() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test172"); }


    java.lang.Number number1 = null;
    org.apache.commons.math3.exception.OutOfRangeException outOfRangeException3 = new org.apache.commons.math3.exception.OutOfRangeException((java.lang.Number)7.241149127564359d, number1, (java.lang.Number)1.6931640502651133d);

  }

  @Test
  public void test173() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test173"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat0 = org.apache.commons.math3.linear.RealMatrixFormat.getInstance();
    java.lang.String str1 = realMatrixFormat0.getRowSeparator();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrixFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + ","+ "'", str1.equals(","));

  }

  @Test
  public void test174() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test174"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    java.lang.String str7 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.linear.FieldVector fieldVector8 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldVector fieldVector9 = array2DRowFieldMatrix1.preMultiply(fieldVector8);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str7 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str7.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test175() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test175"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    int i13 = array2DRowRealMatrix9.getRowDimension();
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = array2DRowRealMatrix9.scalarMultiply(3.1622776601683795d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i13 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);

  }

  @Test
  public void test176() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test176"); }


    double d1 = org.apache.commons.math3.util.FastMath.nextUp(3.4091431702387944d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 3.409143170238795d);

  }

  @Test
  public void test177() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test177"); }


    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(2, 3.2180494402710503E20d);

  }

  @Test
  public void test178() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test178"); }


    int i1 = org.apache.commons.math3.util.FastMath.abs(49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == 49);

  }

  @Test
  public void test179() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test179"); }


    boolean b2 = org.apache.commons.math3.util.Precision.equalsIncludingNaN(101.0d, 1.2104058782952831d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);

  }

  @Test
  public void test180() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test180"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor7 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement12 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixPreservingVisitor7, 100, 156287497, 49, 9);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test181() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test181"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array8 = new double[] { 100.0d };
    double[] d_array12 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b13 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array8, d_array12);
    boolean b14 = org.apache.commons.math3.util.MathArrays.equals(d_array1, d_array12);
    double[] d_array16 = new double[] { 100.0d };
    double[] d_array20 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b21 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array16, d_array20);
    double[] d_array23 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array20, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector24 = new org.apache.commons.math3.linear.ArrayRealVector(d_array12, d_array20);
    double d25 = arrayRealVector24.getNorm();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b21 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d25 == 141.42842712835352d);

  }

  @Test
  public void test182() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test182"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
    double[][] d_array_array9 = array2DRowRealMatrix8.getData();
    double[] d_array11 = new double[] { 100.0d };
    double[] d_array15 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b16 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array11, d_array15);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException20 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.0f, (java.lang.Number)(short)100, 10);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection21 = nonMonotonicSequenceException20.getDirection();
    boolean b23 = org.apache.commons.math3.util.MathArrays.isMonotonic(d_array11, orderDirection21, false);
    double[] d_array24 = array2DRowRealMatrix8.operate(d_array11);
    double[] d_array26 = new double[] { 0.0d };
    double[] d_array28 = org.apache.commons.math3.util.MathArrays.copyOf(d_array26, 1);
    double[] d_array30 = new double[] { 100.0d };
    double[] d_array34 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b35 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array30, d_array34);
    boolean b36 = org.apache.commons.math3.util.MathArrays.equals(d_array26, d_array30);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException40 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.3440585709080678E43d, (java.lang.Number)1.3440585709080678E43d, 2147483647);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection41 = nonMonotonicSequenceException40.getDirection();
    org.apache.commons.math3.exception.util.Localizable localizable42 = null;
    double[] d_array44 = new double[] { 0.0d };
    double[] d_array46 = org.apache.commons.math3.util.MathArrays.copyOf(d_array44, 1);
    double[][] d_array_array47 = new double[][] { d_array44 };
    org.apache.commons.math3.linear.RealMatrix realMatrix48 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array47);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix49 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array47);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException50 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable42, (java.lang.Object[])d_array_array47);
    org.apache.commons.math3.util.MathArrays.sortInPlace(d_array26, orderDirection41, d_array_array47);
    boolean b54 = org.apache.commons.math3.util.MathArrays.checkOrder(d_array24, orderDirection41, false, true);
    java.lang.Double[] d_array56 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector57 = new org.apache.commons.math3.linear.ArrayRealVector(d_array56);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector59 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector57, false);
    org.apache.commons.math3.linear.RealVector realVector61 = arrayRealVector59.mapSubtract(10.04987562112089d);
    double[] d_array62 = arrayRealVector59.toArray();
    // The following exception was thrown during execution in test generation
    try {
      double d63 = org.apache.commons.math3.util.MathArrays.linearCombination(d_array24, d_array62);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b54 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);

  }

  @Test
  public void test183() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test183"); }


    org.apache.commons.math3.Field field0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix3 = org.apache.commons.math3.linear.MatrixUtils.<org.apache.commons.math3.FieldElement>createFieldMatrix(field0, 1, 52);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test184() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test184"); }


    org.apache.commons.math3.Field field0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.BlockFieldMatrix blockFieldMatrix3 = new org.apache.commons.math3.linear.BlockFieldMatrix(field0, 2, 2147483647);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test185() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test185"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    well19937c1.setSeed(10);
    float f4 = well19937c1.nextFloat();
    org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator5 = new org.apache.commons.math3.random.RandomDataGenerator((org.apache.commons.math3.random.RandomGenerator)well19937c1);
    // The following exception was thrown during execution in test generation
    try {
      randomDataGenerator5.setSecureAlgorithm("}", "d45583f416");
      org.junit.Assert.fail("Expected exception of type java.security.NoSuchProviderException");
    } catch (java.security.NoSuchProviderException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.security.NoSuchProviderException")) {
        org.junit.Assert.fail("Expected exception of type java.security.NoSuchProviderException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f4 == 0.76195765f);

  }

  @Test
  public void test186() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test186"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition15 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 4.9E-324d);
    java.io.ObjectInputStream objectInputStream17 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.deserializeRealMatrix((java.lang.Object)eigenDecomposition15, "1", objectInputStream17);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);

  }

  @Test
  public void test187() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test187"); }


    float f2 = org.apache.commons.math3.util.FastMath.scalb(1.0f, 100);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f2 == 1.2676506E30f);

  }

  @Test
  public void test188() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test188"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.RealMatrix realMatrix8 = array2DRowRealMatrix6.scalarMultiply(0.0d);
    double[] d_array10 = new double[] { 0.0d };
    double[] d_array12 = org.apache.commons.math3.util.MathArrays.copyOf(d_array10, 1);
    double[] d_array14 = new double[] { 100.0d };
    double[] d_array18 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b19 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array14, d_array18);
    boolean b20 = org.apache.commons.math3.util.MathArrays.equals(d_array10, d_array14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(d_array10);
    org.apache.commons.math3.linear.RealMatrix realMatrix22 = org.apache.commons.math3.linear.MatrixUtils.createRealDiagonalMatrix(d_array10);
    org.apache.commons.math3.linear.RealMatrix realMatrix23 = array2DRowRealMatrix6.add(realMatrix22);
    org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor24 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
    double d25 = defaultRealMatrixPreservingVisitor24.end();
    // The following exception was thrown during execution in test generation
    try {
      double d30 = array2DRowRealMatrix6.walkInColumnOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor24, 0, 1, 2147483647, 9);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b19 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d25 == 0.0d);

  }

  @Test
  public void test189() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test189"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    double d13 = arrayRealVector11.getMaxValue();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = arrayRealVector11.copy();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d13, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector14);

  }

  @Test
  public void test190() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test190"); }


    java.lang.Throwable throwable0 = null;
    org.apache.commons.math3.exception.util.Localizable localizable1 = null;
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix2 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array3 = array2DRowRealMatrix2.getDataRef();
    int i4 = array2DRowRealMatrix2.getRowDimension();
    double[][] d_array_array5 = array2DRowRealMatrix2.getData();
    org.apache.commons.math3.exception.MathIllegalStateException mathIllegalStateException6 = new org.apache.commons.math3.exception.MathIllegalStateException(throwable0, localizable1, (java.lang.Object[])d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);

  }

  @Test
  public void test191() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test191"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.util.Localizable localizable1 = null;
    double[] d_array2 = new double[] {  };
    double[] d_array4 = new double[] { 100.0d };
    double[] d_array8 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b9 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array4, d_array8);
    double d10 = org.apache.commons.math3.util.MathArrays.distance(d_array2, d_array8);
    double[] d_array11 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2);
    org.apache.commons.math3.exception.util.Localizable localizable12 = null;
    double[] d_array14 = new double[] { 0.0d };
    double[] d_array16 = org.apache.commons.math3.util.MathArrays.copyOf(d_array14, 1);
    double[][] d_array_array17 = new double[][] { d_array14 };
    org.apache.commons.math3.linear.RealMatrix realMatrix18 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array17);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix19 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array17);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException20 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable12, (java.lang.Object[])d_array_array17);
    org.apache.commons.math3.util.MathArrays.sortInPlace(d_array2, d_array_array17);
    org.apache.commons.math3.exception.NullArgumentException nullArgumentException22 = new org.apache.commons.math3.exception.NullArgumentException(localizable1, (java.lang.Object[])d_array_array17);
    org.apache.commons.math3.exception.NullArgumentException nullArgumentException23 = new org.apache.commons.math3.exception.NullArgumentException(localizable0, (java.lang.Object[])d_array_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d10 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix18);

  }

  @Test
  public void test192() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test192"); }


    double d2 = org.apache.commons.math3.util.FastMath.nextAfter(141.42842712835352d, 3.155763050408126d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 141.4284271283535d);

  }

  @Test
  public void test193() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test193"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    double[] d_array18 = new double[] { 0.0d };
    double[] d_array20 = org.apache.commons.math3.util.MathArrays.copyOf(d_array18, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector16, d_array20);
    int i22 = arrayRealVector21.getMaxIndex();
    org.apache.commons.math3.linear.RealVectorChangingVisitor realVectorChangingVisitor23 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d24 = arrayRealVector21.walkInOptimizedOrder(realVectorChangingVisitor23);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i22 == 0);

  }

  @Test
  public void test194() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test194"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    java.io.ObjectInputStream objectInputStream3 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.deserializeRealMatrix((java.lang.Object)d_array_array1, "9", objectInputStream3);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);

  }

  @Test
  public void test195() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test195"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector2, false);
    int i5 = arrayRealVector4.getMaxIndex();
    org.apache.commons.math3.linear.RealVectorPreservingVisitor realVectorPreservingVisitor6 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d9 = arrayRealVector4.walkInDefaultOrder(realVectorPreservingVisitor6, 2147483647, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 0);

  }

  @Test
  public void test196() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test196"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor4 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement9 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixChangingVisitor4, 0, 1, 0, 9);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test197() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test197"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.linear.FieldMatrix fieldMatrix7 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix8 = array2DRowFieldMatrix1.preMultiply(fieldMatrix7);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test198() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test198"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector47 = arrayRealVector41.append((org.apache.commons.math3.linear.RealVector)arrayRealVector46);
    org.apache.commons.math3.linear.RealVector realVector49 = arrayRealVector46.mapAdd(0.0d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix50 = arrayRealVector36.outerProduct((org.apache.commons.math3.linear.RealVector)arrayRealVector46);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector49);

  }

  @Test
  public void test199() {}
// Defects4J: flaky method
//   @Test
//   public void test199() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test199"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     randomDataImpl0.reSeedSecure();
//     randomDataImpl0.reSeed();
//     int i5 = randomDataImpl0.nextPascal(100, 1.0E-9d);
//     java.lang.String str7 = randomDataImpl0.nextHexString(100);
//     double d10 = randomDataImpl0.nextWeibull(0.8623188722876839d, Double.POSITIVE_INFINITY);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i5 == 2147483647);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str7 + "' != '" + "0443c4d536f100ec9a88b14a628af6dc0dcee0063319898fce366deda8074b38738aeb489b9a1df46e422e39642044f0ad05"+ "'", str7.equals("0443c4d536f100ec9a88b14a628af6dc0dcee0063319898fce366deda8074b38738aeb489b9a1df46e422e39642044f0ad05"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d10 == Double.POSITIVE_INFINITY);
// 
//   }

  @Test
  public void test200() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test200"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    boolean b5 = array2DRowFieldMatrix1.isSquare();
    org.apache.commons.math3.FieldElement[] fieldElement_array6 = null;
    org.apache.commons.math3.FieldElement[][] fieldElement_array_array7 = new org.apache.commons.math3.FieldElement[][] { fieldElement_array6 };
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setSubMatrix(fieldElement_array_array7, 2, 100);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathIllegalStateException");
    } catch (org.apache.commons.math3.exception.MathIllegalStateException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathIllegalStateException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathIllegalStateException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array_array7);

  }

  @Test
  public void test201() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test201"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
    org.apache.commons.math3.exception.util.Localizable localizable9 = null;
    double[] d_array11 = new double[] { 0.0d };
    double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
    double[][] d_array_array14 = new double[][] { d_array11 };
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
    double d26 = array2DRowRealMatrix18.getTrace();
    org.apache.commons.math3.exception.util.Localizable localizable27 = null;
    double[] d_array29 = new double[] { 0.0d };
    double[] d_array31 = org.apache.commons.math3.util.MathArrays.copyOf(d_array29, 1);
    double[][] d_array_array32 = new double[][] { d_array29 };
    org.apache.commons.math3.linear.RealMatrix realMatrix33 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array32);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix34 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array32);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException35 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable27, (java.lang.Object[])d_array_array32);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix36 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array32);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition38 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix36, 1.3440585709080678E43d);
    java.lang.String str39 = array2DRowRealMatrix36.toString();
    org.apache.commons.math3.linear.RealMatrix realMatrix40 = array2DRowRealMatrix18.subtract((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix36);
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor41 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d42 = array2DRowRealMatrix18.walkInColumnOrder(realMatrixChangingVisitor41);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d26 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str39 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str39.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix40);

  }

  @Test
  public void test202() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test202"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor5 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement6 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixChangingVisitor5);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);

  }

  @Test
  public void test203() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test203"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.DimensionMismatchException dimensionMismatchException3 = new org.apache.commons.math3.exception.DimensionMismatchException(localizable0, 10, 0);

  }

  @Test
  public void test204() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test204"); }


    int i2 = org.apache.commons.math3.util.FastMath.max(43, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 43);

  }

  @Test
  public void test205() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test205"); }


    java.lang.Class clazz2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.exception.MathParseException mathParseException3 = new org.apache.commons.math3.exception.MathParseException("1", 100, clazz2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test206() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test206"); }


    float f1 = org.apache.commons.math3.util.FastMath.ulp(0.76195765f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f1 == 5.9604645E-8f);

  }

  @Test
  public void test207() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test207"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix10 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array11 = array2DRowRealMatrix10.getDataRef();
    int i12 = array2DRowRealMatrix10.getRowDimension();
    double[][] d_array_array13 = array2DRowRealMatrix10.getData();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix14 = array2DRowRealMatrix9.multiply(array2DRowRealMatrix10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i12 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array13);

  }

  @Test
  public void test208() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test208"); }


    org.apache.commons.math3.util.MathUtils.checkFinite(1.344058570908068E43d);

  }

  @Test
  public void test209() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test209"); }


    java.text.NumberFormat numberFormat0 = org.apache.commons.math3.util.CompositeFormat.getDefaultNumberFormat();
    org.apache.commons.math3.linear.RealVectorFormat realVectorFormat1 = new org.apache.commons.math3.linear.RealVectorFormat(numberFormat0);
    java.lang.String str2 = realVectorFormat1.getPrefix();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str2 + "' != '" + "{"+ "'", str2.equals("{"));

  }

  @Test
  public void test210() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test210"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.NumberIsTooSmallException numberIsTooSmallException4 = new org.apache.commons.math3.exception.NumberIsTooSmallException(localizable0, (java.lang.Number)1.3893803029109677d, (java.lang.Number)2.718281828459045d, true);

  }

  @Test
  public void test211() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test211"); }


    org.apache.commons.math3.linear.RealVectorFormat realVectorFormat3 = new org.apache.commons.math3.linear.RealVectorFormat("", "0443c4d536f100ec9a88b14a628af6dc0dcee0063319898fce366deda8074b38738aeb489b9a1df46e422e39642044f0ad05", "9");

  }

  @Test
  public void test212() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test212"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array22 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector25 = new org.apache.commons.math3.linear.ArrayRealVector(d_array22, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = arrayRealVector18.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector25);
    double d27 = arrayRealVector12.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector26);
    java.lang.Double[] d_array29 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector32 = new org.apache.commons.math3.linear.ArrayRealVector(d_array29, 0, 0);
    java.lang.Double[] d_array34 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector37 = new org.apache.commons.math3.linear.ArrayRealVector(d_array34, 0, 0);
    java.lang.Double[] d_array39 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector42 = new org.apache.commons.math3.linear.ArrayRealVector(d_array39, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector43 = arrayRealVector37.append((org.apache.commons.math3.linear.RealVector)arrayRealVector42);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector44 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector32, arrayRealVector42);
    java.lang.Double[] d_array46 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector49 = new org.apache.commons.math3.linear.ArrayRealVector(d_array46, 0, 0);
    java.lang.Double[] d_array53 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector56 = new org.apache.commons.math3.linear.ArrayRealVector(d_array53, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector57 = arrayRealVector49.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector56);
    double d58 = arrayRealVector32.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector49);
    org.apache.commons.math3.linear.RealVector realVector60 = arrayRealVector32.mapAdd(1.6931640502651133d);
    double d61 = arrayRealVector32.getNorm();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector62 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, arrayRealVector32);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector64 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, false);
    double d65 = arrayRealVector64.getNorm();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d58 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d61 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d65 == 0.0d);

  }

  @Test
  public void test213() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test213"); }


    java.lang.Number number1 = null;
    org.apache.commons.math3.exception.NumberIsTooLargeException numberIsTooLargeException3 = new org.apache.commons.math3.exception.NumberIsTooLargeException((java.lang.Number)4.691649480399091E41d, number1, false);

  }

  @Test
  public void test214() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test214"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    double d13 = arrayRealVector11.getMaxValue();
    double d14 = arrayRealVector11.getLInfNorm();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d13, Double.NaN, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 0.0d);

  }

  @Test
  public void test215() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test215"); }


    double d1 = org.apache.commons.math3.util.FastMath.ceil(10.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 10.0d);

  }

  @Test
  public void test216() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test216"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array8 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array5, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix9 = org.apache.commons.math3.linear.MatrixUtils.createRealDiagonalMatrix(d_array8);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix10 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array8);
    double[] d_array12 = new double[] { 100.0d };
    double[] d_array16 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b17 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array12, d_array16);
    double[] d_array19 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array16, 1.3440585709080678E43d);
    // The following exception was thrown during execution in test generation
    try {
      double[] d_array20 = array2DRowRealMatrix10.operate(d_array16);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array19);

  }

  @Test
  public void test217() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test217"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.FieldElement fieldElement1 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array2 = new org.apache.commons.math3.FieldElement[] { fieldElement1 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix3 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0, fieldElement_array2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array2);

  }

  @Test
  public void test218() {}
// Defects4J: flaky method
//   @Test
//   public void test218() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test218"); }
// 
// 
//     double[] d_array1 = new double[] { 0.0d };
//     double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
//     double[][] d_array_array4 = new double[][] { d_array1 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
//     org.apache.commons.math3.exception.util.Localizable localizable9 = null;
//     double[] d_array11 = new double[] { 0.0d };
//     double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
//     double[][] d_array_array14 = new double[][] { d_array11 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
//     org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix26 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
//     double[][] d_array_array27 = array2DRowRealMatrix26.getDataRef();
//     boolean b28 = array2DRowRealMatrix26.isSquare();
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl29 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d32 = randomDataImpl29.nextUniform((-1.0d), 100.0d);
//     int[] i_array35 = randomDataImpl29.nextPermutation(10, 1);
//     int i38 = randomDataImpl29.nextZipf(52, 4.641588833612779d);
//     boolean b39 = array2DRowRealMatrix26.equals((java.lang.Object)randomDataImpl29);
//     boolean b40 = array2DRowRealMatrix8.equals((java.lang.Object)array2DRowRealMatrix26);
//     org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor41 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
//     double d42 = array2DRowRealMatrix8.walkInColumnOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor41);
//     double[] d_array44 = new double[] { 0.0d };
//     double[] d_array46 = org.apache.commons.math3.util.MathArrays.copyOf(d_array44, 1);
//     double[] d_array48 = new double[] { 100.0d };
//     double[] d_array52 = new double[] { 0.0d, (-1.0d), 100.0d };
//     boolean b53 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array48, d_array52);
//     boolean b54 = org.apache.commons.math3.util.MathArrays.equals(d_array44, d_array48);
//     org.apache.commons.math3.linear.ArrayRealVector arrayRealVector55 = new org.apache.commons.math3.linear.ArrayRealVector(d_array44);
//     double[] d_array56 = array2DRowRealMatrix8.operate(d_array44);
//     // The following exception was thrown during execution in test generation
//     try {
//       double[] d_array58 = org.apache.commons.math3.util.MathArrays.copyOf(d_array44, (-1));
//       org.junit.Assert.fail("Expected exception of type java.lang.NegativeArraySizeException");
//     } catch (java.lang.NegativeArraySizeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NegativeArraySizeException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NegativeArraySizeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(d_array_array27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b28 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d32 == 23.08223399669642d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i38 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b39 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b40 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d42 == 0.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array44);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array46);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array48);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array52);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b53 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b54 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array56);
// 
//   }

  @Test
  public void test219() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test219"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[] d_array5 = new double[] { 100.0d };
    double[] d_array9 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b10 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array5, d_array9);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException14 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.0f, (java.lang.Number)(short)100, 10);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection15 = nonMonotonicSequenceException14.getDirection();
    boolean b17 = org.apache.commons.math3.util.MathArrays.isMonotonic(d_array5, orderDirection15, false);
    org.apache.commons.math3.exception.util.Localizable localizable18 = null;
    double[] d_array20 = new double[] { 0.0d };
    double[] d_array22 = org.apache.commons.math3.util.MathArrays.copyOf(d_array20, 1);
    double[][] d_array_array23 = new double[][] { d_array20 };
    org.apache.commons.math3.linear.RealMatrix realMatrix24 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array23);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array23);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException26 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable18, (java.lang.Object[])d_array_array23);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix27 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array23);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition29 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix27, 1.3440585709080678E43d);
    java.lang.String str30 = array2DRowRealMatrix27.toString();
    int i31 = array2DRowRealMatrix27.getRowDimension();
    double[] d_array33 = new double[] { 100.0d };
    double[] d_array37 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b38 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array33, d_array37);
    double[] d_array40 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array37, 1.3440585709080678E43d);
    double[] d_array42 = org.apache.commons.math3.util.MathArrays.copyOf(d_array37, 1);
    double[] d_array43 = array2DRowRealMatrix27.operate(d_array42);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector44 = new org.apache.commons.math3.linear.ArrayRealVector(d_array5, d_array43);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition46 = new org.apache.commons.math3.linear.EigenDecomposition(d_array3, d_array43, 1.6931640502651133d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVector realVector48 = eigenDecomposition46.getEigenvector(49);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str30 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str30.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i31 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b38 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);

  }

  @Test
  public void test220() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test220"); }


    org.apache.commons.math3.distribution.NormalDistribution normalDistribution2 = new org.apache.commons.math3.distribution.NormalDistribution((-1.0d), 100.0d);
    normalDistribution2.reseedRandomGenerator(1L);

  }

  @Test
  public void test221() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test221"); }


    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException3 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.3440585709080678E43d, (java.lang.Number)1.3440585709080678E43d, 2147483647);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection4 = nonMonotonicSequenceException3.getDirection();
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection5 = nonMonotonicSequenceException3.getDirection();
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection6 = nonMonotonicSequenceException3.getDirection();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection6);

  }

  @Test
  public void test222() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test222"); }


    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(10, 0.0d);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector3 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector2);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector5 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector3, false);

  }

  @Test
  public void test223() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test223"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    double[] d_array82 = new double[] { 0.0d };
    double[] d_array84 = org.apache.commons.math3.util.MathArrays.copyOf(d_array82, 1);
    double[][] d_array_array85 = new double[][] { d_array82 };
    org.apache.commons.math3.linear.RealMatrix realMatrix86 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix87 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    boolean b88 = arrayRealVector36.equals((java.lang.Object)d_array_array85);
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix89 = new org.apache.commons.math3.linear.BlockRealMatrix(d_array_array85);
    // The following exception was thrown during execution in test generation
    try {
      blockRealMatrix89.addToEntry(9, 1, 3.141592653589793d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);

  }

  @Test
  public void test224() {}
// Defects4J: flaky method
//   @Test
//   public void test224() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test224"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d2 = randomDataImpl0.nextT(0.8623188722876839d);
//     randomDataImpl0.reSeedSecure();
//     randomDataImpl0.reSeedSecure(6179557979701623951L);
//     double d8 = randomDataImpl0.nextGaussian(1.544050450508393d, 1.0E-6d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d2 == (-0.285421178620366d));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d8 == 1.5440513756283176d);
// 
//   }

  @Test
  public void test225() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test225"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.linear.FieldVector fieldVector7 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldVector fieldVector8 = array2DRowFieldMatrix1.operate(fieldVector7);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test226() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test226"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[] d_array5 = new double[] { 100.0d };
    double[] d_array9 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b10 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array5, d_array9);
    boolean b11 = org.apache.commons.math3.util.MathArrays.equals(d_array1, d_array5);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = org.apache.commons.math3.linear.MatrixUtils.createRealDiagonalMatrix(d_array1);
    double[] d_array15 = new double[] { 100.0d };
    double[] d_array19 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b20 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array15, d_array19);
    double[] d_array22 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array19, 1.3440585709080678E43d);
    double d23 = org.apache.commons.math3.util.MathArrays.distanceInf(d_array1, d_array22);
    double[] d_array25 = new double[] { 0.0d };
    double[] d_array27 = org.apache.commons.math3.util.MathArrays.copyOf(d_array25, 1);
    double[][] d_array_array28 = new double[][] { d_array25 };
    org.apache.commons.math3.linear.RealMatrix realMatrix29 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array28);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix30 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array28);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix32 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array28, false);
    double[][] d_array_array33 = array2DRowRealMatrix32.getData();
    double[] d_array35 = new double[] { 100.0d };
    double[] d_array39 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b40 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array35, d_array39);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException44 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.0f, (java.lang.Number)(short)100, 10);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection45 = nonMonotonicSequenceException44.getDirection();
    boolean b47 = org.apache.commons.math3.util.MathArrays.isMonotonic(d_array35, orderDirection45, false);
    double[] d_array48 = array2DRowRealMatrix32.operate(d_array35);
    double[] d_array50 = new double[] { 0.0d };
    double[] d_array52 = org.apache.commons.math3.util.MathArrays.copyOf(d_array50, 1);
    double[] d_array54 = new double[] { 100.0d };
    double[] d_array58 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b59 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array54, d_array58);
    boolean b60 = org.apache.commons.math3.util.MathArrays.equals(d_array50, d_array54);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException64 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.3440585709080678E43d, (java.lang.Number)1.3440585709080678E43d, 2147483647);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection65 = nonMonotonicSequenceException64.getDirection();
    org.apache.commons.math3.exception.util.Localizable localizable66 = null;
    double[] d_array68 = new double[] { 0.0d };
    double[] d_array70 = org.apache.commons.math3.util.MathArrays.copyOf(d_array68, 1);
    double[][] d_array_array71 = new double[][] { d_array68 };
    org.apache.commons.math3.linear.RealMatrix realMatrix72 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array71);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix73 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array71);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException74 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable66, (java.lang.Object[])d_array_array71);
    org.apache.commons.math3.util.MathArrays.sortInPlace(d_array50, orderDirection65, d_array_array71);
    boolean b78 = org.apache.commons.math3.util.MathArrays.checkOrder(d_array48, orderDirection65, false, true);
    boolean b80 = org.apache.commons.math3.util.MathArrays.isMonotonic(d_array1, orderDirection65, true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d23 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b40 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b47 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b59 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b60 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array68);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array71);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix72);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b78 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b80 == true);

  }

  @Test
  public void test227() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test227"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equalsIncludingNaN(100.0f, (-0.9999999f), 10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test228() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test228"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.util.Localizable localizable3 = null;
    java.lang.Integer[] i_array5 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array7 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException8 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array5, i_array7);
    org.apache.commons.math3.util.MathUtils.checkNotNull((java.lang.Object)0.0d, localizable3, (java.lang.Object[])i_array7);
    org.apache.commons.math3.exception.MaxCountExceededException maxCountExceededException10 = new org.apache.commons.math3.exception.MaxCountExceededException(localizable0, (java.lang.Number)6.095135277953756d, (java.lang.Object[])i_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array7);

  }

  @Test
  public void test229() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test229"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector2, false);
    org.apache.commons.math3.linear.RealVector realVector6 = arrayRealVector4.mapSubtract(10.04987562112089d);
    double[] d_array7 = arrayRealVector4.getDataRef();
    java.lang.Double[] d_array10 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = new org.apache.commons.math3.linear.ArrayRealVector(d_array10, 0, 0);
    java.lang.Double[] d_array17 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector20 = new org.apache.commons.math3.linear.ArrayRealVector(d_array17, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = arrayRealVector13.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector20);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector22 = arrayRealVector21.copy();
    java.lang.Double[] d_array24 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = new org.apache.commons.math3.linear.ArrayRealVector(d_array24, 0, 0);
    java.lang.Double[] d_array31 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector34 = new org.apache.commons.math3.linear.ArrayRealVector(d_array31, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = arrayRealVector27.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = arrayRealVector35.copy();
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    double[] d_array55 = new double[] { 0.0d };
    double[] d_array57 = org.apache.commons.math3.util.MathArrays.copyOf(d_array55, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector53, d_array57);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector59 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector36, arrayRealVector53);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector60 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector21, arrayRealVector59);
    // The following exception was thrown during execution in test generation
    try {
      arrayRealVector4.setSubVector(49, (org.apache.commons.math3.linear.RealVector)arrayRealVector60);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array57);

  }

  @Test
  public void test230() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test230"); }


    double[] d_array0 = new double[] {  };
    double[] d_array2 = new double[] { 100.0d };
    double[] d_array6 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b7 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array2, d_array6);
    double d8 = org.apache.commons.math3.util.MathArrays.distance(d_array0, d_array6);
    double[] d_array9 = org.apache.commons.math3.util.MathArrays.copyOf(d_array0);
    org.apache.commons.math3.exception.util.Localizable localizable10 = null;
    double[] d_array12 = new double[] { 0.0d };
    double[] d_array14 = org.apache.commons.math3.util.MathArrays.copyOf(d_array12, 1);
    double[][] d_array_array15 = new double[][] { d_array12 };
    org.apache.commons.math3.linear.RealMatrix realMatrix16 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array15);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix17 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array15);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException18 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable10, (java.lang.Object[])d_array_array15);
    org.apache.commons.math3.util.MathArrays.sortInPlace(d_array0, d_array_array15);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix20 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array15);
    org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix20.scalarAdd((-7.241149127564359d));
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.checkSubMatrixIndex((org.apache.commons.math3.linear.AnyMatrix)realMatrix22, (-1), 0, 1, 43);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix22);

  }

  @Test
  public void test231() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test231"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equalsIncludingNaN(141.4284271283535d, 0.0d, 2147483647);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test232() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test232"); }


    org.apache.commons.math3.exception.NumberIsTooSmallException numberIsTooSmallException3 = new org.apache.commons.math3.exception.NumberIsTooSmallException((java.lang.Number)(byte)0, (java.lang.Number)100.0d, false);
    java.lang.Number number4 = numberIsTooSmallException3.getMin();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + number4 + "' != '" + 100.0d+ "'", number4.equals(100.0d));

  }

  @Test
  public void test233() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test233"); }


    org.apache.commons.math3.linear.RealMatrix realMatrix1 = org.apache.commons.math3.linear.MatrixUtils.createRealIdentityMatrix(100);
    org.apache.commons.math3.linear.MatrixUtils.checkSymmetric(realMatrix1, 1.6931640502651133d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix1);

  }

  @Test
  public void test234() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test234"); }


    double d1 = org.apache.commons.math3.util.FastMath.signum(5.29205908405969d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.0d);

  }

  @Test
  public void test235() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test235"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    boolean b5 = array2DRowFieldMatrix1.isSquare();
    org.apache.commons.math3.Field field7 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix8 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field7);
    boolean b10 = array2DRowFieldMatrix8.equals((java.lang.Object)(short)10);
    boolean b12 = array2DRowFieldMatrix8.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field13 = array2DRowFieldMatrix8.getField();
    java.lang.String str14 = array2DRowFieldMatrix8.toString();
    boolean b15 = array2DRowFieldMatrix8.isSquare();
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setRowMatrix((-1), (org.apache.commons.math3.linear.FieldMatrix)array2DRowFieldMatrix8);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str14 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str14.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == true);

  }

  @Test
  public void test236() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test236"); }


    org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException nonPositiveDefiniteMatrixException3 = new org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException(3.4719061895220023d, 0, 7.703719777548943E-34d);
    int i4 = nonPositiveDefiniteMatrixException3.getColumn();
    int i5 = nonPositiveDefiniteMatrixException3.getRow();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 0);

  }

  @Test
  public void test237() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test237"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor4 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement5 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixChangingVisitor4);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test238() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test238"); }


    org.apache.commons.math3.linear.MatrixDimensionMismatchException matrixDimensionMismatchException4 = new org.apache.commons.math3.linear.MatrixDimensionMismatchException(2147483647, 100, 49, 9);
    int i5 = matrixDimensionMismatchException4.getWrongColumnDimension();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 100);

  }

  @Test
  public void test239() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test239"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.DimensionMismatchException dimensionMismatchException3 = new org.apache.commons.math3.exception.DimensionMismatchException(localizable0, 1, 2147483647);

  }

  @Test
  public void test240() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test240"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.analysis.UnivariateFunction univariateFunction13 = null;
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = arrayRealVector12.map(univariateFunction13);
    boolean b15 = arrayRealVector12.isInfinite();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);

  }

  @Test
  public void test241() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test241"); }


    long long1 = org.apache.commons.math3.util.FastMath.abs(100L);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long1 == 100L);

  }

  @Test
  public void test242() {}
// Defects4J: flaky method
//   @Test
//   public void test242() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test242"); }
// 
// 
//     org.apache.commons.math3.random.Well19937c well19937c0 = new org.apache.commons.math3.random.Well19937c();
//     int i2 = well19937c0.nextInt(2147483647);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i2 == 266627117);
// 
//   }

  @Test
  public void test243() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test243"); }


    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(10, 0.0d);
    org.apache.commons.math3.linear.RealVector realVector4 = arrayRealVector2.mapMultiplyToSelf(99.37864167209166d);
    java.util.Iterator iterator5 = arrayRealVector2.sparseIterator();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(iterator5);

  }

  @Test
  public void test244() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test244"); }


    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException3 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.3440585709080678E43d, (java.lang.Number)1.3440585709080678E43d, 2147483647);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection4 = nonMonotonicSequenceException3.getDirection();
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection5 = nonMonotonicSequenceException3.getDirection();
    java.lang.Number number6 = nonMonotonicSequenceException3.getPrevious();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + number6 + "' != '" + 1.3440585709080678E43d+ "'", number6.equals(1.3440585709080678E43d));

  }

  @Test
  public void test245() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test245"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    int i13 = array2DRowRealMatrix9.getRowDimension();
    double[] d_array15 = new double[] { 100.0d };
    double[] d_array19 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b20 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array15, d_array19);
    double[] d_array22 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array19, 1.3440585709080678E43d);
    double[] d_array24 = org.apache.commons.math3.util.MathArrays.copyOf(d_array19, 1);
    double[] d_array25 = array2DRowRealMatrix9.operate(d_array24);
    java.lang.Double[] d_array27 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector(d_array27, 0, 0);
    java.lang.Double[] d_array34 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector37 = new org.apache.commons.math3.linear.ArrayRealVector(d_array34, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector38 = arrayRealVector30.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector37);
    double d39 = arrayRealVector37.getMaxValue();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVector realVector40 = array2DRowRealMatrix9.preMultiply((org.apache.commons.math3.linear.RealVector)arrayRealVector37);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i13 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d39, Double.NaN, 0);

  }

  @Test
  public void test246() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test246"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.OutOfRangeException outOfRangeException4 = new org.apache.commons.math3.exception.OutOfRangeException(localizable0, (java.lang.Number)99.72385498121952d, (java.lang.Number)141.42842712835352d, (java.lang.Number)(-7.241149127564359d));

  }

  @Test
  public void test247() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test247"); }


    org.apache.commons.math3.linear.RealMatrix realMatrix0 = null;
    java.lang.Double[] d_array2 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector5 = new org.apache.commons.math3.linear.ArrayRealVector(d_array2, 0, 0);
    int i6 = arrayRealVector5.getDimension();
    double[] d_array7 = arrayRealVector5.toArray();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector8 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector5);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.solveLowerTriangularSystem(realMatrix0, (org.apache.commons.math3.linear.RealVector)arrayRealVector5);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);

  }

  @Test
  public void test248() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test248"); }


    java.text.ParsePosition parsePosition1 = null;
    // The following exception was thrown during execution in test generation
    try {
      char char2 = org.apache.commons.math3.util.CompositeFormat.parseNextCharacter("}", parsePosition1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test249() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test249"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.RealMatrix realMatrix8 = array2DRowRealMatrix6.scalarMultiply(0.0d);
    boolean b9 = array2DRowRealMatrix6.isSquare();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = new org.apache.commons.math3.linear.ArrayRealVector(10, 0.0d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVector realVector13 = array2DRowRealMatrix6.operateTranspose((org.apache.commons.math3.linear.RealVector)arrayRealVector12);
      org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException");
    } catch (java.lang.UnsupportedOperationException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.UnsupportedOperationException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.UnsupportedOperationException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == true);

  }

  @Test
  public void test250() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test250"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    well19937c1.setSeed(10);
    double[] d_array5 = new double[] { 0.0d };
    double[] d_array7 = org.apache.commons.math3.util.MathArrays.copyOf(d_array5, 1);
    double[] d_array9 = new double[] { 100.0d };
    double[] d_array13 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b14 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array9, d_array13);
    boolean b15 = org.apache.commons.math3.util.MathArrays.equals(d_array5, d_array9);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException19 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.3440585709080678E43d, (java.lang.Number)1.3440585709080678E43d, 2147483647);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection20 = nonMonotonicSequenceException19.getDirection();
    org.apache.commons.math3.exception.util.Localizable localizable21 = null;
    double[] d_array23 = new double[] { 0.0d };
    double[] d_array25 = org.apache.commons.math3.util.MathArrays.copyOf(d_array23, 1);
    double[][] d_array_array26 = new double[][] { d_array23 };
    org.apache.commons.math3.linear.RealMatrix realMatrix27 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array26);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix28 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array26);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException29 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable21, (java.lang.Object[])d_array_array26);
    org.apache.commons.math3.util.MathArrays.sortInPlace(d_array5, orderDirection20, d_array_array26);
    double[][] d_array_array31 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.distribution.MultivariateNormalDistribution multivariateNormalDistribution32 = new org.apache.commons.math3.distribution.MultivariateNormalDistribution((org.apache.commons.math3.random.RandomGenerator)well19937c1, d_array5, d_array_array31);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b15 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix27);

  }

  @Test
  public void test251() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test251"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    well19937c1.setSeed(10);
    float f4 = well19937c1.nextFloat();
    org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator5 = new org.apache.commons.math3.random.RandomDataGenerator((org.apache.commons.math3.random.RandomGenerator)well19937c1);
    long long6 = well19937c1.nextLong();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f4 == 0.76195765f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long6 == (-1551720450747048068L));

  }

  @Test
  public void test252() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test252"); }


    org.apache.commons.math3.linear.MatrixDimensionMismatchException matrixDimensionMismatchException4 = new org.apache.commons.math3.linear.MatrixDimensionMismatchException(2147483647, 100, 49, 9);
    int i5 = matrixDimensionMismatchException4.getExpectedColumnDimension();
    int i6 = matrixDimensionMismatchException4.getWrongRowDimension();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 2147483647);

  }

  @Test
  public void test253() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test253"); }


    java.text.ParsePosition parsePosition1 = null;
    // The following exception was thrown during execution in test generation
    try {
      char char2 = org.apache.commons.math3.util.CompositeFormat.parseNextCharacter("", parsePosition1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test254() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test254"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    double d13 = array2DRowRealMatrix9.getNorm();
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix9.addToEntry(0, 10, 1.3407807929942133E154d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d13 == 0.0d);

  }

  @Test
  public void test255() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test255"); }


    org.apache.commons.math3.FieldElement[] fieldElement_array0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldVector fieldVector1 = org.apache.commons.math3.linear.MatrixUtils.<org.apache.commons.math3.FieldElement>createFieldVector(fieldElement_array0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException");
    } catch (org.apache.commons.math3.exception.NullArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NullArgumentException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test256() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test256"); }


    org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
    randomDataImpl0.reSeedSecure();
    // The following exception was thrown during execution in test generation
    try {
      int i4 = randomDataImpl0.nextPascal(9, 91.72846348246509d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test257() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test257"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix8 = array2DRowFieldMatrix1.getRowMatrix((-1));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test258() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test258"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    double[] d_array82 = new double[] { 0.0d };
    double[] d_array84 = org.apache.commons.math3.util.MathArrays.copyOf(d_array82, 1);
    double[][] d_array_array85 = new double[][] { d_array82 };
    org.apache.commons.math3.linear.RealMatrix realMatrix86 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix87 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    boolean b88 = arrayRealVector36.equals((java.lang.Object)d_array_array85);
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix89 = new org.apache.commons.math3.linear.BlockRealMatrix(d_array_array85);
    double d90 = blockRealMatrix89.getNorm();
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor91 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d96 = blockRealMatrix89.walkInRowOrder(realMatrixChangingVisitor91, 43, 9, 0, 43);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d90 == 0.0d);

  }

  @Test
  public void test259() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test259"); }


    int i1 = org.apache.commons.math3.util.FastMath.getExponent(49.66762847873805d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == 5);

  }

  @Test
  public void test260() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test260"); }


    java.lang.Number number0 = null;
    org.apache.commons.math3.exception.NotPositiveException notPositiveException1 = new org.apache.commons.math3.exception.NotPositiveException(number0);

  }

  @Test
  public void test261() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test261"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    double d14 = array2DRowRealMatrix9.getFrobeniusNorm();
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition15 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9);
    double[] d_array16 = eigenDecomposition15.getImagEigenvalues();
    double[] d_array17 = eigenDecomposition15.getImagEigenvalues();
    boolean b18 = eigenDecomposition15.hasComplexEigenvalues();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b18 == false);

  }

  @Test
  public void test262() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test262"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    double[] d_array18 = new double[] { 0.0d };
    double[] d_array20 = org.apache.commons.math3.util.MathArrays.copyOf(d_array18, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector16, d_array20);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, false);
    int i29 = arrayRealVector28.getMaxIndex();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = arrayRealVector21.combineToSelf(0.0d, (-7.241149127564359d), (org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    double[] d_array31 = arrayRealVector21.toArray();
    org.apache.commons.math3.linear.RealVector realVector33 = arrayRealVector21.mapMultiplyToSelf(1.0E-6d);
    java.io.ObjectInputStream objectInputStream35 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.deserializeRealMatrix((java.lang.Object)arrayRealVector21, "Array2DRowFieldMatrix{}", objectInputStream35);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i29 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector33);

  }

  @Test
  public void test263() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test263"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    java.lang.Object[] obj_array2 = new java.lang.Object[] { 100.0f };
    org.apache.commons.math3.exception.MathUnsupportedOperationException mathUnsupportedOperationException3 = new org.apache.commons.math3.exception.MathUnsupportedOperationException(localizable0, obj_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj_array2);

  }

  @Test
  public void test264() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test264"); }


    int i2 = org.apache.commons.math3.util.FastMath.max(49, 69);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 69);

  }

  @Test
  public void test265() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test265"); }


    float f1 = org.apache.commons.math3.util.FastMath.abs(0.99999994f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f1 == 0.99999994f);

  }

  @Test
  public void test266() {}
// Defects4J: flaky method
//   @Test
//   public void test266() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test266"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d2 = randomDataImpl0.nextT(0.8623188722876839d);
//     randomDataImpl0.reSeedSecure(0L);
//     double d6 = randomDataImpl0.nextT(2.775557561562891E-17d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d2 == (-2.0263349998316382d));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d6 == 3.3519519824856493E153d);
// 
//   }

  @Test
  public void test267() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test267"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    long[] long_array1 = null;
    long[][] long_array_array2 = new long[][] { long_array1 };
    org.apache.commons.math3.util.MathArrays.checkRectangular(long_array_array2);
    org.apache.commons.math3.exception.MathIllegalStateException mathIllegalStateException4 = new org.apache.commons.math3.exception.MathIllegalStateException(localizable0, (java.lang.Object[])long_array_array2);
    org.apache.commons.math3.util.MathArrays.checkRectangular(long_array_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(long_array_array2);

  }

  @Test
  public void test268() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test268"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
    org.apache.commons.math3.exception.util.Localizable localizable9 = null;
    double[] d_array11 = new double[] { 0.0d };
    double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
    double[][] d_array_array14 = new double[][] { d_array11 };
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
    org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor26 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
    double d27 = defaultRealMatrixPreservingVisitor26.end();
    double d28 = array2DRowRealMatrix25.walkInColumnOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor26);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix29 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array30 = array2DRowRealMatrix29.getDataRef();
    int i31 = array2DRowRealMatrix29.getRowDimension();
    org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor32 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
    double d33 = array2DRowRealMatrix29.walkInColumnOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor32);
    double d34 = array2DRowRealMatrix25.walkInRowOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d28 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i31 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d33 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d34 == 0.0d);

  }

  @Test
  public void test269() {}
// Defects4J: flaky method
//   @Test
//   public void test269() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test269"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     randomDataImpl0.reSeedSecure();
//     randomDataImpl0.reSeed();
//     randomDataImpl0.reSeedSecure(49L);
//     double d7 = randomDataImpl0.nextF(3.141592653589793d, 1.5707963267948966d);
//     double d10 = randomDataImpl0.nextF(0.6892682844514348d, 100.0d);
//     java.lang.String str12 = randomDataImpl0.nextHexString(1);
//     double d14 = randomDataImpl0.nextT(1.0E-6d);
//     double d16 = randomDataImpl0.nextChiSquare(0.8623188722876839d);
//     randomDataImpl0.reSeedSecure();
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d7 == 1.1615428844630364d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d10 == 0.13533475911899664d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str12 + "' != '" + "2"+ "'", str12.equals("2"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d14 == (-1.3407807929942597E154d));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d16 == 0.6363779946031d);
// 
//   }

  @Test
  public void test270() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test270"); }


    boolean b2 = org.apache.commons.math3.util.Precision.equalsIncludingNaN(1.0f, (-0.9999999f));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);

  }

  @Test
  public void test271() {}
// Defects4J: flaky method
//   @Test
//   public void test271() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test271"); }
// 
// 
//     double[] d_array1 = new double[] { 0.0d };
//     double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
//     double[][] d_array_array4 = new double[][] { d_array1 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
//     org.apache.commons.math3.exception.util.Localizable localizable9 = null;
//     double[] d_array11 = new double[] { 0.0d };
//     double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
//     double[][] d_array_array14 = new double[][] { d_array11 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
//     org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix26 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
//     double[][] d_array_array27 = array2DRowRealMatrix26.getDataRef();
//     boolean b28 = array2DRowRealMatrix26.isSquare();
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl29 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d32 = randomDataImpl29.nextUniform((-1.0d), 100.0d);
//     int[] i_array35 = randomDataImpl29.nextPermutation(10, 1);
//     int i38 = randomDataImpl29.nextZipf(52, 4.641588833612779d);
//     boolean b39 = array2DRowRealMatrix26.equals((java.lang.Object)randomDataImpl29);
//     boolean b40 = array2DRowRealMatrix8.equals((java.lang.Object)array2DRowRealMatrix26);
//     org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor41 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
//     double d42 = array2DRowRealMatrix8.walkInColumnOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor41);
//     double[] d_array44 = new double[] { 0.0d };
//     double[] d_array46 = org.apache.commons.math3.util.MathArrays.copyOf(d_array44, 1);
//     double[] d_array48 = new double[] { 100.0d };
//     double[] d_array52 = new double[] { 0.0d, (-1.0d), 100.0d };
//     boolean b53 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array48, d_array52);
//     boolean b54 = org.apache.commons.math3.util.MathArrays.equals(d_array44, d_array48);
//     org.apache.commons.math3.linear.ArrayRealVector arrayRealVector55 = new org.apache.commons.math3.linear.ArrayRealVector(d_array44);
//     double[] d_array56 = array2DRowRealMatrix8.operate(d_array44);
//     // The following exception was thrown during execution in test generation
//     try {
//       double d59 = array2DRowRealMatrix8.getEntry(9, (-1));
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
//     } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(d_array_array27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b28 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d32 == 64.70526366801418d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i38 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b39 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b40 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d42 == 0.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array44);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array46);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array48);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array52);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b53 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b54 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array56);
// 
//   }

  @Test
  public void test272() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test272"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    double[] d_array18 = new double[] { 0.0d };
    double[] d_array20 = org.apache.commons.math3.util.MathArrays.copyOf(d_array18, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector16, d_array20);
    double d22 = arrayRealVector21.getL1Norm();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d22 == 0.0d);

  }

  @Test
  public void test273() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test273"); }


    double d2 = org.apache.commons.math3.util.MathUtils.normalizeAngle(1.3622825063580968d, 49.667938200224796d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 51.62776496379479d);

  }

  @Test
  public void test274() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test274"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    double[] d_array82 = new double[] { 0.0d };
    double[] d_array84 = org.apache.commons.math3.util.MathArrays.copyOf(d_array82, 1);
    double[][] d_array_array85 = new double[][] { d_array82 };
    org.apache.commons.math3.linear.RealMatrix realMatrix86 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix87 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    boolean b88 = arrayRealVector36.equals((java.lang.Object)d_array_array85);
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix89 = new org.apache.commons.math3.linear.BlockRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.RealMatrix realMatrix91 = blockRealMatrix89.scalarMultiply(0.0d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix94 = blockRealMatrix89.createMatrix(266627117, 2147483647);
      org.junit.Assert.fail("Expected exception of type java.lang.NegativeArraySizeException");
    } catch (java.lang.NegativeArraySizeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NegativeArraySizeException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NegativeArraySizeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix91);

  }

  @Test
  public void test275() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test275"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    // The following exception was thrown during execution in test generation
    try {
      double d12 = array2DRowRealMatrix9.getEntry(156287497, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);

  }

  @Test
  public void test276() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test276"); }


    org.apache.commons.math3.exception.util.Localizable localizable4 = null;
    java.lang.Integer[] i_array6 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array8 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException9 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array6, i_array8);
    org.apache.commons.math3.util.MathUtils.checkNotNull((java.lang.Object)0.0d, localizable4, (java.lang.Object[])i_array8);
    org.apache.commons.math3.exception.util.Localizable localizable11 = null;
    java.lang.Integer[] i_array13 = new java.lang.Integer[] { 10 };
    java.lang.Integer[] i_array15 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array17 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException18 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array15, i_array17);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException19 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(localizable11, i_array13, i_array15);
    org.apache.commons.math3.exception.util.Localizable localizable20 = null;
    java.lang.Integer[] i_array22 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array24 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException25 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array22, i_array24);
    org.apache.commons.math3.exception.NullArgumentException nullArgumentException26 = new org.apache.commons.math3.exception.NullArgumentException(localizable20, (java.lang.Object[])i_array22);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException27 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array13, i_array22);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException28 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array8, i_array22);
    double[] d_array30 = new double[] { 100.0d };
    double[] d_array34 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b35 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array30, d_array34);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException39 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.0f, (java.lang.Number)(short)100, 10);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection40 = nonMonotonicSequenceException39.getDirection();
    boolean b42 = org.apache.commons.math3.util.MathArrays.isMonotonic(d_array30, orderDirection40, false);
    boolean b44 = org.apache.commons.math3.util.MathArrays.<java.lang.Comparable>isMonotonic((java.lang.Comparable[])i_array22, orderDirection40, true);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException46 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)5.29205908405969d, (java.lang.Number)4.2502863927404205E43d, 0, orderDirection40, false);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection47 = nonMonotonicSequenceException46.getDirection();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b35 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b42 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b44 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection47);

  }

  @Test
  public void test277() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test277"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.util.Localizable localizable1 = null;
    java.lang.Integer[] i_array3 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array5 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException6 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array3, i_array5);
    java.lang.Integer[] i_array7 = multiDimensionMismatchException6.getExpectedDimensions();
    org.apache.commons.math3.exception.ZeroException zeroException8 = new org.apache.commons.math3.exception.ZeroException(localizable1, (java.lang.Object[])i_array7);
    org.apache.commons.math3.exception.MathUnsupportedOperationException mathUnsupportedOperationException9 = new org.apache.commons.math3.exception.MathUnsupportedOperationException(localizable0, (java.lang.Object[])i_array7);
    org.apache.commons.math3.exception.util.ExceptionContext exceptionContext10 = mathUnsupportedOperationException9.getContext();
    org.apache.commons.math3.exception.util.ExceptionContext exceptionContext11 = mathUnsupportedOperationException9.getContext();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(exceptionContext10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(exceptionContext11);

  }

  @Test
  public void test278() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test278"); }


    int i1 = org.apache.commons.math3.util.FastMath.getExponent(1.7763568E-15f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == (-49));

  }

  @Test
  public void test279() {}
// Defects4J: flaky method
//   @Test
//   public void test279() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test279"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
//     long long3 = randomDataGenerator0.nextLong((-1L), 0L);
//     double d5 = randomDataGenerator0.nextExponential(1.2104058782952831d);
//     double d9 = randomDataGenerator0.nextUniform(1.0536712127723509E-8d, 0.8746763868104921d, false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long3 == 0L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d5 == 1.0524209904394652d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d9 == 0.2750555746648935d);
// 
//   }

  @Test
  public void test280() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test280"); }


    double d1 = org.apache.commons.math3.util.FastMath.log(24.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 3.1780538303479458d);

  }

  @Test
  public void test281() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test281"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array8 = new double[] { 100.0d };
    double[] d_array12 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b13 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array8, d_array12);
    boolean b14 = org.apache.commons.math3.util.MathArrays.equals(d_array1, d_array12);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException18 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.3440585709080678E43d, (java.lang.Number)1.3440585709080678E43d, 2147483647);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection19 = nonMonotonicSequenceException18.getDirection();
    boolean b22 = org.apache.commons.math3.util.MathArrays.checkOrder(d_array12, orderDirection19, false, false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);

  }

  @Test
  public void test282() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test282"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    boolean b5 = array2DRowFieldMatrix1.isSquare();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor6 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement11 = array2DRowFieldMatrix1.walkInRowOrder(fieldMatrixPreservingVisitor6, 5, 156287497, (-49), 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == true);

  }

  @Test
  public void test283() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test283"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.NotStrictlyPositiveException notStrictlyPositiveException2 = new org.apache.commons.math3.exception.NotStrictlyPositiveException(localizable0, (java.lang.Number)(-3.4893569077129025d));

  }

  @Test
  public void test284() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test284"); }


    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix2 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(0, 5);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test285() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test285"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
    org.apache.commons.math3.exception.util.Localizable localizable9 = null;
    double[] d_array11 = new double[] { 0.0d };
    double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
    double[][] d_array_array14 = new double[][] { d_array11 };
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
    org.apache.commons.math3.linear.RealMatrix realMatrix27 = array2DRowRealMatrix25.power(1);
    double[] d_array29 = new double[] { 0.0d };
    double[] d_array31 = org.apache.commons.math3.util.MathArrays.copyOf(d_array29, 1);
    double[][] d_array_array32 = new double[][] { d_array29 };
    org.apache.commons.math3.linear.RealMatrix realMatrix33 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array32);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix34 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array32);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix36 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array32, false);
    org.apache.commons.math3.exception.util.Localizable localizable37 = null;
    double[] d_array39 = new double[] { 0.0d };
    double[] d_array41 = org.apache.commons.math3.util.MathArrays.copyOf(d_array39, 1);
    double[][] d_array_array42 = new double[][] { d_array39 };
    org.apache.commons.math3.linear.RealMatrix realMatrix43 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array42);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix44 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array42);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException45 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable37, (java.lang.Object[])d_array_array42);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix46 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array42);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition48 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix46, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix50 = array2DRowRealMatrix46.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition52 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix46, 4.9E-324d);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix53 = array2DRowRealMatrix36.subtract(array2DRowRealMatrix46);
    org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor54 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
    double d55 = defaultRealMatrixPreservingVisitor54.end();
    double d56 = array2DRowRealMatrix53.walkInColumnOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor54);
    double d57 = array2DRowRealMatrix25.walkInColumnOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix50);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d55 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d56 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d57 == 0.0d);

  }

  @Test
  public void test286() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test286"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    int i2 = array2DRowRealMatrix0.getRowDimension();
    double[][] d_array_array3 = array2DRowRealMatrix0.getData();
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor4 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d9 = array2DRowRealMatrix0.walkInColumnOrder(realMatrixChangingVisitor4, 10, 156287497, 156287497, 2);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array3);

  }

  @Test
  public void test287() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test287"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.DimensionMismatchException dimensionMismatchException3 = new org.apache.commons.math3.exception.DimensionMismatchException(localizable0, 100, (-1));

  }

  @Test
  public void test288() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test288"); }


    org.apache.commons.math3.random.RandomGenerator randomGenerator0 = null;
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution4 = new org.apache.commons.math3.distribution.NormalDistribution(randomGenerator0, 54.444384793244126d, 54.444384793244126d, 0.1754034190044697d);
    double d5 = normalDistribution4.getNumericalMean();
    boolean b6 = normalDistribution4.isSupportUpperBoundInclusive();
    double d7 = normalDistribution4.getStandardDeviation();
    double d9 = normalDistribution4.cumulativeProbability(141.4284271283535d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 54.444384793244126d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d7 == 54.444384793244126d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d9 == 0.9449415395152634d);

  }

  @Test
  public void test289() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test289"); }


    org.apache.commons.math3.exception.NumberIsTooSmallException numberIsTooSmallException3 = new org.apache.commons.math3.exception.NumberIsTooSmallException((java.lang.Number)3.4091431702387944d, (java.lang.Number)4.414646020926698E23d, true);

  }

  @Test
  public void test290() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test290"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    int i2 = array2DRowRealMatrix0.getRowDimension();
    double[][] d_array_array3 = array2DRowRealMatrix0.getDataRef();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array3);

  }

  @Test
  public void test291() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test291"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    java.lang.String str7 = array2DRowFieldMatrix1.toString();
    boolean b8 = array2DRowFieldMatrix1.isSquare();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor9 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement14 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixPreservingVisitor9, 5, 156287497, (-1), 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str7 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str7.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);

  }

  @Test
  public void test292() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test292"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    double[] d_array82 = new double[] { 0.0d };
    double[] d_array84 = org.apache.commons.math3.util.MathArrays.copyOf(d_array82, 1);
    double[][] d_array_array85 = new double[][] { d_array82 };
    org.apache.commons.math3.linear.RealMatrix realMatrix86 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix87 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    boolean b88 = arrayRealVector36.equals((java.lang.Object)d_array_array85);
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix89 = new org.apache.commons.math3.linear.BlockRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.RealMatrix realMatrix91 = blockRealMatrix89.scalarMultiply(0.0d);
    double[] d_array93 = null;
    // The following exception was thrown during execution in test generation
    try {
      blockRealMatrix89.setColumn(2, d_array93);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix91);

  }

  @Test
  public void test293() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test293"); }


    double d2 = org.apache.commons.math3.util.FastMath.min(0.0d, 1.544050450508393d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.0d);

  }

  @Test
  public void test294() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test294"); }


    java.text.ParsePosition parsePosition2 = null;
    // The following exception was thrown during execution in test generation
    try {
      boolean b3 = org.apache.commons.math3.util.CompositeFormat.parseFixedstring(",", "5515c956b2eab6260306e287b6e79f9b24f15f0c4374f130a0c3f153c6cd0cd56d53992ff18a0c43e497680ba0f4a0f1340d", parsePosition2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test295() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test295"); }


    java.lang.Number number1 = null;
    org.apache.commons.math3.exception.NumberIsTooLargeException numberIsTooLargeException3 = new org.apache.commons.math3.exception.NumberIsTooLargeException((java.lang.Number)(short)100, number1, false);
    boolean b4 = numberIsTooLargeException3.getBoundIsAllowed();
    boolean b5 = numberIsTooLargeException3.getBoundIsAllowed();
    boolean b6 = numberIsTooLargeException3.getBoundIsAllowed();
    org.apache.commons.math3.exception.util.Localizable localizable7 = null;
    org.apache.commons.math3.exception.OutOfRangeException outOfRangeException11 = new org.apache.commons.math3.exception.OutOfRangeException(localizable7, (java.lang.Number)6.482892211805716d, (java.lang.Number)2.4053276775961323d, (java.lang.Number)2.775557561562891E-17d);
    numberIsTooLargeException3.addSuppressed((java.lang.Throwable)outOfRangeException11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);

  }

  @Test
  public void test296() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test296"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[] d_array5 = new double[] { 100.0d };
    double[] d_array9 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b10 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array5, d_array9);
    boolean b11 = org.apache.commons.math3.util.MathArrays.equals(d_array1, d_array5);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, false);
    boolean b14 = arrayRealVector13.isNaN();
    // The following exception was thrown during execution in test generation
    try {
      arrayRealVector13.unitize();
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException");
    } catch (org.apache.commons.math3.exception.MathArithmeticException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathArithmeticException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b11 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);

  }

  @Test
  public void test297() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test297"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
    org.apache.commons.math3.exception.util.Localizable localizable9 = null;
    double[] d_array11 = new double[] { 0.0d };
    double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
    double[][] d_array_array14 = new double[][] { d_array11 };
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
    org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor26 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
    double d27 = defaultRealMatrixPreservingVisitor26.end();
    double d28 = array2DRowRealMatrix25.walkInColumnOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor26);
    double[] d_array29 = new double[] {  };
    double[] d_array31 = new double[] { 100.0d };
    double[] d_array35 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b36 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array31, d_array35);
    double d37 = org.apache.commons.math3.util.MathArrays.distance(d_array29, d_array35);
    double[] d_array38 = org.apache.commons.math3.util.MathArrays.copyOf(d_array29);
    org.apache.commons.math3.exception.util.Localizable localizable39 = null;
    double[] d_array41 = new double[] { 0.0d };
    double[] d_array43 = org.apache.commons.math3.util.MathArrays.copyOf(d_array41, 1);
    double[][] d_array_array44 = new double[][] { d_array41 };
    org.apache.commons.math3.linear.RealMatrix realMatrix45 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array44);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix46 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array44);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException47 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable39, (java.lang.Object[])d_array_array44);
    org.apache.commons.math3.util.MathArrays.sortInPlace(d_array29, d_array_array44);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix49 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array44);
    org.apache.commons.math3.linear.RealMatrix realMatrix51 = array2DRowRealMatrix49.scalarAdd((-7.241149127564359d));
    org.apache.commons.math3.linear.MatrixUtils.checkMultiplicationCompatible((org.apache.commons.math3.linear.AnyMatrix)array2DRowRealMatrix25, (org.apache.commons.math3.linear.AnyMatrix)array2DRowRealMatrix49);
    double[] d_array54 = new double[] { 0.0d };
    double[] d_array56 = org.apache.commons.math3.util.MathArrays.copyOf(d_array54, 1);
    double[][] d_array_array57 = new double[][] { d_array54 };
    org.apache.commons.math3.linear.RealMatrix realMatrix58 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array57);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix59 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array57);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix61 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array57, false);
    org.apache.commons.math3.exception.util.Localizable localizable62 = null;
    double[] d_array64 = new double[] { 0.0d };
    double[] d_array66 = org.apache.commons.math3.util.MathArrays.copyOf(d_array64, 1);
    double[][] d_array_array67 = new double[][] { d_array64 };
    org.apache.commons.math3.linear.RealMatrix realMatrix68 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array67);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix69 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array67);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException70 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable62, (java.lang.Object[])d_array_array67);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix71 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array67);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition73 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix71, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix75 = array2DRowRealMatrix71.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition77 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix71, 4.9E-324d);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix78 = array2DRowRealMatrix61.subtract(array2DRowRealMatrix71);
    double d79 = array2DRowRealMatrix71.getTrace();
    org.apache.commons.math3.exception.util.Localizable localizable80 = null;
    double[] d_array82 = new double[] { 0.0d };
    double[] d_array84 = org.apache.commons.math3.util.MathArrays.copyOf(d_array82, 1);
    double[][] d_array_array85 = new double[][] { d_array82 };
    org.apache.commons.math3.linear.RealMatrix realMatrix86 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix87 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException88 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable80, (java.lang.Object[])d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix89 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition91 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix89, 1.3440585709080678E43d);
    java.lang.String str92 = array2DRowRealMatrix89.toString();
    org.apache.commons.math3.linear.RealMatrix realMatrix93 = array2DRowRealMatrix71.subtract((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix89);
    org.apache.commons.math3.linear.MatrixUtils.checkMultiplicationCompatible((org.apache.commons.math3.linear.AnyMatrix)array2DRowRealMatrix25, (org.apache.commons.math3.linear.AnyMatrix)array2DRowRealMatrix71);
    double[] d_array96 = null;
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix71.setColumn(43, d_array96);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d27 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d28 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array35);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b36 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d37 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix45);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array57);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix58);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array67);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix68);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix78);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d79 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str92 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str92.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix93);

  }

  @Test
  public void test298() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test298"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    java.lang.String str7 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor8 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement13 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixPreservingVisitor8, 0, 0, 100, 2147483647);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str7 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str7.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test299() {}
// Defects4J: flaky method
//   @Test
//   public void test299() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test299"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
//     long long3 = randomDataGenerator0.nextLong((-1L), 0L);
//     double d5 = randomDataGenerator0.nextExponential(0.6892682844514348d);
//     // The following exception was thrown during execution in test generation
//     try {
//       int i8 = randomDataGenerator0.nextPascal(10, 21.840524586984657d);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
//     } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long3 == 0L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d5 == 0.34622038260409527d);
// 
//   }

  @Test
  public void test300() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test300"); }


    double d1 = org.apache.commons.math3.util.FastMath.atan(0.8623188722876839d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.7116024720019101d);

  }

  @Test
  public void test301() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test301"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    java.lang.Number number2 = null;
    org.apache.commons.math3.exception.NumberIsTooSmallException numberIsTooSmallException4 = new org.apache.commons.math3.exception.NumberIsTooSmallException(localizable0, (java.lang.Number)(short)0, number2, false);

  }

  @Test
  public void test302() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test302"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.Field field3 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix4 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field3);
    boolean b6 = array2DRowFieldMatrix4.equals((java.lang.Object)(short)10);
    boolean b8 = array2DRowFieldMatrix4.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str9 = array2DRowFieldMatrix4.toString();
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setRowMatrix(5, (org.apache.commons.math3.linear.FieldMatrix)array2DRowFieldMatrix4);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str9 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str9.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test303() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test303"); }


    org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
    randomDataImpl0.reSeedSecure();
    randomDataImpl0.reSeed(100L);
    // The following exception was thrown during execution in test generation
    try {
      double d6 = randomDataImpl0.nextF(0.0d, 0.3983155205812365d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test304() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test304"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    double d14 = array2DRowRealMatrix9.getFrobeniusNorm();
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = array2DRowRealMatrix9.copy();
    // The following exception was thrown during execution in test generation
    try {
      double[] d_array17 = array2DRowRealMatrix9.getColumn(52);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);

  }

  @Test
  public void test305() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test305"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor5 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement10 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixPreservingVisitor5, 266627117, 52, 266627117, 49);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);

  }

  @Test
  public void test306() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test306"); }


    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(10, 0.0d);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector3 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector2);
    org.apache.commons.math3.linear.RealVectorPreservingVisitor realVectorPreservingVisitor4 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d5 = arrayRealVector3.walkInOptimizedOrder(realVectorPreservingVisitor4);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test307() {}
// Defects4J: flaky method
//   @Test
//   public void test307() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test307"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     randomDataImpl0.reSeedSecure();
//     randomDataImpl0.reSeed();
//     int i5 = randomDataImpl0.nextPascal(100, 1.0E-9d);
//     java.lang.String str7 = randomDataImpl0.nextHexString(100);
//     double d10 = randomDataImpl0.nextCauchy(2.6881171418161356E43d, 1.327000036267693d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i5 == 2147483647);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str7 + "' != '" + "3b2a05cd45f771cabbfc1dba926a6e2742af2585ab88c8613a14cc9da9d32bb1421c41d9ee58c106a12c2c80d8a4b2ede6fd"+ "'", str7.equals("3b2a05cd45f771cabbfc1dba926a6e2742af2585ab88c8613a14cc9da9d32bb1421c41d9ee58c106a12c2c80d8a4b2ede6fd"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d10 == 2.6881171418161356E43d);
// 
//   }

  @Test
  public void test308() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test308"); }


    org.apache.commons.math3.distribution.NormalDistribution normalDistribution2 = new org.apache.commons.math3.distribution.NormalDistribution(4.414646020926698E23d, 2964.191035514832d);
    double d3 = normalDistribution2.sample();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d3 == 4.414646020926698E23d);

  }

  @Test
  public void test309() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test309"); }


    double d1 = org.apache.commons.math3.util.FastMath.exp(0.07277703352123166d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.075490711802258d);

  }

  @Test
  public void test310() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test310"); }


    int i2 = org.apache.commons.math3.util.MathUtils.copySign(266627117, 49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 266627117);

  }

  @Test
  public void test311() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test311"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    double d14 = array2DRowRealMatrix9.getFrobeniusNorm();
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = array2DRowRealMatrix9.copy();
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition16 = new org.apache.commons.math3.linear.EigenDecomposition(realMatrix15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);

  }

  @Test
  public void test312() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test312"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.Field field2 = array2DRowFieldMatrix1.getField();
    org.apache.commons.math3.linear.FieldVector fieldVector4 = null;
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setRowVector(0, fieldVector4);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field2);

  }

  @Test
  public void test313() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test313"); }


    org.apache.commons.math3.exception.MathParseException mathParseException2 = new org.apache.commons.math3.exception.MathParseException("", 156287497);

  }

  @Test
  public void test314() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test314"); }


    org.apache.commons.math3.FieldElement[][] fieldElement_array_array2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.BlockFieldMatrix blockFieldMatrix4 = new org.apache.commons.math3.linear.BlockFieldMatrix(0, 0, fieldElement_array_array2, true);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException");
    } catch (org.apache.commons.math3.exception.NullArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NullArgumentException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test315() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test315"); }


    double d1 = org.apache.commons.math3.util.FastMath.ceil(3.141592653589793d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 4.0d);

  }

  @Test
  public void test316() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test316"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.NumberIsTooLargeException numberIsTooLargeException4 = new org.apache.commons.math3.exception.NumberIsTooLargeException(localizable0, (java.lang.Number)0.9956942709230656d, (java.lang.Number)Double.NaN, false);
    java.lang.Number number5 = numberIsTooLargeException4.getMax();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)number5, Double.NaN, 0);

  }

  @Test
  public void test317() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test317"); }


    java.text.NumberFormat numberFormat0 = org.apache.commons.math3.util.CompositeFormat.getDefaultNumberFormat();
    org.apache.commons.math3.linear.RealVectorFormat realVectorFormat1 = new org.apache.commons.math3.linear.RealVectorFormat(numberFormat0);
    java.lang.String str2 = realVectorFormat1.getSuffix();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str2 + "' != '" + "}"+ "'", str2.equals("}"));

  }

  @Test
  public void test318() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test318"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.FieldElement fieldElement6 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array7 = new org.apache.commons.math3.FieldElement[] { fieldElement6 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement[] fieldElement_array8 = array2DRowFieldMatrix1.preMultiply(fieldElement_array7);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array7);

  }

  @Test
  public void test319() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test319"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    double d14 = array2DRowRealMatrix9.getFrobeniusNorm();
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition15 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9);
    double[] d_array16 = eigenDecomposition15.getImagEigenvalues();
    org.apache.commons.math3.linear.RealMatrix realMatrix17 = org.apache.commons.math3.linear.MatrixUtils.createRowRealMatrix(d_array16);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.checkMatrixIndex((org.apache.commons.math3.linear.AnyMatrix)realMatrix17, 49, 49);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix17);

  }

  @Test
  public void test320() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test320"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equalsIncludingNaN((-1.0d), 89.6664240050271d, 3.2180494402710503E20d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);

  }

  @Test
  public void test321() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test321"); }


    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(10, 0.0d);
    java.lang.Double[] d_array4 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector7 = new org.apache.commons.math3.linear.ArrayRealVector(d_array4, 0, 0);
    java.lang.Double[] d_array9 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = new org.apache.commons.math3.linear.ArrayRealVector(d_array9, 0, 0);
    java.lang.Double[] d_array14 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector17 = new org.apache.commons.math3.linear.ArrayRealVector(d_array14, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector18 = arrayRealVector12.append((org.apache.commons.math3.linear.RealVector)arrayRealVector17);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector19 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector7, arrayRealVector17);
    java.lang.Double[] d_array21 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector24 = new org.apache.commons.math3.linear.ArrayRealVector(d_array21, 0, 0);
    java.lang.Double[] d_array28 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector31 = new org.apache.commons.math3.linear.ArrayRealVector(d_array28, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector32 = arrayRealVector24.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector31);
    double d33 = arrayRealVector7.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector24);
    org.apache.commons.math3.linear.RealVector realVector35 = arrayRealVector7.mapAdd(1.6931640502651133d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix36 = arrayRealVector2.outerProduct(realVector35);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d33 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector35);

  }

  @Test
  public void test322() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test322"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    int i2 = array2DRowRealMatrix0.getRowDimension();
    org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor3 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
    double d4 = array2DRowRealMatrix0.walkInColumnOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor3);
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor5 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d10 = array2DRowRealMatrix0.walkInRowOrder(realMatrixChangingVisitor5, 49, (-1), 2147483647, 2147483647);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 0.0d);

  }

  @Test
  public void test323() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test323"); }


    double d2 = org.apache.commons.math3.util.FastMath.min(10.04987562112089d, 1.3440585709080678E43d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 10.04987562112089d);

  }

  @Test
  public void test324() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test324"); }


    org.apache.commons.math3.linear.AnyMatrix anyMatrix0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.checkSubMatrixIndex(anyMatrix0, 0, 69, 156287497, 2147483647);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test325() {}
// Defects4J: flaky method
//   @Test
//   public void test325() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test325"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
//     randomDataGenerator0.reSeedSecure(6179557979701623951L);
//     int i5 = randomDataGenerator0.nextSecureInt(0, 52);
//     randomDataGenerator0.reSeedSecure();
//     // The following exception was thrown during execution in test generation
//     try {
//       double d9 = randomDataGenerator0.nextUniform(1.8396277512798853d, 0.0d);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException");
//     } catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NumberIsTooLargeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i5 == 10);
// 
//   }

  @Test
  public void test326() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test326"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    double d14 = array2DRowRealMatrix9.getFrobeniusNorm();
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = array2DRowRealMatrix9.copy();
    boolean b16 = array2DRowRealMatrix9.isTransposable();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b16 == false);

  }

  @Test
  public void test327() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test327"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    double[] d_array82 = new double[] { 0.0d };
    double[] d_array84 = org.apache.commons.math3.util.MathArrays.copyOf(d_array82, 1);
    double[][] d_array_array85 = new double[][] { d_array82 };
    org.apache.commons.math3.linear.RealMatrix realMatrix86 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix87 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    boolean b88 = arrayRealVector36.equals((java.lang.Object)d_array_array85);
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix89 = new org.apache.commons.math3.linear.BlockRealMatrix(d_array_array85);
    double d90 = blockRealMatrix89.getNorm();
    org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor91 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d92 = blockRealMatrix89.walkInRowOrder(realMatrixChangingVisitor91);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d90 == 0.0d);

  }

  @Test
  public void test328() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test328"); }


    double[] d_array1 = new double[] { 1.0d };
    org.apache.commons.math3.linear.RealMatrix realMatrix2 = org.apache.commons.math3.linear.MatrixUtils.createColumnRealMatrix(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix2);

  }

  @Test
  public void test329() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test329"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    double[] d_array18 = new double[] { 0.0d };
    double[] d_array20 = org.apache.commons.math3.util.MathArrays.copyOf(d_array18, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector16, d_array20);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, false);
    int i29 = arrayRealVector28.getMaxIndex();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = arrayRealVector21.combineToSelf(0.0d, (-7.241149127564359d), (org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    double[] d_array31 = arrayRealVector21.toArray();
    // The following exception was thrown during execution in test generation
    try {
      arrayRealVector21.addToEntry(266627117, 0.07233143692049858d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i29 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);

  }

  @Test
  public void test330() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test330"); }


    double[] d_array0 = null;
    double[] d_array1 = null;
    boolean b2 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array0, d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == true);

  }

  @Test
  public void test331() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test331"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array8 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array5, 1.3440585709080678E43d);
    java.lang.Double[] d_array10 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = new org.apache.commons.math3.linear.ArrayRealVector(d_array10, 0, 0);
    java.lang.Double[] d_array17 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector20 = new org.apache.commons.math3.linear.ArrayRealVector(d_array17, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = arrayRealVector13.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector20);
    boolean b22 = arrayRealVector21.isInfinite();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, arrayRealVector21);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector25 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);

  }

  @Test
  public void test332() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test332"); }


    double d1 = org.apache.commons.math3.util.FastMath.expm1(21.840524586984657d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 3.056464175659406E9d);

  }

  @Test
  public void test333() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test333"); }


    long long2 = org.apache.commons.math3.util.MathUtils.copySign((-2252072468373639168L), 0L);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long2 == 2252072468373639168L);

  }

  @Test
  public void test334() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test334"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix12 = eigenDecomposition11.getV();
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = eigenDecomposition11.getD();
    double[] d_array14 = eigenDecomposition11.getRealEigenvalues();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array14);

  }

  @Test
  public void test335() {}
// Defects4J: flaky method
//   @Test
//   public void test335() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test335"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     randomDataImpl0.reSeedSecure();
//     randomDataImpl0.reSeed();
//     randomDataImpl0.reSeedSecure(49L);
//     double d7 = randomDataImpl0.nextF(3.141592653589793d, 1.5707963267948966d);
//     // The following exception was thrown during execution in test generation
//     try {
//       int i10 = randomDataImpl0.nextBinomial(43, 14.556736826696994d);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
//     } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d7 == 0.29779077464428716d);
// 
//   }

  @Test
  public void test336() {}
// Defects4J: flaky method
//   @Test
//   public void test336() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test336"); }
// 
// 
//     org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
//     double d2 = well19937c1.nextDouble();
//     org.apache.commons.math3.distribution.NormalDistribution normalDistribution6 = new org.apache.commons.math3.distribution.NormalDistribution((org.apache.commons.math3.random.RandomGenerator)well19937c1, 1.0E-6d, 2.7755575615628914E-17d, (-1.0d));
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl7 = new org.apache.commons.math3.random.RandomDataImpl((org.apache.commons.math3.random.RandomGenerator)well19937c1);
//     long long10 = randomDataImpl7.nextSecureLong((-5257717138665064837L), (-1L));
//     randomDataImpl7.reSeed(49L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d2 == 0.07277703352123166d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long10 == (-2241639822616691712L));
// 
//   }

  @Test
  public void test337() {}
// Defects4J: flaky method
//   @Test
//   public void test337() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test337"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     randomDataImpl0.reSeedSecure();
//     randomDataImpl0.reSeed();
//     randomDataImpl0.reSeedSecure(49L);
//     double d7 = randomDataImpl0.nextGamma(3.1780538303479458d, 2.718281828459045d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d7 == 6.063618355591195d);
// 
//   }

  @Test
  public void test338() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test338"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector2, false);
    double d5 = arrayRealVector4.getMaxValue();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d5 == 10.0d);

  }

  @Test
  public void test339() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test339"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    java.lang.String str7 = array2DRowFieldMatrix1.toString();
    boolean b8 = array2DRowFieldMatrix1.isSquare();
    java.lang.String str9 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor10 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement11 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixPreservingVisitor10);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str7 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str7.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b8 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str9 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str9.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test340() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test340"); }


    org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
    randomDataImpl0.reSeedSecure();
    randomDataImpl0.reSeed(100L);
    java.util.Collection collection4 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Object[] obj_array6 = randomDataImpl0.nextSample(collection4, 49);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test341() {}
// Defects4J: flaky method
//   @Test
//   public void test341() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test341"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
//     randomDataGenerator0.reSeedSecure(6179557979701623951L);
//     int i5 = randomDataGenerator0.nextSecureInt(0, 52);
//     // The following exception was thrown during execution in test generation
//     try {
//       int i9 = randomDataGenerator0.nextHypergeometric(9, 266627117, 9);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException");
//     } catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NumberIsTooLargeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i5 == 40);
// 
//   }

  @Test
  public void test342() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test342"); }


    float f2 = org.apache.commons.math3.util.FastMath.max(0.0f, 0.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f2 == 0.0f);

  }

  @Test
  public void test343() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test343"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    int i5 = arrayRealVector4.getDimension();
    double[] d_array6 = arrayRealVector4.toArray();
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array8 = array2DRowRealMatrix7.getDataRef();
    int i9 = array2DRowRealMatrix7.getRowDimension();
    double[][] d_array_array10 = array2DRowRealMatrix7.getData();
    org.apache.commons.math3.util.MathArrays.sortInPlace(d_array6, d_array_array10);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix12 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array10);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i9 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array10);

  }

  @Test
  public void test344() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test344"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat1 = org.apache.commons.math3.linear.RealMatrixFormat.getInstance();
    java.text.NumberFormat numberFormat2 = realMatrixFormat1.getFormat();
    java.lang.StringBuffer stringBuffer3 = null;
    java.text.FieldPosition fieldPosition4 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.lang.StringBuffer stringBuffer5 = org.apache.commons.math3.util.CompositeFormat.formatDouble(3.4719061895220023d, numberFormat2, stringBuffer3, fieldPosition4);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrixFormat1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat2);

  }

  @Test
  public void test345() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test345"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    double d14 = array2DRowRealMatrix9.getFrobeniusNorm();
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition15 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9);
    double[] d_array16 = eigenDecomposition15.getImagEigenvalues();
    double[] d_array18 = new double[] { 0.0d };
    double[] d_array20 = org.apache.commons.math3.util.MathArrays.copyOf(d_array18, 1);
    double[] d_array22 = new double[] { 100.0d };
    double[] d_array26 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b27 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array22, d_array26);
    boolean b28 = org.apache.commons.math3.util.MathArrays.equals(d_array18, d_array22);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector29 = new org.apache.commons.math3.linear.ArrayRealVector(d_array18);
    double d30 = org.apache.commons.math3.util.MathArrays.distance1(d_array16, d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b27 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b28 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d30 == 0.0d);

  }

  @Test
  public void test346() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test346"); }


    double d2 = org.apache.commons.math3.util.FastMath.copySign(0.12179535056938828d, (-1.0d));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == (-0.12179535056938828d));

  }

  @Test
  public void test347() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test347"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.Field field2 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix3 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field2);
    boolean b5 = array2DRowFieldMatrix3.equals((java.lang.Object)(short)10);
    boolean b7 = array2DRowFieldMatrix3.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field8 = array2DRowFieldMatrix3.getField();
    java.lang.String str9 = array2DRowFieldMatrix3.toString();
    boolean b10 = array2DRowFieldMatrix3.isSquare();
    java.lang.String str11 = array2DRowFieldMatrix3.toString();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix12 = array2DRowFieldMatrix1.multiply(array2DRowFieldMatrix3);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str9 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str9.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b10 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str11 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str11.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test348() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test348"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.linear.FieldMatrix fieldMatrix7 = null;
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setColumnMatrix((-49), fieldMatrix7);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);

  }

  @Test
  public void test349() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test349"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equalsIncludingNaN((-0.9999999f), 10.0f, 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test350() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test350"); }


    double d1 = org.apache.commons.math3.util.FastMath.cos((-7.241149127564358d));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.5751868171778031d);

  }

  @Test
  public void test351() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test351"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector5 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector8 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 52, 266627117);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException");
    } catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NumberIsTooLargeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);

  }

  @Test
  public void test352() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test352"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat0 = org.apache.commons.math3.linear.MatrixUtils.DEFAULT_FORMAT;
    java.text.NumberFormat numberFormat1 = realMatrixFormat0.getFormat();
    java.lang.String str2 = realMatrixFormat0.getRowPrefix();
    java.lang.String str3 = realMatrixFormat0.getRowSeparator();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrixFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str2 + "' != '" + "{"+ "'", str2.equals("{"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str3 + "' != '" + ","+ "'", str3.equals(","));

  }

  @Test
  public void test353() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test353"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.analysis.UnivariateFunction univariateFunction13 = null;
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = arrayRealVector12.map(univariateFunction13);
    java.lang.Double[] d_array16 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector19 = new org.apache.commons.math3.linear.ArrayRealVector(d_array16, 0, 0);
    java.lang.Double[] d_array23 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = new org.apache.commons.math3.linear.ArrayRealVector(d_array23, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = arrayRealVector19.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector26);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = arrayRealVector27.copy();
    org.apache.commons.math3.linear.RealVector realVector30 = arrayRealVector27.mapDivide(49.41408584662507d);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector31 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector14, arrayRealVector27);
    org.apache.commons.math3.analysis.UnivariateFunction univariateFunction32 = null;
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector33 = arrayRealVector27.map(univariateFunction32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector28);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector33);

  }

  @Test
  public void test354() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test354"); }


    java.lang.Number number0 = null;
    org.apache.commons.math3.exception.NotStrictlyPositiveException notStrictlyPositiveException1 = new org.apache.commons.math3.exception.NotStrictlyPositiveException(number0);

  }

  @Test
  public void test355() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test355"); }


    java.lang.Double[] d_array3 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector6 = new org.apache.commons.math3.linear.ArrayRealVector(d_array3, 0, 0);
    int i7 = arrayRealVector6.getDimension();
    double[] d_array8 = arrayRealVector6.toArray();
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array10 = array2DRowRealMatrix9.getDataRef();
    int i11 = array2DRowRealMatrix9.getRowDimension();
    double[][] d_array_array12 = array2DRowRealMatrix9.getData();
    org.apache.commons.math3.util.MathArrays.sortInPlace(d_array8, d_array_array12);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix15 = new org.apache.commons.math3.linear.BlockRealMatrix(0, 0, d_array_array12, false);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i11 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array12);

  }

  @Test
  public void test356() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test356"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equalsIncludingNaN(1.344058570908068E43d, 2964.191035514832d, 52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);

  }

  @Test
  public void test357() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test357"); }


    boolean b3 = org.apache.commons.math3.util.Precision.equalsWithRelativeTolerance(49.66762847873805d, 49.667938200224796d, 35.50998058787508d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == true);

  }

  @Test
  public void test358() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test358"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    java.lang.Integer[] i_array2 = new java.lang.Integer[] { 10 };
    java.lang.Integer[] i_array4 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array6 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException7 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array4, i_array6);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException8 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(localizable0, i_array2, i_array4);
    // The following exception was thrown during execution in test generation
    try {
      int i10 = multiDimensionMismatchException8.getWrongDimension(5);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array6);

  }

  @Test
  public void test359() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test359"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array8 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array5, 1.3440585709080678E43d);
    double d9 = org.apache.commons.math3.util.MathArrays.safeNorm(d_array5);
    org.apache.commons.math3.linear.RealMatrix realMatrix10 = org.apache.commons.math3.linear.MatrixUtils.createColumnRealMatrix(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d9 == 100.00499987500625d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix10);

  }

  @Test
  public void test360() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test360"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    java.lang.String str7 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor8 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement9 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixChangingVisitor8);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str7 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str7.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test361() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test361"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    double[] d_array14 = new double[] { 0.0d };
    double[] d_array16 = org.apache.commons.math3.util.MathArrays.copyOf(d_array14, 1);
    double[][] d_array_array17 = new double[][] { d_array14 };
    org.apache.commons.math3.linear.RealMatrix realMatrix18 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array17);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix19 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array17);
    org.apache.commons.math3.linear.RealMatrix realMatrix21 = array2DRowRealMatrix19.scalarMultiply(0.0d);
    boolean b22 = array2DRowRealMatrix19.isSquare();
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix23 = array2DRowRealMatrix9.subtract(array2DRowRealMatrix19);
    org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor24 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
    // The following exception was thrown during execution in test generation
    try {
      double d29 = array2DRowRealMatrix9.walkInOptimizedOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor24, 2, 9, (-1), 43);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix23);

  }

  @Test
  public void test362() {}
// Defects4J: flaky method
//   @Test
//   public void test362() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test362"); }
// 
// 
//     double[] d_array1 = new double[] { 0.0d };
//     double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
//     double[][] d_array_array4 = new double[][] { d_array1 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
//     org.apache.commons.math3.exception.util.Localizable localizable9 = null;
//     double[] d_array11 = new double[] { 0.0d };
//     double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
//     double[][] d_array_array14 = new double[][] { d_array11 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
//     org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix26 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
//     double[][] d_array_array27 = array2DRowRealMatrix26.getDataRef();
//     boolean b28 = array2DRowRealMatrix26.isSquare();
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl29 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d32 = randomDataImpl29.nextUniform((-1.0d), 100.0d);
//     int[] i_array35 = randomDataImpl29.nextPermutation(10, 1);
//     int i38 = randomDataImpl29.nextZipf(52, 4.641588833612779d);
//     boolean b39 = array2DRowRealMatrix26.equals((java.lang.Object)randomDataImpl29);
//     boolean b40 = array2DRowRealMatrix8.equals((java.lang.Object)array2DRowRealMatrix26);
//     // The following exception was thrown during execution in test generation
//     try {
//       org.apache.commons.math3.linear.RealMatrix realMatrix42 = array2DRowRealMatrix8.getRowMatrix(1);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
//     } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(d_array_array27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b28 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d32 == 84.43491012568313d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i38 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b39 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b40 == false);
// 
//   }

  @Test
  public void test363() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test363"); }


    double d1 = org.apache.commons.math3.util.FastMath.acos(5.29205908405969d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d1, Double.NaN, 0);

  }

  @Test
  public void test364() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test364"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    int i5 = arrayRealVector4.getDimension();
    double[] d_array6 = arrayRealVector4.toArray();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector7 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector4);
    org.apache.commons.math3.linear.RealVector realVector9 = arrayRealVector4.mapSubtract(1.6931640502651133d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector9);

  }

  @Test
  public void test365() {}
// Defects4J: flaky method
//   @Test
//   public void test365() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test365"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
//     long long3 = randomDataGenerator0.nextLong((-1L), 0L);
//     double d5 = randomDataGenerator0.nextExponential(0.6892682844514348d);
//     // The following exception was thrown during execution in test generation
//     try {
//       double d8 = randomDataGenerator0.nextBeta(6.095135277953756d, Double.POSITIVE_INFINITY);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.ConvergenceException");
//     } catch (org.apache.commons.math3.exception.ConvergenceException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.ConvergenceException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.ConvergenceException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long3 == (-1L));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d5 == 1.7991219570277412d);
// 
//   }

  @Test
  public void test366() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test366"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    double[] d_array82 = new double[] { 0.0d };
    double[] d_array84 = org.apache.commons.math3.util.MathArrays.copyOf(d_array82, 1);
    double[][] d_array_array85 = new double[][] { d_array82 };
    org.apache.commons.math3.linear.RealMatrix realMatrix86 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix87 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    boolean b88 = arrayRealVector36.equals((java.lang.Object)d_array_array85);
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix89 = new org.apache.commons.math3.linear.BlockRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.RealMatrix realMatrix91 = blockRealMatrix89.scalarMultiply(0.0d);
    org.apache.commons.math3.linear.RealMatrixPreservingVisitor realMatrixPreservingVisitor92 = null;
    // The following exception was thrown during execution in test generation
    try {
      double d93 = blockRealMatrix89.walkInRowOrder(realMatrixPreservingVisitor92);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix91);

  }

  @Test
  public void test367() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test367"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    double d2 = well19937c1.nextDouble();
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution6 = new org.apache.commons.math3.distribution.NormalDistribution((org.apache.commons.math3.random.RandomGenerator)well19937c1, 1.0E-6d, 2.7755575615628914E-17d, (-1.0d));
    double d8 = normalDistribution6.probability(2.6881171418161356E43d);
    double d10 = normalDistribution6.density(1.3622825063580968d);
    double d11 = normalDistribution6.getNumericalVariance();
    double d14 = normalDistribution6.cumulativeProbability(1.315265444157678d, 6.095135277953756d);
    double d15 = normalDistribution6.getMean();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.07277703352123166d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d10 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d11 == 7.703719777548943E-34d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d15 == 1.0E-6d);

  }

  @Test
  public void test368() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test368"); }


    org.apache.commons.math3.exception.NotStrictlyPositiveException notStrictlyPositiveException1 = new org.apache.commons.math3.exception.NotStrictlyPositiveException((java.lang.Number)10.0d);

  }

  @Test
  public void test369() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test369"); }


    double d1 = org.apache.commons.math3.util.FastMath.cbrt(2.4053276775961323d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.3398558688067956d);

  }

  @Test
  public void test370() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test370"); }


    java.lang.Class clazz2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.exception.MathParseException mathParseException3 = new org.apache.commons.math3.exception.MathParseException("hi!", 52, clazz2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test371() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test371"); }


    boolean b2 = org.apache.commons.math3.util.Precision.equals((-3.4893569077129025d), 6.063618355591195d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);

  }

  @Test
  public void test372() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test372"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    boolean b7 = array2DRowFieldMatrix1.isSquare();
    int i8 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.linear.FieldMatrix fieldMatrix10 = null;
    // The following exception was thrown during execution in test generation
    try {
      array2DRowFieldMatrix1.setRowMatrix(69, fieldMatrix10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i8 == 0);

  }

  @Test
  public void test373() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test373"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
    double[][] d_array_array9 = array2DRowRealMatrix8.getData();
    org.apache.commons.math3.exception.util.Localizable localizable14 = null;
    org.apache.commons.math3.exception.util.Localizable localizable15 = null;
    double[] d_array17 = new double[] { 0.0d };
    double[] d_array19 = org.apache.commons.math3.util.MathArrays.copyOf(d_array17, 1);
    double[][] d_array_array20 = new double[][] { d_array17 };
    org.apache.commons.math3.linear.RealMatrix realMatrix21 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array20);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix22 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array20);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException23 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable15, (java.lang.Object[])d_array_array20);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix24 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array20);
    org.apache.commons.math3.exception.ZeroException zeroException25 = new org.apache.commons.math3.exception.ZeroException(localizable14, (java.lang.Object[])d_array_array20);
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix8.copySubMatrix(0, 156287497, 100, 43, d_array_array20);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix21);

  }

  @Test
  public void test374() {}
// Defects4J: flaky method
//   @Test
//   public void test374() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test374"); }
// 
// 
//     double[] d_array1 = new double[] { 0.0d };
//     double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
//     double[][] d_array_array4 = new double[][] { d_array1 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
//     org.apache.commons.math3.exception.util.Localizable localizable9 = null;
//     double[] d_array11 = new double[] { 0.0d };
//     double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
//     double[][] d_array_array14 = new double[][] { d_array11 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
//     org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
//     org.apache.commons.math3.linear.RealMatrix realMatrix27 = array2DRowRealMatrix25.power(1);
//     org.apache.commons.math3.exception.util.Localizable localizable28 = null;
//     double[] d_array30 = new double[] { 0.0d };
//     double[] d_array32 = org.apache.commons.math3.util.MathArrays.copyOf(d_array30, 1);
//     double[][] d_array_array33 = new double[][] { d_array30 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix34 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array33);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix35 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array33);
//     org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException36 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable28, (java.lang.Object[])d_array_array33);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix37 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array33);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition39 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix37, 1.3440585709080678E43d);
//     java.lang.String str40 = array2DRowRealMatrix37.toString();
//     double[] d_array42 = new double[] { 0.0d };
//     double[] d_array44 = org.apache.commons.math3.util.MathArrays.copyOf(d_array42, 1);
//     double[][] d_array_array45 = new double[][] { d_array42 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix46 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array45);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix47 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array45);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix49 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array45, false);
//     org.apache.commons.math3.exception.util.Localizable localizable50 = null;
//     double[] d_array52 = new double[] { 0.0d };
//     double[] d_array54 = org.apache.commons.math3.util.MathArrays.copyOf(d_array52, 1);
//     double[][] d_array_array55 = new double[][] { d_array52 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix56 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array55);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix57 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array55);
//     org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException58 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable50, (java.lang.Object[])d_array_array55);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix59 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array55);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition61 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix59, 1.3440585709080678E43d);
//     org.apache.commons.math3.linear.RealMatrix realMatrix63 = array2DRowRealMatrix59.scalarAdd(0.3932953321069236d);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition65 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix59, 4.9E-324d);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix66 = array2DRowRealMatrix49.subtract(array2DRowRealMatrix59);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix67 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
//     double[][] d_array_array68 = array2DRowRealMatrix67.getDataRef();
//     boolean b69 = array2DRowRealMatrix67.isSquare();
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl70 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d73 = randomDataImpl70.nextUniform((-1.0d), 100.0d);
//     int[] i_array76 = randomDataImpl70.nextPermutation(10, 1);
//     int i79 = randomDataImpl70.nextZipf(52, 4.641588833612779d);
//     boolean b80 = array2DRowRealMatrix67.equals((java.lang.Object)randomDataImpl70);
//     boolean b81 = array2DRowRealMatrix49.equals((java.lang.Object)array2DRowRealMatrix67);
//     org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor82 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
//     double d83 = array2DRowRealMatrix49.walkInColumnOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor82);
//     double[] d_array85 = new double[] { 0.0d };
//     double[] d_array87 = org.apache.commons.math3.util.MathArrays.copyOf(d_array85, 1);
//     double[] d_array89 = new double[] { 100.0d };
//     double[] d_array93 = new double[] { 0.0d, (-1.0d), 100.0d };
//     boolean b94 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array89, d_array93);
//     boolean b95 = org.apache.commons.math3.util.MathArrays.equals(d_array85, d_array89);
//     org.apache.commons.math3.linear.ArrayRealVector arrayRealVector96 = new org.apache.commons.math3.linear.ArrayRealVector(d_array85);
//     double[] d_array97 = array2DRowRealMatrix49.operate(d_array85);
//     double[] d_array98 = array2DRowRealMatrix37.preMultiply(d_array85);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix99 = array2DRowRealMatrix25.add(array2DRowRealMatrix37);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array30);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array32);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array33);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix34);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str40 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str40.equals("Array2DRowRealMatrix{{0.0}}"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array42);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array44);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array45);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix46);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array52);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array54);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array55);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix56);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix63);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(array2DRowRealMatrix66);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(d_array_array68);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b69 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d73 == 87.24680611106318d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array76);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i79 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b80 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b81 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d83 == 0.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array85);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array87);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array89);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array93);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b94 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b95 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array97);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array98);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(array2DRowRealMatrix99);
// 
//   }

  @Test
  public void test375() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test375"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    double[] d_array82 = new double[] { 0.0d };
    double[] d_array84 = org.apache.commons.math3.util.MathArrays.copyOf(d_array82, 1);
    double[][] d_array_array85 = new double[][] { d_array82 };
    org.apache.commons.math3.linear.RealMatrix realMatrix86 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix87 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    boolean b88 = arrayRealVector36.equals((java.lang.Object)d_array_array85);
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix89 = new org.apache.commons.math3.linear.BlockRealMatrix(d_array_array85);
    double d90 = blockRealMatrix89.getNorm();
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix92 = blockRealMatrix89.scalarAdd(24.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d90 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockRealMatrix92);

  }

  @Test
  public void test376() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test376"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    double d2 = well19937c1.nextDouble();
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution6 = new org.apache.commons.math3.distribution.NormalDistribution((org.apache.commons.math3.random.RandomGenerator)well19937c1, 1.0E-6d, 2.7755575615628914E-17d, (-1.0d));
    double d8 = normalDistribution6.probability(2.6881171418161356E43d);
    double d10 = normalDistribution6.density(1.3622825063580968d);
    double d11 = normalDistribution6.getNumericalVariance();
    double d14 = normalDistribution6.cumulativeProbability(1.315265444157678d, 6.095135277953756d);
    org.apache.commons.math3.exception.util.Localizable localizable15 = null;
    java.lang.Number number16 = null;
    org.apache.commons.math3.exception.util.Localizable localizable17 = null;
    org.apache.commons.math3.exception.util.Localizable localizable18 = null;
    double[] d_array21 = new double[] { 0.0d };
    double[] d_array23 = org.apache.commons.math3.util.MathArrays.copyOf(d_array21, 1);
    java.lang.Object[] obj_array24 = new java.lang.Object[] { d_array21 };
    org.apache.commons.math3.exception.MaxCountExceededException maxCountExceededException25 = new org.apache.commons.math3.exception.MaxCountExceededException(localizable18, (java.lang.Number)(byte)0, obj_array24);
    org.apache.commons.math3.exception.MathInternalError mathInternalError26 = new org.apache.commons.math3.exception.MathInternalError(localizable17, obj_array24);
    org.apache.commons.math3.exception.NotFiniteNumberException notFiniteNumberException27 = new org.apache.commons.math3.exception.NotFiniteNumberException(number16, obj_array24);
    org.apache.commons.math3.util.MathUtils.checkNotNull((java.lang.Object)d14, localizable15, obj_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.07277703352123166d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d8 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d10 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d11 == 7.703719777548943E-34d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj_array24);

  }

  @Test
  public void test377() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test377"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement3 = array2DRowFieldMatrix1.walkInOptimizedOrder(fieldMatrixChangingVisitor2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test378() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test378"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    double[] d_array82 = new double[] { 0.0d };
    double[] d_array84 = org.apache.commons.math3.util.MathArrays.copyOf(d_array82, 1);
    double[][] d_array_array85 = new double[][] { d_array82 };
    org.apache.commons.math3.linear.RealMatrix realMatrix86 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix87 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    boolean b88 = arrayRealVector36.equals((java.lang.Object)d_array_array85);
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix89 = new org.apache.commons.math3.linear.BlockRealMatrix(d_array_array85);
    double d90 = blockRealMatrix89.getNorm();
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix92 = blockRealMatrix89.getColumnMatrix(0);
    double d93 = blockRealMatrix92.getNorm();
    double[][] d_array_array94 = blockRealMatrix92.getData();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d90 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(blockRealMatrix92);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d93 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array94);

  }

  @Test
  public void test379() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test379"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.linear.FieldMatrixChangingVisitor fieldMatrixChangingVisitor6 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement11 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixChangingVisitor6, (-1), 156287497, 52, 1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);

  }

  @Test
  public void test380() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test380"); }


    org.apache.commons.math3.exception.MaxCountExceededException maxCountExceededException1 = new org.apache.commons.math3.exception.MaxCountExceededException((java.lang.Number)(byte)100);
    org.apache.commons.math3.exception.util.ExceptionContext exceptionContext2 = maxCountExceededException1.getContext();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(exceptionContext2);

  }

  @Test
  public void test381() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test381"); }


    org.apache.commons.math3.exception.MaxCountExceededException maxCountExceededException1 = new org.apache.commons.math3.exception.MaxCountExceededException((java.lang.Number)156287497);

  }

  @Test
  public void test382() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test382"); }


    double d1 = org.apache.commons.math3.util.FastMath.toRadians(697.8487999813906d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 12.179759240766609d);

  }

  @Test
  public void test383() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test383"); }


    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException3 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.3440585709080678E43d, (java.lang.Number)1.3440585709080678E43d, 2147483647);
    boolean b4 = nonMonotonicSequenceException3.getStrict();
    java.lang.Number number5 = nonMonotonicSequenceException3.getPrevious();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + number5 + "' != '" + 1.3440585709080678E43d+ "'", number5.equals(1.3440585709080678E43d));

  }

  @Test
  public void test384() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test384"); }


    java.text.NumberFormat numberFormat3 = org.apache.commons.math3.util.CompositeFormat.getDefaultNumberFormat();
    org.apache.commons.math3.linear.RealVectorFormat realVectorFormat4 = new org.apache.commons.math3.linear.RealVectorFormat(numberFormat3);
    org.apache.commons.math3.linear.RealVectorFormat realVectorFormat5 = new org.apache.commons.math3.linear.RealVectorFormat("5515c956b2eab6260306e287b6e79f9b24f15f0c4374f130a0c3f153c6cd0cd56d53992ff18a0c43e497680ba0f4a0f1340d", "0443c4d536f100ec9a88b14a628af6dc0dcee0063319898fce366deda8074b38738aeb489b9a1df46e422e39642044f0ad05", "0443c4d536f100ec9a88b14a628af6dc0dcee0063319898fce366deda8074b38738aeb489b9a1df46e422e39642044f0ad05", numberFormat3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat3);

  }

  @Test
  public void test385() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test385"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
    org.apache.commons.math3.exception.util.Localizable localizable9 = null;
    double[] d_array11 = new double[] { 0.0d };
    double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
    double[][] d_array_array14 = new double[][] { d_array11 };
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix30 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array31 = array2DRowRealMatrix30.getDataRef();
    int i32 = array2DRowRealMatrix30.getRowDimension();
    double[][] d_array_array33 = array2DRowRealMatrix30.getData();
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix8.copySubMatrix(2, 0, 10, 10, d_array_array33);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i32 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array33);

  }

  @Test
  public void test386() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test386"); }


    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(10, 0.0d);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector3 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector2);
    java.lang.Double[] d_array5 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector6 = new org.apache.commons.math3.linear.ArrayRealVector(d_array5);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector8 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector6, false);
    int i9 = arrayRealVector8.getMaxIndex();
    org.apache.commons.math3.linear.RealVector realVector11 = arrayRealVector8.append(2964.191035514832d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector2.add(realVector11);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i9 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector11);

  }

  @Test
  public void test387() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test387"); }


    double[] d_array1 = new double[] { 0.0d };
    double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
    double[][] d_array_array4 = new double[][] { d_array1 };
    org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
    org.apache.commons.math3.exception.util.Localizable localizable9 = null;
    double[] d_array11 = new double[] { 0.0d };
    double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
    double[][] d_array_array14 = new double[][] { d_array11 };
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
    double[] d_array27 = new double[] { 0.0d };
    double[] d_array29 = org.apache.commons.math3.util.MathArrays.copyOf(d_array27, 1);
    double[][] d_array_array30 = new double[][] { d_array27 };
    org.apache.commons.math3.linear.RealMatrix realMatrix31 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array30);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix32 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array30);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix34 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array30, false);
    org.apache.commons.math3.exception.util.Localizable localizable35 = null;
    double[] d_array37 = new double[] { 0.0d };
    double[] d_array39 = org.apache.commons.math3.util.MathArrays.copyOf(d_array37, 1);
    double[][] d_array_array40 = new double[][] { d_array37 };
    org.apache.commons.math3.linear.RealMatrix realMatrix41 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array40);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix42 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array40);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException43 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable35, (java.lang.Object[])d_array_array40);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix44 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array40);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition46 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix44, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix48 = array2DRowRealMatrix44.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition50 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix44, 4.9E-324d);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix51 = array2DRowRealMatrix34.subtract(array2DRowRealMatrix44);
    org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor52 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
    double d53 = array2DRowRealMatrix51.walkInOptimizedOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor52);
    org.apache.commons.math3.linear.MatrixUtils.checkMultiplicationCompatible((org.apache.commons.math3.linear.AnyMatrix)array2DRowRealMatrix25, (org.apache.commons.math3.linear.AnyMatrix)array2DRowRealMatrix51);
    org.apache.commons.math3.exception.util.Localizable localizable59 = null;
    org.apache.commons.math3.exception.util.Localizable localizable60 = null;
    double[] d_array62 = new double[] { 0.0d };
    double[] d_array64 = org.apache.commons.math3.util.MathArrays.copyOf(d_array62, 1);
    double[][] d_array_array65 = new double[][] { d_array62 };
    org.apache.commons.math3.linear.RealMatrix realMatrix66 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array65);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix67 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array65);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException68 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable60, (java.lang.Object[])d_array_array65);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix69 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array65);
    org.apache.commons.math3.exception.ZeroException zeroException70 = new org.apache.commons.math3.exception.ZeroException(localizable59, (java.lang.Object[])d_array_array65);
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix25.copySubMatrix(0, 1, 5, 5, d_array_array65);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix41);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(array2DRowRealMatrix51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d53 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array64);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix66);

  }

  @Test
  public void test388() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test388"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    java.lang.String str7 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.FieldElement fieldElement8 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array9 = new org.apache.commons.math3.FieldElement[] { fieldElement8 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement[] fieldElement_array10 = array2DRowFieldMatrix1.preMultiply(fieldElement_array9);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str7 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str7.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array9);

  }

  @Test
  public void test389() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test389"); }


    boolean b2 = org.apache.commons.math3.util.Precision.equalsIncludingNaN(1.4E-45f, 1.776357E-15f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b2 == false);

  }

  @Test
  public void test390() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test390"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    org.apache.commons.math3.Field field4 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix5 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field4);
    boolean b7 = array2DRowFieldMatrix5.equals((java.lang.Object)(short)10);
    boolean b9 = array2DRowFieldMatrix5.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field10 = array2DRowFieldMatrix5.getField();
    java.lang.String str11 = array2DRowFieldMatrix5.toString();
    boolean b12 = array2DRowFieldMatrix5.isSquare();
    org.apache.commons.math3.distribution.NormalDistribution normalDistribution16 = new org.apache.commons.math3.distribution.NormalDistribution(4.414646020926698E23d, 4.691649480399091E41d, 2964.191035514832d);
    boolean b17 = array2DRowFieldMatrix5.equals((java.lang.Object)2964.191035514832d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix18 = array2DRowFieldMatrix1.subtract((org.apache.commons.math3.linear.FieldMatrix)array2DRowFieldMatrix5);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b9 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str11 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str11.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);

  }

  @Test
  public void test391() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test391"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    int i13 = array2DRowRealMatrix9.getColumnDimension();
    boolean b14 = array2DRowRealMatrix9.isTransposable();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i13 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);

  }

  @Test
  public void test392() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test392"); }


    double d1 = org.apache.commons.math3.util.FastMath.tan(7.241149127564359d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.4221850306345674d);

  }

  @Test
  public void test393() {}
// Defects4J: flaky method
//   @Test
//   public void test393() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test393"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     randomDataImpl0.reSeedSecure();
//     randomDataImpl0.reSeed();
//     randomDataImpl0.reSeedSecure(49L);
//     double d7 = randomDataImpl0.nextF(3.141592653589793d, 1.5707963267948966d);
//     double d10 = randomDataImpl0.nextF(0.6892682844514348d, 100.0d);
//     randomDataImpl0.reSeedSecure();
//     double d14 = randomDataImpl0.nextWeibull(1.3398558688067956d, 1.845203840522836E41d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d7 == 5.628847655264188d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d10 == 0.004411809173850576d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d14 == 2.8359553078898264E40d);
// 
//   }

  @Test
  public void test394() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test394"); }


    double d1 = org.apache.commons.math3.util.FastMath.atanh((-1.4221850306345674d));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertEquals((double)d1, Double.NaN, 0);

  }

  @Test
  public void test395() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test395"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement3 = array2DRowFieldMatrix1.walkInRowOrder(fieldMatrixPreservingVisitor2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test396() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test396"); }


    double d2 = org.apache.commons.math3.util.FastMath.copySign((-7.241149127564358d), 0.990730617910627d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 7.241149127564358d);

  }

  @Test
  public void test397() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test397"); }


    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException3 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.3440585709080678E43d, (java.lang.Number)1.3440585709080678E43d, 2147483647);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection4 = nonMonotonicSequenceException3.getDirection();
    int i5 = nonMonotonicSequenceException3.getIndex();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 2147483647);

  }

  @Test
  public void test398() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test398"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    int i13 = array2DRowRealMatrix9.getRowDimension();
    double[] d_array15 = new double[] { 100.0d };
    double[] d_array19 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b20 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array15, d_array19);
    double[] d_array22 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array19, 1.3440585709080678E43d);
    double[] d_array24 = org.apache.commons.math3.util.MathArrays.copyOf(d_array19, 1);
    double[] d_array25 = array2DRowRealMatrix9.operate(d_array24);
    boolean b26 = array2DRowRealMatrix9.isSquare();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i13 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b26 == true);

  }

  @Test
  public void test399() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test399"); }


    float f1 = org.apache.commons.math3.util.FastMath.signum(0.99999994f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f1 == 1.0f);

  }

  @Test
  public void test400() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test400"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.DimensionMismatchException dimensionMismatchException3 = new org.apache.commons.math3.exception.DimensionMismatchException(localizable0, 1, 100);
    int i4 = dimensionMismatchException3.getDimension();
    int i5 = dimensionMismatchException3.getDimension();
    int i6 = dimensionMismatchException3.getDimension();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 100);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 100);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i6 == 100);

  }

  @Test
  public void test401() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test401"); }


    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(10, 0.0d);
    org.apache.commons.math3.linear.RealVector realVector4 = arrayRealVector2.mapDivide(1.3407807929942133E154d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector4);

  }

  @Test
  public void test402() {}
// Defects4J: flaky method
//   @Test
//   public void test402() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test402"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
//     randomDataGenerator0.reSeedSecure(6179557979701623951L);
//     int i5 = randomDataGenerator0.nextSecureInt(0, 1);
//     // The following exception was thrown during execution in test generation
//     try {
//       int[] i_array8 = randomDataGenerator0.nextPermutation(0, 0);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
//     } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i5 == 1);
// 
//   }

  @Test
  public void test403() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test403"); }


    double d1 = org.apache.commons.math3.util.FastMath.log(4.691649480399091E41d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 95.95177303495919d);

  }

  @Test
  public void test404() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test404"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector12.mapDivide(49.41408584662507d);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealVector realVector16 = realVector15.unitVector();
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException");
    } catch (org.apache.commons.math3.exception.MathArithmeticException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathArithmeticException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathArithmeticException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);

  }

  @Test
  public void test405() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test405"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array8 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array5, 1.3440585709080678E43d);
    double d9 = org.apache.commons.math3.util.MathArrays.safeNorm(d_array5);
    double[] d_array11 = new double[] { 0.0d };
    double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
    double[] d_array15 = new double[] { 0.0d };
    double[] d_array17 = org.apache.commons.math3.util.MathArrays.copyOf(d_array15, 1);
    double[] d_array19 = new double[] { 100.0d };
    double[] d_array23 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b24 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array19, d_array23);
    boolean b25 = org.apache.commons.math3.util.MathArrays.equals(d_array15, d_array19);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, false);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition29 = new org.apache.commons.math3.linear.EigenDecomposition(d_array11, d_array15, 14.013348232392797d);
    // The following exception was thrown during execution in test generation
    try {
      double[] d_array30 = org.apache.commons.math3.util.MathArrays.ebeMultiply(d_array5, d_array11);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d9 == 100.00499987500625d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b24 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);

  }

  @Test
  public void test406() {}
// Defects4J: flaky method
//   @Test
//   public void test406() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test406"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     randomDataImpl0.reSeedSecure();
//     randomDataImpl0.reSeed(100L);
//     java.lang.String str5 = randomDataImpl0.nextSecureHexString(10);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str5 + "' != '" + "751e6873e8"+ "'", str5.equals("751e6873e8"));
// 
//   }

  @Test
  public void test407() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test407"); }


    int i1 = org.apache.commons.math3.util.FastMath.round(5.9604645E-8f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == 0);

  }

  @Test
  public void test408() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test408"); }


    float f2 = org.apache.commons.math3.util.FastMath.min(0.76195765f, 1.0f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(f2 == 0.76195765f);

  }

  @Test
  public void test409() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test409"); }


    double d2 = org.apache.commons.math3.util.FastMath.log(141.4284271283535d, 0.1754034190044697d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == (-0.3515224555273761d));

  }

  @Test
  public void test410() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test410"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    int i13 = array2DRowRealMatrix9.getRowDimension();
    double[] d_array15 = new double[] { 100.0d };
    double[] d_array19 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b20 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array15, d_array19);
    double[] d_array22 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array19, 1.3440585709080678E43d);
    double[] d_array24 = org.apache.commons.math3.util.MathArrays.copyOf(d_array19, 1);
    double[] d_array25 = array2DRowRealMatrix9.operate(d_array24);
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix9.multiplyEntry(5, 156287497, 0.0d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i13 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b20 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array22);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);

  }

  @Test
  public void test411() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test411"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.FieldElement fieldElement5 = null;
    org.apache.commons.math3.FieldElement[] fieldElement_array6 = new org.apache.commons.math3.FieldElement[] { fieldElement5 };
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement[] fieldElement_array7 = array2DRowFieldMatrix1.operate(fieldElement_array6);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException");
    } catch (org.apache.commons.math3.exception.DimensionMismatchException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.DimensionMismatchException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.DimensionMismatchException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(fieldElement_array6);

  }

  @Test
  public void test412() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test412"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.OutOfRangeException outOfRangeException4 = new org.apache.commons.math3.exception.OutOfRangeException(localizable0, (java.lang.Number)52, (java.lang.Number)(short)0, (java.lang.Number)0.5d);

  }

  @Test
  public void test413() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test413"); }


    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix0 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array1 = array2DRowRealMatrix0.getDataRef();
    int i2 = array2DRowRealMatrix0.getRowDimension();
    org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor3 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
    double d4 = array2DRowRealMatrix0.walkInColumnOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor3);
    java.lang.String str5 = array2DRowRealMatrix0.toString();
    double d6 = array2DRowRealMatrix0.getNorm();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str5 + "' != '" + "Array2DRowRealMatrix{}"+ "'", str5.equals("Array2DRowRealMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d6 == 0.0d);

  }

  @Test
  public void test414() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test414"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    int i7 = array2DRowFieldMatrix1.getColumnDimension();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i7 == 0);

  }

  @Test
  public void test415() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test415"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    int i5 = arrayRealVector4.getDimension();
    double[] d_array6 = arrayRealVector4.toArray();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector7 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector4);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector8 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);

  }

  @Test
  public void test416() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test416"); }


    double d2 = org.apache.commons.math3.util.Precision.representableDelta(4.2502863927404205E43d, 0.0032444438954024163d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.0d);

  }

  @Test
  public void test417() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test417"); }


    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix2 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(0, 52);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test418() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test418"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    double[] d_array82 = new double[] { 0.0d };
    double[] d_array84 = org.apache.commons.math3.util.MathArrays.copyOf(d_array82, 1);
    double[][] d_array_array85 = new double[][] { d_array82 };
    org.apache.commons.math3.linear.RealMatrix realMatrix86 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix87 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    boolean b88 = arrayRealVector36.equals((java.lang.Object)d_array_array85);
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix89 = new org.apache.commons.math3.linear.BlockRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.RealMatrix realMatrix91 = blockRealMatrix89.scalarMultiply(0.0d);
    java.lang.String str92 = blockRealMatrix89.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix91);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str92 + "' != '" + "BlockRealMatrix{{0.0}}"+ "'", str92.equals("BlockRealMatrix{{0.0}}"));

  }

  @Test
  public void test419() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test419"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    boolean b12 = array2DRowRealMatrix9.isTransposable();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);

  }

  @Test
  public void test420() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test420"); }


    org.apache.commons.math3.exception.OutOfRangeException outOfRangeException3 = new org.apache.commons.math3.exception.OutOfRangeException((java.lang.Number)0.916057346631253d, (java.lang.Number)70.95715494148374d, (java.lang.Number)0.6363779946031d);
    org.apache.commons.math3.exception.MathInternalError mathInternalError4 = new org.apache.commons.math3.exception.MathInternalError((java.lang.Throwable)outOfRangeException3);

  }

  @Test
  public void test421() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test421"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.DimensionMismatchException dimensionMismatchException3 = new org.apache.commons.math3.exception.DimensionMismatchException(localizable0, 266627117, 2);

  }

  @Test
  public void test422() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test422"); }


    double d1 = org.apache.commons.math3.util.FastMath.sin(0.6363779946031d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 0.5942863352744209d);

  }

  @Test
  public void test423() {}
// Defects4J: flaky method
//   @Test
//   public void test423() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test423"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
//     randomDataGenerator0.reSeedSecure(6179557979701623951L);
//     int i5 = randomDataGenerator0.nextSecureInt(0, 1);
//     double d8 = randomDataGenerator0.nextGamma(1.6931640502651133d, 49.667938200224796d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i5 == 0);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d8 == 62.35600294153569d);
// 
//   }

  @Test
  public void test424() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test424"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c(1L);
    double d2 = well19937c1.nextGaussian();
    org.apache.commons.math3.random.Well19937c well19937c4 = new org.apache.commons.math3.random.Well19937c(1L);
    well19937c4.setSeed(0);
    byte[] byte_array7 = new byte[] {  };
    well19937c4.nextBytes(byte_array7);
    well19937c1.nextBytes(byte_array7);
    long long10 = well19937c1.nextLong();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 1.327000036267693d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(byte_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(long10 == (-2940070379293551584L));

  }

  @Test
  public void test425() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test425"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix8 = array2DRowFieldMatrix1.power(0);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);

  }

  @Test
  public void test426() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test426"); }


    org.apache.commons.math3.exception.NotPositiveException notPositiveException1 = new org.apache.commons.math3.exception.NotPositiveException((java.lang.Number)1.2548583213158613d);

  }

  @Test
  public void test427() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test427"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array8 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array5, 1.3440585709080678E43d);
    double[] d_array10 = org.apache.commons.math3.util.MathArrays.copyOf(d_array5, 1);
    org.apache.commons.math3.linear.RealMatrix realMatrix11 = org.apache.commons.math3.linear.MatrixUtils.createColumnRealMatrix(d_array5);
    org.apache.commons.math3.linear.RealMatrix realMatrix12 = org.apache.commons.math3.linear.MatrixUtils.createColumnRealMatrix(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix12);

  }

  @Test
  public void test428() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test428"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    java.lang.String str7 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor8 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement13 = array2DRowFieldMatrix1.walkInColumnOrder(fieldMatrixPreservingVisitor8, 156287497, 2147483647, 5, (-1));
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str7 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str7.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test429() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test429"); }


    double[] d_array0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix1 = org.apache.commons.math3.linear.MatrixUtils.createRowRealMatrix(d_array0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException");
    } catch (org.apache.commons.math3.exception.NullArgumentException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NullArgumentException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NullArgumentException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test430() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test430"); }


    double d3 = org.apache.commons.math3.util.MathUtils.reduce(63.081707367870514d, 4.691649480399091E41d, 49.667938200224796d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d3 == 13.413769167645718d);

  }

  @Test
  public void test431() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test431"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.DimensionMismatchException dimensionMismatchException3 = new org.apache.commons.math3.exception.DimensionMismatchException(localizable0, 100, 0);
    int i4 = dimensionMismatchException3.getDimension();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);

  }

  @Test
  public void test432() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test432"); }


    org.apache.commons.math3.linear.SingularMatrixException singularMatrixException0 = new org.apache.commons.math3.linear.SingularMatrixException();
    org.apache.commons.math3.exception.util.Localizable localizable1 = null;
    org.apache.commons.math3.exception.util.Localizable localizable3 = null;
    java.lang.Integer[] i_array5 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array7 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException8 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array5, i_array7);
    org.apache.commons.math3.util.MathUtils.checkNotNull((java.lang.Object)0.0d, localizable3, (java.lang.Object[])i_array7);
    org.apache.commons.math3.exception.MathIllegalStateException mathIllegalStateException10 = new org.apache.commons.math3.exception.MathIllegalStateException((java.lang.Throwable)singularMatrixException0, localizable1, (java.lang.Object[])i_array7);
    org.apache.commons.math3.exception.util.Localizable localizable11 = null;
    org.apache.commons.math3.exception.util.Localizable localizable14 = null;
    java.lang.Integer[] i_array16 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array18 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException19 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array16, i_array18);
    org.apache.commons.math3.util.MathUtils.checkNotNull((java.lang.Object)0.0d, localizable14, (java.lang.Object[])i_array18);
    org.apache.commons.math3.exception.util.Localizable localizable21 = null;
    java.lang.Integer[] i_array23 = new java.lang.Integer[] { 10 };
    java.lang.Integer[] i_array25 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array27 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException28 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array25, i_array27);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException29 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(localizable21, i_array23, i_array25);
    org.apache.commons.math3.exception.util.Localizable localizable30 = null;
    java.lang.Integer[] i_array32 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array34 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException35 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array32, i_array34);
    org.apache.commons.math3.exception.NullArgumentException nullArgumentException36 = new org.apache.commons.math3.exception.NullArgumentException(localizable30, (java.lang.Object[])i_array32);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException37 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array23, i_array32);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException38 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array18, i_array32);
    java.lang.Integer[] i_array39 = multiDimensionMismatchException38.getExpectedDimensions();
    org.apache.commons.math3.exception.NotFiniteNumberException notFiniteNumberException40 = new org.apache.commons.math3.exception.NotFiniteNumberException(localizable11, (java.lang.Number)4.641588833612779d, (java.lang.Object[])i_array39);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException41 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array7, i_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array27);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array39);

  }

  @Test
  public void test433() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test433"); }


    java.text.ParsePosition parsePosition1 = null;
    // The following exception was thrown during execution in test generation
    try {
      char char2 = org.apache.commons.math3.util.CompositeFormat.parseNextCharacter("2", parsePosition1);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test434() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test434"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector2, false);
    double[] d_array6 = new double[] {  };
    double[] d_array8 = new double[] { 100.0d };
    double[] d_array12 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b13 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array8, d_array12);
    double d14 = org.apache.commons.math3.util.MathArrays.distance(d_array6, d_array12);
    double[] d_array15 = org.apache.commons.math3.util.MathArrays.copyOf(d_array6);
    double[] d_array17 = new double[] { 100.0d };
    double[] d_array21 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b22 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array17, d_array21);
    double[] d_array24 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array21, 1.3440585709080678E43d);
    boolean b25 = org.apache.commons.math3.util.MathArrays.equals(d_array6, d_array21);
    double d26 = org.apache.commons.math3.util.MathArrays.safeNorm(d_array6);
    // The following exception was thrown during execution in test generation
    try {
      arrayRealVector2.setSubVector(10, d_array6);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array24);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b25 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d26 == 0.0d);

  }

  @Test
  public void test435() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test435"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    double d14 = array2DRowRealMatrix9.getFrobeniusNorm();
    org.apache.commons.math3.linear.RealMatrix realMatrix15 = array2DRowRealMatrix9.copy();
    // The following exception was thrown during execution in test generation
    try {
      array2DRowRealMatrix9.addToEntry(9, 0, 0.7116024720019101d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d14 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix15);

  }

  @Test
  public void test436() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test436"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    double[] d_array8 = new double[] { 100.0d };
    double[] d_array12 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b13 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array8, d_array12);
    boolean b14 = org.apache.commons.math3.util.MathArrays.equals(d_array1, d_array12);
    double[] d_array16 = new double[] { 100.0d };
    double[] d_array20 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b21 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array16, d_array20);
    double[] d_array23 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array20, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector24 = new org.apache.commons.math3.linear.ArrayRealVector(d_array12, d_array20);
    org.apache.commons.math3.exception.util.Localizable localizable29 = null;
    java.lang.Integer[] i_array31 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array33 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException34 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array31, i_array33);
    org.apache.commons.math3.util.MathUtils.checkNotNull((java.lang.Object)0.0d, localizable29, (java.lang.Object[])i_array33);
    org.apache.commons.math3.exception.util.Localizable localizable36 = null;
    java.lang.Integer[] i_array38 = new java.lang.Integer[] { 10 };
    java.lang.Integer[] i_array40 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array42 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException43 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array40, i_array42);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException44 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(localizable36, i_array38, i_array40);
    org.apache.commons.math3.exception.util.Localizable localizable45 = null;
    java.lang.Integer[] i_array47 = new java.lang.Integer[] { 100 };
    java.lang.Integer[] i_array49 = new java.lang.Integer[] { 1 };
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException50 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array47, i_array49);
    org.apache.commons.math3.exception.NullArgumentException nullArgumentException51 = new org.apache.commons.math3.exception.NullArgumentException(localizable45, (java.lang.Object[])i_array47);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException52 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array38, i_array47);
    org.apache.commons.math3.exception.MultiDimensionMismatchException multiDimensionMismatchException53 = new org.apache.commons.math3.exception.MultiDimensionMismatchException(i_array33, i_array47);
    double[] d_array55 = new double[] { 100.0d };
    double[] d_array59 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b60 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array55, d_array59);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException64 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.0f, (java.lang.Number)(short)100, 10);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection65 = nonMonotonicSequenceException64.getDirection();
    boolean b67 = org.apache.commons.math3.util.MathArrays.isMonotonic(d_array55, orderDirection65, false);
    boolean b69 = org.apache.commons.math3.util.MathArrays.<java.lang.Comparable>isMonotonic((java.lang.Comparable[])i_array47, orderDirection65, true);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException71 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)5.29205908405969d, (java.lang.Number)4.2502863927404205E43d, 0, orderDirection65, false);
    boolean b73 = org.apache.commons.math3.util.MathArrays.isMonotonic(d_array12, orderDirection65, true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b21 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array31);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array40);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array47);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array59);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b60 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b67 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b69 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b73 == false);

  }

  @Test
  public void test437() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test437"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    java.lang.Double[] d_array18 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(d_array18, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector29 = arrayRealVector21.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    double d30 = arrayRealVector4.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector21);
    double[] d_array31 = arrayRealVector21.getDataRef();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d30 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array31);

  }

  @Test
  public void test438() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test438"); }


    java.lang.Number number1 = null;
    org.apache.commons.math3.exception.NumberIsTooLargeException numberIsTooLargeException3 = new org.apache.commons.math3.exception.NumberIsTooLargeException((java.lang.Number)(short)100, number1, false);
    boolean b4 = numberIsTooLargeException3.getBoundIsAllowed();
    java.lang.Number number5 = numberIsTooLargeException3.getArgument();
    java.lang.Number number6 = numberIsTooLargeException3.getMax();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b4 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + number5 + "' != '" + (short)100+ "'", number5.equals((short)100));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(number6);

  }

  @Test
  public void test439() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test439"); }


    double d2 = org.apache.commons.math3.util.FastMath.atan2(0.6363779946031d, Double.POSITIVE_INFINITY);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d2 == 0.0d);

  }

  @Test
  public void test440() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test440"); }


    java.text.NumberFormat numberFormat1 = org.apache.commons.math3.util.CompositeFormat.getDefaultNumberFormat();
    java.text.ParsePosition parsePosition2 = null;
    // The following exception was thrown during execution in test generation
    try {
      java.lang.Number number3 = org.apache.commons.math3.util.CompositeFormat.parseNumber("751e6873e8", numberFormat1, parsePosition2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat1);

  }

  @Test
  public void test441() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test441"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat0 = org.apache.commons.math3.linear.RealMatrixFormat.getInstance();
    java.text.NumberFormat numberFormat1 = realMatrixFormat0.getFormat();
    java.text.NumberFormat numberFormat2 = realMatrixFormat0.getFormat();
    java.lang.String str3 = realMatrixFormat0.getPrefix();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrixFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str3 + "' != '" + "{"+ "'", str3.equals("{"));

  }

  @Test
  public void test442() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test442"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    org.apache.commons.math3.exception.util.Localizable localizable1 = null;
    long[] long_array2 = null;
    long[][] long_array_array3 = new long[][] { long_array2 };
    org.apache.commons.math3.util.MathArrays.checkRectangular(long_array_array3);
    org.apache.commons.math3.exception.MathIllegalStateException mathIllegalStateException5 = new org.apache.commons.math3.exception.MathIllegalStateException(localizable1, (java.lang.Object[])long_array_array3);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException6 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])long_array_array3);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(long_array_array3);

  }

  @Test
  public void test443() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test443"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    boolean b7 = array2DRowFieldMatrix1.isSquare();
    int i8 = array2DRowFieldMatrix1.getRowDimension();
    org.apache.commons.math3.Field field9 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix10 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field9);
    boolean b12 = array2DRowFieldMatrix10.equals((java.lang.Object)(short)10);
    int i13 = array2DRowFieldMatrix10.getRowDimension();
    boolean b14 = array2DRowFieldMatrix10.isSquare();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix15 = array2DRowFieldMatrix1.add((org.apache.commons.math3.linear.FieldMatrix)array2DRowFieldMatrix10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i8 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b12 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i13 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b14 == true);

  }

  @Test
  public void test444() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test444"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    java.lang.Double[] d_array11 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = new org.apache.commons.math3.linear.ArrayRealVector(d_array11, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector15 = arrayRealVector9.append((org.apache.commons.math3.linear.RealVector)arrayRealVector14);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector16 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector4, arrayRealVector14);
    double[] d_array18 = new double[] { 0.0d };
    double[] d_array20 = org.apache.commons.math3.util.MathArrays.copyOf(d_array18, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector21 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector16, d_array20);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector26, false);
    int i29 = arrayRealVector28.getMaxIndex();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = arrayRealVector21.combineToSelf(0.0d, (-7.241149127564359d), (org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    java.lang.Double[] d_array32 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(d_array32, 0, 0);
    java.lang.Double[] d_array37 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector40 = new org.apache.commons.math3.linear.ArrayRealVector(d_array37, 0, 0);
    java.lang.Double[] d_array42 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector45 = new org.apache.commons.math3.linear.ArrayRealVector(d_array42, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector46 = arrayRealVector40.append((org.apache.commons.math3.linear.RealVector)arrayRealVector45);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector47 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector35, arrayRealVector45);
    java.lang.Double[] d_array49 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector52 = new org.apache.commons.math3.linear.ArrayRealVector(d_array49, 0, 0);
    java.lang.Double[] d_array56 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector59 = new org.apache.commons.math3.linear.ArrayRealVector(d_array56, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector60 = arrayRealVector52.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector59);
    double d61 = arrayRealVector35.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector52);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector62 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector30, arrayRealVector35);
    boolean b63 = arrayRealVector30.isNaN();
    // The following exception was thrown during execution in test generation
    try {
      double d65 = arrayRealVector30.getEntry(49);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i29 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector46);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector60);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d61 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b63 == false);

  }

  @Test
  public void test445() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test445"); }


    double d1 = org.apache.commons.math3.util.FastMath.signum(0.8623188722876839d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d1 == 1.0d);

  }

  @Test
  public void test446() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test446"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);

  }

  @Test
  public void test447() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test447"); }


    org.apache.commons.math3.linear.RealVectorFormat realVectorFormat0 = org.apache.commons.math3.linear.RealVectorFormat.getInstance();
    java.text.NumberFormat numberFormat1 = realVectorFormat0.getFormat();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVectorFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat1);

  }

  @Test
  public void test448() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test448"); }


    double[] d_array1 = new double[] { 100.0d };
    double[] d_array5 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b6 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array1, d_array5);
    org.apache.commons.math3.exception.NonMonotonicSequenceException nonMonotonicSequenceException10 = new org.apache.commons.math3.exception.NonMonotonicSequenceException((java.lang.Number)1.0f, (java.lang.Number)(short)100, 10);
    org.apache.commons.math3.util.MathArrays.OrderDirection orderDirection11 = nonMonotonicSequenceException10.getDirection();
    boolean b13 = org.apache.commons.math3.util.MathArrays.isMonotonic(d_array1, orderDirection11, false);
    org.apache.commons.math3.exception.util.Localizable localizable14 = null;
    double[] d_array16 = new double[] { 0.0d };
    double[] d_array18 = org.apache.commons.math3.util.MathArrays.copyOf(d_array16, 1);
    double[][] d_array_array19 = new double[][] { d_array16 };
    org.apache.commons.math3.linear.RealMatrix realMatrix20 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array19);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix21 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array19);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException22 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable14, (java.lang.Object[])d_array_array19);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix23 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array19);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition25 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix23, 1.3440585709080678E43d);
    java.lang.String str26 = array2DRowRealMatrix23.toString();
    int i27 = array2DRowRealMatrix23.getRowDimension();
    double[] d_array29 = new double[] { 100.0d };
    double[] d_array33 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b34 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array29, d_array33);
    double[] d_array36 = org.apache.commons.math3.util.MathArrays.normalizeArray(d_array33, 1.3440585709080678E43d);
    double[] d_array38 = org.apache.commons.math3.util.MathArrays.copyOf(d_array33, 1);
    double[] d_array39 = array2DRowRealMatrix23.operate(d_array38);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector40 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, d_array39);
    java.lang.Double[] d_array42 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector45 = new org.apache.commons.math3.linear.ArrayRealVector(d_array42, 0, 0);
    java.lang.Double[] d_array49 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector52 = new org.apache.commons.math3.linear.ArrayRealVector(d_array49, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = arrayRealVector45.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector52);
    org.apache.commons.math3.analysis.UnivariateFunction univariateFunction54 = null;
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector55 = arrayRealVector53.map(univariateFunction54);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector56 = arrayRealVector55.copy();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector57 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector40, arrayRealVector56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b6 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(orderDirection11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == true);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array18);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str26 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str26.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i27 == 1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array33);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b34 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array36);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array42);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector53);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector56);

  }

  @Test
  public void test449() {}
// Defects4J: flaky method
//   @Test
//   public void test449() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test449"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     randomDataImpl0.reSeedSecure();
//     randomDataImpl0.reSeed();
//     randomDataImpl0.reSeedSecure(49L);
//     double d7 = randomDataImpl0.nextF(3.141592653589793d, 1.5707963267948966d);
//     double d10 = randomDataImpl0.nextF(0.6892682844514348d, 100.0d);
//     java.lang.String str12 = randomDataImpl0.nextHexString(1);
//     // The following exception was thrown during execution in test generation
//     try {
//       double d15 = randomDataImpl0.nextBeta(0.0d, 4.9E-324d);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoBracketingException");
//     } catch (org.apache.commons.math3.exception.NoBracketingException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NoBracketingException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoBracketingException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d7 == 0.6128728646734916d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d10 == 0.08726072551455881d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str12 + "' != '" + "1"+ "'", str12.equals("1"));
// 
//   }

  @Test
  public void test450() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test450"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.DecompositionSolver decompositionSolver12 = eigenDecomposition11.getSolver();
    boolean b13 = eigenDecomposition11.hasComplexEigenvalues();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(decompositionSolver12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b13 == false);

  }

  @Test
  public void test451() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test451"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    int i5 = arrayRealVector4.getDimension();
    double[] d_array6 = arrayRealVector4.toArray();
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
    double[][] d_array_array8 = array2DRowRealMatrix7.getDataRef();
    int i9 = array2DRowRealMatrix7.getRowDimension();
    double[][] d_array_array10 = array2DRowRealMatrix7.getData();
    org.apache.commons.math3.util.MathArrays.sortInPlace(d_array6, d_array_array10);
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix13 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array10, true);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoDataException");
    } catch (org.apache.commons.math3.exception.NoDataException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NoDataException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NoDataException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i5 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(d_array_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i9 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array10);

  }

  @Test
  public void test452() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test452"); }


    org.apache.commons.math3.exception.MathUnsupportedOperationException mathUnsupportedOperationException0 = new org.apache.commons.math3.exception.MathUnsupportedOperationException();
    java.lang.Number number1 = null;
    org.apache.commons.math3.exception.util.Localizable localizable2 = null;
    org.apache.commons.math3.exception.util.Localizable localizable3 = null;
    double[] d_array6 = new double[] { 0.0d };
    double[] d_array8 = org.apache.commons.math3.util.MathArrays.copyOf(d_array6, 1);
    java.lang.Object[] obj_array9 = new java.lang.Object[] { d_array6 };
    org.apache.commons.math3.exception.MaxCountExceededException maxCountExceededException10 = new org.apache.commons.math3.exception.MaxCountExceededException(localizable3, (java.lang.Number)(byte)0, obj_array9);
    org.apache.commons.math3.exception.MathInternalError mathInternalError11 = new org.apache.commons.math3.exception.MathInternalError(localizable2, obj_array9);
    org.apache.commons.math3.exception.NotFiniteNumberException notFiniteNumberException12 = new org.apache.commons.math3.exception.NotFiniteNumberException(number1, obj_array9);
    mathUnsupportedOperationException0.addSuppressed((java.lang.Throwable)notFiniteNumberException12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(obj_array9);

  }

  @Test
  public void test453() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test453"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat0 = org.apache.commons.math3.linear.RealMatrixFormat.getInstance();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.RealMatrix realMatrix2 = realMatrixFormat0.parse("}");
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathParseException");
    } catch (org.apache.commons.math3.exception.MathParseException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.MathParseException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.MathParseException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrixFormat0);

  }

  @Test
  public void test454() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test454"); }


    org.apache.commons.math3.linear.OpenMapRealMatrix openMapRealMatrix2 = new org.apache.commons.math3.linear.OpenMapRealMatrix(9, 100);
    // The following exception was thrown during execution in test generation
    try {
      openMapRealMatrix2.multiplyEntry(0, 266627117, 35.50998058787508d);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test455() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test455"); }


    int i1 = org.apache.commons.math3.util.FastMath.getExponent(0.99999994f);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i1 == (-1));

  }

  @Test
  public void test456() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test456"); }


    org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException nonPositiveDefiniteMatrixException3 = new org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException(3.4719061895220023d, 0, 7.703719777548943E-34d);
    org.apache.commons.math3.exception.NumberIsTooSmallException numberIsTooSmallException7 = new org.apache.commons.math3.exception.NumberIsTooSmallException((java.lang.Number)(byte)0, (java.lang.Number)100.0d, false);
    nonPositiveDefiniteMatrixException3.addSuppressed((java.lang.Throwable)numberIsTooSmallException7);
    int i9 = nonPositiveDefiniteMatrixException3.getRow();
    double d10 = nonPositiveDefiniteMatrixException3.getThreshold();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i9 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d10 == 7.703719777548943E-34d);

  }

  @Test
  public void test457() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test457"); }


    org.apache.commons.math3.exception.DimensionMismatchException dimensionMismatchException2 = new org.apache.commons.math3.exception.DimensionMismatchException(43, 266627117);

  }

  @Test
  public void test458() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test458"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector51 = new org.apache.commons.math3.linear.ArrayRealVector(d_array48, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector52 = arrayRealVector46.append((org.apache.commons.math3.linear.RealVector)arrayRealVector51);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector53 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector41, arrayRealVector51);
    java.lang.Double[] d_array55 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector58 = new org.apache.commons.math3.linear.ArrayRealVector(d_array55, 0, 0);
    java.lang.Double[] d_array62 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector65 = new org.apache.commons.math3.linear.ArrayRealVector(d_array62, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = arrayRealVector58.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector65);
    double d67 = arrayRealVector41.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    double d68 = arrayRealVector36.getL1Distance((org.apache.commons.math3.linear.RealVector)arrayRealVector58);
    java.lang.Double[] d_array70 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector73 = new org.apache.commons.math3.linear.ArrayRealVector(d_array70, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector79 = arrayRealVector73.append((org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    org.apache.commons.math3.linear.RealVector realVector80 = arrayRealVector36.append(realVector79);
    double[] d_array82 = new double[] { 0.0d };
    double[] d_array84 = org.apache.commons.math3.util.MathArrays.copyOf(d_array82, 1);
    double[][] d_array_array85 = new double[][] { d_array82 };
    org.apache.commons.math3.linear.RealMatrix realMatrix86 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix87 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array85);
    boolean b88 = arrayRealVector36.equals((java.lang.Object)d_array_array85);
    org.apache.commons.math3.linear.BlockRealMatrix blockRealMatrix89 = new org.apache.commons.math3.linear.BlockRealMatrix(d_array_array85);
    org.apache.commons.math3.linear.RealMatrix realMatrix91 = blockRealMatrix89.scalarMultiply(0.0d);
    org.apache.commons.math3.linear.RealMatrix realMatrix93 = blockRealMatrix89.scalarMultiply(0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector29);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array32);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array38);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array43);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array48);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector52);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array55);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array62);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector66);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d67 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d68 == 0.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array70);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector80);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array82);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array84);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array85);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix86);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b88 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix91);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix93);

  }

  @Test
  public void test459() {}
// Defects4J: flaky method
//   @Test
//   public void test459() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test459"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl0 = new org.apache.commons.math3.random.RandomDataImpl();
//     randomDataImpl0.reSeedSecure();
//     randomDataImpl0.reSeed();
//     randomDataImpl0.reSeedSecure(49L);
//     double d7 = randomDataImpl0.nextF(3.141592653589793d, 1.5707963267948966d);
//     // The following exception was thrown during execution in test generation
//     try {
//       int i10 = randomDataImpl0.nextInt(156287497, 52);
//       org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException");
//     } catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NumberIsTooLargeException")) {
//         org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NumberIsTooLargeException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d7 == 0.9991795311415583d);
// 
//   }

  @Test
  public void test460() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test460"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array6 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector9 = new org.apache.commons.math3.linear.ArrayRealVector(d_array6, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector10 = arrayRealVector4.append((org.apache.commons.math3.linear.RealVector)arrayRealVector9);
    double[] d_array12 = new double[] { 100.0d };
    double[] d_array16 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b17 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array12, d_array16);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector4, d_array12);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    java.lang.Double[] d_array30 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector33 = new org.apache.commons.math3.linear.ArrayRealVector(d_array30, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector34 = arrayRealVector28.append((org.apache.commons.math3.linear.RealVector)arrayRealVector33);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector23, arrayRealVector33);
    double[] d_array37 = new double[] { 0.0d };
    double[] d_array39 = org.apache.commons.math3.util.MathArrays.copyOf(d_array37, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector40 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector35, d_array39);
    java.lang.Double[] d_array44 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector45 = new org.apache.commons.math3.linear.ArrayRealVector(d_array44);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector47 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector45, false);
    int i48 = arrayRealVector47.getMaxIndex();
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector49 = arrayRealVector40.combineToSelf(0.0d, (-7.241149127564359d), (org.apache.commons.math3.linear.RealVector)arrayRealVector47);
    java.lang.Double[] d_array51 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector54 = new org.apache.commons.math3.linear.ArrayRealVector(d_array51, 0, 0);
    java.lang.Double[] d_array56 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector59 = new org.apache.commons.math3.linear.ArrayRealVector(d_array56, 0, 0);
    java.lang.Double[] d_array61 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector64 = new org.apache.commons.math3.linear.ArrayRealVector(d_array61, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector65 = arrayRealVector59.append((org.apache.commons.math3.linear.RealVector)arrayRealVector64);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector66 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector54, arrayRealVector64);
    java.lang.Double[] d_array68 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector71 = new org.apache.commons.math3.linear.ArrayRealVector(d_array68, 0, 0);
    java.lang.Double[] d_array75 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector78 = new org.apache.commons.math3.linear.ArrayRealVector(d_array75, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector79 = arrayRealVector71.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector78);
    double d80 = arrayRealVector54.getLInfDistance((org.apache.commons.math3.linear.RealVector)arrayRealVector71);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector81 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector49, arrayRealVector54);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector82 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector18, arrayRealVector54);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array12);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b17 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array30);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector34);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array37);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array39);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array44);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i48 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector49);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array51);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array56);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array61);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector65);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array68);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array75);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(arrayRealVector79);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d80 == 0.0d);

  }

  @Test
  public void test461() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test461"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    int i4 = array2DRowFieldMatrix1.getRowDimension();
    java.lang.String str5 = array2DRowFieldMatrix1.toString();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i4 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str5 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str5.equals("Array2DRowFieldMatrix{}"));

  }

  @Test
  public void test462() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test462"); }


    org.apache.commons.math3.Field field0 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix3 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0, 0, 9);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test463() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test463"); }


    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix2 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(0, 1);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test464() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test464"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    org.apache.commons.math3.Field field2 = array2DRowFieldMatrix1.getField();
    org.apache.commons.math3.FieldElement fieldElement3 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.FieldMatrix fieldMatrix4 = array2DRowFieldMatrix1.scalarMultiply(fieldElement3);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException");
    } catch (org.apache.commons.math3.exception.NotStrictlyPositiveException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.NotStrictlyPositiveException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.NotStrictlyPositiveException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field2);

  }

  @Test
  public void test465() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test465"); }


    org.apache.commons.math3.random.Well19937c well19937c1 = new org.apache.commons.math3.random.Well19937c((-1551720450747048068L));

  }

  @Test
  public void test466() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test466"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    org.apache.commons.math3.linear.RealMatrix realMatrix13 = array2DRowRealMatrix9.scalarAdd(0.3932953321069236d);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition15 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 4.9E-324d);
    org.apache.commons.math3.linear.RealMatrix realMatrix16 = eigenDecomposition15.getV();
    double[] d_array17 = eigenDecomposition15.getImagEigenvalues();
    double d18 = eigenDecomposition15.getDeterminant();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix16);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d18 == 0.0d);

  }

  @Test
  public void test467() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test467"); }


    java.io.ObjectInputStream objectInputStream2 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.deserializeRealMatrix((java.lang.Object)35.65493130931986d, "ad54decbcf", objectInputStream2);
      org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
    } catch (java.lang.NullPointerException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
      }
    }

  }

  @Test
  public void test468() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test468"); }


    org.apache.commons.math3.linear.RealVectorFormat realVectorFormat0 = org.apache.commons.math3.linear.RealVectorFormat.getInstance();
    java.lang.String str1 = realVectorFormat0.getSuffix();
    java.lang.String str2 = realVectorFormat0.getSuffix();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVectorFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str1 + "' != '" + "}"+ "'", str1.equals("}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str2 + "' != '" + "}"+ "'", str2.equals("}"));

  }

  @Test
  public void test469() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test469"); }


    org.apache.commons.math3.distribution.NormalDistribution normalDistribution2 = new org.apache.commons.math3.distribution.NormalDistribution((-1.0d), 100.0d);
    double d3 = normalDistribution2.getNumericalVariance();
    double d4 = normalDistribution2.getStandardDeviation();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d3 == 10000.0d);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(d4 == 100.0d);

  }

  @Test
  public void test470() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test470"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    java.lang.String str6 = array2DRowFieldMatrix1.toString();
    boolean b7 = array2DRowFieldMatrix1.isSquare();
    org.apache.commons.math3.linear.FieldMatrixPreservingVisitor fieldMatrixPreservingVisitor8 = null;
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.FieldElement fieldElement13 = array2DRowFieldMatrix1.walkInOptimizedOrder(fieldMatrixPreservingVisitor8, 266627117, 49, 156287497, 0);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str6 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str6.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b7 == true);

  }

  @Test
  public void test471() {}
// Defects4J: flaky method
//   @Test
//   public void test471() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test471"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
//     long long3 = randomDataGenerator0.nextLong((-1L), 0L);
//     double d5 = randomDataGenerator0.nextExponential(1.2104058782952831d);
//     java.lang.String str7 = randomDataGenerator0.nextSecureHexString(10);
//     randomDataGenerator0.reSeedSecure((-2940070379293551584L));
//     java.util.Collection collection10 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       java.lang.Object[] obj_array12 = randomDataGenerator0.nextSample(collection10, 156287497);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long3 == 0L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d5 == 1.178531033836856d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str7 + "' != '" + "0466c6c230"+ "'", str7.equals("0466c6c230"));
// 
//   }

  @Test
  public void test472() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test472"); }


    java.lang.Object[] obj_array1 = null;
    org.apache.commons.math3.exception.NotFiniteNumberException notFiniteNumberException2 = new org.apache.commons.math3.exception.NotFiniteNumberException((java.lang.Number)(short)100, obj_array1);

  }

  @Test
  public void test473() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test473"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    double[] d_array2 = new double[] { 0.0d };
    double[] d_array4 = org.apache.commons.math3.util.MathArrays.copyOf(d_array2, 1);
    double[][] d_array_array5 = new double[][] { d_array2 };
    org.apache.commons.math3.linear.RealMatrix realMatrix6 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix7 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException8 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable0, (java.lang.Object[])d_array_array5);
    org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix9 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array5);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition11 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix9, 1.3440585709080678E43d);
    java.lang.String str12 = array2DRowRealMatrix9.toString();
    int i13 = array2DRowRealMatrix9.getRowDimension();
    // The following exception was thrown during execution in test generation
    try {
      org.apache.commons.math3.linear.MatrixUtils.checkColumnIndex((org.apache.commons.math3.linear.AnyMatrix)array2DRowRealMatrix9, 10);
      org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException");
    } catch (org.apache.commons.math3.exception.OutOfRangeException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("org.apache.commons.math3.exception.OutOfRangeException")) {
        org.junit.Assert.fail("Expected exception of type org.apache.commons.math3.exception.OutOfRangeException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrix6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str12 + "' != '" + "Array2DRowRealMatrix{{0.0}}"+ "'", str12.equals("Array2DRowRealMatrix{{0.0}}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i13 == 1);

  }

  @Test
  public void test474() {}
// Defects4J: flaky method
//   @Test
//   public void test474() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test474"); }
// 
// 
//     java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
//     org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
//     java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
//     org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
//     org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
//     org.apache.commons.math3.analysis.UnivariateFunction univariateFunction13 = null;
//     org.apache.commons.math3.linear.ArrayRealVector arrayRealVector14 = arrayRealVector12.map(univariateFunction13);
//     java.lang.Double[] d_array16 = new java.lang.Double[] { 3.1622776601683795d };
//     org.apache.commons.math3.linear.ArrayRealVector arrayRealVector19 = new org.apache.commons.math3.linear.ArrayRealVector(d_array16, 0, 0);
//     java.lang.Double[] d_array23 = new java.lang.Double[] { 3.1622776601683795d };
//     org.apache.commons.math3.linear.ArrayRealVector arrayRealVector26 = new org.apache.commons.math3.linear.ArrayRealVector(d_array23, 0, 0);
//     org.apache.commons.math3.linear.ArrayRealVector arrayRealVector27 = arrayRealVector19.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector26);
//     org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = arrayRealVector27.copy();
//     org.apache.commons.math3.linear.RealVector realVector30 = arrayRealVector27.mapDivide(49.41408584662507d);
//     org.apache.commons.math3.linear.ArrayRealVector arrayRealVector31 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector14, arrayRealVector27);
//     double[] d_array33 = new double[] { 0.0d };
//     double[] d_array35 = org.apache.commons.math3.util.MathArrays.copyOf(d_array33, 1);
//     double[][] d_array_array36 = new double[][] { d_array33 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix37 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array36);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix38 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array36);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix40 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array36, false);
//     org.apache.commons.math3.exception.util.Localizable localizable41 = null;
//     double[] d_array43 = new double[] { 0.0d };
//     double[] d_array45 = org.apache.commons.math3.util.MathArrays.copyOf(d_array43, 1);
//     double[][] d_array_array46 = new double[][] { d_array43 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix47 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array46);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix48 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array46);
//     org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException49 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable41, (java.lang.Object[])d_array_array46);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix50 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array46);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition52 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix50, 1.3440585709080678E43d);
//     org.apache.commons.math3.linear.RealMatrix realMatrix54 = array2DRowRealMatrix50.scalarAdd(0.3932953321069236d);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition56 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix50, 4.9E-324d);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix57 = array2DRowRealMatrix40.subtract(array2DRowRealMatrix50);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix58 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
//     double[][] d_array_array59 = array2DRowRealMatrix58.getDataRef();
//     boolean b60 = array2DRowRealMatrix58.isSquare();
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl61 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d64 = randomDataImpl61.nextUniform((-1.0d), 100.0d);
//     int[] i_array67 = randomDataImpl61.nextPermutation(10, 1);
//     int i70 = randomDataImpl61.nextZipf(52, 4.641588833612779d);
//     boolean b71 = array2DRowRealMatrix58.equals((java.lang.Object)randomDataImpl61);
//     boolean b72 = array2DRowRealMatrix40.equals((java.lang.Object)array2DRowRealMatrix58);
//     org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor defaultRealMatrixPreservingVisitor73 = new org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor();
//     double d74 = array2DRowRealMatrix40.walkInColumnOrder((org.apache.commons.math3.linear.RealMatrixPreservingVisitor)defaultRealMatrixPreservingVisitor73);
//     double[] d_array76 = new double[] { 0.0d };
//     double[] d_array78 = org.apache.commons.math3.util.MathArrays.copyOf(d_array76, 1);
//     double[] d_array80 = new double[] { 100.0d };
//     double[] d_array84 = new double[] { 0.0d, (-1.0d), 100.0d };
//     boolean b85 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array80, d_array84);
//     boolean b86 = org.apache.commons.math3.util.MathArrays.equals(d_array76, d_array80);
//     org.apache.commons.math3.linear.ArrayRealVector arrayRealVector87 = new org.apache.commons.math3.linear.ArrayRealVector(d_array76);
//     double[] d_array88 = array2DRowRealMatrix40.operate(d_array76);
//     org.apache.commons.math3.linear.ArrayRealVector arrayRealVector89 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector31, d_array76);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array8);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(arrayRealVector12);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(arrayRealVector14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array16);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array23);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(arrayRealVector27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(arrayRealVector28);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realVector30);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array33);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array36);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix37);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array43);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array45);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array46);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix47);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix54);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(array2DRowRealMatrix57);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(d_array_array59);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b60 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d64 == 59.2774651278638d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array67);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i70 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b71 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b72 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d74 == 0.0d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array76);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array78);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array80);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array84);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b85 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b86 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array88);
// 
//   }

  @Test
  public void test475() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test475"); }


    long[] long_array1 = new long[] { 10L };
    org.apache.commons.math3.util.MathArrays.checkNonNegative(long_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(long_array1);

  }

  @Test
  public void test476() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test476"); }


    org.apache.commons.math3.exception.util.Localizable localizable0 = null;
    java.lang.Double[] d_array2 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector5 = new org.apache.commons.math3.linear.ArrayRealVector(d_array2, 0, 0);
    org.apache.commons.math3.exception.MathIllegalStateException mathIllegalStateException6 = new org.apache.commons.math3.exception.MathIllegalStateException(localizable0, (java.lang.Object[])d_array2);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector7 = new org.apache.commons.math3.linear.ArrayRealVector(d_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array2);

  }

  @Test
  public void test477() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test477"); }


    org.apache.commons.math3.Field field0 = null;
    org.apache.commons.math3.linear.Array2DRowFieldMatrix array2DRowFieldMatrix1 = new org.apache.commons.math3.linear.Array2DRowFieldMatrix(field0);
    boolean b3 = array2DRowFieldMatrix1.equals((java.lang.Object)(short)10);
    boolean b5 = array2DRowFieldMatrix1.equals((java.lang.Object)4.2502863927404205E43d);
    org.apache.commons.math3.Field field6 = array2DRowFieldMatrix1.getField();
    java.lang.String str7 = array2DRowFieldMatrix1.toString();
    org.apache.commons.math3.Field field8 = array2DRowFieldMatrix1.getField();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b3 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b5 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str7 + "' != '" + "Array2DRowFieldMatrix{}"+ "'", str7.equals("Array2DRowFieldMatrix{}"));
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNull(field8);

  }

  @Test
  public void test478() {}
// Defects4J: flaky method
//   @Test
//   public void test478() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test478"); }
// 
// 
//     org.apache.commons.math3.random.RandomDataGenerator randomDataGenerator0 = new org.apache.commons.math3.random.RandomDataGenerator();
//     long long3 = randomDataGenerator0.nextLong((-1L), 0L);
//     double d5 = randomDataGenerator0.nextExponential(1.2104058782952831d);
//     java.lang.String str7 = randomDataGenerator0.nextSecureHexString(10);
//     double d10 = randomDataGenerator0.nextWeibull(3.3519519824856493E153d, 0.5751868171778031d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(long3 == 0L);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d5 == 5.026622085482455d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue("'" + str7 + "' != '" + "1dd3e8449b"+ "'", str7.equals("1dd3e8449b"));
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d10 == 0.5751868171778031d);
// 
//   }

  @Test
  public void test479() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test479"); }


    int[] i_array2 = new int[] { 0, 10 };
    int[] i_array4 = org.apache.commons.math3.util.MathArrays.copyOf(i_array2, 10);
    int[] i_array5 = org.apache.commons.math3.util.MathArrays.copyOf(i_array4);
    int[] i_array8 = new int[] { 0, 10 };
    int[] i_array10 = org.apache.commons.math3.util.MathArrays.copyOf(i_array8, 10);
    int[] i_array11 = org.apache.commons.math3.util.MathArrays.copyOf(i_array10);
    int i12 = org.apache.commons.math3.util.MathArrays.distanceInf(i_array4, i_array11);
    int[] i_array14 = org.apache.commons.math3.util.MathArrays.copyOf(i_array11, 52);
    int[] i_array17 = new int[] { 0, 10 };
    int[] i_array19 = org.apache.commons.math3.util.MathArrays.copyOf(i_array17, 10);
    int[] i_array20 = org.apache.commons.math3.util.MathArrays.copyOf(i_array19);
    int[] i_array23 = new int[] { 0, 10 };
    int[] i_array25 = org.apache.commons.math3.util.MathArrays.copyOf(i_array23, 10);
    int[] i_array26 = org.apache.commons.math3.util.MathArrays.copyOf(i_array25);
    int i27 = org.apache.commons.math3.util.MathArrays.distanceInf(i_array19, i_array26);
    // The following exception was thrown during execution in test generation
    try {
      double d28 = org.apache.commons.math3.util.MathArrays.distance(i_array14, i_array26);
      org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException");
    } catch (java.lang.ArrayIndexOutOfBoundsException e) {
      // Expected exception.
      if (! e.getClass().getCanonicalName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
        org.junit.Assert.fail("Expected exception of type java.lang.ArrayIndexOutOfBoundsException, got " + e.getClass().getCanonicalName());
      }
    }
    
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array2);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array4);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array5);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array8);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array10);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i12 == 0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array14);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array19);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array20);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array23);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array25);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(i_array26);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i27 == 0);

  }

  @Test
  public void test480() {}
// Defects4J: flaky method
//   @Test
//   public void test480() throws Throwable {
// 
//     if (debug) { System.out.format("%n%s%n","RegressionTest1.test480"); }
// 
// 
//     double[] d_array1 = new double[] { 0.0d };
//     double[] d_array3 = org.apache.commons.math3.util.MathArrays.copyOf(d_array1, 1);
//     double[][] d_array_array4 = new double[][] { d_array1 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix5 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix6 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix8 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array4, false);
//     org.apache.commons.math3.exception.util.Localizable localizable9 = null;
//     double[] d_array11 = new double[] { 0.0d };
//     double[] d_array13 = org.apache.commons.math3.util.MathArrays.copyOf(d_array11, 1);
//     double[][] d_array_array14 = new double[][] { d_array11 };
//     org.apache.commons.math3.linear.RealMatrix realMatrix15 = org.apache.commons.math3.linear.MatrixUtils.createRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix16 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.exception.MathIllegalArgumentException mathIllegalArgumentException17 = new org.apache.commons.math3.exception.MathIllegalArgumentException(localizable9, (java.lang.Object[])d_array_array14);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix18 = new org.apache.commons.math3.linear.Array2DRowRealMatrix(d_array_array14);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition20 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 1.3440585709080678E43d);
//     org.apache.commons.math3.linear.RealMatrix realMatrix22 = array2DRowRealMatrix18.scalarAdd(0.3932953321069236d);
//     org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition24 = new org.apache.commons.math3.linear.EigenDecomposition((org.apache.commons.math3.linear.RealMatrix)array2DRowRealMatrix18, 4.9E-324d);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix25 = array2DRowRealMatrix8.subtract(array2DRowRealMatrix18);
//     org.apache.commons.math3.linear.Array2DRowRealMatrix array2DRowRealMatrix26 = new org.apache.commons.math3.linear.Array2DRowRealMatrix();
//     double[][] d_array_array27 = array2DRowRealMatrix26.getDataRef();
//     boolean b28 = array2DRowRealMatrix26.isSquare();
//     org.apache.commons.math3.random.RandomDataImpl randomDataImpl29 = new org.apache.commons.math3.random.RandomDataImpl();
//     double d32 = randomDataImpl29.nextUniform((-1.0d), 100.0d);
//     int[] i_array35 = randomDataImpl29.nextPermutation(10, 1);
//     int i38 = randomDataImpl29.nextZipf(52, 4.641588833612779d);
//     boolean b39 = array2DRowRealMatrix26.equals((java.lang.Object)randomDataImpl29);
//     boolean b40 = array2DRowRealMatrix8.equals((java.lang.Object)array2DRowRealMatrix26);
//     org.apache.commons.math3.linear.RealMatrixChangingVisitor realMatrixChangingVisitor41 = null;
//     // The following exception was thrown during execution in test generation
//     try {
//       double d42 = array2DRowRealMatrix8.walkInColumnOrder(realMatrixChangingVisitor41);
//       org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException");
//     } catch (java.lang.NullPointerException e) {
//       // Expected exception.
//       if (! e.getClass().getCanonicalName().equals("java.lang.NullPointerException")) {
//         org.junit.Assert.fail("Expected exception of type java.lang.NullPointerException, got " + e.getClass().getCanonicalName());
//       }
//     }
//     
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array3);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array4);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix5);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array11);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array13);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(d_array_array14);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix15);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(realMatrix22);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(array2DRowRealMatrix25);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNull(d_array_array27);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b28 == true);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(d32 == 59.62875723422739d);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertNotNull(i_array35);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(i38 == 1);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b39 == false);
//     
//     // Regression assertion (captures the current behavior of the code)
//     org.junit.Assert.assertTrue(b40 == false);
// 
//   }

  @Test
  public void test481() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test481"); }


    org.apache.commons.math3.linear.RealMatrixFormat realMatrixFormat0 = org.apache.commons.math3.linear.RealMatrixFormat.getInstance();
    java.text.NumberFormat numberFormat1 = realMatrixFormat0.getFormat();
    java.lang.String str2 = realMatrixFormat0.getRowSuffix();
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realMatrixFormat0);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(numberFormat1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue("'" + str2 + "' != '" + "}"+ "'", str2.equals("}"));

  }

  @Test
  public void test482() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test482"); }


    org.apache.commons.math3.exception.NumberIsTooSmallException numberIsTooSmallException3 = new org.apache.commons.math3.exception.NumberIsTooSmallException((java.lang.Number)4.2502863927404205E43d, (java.lang.Number)100L, true);

  }

  @Test
  public void test483() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test483"); }


    int i2 = org.apache.commons.math3.util.FastMath.min((-1), 266627117);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(i2 == (-1));

  }

  @Test
  public void test484() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test484"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 10.0d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector2 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector2, false);
    org.apache.commons.math3.linear.RealVector realVector6 = arrayRealVector4.mapSubtract(10.04987562112089d);
    double[] d_array7 = arrayRealVector4.getDataRef();
    double[] d_array9 = new double[] { 0.0d };
    double[] d_array11 = org.apache.commons.math3.util.MathArrays.copyOf(d_array9, 1);
    double[] d_array13 = new double[] { 0.0d };
    double[] d_array15 = org.apache.commons.math3.util.MathArrays.copyOf(d_array13, 1);
    double[] d_array17 = new double[] { 100.0d };
    double[] d_array21 = new double[] { 0.0d, (-1.0d), 100.0d };
    boolean b22 = org.apache.commons.math3.util.MathArrays.equalsIncludingNaN(d_array17, d_array21);
    boolean b23 = org.apache.commons.math3.util.MathArrays.equals(d_array13, d_array17);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector25 = new org.apache.commons.math3.linear.ArrayRealVector(d_array13, false);
    org.apache.commons.math3.linear.EigenDecomposition eigenDecomposition27 = new org.apache.commons.math3.linear.EigenDecomposition(d_array9, d_array13, 14.013348232392797d);
    double[] d_array28 = org.apache.commons.math3.util.MathArrays.ebeMultiply(d_array7, d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array1);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(realVector6);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array7);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array9);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array11);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array13);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array15);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array17);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array21);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b22 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertTrue(b23 == false);
    
    // Regression assertion (captures the current behavior of the code)
    org.junit.Assert.assertNotNull(d_array28);

  }

  @Test
  public void test485() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test485"); }


    org.apache.commons.math3.linear.NonSquareMatrixException nonSquareMatrixException2 = new org.apache.commons.math3.linear.NonSquareMatrixException(1, 69);

  }

  @Test
  public void test486() throws Throwable {

    if (debug) { System.out.format("%n%s%n","RegressionTest1.test486"); }


    java.lang.Double[] d_array1 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector4 = new org.apache.commons.math3.linear.ArrayRealVector(d_array1, 0, 0);
    java.lang.Double[] d_array8 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector11 = new org.apache.commons.math3.linear.ArrayRealVector(d_array8, 0, 0);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector12 = arrayRealVector4.combineToSelf(0.0d, 10.04987562112089d, (org.apache.commons.math3.linear.RealVector)arrayRealVector11);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector13 = arrayRealVector12.copy();
    java.lang.Double[] d_array15 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector18 = new org.apache.commons.math3.linear.ArrayRealVector(d_array15, 0, 0);
    java.lang.Double[] d_array20 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector23 = new org.apache.commons.math3.linear.ArrayRealVector(d_array20, 0, 0);
    java.lang.Double[] d_array25 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector28 = new org.apache.commons.math3.linear.ArrayRealVector(d_array25, 0, 0);
    org.apache.commons.math3.linear.RealVector realVector29 = arrayRealVector23.append((org.apache.commons.math3.linear.RealVector)arrayRealVector28);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector30 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector18, arrayRealVector28);
    double[] d_array32 = new double[] { 0.0d };
    double[] d_array34 = org.apache.commons.math3.util.MathArrays.copyOf(d_array32, 1);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector35 = new org.apache.commons.math3.linear.ArrayRealVector(arrayRealVector30, d_array34);
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector36 = new org.apache.commons.math3.linear.ArrayRealVector((org.apache.commons.math3.linear.RealVector)arrayRealVector13, arrayRealVector30);
    java.lang.Double[] d_array38 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector41 = new org.apache.commons.math3.linear.ArrayRealVector(d_array38, 0, 0);
    java.lang.Double[] d_array43 = new java.lang.Double[] { 3.1622776601683795d };
    org.apache.commons.math3.linear.ArrayRealVector arrayRealVector46 = new org.apache.commons.math3.linear.ArrayRealVector(d_array43, 0, 0);
    java.lang.Double[] d_array48 = new java.lang.Double[] { 3.16227766