/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.ambiguity;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.evosuite.Properties;
import org.evosuite.coverage.ambiguity.AmbiguityCoverageFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAmbiguityFitness {
    private static String MATRIX_CONTENT = "1 0 0 1 +\n0 1 1 0 -\n0 0 1 0 +\n";

    @BeforeClass
    public static void prepare() throws IOException {
        Properties.REPORT_DIR = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString() + File.separator + Properties.REPORT_DIR;
        Properties.TARGET_CLASS = "tmpClass";
        String path = Properties.REPORT_DIR + File.separator + "data";
        File tmp = new File(path);
        tmp.mkdirs();
        File matrix = new File(path + File.separator + Properties.TARGET_CLASS + ".matrix");
        matrix.createNewFile();
        FileWriter fw = new FileWriter(matrix.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(MATRIX_CONTENT);
        bw.close();
    }

    @Before
    public void reset() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = AmbiguityCoverageFactory.class.getDeclaredField("transposedMatrix");
        field.setAccessible(true);
        field.set(null, new ArrayList());
    }

    @Test
    public void testTransposedMatrix() {
        AmbiguityCoverageFactory.loadCoverage();
        List transposedMatrix = AmbiguityCoverageFactory.getTransposedMatrix();
        Assert.assertEquals((long)transposedMatrix.size(), (long)4L);
        Assert.assertEquals((Object)((StringBuilder)transposedMatrix.get(0)).toString(), (Object)"100");
        Assert.assertEquals((Object)((StringBuilder)transposedMatrix.get(1)).toString(), (Object)"010");
        Assert.assertEquals((Object)((StringBuilder)transposedMatrix.get(2)).toString(), (Object)"011");
        Assert.assertEquals((Object)((StringBuilder)transposedMatrix.get(3)).toString(), (Object)"100");
    }

    @Test
    public void testTransposedMatrixWithoutPreviousCoverage() {
        Properties.TARGET_CLASS = "no_class";
        AmbiguityCoverageFactory.loadCoverage();
        List transposedMatrix = AmbiguityCoverageFactory.getTransposedMatrix();
        Assert.assertEquals((long)transposedMatrix.size(), (long)0L);
    }

    @Test
    public void testAmbiguity() {
        AmbiguityCoverageFactory.loadCoverage();
        List matrix = AmbiguityCoverageFactory.getTransposedMatrix();
        Assert.assertEquals((long)matrix.size(), (long)4L);
        Assert.assertEquals((double)AmbiguityCoverageFactory.getAmbiguity((List)matrix), (double)0.25, (double)0.0);
    }

    @Test
    public void testGetFitnessUsingPreviousCoverage() {
    }

    @Test
    public void testGetFitnessWithoutUsingPreviousCoverage() {
    }
}

