/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.rho;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.UUID;
import org.evosuite.Properties;
import org.evosuite.coverage.rho.RhoCoverageFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRhoFitness {
    private static int NUMBER_OF_ONES = 5;
    private static int NUMBER_OF_TEST_CASES = 3;
    private static String MATRIX_CONTENT = "1 0 0 1 +\n0 1 1 0 -\n0 0 1 0 +\n";

    @BeforeClass
    public static void prepare() throws IOException {
        Properties.REPORT_DIR = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString() + File.separator + Properties.REPORT_DIR;
        Properties.TARGET_CLASS = "tmpClass";
        String path = Properties.REPORT_DIR + File.separator + "data";
        File tmp = new File(path);
        tmp.mkdirs();
        File matrix = new File(path + File.separator + Properties.TARGET_CLASS + ".matrix");
        matrix.createNewFile();
        FileWriter fw = new FileWriter(matrix.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(MATRIX_CONTENT);
        bw.close();
    }

    @Before
    public void reset() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = RhoCoverageFactory.class.getDeclaredField("number_of_ones");
        field.setAccessible(true);
        field.set(null, 0);
        field = RhoCoverageFactory.class.getDeclaredField("number_of_test_cases");
        field.setAccessible(true);
        field.set(null, 0);
    }

    @Test
    public void testLoadCoverageMatrix() {
        RhoCoverageFactory.loadCoverage();
        Assert.assertEquals((long)RhoCoverageFactory.getNumberOnes(), (long)NUMBER_OF_ONES);
        Assert.assertEquals((long)RhoCoverageFactory.getNumberTestCases(), (long)NUMBER_OF_TEST_CASES);
    }

    @Test
    public void testLoadCoverageMatrixWithoutPreviousCoverage() {
        Properties.TARGET_CLASS = "no_class";
        RhoCoverageFactory.loadCoverage();
        Assert.assertEquals((long)RhoCoverageFactory.getNumberOnes(), (long)0L);
        Assert.assertEquals((long)RhoCoverageFactory.getNumberTestCases(), (long)0L);
    }

    @Test
    public void testGetFitnessUsingPreviousCoverage() {
    }

    @Test
    public void testGetFitnessWithoutUsingPreviousCoverage() {
    }
}

