/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.evosuite.instrumentation.ErrorConditionChecker;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestDoubleOverflow {
    private double x;
    private double y;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[] values = new Object[]{-1.7976931348623157E308, -0.0, 0.0, 8.988465674311579E307, Double.MAX_VALUE};
        ArrayList<Object[]> valuePairs = new ArrayList<Object[]>();
        for (Object val1 : values) {
            for (Object val2 : values) {
                valuePairs.add(new Object[]{val1, val2});
            }
        }
        return valuePairs;
    }

    public TestDoubleOverflow(double x, double y) {
        this.x = x;
        this.y = y;
    }

    private void assertOverflow(BigDecimal preciseResult, int distance, double doubleResult) {
        BigDecimal maxResult = new BigDecimal(Double.MAX_VALUE);
        if (preciseResult.compareTo(maxResult) > 0) {
            Assert.assertTrue((String)("Expected negative value for " + this.x + " and " + this.y + ": " + distance), (distance <= 0 ? 1 : 0) != 0);
            Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)doubleResult, (double)0.0);
        } else {
            Assert.assertTrue((String)("Expected positive value for " + this.x + " and " + this.y + ": " + distance), (distance > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAddOverflow() {
        int result = ErrorConditionChecker.overflowDistance((double)this.x, (double)this.y, (int)99);
        this.assertOverflow(new BigDecimal(this.x).add(new BigDecimal(this.y)), result, this.x + this.y);
    }

    @Test
    public void testSubOverflow() {
        int result = ErrorConditionChecker.overflowDistance((double)this.x, (double)this.y, (int)103);
        this.assertOverflow(new BigDecimal(this.x).subtract(new BigDecimal(this.y)), result, this.x - this.y);
    }

    @Test
    public void testMulOverflow() {
        int result = ErrorConditionChecker.overflowDistance((double)this.x, (double)this.y, (int)107);
        this.assertOverflow(new BigDecimal(this.x).multiply(new BigDecimal(this.y)), result, this.x * this.y);
    }

    @Test
    public void testDivOverflow() {
        Assume.assumeTrue((this.y != 0.0 ? 1 : 0) != 0);
        int result = ErrorConditionChecker.overflowDistance((double)this.x, (double)this.y, (int)111);
        this.assertOverflow(new BigDecimal(this.x).divide(new BigDecimal(this.y)), result, this.x / this.y);
    }
}

