/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.util.ArrayList;
import java.util.Collection;
import org.evosuite.instrumentation.ErrorConditionChecker;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestIntOverflow {
    private int x;
    private int y;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[] values = new Object[]{Integer.MIN_VALUE, -1073741824, 0, 0x3FFFFFFF, Integer.MAX_VALUE};
        ArrayList<Object[]> valuePairs = new ArrayList<Object[]>();
        for (Object val1 : values) {
            for (Object val2 : values) {
                valuePairs.add(new Object[]{val1, val2});
            }
        }
        return valuePairs;
    }

    public TestIntOverflow(int x, int y) {
        this.x = x;
        this.y = y;
    }

    private void assertOverflow(long longResult, int intResult) {
        if (longResult > Integer.MAX_VALUE) {
            Assert.assertTrue((String)("Expected negative value for " + this.x + " and " + this.y + ": " + intResult), (intResult <= 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("Expected positive value for " + this.x + " and " + this.y + ": " + intResult), (intResult > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAddOverflow() {
        int result = ErrorConditionChecker.overflowDistance((int)this.x, (int)this.y, (int)96);
        this.assertOverflow((long)this.x + (long)this.y, result);
    }

    @Test
    public void testSubOverflow() {
        int result = ErrorConditionChecker.overflowDistance((int)this.x, (int)this.y, (int)100);
        this.assertOverflow((long)this.x - (long)this.y, result);
    }

    @Test
    public void testMulOverflow() {
        int result = ErrorConditionChecker.overflowDistance((int)this.x, (int)this.y, (int)104);
        this.assertOverflow((long)this.x * (long)this.y, result);
    }

    @Test
    public void testDivOverflow() {
        Assume.assumeTrue((this.y != 0 ? 1 : 0) != 0);
        int result = ErrorConditionChecker.overflowDistance((int)this.x, (int)this.y, (int)108);
        this.assertOverflow((long)this.x / (long)this.y, result);
    }
}

