/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import org.evosuite.instrumentation.ErrorConditionChecker;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestLongOverflow {
    private long x;
    private long y;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[] values = new Object[]{Long.MIN_VALUE, -4611686018427387904L, 0, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE};
        ArrayList<Object[]> valuePairs = new ArrayList<Object[]>();
        for (Object val1 : values) {
            for (Object val2 : values) {
                valuePairs.add(new Object[]{val1, val2});
            }
        }
        return valuePairs;
    }

    public TestLongOverflow(long x, long y) {
        this.x = x;
        this.y = y;
    }

    private void assertOverflow(BigDecimal preciseResult, int distance, long longResult) {
        BigDecimal maxResult = new BigDecimal(Long.MAX_VALUE);
        if (preciseResult.compareTo(maxResult) > 0) {
            Assert.assertTrue((String)("Expected negative value for " + this.x + " and " + this.y + ": " + distance + " for " + longResult), (distance <= 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("Expected positive value for " + this.x + " and " + this.y + ": " + distance + " for " + longResult), (distance > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAddOverflow() {
        int result = ErrorConditionChecker.overflowDistance((long)this.x, (long)this.y, (int)97);
        this.assertOverflow(new BigDecimal(this.x).add(new BigDecimal(this.y)), result, this.x + this.y);
    }

    @Test
    public void testSubOverflow() {
        int result = ErrorConditionChecker.overflowDistance((long)this.x, (long)this.y, (int)101);
        this.assertOverflow(new BigDecimal(this.x).subtract(new BigDecimal(this.y)), result, this.x - this.y);
    }

    @Test
    public void testMulOverflow() {
        int result = ErrorConditionChecker.overflowDistance((long)this.x, (long)this.y, (int)105);
        this.assertOverflow(new BigDecimal(this.x).multiply(new BigDecimal(this.y)), result, this.x * this.y);
    }

    @Test
    public void testDivOverflow() {
        Assume.assumeTrue((this.y != 0L ? 1 : 0) != 0);
        System.out.println("x: " + this.x + ", y: " + this.y);
        int result = ErrorConditionChecker.overflowDistance((long)this.x, (long)this.y, (int)109);
        this.assertOverflow(new BigDecimal(this.x).divide(new BigDecimal(this.y), 10, RoundingMode.HALF_UP), result, this.x / this.y);
    }
}

