/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import org.evosuite.instrumentation.ErrorConditionChecker;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestLongUnderflow {
    private long x;
    private long y;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[] values = new Object[]{Long.MIN_VALUE, -4611686018427387904L, 0, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE};
        ArrayList<Object[]> valuePairs = new ArrayList<Object[]>();
        for (Object val1 : values) {
            for (Object val2 : values) {
                valuePairs.add(new Object[]{val1, val2});
            }
        }
        return valuePairs;
    }

    public TestLongUnderflow(long x, long y) {
        this.x = x;
        this.y = y;
    }

    private void assertUnderflow(BigDecimal preciseResult, int distance, long longResult) {
        BigDecimal maxResult = new BigDecimal(Long.MIN_VALUE);
        if (preciseResult.compareTo(maxResult) < 0) {
            Assert.assertTrue((String)("Expected negative value for " + this.x + " and " + this.y + ": " + distance + " for " + longResult), (distance < 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("Expected positive value for " + this.x + " and " + this.y + ": " + distance), (distance >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAddUnderflow() {
        int result = ErrorConditionChecker.underflowDistance((long)this.x, (long)this.y, (int)97);
        this.assertUnderflow(new BigDecimal(this.x).add(new BigDecimal(this.y)), result, this.x + this.y);
    }

    @Test
    public void testSubUnderflow() {
        int result = ErrorConditionChecker.underflowDistance((long)this.x, (long)this.y, (int)101);
        this.assertUnderflow(new BigDecimal(this.x).subtract(new BigDecimal(this.y)), result, this.x - this.y);
    }

    @Test
    public void testMulUnderflow() {
        int result = ErrorConditionChecker.underflowDistance((long)this.x, (long)this.y, (int)105);
        this.assertUnderflow(new BigDecimal(this.x).multiply(new BigDecimal(this.y)), result, this.x * this.y);
    }

    @Test
    public void testDivUnderflow() {
        Assume.assumeTrue((this.y != 0L ? 1 : 0) != 0);
        int result = ErrorConditionChecker.underflowDistance((long)this.x, (long)this.y, (int)109);
        this.assertUnderflow(new BigDecimal(this.x).divide(new BigDecimal(this.y), 10, RoundingMode.HALF_UP), result, this.x / this.y);
    }
}

