/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import org.evosuite.instrumentation.BooleanHelper;
import org.junit.Assert;
import org.junit.Test;

public class TestStringReplacementMethods {
    @Test
    public void testEquals() {
        String str1 = "test";
        String str2 = "test";
        int result = BooleanHelper.StringEquals((String)str1, (Object)str2);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsNull() {
        String str1 = "test";
        Object str2 = null;
        int result = BooleanHelper.StringEquals((String)str1, str2);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void testEqualsNullCallee() {
        String str1 = null;
        String str2 = "test";
        BooleanHelper.StringEquals(str1, (Object)str2);
    }

    @Test
    public void testNotEquals() {
        String str1 = "test1";
        String str2 = "test2";
        int result = BooleanHelper.StringEquals((String)str1, (Object)str2);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsRelativeOrdering() {
        String str1 = "test1";
        String str2 = "test2";
        String str3 = "something else";
        int result1 = BooleanHelper.StringEquals((String)str1, (Object)str2);
        int result2 = BooleanHelper.StringEquals((String)str1, (Object)str3);
        Assert.assertTrue((result2 < result1 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsIgnoreCase() {
        String str1 = "test";
        String str2 = "TEST";
        int result = BooleanHelper.StringEqualsIgnoreCase((String)str1, (String)str2);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsIgnoreCaseNull() {
        String str1 = "test";
        String str2 = null;
        int result = BooleanHelper.StringEqualsIgnoreCase((String)str1, str2);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void testEqualsIgnoreCaseNullCallee() {
        String str1 = null;
        String str2 = "test";
        BooleanHelper.StringEqualsIgnoreCase(str1, (String)str2);
    }

    @Test
    public void testNotEqualsIgnoreCase() {
        String str1 = "test1";
        String str2 = "test2";
        int result = BooleanHelper.StringEqualsIgnoreCase((String)str1, (String)str2);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsIgnoreCaseRelativeOrdering() {
        String str1 = "test1";
        String str2 = "test2";
        String str3 = "something else";
        int result1 = BooleanHelper.StringEqualsIgnoreCase((String)str1, (String)str2);
        int result2 = BooleanHelper.StringEqualsIgnoreCase((String)str1, (String)str3);
        Assert.assertTrue((result2 < result1 ? 1 : 0) != 0);
    }

    @Test
    public void testStartsWithAtStart() {
        String str = "testchen";
        String prefix = "test";
        int result = BooleanHelper.StringStartsWith((String)str, (String)prefix, (int)0);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStartsWith() {
        String str = "blahtestchen";
        String prefix = "test";
        int result = BooleanHelper.StringStartsWith((String)str, (String)prefix, (int)4);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotStartsWithAtStart() {
        String str = "testchen";
        String prefix = "foo";
        int result = BooleanHelper.StringStartsWith((String)str, (String)prefix, (int)0);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotStartsWith() {
        String str = "blahtestchen";
        String prefix = "foo";
        int result = BooleanHelper.StringStartsWith((String)str, (String)prefix, (int)4);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEndsWith() {
        String str = "foo bar test";
        String suffix = "test";
        int result = BooleanHelper.StringEndsWith((String)str, (String)suffix);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotEndsWith() {
        String str = "blahtestchen";
        String suffix = "foo";
        int result = BooleanHelper.StringEndsWith((String)str, (String)suffix);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEmpty() {
        String str = "";
        int result = BooleanHelper.StringIsEmpty((String)str);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotEmpty() {
        String str = "blahtestchen";
        int result = BooleanHelper.StringIsEmpty((String)str);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMatches() {
        String str = "hahafoo";
        String regex = ".*foo";
        int result = BooleanHelper.StringMatches((String)str, (String)regex);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotMatches() {
        String str = "";
        String regex = "foo";
        int result = BooleanHelper.StringMatches((String)str, (String)regex);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRegionMatches() {
        String str = "hahafoobar";
        String match = "foog";
        int result = BooleanHelper.StringRegionMatches((String)str, (int)4, (String)match, (int)0, (int)3);
        Assert.assertTrue((boolean)str.regionMatches(4, match, 0, 3));
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotRegionMatchesStart1() {
        String str = "hahafoobar";
        String match = "foog";
        int result = BooleanHelper.StringRegionMatches((String)str, (int)5, (String)match, (int)0, (int)3);
        Assert.assertFalse((boolean)str.regionMatches(5, match, 0, 3));
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotRegionMatchesStart2() {
        String str = "hahafoobar";
        String match = "foog";
        int result = BooleanHelper.StringRegionMatches((String)str, (int)4, (String)match, (int)1, (int)3);
        Assert.assertFalse((boolean)str.regionMatches(4, match, 1, 3));
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotRegionMatchesLength() {
        String str = "hahafoobar";
        String match = "foo";
        int result = BooleanHelper.StringRegionMatches((String)str, (int)5, (String)match, (int)0, (int)4);
        Assert.assertFalse((boolean)str.regionMatches(5, match, 0, 4));
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotRegionMatchesString() {
        String str = "hahafoobar";
        String match = "bar";
        int result = BooleanHelper.StringRegionMatches((String)str, (int)5, (String)match, (int)0, (int)3);
        Assert.assertFalse((boolean)str.regionMatches(5, match, 0, 3));
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }
}

