/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.javaagent;

import org.evosuite.instrumentation.ErrorConditionChecker;
import org.junit.Assert;
import org.junit.Test;

public class ErrorConditionCheckerTest {
    @Test
    public void testScaleTo() {
        int y;
        int x = ErrorConditionChecker.scaleTo((double)100.0, (int)Integer.MAX_VALUE);
        Assert.assertTrue((x < (y = ErrorConditionChecker.scaleTo((double)200.0, (int)Integer.MAX_VALUE)) ? 1 : 0) != 0);
        int HALFWAY = 0x3FFFFFFF;
        x = ErrorConditionChecker.scaleTo((double)100.0, (int)0x3FFFFFFF);
        y = ErrorConditionChecker.scaleTo((double)200.0, (int)0x3FFFFFFF);
        Assert.assertTrue((x < y ? 1 : 0) != 0);
    }

    @Test
    public void testIntAddOverflow() {
        int distance = ErrorConditionChecker.overflowDistance((int)Integer.MAX_VALUE, (int)2, (int)96);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)96);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((int)Integer.MAX_VALUE, (int)1, (int)96);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((int)Integer.MAX_VALUE, (int)0, (int)96);
        Assert.assertEquals((long)1L, (long)distance);
        distance = ErrorConditionChecker.overflowDistance((int)0, (int)Integer.MAX_VALUE, (int)96);
        Assert.assertEquals((long)1L, (long)distance);
        distance = ErrorConditionChecker.overflowDistance((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE, (int)96);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)distance);
        int distance1 = ErrorConditionChecker.overflowDistance((int)10, (int)10, (int)96);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        int distance2 = ErrorConditionChecker.overflowDistance((int)1000, (int)1000, (int)96);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance1 > distance2 ? 1 : 0) != 0);
        distance1 = ErrorConditionChecker.overflowDistance((int)100, (int)-100, (int)96);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        distance2 = ErrorConditionChecker.overflowDistance((int)-100, (int)100, (int)96);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)distance1, (long)distance2);
        int distance3 = ErrorConditionChecker.overflowDistance((int)-100, (int)10, (int)96);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance3), (distance3 > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)distance1, (long)distance2);
        distance3 = ErrorConditionChecker.overflowDistance((int)-50, (int)10, (int)96);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance3), (distance3 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((distance3 < distance2 ? 1 : 0) != 0);
    }

    @Test
    public void testIntAddUnderflow() {
        int distance = ErrorConditionChecker.underflowDistance((int)Integer.MIN_VALUE, (int)-1, (int)96);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.underflowDistance((int)-1, (int)Integer.MIN_VALUE, (int)96);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.underflowDistance((int)-1073741824, (int)-1073741824, (int)96);
        Assert.assertEquals((long)1L, (long)distance);
        distance = ErrorConditionChecker.underflowDistance((int)-1073741825, (int)-1073741825, (int)96);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.underflowDistance((int)-1073741823, (int)-1073741823, (int)96);
        Assert.assertTrue((distance > 0 ? 1 : 0) != 0);
        int distance1 = ErrorConditionChecker.underflowDistance((int)10, (int)10, (int)96);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        int distance2 = ErrorConditionChecker.underflowDistance((int)1000, (int)1000, (int)96);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance1 < distance2 ? 1 : 0) != 0);
    }

    @Test
    public void testIntSubOverflow() {
        int distance = ErrorConditionChecker.overflowDistance((int)Integer.MAX_VALUE, (int)-2, (int)100);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((int)Integer.MAX_VALUE, (int)Integer.MIN_VALUE, (int)100);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((int)Integer.MAX_VALUE, (int)-1, (int)100);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((int)Integer.MAX_VALUE, (int)0, (int)100);
        Assert.assertEquals((long)1L, (long)distance);
        distance = ErrorConditionChecker.overflowDistance((int)0, (int)Integer.MIN_VALUE, (int)100);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((int)-1, (int)Integer.MIN_VALUE, (int)100);
        Assert.assertTrue((distance > 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE, (int)100);
        Assert.assertEquals((long)0x7FFFFFFEL, (long)distance);
        int distance1 = ErrorConditionChecker.overflowDistance((int)10, (int)10, (int)100);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        int distance2 = ErrorConditionChecker.overflowDistance((int)10, (int)1000, (int)100);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance2 > distance1 ? 1 : 0) != 0);
        distance1 = ErrorConditionChecker.overflowDistance((int)100, (int)-100, (int)100);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        distance2 = ErrorConditionChecker.overflowDistance((int)-100, (int)100, (int)100);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((distance1 < distance2 ? 1 : 0) != 0);
        int distance3 = ErrorConditionChecker.overflowDistance((int)-100, (int)10, (int)100);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance3), (distance3 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((distance3 < distance2 ? 1 : 0) != 0);
        distance3 = ErrorConditionChecker.overflowDistance((int)-50, (int)10, (int)100);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance3), (distance3 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((distance3 < distance2 ? 1 : 0) != 0);
    }

    @Test
    public void testIntSubUnderflow() {
        int distance = ErrorConditionChecker.underflowDistance((int)Integer.MIN_VALUE, (int)2, (int)100);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.underflowDistance((int)Integer.MIN_VALUE, (int)-2, (int)100);
        Assert.assertTrue((distance > 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.underflowDistance((int)-2, (int)Integer.MAX_VALUE, (int)100);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        int distance1 = ErrorConditionChecker.underflowDistance((int)10, (int)10, (int)100);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        int distance2 = ErrorConditionChecker.underflowDistance((int)1000, (int)1000, (int)100);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance1 < distance2 ? 1 : 0) != 0);
        distance1 = ErrorConditionChecker.underflowDistance((int)10, (int)-10, (int)100);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        distance2 = ErrorConditionChecker.underflowDistance((int)1000, (int)-1000, (int)100);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance1 < distance2 ? 1 : 0) != 0);
    }

    @Test
    public void testIntMulOverflow() {
        int distance = ErrorConditionChecker.overflowDistance((int)Integer.MAX_VALUE, (int)2, (int)104);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((int)0x3FFFFFFF, (int)3, (int)104);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((int)Integer.MIN_VALUE, (int)-2, (int)104);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((int)Integer.MIN_VALUE, (int)-1, (int)104);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((int)-15000000, (int)-15000000, (int)104);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        int distance1 = ErrorConditionChecker.overflowDistance((int)10, (int)10, (int)104);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        int distance2 = ErrorConditionChecker.overflowDistance((int)10, (int)1000, (int)104);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance2 < distance1 ? 1 : 0) != 0);
        distance2 = ErrorConditionChecker.overflowDistance((int)-10, (int)1000, (int)104);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance2 > distance1 ? 1 : 0) != 0);
        int distance3 = ErrorConditionChecker.overflowDistance((int)-100, (int)1000, (int)104);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance3), (distance3 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance3 > distance2 ? 1 : 0) != 0);
        distance1 = ErrorConditionChecker.overflowDistance((int)-100, (int)-100, (int)104);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        distance2 = ErrorConditionChecker.overflowDistance((int)100, (int)1000, (int)104);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance2 < distance1 ? 1 : 0) != 0);
    }

    @Test
    public void testIntMulUnderflow() {
        int distance = ErrorConditionChecker.underflowDistance((int)Integer.MAX_VALUE, (int)-2, (int)104);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.underflowDistance((int)-2, (int)Integer.MAX_VALUE, (int)104);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.underflowDistance((int)2, (int)Integer.MIN_VALUE, (int)104);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.underflowDistance((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE, (int)104);
        Assert.assertTrue((distance > 0 ? 1 : 0) != 0);
        int distance1 = ErrorConditionChecker.underflowDistance((int)10, (int)10, (int)104);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        int distance2 = ErrorConditionChecker.underflowDistance((int)20, (int)1000, (int)104);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance1 < distance2 ? 1 : 0) != 0);
        distance2 = ErrorConditionChecker.underflowDistance((int)3, (int)1000000, (int)104);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance2 < distance1 ? 1 : 0) != 0);
    }

    @Test
    public void testIntDivOverflow() {
        int distance = ErrorConditionChecker.overflowDistance((int)Integer.MIN_VALUE, (int)-1, (int)108);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((int)Integer.MIN_VALUE, (int)1, (int)108);
        Assert.assertTrue((String)("Expected > 0 but got " + distance), (distance > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFloatAddOverflow() {
        int distance = ErrorConditionChecker.overflowDistance((float)Float.MAX_VALUE, (float)2.0f, (int)98);
        Assert.assertEquals((long)1L, (long)distance);
        distance = ErrorConditionChecker.overflowDistance((float)Float.MAX_VALUE, (float)Float.MAX_VALUE, (int)98);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((float)Float.MAX_VALUE, (float)0.0f, (int)98);
        Assert.assertEquals((long)1L, (long)distance);
        distance = ErrorConditionChecker.overflowDistance((float)0.0f, (float)Float.MAX_VALUE, (int)98);
        Assert.assertEquals((long)1L, (long)distance);
        distance = ErrorConditionChecker.overflowDistance((float)-3.4028235E38f, (float)Float.MAX_VALUE, (int)98);
        Assert.assertEquals((long)0x7FFFFFFEL, (long)distance);
        int distance1 = ErrorConditionChecker.overflowDistance((float)10.0f, (float)10.0f, (int)98);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        int distance2 = ErrorConditionChecker.overflowDistance((float)1000.0f, (float)1000.0f, (int)98);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance1 > distance2 ? 1 : 0) != 0);
        distance1 = ErrorConditionChecker.overflowDistance((float)100.0f, (float)-100.0f, (int)98);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        distance2 = ErrorConditionChecker.overflowDistance((float)-100.0f, (float)100.0f, (int)98);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)distance1, (long)distance2);
        int distance3 = ErrorConditionChecker.overflowDistance((float)-100.0f, (float)10.0f, (int)98);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance3), (distance3 > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)distance1, (long)distance2);
        distance3 = ErrorConditionChecker.overflowDistance((float)-50.0f, (float)10.0f, (int)98);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance3), (distance3 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((distance3 < distance2 ? 1 : 0) != 0);
    }

    @Test
    public void testFloatAddUnderflow() {
        int distance = ErrorConditionChecker.underflowDistance((float)-3.4028235E38f, (float)-3.4028235E38f, (int)98);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.underflowDistance((float)-1.7014117E38f, (float)-1.7014117E38f, (int)98);
        Assert.assertEquals((long)1L, (long)distance);
        distance = ErrorConditionChecker.underflowDistance((float)-1.7014117E38f, (float)-1.7014117E38f, (int)98);
        Assert.assertEquals((long)1L, (long)distance);
        distance = ErrorConditionChecker.underflowDistance((float)-1.7014117E38f, (float)-1.7014117E38f, (int)98);
        Assert.assertTrue((distance > 0 ? 1 : 0) != 0);
        int distance1 = ErrorConditionChecker.underflowDistance((float)10.0f, (float)10.0f, (int)98);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        int distance2 = ErrorConditionChecker.underflowDistance((float)1000.0f, (float)1000.0f, (int)98);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance1 < distance2 ? 1 : 0) != 0);
    }

    @Test
    public void testFloatSubOverflow() {
        int distance = ErrorConditionChecker.overflowDistance((float)Float.MAX_VALUE, (float)-3.4028235E38f, (int)102);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((float)Float.MAX_VALUE, (float)-3.4028235E38f, (int)102);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((float)Float.MAX_VALUE, (float)-1.0f, (int)102);
        Assert.assertEquals((long)1L, (long)distance);
        distance = ErrorConditionChecker.overflowDistance((float)Float.MAX_VALUE, (float)0.0f, (int)102);
        Assert.assertEquals((long)1L, (long)distance);
        distance = ErrorConditionChecker.overflowDistance((float)0.0f, (float)-3.4028235E38f, (int)102);
        Assert.assertEquals((long)1L, (long)distance);
        distance = ErrorConditionChecker.overflowDistance((float)-1.0f, (float)-3.4028235E38f, (int)102);
        Assert.assertTrue((distance > 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((float)-3.4028235E38f, (float)-3.4028235E38f, (int)102);
        Assert.assertEquals((long)0x7FFFFFFEL, (long)distance);
        int distance1 = ErrorConditionChecker.overflowDistance((float)10.0f, (float)10.0f, (int)102);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        int distance2 = ErrorConditionChecker.overflowDistance((float)10.0f, (float)1000.0f, (int)102);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance2 > distance1 ? 1 : 0) != 0);
        distance1 = ErrorConditionChecker.overflowDistance((float)100.0f, (float)-100.0f, (int)102);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        distance2 = ErrorConditionChecker.overflowDistance((float)-100.0f, (float)100.0f, (int)102);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((distance1 < distance2 ? 1 : 0) != 0);
        int distance3 = ErrorConditionChecker.overflowDistance((float)-100.0f, (float)10.0f, (int)102);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance3), (distance3 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((distance3 < distance2 ? 1 : 0) != 0);
        distance3 = ErrorConditionChecker.overflowDistance((float)-50.0f, (float)10.0f, (int)102);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance3), (distance3 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((distance3 < distance2 ? 1 : 0) != 0);
    }

    @Test
    public void testFloatSubUnderflow() {
        int distance = ErrorConditionChecker.underflowDistance((float)-3.4028235E38f, (float)Float.MAX_VALUE, (int)102);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.underflowDistance((float)-3.4028235E38f, (float)-2.0f, (int)102);
        Assert.assertTrue((distance > 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.underflowDistance((float)-3.4028235E38f, (float)Float.MAX_VALUE, (int)102);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        int distance1 = ErrorConditionChecker.underflowDistance((float)10.0f, (float)10.0f, (int)102);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        int distance2 = ErrorConditionChecker.underflowDistance((float)1000.0f, (float)1000.0f, (int)102);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance1 < distance2 ? 1 : 0) != 0);
        distance1 = ErrorConditionChecker.underflowDistance((float)10.0f, (float)-10.0f, (int)102);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        distance2 = ErrorConditionChecker.underflowDistance((float)1000.0f, (float)-1000.0f, (int)102);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance1 < distance2 ? 1 : 0) != 0);
    }

    @Test
    public void testFloatMulOverflow() {
        int distance = ErrorConditionChecker.overflowDistance((float)Float.MAX_VALUE, (float)2.0f, (int)106);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((float)1.7014117E38f, (float)3.0f, (int)106);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((float)-3.4028235E38f, (float)-2.0f, (int)106);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((float)-3.4028235E38f, (float)-1.0f, (int)106);
        Assert.assertEquals((long)1L, (long)distance);
        distance = ErrorConditionChecker.overflowDistance((float)-1.5E23f, (float)-1.5E23f, (int)106);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        int distance1 = ErrorConditionChecker.overflowDistance((float)10.0f, (float)10.0f, (int)106);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        int distance2 = ErrorConditionChecker.overflowDistance((float)10.0f, (float)1000.0f, (int)106);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance2 < distance1 ? 1 : 0) != 0);
        distance2 = ErrorConditionChecker.overflowDistance((float)-10.0f, (float)1000.0f, (int)106);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance2 > distance1 ? 1 : 0) != 0);
        int distance3 = ErrorConditionChecker.overflowDistance((float)-100.0f, (float)1000.0f, (int)106);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance3), (distance3 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance3 > distance2 ? 1 : 0) != 0);
        distance1 = ErrorConditionChecker.overflowDistance((float)-100.0f, (float)-100.0f, (int)106);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        distance2 = ErrorConditionChecker.overflowDistance((float)100.0f, (float)1000.0f, (int)106);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance2 < distance1 ? 1 : 0) != 0);
    }

    @Test
    public void testFloatMulUnderflow() {
        int distance = ErrorConditionChecker.underflowDistance((float)Float.MAX_VALUE, (float)-2.0f, (int)106);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.underflowDistance((float)-2.0f, (float)Float.MAX_VALUE, (int)106);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.underflowDistance((float)2.0f, (float)-3.4028235E38f, (int)106);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.underflowDistance((float)-3.4028235E38f, (float)-3.4028235E38f, (int)106);
        Assert.assertTrue((distance > 0 ? 1 : 0) != 0);
        int distance1 = ErrorConditionChecker.underflowDistance((float)10.0f, (float)10.0f, (int)106);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance1), (distance1 > 0 ? 1 : 0) != 0);
        int distance2 = ErrorConditionChecker.underflowDistance((float)20.0f, (float)1000.0f, (int)106);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance1 < distance2 ? 1 : 0) != 0);
        distance2 = ErrorConditionChecker.underflowDistance((float)3.0f, (float)1000000.0f, (int)106);
        Assert.assertTrue((String)("Expected value greater 0 but got " + distance2), (distance2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid ranking: " + distance1 + ", " + distance2), (distance2 < distance1 ? 1 : 0) != 0);
    }

    @Test
    public void testFloatDivOverflow() {
        int distance = ErrorConditionChecker.overflowDistance((float)-3.4028235E38f, (float)-1.0f, (int)110);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = ErrorConditionChecker.overflowDistance((float)-3.4028235E38f, (float)1.0f, (int)110);
        Assert.assertTrue((String)("Expected > 0 but got " + distance), (distance > 0 ? 1 : 0) != 0);
    }
}

