/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit.xml;

import com.examples.with.different.packagename.junit.PassingFooTest;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.junit.FooTestClassLoader;
import org.evosuite.junit.JUnitExecutionException;
import org.evosuite.junit.JUnitResult;
import org.evosuite.junit.xml.JUnitProcessLauncher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class JUnitProcessLauncherTest {
    @Test
    public void testCorrectLaunch() throws JUnitExecutionException {
        JUnitProcessLauncher launcher = new JUnitProcessLauncher();
        JUnitResult result = launcher.startNewJUnitProcess(new Class[]{PassingFooTest.class}, null);
        Assert.assertTrue((boolean)result.wasSuccessful());
        Assert.assertEquals((long)0L, (long)result.getFailureCount());
        Assert.assertEquals((long)3L, (long)result.getRunCount());
    }

    @Test
    public void testMissingClassFile() {
        FooTestClassLoader loader = new FooTestClassLoader();
        Class<?> fooTestClass = loader.loadFooTestClass();
        JUnitProcessLauncher launcher = new JUnitProcessLauncher();
        try {
            launcher.startNewJUnitProcess(new Class[]{fooTestClass}, null);
            Assert.fail();
        }
        catch (JUnitExecutionException e) {
            // empty catch block
        }
    }

    @Test
    public void testMissingArguments() {
        JUnitProcessLauncher launcher = new JUnitProcessLauncher();
        try {
            launcher.startNewJUnitProcess(new Class[0], null);
            Assert.fail();
        }
        catch (JUnitExecutionException e) {
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @After
    public void resetHanlderAfterTest() {
        ClassPathHandler.resetSingleton();
    }
}

