/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit.xml;

import java.io.File;
import org.evosuite.junit.FooTestClassLoader;
import org.evosuite.junit.JUnitResult;
import org.evosuite.junit.xml.JUnitExecutor;
import org.evosuite.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JUnitXmlResultProxyTest {
    private static final String JUNIT_RESULT_FILENAME = "junitresult.xml";

    @Before
    public void setUp() throws Exception {
        this.cleanFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        this.cleanFileSystem();
    }

    @Test
    public void test() {
        Assert.assertFalse((boolean)this.checkFileExists());
        JUnitExecutor executor = new JUnitExecutor();
        Class<?> fooTestClass = new FooTestClassLoader().loadFooTestClass();
        JUnitResult result = executor.execute(new Class[]{fooTestClass});
        Utils.writeXML((Object)result, (String)JUNIT_RESULT_FILENAME);
        Assert.assertTrue((boolean)this.checkFileExists());
        JUnitResult result_from_xml_file = (JUnitResult)Utils.readXML((String)JUNIT_RESULT_FILENAME);
        Assert.assertEquals((Object)result, (Object)result_from_xml_file);
    }

    private void cleanFileSystem() {
        File junitResult = new File(JUNIT_RESULT_FILENAME);
        if (junitResult.exists()) {
            junitResult.delete();
        }
    }

    private boolean checkFileExists() {
        File file = new File(JUNIT_RESULT_FILENAME);
        return file.exists();
    }
}

