/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.rmi;

import java.net.ServerSocket;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import org.junit.Assert;
import org.junit.Test;

public class OpenRegestryTest {
    @Test
    public void openTest() throws RemoteException, NotBoundException {
        int port = 2000;
        for (int i = 0; i < 10000; ++i) {
            try {
                LocateRegistry.createRegistry(port);
                break;
            }
            catch (ExportException e) {
                ++port;
                continue;
            }
        }
        Registry registry = LocateRegistry.getRegistry(port);
        Assert.assertNotNull((Object)registry);
        try {
            LocateRegistry.createRegistry(port);
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ServerSocket socket = new ServerSocket(port);
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        FooImpl foo = new FooImpl();
        Ifoo stub = (Ifoo)UnicastRemoteObject.exportObject((Remote)foo, port);
        String service = "Foo";
        registry.rebind(service, stub);
        Ifoo lookedup = (Ifoo)registry.lookup(service);
        Assert.assertEquals((Object)"Hello World", (Object)lookedup.getString());
    }

    class FooImpl
    implements Ifoo {
        FooImpl() {
        }

        @Override
        public String getString() throws RemoteException {
            return "Hello World";
        }
    }

    static interface Ifoo
    extends Remote {
        public String getString() throws RemoteException;
    }
}

