/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.stubs;

import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.evosuite.stubs.StubClassVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.TraceClassVisitor;

public class TestStubbingClassLoader
extends ClassLoader {
    private final ClassLoader classLoader;
    private final Map<String, Class<?>> classes = new HashMap();

    public TestStubbingClassLoader() {
        this.classLoader = TestStubbingClassLoader.class.getClassLoader();
    }

    public static String[] getPackagesShouldNotBeInstrumented() {
        return new String[]{"java.", "javax.", "sun.", "org.evosuite", "org.exsyst", "de.unisb.cs.st.testcarver", "de.unisb.cs.st.evosuite", "org.uispec4j", "de.unisb.cs.st.specmate", "org.xml", "org.w3c", "testing.generation.evosuite", "com.yourkit", "com.vladium.emma.", "daikon.", "apple.", "com.apple.", "com.sun", "org.junit", "junit.framework", "org.apache.xerces.dom3", "de.unisl.cs.st.bugex", "edu.uta.cse.dsc", "corina.cross.Single"};
    }

    public static boolean checkIfCanInstrument(String className) {
        for (String s : TestStubbingClassLoader.getPackagesShouldNotBeInstrumented()) {
            if (!className.startsWith(s)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (!TestStubbingClassLoader.checkIfCanInstrument(name)) {
            Class<?> result = this.findLoadedClass(name);
            if (result != null) {
                return result;
            }
            result = this.classLoader.loadClass(name);
            return result;
        }
        Class<?> result = this.findLoadedClass(name);
        if (result != null) {
            return result;
        }
        result = this.classes.get(name);
        if (result != null) {
            return result;
        }
        Class<?> instrumentedClass = this.instrumentClass(name);
        return instrumentedClass;
    }

    private Class<?> instrumentClass(String fullyQualifiedTargetClass) throws ClassNotFoundException {
        try {
            String className = fullyQualifiedTargetClass.replace('.', '/');
            InputStream is = ClassLoader.getSystemResourceAsStream(className + ".class");
            if (is == null) {
                throw new ClassNotFoundException("Class '" + className + ".class" + "' should be in target project, but could not be found!");
            }
            ClassReader reader = new ClassReader(is);
            ClassWriter writer = new ClassWriter(2);
            TraceClassVisitor tc = new TraceClassVisitor((ClassVisitor)writer, new PrintWriter(System.err));
            StubClassVisitor visitor = new StubClassVisitor((ClassVisitor)tc, fullyQualifiedTargetClass);
            reader.accept((ClassVisitor)visitor, 4);
            byte[] byteBuffer = writer.toByteArray();
            Class<?> result = this.defineClass(fullyQualifiedTargetClass, byteBuffer, 0, byteBuffer.length);
            this.classes.put(fullyQualifiedTargetClass, result);
            return result;
        }
        catch (Throwable t) {
            throw new ClassNotFoundException(t.getMessage(), t);
        }
    }
}

