/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ConcurrentModificationException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;

public class MathRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -5128983364075381060L;
    private final String pattern;
    private final Object[] arguments;

    private static String translate(String s, Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.apache.commons.math.MessagesResources", locale);
            if (bundle.getLocale().getLanguage().equals(locale.getLanguage())) {
                return bundle.getString(s);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return s;
    }

    private static String buildMessage(Locale locale, String pattern, Object ... arguments) {
        return pattern == null ? "" : new MessageFormat(MathRuntimeException.translate(pattern, locale), locale).format(arguments);
    }

    public MathRuntimeException(String pattern, Object ... arguments) {
        super(MathRuntimeException.buildMessage(Locale.US, pattern, arguments));
        this.pattern = pattern;
        this.arguments = arguments == null ? new Object[]{} : (Object[])arguments.clone();
    }

    public MathRuntimeException(Throwable rootCause) {
        super(rootCause);
        this.pattern = this.getMessage();
        this.arguments = new Object[0];
    }

    public MathRuntimeException(Throwable rootCause, String pattern, Object ... arguments) {
        super(MathRuntimeException.buildMessage(Locale.US, pattern, arguments), rootCause);
        this.pattern = pattern;
        this.arguments = arguments == null ? new Object[]{} : (Object[])arguments.clone();
    }

    public String getPattern() {
        return this.pattern;
    }

    public Object[] getArguments() {
        return (Object[])this.arguments.clone();
    }

    public String getMessage(Locale locale) {
        return MathRuntimeException.buildMessage(locale, this.pattern, this.arguments);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(out, false);
            this.printStackTrace(pw);
            pw.flush();
        }
    }

    public static ArithmeticException createArithmeticException(final String pattern, final Object ... arguments) {
        return new ArithmeticException(MathRuntimeException.buildMessage(Locale.US, pattern, arguments)){
            private static final long serialVersionUID = 7705628723242533939L;

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), pattern, arguments);
            }
        };
    }

    public static ArrayIndexOutOfBoundsException createArrayIndexOutOfBoundsException(final String pattern, final Object ... arguments) {
        return new ArrayIndexOutOfBoundsException(MathRuntimeException.buildMessage(Locale.US, pattern, arguments)){
            private static final long serialVersionUID = -3394748305449283486L;

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), pattern, arguments);
            }
        };
    }

    public static EOFException createEOFException(final String pattern, final Object ... arguments) {
        return new EOFException(MathRuntimeException.buildMessage(Locale.US, pattern, arguments)){
            private static final long serialVersionUID = 279461544586092584L;

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), pattern, arguments);
            }
        };
    }

    public static IOException createIOException(Throwable rootCause) {
        IOException ioe = new IOException(rootCause.getLocalizedMessage());
        ioe.initCause(rootCause);
        return ioe;
    }

    public static IllegalArgumentException createIllegalArgumentException(final String pattern, final Object ... arguments) {
        return new IllegalArgumentException(MathRuntimeException.buildMessage(Locale.US, pattern, arguments)){
            private static final long serialVersionUID = -6555453980658317913L;

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), pattern, arguments);
            }
        };
    }

    public static IllegalArgumentException createIllegalArgumentException(Throwable rootCause) {
        IllegalArgumentException iae = new IllegalArgumentException(rootCause.getLocalizedMessage());
        iae.initCause(rootCause);
        return iae;
    }

    public static IllegalStateException createIllegalStateException(final String pattern, final Object ... arguments) {
        return new IllegalStateException(MathRuntimeException.buildMessage(Locale.US, pattern, arguments)){
            private static final long serialVersionUID = -95247648156277208L;

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), pattern, arguments);
            }
        };
    }

    public static ConcurrentModificationException createConcurrentModificationException(final String pattern, final Object ... arguments) {
        return new ConcurrentModificationException(MathRuntimeException.buildMessage(Locale.US, pattern, arguments)){
            private static final long serialVersionUID = 6134247282754009421L;

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), pattern, arguments);
            }
        };
    }

    public static NoSuchElementException createNoSuchElementException(final String pattern, final Object ... arguments) {
        return new NoSuchElementException(MathRuntimeException.buildMessage(Locale.US, pattern, arguments)){
            private static final long serialVersionUID = 7304273322489425799L;

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), pattern, arguments);
            }
        };
    }

    public static NullPointerException createNullPointerException(final String pattern, final Object ... arguments) {
        return new NullPointerException(MathRuntimeException.buildMessage(Locale.US, pattern, arguments)){
            private static final long serialVersionUID = -3075660477939965216L;

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), pattern, arguments);
            }
        };
    }

    public static ParseException createParseException(int offset, final String pattern, final Object ... arguments) {
        return new ParseException(MathRuntimeException.buildMessage(Locale.US, pattern, arguments), offset){
            private static final long serialVersionUID = -1103502177342465975L;

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), pattern, arguments);
            }
        };
    }

    public static RuntimeException createInternalError(Throwable cause) {
        String pattern = "internal error, please fill a bug report at {0}";
        String argument = "https://issues.apache.org/jira/browse/MATH";
        return new RuntimeException(MathRuntimeException.buildMessage(Locale.US, "internal error, please fill a bug report at {0}", "https://issues.apache.org/jira/browse/MATH")){
            private static final long serialVersionUID = -201865440834027016L;

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), "internal error, please fill a bug report at {0}", new Object[]{"https://issues.apache.org/jira/browse/MATH"});
            }
        };
    }
}

