/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import com.examples.with.different.packagename.concolic.TestCase86;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.symbolic.Assertions;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.ConcolicExecution;
import org.evosuite.symbolic.Fraction;
import org.evosuite.symbolic.TestCaseBuilder;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.VariableReference;
import org.junit.Assert;
import org.junit.Test;

public class SymbolicObserverTest {
    public static void printConstraints(List<BranchCondition> branch_conditions) {
        System.out.println("Constraints=");
        for (BranchCondition branchCondition : branch_conditions) {
            for (Constraint constr : branchCondition.getSupportingConstraints()) {
                System.out.println(constr.toString());
            }
            System.out.println(branchCondition.getLocalConstraint().toString());
        }
    }

    private static void test_input1() {
        String string0 = "aaaaaaaaaaab";
        String string1 = "a*b";
        boolean boolean0 = StringHandler.stringMatches(string0, string1);
        boolean boolean1 = true;
        StringHandler.checkEquals(boolean0, boolean1);
    }

    private static DefaultTestCase build_test_input_1() throws SecurityException, NoSuchMethodException {
        SymbolicObserverTest.test_input1();
        Method string_matches_method = StringHandler.class.getMethod("stringMatches", String.class, String.class);
        Method checkEquals_method = StringHandler.class.getMethod("checkEquals", Boolean.TYPE, Boolean.TYPE);
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference string0 = tc.appendStringPrimitive("aaaaaaaaaaab");
        VariableReference string1 = tc.appendStringPrimitive("a*b");
        VariableReference boolean0 = tc.appendMethod(null, string_matches_method, string0, string1);
        VariableReference boolean1 = tc.appendBooleanPrimitive(true);
        tc.appendMethod(null, checkEquals_method, boolean0, boolean1);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test1() throws SecurityException, NoSuchMethodException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_1();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)1L, (long)branch_conditions.size());
    }

    private static void test_input2() {
        String string0 = "Togliere sta roba";
        StringHandler stringHandler0 = new StringHandler(string0);
        String string1 = "TOGLIERE STA ROBA";
        stringHandler0.toUpperCase();
        boolean boolean0 = stringHandler0.equals(string1);
        boolean boolean1 = true;
        StringHandler.checkEquals(boolean0, boolean1);
    }

    private static DefaultTestCase build_test_input_2() throws SecurityException, NoSuchMethodException {
        SymbolicObserverTest.test_input2();
        Constructor constructor = StringHandler.class.getConstructor(String.class);
        Method toUpperCase_method = StringHandler.class.getMethod("toUpperCase", new Class[0]);
        Method equals_method = StringHandler.class.getMethod("equals", String.class);
        Method checkEquals_method = StringHandler.class.getMethod("checkEquals", Boolean.TYPE, Boolean.TYPE);
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference string0 = tc.appendStringPrimitive("Togliere sta roba");
        VariableReference stringHandler0 = tc.appendConstructor(constructor, string0);
        VariableReference string1 = tc.appendStringPrimitive("TOGLIERE STA ROBA");
        tc.appendMethod(stringHandler0, toUpperCase_method, new VariableReference[0]);
        VariableReference boolean0 = tc.appendMethod(stringHandler0, equals_method, string1);
        VariableReference boolean1 = tc.appendBooleanPrimitive(true);
        tc.appendMethod(null, checkEquals_method, boolean0, boolean1);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test2() throws SecurityException, NoSuchMethodException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_2();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)1L, (long)branch_conditions.size());
    }

    private static void test_input3() {
        String string0 = "add";
        Calculator calculator0 = new Calculator(string0);
        double double0 = 1.5;
        double double1 = -1.5;
        double double2 = calculator0.compute(double0, double1);
        double double3 = 0.0;
        Assertions.checkEquals(double2, double3);
    }

    private static DefaultTestCase build_test_input_3() throws SecurityException, NoSuchMethodException {
        SymbolicObserverTest.test_input3();
        Constructor constructor = Calculator.class.getConstructor(String.class);
        Method compute_method = Calculator.class.getMethod("compute", Double.TYPE, Double.TYPE);
        Method checkEquals_method = Assertions.class.getMethod("checkEquals", Double.TYPE, Double.TYPE);
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference string0 = tc.appendStringPrimitive("add");
        VariableReference calculator0 = tc.appendConstructor(constructor, string0);
        VariableReference double0 = tc.appendDoublePrimitive(1.5);
        VariableReference double1 = tc.appendDoublePrimitive(-1.5);
        VariableReference double2 = tc.appendMethod(calculator0, compute_method, double0, double1);
        VariableReference double3 = tc.appendDoublePrimitive(0.0);
        tc.appendMethod(null, checkEquals_method, double2, double3);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test3() throws SecurityException, NoSuchMethodException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_3();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)2L, (long)branch_conditions.size());
    }

    private static void test_input4() {
        MemoryCell memoryCell0;
        int int0 = Integer.MAX_VALUE;
        MemoryCell memoryCell1 = memoryCell0.anotherCell = (memoryCell0 = new MemoryCell(int0));
        int int1 = memoryCell0.getValue();
        int int2 = memoryCell1.getValue();
        Assertions.checkEquals(int1, int2);
    }

    private static DefaultTestCase build_test_input_4() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        SymbolicObserverTest.test_input4();
        Constructor constructor = MemoryCell.class.getConstructor(Integer.TYPE);
        Field anotherCell_field = MemoryCell.class.getField("anotherCell");
        Method getValue_method = MemoryCell.class.getMethod("getValue", new Class[0]);
        Method checkEquals_method = Assertions.class.getMethod("checkEquals", Integer.TYPE, Integer.TYPE);
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference int0 = tc.appendIntPrimitive(Integer.MAX_VALUE);
        VariableReference memoryCell0 = tc.appendConstructor(constructor, int0);
        tc.appendAssignment(memoryCell0, anotherCell_field, memoryCell0);
        VariableReference memoryCell1 = tc.appendFieldStmt(memoryCell0, anotherCell_field);
        VariableReference int1 = tc.appendMethod(memoryCell0, getValue_method, new VariableReference[0]);
        VariableReference int2 = tc.appendMethod(memoryCell1, getValue_method, new VariableReference[0]);
        tc.appendMethod(null, checkEquals_method, int1, int2);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test4() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_4();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)1L, (long)branch_conditions.size());
    }

    private static void test_input5() {
        int int2;
        int int0 = Integer.MAX_VALUE;
        int int1 = Integer.MIN_VALUE;
        IntHolder intHolder0 = new IntHolder(int0);
        IntHolder intHolder1 = new IntHolder(int1);
        intHolder1.intValue = int2 = intHolder0.intValue;
        int int3 = intHolder0.getValue();
        int int4 = intHolder0.getValue();
        Assertions.checkEquals(int3, int4);
    }

    private static DefaultTestCase build_test_input_5() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        SymbolicObserverTest.test_input5();
        Constructor newIntHolder = IntHolder.class.getConstructor(Integer.TYPE);
        Field intValue = IntHolder.class.getField("intValue");
        Method getValue = IntHolder.class.getMethod("getValue", new Class[0]);
        Method checkEquals = Assertions.class.getMethod("checkEquals", Integer.TYPE, Integer.TYPE);
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference int0 = tc.appendIntPrimitive(Integer.MAX_VALUE);
        VariableReference int1 = tc.appendIntPrimitive(Integer.MIN_VALUE);
        VariableReference intHolder0 = tc.appendConstructor(newIntHolder, int0);
        VariableReference intHolder1 = tc.appendConstructor(newIntHolder, int1);
        VariableReference int2 = tc.appendFieldStmt(intHolder0, intValue);
        tc.appendAssignment(intHolder1, intValue, int2);
        VariableReference int3 = tc.appendMethod(intHolder0, getValue, new VariableReference[0]);
        VariableReference int4 = tc.appendMethod(intHolder1, getValue, new VariableReference[0]);
        tc.appendMethod(null, checkEquals, int3, int4);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test5() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_5();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)1L, (long)branch_conditions.size());
    }

    private static void test_input6() {
        String string0;
        String string1 = StaticFields.string_field = (string0 = "Togliere sta roba");
        boolean boolean0 = StaticFields.equals(string0, string1);
        boolean boolean1 = true;
        Assertions.checkEquals(boolean0, boolean1);
    }

    private static DefaultTestCase build_test_input_6() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        SymbolicObserverTest.test_input6();
        Field string_field = StaticFields.class.getField("string_field");
        Method equals = StaticFields.class.getMethod("equals", String.class, String.class);
        Method checkEquals = Assertions.class.getMethod("checkEquals", Boolean.TYPE, Boolean.TYPE);
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference string0 = tc.appendStringPrimitive("Togliere sta roba");
        tc.appendAssignment(null, string_field, string0);
        VariableReference string1 = tc.appendStaticFieldStmt(string_field);
        VariableReference boolean0 = tc.appendMethod(null, equals, string0, string1);
        VariableReference boolean1 = tc.appendBooleanPrimitive(true);
        tc.appendMethod(null, checkEquals, boolean0, boolean1);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test6() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_6();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)1L, (long)branch_conditions.size());
    }

    private static void test_input7() {
        Object string0;
        Object string1 = string0 = null;
    }

    private static void test_input8() {
        MyEnum myEnum0 = MyEnum.VALUE1;
        MyEnum myEnum1 = MyEnum.VALUE1;
        MyEnum myEnum2 = MyEnum.VALUE2;
    }

    private static DefaultTestCase build_test_input_7() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        SymbolicObserverTest.test_input7();
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference string0 = tc.appendNull((Type)((Object)String.class));
        return tc.getDefaultTestCase();
    }

    @Test
    public void test7() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_7();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)0L, (long)branch_conditions.size());
    }

    private static DefaultTestCase build_test_input_8() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        SymbolicObserverTest.test_input8();
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference myEnum0 = tc.appendEnumPrimitive(MyEnum.VALUE1);
        VariableReference myEnum1 = tc.appendEnumPrimitive(MyEnum.VALUE1);
        VariableReference myEnum2 = tc.appendEnumPrimitive(MyEnum.VALUE2);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test8() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_8();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)0L, (long)branch_conditions.size());
    }

    private static void test_input9() {
        int int0;
        int[] intArray0 = new int[10];
        double[] doubleArray0 = new double[10];
        String[] stringArray0 = new String[10];
        int[][] intMatrix0 = new int[3][3];
        intArray0[1] = int0 = Integer.MAX_VALUE;
        int int1 = Integer.MIN_VALUE;
        int1 = intArray0[1];
        Assertions.checkEquals(int0, int1);
    }

    private static DefaultTestCase build_test_input_9() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        SymbolicObserverTest.test_input9();
        Method checkEquals = Assertions.class.getMethod("checkEquals", Integer.TYPE, Integer.TYPE);
        TestCaseBuilder tc = new TestCaseBuilder();
        ArrayReference intArray0 = tc.appendArrayStmt((Type)((Object)int[].class), 10);
        ArrayReference doubleArray0 = tc.appendArrayStmt((Type)((Object)double[].class), 11);
        ArrayReference stringArray0 = tc.appendArrayStmt((Type)((Object)String[].class), 12);
        ArrayReference intMatrix0 = tc.appendArrayStmt((Type)((Object)int[].class), 3, 3);
        VariableReference int0 = tc.appendIntPrimitive(Integer.MAX_VALUE);
        tc.appendAssignment(intArray0, 1, int0);
        VariableReference int1 = tc.appendIntPrimitive(Integer.MIN_VALUE);
        tc.appendAssignment(int1, intArray0, 1);
        tc.appendMethod(null, checkEquals, int0, int1);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test9() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_9();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)1L, (long)branch_conditions.size());
    }

    private static void test_input10() {
        int int0 = Integer.MAX_VALUE;
        int int1 = Integer.MIN_VALUE;
        int int2 = Math.max(int0, int1);
        Assertions.checkEquals(int0, int2);
    }

    private static DefaultTestCase build_test_input_10() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        SymbolicObserverTest.test_input10();
        Method checkEquals = Assertions.class.getMethod("checkEquals", Integer.TYPE, Integer.TYPE);
        Method max = Math.class.getMethod("max", Integer.TYPE, Integer.TYPE);
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference int0 = tc.appendIntPrimitive(Integer.MAX_VALUE);
        VariableReference int1 = tc.appendIntPrimitive(Integer.MIN_VALUE);
        VariableReference int2 = tc.appendMethod(null, max, int0, int1);
        tc.appendMethod(null, checkEquals, int0, int2);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test10() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_10();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)1L, (long)branch_conditions.size());
    }

    private static DefaultTestCase build_test_input_11() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Constructor newBoolean = Boolean.class.getConstructor(Boolean.TYPE);
        Constructor newInteger = Integer.class.getConstructor(Integer.TYPE);
        Constructor newByte = Byte.class.getConstructor(Byte.TYPE);
        Constructor newShort = Short.class.getConstructor(Short.TYPE);
        Constructor newChar = Character.class.getConstructor(Character.TYPE);
        Constructor newLong = Long.class.getConstructor(Long.TYPE);
        Constructor newFloat = Float.class.getConstructor(Float.TYPE);
        Constructor newDouble = Double.class.getConstructor(Double.TYPE);
        Method booleanValue = Boolean.class.getMethod("booleanValue", new Class[0]);
        Method intValue = Integer.class.getMethod("intValue", new Class[0]);
        Method byteValue = Byte.class.getMethod("byteValue", new Class[0]);
        Method shortValue = Short.class.getMethod("shortValue", new Class[0]);
        Method charValue = Character.class.getMethod("charValue", new Class[0]);
        Method longValue = Long.class.getMethod("longValue", new Class[0]);
        Method floatValue = Float.class.getMethod("floatValue", new Class[0]);
        Method doubleValue = Double.class.getMethod("doubleValue", new Class[0]);
        Method checkBooleanEquals = Assertions.class.getMethod("checkEquals", Boolean.TYPE, Boolean.TYPE);
        Method checkIntEquals = Assertions.class.getMethod("checkEquals", Integer.TYPE, Integer.TYPE);
        Method checkByteEquals = Assertions.class.getMethod("checkEquals", Byte.TYPE, Byte.TYPE);
        Method checkShortEquals = Assertions.class.getMethod("checkEquals", Short.TYPE, Short.TYPE);
        Method checkCharEquals = Assertions.class.getMethod("checkEquals", Character.TYPE, Character.TYPE);
        Method checkLongEquals = Assertions.class.getMethod("checkEquals", Long.TYPE, Long.TYPE);
        Method checkFloatEquals = Assertions.class.getMethod("checkEquals", Float.TYPE, Float.TYPE);
        Method checkDoubleEquals = Assertions.class.getMethod("checkEquals", Double.TYPE, Double.TYPE);
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference int0 = tc.appendIntPrimitive(Integer.MAX_VALUE);
        VariableReference integer0 = tc.appendConstructor(newInteger, int0);
        VariableReference int1 = tc.appendMethod(integer0, intValue, new VariableReference[0]);
        VariableReference byte0 = tc.appendBytePrimitive((byte)127);
        VariableReference byte_instance0 = tc.appendConstructor(newByte, byte0);
        VariableReference byte1 = tc.appendMethod(byte_instance0, byteValue, new VariableReference[0]);
        VariableReference short0 = tc.appendShortPrimitive((short)Short.MAX_VALUE);
        VariableReference short_instance0 = tc.appendConstructor(newShort, short0);
        VariableReference short1 = tc.appendMethod(short_instance0, shortValue, new VariableReference[0]);
        VariableReference char0 = tc.appendCharPrimitive('\uffff');
        VariableReference character0 = tc.appendConstructor(newChar, char0);
        VariableReference char1 = tc.appendMethod(character0, charValue, new VariableReference[0]);
        VariableReference long0 = tc.appendLongPrimitive(Long.MAX_VALUE);
        VariableReference long_instance0 = tc.appendConstructor(newLong, long0);
        VariableReference long1 = tc.appendMethod(long_instance0, longValue, new VariableReference[0]);
        VariableReference float1 = tc.appendFloatPrimitive(Float.MAX_VALUE);
        VariableReference float_instance1 = tc.appendConstructor(newFloat, float1);
        VariableReference float2 = tc.appendMethod(float_instance1, floatValue, new VariableReference[0]);
        VariableReference double0 = tc.appendDoublePrimitive(Double.MAX_VALUE);
        VariableReference double_instance1 = tc.appendConstructor(newDouble, double0);
        VariableReference double1 = tc.appendMethod(double_instance1, doubleValue, new VariableReference[0]);
        VariableReference boolean0 = tc.appendBooleanPrimitive(Boolean.TRUE);
        VariableReference boolean_instance0 = tc.appendConstructor(newBoolean, boolean0);
        VariableReference boolean1 = tc.appendMethod(boolean_instance0, booleanValue, new VariableReference[0]);
        tc.appendMethod(null, checkIntEquals, int0, int1);
        tc.appendMethod(null, checkByteEquals, byte0, byte1);
        tc.appendMethod(null, checkShortEquals, short0, short1);
        tc.appendMethod(null, checkCharEquals, char0, char1);
        tc.appendMethod(null, checkFloatEquals, float1, float2);
        tc.appendMethod(null, checkLongEquals, long0, long1);
        tc.appendMethod(null, checkDoubleEquals, double0, double1);
        tc.appendMethod(null, checkBooleanEquals, boolean0, boolean1);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test11() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_11();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)8L, (long)branch_conditions.size());
    }

    private static DefaultTestCase build_test_input_12() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Constructor newString = String.class.getConstructor(String.class);
        Method length = String.class.getMethod("length", new Class[0]);
        Method checkIntEquals = Assertions.class.getMethod("checkEquals", Integer.TYPE, Integer.TYPE);
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference string0 = tc.appendStringPrimitive("Togliere sta roba");
        VariableReference string1 = tc.appendConstructor(newString, string0);
        VariableReference int0 = tc.appendMethod(string0, length, new VariableReference[0]);
        VariableReference int1 = tc.appendMethod(string1, length, new VariableReference[0]);
        tc.appendMethod(null, checkIntEquals, int0, int1);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test12() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_12();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)1L, (long)branch_conditions.size());
    }

    private static DefaultTestCase build_test_input_13() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Method checkDoubleEquals = Assertions.class.getMethod("checkEquals", Double.TYPE, Double.TYPE);
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference int0 = tc.appendIntPrimitive(10);
        VariableReference int1 = tc.appendIntPrimitive(20);
        tc.appendMethod(null, checkDoubleEquals, int0, int1);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test13() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_13();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)1L, (long)branch_conditions.size());
    }

    @Test
    public void test_input_14() {
        int int0 = Integer.MAX_VALUE;
        Integer integer0 = Boxer.boxInteger(int0);
        int int1 = Boxer.unboxInteger(integer0);
        Assertions.checkEquals(int0, int1);
    }

    private static DefaultTestCase build_test_input_14() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Method checkIntEquals = Assertions.class.getMethod("checkEquals", Integer.TYPE, Integer.TYPE);
        Method boxInteger = Boxer.class.getMethod("boxInteger", Integer.class);
        Method unboxInteger = Boxer.class.getMethod("unboxInteger", Integer.TYPE);
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference int0 = tc.appendIntPrimitive(Integer.MAX_VALUE);
        VariableReference integer0 = tc.appendMethod(null, boxInteger, int0);
        VariableReference int1 = tc.appendMethod(null, unboxInteger, integer0);
        tc.appendMethod(null, checkIntEquals, int0, int1);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test14() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_14();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)1L, (long)branch_conditions.size());
    }

    private static DefaultTestCase build_test_input_15() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Field one_fifth = Fraction.class.getField("ONE_FIFTH");
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference fraction0 = tc.appendStaticFieldStmt(one_fifth);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test15() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_15();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)0L, (long)branch_conditions.size());
    }

    private static DefaultTestCase build_test_input_16() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Method valueOf = Double.class.getMethod("valueOf", Double.TYPE);
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference double0 = tc.appendNull((Type)((Object)Double.class));
        VariableReference double1 = tc.appendMethod(null, valueOf, double0);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test16() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_16();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)0L, (long)branch_conditions.size());
    }

    private static DefaultTestCase build_test_input_17() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Method test = TestCase86.class.getMethod("test", Integer.TYPE);
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference int0 = tc.appendIntPrimitive(Integer.MAX_VALUE);
        tc.appendMethod(null, test, int0);
        return tc.getDefaultTestCase();
    }

    @Test
    public void test17() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        DefaultTestCase tc = SymbolicObserverTest.build_test_input_17();
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        Assert.assertEquals((long)1L, (long)branch_conditions.size());
    }

    public static abstract class Boxer {
        public static Integer boxInteger(Integer i) {
            return i;
        }

        public static int unboxInteger(int i) {
            return i;
        }
    }

    public static enum MyEnum {
        VALUE1,
        VALUE2;

    }

    public static abstract class StaticFields {
        public static String string_field;
        public static Object object_field;

        public static boolean equals(String left, String right) {
            return left.equals(right);
        }
    }

    public static class IntHolder {
        public int intValue;

        public IntHolder(int myInt) {
            this.intValue = myInt;
        }

        public int getValue() {
            return this.intValue;
        }
    }

    public static class StringHandler {
        private String str;

        public StringHandler(String str) {
            this.str = str;
        }

        public boolean equals(String otherString) {
            return this.str.equals(otherString);
        }

        public void toUpperCase() {
            this.str = this.str.toUpperCase();
        }

        public static boolean stringMatches(String string, String regex) {
            return string.matches(regex);
        }

        public static void checkEquals(boolean l, boolean r) {
            if (l != r) {
                throw new RuntimeException();
            }
        }
    }

    public static class Calculator {
        private final String operation;
        private static final String ADD = "add";
        private static final String SUB = "sub";
        private static final String DIV = "add";
        private static final String REM = "add";
        private static final String MUL = "add";

        public Calculator(String op) {
            this.operation = op;
        }

        public double compute(double l, double r) {
            if (this.operation.equals("add")) {
                return l + r;
            }
            if (this.operation.equals(SUB)) {
                return l - r;
            }
            if (this.operation.equals("add")) {
                return l / r;
            }
            if (this.operation.equals("add")) {
                return l % r;
            }
            if (this.operation.equals("add")) {
                return l * r;
            }
            return 0.0;
        }
    }

    public static class MemoryCell {
        private final int intVal;
        public MemoryCell anotherCell;

        public MemoryCell(int int0) {
            this.intVal = int0;
        }

        public int getValue() {
            return this.intVal;
        }
    }
}

