/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.ConcolicExecution;
import org.evosuite.symbolic.TestCaseBuilder;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.solver.ConstraintSolverTimeoutException;
import org.evosuite.symbolic.solver.search.EvoSuiteSolver;
import org.evosuite.symbolic.solver.search.TestInput1;
import org.evosuite.symbolic.solver.search.TestInput2;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.variable.VariableReference;
import org.junit.Assert;
import org.junit.Test;

public class TestConstraintSolver {
    private List<BranchCondition> executeTest(DefaultTestCase tc) {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000000;
        Properties.CONCOLIC_TIMEOUT = 5000000;
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        return branch_conditions;
    }

    private DefaultTestCase buildTestCase1() throws SecurityException, NoSuchMethodException {
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference int0 = tc.appendIntPrimitive(-15);
        VariableReference long0 = tc.appendLongPrimitive(Long.MAX_VALUE);
        VariableReference string0 = tc.appendStringPrimitive("Togliere sta roba");
        Method method = TestInput1.class.getMethod("test", Integer.TYPE, Long.TYPE, String.class);
        tc.appendMethod(null, method, int0, long0, string0);
        return tc.getDefaultTestCase();
    }

    @Test
    public void testCase1() throws SecurityException, NoSuchMethodException {
        DefaultTestCase tc = this.buildTestCase1();
        List<BranchCondition> branch_conditions = this.executeTest(tc);
        Assert.assertEquals((long)2L, (long)branch_conditions.size());
        try {
            Map<String, Object> model = this.executeSeeker(branch_conditions);
            Assert.assertNotNull(model);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    private Map<String, Object> executeSeeker(List<BranchCondition> branch_conditions) throws ConstraintSolverTimeoutException {
        int lastBranchIndex = branch_conditions.size() - 1;
        BranchCondition last_branch = branch_conditions.get(lastBranchIndex);
        LinkedList constraints = new LinkedList();
        constraints.addAll(last_branch.getReachingConstraints());
        Constraint lastConstraint = last_branch.getLocalConstraint();
        Constraint targetConstraint = lastConstraint.negate();
        constraints.add(targetConstraint);
        System.out.println("Target constraints");
        TestConstraintSolver.printConstraints(constraints);
        EvoSuiteSolver seeker = new EvoSuiteSolver();
        Map model = seeker.solve(constraints);
        if (model == null) {
            System.out.println("No new model was found");
        } else {
            System.out.println(model.toString());
        }
        return model;
    }

    private static void printConstraints(List<Constraint<?>> constraints) {
        for (Constraint<?> constraint : constraints) {
            System.out.println(constraint);
        }
    }

    private DefaultTestCase buildTestCase2() throws SecurityException, NoSuchMethodException {
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference int0 = tc.appendIntPrimitive(5);
        VariableReference int1 = tc.appendIntPrimitive(16);
        VariableReference int2 = tc.appendIntPrimitive(16);
        VariableReference int3 = tc.appendIntPrimitive(22);
        VariableReference int4 = tc.appendIntPrimitive(22);
        Method method = TestInput2.class.getMethod("test", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        tc.appendMethod(null, method, int0, int1, int2, int3, int4);
        return tc.getDefaultTestCase();
    }

    @Test
    public void testCase2() throws SecurityException, NoSuchMethodException {
        DefaultTestCase tc = this.buildTestCase2();
        List<BranchCondition> branch_conditions = this.executeTest(tc);
        Assert.assertEquals((long)57L, (long)branch_conditions.size());
        ArrayList<BranchCondition> sublist = new ArrayList<BranchCondition>();
        sublist.add(branch_conditions.get(0));
        sublist.add(branch_conditions.get(1));
        try {
            Map<String, Object> model = this.executeSeeker(sublist);
            Assert.assertNotNull(model);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }
}

