/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.search;

import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.StringConstraint;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.StringBinaryComparison;
import org.evosuite.symbolic.expr.bv.StringComparison;
import org.evosuite.symbolic.expr.str.StringConstant;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.search.StringAVM;
import org.evosuite.symbolic.vm.ExpressionFactory;
import org.junit.Test;

public class StringAVMTests {
    private List<Constraint<?>> getPatternConstraint(StringVariable var, String format) {
        StringConstant symb_regex = ExpressionFactory.buildNewStringConstant((String)format);
        StringBinaryComparison strComp = new StringBinaryComparison((Expression)symb_regex, Operator.PATTERNMATCHES, (Expression)var, Long.valueOf(0L));
        StringConstraint constraint = new StringConstraint((StringComparison)strComp, Comparator.NE, new IntegerConstant(0L));
        List<StringConstraint> constraints = Collections.singletonList(constraint);
        return constraints;
    }

    @Test
    public void testIssueWithOptional() {
        String name = "addd";
        StringVariable var = new StringVariable(name, "");
        String format = "a.?c";
        List<Constraint<?>> constraints = this.getPatternConstraint(var, format);
        StringAVM avm = new StringAVM(var, constraints);
        boolean succeded = avm.applyAVM();
        Assert.assertTrue((boolean)succeded);
    }

    @Test
    public void testSimpleRegexThreeDigits() {
        String name = "foo";
        StringVariable var = new StringVariable(name, "");
        String format = "\\d\\d\\d";
        List<Constraint<?>> constraints = this.getPatternConstraint(var, format);
        StringAVM avm = new StringAVM(var, constraints);
        boolean succeded = avm.applyAVM();
        Assert.assertTrue((boolean)succeded);
        String result = (String)var.getConcreteValue();
        Integer value = Integer.parseInt(result);
        Assert.assertTrue((String)("Value=" + result), (value >= 0 && value <= 999 ? 1 : 0) != 0);
    }

    @Test
    public void testInsertLeft() {
        String name = "foo";
        String start = "abc";
        StringVariable var = new StringVariable(name, start);
        String format = "\\d\\d\\d" + start;
        List<Constraint<?>> constraints = this.getPatternConstraint(var, format);
        StringAVM avm = new StringAVM(var, constraints);
        boolean succeded = avm.applyAVM();
        Assert.assertTrue((boolean)succeded);
        String result = (String)var.getConcreteValue();
        Assert.assertTrue((String)("Length=" + result.length()), (result.length() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((String)result, (boolean)result.endsWith(start));
    }

    @Test
    public void testInsertRight() {
        String name = "foo";
        String start = "abc";
        StringVariable var = new StringVariable(name, start);
        String format = start + "\\d\\d\\d";
        List<Constraint<?>> constraints = this.getPatternConstraint(var, format);
        StringAVM avm = new StringAVM(var, constraints);
        boolean succeded = avm.applyAVM();
        Assert.assertTrue((boolean)succeded);
        String result = (String)var.getConcreteValue();
        Assert.assertTrue((String)("Length=" + result.length()), (result.length() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((String)result, (boolean)result.startsWith(start));
    }
}

