/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.bv.IntegerBinaryExpression;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.bv.IntegerVariable;
import org.evosuite.symbolic.expr.bv.StringBinaryToIntegerExpression;
import org.evosuite.symbolic.expr.str.StringConstant;
import org.evosuite.symbolic.solver.ConstraintSolverTimeoutException;
import org.evosuite.symbolic.solver.search.EvoSuiteSolver;
import org.junit.Assert;
import org.junit.Test;

public class TestIntegerSearch {
    @Test
    public void testEQConstant() {
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", 0L, -1000000L, 1000000L), Comparator.EQ, (Expression)new IntegerConstant(235082L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertEquals((long)235082L, (long)((Number)result.get("test1")).intValue());
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testNEConstant() {
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", 235082L, -1000000L, 1000000L), Comparator.NE, (Expression)new IntegerConstant(235082L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertTrue((235082 != ((Number)result.get("test1")).intValue() ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testLEConstant() {
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", 235086L, -1000000L, 1000000L), Comparator.LE, (Expression)new IntegerConstant(235082L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertTrue((235082 >= ((Number)result.get("test1")).intValue() ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testLTConstant() {
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", 235086L, -1000000L, 1000000L), Comparator.LT, (Expression)new IntegerConstant(235082L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertTrue((235082 > ((Number)result.get("test1")).intValue() ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGEConstant() {
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", 0L, -1000000L, 1000000L), Comparator.GE, (Expression)new IntegerConstant(235082L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertTrue((235082 <= ((Number)result.get("test1")).intValue() ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGTConstant() {
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", 0L, -1000000L, 1000000L), Comparator.GT, (Expression)new IntegerConstant(235082L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertTrue((235082 < ((Number)result.get("test1")).intValue() ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEQVariable() {
        int var1 = 0;
        int var2 = 1;
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", (long)var1, -1000000L, 1000000L), Comparator.EQ, (Expression)new IntegerVariable("test2", (long)var2, -1000000L, 1000000L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).intValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).intValue();
            }
            Assert.assertEquals((long)var1, (long)var2);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testNEVariable() {
        int var1 = 1;
        int var2 = 1;
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", (long)var1, -1000000L, 1000000L), Comparator.NE, (Expression)new IntegerVariable("test2", (long)var2, -1000000L, 1000000L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).intValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).intValue();
            }
            Assert.assertTrue((var1 != var2 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testLEVariable() {
        int var1 = 2;
        int var2 = 1;
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", (long)var1, -1000000L, 1000000L), Comparator.LE, (Expression)new IntegerVariable("test2", (long)var2, -1000000L, 1000000L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).intValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).intValue();
            }
            Assert.assertTrue((var1 <= var2 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testLTVariable() {
        int var1 = 2;
        int var2 = 1;
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", (long)var1, -1000000L, 1000000L), Comparator.LT, (Expression)new IntegerVariable("test2", (long)var2, -1000000L, 1000000L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).intValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).intValue();
            }
            Assert.assertTrue((var1 < var2 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGEVariable() {
        int var1 = 0;
        int var2 = 1;
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", (long)var1, -1000000L, 1000000L), Comparator.GE, (Expression)new IntegerVariable("test2", (long)var2, -1000000L, 1000000L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).intValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).intValue();
            }
            Assert.assertTrue((var1 >= var2 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGTVariable() {
        int var1 = 0;
        int var2 = 1;
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", (long)var1, -1000000L, 1000000L), Comparator.GT, (Expression)new IntegerVariable("test2", (long)var2, -1000000L, 1000000L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).intValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).intValue();
            }
            Assert.assertTrue((var1 > var2 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEQArithmetic() {
        int var1 = 0;
        int var2 = 1;
        int var3 = 1;
        Assert.assertTrue((var1 != var2 + var3 ? 1 : 0) != 0);
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", (long)var1, -1000000L, 1000000L), Comparator.EQ, (Expression)new IntegerBinaryExpression((Expression)new IntegerVariable("test2", (long)var2, -1000000L, 1000000L), Operator.PLUS, (Expression)new IntegerVariable("test3", (long)var3, -1000000L, 1000000L), Long.valueOf(0L))));
        EvoSuiteSolver solver = new EvoSuiteSolver();
        try {
            Map result = solver.solve(constraints);
            Assert.assertNotNull((Object)result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).intValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).intValue();
            }
            if (result.containsKey("test3")) {
                var3 = ((Number)result.get("test3")).intValue();
            }
            Assert.assertTrue((var1 == var2 + var3 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testNEArithmetic() {
        int var1 = 2;
        int var2 = 1;
        int var3 = 1;
        Assert.assertTrue((var1 == var2 + var3 ? 1 : 0) != 0);
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", (long)var1, -1000000L, 1000000L), Comparator.NE, (Expression)new IntegerBinaryExpression((Expression)new IntegerVariable("test2", (long)var2, -1000000L, 1000000L), Operator.PLUS, (Expression)new IntegerVariable("test3", (long)var3, -1000000L, 1000000L), Long.valueOf(0L))));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).intValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).intValue();
            }
            if (result.containsKey("test3")) {
                var3 = ((Number)result.get("test3")).intValue();
            }
            Assert.assertTrue((var1 != var2 + var3 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testLEArithmetic() {
        int var1 = 3;
        int var2 = 1;
        int var3 = 1;
        Assert.assertTrue((var1 > var2 + var3 ? 1 : 0) != 0);
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", (long)var1, -1000000L, 1000000L), Comparator.LE, (Expression)new IntegerBinaryExpression((Expression)new IntegerVariable("test2", (long)var2, -1000000L, 1000000L), Operator.PLUS, (Expression)new IntegerVariable("test3", (long)var3, -1000000L, 1000000L), Long.valueOf(0L))));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).intValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).intValue();
            }
            if (result.containsKey("test3")) {
                var3 = ((Number)result.get("test3")).intValue();
            }
            Assert.assertTrue((var1 <= var2 + var3 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testLTArithmetic() {
        int var1 = 2;
        int var2 = 1;
        int var3 = 1;
        Assert.assertTrue((var1 >= var2 + var3 ? 1 : 0) != 0);
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", (long)var1, -1000000L, 1000000L), Comparator.LT, (Expression)new IntegerBinaryExpression((Expression)new IntegerVariable("test2", (long)var2, -1000000L, 1000000L), Operator.PLUS, (Expression)new IntegerVariable("test3", (long)var3, -1000000L, 1000000L), Long.valueOf(0L))));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).intValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).intValue();
            }
            if (result.containsKey("test3")) {
                var3 = ((Number)result.get("test3")).intValue();
            }
            Assert.assertTrue((var1 < var2 + var3 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGEArithmetic() {
        int var1 = 0;
        int var2 = 1;
        int var3 = 1;
        Assert.assertTrue((var1 < var2 + var3 ? 1 : 0) != 0);
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", (long)var1, -1000000L, 1000000L), Comparator.GT, (Expression)new IntegerBinaryExpression((Expression)new IntegerVariable("test2", (long)var2, -1000000L, 1000000L), Operator.PLUS, (Expression)new IntegerVariable("test3", (long)var3, -1000000L, 1000000L), Long.valueOf(0L))));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).intValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).intValue();
            }
            if (result.containsKey("test3")) {
                var3 = ((Number)result.get("test3")).intValue();
            }
            Assert.assertTrue((var1 >= var2 + var3 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGTArithmetic() {
        int var1 = 0;
        int var2 = 1;
        int var3 = 1;
        Assert.assertTrue((var1 <= var2 + var3 ? 1 : 0) != 0);
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", (long)var1, -1000000L, 1000000L), Comparator.GE, (Expression)new IntegerBinaryExpression((Expression)new IntegerVariable("test2", (long)var2, -1000000L, 1000000L), Operator.PLUS, (Expression)new IntegerVariable("test3", (long)var3, -1000000L, 1000000L), Long.valueOf(0L))));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).intValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).intValue();
            }
            if (result.containsKey("test3")) {
                var3 = ((Number)result.get("test3")).intValue();
            }
            Assert.assertTrue((var1 >= var2 + var3 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEvosuiteExample1() {
        int var1 = 1;
        int var2 = 1;
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", (long)var1, -1000000L, 1000000L), Comparator.LE, (Expression)new IntegerConstant(0L)));
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", (long)var1, -1000000L, 1000000L), Comparator.LT, (Expression)new IntegerVariable("test2", (long)var2, -1000000L, 1000000L)));
        constraints.add(new IntegerConstraint((Expression)new IntegerVariable("test1", (long)var1, -1000000L, 1000000L), Comparator.GE, (Expression)new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).intValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).intValue();
            }
            Assert.assertEquals((long)0L, (long)var1);
            Assert.assertTrue((var1 < var2 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEvosuiteExample3() {
        int var1 = 25721;
        int var2 = -1043;
        IntegerConstant iconst1 = new IntegerConstant(6860L);
        IntegerConstant iconst2 = new IntegerConstant(8275L);
        IntegerVariable ivar1 = new IntegerVariable("test1", (long)var1, Integer.MIN_VALUE, Integer.MAX_VALUE);
        IntegerVariable ivar2 = new IntegerVariable("test2", (long)var2, Integer.MIN_VALUE, Integer.MAX_VALUE);
        IntegerBinaryExpression sub = new IntegerBinaryExpression((Expression)ivar2, Operator.MINUS, (Expression)iconst1, Long.valueOf(-7903L));
        IntegerBinaryExpression mul = new IntegerBinaryExpression((Expression)ivar1, Operator.MUL, (Expression)sub, Long.valueOf(-203273063L));
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)mul, Comparator.EQ, (Expression)iconst2));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertFalse((boolean)result.isEmpty());
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).intValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).intValue();
            }
            Assert.assertTrue((var1 * (var2 - 6860) == 8275 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    private static IntegerValue mul(IntegerValue left, IntegerValue right) {
        int left_val = ((Long)left.getConcreteValue()).intValue();
        int right_val = ((Long)right.getConcreteValue()).intValue();
        return new IntegerBinaryExpression((Expression)left, Operator.MUL, (Expression)right, Long.valueOf((long)left_val * (long)right_val));
    }

    private static IntegerValue div(IntegerValue left, IntegerValue right) {
        int left_val = ((Long)left.getConcreteValue()).intValue();
        int right_val = ((Long)right.getConcreteValue()).intValue();
        return new IntegerBinaryExpression((Expression)left, Operator.DIV, (Expression)right, Long.valueOf((long)left_val / (long)right_val));
    }

    private static IntegerValue sub(IntegerValue left, IntegerValue right) {
        int left_val = ((Long)left.getConcreteValue()).intValue();
        int right_val = ((Long)right.getConcreteValue()).intValue();
        return new IntegerBinaryExpression((Expression)left, Operator.MINUS, (Expression)right, Long.valueOf((long)left_val - (long)right_val));
    }

    private static IntegerValue rem(IntegerValue left, IntegerValue right) {
        int left_val = ((Long)left.getConcreteValue()).intValue();
        int right_val = ((Long)right.getConcreteValue()).intValue();
        return new IntegerBinaryExpression((Expression)left, Operator.REM, (Expression)right, Long.valueOf((long)left_val % (long)right_val));
    }

    @Test
    public void testEvosuiteExample4_1() {
        IntegerVariable var24 = new IntegerVariable("var24", 21458L, Integer.MIN_VALUE, Integer.MAX_VALUE);
        IntegerVariable var10 = new IntegerVariable("var10", 1172L, Integer.MIN_VALUE, Integer.MAX_VALUE);
        IntegerVariable var14 = new IntegerVariable("var14", -1903L, Integer.MIN_VALUE, Integer.MAX_VALUE);
        IntegerConstant c_19072 = new IntegerConstant(19072L);
        IntegerConstant c_11060 = new IntegerConstant(11060L);
        IntegerValue left = TestIntegerSearch.mul(TestIntegerSearch.sub((IntegerValue)var24, TestIntegerSearch.div((IntegerValue)var10, (IntegerValue)var14)), (IntegerValue)c_19072);
        IntegerConstant right = c_11060;
        IntegerConstraint constr = new IntegerConstraint((Expression)left, Comparator.LT, (Expression)right);
        List<IntegerConstraint> constraints = Collections.singletonList(constr);
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            int v_24 = ((Number)result.get("var24")).intValue();
            int v_10 = ((Number)result.get("var10")).intValue();
            int v_14 = ((Number)result.get("var14")).intValue();
            Assert.assertTrue((v_24 - v_10 / v_14 * 19072 < 11060 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEvosuiteExample4_2() {
        IntegerVariable var20 = new IntegerVariable("var20", 17433L, Integer.MIN_VALUE, Integer.MAX_VALUE);
        IntegerVariable var39 = new IntegerVariable("var39", -1819L, Integer.MIN_VALUE, Integer.MAX_VALUE);
        IntegerVariable var40 = new IntegerVariable("var40", -1819L, Integer.MIN_VALUE, Integer.MAX_VALUE);
        IntegerConstant c_11060 = new IntegerConstant(11060L);
        IntegerConstant c_12089 = new IntegerConstant(12089L);
        IntegerConstant c_14414 = new IntegerConstant(14414L);
        IntegerValue left = TestIntegerSearch.sub(TestIntegerSearch.mul((IntegerValue)c_12089, (IntegerValue)var40), TestIntegerSearch.rem(TestIntegerSearch.mul((IntegerValue)var39, (IntegerValue)c_14414), (IntegerValue)var20));
        IntegerConstant right = c_11060;
        IntegerConstraint constr = new IntegerConstraint((Expression)left, Comparator.GT, (Expression)right);
        List<IntegerConstraint> constraints = Collections.singletonList(constr);
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            int v_20 = ((Number)result.get("var20")).intValue();
            int v_39 = ((Number)result.get("var39")).intValue();
            int v_40 = ((Number)result.get("var40")).intValue();
            Assert.assertTrue((12089 * v_40 - v_39 * 14414 % v_20 > 11060 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEvosuiteExample5() {
        int var1 = 84;
        int const1 = 115;
        int const2 = 108;
        String const3 = "y";
        IntegerConstant iconst1 = new IntegerConstant((long)const1);
        IntegerConstant iconst2 = new IntegerConstant((long)const2);
        StringConstant strConst = new StringConstant(const3);
        IntegerVariable ivar1 = new IntegerVariable("test1", (long)var1, Integer.MIN_VALUE, Integer.MAX_VALUE);
        StringBinaryToIntegerExpression sBExpr = new StringBinaryToIntegerExpression((Expression)strConst, Operator.CHARAT, (Expression)new IntegerConstant(0L), Long.valueOf("y".charAt(0)));
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)ivar1, Comparator.NE, (Expression)sBExpr));
        constraints.add(new IntegerConstraint((Expression)ivar1, Comparator.NE, (Expression)iconst1));
        constraints.add(new IntegerConstraint((Expression)ivar1, Comparator.EQ, (Expression)iconst2));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertFalse((boolean)result.isEmpty());
            var1 = ((Number)result.get("test1")).intValue();
            Assert.assertTrue((var1 == 108 ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEvosuiteExample6() {
        int x = -157;
        int y = 1890;
        IntegerVariable ivar1 = new IntegerVariable("test1", (long)x, Integer.MIN_VALUE, Integer.MAX_VALUE);
        IntegerVariable ivar2 = new IntegerVariable("test2", (long)y, Integer.MIN_VALUE, Integer.MAX_VALUE);
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(new IntegerConstraint((Expression)ivar2, Comparator.GE, (Expression)new IntegerConstant(0L)));
        constraints.add(new IntegerConstraint((Expression)ivar1, Comparator.LE, (Expression)new IntegerConstant(0L)));
        constraints.add(new IntegerConstraint((Expression)ivar2, Comparator.LE, (Expression)ivar1));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertFalse((boolean)result.isEmpty());
            if (result.containsKey("test1")) {
                x = ((Number)result.get("test1")).intValue();
            }
            if (result.containsKey("test2")) {
                y = ((Number)result.get("test2")).intValue();
            }
            Assert.assertTrue((y >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((x <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((y <= x ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }
}

