/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.search;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.StringConstraint;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.StringBinaryComparison;
import org.evosuite.symbolic.expr.bv.StringComparison;
import org.evosuite.symbolic.expr.str.StringConstant;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.DistanceEstimator;
import org.junit.Assert;
import org.junit.Test;

public class TestStringDistance {
    private static final double DELTA = 0.0;

    @Test
    public void testEquals() {
        String str1 = "abc";
        String str2 = "abcd";
        Collection<Constraint<?>> cnstr = this.createConstraints("abc", "abcd");
        double distance = DistanceEstimator.getDistance(cnstr);
        Assert.assertTrue((0.5 == distance ? 1 : 0) != 0);
    }

    @Test
    public void testEquals2() {
        String str1 = "abcd";
        String str2 = "abc";
        Collection<Constraint<?>> cnstr = this.createConstraints("abcd", "abc");
        double distance = DistanceEstimator.getDistance(cnstr);
        Assert.assertTrue((0.5 == distance ? 1 : 0) != 0);
    }

    @Test
    public void testEquals3() {
        String str1 = "abc";
        String str2 = "abcde";
        Collection<Constraint<?>> cnstr = this.createConstraints("abc", "abcde");
        double distance = DistanceEstimator.getDistance(cnstr);
        Assert.assertEquals((double)0.6666666666666666, (double)distance, (double)0.0);
    }

    @Test
    public void testEquals4() {
        String str1 = "abc";
        String str2 = "xbc";
        Collection<Constraint<?>> cnstr = this.createConstraints("abc", "xbc");
        double distance = DistanceEstimator.getDistance(cnstr);
        Assert.assertEquals((double)0.48936170212765956, (double)distance, (double)0.0);
    }

    @Test
    public void testEquals5() {
        String str1 = "abc";
        String str2 = "xbc";
        Collection<Constraint<?>> cnstr1 = this.createConstraints("abc", "xbc");
        double distance1 = DistanceEstimator.getDistance(cnstr1);
        String str3 = "abc";
        String str4 = "abcd";
        Collection<Constraint<?>> cnstr2 = this.createConstraints("abc", "abcd");
        double distance2 = DistanceEstimator.getDistance(cnstr2);
        Assert.assertTrue((distance1 < distance2 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals6() {
        String str1 = "abc";
        String str2 = "xbc";
        Collection<Constraint<?>> cnstr1 = this.createConstraints("abc", "xbc");
        double distance1 = DistanceEstimator.getDistance(cnstr1);
        String str3 = "abc";
        String str4 = "bbc";
        Collection<Constraint<?>> cnstr2 = this.createConstraints("abc", "bbc");
        double distance2 = DistanceEstimator.getDistance(cnstr2);
        Assert.assertTrue((distance2 < distance1 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals7() {
        String str1 = "s";
        String str2 = "test";
        Collection<Constraint<?>> cnstr1 = this.createConstraints("s", "test");
        double distance1 = DistanceEstimator.getDistance(cnstr1);
        String str3 = "t";
        String str4 = "test";
        Collection<Constraint<?>> cnstr2 = this.createConstraints("t", "test");
        double distance2 = DistanceEstimator.getDistance(cnstr2);
        Assert.assertTrue((distance1 > distance2 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals8() {
        String str1 = "test";
        String str2 = "est";
        Collection<Constraint<?>> cnstr1 = this.createConstraints("test", "est");
        double distance1 = DistanceEstimator.getDistance(cnstr1);
        String str3 = "test";
        String str4 = "estx";
        Collection<Constraint<?>> cnstr2 = this.createConstraints("test", "estx");
        double distance2 = DistanceEstimator.getDistance(cnstr2);
        Assert.assertTrue((distance1 > distance2 ? 1 : 0) != 0);
    }

    private Collection<Constraint<?>> createConstraints(String str1, String str2) {
        StringVariable var1 = new StringVariable("var0", str1);
        StringConstant const1 = new StringConstant(str2);
        StringBinaryComparison comp = new StringBinaryComparison((Expression)var1, Operator.EQUALS, (Expression)const1, Long.valueOf(0L));
        IntegerConstant zero = new IntegerConstant(0L);
        StringConstraint stringConstraint = new StringConstraint((StringComparison)comp, Comparator.NE, zero);
        List<StringConstraint> cnstr = Collections.singletonList(stringConstraint);
        return cnstr;
    }
}

