/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.search;

import java.util.ArrayList;
import java.util.Map;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.StringConstraint;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.StringBinaryComparison;
import org.evosuite.symbolic.expr.bv.StringBinaryToIntegerExpression;
import org.evosuite.symbolic.expr.bv.StringComparison;
import org.evosuite.symbolic.expr.bv.StringMultipleComparison;
import org.evosuite.symbolic.expr.str.StringConstant;
import org.evosuite.symbolic.expr.str.StringUnaryExpression;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.ConstraintSolverTimeoutException;
import org.evosuite.symbolic.solver.search.EvoSuiteSolver;
import org.junit.Assert;
import org.junit.Test;

public class TestStringSearch {
    @Test
    public void testEqualsTrueConstant() {
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        String var1 = "foo";
        String const2 = "test";
        StringVariable strVar = new StringVariable("test1", var1);
        StringConstant strConst = new StringConstant(const2);
        StringBinaryComparison strComp = new StringBinaryComparison((Expression)strVar, Operator.EQUALS, (Expression)strConst, Long.valueOf(0L));
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.NE, new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertTrue((boolean)const2.equals(result.get("test1").toString()));
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEqualsFalseConstant() {
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        String var1 = "foo";
        String const2 = "foo";
        StringVariable strVar = new StringVariable("test1", var1);
        StringConstant strConst = new StringConstant(const2);
        StringBinaryComparison strComp = new StringBinaryComparison((Expression)strVar, Operator.EQUALS, (Expression)strConst, Long.valueOf(0L));
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.EQ, new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertTrue((!const2.equals(result.get("test1").toString()) ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEqualsIgnoreCaseTrueConstant() {
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        String var1 = "foo";
        String const2 = "Fest";
        StringVariable strVar = new StringVariable("test1", var1);
        StringConstant strConst = new StringConstant(const2);
        StringBinaryComparison strComp = new StringBinaryComparison((Expression)strVar, Operator.EQUALSIGNORECASE, (Expression)strConst, Long.valueOf(0L));
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.NE, new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertTrue((boolean)const2.equalsIgnoreCase(result.get("test1").toString()));
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEqualsIgnoreCaseFalseConstant() {
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        String var1 = "foo";
        String const2 = "FOO";
        StringVariable strVar = new StringVariable("test1", var1);
        StringConstant strConst = new StringConstant(const2);
        StringBinaryComparison strComp = new StringBinaryComparison((Expression)strVar, Operator.EQUALSIGNORECASE, (Expression)strConst, Long.valueOf(0L));
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.EQ, new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertFalse((boolean)const2.equalsIgnoreCase(result.get("test1").toString()));
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testStartsWithTrueConstant() {
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        String var1 = "foo";
        String const2 = "test";
        StringVariable strVar = new StringVariable("test1", var1);
        StringConstant strConst = new StringConstant(const2);
        IntegerConstant offs_expr = new IntegerConstant(2L);
        ArrayList<IntegerConstant> other = new ArrayList<IntegerConstant>();
        other.add(offs_expr);
        StringMultipleComparison strComp = new StringMultipleComparison((Expression)strVar, Operator.STARTSWITH, (Expression)strConst, other, Long.valueOf(0L));
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.NE, new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertTrue((boolean)result.get("test1").toString().startsWith(const2, 2));
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testStartsWithFalseConstant() {
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        String var1 = "footest";
        String const2 = "test";
        StringVariable strVar = new StringVariable("test1", var1);
        StringConstant strConst = new StringConstant(const2);
        IntegerConstant offs_expr = new IntegerConstant(3L);
        ArrayList<IntegerConstant> other = new ArrayList<IntegerConstant>();
        other.add(offs_expr);
        StringMultipleComparison strComp = new StringMultipleComparison((Expression)strVar, Operator.STARTSWITH, (Expression)strConst, other, Long.valueOf(0L));
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.EQ, new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertFalse((boolean)result.get("test1").toString().startsWith(const2, 3));
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEndsWithTrueConstant() {
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        String var1 = "foo";
        String const2 = "test";
        StringVariable strVar = new StringVariable("test1", var1);
        StringConstant strConst = new StringConstant(const2);
        StringBinaryComparison strComp = new StringBinaryComparison((Expression)strVar, Operator.ENDSWITH, (Expression)strConst, Long.valueOf(0L));
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.NE, new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertTrue((boolean)result.get("test1").toString().endsWith(const2));
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEndsWithFalseConstant() {
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        String var1 = "footest";
        String const2 = "test";
        StringVariable strVar = new StringVariable("test1", var1);
        StringConstant strConst = new StringConstant(const2);
        StringBinaryComparison strComp = new StringBinaryComparison((Expression)strVar, Operator.ENDSWITH, (Expression)strConst, Long.valueOf(0L));
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.EQ, new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertFalse((boolean)result.get("test1").toString().endsWith(const2));
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testContainsTrueConstant() {
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        String var1 = "foo";
        String const2 = "test";
        StringVariable strVar = new StringVariable("test1", var1);
        StringConstant strConst = new StringConstant(const2);
        StringBinaryComparison strComp = new StringBinaryComparison((Expression)strVar, Operator.CONTAINS, (Expression)strConst, Long.valueOf(0L));
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.NE, new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertTrue((boolean)result.get("test1").toString().contains(const2));
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testContainsFalseConstant() {
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        String var1 = "fotesto";
        String const2 = "test";
        StringVariable strVar = new StringVariable("test1", var1);
        StringConstant strConst = new StringConstant(const2);
        StringBinaryComparison strComp = new StringBinaryComparison((Expression)strVar, Operator.CONTAINS, (Expression)strConst, Long.valueOf(0L));
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.EQ, new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertFalse((boolean)result.get("test1").toString().contains(const2));
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testRegionMatchesICTrueConstant() {
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        String var1 = "teXto";
        String const2 = "rtestooo";
        boolean ignore_case = true;
        int offset1 = 0;
        int offset2 = 1;
        int len = 4;
        StringVariable strVar = new StringVariable("test1", var1);
        StringConstant strConst = new StringConstant(const2);
        IntegerConstant len_expr = new IntegerConstant((long)len);
        IntegerConstant offs_one = new IntegerConstant((long)offset1);
        IntegerConstant offs_two = new IntegerConstant((long)offset2);
        IntegerConstant ign_case = new IntegerConstant(ignore_case ? 1L : 0L);
        ArrayList<IntegerConstant> other = new ArrayList<IntegerConstant>();
        other.add(offs_one);
        other.add(offs_two);
        other.add(len_expr);
        other.add(ign_case);
        StringMultipleComparison strComp = new StringMultipleComparison((Expression)strVar, Operator.REGIONMATCHES, (Expression)strConst, other, Long.valueOf(0L));
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.NE, new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertTrue((boolean)result.get("test1").toString().regionMatches(ignore_case, offset1, const2, offset2, len));
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testRegionMatchesICFalseConstant() {
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        String var1 = "foTESTo";
        String const2 = "rtestooo";
        boolean ignore_case = true;
        int offset1 = 2;
        int offset2 = 1;
        int len = 4;
        StringVariable strVar = new StringVariable("test1", var1);
        StringConstant strConst = new StringConstant(const2);
        IntegerConstant len_expr = new IntegerConstant((long)len);
        IntegerConstant offs_two = new IntegerConstant((long)offset2);
        IntegerConstant offs_one = new IntegerConstant((long)offset1);
        IntegerConstant ign_case = new IntegerConstant(ignore_case ? 1L : 0L);
        ArrayList<IntegerConstant> other = new ArrayList<IntegerConstant>();
        other.add(offs_one);
        other.add(offs_two);
        other.add(len_expr);
        other.add(ign_case);
        StringMultipleComparison strComp = new StringMultipleComparison((Expression)strVar, Operator.REGIONMATCHES, (Expression)strConst, other, Long.valueOf(0L));
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.EQ, new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertFalse((boolean)result.get("test1").toString().regionMatches(ignore_case, offset1, const2, offset2, len));
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testInversionOfRegex() {
        Map result;
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        String var = "a+";
        String regex = "aaa";
        Assert.assertFalse((boolean)var.matches(regex));
        String variableName = "test1";
        StringVariable strVar = new StringVariable(variableName, var);
        StringConstant strConst = new StringConstant(regex);
        StringBinaryComparison strComp = new StringBinaryComparison((Expression)strConst, Operator.PATTERNMATCHES, (Expression)strVar, Long.valueOf(0L));
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.NE, new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get(variableName));
            String solution = result.get(variableName).toString();
            Assert.assertTrue((boolean)solution.matches(regex));
            Assert.assertEquals((Object)regex, (Object)solution);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
        strVar = new StringVariable(variableName, regex);
        strConst = new StringConstant(var);
        Assert.assertTrue((boolean)regex.matches(var));
        strComp = new StringBinaryComparison((Expression)strConst, Operator.PATTERNMATCHES, (Expression)strVar, Long.valueOf(0L));
        constraints.clear();
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.NE, new IntegerConstant(0L)));
        try {
            result = skr.solve(constraints);
            Assert.assertNull((Object)result);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testRegexMatchesTrue() {
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        String var1 = "test";
        String const2 = "TEST";
        StringVariable strVar = new StringVariable("test1", var1);
        StringConstant strConst = new StringConstant(const2);
        StringBinaryComparison strComp = new StringBinaryComparison((Expression)strVar, Operator.PATTERNMATCHES, (Expression)strConst, Long.valueOf(0L));
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.NE, new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertTrue((boolean)result.get("test1").toString().matches(const2));
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testChopOffIndexOfC() {
        String var1value = "D<E\u001exqaa:saksajij1\u00a7n";
        StringVariable var1 = new StringVariable("var1", var1value);
        IntegerConstant colon_code = new IntegerConstant(58L);
        IntegerConstant minus_one = new IntegerConstant(-1L);
        int colon_int_code = 58;
        int concrete_value = var1value.indexOf(colon_int_code);
        StringBinaryToIntegerExpression index_of_colon = new StringBinaryToIntegerExpression((Expression)var1, Operator.INDEXOFC, (Expression)colon_code, Long.valueOf(concrete_value));
        IntegerConstraint constr1 = new IntegerConstraint((Expression)index_of_colon, Comparator.EQ, (Expression)minus_one);
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(constr1);
        EvoSuiteSolver solver = new EvoSuiteSolver();
        try {
            Map solution = solver.solve(constraints);
            Assert.assertNotNull((Object)solution);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testInsertIndexOfC() {
        String var1value = "D<E\u001exqaasaksajij1\u00a7n";
        StringVariable var1 = new StringVariable("var1", var1value);
        IntegerConstant colon_code = new IntegerConstant(58L);
        IntegerConstant minus_one = new IntegerConstant(-1L);
        int colon_int_code = 58;
        int concrete_value = var1value.indexOf(colon_int_code);
        StringBinaryToIntegerExpression index_of_colon = new StringBinaryToIntegerExpression((Expression)var1, Operator.INDEXOFC, (Expression)colon_code, Long.valueOf(concrete_value));
        IntegerConstraint constr1 = new IntegerConstraint((Expression)index_of_colon, Comparator.NE, (Expression)minus_one);
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(constr1);
        EvoSuiteSolver solver = new EvoSuiteSolver();
        try {
            Map solution = solver.solve(constraints);
            Assert.assertNotNull((Object)solution);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testIndexOfC() {
        String var1value = "D<E\u001e";
        StringVariable var1 = new StringVariable("var1", var1value);
        IntegerConstant colon_code = new IntegerConstant(35L);
        IntegerConstant numeral_code = new IntegerConstant(58L);
        IntegerConstant minus_one = new IntegerConstant(-1L);
        StringBinaryToIntegerExpression index_of_colon = new StringBinaryToIntegerExpression((Expression)var1, Operator.INDEXOFC, (Expression)colon_code, Long.valueOf(-1L));
        StringBinaryToIntegerExpression index_of_numeral = new StringBinaryToIntegerExpression((Expression)var1, Operator.INDEXOFC, (Expression)numeral_code, Long.valueOf(-1L));
        IntegerConstraint constr1 = new IntegerConstraint((Expression)index_of_colon, Comparator.EQ, (Expression)minus_one);
        IntegerConstraint constr2 = new IntegerConstraint((Expression)index_of_numeral, Comparator.NE, (Expression)minus_one);
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(constr1);
        constraints.add(constr2);
        EvoSuiteSolver solver = new EvoSuiteSolver();
        try {
            Map solution = solver.solve(constraints);
            Assert.assertNotNull((Object)solution);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testRegexMatchesFalse() {
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        String var1 = "testsomestring";
        String const2 = "testsomestring";
        StringVariable strVar = new StringVariable("test1", var1);
        StringConstant strConst = new StringConstant(const2);
        StringBinaryComparison strComp = new StringBinaryComparison((Expression)strVar, Operator.PATTERNMATCHES, (Expression)strConst, Long.valueOf(0L));
        constraints.add(new StringConstraint((StringComparison)strComp, Comparator.EQ, new IntegerConstant(0L)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map result = skr.solve(constraints);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull(result.get("test1"));
            Assert.assertFalse((String)("Result should not match TEST: " + result.get("test1").toString()), (boolean)result.get("test1").toString().matches(const2));
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEqualsToLowerCase() {
        StringVariable var1 = new StringVariable("var1", "f|");
        StringBinaryComparison cmp3 = new StringBinaryComparison((Expression)new StringConstant("wed"), Operator.EQUALS, (Expression)new StringUnaryExpression((Expression)var1, Operator.TOLOWERCASE, "f|".toLowerCase()), Long.valueOf(0L));
        StringConstraint constr3 = new StringConstraint((StringComparison)cmp3, Comparator.NE, new IntegerConstant(0L));
        ArrayList<StringConstraint> constraints = new ArrayList<StringConstraint>();
        constraints.add(constr3);
        EvoSuiteSolver solver = new EvoSuiteSolver();
        try {
            Map solution = solver.solve(constraints);
            Assert.assertNotNull((Object)solution);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testIndexOfC2() {
        String var1value = ":cc]#0l";
        StringVariable var1 = new StringVariable("var0", var1value);
        IntegerConstant colon_code = new IntegerConstant(58L);
        IntegerConstant numeral_code = new IntegerConstant(35L);
        IntegerConstant minus_one = new IntegerConstant(-1L);
        StringBinaryToIntegerExpression index_of_colon = new StringBinaryToIntegerExpression((Expression)var1, Operator.INDEXOFC, (Expression)colon_code, Long.valueOf(-1L));
        StringBinaryToIntegerExpression index_of_numeral = new StringBinaryToIntegerExpression((Expression)var1, Operator.INDEXOFC, (Expression)numeral_code, Long.valueOf(-1L));
        IntegerConstraint constr1 = new IntegerConstraint((Expression)index_of_colon, Comparator.NE, (Expression)minus_one);
        IntegerConstraint constr2 = new IntegerConstraint((Expression)index_of_numeral, Comparator.NE, (Expression)minus_one);
        IntegerConstraint constr3 = new IntegerConstraint((Expression)index_of_numeral, Comparator.LT, (Expression)index_of_colon);
        ArrayList<IntegerConstraint> constraints = new ArrayList<IntegerConstraint>();
        constraints.add(constr1);
        constraints.add(constr2);
        constraints.add(constr3);
        EvoSuiteSolver solver = new EvoSuiteSolver();
        Map solution = null;
        try {
            int TRIES = 20;
            for (int i = 0; i < 20 && (solution = solver.solve(constraints)) == null; ++i) {
            }
            Assert.assertNotNull(solution);
            String result = solution.get("var0").toString();
            int colonPos = result.indexOf(58);
            int numeralPos = result.indexOf(35);
            Assert.assertTrue((String)("Colon not found in " + result), (colonPos >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Numeral not found in " + result), (numeralPos >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((colonPos > numeralPos ? 1 : 0) != 0);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }
}

