/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.search;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.ConcolicExecution;
import org.evosuite.symbolic.SymbolicObserverTest;
import org.evosuite.symbolic.TestCaseBuilder;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.solver.ConstraintSolverTimeoutException;
import org.evosuite.symbolic.solver.search.EvoSuiteSolver;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.variable.VariableReference;
import org.junit.Assert;
import org.junit.Test;

public class TestStringSearch2 {
    private static int getFragmentLocation(String s) {
        int fragmentLocation = s.indexOf(35);
        if (fragmentLocation == -1) {
            return s.length();
        }
        return fragmentLocation;
    }

    public static void checkPathURN(String nuri) {
        String uri = nuri;
        int colonLocation = nuri.indexOf(58);
        int fragmentLocation = TestStringSearch2.getFragmentLocation(nuri);
        if (colonLocation == -1 || colonLocation > fragmentLocation || colonLocation == 0) {
            throw new RuntimeException("No scheme in URI \"" + uri + "\"");
        }
        String nurn = nuri;
        int secondColonLocation = nurn.indexOf(58, colonLocation + 1);
        if (secondColonLocation == -1 || secondColonLocation > fragmentLocation || secondColonLocation == colonLocation + 1) {
            throw new RuntimeException("No protocol part in URN \"" + nurn + "\".");
        }
        if (!nurn.regionMatches(0, "urn", 0, colonLocation)) {
            throw new RuntimeException("The identifier was no URN \"" + nurn + "\".");
        }
        if (uri.length() == secondColonLocation + 1) {
            throw new RuntimeException("Empty Path URN");
        }
        if (uri.charAt(secondColonLocation + 1) != '/') {
            throw new RuntimeException("Path URN has no '/': \"" + uri + "\"");
        }
        if (!uri.regionMatches(colonLocation + 1, "path", 0, secondColonLocation - colonLocation - 1)) {
            throw new RuntimeException("The identifier was no Path URN \"" + uri + "\".");
        }
    }

    @Test
    public void testValidPathURN() {
        String pathURN = "urn:path:/A/B/C/doc.html#gilada";
        TestStringSearch2.checkPathURN(pathURN);
    }

    @Test
    public void testValidPathURN2() {
        String pathURN = "u:path:/";
        TestStringSearch2.checkPathURN(pathURN);
    }

    @Test
    public void testInvalidPathURN() {
        try {
            String pathURN = "urn:paxth:/A/B/C/doc.html#gilada";
            TestStringSearch2.checkPathURN(pathURN);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private DefaultTestCase buildTestCase(String stringVal) throws SecurityException, NoSuchMethodException {
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference string0 = tc.appendStringPrimitive(stringVal);
        Method method = TestStringSearch2.class.getMethod("checkPathURN", String.class);
        tc.appendMethod(null, method, string0);
        return tc.getDefaultTestCase();
    }

    private List<BranchCondition> executeTest(DefaultTestCase tc) {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000;
        Properties.CONCOLIC_TIMEOUT = 5000000;
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        return branch_conditions;
    }

    @Test
    public void testCreatePathConstraint() throws SecurityException, NoSuchMethodException {
        DefaultTestCase tc = this.buildTestCase("urn:pBth:/A/B/C/doc.html#gilada");
        List<BranchCondition> branch_conditions = this.executeTest(tc);
        Assert.assertEquals((long)11L, (long)branch_conditions.size());
    }

    @Test
    public void testSolvePathConstraint() throws SecurityException, NoSuchMethodException {
        DefaultTestCase tc = this.buildTestCase("urn:pBth:/A/B/C/doc.html#gilada");
        List<BranchCondition> branch_conditions = this.executeTest(tc);
        BranchCondition last_branch = branch_conditions.get(branch_conditions.size() - 1);
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        constraints.addAll(last_branch.getReachingConstraints());
        constraints.add(last_branch.getLocalConstraint().negate());
        EvoSuiteSolver solver = new EvoSuiteSolver();
        try {
            Map solution = solver.solve(constraints);
            Assert.assertNotNull((Object)solution);
            System.out.println(solution);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testSolveIndexOfConstant() throws SecurityException, NoSuchMethodException {
        DefaultTestCase tc = this.buildTestCase("V*X-:o%tp");
        List<BranchCondition> branch_conditions = this.executeTest(tc);
        BranchCondition last_branch = branch_conditions.get(branch_conditions.size() - 2);
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        constraints.addAll(last_branch.getReachingConstraints());
        constraints.add(last_branch.getLocalConstraint().negate());
        EvoSuiteSolver solver = new EvoSuiteSolver();
        try {
            Map solution = solver.solve(constraints);
            Assert.assertNotNull((Object)solution);
            System.out.println(solution);
        }
        catch (ConstraintSolverTimeoutException e) {
            Assert.fail();
        }
    }
}

