/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.junit.Assert;
import org.junit.Test;

public class TestSerialization {
    @Test
    public void testSerializationEmptyTest() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        double fitness = 3.14;
        TestChromosome chromosome = new TestChromosome();
        chromosome.setFitness(null, fitness);
        oos.writeObject(chromosome);
        byte[] baSerialized = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baSerialized);
        ObjectInputStream ois = new ObjectInputStream(bais);
        TestChromosome copy = (TestChromosome)ois.readObject();
        Assert.assertEquals((double)chromosome.getFitness(), (double)copy.getFitness(), (double)0.0);
    }

    @Test
    public void testSerializationNonEmptyTest() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        double fitness = 0.9950513142057124;
        TestChromosome chromosome = new TestChromosome();
        DefaultTestCase test = new DefaultTestCase();
        PrimitiveStatement statement = PrimitiveStatement.getPrimitiveStatement((TestCase)test, Integer.TYPE);
        test.addStatement((Statement)statement);
        chromosome.setTestCase((TestCase)test);
        chromosome.setFitness(null, fitness);
        oos.writeObject(chromosome);
        byte[] baSerialized = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baSerialized);
        ObjectInputStream ois = new ObjectInputStream(bais);
        TestChromosome copy = (TestChromosome)ois.readObject();
        Assert.assertEquals((double)chromosome.getFitness(), (double)copy.getFitness(), (double)0.0);
    }
}

