/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite;

import com.examples.with.different.packagename.FlagExample1;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.coverage.branch.BranchCoverageFactory;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.coverage.dataflow.DefUseCoverageFactory;
import org.evosuite.coverage.dataflow.DefUseCoverageSuiteFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.runtime.reset.ResetManager;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.numeric.IntPrimitiveStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteMinimizer;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.GenericConstructor;
import org.evosuite.utils.GenericMethod;
import org.evosuite.utils.Randomness;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTestSuiteMinimizer {
    private static java.util.Properties currentProperties;

    @Before
    public void setUp() {
        Properties.getInstance().resetToDefaults();
        Randomness.setSeed((long)42L);
        Properties.TARGET_CLASS = "";
        TestGenerationContext.getInstance().resetContext();
        ResetManager.getInstance().clearManager();
        Randomness.setSeed((long)42L);
        currentProperties = (java.util.Properties)System.getProperties().clone();
    }

    @After
    public void tearDown() {
        TestGenerationContext.getInstance().resetContext();
        ResetManager.getInstance().clearManager();
        System.setProperties(currentProperties);
        Properties.getInstance().resetToDefaults();
    }

    @Test
    public void minimizeEmptySuite() throws ClassNotFoundException {
        DefaultTestCase test = new DefaultTestCase();
        TestSuiteChromosome tsc = new TestSuiteChromosome();
        tsc.addTest((TestCase)test);
        BranchCoverageSuiteFitness ff = new BranchCoverageSuiteFitness();
        double previous_fitness = ff.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)ff, previous_fitness);
        Assert.assertEquals((double)previous_fitness, (double)0.0, (double)0.0);
        TestSuiteMinimizer minimizer = new TestSuiteMinimizer((TestFitnessFactory)new BranchCoverageFactory());
        minimizer.minimize(tsc, false);
        Assert.assertTrue((tsc.getTestChromosomes().size() == 0 ? 1 : 0) != 0);
        double fitness = ff.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_fitness, (double)fitness, (double)0.0);
    }

    @Test
    public void minimizeSuiteOnlyWithVariables() {
        DefaultTestCase test = new DefaultTestCase();
        for (int i = 0; i < 10; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(i));
            test.addStatement((Statement)ips);
        }
        Assert.assertEquals((long)10L, (long)test.size());
        TestSuiteChromosome tsc = new TestSuiteChromosome();
        tsc.addTest((TestCase)test);
        BranchCoverageSuiteFitness ff = new BranchCoverageSuiteFitness();
        double previous_fitness = ff.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)ff, previous_fitness);
        Assert.assertEquals((double)previous_fitness, (double)0.0, (double)0.0);
        TestSuiteMinimizer minimizer = new TestSuiteMinimizer((TestFitnessFactory)new BranchCoverageFactory());
        minimizer.minimize(tsc, false);
        Assert.assertTrue((tsc.getTestChromosomes().size() == 0 ? 1 : 0) != 0);
        double fitness = ff.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_fitness, (double)fitness, (double)0.0);
    }

    @Test
    public void minimizeSuiteHalfCoverage() throws ClassNotFoundException, NoSuchFieldException, SecurityException, ConstructionFailedException, NoSuchMethodException {
        Properties.TARGET_CLASS = FlagExample1.class.getCanonicalName();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(Properties.TARGET_CLASS);
        GenericClass clazz = new GenericClass(sut);
        DefaultTestCase test = new DefaultTestCase();
        GenericConstructor gc = new GenericConstructor(clazz.getRawClass().getConstructors()[0], clazz);
        TestFactory testFactory = TestFactory.getInstance();
        testFactory.addConstructor((TestCase)test, gc, 0, 0);
        ArrayList<VariableReference> parameters = new ArrayList<VariableReference>();
        for (int i = 0; i < 10; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(28234 + i));
            VariableReference vr = test.addStatement((Statement)ips, i + 1);
            parameters.add(vr);
        }
        ConstructorStatement ct = new ConstructorStatement((TestCase)test, gc, parameters);
        Method m = clazz.getRawClass().getMethod("testMe", Integer.TYPE);
        GenericMethod method = new GenericMethod(m, sut);
        testFactory.addMethod((TestCase)test, method, 11, 0);
        Assert.assertEquals((long)12L, (long)test.size());
        TestSuiteChromosome tsc = new TestSuiteChromosome();
        tsc.addTest((TestCase)test);
        BranchCoverageSuiteFitness ff = new BranchCoverageSuiteFitness();
        double previous_fitness = ff.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)ff, previous_fitness);
        Assert.assertEquals((double)previous_fitness, (double)2.0, (double)0.0);
        TestSuiteMinimizer minimizer = new TestSuiteMinimizer((TestFitnessFactory)new BranchCoverageFactory());
        minimizer.minimize(tsc, false);
        System.out.println(((TestCase)tsc.getTests().get(0)).toCode());
        Assert.assertTrue((boolean)((TestCase)tsc.getTests().get(0)).toCode().equals("FlagExample1 flagExample1_0 = new FlagExample1();\nint int0 = 28234;\nboolean boolean0 = flagExample1_0.testMe(int0);\n"));
        double fitness = ff.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_fitness, (double)fitness, (double)0.0);
    }

    @Test
    public void minimizeSuiteHalfCoverageWithTwoFitnessFunctions() throws ClassNotFoundException, ConstructionFailedException, NoSuchMethodException, SecurityException {
        Properties.TARGET_CLASS = FlagExample1.class.getCanonicalName();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(Properties.TARGET_CLASS);
        GenericClass clazz = new GenericClass(sut);
        DefaultTestCase test = new DefaultTestCase();
        GenericConstructor gc = new GenericConstructor(clazz.getRawClass().getConstructors()[0], clazz);
        TestFactory testFactory = TestFactory.getInstance();
        testFactory.addConstructor((TestCase)test, gc, 0, 0);
        ArrayList<VariableReference> parameters = new ArrayList<VariableReference>();
        for (int i = 0; i < 10; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(28234 + i));
            VariableReference vr = test.addStatement((Statement)ips, i + 1);
            parameters.add(vr);
        }
        ConstructorStatement ct = new ConstructorStatement((TestCase)test, gc, parameters);
        Method m = clazz.getRawClass().getMethod("testMe", Integer.TYPE);
        GenericMethod method = new GenericMethod(m, sut);
        testFactory.addMethod((TestCase)test, method, 11, 0);
        Assert.assertEquals((long)12L, (long)test.size());
        TestSuiteChromosome tsc = new TestSuiteChromosome();
        tsc.addTest((TestCase)test);
        BranchCoverageSuiteFitness branch = new BranchCoverageSuiteFitness();
        double previous_branch_fitness = branch.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)branch, previous_branch_fitness);
        Assert.assertEquals((double)previous_branch_fitness, (double)2.0, (double)0.0);
        DefUseCoverageSuiteFitness defuse = new DefUseCoverageSuiteFitness();
        double previous_defuse_fitness = defuse.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)defuse, previous_defuse_fitness);
        Assert.assertEquals((double)previous_defuse_fitness, (double)0.0, (double)0.0);
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new BranchCoverageFactory());
        factories.add(new DefUseCoverageFactory());
        TestSuiteMinimizer minimizer = new TestSuiteMinimizer(factories);
        minimizer.minimize(tsc, false);
        System.out.println(((TestCase)tsc.getTests().get(0)).toCode());
        Assert.assertTrue((boolean)((TestCase)tsc.getTests().get(0)).toCode().equals("FlagExample1 flagExample1_0 = new FlagExample1();\nint int0 = 28234;\nboolean boolean0 = flagExample1_0.testMe(int0);\n"));
        double branch_fitness = branch.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_branch_fitness, (double)branch_fitness, (double)0.0);
        double defuse_fitness = defuse.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_defuse_fitness, (double)defuse_fitness, (double)0.0);
    }

    @Test
    public void minimizeSuiteFullCoverage() throws ClassNotFoundException, NoSuchFieldException, SecurityException, ConstructionFailedException, NoSuchMethodException {
        Properties.TARGET_CLASS = FlagExample1.class.getCanonicalName();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(Properties.TARGET_CLASS);
        GenericClass clazz = new GenericClass(sut);
        DefaultTestCase test = new DefaultTestCase();
        GenericConstructor gc = new GenericConstructor(clazz.getRawClass().getConstructors()[0], clazz);
        TestFactory testFactory = TestFactory.getInstance();
        testFactory.addConstructor((TestCase)test, gc, 0, 0);
        ArrayList<VariableReference> parameters = new ArrayList<VariableReference>();
        for (int i = 0; i < 10; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(28234 + i));
            VariableReference vr = test.addStatement((Statement)ips, i + 1);
            parameters.add(vr);
        }
        ConstructorStatement ct = new ConstructorStatement((TestCase)test, gc, parameters);
        Method m = clazz.getRawClass().getMethod("testMe", Integer.TYPE);
        GenericMethod method = new GenericMethod(m, sut);
        testFactory.addMethod((TestCase)test, method, 11, 0);
        parameters = new ArrayList();
        for (int i = 12; i < 15; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(i));
            VariableReference vr = test.addStatement((Statement)ips, i);
            parameters.add(vr);
        }
        ct = new ConstructorStatement((TestCase)test, gc, parameters);
        testFactory.addMethod((TestCase)test, method, 15, 0);
        Assert.assertEquals((long)16L, (long)test.size());
        TestSuiteChromosome tsc = new TestSuiteChromosome();
        tsc.addTest((TestCase)test);
        BranchCoverageSuiteFitness ff = new BranchCoverageSuiteFitness();
        double previous_fitness = ff.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)ff, previous_fitness);
        Assert.assertEquals((double)previous_fitness, (double)0.0, (double)0.0);
        TestSuiteMinimizer minimizer = new TestSuiteMinimizer((TestFitnessFactory)new BranchCoverageFactory());
        minimizer.minimize(tsc, false);
        Assert.assertTrue((boolean)((TestCase)tsc.getTests().get(0)).toCode().equals("FlagExample1 flagExample1_0 = new FlagExample1();\nint int0 = 28234;\nint int1 = 28241;\nboolean boolean0 = flagExample1_0.testMe(int1);\nboolean boolean1 = flagExample1_0.testMe(int0);\n"));
        double fitness = ff.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_fitness, (double)fitness, (double)0.0);
    }

    @Test
    public void minimizeSuiteFullCoverageWithTwoFitnessFunctions() throws ClassNotFoundException, NoSuchFieldException, SecurityException, ConstructionFailedException, NoSuchMethodException {
        Properties.TARGET_CLASS = FlagExample1.class.getCanonicalName();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(Properties.TARGET_CLASS);
        GenericClass clazz = new GenericClass(sut);
        DefaultTestCase test = new DefaultTestCase();
        GenericConstructor gc = new GenericConstructor(clazz.getRawClass().getConstructors()[0], clazz);
        TestFactory testFactory = TestFactory.getInstance();
        testFactory.addConstructor((TestCase)test, gc, 0, 0);
        ArrayList<VariableReference> parameters = new ArrayList<VariableReference>();
        for (int i = 0; i < 10; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(28234 + i));
            VariableReference vr = test.addStatement((Statement)ips, i + 1);
            parameters.add(vr);
        }
        ConstructorStatement ct = new ConstructorStatement((TestCase)test, gc, parameters);
        Method m = clazz.getRawClass().getMethod("testMe", Integer.TYPE);
        GenericMethod method = new GenericMethod(m, sut);
        testFactory.addMethod((TestCase)test, method, 11, 0);
        parameters = new ArrayList();
        for (int i = 12; i < 15; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(i));
            VariableReference vr = test.addStatement((Statement)ips, i);
            parameters.add(vr);
        }
        ct = new ConstructorStatement((TestCase)test, gc, parameters);
        testFactory.addMethod((TestCase)test, method, 15, 0);
        Assert.assertEquals((long)16L, (long)test.size());
        TestSuiteChromosome tsc = new TestSuiteChromosome();
        tsc.addTest((TestCase)test);
        BranchCoverageSuiteFitness branch = new BranchCoverageSuiteFitness();
        double previous_branch_fitness = branch.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)branch, previous_branch_fitness);
        Assert.assertEquals((double)previous_branch_fitness, (double)0.0, (double)0.0);
        DefUseCoverageSuiteFitness defuse = new DefUseCoverageSuiteFitness();
        double previous_defuse_fitness = defuse.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)defuse, previous_defuse_fitness);
        Assert.assertEquals((double)previous_defuse_fitness, (double)0.0, (double)0.0);
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new BranchCoverageFactory());
        factories.add(new DefUseCoverageFactory());
        TestSuiteMinimizer minimizer = new TestSuiteMinimizer(factories);
        minimizer.minimize(tsc, false);
        System.out.println(((TestCase)tsc.getTests().get(0)).toCode());
        Assert.assertTrue((boolean)((TestCase)tsc.getTests().get(0)).toCode().equals("FlagExample1 flagExample1_0 = new FlagExample1();\nint int0 = 28234;\nint int1 = 28241;\nboolean boolean0 = flagExample1_0.testMe(int1);\nboolean boolean1 = flagExample1_0.testMe(int0);\n"));
        double branch_fitness = branch.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_branch_fitness, (double)branch_fitness, (double)0.0);
        double defuse_fitness = defuse.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_defuse_fitness, (double)defuse_fitness, (double)0.0);
    }
}

