/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import com.examples.with.different.packagename.generic.AbstractGenericClass;
import com.examples.with.different.packagename.generic.ConcreteGenericClass;
import com.examples.with.different.packagename.generic.GenericClassTwoParameters;
import com.examples.with.different.packagename.generic.GenericClassWithGenericMethodAndSubclass;
import com.examples.with.different.packagename.generic.GenericMethodAlternativeBounds;
import com.examples.with.different.packagename.generic.GenericMethodReturningTypeVariable;
import com.examples.with.different.packagename.generic.GenericMethodWithBounds;
import com.examples.with.different.packagename.generic.GenericParameters8;
import com.examples.with.different.packagename.generic.GuavaExample3;
import com.examples.with.different.packagename.generic.GuavaExample4;
import com.googlecode.gentyref.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.Inspector;
import org.evosuite.assertion.InspectorAssertion;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.instrumentation.InstrumentingClassLoader;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.numeric.IntPrimitiveStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.GenericConstructor;
import org.evosuite.utils.GenericMethod;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericAccessibleObject {
    @Test
    public void testGenericMethod() throws SecurityException, NoSuchMethodException, ConstructionFailedException {
        Class<com.examples.with.different.packagename.generic.GenericMethod> targetClass = com.examples.with.different.packagename.generic.GenericMethod.class;
        Method targetMethod = targetClass.getMethod("coverMe", Object.class);
        GenericMethod genericMethod = new GenericMethod(targetMethod, targetClass);
        Assert.assertFalse((boolean)genericMethod.getOwnerClass().hasTypeVariables());
        List parameters = genericMethod.getParameterClasses();
        Assert.assertFalse((boolean)((GenericClass)parameters.get(0)).hasTypeVariables());
        Assert.assertTrue((boolean)((GenericClass)parameters.get(0)).hasWildcardTypes());
        GenericMethod instantiatedMethod = (GenericMethod)genericMethod.getGenericInstantiation();
        parameters = instantiatedMethod.getParameterClasses();
        Assert.assertFalse((boolean)((GenericClass)parameters.get(0)).hasTypeVariables());
        Assert.assertFalse((boolean)((GenericClass)parameters.get(0)).hasWildcardTypes());
    }

    @Test
    public void testGenericMethodWithBounds() throws SecurityException, NoSuchMethodException, ConstructionFailedException {
        Class<GenericMethodWithBounds> targetClass = GenericMethodWithBounds.class;
        Method targetMethod = targetClass.getMethod("is", Comparable.class);
        GenericMethod genericMethod = new GenericMethod(targetMethod, targetClass);
        Assert.assertFalse((boolean)genericMethod.getOwnerClass().hasTypeVariables());
        List parameters = genericMethod.getParameterClasses();
        Assert.assertFalse((boolean)((GenericClass)parameters.get(0)).hasTypeVariables());
        Assert.assertTrue((boolean)((GenericClass)parameters.get(0)).hasWildcardTypes());
        Assert.assertTrue((boolean)genericMethod.getGeneratedClass().hasWildcardTypes());
        GenericMethod instantiatedMethod = (GenericMethod)genericMethod.getGenericInstantiation();
        parameters = instantiatedMethod.getParameterClasses();
        Assert.assertFalse((boolean)((GenericClass)parameters.get(0)).hasTypeVariables());
        Assert.assertFalse((boolean)((GenericClass)parameters.get(0)).hasWildcardTypes());
        Assert.assertFalse((boolean)instantiatedMethod.getGeneratedClass().hasWildcardTypes());
    }

    @Test
    public void testGenericMethodAlternativeBounds() throws NoSuchMethodException, RuntimeException, ClassNotFoundException {
        Class<GenericMethodAlternativeBounds> targetClass = GenericMethodAlternativeBounds.class;
        Method targetMethod = targetClass.getMethod("create", Class.class);
        GenericMethod genericMethod = new GenericMethod(targetMethod, targetClass);
        Assert.assertFalse((boolean)genericMethod.getOwnerClass().hasTypeVariables());
        List parameters = genericMethod.getParameterClasses();
        Assert.assertFalse((boolean)((GenericClass)parameters.get(0)).hasTypeVariables());
        Assert.assertTrue((boolean)((GenericClass)parameters.get(0)).hasWildcardTypes());
        Assert.assertTrue((boolean)genericMethod.getGeneratedClass().hasWildcardTypes());
    }

    @Test
    public void testGenericClassWithGenericMethodAndSubclass() throws SecurityException, NoSuchMethodException, ConstructionFailedException {
        Class<GenericClassWithGenericMethodAndSubclass> targetClass = GenericClassWithGenericMethodAndSubclass.class;
        Method targetMethod = targetClass.getMethod("wrap", Object.class);
        GenericMethod genericMethod = new GenericMethod(targetMethod, targetClass);
        Assert.assertTrue((boolean)genericMethod.getOwnerClass().hasTypeVariables());
        System.out.println(genericMethod.toString());
        System.out.println(genericMethod.getOwnerClass().toString());
        System.out.println(genericMethod.getGeneratedClass().toString());
        List parameters = genericMethod.getParameterClasses();
        Assert.assertFalse((boolean)((GenericClass)parameters.get(0)).hasTypeVariables());
        Assert.assertTrue((boolean)((GenericClass)parameters.get(0)).hasWildcardTypes());
        Assert.assertTrue((boolean)genericMethod.getGeneratedClass().hasWildcardTypes());
        GenericMethod instantiatedMethod = (GenericMethod)genericMethod.getGenericInstantiation();
        parameters = instantiatedMethod.getParameterClasses();
        Assert.assertFalse((boolean)((GenericClass)parameters.get(0)).hasTypeVariables());
        Assert.assertFalse((boolean)((GenericClass)parameters.get(0)).hasWildcardTypes());
        Assert.assertFalse((boolean)instantiatedMethod.getGeneratedClass().hasWildcardTypes());
    }

    @Test
    public void testGenericRawParameter() throws SecurityException, NoSuchMethodException {
        Class<GenericParameters8> targetClass = GenericParameters8.class;
        Method targetMethod = targetClass.getMethod("testMe", List.class);
        GenericMethod genericMethod = new GenericMethod(targetMethod, targetClass);
        System.out.println(genericMethod.toString());
        System.out.println(genericMethod.getOwnerClass().toString());
        System.out.println(genericMethod.getGeneratedClass().toString());
        Assert.assertFalse((boolean)genericMethod.getOwnerClass().hasTypeVariables());
        List parameters = genericMethod.getParameterClasses();
        Assert.assertTrue((boolean)((GenericClass)parameters.get(0)).hasTypeVariables());
        Assert.assertFalse((boolean)((GenericClass)parameters.get(0)).hasWildcardTypes());
        Assert.assertFalse((boolean)genericMethod.getGeneratedClass().hasWildcardTypes());
    }

    @Test
    public void testLinkedList() throws SecurityException, NoSuchMethodException, ConstructionFailedException {
        Class<LinkedList> targetClass = LinkedList.class;
        Method targetMethod = targetClass.getMethod("get", Integer.TYPE);
        GenericMethod genericMethod = new GenericMethod(targetMethod, targetClass);
        System.out.println(genericMethod.getGeneratedClass().toString());
        Assert.assertTrue((boolean)genericMethod.getGeneratedClass().hasWildcardOrTypeVariables());
        GenericMethod instantiatedMethod = (GenericMethod)genericMethod.getGenericInstantiation();
        System.out.println(instantiatedMethod.getGeneratedClass().toString());
        Assert.assertFalse((boolean)instantiatedMethod.getGeneratedClass().hasWildcardOrTypeVariables());
    }

    @Test
    public void testGuavaExample3() throws SecurityException, NoSuchMethodException, ConstructionFailedException {
        Class<GuavaExample3> targetClass = GuavaExample3.class;
        GenericClass genericInstantiation = new GenericClass(new TypeToken<GuavaExample3<String, String, Object>>(){}.getType());
        Method targetMethod = targetClass.getMethod("create", GuavaExample3.class);
        GenericMethod genericMethod = new GenericMethod(targetMethod, targetClass);
        System.out.println(genericMethod.getGeneratedClass().toString());
        Assert.assertTrue((boolean)genericMethod.getGeneratedClass().hasWildcardOrTypeVariables());
        System.out.println("------------------");
        GenericMethod instantiatedMethod = (GenericMethod)genericMethod.getGenericInstantiationFromReturnValue(genericInstantiation);
        System.out.println(instantiatedMethod.getGeneratedClass().toString());
        Assert.assertFalse((boolean)instantiatedMethod.getGeneratedClass().hasWildcardOrTypeVariables());
        Assert.assertEquals((Object)genericInstantiation, (Object)instantiatedMethod.getGeneratedClass());
    }

    @Test
    public void testGenericMethodFromReturnValue() throws SecurityException, NoSuchMethodException, ConstructionFailedException {
        Class<GenericMethodWithBounds> targetClass = GenericMethodWithBounds.class;
        Method targetMethod = targetClass.getMethod("is", Comparable.class);
        GenericMethod genericMethod = new GenericMethod(targetMethod, targetClass);
        GenericClass generatedType = new GenericClass(new TypeToken<List<Integer>>(){}.getType());
        GenericMethod instantiatedMethod = (GenericMethod)genericMethod.getGenericInstantiationFromReturnValue(generatedType);
        Assert.assertEquals((Object)instantiatedMethod.getGeneratedClass(), (Object)generatedType);
    }

    @Test
    public void testGenericMethodFromReturnValueWithSubclass() throws SecurityException, NoSuchMethodException, ConstructionFailedException {
        Class<GenericClassWithGenericMethodAndSubclass> targetClass = GenericClassWithGenericMethodAndSubclass.class;
        Method targetMethod = targetClass.getMethod("wrap", Object.class);
        GenericMethod genericMethod = new GenericMethod(targetMethod, targetClass);
        GenericClass generatedType = new GenericClass(new TypeToken<GenericClassWithGenericMethodAndSubclass.Foo<String>>(){}.getType());
        GenericMethod instantiatedMethod = (GenericMethod)genericMethod.getGenericInstantiationFromReturnValue(generatedType);
        Assert.assertEquals(instantiatedMethod.getGeneratedClass().getParameterTypes().get(0), String.class);
    }

    @Test
    public void testGenericMethodFromReturnValueTypeVariable() throws SecurityException, NoSuchMethodException, ConstructionFailedException {
        Class<GenericMethodReturningTypeVariable> targetClass = GenericMethodReturningTypeVariable.class;
        Method targetMethod = targetClass.getMethod("get", Object.class);
        GenericMethod genericMethod = new GenericMethod(targetMethod, targetClass);
        GenericClass generatedType1 = new GenericClass(Integer.class);
        GenericClass generatedType2 = new GenericClass(String.class);
        GenericMethod instantiatedMethod = (GenericMethod)genericMethod.getGenericInstantiationFromReturnValue(generatedType2);
        Assert.assertEquals((Object)instantiatedMethod.getGeneratedClass().getRawClass(), String.class);
        instantiatedMethod = (GenericMethod)genericMethod.getGenericInstantiationFromReturnValue(generatedType1);
        Assert.assertEquals((Object)instantiatedMethod.getGeneratedClass().getRawClass(), Integer.class);
    }

    @Test
    public void testGenericMethodFromReturnValueTypeVariable2() throws SecurityException, NoSuchMethodException, ConstructionFailedException {
        Class<GuavaExample4> targetClass = GuavaExample4.class;
        Method targetMethod = targetClass.getMethod("create", new Class[0]);
        GenericMethod genericMethod = new GenericMethod(targetMethod, targetClass);
        GenericClass iterableIntegerClass = new GenericClass(new TypeToken<GuavaExample4<Iterable<Integer>>>(){}.getType());
        GenericMethod instantiatedMethod = (GenericMethod)genericMethod.getGenericInstantiationFromReturnValue(iterableIntegerClass);
        System.out.println(instantiatedMethod.getGeneratedClass().toString());
        Assert.assertEquals((Object)instantiatedMethod.getGeneratedClass().getRawClass(), GuavaExample4.class);
    }

    @Test
    public void testGenericMethodAbstractType() throws SecurityException, NoSuchMethodException, ConstructionFailedException {
        Class<ConcreteGenericClass> targetClass = ConcreteGenericClass.class;
        Method targetMethod = targetClass.getMethod("create", Integer.TYPE);
        GenericMethod genericMethod = new GenericMethod(targetMethod, targetClass);
        Assert.assertEquals((Object)genericMethod.getGeneratedClass().getRawClass(), ConcreteGenericClass.class);
        GenericClass iterableIntegerClass = new GenericClass(new TypeToken<AbstractGenericClass<Integer>>(){}.getType());
        GenericMethod instantiatedMethod = (GenericMethod)genericMethod.getGenericInstantiationFromReturnValue(iterableIntegerClass);
        System.out.println(instantiatedMethod.getGeneratedClass().toString());
        Assert.assertEquals((Object)instantiatedMethod.getGeneratedClass().getRawClass(), ConcreteGenericClass.class);
        instantiatedMethod = genericMethod.copyWithOwnerFromReturnType(iterableIntegerClass);
        System.out.println(instantiatedMethod.getGeneratedClass().toString());
        Assert.assertEquals((Object)instantiatedMethod.getGeneratedClass().getRawClass(), ConcreteGenericClass.class);
        instantiatedMethod = (GenericMethod)genericMethod.getGenericInstantiation(iterableIntegerClass);
        System.out.println(instantiatedMethod.getGeneratedClass().toString());
        Assert.assertEquals((Object)instantiatedMethod.getGeneratedClass().getRawClass(), ConcreteGenericClass.class);
        instantiatedMethod = genericMethod.copyWithNewOwner(iterableIntegerClass);
        System.out.println(instantiatedMethod.getGeneratedClass().toString());
        Assert.assertEquals((Object)instantiatedMethod.getGeneratedClass().getRawClass(), ConcreteGenericClass.class);
    }

    @Test
    public void testClassLoaderChange() throws NoSuchMethodException, SecurityException, ConstructionFailedException {
        Class<GenericClassTwoParameters> targetClass = GenericClassTwoParameters.class;
        Method creatorMethod = targetClass.getMethod("create", new Class[0]);
        Method targetMethod = targetClass.getMethod("get", Object.class);
        Method inspectorMethod = targetClass.getMethod("testMe", new Class[0]);
        Constructor intConst = Integer.class.getConstructor(Integer.TYPE);
        GenericClass listOfInteger = new GenericClass(new TypeToken<GenericClassTwoParameters<Integer, Integer>>(){}.getType());
        GenericMethod genericCreatorMethod = (GenericMethod)new GenericMethod(creatorMethod, targetClass).getGenericInstantiationFromReturnValue(listOfInteger);
        System.out.println(genericCreatorMethod.getGeneratedClass().toString());
        GenericMethod genericMethod = new GenericMethod(targetMethod, targetClass).copyWithNewOwner(genericCreatorMethod.getGeneratedClass());
        System.out.println(genericMethod.getGeneratedClass().toString());
        DefaultTestCase test = new DefaultTestCase();
        MethodStatement ms1 = new MethodStatement((TestCase)test, genericCreatorMethod, (VariableReference)null, new ArrayList());
        test.addStatement((Statement)ms1);
        IntPrimitiveStatement ps1 = (IntPrimitiveStatement)PrimitiveStatement.getPrimitiveStatement((TestCase)test, Integer.TYPE);
        test.addStatement((Statement)ps1);
        GenericConstructor intConstructor = new GenericConstructor(intConst, Integer.class);
        ArrayList<VariableReference> constParam = new ArrayList<VariableReference>();
        constParam.add(ps1.getReturnValue());
        ConstructorStatement cs1 = new ConstructorStatement((TestCase)test, intConstructor, constParam);
        ArrayList<VariableReference> callParam = new ArrayList<VariableReference>();
        callParam.add(ps1.getReturnValue());
        MethodStatement ms2 = new MethodStatement((TestCase)test, genericMethod, ms1.getReturnValue(), callParam);
        test.addStatement((Statement)ms2);
        Inspector inspector = new Inspector(targetClass, inspectorMethod);
        InspectorAssertion assertion = new InspectorAssertion(inspector, (Statement)ms2, ms1.getReturnValue(), (Object)0);
        ms2.addAssertion((Assertion)assertion);
        String code = test.toCode();
        InstrumentingClassLoader loader = new InstrumentingClassLoader();
        Properties.TARGET_CLASS = targetClass.getCanonicalName();
        Properties.CRITERION = new Properties.Criterion[1];
        Properties.CRITERION[0] = Properties.Criterion.MUTATION;
        DefaultTestCase testCopy = test.clone();
        testCopy.changeClassLoader((ClassLoader)loader);
        String code2 = testCopy.toCode();
        Assert.assertEquals((Object)code, (Object)code2);
        Assert.assertEquals((Object)code, (Object)test.toCode());
        testCopy.removeAssertion((Assertion)assertion);
        Assert.assertEquals((Object)code, (Object)test.toCode());
        test.removeAssertions();
        System.out.println(test.toCode());
    }
}

