/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import com.examples.with.different.packagename.generic.AbstractGuavaExample;
import com.examples.with.different.packagename.generic.GenericParameterExtendingGenericBounds;
import com.examples.with.different.packagename.generic.GuavaExample4;
import com.examples.with.different.packagename.generic.GuavaExample5;
import com.googlecode.gentyref.GenericTypeReflector;
import com.googlecode.gentyref.TypeToken;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.instrumentation.InstrumentingClassLoader;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.ParameterizedTypeImpl;
import org.evosuite.utils.WildcardTypeImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericClass {
    @Test
    public void testWildcardClassloader() {
        GenericClass clazz = new GenericClass(Class.class).getWithWildcardTypes();
        Assert.assertEquals((Object)"java.lang.Class<?>", (Object)clazz.getTypeName());
        clazz.changeClassLoader(TestGenericClass.class.getClassLoader());
        Assert.assertEquals((Object)"java.lang.Class<?>", (Object)clazz.getTypeName());
    }

    @Test
    public void testAssignablePrimitives() {
        GenericClass clazz1 = new GenericClass(Integer.TYPE);
        GenericClass clazz2 = new GenericClass(Integer.TYPE);
        Assert.assertTrue((boolean)clazz1.isAssignableTo(clazz2));
        Assert.assertTrue((boolean)clazz1.isAssignableFrom(clazz2));
    }

    @Test
    public void testAssignableObject() {
        GenericClass clazz1 = new GenericClass(Object.class);
        GenericClass clazz2 = new GenericClass(Object.class);
        Assert.assertTrue((boolean)clazz1.isAssignableTo(clazz2));
    }

    @Test
    public void testAssignableIntegerObject() {
        GenericClass clazz1 = new GenericClass(Integer.class);
        GenericClass clazz2 = new GenericClass(Object.class);
        Assert.assertTrue((boolean)clazz1.isAssignableTo(clazz2));
        Assert.assertFalse((boolean)clazz1.isAssignableFrom(clazz2));
    }

    @Test
    public void testAssignableIntegerNumber() {
        GenericClass clazz1 = new GenericClass(Integer.class);
        GenericClass clazz2 = new GenericClass(Number.class);
        Assert.assertTrue((boolean)clazz1.isAssignableTo(clazz2));
        Assert.assertFalse((boolean)clazz1.isAssignableFrom(clazz2));
    }

    @Test
    public void testAssignableIntInteger() {
        GenericClass clazz1 = new GenericClass(Integer.class);
        GenericClass clazz2 = new GenericClass(Integer.TYPE);
        Assert.assertTrue((boolean)clazz1.isAssignableTo(clazz2));
        Assert.assertTrue((boolean)clazz1.isAssignableFrom(clazz2));
    }

    @Test
    public void testAssignableClass() {
        GenericClass clazzTypeVar = new GenericClass(Class.class);
        GenericClass clazzWildcard = clazzTypeVar.getWithWildcardTypes();
        ParameterizedTypeImpl type = new ParameterizedTypeImpl(Class.class, new Type[]{Integer.class}, null);
        GenericClass clazzConcrete = new GenericClass((Type)type);
        Assert.assertFalse((boolean)clazzWildcard.isAssignableTo(clazzConcrete));
        Assert.assertFalse((boolean)clazzWildcard.isAssignableTo(clazzTypeVar));
        Assert.assertTrue((boolean)clazzWildcard.isAssignableTo(clazzWildcard));
        Assert.assertFalse((boolean)clazzTypeVar.isAssignableTo(clazzConcrete));
        Assert.assertTrue((boolean)clazzTypeVar.isAssignableTo(clazzTypeVar));
        Assert.assertTrue((boolean)clazzTypeVar.isAssignableTo(clazzWildcard));
        Assert.assertTrue((boolean)clazzConcrete.isAssignableTo(clazzConcrete));
        Assert.assertFalse((boolean)clazzConcrete.isAssignableTo(clazzTypeVar));
        Assert.assertTrue((boolean)clazzConcrete.isAssignableTo(clazzWildcard));
    }

    @Test
    public void test01() throws Throwable {
        Stack col0 = new Stack();
        Stack col1 = new Stack();
        Stack col2 = new Stack();
        Stack col3 = new Stack();
        GenericClass stack = new GenericClass(Stack.class).getWithWildcardTypes();
        GenericClass collection = new GenericClass(Collection.class).getWithWildcardTypes();
        Assert.assertTrue((boolean)stack.isAssignableTo(collection));
        GenericClass objectStack = new GenericClass(col0.getClass());
        Assert.assertTrue((boolean)objectStack.isAssignableTo(collection));
        Type typeColA = new TypeToken<Collection<A>>(){}.getType();
        Type typeStack = new TypeToken<Stack>(){}.getType();
        Type typeObjectStack = new TypeToken<Stack<Object>>(){}.getType();
        GenericClass classColA = new GenericClass(typeColA);
        GenericClass classStack = new GenericClass(typeStack).getWithWildcardTypes();
        GenericClass classObjectStack = new GenericClass(typeObjectStack);
        Assert.assertFalse((boolean)classStack.isAssignableTo(classColA));
        Assert.assertFalse((boolean)classObjectStack.isAssignableTo(classColA));
        Assert.assertFalse((boolean)classColA.isAssignableFrom(classObjectStack));
    }

    @Test
    public void test1() {
        Type listOfString = new TypeToken<List<String>>(){}.getType();
        Type listOfInteger = new TypeToken<List<Integer>>(){}.getType();
        GenericClass listOfStringClass = new GenericClass(listOfString);
        GenericClass listOfIntegerClass = new GenericClass(listOfInteger);
        Assert.assertFalse((boolean)listOfStringClass.isAssignableFrom(listOfIntegerClass));
        Assert.assertFalse((boolean)listOfStringClass.isAssignableTo(listOfIntegerClass));
    }

    @Test
    public void test2() {
        Type listOfString = new TypeToken<List<String>>(){}.getType();
        Type plainList = new TypeToken<List>(){}.getType();
        Type objectList = new TypeToken<List<Object>>(){}.getType();
        GenericClass listOfStringClass = new GenericClass(listOfString);
        GenericClass plainListClass = new GenericClass(plainList).getWithWildcardTypes();
        GenericClass objectListClass = new GenericClass(objectList);
        Assert.assertFalse((boolean)listOfStringClass.isAssignableTo(objectListClass));
        Assert.assertFalse((boolean)listOfStringClass.isAssignableFrom(plainListClass));
        Assert.assertTrue((boolean)listOfStringClass.isAssignableTo(plainListClass));
    }

    @Test
    public void test3() {
        Type listOfInteger = new TypeToken<List<Integer>>(){}.getType();
        Type listOfSerializable = new TypeToken<List<Serializable>>(){}.getType();
        GenericClass listOfIntegerClass = new GenericClass(listOfInteger);
        GenericClass listOfSerializableClass = new GenericClass(listOfSerializable);
        Assert.assertFalse((boolean)listOfIntegerClass.isAssignableFrom(listOfSerializableClass));
        Assert.assertFalse((boolean)listOfSerializableClass.isAssignableFrom(listOfIntegerClass));
        Assert.assertTrue((boolean)listOfIntegerClass.isAssignableFrom(listOfIntegerClass));
        Assert.assertTrue((boolean)listOfSerializableClass.isAssignableFrom(listOfSerializableClass));
    }

    @Test
    public void testTypeVariableBoundariesNumber() {
        TypeVariable numberTypeVariable = NumberBoundary.class.getTypeParameters()[0];
        GenericClass listOfIntegerClass = new GenericClass(Integer.class);
        GenericClass listOfSerializableClass = new GenericClass(Serializable.class);
        Assert.assertTrue((boolean)listOfIntegerClass.satisfiesBoundaries(numberTypeVariable));
        Assert.assertFalse((boolean)listOfSerializableClass.satisfiesBoundaries(numberTypeVariable));
    }

    @Test
    public void testTypeVariableBoundariesComparable() {
        TypeVariable comparableTypeVariable = ComparableBoundary.class.getTypeParameters()[0];
        GenericClass listOfIntegerClass = new GenericClass(Integer.class);
        GenericClass listOfSerializableClass = new GenericClass(Serializable.class);
        Assert.assertTrue((boolean)listOfIntegerClass.satisfiesBoundaries(comparableTypeVariable));
        Assert.assertFalse((boolean)listOfSerializableClass.satisfiesBoundaries(comparableTypeVariable));
    }

    @Test
    public void testGuavaExample() {
        Type abstractGuavaExampleString = new TypeToken<AbstractGuavaExample<String>>(){}.getType();
        Type guavaExample5 = new TypeToken<GuavaExample5<String>>(){}.getType();
        GenericClass abstractClass = new GenericClass(abstractGuavaExampleString);
        GenericClass concreteClass = new GenericClass(guavaExample5);
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)concreteClass.getType(), (Type)abstractClass.getType()));
        Assert.assertTrue((String)("Cannot assign " + concreteClass + " to " + abstractClass), (boolean)abstractClass.isAssignableFrom(concreteClass));
        Assert.assertTrue((boolean)concreteClass.isAssignableTo(abstractClass));
    }

    @Test
    public void testTypeVariableBoundariesRefined() {
        TypeVariable dateTypeVariable = RefinedComparableBoundary.class.getTypeParameters()[0];
        TypeVariable comparableTypeVariable = ComparableBoundary.class.getTypeParameters()[0];
        GenericClass listOfIntegerClass = new GenericClass(Integer.class);
        GenericClass listOfComparableClass = new GenericClass(Comparable.class);
        GenericClass listOfDateClass = new GenericClass(java.util.Date.class);
        GenericClass listOfSqlDateClass = new GenericClass(Date.class);
        Assert.assertFalse((boolean)listOfIntegerClass.satisfiesBoundaries(dateTypeVariable));
        Assert.assertFalse((boolean)listOfComparableClass.satisfiesBoundaries(dateTypeVariable));
        Assert.assertTrue((boolean)listOfDateClass.satisfiesBoundaries(dateTypeVariable));
        Assert.assertTrue((boolean)listOfSqlDateClass.satisfiesBoundaries(dateTypeVariable));
        Assert.assertTrue((boolean)listOfIntegerClass.satisfiesBoundaries(comparableTypeVariable));
        Assert.assertTrue((boolean)listOfDateClass.satisfiesBoundaries(comparableTypeVariable));
    }

    @Test
    public void testWildcardObjectBoundaries() {
        WildcardTypeImpl objectType = new WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);
        GenericClass integerClass = new GenericClass(Integer.class);
        GenericClass comparableClass = new GenericClass(Comparable.class);
        GenericClass dateClass = new GenericClass(java.util.Date.class);
        GenericClass sqlDateClass = new GenericClass(Date.class);
        Assert.assertTrue((boolean)integerClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertTrue((boolean)comparableClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertTrue((boolean)dateClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertTrue((boolean)sqlDateClass.satisfiesBoundaries((WildcardType)objectType));
    }

    @Test
    public void testWildcardNumberBoundaries() {
        WildcardTypeImpl objectType = new WildcardTypeImpl(new Type[]{Number.class}, new Type[0]);
        GenericClass integerClass = new GenericClass(Integer.class);
        GenericClass comparableClass = new GenericClass(Comparable.class);
        GenericClass dateClass = new GenericClass(java.util.Date.class);
        GenericClass sqlDateClass = new GenericClass(Date.class);
        Assert.assertTrue((boolean)integerClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)comparableClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)dateClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)sqlDateClass.satisfiesBoundaries((WildcardType)objectType));
    }

    @Test
    public void testWildcardIntegerBoundaries() {
        WildcardTypeImpl objectType = new WildcardTypeImpl(new Type[]{Integer.class}, new Type[0]);
        GenericClass integerClass = new GenericClass(Integer.class);
        GenericClass comparableClass = new GenericClass(Comparable.class);
        GenericClass dateClass = new GenericClass(java.util.Date.class);
        GenericClass sqlDateClass = new GenericClass(Date.class);
        Assert.assertTrue((boolean)integerClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)comparableClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)dateClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)sqlDateClass.satisfiesBoundaries((WildcardType)objectType));
    }

    @Test
    public void testWildcardComparableBoundaries() {
        WildcardTypeImpl objectType = new WildcardTypeImpl(new Type[]{Comparable.class}, new Type[0]);
        GenericClass integerClass = new GenericClass(Integer.class);
        GenericClass comparableClass = new GenericClass(Comparable.class);
        GenericClass dateClass = new GenericClass(java.util.Date.class);
        GenericClass sqlDateClass = new GenericClass(Date.class);
        Assert.assertTrue((boolean)integerClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertTrue((boolean)comparableClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertTrue((boolean)dateClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertTrue((boolean)sqlDateClass.satisfiesBoundaries((WildcardType)objectType));
    }

    @Test
    public void testWildcardDateBoundaries() {
        WildcardTypeImpl objectType = new WildcardTypeImpl(new Type[]{java.util.Date.class}, new Type[0]);
        GenericClass integerClass = new GenericClass(Integer.class);
        GenericClass comparableClass = new GenericClass(Comparable.class);
        GenericClass dateClass = new GenericClass(java.util.Date.class);
        GenericClass sqlDateClass = new GenericClass(Date.class);
        Assert.assertFalse((boolean)integerClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)comparableClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertTrue((boolean)dateClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertTrue((boolean)sqlDateClass.satisfiesBoundaries((WildcardType)objectType));
    }

    @Test
    public void testWildcardSqlDateBoundaries() {
        WildcardTypeImpl objectType = new WildcardTypeImpl(new Type[]{Date.class}, new Type[0]);
        GenericClass integerClass = new GenericClass(Integer.class);
        GenericClass comparableClass = new GenericClass(Comparable.class);
        GenericClass dateClass = new GenericClass(java.util.Date.class);
        GenericClass sqlDateClass = new GenericClass(Date.class);
        Assert.assertFalse((boolean)integerClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)comparableClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)dateClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertTrue((boolean)sqlDateClass.satisfiesBoundaries((WildcardType)objectType));
    }

    @Test
    public void testWildcardDateSuperBoundaries() {
        WildcardTypeImpl objectType = new WildcardTypeImpl(new Type[]{Object.class}, new Type[]{java.util.Date.class});
        GenericClass integerClass = new GenericClass(Integer.class);
        GenericClass comparableClass = new GenericClass(Comparable.class);
        GenericClass dateClass = new GenericClass(java.util.Date.class);
        GenericClass sqlDateClass = new GenericClass(Date.class);
        Assert.assertFalse((boolean)integerClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)comparableClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertTrue((boolean)dateClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)sqlDateClass.satisfiesBoundaries((WildcardType)objectType));
    }

    @Test
    public void testWildcardDateBothBoundaries() {
        WildcardTypeImpl objectType = new WildcardTypeImpl(new Type[]{java.util.Date.class}, new Type[]{java.util.Date.class});
        GenericClass integerClass = new GenericClass(Integer.class);
        GenericClass comparableClass = new GenericClass(Comparable.class);
        GenericClass dateClass = new GenericClass(java.util.Date.class);
        GenericClass sqlDateClass = new GenericClass(Date.class);
        Assert.assertFalse((boolean)integerClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)comparableClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertTrue((boolean)dateClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)sqlDateClass.satisfiesBoundaries((WildcardType)objectType));
    }

    @Test
    public void testWildcardDateBothBoundaries2() {
        WildcardTypeImpl objectType = new WildcardTypeImpl(new Type[]{Comparable.class}, new Type[]{java.util.Date.class});
        GenericClass integerClass = new GenericClass(Integer.class);
        GenericClass comparableClass = new GenericClass(Comparable.class);
        GenericClass dateClass = new GenericClass(java.util.Date.class);
        GenericClass sqlDateClass = new GenericClass(Date.class);
        Assert.assertFalse((boolean)integerClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)comparableClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertTrue((boolean)dateClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)sqlDateClass.satisfiesBoundaries((WildcardType)objectType));
    }

    @Test
    public void testWildcardInvalidBoundaries() {
        WildcardTypeImpl objectType = new WildcardTypeImpl(new Type[]{Number.class}, new Type[]{java.util.Date.class});
        GenericClass integerClass = new GenericClass(Integer.class);
        GenericClass comparableClass = new GenericClass(Comparable.class);
        GenericClass dateClass = new GenericClass(java.util.Date.class);
        GenericClass sqlDateClass = new GenericClass(Date.class);
        Assert.assertFalse((boolean)integerClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)comparableClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)dateClass.satisfiesBoundaries((WildcardType)objectType));
        Assert.assertFalse((boolean)sqlDateClass.satisfiesBoundaries((WildcardType)objectType));
    }

    @Test
    public void testGenericSuperclassWildcards() {
        GenericClass listOfInteger = new GenericClass(new TypeToken<List<Integer>>(){}.getType());
        GenericClass listOfWildcard = new GenericClass(new TypeToken<List<?>>(){}.getType());
        Assert.assertTrue((boolean)listOfWildcard.isGenericSuperTypeOf(listOfInteger));
        Assert.assertFalse((boolean)listOfInteger.isGenericSuperTypeOf(listOfWildcard));
        Assert.assertTrue((boolean)listOfInteger.hasGenericSuperType(listOfWildcard));
        Assert.assertFalse((boolean)listOfWildcard.hasGenericSuperType(listOfInteger));
        GenericClass mapOfInteger = new GenericClass(new TypeToken<Map<Integer, String>>(){}.getType());
        GenericClass mapOfWildcard = new GenericClass(new TypeToken<Map<?, ?>>(){}.getType());
        Assert.assertTrue((boolean)mapOfWildcard.isGenericSuperTypeOf(mapOfInteger));
        Assert.assertFalse((boolean)mapOfInteger.isGenericSuperTypeOf(mapOfWildcard));
        Assert.assertTrue((boolean)mapOfInteger.hasGenericSuperType(mapOfWildcard));
        Assert.assertFalse((boolean)mapOfWildcard.hasGenericSuperType(mapOfInteger));
    }

    @Test
    public void testGenericSuperclassConcreteList() {
        GenericClass listOfInteger = new GenericClass(new TypeToken<List<Integer>>(){}.getType());
        GenericClass linkedlistOfInteger = new GenericClass(new TypeToken<LinkedList<Integer>>(){}.getType());
        Assert.assertTrue((boolean)linkedlistOfInteger.canBeInstantiatedTo(listOfInteger));
        Assert.assertFalse((boolean)listOfInteger.canBeInstantiatedTo(linkedlistOfInteger));
    }

    @Test
    public void testGenericSuperclassToWildcardList() {
        GenericClass listOfWildcard = new GenericClass(new TypeToken<List<Integer>>(){}.getType()).getWithWildcardTypes();
        GenericClass linkedlistOfInteger = new GenericClass(new TypeToken<LinkedList<Integer>>(){}.getType());
        Assert.assertTrue((boolean)linkedlistOfInteger.canBeInstantiatedTo(listOfWildcard));
        Assert.assertFalse((boolean)listOfWildcard.canBeInstantiatedTo(linkedlistOfInteger));
    }

    @Test
    public void testGenericSuperclassFromWildcardList() {
        GenericClass listOfInteger = new GenericClass(new TypeToken<List<Integer>>(){}.getType());
        GenericClass linkedlistOfWildcard = new GenericClass(new TypeToken<LinkedList<Integer>>(){}.getType()).getWithWildcardTypes();
        Assert.assertTrue((boolean)linkedlistOfWildcard.canBeInstantiatedTo(listOfInteger));
        Assert.assertFalse((boolean)listOfInteger.canBeInstantiatedTo(linkedlistOfWildcard));
    }

    @Test
    public void testGenericSuperclassToTypeVariableList() {
        GenericClass listOfTypeVariable = new GenericClass(new TypeToken<List>(){}.getType());
        GenericClass linkedlistOfInteger = new GenericClass(new TypeToken<LinkedList<Integer>>(){}.getType());
        Assert.assertTrue((boolean)linkedlistOfInteger.canBeInstantiatedTo(listOfTypeVariable));
        Assert.assertFalse((boolean)listOfTypeVariable.canBeInstantiatedTo(linkedlistOfInteger));
    }

    @Test
    public void testGenericSuperclassFromTypeVariableList() {
        GenericClass listOfInteger = new GenericClass(new TypeToken<List<Integer>>(){}.getType());
        GenericClass linkedlistOfTypeVariable = new GenericClass(new TypeToken<LinkedList>(){}.getType());
        Assert.assertTrue((boolean)linkedlistOfTypeVariable.canBeInstantiatedTo(listOfInteger));
        Assert.assertFalse((boolean)listOfInteger.canBeInstantiatedTo(linkedlistOfTypeVariable));
    }

    @Test
    public void testPrimitiveWrapper() {
        GenericClass integerClass = new GenericClass(Integer.class);
        GenericClass intClass = new GenericClass(Integer.TYPE);
        Assert.assertTrue((boolean)integerClass.canBeInstantiatedTo(intClass));
        Assert.assertFalse((boolean)intClass.canBeInstantiatedTo(integerClass));
    }

    @Test
    public void testGenericInstantiationIntegerList() throws ConstructionFailedException {
        GenericClass listOfInteger = new GenericClass(new TypeToken<List<Integer>>(){}.getType());
        GenericClass linkedlistOfTypeVariable = new GenericClass(new TypeToken<LinkedList>(){}.getType());
        GenericClass instantiatedClass = linkedlistOfTypeVariable.getWithParametersFromSuperclass(listOfInteger);
        Assert.assertEquals(Integer.class, instantiatedClass.getParameterTypes().get(0));
    }

    @Test
    public void testGenericInstantiationMapSubclass() throws ConstructionFailedException {
        GenericClass mapOfStringAndWildcard = new GenericClass(new TypeToken<Map<String, ?>>(){}.getType());
        GenericClass hashMapClass = new GenericClass(new TypeToken<HashMap>(){}.getType());
        GenericClass instantiatedClass = hashMapClass.getWithParametersFromSuperclass(mapOfStringAndWildcard);
        System.out.println(instantiatedClass.toString());
        Assert.assertEquals(String.class, instantiatedClass.getParameterTypes().get(0));
    }

    @Test
    public void testGenericInstantiationMapType() throws ConstructionFailedException {
        GenericClass genericClass = new GenericClass(GenericParameterExtendingGenericBounds.class);
        GenericClass instantiatedClass = genericClass.getGenericInstantiation();
        System.out.println(instantiatedClass.toString());
        Type parameterType = (Type)instantiatedClass.getParameterTypes().get(0);
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)parameterType, Map.class));
        Assert.assertTrue((boolean)(parameterType instanceof ParameterizedType));
        ParameterizedType parameterizedType = (ParameterizedType)parameterType;
        Assert.assertEquals(String.class, (Object)parameterizedType.getActualTypeArguments()[0]);
    }

    @Test
    public void testIterableAndList() throws ConstructionFailedException {
        GenericClass iterableIntegerClass = new GenericClass(new TypeToken<Iterable<Integer>>(){}.getType());
        GenericClass arrayListClass = new GenericClass(ArrayList.class);
        Assert.assertTrue((boolean)arrayListClass.canBeInstantiatedTo(iterableIntegerClass));
        Assert.assertFalse((boolean)iterableIntegerClass.canBeInstantiatedTo(arrayListClass));
        GenericClass instantiatedList = arrayListClass.getWithParametersFromSuperclass(iterableIntegerClass);
        Type parameterType = (Type)instantiatedList.getParameterTypes().get(0);
        Assert.assertEquals(Integer.class, (Object)GenericTypeReflector.erase((Type)parameterType));
    }

    @Test
    public void testIterableAndListBoundaries() {
        HashMap<33, Type> typeMap = new HashMap<33, Type>();
        final GenericClass iterableIntegerClass = new GenericClass(new TypeToken<Iterable<Integer>>(){}.getType());
        TypeVariable var = new TypeVariable(){

            @Override
            public Type[] getBounds() {
                return new Type[]{iterableIntegerClass.getType()};
            }

            public GenericDeclaration getGenericDeclaration() {
                return null;
            }

            @Override
            public String getName() {
                return "Test";
            }

            public String toString() {
                return "Dummy Variable";
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return null;
            }

            @Override
            public Annotation[] getAnnotations() {
                return null;
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return null;
            }

            public void getAnnotatedBounds() {
            }
        };
        typeMap.put(var, iterableIntegerClass.getType());
        GenericClass arrayListClass = new GenericClass(new TypeToken<ArrayList<String>>(){}.getType());
        Assert.assertFalse((boolean)arrayListClass.satisfiesBoundaries(var, typeMap));
        arrayListClass = new GenericClass(new TypeToken<ArrayList<Integer>>(){}.getType());
        Assert.assertTrue((boolean)arrayListClass.satisfiesBoundaries(var, typeMap));
    }

    @Test
    public void testSatisfiesTypeVariableInSubtype() {
        GenericClass iterableIntegerClass = new GenericClass(new TypeToken<GuavaExample4<Iterable<Integer>>>(){}.getType());
        ParameterizedType iterableInteger = (ParameterizedType)iterableIntegerClass.getParameterTypes().get(0);
        TypeVariable typeVariable = ((Class)iterableInteger.getRawType()).getTypeParameters()[0];
        TypeVariable iterableTypeVariable = (TypeVariable)iterableIntegerClass.getTypeVariables().get(0);
        GenericClass listOfIntegerClass = new GenericClass(GuavaExample4.class);
        Assert.assertTrue((boolean)iterableIntegerClass.satisfiesBoundaries(typeVariable));
        Assert.assertTrue((boolean)listOfIntegerClass.satisfiesBoundaries(typeVariable));
        Assert.assertTrue((boolean)iterableIntegerClass.satisfiesBoundaries(iterableTypeVariable));
        Assert.assertTrue((boolean)listOfIntegerClass.satisfiesBoundaries(iterableTypeVariable));
    }

    @Test
    public void reloadArrayClass() {
        GenericClass arrayClass = new GenericClass(Object[].class);
        InstrumentingClassLoader loader = new InstrumentingClassLoader();
        arrayClass.changeClassLoader((ClassLoader)loader);
        Class rawClass = arrayClass.getRawClass();
        Assert.assertTrue((boolean)rawClass.isArray());
    }

    @Test
    public void reloadNonArrayClass() {
        GenericClass arrayClass = new GenericClass(Integer.class);
        InstrumentingClassLoader loader = new InstrumentingClassLoader();
        arrayClass.changeClassLoader((ClassLoader)loader);
        Class rawClass = arrayClass.getRawClass();
        Assert.assertFalse((boolean)rawClass.isArray());
    }

    @Test
    public void testWildcardInstantiation() throws ConstructionFailedException {
        GenericClass integerWildcardListClass = new GenericClass(new TypeToken<List<? extends Integer>>(){}.getType());
        GenericClass integerListClass = new GenericClass(new TypeToken<List<Integer>>(){}.getType());
        GenericClass objectListClass = new GenericClass(new TypeToken<List<Object>>(){}.getType());
        Assert.assertTrue((boolean)integerWildcardListClass.isAssignableFrom(integerListClass));
        Assert.assertFalse((boolean)integerWildcardListClass.isAssignableFrom(objectListClass));
        GenericClass integerWildcardListInstantiation = integerWildcardListClass.getGenericInstantiation();
        Assert.assertTrue((boolean)integerWildcardListClass.isAssignableFrom(integerWildcardListInstantiation));
    }

    @Test
    public void testWildcardWithSuperIntegerBoundaryInstantiation() throws ConstructionFailedException {
        GenericClass integerWildcardListClass = new GenericClass(new TypeToken<List<? super Integer>>(){}.getType());
        GenericClass integerListClass = new GenericClass(new TypeToken<List<Integer>>(){}.getType());
        GenericClass numberListClass = new GenericClass(new TypeToken<List<Number>>(){}.getType());
        GenericClass objectListClass = new GenericClass(new TypeToken<List<Object>>(){}.getType());
        Assert.assertTrue((boolean)integerWildcardListClass.isAssignableFrom(integerListClass));
        Assert.assertTrue((boolean)integerWildcardListClass.isAssignableFrom(numberListClass));
        Assert.assertTrue((boolean)integerWildcardListClass.isAssignableFrom(objectListClass));
        GenericClass integerWildcardListInstantiation = integerWildcardListClass.getGenericInstantiation();
        Assert.assertTrue((boolean)integerWildcardListClass.isAssignableFrom(integerWildcardListInstantiation));
    }

    @Test
    public void testWildcardWithSuperNumberBoundaryInstantiation() throws ConstructionFailedException {
        GenericClass numberWildcardListClass = new GenericClass(new TypeToken<List<? super Number>>(){}.getType());
        GenericClass integerListClass = new GenericClass(new TypeToken<List<Integer>>(){}.getType());
        GenericClass numberListClass = new GenericClass(new TypeToken<List<Number>>(){}.getType());
        GenericClass objectListClass = new GenericClass(new TypeToken<List<Object>>(){}.getType());
        Assert.assertFalse((boolean)numberWildcardListClass.isAssignableFrom(integerListClass));
        Assert.assertTrue((boolean)numberWildcardListClass.isAssignableFrom(numberListClass));
        Assert.assertTrue((boolean)numberWildcardListClass.isAssignableFrom(objectListClass));
        GenericClass integerWildcardListInstantiation = numberWildcardListClass.getGenericInstantiation();
        System.out.println(integerWildcardListInstantiation.toString());
        Assert.assertTrue((boolean)numberWildcardListClass.isAssignableFrom(integerWildcardListInstantiation));
    }

    private class RefinedComparableBoundary<T extends java.util.Date>
    extends ComparableBoundary<java.util.Date> {
        private RefinedComparableBoundary() {
        }
    }

    private class ComparableBoundary<T extends Comparable<T>> {
        private ComparableBoundary() {
        }
    }

    private class NumberBoundary<T extends Number> {
        private NumberBoundary() {
        }
    }

    private static class A {
        private A() {
        }
    }
}

