/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import java.io.IOException;
import org.evosuite.Properties;
import org.evosuite.TimeController;
import org.evosuite.classpath.ClassPathHacker;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.MasterNodeRemote;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.agent.ToolsJarLocator;
import org.evosuite.runtime.instrumentation.MethodCallReplacementCache;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.sandbox.MSecurityManager;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientProcess {
    private static Logger logger = LoggerFactory.getLogger(ClientProcess.class);
    public static TestGenerationResult result;

    public void run() {
        Properties.getInstance();
        ClientProcess.setupRuntimeProperties();
        Sandbox.setCheckForInitialization((boolean)Properties.SANDBOX);
        MockFramework.enable();
        this.initializeToolJar();
        MSecurityManager.setupMasterNodeRemoteHandling(MasterNodeRemote.class);
        LoggingUtils.getEvoLogger().info("* Connecting to master process on port " + Properties.PROCESS_COMMUNICATION_PORT);
        boolean registered = ClientServices.getInstance().registerServices();
        if (!registered) {
            result = TestGenerationResultBuilder.buildErrorResult("Could not connect to master process on port " + Properties.PROCESS_COMMUNICATION_PORT);
            throw new RuntimeException("Could not connect to master process on port " + Properties.PROCESS_COMMUNICATION_PORT);
        }
        ClientServices.getInstance().getClientNode().waitUntilDone();
        ClientServices.getInstance().stopServices();
    }

    private void initializeToolJar() {
        ToolsJarLocator locator = new ToolsJarLocator(Properties.TOOLS_JAR_LOCATION);
        locator.getLoaderForToolsJar();
        if (locator.getLocationNotOnClasspath() != null) {
            try {
                logger.info("Using JDK libraries at: " + locator.getLocationNotOnClasspath());
                ClassPathHacker.addFile(locator.getLocationNotOnClasspath());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to add " + locator.getLocationNotOnClasspath() + " to system classpath");
            }
        }
    }

    private static void setupRuntimeProperties() {
        RuntimeSettings.useVFS = Properties.VIRTUAL_FS;
        RuntimeSettings.mockJVMNonDeterminism = Properties.REPLACE_CALLS;
        RuntimeSettings.mockSystemIn = Properties.REPLACE_SYSTEM_IN;
        RuntimeSettings.sandboxMode = Properties.SANDBOX_MODE;
        RuntimeSettings.maxNumberOfThreads = Properties.MAX_STARTED_THREADS;
        RuntimeSettings.useVNET = Properties.VIRTUAL_NET;
        RuntimeSettings.useSeparateClassLoader = Properties.USE_SEPARATE_CLASSLOADER;
        MethodCallReplacementCache.resetSingleton();
    }

    public static void main(String[] args) {
        block5: {
            boolean onThread = Properties.CLIENT_ON_THREAD;
            try {
                LoggingUtils.getEvoLogger().info("* Starting client");
                ClientProcess process = new ClientProcess();
                TimeController.resetSingleton();
                process.run();
                if (!onThread) {
                    System.exit(0);
                }
            }
            catch (Throwable t) {
                logger.error("Error when generating tests for: " + Properties.TARGET_CLASS + " with seed " + Randomness.getSeed() + ". Configuration id : " + Properties.CONFIGURATION_ID, t);
                t.printStackTrace();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (onThread) break block5;
                System.exit(1);
            }
        }
    }
}

