/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import java.io.Serializable;
import org.evosuite.TestSuiteGenerator;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.rmi.service.ClientStateInformation;
import org.evosuite.testsuite.TestSuiteChromosome;

public class ProgressMonitor
implements SearchListener,
Serializable {
    private static final long serialVersionUID = -8518559681906649686L;
    private StoppingCondition stoppingCondition = null;
    private long max = 1L;
    private int currentCoverage = 0;
    protected int lastCoverage = 0;
    protected int lastProgress = 0;
    protected int iteration = 0;
    protected ClientState state = ClientState.INITIALIZATION;

    public void updateStatus(int percent) {
        ClientState state = ClientState.SEARCH;
        ClientStateInformation information = new ClientStateInformation(state);
        information.setCoverage(this.currentCoverage);
        information.setProgress(percent);
        information.setIteration(this.iteration);
        ClientServices.getInstance().getClientNode().changeState(state, information);
        this.lastProgress = percent;
        this.lastCoverage = this.currentCoverage;
    }

    @Override
    public void searchStarted(GeneticAlgorithm<?> algorithm) {
        this.stoppingCondition = TestSuiteGenerator.getStoppingCondition();
        this.max = this.stoppingCondition.getLimit();
    }

    @Override
    public void iteration(GeneticAlgorithm<?> algorithm) {
        long current = this.stoppingCondition.getCurrentValue();
        this.currentCoverage = (int)Math.floor(((TestSuiteChromosome)algorithm.getBestIndividual()).getCoverage() * 100.0);
        this.updateStatus((int)(100L * current / this.max));
        ++this.iteration;
    }

    @Override
    public void searchFinished(GeneticAlgorithm<?> algorithm) {
        this.currentCoverage = (int)Math.floor(((TestSuiteChromosome)algorithm.getBestIndividual()).getCoverage() * 100.0);
        if (this.currentCoverage > this.lastCoverage) {
            this.updateStatus((int)(100L * this.stoppingCondition.getCurrentValue() / this.max));
        }
    }

    @Override
    public void fitnessEvaluation(Chromosome individual) {
        int current = (int)((long)((int)(100L * this.stoppingCondition.getCurrentValue())) / this.max);
        this.currentCoverage = (int)Math.floor(((TestSuiteChromosome)individual).getCoverage() * 100.0);
        if (this.currentCoverage > this.lastCoverage || current > this.lastProgress) {
            this.updateStatus(current);
        }
    }

    @Override
    public void modification(Chromosome individual) {
    }
}

