/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import org.evosuite.Properties;
import org.evosuite.contracts.ContractChecker;
import org.evosuite.contracts.FailingTestSet;
import org.evosuite.coverage.archive.TestsArchive;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.ga.stoppingconditions.GlobalTimeStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.graphs.cfg.CFGMethodAdapter;
import org.evosuite.instrumentation.InstrumentingClassLoader;
import org.evosuite.instrumentation.LinePool;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.instrumentation.MethodCallReplacementCache;
import org.evosuite.runtime.util.SystemInUtil;
import org.evosuite.seeding.CastClassManager;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.seeding.ObjectPoolManager;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.TestCluster;
import org.evosuite.setup.TestClusterGenerator;
import org.evosuite.testcarver.extraction.CarvingManager;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.utils.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGenerationContext {
    private static final Logger logger = LoggerFactory.getLogger(TestGenerationContext.class);
    private static final TestGenerationContext singleton = new TestGenerationContext();
    private InstrumentingClassLoader classLoader;
    private ClassLoader originalClassLoader = this.getClass().getClassLoader();

    private TestGenerationContext() {
        this.classLoader = new InstrumentingClassLoader();
    }

    public static TestGenerationContext getInstance() {
        return singleton;
    }

    public void goingToExecuteSUTCode() {
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    public void doneWithExecuteingSUTCode() {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
    }

    public InstrumentingClassLoader getClassLoaderForSUT() {
        return this.classLoader;
    }

    public static ClassLoader getClassLoader() {
        return TestGenerationContext.getInstance().classLoader;
    }

    public void resetContext() {
        logger.info("*** Resetting context");
        this.classLoader = new InstrumentingClassLoader();
        TestCaseExecutor.pullDown();
        ExecutionTracer.getExecutionTracer().clear();
        BranchPool.reset();
        LinePool.reset();
        MutationPool.clear();
        GraphPool.clearAll();
        DefUsePool.clear();
        CFGMethodAdapter.methods.clear();
        BytecodeInstructionPool.clearAll();
        TestCluster.reset();
        CastClassManager.getInstance().clear();
        TestFactory.getInstance().reset();
        MaxStatementsStoppingCondition.setNumExecutedStatements(0L);
        GlobalTimeStoppingCondition.forceReset();
        Properties.resetTargetClass();
        TestCaseExecutor.initExecutor();
        TestsArchive.instance.reset();
        ConstantPoolManager.getInstance().reset();
        ObjectPoolManager.getInstance().reset();
        CarvingManager.getInstance().clear();
        if (Properties.INSTRUMENT_CONTEXT || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.IBRANCH)) {
            try {
                TestClusterGenerator clusterGenerator = new TestClusterGenerator();
                clusterGenerator.generateCluster(Properties.TARGET_CLASS, DependencyAnalysis.getInheritanceTree(), DependencyAnalysis.getCallGraph());
            }
            catch (RuntimeException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (Properties.CHECK_CONTRACTS) {
            FailingTestSet.changeClassLoader(this.classLoader);
        }
        ContractChecker.setActive(true);
        SystemInUtil.resetSingleton();
        Runtime.resetSingleton();
        MethodCallReplacementCache.resetSingleton();
    }
}

