/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.lang.reflect.Array;
import org.evosuite.Properties;
import org.evosuite.assertion.ArrayTraceEntry;
import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;

public class ArrayTraceObserver
extends AssertionTraceObserver<ArrayTraceEntry> {
    @Override
    public synchronized void afterStatement(Statement statement, Scope scope, Throwable exception) {
        if (exception != null) {
            return;
        }
        this.visitReturnValue(statement, scope);
        this.visitDependencies(statement, scope);
    }

    private Object[] getArray(Object val) {
        int arrlength = Array.getLength(val);
        Object[] outputArray = new Object[arrlength];
        for (int i = 0; i < arrlength; ++i) {
            outputArray[i] = Array.get(val, i);
        }
        return outputArray;
    }

    @Override
    protected void visit(Statement statement, Scope scope, VariableReference var) {
        logger.debug("Checking array " + var);
        try {
            if (var == null) {
                return;
            }
            if (statement instanceof PrimitiveStatement) {
                return;
            }
            if (statement instanceof AssignmentStatement) {
                return;
            }
            if (statement instanceof ArrayStatement) {
                return;
            }
            Object object = var.getObject(scope);
            if (object == null) {
                return;
            }
            if (!object.getClass().isArray()) {
                return;
            }
            if (!object.getClass().getComponentType().isPrimitive()) {
                return;
            }
            if (var.getComponentClass() == null) {
                return;
            }
            if (Array.getLength(object) > Properties.MAX_ARRAY) {
                return;
            }
            logger.debug("Observed value " + object + " for statement " + statement.getCode());
            this.trace.addEntry(statement.getPosition(), var, new ArrayTraceEntry(var, this.getArray(object)));
        }
        catch (CodeUnderTestException e) {
            logger.debug("", (Throwable)e);
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r) {
    }
}

