/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Assertion
implements Serializable {
    private static final long serialVersionUID = 1617423211706717599L;
    protected VariableReference source;
    protected Object value;
    protected Statement statement;
    protected transient Set<Mutation> killedMutants = new LinkedHashSet<Mutation>();
    protected static final Logger logger = LoggerFactory.getLogger(Assertion.class);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Assertion other = (Assertion)obj;
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public void addKilledMutation(Mutation m) {
        this.killedMutants.add(m);
    }

    public Set<Mutation> getKilledMutations() {
        return this.killedMutants;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public VariableReference getSource() {
        return this.source;
    }

    public void setSource(VariableReference var) {
        this.source = var;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public abstract String getCode();

    public final Assertion clone() {
        throw new UnsupportedOperationException("Use Assertion.clone(TestCase)");
    }

    public Assertion clone(TestCase newTestCase) {
        return this.copy(newTestCase, 0);
    }

    public abstract Assertion copy(TestCase var1, int var2);

    public abstract boolean evaluate(Scope var1);

    public Set<VariableReference> getReferencedVariables() {
        HashSet<VariableReference> vars = new HashSet<VariableReference>();
        vars.add(this.source);
        return vars;
    }

    public boolean isValid() {
        return this.source != null && this.value != null;
    }

    public void changeClassLoader(ClassLoader loader) {
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.killedMutants = new LinkedHashSet<Mutation>();
    }
}

