/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import org.evosuite.assertion.OutputTrace;
import org.evosuite.assertion.OutputTraceEntry;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionObserver;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AssertionTraceObserver<T extends OutputTraceEntry>
extends ExecutionObserver {
    protected static final Logger logger = LoggerFactory.getLogger(AssertionTraceObserver.class);
    protected OutputTrace<T> trace = new OutputTrace();

    protected boolean checkThread() {
        return ExecutionTracer.isThreadNeqCurrentThread();
    }

    @Override
    public synchronized void output(int position, String output) {
    }

    protected void visitDependencies(Statement statement, Scope scope) {
        for (VariableReference var : currentTest.getDependencies(statement.getReturnValue())) {
            if (var.isVoid()) continue;
            try {
                this.visit(statement, scope, var);
            }
            catch (CodeUnderTestException e) {}
        }
    }

    protected void visitReturnValue(Statement statement, Scope scope) {
        if (statement.getReturnClass().equals(Void.TYPE)) {
            return;
        }
        if (statement.isAssignmentStatement()) {
            return;
        }
        try {
            this.visit(statement, scope, statement.getReturnValue());
        }
        catch (CodeUnderTestException codeUnderTestException) {
            // empty catch block
        }
    }

    protected abstract void visit(Statement var1, Scope var2, VariableReference var3) throws CodeUnderTestException;

    @Override
    public synchronized void afterStatement(Statement statement, Scope scope, Throwable exception) {
        if (exception != null) {
            return;
        }
        this.visitDependencies(statement, scope);
    }

    @Override
    public synchronized void beforeStatement(Statement statement, Scope scope) {
    }

    @Override
    public synchronized void clear() {
        this.trace.clear();
    }

    public synchronized OutputTrace<T> getTrace() {
        return this.trace.clone();
    }
}

