/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.assertion.Assertion;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.variable.VariableReference;

public class EqualsAssertion
extends Assertion {
    private static final long serialVersionUID = 1427358542327670617L;
    protected VariableReference dest;

    public VariableReference getDest() {
        return this.dest;
    }

    public void setDest(VariableReference dest) {
        this.dest = dest;
    }

    @Override
    public Assertion copy(TestCase newTestCase, int offset) {
        EqualsAssertion s = new EqualsAssertion();
        s.source = this.source.copy(newTestCase, offset);
        s.dest = this.dest.copy(newTestCase, offset);
        s.value = this.value;
        s.killedMutants.addAll(this.killedMutants);
        return s;
    }

    @Override
    public String getCode() {
        if (this.source.isPrimitive() && this.dest.isPrimitive()) {
            if (((Boolean)this.value).booleanValue()) {
                return "assertTrue(" + this.source.getName() + " == " + this.dest.getName() + ");";
            }
            return "assertFalse(" + this.source.getName() + " == " + this.dest.getName() + ");";
        }
        if (((Boolean)this.value).booleanValue()) {
            return "assertTrue(" + this.source.getName() + ".equals((java.lang.Object)" + this.dest.getName() + "));";
        }
        return "assertFalse(" + this.source.getName() + ".equals((java.lang.Object)" + this.dest.getName() + "));";
    }

    @Override
    public boolean evaluate(Scope scope) {
        try {
            if (((Boolean)this.value).booleanValue()) {
                if (this.source.getObject(scope) == null) {
                    return this.dest.getObject(scope) == null;
                }
                return this.source.getObject(scope).equals(this.dest.getObject(scope));
            }
            if (this.source.getObject(scope) == null) {
                return this.dest.getObject(scope) != null;
            }
            return !this.source.getObject(scope).equals(this.dest.getObject(scope));
        }
        catch (CodeUnderTestException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dest == null ? 0 : this.dest.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EqualsAssertion other = (EqualsAssertion)obj;
        return !(this.dest == null ? other.dest != null : !this.dest.equals(other.dest));
    }

    @Override
    public Set<VariableReference> getReferencedVariables() {
        HashSet<VariableReference> vars = new HashSet<VariableReference>();
        vars.add(this.source);
        vars.add(this.dest);
        return vars;
    }
}

