/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.NullAssertion;
import org.evosuite.assertion.OutputTraceEntry;
import org.evosuite.testcase.variable.VariableReference;

public class NullTraceEntry
implements OutputTraceEntry {
    private final boolean isNull;
    private final VariableReference var;

    public NullTraceEntry(VariableReference var, boolean result) {
        this.var = var;
        this.isNull = result;
    }

    @Override
    public boolean differs(OutputTraceEntry other) {
        if (other instanceof NullTraceEntry) {
            NullTraceEntry otherEntry = (NullTraceEntry)other;
            if (this.var.equals(otherEntry.var) && otherEntry.isNull != this.isNull) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Assertion> getAssertions(OutputTraceEntry other) {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        if (other instanceof NullTraceEntry) {
            NullTraceEntry otherEntry = (NullTraceEntry)other;
            if (this.var.equals(otherEntry.var) && otherEntry.isNull != this.isNull) {
                NullAssertion assertion = new NullAssertion();
                assertion.value = this.isNull;
                assertion.source = this.var;
                assertions.add(assertion);
                assert (assertion.isValid());
            }
        }
        return assertions;
    }

    @Override
    public Set<Assertion> getAssertions() {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        NullAssertion assertion = new NullAssertion();
        assertion.value = this.isNull;
        assertion.source = this.var;
        assertions.add(assertion);
        assert (assertion.value != null);
        assert (assertion.isValid());
        return assertions;
    }

    @Override
    public boolean isDetectedBy(Assertion assertion) {
        if (assertion instanceof NullAssertion) {
            NullAssertion ass = (NullAssertion)assertion;
            if (this.var.equals(ass.source)) {
                return (Boolean)ass.value != this.isNull;
            }
        }
        return false;
    }

    @Override
    public OutputTraceEntry cloneEntry() {
        return new NullTraceEntry(this.var, this.isNull);
    }
}

