/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.HashMap;
import java.util.Map;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.OutputTraceEntry;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.variable.VariableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputTrace<T extends OutputTraceEntry>
implements Cloneable {
    private static Logger logger = LoggerFactory.getLogger(OutputTrace.class);
    protected Map<Integer, Map<VariableReference, T>> trace = new HashMap<Integer, Map<VariableReference, T>>();

    public synchronized void addEntry(int position, VariableReference var, T entry) {
        if (!this.trace.containsKey(position)) {
            this.trace.put(position, new HashMap());
        }
        this.trace.get(position).put(var, entry);
    }

    public synchronized T getEntry(int position, VariableReference var) {
        if (!this.trace.containsKey(position)) {
            this.trace.put(position, new HashMap());
            return null;
        }
        if (!this.trace.get(position).containsKey(var)) {
            return null;
        }
        return (T)((OutputTraceEntry)this.trace.get(position).get(var));
    }

    public boolean containsEntry(int position, VariableReference var) {
        if (!this.trace.containsKey(position)) {
            this.trace.put(position, new HashMap());
            return false;
        }
        return this.trace.get(position).containsKey(var);
    }

    public boolean differs(OutputTrace<?> other) {
        for (Integer statement : this.trace.keySet()) {
            if (!other.trace.containsKey(statement)) continue;
            for (VariableReference var : this.trace.get(statement).keySet()) {
                if (!((OutputTraceEntry)this.trace.get(statement).get(var)).differs((OutputTraceEntry)other.trace.get(statement).get(var))) continue;
                return true;
            }
        }
        return false;
    }

    public int numDiffer(OutputTrace<?> other) {
        int num = 0;
        for (Integer statement : this.trace.keySet()) {
            if (!other.trace.containsKey(statement)) continue;
            for (VariableReference var : this.trace.get(statement).keySet()) {
                if (!((OutputTraceEntry)this.trace.get(statement).get(var)).differs((OutputTraceEntry)other.trace.get(statement).get(var))) continue;
                ++num;
            }
        }
        return num;
    }

    public int getAssertions(TestCase test, OutputTrace<?> other) {
        int num = 0;
        for (Integer statement : this.trace.keySet()) {
            if (!other.trace.containsKey(statement)) continue;
            for (VariableReference var : this.trace.get(statement).keySet()) {
                for (Assertion assertion : ((OutputTraceEntry)this.trace.get(statement).get(var)).getAssertions((OutputTraceEntry)other.trace.get(statement).get(var))) {
                    assert (assertion.isValid()) : "Invalid assertion: " + assertion.getCode() + ", " + assertion.value;
                    test.getStatement(statement).addAssertion(assertion);
                    ++num;
                }
            }
        }
        return num;
    }

    public int getAllAssertions(TestCase test) {
        int num = 0;
        for (Integer statement : this.trace.keySet()) {
            for (VariableReference var : this.trace.get(statement).keySet()) {
                for (Assertion assertion : ((OutputTraceEntry)this.trace.get(statement).get(var)).getAssertions()) {
                    assert (assertion.isValid()) : "Invalid assertion: " + assertion.getCode() + ", " + assertion.value;
                    test.getStatement(statement).addAssertion(assertion);
                    ++num;
                }
            }
        }
        return num;
    }

    public int getAllAssertions(TestCase test, int statement) {
        int num = 0;
        if (!this.trace.containsKey(statement)) {
            return 0;
        }
        for (VariableReference var : this.trace.get(statement).keySet()) {
            for (Assertion assertion : ((OutputTraceEntry)this.trace.get(statement).get(var)).getAssertions()) {
                assert (assertion.isValid()) : "Invalid assertion: " + assertion.getCode() + ", " + assertion.value;
                test.getStatement(statement).addAssertion(assertion);
                ++num;
            }
        }
        return num;
    }

    public boolean isDetectedBy(Assertion assertion) {
        assert (assertion.isValid());
        for (Integer statement : this.trace.keySet()) {
            for (VariableReference var : this.trace.get(statement).keySet()) {
                if (!((OutputTraceEntry)this.trace.get(statement).get(var)).isDetectedBy(assertion)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void clear() {
        this.trace.clear();
    }

    public synchronized OutputTrace<T> clone() {
        OutputTrace<T> copy = new OutputTrace<T>();
        for (Integer position : this.trace.keySet()) {
            copy.trace.put(position, new HashMap());
            for (VariableReference var : this.trace.get(position).keySet()) {
                copy.trace.get(position).put(var, ((OutputTraceEntry)this.trace.get(position).get(var)).cloneEntry());
            }
        }
        return copy;
    }
}

