/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import org.evosuite.Properties;
import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.assertion.CheapPurityAnalyzer;
import org.evosuite.assertion.SameTraceEntry;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.objectweb.asm.Type;

public class SameTraceObserver
extends AssertionTraceObserver<SameTraceEntry> {
    @Override
    protected void visit(Statement statement, Scope scope, VariableReference var) {
        if (statement.isAssignmentStatement()) {
            return;
        }
        try {
            Object object = var.getObject(scope);
            if (object == null) {
                return;
            }
            if (var.isPrimitive()) {
                return;
            }
            SameTraceEntry entry = new SameTraceEntry(var);
            for (VariableReference other : scope.getElements(var.getType())) {
                Object otherObject;
                if (other == var || other.isPrimitive() || (otherObject = other.getObject(scope)) == null) continue;
                if (Properties.PURE_EQUALS) {
                    String className = object.getClass().getCanonicalName();
                    String methodName = "equals";
                    String descriptor = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Object.class)});
                    CheapPurityAnalyzer cheapPurityAnalyzer = CheapPurityAnalyzer.getInstance();
                    if (!cheapPurityAnalyzer.isPure(className, methodName, descriptor)) continue;
                }
                try {
                    logger.debug("Comparison of " + var + " with " + other + " is: " + object.equals(otherObject) + " ==> " + (object == otherObject));
                    entry.addEntry(other, object == otherObject);
                }
                catch (Throwable t) {
                    logger.debug("Exception during equals: " + t);
                }
            }
            this.trace.addEntry(statement.getPosition(), var, entry);
        }
        catch (CodeUnderTestException e) {
            logger.debug("", (Throwable)e);
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r) {
    }
}

