/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.classpath;

import java.io.File;
import org.evosuite.Properties;

public class ClassPathHandler {
    private static final ClassPathHandler singleton = new ClassPathHandler();
    private String targetClassPath;
    private String evosuiteClassPath;

    private ClassPathHandler() {
    }

    public static ClassPathHandler getInstance() {
        return singleton;
    }

    public static void resetSingleton() {
        ClassPathHandler.getInstance().targetClassPath = null;
        ClassPathHandler.getInstance().evosuiteClassPath = null;
    }

    public String getEvoSuiteClassPath() {
        if (this.evosuiteClassPath == null) {
            this.evosuiteClassPath = System.getProperty("java.class.path");
        }
        return this.evosuiteClassPath;
    }

    public void setEvoSuiteClassPath(String[] elements) throws IllegalArgumentException {
        String cp;
        this.evosuiteClassPath = cp = this.getClassPath(elements);
    }

    public void changeTargetClassPath(String[] elements) throws IllegalArgumentException {
        String cp;
        Properties.CP = cp = this.getClassPath(elements);
        this.targetClassPath = cp;
    }

    private String getClassPath(String[] elements) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("No classpath elements");
        }
        String cp = "";
        boolean first = true;
        for (String entry : elements) {
            this.checkIfValidClasspathEntry(entry);
            if (first) {
                first = false;
            } else {
                cp = cp + File.pathSeparator;
            }
            cp = cp + entry;
        }
        return cp;
    }

    public String getTargetProjectClasspath() {
        if (this.targetClassPath == null) {
            this.targetClassPath = Properties.CP;
        }
        return this.targetClassPath;
    }

    public void addElementToTargetProjectClassPath(String element) throws IllegalArgumentException {
        this.checkIfValidClasspathEntry(element);
        this.getTargetProjectClasspath();
        if (this.targetClassPath == null || this.targetClassPath.isEmpty()) {
            this.targetClassPath = element;
        } else {
            if (this.targetClassPath.contains(element)) {
                return;
            }
            Properties.CP = this.targetClassPath = this.targetClassPath + File.pathSeparator + element;
        }
    }

    private void checkIfValidClasspathEntry(String element) throws IllegalArgumentException {
        if (element == null || element.isEmpty()) {
            throw new IllegalArgumentException("Empty input element");
        }
        File file = new File(element);
        if (!file.exists()) {
            throw new IllegalArgumentException("Classpath element does not exist on disk at: " + element);
        }
        if (!element.endsWith(".jar") && !file.isDirectory()) {
            throw new IllegalArgumentException("A classpath element should either be a jar or a folder");
        }
    }

    public String[] getClassPathElementsForTargetProject() {
        String cp = this.getTargetProjectClasspath();
        if (cp == null) {
            return new String[0];
        }
        return cp.split(File.pathSeparator);
    }

    public void changeTargetCPtoTheSameAsEvoSuite() {
        File outDir = new File("target" + File.separator + "classes");
        if (outDir.exists()) {
            this.changeTargetClassPath(new String[]{outDir.getAbsolutePath()});
            File testDir = new File("target" + File.separator + "test-classes");
            if (testDir.exists()) {
                this.addElementToTargetProjectClassPath(testDir.getAbsolutePath());
            }
        } else {
            this.changeTargetClassPath(this.getEvoSuiteClassPath().split(File.pathSeparator));
        }
    }
}

