/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.contracts;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.contracts.ContractChecker;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.contracts.SingleContractChecker;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Contract {
    protected static final Logger logger = LoggerFactory.getLogger(Contract.class);

    protected Collection<Object> getAllObjects(Scope scope) {
        return scope.getObjects(Properties.getTargetClass());
    }

    protected Collection<VariableReference> getAllVariables(Scope scope) {
        return scope.getElements(Properties.getTargetClass());
    }

    protected Collection<Pair<Object>> getAllObjectPairs(Scope scope) {
        HashSet<Pair<Object>> pairs = new HashSet<Pair<Object>>();
        for (Object o1 : scope.getObjects(Properties.getTargetClass())) {
            for (Object o2 : scope.getObjects(o1.getClass())) {
                pairs.add(new Pair<Object>(o1, o2));
            }
        }
        return pairs;
    }

    protected Collection<Pair<VariableReference>> getAllVariablePairs(Scope scope) {
        HashSet<Pair<VariableReference>> pairs = new HashSet<Pair<VariableReference>>();
        List<VariableReference> objects = scope.getElements(Properties.getTargetClass());
        for (int i = 0; i < objects.size(); ++i) {
            for (int j = i; j < objects.size(); ++j) {
                pairs.add(new Pair<VariableReference>(objects.get(i), objects.get(j)));
            }
        }
        return pairs;
    }

    protected boolean isTargetStatement(Statement statement) {
        if (statement instanceof MethodStatement) {
            MethodStatement ms = (MethodStatement)statement;
            if (Properties.getTargetClass().equals(ms.getMethod().getDeclaringClass())) {
                return true;
            }
        } else if (statement instanceof ConstructorStatement) {
            ConstructorStatement cs = (ConstructorStatement)statement;
            if (Properties.getTargetClass().equals(cs.getConstructor().getDeclaringClass())) {
                return true;
            }
        } else if (statement instanceof FieldStatement) {
            FieldStatement fs = (FieldStatement)statement;
            if (Properties.getTargetClass().equals(fs.getField().getDeclaringClass())) {
                return true;
            }
        }
        return false;
    }

    public boolean fails(TestCase test) {
        ContractChecker.setActive(false);
        TestCaseExecutor executor = TestCaseExecutor.getInstance();
        SingleContractChecker checker = new SingleContractChecker(this);
        executor.addObserver(checker);
        TestCaseExecutor.runTest(test);
        executor.removeObserver(checker);
        return !checker.isValid();
    }

    public abstract ContractViolation check(Statement var1, Scope var2, Throwable var3);

    public abstract void addAssertionAndComments(Statement var1, List<VariableReference> var2, Throwable var3);

    public void changeClassLoader(ClassLoader classLoader) {
    }

    protected static class Pair<T> {
        T object1;
        T object2;

        public Pair(T o1, T o2) {
            this.object1 = o1;
            this.object2 = o2;
        }
    }
}

