/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.contracts;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.contracts.Contract;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.testcase.ConstantInliner;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.FieldReference;
import org.evosuite.testcase.variable.VariableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractViolation {
    private static Logger logger = LoggerFactory.getLogger(ContractViolation.class);
    private final Contract contract;
    private TestCase test;
    private Statement statement;
    private final Throwable exception;
    private final List<VariableReference> variables = new ArrayList<VariableReference>();
    private boolean isMinimized = false;

    public ContractViolation(Contract contract, Statement statement, Throwable exception, VariableReference ... variables) {
        this.contract = contract;
        this.test = statement.getTestCase().clone();
        this.test.chop(statement.getPosition() + 1);
        ((DefaultTestCase)this.test).setFailing(true);
        this.statement = this.test.getStatement(statement.getPosition());
        for (VariableReference var : variables) {
            this.variables.add(var.clone(this.test));
        }
        this.exception = exception;
    }

    protected VariableReference getVariable(int num) {
        return this.variables.get(num).clone(this.test);
    }

    public TestCase getTestCase() {
        return this.test;
    }

    public Contract getContract() {
        return this.contract;
    }

    public int getPosition() {
        return this.statement.getPosition();
    }

    public void minimizeTest() {
        int i;
        if (this.isMinimized) {
            return;
        }
        TestFactory testFactory = TestFactory.getInstance();
        if (Properties.INLINE) {
            ConstantInliner inliner = new ConstantInliner();
            inliner.inline(this.test);
        }
        TestCase origTest = this.test.clone();
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (VariableReference var : this.variables) {
            positions.add(var.getStPosition());
        }
        int oldLength = this.test.size();
        boolean changed = true;
        while (changed) {
            changed = false;
            for (i = this.test.size() - 1; i >= 0; --i) {
                if (i >= this.test.size() || positions.contains(i)) continue;
                try {
                    testFactory.deleteStatement(this.test, i);
                    if (!this.contract.fails(this.test)) {
                        this.test = origTest.clone();
                        continue;
                    }
                    changed = true;
                    for (int j = 0; j < positions.size(); ++j) {
                        if ((Integer)positions.get(j) <= i) continue;
                        positions.set(j, (Integer)positions.get(j) - (oldLength - this.test.size()));
                    }
                    origTest = this.test.clone();
                    oldLength = this.test.size();
                    continue;
                }
                catch (ConstructionFailedException e) {
                    this.test = origTest.clone();
                }
            }
        }
        this.statement = this.test.getStatement(this.test.size() - 1);
        for (i = 0; i < this.variables.size(); ++i) {
            this.variables.set(i, this.test.getStatement((Integer)positions.get(i)).getReturnValue());
        }
        this.contract.addAssertionAndComments(this.statement, this.variables, this.exception);
        this.isMinimized = true;
    }

    public boolean same(ContractViolation other) {
        if (!this.contract.getClass().equals(other.contract.getClass())) {
            return false;
        }
        if (!this.statement.getClass().equals(other.statement.getClass())) {
            return false;
        }
        if (this.exception != null && other.exception != null && !this.exception.getClass().equals(other.exception.getClass())) {
            return false;
        }
        if (this.statement instanceof MethodStatement) {
            MethodStatement ms1 = (MethodStatement)this.statement;
            MethodStatement ms2 = (MethodStatement)other.statement;
            if (ms1.getMethod().getMethod().equals(ms2.getMethod().getMethod())) {
                return true;
            }
        } else if (this.statement instanceof ConstructorStatement) {
            ConstructorStatement ms1 = (ConstructorStatement)this.statement;
            ConstructorStatement ms2 = (ConstructorStatement)other.statement;
            if (ms1.getConstructor().getConstructor().equals(ms2.getConstructor().getConstructor())) {
                return true;
            }
        } else if (this.statement instanceof AssignmentStatement) {
            VariableReference var1 = this.statement.getReturnValue();
            VariableReference var2 = other.statement.getReturnValue();
            if (var1 instanceof FieldReference && var2 instanceof FieldReference && ((FieldReference)var1).getField().getField().equals(((FieldReference)var2).getField().getField())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Violated contract: " + this.contract + " in statement " + this.statement + " with exception " + this.exception;
    }

    public void changeClassLoader(ClassLoader classLoader) {
        ((DefaultTestCase)this.test).changeClassLoader(classLoader);
        this.contract.changeClassLoader(classLoader);
        this.statement = this.test.getStatement(this.statement.getPosition());
        for (int i = 0; i < this.variables.size(); ++i) {
            this.variables.set(i, this.variables.get(i).clone(this.test));
        }
    }
}

