/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.contracts;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.contracts.AssertionErrorContract;
import org.evosuite.contracts.Contract;
import org.evosuite.contracts.ContractChecker;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.contracts.EqualsContract;
import org.evosuite.contracts.EqualsHashcodeContract;
import org.evosuite.contracts.EqualsNullContract;
import org.evosuite.contracts.EqualsSymmetricContract;
import org.evosuite.contracts.HashCodeReturnsNormallyContract;
import org.evosuite.contracts.JCrasherExceptionContract;
import org.evosuite.contracts.NullPointerExceptionContract;
import org.evosuite.contracts.ToStringReturnsNormallyContract;
import org.evosuite.contracts.UndeclaredExceptionContract;
import org.evosuite.junit.writer.TestSuiteWriter;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailingTestSet {
    private static Logger logger = LoggerFactory.getLogger(FailingTestSet.class);
    private static final List<ContractViolation> violations = new ArrayList<ContractViolation>();
    private static int violationCount = 0;

    public static void addFailingTest(ContractViolation violation) {
        ++violationCount;
        if (!FailingTestSet.hasViolation(violation)) {
            violations.add(violation);
        }
    }

    public static int getNumberOfViolations() {
        return violationCount;
    }

    public static int getNumberOfViolations(Contract contract) {
        int num = 0;
        for (ContractViolation violation : violations) {
            if (!violation.getContract().equals(contract)) continue;
            ++num;
        }
        return num;
    }

    public static int getNumberOfViolations(Class<?> contractClass) {
        int num = 0;
        for (ContractViolation violation : violations) {
            if (!violation.getContract().getClass().equals(contractClass)) continue;
            ++num;
        }
        return num;
    }

    public static int getNumberOfUniqueViolations() {
        return violations.size();
    }

    public static List<TestCase> getFailingTests() {
        ArrayList<TestCase> tests = new ArrayList<TestCase>();
        ContractChecker.setActive(false);
        TestCaseExecutor.getInstance().newObservers();
        for (int i = 0; i < violations.size(); ++i) {
            logger.debug("Writing test {}/{}", (Object)i, (Object)violations.size());
            ContractViolation violation = violations.get(i);
            violation.minimizeTest();
            TestCase test = violation.getTestCase();
            tests.add(test);
        }
        return tests;
    }

    public static void writeJUnitTestSuite() {
        logger.info("Writing {} failing tests", (Object)violations.size());
        TestSuiteWriter writer = new TestSuiteWriter();
        FailingTestSet.writeJUnitTestSuite(writer);
        String name = Properties.TARGET_CLASS.substring(Properties.TARGET_CLASS.lastIndexOf(".") + 1);
        String testDir = Properties.TEST_DIR;
        writer.writeTestSuite("Failures" + name, testDir);
    }

    public static void writeJUnitTestSuite(TestSuiteWriter writer) {
        logger.info("Writing {} failing tests", (Object)violations.size());
        ContractChecker.setActive(false);
        TestCaseExecutor.getInstance().newObservers();
        for (int i = 0; i < violations.size(); ++i) {
            logger.debug("Writing test {}/{}", (Object)i, (Object)violations.size());
            ContractViolation violation = violations.get(i);
            violation.minimizeTest();
            TestCase test = violation.getTestCase();
            test.addContractViolation(violation);
            writer.insertTest(test, " Contract violation: " + violation.getContract().toString());
        }
    }

    public static boolean hasViolation(ContractViolation violation) {
        for (ContractViolation oldViolation : violations) {
            if (!oldViolation.same(violation)) continue;
            return true;
        }
        return false;
    }

    public static void changeClassLoader(ClassLoader classLoader) {
        for (ContractViolation violation : violations) {
            violation.changeClassLoader(classLoader);
        }
    }

    public static void clear() {
        violations.clear();
        violationCount = 0;
    }

    public static void sendStatistics() {
        if (!Properties.NEW_STATISTICS) {
            return;
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.AssertionContract, FailingTestSet.getNumberOfViolations(AssertionErrorContract.class));
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.EqualsContract, FailingTestSet.getNumberOfViolations(EqualsContract.class));
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.EqualsHashcodeContract, FailingTestSet.getNumberOfViolations(EqualsHashcodeContract.class));
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.EqualsNullContract, FailingTestSet.getNumberOfViolations(EqualsNullContract.class));
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.EqualsSymmetricContract, FailingTestSet.getNumberOfViolations(EqualsSymmetricContract.class));
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.HashCodeReturnsNormallyContract, FailingTestSet.getNumberOfViolations(HashCodeReturnsNormallyContract.class));
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.JCrasherExceptionContract, FailingTestSet.getNumberOfViolations(JCrasherExceptionContract.class));
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.NullPointerExceptionContract, FailingTestSet.getNumberOfViolations(NullPointerExceptionContract.class));
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.ToStringReturnsNormallyContract, FailingTestSet.getNumberOfViolations(ToStringReturnsNormallyContract.class));
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.UndeclaredExceptionContract, FailingTestSet.getNumberOfViolations(UndeclaredExceptionContract.class));
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Contract_Violations, FailingTestSet.getNumberOfViolations());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Unique_Violations, FailingTestSet.getNumberOfUniqueViolations());
    }
}

