/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.contracts;

import java.util.Arrays;
import java.util.List;
import org.evosuite.contracts.Contract;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;

public class JCrasherExceptionContract
extends Contract {
    private static final Class<?>[] uncheckedBugExceptions = new Class[]{ArrayIndexOutOfBoundsException.class, NegativeArraySizeException.class, ArrayStoreException.class, ClassCastException.class, ArithmeticException.class};
    private static final List<Class<?>> uncheckedExceptions = Arrays.asList(uncheckedBugExceptions);

    @Override
    public ContractViolation check(Statement statement, Scope scope, Throwable exception) {
        if (!this.isTargetStatement(statement)) {
            return null;
        }
        if (exception != null) {
            if (exception instanceof CodeUnderTestException) {
                return null;
            }
            if (exception instanceof RuntimeException) {
                if (uncheckedExceptions.contains(exception.getClass())) {
                    return new ContractViolation(this, statement, exception, new VariableReference[0]);
                }
                StackTraceElement element = exception.getStackTrace()[0];
                String methodName = "";
                if (statement instanceof ConstructorStatement) {
                    methodName = "<init>";
                } else if (statement instanceof MethodStatement) {
                    methodName = ((MethodStatement)statement).getMethod().getName();
                } else {
                    return null;
                }
                if (element.getMethodName().equals(methodName)) {
                    return null;
                }
                if (element.getClassName().startsWith("org.evosuite.testcase")) {
                    return null;
                }
                return new ContractViolation(this, statement, exception, new VariableReference[0]);
            }
        }
        return null;
    }

    @Override
    public void addAssertionAndComments(Statement statement, List<VariableReference> variables, Throwable exception) {
        statement.addComment("Throws undeclared exception (JCrasher heuristic): " + exception.getMessage());
    }

    public String toString() {
        return "Undeclared exception (JCrasher style)";
    }
}

