/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.contracts;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.evosuite.contracts.Contract;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.GenericConstructor;
import org.evosuite.utils.GenericMethod;

public class JUnitTheoryContract
extends Contract {
    private GenericMethod theoryMethod;
    private Object theoryReceiver;

    public JUnitTheoryContract(GenericMethod theoryMethod) throws InstantiationException, IllegalAccessException {
        this.theoryMethod = theoryMethod;
        this.theoryReceiver = theoryMethod.getDeclaringClass().newInstance();
        if (theoryMethod.getParameterTypes().length != 1) {
            throw new IllegalArgumentException("Number of arguments needs to be one");
        }
    }

    @Override
    public ContractViolation check(Statement statement, Scope scope, Throwable exception) {
        for (VariableReference var : this.getAllVariables(scope)) {
            logger.debug("Current variable: " + var);
            Object object = scope.getObject(var);
            if (object == null) {
                logger.debug("Current object is null");
                continue;
            }
            try {
                this.theoryMethod.getMethod().invoke(this.theoryReceiver, object);
            }
            catch (IllegalAccessException e) {
                logger.warn("Error while checking contract: " + e);
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                logger.warn("Error while checking contract: " + e);
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                return new ContractViolation(this, statement, e.getCause(), var);
            }
            catch (Throwable t) {
                logger.warn("New contract violation found: " + t);
                return new ContractViolation(this, statement, t, var);
            }
        }
        return null;
    }

    @Override
    public void addAssertionAndComments(Statement statement, List<VariableReference> variables, Throwable exception) {
        TestCase test = statement.getTestCase();
        int position = statement.getPosition();
        VariableReference a = variables.get(0);
        int pos = a.getStPosition();
        try {
            Constructor<?> defaultConstructor = this.theoryReceiver.getClass().getConstructor(new Class[0]);
            GenericConstructor constructor = new GenericConstructor(defaultConstructor, this.theoryReceiver.getClass());
            ConstructorStatement st1 = new ConstructorStatement(test, constructor, new ArrayList<VariableReference>());
            VariableReference receiver = test.addStatement(st1, position + 1);
            MethodStatement st2 = new MethodStatement(test, this.theoryMethod, receiver, Arrays.asList(test.getStatement(pos).getReturnValue()));
            test.addStatement(st2, position + 2);
            st2.addComment("Violates theory: " + this.theoryMethod.getName());
        }
        catch (NoSuchMethodException e) {
            logger.warn("Error while creating contract violation: " + e);
            e.printStackTrace();
        }
        catch (SecurityException e) {
            logger.warn("Error while creating contract violation: " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void changeClassLoader(ClassLoader classLoader) {
        this.theoryMethod.changeClassLoader(classLoader);
        try {
            this.theoryReceiver = this.theoryMethod.getDeclaringClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "JUnit Theory contract: " + this.theoryMethod.getName();
    }
}

