/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.contracts;

import java.util.List;
import java.util.Set;
import org.evosuite.contracts.Contract;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;

public class UndeclaredExceptionContract
extends Contract {
    @Override
    public ContractViolation check(Statement statement, Scope scope, Throwable exception) {
        Set<Class<?>> exceptions;
        if (!this.isTargetStatement(statement)) {
            return null;
        }
        if (exception != null && !(exceptions = statement.getDeclaredExceptions()).contains(exception.getClass())) {
            String methodName;
            if (exception instanceof CodeUnderTestException) {
                return null;
            }
            StackTraceElement element = exception.getStackTrace()[0];
            if (element.getClassName().startsWith("org.evosuite.testcase")) {
                return null;
            }
            if (exception instanceof AssertionError) {
                return null;
            }
            if (statement instanceof MethodStatement && ((methodName = ((MethodStatement)statement).getMethod().getName()).equals("toString") || methodName.equals("hashCode"))) {
                return null;
            }
            return new ContractViolation(this, statement, exception, new VariableReference[0]);
        }
        return null;
    }

    @Override
    public void addAssertionAndComments(Statement statement, List<VariableReference> variables, Throwable exception) {
        statement.addComment("Throws undeclared exception: " + exception.getMessage());
    }

    public String toString() {
        return "Undeclared exception check";
    }
}

