/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.TestSuiteGenerator;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cfg.CFGMethodAdapter;
import org.evosuite.graphs.cfg.RawControlFlowGraph;
import org.evosuite.instrumentation.LinePool;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.TestCluster;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassStatisticsPrinter {
    private static final Logger logger = LoggerFactory.getLogger(ClassStatisticsPrinter.class);

    private static void reinstrument(Properties.Criterion criterion) {
        Properties.CRITERION = new Properties.Criterion[1];
        Properties.CRITERION[0] = criterion;
        logger.info("Re-instrumenting for criterion: " + (Object)((Object)criterion));
        TestGenerationContext.getInstance().resetContext();
        Properties.getTargetClass(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printClassStatistics() {
        Properties.Criterion[] oldCriterion;
        Sandbox.goingToExecuteSUTCode();
        TestGenerationContext.getInstance().goingToExecuteSUTCode();
        Sandbox.goingToExecuteUnsafeCodeOnSameThread();
        try {
            DependencyAnalysis.analyze(Properties.TARGET_CLASS, Arrays.asList(ClassPathHandler.getInstance().getClassPathElementsForTargetProject()));
            Class<?> targetClass = Properties.getTargetClass(false);
            if (targetClass == null) {
                LoggingUtils.getEvoLogger().info("* Error while initializing target class, not continuing");
                return;
            }
            LoggingUtils.getEvoLogger().info("* Finished analyzing classpath");
            int publicMethods = 0;
            int nonpublicMethods = 0;
            int staticMethods = 0;
            int staticFields = 0;
            for (Method method : targetClass.getDeclaredMethods()) {
                if (method.getName().equals("__STATIC_RESET")) continue;
                if (Modifier.isPublic(method.getModifiers())) {
                    ++publicMethods;
                } else {
                    ++nonpublicMethods;
                }
                if (!Modifier.isStatic(method.getModifiers())) continue;
                LoggingUtils.getEvoLogger().info("Static: " + method);
                ++staticMethods;
            }
            for (Executable executable : targetClass.getDeclaredConstructors()) {
                if (Modifier.isPublic(((Constructor)executable).getModifiers())) {
                    ++publicMethods;
                    continue;
                }
                ++nonpublicMethods;
            }
            for (AccessibleObject accessibleObject : targetClass.getDeclaredFields()) {
                if (!Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
                ++staticFields;
            }
            LoggingUtils.getEvoLogger().info("* Abstract: " + Modifier.isAbstract(targetClass.getModifiers()));
            LoggingUtils.getEvoLogger().info("* Public methods/constructors: " + publicMethods);
            LoggingUtils.getEvoLogger().info("* Non-Public methods/constructors: " + nonpublicMethods);
            LoggingUtils.getEvoLogger().info("* Static methods: " + staticMethods);
            LoggingUtils.getEvoLogger().info("* Inner classes: " + targetClass.getDeclaredClasses().length);
            LoggingUtils.getEvoLogger().info("* Total fields: " + targetClass.getDeclaredFields().length);
            LoggingUtils.getEvoLogger().info("* Static fields: " + staticFields);
            LoggingUtils.getEvoLogger().info("* Type parameters: " + targetClass.getTypeParameters().length);
        }
        catch (Throwable e) {
            LoggingUtils.getEvoLogger().error("* Error while initializing target class: " + (e.getMessage() != null ? e.getMessage() : e.toString()));
            return;
        }
        finally {
            Sandbox.doneWithExecutingUnsafeCodeOnSameThread();
            Sandbox.doneWithExecutingSUTCode();
            TestGenerationContext.getInstance().doneWithExecuteingSUTCode();
        }
        LoggingUtils.getEvoLogger().info("* Subclasses: " + (TestCluster.getInheritanceTree().getSubclasses(Properties.TARGET_CLASS).size() - 1));
        LoggingUtils.getEvoLogger().info("* Superclasses/interfaces: " + (TestCluster.getInheritanceTree().getSuperclasses(Properties.TARGET_CLASS).size() - 1));
        LoggingUtils.getEvoLogger().info("* Lines of code: " + LinePool.getNumLines());
        LoggingUtils.getEvoLogger().info("* Methods without branches: " + BranchPool.getNumBranchlessMethods());
        LoggingUtils.getEvoLogger().info("* Total branch predicates: " + BranchPool.getBranchCounter());
        double complexity = 0.0;
        int maxComplexity = 0;
        for (Map.Entry<String, RawControlFlowGraph> entry : GraphPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getRawCFGs(Properties.TARGET_CLASS).entrySet()) {
            int c = entry.getValue().getCyclomaticComplexity();
            if (c > maxComplexity) {
                maxComplexity = c;
            }
            complexity += (double)c;
        }
        LoggingUtils.getEvoLogger().info("* Average cyclomatic complexity: " + complexity / (double)CFGMethodAdapter.getNumMethods());
        LoggingUtils.getEvoLogger().info("* Maximum cyclomatic complexity: " + maxComplexity);
        for (Properties.Criterion criterion : oldCriterion = Arrays.copyOf(Properties.CRITERION, Properties.CRITERION.length)) {
            ClassStatisticsPrinter.reinstrument(criterion);
            List<TestFitnessFactory<? extends TestFitnessFunction>> list = TestSuiteGenerator.getFitnessFactory();
            int numGoals = 0;
            for (TestFitnessFactory<? extends TestFitnessFunction> factory : list) {
                if (Properties.PRINT_GOALS) {
                    for (TestFitnessFunction testFitnessFunction : factory.getCoverageGoals()) {
                        LoggingUtils.getEvoLogger().info("" + testFitnessFunction.toString());
                    }
                }
                numGoals += factory.getCoverageGoals().size();
            }
            LoggingUtils.getEvoLogger().info("* Criterion " + (Object)((Object)criterion) + ": " + numGoals);
        }
    }
}

