/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.FitnessFunctions;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverageAnalysis {
    private static final Logger logger = LoggerFactory.getLogger(CoverageAnalysis.class);

    private static boolean isMutationCriterion(Set<Properties.Criterion> criteria) {
        for (Properties.Criterion pc : criteria) {
            if (!CoverageAnalysis.isMutationCriterion(pc)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMutationCriterion(Properties.Criterion criterion) {
        switch (criterion) {
            case MUTATION: 
            case WEAKMUTATION: 
            case STRONGMUTATION: 
            case ONLYMUTATION: 
            case ARCHIVEMUTATION: {
                return true;
            }
        }
        return false;
    }

    private static void reinstrument(TestSuiteChromosome testSuite, Properties.Criterion criterion) {
        Properties.Criterion[] oldCriterion = Arrays.copyOf(Properties.CRITERION, Properties.CRITERION.length);
        HashSet<Properties.Criterion> oldCriteria = new HashSet<Properties.Criterion>();
        for (Properties.Criterion c : Properties.CRITERION) {
            oldCriteria.add(c);
            if (c.equals((Object)Properties.Criterion.ARCHIVEBRANCH)) {
                oldCriteria.add(Properties.Criterion.BRANCH);
            }
            if (!c.equals((Object)Properties.Criterion.ARCHIVEIBRANCH)) continue;
            oldCriteria.add(Properties.Criterion.IBRANCH);
        }
        if (Properties.SECONDARY_OBJECTIVE.toLowerCase().contains("ibranch") || Properties.SECONDARY_OBJECTIVE.toLowerCase().contains("archiveibranch")) {
            oldCriteria.add(Properties.Criterion.IBRANCH);
            ExecutionTracer.enableContext();
        }
        if (!ExecutionTracer.isTraceCallsEnabled()) {
            ExecutionTracer.enableTraceCalls();
            testSuite.setChanged(true);
            for (TestChromosome test : testSuite.getTestChromosomes()) {
                test.setChanged(true);
                test.clearCachedResults();
                test.clearCachedMutationResults();
            }
        }
        if (oldCriteria.contains((Object)criterion)) {
            return;
        }
        testSuite.setChanged(true);
        for (TestChromosome test : testSuite.getTestChromosomes()) {
            test.setChanged(true);
            test.clearCachedResults();
            test.clearCachedMutationResults();
        }
        if (CoverageAnalysis.isMutationCriterion(criterion) && CoverageAnalysis.isMutationCriterion(oldCriteria)) {
            return;
        }
        Properties.CRITERION = new Properties.Criterion[1];
        Properties.CRITERION[0] = criterion;
        logger.info("Re-instrumenting for criterion: " + (Object)((Object)criterion));
        TestGenerationContext.getInstance().resetContext();
        Properties.getTargetClass();
        logger.info("Changing classloader of test suite for criterion: " + (Object)((Object)criterion));
        for (TestChromosome test : testSuite.getTestChromosomes()) {
            DefaultTestCase dtest = (DefaultTestCase)test.getTestCase();
            dtest.changeClassLoader(TestGenerationContext.getInstance().getClassLoaderForSUT());
        }
        Properties.CRITERION = oldCriterion;
    }

    public static void analyzeCriteria(TestSuiteChromosome testSuite, String criteria) {
        if (!Properties.COVERAGE) {
            for (Properties.Criterion c : Properties.CRITERION) {
                logger.debug("Measuring coverage of target criterion " + (Object)((Object)c));
                CoverageAnalysis.analyzeCoverage(testSuite, c.name());
            }
        }
        for (String extraCriterion : Arrays.asList(criteria.toUpperCase().split(","))) {
            if (ArrayUtil.contains((Object[])Properties.CRITERION, extraCriterion)) continue;
            logger.debug("Measuring additional coverage of target criterion " + extraCriterion);
            CoverageAnalysis.analyzeCoverage(testSuite, extraCriterion);
        }
    }

    public static void analyzeCoverage(TestSuiteChromosome testSuite, String criterion) {
        try {
            logger.info("Measuring coverage of criterion: " + criterion);
            Properties.Criterion crit = Properties.Criterion.valueOf(criterion.toUpperCase());
            CoverageAnalysis.analyzeCoverage(testSuite, crit);
        }
        catch (IllegalArgumentException e) {
            LoggingUtils.getEvoLogger().info("* Unknown coverage criterion: " + criterion);
        }
    }

    private static RuntimeVariable getCoverageVariable(Properties.Criterion criterion) {
        switch (criterion) {
            case ALLDEFS: {
                return RuntimeVariable.AllDefCoverage;
            }
            case BRANCH: {
                return RuntimeVariable.BranchCoverage;
            }
            case ARCHIVEBRANCH: {
                return RuntimeVariable.BranchCoverage;
            }
            case CBRANCH: {
                return RuntimeVariable.CBranchCoverage;
            }
            case EXCEPTION: {
                return RuntimeVariable.ExceptionCoverage;
            }
            case DEFUSE: {
                return RuntimeVariable.DefUseCoverage;
            }
            case STATEMENT: {
                return RuntimeVariable.StatementCoverage;
            }
            case RHO: {
                return RuntimeVariable.RhoCoverage;
            }
            case AMBIGUITY: {
                return RuntimeVariable.AmbiguityCoverage;
            }
            case MUTATION: 
            case STRONGMUTATION: {
                return RuntimeVariable.MutationScore;
            }
            case ONLYMUTATION: 
            case ARCHIVEMUTATION: {
                return RuntimeVariable.OnlyMutationScore;
            }
            case WEAKMUTATION: {
                return RuntimeVariable.WeakMutationScore;
            }
            case ONLYBRANCH: {
                return RuntimeVariable.OnlyBranchCoverage;
            }
            case METHODTRACE: {
                return RuntimeVariable.MethodTraceCoverage;
            }
            case METHOD: {
                return RuntimeVariable.MethodCoverage;
            }
            case METHODNOEXCEPTION: {
                return RuntimeVariable.MethodNoExceptionCoverage;
            }
            case ARCHIVELINE: 
            case LINE: {
                return RuntimeVariable.LineCoverage;
            }
            case OUTPUT: {
                return RuntimeVariable.OutputCoverage;
            }
            case IBRANCH: {
                return RuntimeVariable.IBranchCoverage;
            }
            case ARCHIVEIBRANCH: {
                return RuntimeVariable.IBranchCoverage;
            }
        }
        throw new RuntimeException("Criterion not supported: " + (Object)((Object)criterion));
    }

    public static void analyzeCoverage(TestSuiteChromosome testSuite, Properties.Criterion criterion) {
        CoverageAnalysis.reinstrument(testSuite, criterion);
        TestFitnessFactory<? extends TestFitnessFunction> factory = FitnessFunctions.getFitnessFactory(criterion);
        for (TestChromosome test : testSuite.getTestChromosomes()) {
            test.getTestCase().clearCoveredGoals();
        }
        int covered = 0;
        List<? extends TestFitnessFunction> goals = factory.getCoverageGoals();
        for (TestFitnessFunction testFitnessFunction : goals) {
            if (testFitnessFunction.isCoveredBy(testSuite)) {
                logger.debug("Goal {} is covered", (Object)testFitnessFunction);
                ++covered;
                continue;
            }
            logger.debug("Goal {} is not covered", (Object)testFitnessFunction);
        }
        if (goals.isEmpty()) {
            if (criterion == Properties.Criterion.MUTATION || criterion == Properties.Criterion.STRONGMUTATION) {
                ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.MutationScore, 1.0);
            }
            LoggingUtils.getEvoLogger().info("* Coverage of criterion " + (Object)((Object)criterion) + ": 100% (no goals)");
            ClientServices.getInstance().getClientNode().trackOutputVariable(CoverageAnalysis.getCoverageVariable(criterion), 1.0);
        } else {
            ClientServices.getInstance().getClientNode().trackOutputVariable(CoverageAnalysis.getCoverageVariable(criterion), (double)covered / (double)goals.size());
            if (criterion == Properties.Criterion.MUTATION || criterion == Properties.Criterion.STRONGMUTATION) {
                ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.MutationScore, (double)covered / (double)goals.size());
            }
            LoggingUtils.getEvoLogger().info("* Coverage of criterion " + (Object)((Object)criterion) + ": " + NumberFormat.getPercentInstance().format((double)covered / (double)goals.size()));
            LoggingUtils.getEvoLogger().info("* Number of covered goals: " + covered);
        }
    }
}

