/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage;

import org.evosuite.Properties;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.coverage.ambiguity.AmbiguityCoverageFactory;
import org.evosuite.coverage.ambiguity.AmbiguityCoverageSuiteFitness;
import org.evosuite.coverage.branch.BranchCoverageFactory;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.coverage.branch.OnlyBranchCoverageFactory;
import org.evosuite.coverage.branch.OnlyBranchCoverageSuiteFitness;
import org.evosuite.coverage.branch.archive.ArchiveBranchCoverageSuiteFitness;
import org.evosuite.coverage.cbranch.CBranchFitnessFactory;
import org.evosuite.coverage.cbranch.CBranchSuiteFitness;
import org.evosuite.coverage.dataflow.AllDefsCoverageFactory;
import org.evosuite.coverage.dataflow.AllDefsCoverageSuiteFitness;
import org.evosuite.coverage.dataflow.DefUseCoverageFactory;
import org.evosuite.coverage.dataflow.DefUseCoverageSuiteFitness;
import org.evosuite.coverage.exception.ExceptionCoverageFactory;
import org.evosuite.coverage.exception.ExceptionCoverageSuiteFitness;
import org.evosuite.coverage.ibranch.IBranchFitnessFactory;
import org.evosuite.coverage.ibranch.IBranchSuiteFitness;
import org.evosuite.coverage.ibranch.archive.ArchiveIBranchSuiteFitness;
import org.evosuite.coverage.line.LineCoverageFactory;
import org.evosuite.coverage.line.LineCoverageSuiteFitness;
import org.evosuite.coverage.line.archive.ArchiveOnlyLineCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodCoverageFactory;
import org.evosuite.coverage.method.MethodCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodNoExceptionCoverageFactory;
import org.evosuite.coverage.method.MethodNoExceptionCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodTraceCoverageFactory;
import org.evosuite.coverage.method.MethodTraceCoverageSuiteFitness;
import org.evosuite.coverage.mutation.ArchiveOnlyMutationSuiteFitness;
import org.evosuite.coverage.mutation.MutationFactory;
import org.evosuite.coverage.mutation.OnlyMutationFactory;
import org.evosuite.coverage.mutation.OnlyMutationSuiteFitness;
import org.evosuite.coverage.mutation.StrongMutationSuiteFitness;
import org.evosuite.coverage.mutation.WeakMutationSuiteFitness;
import org.evosuite.coverage.output.OutputCoverageFactory;
import org.evosuite.coverage.output.OutputCoverageSuiteFitness;
import org.evosuite.coverage.readability.ReadabilitySuiteFitness;
import org.evosuite.coverage.rho.RhoCoverageFactory;
import org.evosuite.coverage.rho.RhoCoverageSuiteFitness;
import org.evosuite.coverage.statement.StatementCoverageFactory;
import org.evosuite.coverage.statement.StatementCoverageSuiteFitness;
import org.evosuite.regression.RegressionSuiteFitness;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FitnessFunctions {
    private static Logger logger = LoggerFactory.getLogger(FitnessFunctions.class);

    public static TestSuiteFitnessFunction getFitnessFunction(Properties.Criterion criterion) {
        switch (criterion) {
            case STRONGMUTATION: {
                return new StrongMutationSuiteFitness();
            }
            case WEAKMUTATION: {
                return new WeakMutationSuiteFitness();
            }
            case MUTATION: {
                return new StrongMutationSuiteFitness();
            }
            case ONLYMUTATION: {
                return new OnlyMutationSuiteFitness();
            }
            case ARCHIVEMUTATION: {
                return new ArchiveOnlyMutationSuiteFitness();
            }
            case DEFUSE: {
                return new DefUseCoverageSuiteFitness();
            }
            case BRANCH: {
                return new BranchCoverageSuiteFitness();
            }
            case ARCHIVEBRANCH: {
                return new ArchiveBranchCoverageSuiteFitness();
            }
            case CBRANCH: {
                return new CBranchSuiteFitness();
            }
            case IBRANCH: {
                return new IBranchSuiteFitness();
            }
            case ARCHIVEIBRANCH: {
                return new ArchiveIBranchSuiteFitness();
            }
            case STATEMENT: {
                return new StatementCoverageSuiteFitness();
            }
            case RHO: {
                return new RhoCoverageSuiteFitness();
            }
            case AMBIGUITY: {
                return new AmbiguityCoverageSuiteFitness();
            }
            case ALLDEFS: {
                return new AllDefsCoverageSuiteFitness();
            }
            case EXCEPTION: {
                return new ExceptionCoverageSuiteFitness();
            }
            case REGRESSION: {
                return new RegressionSuiteFitness();
            }
            case READABILITY: {
                return new ReadabilitySuiteFitness();
            }
            case ONLYBRANCH: {
                return new OnlyBranchCoverageSuiteFitness();
            }
            case METHODTRACE: {
                return new MethodTraceCoverageSuiteFitness();
            }
            case METHOD: {
                return new MethodCoverageSuiteFitness();
            }
            case METHODNOEXCEPTION: {
                return new MethodNoExceptionCoverageSuiteFitness();
            }
            case ARCHIVELINE: {
                return new ArchiveOnlyLineCoverageSuiteFitness();
            }
            case LINE: {
                return new LineCoverageSuiteFitness();
            }
            case OUTPUT: {
                return new OutputCoverageSuiteFitness();
            }
        }
        logger.warn("No TestSuiteFitnessFunction defined for " + Properties.CRITERION + " using default one (BranchCoverageSuiteFitness)");
        return new BranchCoverageSuiteFitness();
    }

    public static TestFitnessFactory<? extends TestFitnessFunction> getFitnessFactory(Properties.Criterion crit) {
        switch (crit) {
            case STRONGMUTATION: 
            case MUTATION: {
                return new MutationFactory();
            }
            case WEAKMUTATION: {
                return new MutationFactory(false);
            }
            case ONLYMUTATION: {
                return new OnlyMutationFactory();
            }
            case ARCHIVEMUTATION: {
                return new OnlyMutationFactory();
            }
            case DEFUSE: {
                return new DefUseCoverageFactory();
            }
            case BRANCH: {
                return new BranchCoverageFactory();
            }
            case ARCHIVEBRANCH: {
                return new BranchCoverageFactory();
            }
            case CBRANCH: {
                return new CBranchFitnessFactory();
            }
            case IBRANCH: {
                return new IBranchFitnessFactory();
            }
            case ARCHIVEIBRANCH: {
                return new IBranchFitnessFactory();
            }
            case STATEMENT: {
                return new StatementCoverageFactory();
            }
            case RHO: {
                return new RhoCoverageFactory();
            }
            case AMBIGUITY: {
                return new AmbiguityCoverageFactory();
            }
            case ALLDEFS: {
                return new AllDefsCoverageFactory();
            }
            case EXCEPTION: {
                return new ExceptionCoverageFactory();
            }
            case ONLYBRANCH: {
                return new OnlyBranchCoverageFactory();
            }
            case METHODTRACE: {
                return new MethodTraceCoverageFactory();
            }
            case METHOD: {
                return new MethodCoverageFactory();
            }
            case METHODNOEXCEPTION: {
                return new MethodNoExceptionCoverageFactory();
            }
            case LINE: {
                return new LineCoverageFactory();
            }
            case ARCHIVELINE: {
                return new LineCoverageFactory();
            }
            case OUTPUT: {
                return new OutputCoverageFactory();
            }
        }
        logger.warn("No TestFitnessFactory defined for " + (Object)((Object)crit) + " using default one (BranchCoverageFactory)");
        return new BranchCoverageFactory();
    }
}

