/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FitnessLogger
implements SearchListener {
    private static Logger logger = LoggerFactory.getLogger(FitnessLogger.class);
    private final List<Integer> evaluations_history = new ArrayList<Integer>();
    private final List<Long> statements_history = new ArrayList<Long>();
    private final List<Double> fitness_history = new ArrayList<Double>();
    private final List<Integer> size_history = new ArrayList<Integer>();
    private String name = null;
    private int evaluations = 0;

    @Override
    public void searchStarted(GeneticAlgorithm<?> algorithm) {
        this.evaluations = 0;
        this.evaluations_history.clear();
        this.statements_history.clear();
        this.fitness_history.clear();
        this.size_history.clear();
        File dir = new File(Properties.REPORT_DIR + "/goals/");
        dir.mkdirs();
        this.name = Properties.REPORT_DIR + "/goals/" + algorithm.getFitnessFunction().toString().replace(" ", "_").replace(":", "-").replace("(", "").replace(")", "");
    }

    @Override
    public void iteration(GeneticAlgorithm<?> algorithm) {
        if (algorithm.getPopulation().isEmpty()) {
            return;
        }
        this.evaluations_history.add(this.evaluations);
        this.statements_history.add(MaxStatementsStoppingCondition.getNumExecutedStatements());
        this.fitness_history.add(algorithm.getBestIndividual().getFitness());
        this.size_history.add(algorithm.getBestIndividual().size());
    }

    @Override
    public void searchFinished(GeneticAlgorithm<?> algorithm) {
        if (this.name == null) {
            return;
        }
        File f = new File(this.name);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(f, true));
            out.write("Iteration,Evaluations,Statements,Fitness,Size\n");
            for (int i = 0; i < this.fitness_history.size(); ++i) {
                out.write(i + ",");
                out.write(this.evaluations_history.get(i) + ",");
                out.write(this.statements_history.get(i) + ",");
                out.write(this.fitness_history.get(i) + ",");
                out.write(this.size_history.get(i) + "\n");
            }
            out.close();
        }
        catch (IOException e) {
            logger.error("Could not open csv file: " + e);
        }
    }

    @Override
    public void fitnessEvaluation(Chromosome individual) {
        ++this.evaluations;
    }

    @Override
    public void modification(Chromosome individual) {
    }
}

